项目说明：

    服务系统标准版，主要模块：客户回访，客诉登记，培训考试，品控。

开发说明：
目录结构
www  WEB部署目录（或者子目录）
├─application           应用目录
│  ├─common             公共模块目录
│  ├─module_name        模块目录
│  │  ├─api             API接口目录，里面放的所有文件均按控制器的写法写，但不用继承Base方法.
│  │  │                 所有方法都会接收两个参数：params和appId
│  │  │                 第一个参数是接口传过来的所有参数，第二个参数为调用的应用ID。接口层面的验证已经做完，只需做业务方面的验证即右。（可选）
│  │  ├─config.php      模块配置文件（可选）
│  │  ├─common.php      模块函数文件（可选）
│  │  ├─controller      控制器目录,为控制器的入口，具体业务实现，要放在lib内，调用时，使用controller('lib下的类名','lib')->具体方法();
│  │  │ ├─Api.php       API请求入口文件，全部API的请求，都将进入此文件，再调用api目录下的对应方法处理（可选）
│  │  │ ├─ApiDocs.php   API文档管理方法，默认打开此方法是API的应用列表，可以维护所有API接口（可选）
│  │  │ ├─Base.php      基础类，所有非API的控制器，都需要继承此类，针对于API接口，在API.php内已经继承，不用单独继承
│  │  │ ├─Index.php     模块首页
│  │  │ └...            其他控制器自行添加
│  │  ├─model           模型目录
│  │  ├─view            视图目录
│  │  └─lib             模块业务和处理目录，所有业务实现的控制放在此处
   │  
│  │
│  ├─command.php        命令行工具配置文件
│  ├─common.php         公共函数文件
│  ├─config.php         公共配置文件
│  ├─route.php          路由配置文件
│  ├─tags.php           应用行为扩展定义文件
│  └─database.php       数据库配置文件
│
├─public                WEB目录（对外访问目录）
│  ├─index.php          入口文件
│  ├─router.php         快速测试文件
│  └─.htaccess          用于apache的重写
│
├─thinkphp              TP框架系统目录
│
├─extend                扩展类库目录（目前未使用）
├─runtime               应用的运行时目录（可写，可定制）
├─vendor                第三方类库目录（Composer依赖库）
├─build.php             自动生成定义文件（参考）
├─composer.json         composer 定义文件
├─LICENSE.txt           授权说明文件
├─README.md             README 文件
├─think                 命令行入口文件
~~~
常用操作:
获取随机字符串：get_rand_str
发送HTTP请求：httpRequest
调用素玄其他系统接口：sx_call
获取客户端IP地址：get_client_ip
向浏览器发送一个状态码：send_http_status
检查是否登录：check_login【注：控制器默认继承base.php时，已经判断是否登录了，其他地方需要使用此方法判断】
记录API请求日志：api_log【注：在API请求公共方法内已经记录，不需要单独记录，但业务操作日志需要手动记录】
记录业务操作日志：action_log
公共加密方法：think_encrypt
公共解密方法：think_decrypt
... （未完待续）


PHP开发规范~~~~~

开发环境：
	PHP版本：5.4以上，不要使用PHP7

编辑器：
        原则上不限制，但要保障以下几点：
	默认存储文件格式为utf-8或可以按项目自动识别文件存储类似。
	更换文件存储格式时，换为utf-8是，不能带BOM头。
	支持函数快速查询功能，以及函数调用快速定位功能。

db类进行数据库操作时，除了使用框架的ORM方法外，如果直接写SQL，
一定要遵循:
	查询类，使用db(‘tablename’)->query($sql)
	更新类：使用db(‘tablename’)->execute($sql)
文件注释：
        所有文件按以下格式进行注释：

/**
 * {文件功能描述}有多行描述，结尾加：<br/>
 * 
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 * 
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: {作都名字}<{作者邮箱}> 2017-10-17 $
 */

        所有方法按如下备注：

/**
 * 此方法描述，有多行描述，结尾加：<br/>
 * @param String $url 请求url地址
 * @param String $method 请求方法 get post
 * @param null $postfields post数据数组
 * @param Array $headers 请求header信息
 * @param Bool|false $debug  调试开启 默认false
 * @return mixed
 * @author {作都名字}<{作者邮箱}> 2017-10-17 $
 */


命名规范：

PHP脚本：
        命令尽量使用代表实际意义的英文或英文简写，实在想不出的，可以使用拼音，但尽量少用，
        英文字母超过10个以上的，请使用相应简写，或头三个字母。
	类：遵循驼峰规则，首字母大写,如：Order
        函数的命名使用小写字母和下划线（小写字母开头）的方式，例如 `get_client_ip`；
	方法命名：遵循驼峰规则，首字母小写，如：getUsernameById()
	常量：全部大写，中间以下划线分开，如：LOGIN_ACTIVE_TIME
	普通变量：遵循驼峰规则，首字母小写，如：$appVersion
	模板变量：遵循驼峰规则，首字母小写,并尽量保持与PHP内变量名一致，以便维护，如：$this->assign('userName', $userName)
        属性的命名使用驼峰法，并且首字母小写，例如 `tableName`、`instance`；
        TP5的controller和model等文件名命不用再加后缀，如User控制器，命名为：User.php即可，不用命名成：UserController.class.php了
	
页面：
	JS的变量：小写字母，中间以下划线分开，如：var  user_id = 0;
	表单内属DOM对像名字：小写字母，中间以下划线分开，对像如果需要在JS中获取属性的，需设置为ID，ID与NAME原则一一致
	如：
	<input type="text" class="form-control" id="api_version" name="api_version" value="K10"/>
	有涉及到表单内字段代表某个表内的字段时，原则上与数据库内的字段名一至。
	CSS内样式表的命名，以小写英文单词加中划线分隔。
其他：
	存储文件，中间的目录命名，统一使用小写英文单词或简写英文单词，中间以下划线分隔。

数据库建表规范：
        表名，字段名，以及脚本内的变量名同理，尽量使用有意义的英文，超过10字母的，用简写或头三个字母。
	表名：表名用简写表头进行模块分类，比如订单表，应以：o_开头  
		表名除表头部分，一律使用小写字母中间以下划线分隔，如：o_order_history
	字段名：同上，小写的英文单词组合，中间用下划线分隔，如：create_time
		字段名主键，统一使用：id 代表，涉及到让用户填写的编号字段，统一使用code字段代表，
	数据库所有表，字符集为utf8字符集校验为：utf8_unicode_ci存储引擎类型为：InnoDB
PowerDesign内设置：databases->Edit Current DBMS ->Mysql 5.0 ->Script->Object->Table->Option内增加：

ENGINE = %s : list = BDB | HEAP | ISAM | InnoDB | MERGE | MRG_MYISAM | MYISAM, default = InnoDB 
DEFAULT CHARACTER SET = %s : list = utf8 | gbk, default = utf8 
COLLATE = %s : list = utf8_bin | utf8_general_ci | gbk_bin | gbk_chinese_ci, default = utf8_bin

然后在每个数据库表的Physical Options 内增加上Engine,DEFAULT CHARACTER SET和Collate的标签


数据库表名：
	 数据库名		日志库名
CRM系统：  sx_crm 	sx_crm_logs
ERP系统：  sx_erp		sx_erp_logs
管理中心：  sx_mc		sx_mc_logs
选片系统 ： sx_spm        sx_spm_logs
会员系统；  sx_vip	sx_vip_logs
客服系统 ： sx_csc	sx_csc_logs
数码管控：  sx_crpm	sx_crpm_logs
OA：      sx_oa		sx_oa_logs
财报系统 ： sx_fs		sx_fs_logs
供应链：	  sx_scm	sx_scm_logs
企划：	  sx_pa		sx_pa_logs
车间：	  sx_pwm	sx_pwm_logs

