<?php
// +----------------------------------------------------------------------
// | ThinkPHP [ WE CAN DO IT JUST THINK ]
// +----------------------------------------------------------------------
// | Copyright (c) 2006-2016 http://thinkphp.cn All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 流年 <liu21st@gmail.com>
// +----------------------------------------------------------------------

// 应用公共文件

error_reporting(E_ERROR|E_PARSE);

/**
    * 产生随机字串，可用来自动生成密码
    * 默认长度6位 字母和数字混合 支持中文
    * @param integer $len 长度
    * @param string $type 字串类型
    * 0 字母 1 数字 其它 混合
    * @param string $addChars 额外字符
    * @return string
    */
function get_rand_string($len=6,$type='',$addChars='') {
    $str ='';
    switch($type) {
        case 0:
            $chars='ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz'.$addChars;
            break;
        case 1:
            $chars= str_repeat('0123456789',3);
            break;
        case 2:
            $chars='ABCDEFGHIJKLMNOPQRSTUVWXYZ'.$addChars;
            break;
        case 3:
            $chars='abcdefghijklmnopqrstuvwxyz'.$addChars;
            break;
        case 4:
            $chars = "们以我到他会作时要动国产的一是工就年阶义发成部民可出能方进在了不和有大这主中人上为来分生对于学下级地个用同行面说种过命度革而多子后自社加小机也经力线本电高量长党得实家定深法表着水理化争现所二起政三好十战无农使性前等反体合斗路图把结第里正新开论之物从当两些还天资事队批点育重其思与间内去因件日利相由压员气业代全组数果期导平各基或月毛然如应形想制心样干都向变关问比展那它最及外没看治提五解系林者米群头意只明四道马认次文通但条较克又公孔领军流入接席位情运器并飞原油放立题质指建区验活众很教决特此常石强极土少已根共直团统式转别造切九你取西持总料连任志观调七么山程百报更见必真保热委手改管处己将修支识病象几先老光专什六型具示复安带每东增则完风回南广劳轮科北打积车计给节做务被整联步类集号列温装即毫知轴研单色坚据速防史拉世设达尔场织历花受求传口断况采精金界品判参层止边清至万确究书术状厂须离再目海交权且儿青才证低越际八试规斯近注办布门铁需走议县兵固除般引齿千胜细影济白格效置推空配刀叶率述今选养德话查差半敌始片施响收华觉备名红续均药标记难存测士身紧液派准斤角降维板许破述技消底床田势端感往神便贺村构照容非搞亚磨族火段算适讲按值美态黄易彪服早班麦削信排台声该击素张密害侯草何树肥继右属市严径螺检左页抗苏显苦英快称坏移约巴材省黑武培著河帝仅针怎植京助升王眼她抓含苗副杂普谈围食射源例致酸旧却充足短划剂宣环落首尺波承粉践府鱼随考刻靠够满夫失包住促枝局菌杆周护岩师举曲春元超负砂封换太模贫减阳扬江析亩木言球朝医校古呢稻宋听唯输滑站另卫字鼓刚写刘微略范供阿块某功套友限项余倒卷创律雨让骨远帮初皮播优占死毒圈伟季训控激找叫云互跟裂粮粒母练塞钢顶策双留误础吸阻故寸盾晚丝女散焊功株亲院冷彻弹错散商视艺灭版烈零室轻血倍缺厘泵察绝富城冲喷壤简否柱李望盘磁雄似困巩益洲脱投送奴侧润盖挥距触星松送获兴独官混纪依未突架宽冬章湿偏纹吃执阀矿寨责熟稳夺硬价努翻奇甲预职评读背协损棉侵灰虽矛厚罗泥辟告卵箱掌氧恩爱停曾溶营终纲孟钱待尽俄缩沙退陈讨奋械载胞幼哪剥迫旋征槽倒握担仍呀鲜吧卡粗介钻逐弱脚怕盐末阴丰雾冠丙街莱贝辐肠付吉渗瑞惊顿挤秒悬姆烂森糖圣凹陶词迟蚕亿矩康遵牧遭幅园腔订香肉弟屋敏恢忘编印蜂急拿扩伤飞露核缘游振操央伍域甚迅辉异序免纸夜乡久隶缸夹念兰映沟乙吗儒杀汽磷艰晶插埃燃欢铁补咱芽永瓦倾阵碳演威附牙芽永瓦斜灌欧献顺猪洋腐请透司危括脉宜笑若尾束壮暴企菜穗楚汉愈绿拖牛份染既秋遍锻玉夏疗尖殖井费州访吹荣铜沿替滚客召旱悟刺脑措贯藏敢令隙炉壳硫煤迎铸粘探临薄旬善福纵择礼愿伏残雷延烟句纯渐耕跑泽慢栽鲁赤繁境潮横掉锥希池败船假亮谓托伙哲怀割摆贡呈劲财仪沉炼麻罪祖息车穿货销齐鼠抽画饲龙库守筑房歌寒喜哥洗蚀废纳腹乎录镜妇恶脂庄擦险赞钟摇典柄辩竹谷卖乱虚桥奥伯赶垂途额壁网截野遗静谋弄挂课镇妄盛耐援扎虑键归符庆聚绕摩忙舞遇索顾胶羊湖钉仁音迹碎伸灯避泛亡答勇频皇柳哈揭甘诺概宪浓岛袭谁洪谢炮浇斑讯懂灵蛋闭孩释乳巨徒私银伊景坦累匀霉杜乐勒隔弯绩招绍胡呼痛峰零柴簧午跳居尚丁秦稍追梁折耗碱殊岗挖氏刃剧堆赫荷胸衡勤膜篇登驻案刊秧缓凸役剪川雪链渔啦脸户洛孢勃盟买杨宗焦赛旗滤硅炭股坐蒸凝竟陷枪黎救冒暗洞犯筒您宋弧爆谬涂味津臂障褐陆啊健尊豆拔莫抵桑坡缝警挑污冰柬嘴啥饭塑寄赵喊垫丹渡耳刨虎笔稀昆浪萨茶滴浅拥穴覆伦娘吨浸袖珠雌妈紫戏塔锤震岁貌洁剖牢锋疑霸闪埔猛诉刷狠忽灾闹乔唐漏闻沈熔氯荒茎男凡抢像浆旁玻亦忠唱蒙予纷捕锁尤乘乌智淡允叛畜俘摸锈扫毕璃宝芯爷鉴秘净蒋钙肩腾枯抛轨堂拌爸循诱祝励肯酒绳穷塘燥泡袋朗喂铝软渠颗惯贸粪综墙趋彼届墨碍启逆卸航衣孙龄岭骗休借".$addChars;
            break;
        default :
            // 默认去掉了容易混淆的字符oOLl和数字01，要添加请使用addChars参数
            $chars='ABCDEFGHIJKMNPQRSTUVWXYZabcdefghijkmnpqrstuvwxyz23456789'.$addChars;
            break;
    }
    if($len>10 ) {//位数过长重复字符串一定次数
        $chars= $type==1? str_repeat($chars,$len) : str_repeat($chars,5);
    }
    if($type!=4) {
        $chars   =   str_shuffle($chars);
        $str     =   substr($chars,0,$len);
    }else{
        // 中文随机字
        for($i=0;$i<$len;$i++){
            $str.= msubstr($chars, floor(mt_rand(0,mb_strlen($chars,'utf-8')-1)),1,'utf-8',false);
        }
    }
    return $str;
}
/**
 * http_request的重写，只返回response,如果需要返回http_code 以及request信息，请调用http_request
 * 
 * @param $url 请求url地址
 * @param $method 请求方法 get post
 * @param null $postfields post数据数组
 * @param array $headers 请求header信息
 * @param bool|false $debug  调试开启 默认false
 * @return mixed
 * @author songdemei<songdemei@suxuantech.cn>
 */
function httpRequest($url, $method="GET", $postfields = null, $headers = array(), $debug = false) {
    $res = http_request($url, $method, $postfields, $headers, $debug);
    return $res['response'];
}
/**
 * CURL请求
 * @param $url 请求url地址
 * @param $method 请求方法 get post
 * @param null $postfields post数据数组
 * @param array $headers 请求header信息
 * @param bool|false $debug  调试开启 默认false
 * @return array();<br/>
 * code:http状态码；
 * response：响应内容；
 * request:请求信息；
 * @author songdemei<songdemei@suxuantech.cn>
 */
function http_request($url, $method="GET", $postfields = null, $headers = array(), $debug = false) {
    $method = strtoupper($method);
    $ci = curl_init();
    $contentLength = 0;
    /* Curl settings */
    curl_setopt($ci, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_0);
    curl_setopt($ci, CURLOPT_USERAGENT, "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/61.0.3163.100 Safari/537.36");
    curl_setopt($ci, CURLOPT_CONNECTTIMEOUT, 10); /* 在发起连接前等待的时间，如果设置为0，则无限等待 */
    curl_setopt($ci, CURLOPT_TIMEOUT, 7); /* 设置cURL允许执行的最长秒数 */
    curl_setopt($ci, CURLOPT_RETURNTRANSFER, true);
    switch ($method) {
        case "POST":
            curl_setopt($ci, CURLOPT_POST, true);
            if (!empty($postfields)) {
                $tmpdatastr = is_array($postfields) ? http_build_query($postfields) : $postfields;
                $contentLength = strlen($tmpdatastr);
                curl_setopt($ci, CURLOPT_POSTFIELDS, $tmpdatastr);
            }
            break;
        default:
            curl_setopt($ci, CURLOPT_CUSTOMREQUEST, $method); /* //设置请求方式 */
            break;
    }
    $ssl = preg_match('/^https:\/\//i',$url) ? TRUE : FALSE;
    curl_setopt($ci, CURLOPT_URL, $url);
    if($ssl){
        curl_setopt($ci, CURLOPT_SSL_VERIFYPEER, FALSE); // https请求 不验证证书和hosts
        curl_setopt($ci, CURLOPT_SSL_VERIFYHOST, FALSE); // 不从证书中检查SSL加密算法是否存在
    }
    //curl_setopt($ci, CURLOPT_HEADER, true); /*启用时会将头文件的信息作为数据流输出*/
    curl_setopt($ci, CURLOPT_FOLLOWLOCATION, 1);
    curl_setopt($ci, CURLOPT_MAXREDIRS, 2);/*指定最多的HTTP重定向的数量，这个选项是和CURLOPT_FOLLOWLOCATION一起使用的*/
    $headers[] = "Content-Length: ".$contentLength;
    curl_setopt($ci, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ci, CURLINFO_HEADER_OUT, true);
    /*curl_setopt($ci, CURLOPT_COOKIE, $Cookiestr); * *COOKIE带过去** */
    $response = curl_exec($ci);
    $requestinfo = curl_getinfo($ci);
    $http_code = curl_getinfo($ci, CURLINFO_HTTP_CODE);
    if ($debug) {
        echo "=====post data======\r\n";
        print_r($postfields);
        echo "=====info===== \r\n";
        print_r($requestinfo);
        echo "=====response=====\r\n";
        print_r($response);
    }
    curl_close($ci);
    //return $response;
    return array('code'=>$http_code, 'response'=>$response,'request'=>$requestinfo);
}


/**
 * 获取客户端IP地址
 * @param integer $type 返回类型 0 返回IP地址 1 返回IPV4地址数字
 * @param boolean $adv 是否进行高级模式获取（有可能被伪装） 
 * @return mixed
 */
function get_client_ip($type = 0,$adv=false) {
    $type       =  $type ? 1 : 0;
    static $ip  =   NULL;
    if ($ip !== NULL) return $ip[$type];
    if($adv){
        if (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
            $arr    =   explode(',', $_SERVER['HTTP_X_FORWARDED_FOR']);
            $pos    =   array_search('unknown',$arr);
            if(false !== $pos) unset($arr[$pos]);
            $ip     =   trim($arr[0]);
        }elseif (isset($_SERVER['HTTP_CLIENT_IP'])) {
            $ip     =   $_SERVER['HTTP_CLIENT_IP'];
        }elseif (isset($_SERVER['REMOTE_ADDR'])) {
            $ip     =   $_SERVER['REMOTE_ADDR'];
        }
    }elseif (isset($_SERVER['REMOTE_ADDR'])) {
        $ip     =   $_SERVER['REMOTE_ADDR'];
    }
    // IP地址合法验证
    $long = sprintf("%u",ip2long($ip));
    $ip   = $long ? array($ip, $long) : array('0.0.0.0', 0);
    return $ip[$type];
}

/**
 * 发送HTTP状态
 * @param integer $code 状态码
 * @return void
 */
function send_http_status($code) {
    static $_status = array(
            // Informational 1xx
            100 => 'Continue',
            101 => 'Switching Protocols',
            // Success 2xx
            200 => 'OK',
            201 => 'Created',
            202 => 'Accepted',
            203 => 'Non-Authoritative Information',
            204 => 'No Content',
            205 => 'Reset Content',
            206 => 'Partial Content',
            // Redirection 3xx
            300 => 'Multiple Choices',
            301 => 'Moved Permanently',
            302 => 'Moved Temporarily ',  // 1.1
            303 => 'See Other',
            304 => 'Not Modified',
            305 => 'Use Proxy',
            // 306 is deprecated but reserved
            307 => 'Temporary Redirect',
            // Client Error 4xx
            400 => 'Bad Request',
            401 => 'Unauthorized',
            402 => 'Payment Required',
            403 => 'Forbidden',
            404 => 'Not Found',
            405 => 'Method Not Allowed',
            406 => 'Not Acceptable',
            407 => 'Proxy Authentication Required',
            408 => 'Request Timeout',
            409 => 'Conflict',
            410 => 'Gone',
            411 => 'Length Required',
            412 => 'Precondition Failed',
            413 => 'Request Entity Too Large',
            414 => 'Request-URI Too Long',
            415 => 'Unsupported Media Type',
            416 => 'Requested Range Not Satisfiable',
            417 => 'Expectation Failed',
            // Server Error 5xx
            500 => 'Internal Server Error',
            501 => 'Not Implemented',
            502 => 'Bad Gateway',
            503 => 'Service Unavailable',
            504 => 'Gateway Timeout',
            505 => 'HTTP Version Not Supported',
            509 => 'Bandwidth Limit Exceeded'
    );
    if(isset($_status[$code])) {
        header('HTTP/1.1 '.$code.' '.$_status[$code]);
        // 确保FastCGI模式下正常
        header('Status:'.$code.' '.$_status[$code]);
    }
}

function api_check_login($sessionId='') {
    $sessionId = $sessionId?$sessionId:input('post.session_id');
    $loginInfo = db('s_session')->where('session_id', $sessionId)->find();
    if(!$loginInfo){
        return false;
    }
    if(time() > $loginInfo['expire_time']){
        //登录是否过期
        return false;
    }
    return $loginInfo;
    
}

//替换特殊字符
function replaceSpecialChar($strParam){
    $regex = "/\/|\~|\!|\@|\#|\\$|\%|\^|\&|\*|\(|\)|\_|\+|\{|\}|\:|\<|\>|\?|\[|\]|\,|\.|\/|\;|\'|\`|\-|\=|\\\|\|/";
    return preg_replace($regex,"",$strParam);
}
function saveLoginSessions($info){
    session('staff_id',$info['staff_id']);
    session('staff_name',$info['staffname']);
    session('staff_number',$info['staffnumber']);
    session('session_id',$info['session_id']);
    session('brandclass_id',$info['brandclass_id']);
    session('brandclass',$info['brandclass']);
    session('shop_name',$info['shop_name']);
    session('shop_code',$info['shop_code']);
    session('belong_shop_name',$info['belong_shop_name']);
    session('belong_shop_code',$info['belong_shop_code']);
    session('is_sk',$info['is_sk']);
    session('is_marketing',$info['is_marketing']);
    session('shop_type',$info['shop_type']);
    session('setkey',$info['setkey']);
    session('main_work_type',$info['main_work_type']);
    session('work_type',$info['work_type']);
    session('department_name',$info['department_name']);
    session('department_id',$info['department_id']);
    session('position_code',$info['position_code']);
    session('main_position_name',$info['main_position_name']);
    session('main_position_code',$info['main_position_code']);
    session('grade_type',$info['grade_type']);
    session('is_belong',$info['is_belong']);
    session('open_id', $info['open_id']);
}
/*
 * 判断是否登录状态
 * 正常判断session如果session里没有，则判断cookie是否自动登录，如果是，更新session
 * 如果没有，退出登录
 * @return [type] [description]
 */
function check_login($detailError = 0){
    $cookieStaffId = (int)cookie('staff_id');
    $sessionStaffId = session('staff_id');
    $cookieSessionId = cookie('session_id');
    $sessionId = session('session_id');
    if(!$cookieStaffId || !$cookieSessionId){
        //cookie内值一定要有，5天自动登录也就是cookie存在时间长一点而以。
        return false;
    }

    $cacheStaffInfo = cache('KF_staffInfo_'.$cookieStaffId);
    if(!$cacheStaffInfo){
        //未登录
        return false;
    }

    if($cacheStaffInfo['session_id'] != $cookieSessionId){
        //cookie里与cache里不一至，直接退出。
        //注意，如果5天自动登录，有可能session里没有了。
        if($detailError){
            return array('code'=>ERR_LOGIN_OTHERLOGIN,'msg'=>'用户在别的地方登录','data'=>array());
        }else{
            return false;
        }
    }

    $cacheStaffInfo['active'] = time();
    if(!$sessionStaffId || $sessionStaffId != $cookieStaffId || $sessionId != $cookieSessionId){
        //session 没了，但cookie还有，且与cache里一至
        //更新cache到session
        saveLoginSessions($cacheStaffInfo);
        $sessionStaffId = $cacheStaffInfo['staff_id'];
        $sessionId = $cacheStaffInfo['session_id'];
    }

    if($cookieStaffId == $sessionStaffId && $cookieSessionId == $sessionId){
        //登录没问题
        if($cacheStaffInfo['keep_login'] == 1){
            cache('KF_staffInfo_'.$cookieStaffId, json_encode($cacheStaffInfo),432000);
        }else{
            cache('KF_staffInfo_'.$cookieStaffId, json_encode($cacheStaffInfo));
        }
        
        return true;
    }else{
        //登录有问题
        if($detailError){
            if($cookieStaffId == $sessionStaffId){
                $res = array('code'=>ERR_LOGIN_OTHERLOGIN,'msg'=>'用户在别的地方登录','data'=>array());
            }else{
                $res = array('code'=>ERR_LOGIN_UNLOGIN,'msg'=>'用户未登录','data'=>array());
            }
        }else{
            $rse = false;
        }
        return $res;
    }

}

/**
 * 正常业务访问时，判断用户是否登录使用。此处只判断是否登录，如何处理，由调用处进行处理。
 * 
 * @return boolean
 */
function check_login_old() {
    $staffId = think_decrypt(cookie('auto_staff_id'),'');
    $session_id = think_decrypt(cookie('auto_session_id'),'');
    if(empty($session_id) || empty(intval($staffId))){//缓存里没有说明没有选择自动登录，验证普通登录
        $info = json_decode(think_decrypt(cache('KF_staffInfo_'.cookie('staff_id'))),true);
        //print_r(cookie('session_id'));echo "|";print_r($info['session_id']);die;
        if( cookie('session_id') == $info['session_id'] ){
            if(empty(trim(cookie('session_id'))) || intval(cookie('staff_id') <= 0) || empty(trim(session('staff_id')))){
                cookie(null);
                session();
                return false;
            }
            $info['active'] = time();
             //if(cookie('status') == 1){
                cache('KF_staffInfo_'.cookie('staff_id'), think_encrypt(json_encode($info)));
             //}
            return true;
        }else{
            cookie(null);
            session();
            return false;
        }
    }else{
        $info = json_decode(think_decrypt(cache('KF_staffInfo_'.$staffId),''),true);
        // var_dump($session_id);
        // var_dump($info);
        if($info['session_id'] == $session_id){

            session('staff_id',$info['staff_id']);
            session('staff_name',$info['staffname']);
            session('staff_number',$info['staffnumber']);
            session('session_id',$info['session_id']);
            session('brandclass_id',$info['brandclass_id']);
            session('brandclass',$info['brandclass']);
            session('shop_name',$info['shop_name']);
            session('shop_code',$info['shop_code']);
            session('belong_shop_name',$info['belong_shop_name']);
            session('belong_shop_code',$info['belong_shop_code']);
            session('is_sk',$info['is_sk']);
            session('is_marketing',$info['is_marketing']);
            session('shop_type',$info['shop_type']);
            session('setkey',$info['setkey']);
            cookie('status',$info['status']);
            session('main_work_type',$info['main_work_type']);
            session('work_type',$info['work_type']);
            session('department_name',$info['department_name']);
            session('department_id',$info['department_id']);
            session('position_code',$info['position_code']);
            session('main_position_name',$info['main_position_name']);
            session('main_position_code',$info['main_position_code']);
            session('grade_type',$info['grade_type']);
            session('is_belong',$info['is_belong']);
            session('open_id', $info['open_id']);
            // if(cookie('status') == 1){
            $info['active'] = time();
            cache('KF_staffInfo_'.cookie('staff_id'), think_encrypt(json_encode($info)));
            // }

            return true;
        }else{
            cookie(null);//不好使。。。。TP的BUG
            session();
            cookie('auto_staff_id',null);
            cookie('auto_session_id',null);
            return false;
        }
    }

}
/**
 * 把数据按key=value方式，使用&连接起来。
 * 
 * @param type $array
 * @return type String
 */
function arrayToParams($array){
    $ret = '';
    foreach($array as $k=>$v){
        $ret .= $k.'='.$v.'&';
    }
    $ret = trim($ret,'&');
    return $ret;
}
/**
 * 验证POST数据的access token签名是否正确。
 * 
 * @param String $appSecret 当前请求接口的应用密钥
 * @param String $accessToken 当前请求头信息内的token
 * 
 * @return boolean  验证通过返回true,验证失败返回false
 */
function checkAccessToken($appSecret,$accessToken) {
    $params = input('post.');
    unset($params['action'],$params['method']);
    ksort($params);
    $tokenStr = arrayToParams($params).$appSecret;
    //var_dump($tokenStr);
    if($accessToken != md5($tokenStr)){
        return false;           
    }
    return true;
}
/**
 * 记录API访问日志
 * 
 * @param type $logInfo
 */
function apiLog($logInfo) {
   // var_dump($logInfo);
   // exit();
    $logInfo['create_time'] = date('Y-m-d H:i:s');
    $logInfo['create_ip'] = get_client_ip();
    $res = db('api_logs','db_logs')->insert($logInfo);
    if(!$res){
        
    }
}
function api_log($logInfo){
    apiLog($logInfo);
}

/**
 * 操作日志记录，此日志需要在代码里手动记录。<br/>
 * 需要在application的common里面有model/actionLog.php的model类<br/>
 * 记录的module/controller/action如果不输入，为请求进来的，针对于API接口。因为做了单独调用，固需要手动指定一下<br/>
 * 
 * @param Mix $data        本次要记录的日志数据
 * @param Mix $oldData     修改前的数据
 * @param Int $customerId      当前操作的客户ID。
 * @param Int $staffId      当前登录员工ID，默认取session内的staff_id,针对API记录，需要手动传入。
 * @param Int $staffName      当前登录员工姓名
 * @param String $module      操作的模块，默认取当前请求的应用模块
 * @param String $controller  操作的控制器，默认取当前请求的控制器
 * @param String $action      操作的方法，默认取当前请求的方法
 */
function action_log($data,$oldData,$id = 0,$staffId = 0,$staffName='',$module='',$controller = '',$action='', $ip='', $create_time=''){
    if(!$module){
        $module = \think\Request::instance()->module();
    }
    if(!$controller){
        $controller = \think\Request::instance()->controller();
    }
    if(!$action){
        $action = \think\Request::instance()->action();
    }
    if(!$ip){
        $ip = \think\Request::instance()->ip();
    }
    if(!is_string($data)){
        $data = json_encode($data);
    }
    if(!is_string($oldData)){
        $oldData = json_encode($oldData);
    }

    $log = model('crm/ActionLog');
    $log->old_data = $oldData;
    $log->data = $data;
    $log->action = $action;
    $log->controller = $controller;
    $log->module = $module;
    $log->ip = $ip;
    $log->this_id = $id;
    $log->staff_id = $staffId?$staffId:(int)session('staff_id');
    $log->staff_name = $staffName?$staffName:session('staff_name');
    $log->create_time= $create_time ? $create_time : date('Y-m-d H:i:s');
    $log->startTrans();
    $res = $log->isUpdate(false)->save();
    // echo 'action_log==>>'.$res;
    if($res === false){
        // echo 'action_log==>>rollBack';
        $log->rollBack();
        \think\Log::error('日志保存错误:module:'.$module.';controller:'.$controller.';action:'.$action.';data:'.$data.';olddata:'.$oldData.';customerid:'.$customerId);       
    }else{
        // echo 'action_log==>>commit';
        $log->commit();
    }
}
/**
 * 素玄内部接口调用
 * 
 * @param type $interfaceHash
 * @param type $data
 * @param type $system
 * @param type $sessionId
 * @return string
 */
function sx_call($interfaceHash,$data,$system='sx_mc',$sessionId='') {
    $param = '';
    $system = $system?$system:'sx_mc';
    $ret = array('errid'=>0,'data'=>[]);
    foreach ($data as $k=>$v){
        if(is_null($v)){
            unset($data[$k]);
        }
    }
    if(!empty($data)){
        ksort($data);
        $param = arrayToParams($data);
    }
    $appConfig = config('ext.app_config');
    $secret = config('ext.app_secret');//$appConfig[strtolower($system)]['secret'];
    if(key_exists(strtolower($system), $appConfig)){
        $addr = $appConfig[strtolower($system)]['addr'];
        if(substr($addr,-1) != '/'){
            $addr .= '/';
        }
        $addr .= 'api/'.$interfaceHash;

    }else{
        $ret['error'] = '当前系统未安装应用：'.$system;
        return $ret;
    }
    $param .= $secret;
    $token = md5($param);
    $header = array('ACCESS-TOKEN: '.$token);
    if($sessionId){
        $header[] = 'SESSION-ID: '.$sessionId;
    }

    return json_decode(httpRequest($addr, 'POST', $data, $header),true);
    
}


/**
 * 系统加密方法
 * @param string $data 要加密的字符串
 * @param string $key  加密密钥
 * @param int $expire  过期时间 单位 秒
 * @return string
 */
function think_encrypt($data, $key = '', $expire = 0) {
    $key  = md5(empty($key) ? config('AUTH_KEY') : $key);
    $data = base64_encode($data);
    $x    = 0;
    $len  = strlen($data);
    $l    = strlen($key);
    $char = '';

    for ($i = 0; $i < $len; $i++) {
        if ($x == $l) $x = 0;
        $char .= substr($key, $x, 1);
        $x++;
    }

    $str = sprintf('%010d', $expire ? $expire + time():0);

    for ($i = 0; $i < $len; $i++) {
        $str .= chr(ord(substr($data, $i, 1)) + (ord(substr($char, $i, 1)))%256);
    }
    return str_replace(array('+','/','='),array('-','_',''),base64_encode($str));
}

/**
 * 系统解密方法
 * @param  string $data 要解密的字符串 （必须是think_encrypt方法加密的字符串）
 * @param  string $key  加密密钥
 * @return string
 */
function think_decrypt($data, $key = ''){
    $key    = md5(empty($key) ? config('AUTH_KEY') : $key);
    $data   = str_replace(array('-','_'),array('+','/'),$data);
    $mod4   = strlen($data) % 4;
    if ($mod4) {
       $data .= substr('====', $mod4);
    }
    $data   = base64_decode($data);
    $expire = substr($data,0,10);
    $data   = substr($data,10);

    if($expire > 0 && $expire < time()) {
        return '';
    }
    $x      = 0;
    $len    = strlen($data);
    $l      = strlen($key);
    $char   = $str = '';

    for ($i = 0; $i < $len; $i++) {
        if ($x == $l) $x = 0;
        $char .= substr($key, $x, 1);
        $x++;
    }

    for ($i = 0; $i < $len; $i++) {
        if (ord(substr($data, $i, 1))<ord(substr($char, $i, 1))) {
            $str .= chr((ord(substr($data, $i, 1)) + 256) - ord(substr($char, $i, 1)));
        }else{
            $str .= chr(ord(substr($data, $i, 1)) - ord(substr($char, $i, 1)));
        }
    }
    return base64_decode($str);
}

/**
 * 存入redis消息队列
 * 
 * @param str listName      消息队列的名称
 * @param mix $msg          消息队列的内容
 *
 * @return boolean  
 */
function push_list($listName, $msg){
    $create_time = date('Y-m-d H:i:s');
    // $ip = \think\Request::instance()->ip();
    $ip = get_client_ip();
    $msg['ip'] = $ip;
    $msg['create_time'] = $create_time;
    switch ($listName) {
        // 数据统计队列
        case 'historyDataList':
            $msgIn = json_encode($msg);
            $data['message']    = $msgIn;
            $data['type']       = $msg['type'];
            $data['create_time']= $create_time;
            $res = db('c_history_data')->insertGetId($data);
            if (!$res) {
                return false;
            }
            
            $msg['hid'] = $res;
            $message = $msg;
            break;
        // 分配队列
        case 'fpCustomerList':
            $message = $msg;
            break;
        // excel导入队列
        case 'excelImportRedisList':
            $message = $msg;
            break;
    }
    return \app\common\lib\redisQueue::init()->rPush($listName, $message);
}



/**
 * 发送系统消息   发送人信息  为系统  四种类型（1：存库；2：redis订阅消息；3：微信消息；4：短信）
 * @param  data  
 *
 * @param  data['send_mode']      消息模式（array('db'=>1, 'publish'=>1, 'wx'=>, 'sms'=>1)）
 * @param  data['send_type']      消息类型
 * @param  data['send_title']     消息标题
 * @param  data['send_msg']       发送的消息内容
 * @param  data['receive_id']     接收人id
 * @param  data['receive_name']   接收人name
 * @param  data['receive_status'] 接收状态
 * @param  data['operation_type'] 操作类型（1：可操作；2：不可操作）
 * @param  data['operation']      操作方法json（[0=>[button：按钮名称；url：按钮对应的URL带参数],1=>...]）
 * @param  data['time_out']       生存时间（600秒）
 * @return bool    
 * @author Eric
 */
function sendSystemMessage($data){

    // 频道名称
    $channel = 'notice';
    $time = time();
    if ($data['time_out']) {
        $timeOut = $time+$data['time_out'];
    }else{
        $timeOut = '';
    }
    $timeOut = $time+$data['time_out'];
    $inData = [
        'send_id'  => '-1',
        'send_name'=> 'syetem',
        'send_time'=> date('Y-m-d H:i:s', $time),
        'time_out' => $timeOut,
    ];
    $allData = array_merge($data, $inData);
    // 开启事务
    db()->startTrans();
    try {
        $id = db('c_message')->insertGetId($allData);
        $message = $allData;
        $message['id'] = $id;
        $res = \app\common\lib\redisQueue::init()->publish($channel, $message);
        db()->commit();
        return true;
    } catch (Exception $e) {
        db()->rollback();
        return false;
    }
}

/**
 * 发送系统消息   发送人信息  为系统  四种类型（1：存库；2：redis订阅消息；3：微信消息；4：短信）
 * @param  data  
 *
 * @param  data['send_mode']      消息模式（array('db'=>1, 'publish'=>1, 'wx'=>, 'sms'=>1)）
 * @param  data['send_type']      消息类型:1:短消息(弹窗)；2：通知',
 * @param  data['send_title']     消息标题
 * @param  data['send_msg']       发送的消息内容
 * @param  data['receive_id']     接收人id
 * @param  data['receive_name']   接收人name
 * @param  data['receive_status'] 接收状态
 * @param  data['operation_type'] 操作类型（1：可操作；2：不可操作）
 * @param  data['operation']      操作方法json（[0=>[button：按钮名称；url：按钮对应的URL带参数],1=>...]）
 * @param  data['time_out']       生存时间（600秒）
 * @return bool    
 * @author Eric
 */
function sendSystemMessage_back($data){
    
    $time = time();
    if ($data['time_out']) {
        $timeOut = $time+$data['time_out'];
    }else{
        $timeOut = '';
    }
    $timeOut = $time+$data['time_out'];
    $inData = [
        'send_id'  => '-1',
        'send_name'=> 'syetem',
        'send_time'=> date('Y-m-d H:i:s', $time),
        'time_out' => $timeOut,
    ];
    $allData = array_merge($data, $inData);

    // db模式
    if ( isset($data['send_mode']['db']) && $data['send_mode']['db'] == 1 ) {
        $id = db('c_message')->insertGetId($allData);
    }
    // redis订阅消息模式
    if ( isset($data['send_mode']['publish']) && $data['send_mode']['publish'] == 1 ) {
        // 频道名称
        $channel = 'notice';
        $message = $allData;
        $message['id'] = $id ? $id : 0;
        $res = \app\common\lib\redisQueue::init()->publish($channel, $message);
    }
    // 微信消息模式
    if ( isset($data['send_mode']['wx']) && $data['send_mode']['wx'] == 1 ) {
        # code...
    }
    // 短信消息模式
    if ( isset($data['send_mode']['sms']) && $data['send_mode']['sms'] == 1 ) {
        # code...
    }

}

function isOnline(){
    $info = cache('KF_staffInfo_'.session('staff_id'));
    if( (time() - $info['active'] > 160) || ($info['status'] != 1) ){
        return false;
    }else{
        return true;
    }
}

// 回调函数,这里写处理逻辑
function noticeCallBack($instance, $channelName, $message) {
    if ($message) {
        $message = json_decode($message,true);
        if ($message['send_type'] == 3) {
            $check_login = check_login();
            // $check_login = isOnline();
            if ($check_login === false) {
                exit(json_encode(array('code'=>ERR_LOGIN_UNLOGIN)));
            }else{
                exit(json_encode(array('code'=>302,'msg'=>'','data'=>array())));
            }
        }
        $message['pop_status'] = 1;
        $message['operation'] = json_decode($message['operation'],true);
        #var_dump($message);
        foreach($message as $k=>$v){
            $message[$k]['time_out'] = $v['time_out'] - time();
        }

        $return['mid']        = (int)$message['id'];
        $return['noRead']     = controller("crm/Customer","lib")->getNewMessageNum();
        $return['popList']    = array($message);
        $return['messageList']= array($message);
        header("Content-Type:application/json;charset=utf-8");
        echo json_encode($return);
        exit;
    }
    // file_put_contents("rNotice.txt", 'cName：'.$channelName.'；msg：'.$message.PHP_EOL, FILE_APPEND); 
}

/**
 * 发送模板消息
 * @param Integer  $content json格式模板消息内容
 * @param String  $brandclass_id 品牌id
 * @param String   $shop_code 店面唯一识别码
 * @author {wangyining}<{wangyining@suxuantech.cn}> 2017-10-17 $
 */
function sendMsg($data){
    $url="5a4b81bc26160";
    $res=sx_call($url,$data);
    if($res['code']==200){
        $detail=$res['data'];
    }
    return $detail;
}

// 获取起始时间 $dataArea == today,near_week,near_month,last_week,last_month,this_week,this_month,last_jd,this_jd
function getdateArea($dataArea){
    switch ($dataArea) {
        // 今天
        case 'today':
            $begin  = date('Y-m-d');
            $end    = date('Y-m-d',strtotime('+1 day',strtotime($begin)));
            $return = array($begin,$end);
            break;
        // 最近一周 前7天
        case 'near_week':
            $near_week_begin  = date('Y-m-d', strtotime('-7 days'));
            $near_week_end    = date('Y-m-d', strtotime('-1 days'));
            $return = array($near_week_begin,$near_week_end);
            break;
        // 最近一月 前30天
        case 'near_month':
            $near_month_begin = date('Y-m-d', strtotime('-30 days'));
            $near_month_end   = date('Y-m-d', strtotime('-1 days'));
            $return = array($near_month_begin,$near_month_end);
            break;
        // 上周
        case 'last_week':
            $last_week_begin = date("Y-m-d",mktime(0, 0 , 0,date("m"),date("d")-date("w")+1-7,date("Y")));
            $last_week_end   = date("Y-m-d",mktime(23,59,59,date("m"),date("d")-date("w")+7-7,date("Y")));
            $return = array($last_week_begin,$last_week_end);
            break;
        // 上月 
        case 'last_month':
            $last_month_begin = date("Y-m-d",mktime(0, 0 , 0,date("m")-1,1,date("Y")));
            $last_month_end   = date("Y-m-d",mktime(23,59,59,date("m") ,0,date("Y")));
            $return = array($last_month_begin,$last_month_end);
            break;
        // 本周
        case 'this_week':
        case 'week':
            $this_week_begin  = date("Y-m-d",mktime(0, 0 , 0,date("m"),date("d")-date("w")+1,date("Y")));
            $this_week_end    = date("Y-m-d",mktime(23,59,59,date("m"),date("d")-date("w")+7,date("Y")));
            $return = array($this_week_begin,$this_week_end);
            break;
        // 本月 
        case 'this_month':
        case 'month':
            $this_month_begin = date("Y-m-d",mktime(0, 0 , 0,date("m"),1,date("Y")));
            $this_month_end   = date("Y-m-d",mktime(23,59,59,date("m"),date("t"),date("Y")));
            $return = array($this_month_begin,$this_month_end);
            break;
        // 上季度 
        case 'last_jd':
            $last_season   = ceil((date('n'))/3)-1;//上季度是第几季度
            $last_jd_begin = date('Y-m-d', mktime(0, 0, 0,$last_season*3-3+1,1,date('Y')));
            $last_jd_end   = date('Y-m-d', mktime(23,59,59,$last_season*3,date('t',mktime(0, 0 , 0,$last_season*3,1,date("Y"))),date('Y')));
            $return = array($last_jd_begin,$last_jd_end);
            break;
        // 本季度
        case 'this_jd':
            $this_season   = ceil((date('n'))/3);//当月是第几季度 
            $this_jd_begin = date('Y-m-d', mktime(0, 0, 0,$this_season*3-3+1,1,date('Y')));
            $this_jd_end   = date('Y-m-d', mktime(23,59,59,$this_season*3,date('t',mktime(0, 0 , 0,$this_season*3,1,date("Y"))),date('Y')));
            $return = array($this_jd_begin,$this_jd_end);
            break;
        default:
            $timestamp = strtotime( $dataArea );
            $this_jd_begin = date( 'Y-m-1 00:00:00', $timestamp );
            $mdays = date( 't', $timestamp );
            $this_jd_end = date( 'Y-m-' . $mdays . ' 23:59:59', $timestamp );
            $return = array($this_jd_begin,$this_jd_end);
            break;
    };
    return $return;
}

/**
 * 获取指定日期段内每一天的日期
 * @param  Date  $startdate 开始日期
 * @param  Date  $enddate   结束日期
 * @return Array
 */
function getDateFromRange($startdate, $enddate){
    $stimestamp = strtotime($startdate);
    $etimestamp = strtotime($enddate);
    // 计算日期段内有多少天
    $days = ($etimestamp-$stimestamp)/86400+1;

    // 保存每天日期
    $date = array();
    for($i=0; $i<$days; $i++){
        $date[] = date('Y-m-d', $stimestamp+(86400*$i));
    }
    return $date;
}

// 对应表中字段的中文
function translate($table='c_customerinfo', $key){
    $return = array(
        // 用户详情表
        'c_customerinfo' => array(
            'customer_number'      => '客户编号',
            'customer_name'        => '客户姓名',
            'customer_sex'         => '客户性别',
            'customer_tel'         => '客户手机',
            'customer_wechat'      => '客户微信',
            'customer_weibo'       => '客户微博',
            'customer_qq'          => '客户QQ',
            'province'             => '所在省',
            'city'                 => '所在市',
            'county'               => '县（区）',
            'customer_address'     => '客户地址',
            'mate_name'            => '配偶姓名',
            'mate_sex'             => '配偶性别',
            'mate_tel'             => '配偶电话',
            'mate_wechat'          => '配偶微信',
            'mate_weibo'           => '配偶微博',
            'mate_qq'              => '配偶QQ',
            'mate_address'         => '配偶地址',
            'consultation_type'    => '消费类型',
            'customer_type'        => '客户类型',
            'consulation_shop_code'=> '意向店面编码',
            'consulation_shop'     => '意向店面',
            'customer_channel'     => '客户渠道',
            'customer_cource'      => '客户来源',
            'customer_intention'   => '客户意向',
            'customer_orderaddress'=> '接单点',
            'access_model'         => '获取方式',
            'customer_area'        => '客户分区',
            'customer_region'      => '客户地域',
            'is_intostore'         => '是否进店',
            'is_success'           => '是否成交',
            'is_valid'             => '是否有效',
            'yx_day'               => '标记有效日期',
            'is_urgent'            => '是否加急',
            'is_loss'              => '是否流失',
            'is_dive'              => '是否潜水',
            'is_sk'                => '筛客状态',
            // 'is_sel'               => '筛客状态',
            'is_next'              => '是否再约',
            'next_time'            => '再约时间',
            'op_signinfo'          => '追踪标记',
            'op_signday'           => '追踪标记日期',
            'customer_capacity'    => '消费能力',
            'photo_address'        => '拍照地',
            'customer_birthday'    => '客户生日',
            'customer_idtype'      => '客户证件类型',
            'customer_idnumber'    => '客户证件号',
            'mate_birthday'        => '配偶生日',
            'mate_idtype'          => '配偶证件类型',
            'mate_idnumber'        => '配偶证件号码',
            'wedding_date'         => '结婚日期',
            'fp_staff'             => '分配人员',
            'fp_time_out'          => '待接收客资超时时间',
            'sales_staff'          => '追踪人员',
            'yjd_day'              => '预约进店日期',
            'syjd_day'             => '实际进店日期',
            'yp_day'               => '预拍日期',
            'order_day'            => '成交订单日期',
            'totalpay_money'       => '消费金额',
            'order_number'         => '订单单号',
            'step_name'            => '追踪阶段名称',
            'c_star_day'           => '客资追踪开始日期',
            'c_end_day'            => '客资追踪结束日期',
            'last_trackday'        => '最后一次追踪日期',
            'creator_day'          => '创建日期',
            'seles_error_reason'   => '追踪失败原因',
            'customer_remark'      => '客户备注',
            'photo_day'            => '实际拍照日期',
            'sel_day'              => '筛客日期',
            'sign_name'            => '客资标记',
            'tel_visit_num'        => '电访量',
            'loss_cause'           => '流失原因',
            'sk_staff'             => '筛客人姓名',
            'sk_time'              => '筛客时间',
            'tel_staff'            => '手机号录入者名字',
            'tel_time'             => '录入手机号时间',
            'is_already_sk'        => '是否已经筛客，1是2否',
            'is_first_tel'         => '第一次录入是否有手机号',
            'channel_plan_number'  => '渠道计划编号',
            'customer_key'         => '客资搜索关键词',
            'intostore_note'       => '进店备注',
            'ready_baby_day'       => '预产期',
            'baby_birthday'        => '宝宝生日',
            'baby_address'         => '宝宝出生地',
            'marry_day'            => '结婚日期',
            'record_img'           => '聊天记录图片',
            'track_record'         => '最近三条追踪记录',
            'budget'               => '预算',
            'fact_money'           => '实际收款',
            'order_start_time'     => '订单开始时间',
            'loss_day'             => '流失时间',
        )
    );
    return $return[$table][$key];
}

//导入模板表头对应的表字段
function import_header(){
    $title=array(
        'customer_name'=>'客户姓名',
        'customer_sex'=>'性别',
        'customer_tel'=>'手机号',
        'customer_wechat'=>'微信',
        'customer_weibo'=>'微博',
        'customer_qq'=>'QQ',
        'province'=>'省',
        'city'=>'市',
        'county'=>'区',
        'customer_address'=>'详细地址',
        'customer_type'=>'客户类型',
        'customer_channel'=>'客户渠道',
        'access_model'=>'获取方式',
        'consultation_type'=>'消费类型',
        'customer_cource'=>'客户来源',
        'customer_area'=>'客户分区',
        'customer_intention'=>'客户意向',
        'consulation_shop'=>'意向店面',
        'customer_orderaddress'=>'接单点',
        'sales_staff'=>'追踪人',
        //'customer_region'=>'客户地域'
    );
    return $title;
}

//下载导入excel模板
function template_header(){
    $title=array('客户姓名','性别','手机号','微信','QQ','微博','省','市','区','详细地址','客户类型','客户渠道','获取方式','消费类型','客户来源','客户分区','客户意向','意向店面','接单点','追踪人');
    return $title;
}

//导出excel模板表头
function export_header(){
    $title=array(
        '客户渠道', '客资标记','是否有效','追踪标记','编号', '姓名', '性别', '手机号', '微信', '微博', 'QQ','城市','婚期','预算','意向店面', '预约进店时间', '预计进店时间','追踪记录','是否进店', '进店时间', '是否成交','订单时间','订单金额','流失原因','客户类型','登记日期','获取日期','是否分配', '是否流失', '登记人','追踪人','筛客人','老顾客姓名','老顾客电话','老顾客单号','老客资类型','电访量','最后追踪时间', '消费类型', '客户来源', '客户意向','获取方式', '接单点', '客户分区','品牌','归属店','提报店'
    );
    return $title;
}



//导出excel模板表头--无效原因
function exportInvalid(){
    $title=array(
        '日期', '编号', '男姓名','男电话','女姓名','女电话','无效原因'
    );
    return $title;
}

/**
 * 字符串截取，支持中文和其他编码
 * @static
 * @access public
 * @param string $str 需要转换的字符串
 * @param string $start 开始位置
 * @param string $length 截取长度
 * @param string $charset 编码格式
 * @param string $suffix 截断显示字符
 * @return string
 */
function msubstr($str, $start=0, $length, $charset="utf-8", $suffix=true) {
    if(function_exists("mb_substr"))
        $slice = mb_substr($str, $start, $length, $charset);
    elseif(function_exists('iconv_substr')) {
        $slice = iconv_substr($str,$start,$length,$charset);
    }else{
        $re['utf-8']   = "/[\x01-\x7f]|[\xc2-\xdf][\x80-\xbf]|[\xe0-\xef][\x80-\xbf]{2}|[\xf0-\xff][\x80-\xbf]{3}/";
        $re['gb2312'] = "/[\x01-\x7f]|[\xb0-\xf7][\xa0-\xfe]/";
        $re['gbk']    = "/[\x01-\x7f]|[\x81-\xfe][\x40-\xfe]/";
        $re['big5']   = "/[\x01-\x7f]|[\x81-\xfe]([\x40-\x7e]|\xa1-\xfe])/";
        preg_match_all($re[$charset], $str, $match);
        $slice = join("",array_slice($match[0], $start, $length));
    }

    return ($suffix && (mb_strlen($str,$charset) > $length)) ? $slice.'...' : $slice;
}

// 排序根据二维数组的某个字段排序 
// SORT_DESC 降序；SORT_ASC 升序  SORT_NUMERIC数字顺序  SORT_STRING 字母顺序
function my_sort($arrays,$sort_key,$sort_order=SORT_ASC,$sort_type=SORT_NUMERIC ){
    if ($sort_order == 'SORT_DESC') {
        $sort_order = SORT_DESC;
    }else{
        $sort_order = SORT_ASC;
    }
    if ($sort_type == 'SORT_STRING') {
        $sort_type = SORT_STRING;
    }else{
        $sort_type = SORT_NUMERIC;
    }
    if(is_array($arrays)){
        foreach ($arrays as $array){
            if(is_array($array)){
                $key_arrays[] = $array[$sort_key];
            }else{
                return false;
            }
        }
    }else{
        return false;
    }
    array_multisort($key_arrays,$sort_order,$sort_type,$arrays);
    return $arrays;
}

/**
 * 获取或更新数据库配置键对应的值。
 * 
 * @param type $key
 * @param type $value
 * @return boolean
 */
function db_config($key,$value) {
    $cacheKey = 'db_config_'.$key;
    if(is_null($value)){
        if(cache('?'.$cacheKey)){
            return cache($cacheKey);
        }else{
            $value = db('c_sysconfig')->where('ckey',$key)->value('cvalue');
            if(!is_null( $value ) ){
                cache($cacheKey,$value);
            }
            return $value;
        }
        
        
    }else{
        db()->startTrans();
        $count = db('c_sysconfig')->where('ckey',$key)->count();
        if($count>0){
            $res = db('c_sysconfig')->where('ckey',$key)->update(array('cvalue'=>$value));
        }else{
            $res = db('c_sysconfig')->insert(array('ckey'=>$key,'cvalue'=>$value));
        }
        if($res === false){
            db()->rollback();
            return false;
        }else{
            db()->commit();
            cache($cacheKey,null);
            return true;
        }
        
    }
}
//根据staff_id获取cache里的用户信息
function getStaffInfoById($staff_id){
    if(!empty(cache('KF_staffInfo_'.$staff_id))) {
        return cache('KF_staffInfo_'.$staff_id);
    }else{
        $res = controller('crm/Customer','lib')->get_staff_info(array('staff_id'=>$staff_id));
        return $res['data'];
    }
}

// 根据时间获取对应的表明，c_hour_number，c_day_number
function getTable($day){
    $date = date('Ymd');
    $temp = date('Ymd', strtotime($day));
    if ($date == $temp) {
        // 时间表
        $return['table'] = 'c_hour_number';
        $return['useDay'] = date('YmdH', strtotime($day));
    }else{
        // 日期表
        $return['table'] = 'c_day_number';
        $return['useDay'] = date('Y-m-d', strtotime($day));
    }
    return $return;
}

/**
 * 把返回的数据集转换成Tree
 * @param $list
 * @param string $pk
 * @param string $pid
 * @param string $child
 * @param string $root
 * @return array
 */
function listToTree($list, $pk='id', $pid = 'fid', $child = '_child', $root = '0') {
    $tree = array();
    if(is_array($list)) {
        $refer = array();
        foreach ($list as $key => $data) {
            $refer[$data[$pk]] = &$list[$key];
        }
        foreach ($list as $key => $data) {
            $parentId =  $data[$pid];
            if ($root == $parentId) {
                $tree[] = &$list[$key];
            }else{
                if (isset($refer[$parentId])) {
                    $parent = &$refer[$parentId];
                    $parent[$child][] = &$list[$key];
                }
            }
        }
    }
    return $tree;
}

function formatTree($list, $lv = 0, $title = 'menu_name'){
    $formatTree = array();
    foreach($list as $key => $val){
        $title_prefix = '';
        for( $i=0;$i<$lv;$i++ ){
            $title_prefix .= "|---";
        }
        $val['lv'] = $lv;
        $val['namePrefix'] = $lv == 0 ? '' : $title_prefix;
        $val['showName'] = $lv == 0 ? $val[$title] : $title_prefix.$val[$title];
        if(!array_key_exists('_child', $val)){
            array_push($formatTree, $val);
        }else{
            $child = $val['_child'];
            unset($val['_child']);
            array_push($formatTree, $val);
            $middle = formatTree($child, $lv+1, $title); //进行下一层递归
            $formatTree = array_merge($formatTree, $middle);
        }
    }
    return $formatTree;
}

/*
 * 将数据递归处理
 *  @param array $list
 *  @param string $fid
 */
function treeData($list,$fid){
    $tree = array();
    foreach($list as $k=>$row) {
        if($row['fid'] == $fid) {
            $currentMenuUrl = '/'.request()->module().'/'.request()->controller().'/'.request()->action();
            if(strpos(strtolower($row['menu_url']),strtolower($currentMenuUrl)) !== false){
                $row['active'] = 1;
            }else{
                $row['active'] = 0;
            }
            $row['children'] = treeData($list, $row['id']);
            $tree[] = $row;
        }
    }
    return $tree;
}
function treeData1($list,$pid){
    $tree = array();
    foreach($list as $row) {
        if($row['pid'] == $pid) {
            $row['children'] = treeData($list, $row['id']);
            $tree[] = $row;
        }
    }
    return $tree;
}

//检测是否是管理员
function isAdministrator(){
    $main_work_type = (int)session('main_work_type');
    $work_type      = session('work_type');

    $allWorkType = explode(',',trim($main_work_type.','.$work_type,','));
    if(in_array(SYSTEM_AUTH_ADMIN,$allWorkType)){
        return true;
    }else{
        return false;
    }
}

//获取登录人左侧菜单信息
function getAuth($type){

    $menuAllS=cache('KF_menuAllS');
    if(!$menuAllS){
        $menuAllS=db('s_menu')->order('sort asc')->select();
        cache('KF_menuAllS',$menuAllS);
    }

    if($type=='menu'){
        $menuList=[];
        foreach($menuAllS as $k => $v){
            if($v['status']==1){
                $menuList[]=$v;
            }
        }
    }elseif($type=='auth'){
        $menuList=$menuAllS;
    }

    $work_type=explode(',',trim(session('main_work_type').','.session('work_type'),','));
    if(in_array(SYSTEM_AUTH_ADMIN,$work_type)){
        return $menuList;
    }else{
        $position_code=array_unique(explode(',',trim(session('main_position_code').','.session('position_code'),',')));
        $menuAll=array();
        foreach($position_code as $k => $v){
            //取这个岗位的所有MENU 逗号分隔的menu code
            $menu=cache('KF_menu_'.$position_code[$k]);
            if(!$menu){
                $data=db('s_position_menu')->where('position_code',$position_code[$k])->find();
                $menu=$data['menu_code'];
                cache('KF_menu_'.$position_code[$k], $menu);
            }

            array_push($menuAll,$menu);
        }
        //去重
        $menuAll=array_unique(explode(',',implode(',',$menuAll)));
        //取所有menu的详细信息
        foreach ($menuList as $k=>$menuInfo){
            if(!in_array($menuInfo['menu_code'], $menuAll)){
                unset($menuList[$k]);
            }
        }

        return $menuList;
    }
}


//判断是否安装某应用
function is_install($name){
    $all = config('ext.app_config');
    if(empty($all[$name])){
        return false;
    }else{
        $is_at = db_config($name.'_'.session('brandclass_id'));
        if($is_at){
            return true;
        }else{
            return false;
        }
    }
}
function ajax_return($data,$code = 200,$msg = ""){
    
    $ret = [
      'code'=>$code,
      'msg'=>$msg,
      'data'=>$data,
    ];
    return json($ret);
}
/**
 * 返回系统版本号，支持模块版本，和应用版本
 * 在application下的config.php配置的APP_VERSION版本号，为应用版本号
 * 在application/模块/config.php配置的MODULE_VERSION为模块版本号
 * 
 * @param type $type 版本类型，默认app
 * @return type
 */
function get_version($type ='') {
    $module = \think\Request::instance()->module();
    if(empty($type)){
        return strtolower($module) == 'index'?APP_VERSION:config('MODULE_VERSION');
    }else{
        if(strtolower($module) == 'index'){
            return APP_VERSION;
        }else{
            return strtolower($type) == 'app'?APP_VERSION:config('MODULE_VERSION');
        }
    }
}

function check_right($code){
    //判断是否有权限
    $auth=getAuth($type='auth');
    if(in_array($code,array_column($auth,'menu_code'))){
        return true;
    }else{
        return false;
    }
}
///判断是PC还是微信登录
function is_weixin(){
    if ( strpos($_SERVER['HTTP_USER_AGENT'],'MicroMessenger') !== false ) {
        return true;
    }else{
        return false;
    }
}
/**
 * 求两个日期之间相差的天数
 * (针对1970年1月1日之后，求之前可以采用泰勒公式)
 * @param string $day1
 * @param string $day2
 * @return number
 */
function diffBetweenTwoDays ($day1, $day2)
{
    $second1 = strtotime($day1);
    $second2 = strtotime($day2);

    if ($second1 < $second2) {
        $tmp = $second2;
        $second2 = $second1;
        $second1 = $tmp;
    }
    return ($second1 - $second2) / 86400;
}


/**
 * 队列中需要记录日志时，调用此方法
 * @param Mix $data           本次要记录的日志数据
 * @param Mix $oldData        修改前的数据
 * @param Int $customerId     当前操作的客户ID。
 * @param Int $staffId        当前登录员工ID，默认取session内的staff_id,针对API记录，需要手动传入。
 * @param Int $staffName      当前登录员工姓名
 * @param String $module      操作的模块，默认取当前请求的应用模块
 * @param String $controller  操作的控制器，默认取当前请求的控制器
 * @param String $action      操作的方法，默认取当前请求的方法
 */
function history_log($data,$oldData,$customerId,$staffId,$staffName,$module,$controller,$action,$ip,$create_time){
    if(!$module){
        $module = \think\Request::instance()->module();
    }
    if(!$controller){
        $controller = \think\Request::instance()->controller();
    }
    if(!$action){
        $action = \think\Request::instance()->action();
    }
    if(!$ip){
        $ip = \think\Request::instance()->ip();
    }
    if(!is_string($data)){
        $data = json_encode($data);
    }
    if(!is_string($oldData)){
        $oldData = json_encode($oldData);
    }
    if (!$create_time) {
        $create_time = date('Y-m-d H:i:s');
    }
    $logData = [
        'module'     => $module,
        'controller' => $controller,
        'action'     => $action,
        'old_data'   => $oldData,
        'data'       => $data,
        'customer_id'=> $customerId,
        'staff_name' => $staffName,
        'staff_id'   => $staffId,
        'ip'         => $ip,
        'create_time'=> $create_time,
    ];
    db()->startTrans();
    try {
        db('action_log','db_logs')->insert($logData);
        db()->commit();
    } catch (Exception $e) {
        db()->rollback();
        \think\Log::error('日志保存错误:module:'.$module.';controller:'.$controller.';action:'.$action.';data:'.$data.';olddata:'.$oldData.';customerid:'.$customerId);
    }
}
//ip138查询手机归属地
function getData($mobile){
    $token = db_config('sx_secret_key_'.session('shop_code'));
//    $token = config('IP138_API');
    $datatype = 'txt';
    $url = 'http://api.ip138.com/mobile/?mobile='.$mobile.'&datatype='.$datatype;
    $header = array('token:'.$token);
    $ch = curl_init();
    curl_setopt($ch,CURLOPT_URL,$url);
    curl_setopt($ch,CURLOPT_HTTP_VERSION,CURL_HTTP_VERSION_1_1);
    curl_setopt($ch,CURLOPT_HTTPHEADER,$header);
    curl_setopt($ch,CURLOPT_RETURNTRANSFER,1);
    curl_setopt($ch,CURLOPT_CONNECTTIMEOUT,3);
    $handles = curl_exec($ch);
    curl_close($ch);
    return $handles;
}
//百度地图：通过ip获取城市
function getCityByIp($ip){
    $ak = config('BAIDU_API');
    $url = "http://api.map.baidu.com/location/ip?ak=".$ak."&ip=$ip&coor=bd09ll";
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    $output = curl_exec($ch);
    if(curl_errno($ch)){
        echo 'CURL ERROR Code: '.curl_errno($ch).', reason: '.curl_error($ch);
    }
    curl_close($ch);
    $city_info = json_decode($output, true);
    if($city_info['status'] == "0"){
       // $citytemp = $city_info['content']['address_detail']['city'];
       // $keywords = explode("市",$citytemp);
       // $city = iconv('utf-8','gbk',$keywords[0]);
        return $city_info['content']['address'];
    }else{
        return false;
    }
}
/**
 * 读取文件前几个字节 判断文件类型
 * @return String
 */
function checkFileType($filename){
    $file=fopen($filename, "rb");
    $bin=fread($file, 2); //只读2字节
    fclose($file);
    $strInfo =@unpack("c2chars", $bin);
    $typeCode=intval($strInfo['chars1'].$strInfo['chars2']);
    $fileType='';
    switch($typeCode){
        case 7790:
            $fileType='exe';
            break;
        case 7784:
            $fileType='midi';
            break;
        case 8297:
            $fileType='rar';
            break;
        case 255216:
            $fileType='jpg';
            break;
        case 7173:
            $fileType='gif';
            break;
        case 6677:
            $fileType='bmp';
            break;
        case 13780:
            $fileType='png';
            break;
        case 8273:
            $fileType='wav';
            break;
        default:
            $fileType='unknown'.$typeCode;
            break;
    }
    //Fix
    if($strInfo['chars1']=='-1' && $strInfo['chars2']=='-40'){
        return 'jpg';
    }
    if($strInfo['chars1']=='-119' && $strInfo['chars2']=='80'){
        return 'png';
    }
    return $fileType;
}

function requestERP($url,$content){
    //print_r($url);die;
    $time      = time();
    $nonce     = rand(99999,999999);
    $signature = md5($time.$nonce.'oUWKYeqCEojOvbmsynvWTctJSAVeoMZv');
    $header    = array('timestamp:'.$time,'nonce:'.$nonce,'signature:'.$signature);
    $header[] = 'Content-Type: application/json; charset=utf-8';
    $header[] = 'Content-Length: ' . strlen($content);
    $a = http_request($url,'POST', $content,$header);
    $b = json_decode($a['response'], true);
    return $b;
}


/**
 * 编号+1
 *  @param String  $my_number 编号
 * @author {wangyining}<{wangyining@suxuantech.cn}>  $
 */
function get_number($my_number){

    if(eregi("^[0-9]+$",$my_number)) {//纯数字
        if(strlen((int)$my_number+1)<strlen($my_number)){
            $count = str_pad((int)$my_number + 1, strlen($my_number), '0', STR_PAD_LEFT);
        }elseif(strlen((int)$my_number+1)>=strlen($my_number)){
            $count=(int)$my_number+1;
        }
        $number=$count;
    }else{//字母加数字

        $array=$this->check_array($my_number);
        $sort_array=array_reverse($array);

        for($i=0;$i<count($sort_array);$i++){
            if(!eregi("^[0-9]+$",$sort_array[$i])){
                $point=$i;
                break;
            }
        }
        $lenth=strlen($my_number);
        $str=substr($my_number,0,(int)$lenth - $point);
        $num=substr($my_number,-$point);
        if(strlen($num+1)<strlen($num)){
            $count = str_pad($num + 1, strlen($num), '0', STR_PAD_LEFT);
        }elseif(strlen($num+1)>=strlen($num)){
            $count=$num+1;
        }
        $number=$str.$count;
    }
    return $number;
}

//生成指定长度随机数
function generate_code($length = 4) {
    return rand(pow(10,($length-1)), pow(10,$length)-1);
}

/**
 * $msg 待提示的消息
 * $url 待跳转的链接
 * $time 弹出维持时间（单位秒）
 */
function alert($msg='',$url='',$time=3)
{
    $str = '<script type="text/javascript" src="/public/js/jquery-1.7.1.min.js"></script><script type="text/javascript" src="/public/item/layui.all.js"></script></script>';//加载jquery和layer
    $str .= '<script>$(function(){layer.alert("' . $msg . '");setTimeout(function(){self.location.href="' . $url . '"},2000)});</script>';//主要方法
    echo $str;
}

// 根据月份获取当前月份的每一天 默认当前月份
function getMonthDays($month = "this month", $format = "Y-m-d", $dateTimeZone = false) {
    if(!$dateTimeZone) $dateTimeZone = new DateTimeZone("Asia/Shanghai");
    $start = new DateTime("first day of $month", $dateTimeZone);
    $end = new DateTime("last day of $month", $dateTimeZone);

    $days = array();
    for($time = $start; $time <= $end; $time = $time->modify("+1 day")) {
        $days[] = $time->format($format);
    }
    return $days;
}
//获取星期方法
function get_week($date){
    //强制转换日期格式
    $date_str=date('Y-m-d',strtotime($date));
    //封装成数组
    $arr=explode("-", $date_str);
    //参数赋值
    //年
    $year=$arr[0];
    //月，输出2位整型，不够2位右对齐
    $month=sprintf('%02d',$arr[1]);
    //日，输出2位整型，不够2位右对齐
    $day=sprintf('%02d',$arr[2]);
    //时分秒默认赋值为0；
    $hour = $minute = $second = 0;
    //转换成时间戳
    $strap = mktime($hour,$minute,$second,$month,$day,$year);
    //获取数字型星期几
    $number_wk=date("w",$strap);
    //自定义星期数组
    $weekArr=array("星期日","星期一","星期二","星期三","星期四","星期五","星期六");
    //获取数字对应的星期
    return $weekArr[$number_wk];
}

/**验证手机号格式
 * $tel 手机号
 */
function check_tel($tel){
    $preg_tel='/^1[3|4|5|6|7|8|9][0-9]{9}$/';
    if(preg_match($preg_tel,$tel)){
        return true;
    }else{
        return false;
    }
}

/**
 * 获取当前配置内，上传文件的最大限制
 *
 * @return type
 */
function getMaxUploadSize(){

    $scan['gb'] = 1073741824; //1024 * 1024 * 1024;
    $scan['g']  = 1073741824; //1024 * 1024 * 1024;
    $scan['mb'] = 1048576;
    $scan['m']  = 1048576;
    $scan['kb'] =    1024;
    $scan['k']  =    1024;
    $scan['b']  =       1;
    $upSize = strtolower(ini_get('upload_max_filesize'));
    $upSizeC = str_replace(intval($upSize) . '','',$upSize);
    $upSizeN = $scan[$upSizeC] * intval($upSize);
    $postSize = strtolower(ini_get('post_max_size'));
    $postSizeC = str_replace(intval($postSize) . '','',$postSize);
    $postSizeN = $scan[$postSizeC] * intval($postSize);

    $limit = $postSizeN>$upSizeN?$upSize:$postSize;

    return $limit;
    // $upSize = $scan[strtolower(ini_get('upload_max_filesize'))] ;

    // return ini_get('upload_max_filesize');

}

/**
 * 将截图粘贴到文本编辑器内的带BASE64的图片内容中的图片存为文件，返回可用于显示的内容。
 * 
 * @param  String $string 提交的编辑器内容，带bese64图片内容的文本内容
 * @param  String $path   图片保存目录，相对于网站访问跟目录的图片路径，默认pic目录下
 * @param  String $prefix 服务端路径前缀，与path变量组成可访问文件的绝对路径，默认ROOT_PATH/public/下
 * @return String         返回替换完后的内容。
 */
function save_clips_to_file($string,$path='',$prefix=''){
    if(!$string){return '';}
    $prefix = $prefix?$prefix:ROOT_PATH.DS.'public'.DS;
    $prefix = substr($prefix,-1) != DS?$prefix.DS:$prefix;
    $path = $path?$path:'pic'.DS;
    $path = trim($path,DS).DS;//拼路径时，去掉前面的路径分隔符，后面替换时，再加上。
    preg_match_all('/<img.*?src=\"(.*?)\"/i', $string, $mat);
    //var_dump($mat);
    foreach($mat[1] as $k=>$src){
        if(substr($src,0,4) == 'data'){
            //是data类型的图片地址
            $fileType = '.'.substr($src,strpos($src,'/')+1, strpos($src,';') - strpos($src,'/') - 1);
            $fileName = md5($src).$fileType;
            unset($fileType);
            $preDir = substr($fileName,0,2);
            //*//
            if(!file_exists($prefix.$path.$preDir)){
                $mkres = @mkdir($prefix.$path.$preDir,0777,true);
                if(!$mkres){
                    return false;
                }
            }//*/
            $fileName = $preDir.DS.$fileName;
            unset($preDir,$mkres);
            $content = base64_decode(substr($src, strpos($src,'base64,') +7 ));
            //echo $content;exit();
           if($content){
                //解压成功，则存文件，否则不处理。
                $save = @file_put_contents($prefix.$path.$fileName,$content);
                if(!$save){
                    return false;
                }
                //将文件路径转为URL可显示路径，解决WINDOWS的路径分隔符问题
                $saveFile = '/'.str_replace('\\', '/', $path.$fileName);
                $string = str_replace($src, $saveFile, $string);
            }
            unset($src,$fileName,$content,$save);
        }
    }
    return $string;
}
//客资是否有效获取器
function getIsValidAttr($key){
    $valid = [1=>'是',2=>'待定',3=>'否',4=>'被驳回'];
    return $valid[$key] ? $valid[$key] : '待定';
}
//客资是否进店获取器
function getIsIntostore($key){
    $into = [1=>'未进店',2=>'进店进客',3=>'进店非进客',4=>'邀约未进客'];
    return $into[$key] ? $into[$key] : '未进店';
}
//客资是否成交获取器
function getIsSuccess($key){
    $succ = [1=>'已成交',2=>'未成交',3=>'已定金'];
    return $succ[$key] ? $succ[$key] : '未成交';
}
//客资是否分配获取器
function getIsFP($key){
    $fp = [1=>'已分配',2=>'未分配',3=>'待接收',4=>'分配失败'];
    return $fp[$key] ? $fp[$key] : '未分配';
}
//客资是否分配获取器
function getIsValid($key){
    $fp = [1=>'有效',2=>'待定',3=>'无效',4=>'驳回'];
    return $fp[$key] ? $fp[$key] : '待定';
}
//客资是否流失获取器
function getIsLoss($key){
    $fp = [1=>'已流失',2=>'未流失'];
    return $fp[$key] ? $fp[$key] : '未流失';
}
//客资提报类型获取器
function getIntroducerType($key){
    $fp = [1=>'新客',2=>'现客',3=>'老客'];
    return $fp[$key] ? $fp[$key] : '新客';
}
//电访结果获取器
function getTelResult($key){
    $tel = [1=>'接通',2=>'未接通',3=>'空号','4'=>'不是本人'];
    return $tel[$key] ? $tel[$key] : '接通';
}

//去除提交的table相关标签
function DeleteHtml($str)
{
//    return strip_tags($str);//用这个会把img标签去掉，图片不显示
//    $str=preg_replace("/\s+/"," ", $str);//过滤多余回车
//    $str=preg_replace("/<[]+/si","<",$str);//过滤<__("<"号后面带空格)
//    $str=preg_replace("/<\!--.*?-->/si","",$str);//注释
    $str=preg_replace("/<(\!.*?)>/si"," ",$str);//过滤DOCTYPE
    $str=preg_replace("/<(html.*?)>/si"," ",$str);//过滤html标签
    $str=preg_replace("/<(\/?html.*?)>/si"," ",$str);//过滤html标签
    $str=preg_replace("/<(head.*?)>/si"," ",$str);//过滤head标签
    $str=preg_replace("/<(\/?head.*?)>/si"," ",$str);//过滤head标签
    $str=preg_replace("/<(meta.*?)>/si"," ",$str);//过滤meta标签
    $str=preg_replace("/<(\/?meta.*?)>/si"," ",$str);//过滤meta标签
    $str=preg_replace("/<(body.*?)>/si"," ",$str);//过滤body标签
    $str=preg_replace("/<(\/?body.*?)>/si"," ",$str);//过滤body标签
    $str=preg_replace("/<(link.*?)>/si"," ",$str);//过滤link标签
    $str=preg_replace("/<(\/?link.*?)>/si"," ",$str);//过滤link标签
    $str=preg_replace("/<(form.*?)>/si"," ",$str);//过滤form标签
    $str=preg_replace("/<(\/?form.*?)>/si"," ",$str);//过滤form标签

    $str=preg_replace("/<(table.*?)>/si"," ",$str);//过滤table标签
    $str=preg_replace("/<(\/?table.*?)>/si"," ",$str);//过滤table标签
    $str=preg_replace("/<(thead.*?)>/si"," ",$str);//过滤tbody标签
    $str=preg_replace("/<(\/?thead.*?)>/si"," ",$str);//过滤tbody标签
    $str=preg_replace("/<(tbody.*?)>/si"," ",$str);//过滤tbody标签
    $str=preg_replace("/<(\/?tbody.*?)>/si"," ",$str);//过滤tbody标签
    $str=preg_replace("/<(tr.*?)>/si"," ",$str);//过滤tr标签
    $str=preg_replace("/<(\/?tr.*?)>/si"," ",$str);//过滤tr标签
    $str=preg_replace("/<(a.*?)>/si"," ",$str);//过滤a标签
    $str=preg_replace("/<(\/?a.*?)>/si"," ",$str);//过滤a标签
    $str=preg_replace("/<(br.*?)>/si"," ",$str);//过滤br标签
    $str=preg_replace("/<(\/?button.*?)>/si"," ",$str);//过滤th标签
    $str=preg_replace("/<(button.*?)>/si"," ",$str);//过滤th标签
    $str=preg_replace("/<(\/?datalist.*?)>/si"," ",$str);//过滤datalist标签
    $str=preg_replace("/<(datalist.*?)>/si"," ",$str);//过滤datalist标签
    $str=preg_replace("/<(th.*?)>/si"," ",$str);//过滤th标签
    $str=preg_replace("/<(\/?th.*?)>/si"," ",$str);//过滤th标签
    $str=preg_replace("/<(caption.*?)>/si"," ",$str);//过滤caption标签
    $str=preg_replace("/<(\/?caption.*?)>/si"," ",$str);//过滤caption标签
    $str=preg_replace("/<(iframe.*?)>/si"," ",$str);//过滤iframe标签
    $str=preg_replace("/<(\/?iframe.*?)>/si"," ",$str);//过滤iframe标签
    $str=preg_replace("/<(td.*?)>/si"," ",$str);//过滤td标签
    $str=preg_replace("/<(\/?td.*?)>/si"," ",$str);//过滤td标签
    $str=preg_replace("/<(colgroup.*?)>/si"," ",$str);//过滤colgroup标签
    $str=preg_replace("/<(\/?colgroup.*?)>/si"," ",$str);//过滤colgroup标签
    $str=preg_replace("/<(col.*?)>/si"," ",$str);//过滤col标签
    $str=preg_replace("/<(\/?col.*?)>/si"," ",$str);//过滤col标签
    $str=preg_replace("/<(ul.*?)>/si"," ",$str);//过滤ul标签
    $str=preg_replace("/<(\/?ul.*?)>/si"," ",$str);//过滤ul标签
    $str=preg_replace("/<(li.*?)>/si"," ",$str);//过滤li标签
    $str=preg_replace("/<(\/?li.*?)>/si"," ",$str);//过滤li标签
    $str=preg_replace("/<(dd.*?)>/si"," ",$str);//过滤dd标签
    $str=preg_replace("/<(\/?dd.*?)>/si"," ",$str);//过滤dd标签
    $str=preg_replace("/<(dt.*?)>/si"," ",$str);//过滤dt标签
    $str=preg_replace("/<(\/?dt.*?)>/si"," ",$str);//过滤dt标签
    $str=preg_replace("/<(dialog.*?)>/si"," ",$str);//过滤dialog标签
    $str=preg_replace("/<(\/?dialog.*?)>/si"," ",$str);//过滤dialog标签
    $str=preg_replace("/<(fieldset.*?)>/si"," ",$str);//过滤fieldset标签
    $str=preg_replace("/<(\/?fieldset.*?)>/si"," ",$str);//过滤fieldset标签
    $str=preg_replace("/<(input.*?)>/si"," ",$str);//过滤input标签
    $str=preg_replace("/<(script.*?)>(.*?)<(\/script.*?)>/si"," ",$str);//过滤script标签
    $str=preg_replace("/<(\/?script.*?)>/si"," ",$str);//过滤script标签
    $str=preg_replace("/javascript/si","Javascript",$str);//过滤script标签
    $str=preg_replace("/<(title.*?)>(.*?)<(\/title.*?)>/si"," ",$str);//过滤title标签
    $str=preg_replace("/<(\/?title.*?)>/si"," ",$str);//过滤title标签
//    $str=preg_replace("/<(applet.*?)>(.*?)<(\/applet.*?)>/si","",$str);//过滤applet标签
//    $str=preg_replace("/<(\/?applet.*?)>/si","",$str);//过滤applet标签
//    $str=preg_replace("/<(style.*?)>(.*?)<(\/style.*?)>/si","",$str);//过滤style标签
//    $str=preg_replace("/<(\/?style.*?)>/si","",$str);//过滤style标签
//    $str=preg_replace("/<(title.*?)>(.*?)<(\/title.*?)>/si","",$str);//过滤title标签
//    $str=preg_replace("/<(\/?title.*?)>/si","",$str);//过滤title标签
//    $str=preg_replace("/<(object.*?)>(.*?)<(\/object.*?)>/si","",$str);//过滤object标签
//    $str=preg_replace("/<(\/?objec.*?)>/si","",$str);//过滤object标签
//    $str=preg_replace("/<(noframes.*?)>(.*?)<(\/noframes.*?)>/si","",$str);//过滤noframes标签
//    $str=preg_replace("/<(\/?noframes.*?)>/si","",$str);//过滤noframes标签
//    $str=preg_replace("/<(i?frame.*?)>(.*?)<(\/i?frame.*?)>/si","",$str);//过滤frame标签
//    $str=preg_replace("/<(\/?i?frame.*?)>/si","",$str);//过滤frame标签
//    $str=preg_replace("/<(script.*?)>(.*?)<(\/script.*?)>/si","",$str);//过滤script标签
//    $str=preg_replace("/<(\/?script.*?)>/si","",$str);//过滤script标签
//    $str=preg_replace("/javascript/si","Javascript",$str);//过滤script标签
//    $str=preg_replace("/vbscript/si","Vbscript",$str);//过滤script标签
//    $str=preg_replace("/on([a-z]+)\s*=/si","On\\1=",$str);//过滤script标签
//    $str=preg_replace("/&#/si","&＃",$str);//过滤script标签，如javAsCript:alert
    return trim($str); //返回字符串
}

//修改客资表近三次追踪记录
function getSalesTracking($customer_id){

    $track=db('CSalestrackinginfo')
        ->where('customer_id',$customer_id)
        ->order('sales_day desc')
        ->limit(3)
        ->field('sales_day, sales_remark')
        ->master()
        ->select();
    $str="";
    foreach($track as $k => $v){
        $day = date('Y-m-d H:i', strtotime($v['sales_day']));
        $remark = preg_replace('/<\s*img\s+[^>]*?src\s*=\s*(\'|\")(.*?)\\1[^>]*?\/?\s*>/i', '', $v['sales_remark']);
        if(!$remark) $remark='未填写备注';
        if(strpos($remark,'驳回') !== false){//反驳回时标红
            $remark = '<font style="color: red">'.$remark.'</font>';
        }
        $str .='<font color="#ffffff" style="background-color:#8391a5;border-radius: 3px;padding: 2px 4px;
width: 100px;display: inline-block;margin: 1px 0;text-align: center;">'.$day.'</font>&nbsp;'.$remark."<br/>";
    }
    db('c_customerinfo')->where('id',$customer_id)->update(array('track_record'=>$str));
}
//不跨月获取本周开始时间
function getWeekStartTimeNotFrontMonth(){
    $month = date('m');//当前月份
    $startTime = date('Y-m-d', strtotime("this week Monday", time()));//本周开始时间
    for($i=1;$i<=7;$i++){
        if ($month == date('m',strtotime($startTime))) {
            break;
        }
        $startTime = date('Y-m-d', strtotime($startTime)+$i*86400);
    }
    return $startTime;
}
// 两个日期之间的所有日期
function getDates($start,$end){
    $dt_start = strtotime($start);
    $dt_end = strtotime($end);
    $arr = [];
    while ($dt_start<$dt_end){
        array_push($arr,date('Y-m-d',$dt_start));
        $dt_start = strtotime('+1 day',$dt_start);
    }
    return $arr;
}


/**
 * 获取当前应用的域名，配置于环境变量内。
 * @return domain 域名
 */
function getDomain(){

    $url = $_SERVER['HTTP_HOST'];
    $matches = parse_url(trim($url));
    $scheme = empty($matches['scheme'])?'http://':'';
    return $scheme.$url;
}


/*
* 客诉工单号
*/
function getWorkNumber($brand_id){
    $numberData = cache('KF_work_number');
    if($numberData){
        //$numberData = json_decode($work_number_json,true);
        if($numberData['date']==date('Ymd')){
            $my_number = $numberData['number'];
            if(strlen((int)$my_number+1)<strlen($my_number)){
                $now_number = str_pad((int)$my_number + 1, strlen($my_number), '0', STR_PAD_LEFT);
            }elseif(strlen((int)$my_number+1)>=strlen($my_number)){
                $now_number=(int)$my_number+1;
            }
        }else{
            $now_number = '001';
        }
    }else{
        $now_number = '001';
    }

    cache('KF_work_number',json_encode(array('date'=>date('Ymd'),'number'=>$now_number)));
    $work_number = 'kf'.$brand_id.date('Ymd').$now_number;
    return $work_number;
}

//获取系统设置中 质检对象 1店面，2部门，默认为店面
function getZJObjectType(){
    $sysConfig = db('s_sysconfig')->where('skey','kf')->find();
    $config = json_decode($sysConfig['svalue'],true);
    $object_type = $config['zj_object'];
    if(!$object_type||$object_type==0)  $object_type=1;
    return $object_type;

}

?>