<?php
/**
 * 客资接口入口
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: wzy<wangzhenya@suxuantech.cn> 2018-1-3 $
 */
namespace app\index\api;

use think\Exception;

class Customer{
    /**
     * 开单，添加消费产品，收款操作
     * 开单：新增订单，一销，二销，和总额都是0
     * 添加消费产品：总额不为0，一销二销为0
     * 收款：一销二销其中一个不为0，总额都不为0
     * @param string $param 要加密的字符串
     * $param包含下列字段:
     * diff         1:开单；2：添加消费产品；3：收款
     * create_time          订单创建时间
     * m_tel                男手机号
     * w_tel                女手机号
     * order_sn             订单号
     * order_fact           一销实收
     * order_amount         一销总额
     * two_pin_fact         二销实收
     * two_pin_amount       二销总额
     * brandclass_id        事业部id
     * customer_number      customer_number
     * consultation_type    消费类型
     * shop_code
     * @return array
     */
    public function receivables($param){
        $target_time = $param['create_time'] ? date('Y-m-d H:i:s',strtotime($param['create_time'])) : date('Y-m-d H:i:s',time());
        $param['create_time'] = date('Y-m-d H:i:s',time());
        if($param['diff'] == 1){//开单 一销，二销，和总额都是0
            //判断客资是否存在
            $cusInfoM = controller('index/Customer','lib')->checkCustomer(['brandclass_id'=>$param['brandclass_id'],'shop_code'=>$param['shop_code'],'customer_tel'=>$param['m_tel'],'customer_number'=>$param['customer_number'],'is_in'=>1]);
            if(empty($cusInfoW['status'])){
                $cusInfoW = controller('index/Customer','lib')->checkCustomer(['brandclass_id'=>$param['brandclass_id'],'shop_code'=>$param['shop_code'],'customer_tel'=>$param['w_tel'],'customer_number'=>$param['customer_number'],'is_in'=>1]);
            }
            if(empty($cusInfoM) && empty($contentW)){
                return array('error'=>1,'code'=>110,'msg'=>'开单失败,没有此客资，请先创建客资','data'=>'');
            }
            if($cusInfoM['id'] == $cusInfoW['id']){
                $cusInfo = $cusInfoM;
            }elseif(!empty($cusInfoM['yjd_day']) && !empty($cusInfoW['yjd_day']) && $cusInfoM['yjd_day'] > $cusInfoW['yjd_day']){
                $cusInfo = $cusInfoM;
            }elseif(!empty($cusInfoM['c_end_day']) && !empty($cusInfoW['c_end_day']) && $cusInfoM['c_end_day'] > $cusInfoW['c_end_day']){
                $cusInfo = $cusInfoM;
            }elseif(!empty($cusInfoM['jr_day']) && !empty($cusInfoW['jr_day']) && $cusInfoM['jr_day'] > $cusInfoW['jr_day']){
                $cusInfo = $cusInfoM;
            }elseif(!empty($cusInfoM['creator_day']) && !empty($cusInfoW['creator_day']) && $cusInfoM['creator_day'] > $cusInfoW['creator_day']){
                $cusInfo = $cusInfoM;
            }else{
                $cusInfo = $cusInfoW;
            }

            if ($cusInfoM['id'] != $cusInfoW['id']) {
                $contentM = [
                    'touser'       => $cusInfoM['sales_staff_id'],
                    'template_id'  => OPENTM_CT,
                    'data'         => [
                        'first'=>[
                            'value'=>'您好，您有一笔订单冲突',
                            'color'=>'#173177'
                        ],
                        'keyword1'=>[
                            'value'=>$cusInfoM['customer_name'].'('.$cusInfoM['customer_sex'].')',
                            'color'=>'#173177'
                        ],
                        'keyword2'=>[
                            'value'=>$cusInfoM['customer_tel'],
                            'color'=>'#173177'
                        ],
                        'keyword3'=>[
                            'value'=>'订单冲突',
                            'color'=>'#173177'
                        ],
                        'keyword4'=>[
                            'value'=>$param['create_time'],
                            'color'=>'#173177'
                        ],
                        'remark'=>[
                            'value'=>'请尽快查收，谢谢',
                            'color'=>'#173177'
                        ]
                    ]
                ];
                $send_data['content'] = json_encode($contentM);
                // $res = sendMsg($send_data);
                $contentW = [
                    'touser'       => $cusInfoW['sales_staff_id'],
                    'template_id'  => OPENTM_CT,
                    'data'         => [
                        'first'=>[
                            'value'=>'您好，您有一笔订单冲突',
                            'color'=>'#173177'
                        ],
                        'keyword1'=>[
                            'value'=>$cusInfoW['customer_name'].'('.$cusInfoW['customer_sex'].')',
                            'color'=>'#173177'
                        ],
                        'keyword2'=>[
                            'value'=>$cusInfoW['customer_tel'],
                            'color'=>'#173177'
                        ],
                        'keyword3'=>[
                            'value'=>'订单冲突',
                            'color'=>'#173177'
                        ],
                        'keyword4'=>[
                            'value'=>$param['create_time'],
                            'color'=>'#173177'
                        ],
                        'remark'=>[
                            'value'=>'请尽快查收，谢谢',
                            'color'=>'#173177'
                        ]
                    ]
                ];
                $send_data['content'] = json_encode($contentW);
                // $res = sendMsg($send_data);
            }
            //判断订单是否存在
            $orderInfo = $this->checkOrder(['order_sn'=>$param['order_sn']]);

            db()->startTrans();
            if($orderInfo['error'] == 1){
                $brandclassInfo = controller('index/Customer','lib')->getBrandClassInfo($param['brandclass_id']);
                $arr = array(
                    'order_sn' => $param['order_sn'],
                    'customer_id' => (int)$cusInfo['id'],
                    'customer_name' => $cusInfo['customer_name'],
                    'order_fact' => (float)$param['order_fact'],
                    'order_amount' => (float)$param['order_amount'],
                    'two_pin_fact' => (float)$param['two_pin_fact'],
                    'two_pin_amount' => (float)$param['two_pin_amount'],
                    'target_time' => $target_time,
                    'create_time' => $param['create_time'],
                    'shop_code' => $cusInfo['shop_code'],
                    'shop_name' => $cusInfo['shop_name'],
                    'consultation_type' => $param['consultation_type'],
                    'order_type' => 2,
                    'brandclass_id'=> $param['brandclass_id'],
                    'brandclass'  => $brandclassInfo['brandclass'],
                );
                $ord = controller('index/Customer','lib')->addCustomerOrder($arr);

                if($ord){
                    $cus['id'] = $cusInfo['id'];
                    $cus['totalpay_money'] = $param['order_amount']+$param['two_pin_amount'];
                    $cus['order_number'] = $param['order_sn'];
                    $cus['fact_money'] = $param['order_fact']+$param['two_pin_fact'];
                    $cus['order_start_time'] = date('Y-m-d H:i:s',time());
                    if($cusInfo['is_intostore'] != 2){
                        $cus['is_intostore'] = 2;
                        $cus['syjd_day'] = date('Y-m-d H:i:s',time());
                    }
                    if($cusInfo['is_valid'] != 1){
                        $cus['is_valid'] = 1;
                        $cus['yx_day'] = date('Y-m-d H:i:s',time());
                    }
                    $res = controller('index/Customer','lib')->updateCustomer($cus);
                    if($res){
                        // 发送微信模板消息 发2次
                        // 向上一级发信息  微信
                        if(!empty($cusInfo['sales_staff_id'])){
                            $content = [
                                'touser'       => $cusInfo['sales_staff_id'],
                                'template_id'  => OPENTM_CT,
                                'data'         => [
                                    'first'=>[
                                        'value'=>'您好，您有一笔订单冲突',
                                        'color'=>'#173177'
                                    ],
                                    'keyword1'=>[
                                        'value'=>$cusInfo['customer_name'].'('.$cusInfo['customer_sex'].')',
                                        'color'=>'#173177'
                                    ],
                                    'keyword2'=>[
                                        'value'=>$cusInfo['customer_tel'],
                                        'color'=>'#173177'
                                    ],
                                    'keyword3'=>[
                                        'value'=>'订单冲突',
                                        'color'=>'#173177'
                                    ],
                                    'keyword4'=>[
                                        'value'=>$param['create_time'],
                                        'color'=>'#173177'
                                    ],
                                    'remark'=>[
                                        'value'=>'请尽快查收，谢谢',
                                        'color'=>'#173177'
                                    ]
                                ]
                            ];
                            $send_data['content'] = json_encode($content);
                            // $res = sendMsg($send_data);
                        }
                        db()->commit();
                        return $param;
                    }else{
                        db()->rollback();
                        return array('error'=>1,'code'=>1212,'msg'=>'开单失败,修改客资表订单信息失败','data'=>'','sql'=>'');
                    }
                }else{
                    db()->rollback();
                    return array('error'=>1,'code'=>110,'msg'=>'开单失败','data'=>'');
                }
            }else{
                return array('error'=>1,'code'=>210,'msg'=>'开单失败,订单已存在','data'=>'');
            }
        }elseif($param['diff'] == 2){//添加消费产品 总额不为0，一销二销为0
            // $info = db('c_customerinfo')->where('order_number',$param['order_sn'])->field('id,customer_name,shop_code,shop_name,order_number,totalpay_money')->find();
            // if(empty($info['id'])){
            //     return array('error'=>1,'code'=>120,'msg'=>'添加消费产品时通过订单号查询客资id失败','data'=>'');
            // }
            $orderInfo = $this->checkOrder(['order_sn'=>$param['order_sn']]);
            if($orderInfo['error'] == 1){
                return array('error'=>1,'code'=>404,'msg'=>'添加消费产品时,订单表查询失败','data'=>'');
            }
            //修改订单表信息
            db()->startTrans();
            $arr = array(
                'order_sn'       => $orderInfo['order_sn'],
                'customer_id'    => $orderInfo['customer_id'],
                'customer_name'  => $orderInfo['customer_name'],
                // 'earnest_money'  => 0,
                // 'order_fact'     => 0,
                'order_amount'   => $param['order_amount'],
                // 'two_pin_fact'   => 0,
                'two_pin_amount' => $param['two_pin_amount'],
                'update_time'    => date('Y-m-d H:i:s',strtotime($param['create_time'])),
                'shop_code'      => $orderInfo['shop_code'],
                'shop_name'      => $orderInfo['shop_name'],
            );
            $ord = controller('index/Customer','lib')->updateCustomerOrder($arr);

            if($ord){
                //修改客资表套系金额
                $customerData = [
                    'id'=>$orderInfo['customer_id'],
                    'totalpay_money'=>$param['two_pin_amount']+$param['order_amount'],
                    'order_number'=> $orderInfo['order_sn'],
                ];
                $cusInfo = db('c_customerinfo')->where('id',$orderInfo['customer_id'])->field('is_intostore,is_valid')->find();
                if($cusInfo['is_intostore'] != 2){
                    $customerData['is_intostore'] = 2;
                    $customerData['syjd_day'] = date('Y-m-d H:i:s',time());
                }
                if($cusInfo['is_valid'] != 1){
                    $customerData['is_valid'] = 1;
                    $customerData['yx_day'] = date('Y-m-d H:i:s',time());
                }
                $res = controller('index/Customer','lib')->updateCustomer($customerData);
                // $res = controller('index/Customer','lib')->updateCustomer(['id'=>$info['id'],'totalpay_money'=>$info['totalpay_money']+$param['two_pin_amount']+$param['order_amount']]);
                if($res === false){
                    db()->rollback();
                    return array('error'=>1,'code'=>140,'msg'=>'添加消费产品时,客资表修改失败','data'=>'');
                }else{
                    db()->commit();
                    return $arr;
                }
            }else{
                db()->rollback();
                return array('error'=>1,'code'=>150,'msg'=>'添加消费产品时订单表更新失败','data'=>''.db()->getLastSql());
            }
        }elseif($param['diff'] == 3){
           // $info = db('c_customerinfo')->where('order_number',$param['order_sn'])->field('id,customer_name,shop_code,shop_name,order_number,fact_money')->find();//判断客资表中存不存在此订单
           // $info = db('c_customer_order')->where('order_sn',$param['order_sn'])->field('id,customer_name,shop_code,shop_name,order_sn,order_fact')->find();//判断订单标准存不存在此订单
           // if(empty($info['id'])){
           //     return array('error'=>1,'code'=>120,'msg'=>'付款时订单号查询失败','data'=>'');
           // }
            $orderInfo = $this->checkOrder(['order_sn'=>$param['order_sn']]);
            if($orderInfo['error'] == 1){
                return array('error'=>1,'code'=>404,'msg'=>'付款时,订单表查询失败','data'=>'');
            }
            // 无效订单
            if($orderInfo['order_valid'] == 1){
                // 判断订单是否有效
                $checkParam = [
                    'brandclass_id' => $param['brandclass_id'],
                    'fact_money'    => $orderInfo['earnest_money']+$param['order_fact'],
                    'order_money'   => $param['order_amount'],
                ];
                $result = controller('index/Customer', 'lib')->checkOrderValid($checkParam);

                db()->startTrans();
                try {
                    // 有效
                    if ($result === true) {
                        // 更新订单表
                        $orderData = [
                            'order_sn' => $param['order_sn'],
                            'order_valid' => 2,
                            'earnest_money'=> 0,
                            'order_fact'=>$orderInfo['earnest_money']+$param['order_fact'],
                            'order_amount'=>$param['order_amount'],
                            'two_pin_fact'=>$param['two_pin_fact']+$orderInfo['two_pin_fact'],
                            'two_pin_amount'=>$param['two_pin_amount'],
                            'update_time'=>date('Y-m-d'),
                        ];
                        $oRes = controller('index/Customer','lib')->updateCustomerOrder($orderData);
                        action_log($param,$orderInfo,$orderInfo['customer_id'],session('staff_id'),session('staff_name'));
                        //订单流水表
                        $order = array(
                            'order_sn' => $param['order_sn'],
                            'pay_time' => date('Y-m-d',strtotime($param['create_time'])),
                            'order_valid' => 2,
                            'order_type' => $orderInfo['order_type'],
                            'order_fact' => $param['order_fact'],
                            'two_pin_fact' => $param['two_pin_fact'],
                            'create_time' => date('Y-m-d H:i:s',time())
                        );
                        // $odRes = db('c_order_detail')->insert($order);
                        controller('crm/Customer','lib')->insert_order_detail($order);
                        // 修改客资表
                        $customerData = [
                            'id'=>$orderInfo['customer_id'],
                            'totalpay_money'=>$param['order_amount']+$param['two_pin_amount'],
                            'is_success'=>1,
                            'order_number'=>$param['order_sn'],
                            'order_day' =>date('Y-m-d H:i:s'),
                            'fact_money'=>$orderInfo['order_fact']+$orderInfo['earnest_money']+$param['order_fact']+$param['two_pin_fact']
                        ];
                        $cusInfo = db('c_customerinfo')->where('id',$orderInfo['customer_id'])->field('is_intostore,is_valid')->find();
                        if($cusInfo['is_intostore'] != 2){
                            $customerData['is_intostore'] = 2;
                            $customerData['syjd_day'] = date('Y-m-d H:i:s',time());
                        }
                        if($cusInfo['is_valid'] != 1){
                            $customerData['is_valid'] = 1;
                            $customerData['yx_day'] = date('Y-m-d H:i:s',time());
                        }
                        $cRes = controller('index/Customer','lib')->updateCustomer($customerData);
                    }else {
                        // 更新订单表
                        $orderData = [
                            'order_sn' => $param['order_sn'],
                            'order_valid' => 1,
                            'earnest_money'=>$orderInfo['earnest_money']+$param['order_fact'],
                            // 'order_fact'=>0,
                            'order_amount'=>$param['order_amount'],
                            'two_pin_fact'=>$param['two_pin_fact']+$orderInfo['two_pin_fact'],
                            'two_pin_amount'=>$param['two_pin_amount'],
                            'update_time'=>date('Y-m-d'),
                        ];
                        $oRes = controller('index/Customer','lib')->updateCustomerOrder($orderData);
                        action_log($param,$orderInfo,$orderInfo['customer_id'],session('staff_id'),session('staff_name'));
                        //订单流水表
                        $order = array(
                            'order_sn' => $param['order_sn'],
                            'pay_time' => date('Y-m-d',strtotime($param['create_time'])),
                            'order_valid' => 1,
                            'order_type' => $orderInfo['order_type'],
                            'order_fact' => $param['order_fact'],
                            'two_pin_fact' => $param['two_pin_fact'],
                            'create_time' => date('Y-m-d H:i:s',time())
                        );
                        // db('c_order_detail')->insert($order);
                        controller('crm/Customer','lib')->insert_order_detail($order);
                        // 修改客资表
                        $customerData = [
                            'id'=>$orderInfo['customer_id'],
                            'totalpay_money'=>$param['order_amount']+$param['two_pin_amount'],
                            'is_success'=>3,
                            'order_number'=>$param['order_sn'],
                            'fact_money'=>$orderInfo['order_fact']+$orderInfo['earnest_money']+$param['order_fact']+$param['two_pin_fact']
                        ];
                        $cusInfo = db('c_customerinfo')->where('id',$orderInfo['customer_id'])->field('is_intostore,is_valid')->find();
                        if($cusInfo['is_intostore'] != 2){
                            $customerData['is_intostore'] = 2;
                            $customerData['syjd_day'] = date('Y-m-d H:i:s',time());
                        }
                        if($cusInfo['is_valid'] != 1){
                            $customerData['is_valid'] = 1;
                            $customerData['yx_day'] = date('Y-m-d H:i:s',time());
                        }
                        controller('index/Customer','lib')->updateCustomer($customerData);
                    }
                    db()->commit();
                } catch (Exception $e) {
                    db()->rollback();
                    return array('error'=>1,'code'=>101,'msg' =>'有效订单收款失败','data'=>$e->getMessage());
                }
            }
            // 有效订单
            else{
                db()->startTrans();
                // 判断订单是否有效
                $checkParam = [
                    'brandclass_id' => $param['brandclass_id'],
                    'fact_money'    => $orderInfo['order_fact']+$param['order_fact'],
                    'order_money'   => $param['order_amount'],
                ];
                $result = controller('index/Customer', 'lib')->checkOrderValid($checkParam);
                try {
                    if($result === false){
                        // 更新订单表
                        $orderData = [
                            'order_sn' => $param['order_sn'],
                            'order_valid' => 1,
                            'order_fact'=>0,
                            'earnest_money'=>$param['order_fact']+$orderInfo['order_fact'],
                            'order_amount'=>$param['order_amount'],
                            'two_pin_fact'=>$param['two_pin_fact']+$orderInfo['two_pin_fact'],
                            'two_pin_amount'=>$param['two_pin_amount'],
                            'update_time'=>date('Y-m-d'),
                        ];

                        //订单流水表
                        $order = array(
                            'order_sn' => $param['order_sn'],
                            'pay_time' => date('Y-m-d',strtotime($param['create_time'])),
                            'order_valid' => 1,
                            'order_type' => $orderInfo['order_type'],
                            'order_fact' => $param['order_fact'],
                            'two_pin_fact' => $param['two_pin_fact'],
                            'create_time' => date('Y-m-d H:i:s',time())
                        );
                    // db('c_order_detail')->insert($order);
                        //修改客资表
                        $customerData = [
                            'id'=>$orderInfo['customer_id'],
                            'totalpay_money'=>$param['order_amount']+$param['two_pin_amount'],
                            'is_success'=>3,
                            'order_day' =>null,
                            'fact_money'=>$orderInfo['order_fact']+$orderInfo['earnest_money']+$param['order_fact']+$param['two_pin_fact'],
                            'order_number'=>$param['order_sn'],
                        ];
                    }else{
                        // 更新订单表
                        $orderData = [
                            'order_sn' => $param['order_sn'],
                            'order_fact'=>$orderInfo['earnest_money']+$param['order_fact']+$orderInfo['order_fact'],
                            'order_amount'=>$param['order_amount'],
                            'two_pin_fact'=>$param['two_pin_fact']+$orderInfo['two_pin_fact'],
                            'two_pin_amount'=>$param['two_pin_amount'],
                            'update_time'=>date('Y-m-d'),
                        ];

                        //订单流水表
                        $order = array(
                            'order_sn' => $param['order_sn'],
                            'pay_time' => date('Y-m-d',strtotime($param['create_time'])),
                            'order_valid' => 2,
                            'order_type' => $orderInfo['order_type'],
                            'order_fact' => $param['order_fact'],
                            'two_pin_fact' => $param['two_pin_fact'],
                            'create_time' => date('Y-m-d H:i:s',time())
                        );
                        // db('c_order_detail')->insert($order);
                        //修改客资表
                        $customerData = [
                            'id'=>$orderInfo['customer_id'],
                            'totalpay_money'=>$param['order_amount']+$param['two_pin_amount'],
                            'is_success'=>1,
                            'fact_money'=>$orderInfo['order_fact']+$orderInfo['earnest_money']+$param['order_fact']+$param['two_pin_fact'],
                            'order_number'=>$param['order_sn'],
                        ];
                    }
                    $cusInfo = db('c_customerinfo')->where('id',$orderInfo['customer_id'])->field('is_intostore,is_valid')->find();
                    if($cusInfo['is_intostore'] != 2){
                        $customerData['is_intostore'] = 2;
                        $customerData['syjd_day'] = date('Y-m-d H:i:s',time());
                    }
                    if($cusInfo['is_valid'] != 1){
                        $customerData['is_valid'] = 1;
                        $customerData['yx_day'] = date('Y-m-d H:i:s',time());
                    }
                    controller('index/Customer','lib')->updateCustomerOrder($orderData);

                    action_log($param,$orderInfo,$orderInfo['customer_id'],session('staff_id'),session('staff_name'));
                    controller('crm/Customer','lib')->insert_order_detail($order);
                    controller('index/Customer','lib')->updateCustomer($customerData);

                    db()->commit();
                } catch (Exception $e) {
                    db()->rollback();
                    return array('error'=>1,'code'=>101,'msg' =>'有效订单收款失败','data'=>$e->getMessage());
                }
            }
            return $orderData;
            // //根据事业部id查询设定的有效条件
            // $brandclassInfo = controller('index/Customer','lib')->getBrandClassInfo($param['brandclass_id']);
            // //如果满足条件，订单表改为有效，客资表也改为有效，实际收款，未满足条件，放到定金字段，客资表实际收款
            // if(!empty($brandclassInfo)){
            //     //实收款
            //     if($brandclassInfo['order_rule'] == 1){
            //         // 订单无效
            //         if ($orderInfo['order_valid'] == 1) {
            //             if($orderInfo['earnest_money']+$param['order_fact'] >= $brandclassInfo['proportion']){//有效
            //                 $arr = array(
            //                     'order_sn' => $info['order_number'],
            //                     'customer_id' => $info['id'],
            //                     'customer_name' => $info['customer_name'],
            //                     'earnest_money' => 0,
            //                     'order_fact' => $orderInfo['earnest_money']+$param['order_fact'],
            //                     'order_amount' => $param['order_amount'],
            //                     'two_pin_fact' => $orderInfo['two_pin_fact']+$param['two_pin_fact'],
            //                     'two_pin_amount' => $param['two_pin_amount'],
            //                     'update_time' => $param['create_time'],
            //                     'shop_code' => $info['shop_code'],
            //                     'shop_name' => $info['shop_name'],
            //                 );
            //                 db()->startTrans();
            //                 try{
            //                     controller('index/Customer','lib')->updateCustomerOrder($arr);
            //                     //修改订单流水表
            //                     $arr = array(
            //                         'order_sn' => $param['order_sn'],
            //                         'order_fact' => $param['order_fact'],
            //                         'order_valid' => 2,
            //                         'pay_time' => date('Y-m-d',strtotime($param['create_time'])),
            //                         'two_pin_fact' => $param['two_pin_fact'],
            //                         'create_time' => date('Y-m-d H:i:s',time())
            //                     );
            //                     db('c_order_detail')->insert($arr);
            //                     //修改客资表
            //                     controller('index/Customer','lib')->updateCustomer(['id'=>$info['id'],'totalpay_money'=>$param['order_amount']+$param['two_pin_amount'],'is_success'=>1,'fact_money'=>$info['fact_money']+$param['order_fact']+$param['two_pin_fact']]);
            //                     db()->commit();
            //                     return $param;
            //                 }catch (Exception $e){
            //                     db()->rollback();
            //                     return array('error'=>1,'code'=>140,'msg'=>'付款时,客资表修改失败','data'=>'');
            //                 }
            //             }else{//无效
            //                 $arr = array(
            //                     'order_sn' => $info['order_number'],
            //                     'customer_id' => $info['id'],
            //                     'customer_name' => $info['customer_name'],
            //                     'earnest_money' => $orderInfo['earnest_money']+$param['order_fact'],
            //                     'order_fact' => 0,
            //                     'order_amount' => $orderInfo['order_amount']+$param['order_amount'],
            //                     'two_pin_fact' => $orderInfo['two_pin_fact']+$param['two_pin_fact'],
            //                     'two_pin_amount' => $orderInfo['two_pin_amount']+$param['two_pin_amount'],
            //                     'update_time' => $param['create_time'],
            //                     'shop_code' => $info['shop_code'],
            //                     'shop_name' => $info['shop_name'],
            //                 );
            //                 db()->startTrans();
            //                 try{
            //                     controller('index/Customer','lib')->updateCustomerOrder($arr);
            //                     //修改订单流水表
            //                     $arr = array(
            //                         'order_sn' => $param['order_sn'],
            //                         'order_fact' => $param['order_fact'],
            //                         'order_valid' => 1,
            //                         'pay_time' => date('Y-m-d',strtotime($param['create_time'])),
            //                         'two_pin_fact' => $param['two_pin_fact'],
            //                         'create_time' => date('Y-m-d H:i:s',time())
            //                     );
            //                     db('c_order_detail')->insert($arr);
            //                     //修改客资表
            //                     //修改客资表实际收款，是否成交
            //                     controller('index/Customer','lib')->updateCustomer(['id'=>$info['id'],'is_success'=>3,'fact_money'=>$param['order_fact']+$param['two_pin_fact'],'is_valid'=>1]);
            //                     db()->commit();
            //                     return $param;
            //                 }catch (Exception $e){
            //                     db()->rollback();
            //                     return array('error'=>1,'code'=>500,'msg'=>'付款时修改订单表定金失败','data'=>'');
            //                 }
            //             }
            //         }
            //         // 订单有效
            //         else{

            //         }
            //     }
            //     //占比
            //     elseif($brandclassInfo['order_rule'] == 2){
            //         // 订单无效
            //         if ($orderInfo['order_valid'] == 1) {
            //             if(($orderInfo['order_fact']+$orderInfo['earnest_money']+$param['order_fact'])/$orderInfo['order_amount'] >= $brandclassInfo['proportion']/100){
            //                 $arr = array(
            //                     'order_sn' => $info['order_number'],
            //                     'customer_id' => $info['id'],
            //                     'customer_name' => $info['customer_name'],
            //                     'earnest_money' => 0,
            //                     'order_fact' => $orderInfo['earnest_money']+$orderInfo['order_fact']+$param['order_fact'],
            //                     'order_amount' => $orderInfo['order_amount']+$param['order_amount'],
            //                     'two_pin_fact' => $orderInfo['two_pin_fact']+$param['two_pin_fact'],
            //                     'two_pin_amount' => $orderInfo['two_pin_amount']+$param['two_pin_amount'],
            //                     'update_time' => $param['create_time'],
            //                     'shop_code' => $info['shop_code'],
            //                     'shop_name' => $info['shop_name'],
            //                 );
            //                 db()->startTrans();
            //                 try{
            //                     controller('index/Customer','lib')->updateCustomerOrder($arr);
            //                     //修改订单流水表
            //                     $arr = array(
            //                         'order_sn' => $param['order_sn'],
            //                         'order_fact' => $param['order_fact'],
            //                         'order_valid' => 2,
            //                         'pay_time' => date('Y-m-d',strtotime($param['create_time'])),
            //                         'two_pin_fact' => $param['two_pin_fact'],
            //                         'create_time' => date('Y-m-d H:i:s',time())
            //                     );
            //                     db('c_order_detail')->insert($arr);
            //                     //修改客资表
            //                      controller('index/Customer','lib')->updateCustomer(['id'=>$info['id'],'totalpay_money'=>$param['order_amount']+$param['two_pin_amount'],'is_success'=>1,'fact_money'=>$info['fact_money']+$param['order_fact']+$param['two_pin_fact']]);


            //                     db()->commit();
            //                     return $param;
            //                 }catch (Exception $e){
            //                     db()->rollback();
            //                     return array('error'=>1,'code'=>140,'msg'=>'付款时,客资表修改失败','data'=>'');
            //                 }

            //             }else{//无效
            //                 $arr = array(
            //                     'order_sn' => $info['order_number'],
            //                     'customer_id' => $info['id'],
            //                     'customer_name' => $info['customer_name'],
            //                     'earnest_money' => $orderInfo['earnest_money']+$param['order_fact'],
            //                     'order_fact' => 0,
            //                     'order_amount' => $orderInfo['order_amount']+$param['order_amount'],
            //                     'two_pin_fact' => $orderInfo['two_pin_fact']+$param['two_pin_fact'],
            //                     'two_pin_amount' => $orderInfo['two_pin_amount']+$param['two_pin_amount'],
            //                     'update_time' => $param['create_time'],
            //                     'shop_code' => $info['shop_code'],
            //                     'shop_name' => $info['shop_name'],
            //                 );
            //                 db()->startTrans();
            //                 try{
            //                     controller('index/Customer','lib')->updateCustomerOrder($arr);

            //                     //修改订单流水表
            //                     $arr = array(
            //                         'order_sn' => $param['order_sn'],
            //                         'order_fact' => $param['order_fact'],
            //                         'order_valid' => 2,
            //                         'pay_time' => date('Y-m-d',strtotime($param['create_time'])),
            //                         'two_pin_fact' => $param['two_pin_fact'],
            //                         'create_time' => date('Y-m-d H:i:s',time())
            //                     );
            //                     db('c_order_detail')->insert($arr);
            //                     //修改客资表
            //                     //修改客资表实际收款，是否成交
            //                     controller('index/Customer','lib')->updateCustomer(['id'=>$info['id'],'is_success'=>3,'fact_money'=>$param['order_fact']+$param['two_pin_fact'],'is_valid'=>1]);

            //                         db()->commit();
            //                         return $param;
            //                 }catch (Exception $e){
            //                     db()->rollback();
            //                     return array('error'=>1,'code'=>500,'msg'=>'付款时修改订单表定金失败','data'=>'');
            //                 }
            //             }
            //         }
            //         // 订单有效
            //         else{

            //         }
            //     }
            //     //未设定订单有效标准时，默认有效s
            //     else{//未设定订单有效标准时，默认有效
            //         $info = db('c_customerinfo')->where('order_number',$param['order_sn'])->field('id,customer_name,shop_code,shop_name,order_number,fact_money')->find();
            //         if(empty($info['id'])){
            //             return array('error'=>1,'code'=>120,'msg'=>'付款时通过订单号查询客资id失败','data'=>'');
            //         }
            //         $orderInfo = $this->checkOrder(['order_sn'=>$param['order_sn']]);
            //         $arr = array(
            //             'order_sn' => $info['order_number'],
            //             'customer_id' => $info['id'],
            //             'customer_name' => $info['customer_name'],
            //             'earnest_money' => 0,
            //             'order_fact' => $orderInfo['earnest_money']+$orderInfo['order_fact']+$param['order_fact'],
            //             'order_amount' => $orderInfo['order_amount']+$param['order_amount'],
            //             'two_pin_fact' => $orderInfo['two_pin_fact']+$param['two_pin_fact'],
            //             'two_pin_amount' => $orderInfo['two_pin_amount']+$param['two_pin_amount'],
            //             'update_time' => $param['create_time'],
            //             'shop_code' => $info['shop_code'],
            //             'shop_name' => $info['shop_name'],
            //         );
            //         db()->startTrans();
            //         try{
            //             controller('index/Customer','lib')->updateCustomerOrder($arr);
            //             //修改订单流水表
            //             $arr = array(
            //                 'order_sn' => $param['order_sn'],
            //                 'order_fact' => $param['order_fact'],
            //                 'order_valid' => 2,
            //                 'pay_time' => date('Y-m-d',strtotime($param['create_time'])),
            //                 'two_pin_fact' => $param['two_pin_fact'],
            //                 'create_time' => date('Y-m-d H:i:s',time())
            //             );
            //             db('c_order_detail')->insert($arr);
            //             //修改客资表
            //             controller('index/Customer','lib')->updateCustomer(['id'=>$info['id'],'totalpay_money'=>$param['order_amount']+$param['two_pin_amount'],'is_success'=>1,'fact_money'=>$info['fact_money']+$param['order_fact']+$param['two_pin_fact']]);

            //             db()->commit();
            //             return $param;
            //         }catch (Exception $e){
            //             db()->rollback();
            //             return array('error'=>1,'code'=>140,'msg'=>'付款时出错','data'=>'');
            //         }
            //     }
            // }else{
            //     return array('error'=>1,'code'=>300,'msg'=>'事业部查询失败','data'=>$param['brandclass_id']);
            // }
        }else{
            return array('error'=>1,'code'=>400,'msg'=>'参数有误','data'=>'');
        }
    }
    
	/**
	 * 检查该客资是否存在于客资系统中
	 * 
	 * @param  brandclass_id         事业部id
	 * @param  shop_code             
     * @param  staff_id              操作人id
     * @param  customer_number       客户编号
     * @param  customer_name         客户姓名
	 * @param  customer_tel          客户手机
	 * @param  customer_wechat       客户微信
	 * @param  customer_qq           客户QQ
     * @param  customer_sex          客户性别
     * @param  customer_birthday     客户生日
     * @param  consultation_type_id  消费类型id
     * @param  consultation_type     消费类型
     * @param  customer_area_id      客户分区id
     * @param  customer_area         客户分区
     * @param  customer_cource_id    客户来源id
     * @param  customer_cource       客户来源
     * @param  customer_intention_id 客户意向id
     * @param  customer_intention    客户意向
     * @param  customer_orderaddress 接单点
     * @param  customer_address      客户地址
     * @param  yp_day                预拍日期
     * @param  marry_day             结婚日期
     * @param  mate_name             配偶姓名
     * @param  mate_tel              配偶手机
     * @param  mate_wechat           配偶微信
     * @param  mate_qq               配偶QQ
     * @param  mate_sex              配偶性别
     * @param  mate_birthday         配偶生日
     * @param  ready_baby_day        预产期
     * @param  baby_birthday         宝宝生日
     * @param  baby_address          宝宝出生地
     * @param  customer_remark       客户备注
     *
	 * @return array
	 * @author lilong<lilong@suxuantech.cn>
	 */
	public function checkCustomer($param){
        $customer_name = $param['customer_name'];
        // $tel = preg_match('#/^1[3|4|5|6|7|8|9][0-9]{9}$/#', $param['customer_tel']) ? true : false;
        if(!preg_match("/^1[3|4|5|6|7|8|9][0-9]{9}$/", $param['customer_tel'])){
            return array('error'=>1,'code'=>300,'msg'=>'手机格式错误','data'=>[]);
        }

		$return = controller("Customer","lib")->checkCustomer($param);
        // var_dump($return);
        // exit;
		// 客资不存在，录入到客资里
        $date = date('Y-m-d H:i:s');
        if (!$return) {
            $staffInfo = getStaffInfoById(intval($param['staff_id']));
            // print_r($staffInfo);
            // exit;
            $data = [
                'brandclass_id'        => (int)$param['brandclass_id'],
                'brandclass'           => $staffInfo['brandclass'],
                'shop_code'            => $staffInfo['shop_code'],
                'shop_name'            => $staffInfo['shop_name'],
                'add_shop_code'        => $staffInfo['shop_code'],
                'add_shop_name'        => $staffInfo['shop_name'],
                'customer_name'        => $customer_name,
                'customer_number'      => time().generate_code(),
                'customer_tel'         => $param['customer_tel'],
                'customer_wechat'      => $param['customer_wechat'],
                'customer_qq'          => $param['customer_qq'],
                'customer_sex'         => $param['customer_sex'],
                'consultation_type_id' => (int)$param['consultation_type_id'],
                'consultation_type'    => $param['consultation_type'],
                'customer_area_id'     => (int)$param['customer_area_id'],
                'customer_area'        => $param['customer_area'],
                'customer_birthday'    => $param['customer_birthday'] ? date('Y-m-d H:i:s', strtotime($param['customer_birthday'])) : NULL,
                'customer_cource_id'   => (int)$param['customer_cource_id'],
                'customer_cource'      => $param['customer_cource'],
                'customer_intention_id'=> (int)$param['customer_intention_id'],
                'customer_intention'   => $param['customer_intention'],
                'customer_orderaddress'=> $param['customer_orderaddress'],
                'customer_address'     => $param['customer_address'],
                'yp_day'               => $param['yp_day'] ? date('Y-m-d H:i:s', strtotime($param['yp_day'])) : NULL,
                'marry_day'            => $param['marry_day'] ? date('Y-m-d H:i:s', strtotime($param['marry_day'])) : NULL,
                'mate_name'            => $param['mate_name'],
                'mate_tel'             => $param['mate_tel'],
                'mate_wechat'          => $param['mate_wechat'],
                'mate_qq'              => $param['mate_qq'],
                'mate_sex'             => $param['mate_sex'],
                'mate_birthday'        => $param['mate_birthday']?date('Y-m-d H:i:s',strtotime($param['mate_birthday'])):NULL,
                'customer_remark'      => $param['customer_remark'],
                'ready_baby_day'       => $param['ready_baby_day']?date('Y-m-d H:i:s',strtotime($param['ready_baby_day'])):NULL,
                'baby_birthday'        => $param['baby_birthday']?date('Y-m-d H:i:s',strtotime($param['baby_birthday'])):NULL,
                'baby_address'         => $param['baby_address'] ? $param['baby_address'] : '',
                'c_from'                 => 2,
                'creator_day'          => $date,
                'create_time'          => $date,
                'dj_day'               => $date,
                'dj_staff'             => $staffInfo['staffname'],
                'dj_staff_id'          => $param['staff_id'],
                'dj_staff_number'      => $staffInfo['staffnumber'],
                'tel_staff_id'         => $param['staff_id'],
                'tel_staff'            => $staffInfo['staffname'],
                'tel_time'             => $date,
                'is_first_tel'         => 1,
                'wechat_staff_id'      => $param['customer_wechat'] ? $param['staff_id'] : '',
                'wechat_staff'         => $param['customer_wechat'] ? $staffInfo['staffname'] : '',
                'wechat_time'          => $param['customer_wechat'] ? $date : NULL,
                'is_first_wechat'      => $param['customer_wechat'] ? 1 : '',
                'qq_staff_id'          => $param['customer_qq'] ? $param['staff_id'] : '',
                'qq_staff'             => $param['customer_qq'] ? $staffInfo['staffname'] : '',
                'qq_time'              => $param['customer_qq'] ? $date : NULL,
                'is_first_qq'          => $param['customer_qq'] ? 1 : '',
                'is_valid'          => 1,
                'yx_day'          => $date,
                'is_intostore'          => 2,
                'syjd_day'          => $date,
            ];
            // print_r($param);die;
            db()->startTrans();
            try {
                $res = db('c_customerinfo')->insertGetId($data);
                $data['id']     = $res;
                $data['status'] = 1;
                $return = $data;
                db()->commit();
            } catch (Exception $e) {
                $return = array('error'=>1,'code'=>201,'msg'=>'操作失败，请重试！');
                db()->rollback();
            }
        }else{
            $arr = [];
            if($return['is_valid'] != 1){
                $arr['is_valid'] = 1;
                $arr['yx_day'] = $date;
            }
            if($return['is_intostore'] != 2){
                $arr['is_intostore'] = 2;
                $arr['syjd_day'] = $date;
            }
            if(!empty($arr)){
                db()->startTrans();
                try {
                    db('c_customerinfo')->where('id',$return['id'])->update($arr);
                    db()->commit();
                } catch (Exception $e) {
                    $return = array('error'=>1,'code'=>202,'msg'=>'操作失败，请重试！');
                    db()->rollback();
                }
            }
        }
        if ($param['is_in'] == 1) {
            $returnData = $return;
        }else{
            $returnData['customer_number'] = $return['customer_number'];
        }
		return $returnData;
	}

	/**
	 * 检查该订单是否存在于客资系统中
	 * 
	 * @param  customer_id
	 * @param  order_sn
	 *
	 * @return boolean
	 * @author lilong<lilong@suxuantech.cn>
	 */
	public function checkOrder($param){
		$res = controller("Customer","lib")->checkOrder($param);
		if (!$res) {
			$return = array('error'=>1,'code'=>201,'msg'=>'不存在该订单信息！');
		}else{
			$return = $res;
		}
        // var_dump($return);
		return $return;
	}

	/**
	 * 客资状态修改（进店进客，进店非进客，未进店，流失）
	 * 
	 * @param  code             1:进店进客；2：进店非进客；3：未进店；4：流失
	 * @param  create_time      进店时间/标记时间
	 * @param  lose_reason      流失原因
	 * @param  customer_number  客资编号
	 * @param  retail_sales     门市人员
	 * @param  m_tel            男士手机号
	 * @param  w_tel            女士手机号
	 * @param  brandclass_id    事业部id
	 * @param  shop_code        shop_code
	 *
	 * @return boolean
	 * @author lilong<lilong@suxuantech.cn>
	 */
	public function changeCustomerStatus($param){
        $param['create_time'] = date('Y-m-d H:i:s',strtotime($param['create_time']));
        $return = [];
		switch ($param['code']) {
			case '1':
                $data['is_intostore'] = 2;
                $data['syjd_day']     = $param['create_time'];
				break;
			case '2':
				$data['is_intostore'] = 3;
                $data['syjd_day']     = $param['create_time'];
				break;
			case '3':
				$data['is_intostore'] = 1;
				break;
			case '4':
                $data['is_loss'] = 1;
                $data['loss_cause'] = $param['lose_reason'];
                break;
		}
        // $data
        // 判断条件
        $where['brandclass_id'] = $param['brandclass_id'];
        if ($param['customer_number']) {
            $where['customer_number'] = $param['customer_number'];
        }else{
            // 根据男士或者女士手机号，查询客资
            // 男士信息
            if($param['m_tel']){
               // $tel = preg_match('#/^1[3|4|5|6|7|8|9][0-9]{9}$/#', $param['m_tel']) ? true : false;
               // if($tel == false){
               //     return array('error'=>1,'code'=>300,'msg'=>'男手机格式错误','data'=>[]);
               // }
                if(!preg_match("/^1[3|4|5|6|7|8|9][0-9]{9}$/", $param['m_tel'])){
                    return array('error'=>1,'code'=>300,'msg'=>'男手机格式错误','data'=>[]);
                }
            }
            $mParam['customer_tel'] = $param['m_tel'];
            $mParam['brandclass_id'] = $param['brandclass_id'];
            $mInfo = controller('index/Customer','lib')->checkCustomer($mParam);

            // 女士信息
            if($param['w_tel']){
               // $tel = preg_match('#/^1[3|4|5|6|7|8|9][0-9]{9}$/#', $param['w_tel']) ? true : false;
               // if($tel == false){
               //     return array('error'=>1,'code'=>300,'msg'=>'女手机格式错误','data'=>[]);
               // }
                if(!preg_match("/^1[3|4|5|6|7|8|9][0-9]{9}$/", $param['w_tel'])){
                    return array('error'=>1,'code'=>300,'msg'=>'女手机格式错误','data'=>[]);
                }
            }
            $wParam['customer_tel'] = $param['w_tel'];
            $wParam['brandclass_id'] = $param['brandclass_id'];
            $wInfo = controller('index/Customer','lib')->checkCustomer($wParam);

            // 同一条客资
            if ($mInfo['id'] == $wInfo['id']) {
                $where['id'] = $mInfo['id'];
            }else{
                // 不同客资 存在 预约进店 时间
                if ($mInfo['yjd_day'] && $wInfo['yjd_day']) {
                    if ($mInfo['yjd_day'] > $wInfo['yjd_day']) {
                        $where['id'] = $wInfo['id'];
                    }else{
                        $where['id'] = $mInfo['id'];
                    }
                } else if ((empty($mInfo['yjd_day']) && $wInfo['yjd_day']) || (empty($wInfo['yjd_day']) && $mInfo['yjd_day'])) {
                    if(empty($mInfo['yjd_day']) && $wInfo['yjd_day'])    $where['id'] = $wInfo['id'];
                    if(empty($wInfo['yjd_day']) && $mInfo['yjd_day'])    $where['id'] = $mInfo['id'];
                }
                // 不同客资 存在 开始追踪 时间
                else if ($mInfo['c_star_day'] && $wInfo['c_star_day']) {
                    if ($mInfo['c_star_day'] > $wInfo['c_star_day']) {
                        $where['id'] = $wInfo['id'];
                    }else{
                        $where['id'] = $mInfo['id'];
                    }
                }
                else if ((empty($mInfo['c_star_day']) && $wInfo['c_star_day']) || (empty($wInfo['c_star_day']) && $mInfo['c_star_day'])) {
                    if(empty($mInfo['c_star_day']) && $wInfo['c_star_day'])    $where['id'] = $wInfo['id'];
                    if(empty($wInfo['c_star_day']) && $mInfo['c_star_day'])    $where['id'] = $mInfo['id'];
                }
                // 不同客资 存在 接入 时间
                else if ($mInfo['jr_day'] || $wInfo['jr_day']) {
                    if ($mInfo['jr_day'] > $wInfo['jr_day']) {
                        $where['id'] = $wInfo['id'];
                    }else{
                        $where['id'] = $mInfo['id'];
                    }
                }
                else if ((empty($mInfo['jr_day']) && $wInfo['jr_day']) || (empty($wInfo['jr_day']) && $mInfo['jr_day'])) {
                    if(empty($mInfo['jr_day']) && $wInfo['jr_day'])    $where['id'] = $wInfo['id'];
                    if(empty($wInfo['jr_day']) && $mInfo['jr_day'])    $where['id'] = $mInfo['id'];
                }
                // 不同客资 存在 录入 时间
                else {
                    // $mInfo['creator_day'] || $wInfo['creator_day'];
                    if ($mInfo['creator_day'] > $wInfo['creator_day']) {
                        $where['id'] = $mInfo['id'];
                    }else{
                        $where['id'] = $wInfo['id'];
                    }
                }
            }
        }
        // 开启事务
        db()->startTrans();
        try {
            db('c_customerinfo')->where($where)->update($data);
            $staff_id = $param['staff_id'];
            $staffInfo = getStaffInfoById($staff_id);
            history_log($data, [], $where['id'], $staff_id, $staffInfo['staffname']);
            db()->commit();
            $return = $data;
        } catch (Exception $e) {
            $return = array('error'=>1,'code'=>201,'msg'=>'修改失败，请重试！');
            db()->rollback();
        }

        return $return;
	}

    /**
     * 门市创建新订单
     * 
     * @param  brandclass_id         事业部id
     * @param  shop_code             shop_code
     * @param  staff_id              员工id
     * @param  order_sn              订单编号 
     * @param  create_time           创建时间 (y-m-d H:i:s)
     * @param  consultation_type     消费类型
     * @param  consultation_type_id  消费类型 id
     * @param  customer_cource       客户来源
     * @param  customer_cource_id    客户来源 id
     * @param  customer_area         客户分区
     * @param  customer_area_id      客户分区 id
     * @param  marry_day             结婚日期
     * @param  baby_birthday         宝宝生日
     * @param  wname                 女士姓名
     * @param  wphone                女士手机
     * @param  mname                 男士姓名
     * @param  mphone                男士手机
     * @param  wwechat               女士微信
     * @param  mwechat               男士微信
     *
     * @return string           customer_number
     * @author lilong<lilong@suxuantech.cn>
     */
    public function createOrder($param){

        // 先根据女士手机号判断客资是否存在，根据男士手机是否存在，判断客资是否存在
        // 如果  女士手机号  和  男士手机号 都不存在客资 ， 那么创建客资，生成订单，返回customer_number

        // 如果  女士手机号、男士手机号 客资  存在一条，那么根据最后一次追踪时间，
            // 在三天内，生成订单，返回customer_number；
            // 不在三天内，更新客资所属及相关信息（等于创建新订单，归属原电商），并生成订单，返回customer_number；

        // 如果  女士手机号  和  男士手机号 都存在客资，
            // 如果有邀约，根据邀约时间，先邀约，返回customer_number
            // 没有邀约，根据最近三天是否追踪，有追踪，根据最后一次追踪时间
            // 最近三天没有追踪，更新客资所属及相关信息（等于创建新订单，归属门店？归属原电商），生成订单，返回customer_number；

        // 根据女士手机号，判断客资是否存在
        $wData['customer_tel']    = $param['wphone'];
        $wData['customer_wechat'] = $param['wwechat'];
        $wData['brandclass_id']   = $param['brandclass_id'];
        $wInfo = controller("Customer","lib")->checkCustomer($wData);

        $brandclassInfo= controller('index/Customer','lib')->getBrandClassInfo($param['brandclass_id']);

        $target_time = date('Y-m-d H:i:s',strtotime($param['create_time']));

        $param['create_time'] = date('Y-m-d H:i:s',time());
        // 今天
        $date = date('Y-m-d');
        // 三天前
        $tAgo = date('Y-m-d', strtotime('-3 days'));
        // 根据男士手机号存在，判断客资是否存在
        if ($param['mphone']) {
            $mData['customer_tel']    = $param['mphone'];
            $mData['customer_wechat'] = $param['mwechat'];
            $mData['brandclass_id']   = $param['brandclass_id'];
            $mInfo = controller("Customer","lib")->checkCustomer($mData);
        }

        // 两个手机号客资都不存在  创建新客资
        if ( empty($wInfo) && empty($mInfo) ) {
            // 创建客资
            $res = controller("Customer", "lib")->createCustomer($param);
            // 创建订单
            $oData['order_sn']          = $param['order_sn'];
            $oData['customer_id']       = $res['id'];
            $oData['customer_name']     = $param['wname'];
            $oData['consultation_type'] = $param['consultation_type'];
            $oData['target_time']       = $target_time;
            $oData['create_time']       = $param['create_time'];
            $oData['shop_code']         = $res['shop_code'];
            $oData['shop_name']         = $res['shop_name'];
            $oData['order_type']        = 2;
            $oData['brandclass_id']     = $param['brandclass_id'];
            $oData['brandclass']        = $brandclassInfo['brandclass'];
            // var_dump($oData);
            // exit;
            db('c_customer_order')->insert($oData);
            // 返回客资编号
            $returnData['customer_number'] = $res['customer_number'];
        }
        // 女士客资 存在，存在一条
        else if ( ($wInfo && empty($mInfo)) || $wInfo['id'] == $mInfo['id'] ) {
            $arr = array(
                'order_sn'=>$param['order_sn'],
            );
            $res = $this->checkOrder($arr);
            if($res['error'] != 1){
                // 返回客资编号
                $returnData['customer_number'] = $wInfo['customer_number'];
                return $returnData;
            }
            // 创建订单
            $oData['order_sn']          = $param['order_sn'];
            $oData['customer_id']       = $wInfo['id'];
            $oData['customer_name']     = $wInfo['customer_name'];
            $oData['consultation_type'] = $param['consultation_type'];
            $oData['target_time']       = $target_time;
            $oData['create_time']       = $param['create_time'];
            $oData['shop_code']         = $wInfo['shop_code'];
            $oData['shop_name']         = $wInfo['shop_name'];
            $oData['order_type']        = 2;
            $oData['brandclass_id']     = $param['brandclass_id'];
            $oData['brandclass']        = $brandclassInfo['brandclass'];
            db('c_customer_order')->insert($oData);

            // $count = db('c_customerinfo')
            //     ->where('id', $wInfo['id'])
            //     ->where('c_end_day', 'between time', [$tAgo, $date])
            //     ->count();
            // 3天内存在追踪记录 不管是不是追踪过，crm的客资
            // if (!$count) {
            //     $cData['c_from'] = 2;
            // }
            $cData['order_number'] = $param['order_sn'];
            $cData['order_start_time'] = $target_time;

            if ($wInfo['is_valid'] > 1) {
                $cData['is_valid'] = 1;
                $cData['yx_day'] = $param['create_time'];
            }
            if ($wInfo['is_intostore'] != 2) {
                $cData['is_intostore'] = 2;
                $cData['syjd_day'] = $param['create_time'];
            }

            if ($param['mphone']) {
                if (!$wInfo['mate_tel']) {
                    $cData['mate_tel'] = $param['mphone'];
                }
                if (!$wInfo['mate_name']) {
                    $cData['mate_name'] = $param['mname'];
                }
                if (!$wInfo['mate_sex']) {
                    $cData['mate_sex'] = '男';
                }
                if (!$wInfo['mate_wechat']) {
                    $cData['mate_wechat'] = $param['mwechat'];
                }
            }

            $cData['customer_area_id'] = $param['customer_area_id'];
            $cData['customer_area']    = $param['customer_area'];
            
            db('c_customerinfo')->where('id', $wInfo['id'])->update($cData);
            // 返回客资编号
            $returnData['customer_number'] = $wInfo['customer_number'];
        }
        // 男士客资 存在，存在一条
        else if ( empty($wInfo) && $mInfo ) {
            $arr = array(
                'order_sn'=>$param['order_sn'],
            );
            $res = $this->checkOrder($arr);
            if($res['error'] != 1){
                // 返回客资编号
                $returnData['customer_number'] = $mInfo['customer_number'];
                return $returnData;
            }
            // 创建订单
            $oData['order_sn']          = $param['order_sn'];
            $oData['customer_id']       = $mInfo['id'];
            $oData['customer_name']     = $mInfo['customer_name'];
            $oData['consultation_type'] = $mInfo['consultation_type'];
            $oData['target_time']       = $target_time;
            $oData['create_time']       = $mInfo['create_time'];
            $oData['shop_code']         = $mInfo['shop_code'];
            $oData['shop_name']         = $mInfo['shop_name'];
            $oData['order_type']        = 2;
            $oData['brandclass_id']     = $param['brandclass_id'];
            $oData['brandclass']        = $brandclassInfo['brandclass'];
            db('c_customer_order')->insert($oData);

            // $count = db('c_customerinfo')
            //     ->where('id', $mInfo['id'])
            //     ->where('c_end_day', 'between time', [$tAgo, $date])
            //     ->count();
            // // 3天内存在追踪记录
            // if ($count) {
            //     // 更新客资
            //     $cData['order_number'] = $param['order_sn'];
            //     db('c_customerinfo')->where('id', $mInfo['id'])->update($cData);
            // }else{
            //     // 更新客资
            //     $cData['order_number'] = $param['order_sn'];
            //     $cData['c_from'] = 2;
            //     db('c_customerinfo')->where('id', $mInfo['id'])->update($cData);
            // }
            $cData['order_number'] = $param['order_sn'];
            $cData['order_start_time'] = $target_time;
            if ($wInfo['is_valid'] > 1) {
                $cData['is_valid'] = 1;
                $cData['yx_day'] = $param['create_time'];
            }
            if ($wInfo['is_intostore'] != 2) {
                $cData['is_intostore'] = 2;
                $cData['syjd_day'] = $param['create_time'];
            }

            if ($param['wphone']) {
                if (!$wInfo['mate_tel']) {
                    $cData['mate_tel'] = $param['wphone'];
                }
                if (!$wInfo['mate_name']) {
                    $cData['mate_name'] = $param['wname'];
                }
                if (!$wInfo['mate_sex']) {
                    $cData['mate_sex'] = '女';
                }
                if (!$wInfo['mate_wechat']) {
                    $cData['mate_wechat'] = $param['wwechat'];
                }
            }

            $cData['customer_area_id'] = $param['customer_area_id'];
            $cData['customer_area']    = $param['customer_area'];

            // var_dump($cData);
            db('c_customerinfo')->where('id', $mInfo['id'])->update($cData);
            // echo db()->getLastSql();
            // 返回客资编号
            $returnData['customer_number'] = $mInfo['customer_number'];
        }
        // 如果  女士手机号  和  男士手机号 都存在客资，
        else if ( $wInfo && $mInfo ) {
            // 女士客资的最后一次追踪时间  大于  男士客资的最后一次追踪时间  并且  男客资的最后一次追踪时间在3天内
            if ( ($wInfo['c_end_day']>$mInfo['c_end_day']) && ($tAgo<$mInfo['c_end_day'] && $mInfo['c_end_day']<$date) ) {
                $arr = array(
                    'order_sn'=>$param['order_sn'],
                );
                $res = $this->checkOrder($arr);
                if($res['error'] != 1){
                    // 返回客资编号
                    $returnData['customer_number'] = $wInfo['customer_number'];
                    return $returnData;
                }
                // 返回数据
                $return = $wInfo['customer_number'];

                // 订单表数据
                $oData['customer_id']   = $wInfo['id'];
                $oData['customer_name'] = $wInfo['customer_name'];
                $oData['shop_code']     = $wInfo['shop_code'];
                $oData['shop_name']     = $wInfo['shop_name'];

                // 客资表数据及条件
                if ($param['mphone']) {
                    if (!$wInfo['mate_tel']) {
                        $cData['mate_tel'] = $param['mphone'];
                    }
                    if (!$wInfo['mate_name']) {
                        $cData['mate_name'] = $param['mname'];
                    }
                    if (!$wInfo['mate_wechat']) {
                        $cData['mate_wechat'] = $param['mwechat'];
                    }
                }
                $where['id'] = $wInfo['id'];
            }
            // 女士客资的最后一次追踪时间  小于  男士客资的最后一次追踪时间  并且  女客资的最后一次追踪时间在3天内
            else if (($wInfo['c_end_day']<$mInfo['c_end_day']) && ($tAgo<$wInfo['c_end_day'] && $wInfo['c_end_day']<$date)) {
                $arr = array(
                    'order_sn'=>$param['order_sn'],
                );
                $res = $this->checkOrder($arr);
                if($res['error'] != 1){
                    // 返回客资编号
                    $returnData['customer_number'] = $mInfo['customer_number'];
                    return $returnData;
                }
                // 返回数据
                $return = $mInfo['customer_number'];

                // 订单表数据
                $oData['customer_id']       = $mInfo['id'];
                $oData['customer_name']     = $mInfo['customer_name'];
                $oData['shop_code']         = $mInfo['shop_code'];
                $oData['shop_name']         = $mInfo['shop_name'];

                // 客资表数据及条件
                if ($param['wphone']) {
                    if (!$wInfo['mate_tel']) {
                        $cData['mate_tel'] = $param['wphone'];
                    }
                    if (!$wInfo['mate_name']) {
                        $cData['mate_name'] = $param['wname'];
                    }
                    if (!$wInfo['mate_wechat']) {
                        $cData['mate_wechat'] = $param['wwechat'];
                    }
                }

                $where['id'] = $mInfo['id'];
            }
            // 都不在3天之内，返回谁都行，自行判断
            else{
                $arr = array(
                    'order_sn'=>$param['order_sn'],
                );
                $res = $this->checkOrder($arr);
                if($res['error'] != 1){
                    // 返回客资编号
                    $returnData['customer_number'] = $wInfo['customer_number'];
                    return $returnData;
                }
                // 返回数据
                $return = $wInfo['customer_number'];

                // 订单表数据
                $oData['customer_id']       = $wInfo['id'];
                $oData['customer_name']     = $wInfo['customer_name'];
                $oData['shop_code']         = $wInfo['shop_code'];
                $oData['shop_name']         = $wInfo['shop_name'];
                
                // 客资表数据及条件
                // $cData['c_from'] = 2;
                if ($param['mphone']) {
                    if (!$wInfo['mate_tel']) {
                        $cData['mate_tel'] = $param['mphone'];
                    }
                    if (!$wInfo['mate_name']) {
                        $cData['mate_name'] = $param['mname'];
                    }
                    if (!$wInfo['mate_wechat']) {
                        $cData['mate_wechat'] = $param['mwechat'];
                    }
                }

                $where['id'] = $wInfo['id'];
            }

            // 创建订单
            $oData['order_sn']          = $param['order_sn'];
            $oData['consultation_type'] = $mInfo['consultation_type'];
            $oData['target_time']       = $target_time;
            $oData['create_time']       = $mInfo['create_time'];
            $oData['order_type']        = 2;
            $oData['brandclass_id']     = $param['brandclass_id'];
            $oData['brandclass']        = $brandclassInfo['brandclass'];

            db('c_customer_order')->insert($oData);
            
            $cData['order_start_time'] = $target_time;
            // $cData['is_intostore'] = 2;
            // $cData['syjd_day'] = $param['create_time'];
            // $cData['is_valid'] = 1;
            // $cData['yx_day'] = $param['create_time'];

            if ($wInfo['is_valid'] > 1) {
                $cData['is_valid'] = 1;
                $cData['yx_day'] = $param['create_time'];
            }
            if ($wInfo['is_intostore'] != 2) {
                $cData['is_intostore'] = 2;
                $cData['syjd_day'] = $param['create_time'];
            }
            $cData['order_number']     = $param['order_sn'];
            $cData['customer_area_id'] = $param['customer_area_id'];
            $cData['customer_area']    = $param['customer_area'];

            db('c_customerinfo')->where($where)->update($cData);

            // 返回客资编号
            $returnData['customer_number'] = $return;
        }

        return $returnData;
    }
    /*
     * 根据手机号查询此客资的节点
     * */
    public function getInfoByTel($param){
        $where = '';
        if($param['customer_tel']){
            $where['customer_tel'] = trim($param['customer_tel']);
        }
        if($param['customer_qq']){
            $where['customer_qq'] = trim($param['customer_qq']);
        }
        if($param['customer_wechat']){
            $where['customer_wechat'] = trim($param['customer_wechat']);
        }
        if($param['mate_tel']){
            $where['mate_tel'] = trim($param['mate_tel']);
        }
        if($param['brandclass_id']){
            $where['brandclass_id'] = trim($param['brandclass_id']);
        }
        if($param['shop_code']){
            $where['shop_code'] = trim($param['shop_code']);
        }

        $info = db('c_customerinfo')->where($where)->field('id,customer_name,customer_number,customer_tel,mate_tel,customer_qq,customer_wechat,dj_day,dj_staff,fp_day,fp_staff,jr_day,sales_staff,c_star_day,c_end_day,last_trackday,yx_day,yjd_day,syjd_day,order_start_time,order_day,order_number,consulation_shop,customer_intention,customer_type,introducer_type,introducer_name,introducer_tel')->select();
        if(empty($info)){
            return  array('error'=>1,'code'=>500,'msg'=>'无此客资！');
        }else{
            foreach($info as $k=>$v){
                $info[$k]['track_log'] = db('c_salestrackinginfo')->where('customer_id',$v['id'])->order('sales_day asc')->field('sales_staff,sales_day,sales_remark,step_name')->select();
            }
            return $info;
        }
    }

    /**
     * 门市删除订单
     * 
     * @param  staff_id              员工id
     * @param  staff_name            员工姓名
     * @param  order_sn              订单编号 
     *
     * @return boolen
     * @author lilong<lilong@suxuantech.cn>
     */
    public function delOrder($param){
        // 查看订单是否存在
        
        if (!$param['order_sn']) {
            $returnData=['code'=> 400,'msg' => '参数，订单号不存在'];
            return $returnData;
        }
        if (!$param['staff_id']) {
            $returnData=['code'=> 401,'msg' => '参数，员工id不存在'];
            return $returnData;
        }
        if (!$param['staff_name']) {
            $returnData=['code'=> 402,'msg' => '参数，员工姓名不存在'];
            return $returnData;
        }

        $order_sn = $param['order_sn'];
        $haveOrder = db('c_customer_order')->where('order_sn', $order_sn)->count();
        if (!$haveOrder) {
            $returnData=['code'=> 201,'msg' => '订单不存在'];
        }else{
            // 查询订单所属的客资
            $hasCustomer = db('c_customerinfo')
                ->where('order_number', $order_sn)
                ->field('id,is_success,order_start_time,order_number,fact_money,totalpay_money')
                ->find();
            db()->startTrans();
            try {
                // 删除订单及明细
                db('c_customer_order')->where('order_sn', $order_sn)->delete();
                db('c_order_detail')->where('order_sn', $order_sn)->delete();
                // 客资存在，去掉客资里的订单信息
                if ($hasCustomer) {
                    $cData['is_success']       = 2;
                    $cData['order_start_time'] = null;
                    $cData['order_day']        = null;
                    $cData['order_number']     = '';
                    $cData['fact_money']       = 0;
                    $cData['totalpay_money']   = 0;
                    db('c_customerinfo')->where('id',$hasCustomer['id'])->update($cData);
                }
                db()->commit();
                $returnData=['code'=> 200,'msg' => '删除成功'];
            } catch (Exception $e) {
                db()->rollback();
                $returnData=['code'=> 202,'msg' => '操作失败'];
            }
        }

        // 记录日志
        $data = '订单编号：;<br />订单时间：;<br />付款金额：;<br />套系金额：;';

        $oldData = '订单编号：'.$hasCustomer['order_number'].';<br />订单时间：'.$hasCustomer['order_start_time'].';<br />付款金额：'.$hasCustomer['fact_money'].';<br />套系金额：'.$hasCustomer['totalpay_money'].';';
        $customerId = $hasCustomer['id'];
        $staffId  = $param['staff_id'];
        $staffName= $param['staff_name'];
        $module='';
        $controller = '';
        $action='customerInfo';

        history_log($data,$oldData,$customerId,$staffId,$staffName,$module,$controller,$action);

        return $returnData;
    }
}