<?php
/**
 * 客资接口入口
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: wzy<wangzhenya@suxuantech.cn> 2018-1-3 $
 */
namespace app\index\api;

use think\Exception;

class Order{

    /**
     * 开单，添加消费产品，收款操作
     * 开单：新增订单，一销，二销，和总额都是0
     * 添加消费产品：总额不为0，一销二销为0
     * 收款：一销二销其中一个不为0，总额都不为0
     * @param string $param 要加密的字符串
     * $param包含下列字段:
     * order_number         订单号
     * customer_number      客资编号
     * m_name               男士姓名
     * m_phone              男手机号
     * w_name               女士姓名
     * w_phone              女手机号
     * duty_staff           投诉对象（负责人）
     * complain_id          投诉类型
     * source_id            工单来源（1回访，2事业部提报，3会员）
     * level                客诉等级（1一般客诉,2重大客诉）
     * describe             客诉描述
     * order_fact           一销实收
     * order_amount         一销总额
     * two_pin_fact         二销实收
     * two_pin_amount       二销总额
     * brand_id             事业部id
     * shop_code            店面code
     * @return array
     */
    public function addWorkOrder($param){
        $data['order_number']   = trim($param['order_number']);
        $data['customer_number']= trim($param['customer_number']);
        $data['m_name'] = trim($param['m_name']);
        $data['m_phone']= trim($param['m_phone']);
        $data['w_name'] = trim($param['w_name']);
        $data['w_phone']= trim($param['w_phone']);
        $data['level']    = trim($param['level']);
        $data['describe'] = trim($param['describe']);
        $data['source_id']= trim($param['source_id']);//投诉来源id
        $data['source_name'] = trim($param['source_name']);

        $data['complain_id']     = trim($param['complain_id']);//投诉类型id
        $data['complain_name']   = trim($param['complain_name']);//投诉类型

        $data['brand_id']    = trim($param['brand_id']);
        $data['brandclass']  = trim($param['brandclass']);
        $data['shop_code']   = trim($param['shop_code']);
        $data['shop_name']   = trim($param['shop_name']);

        $data['duty_position_code']   = trim($param['duty_position_code']);//负责人岗位code
        $data['duty_position_name']   = trim($param['duty_position_name']);//负责人岗位名称

        $data['duty_staff_id'] = trim($param['duty_staff_id']);
        $data['duty_staff_name'] = trim($param['duty_staff_name']);
        $data['duty_staff_number'] = trim($param['duty_staff_number']);//负责人编号

        //负责人部门
        if($param['department_id']){
            $data['department_id'] = $param['department_id'];
            $data['department_name'] = $param['department_name'];
        }

        //来源
//        if($data['source_id']){
//            $sourceData = db('s_source')->where('id',$data['source_id'])->find();
//            $data['source_name'] = $sourceData['source_name'];
//        }

        //创建人
        $data['create_time'] = date('Y-m-d H:i:s',time());
        $data['create_staff_id']     = $param['create_staff_id'];
        $data['create_staff_name']   = $param['create_staff_name'];
        $data['create_staff_number'] = $param['create_staff_number'];
        $data['create_brand_id']   = $param['brand_id'];
        $data['create_brandclass'] = $param['brandclass'];
        //处理事业部
        $data['manage_brand_id']   = $param['brand_id'];
        $data['manage_brandclass'] = $param['brandclass'];


        do{
            $data['work_number'] = controller('kf/Workorder','lib')->getWorkNumber($data['brand_id']);
            $repeat=db('k_work_order')->where('work_number',$data['work_number'])->find();
        }while(!empty($repeat));

        if(!$data['order_number']){
            return array('error'=>1,'code'=>101,'msg'=>'单号不能为空','data'=>'');
        }
//        if(!$data['describe']){
//            return array('error'=>1,'code'=>102,'msg'=>'客诉描述不能为空','data'=>'');
//        }
        if(!$data['source_id']){
            return array('error'=>1,'code'=>103,'msg'=>'工单来源不能为空','data'=>'');
        }

        //若来源设置为重大客诉，则自动升为重大客诉
        $sourceData = db('s_source')->where('id',$data['source_id'])->find();
        if($sourceData['is_great']==1) {//重大客诉
            $data['level'] = 2;
        }

        $data['is_ks'] = 1;//是客诉

        $res=db('k_work_order')->insert($data);
        if($res===false){
            return array('error'=>1,'code'=>104,'msg'=>'客诉生成失败','data'=>'');
        }else{
            return array('msg'=>'生成客诉工单成功');
        }

    }

    /*
     * 客诉来源
     */
    public function getSource(){
        $res = db('s_source')->select();
        return $res;
    }

    /*
    * 客诉投诉类型
    */
    public function getComplainType($param){
        //$fid = $param['fid']?$param['fid']:0;
        $res = db('s_complain_type')->select();
        return $res;
    }


    /*
     * 客诉列表
     * source_id    客诉来源
     */
    public function getWorkOrderList($param){

        if($param['source_id']){
            $source = 'source_id = :source_id';
            $sourceArr = ['source_id'=>$param['source_id']];
        }

        if(isset($param['order_number'])){
            $number = 'order_number = :order_number';
            $numberArr = ['order_number'=>$param['order_number']];
        }

        $start_time = $param['start_date'];
        $end_time = $param['end_date'];
        $end_time = date("Y-m-d",strtotime("$end_time +1 day"));

        $sql = ' 1 = 1';
        if($start_time)      $sql .= " and create_time >='".$start_time."' ";
        if($end_time)        $sql .= " and create_time <'".$end_time."' ";

        $data = db('k_work_order')
            ->where($source,$sourceArr)
            ->where($number,$numberArr)
            ->where($sql)
            ->select();

        $count = count($data);

        return $data;
    }


    /*
     * 根据客诉单号查询详情（返回详情页链接）
     */
    public function getWorkOrderInfo($param){

        if(!$param['work_number']){
            return array('error'=>1,'msg'=>'没有获取到客诉单号');
        }

        $urlData = config('ext.app_config');
        $urlto = trim($urlData['sx_kf']['addr'],'/');   //获取域名
        $url = $urlto."/index/index/WorkOrderInfo?work_number=".$param['work_number'];
        return array('url'=>$url);

    }



}