<?php
/**
 * 客资接口实现类
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: wzy<wangzhenya@suxuantech.cn> 2018-1-3 $
 */
namespace app\index\lib;

class Customer{
    /*
     * 修改客资信息
     * $param  如：['id'=>$id,'totalpay_money'=>$param['order_amount'],'fact_money'=>$param['order_fact']]
     * return 受影响的行
     * */
    public function updateCustomer($param){
        $res = db('c_customerinfo')->where('id',$param['id'])->update($param);
        return $res;
    }
    /*
     * 修改客资信息
     * $param  如：['id'=>$id,'totalpay_money'=>$param['order_amount'],'fact_money'=>$param['order_fact']]
     * return 受影响的行
     * */
    public function updateCustomerOrder($param){
        $res = db('c_customer_order')->where('order_sn',$param['order_sn'])->update($param);
        return $res;
    }

    /**
     * 根据事业部获取  店（电商，网销，渠道）
     * @param  brandclass_id   事业部id
     * @return array
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getShops($brandclass_id){
        $shopList = cache('brandShop_'.$brandclass_id);
        if (!$shopList || empty($shopList)) {
            $url = '5a37a1503264d';
            $data['brandclass_id']= $brandclass_id;
            $res = sx_call($url, $data);
            if ($res['code'] == 200) {
                $shopList = $res['data'];
                cache('brandShop_'.$brandclass_id, json_encode($shopList));
            }else{
                $shopList = '';
            }
        }else{
            $shopList = json_decode($shopList, true);
        }
        return $shopList;
    }
    /**
     * 根据事业部id 获取事业部名
     * @param  brandclass_id   事业部id
     * @return str
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getBlandclass($brandclass_id){
        $shopList = cache('brandShop_'.$brandclass_id);
        if (!$shopList || empty($shopList)) {
            $url = '5a37a1503264d';
            $data['brandclass_id']= $brandclass_id;
            $res = sx_call($url, $data);
            if ($res['code'] == 200) {
                $shopList = $res['data'];
                cache('brandShop_'.$brandclass_id, json_encode($shopList));
            }else{
                $shopList = '';
            }
        }else{
            $shopList = json_decode($shopList, true);
        }
        return $shopList;
    }

	/**
	 * 检查该客资是否存在于客资系统中
	 * 
	 * @param  brandclass_id         事业部id
	 * @param  shop_code       
     * @param  customer_number       客户编号
	 * @param  customer_tel
	 * @param  customer_wechat
	 * @param  customer_qq
	 *
	 * @return boolean
	 * @author lilong<lilong@suxuantech.cn>
	 */
	public function checkCustomer($param){
        if ($param['customer_number']) {
            $res = db('c_customerinfo')
                ->where('customer_number', $param['customer_number'])
                ->field('id,is_valid,is_intostore,customer_number,shop_code,shop_name,order_number,customer_tel,customer_wechat,customer_qq,customer_weibo,customer_name,mate_tel,mate_wechat,mate_name,mate_sex,sales_staff_id,dj_staff,sales_staff,creator_day,jr_day,c_star_day,c_end_day,yjd_day,syjd_day')
                ->find();
        }

        if (!$res || empty($param['customer_number'])) {
            if ($param['customer_wechat']) {
                $sql = " (customer_wechat = :customer_wechat or customer_qq=:customer_qq or customer_tel = :customer_tel or mate_tel=:mate_tel) ";
                $array['customer_wechat']=$param['customer_wechat'];
                $array['customer_qq']=$param['customer_wechat'];
                $array['customer_tel']=$param['customer_wechat'];
                $array['mate_tel']=$param['customer_wechat'];
            }
            if ($param['customer_qq']) {
                if ($sql) {
                    $sql .= " or (customer_wechat = :customer_wechat1 or customer_qq=:customer_qq1 or customer_tel = :customer_tel1 or mate_tel=:mate_tel1) ";
                } else {
                    $sql= " (customer_wechat = :customer_wechat1 or customer_qq=:customer_qq1 or customer_tel = :customer_tel1 or mate_tel=:mate_tel1) ";
                }
                $array['customer_wechat1']=$param['customer_qq'];
                $array['customer_qq1']=$param['customer_qq'];
                $array['customer_tel1']=$param['customer_qq'];
                $array['mate_tel1']=$param['customer_qq'];
            }
            if ($param['customer_tel']) {
                if ($sql) {
                    $sql .= " or (customer_wechat = :customer_wechat2 or customer_qq=:customer_qq2 or customer_tel = :customer_tel2 or mate_tel=:mate_tel2) ";
                } else {
                    $sql= " (customer_wechat = :customer_wechat2 or customer_qq=:customer_qq2 or customer_tel = :customer_tel2 or mate_tel=:mate_tel2) ";
                }
                $array['customer_wechat2']=$param['customer_tel'];
                $array['customer_qq2']=$param['customer_tel'];
                $array['customer_tel2']=$param['customer_tel'];
                $array['mate_tel2']=$param['customer_tel'];
            }
            // create_time(获取时间),creator_day(录入时间),jr_day(接入时间),c_star_day(开始追踪时间),yjd_day(预约进店时间)
            $res = db("c_customerinfo")
                ->field('id,is_valid,is_intostore,customer_number,shop_code,shop_name,order_number,customer_tel,customer_wechat,customer_qq,customer_weibo,customer_name,mate_tel,mate_wechat,mate_name,mate_sex,sales_staff_id,dj_staff,sales_staff,creator_day,jr_day,c_star_day,c_end_day,yjd_day,syjd_day')
                ->where('brandclass_id', $param['brandclass_id'])
                ->where('is_status', 1)
                ->where($sql,$array)
                ->find();
        };
        return $res;
	}

	/**
	 * 检查该订单是否存在于客资系统中
	 * 
	 * @param  customer_id
	 * @param  order_sn
	 *
	 * @return boolean
	 * @author lilong<lilong@suxuantech.cn>
	 */
	public function checkOrder($param){
		$where = [
			'order_sn'   =>$param['order_sn'],
			// 'customer_id'=>$param['customer_id'],
		];
		$res = db('c_customer_order')->where($where)->find();

		return $res;
	}

    public function getBrandClassInfo($brandclass_id){
        //根据事业部id查询设定的有效条件
        $brandclassInfo = cache('brandclassInfo_'.$brandclass_id);
        if(empty($brandclassInfo)){
            $info = sx_call('5a38840b15ba9',['id'=>$brandclass_id]);
            if($info['code'] == 200){
                cache('brandclassInfo_'.$brandclass_id,$info['data'][0]);
                $brandclassInfo = $info['data'][0];
            }
        }
        return $brandclassInfo;
    }
    //创建订单
    public function addCustomerOrder($param){
        $res = db('c_customer_order')->insertGetId($param);
        // echo db()->getLastSql();
        return $res;
    }

    // 新建客资 
    public function createCustomer($param){
        $date = date('Y-m-d H:i:s');
        $staffInfo = getStaffInfoById($param['staff_id']);
        $create_time = $param['create_time'] ? date('Y-m-d H:i:s',strtotime($param['create_time'])) : $date;
        $data = [
            'brandclass_id'        => (int)$param['brandclass_id'],
            'brandclass'           => $staffInfo['brandclass'],
            'shop_code'            => $staffInfo['shop_code'],
            'shop_name'            => $staffInfo['shop_name'],
            'add_shop_code'        => $staffInfo['shop_code'],
            'add_shop_name'        => $staffInfo['shop_name'],
            'customer_number'      => time().generate_code(),
            'customer_name'        => $param['wname'],
            'customer_tel'         => $param['wphone'],
            'customer_wechat'      => $param['wwechat'],
            'customer_sex'         => '女',
            'mate_name'            => $param['mname'],
            'mate_tel'             => $param['mphone'],
            'mate_wechat'          => $param['mwechat'],
            'mate_sex'             => '男',
            'marry_day'            => $param['marry_day'] ? date('Y-m-d H:i:s', strtotime($param['marry_day'])) : NULL,
            'ready_baby_day'       => $param['ready_baby_day']?date('Y-m-d H:i:s',strtotime($param['ready_baby_day'])):NULL,
            'consultation_type_id' => (int)$param['consultation_type_id'],
            'consultation_type'    => $param['consultation_type'],
            'customer_area_id'     => (int)$param['customer_area_id'],
            'customer_area'        => $param['customer_area'],
            'customer_cource_id'   => (int)$param['customer_cource_id'],
            'customer_cource'      => $param['customer_cource'],
            'c_from'               => 2,
            'is_intostore'         => 2,
            'syjd_day'             => $create_time,
            'creator_day'          => $create_time,
            'create_time'          => $create_time,
            'dj_day'               => $create_time,
            'dj_staff'             => $staffInfo['staffname'],
            'dj_staff_id'          => $param['staff_id'],
            'dj_staff_number'      => $staffInfo['staffnumber'],
            'tel_staff_id'         => $param['staff_id'],
            'tel_staff'            => $staffInfo['staffname'],
            'tel_time'             => $create_time,
            'is_first_tel'         => 1,
            'wechat_staff_id'      => $param['mwechat'] ? $param['staff_id'] : '',
            'wechat_staff'         => $param['mwechat'] ? $staffInfo['staffname'] : '',
            'wechat_time'          => $param['mwechat'] ? $create_time : NULL,
            'is_first_wechat'      => $param['mwechat'] ? 1 : '',
            'customer_type'        => 1,
            'consulation_shop_code'=> $staffInfo['shop_code'],
            'consulation_shop'     => $staffInfo['shop_name'],
            'reception_id'         => $param['staff_id'],
            'reception_name'       => $staffInfo['staffname'],
            'order_number'         => $param['order_sn'],
            'order_start_time'     => $create_time,
            'is_valid'             => 1,
            'yx_day'               => $param['create_time'],
        ];

        $res = db('c_customerinfo')->insertGetId($data);
        $data['id']     = $res;
        $data['status'] = 1;
        $return = $data;
        return $return;
    }

    // 判断订单是否有效
    public function checkOrderValid($param){
        $brandclassInfo = $this->getBrandClassInfo($param['brandclass_id']);
        if(!empty($brandclassInfo)){
            //实收款
            if($brandclassInfo['order_rule'] == 1){
                // 有效
                if ( $param['fact_money'] >= $brandclassInfo['proportion'] ) {
                    return true;
                }else{
                    return false;
                }
            }
            //占比
            else if ($brandclassInfo['order_rule'] == 2) {
                if ($brandclassInfo['proportion']/100*$param['order_money'] <= $param['fact_money']) {
                    return true;
                }else{
                    return false;
                }
            }
            //未设定订单有效标准时，按订单金额的30%计算，有效订单
            else{
                if (0.3*$param['order_money'] <= $param['fact_money']) {
                    return true;
                }else{
                    return false;
                }
            }
        }else{
            return false;
        }
    }
}