<?php
/**
 * KF 基本模块
 * 默认接口方法，此方法内定议基础框架所需要的方法，用于验证模块合法性，模块版本，对接基础架构中需要的方法
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: wangyining<wangyining@suxuantech.cn> 2018-04-11 $
 */
namespace app\kf\controller;
use app\kf\lib\Target;
use think\Cache;
use app\index\controller\Base;
use think\Exception;
use think\Log;
use think\Request;
use think\Session;
use PHPExcel_IOFactory;
use PHPExcel;
use Excel5;
use think\Controller;
use app\common\lib\redisQueue;
class Bottle extends Base{

    /**漂流瓶列表
     * @return \think\response\View
     */
    public function bottleList(){

        if(Request::instance()->isAjax()){
            $data = input();
            //print_r($data);die;
            $detail=controller("Bottle","lib")->bottleListData($data);

            echo  json_encode($detail);
        }else{
            $brand=controller('Visit','lib')->get_brandclass();
            $this->assign('brand',$brand);
            return view('bottlelist');
        }

    }

    /*
     * 列表页每个标签数量
     */
    public function bottleNum(){
        $num = controller('Bottle','lib')->bottleNum(input());
        if($num){
            return array('code'=>1,'data'=>$num);
        }
    }

    /*
     * 获取某事业部下店面
     */
    public function get_shop(){
        $brand_id = input('post.brand_id');
        $shop=controller('Visit','lib')->get_shop(array('brandclass_id'=>$brand_id));
        if($shop){
            return array('code'=>1,'data'=>$shop);
        }
    }

    //领取漂流瓶
    public function bottleReceive(){
        $res=controller('Bottle','lib')->bottleReceive(input('post.id'));
        if($res===false){
            return array('code'=>0,'msg'=>'领取失败，请稍后重试');
        }else{
            return array('code'=>1,'msg'=>'领取成功');
        }

    }

    //处理
    public function manage(){
        $data=db('k_drift_bottle')->where('id',input('get.id'))->find();
        $this->assign('detail',$data);
        return view('manage');
    }

    //标记为已处理
    public function doManage(){
        $data=input();
        $detail['note'] = $data['note'];
        if($data['is_manage']==1)  $detail['status'] = 3;
        $res=db('k_drift_bottle')->where('id',$data['id'])->update($detail);
        if($res===false){
            return array('code'=>0,'msg'=>'提交失败');
        }else{
            return array('code'=>1,'msg'=>'提交成功');
        }
    }

    //详情
    public function bottleInfo(){
        $data=db('k_drift_bottle')->where('id',input('get.id'))->find();
        $this->assign('detail',$data);
        return view('bottleinfo');
    }


    /*
      * 漂流瓶
      */
    public function driftBottle(){

        return view('driftbottle');
    }

    /*
     * 扔漂流瓶
     */
    public function addBottle(){
        $content=input('post.content');
        $data['content'] = $content;
        $data['create_staff_id'] = session('staff_id');
        $data['create_staff_name'] = session('staff_name');
        $data['create_staff_number'] = session('staff_number');
        $data['create_time'] = date('Y-m-d H:i:s',time());
        $data['brand_id'] = session('brand_id');
        $data['brandclass'] = session('brandclass');
        $data['shop_code'] = session('shop_code');
        $data['shop_name'] = session('shop_name');
        $res=db('k_drift_bottle')->insert($data);
        if($res===false){
            return array('coce'=>0,'msg'=>'力气太小啦，用里扔~');
        }else{
            return array('code'=>1,'msg'=>'扔瓶子成功~');
        }

    }

    /*
     * 我的漂流瓶
     */
    public function myBottle(){
        $list=db('k_drift_bottle')->where('create_staff_number',session('staff_number'))->where('my_delete',null)->where('is_hidden',2)->select();
        $str='';
        foreach($list as $k => $v){
            $v['create_time'] = date('Y/m/d',strtotime($v['create_time']));
            $str .='<div class="lbd b_list" data-value="'.$v['id'].'">
                    <div class="lbd_left">
                        <img class="lbd_img" src="/img/pz.png">
                    </div>
                    <div class="lbd_center get_info">
                        <span>'.$v['content'].'</span>
                    </div>
                    <div class="lbd_right">
                        <span>'.$v['create_time'].'</span>
                        <a href="#" class="b_delete">删除</a>
                    </div>
                </div>';
        }
        return array('code'=>1,'str'=>$str);
    }

    /*
     * 漂流瓶详情
     */
    public function getInfo(){
        $id=input('post.id');
        $res=db('k_drift_bottle')->where('id',$id)->find();
        if($res){
            return array('code'=>1,'data'=>$res);
        }
    }

    /*
     * 删除漂流瓶
     */
    public function delBottle(){
        $res=db('k_drift_bottle')->where('id',input('post.id'))->update(['is_hidden'=>1]);
        if($res===false){
            return array('code'=>0,'msg'=>'删除失败');
        }else{
            return array('code'=>1,'msg'=>'删除成功');
        }
    }

    /*
     * 二维数组去重
     *  $arr  数组
     *  $key  判断重复的key
     */
    public function array_unset_unique($arr,$key){
        $res = array();
        foreach ($arr as $value) {
            if(isset($res[$value[$key]])){
                unset($value[$key]);
            }
            else{
                $res[$value[$key]] = $value;
            }
        }
        return $res;
    }





}