<?php
/**
 * CRM 基本模块
 * 默认接口方法，此方法内定议基础框架所需要的方法，用于验证模块合法性，模块版本，对接基础架构中需要的方法
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: songdemei<songdemei@suxuantech.cn> 2017-10-17 $
 */
namespace app\kf\controller;
use app\kf\lib\Target;
use think\Cache;
use app\index\controller\Base;
use think\Exception;
use think\Log;
use think\Request;
use think\Session;
use PHPExcel_IOFactory;
use PHPExcel;
use Excel5;
use think\Controller;
use app\common\lib\redisQueue;
class Customer extends Base
{
    public function check()
    {
        return $this->fetch();
    }

    public function test()
    {
        $image = \think\Image::open(ROOT_PATH . 'public/img/modal4.jpg');
        //读取图片添加水印，下方是接收图片添加为水印
        // $photo = \think\Image::open(request()->file('photo'));
        // $name = \think\Image::open(request()->file('nick_name'));
        // $ewm = \think\Image::open(request()->file('ewm'));
        $arr = input('post.');
        $photo_x = $arr['photo_x'] ? $arr['photo_x'] : 10;
        $photo_y = $arr['photo_y'] ? $arr['photo_y'] : 10;
        $name_x = $arr['name_x'] ? $arr['name_x'] : 150;
        $name_y = $arr['name_y'] ? $arr['name_y'] : 50;
        $ewm_x = $arr['ewm_x'] ? $arr['ewm_x'] : 0;
        $ewm_y = $arr['ewm_y'] ? $arr['ewm_y'] : $image->height() - 195;
        $path = '/upload/' . time() . '.jpg';
        // 给原图左上角添加水印并保存
        $image->resize_img(ROOT_PATH . 'public/img/head-img.png', $path);//压缩
        $img = $image->test(ROOT_PATH . 'public/img/head-img.png', $path);//裁剪成圆形
        $image->water($img, [$photo_x, $photo_y]);
        // 给原图左上角添加文字水印并保存
        $image->text('素玄科技', ROOT_PATH . 'public/font/fonts/HYQingKongTiJ.ttf', 30, '#00000000', [$name_x, $name_y]);
        //左下角加二维码水印
        $image->water(ROOT_PATH . 'public/img/ewm.jpg', [$ewm_x, $ewm_y]);
        $image->save(ROOT_PATH . 'public' . $path);

        $this->assign('path', $path);
        return $this->fetch();
    }

    /**
     * 清除模版缓存 不删除 temp目录
     */
    public function clear_temp_ahce()
    {
        $my_files = (array)glob(TEMP_PATH . '/*.php');
        array_map(
            function ($v) {
                if (file_exists($v))
                    @unlink($v);
            }, $my_files
        );
        @unlink(ROOT_PATH . 'public/login.html');//登录缓存文件
        //清除session
        session('position_list', null);
        session('brandclass_list', null);
        session('source', null);
        session('channel', null);
        session('accessModel', null);
        session('intention', null);
        session('region', null);
        session('areaSet', null);
        session('capacity', null);
        session('consumptionType', null);
        session('orderAddress', null);
        session('positions_' . session('staff_id'), null);
        //清除菜单缓存
        cache('KF_menuAllS', null);
        cache('KF_menu_p15156347814477', null);
        cache('KF_menu_position1512878846', null);
        //linux下没有缓存文件会报错，清除前必须判断文件存不存在
        // array_map( 'unlink', glob(TEMP_PATH.'*.php' ) );
    }

    public function index()
    {


        // 获取个人信息
        $staffId = input('param.id');
        if (!empty($staffId)) {
            $staffId = $staffId;
        } else {
            $staffId = session('staff_id');
        }
        $info = controller('kf/Customer', 'lib')->get_staff_info(array('staff_id' => $staffId));//个人信息
        if (empty($info['data'])) {
            alert('查看有误，无信息', '/');
            exit();
        }
        $this->assign('info', $info['data']);

        $this->assign('title', '首页');
        return view('home');

    }

    public function checkLogin()
    {
        echo check_login();
    }

    /*
    * 插入手机归属地信息
    * */
    public function insTelInfo()
    {
        $res = controller('crm/Customer', 'lib')->insTelInfo(input('param.tel'));
        return $res;
    }

    /*
    * 查询手机归属地信息
    * */
    public function getTelInfo()
    {
        $res = controller('crm/Customer', 'lib')->getTelInfo(input('post.'));
        return $res;
    }

    public function jqgrid()
    {
        //表格自定义
        // $jq_name = [ '客户编号', '追踪日期', '名字', '追踪阶段', '手机','接单点', '介绍人', '追踪人' ];
        if (session('staff_id')) {
            $jqgrid = cache('jqgrid_' . session('staff_id'));
            // dump(($jqgrid));die;
            // $jqgrid['name'] = $jqgrid['name'] ? $jqgrid['name'] : [];
            $jqgrid['model'] = json_encode($jqgrid['model']);
            return $jqgrid;
        }

        // $this->assign('jq_name',json_encode($jqgrid['name']));
        // $this->assign('jq_model',json_encode($jqgrid['model']));
        // $this->assign('jq_name',json_encode($jq_name));
    }


    public function getMessage()
    {
        $message = controller('crm/Customer', 'lib')->message_list(input('post.send_type'));
        return json_encode($message);
    }

    public function getNotice()
    {
        $message = controller('crm/Customer', 'lib')->message_list(2);
        return json_encode($message);
    }

    //修改信息，通知
    public function update_message()
    {
        $id = input('post.id');
        $res = controller('crm/Customer', 'lib')->update_message($id);
        $whereCount = [
            'receive_id' => session('staff_id'),
            'read_status' => 0,
            'is_delete' => 0
        ];
        $noRead = db('c_message')->where($whereCount)->count();
        return $noRead;
    }

    //获取最后活动时间
    public function getStaffOnlineStatus($staff_id)
    {
        return controller('crm/Customer', 'lib')->getStaffOnlineStatus($staff_id);
    }

    //修改在线状态
    public function update_status()
    {
        $status = input('post.status');
        $res = controller('crm/Customer', 'lib')->update_status($status);
        return $res;
    }






    public function logOut()
    {
        $staffId = session('staff_id');
        controller('kf/Customer', 'lib')->logOut($staffId);
        if (is_weixin()) {
            $this->redirect('kf/Index/wxLogin');
        } else {
            $this->redirect('kf/Index/index');
        }
    }

    public function show_pwd()
    {
        return $this->fetch('update_pwd');
    }

    public function bindWeixin()
    {
        $staffId = session('staff_id');
        if (IS_POST === true) {
            $password = input('post.password');
            $res = sx_call('5a221c9548d47', ['staffname' => session('staff_name'), 'password' => $password]);
            if ($res['code'] == 200) {
                $bindCode = get_rand_string(16);
                cache('bindWX_' . $staffId, ['code' => $bindCode, 'staffname' => session('staff_name'), 'password' => $password, 'state' => 'init'], 60);
                $url = Url('bindWeixin', ['stff_id' => $staffId, 'bind_code' => $bindCode, 'act' => 'showqrcode']);
                $url = Url('bindWeixin', '', '', true);
                $url = strpos($url, '?') ? ($url . '&') : ($url . '?');
                $url = $url . 'staff_id=' . $staffId . '&bind_code=' . $bindCode . '&act=showqrcode';
                return json(['code' => 200, 'bind_code' => $bindCode, 'staff_id' => $staffId, 'img_url' => $url]);
            } else {
                return json(['code' => 500, 'msg' => '验证失败，可能密码错误。']);
            }
            exit();
        }
        $act = input('get.act');
        if ($act == 'showqrcode') {
            $bindCode = input('get.bind_code');
            $staffId = input('get.staff_id');
            $url = Url('index/bindWeixin', '', '', true);
            $url = strpos($url, '?') ? ($url . '&') : ($url . '?');
            $url = $url . 'staff_id=' . $staffId . '&bind_code=' . $bindCode;
            $qrcode = new \Endroid\QrCode\QrCode();
            $qrcode->setText($url);
            echo $qrcode->writeString();
        }
        if ($act == 'getbind') {
            //手机端绑定界面
            $res = cache('bindWX_' . $staffId);
            if ($res && $res['state'] == 'binded') {
                return json(['code' => 200, 'msg' => '绑定成功', 'data' => ['state' => 'binded']]);
                exit();
            } elseif (!$res) {
                return json(['code' => 503, 'msg' => '绑定失败或二维码已过期，请重试', 'data' => []]);
                exit();
            }
            return json(['code' => 200, 'msg' => '', 'data' => []]);
            //return $this->fetch('bind_page');
            exit();

        }
        $staffInfo = sx_call('5a18e3fa516a1', ['staff_id' => $staffId]);
        $this->assign('staffInfo', $staffInfo[0]);
        return $this->fetch();
    }

    public function edit_pwd()
    {
        $param['staff_id'] = session('staff_id');
        $param['newPassword'] = input('post.newPassword');
        $param['oldPassword'] = input('post.oldPassword');
        $res = controller('kf/Customer', 'lib')->update_pwd($param);
        return $res;
    }




    //移动端二维码
    public function myqrcode()
    {
        $param = input('param.');
        $param['customer_channel'] = urlencode($param['customer_channel']);
        if ($param['introducer_name']) {
            $param['introducer_name'] = urlencode($param['introducer_name']);
        }

        unset($param['/crm/customer/myqrcode_html']);
        $a = arrayToParams($param);
        $u = strpos($_SERVER['HTTP_HOST'], 'http://') ? $_SERVER['HTTP_HOST'] : 'http://' . $_SERVER['HTTP_HOST'];
        $u .= "/crm/index/appTB?";
        if ($param['customer_type'] == 2) {
            $url = $u . "dj_staff_id=" . session('staff_id') . "&dj_staff_number=" . session('staff_number') . "&dj_staff=" . urlencode(session('staff_name')) . "&shop_code=" . $param['shop_code'] . "&brandclass_id=" . session('brandclass_id') . "&brandclass=" . urlencode(session('brandclass')) . "&add_shop_code=" . session('belong_shop_code') . "&add_shop_name=" . urlencode(session('belong_shop_name')) . '&' . $a;
        } else {
            $url = $u . "dj_staff_id=" . session('staff_id') . "&dj_staff_number=" . session('staff_number') . "&dj_staff=" . urlencode(session('staff_name')) . "&brandclass_id=" . session('brandclass_id') . "&brandclass=" . urlencode(session('brandclass')) . "&add_shop_code=" . session('belong_shop_code') . "&add_shop_name=" . urlencode(session('belong_shop_name')) . "shop_code=" . '&' . $a;
        }
        $qrcode = new \Endroid\QrCode\QrCode();
        $qrcode->setText($url);
        echo $qrcode->writeString();
        exit();
    }

    public function qrcode()
    {
        $param = input('post.');
        $channel = sx_call('59fd5e729e5a8', array('id' => $param['channel_id']));//渠道名称
        $shop = sx_call('5a005e0038270', array('shop_code' => $param['shop_code']));//提交店面信息
        $this->assign('channel', $channel['data'][0]);
        $this->assign('shop', $shop['data'][0]);
        $this->assign('customer_type', $param['customer_type']);
        return $this->fetch();
    }



    public function check_right()
    {
        $code = input('post.');
        if (check_right($code['code'])) {
            $num = 1;
        } else {
            $num = 5;
        }
        $this->success('验证权限成功', '/', $num);
    }


    //通过归属地查询省市
    public function getAddressInfo()
    {
        $info = input('post.name');
        $arr = explode(' ', $info);
        if (count($arr) == 1) {
            $ret['pid'] = controller("Customer", "lib")->getAddressByLike(['name' => $arr[0]]);
        } else {
            $ret['pid'] = controller("Customer", "lib")->getAddressByLike(['name' => $arr[0]]);
            $ret['cid'] = controller("Customer", "lib")->getAddressByLike(['name' => $arr[1]]);
        }
        return $ret;
    }

    public function upload_img()
    {
        //$content = input('content');
        $file = Request::instance()->file('file');
        if (empty($file)) {
            $result["code"] = "1";
            $result["msg"] = "请选择图片";
            $result['data']["src"] = '';
        } else {
            // 移动到 目录下
            $info = $file->move(ROOT_PATH . 'public' . DS . 'upload/img');
            if ($info) {
                $name_path = str_replace('\\', "/", $info->getSaveName());
                //成功上传后 获取上传信息
                $result["code"] = '0';
                $result["msg"] = "上传成功";
                $result['data']["src"] = "/upload/img/" . $name_path;
            } else {
                // 上传失败获取错误信息
                $result["code"] = "2";
                $result["msg"] = "上传出错";
                $result['data']["src"] = '';
            }
        }
        //$a='http://crm.sx.com/public/uploads/img/20171221/2af12f7d271e633836abb03f48f559db.jpg';
        //print_r($result);die;
        return json_encode($result);
    }

    /**
     *      把秒数转换为时分秒的格式
     * @param Int $times 时间，单位 秒
     * @return String
     */
    static function secToTime($times)
    {
        // $result = '00:00:00';
        $result = '00:00';
        if ($times > 0) {
            $hour = 1;
            $minute = floor(($times - 3600 * $hour) / 60);
            $second = floor((($times - 3600 * $hour) - 60 * $minute) % 60);
            $result = $minute . ':' . $second;
            // $result = $hour.':'.$minute.':'.$second;
        }
        return $result;
    }

    public function setJQGrid()
    {
        $param = input('post.');
        $arr = $param['arrColumn'];
        $column = implode(',', $arr);
        db()->startTrans();
        try {
            $data['custom_name'] = $param['name'] ? json_encode($param['name']) : null;
            $data['custom_model'] = $param['model'] ? json_encode($param['model']) : null;
            $data['custom_column'] = $column;
            $data['staff_id'] = session('staff_id');
            //查询有无数据
            $info = db('s_custom_column')->where('staff_id', session('staff_id'))->find();
            if ($info['id']) {
                db('s_custom_column')->where('staff_id', session('staff_id'))->update($data);
            } else {
                db('s_custom_column')->insert($data);
            }

            cache('colColumn_' . session('staff_id'), $column);
            cache('colNames_' . session('staff_id'), $param['name'] ? json_encode($param['name']) : null);
            cache('colModel_' . session('staff_id'), $param['model'] ? json_encode($param['model']) : null);
            action_log($param, '', 0, session('staff_id'), session('staff_name'));
            db()->commit();
            return true;
        } catch (Exception $e) {
            db()->rollback();
            return false;
        }
    }

    //查询自定义列
    public function getCustomColumn()
    {
        $column = cache('colColumn_' . session('staff_id'));
        $names = cache('colNames_' . session('staff_id'));
        $model = cache('colModel_' . session('staff_id'));

        if (strlen($column) > 0 && !$names && !$model) {
            $info = array(
                'custom_name' => json_encode($names),
                'custom_model' => json_encode($model),
            );
        } else {
            $info = db('s_custom_column')->where('staff_id', session('staff_id'))->find();
            if (!empty($info)) {
                cache('colColumn_' . session('staff_id'), $info['custom_column']);
                cache('colNames_' . session('staff_id'), $info['custom_name']);
                cache('colModel_' . session('staff_id'), $info['custom_model']);
                $info = array(
                    'custom_name' => ($info['custom_name']),
                    'custom_model' => ($info['custom_model']),
                );
            }
        }
        return $info;
    }

    //获取短信模板内容
    public function getModelContent()
    {
        $id = input('post.id');
        $res = db('s_message_templateinfo')->where('id', $id)->find();
        if ($res) {
            return $res;
        } else {
            return false;
        }
    }

    //事业部下的店
    public function searchShop()
    {
        $brandclass_id = session('brandclass_id');
        if (!$brandclass_id) {
            return false;
        }
        $url = '5a37a1503264d';
        $data['brandclass_id'] = $brandclass_id;
        $res = sx_call($url, $data);
        if ($res['code'] == 200) {
            $shopList = $res['data'];
        } else {
            $shopList = '';
        }
        return $shopList;
    }

    public function moreSearch()
    {
        // 权限
        $auth = check_right('menu1521267312');
        if (!$auth) {
            controller('crm/Index', 'controller')->index();
            exit;
        }
        return $this->fetch();
    }



    // 员工请求  ajax递归，订阅发布频道
    public function staffSubscribe($msg_id){
        // 第一次请求，$msg_id == 0
        // list1：最近10条消息，不区分已读未读；messageList
        // list2：最近五条未读弹框消息 popList
        // noRead：未读消息数目
        // mid：最近一条消息的id
        // 之后的请求  $msg_id != 0
        // 数据库对比最后一条消息的id
        //   一样 则 订阅频道
        // 不一样 则 取出后面的消息，两个list弹框和铃铛，noRead，mid

        // 第一次请求
        if ($msg_id == 0 || !$msg_id) {
            // 获取最近10条消息
            $messageList = controller("Customer","lib")->getMessageList($msg_id);
            // 需要弹窗的最近五条消息
            $popList = controller("Customer","lib")->getPopList($msg_id);
            // 没有获取到数据   开启监听
            if (!$messageList) {
                $channel = array('notice');
                $callback= 'noticeCallBack';
                $message = controller("Customer","lib")->webSubscribe($channel, $callback);
                // 监听频道超时
                if ($message === false) {
                    $return['mid']        = $msg_id;
                    $return['noRead']     = controller("Customer","lib")->getNewMessageNum();
                    $return['popList']    = array();
                    $return['messageList']= array();
                    return json($return);
                }

                $messageList = array($message);
                $popList = array($message);

                $return['mid']        = $message['id'];
                $return['noRead']     = controller("Customer","lib")->getNewMessageNum();
                $return['popList']    = array($message);
                $return['messageList']= array($message);
                return json($return);
            }
        }else{
            // 最新的消息id
            $mid = controller("Customer","lib")->getNewMessageId();
            // 新消息id大于传值id
            if ($mid > $msg_id) {
                // 获取新的消息，即大于传值id的消息
                $messageList = controller("Customer","lib")->getMessageList($msg_id);
                // 获取新的弹框消息，即大于传值id的消息
                $popList = controller("Customer","lib")->getPopList($msg_id);
            }else{
                // 开启监听
                $channel = array('notice');
                $callback= 'noticeCallBack';
                $message = controller("Customer","lib")->webSubscribe($channel, $callback);

                // 监听频道超时
                if ($message === false) {
                    $return['mid']        = $msg_id;
                    $return['noRead']     = controller("Customer","lib")->getNewMessageNum();
                    $return['popList']    = array();
                    $return['messageList']= array();
                    return json($return);
                }

                $messageList = array($message);
                $popList = array($message);

                $return['mid']        = $message['id'];
                $return['noRead']     = controller("Customer","lib")->getNewMessageNum();
                $return['popList']    = array($message);
                $return['messageList']= array($message);
                return json($return);
            }
        }
        // 获取最近一条消息id
        $mid = controller("Customer","lib")->getNewMessageId();
        // 获取未读 消息数目
        $noRead = controller("Customer","lib")->getNewMessageNum();

        $return['mid'] = $mid;
        $return['noRead'] = $noRead;
        $return['messageList'] = $messageList;
        $return['popList'] = $popList;

        return json($return);
    }

}