<?php
/**
 * KF 品控中心->知识库
 * 默认接口方法，此方法内定议基础框架所需要的方法，用于验证模块合法性，模块版本，对接基础架构中需要的方法
 * 此类不作任何业务逻辑
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: chaidongdong<chaidongdong@suxuantech.cn> 2018-4-23 $
 */
namespace app\kf\controller;

use app\index\controller\Base;
use think\Request;
use app\kf\lib\Setting;

class Knowledge extends Base{
    
    // public function index(){
        // $a = saveLoginSessions();
        // dd($a);/
        // $a = controller('Setting','lib')->brandclass_list();
        // dd($a);
    //     $this->knowledgeList();
    // }

    /**
     * 知识库目录
     *
     * @param int $id 目录ID
     * @return unknow
     * @author chaidongdong@suxuantech.cn
     */
    public function knowledgeList(){
        $data = input();
        $data['id']= intval($data['id']) ? intval($data['id']) : 0;
        if(Request::instance()->isAjax()){
            if($data['type'] == 'back'){
                $pid = controller('Knowledge','lib')->getPKnowledgeClass($data);
                echo json_encode(['code'=>0,'msg'=>'','data'=>$pid]);
                exit;
            }
            $detail=controller("Knowledge","lib")->getKnowledgePower($data);
            echo json_encode(['code'=>0,'msg'=>'','count'=>count($detail),'data'=>$detail]);
            exit;
        }
        $class_path = controller('Knowledge','lib')->getKnowledgeClassPath($data['id']);
        $this->assign('class_path',$class_path);
        $this->assign('id',$data['id']);
        return view('knowledgelist');
    }

    /**
     * 修改目录页面 
     *
     * @param string $id
     * @return unknown
     * @author chaidongdong@suxuantech.cm
     */
    public function knowledgeClassSave(){
        $data = input();
        if($data['id']){
            $class = controller('Knowledge','lib')->getOneKnowedgeClass(['id'=>$data['id']]);
        }
        $p_id = $data['p_id'] ? $data['p_id'] : $class['p_id'];
        $this->assign('class',$class);
        $this->assign('p_id',$p_id);
        return $this->fetch();
    }

    /**
     * 添加/修改目录
     *
     * @param string $name 目录名称
     * @return json
     * @author chaidongdong@suxuantech.cn
     */
    public function saveknowledgeClass(){
        $data = input('post.');
        if(!$data['id']){
            $data['create_staff_id'] = session('staff_id');
            $res = controller('Knowledge','lib')->addKnowledgeClass($data,$msg);
        }else{
            $res = controller('Knowledge','lib')->editKnowledgeClass($data,$msg);
        }
        if($res){
            echo json_encode(['code'=>1,'msg'=>$msg]);
        }else{
            echo json_encode(['code'=>0,'msg'=>$msg]);
        }
        exit;
    }

    /**
     * 修改文章页面
     *
     * @param int $id
     * @return unknown
     * @author chaidongdong@suxuantech.cn
     */
    public function knowledgeSave(){
        $data = input();
        if($data['id']){
            $knowledge = controller('Knowledge','lib')->getOneKnowledge($data);
            $this->assign('data',$knowledge);
        }
        $class_id = $data['class_id'] ? $data['class_id'] : $knowledge['class_id'];
        $this->assign('class_id',$class_id);
        return $this->fetch();
    }

    /**
     * 添加、修改文章
     *
     * @param array $data
     * @return json
     * @author chaidongdong@suxuantech.cn
     */
    public function saveknowledge(){
        $data = input();
        $data = array_filter($data);
        // dd($data);
        if(!$data['id']){
            $data['create_staff_id'] = session('staff_id');
            $res = controller('Knowledge','lib')->addKnowledge($data,$msg);
        }else{
            $res = controller('Knowledge','lib')->editKnowledge($data,$msg);
        }
        if($res){
            echo json_encode(['code'=>1,'msg'=>$msg]);
        }else{
            echo json_encode(['code'=>0,'msg'=>$msg]);
        }
        exit;

    }

    /**
     * 删除文章
     *
     * @param string $id
     * @return json
     * @author chaidongdong@suxuantech.cn
     */
    public function delKnowledge(){
        $data = input();
        $res = controller('Knowledge','lib')->delKnowledge($data,$msg);
        if($res){
            echo json_encode(['code'=>1,'msg'=>$msg]);
        }else{
            echo json_encode(['code'=>0,'msg'=>$msg]);
        }
        exit;
    }

    /**
     * 删除目录
     *
     * @param string $id
     * @return json
     * @author chaidongdong@suxuantech.cn
     */
    public function delKnowledgeClass(){
        $data = input();
        $res = controller('Knowledge','lib')->delKnowledgeClass($data,$msg);
        if($res){
            echo json_encode(['code'=>1,'msg'=>$msg]);
        }else{
            echo json_encode(['code'=>0,'msg'=>$msg]);
        }
        exit;

    }





}