<?php
/**
 * kf 手机端页面
 * 默认接口方法，此方法内定议基础框架所需要的方法，用于验证模块合法性，模块版本，对接基础架构中需要的方法
 * 此类不作任何业务逻辑
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: chaidongdong<chaidongdong@suxuantech.cn> 2018-5-9 $
 */
namespace app\kf\controller;

use app\kf\model\TTestAnswer;
use think\Controller;
use think\Request;
use app\common\lib\redisQueue;
//use app\kf\lib\RunStatistics;
header('Content-type:text/html;charset=utf8');
define('IS_POST', \think\Request::instance()->isPost());
class Mobile extends Controller
{
    protected  $beforeActionList = [
        'check_login' =>  [
            'except'=>['login','is_weixin','wxsign','getquality','getbrandshoplist','handquality'
            ]
        ],
        // 'session_url'=>[
        //     'except'=>[
        //         'login','is_weixin','wxsign',
        //         'submitStaffTestAnswer','handQuality','outputJson','outputErrorView'
        //     ]
        // ]
    ];

    /**
     * 检查登录
     */
    public function check_login(){

        // $http = $_SERVER['HTTPS'] ? 'http://' : 'http://';
        // $url = $http.$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];
        // if(session('return_url')){
        //     $this->assign('return_url',session('return_url'));
        // }

        if(!check_login()){
            $http = $_SERVER['HTTPS'] ? 'https://' : 'http://';
            $url = $http.$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];
            $this->redirect('/kf/Mobile/login.html?return_url='.$this->lock_url($url));
        }
    }

    /**
     * 个人中心
     * @return mixed
     */
    public function index(){
        $res = controller('Quality','lib')->checkPosition_code(session('main_position_code'));   //质检单权限
        $this->assign('quality',$res);
        return $this->fetch();
    }

    /**
     * 登录
     *
     * @param string $username
     * @param string @password
     * @return mixed
     */
    public function wxSign(){
        if(check_login()){
            $this->redirect('/kf/Mobile/index');
        }
        $data = input();
        $param['password'] = input('post.password');
        $param['staffname'] = input('post.staffname');
        $param['five'] = input('post.five');
        $param['open_id'] = session('openid');
        $res = controller('kf/Customer','lib')->wx_login($param);
        return $res;
    }

    /**
     * 检查登录
     */
    public function login(){
        $data = input();
        $this->assign('return_url',$this->unlock_url($data['return_url']));
        //判断是PC还是微信登录，
        if($this->is_weixin()){
            $openId = session('openid');

            if(!$openId){

                $code = $_GET['code'];

                if(empty($code)){
                    get_wx_openid('login');
                }else{
                    $res = sx_call('5a0e5f4ced930', ['code'=>$code]);
                    if($res['code'] == 200){
                        $openId = $res['data']['openid'];
                    }
                    session('openid',$openId);
                }
            }
            cookie('code',$code);
            cookie('open',$openId);
            $autoLogin = sx_call('5a2a39b803dc2', ['open_id' => $openId]);
            if ($autoLogin['code'] == 200 && !empty($autoLogin['data'])) {
                $autoLogin['data']['staff_id'] = $autoLogin['data']['id'];
                $loginres = controller('kf/Customer', 'lib')->setLoginEnv($autoLogin['data'], 'wx', 'auto');
                if (!$loginres) {
                    return $this->fetch('index/wx_login');
                }else{
                    if(session('return_url')){
                        $returnUrl = session('return_url');
                        session('return_url',null);
                        $this->redirect($returnUrl);
                    }else{
                        $this->redirect('kf/Mobile/index');
                    }
                }
            } else {
                return $this->fetch('mobile/login');
            }
        }else{
            if(check_login()){
                // 微信模板消息
                $content = [
                    'touser'       => session('staff_id'),
                    'template_id'  => OPENTM_DL,
                    'data'         => [
                        'first'=>[
                            'value'=> '您好,'.session('staff_name').',您已成功登录客服系统',
                            'color'=> '#173177'
                        ],
                        'time'=>[
                            'value'=> date('Y-m-d H:i:s'),
                            'color'=> '#173177'
                        ],
                        'ip'=>[
                            'value'=> get_client_ip(),
                            'color'=> '#173177'
                        ],
                        'reason'=>[
                            'value'=> '如果不是本人操作，可能您的密码已泄露，请及时更改密码。',
                            'color'=> '#173177'
                        ]
                    ]
                ];
                $send_data['content'] = json_encode($content);
                $res = sendMsg($send_data);
                $message = array(
                    'send_type' => 3,
                    'receive_id'=>session('staff_id'),
                    'time_out'=>60,
                );
                $channel = 'notice';
                $res = \app\common\lib\redisQueue::init()->publish($channel, $message);
                // exit;
                return $this->redirect('/kf/Mobile/index');
            }else{
                return $this->fetch('mobile/login');

//                return $this->redirect('/kf/Mobile/login');
            }
        }
    }

    ///判断是PC还是微信登录
    private function is_weixin(){
        if ( strpos($_SERVER['HTTP_USER_AGENT'],'MicroMessenger') !== false ) {
            return true;
        }else{
            return false;
        }
    }

    /**
     * 知识库
     * @return mixed
     */
    public function tKnowledgeClass(){
        $data = input();
        $res = controller('Knowledge','lib')->getKnowledgePower(['id'=>$data['id']]);
        if($res){
            $this->assign('data',$res);
            return $this->fetch();
        }else{
            return $this->outputErrorView('您访问的页面暂时没有数据');
        }
    }

    /**
     * 知识库内容详情
     */
    public function tKnowledgeInfo(){
        $data = input();
        $staff_id = session('staff_id');
        $info = controller('Knowledge','lib')->getOneKnowledge(['id'=>$data['id']]);
        controller('Knowledge','lib')->addKnowledgeLog($staff_id,$data['id'],'wx');
        $this->assign('data',$info);
        return $this->fetch();
    }

    /**
     * 全部培训
     */
    public function tTrainingList(){
        $data = input();
        $staff_id = session('staff_id');
        $trainingList = controller('Training','lib')->getTrainingList(['status'=>'1'],'*','','','create_time desc');
        if($trainingList){
            foreach ($trainingList as $key => $value){
                $join = controller('Training','lib')->checkTrainingJoin($value['id'],$staff_id);
                if($join['join_time']){
                    $trainingList[$key]['join'] = 1;
                }
                if($join['sign_time']){
                    $trainingList[$key]['sign'] = 1;
                }
            }
        }
        if($trainingList){
            $this->assign('data',$trainingList);
            return $this->fetch();
        }else{
            return $this->outputErrorView('您访问的页面暂时没有数据');
        }
    }

    /**
     * 培训花絮
     */
    public function trainingTidbit(){
        $data = input();
        $data = controller('Training','lib')->getOneTraining(['id'=>$data['id']]);
        if($data['tidbit']){
            foreach ($data['tidbit'] as $key=>$value){
                $name_postfix =  strrev(explode('.', strrev($value['name']))[0]);
                if(strtolower($name_postfix) == 'mp4'){
                    $data['tidbit'][$key]['type'] = 'mp4';
                }
            }
            $this->assign('tidbit',$data['tidbit']);
            $this->assign('training_name',$data['title']);
            return $this->fetch();
        }else{
            return $this->outputErrorView('此培训还没上传花絮');
        }
    }

    /**
     * 培训报名
     */
    public function tJoinTraining(){
        $data = input();
        $staff_id = session('staff_id');
        $staff_name = session('staff_name');
        $res = controller('Training','lib')->joinTraining($data['id'],$staff_id,$staff_name);
        return $this->fetch();
    }

    /**
     * 培训签到
     */
    public function tSignTraining(){
        $data = input();
        $staff_id = session('staff_id');
        $staff_name = session('staff_name');
        $res = controller('Training','lib')->signTraining($data['id'],$staff_id,$staff_name);
        if($res){
            return $this->outputTrueView('签到成功');
        }else{
            return $this->outputErrorView('签到失败');
        }
    }

    /**
     * 培训详情
     */
    public function tTrainingInfo(){
        $data = input();
        $detail = controller('Training','lib')->getOneTraining(['id'=>$data['id']]);
        $this->assign('detail',$detail);
        return $this->fetch();
    }

    /**
     * 培训附件下载
     */
    public function Download(){
        $data = input();
        if($this->is_weixin()){
            return $this->outputErrorView('请使用其他浏览器打开页面');
        }
        if($data['training_id']){
            $training = controller('Training','lib')->getOneTraining(['id'=>$data['training_id']]);
            if($training){
                if($training['file'][$data['file_id']]){
                    $file_name = $training['file'][$data['file_id']]['name'];
                    $path = ROOT_PATH.'public'.$training['file'][$data['file_id']]['link_path'];
                }
            }else{
                return $this->outputErrorView('文件不存在');
            }
        }else{
            return $this->outputErrorView('文件不存在');
        }
        $finfo    = finfo_open(FILEINFO_MIME_TYPE);
        $mimetype = finfo_file($finfo, $path);
        header("Content-Type: $mimetype");
        header('Content-Disposition: attachment; filename="'.$file_name.'"');
        header('Content-Transfer-Encoding: binary');
        header("X-Sendfile:$path");
        exit;
    }

    /**
     * 我的考试列表
     */
    public function tTestList(){
        $data = input();
        $staff_id = session('staff_id');
//        if($data['training_id']){
//            $params = ['training_id'=>$data['training_id']];
//        }
//        $test = controller('Test','lib')->getStaffTestList($params);
//        if($test){
//            foreach ($test as $key => $value){
//                $test[$key]['test'] = controller('Test','lib')->checkStaffTestSupplement($value['id'],$staff_id);
//            }
//        }
        $test = controller('Test','lib')->getJoinTest($staff_id);
        if($test){
            $this->assign('data',$test);
            return $this->fetch();
        }else{
            return $this->outputErrorView('您没有参加过考试');
        }
    }

    /**
     * 获取新的考卷用于答题
     */
    public function tTestInfo(){
        $data = input();
        $staff_id = session('staff_id');
        $check = controller('Test','lib')->checkStaffTestSupplement($data['id'],$staff_id);
        if(in_array($check['type'],['1','2','3','6'])){
            return $this->outputErrorView($check['msg']);
        }
        $res = controller('Test','lib')->getTestQuestionInfo($data['id'],$msg);
        $i = 1;
        foreach ($res['question'] as $key=>$value){
            $question_type[$i] = $key;
            $question_list[$key] = $value;
            $i++;
        }
        $this->assign('question_type',$question_type);
        $this->assign('question_list',$question_list);
        $this->assign('id',$res['id']);
        return $this->fetch();
    }

    /**
     * 交卷
     */
    public function handOverTest(){
        $data = input();
        $staff_id = session('staff_id');
        $staff_name = session('staff_name');
        $question = controller('Test','lib')->getTestQuestion($data['id']);
        if($question){
            $check = controller('Test','lib')->checkStaffTestSupplement($question['test_id'],$staff_id);
            if(!in_array($check['type'],['1','2','3','6'])){
                $res = controller('Test','lib')->autoHandOverTest($staff_id,$question['id'],$data['question'],$staff_name);
                if($res){
                    $this->redirect('kf/Mobile/getTestRanking',['test_id'=>$question['test_id']]);
                }else{
                    return $this->outputErrorView('提交失败！');
                }
            }else{
                return $check['msg'];
            }
        }else{
            return $this->outputErrorView('考试不存在！');
        }
    }

    /**
     * 考试完成后查看考试排名
     */
    public function getTestRanking(){
        $data = input();
        $staff_id = session('staff_id');
        $test = controller('Test','lib')->getTestInfo(['id'=>$data['test_id']]);
        $s = controller('Test','lib')->getStaffTestAnswer($staff_id,$data['test_id']);
        if($s){
            $answer = controller('Test','lib')->getTestALlAnswerRanking($data['test_id']);
            $this->assign('test',$test);
            $this->assign('staff_id',$staff_id);
            $this->assign('answer',$answer);
            return view('testranking');
        }else{
            return $this->outputErrorView('您没有参加考试！');
        }
    }

    /**
     * 获取考试得分
     */
    public function getTestScore(){
        $data = input();
        $staff_id = session('staff_id');
        $res = controller('Test','lib')->getLastStaffTest($data['test_id'],$staff_id);
        if($res['type'] == 4){
            return view('success1');
        }elseif($res['type'] == 3 || $res['type'] == 2){
            $this->assign('data',$res);
            return view('success2');
        }
    }

    /**
     * 考试过后查看最后一次答卷
     */
    public function getTestQuestionAnswer(){
        $data = input();
        $staff_id = session('staff_id');
        $data = controller('Test','lib')->getStaffTestAnwer($data['id'],$staff_id);
        $i = 1;
        foreach ($data['question']['question_list'] as $key=>$value){
            $question_type[$i] = $key;
            $question_list[$key] = $value;
            $i++;
        }
        $this->assign('question_type',$question_type);
        $this->assign('question_list',$question_list);
        return view('testquestionanswer');
    }

    /**
     * 查看考试报表
     */
    public function getTestAnswerResult(){
        $data = input();
        $test = controller('Test','lib')->getTestInfo(['id'=>$data['test_id']]);
        if($test){
            $res = controller('Test','lib')->getTestAnswerResult($test['id']);
            $res = array_values($res);
            $this->assign('answer',$res);
            return view('gettestanswerresult');
        }else{
            return $this->outputJson(400,'您访问的页面不存在');
        }
    }

    /**
     * 人工审题列表
     */
    public function applyTest(){
        $data = input();
        $staff_id = session('staff_id');
        $res = controller('Test','lib')->checkApplyTest($data['test_id'],$staff_id);
        if($res){
            $data = controller('Test','lib')->getTestAnswerList($data['test_id']);
            $this->assign('data',$data);
            return $this->fetch();
        }else{
            return $this->outputErrorView('您没有审题权限');
        }
    }

    /**
     * 人工审题
     */
    public function applyStaffTestAnswer(){
        $data = input();
        $staff_id = session('staff_id');
        $res = controller('Test','lib')->checkApplyTest($data['test_id'],$staff_id);
        if($res){
            $answer = controller('Test','lib')->getTestAnswer($data['answer_id']);
            $question = controller('Test','lib')->formatStaffTestAnswer($answer);
            $i = 1;
            foreach ($question['question_list'] as $key=>$value){
                $question_type[$i] = $key;
                $question_list[$key] = $value;
                $i++;
            }
            $this->assign('test_id',$data['test_id']);
            $this->assign('answer_id',$data['answer_id']);
            $this->assign('question_type',$question_type);
            $this->assign('question_list',$question_list);
            return $this->fetch();
        }else{
            return $this->outputErrorView('您没有审题权限');
        }
    }

    /**
     * 提交人工审题
     */
    public function submitStaffTestAnswer(){
        $data = input();
        $staff_id = session('staff_id');
        $res = controller('Test','lib')->checkApplyTest($data['test_id'],$staff_id);
        if($res){
            $res = controller('Test','lib')->handOverTest($data['test_id'],$data['answer_id'],$staff_id,$data['score']);
            if($res){
                $this->outputJson('200','审题成功');
            }else{
                $this->outputJson('400','审题失败');
            }
        }else{
            $this->outputJson('400','没有审题权限');
        }
    }

    /**
     * 质检单
     */
    public function getQuality(){
        $data = input();
        $staff_id = session('staff_id');
        if($data['quality_id']){
            $quality = controller('Quality','lib')->getQualityInfo(['id'=>$data['quality_id']]);
            if($quality['type'] != '3'){
                $this->check_login();
            }
            if($quality){
                //查看系统设置 质检对象 1店面，2部门
                $object_type = getZJObjectType();
                if($data['shop_code']||$data['department_id']){

                    if($quality['type'] == 3){
                        if($object_type==1){
                            $getInfo = controller('Setting','lib')->get_shop(['shop_code'=>$data['shop_code']]);
                        }else{
                            $getInfo = controller('Setting','lib')->department_list(['id'=>$data['department_id']]);
                        }
                        $res = controller('Quality','lib')->checkErpOrder($data['orderid'],$data['mobile'],$getInfo['0']['brandclass_id'],$msg);
                        if(!$res){
                            return $this->outputJson(400,$msg);
                        }
                    }
                    if($object_type==1){
                        $object = controller('Quality','lib')->getQualityShop($data['quality_id'],$data['shop_code']);
                    }else{
                        $object = controller('Quality','lib')->getQualityDept($data['quality_id'],$data['department_id']);
                    }

                    if($object){
                        if(Request::instance()->isAjax()){
                            return $this->outputJson('200');
                        }
                        $quality = controller('Quality','lib')->getQualityInfo(['id'=>$data['quality_id']]);
                        $this->assign('quality',$quality);
                        $this->assign('username',$data['userName']);
                        $this->assign('orderid',$data['orderid']);
                        $this->assign('mobile',$data['mobile']);
                        $this->assign('shop_code',$data['shop_code']);
                        $this->assign('department_id',$data['department_id']);
                        $this->assign('object_type',$object_type);
                        return view('pinkong');
                    }else{
                        return $this->outputJson(400,'您访问的页面不存在');
                    }
                }else{

                    //质检对象是门店，先查事业部
                    if($object_type == 1){
                        $brandlist = controller('Quality','lib')->getQualityBrandList($data['quality_id']);
                        $this->assign('brandlist',$brandlist);
                    }else{
                        //质检对象是部门 先查店
                        $shopList = controller('Quality','lib')->getQualityShopList($data['quality_id']);
                        $this->assign('shoplist',$shopList);
                    }

                    $this->assign(['quality'=>$quality,'object_type'=>$object_type]);
                    $this->assign('quality_id',$data['quality_id']);
                    return view('qualityshop');
                }
            }else{
                if(Request::instance()->isAjax())
                    return $this->outputJson(400,'您访问的页面不存在');
                else
                    return $this->outputErrorView('您访问的页面不存在');
            }
        }
        if(Request::instance()->isAjax()){
            return $this->outputJson(400,'您访问的页面不存在');
        }else{
            return $this->outputErrorView('您访问的页面不存在');
        }
    }

    /**
     * 获取质检品牌下的门店
     */
    public function getBrandShopList(){
        $data = input();
        $shoplist = controller('Quality','lib')->getQualityBrandShop($data['quality_id'],$data['brand_id'],$data['object_type']);
        return $this->outputJson(200,'',$shoplist);
    }

    /*
     * 获取门店下部门
     */
    public function getShopDeptList(){
        $data = input();
        $deptlist =  $shoplist = controller('Quality','lib')->getQualityShopDept($data['quality_id'],$data['shop_code'],$data['object_type']);
        return $this->outputJson(200,'',$deptlist);
    }

    /**
     * 提交质检单
     submitStaffTestAnswer,handQuality
     */
    public function handQuality(){
        $data = input();
        $staff_id = session('staff_id');
        $object_type = getZJObjectType();
        if($object_type==1){
            $object = controller('Quality','lib')->getQualityShop($data['quality_id'],$data['shop_code']);
        }else{
            $object = controller('Quality','lib')->getQualityDept($data['quality_id'],$data['department_id']);
        }

        if($object){
            $quality = controller('Quality','lib')->getValidQuality($data['quality_id']);
            if($quality){
                if($object_type==1){
                    $code = $data['shop_code'];
                }else{
                    $code = $data['department_id'];
                }
                $res = controller('Quality','lib')->handQuality($data['quality_id'],$code,$staff_id,$data,$msg);
                if($res){
                    return $this->outputJson(200,'质检成功');
                }else{
                    return $this->outputJson(400,$msg);
                }
            }else{
                return $this->outputJson(400,'您访问的页面不存在');
            }
        }else{
            return $this->outputJson(400,'您访问的页面不存在');
        }
    }

    /**
     * 获取质检单列表
     *
     */
    public function getQualityList(){
        $data = input();
        $object_type=getZJObjectType();
        $res = controller('Quality','lib')->getQualityResult();
        $this -> assign('object_type',$object_type);
        $this->assign('quality',$res);
        return view('qualitylist');
    }

    /**
     * 筛选质检单门店结果
     */
    public function getQualityShopList(){
        $data = input();
        $object_type=getZJObjectType();
        $res = controller('Quality','lib')->getQualityResult(['id'=>$data['quality_id']]);
        if($res){
            //判断质检对象是门店还是部门
            if($object_type==1){
                $brandlist = controller('Quality','lib')->getQualityBrandList($data['quality_id']);
                $this->assign('brandlist',$brandlist);
            }else{
                $shoplist = controller('Quality','lib')->getQualityShopList($data['quality_id']);
                $this->assign('shoplist',$shoplist);
            }

            $this->assign(['quality_id'=>$data['quality_id'],'object_type'=>$object_type]);

            return view('qualityshoplist');
        }else{
            return $this->outputErrorView('您访问的页面不存在');
        }
    }

    /**
     * 获取质检单结果
     *
     * @param integer $quality_id
     * @param string $shop_code
     */
    public function getQualityResult(){
        $data = input();
        $object_type = getZJObjectType();
        if($object_type&&$data['quality_id'] && ($data['shop_code']||$data['department_id'])){
            if($object_type==1&&$data['shop_code']){
                $res = controller('Quality','lib')->getQualityObjectShop($data['shop_code'],$data['quality_id'],$object_type);
            }elseif($object_type==2&&$data['department_id']){
                $res = controller('Quality','lib')->getQualityObjectShop($data['department_id'],$data['quality_id'],$object_type);
            }

            if($res){
                if(Request::instance()->isAjax()){
                    if($object_type==1){
                        return $this->outputJson(200,'',['url'=>'/kf/Mobile/getQualityResult.html?shop_code='.$data['shop_code'].'&quality_id='.$data['quality_id']]);
                    }else{
                        return $this->outputJson(200,'',['url'=>'/kf/Mobile/getQualityResult.html?department_id='.$data['department_id'].'&quality_id='.$data['quality_id']]);
                    }

                }else{
                    $quality = controller('Quality','lib')->getQualityInfoR(['id'=>$data['quality_id']]);
                    $this->assign('quality',$quality);
//                    dd($res);
                    $this->assign('quality_answer',$res);
                    return view('qualityinfo');
                }
            }else{
                if(Request::instance()->isAjax()) {
                    return $this->outputJson(400, '该门店没有质检成功');
                }else{
                    return view('filterQualityShopCode');
                }
            }
        }else{
            return view('filterQualityShopCode');
        }
    }

    /**
     * json输出
     * 
     * @param integer $code 200正确，400错误
     * @param string $msg 提示信息
     * @param array|string $data
     * @author chaidongdong@suxuantech.cn
     */
    private function outputJson($code,$msg,$data){
        echo json_encode(['code'=>$code,'msg'=>$msg,'data'=>$data]);exit;
    }

    /**
     * 错误页面提示
     *
     * @param string $msg
     * @return mixed
     * @author chaidongdong@suxuantech.cn
     */
    public function outputErrorView($msg = '你访问的页面上天了。。。',$url='/kf/Mobile/index'){
        $this->assign('msg',$msg);
        $this->assign('url',$url);
        return view('error');
    }

    /**
     * 正确页面提示
     *
     * @param string $msg
     * @return mixed
     * @author chaidongdong@suxuantech.cn
     */
    public function outputTrueView($msg = '恭喜你。成功。。。上天了',$url = '/kf/Mobile/index'){
        $this->assign('msg',$msg);
        $this->assign('url',$url);
        return view('session');
    }

    //加密函数
    function lock_url($txt,$key='kfchaidong')
    {
        $chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-=+";
        $nh = rand(0,64);
        $ch = $chars[$nh];
        $mdKey = md5($key.$ch);
        $mdKey = substr($mdKey,$nh%8, $nh%8+7);
        $txt = base64_encode($txt);
        $tmp = '';
        $i=0;$j=0;$k = 0;
        for ($i=0; $i<strlen($txt); $i++) {
            $k = $k == strlen($mdKey) ? 0 : $k;
            $j = ($nh+strpos($chars,$txt[$i])+ord($mdKey[$k++]))%64;
            $tmp .= $chars[$j];
        }
        return urlencode($ch.$tmp);
    }

    //解密函数
    function unlock_url($txt,$key='kfchaidong')
    {
        $txt = urldecode($txt);
        $chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-=+";
        $ch = $txt[0];
        $nh = strpos($chars,$ch);
        $mdKey = md5($key.$ch);
        $mdKey = substr($mdKey,$nh%8, $nh%8+7);
        $txt = substr($txt,1);
        $tmp = '';
        $i=0;$j=0; $k = 0;
        for ($i=0; $i<strlen($txt); $i++) {
            $k = $k == strlen($mdKey) ? 0 : $k;
            $j = strpos($chars,$txt[$i])-$nh - ord($mdKey[$k++]);
            while ($j<0) $j+=64;
            $tmp .= $chars[$j];
        }
        return base64_decode($tmp);
    }
}
