<?php
/**
 * KF 品控中心->质检单
 * 默认接口方法，此方法内定议基础框架所需要的方法，用于验证模块合法性，模块版本，对接基础架构中需要的方法
 * 此类不作任何业务逻辑
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: chaidongdong<chaidongdong@suxuantech.cn> 2018-4-23 $
 */
namespace app\kf\controller;

use app\index\controller\Base;
use think\Request;

class Quality extends Base{

    /**
     * 质检单 单项列表
     *
     * @param array $data
     * @return unknown
     * @author chaidongdong@suxuantech.cn
     */
    public function singleList(){
        if(Request::instance()->isAjax()){
            $data = input();
            $detail=controller("Quality","lib")->SingleList($data);
            echo  json_encode(array_merge(['code'=>0,'msg'=>''],$detail));
            exit;
        }else{
            return view('singlelist');
        }
    }

    /**
     * 质检单列表
     *
     * @param array $data
     * @return unknown
     * @author chaidongdong@suxuantech.cn
     */
    public function qualityList(){
        if(Request::instance()->isAjax()){
            $data = input();
            $detail=controller("Quality","lib")->QualityList($data);
            echo  json_encode(array_merge(['code'=>0,'msg'=>''],$detail));
            exit;
        }else{
            return view('qualitylist');
        }
    }

    /**
     * 添加、修改质检单单项页面
     *
     * @param int $id
     * @return unknown
     * @author chaidongdong@suxuantech.cn
     */
    public function singleSave(){
        $data = input();
        $detail = controller('Quality','lib')->getSingleOne(['id'=>$data['id']]);
        $this->assign('detail',$detail);
        return view('singlesave');
    }

    /**
     * 添加、修改质检单单项功能
     *
     * @param array $data
     * @return json
     * @author chaidongdong@suxuantech.cn
     */
    public function saveSingle(){
        $data = input();
        $data['create_staff_id'] = session('staff_id');
        $res = controller('Quality','lib')->saveSingle($data,$msg);
        if($res){
            echo json_encode(array('code'=>1,'msg'=>$msg));
        }else{
            echo json_encode(array('code'=>0,'msg'=>$msg));
        }
        exit;
    }

    /**
     * 添加、修改质检单
     * 
     * @param array $data
     * @return unknown
     * @author chaidongdong@suxuantech.cn
     */
    public function qualitySave(){
        $data = input();
        $res = controller('Quality','lib')->getQualityOne(['id'=>$data['id']]);
        $this->assign('detail',$res);
        return view('qualitysave');
    }

    /**
     * 获取质检单项（用于添加质检单单项）
     *
     * @param array/string $id
     * @return json
     * @return chaidongdong@suxuantech.cn
     */
    public function getSingles(){
        $data = input();
        $id = $data;
        if($id && !empty($id)){
            $data = controller('Quality','lib')->getSingleList(['id'=>$id['id']]);
            cache('KF_quality_single_'.session('staff_id'), think_encrypt(json_encode($info)));
            echo json_encode(['code'=>1,'data'=>$data]);
        }else{
            echo json_encode(array('code'=>0,'msg'=>'数据错误'));
        }
        exit;
    }

    /**
     * 添加、修改质检单
     *
     * @param array $data
     * @return json
     * @author chaidongdong@suxuantech.cn
     */
    public function saveQuality(){
        $data = input();
        $data['create_staff_id'] = session('staff_id');
        $res = controller('Quality','lib')->saveQuality($data,$msg);
        if($res){
            echo json_encode(array('code'=>1,'msg'=>$msg));
        }else{
            echo json_encode(array('code'=>0,'msg'=>$msg));
        }
        exit;
    }

    /**
     * 删除质检单单项
     *
     * @param int $id
     * @return json
     * @author chaidongdong@suxuantech.cn
     */
    public function delQualitySingle(){
        $data = input();
        $res = controller('Quality','lib')->delQualitySingle(['id'=>$data['id']],$msg);
        if($res){
            echo json_encode(array('code'=>1,'msg'=>$msg));
        }else{
            echo json_encode(array('code'=>0,'msg'=>$msg));
        }
        exit;
    }

    /**
     * 删除质检单
     * @param int $id
     * @return json
     * @author chaidongdong@suxuantech.cn
     */
    public function delQuality(){
        $data = input();
        $res = controller('Quality','lib')->delQuality(['id'=>$data['id']]);
        if($res){
            echo json_encode(array('code'=>1,'msg'=>''));
        }else{
            echo json_encode(array('code'=>0,'msg'=>''));
        }
        exit;
    }

    /**
     * 质检对象页面
     *
     * @param integer $quality_id
     * @return mixed
     */
    public function qualityObject(){

        $data = input();
        //判断系统设置当前质检对象是店面还是部门
        $object_type = getZJObjectType();

        $object = controller('Quality','lib')->getFormatQualityObject($data['quality_id'],$object_type);

        $this->assign(['object'=>$object,'object_type'=>$object_type]);
        $this->assign('quality_id',$data['quality_id']);
        if($object_type==2){
            $shop = controller('Setting','lib')->get_shop();
            $this->assign('shop',$shop);
            return view('qualityobject2');
        }else{
            $brand=controller('Setting','lib')->brandclass_list();
            $this->assign('brand',$brand);
            return $this->fetch();
        }

    }

    /**
     * 修改质检对象
     *
     */
    public function saveQualityObject(){
        $data = input();
        $res = controller('Quality','lib')->saveQualityObject($data['quality_id'],$data['content'],$data['object_type']);
        if($res){
            echo json_encode(array('code'=>1,'msg'=>'操作成功'));
        }else{
            echo json_encode(array('code'=>0,'msg'=>'操作失败'));
        }
        exit;
    }

    /**
     * 质检二维码页面
     *
     */
    public function codeQualityObject(){
        $data = input();
        $http = $_SERVER['HTTPS'] ? 'http://' : 'http://';
        $sign_url = $http.$_SERVER['HTTP_HOST'].'/kf/Mobile/getQuality.html?quality_id='.$data['quality_id'];
        controller('Quality','lib')->qrcodeQuality($sign_url,'codeQualityObject_'.$data['quality_id']);
        $this->assign('url','/upload/quality/codeQualityObject_'.$data['quality_id'].'.png');
        $this->assign('link_url',$sign_url);
        return $this->fetch();
    }

    /**
     * 质检结果页面
     */
    public function QualityObjectResult(){
        $data = input();
        $object_type = getZJObjectType();
        if($object_type==1){
            $brand_list = controller('Quality','lib')->getQualityObjectBrand($data['quality_id']);
            $this->assign('brand_list',$brand_list);
        }else{
            $shop_list = controller('Quality','lib')->getQualityShopList($data['quality_id']);
            $this->assign('shop_list',$shop_list);
        }

        $this->assign(['quality_id'=>$data['quality_id'],'object_type'=>$object_type]);

        return $this->fetch();
    }

    /**
     * 质检结果页面--获取质检单品牌下的门店
     */
    public function getQualityObjectBrandShop(){
        $data = input();

        $shop_list = controller('Quality','lib')->getQualityObjectBrandShop($data['quality_id'],$data['brand_id']);
        echo json_encode(['code'=>200,'data'=>$shop_list]);exit;
    }

    /**
     * 质检结果页面--获取质检单品牌下的门店
     */
    public function getQualityObjectShopDept(){
        $data = input();

        $shop_list = controller('Quality','lib')->getQualityShopDept($data['quality_id'],$data['shop_code'],$data['object_type']);
        echo json_encode(['code'=>200,'data'=>$shop_list]);exit;
    }

    /**
     * 质检结果页面--获取质检结果
     */
    public function getQualityObjectResultView(){
        $data = input();
        if($data['object_type'] == 1){
            $object_result = controller('Quality','lib')->getQualityObjectShop($data['shop_code'],$data['quality_id'],$data['object_type']);
        }elseif($data['object_type'] == 2){
            $object_result = controller('Quality','lib')->getQualityObjectShop($data['department_id'],$data['quality_id'],$data['object_type']);
        }

        if($object_result){
            $object = controller('Quality','lib')->getQualityInfosss(['id'=>$data['quality_id']]);
            $html = '';
            //抄送
            $brand=controller('Setting','lib')->brandclass_list();
            $html .='<div class="layui-form-item addr_wrap">
                        <label class="layui-form-label">抄送：</label>
                        <div class="layui-input-block w-150">
                            <select name="brand_id" id="brand_id" lay-filter="brand" class="cus-input" >
                            <option value="">请选择事业部</option>';
            foreach ($brand as $value){
                $html .= '<option value="'.$value['id'].'">'.$value['brandclass'].'</option>';
            }
            $html .= '</select>
                </div>
                <span class="addr_text"></span>
                    <div class="layui-input-block shop w-150" id="shop">
                        <select id="shop_code" lay-filter="shop" class="cus-input">
                            <option value="">请选择店面</option>
                        </select>
                    </div>
                    <span class="addr_text"></span>
                    <div class="layui-input-block department w-150" id="department">
                        <select id="department_id" lay-filter="department" class="cus-input">
                            <option value="">请选择部门</option>
                        </select>
                    </div>
                    <div class="layui-form-item">
                        <label class="layui-form-label"></label>
                        <div class="layui-input-block position" style="margin-top: 8px">
                        </div>
                    </div>
                    <div class="layui-form-item" style="margin-left: 100px;">
                        <label class="layui-form-label"></label>
                        <div  class="add-shop-all">
                        </div>
                    </div>
                </div>';
        foreach ($object['list'] as $key => $value){
                $html .= '<div class="layui-form-item">
                            <label class="layui-form-label">'.($key+1).'：</label>
                            <div class="layui-input-block">
                            <div class="set_bz_tit">'.$value['name'].'</div>';
                foreach ($value['options']['options'] as $k=>$v){
                    if($object_result['items'][$value['id']]['score'] == $value['options']['score'][$k]){
                        $html .= '<div class="set_bz_tit"><input type="radio" checked="checked" name="quality['.$value['id'].']" value="'.$value['options']['score'][$k].'" title="'.$v.'"></div>';
                    }else{
                        $html .= '<div class="set_bz_tit"><input type="radio" name="quality['.$value['id'].']" value="'.$value['options']['score'][$k].'" title="'.$v.'"></div>';
                    }
                }
                $html .= '<div class="set_bz_tit">客户备注：'.$object_result['items'][$value['id']]['remarks']['old_remarks'].'</div>';
                $html .= '<div class="set_bz_tit">修改备注：<textarea placeholder="请输入内容" name="u['.$value['id'].']" class="layui-textarea">'.$object_result['items'][$value['id']]['remarks']['a'].'</textarea></div>';
                $html .= '</div></div>';
            }
            $html .= '<div class="layui-form-item" style="width: 500px;">
                            <label class="layui-form-label">问题点：</label>
                            <div class="layui-input-block"><textarea placeholder="请输入内容" name="question" class="layui-textarea">'.$object_result['question'].'</textarea></div></div>';
            $html .= '<div class="layui-form-item" style="width: 500px;">
                            <label class="layui-form-label">温馨提示：</label>
                            <div class="layui-input-block"><textarea placeholder="请输入内容" name="tip" class="layui-textarea">'.$object_result['tip'].'</textarea></div></div>';
            $html .= '<div class="layui-form-item" style="width: 500px;">
                            <label class="layui-form-label">经理/店长回复：</label>
                            <div class="layui-input-block"><textarea placeholder="请输入内容" name="reply" class="layui-textarea">'.$object_result['reply'].'</textarea></div></div>';


            echo <<<EDP
            $html
EDP;
        }else{
            echo <<<EDP
                <div class="layui-form-item" style="width: 500px; margin-left: 290px;">目前没有数据</div>
EDP;
        }
        exit;
    }

    /**
     * 修改质检结果,并抄送
     *
     */
    public function savaQualityObjectResult(){
        $data = input();
        $res = controller('Quality','lib')->checkEditQuality(session('staff_id'),$data['quality_id']);
        if($res){
            //质检对象为1时 shop_code,2时department_id
            $code = $data['object_type']==1?$data['shop_code']:$data['department_id'];

            $res = controller('Quality','lib')->editQualityObject($code,$data['quality_id'],$data);
            $http = $_SERVER['HTTPS'] ? 'https://' : 'http://';
            if($data['object_type']==1){
                $url = $http.$_SERVER['HTTP_HOST'].'/kf/Mobile/getQualityResult.html?quality_id='.$data['quality_id'].'&shop_code='.$data['shop_code'];
                controller('Quality','lib')->wxQualityResultSend(array_keys($data['staff_number']),$data['quality_id'],$data['shop_code'],$url,$data['object_type']);
            }else{
                $url = $http.$_SERVER['HTTP_HOST'].'/kf/Mobile/getQualityResult.html?quality_id='.$data['quality_id'].'&department_id='.$data['department_id'];
                controller('Quality','lib')->wxQualityResultSend(array_keys($data['staff_number']),$data['quality_id'],$data['department_id'],$url,$data['object_type']);
            }

            if($res){
                echo json_encode(['code'=>0,'msg'=>'修改成功']);
            }else{
                echo json_encode(['code'=>1,'msg'=>'修改成功']);
            }
        }else{
            echo json_encode(['code'=>1,'msg'=>'权限不足']);
        }
    }

    /**
     * 质检单线性图
     */
    public function line(){
        $object_type = getZJObjectType();
        if(Request::instance()->isAjax()) {
            $data = input();

        $array = [
            'xAxis'=>[
                'type'=>'category',
//                'data'=>['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun']
            ],
            'yAxis'=>[
                'type'=>'value'
            ],
            'series'=>[[
//                'data'=>[820, 932, 901, 934, 1290, 1330, 320],
                'type'=>'line']
            ]
        ];
            $code = $object_type == 1 ? $data['shop_code'] : $data['department_id'];
            $res = controller('Quality','lib')->getQualityLine('',$code,'mouth',['start'=>$data['start_time'],'end'=>$data['end_time']],'amount',$object_type);
            foreach ($res as $key=>$value){
                $array['xAxis']['data'][] = $key;
                $array['series'][0]['data'][] = $value;
            }
            echo json_encode($array);exit;
        }else{
            if($object_type==1){
                $all_brand = controller('Quality','lib')->getQualityAllBrandList();
                $this->assign(['all_brand'=>$all_brand,'object_type'=>$object_type]);
            }else{
                $all_shop = controller('Quality','lib')->getQualityAllShopList();
                $this->assign(['all_shop'=>$all_shop,'object_type'=>$object_type]);
            }

            return view('qualityline');
        }
    }

    /**
     * 获取质检单某品牌所有质检过的门店
     */
    public function getAllshop(){
        $data = input();
        $res = controller('Quality','lib')->getQualityAllShop($data['brand_id']);
        echo json_encode(['code'=>1,'data'=>$res]);exit;
    }

    /**
     * 获取质检单某店面所有质检过的部门
     */
    public function getAllDept(){
        $data = input();
        $res = controller('Quality','lib')->getQualityAllDept($data['shop_code']);
        echo json_encode(['code'=>1,'data'=>$res]);exit;
    }


}