<?php
/**
 * KF 品控中心->题库考试
 * 默认接口方法，此方法内定议基础框架所需要的方法，用于验证模块合法性，模块版本，对接基础架构中需要的方法
 * 此类不作任何业务逻辑
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: chaidongdong<chaidongdong@suxuantech.cn> 2018-4-23 $
 */
namespace app\kf\controller;

use app\index\controller\Base;
use think\Request;
// use app\kf\model\TTraining;
// use app\kf\model\TTrainingJoin;

class Question extends Base{

    public $question_type = [
        '1'=>'单选题',
        '2'=>'多选题',
        '3'=>'填空题',
        '4'=>'简答题'
    ];

    /**
     * 培训列表
     *
     * @return unknown
     * @author chaidongdong@suxuantech.cn
     */
    public function questionList(){
        if(Request::instance()->isAjax()){
            $data = input();
            $detail=controller("Question","lib")->QuestionList($data);
            echo  json_encode(array_merge(['code'=>0,'msg'=>''],$detail));
            exit;
        }else{
            return view('questionlist');
        }
    }

    /**
     * 添加/修改 考题页面
     *
     * @param int $question_type  问题类型
     * @return unknown
     * @author chaidongdong@suxuantech.cn
     */
    public function questionSave(){
        $data = input();
        if($data['id']){
            $question = controller('Question','lib')->getQuestionInfo($data);
            if($question['answer'] && ($question['question_type'] == 3 || $question['question_type'] == 4)){
                $question['answer'] = implode("\r\n",$question['answer']);
            }
            $this->assign('question',$question);
            $data['question_type'] = $question['question_type'];
        }
        switch ($data['question_type']) {
            case '1':
                return view('questionsave_1');
                break;
            case '2':
                return view('questionsave_2');
                break;
            case '3': 
                return view('questionsave_3');
                break;
            default:
                return view('questionsave_4');
                break;
        }
    }

    /**
     * 添加/修改 题库
     *
     * @param array $data
     * @return json
     * @author chaidongdong@suxuantech.cn
     */
    public function saveQuestion(){
        $data = input();
        if(!in_array($data['question_type'],array_keys($this->question_type))){
            echo json_encode(['code'=>0,'msg'=>'请选择题目类型']);
            exit;
        }
        $res = controller('Question','lib')->saveQuestion($data,$msg);
        if($res){
            echo json_encode(['code'=>1,'msg'=>'']);
            exit;
        }else{
            echo json_encode(['code'=>0,'msg'=>$msg]);
            exit;
        }
    }

    /**
     * 删除
     * 
     * @param int $id
     * @return unknown
     * @author chaidongdong@suxuantech.cn
     */
    public function delQuestion(){
        $data = input();
        $res = controller('Question','lib')->delQuestion(['id'=>$data['id']]);
        if($res){
            echo json_encode(['code'=>1,'msg'=>'']);
            exit;
        }else{
            echo json_encode(['code'=>0,'msg'=>$msg]);
            exit;
        }
    }



}