<?php
/**
 * KF设定
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: wzy<wangzhenya@suxuantech.cn> 2017-10-27 $
 */
namespace app\kf\controller;
use app\index\controller\Base;
use think\Queue;
use app\kf\lib\McInterface;
use think\Request;
class Setting extends Base{


    //版本更新
    public function versionUpdateLog(){
        $update = include_once(ROOT_PATH . 'application/index/lib/update_log.php');
        krsort($update);
        $this->assign('update',$update);
        return $this->fetch();
    }

    public function getPositionList(){
        //岗位
        $position_info = controller('Setting','lib')->get_position_list(['shop_code'=>session('shop_code')]);
        return $position_info;
    }
    public function getDepartmentList(){
        //岗位
        $dep = controller('Setting','lib')->get_department_list(['shop_code'=>session('shop_code')]);
        return $dep;
    }
    public function getDepartmentStaff(){
        $department_id = input('post.department_id');
        //部门下的人员
        $staff = controller('Customer','lib')->get_staff_list(['department_id'=>$department_id]);
        return $staff;
    }


    //功能菜单设定
    function menuSet(){
        // 权限
        $auth = check_right('menu1512029909');
        if (!$auth) {
            return $this->redirect('/');
        }
        $data=controller('Setting',"lib")->getMenuJSON();
        $this->assign('data',$data);

        return $this->fetch();
    }

    //功能菜单列表
    function getMenuJSON(){
        $res = controller("Setting","lib")->getMenuJSON(input());
        return json($res);
    }

    public function addMenuSet(){
        // 权限
        $auth = check_right('menu1512029909');
        if (!$auth) {
            return $this->redirect('/');
        }
        $id= input('get.id');
        if($id){
            $detail=db('s_menu')->where('id',$id)->find();
            $this->assign('detail',$detail);
            $data=controller('Setting',"lib")->getMenuList();
            $this->assign('data',$data);
            return  $this->fetch();
        }else{
            $data=controller('Setting',"lib")->getMenuList();
            $this->assign('data',$data);
            return  $this->fetch();
        }
    }

    //增加功能
    public function addMenu(){
        // 权限
        $auth = check_right('menu1512029909');
        if (!$auth) {
            return $this->redirect('/');
        }
        return controller('Setting','lib')->addMenu(input('post.'));
    }


    //删除功能
    function  delMenu(){
        // 权限
        $auth = check_right('menu1512029909');
        if (!$auth) {
            return $this->redirect('/');
        }
        return controller('Setting','lib')->delMenu(input('post.id'));
    }

    //功能菜单状态修改
    function editStatus(){
        // 权限
        $auth = check_right('menu1512029909');
        if (!$auth) {
            return $this->redirect('/');
        }
        return controller('Setting','lib')->editStatus(input('post.'));
    }

    //权限设定
    public function permission(){
        if(session('is_belong')==1){
            $brand=controller('Setting','lib')->brandclass_list();
            $department=controller('Setting','lib')->department_list(array('grade_type'=>session('is_belong')));
            $position=controller("Setting","lib")->get_position_list(array('grade_type'=>session('is_belong'),'department_id'=>'zero'));
        }
        if(session('is_belong')==2){
            $shop=controller('kf/Customer','lib')->get_shop(array('brandclass'=>session('brandclass')));
            $department=controller('Setting','lib')->department_list(array('grade_type'=>session('is_belong'),'brandclass'=>session('brandclass')));
            $position=controller("Setting","lib")->get_position_list(array('grade_type'=>session('is_belong'),'brandclass'=>session('brandclass'),'department_id'=>'zero'));
        }

        if(session('is_belong')==3||session('is_belong')==4){
            $department=controller('Setting','lib')->department_list(array('shop_code'=>session('shop_code')));
            $position=controller("Setting","lib")->get_position_list(array('grade_type'=>3,'shop_code'=>session('shop_code')));
        }
        $this->assign('is_belong',session('is_belong'));
        $this->assign('brand',$brand);
        $this->assign('shop',$shop);
        $this->assign('department',$department);
        $this->assign('position',$position);
        return $this->fetch();
    }

    public function bran_link(){
        $brand=input('post.');
        //print_r($brand);die;
        $msg['shop']=controller('kf/Customer','lib')->get_shop(array('brandclass'=>$brand['brandclass']));
        $msg['department']=controller('Setting','lib')->department_list(array('grade_type'=>2,'brandclass'=>$brand['brandclass']));
        $msg['position']=controller("Setting","lib")->get_position_list(array('grade_type'=>2,'brandclass'=>$brand['brandclass'],'department_id'=>'zero'));
        if($msg){
            $this->success("查询成功",'/',$msg);
        }
    }
    public function shop_link(){
        $shop=input('post.');
        $msg['department']=controller('Setting','lib')->department_list(array('grade_type'=>3,'shop_code'=>$shop['shop_code']));
        $msg['position']=controller("Setting","lib")->get_position_list(array('grade_type'=>3,'shop_code'=>$shop['shop_code'],'department_id'=>'zero'));
        if($msg){
            $this->success("查询成功",'/',$msg);
        }
    }

    public function department_link(){
        $data=input('post.');
        $department['department_id']=(int)$data['department'];
        $msg['position']=controller("Setting","lib")->get_position_list(array('department_id'=>$department['department_id']));

        if($msg){
            $this->success("查询成功",'/',$msg);
        }
    }

    public function position_link(){
        $data=input('post.');
        $msg['staff']=controller("Setting","lib")->get_staff(array('main_position_code'=>$data['position_code']));
        if($msg){
            $this->success("查询成功",'/',$msg);
        }
    }

    public function link_search(){
        $data=input('post.');
        if($data['brandclass']){
            $brandclass=$data['brandclass']=='undefined'?session('brandclass'):$data['brandclass'];
        }else{
            $brandclass='zero';
        }
        if(empty($data['shop_code'])){
            $shop_code='zero';
        }else{
            $shop_code=$data['shop_code']=='undefined'?session('shop_code'):$data['shop_code'];
        }
        $department_id='zero';
        $msg['department']=controller('Setting','lib')->department_list(array('brandclass'=>$brandclass,'shop_code'=>$shop_code));
        $msg['position']=controller("Setting","lib")->get_position_list(array('brandclass'=>$brandclass,'shop_code'=>$shop_code,'department_id'=>$department_id));
        if($msg){
            $this->success("查询成功",'/',$msg);
        }
    }



    //当前登录人权限
    public  function get_menu(){
        $auth=getAuth($type='auth');
        $menu=array_column($auth,'id');
        $this->success('查询成功','/',$menu);
    }

    //递归后功能菜单数据
    public function  getPermissionJSON(){
        return controller('Setting','lib')->getPermissionJSON();
    }

    //授权
    public function authorise(){
        $data=input('post.');
        return controller("Setting","lib")->authorise($data);
    }

    //根据岗位查询其功能权限
    public function getPositionMenu(){
        $position_code=input('post.position_code');
        return controller("Setting","lib")->getPositionMenu($position_code);
    }

    /*
     * 回访无效原因设定
     */
    public function invalidSet(){
        return $this->fetch();
    }

    //获取回访无效原因json数据
    public function getInvalidJSON(){
        $res = controller('Setting','lib')->getInvalidJSON(input('param.'));
        return json($res);
    }


    //添加/修改 回访无效原因
    public function addInvalid(){
        $id = input('post.id');
        $invalid_reason=input('post.invalid_reason');
        $invalid = db('s_invalid_reason')->where('invalid_reason',$invalid_reason)->find();
        if($id){
            if($invalid&&$invalid['id']!=$id){
                return array('code'=>100,'msg'=>'此无效原因已存在');
            }
        }else{
            if($invalid){
                return array('code'=>100,'msg'=>'此无效原因已存在');
            }
        }
        db()->startTrans();
        if($id){
            $res = db('s_invalid_reason')->where('id',$id)->update(['invalid_reason'=>$invalid_reason,'create_time'=>date('Y-m-d H:i:s',time()),'staff_id'=>session('staff_id'),'staff_name'=>session('staff_name')]);
        }else{
            $res=db('s_invalid_reason')->insert(['invalid_reason'=>$invalid_reason,'create_time'=>date('Y-m-d H:i:s',time()),'staff_id'=>session('staff_id'),'staff_name'=>session('staff_name')]);
        }
        if($res===false){
            db()->rollback();
            return array('code'=>100,'msg'=>'编辑无效原因失败');
        }else{
            action_log(input('post.'),'',0,session(['staff_id']),session(['staff_name']));
            db()->commit();
            return array('code'=>200,'msg'=>'编辑无效原因成功');
        }

    }

    //删除无效原因
    public function delInvalid(){
        $id = input('post.id');
        $res = db('s_invalid_reason')->where('id',$id)->delete();
        if($res===false){
            return array('code'=>100,'msg'=>'删除无效原因失败');
        }else{
            return array('code'=>200,'msg'=>'删除无效原因成功');
        }
    }

    //客诉来源设定
    public function source(){
        return $this->fetch();
    }


    //获取客诉来源json数据
    public function getSourceJSON(){
        $res = controller('Setting','lib')->getSourceJSON(input('param.'));
        return json($res);
    }
    //删除客诉来源
    public function delKfSource(){
        // 权限
//        $auth = check_right('menu1516949559');
//        if (!$auth) {
//            return $this->redirect('/');
//        }

        $id=input('post.id');
        if(empty($id)){
            return array('code'=>300,'msg'=>'未获取到数据','data'=>$id);
        }
        db()->startTrans();
        $data=db('s_source')->where('id',$id)->find();
        if($data['is_must']==1){
            return array('code'=>100,'msg'=>'固定来源不可删除');
        }
        $res = db('s_source')->where('id',$id)->delete();
        if($res === false){
            db()->rollback();
            return array('code'=>100,'msg'=>'删除工单来源失败','data'=>$res);
        }else{
            action_log(input('post.'),'',$id,session(['staff_id']),session(['staff_name']));
            db()->commit();
            return array('code'=>200,'msg'=>'删除工单来源成功','data'=>$res);
        }

    }

    //添加客诉来源页面
    public function addSource(){
        $id= input('get.id');
        if($id){
            $detail=db('s_source')->where('id',$id)->find();
            $statistics = explode(',',$detail['statistics']);
            $this->assign(['detail'=>$detail,'statistics'=>$statistics]);
            return  $this->fetch();
        }else{
            return  $this->fetch();
        }
    }

    //执行添加/修改来源
    public function doAddSource(){
        $data = input('post.');
        $upData['source_name'] = $data['source_name'];
        $upData['is_great']     = $data['is_great'];
        $upData['statistics']  = implode(',',$data['statistics']);
        $upData['create_time'] = date('Y-m-d H:i:s',time());
        $upData['staff_id']    = session('staff_id');
        $upData['staff_name']  = session('staff_name');

        $source = db('s_source')->where('source_name',$data['source_name'])->find();
        if($data['id']){
            if($source&&$source['id']!=$data['id']){
                return array('code'=>100,'msg'=>'此客诉来源已存在');
            }
        }else{
            if($source){
                return array('code'=>100,'msg'=>'此客诉来源已存在');
            }
        }
        db()->startTrans();
        if($data['id']){
            $res = db('s_source')->where('id',$data['id'])->update($upData);
        }else{
            $upData['is_must'] = 2;
            $res = db('s_source')->insert($upData);
        }
        if($res===false){
            db()->rollback();
            return array('code'=>100,'msg'=>'客诉来源编辑失败','data'=>$res);
        }else{
            action_log(input('post.'),'',0,session(['staff_id']),session(['staff_name']));
            db()->commit();
            return array('code'=>200,'msg'=>'客诉来源编辑成功','data'=>$res);
        }

    }



    //投诉类型设定
    public function complaintype(){
        return $this->fetch();
    }

    //获取投诉类型json数据
    public function getComplainJSON(){
        $res = controller('Setting','lib')->getComplainJSON(input('param.'));
        return json($res);
    }
    //删除投诉类型
    public function delComplainType(){
        // 权限
//        $auth = check_right('menu1516949559');
//        if (!$auth) {
//            return $this->redirect('/');
//        }

        $id=input('post.id');
        if(empty($id)){
            return array('code'=>300,'msg'=>'未获取到数据','data'=>$id);
        }
        if(db('s_complain_type')->where('fid',$id)->find()){
            return array('code'=>301,'msg'=>'此类型下存在子类型，请先删除子类型');
        }
        db()->startTrans();
        $res = db('s_complain_type')->where('id',$id)->delete();
        if($res === false){
            db()->rollback();
            return array('code'=>100,'msg'=>'删除投诉类型失败','data'=>$res);
        }else{
            action_log(input('post.'),'',$id,session(['staff_id']),session(['staff_name']));
            db()->commit();
            return array('code'=>200,'msg'=>'删除投诉类型成功','data'=>$res);
        }

    }

    //添加投诉类型
    public function addComplainType(){
        $complain_type = input('post.complain_type');
        $fid = input('post.fid');
        if(db('s_complain_type')->where('complain_name',$complain_type)->find()){
            return array('code'=>100,'msg'=>'此投诉类型已存在');
        }
        db()->startTrans();
        $res=db('s_complain_type')->insert(['complain_name'=>$complain_type,'fid'=>$fid,'create_time'=>date('Y-m-d H:i:s',time()),'staff_id'=>session('staff_id'),'staff_name'=>session('staff_name')]);
        if($res===false){
            db()->rollback();
            return array('code'=>100,'msg'=>'添加投诉类型失败','data'=>$res);
        }else{
            action_log(input('post.'),'',0,session(['staff_id']),session(['staff_name']));
            db()->commit();
            return array('code'=>200,'msg'=>'添加投诉类型成功','data'=>$res);
        }

    }

    //修改投诉类型
    public  function editComplainType(){

        if(!input('post.id')){
            return array('code'=>100,'msg'=>'未获取到此数据');
        }
        $reData = db('s_complain_type')->where('complain_name',input('post.complain_type'))->find();
        if($reData&&$reData['id']!=input('post.id')){
            return array('code'=>100,'msg'=>'此投诉类型已存在');
        }
        db()->startTrans();
        $res=db('s_complain_type')->where('id',input('post.id'))->update(['complain_name'=>input('post.complain_type'),'fid'=>input('post.fid'),'create_time'=>date('Y-m-d H:i:s',time()),'staff_id'=>session('staff_id'),'staff_name'=>session('staff_name')]);
        if($res===false){
            db()->rollback();
            return array('code'=>100,'msg'=>'修改投诉类型失败','data'=>$res);
        }else{
            action_log(input('post.'),'',input('post.id'),session(['staff_id']),session(['staff_name']));
            db()->commit();
            return array('code'=>200,'msg'=>'修改投诉类型成功','data'=>$res);
        }
    }

    public function getComplainSelect(){
        $type = db('s_complain_type')->select();
        $res=formatTree(listToTree($type),'','complain_name');
        return array('code'=>1,'data'=>$res);

    }

    //手机归属地秘钥设定
    public function pswSet(){
        // 权限
        $auth = check_right('menu1522207375');
        if (!$auth) {
            return $this->redirect('/');
        }
        $data = input();

        if(session('shop_code')){
            $res = db_config('sx_secret_key_'.session('shop_code'),$data['psw']);
            if($res){
                cache('db_config_sx_secret_key_'.session('shop_code'),null);
                return array('code'=>200,'msg'=>'短信秘钥设定成功','data'=>'');
            }else{
                return array('code'=>100,'msg'=>'短信秘钥设定失败','data'=>'');
            }
        }else{
            return array('code'=>300,'msg'=>'未找到店面简码，不能设置','data'=>'');
        }

    }
    //本地配置
    public function citySet(){
        // 权限
        $auth = check_right('menu1522207375');
        if (!$auth) {
            return $this->redirect('/');
        }
        $data = input();

        if(session('shop_code')){
            $res = db_config('sx_city_id_'.session('brandclass_id'),$data['city_id']);
            if($res){
                cache('db_config_sx_city_id_'.session('brandclass_id'),null);
                return array('code'=>200,'msg'=>'本地配置设定成功','data'=>'');
            }else{
                return array('code'=>100,'msg'=>'本地配置设定失败','data'=>'');
            }
        }else{
            return array('code'=>300,'msg'=>'未找到店面简码，不能设置','data'=>'');
        }

    }

    //受理流程设置
    public function manageSet(){
        if(Request::instance()->isAjax()){
            $res = controller('Setting','lib')->getManageJSON(input('param.'));
            return json($res);
        }else{
            return view('manageset');
        }
    }

    //添加受理流程页面
    public function addManage(){
        if(input('get.id')){
            $detail=db('s_manage_process')->where('id',input('get.id'))->find();
            $this->assign('detail',$detail);
        }
        //$brand=controller('Setting','lib')->brandclass_list();
        //$department=controller('Setting','lib')->department_list(['grade_type'=>1]);
        if(session('department_id')){
            $where = ['department_id'=>session('department_id')];
        }elseif(session('shop_code')){
            $where = ['shop_code'=>session('shop_code'),'department_id'=>'zero'];
        }elseif(session('brandclass_id')){
            $where = ['brandclass_id'=>session('brandclass_id'),'shop_code'=>'zero','department_id'=>'zero'];
        }elseif(!session('brandclass_id')){
            $where = ['brandclass_id'=>'zero','shop_code'=>'zero','department_id'=>'zero'];
        }
        $position=controller('Setting','lib')->get_position($where);
        $this->assign([
            //'brand'=>$brand,
           // 'department'=>$department,
            'position'=>$position]);
        return view('addmanage');
    }

    //删除受理流程
    public function delManage(){
        $id=input('post.id');
        $res=db('s_manage_process')->where('id',$id)->delete();
        if($res===false){
            return array('code'=>0,'msg'=>'删除失败，请稍后重试');
        }else{
            return array('code'=>1,'msg'=>'删除成功');
        }
    }

    //添加受理流程
    public function doAddManage(){
        $data=input('post.');
        if($data['manage_staff_number']&&$data['sort']!=1){
            $manage_staff=controller('Setting','lib')->get_staff(['staffnumber'=>$data['manage_staff_number']]);
            $manageData['manage_staff_number']  = $data['manage_staff_number'];
            $manageData['manage_staff_id']      = $manage_staff[0]['id'];
            $manageData['manage_staff_name']    = $manage_staff[0]['staffname'];
            $manageData['manage_brand_id']      = $manage_staff[0]['brandclass_id'];
            $manageData['manage_brandclass']    = $manage_staff[0]['brandclass'];
            unset($manage_staff);
        }

        if($data['is_second'] == 1){
            if($data['second_visit_staff_number']){
                $manage_staff=controller('Setting','lib')->get_staff(['staffnumber'=>$data['second_visit_staff_number']]);
                $manageData['second_visit_staff_number']  = $data['second_visit_staff_number'];
                $manageData['second_visit_staff_id']      = $manage_staff[0]['id'];
                $manageData['second_visit_staff_name']    = $manage_staff[0]['staffname'];
                $manageData['second_visit_brand_id']      = $manage_staff[0]['brandclass_id'];
                $manageData['second_visit_brandclass']    = $manage_staff[0]['brandclass'];
                unset($manage_staff);
            }
        }else{
            $manageData['second_visit_staff_number']  = '';
            $manageData['second_visit_staff_id']      = '';
            $manageData['second_visit_staff_name']    = '';
            $manageData['second_visit_brand_id']      = '';
            $manageData['second_visit_brandclass']    = '';
        }

        $manageData['sort']        = $data['sort'];
        $manageData['manage_num'] = $data['manage_num'];
        $manageData['is_great']   = $data['is_great'];
        $manageData['is_second']  = $data['is_second'];
        $manageData['is_open']    = $data['is_open'];

        $check_sort=db('s_manage_process')->where('sort',$data['sort'])->find();
        if(!$data['id']){
            if($check_sort){
                return array('code'=>0,'msg'=>'此排序数字已存在');
            }
            $res=db('s_manage_process')->insert($manageData);
        }else{
            if($check_sort&&$check_sort['id']!=$data['id']){
                return array('code'=>0,'msg'=>'此排序数字已存在');
            }
            $res=db('s_manage_process')->where('id',$data['id'])->update($manageData);
        }

        if($res===false){
            return array('code'=>0,'msg'=>'编辑失败，请稍后重试');
        }else{
            return array('code'=>1,'msg'=>'编辑成功');
        }
    }

    /*
     * 回访对象名称等设置
     */
    public function visitObjectName(){
        $object_list = db('k_visit_object')->where('is_show',1)->select();
        $this->assign(['object_list'=>$object_list]);
        return $this->fetch();
    }

    /*
     * 修改回访对象名称
     * id         对象id
     * new_name   修改的新名称
     */
    public function editVisitObjectName(){
        $id = input('id');
        $new_name = input('new_name');
        if($id&&$new_name){
            $res = db('k_visit_object')->where('id',$id)->update(['new_name'=>$new_name]);
            if($res===false){
                return array('code'=>201,'msg'=>'修改失败，请稍后重试！');
            }else{
                return array('code'=>200,'msg'=>'修改成功！');
            }
        }else{
            return array('code'=>201,'msg'=>'没有获取到信息！');
        }
    }

    /*
     * 回访环节对应回访对象设定
     */
    public function setVisitLinkObject(){
        if(Request::instance()->isAjax()){
            $orderArr = input('orderArr/a');
            $photoArr = input('photoArr/a');
            $spArr = input('spArr/a');
            $jgArr = input('jgArr/a');
            $qjArr = input('qjArr/a');
            $insertData = [];
            $add = ['add_time'=>date('Y-m-d H:i:s'),'add_staff_id'=>session('staff_id'),'add_staff_name'=>session('staff_name')];
            if(!empty($orderArr)){
                foreach($orderArr as $k1 => $v1){
                    $order = ['link'=>'order','option_id'=>$v1['id'],'option_code'=>$v1['option_code'],'object_code'=>$v1['object_code']];
                    $insertData[] = array_merge($add,$order);
                }
            }
            if(!empty($photoArr)){
                foreach($photoArr as $k2 => $v2){
                    $photo = ['link'=>'photo','option_id'=>$v2['id'],'option_code'=>$v2['option_code'],'object_code'=>$v2['object_code']];
                    $insertData[] = array_merge($add,$photo);
                }
            }
            if(!empty($spArr)){
                foreach($spArr as $k3 => $v3){
                    $sp = ['link'=>'sp','option_id'=>$v3['id'],'option_code'=>$v3['option_code'],'object_code'=>$v3['object_code']];
                    $insertData[] = array_merge($add,$sp);
                }
            }
            if(!empty($jgArr)){
                foreach($jgArr as $k4 => $v4){
                    $jg = ['link'=>'jg','option_id'=>$v4['id'],'option_code'=>$v4['option_code'],'object_code'=>$v4['object_code']];
                    $insertData[] = array_merge($add,$jg);
                }
            }

            if(!empty($qjArr)){
                foreach($qjArr as $k5 => $v5){
                    $qj = ['link'=>'qj','option_id'=>$v5['id'],'option_code'=>$v5['option_code'],'object_code'=>$v5['object_code']];
                    $insertData[] = array_merge($add,$qj);
                }
            }

            db()->startTrans();
            try{
                db('k_visit_link_object')->where('1=1')->delete();
                db('k_visit_link_object')->insertAll($insertData);
                db()->commit();
                return array('code'=>200,'msg'=>'设置成功！');
            }catch (\Exception $e){
                print_r($e->getMessage());
                db()->rollback();
                return array('code'=>201,'msg'=>'设置失败，请稍后重试！');
            }

        }else{

            //已设置评分项
            $already = db('k_visit_link_object')
                ->alias('a')
                ->join('k_visit_option b','a.option_id = b.id','left')
                ->join('k_visit_object c','b.object_id = c.id','left')
                ->where('c.is_show',1)
                ->field('a.*,b.option_name,c.new_name,c.code,c.content')
                ->select();

            //所有评分项
            $all = db('k_visit_option')
                ->alias('a')
                ->join('k_visit_object b','a.object_id = b.id','left')
                ->where('b.is_show',1)
                ->field('a.*,b.new_name,b.code,b.content')
                ->select();

            //print_r($already);print_r($all);die;

            //未设置评分项
            /*2019-07-25 每一项在不同环节可出现多次
            foreach($all as $key => $val){
                if(in_array($val['id'],array_column($already,'option_id'))){
                    unset($all[$key]);
                }
            }
            */

            $this->assign(['list'=>$all,'already'=>$already]);
            return $this->fetch();
        }

    }

    /*
     * 系统设置
     */
    public function systemSet(){
        if(Request::instance()->isAjax()){
            $inData['visit_score'] =  input('post.visit_score');
            $inData['visit_tel'] =  input('post.visit_tel');
            $inData['ks_signature'] = input('post.ks_signature');
            $inData['zj_object'] = input('post.zj_object');
            $data=db('s_sysconfig')->where('skey','kf')->find();
            if($data){
                $res = db('s_sysconfig')->where('skey','kf')->update(['svalue'=>json_encode($inData)]);
            }else{
                $res = db('s_sysconfig')->insert(['skey'=>'kf','svalue'=>json_encode($inData)]);
            }
            if($res===false){
                return array('code'=>0,'msg'=>'提交失败');
            }else{
                return array('code'=>1,'msg'=>'修改失败');
            }
        }else{
            $data=db('s_sysconfig')->where('skey','kf')->find();
            $svalue=json_decode($data['svalue'],true);
            $this->assign('svalue',$svalue);
            return view('systemset');
        }

    }


    /*
     * 调研问题设定
     */
    public function researchSet(){

        if(Request::instance()->isAjax()){
            $params = input('');

            $page = $params['page'] ? $params['page'] : 1;
            $limit = $params['limit'] ? $params['limit'] : 10;
            if($params['keyword']){
                $keyword  = 'question like :question';
                $keywordArr = ['question' => '%'.$params['keyword'].'%'];
            }
            $data = db('k_visit_question')->where($keyword,$keywordArr)->page($page,$limit)->select();
            $count = db('k_visit_question')->where($keyword,$keywordArr)->count();
            return json(['code'=>0,'data'=>$data,'count'=>$count]);
        }
        return $this->fetch();
    }

    /*
     * 新增问题
     */
    public function addResearch(){
        if(Request::instance()->isPost()){
            $data = input('');
            //print_r($data);die;
            $insertData['question'] = $data['question'];
            $insertData['create_time'] = date('Y-m-d H:i:s');
            $insertData['staff_id'] = session('staff_id');
            $insertData['staff_name'] = session('staff_name');

            //将空白项去除
            foreach($data['options'] as $k => $v){
                if(!$v) unset($data['options'][$k]);
            }
            $insertData['options']  = json_encode($data['options']);

            //调研问题在哪几个环节显示
            $insertData['link'] = $data['link']?implode(',',$data['link']):'';

            if($data['id']){
                $res = db('k_visit_question')->where('id',$data['id'])->update($insertData);
            }else{
                $res = db('k_visit_question')->insert($insertData);
            }

            if($res === false){
                return array('code'=>201,'msg'=>'操作失败，请稍后重试！');
            }else{
                return array('code'=>200,'msg'=>'操作成功');
            }

        }

        if(input('id')){
            $question = db('k_visit_question')->where('id',input('id'))->find();
            $question['options'] = json_decode($question['options'],true);
            $question['link']    = $question['link']?explode(',',$question['link']):[];
            //print_r($question);die;
            $this->assign('question',$question);
        }
        return $this->fetch();
    }

    /*
     * 删除调研问题
     */
    public function delResearch(){
        $id = input('id');
        if(!$id){
            return array('code'=>201,'msg'=>'没有获取到本条信息');
        }
        $res = db('k_visit_question')->where('id',$id)->delete();
        if($res === false){
            return array('code'=>202,'msg'=>'删除失败，请稍后重试！');
        }else{
            return array('code'=>200,'msg'=>'删除成功！');
        }
    }


    /*
     * 不满意原因设定
     */
    public function discontentSet(){
        if(request()->instance()->isAjax()){
            //获取不满意原因json数据
            $res = controller('Setting','lib')->getDiscontentJSON(input('param.'));
            return json($res);
        }

        return $this->fetch();
    }


    //添加/修改 不满原因
    public function addDiscontent(){
        $id = input('post.id');
        $name=input('post.name');
        $invalid = db('s_discontent')->where('name',$name)->find();
        if($id){
            if($invalid&&$invalid['id']!=$id){
                return array('code'=>100,'msg'=>'此不满原因已存在');
            }
        }else{
            if($invalid){
                return array('code'=>100,'msg'=>'此不满原因已存在');
            }
        }
        db()->startTrans();
        if($id){
            $res = db('s_discontent')->where('id',$id)->update(['name'=>$name,'create_time'=>date('Y-m-d H:i:s',time()),'staff_id'=>session('staff_id'),'staff_name'=>session('staff_name')]);
        }else{
            $res=db('s_discontent')->insert(['name'=>$name,'create_time'=>date('Y-m-d H:i:s',time()),'staff_id'=>session('staff_id'),'staff_name'=>session('staff_name')]);
        }
        if($res===false){
            db()->rollback();
            return array('code'=>100,'msg'=>'编辑不满原因失败');
        }else{
            action_log(input('post.'),'',0,session(['staff_id']),session(['staff_name']));
            db()->commit();
            return array('code'=>200,'msg'=>'编辑不满原因成功');
        }

    }

    //删除不满原因
    public function delDiscontent(){
        $id = input('post.id');
        $res = db('s_discontent')->where('id',$id)->delete();
        if($res===false){
            return array('code'=>100,'msg'=>'删除不满原因失败');
        }else{
            return array('code'=>200,'msg'=>'删除不满原因成功');
        }
    }


    /*
    * 客诉解决设定
    */
    public function solutionSet(){
        if(request()->instance()->isAjax()){
            //获取不满意原因json数据
            $res = controller('Setting','lib')->getSolutionJSON(input('param.'));
            return json($res);
        }

        return $this->fetch();
    }


    //添加/修改 不满原因
    public function addSolution(){
        $id = input('post.id');
        $name=input('post.name');
        $invalid = db('s_solution')->where('name',$name)->find();
        if($id){
            if($invalid&&$invalid['id']!=$id){
                return array('code'=>100,'msg'=>'此客诉解决方案已存在');
            }
        }else{
            if($invalid){
                return array('code'=>100,'msg'=>'此客诉解决方案已存在');
            }
        }
        db()->startTrans();
        if($id){
            $res = db('s_solution')->where('id',$id)->update(['name'=>$name,'create_time'=>date('Y-m-d H:i:s',time()),'staff_id'=>session('staff_id'),'staff_name'=>session('staff_name')]);
        }else{
            $res=db('s_solution')->insert(['name'=>$name,'create_time'=>date('Y-m-d H:i:s',time()),'staff_id'=>session('staff_id'),'staff_name'=>session('staff_name')]);
        }
        if($res===false){
            db()->rollback();
            return array('code'=>100,'msg'=>'编辑客诉解决方案失败');
        }else{
            action_log(input('post.'),'',0,session(['staff_id']),session(['staff_name']));
            db()->commit();
            return array('code'=>200,'msg'=>'编辑客诉解决方案成功');
        }

    }

    //删除不满原因
    public function delSolution(){
        $id = input('post.id');
        $res = db('s_solution')->where('id',$id)->delete();
        if($res===false){
            return array('code'=>100,'msg'=>'删除不满原因失败');
        }else{
            return array('code'=>200,'msg'=>'删除不满原因成功');
        }
    }

}
