<?php
/**
 * 统计控制器
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: wangyining<wangyining@suxuantech.cn> $
 */
namespace app\kf\controller;
use app\index\controller\Base;
use PHPExcel;
use Symfony\Component\Yaml\Yaml;
use think\Queue;
use think\Request;

class Statistics extends Base{


    //无效原因统计页面
    public function invalid(){

        if(Request::instance()->isAjax()){

            $data = input();
            $detail=controller("Statistics","lib")->getInvalid($data);
            echo  json_encode($detail);
        }else{

            $source=db('s_source')->select();
            $complain=db('s_complain_type')->select();
            $brand=controller('Setting','lib')->brandclass_list();
            $this->assign(['title'=>'无效原因明细','source'=>$source,'complain'=>$complain,'brand'=>$brand]);

            return $this->fetch();
        }
    }
    
    //导出无效原因
    public function exportInvalid(){


        $sql=controller('Statistics','lib')->getInvalidSql(input());
        $data=db('k_order')->field('order_time,orderId,mname,mphone,wname,wphone,invalid_reason')->where($sql)->select();
        $title=exportInvalid();
        $file="wuxiao.xlsx";
        controller("Statistics","lib")->export($title,$data,$file);
    }


    /*
     *事业部每月客诉汇总数据（12月）
     */
    public function ksEveryMonth(){

        if(Request::instance()->isAjax()){
            $data = input();
            $detail=controller("Statistics","lib")->ksEveryMonth($data);
            return json($detail);
        }else{

            $source = db('s_source')->select();
            $countSource = count($source);
            $complain = db('s_complain_type')->where('fid',0)->select();
            $countComplain = count($complain);
            $brand=controller('Setting','lib')->brandclass_list();
            $this->assign(['title'=>'事业部每月客诉汇总数据','brand'=>$brand,'source'=>$source,'countSource'=>$countSource,'complain'=>$complain,'countComplain'=>$countComplain]);
            return $this->fetch();
        }
    }

    /*
     * 导出事业部每月客诉汇总数据（12月）
     */
    public function exportKsEveryMonth(){
        $data = controller('Statistics','lib')->ksEveryMonth(input());
        controller('Statistics','lib')->exportKsEveryMonth($data['data'],input('get.brandclass'));
    }

    /*
    * 事业部每月客诉汇总数据（客诉分类）（12月）
    */
    public function ksDutyClassify(){

        if(Request::instance()->isAjax()){
            $data = input();
            $detail=controller("Statistics","lib")->ksDutyClassify($data);
            return json($detail);
        }else{
            $departmentAll = db('k_work_order')->where('department_name is not null and department_name <> ""')->group('department_name')->select();
            $department = array_values(array_unique(explode(',',trim(implode(',',array_column($departmentAll,'department_name')),','))));
            $countDepartment = count($department);
            $source = db('s_source')->select();
            $countSource = count($source);
            //投诉类型
            $complainAll = db('s_complain_type')->order('create_time')->select();
            $complainTree = listToTree($complainAll);
            $secondComplain = [];//二级
            foreach($complainTree as $k => $v){
                $secondComplain = array_merge($secondComplain,$v['_child']);
            }

            $countComplain = count($secondComplain);//二级个数 表格列数

            $this->assign(['title'=>'客诉责任分类','department'=>$department,'countDepartment'=>$countDepartment,'source'=>$source,'countSource'=>$countSource,'complain'=>$complainTree,'secondComplain'=>$secondComplain,'countComplain'=>$countComplain]);
            return $this->fetch();
        }
    }

    /*
    * 导出客诉分类（12月）
    */
    public function exportKsDuty(){
        $data = controller('Statistics','lib')->ksDutyClassify(input());
        controller('Statistics','lib')->exportKsDuty($data['data']);
    }

    /*  1.
     *  回访对比
     *  @params brand_id    事业部id
     *  @params visit_type  服务/专业
     *  @params score      超期/达到/低期
     *  @params start_time
     *  @params end_time
    */
    public function visitSameTime(){
        $params = input();
        $data = controller("Statistics", "lib")->visitContrast($params);

        $brand_id = $params['brand_id'];
        if ($brand_id && $brand_id != 0) {
            $shop = controller('Setting', 'lib')->get_shop(['brandclass_id' => $brand_id]);
        }

        if ($shop) {
            $column = [];
            foreach ($shop as $k => $v) {
                $array['shop_' . $v['shop_code']]['name'] = $v['shop_name'];
                $array['shop_' . $v['shop_code']]['column'] = 'shop_' . $v['shop_code'];
                array_push($column, $array['shop_' . $v['shop_code']]);
                $array['3_' . $v['shop_code']]['name'] = '同期';
                $array['3_' . $v['shop_code']]['column'] = 'tq_' . $v['shop_code'];
                array_push($column, $array['3_' . $v['shop_code']]);
            }

            $titles = '';
            foreach ($column as $kk => $vv) {
                $titles .= '<th style="width: 100px">' . $vv['name'] . '</th>';
            }

            $dataList = '';
            foreach ($data as $key => $val) {
                $dataList .= '<tr>';
                foreach ($column as $ti => $title) {
                    if(empty($val[$title['column']])){
                        $val[$title['column']]='0.00%';
                    }
                    $dataList .= '<td>' . $val[$title['column']] . '</td>';
                }
                $dataList .= '</tr>';
            }
        }

        $brand=controller('Setting','lib')->brandclass_list();
        $this->assign('detail',$params);
        $this->assign(['title'=>'回访对比','brand'=>$brand,'titles'=>$titles,'data'=>$data,'dataList'=>$dataList]);
        return $this->fetch();
    }

    /*
    * 导出  回访对比
    */
    public function exportVisitContrast(){
        $data = controller('Statistics','lib')->visitContrast(input());
        controller('Statistics','lib')->exportVisitContrast($data,input());
    }

    /* 2
     * 回访对比（超期，达到，底期同时显示）
     */
    public function visitContrast2(){

        $params = input();
        $data=controller("Statistics","lib")->visitContrast2($params);

        $brand_id = $params['brand_id'];
        if($brand_id&&$brand_id!=0){
            $shop = controller('Setting','lib')->get_shop(['brandclass_id'=>$brand_id]);
        }

        if($shop){
            $column = [];
            foreach($shop as $k => $v){
                $array['shop_'.$v['shop_code']]['name'] = $v['shop_name'];
                $array['shop_'.$v['shop_code']]['column'] = 'shop_'.$v['shop_code'];
                array_push($column,$array['shop_'.$v['shop_code']]);
                $array['3_'.$v['shop_code']]['name'] = '超期';
                $array['3_'.$v['shop_code']]['column'] = '3_'.$v['shop_code'];
                array_push($column,$array['3_'.$v['shop_code']]);
                $array['2_'.$v['shop_code']]['name'] = '达到';
                $array['2_'.$v['shop_code']]['column'] = '2_'.$v['shop_code'];
                array_push($column,$array['2_'.$v['shop_code']]);
                $array['1_'.$v['shop_code']]['name'] = '低于';
                $array['1_'.$v['shop_code']]['column'] = '1_'.$v['shop_code'];
                array_push($column,$array['1_'.$v['shop_code']]);
            }

            $titles = '';
            foreach($column as $kk => $vv){
                $titles .= '<th style="width: 100px">'.$vv['name'].'</th>';
            }

            $dataList = '';
            foreach($data as $key => $val){
                $dataList .= '<tr>';
                foreach($column as $ti => $title){
                    $dataList .= '<td>'.$val[$title['column']].'</td>';
                }
                $dataList .= '</tr>';
            }
        }

        $brand=controller('Setting','lib')->brandclass_list();
        $this->assign('detail',$params);
        $this->assign(['title'=>'回访 超期/达到/低于 对比','brand'=>$brand,'titles'=>$titles,'data'=>$data,'dataList'=>$dataList]);
        return $this->fetch();


    }

    /*
     * 导出  回访对比（超期，达到，底期同时显示）
     */
    public function exportVisitContrast2(){
        $data = controller('Statistics','lib')->visitContrast2(input());
        controller('Statistics','lib')->exportVisitContrast2($data,input());
    }


    /* 4
     * 事业部各部门对比
     */
    public function departmentBrand(){
        if(Request::instance()->isAjax()){
            $data = input();
            $detail=controller("Statistics","lib")->departmentBrand($data);
            return json($detail);
        }else{

            $brand=controller('Setting','lib')->brandclass_list();
            $countBrand = count($brand)*2;
            $this->assign(['title'=>'1-12月事业部各部门对比','brand'=>$brand,'countBrand'=>$countBrand]);
            return $this->fetch();
        }
    }

    /*
    * 导出  事业部各部门对比
    */
    public function exportDepartmentBrand(){
        $data = controller('Statistics','lib')->departmentBrand(input());
        controller('Statistics','lib')->exportDepartmentBrand($data['data'],input());
    }


    /*
    * 回访对象得分数据 百分比 对比
    * params brand_id     事业部id
    * params order_link   订单类型
    * params visit_type   专业/服务
    * params start_time   开始时间
    * params end_time     结束时间
    */
    public function staffVisit(){
        if(Request::instance()->isAjax()){
            $data = input();
            $detail=controller("Statistics","lib")->staffVisit($data);
            return json($detail);
        }else{

            $brand=controller('Setting','lib')->brandclass_list();
            $this->assign(['title'=>'回访对象得分对比','brand'=>$brand]);
            return $this->fetch();
        }
    }


    /*
    * 回访对象得分数据 百分比 对比------导出
    * params brand_id     事业部id
    * params order_link   订单类型
    * params visit_type   专业/服务
    * params start_time   开始时间
    * params end_time     结束时间
    */
    public function exportStaffVisit(){
        $data = controller('Statistics','lib')->staffVisit(input());
        controller('Statistics','lib')->exportStaffVisit($data['data'],input());
    }

    /*
     * 员工回访量对比
     * params  brand_id   事业部id
     * params order_link   订单类型
     * params start_time   开始时间
     * params end_time     结束时间
     */
    public function visitAmount(){
        if(Request::instance()->isAjax()){
            $data = input();
            $detail=controller("Statistics","lib")->visitAmount($data);
            return json($detail);
        }else{

            $brand=controller('Setting','lib')->brandclass_list();
            $this->assign(['title'=>'员工回访量对比','brand'=>$brand]);
            return $this->fetch();
        }
    }

    /*
     * 员工回访量对比  --------------导出
     * params  brand_id   事业部id
     * params order_link   订单类型
     * params start_time   开始时间
     * params end_time     结束时间
     */
    public function exportVisitAmount(){
        $data = controller('Statistics','lib')->visitAmount(input());
        controller('Statistics','lib')->exportVisitAmount($data['data'],input());
    }


    /*
     * 回访订单详情信息
     * params  brand_id   事业部id
     * params order_link   订单类型
     * params start_time   开始时间
     * params end_time     结束时间
     * params visit_type   服务、专业
     */
    public function visitOrderInfo(){
        $params = input();

        //集团的人
        $brand=controller('Setting','lib')->brandclass_list();
        if(session('grade_type') == 1){
            $brand_id = $brand[0]['id'];
        }else{
            $brand_id = session('brandclass_id');
        }

        //默认事业部
        if(!$params['brand_id']){
            $params['brand_id'] = $brand_id;
        }

        //若页面传all则是查全集团
        if($params['brand_id'] == 'all'){
            $params['brand_id'] = '';
        }

        //print_r(request()->get(''));die;
        if(Request::instance()->isAjax()){

            $detail=controller("Statistics","lib")->visitOrderInfo($params);
            return json($detail);
        }else{

            //本环节回访对象
            $visitObj = controller('Statistics','lib')->getVisitObject($params['order_link'],$params['visit_type']);

            //本环节调研问题
            $question = controller('Statistics','lib')->getLinkQuestion($params['order_link']);


            $this->assign(['title'=>'回访订单详情信息','brand'=>$brand,'brand_id'=>$brand_id]);
            $this->assign(['visitObj'=>$visitObj,'question'=>$question]);//表头，回访对象 和调研问题
            return $this->fetch();
        }
    }

    /*
     * 回访订单详情信息------------------导出
     * params  brand_id   事业部id
     * params order_link   订单类型
     * params start_time   开始时间
     * params end_time     结束时间
     * params visit_type   服务、专业
     */
    public function exportVisitOrderInfo(){
        $params = input();
        $params['is_all'] = 1;
        $data = controller("Statistics","lib")->visitOrderInfo($params);
        controller('Statistics','lib')->exportVisitOrderInfo($data['data'],$params);
    }


}
