<?php
/**
 * KF 品控中心->考试
 * 默认接口方法，此方法内定议基础框架所需要的方法，用于验证模块合法性，模块版本，对接基础架构中需要的方法
 * 此类不作任何业务逻辑
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: chaidongdong<chaidongdong@suxuantech.cn> 2018-4-23 $
 */
namespace app\kf\controller;

use app\index\controller\Base;
use think\Request;

class Test extends Base{

    /**
     * 培训列表
     *
     * @return unknown
     * @author chaidongdong@suxuantech.cn
     */
    public function testList(){
        if(Request::instance()->isAjax()){
            $data = input();
            $detail=controller("Test","lib")->TestList($data);
            echo  json_encode(array_merge(['code'=>0,'msg'=>''],$detail));
            exit;
        }else{
            return view('testlist');
        }
    }

    /**
     * 添加、修改 考试 
     *
     * @param int $id
     * @return unknown
     * @author chaidongdong@suxuantech.cn
     */
    public function testSave(){
        $data = input();
        $test = controller('Test','lib')->getTestInfo(['id'=>$data['id']]);
        $this->assign('test',$test);
        $trainings = controller('Training','lib')->getTrainings();
        $this->assign('trainings',$trainings);
        return $this->fetch();
    }

    /**
     * 参加考试二维码
     *
     * @param integer $id
     * @return view
     * @author chaidongdong@suxuantech.cn
     */
    public function qrcodeTest(){
        $data = input();
        $http = $_SERVER['HTTPS'] ? 'http://' : 'http://';
        $test_url = $http.$_SERVER['HTTP_HOST'].'/kf/Mobile/tTestInfo.html?id='.$data['id'];
        controller('Test','lib')->qrcodeTest($test_url,'test_'.$data['id']);

        $apply_url = $http.$_SERVER['HTTP_HOST'].'/kf/Mobile/applyTest.html?test_id='.$data['id'];
        controller('Test','lib')->getApplyTestQrcode($apply_url,'apply_question_'.$data['id']);
        $this->assign('url','/upload/test/apply_question_'.$data['id'].'.png');

        $this->assign('test_id',$data['id']);
        return view('qccodetest');
    }

    /**
     * 添加、修改考试数据
     *
     * @param array $data
     * @param unknown
     * @author chaidongdong@suxuantech.cn
     */
    public function saveTest(){
        $data = input();
        $data['create_staff_id'] = session('staff_id');
        $res = controller('Test','lib')->saveTest($data,$msg);
        if(!$res){
            echo json_encode(array('code'=>0,'msg'=>$msg));
        }else{
            echo json_encode(array('code'=>1,'msg'=>$msg));
        }
        exit;
    }

    /**
     * 审题二维码
     */
//    public function applyQuestion(){
//        $data = input();
//        $http = $_SERVER['HTTPS'] ? 'http://' : 'http://';
//        $apply_url = $http.$_SERVER['HTTP_HOST'].'/kf/Mobile/applyTest.html?test_id='.$data['id'];
//        $res = controller('Test','lib')->getApplyTestQrcode($apply_url,'apply_question_'.$data['id']);
//        $this->assign('url','/upload/test/apply_question_'.$data['id'].'.png');
//        return $this->fetch();
//    }

    /**
     * 考试添加考题页面
     *
     * @param int $id  考试ID
     * @return unknown
     * @author chaidongdong@suxuantech.cn
     */
    public function addTestQuestion(){
        $data = input();
        $test = controller('Test','lib')->getTestInfo(['id'=>$data['id']]);
        $test['rule'] = json_decode($test['rule'],true);
        if($test['type'] == 1){
            $question_list = [];
            foreach ($test['rule'] as $value){
                foreach ($value as $v){
                    $question = controller('Question','lib')->getQuestionInfo(['id'=>$v['question_id']]);
                    $question_list[] = [
                        'question'=>$question['question'],
                        'id'=>$v['question_id'],
                        'score'=>$v['score'],
                        'question_type'=>$question['question_type']
                    ];
                }
            }
            $this->assign('question_list',$question_list);
        }
        $this->assign('test',$test);
        if($test['type'] == '1'){
            //固定出题
            return view('addtestquestion1');
        }
        if($test['type'] == '2'){
            //随机出题
            return view('addtestquestion2');
        }
    }

    /**
     * 添加考题功能
     *
     * @param array $data 考题数据或者规则
     * @return json 
     * @author chaidongdong@suxuantech.cn
     */
    public function saveTestQuestion(){
        $data = input();
        $res = controller('Test','lib')->saveTestQuestion($data,$msg);
        if(!$res){
            echo json_encode(array('code'=>0,'msg'=>$msg));
        }else{
            echo json_encode(array('code'=>1,'msg'=>$msg));
        }
        exit;
    }

    /**
     * 删除考试
     *
     * @param string $id
     * @return json
     * @author chaidongdong@suxauntech.cn
     */
    public function delTest(){
         $data = input();
         $res = controller('Test','lib')->delTest(['id'=>$data['id']]);
         if(!$res){
             echo json_encode(array('code'=>0,'msg'=>'删除失败'));
         }else{
             echo json_encode(array('code'=>1,'msg'=>'删除成功'));
         }
        exit;
    }

    /**
     * 获取单一考题
     *
     * @param integer $id
     * @return json
     * @author chaidongdong@suxuantech.cn
     */
    public function getSingles(){
        $data = input();
        $res = controller('Question','lib')->getQuestionInfo(['id'=>$data['id']]);
        if($res){
            echo json_encode(['code'=>1,'data'=>$res]);
        }else{
            echo json_encode(['code'=>0,'msg'=>'考题不存在']);
        }
        exit;
    }

    /**
     * 考试成绩列表
     *
     * @param integer $test_id
     * @return view
     * @author chaidongdong@suxuantech.cn
     */
    public function answerList(){
        $data = input();
        if($data['a']){
            $data['key']= [
                'test_id'=>$data['test_id'],
                'score'=>['s'=>'neq','v'=>'-1'],
                'is_supplement'=>$data['is_supplement']?$data['is_supplement']:0
            ];
            $answer = controller('Test','lib')->getTestAnswerA($data);
            echo  json_encode(array_merge(['code'=>0,'msg'=>''],$answer));
            exit;
        }else{
            $test = controller('Test','lib')->getTestInfo(['id'=>$data['id']]);
            $this->assign('test_id',$data['id']);
            $this->assign('test',$test);
            return view('answerlist');
        }
    }

    /**
     * 导出页面
     */
    public function testExport(){
        $data = input();
        return view('testexport');
    }


    /**
     * 导出考试成绩
     */
    public function exportTestAnswer(){
        $data = input();
        controller('Test','lib')->export_excel($data['test_id']);
    }

    /**
     * 考试结果修改加分
     *
     * @param array
     * @return view
     * @author chaidongdong@suxuantech.cn
     */
    public function savePoints(){
        $data = input();
        $res = controller('Test','lib')->saveTestPoints($data['test_id'],$data['points']);
        if($res){
            echo json_encode(['code'=>0,'msg'=>'']);
        }else{
            echo json_encode(['code'=>1,'msg'=>'操作失败']);
        }
        exit;
    }


}