<?php
/**
 * KF 品控中心->培训
 * 默认接口方法，此方法内定议基础框架所需要的方法，用于验证模块合法性，模块版本，对接基础架构中需要的方法
 * 此类不作任何业务逻辑
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: chaidongdong<chaidongdong@suxuantech.cn> 2018-4-23 $
 */
namespace app\kf\controller;

use app\index\controller\Base;
use think\Request;
use app\kf\model\TTraining;
use app\kf\model\TTrainingJoin;

class Training extends Base{

    // public function index(){
    //     $this->trainList();
    // }
    /**
     * 培训列表
     *
     * @return unknown
     * @author chaidongdong@suxuantech.cn
     */
    public function trainList(){
        if(Request::instance()->isAjax()){
            $data = input();
            if($data['key']){
                $date = date('Y-m-d H:i:s');
                if($data['key']['status']){
                    switch ($data['key']['status']) {
                        case 'not_beginning':
                            $data['key']['start_time'] = ['s'=>'gt','v'=>$date];
                            $data['key']['status'] = '1';
                            break;
                        case 'begining':
                            $data['key']['start_time'] = ['s'=>'lt','v'=>$date];
                            $data['key']['end_time'] = ['s'=>'gt','v'=>$date];
                            $data['key']['status'] = '1';
                            break;
                        case 'begined':
                            $data['key']['end_time'] = ['s'=>'lt','v'=>$date];
                            $data['key']['status'] = '1';
                            break;
                        case 'pause':
                            $data['key']['status'] = '2';
                            break;
                        case 'pause':
                            $data['key']['cancel'] = '3';
                            break;
                    }
                }
                if($data['key']['title']){
                    $data['key']['title'] = ['s'=>'like','v'=>'%'.$data['key']['title'].'%'];
                }
            }
            $data['key'] = array_filter($data['key']);
            $detail=controller("Training","lib")->TrainingList($data);
            echo  json_encode(array_merge(['code'=>0,'msg'=>''],$detail));
            exit;
        }else{
            return view('traininglist');
        }
    }

    /**
     * 新增或者修改培训页面
     *
     * @param int $id 培训ID
     * @return unknown
     * @author chaidongdong@suxuantech.cn
     */
    public function trainingAdd(){
        $id=input('get.id');
        if($id){
            $detail=controller("Training","lib")->getOneTraining(['id'=>$id]);
            if($detail){
                $this->assign('detail',$detail);
            }
        }
        $status_list=controller("Training","lib")->status;
        $this->assign('status_list',$status_list);
        return $this->fetch();
    }

    /**
     * 添加或修改培训数据
     *
     * @param array
     * @return json
     * @author chaidongdong@suxuantech.cn
     */
    public function saveTraining(){
        $data = input('post.');
        $data['create_staff_id'] = session('staff_id');
        $res=controller("Training","lib")->addTraining($data,$msg);
        if(!$res){
            echo json_encode(array('code'=>0,'msg'=>$msg));
        }else{
            echo json_encode(array('code'=>1,'msg'=>$msg));
        }
        exit;
    }

    /**
     * 删除培训数据
     *
     * @param int $id 培训ID
     * @return array
     * @author chaidongdong@suxuantech.cn
     */
    public function delTraining(){
        $data = input('post.');
        $res=controller("Training","lib")->delTraining($data,$msg);
        if(!$res){
            echo json_encode(array('code'=>0,'msg'=>$msg));
        }else{
            echo json_encode(array('code'=>1,'msg'=>$msg));
        }
        exit;
    }

    /**
     * 二维码
     *
     * @param integer $id
     * @return mixed
     * @author chaidongdong@suxuantech.cn
     */
    public function codeTraining(){
        $data = input();
        $http = $_SERVER['HTTPS'] ? 'http://' : 'http://';
        $join_url = $http.$_SERVER['HTTP_HOST'].'/kf/Mobile/tJoinTraining.html?id='.$data['id'];
        controller('Training','lib')->qrcodeTraining($join_url,'join_'.$data['id']);
        $sign_url = $http.$_SERVER['HTTP_HOST'].'/kf/Mobile/tSignTraining.html?id='.$data['id'];
        controller('Training','lib')->qrcodeTraining($sign_url,'sign_'.$data['id']);
        $this->assign(
            'url',
            [
                'join'=>'/upload/training/'.'join_'.$data['id'].'.png',
                'sign'=>'/upload/training/'.'sign_'.$data['id'].'.png',
            ]);
        return $this->fetch();
    }

    /**
     * 报名签到列表
     *
     * @param int $id $培训ID
     * @return array
     * @author chaidongdong@suxuantech.cn
     */
    public function joinTraining(){
        $data = input('get.');
        $param['training_id'] = $data['id'];
        $list = controller('Training','lib')->getJoinSignTrainingList($param);
        $this->assign('joinList',$list);
        $this->assign('training_id',$param['training_id']);
        return $this->fetch();
    }

    /**
     * 导出报名签到列表
     *
     * @param integer $training_id
     * @return file
     */
    public function exportJoinTraining(){
        $data = input();
        $param['training_id'] = $data['training_id'];
        $training = controller('Training','lib')->getTrainingInfo(['id'=>$data['training_id']]);
        $list = controller('Training','lib')->getJoinSignTrainingList($param);
        $title = ['培训名称','姓名','报名时间','签到时间'];
        if($list && $training){
            $export_data = [];
            foreach ($list as $value){
                $export_data[] = [
                    'training_title'=>$training['title'],
                    'staff_name'=>$value['staff_name'],
                    'join_time'=>$value['join_time'],
                    'sign_time'=>$value['sign_time']
                ];
            }
        }
        return controller('Training','lib')->export($title,$export_data,$training['title'].'报名签到表');
    }

    /**
     * 花絮页面展示
     *
     * @param integer $training_id
     * @return view
     */
    public function tidbitSave(){
        $data = input();
        $training = controller('Training','lib')->getOneTraining(['id'=>$data['id']]);
        $this->assign('tidbit',$training['tidbit']);
        return view('tidbitsave');
    }
    /**
     * 修改花絮
     */
    public function saveTidbit(){
        $data = input();
        if($data['tidbit']){
            foreach ($data['tidbit'] as $key => $value){
                $data['tidbit'][$key] = @json_decode($value,true);
            }
        }
        $res = controller('Training','lib')->saveTrainingTidbit($data['tidbit'],['id'=>$data['id']]);
        if($res){
            echo json_encode(['code'=>0,'msg'=>'修改成功']);
        }else{
            echo json_encode(['code'=>1,'msg'=>'修改失败']);
        }
        exit;
    }

    /**
     * 图片上传
     *
     * @param mixed $file
     * @return json
     * @author chaidongdong@suxuantech.cn
     */
    public function upload_img(){
        $path = controller('Training','lib')->upload_image();
        if($path){
            echo json_encode(['code'=>0,'msg'=>'','path'=>$path]);
        }else{
            echo json_encode(['code'=>1]);
        }
        exit;
    }

    /**
     * 附件上传
     *
     * @param unknown
     * @return json
     * @author chaidongdong@suxuantech.cn
     */
    public function upload_file(){
        $data = input();
        $res = controller('Training','lib')->uploadFile($_FILES['file'],'',$msg);
        if($res){
            return ['code'=>'0','data'=>$res];
        }else{
            return ['code'=>'1','msg'=>$msg];
        }
    }




}