<?php
/**
 * KF 回访中心
 * 默认接口方法，此方法内定议基础框架所需要的方法，用于验证模块合法性，模块版本，对接基础架构中需要的方法
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: wangyining<wangyining@suxuantech.cn> 2018-04-11 $
 */
namespace app\kf\controller;
use app\kf\lib\Target;
use think\Cache;
use app\index\controller\Base;
use think\Exception;
use think\Log;
use think\Request;
use think\Session;
use PHPExcel_IOFactory;
use PHPExcel;
use Excel5;
use think\Controller;
use app\common\lib\redisQueue;
class Visit extends Base{

    /**订单列表
     * @return \think\response\View
     */
    public function orderList(){


        if(Request::instance()->isAjax()){
            $data = input();
            //$data['brand_id'] = $data['brand_id'] ? $data['brand_id'] : $brand_id;
            //$data['shop_code'] = $data['shop_code'] ? $data['shop_code'] : $shop_code;

            $detail=controller("Visit","lib")->orderListData($data);
            //print_r($detail);die;
            echo  json_encode($detail);
        }else{

            //集团的人
            if(session('grade_type') == 1){
                $brand = controller('Setting','lib')->brandclass_list();
                $brand_id = $brand[0]['id'];
            }else{
                $brand = controller('Setting','lib')->brandclass_list(['id'=>session('brandclass_id')]);
                $brand_id = session('brandclass_id');
            }

            $shopList = controller('Setting','lib')->get_shop(['brandclass_id'=>$brand_id]);

            if(session('shop_code')){
                $shop_code = session('shop_code');
            }else{
                $shop_code = $shopList[0]['shop_code'];
            }

            $staffList = controller('Setting','lib')->get_staff(['brandclass_id'=>$brand_id]);

            //是否审核客诉
            $is_check = db('s_menu')->where('menu_code','menu1529393800')->value('status');

            $this->assign([
                'brand'=>$brand,
                'shopList' => $shopList,
                'brand_id' => $brand_id,
                'shop_code'=> $shop_code,
                'staffList'=> $staffList,
                'is_check' => $is_check
            ]);
            return view('orderlist');
        }

    }

    /*
     * 导出
     */
    public function exportVisit(){
        $data = input();
        //print_r($data);
        if($data['tabs'] != 'my_ks' && $data['tabs'] != 'not_check'){
            $listRes = controller("Visit","lib")->orderListData($data);
            //print_r($listRes);die;
            $list = $listRes['data'];
            $export = [];
            foreach($list as $key => $val){
                $export[$key]['orderId'] = $val['orderId'];
                $export[$key]['wname']   = $val['wname'];
                $export[$key]['wphone']  = $val['wphone'];
                $export[$key]['mname']   = $val['mname'];
                $export[$key]['mphone']  = $val['mphone'];

                $export[$key]['already_visit']  = $val['already_visit'] ? $val['already_visit'] : '回访过';//是否回访过

                //是否领取
                if($val['order_link'] == 'order'){
                    $export[$key]['order_link'] = '已领取（已订单）';
                }elseif($val['order_link'] == 'photo'){
                    $export[$key]['order_link'] = '已领取（已拍照）';
                }elseif($val['order_link'] == 'sp'){
                    $export[$key]['order_link'] = '已领取（已选片）';
                }elseif($val['order_link'] == 'jg'){
                    $export[$key]['order_link'] = '已领取（已校稿）';
                }elseif($val['order_link'] == 'qj'){
                    $export[$key]['order_link'] = '已领取（已取件）';
                }else{
                    //以上都没有，则是erp接口返回订单中，经过排重 判断是否领取的结果
                    $export[$key]['order_link'] = $val['order_link'];
                }

                //回访状态
                if($val['is_valid'] == 1){
                    $export[$key]['is_valid'] = '完成';
                }elseif($val['is_valid'] == 2){
                    $export[$key]['is_valid'] = '继续回访';
                }elseif($val['is_valid'] == 3){
                    $export[$key]['is_valid'] = '无效';
                }else{
                    $export[$key]['is_valid'] = '未回访';
                }


                $export[$key]['visit_staff_name']  = $val['visit_staff_name'];//回访人
                $export[$key]['connect_phone']     = $val['connect_phone'];//接通电话


                $export[$key]['order_type_name']  = $val['order_type_name'];//订单状态
                $export[$key]['shop_name']  = $val['shop_name'];
                $export[$key]['consumption_type']  = $val['consumption_type'];//消费类型
                $export[$key]['package_name']  = $val['package_name'];//包套名称
                $export[$key]['total_money']  = $val['total_money'];//金额

                switch($data['order_link']){
                    case 'order':
                        $export[$key]['storeconsuitant1'] = $val['storeconsuitant1'];
                        $export[$key]['storeconsuitant2'] = $val['storeconsuitant2'];
                        break;
                    case 'photo':
                        $export[$key]['storeconsuitant1'] = $val['storeconsuitant1'];
                        $export[$key]['storeconsuitant2'] = $val['storeconsuitant2'];
                        $export[$key]['cameraman'] = $val['cameraman'];
                        $export[$key]['photoassistant'] = $val['photoassistant'];//摄影助理
                        $export[$key]['dresser'] = $val['dresser'];//化妆师
                        $export[$key]['huazhuangzhuli'] = $val['huazhuangzhuli'];//化妆助理
                        $export[$key]['secretaireman'] = $val['secretaireman'];//礼服师
                        $export[$key]['zhuozhuangshi'] = $val['zhuozhuangshi'];//着装师
                        break;
                    case 'sp':
                        $export[$key]['selectman'] = $val['selectman'];//选片师
                        $export[$key]['kanbanshi'] = $val['kanbanshi'];//校稿人员
                        $export[$key]['secretaireman'] = $val['secretaireman'];//礼服秘书
                        $export[$key]['cameraman'] = $val['cameraman'];//摄影师
                        $export[$key]['dresser'] = $val['dresser'];//化妆师
                        $export[$key]['storeconsuitant1'] = $val['storeconsuitant1'];//门市销售
                        break;
                    case 'jg':
                        $export[$key]['selectman'] = $val['selectman'];//选片师
                        $export[$key]['kanbanshi'] = $val['kanbanshi'];//校稿人员（看版师）
                        break;
                    case 'qj':
                        $export[$key]['storeconsuitant1'] = $val['storeconsuitant1'];//门市销售
                        $export[$key]['storeconsuitant4'] = $val['storeconsuitant4'];//服务人员
                        $export[$key]['qj_renname'] = $val['qj_renname'];//取件人
                        $export[$key]['selectman'] = $val['selectman'];//选片师
                        break;
                    case '未领取':
                        break;
                }

            }

            $title = ['订单编号','女士姓名','女士手机号','男士姓名','男士手机号','是否回访过','是否领取','回访状态','回访人','接通电话','订单状态','店面名称','消费类型','包套名称','金额'];
            switch($data['order_link']){
                case 'order':
                    $addTitle = ['销售门市','网销门市'];
                    break;
                case 'photo':
                    $addTitle = ['销售门市','网销门市','摄影师','摄影助理','化妆师','化妆助理','礼服师','着装师'];
                    break;
                case 'sp':
                    $addTitle = ['选片师','校稿人员','礼服秘书','摄影师','化妆师','门市销售'];
                    break;
                case 'jg':
                    $addTitle = ['订单状态','选片师','校稿人员'];
                    break;
                case 'qj':
                    $addTitle = ['订单状态','门市销售','服务人员','取件人','选片师'];
                    break;
                case '未领取':
                    $addTitle = [];
                    break;
            }
            $title = array_merge($title,$addTitle);
            $files = 'visit.xlsx';
            //$title = ['订单编号','女士姓名','女士手机号','男士姓名','男士手机号','是否领取','订单状态','店面名称','消费类型','包套名称','金额'];

        }else{
            $listRes = controller('Visit','lib')->workListData($data);
            $list = $listRes['data'];

            $export = [];
            foreach($list as $key => $val){
                $export[$key]['work_number'] = $val['work_number'];
                $export[$key]['order_number'] = $val['order_number'];
                $export[$key]['w_name']  = $val['w_name'];
                $export[$key]['w_phone'] = $val['w_phone'];
                $export[$key]['m_name']  = $val['m_name'];
                $export[$key]['m_phone'] = $val['m_phone'];
                $export[$key]['brandclass'] = $val['brandclass'];
                $export[$key]['shop_name'] = $val['shop_name'];
                $export[$key]['duty_staff_name'] = $val['duty_staff_name'];
                $export[$key]['complain_name'] = $val['complain_name'];
                $export[$key]['source_name'] = $val['source_name'];
                $export[$key]['level'] = $val['level'] == 1 ? '一般客诉' : '重大客诉';
                if($val['is_ks'] == 5){
                    $export[$key]['status'] = '相关人员处理中';
                }else{
                    switch($val['is_status']){
                        case 1: $export[$key]['status'] = '未领取';
                            break;
                        case 2: $export[$key]['status'] = '已领取';
                            break;
                        case 3: $export[$key]['status'] = '处理中';
                            break;
                        case 4: $export[$key]['status'] = '已解决';
                            break;
                        case 5: $export[$key]['status'] = '不满意';
                            break;
                    }

                }

                $export[$key]['create_time'] = $val['create_time'];
                $export[$key]['manage_staff_name'] = $val['manage_staff_name'];//处理人
                $export[$key]['second_visit_staff_name'] = $val['second_visit_staff_name'];//二次满意度
            }
            $files = 'ks.xlsx';
            $title = ['客诉编号','订单编号','女士姓名','女士手机号','男士姓名','男士手机号','事业部','店面','责任人','投诉类型','投诉来源','客诉等级','状态','创建时间','处理人','二次满意度调查人'];

        }

        controller('Statistics','lib')->export($title,$export,$files);

    }


    /*
     * 客诉列表
     */
    public function workList(){
        $data = input();
        $detail = controller('Visit','lib')->workListData($data);
        echo json_encode($detail);
    }

    /*
     * 审核客诉页面
     */
    public function check(){

        $work_number = input('get.work_number');
        $workInfo=db('k_work_order')->where('work_number',$work_number)->find();
        $complain_select=explode(',',$workInfo['complain_id']);
        $source=db('s_source')->select();
        $complain=db('s_complain_type')->select();

        $this->assign(['source'=>$source,'complain'=>$complain,'complain_select'=>$complain_select,'workInfo'=>$workInfo]);
        return view('check');
    }

    /*
     * 审核客诉
     */
    public function checkKs(){
        $data = input();
        $res = controller('Workorder','lib')->checkKs($data);
        return $res;

    }

    /*
     * 客诉列表页每个标签数量
     */
    public function orderNum(){
        $num = controller('Visit','lib')->orderNum(input());
        if($num){
            return array('code'=>1,'data'=>$num);
        }
    }

    /*
     * 获取某事业部下店面
     */
    public function get_shop(){
        $brand_id = input('post.brand_id');
        $type = input('type') ? input('type') : 1;

        $shop = controller('Visit','lib')->get_shop(array('brandclass_id'=>$brand_id));

        if($type == 1){
            //(同一个事业部的人)
            $staffList = controller('Setting','lib')->get_staff(['brandclass_id'=>$brand_id]);
        }

        return array('code'=>1,'data'=>['shop'=>$shop?$shop:[],'staff'=>$staffList?$staffList:[]]);

    }


    /*
     * 电访
     */
    public function dianfang(){
        //搜索条件
        $orderid = input('param.orderid');
        $id=input('param.id');//erp订单表id
        $order_link=input('param.order_link');
        $tab=input('param.tab');
        $shop_code=input('param.shop_code');

        if($tab&&$tab!='new_order'){
            //更新当前选中订单各值
            $orderInfo=db('k_order')->where('id',$id)->find();
            $order_link=$orderInfo['order_link'];
            $id=$orderInfo['this_id'];//erp订单表id
            $shop_code=$orderInfo['shop_code'];
            $brand_id = $orderInfo['brand_id'];
            $brandclass = $orderInfo['brandclass'];
            $visitID  = input('param.id');

            //$this->assign('table_order_id',$id);
        }
        //else{
            $erp = config('ext.app_config');  //读取erp配置文件
            $addr = $erp['sx_erp']['addr'];  //调用url
            if($order_link&&$order_link=='order'){
                $dataUrl=$addr.'/SX_CustomerService/SX_InquireCustomerInfoKF?Token=^******^&StartDate=&EndDate=&orderid='.$orderid.'&pageIndex=0&pageSize=0&Code='.$shop_code.'&cxtype=0&brandid=';
            }else if($order_link&&$order_link=='photo'){
                $dataUrl=$addr.'/SX_CustomerService/SX_CustomerPhotoInfoKF?Token=^******^&StartDate=&EndDate=&orderid='.$orderid.'&pageIndex=0&pageSize=0&Code='.$shop_code.'&PZID='.$id.'&State=&brandid=';
            }else if($order_link&&$order_link=='sp'){
                $dataUrl=$addr.'/SX_CustomerService/SX_CustomerXuanPianKF?Token=^******^&StartDate=&EndDate=&orderid='.$orderid.'&pageIndex=0&pageSize=0&Code='.$shop_code.'&XPID='.$id.'&State=&brandid=';
            }else if($order_link&&$order_link=='jg'){
                $dataUrl=$addr.'/SX_CustomerService/SX_CustomerKanBanKF?Token=^******^&StartDate=&EndDate=&orderid='.$orderid.'&pageIndex=0&pageSize=0&Code='.$shop_code.'&XPID='.$id.'&State=&brandid=';
            }else if($order_link&&$order_link=='qj'){
                $dataUrl=$addr.'/SX_CustomerService/SX_InquireCustomerInfoKF?Token=^******^&StartDate=&EndDate=&orderid='.$orderid.'&pageIndex=0&pageSize=0&Code='.$shop_code.'&cxtype=1&brandid=';
            }

            $response = requestERP($dataUrl, json_encode(['sqlwhere'=>'']));  //调用erp接口

            if ($response['Code'] == 200) {

                foreach($response['Data'] as $key => $val){
                    if($val['orderId'] == $orderid){
                        $orderInfo = $response['Data'][$key];
                    }
                }

                $Insert=$this->addOrder($orderInfo,$order_link);

                $brand_id = $Insert['brand_id'];
                $brandclass = $Insert['brandclass'];
                $visitID  = $Insert['visitID'];
            }
        //}

        //评分
        $scoreData=db('k_score_list')->where(array('orderId'=>$orderid,'this_id'=>$id,'order_link'=>$order_link))->select();
        //print_r($scoreData);die;
        $scoreInfo=[];
        foreach($scoreData as $k => $v){
            //$scoreInfo['visit_object']=$v['visit_object'];
            $scoreInfo[$v['visit_object'].'-service']=$v['service_score'];
            $scoreInfo[$v['visit_object'].'-professional']=$v['professional_score'];
            $scoreInfo[$v['visit_object'].'_name']=$v['staff_name'];
            $scoreInfo[$v['visit_object']]=$v['staff_name'];
            $scoreInfo[$v['visit_object'].'-service_bm_id'] = $v['service_bm_id'];
            $scoreInfo[$v['visit_object'].'-professional_bm_id'] = $v['professional_bm_id'];
        }

        //回访项
        $options = db('k_visit_link_object')
            ->where('a.link',$order_link)
            ->alias('a')
            ->join('k_visit_option b','a.option_id = b.id','left')
            ->join('k_visit_object c','b.object_id = c.id','left')
            ->field('a.*,b.option_name,c.new_name,c.code,c.content')
            ->select();

        //回访项对应不满意原因id
        foreach($options as $ok => $ov){

            $option_code = $ov['option_code'];   //回访服务人员code-回访类型，服务、专业
            foreach($scoreInfo as $sk => $sv){

                $visit_code = explode('_',$sk)[0];
                if($visit_code == $option_code){

                    $options[$ok]['bm_id'] = $scoreInfo[$visit_code.'_bm_id'];
                }
            }
        }

        $all_option = array_column($options,'code');

        //摄影师 摄影助理 化妆师 化妆助理 礼服秘书 着装师
        if($order_link <> 'photo'&&(in_array('cameraman',$all_option)||in_array('photoassistant',$all_option)||in_array('dresser',$all_option)||in_array('huazhuangzhuli',$all_option)||in_array('secretaireman',$all_option)||in_array('zhuozhuangshi',$all_option))){
            $pzUrl=$addr.'/SX_CustomerService/SX_CustomerPhotoInfoKF?Token=^******^&StartDate=&EndDate=&orderid='.$orderid.'&pageIndex=0&pageSize=0&Code='.$shop_code.'&PZID=&State=&brandid=';
            $pzResponse = requestERP($pzUrl, '');  //调用erp接口

            if ($pzResponse['Code'] == 200) {
                $cameraman = $this->array_unset_unique($pzResponse['Data'],'cameraman');//摄影师
                $photoassistant = $this->array_unset_unique($pzResponse['Data'],'photoassistant');//摄影助理
                $dresser = $this->array_unset_unique($pzResponse['Data'],'dresser');//化妆师
                $huazhuangzhuli = $this->array_unset_unique($pzResponse['Data'],'huazhuangzhuli');//化妆助理
                $secretaireman = $this->array_unset_unique($pzResponse['Data'],'secretaireman');//礼服秘书
                $zhuozhuangshi = $this->array_unset_unique($pzResponse['Data'],'zhuozhuangshi');//着装师

            }
            $this->assign(['cameraman'=>$cameraman,'photoassistant'=>$photoassistant,'dresser'=>$dresser,'huazhuangzhuli'=>$huazhuangzhuli,'secretaireman'=>$secretaireman,'zhuozhuangshi'=>$zhuozhuangshi]);
        }

        //样前美修-修片师
        if(in_array('xpstaff',$all_option)){
            $xpUrl = $addr.'/SX_CustomerService/SX_CustomerYQMXKF?Token=^******^&StartDate=&EndDate=&orderid='.$orderid.'&pageIndex=0&pageSize=0&Code='.$shop_code.'&YQMXID=&brandid=';
            $xpResponse = requestERP($xpUrl, '');  //调用erp接口
            //print_r($xpResponse);die;
            if ($xpResponse['Code'] == 200) {
                $xpstaff = $this->array_unset_unique($xpResponse['Data'],'xpstaff');
                //print_r($xpstaff);die;
            }
            $this->assign(['xpstaff'=>$xpstaff]);
        }

        //样前转档 获取调色师
        if(in_array('tiaosestaff',$all_option)){
            $yqzdUrl = $addr.'/SX_CustomerService/SX_CustomerYQZDKF?Token=^******^&StartDate=&EndDate=&orderid='.$orderid.'&pageIndex=0&pageSize=0&Code='.$shop_code.'&YQZDID=&brandid=';
            $yqzdResponse = requestERP($yqzdUrl, '');
            if ($yqzdResponse['Code'] == 200) {
                $tiaose = $this->array_unset_unique($yqzdResponse['Data'],'tiaosestaff');
            }
            $this->assign(['tiaosestaff'=>$tiaose]);
        }

        //样后精修 精修人员
        if(in_array('jxstaff',$all_option)){
            $yhjxUrl = $addr.'/SX_CustomerService/SX_CustomerYHJXKF?Token=^******^&StartDate=&EndDate=&orderid='.$orderid.'&pageIndex=0&pageSize=0&Code='.$shop_code.'&YHJXID=&brandid=';
            $yhjxResponse = requestERP($yhjxUrl,'');
            if($yhjxResponse['Code'] == 200) {
                $jxstaff = $this->array_unset_unique($yhjxResponse['Data'],'jxstaff');
            }
            $this->assign(['jxstaff'=>$jxstaff]);
        }

        //排版
        if(in_array('pbstaff',$all_option)){
            $pbUrl = $addr.'/SX_CustomerService/SX_CustomerXCPBKF?Token=^******^&StartDate=&EndDate=&orderid='.$orderid.'&pageIndex=0&pageSize=0&Code='.$shop_code.'&XCPBID=&brandid=';
            $pbResponse = requestERP($pbUrl,'');
            if($pbResponse['Code'] == 200) {
                $pbstaff = $this->array_unset_unique($pbResponse['Data'],'pbstaff');
            }
            $this->assign(['pbstaff'=>$pbstaff]);
        }

        /*  2018/10/13 改为可配置后弃用
        if($order_link=='sp'){
            $pzUrl=$addr.'/SX_CustomerService/SX_CustomerPhotoInfoKF?Token=^******^&StartDate=&EndDate=&orderid='.$orderid.'&pageIndex=0&pageSize=0&Code='.$shop_code.'&PZID=&State=';
            $pzResponse = requestERP($pzUrl, '');  //调用erp接口

            if ($pzResponse['Code'] == 200) {
                $cameraman = $this->array_unset_unique($pzResponse['Data'],'cameraman');//摄影师
                $photoassistant = $this->array_unset_unique($pzResponse['Data'],'photoassistant');//摄影助理
                $dresser = $this->array_unset_unique($pzResponse['Data'],'dresser');//化妆师
                $huazhuangzhuli = $this->array_unset_unique($pzResponse['Data'],'huazhuangzhuli');//化妆助理
            }

//            $cameraman=db('k_score_list')->where('orderId',$orderid)->where('visit_object','cameraman')->select();//摄影师
//            $photoassistant=db('k_score_list')->where('orderId',$orderid)->where('visit_object','photoassistant')->select();//摄影助理
//            $dresser=db('k_score_list')->where('orderId',$orderid)->where('visit_object','dresser')->select();//化妆师
//            $huazhuangzhuli=db('k_score_list')->where('orderId',$orderid)->where('visit_object','huazhuangzhuli')->select();//化妆助理

            //样前美修-修片师
            $xpUrl = $addr.'/SX_CustomerService/SX_CustomerYQMXKF?Token=^******^&StartDate=&EndDate=&orderid=SY18022300025&pageIndex=0&pageSize=0&Code='.$shop_code.'&YQMXID=';
            $xpResponse = requestERP($xpUrl, '');  //调用erp接口
            if ($xpResponse['Code'] == 200) {
                $xpstaff = $this->array_unset_unique($xpResponse['Data'],'xpstaff');
            }
            $this->assign(['cameraman'=>$cameraman,'photoassistant'=>$photoassistant,'dresser'=>$dresser,'huazhuangzhuli'=>$huazhuangzhuli,'xpstaff'=>$xpstaff]);
        }
        if($order_link=='qj'){
            //样前转档 获取调色师
            $yqzdUrl = $addr.'/SX_CustomerService/SX_CustomerYQZDKF?Token=^******^&StartDate=&EndDate=&orderid=SY18012000008&pageIndex=0&pageSize=0&Code='.$shop_code.'&YQZDID=';
            $yqzdResponse = requestERP($yqzdUrl, '');
            if ($yqzdResponse['Code'] == 200) {
                $tiaose = $this->array_unset_unique($yqzdResponse['Data'],'tiaosestaff');
            }
            //样后精修 精修人员
            $yhjxUrl = $addr.'/SX_CustomerService/SX_CustomerYHJXKF?Token=^******^&StartDate=&EndDate=&orderid=SY18022300026&pageIndex=0&pageSize=0&Code='.$shop_code.'&YHJXID=';
            $yhjxResponse = requestERP($yhjxUrl,'');
            if($yhjxResponse['Code'] == 200) {
                $jxstaff = $this->array_unset_unique($yhjxResponse['Data'],'jxstaff');
            }
            //排版
            $pbUrl = $addr.'/SX_CustomerService/SX_CustomerXCPBKF?Token=^******^&StartDate=&EndDate=&orderid=SY18022400026&pageIndex=0&pageSize=0&Code='.$shop_code.'&XCPBID=';
            $pbResponse = requestERP($pbUrl,'');
            if($pbResponse['Code'] == 200) {
                $pbstaff = $this->array_unset_unique($pbResponse['Data'],'pbstaff');
            }

            //校稿看版
            //2018.10.09 校稿人员在已校稿环节回访，取校稿单中的kanbanshi
//            $kanbanUrl = $addr.'/SX_CustomerService/SX_CustomerXGKBKF?Token=^******^&StartDate=&EndDate=&orderid='.$orderid.'&pageIndex=0&pageSize=0&Code='.$shop_code.'&XGKBID=';
//            $kanbanResponse = requestERP($kanbanUrl,'');
//            if($kanbanResponse['Code'] == 200) {
//                $kanban =$this->array_unset_unique($kanbanResponse['Data'],'kanbanstaff');
//            }

            $this->assign(['tiaose'=>$tiaose,'jxstaff'=>$jxstaff,'pbstaff'=>$pbstaff,'kanban'=>$kanban]);

        }
*/

        //男士电话和女士电话
        $phoneList = [];
        if($orderInfo['mphone'])  $phoneList[] = '男士电话'.$orderInfo['mphone'];
        if($orderInfo['wphone'])  $phoneList[] = '女士电话'.$orderInfo['wphone'];

        //无效原因
        $invalid = db('s_invalid_reason')->select();

        //回访不满意原因
        $discontent = db('s_discontent')->select();

        //已回答调研问题
        $answerData = db('k_visit_question_answer')->where('order_id',$visitID)->where('delete_time is null')->select();
        $answer = [];
        foreach($answerData as $k => $v){
            $answer[$v['q_id']] = $v['answer_text'];
        }

        //此环节设置调研问题 结合已回答的答案
        $research = db('k_visit_question')->where("FIND_IN_SET('".$order_link."',link)")->select();
        foreach($research as $k => $v){
            $research[$k]['options'] = json_decode($v['options'],true);
            $research[$k]['answer_text']  = $answer[$v['id']];
        }

        //回访完成后可修改权限
        if(check_right('menu1526030326')){
            $auth=1;
        }

        //系统配置评分制
        $configData = db('s_sysconfig')->where('skey','kf')->find();
        $config = json_decode($configData['svalue'],true);
        $score_type = $config['visit_score'];

        $this->assign([
            'orderInfo' => $orderInfo,
            'order_link'=> $order_link,
            'this_id'   => $id,
            'scoreInfo' => $scoreInfo,
            'visitID'   => $visitID,
            'brand_id'  => $brand_id,
            'brandclass'=> $brandclass,
            'auth'      => $auth, //回访完成后可修改权限
            'options'   => $options,   //回访项
            'score_type'=> $score_type,//评分的分制 3分制，5分制，10分制
            'invalid'   => $invalid,   //无效原因
            'discontent'=> $discontent,//回访不满意原因
            'research'  => $research,  //调研问题
            'phoneList' => $phoneList, //电话
        ]);

        return $this->fetch();
    }

    /*
     * 二维数组去重
     *  $arr  数组
     *  $key  判断重复的key
     */
    public function array_unset_unique($arr,$key){

        $res = array();
        foreach ($arr as $value) {
            if(isset($res[$value[$key]])){
                unset($value[$key]);
            }
            else{
                $res[$value[$key]] = $value;
            }
        }

        return $res;
    }

    /**
     * 编辑回访记录
     */
    public function addVisit(){
        $data = input('post.');

        return controller('Visit','lib')->addVisit(input('post.'));
    }


    /*
     * 添加订单信息
     */
    public function addOrder($orderInfo,$order_link){
        if($order_link=='order'&&!empty($orderInfo['targetdate'])){
            $orderData['order_time'] = date('Y-m-d H:i:s',strtotime($orderInfo['targetdate']));
        }elseif($order_link=='photo'&&!empty($orderInfo['photodate'])){
            $orderData['order_time'] = date('Y-m-d H:i:s',strtotime($orderInfo['photodate']));
            $orderData['phototype']  = $orderInfo['phototype'];//拍照类型
        }elseif($order_link=='sp'&&!empty($orderInfo['selectday'])){
            $orderData['order_time'] = date('Y-m-d H:i:s',strtotime($orderInfo['selectday']));
        }elseif($order_link=='jg'&&!empty($orderInfo['kanbanendday'])){
            $orderData['order_time'] = date('Y-m-d H:i:s',strtotime($orderInfo['kanbanendday']));
        }elseif($order_link=='qj'&&!empty($orderInfo['qj_psjdate'])){
            $orderData['order_time'] = date('Y-m-d H:i:s',strtotime($orderInfo['qj_psjdate']));
        }

        $orderData['orderId']    = $orderInfo['orderId'];
        $orderData['this_id']    = $orderInfo['id'];
        $orderData['customerid'] = $orderInfo['customerid'];
        $orderData['order_link'] = $order_link;
        $orderData['wname']       = $orderInfo['wname'];
        $orderData['mname']       = $orderInfo['mname'];
        $orderData['wphone']      = $orderInfo['wphone'];
        $orderData['mphone']      = $orderInfo['mphone'];
        $orderData['package_name'] = $orderInfo['package_name'];
        $orderData['total_money']  = $orderInfo['total_money'];
        $orderData['bargain_money']  = $orderInfo['bargain_money'];//一销金额
        $orderData['supplementary_money']  = $orderInfo['supplementary_money'];//二销金额
        $orderData['consumption_type']  = $orderInfo['consumption_type'];
        $orderData['visit_staff_id']   = session('staff_id');
        $orderData['visit_staff_name'] = session('staff_name');
        $orderData['visit_staff_number'] = session('staff_number');
        $orderData['visit_time']  = date('Y-m-d H:i:s', time());
        $orderData['shop_code']   = $orderInfo['shop_code'];
        $orderData['shop_name']   = $orderInfo['shop_name'];
        $orderData['is_valid']    = 2;

        //服务人员
        $orderData['storeconsuitant1']  = $orderInfo['storeconsuitant1'];//销售门市
        $orderData['storeconsuitant2']  = $orderInfo['storeconsuitant2'];//网销门市
        $orderData['dresser']           = $orderInfo['dresser'];
        $orderData['huazhuangzhuli']    = $orderInfo['huazhuangzhuli'];
        $orderData['cameraman']         = $orderInfo['cameraman'];//摄影师
        $orderData['photoassistant']    = $orderInfo['photoassistant'];//摄影助理
        $orderData['secretaireman']     = $orderInfo['secretaireman'];//礼服秘书
        $orderData['zhuozhuangshi']     = $orderInfo['zhuozhuangshi'];//化妆助理
        $orderData['selectman']         = $orderInfo['selectman'];//选片师
        $orderData['xpstaff']           = $orderInfo['xpstaff'];//样前美修-修片师
        $orderData['jxstaff']           = $orderInfo['jxstaff'];//样后精修
        $orderData['tiaosestaff']       = $orderInfo['tiaosestaff'];//调色师
        $orderData['kanbanshi']         = $orderInfo['kanbanshi'];//看版师
        $orderData['qj_renname']        = $orderInfo['qj_renname'];//取件人
        $orderData['storeconsuitant4']  = $orderInfo['storeconsuitant4'];//服务人员

        $brand=controller('Setting','lib')->get_shop(['shop_code'=>$orderData['shop_code']]);

        $orderData['brand_id']=$brand[0]['brandclass_id'];
        $orderData['brandclass']=$brand[0]['brandclass'];
        $lastVisit=db('k_order')->where(['order_link'=>$orderData['order_link'],'this_id'=>$orderData['this_id'],'orderId'=>$orderData['orderId']])->find();
        //print_r(db()->getLastSql());die;
        if(!$lastVisit){
            $orderData['first_visit_time']=$orderData['visit_time'];
            $visitID=db('k_order')->insertGetId($orderData);
        }else{
            db('k_order')
                ->where(['order_link'=>$orderData['order_link'],'this_id'=>$orderData['this_id'],'orderId'=>$orderData['orderId']])
                ->update($orderData);
            $visitID=$lastVisit['id'];
        }

        return ['visitID'=>$visitID,'brand_id'=>$orderData['brand_id'],'brandclass'=>$orderData['brandclass']];
    }

    /*
     * 检测是否为当前回访人
     */
    public function checkVisit(){
        if(input('post.visit_order_id')){
            $data=db('k_order')->where('id',input('post.visit_order_id'))->find();
        }else{
            $data=db('k_order')->where(array('order_link'=>input('post.order_link'),'this_id'=>input('post.this_id')))->find();
        }
        if($data&&$data['visit_staff_number']!=session('staff_number')){
            return array('code'=>0,'msg'=>'此订单已有人回访');
        }else{
            return array('code'=>1,'msg'=>'可以回访');
        }
    }

    /*
     *  回访记录
     */
    public function visitLog(){
        /*
        $id=input('param.id');
        if($id){
            //k_order表主键
            $visitLog = db('k_visit_list')->where('visit_order_id',$id)->order('visit_time desc')->select();
        }else{
            $visitLog = db('k_visit_list')->where(['order_link'=>input('order_link'),'this_id'=>input('this_id')])->order('visit_time desc')->select();
        }
        */

        $visitLog = db('k_visit_list')->where('orderId',input('orderid'))->order('visit_time desc')->select();

        $this->assign('domain',getDomain());
        $this->assign('visitLog',$visitLog);
        return view('visitlog');
    }


    /*
     * 回访添加客诉
     */
    public function addWorkOrder(){
        $data = input();
        $res = controller('Visit','lib')->addWorkOrder($data);
        if($res===false){
            return array('code'=>0,'msg'=>'添加客诉工单失败');
        }elseif($res===true){
            return array('code'=>1,'msg'=>'添加客诉工单成功');
        }else{
            return $res;
        }

    }

}