<?php
/**
 * KF 客诉中心
 * 默认接口方法，此方法内定议基础框架所需要的方法，用于验证模块合法性，模块版本，对接基础架构中需要的方法
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: wangyining<wangyining@suxuantech.cn> 2018-04-11 $
 */
namespace app\kf\controller;
use app\kf\lib\Target;
use think\Cache;
use app\index\controller\Base;
use think\Exception;
use think\Log;
use think\Request;
use think\Session;
use PHPExcel_IOFactory;
use PHPExcel;
use Excel5;
use think\Controller;
use app\common\lib\redisQueue;
class Workorder extends Base{

    /**工单列表
     * @return \think\response\View
     */
    public function WorkOrderList(){

        if(Request::instance()->isAjax()){
            $data = input();
            $detail=controller("Workorder","lib")->WorkOrderList($data);
            echo  json_encode($detail);
        }else{
            $source=db('s_source')->select();
            $complain=db('s_complain_type')->select();
            //集团的人
            if(session('grade_type') == 1){
                $brand=controller('Setting','lib')->brandclass_list();
                $brand_id = $brand[0]['id'];
            }else{
                $brand=controller('Setting','lib')->brandclass_list(['id'=>session('brandclass_id')]);
                $brand_id = session('brandclass_id');
            }
            $this->assign(['source'=>$source,'complain'=>$complain,'brand'=>$brand,'brand_id'=>$brand_id]);

            return view('workorderlist');
        }

    }

    /*
     * 获取客诉列表每个标签数据量
     */
    public function WorkOrderNum(){
        $data = input();
        $num=controller('Workorder','lib')->WorkOrderNum($data);
        if($num){
            return array('code'=>1,'data'=>$num);
        }
    }

    /*
     * 导出客诉
     */
    public function exportWorkOrder(){
        $data = input();
        $listRes = controller("Workorder","lib")->WorkOrderList($data);
        $list = $listRes['data'];

        $export = [];
        foreach($list as $key => $val){
            $export[$key]['work_number'] = $val['work_number'];
            $export[$key]['order_number'] = $val['order_number'];
            $export[$key]['w_name']  = $val['w_name'];
            $export[$key]['w_phone'] = $val['w_phone'];
            $export[$key]['m_name']  = $val['m_name'];
            $export[$key]['m_phone'] = $val['m_phone'];
            $export[$key]['describe'] = $val['describe'];//客诉描述
            $export[$key]['create_staff_name'] = $val['create_staff_name'];//提报人
            $export[$key]['duty_staff_name'] = $val['duty_staff_name'];
            $export[$key]['complain_name'] = $val['complain_name'];
            $export[$key]['source_name'] = $val['source_name'];
            $export[$key]['level'] = $val['level'] == 1 ? '一般客诉' : '重大客诉';
            if($val['is_ks'] == 5){
                $export[$key]['status'] = '相关人员处理中';
            }else{
                switch($val['is_status']){
                    case 1: $export[$key]['status'] = '未领取';
                        break;
                    case 2: $export[$key]['status'] = '已领取';
                        break;
                    case 3: $export[$key]['status'] = '处理中';
                        break;
                    case 4: $export[$key]['status'] = '已解决';
                        break;
                    case 5: $export[$key]['status'] = '不满意';
                        break;
                }

            }

            $export[$key]['create_time'] = $val['create_time'];
            $export[$key]['manage_staff_name'] = $val['manage_staff_name'];//处理人
            $export[$key]['second_visit_staff_name'] = $val['second_visit_staff_name'];//二次满意度
            $export[$key]['brandclass'] = $val['brandclass'];
            $export[$key]['shop_name'] = $val['shop_name'];
        }

        //print_r($list);

        $title = ['客诉编号','订单编号','女士姓名','女士手机号','男士姓名','男士手机号','客诉描述','提报人','责任人','投诉类型','投诉来源','客诉等级','状态','创建时间','处理人','二次满意度调查人','事业部','店面'];

        controller('Statistics','lib')->export($title,$export,'ks.xlsx');

    }


    /*
     * 领取客诉
     */
    public function workOrderReceive(){
        $work_number = input('post.work_number');
        $workData = db('k_work_order')->where('work_number',$work_number)->find();

        if($workData['is_ks'] == 5){
            return array('code'=>201,'msg'=>'相关人员处理中，去领取其他客诉吧');
        }

        if($workData['receice_staff_number'] == session('staff_number')){
            return array('code'=>202,'msg'=>'您已领取此客诉，快去处理吧');
        }

        if($workData['receice_staff_number'] && $workData['receice_staff_number'] != session('staff_number')){
            return array('code'=>203,'msg'=>'已被他人领取，去领取其他客诉吧');
        }

        $data['is_status']=2;
        $data['receice_staff_id']   = session('staff_id');
        $data['receice_staff_name'] = session('staff_name');
        $data['receice_staff_number'] = session('staff_number');
        $data['receice_time']        = date('Y-m-d H:i:s',time());

        $data['manage_staff_id']  = session('staff_id');
        $data['manage_staff_name']  = session('staff_name');
        $data['manage_staff_number']  = session('staff_number');

        $track=[
            'work_number'=>$work_number,
            'manage_type'=>3,
            'manage_time'=>date('Y-m-d H:i:s',time()),
            'manage_staff_name'=>session('staff_name'),
            'manage_staff_number'=>session('staff_number'),
            'manage_staff_id'=>session('staff_id'),
            'note'=>'领取此客诉',
        ];

        db()->startTrans();
        try{
            db('k_work_order')->where('work_number',$work_number)->update($data);
            db('k_manage_log')->insert($track);
            db()->commit();
            return array('code'=>1,'msg'=>'领取成功');
        }catch (Exception $e){
            db()->rollback();
            return array('code'=>0,'msg'=>'领取失败');
        }

    }

    //确认客诉
    public function isKs(){
        $work_number=input('post.work_number');
        $res=db('k_work_order')->where('work_number',$work_number)->update(['is_ks'=>1]);
        if($res===false){
            return array('code'=>0,'msg'=>'操作失败，请稍后重试');
        }else{
            return array('code'=>1,'msg'=>'确认客诉成功！');
        }
    }

    //转送客诉页面
    public function workOrderTurn(){
        $work_number=input('param.work_number');
//        选择转送人为整个集团的情况下
//        $brand=controller('Setting','lib')->brandclass_list();
//        $position=controller('Setting','lib')->get_position(array('grade_type'=>1));
//        $this->assign(['brand'=>$brand,'position'=>$position,'work_number'=>$work_number]);

        //选择转送人为本部门的情况
        $position=controller('Setting','lib')->get_position(['department_id'=>session('department_id')]);
        $this->assign(['position'=>$position,'work_number'=>$work_number]);
        return view('workorderturn');
    }

    //检验是否可转送、上升集团 等操作
    public function checkTurn(){
        $work_number = input('work_number');

        $workData=db('k_work_order')->where('work_number',$work_number)->where('manage_staff_number',session('staff_number'))->find();
        if(!$workData){
            return array('code'=>0,'msg'=>'不是您可处理的客诉，不可操作');
        }
        if($workData['is_status']==4){
            return array('code'=>0,'msg'=>'此客诉已解决，不可操作');
        }
        return array('code'=>1,'msg'=>'可操作');
    }

    //上升给集团处理
    public function upGroup(){
        $work_number = input('post.work_number');

        $check = $this->checkTurn($work_number);
        if($check['code']!=1){
            return $check;
        }

        $data['is_status']=1;
        $data['receice_staff_id']     = null;
        $data['receice_staff_name']   = null;
        $data['receice_staff_number'] = null;
        $data['receice_time']         = null;
        $data['manage_time']         = null;
        $data['manage_staff_id']      = null;
        $data['manage_staff_name']    = null;
        $data['manage_staff_number']  = null;
        $data['manage_brand_id']   = '0';//0为集团处理
        $data['manage_brandclass'] = '0';

        $track=[
            'work_number'=>$work_number,
            'manage_type'=>3,
            'manage_time'=>date('Y-m-d H:i:s',time()),
            'manage_staff_name'=>session('staff_name'),
            'manage_staff_number'=>session('staff_number'),
            'manage_staff_id'=>session('staff_id'),
            'note'=>'上升集团处理',
        ];
        db()->startTrans();
        try{
            db('k_work_order')->where('work_number',$work_number)->update($data);
            db('k_manage_log')->insert($track);
            db()->commit();
            return array('code'=>1,'msg'=>'升级为集团处理，操作成功！');
        }catch (Exception $e){
            db()->rollback();
            return array('code'=>0,'msg'=>'操作失败，请稍后重试！');
        }



    }

    /*
     * 转送给他人
     */
    public function doTurn(){
        $work_number = input('post.work_number');
        $staff_number=input('post.staff_number');

        $staffData=controller('Setting','lib')->get_staff(['staffnumber'=>$staff_number]);
        $data['is_status']=2;
        $data['receice_staff_id']     = $staffData[0]['id'];
        $data['receice_staff_name']   = $staffData[0]['staffname'];
        $data['receice_staff_number'] = $staffData[0]['staffnumber'];
        $data['receice_time']          = date('Y-m-d H:i:s',time());
        $data['manage_staff_id']       = $staffData[0]['id'];
        $data['manage_staff_name']     = $staffData[0]['staffname'];
        $data['manage_staff_number']   = $staffData[0]['staffnumber'];
        $data['manage_brand_id']   = $staffData[0]['brandclass_id'];
        $data['manage_brandclass']   = $staffData[0]['brandclass'];

        $track=[
            'work_number'=>$work_number,
            'manage_type'=>3,
            'manage_time'=>date('Y-m-d H:i:s',time()),
            'manage_staff_name'=>session('staff_name'),
            'manage_staff_number'=>session('staff_number'),
            'manage_staff_id'=>session('staff_id'),
            'note'=>'转送给'.$staffData[0]['staffname'],
            ];
        db()->startTrans();
        try{
            db('k_work_order')->where('work_number',$work_number)->update($data);
            db('k_manage_log')->insert($track);
            db()->commit();
            return array('code'=>1,'msg'=>'转送给[' .$data['receice_staff_name'].']成功');
        }catch (Exception $e){
            db()->rollback();
            return array('code'=>0,'msg'=>'转送给['. $data['receice_staff_name'].']失败');
        }
//        $res=db('k_work_order')->where('work_number',$work_number)->update($data);
//        if($res===false){
//            return array('code'=>0,'msg'=>'转送给['. $data['receice_staff_name'].']失败');
//        }else{
//            action_log($data,'',$work_number,session(['staff_id']),session(['staff_name']));
//            return array('code'=>1,'msg'=>'转送给[' .$data['receice_staff_name'].']成功');
//        }
    }


    /*
     * 显示新增客诉页面
     */
    public function workOrderAdd(){
        $visitData = input('get.');
        if($visitData['brand_id']){
            $shop = controller('Setting','lib')->get_shop(array('brandclass_id'=>$visitData['brand_id']));
            if($visitData['shop_code']){
                $department = controller('Setting','lib')->department_list(array('grade_type'=>3,'shop_code'=>$visitData['shop_code']));
                $position = controller('Setting','lib')->get_position(array('grade_type'=>3,'shop_code'=>$visitData['shop_code']));
            }else{
                $department = controller('Setting','lib')->department_list(array('grade_type'=>2,'brandclass_id'=>$visitData['brand_id']));
                $position = controller('Setting','lib')->get_position(array('grade_type'=>2,'brandclass_id'=>$visitData['brand_id']));
            }
        }else{
            $department = controller('Setting','lib')->department_list(array('grade_type'=>1));
            $position=controller('Setting','lib')->get_position(array('grade_type'=>1));
        }
        $source = db('s_source')->select();
        $complain = db('s_complain_type')->where('fid',0)->select();
        $brand = controller('Setting','lib')->brandclass_list();

        $this->assign(['source'=>$source,'complain'=>$complain,'brand'=>$brand,'shop'=>$shop,'department'=>$department,'position'=>$position,'visitData'=>$visitData]);

        return $this->fetch();
    }

    /*
     * 获取所选客诉类型的二级类型
     */
    public function selectComplain(){
        $complain_id = input('post.complain_id');
        $complain = db('s_complain_type')->where('fid',$complain_id)->select();
        return array('code'=>1,'data'=>$complain);
    }

    /*
     * 事业部-店 联动
     */
    public function selectBrand(){
        $brand_id=input('post.brand_id');
        $shop=controller('Setting','lib')->get_shop(array('brandclass_id'=>$brand_id));
        $department=controller('Setting','lib')->department_list(array('brandclass_id'=>$brand_id,'grade_type'=>2));
        $position = controller('Setting','lib')->get_position(array('brandclass_id'=>$brand_id,'grade_type'=>2));
        return array('code'=>1,'data'=>$shop,'department'=>$department,'position'=>$position);
    }

    /*
     * 店-部门 联动
     */
    public function selectShop(){
        $shop_code=input('post.shop_code');
        $department=controller('Setting','lib')->department_list(array('shop_code'=>$shop_code));
        $position = controller('Setting','lib')->get_position(array('shop_code'=>$shop_code,'grade_type'=>3));
        $staff = controller('Setting','lib')->get_staff(array('shop_code'=>$shop_code));
        return array('code'=>1,'data'=>$department,'position'=>$position,'staff'=>$staff);
    }

    /*
     * 部门-岗位 联动
     */
    public function selectDepartment(){
        $deprtment_id=input('post.department_id');
        $position=controller('Setting','lib')->get_position(array('department_id'=>$deprtment_id));
        if($position){
            return array('code'=>1,'data'=>$position);
        }else{
            return array('code'=>0,'data'=>'');
        }
    }

    /*
     * 岗位-人员  联动
     */
    public function selectPosition(){
        $position_code=input('post.position_code');
        $staff=controller('Setting','lib')->get_staff(array('main_position_code'=>$position_code));
        $data['staff']=$staff;
//        if($staff){
//            $data['staff']=$staff;
//            $data['position_name']=$staff[0]['main_position_name'];
//        }else{
            $position=controller('Setting','lib')->get_position(array('position_code'=>$position_code));
            $data['position_name']=$position[0]['position_name'];
//        }
        return array('code'=>1,'data'=>$data);

    }

    /*
     * 根据手机号获取订单号
     */
    public function getOrderNumber(){
        $phone = input('post.phone');
        $orderid = input('post.orderid');

        $erp = config('ext.app_config')['sx_erp']['addr'];
        //$phone='13156987456';
        $url=$erp.'/SX_CustomerService/SX_InquireCustomerInfoKF?Token=^******^&StartDate=&EndDate=&orderid='.$orderid.'&pageIndex=0&pageSize=0&Code=&cxtype=0&brandid=';

        //$url = $erp.'/SX_VipApi/Vip_SelOrderInfo?Token=^******^&tel='.$phone.'&orderid='.$orderid; //定义拼接url
        $response = requestERP($url,'');  //调用erp接口

        if ($response['Code'] == 200) {
            return array('code'=>1,'data'=>$response['Data']);
        }else{
            return array('code'=>0,'msg'=>'没有获取到订单信息');
        }

    }


    /*
     * 新增客诉
     */
    public function addWorkOrder(){

        $data = input('post.');
        $res=controller('Workorder','lib')->addWorkOrder($data);
        if($res===false){
            return array('code'=>0,'msg'=>'添加客诉工单失败');
        }elseif($res===true){
            return array('code'=>1,'msg'=>'添加客诉工单成功');
        }else{
            return $res;
        }

    }

    /*
     * 客诉图片
     */
    public function upload_img(){
        //$content = input('content');
        $file = Request::instance()->file('file');
        if(empty($file)){
            $result["code"] = "1";
            $result["msg"] = "请选择图片";
            $result['data']["src"] = '';
        }else{
            // 移动到 目录下
            $info = $file->move(ROOT_PATH . 'public' . DS . 'upload/img' );
            if($info){
                $name_path =str_replace('\\',"/",$info->getSaveName());
                //成功上传后 获取上传信息
                $result["code"] = '0';
                $result["msg"] = "上传成功";
                $result['data']["src"] = "/upload/img/".$name_path;
            }else{
                // 上传失败获取错误信息
                $result["code"] = "2";
                $result["msg"] = "上传出错";
                $result['data']["src"] ='';
            }
        }

        return json_encode($result);
    }

    /*
     * 客诉录音
     */
    public function upload_record(){
        //$content = input('content');
        $file = Request::instance()->file('file');
        $name = $_FILES['file']['name'];

        if(empty($file)){
            $result["code"] = "201";
            $result["msg"] = "请选择文件";
            $result['data']["src"] = '';
        }else{
            // 移动到 目录下

            $dir = ROOT_PATH . 'public' . DS . 'upload' . DS . 'record';
            if(!is_dir($dir))   mkdir($dir,0777,true);
            $info = $file->move($dir);
            if($info){
                $name_path =str_replace('\\',"/",$info->getSaveName());
                //成功上传后 获取上传信息
                $result["code"] = '200';
                $result["msg"] = "上传成功";
                $result['data']["src"] = "/upload/record/".$name_path;
                //$result['data']['src'] = ROOT_PATH . 'public' . DS . 'upload' . DS . 'record' . DS . $name_path;
                $result['data']['name'] = $name;
            }else{
                // 上传失败获取错误信息
                $result["code"] = "202";
                $result["msg"] = "上传出错";
                $result['data']["src"] ='';
            }
        }

        return json_encode($result);
    }

    /*
     * 文件下载
     */
    public function down_file(){
        $id = input('id');
        $type = input('type');
        if($type == 'visit'){
            //回访记录表
            $path = db('k_visit_list')->where('id',$id)->value('tel_recording');
        }else{
            //客诉表
            $path = db('k_work_order')->where('id',$id)->value('tel_recording');
        }
        $path = ROOT_PATH.'public'.$path;

        controller('Customer','lib')->down_file($path);
    }

    /*
     * 验证客诉是否已确认
     */
//    public function checkKs(){
//        $work_number=input('post.work_number');
//        $workInfo=db('k_work_order')->where('work_number',$work_number)->find();
//        if($workInfo['is_ks']==1){
//            return array('code'=>1,'msg'=>'可处理');
//        }else{
//            return array('code'=>0,'msg'=>'请先确认客诉，再进行处理');
//        }
//    }

    /*
     * 驳回客诉
     */
    public function refute(){
        $work_number=input('post.work_number');
        $record['work_number'] = $work_number;
        $record['manage_type'] = 4;
        $record['note']         = '被驳回,驳回原因：'.input('post.refute_reason');
        $record['manage_staff_id'] = session('staff_id');
        $record['manage_staff_name'] = session('staff_name');
        $record['manage_staff_number'] = session('staff_number');
        db()->startTrans();
        try{
            db('k_work_order')->where('work_number',$work_number)->update(['is_refute'=>1,'refute_reason'=>input('post.refute_reason')]);
            db('k_manage_log')->insert($record);
            db()->commit();
            return array('code'=>1,'msg'=>'驳回成功');
        }catch(Exception $e){
            db()->rollback();
            return array('code'=>0,'msg'=>'驳回操作失败');
        }
    }

    /*
     * 客诉处理页面
     */
    public function manage(){


        $work_number = input('param.work_number');
        $workInfo=db('k_work_order')->where('work_number',$work_number)->find();
        $brand=controller('Setting','lib')->brandclass_list();
        $department = controller('Setting','lib')->department_list(array('grade_type'=>1));
        $position=controller('Setting','lib')->get_position(array('grade_type'=>1));

        //解决人选择范围
        if($workInfo['settle_staff_id']){
            $settle_staff_info = controller('Setting','lib')->get_staff(array('id'=>$workInfo['settle_staff_id']))[0];
            $settle_shop  = controller('kf/Customer','lib')->get_shop(array('brandclass'=>$settle_staff_info['brandclass']));

            //解决人的部门范围
            if($settle_staff_info['shop_code']){
                $d_param = ['shop_code'=>$settle_staff_info['shop_code']];
            }elseif($settle_staff_info['brandclass_id']){
                $d_param = ['brandclass_id'=>$settle_staff_info['brandclass_id']];
            }
            $settle_department = controller('Setting','lib')->department_list($d_param);

            //解决人的岗位范围
            if($settle_staff_info['department_id']){
                $p_param = ['department_id'=>$settle_staff_info['department_id'],'grade_type'=>4];
            }elseif($settle_staff_info['shop_code']){
                $p_param = ['shop_code'=>$settle_staff_info['shop_code'],'grade_type'=>3];
            }elseif($settle_staff_info['brandclass_id']){
                $p_param = ['brandclass_id'=>$settle_staff_info['brandclass_id'],'grade_type'=>2];
            }else{
                $p_param = ['grade_type'=>1];
            }

            $settle_position = controller('Setting','lib')->get_position($p_param);
            $settle_staff = controller('Setting','lib')->get_staff(array('main_position_code'=>$settle_staff_info['main_position_code']));
        }else{
            $settle_shop = [];
            $settle_department = $department;
            $settle_position = $position;

        }

        //解决方案
        $solution = db('s_solution')->select();

        //跟进记录
        $manageLog=db('k_manage_log')->where('work_number',$work_number)->order('id desc')->select();
        $this->assign('manageLog',$manageLog);

        //暂时保存的跟进备注
        $last_record = db('k_manage_log')->where(['work_number'=>$work_number,'manage_type'=>0])->order('manage_time desc')->find();

        switch($workInfo['ks_phase']){
            case 1: $workInfo['ks_phase'] = '订单';break;
            case 2: $workInfo['ks_phase'] = '试衣';break;
            case 3: $workInfo['ks_phase'] = '拍摄';break;
            case 4: $workInfo['ks_phase'] = '选片';break;
            case 5: $workInfo['ks_phase'] = '修图';break;
            case 6: $workInfo['ks_phase'] = '取件';break;
            case 7: $workInfo['ks_phase'] = '其他';break;
        }

        $this->assign([
            'workInfo'   => $workInfo,
            'brand'      => $brand,
            'department' => $department,
            'position'   => $position,
            'last_record'=> $last_record,
            'settle_staff_info'=> $settle_staff_info,
            'settle_shop' => $settle_shop,
            'settle_department' => $settle_department,
            'settle_position'   => $settle_position,
            'settle_staff'      => $settle_staff,
            'solution'          => $solution,
        ]);
        return $this->fetch();
    }



    /**
     * 处理客诉
     */
    public function doManage(){

        $res = controller('Workorder','lib')->doManage(input('post.'));
        return $res;
//        if($res===false){
//            return array('code'=>0,'msg'=>'处理结果提交失败，请稍后重试');
//        }else if($res===true){
//            return array('code'=>1,'msg'=>'处理结果提交成功');
//        }else{
//            return $res;
//        }
    }

    //测试签字
    public function getSignatrue(){
        $res=controller('Workorder','lib')->getSignature('65215589156329');
        print_r($res);die;
    }

    /*
     * 客诉详情
     */
    public function workOrderInfo(){
        $work_number=input('param.work_number');
        $workInfo=db('k_work_order')->where('work_number',$work_number)->find();
        $complain_select=explode(',',$workInfo['complain_id']);
        $source=db('s_source')->select();
        $complain=db('s_complain_type')->where('fid','0')->select();
        $brand=controller('Setting','lib')->brandclass_list();
        $position=controller('Setting','lib')->get_position(array('grade_type'=>1));

        if($workInfo['manage_staff_number']!=session('staff_number')||$workInfo['is_status']==4){
            $is_auth='no';
        }

        if($workInfo['tel_recording']){
            $workInfo['listen_recording'] = getDomain().$workInfo['tel_recording'];
        }

        $staff = controller('Setting','lib')->get_staff(array('id'=>$workInfo['duty_staff_id']));

        $this->assign([
            'source'   => $source,
            'complain' => $complain,
            'complain_select' => $complain_select,
            'brand' => $brand,
            'position' => $position,
            'workInfo' => $workInfo,
            'staff' => $staff[0],
            'is_auth'  => $is_auth
        ]);
        return view('workorderinfo');
    }

    /*
     * 修改客诉详情
     */
    public function editInfo(){

        $data = input('post.');
        $thisData=db('k_work_order')->where('work_number',$data['work_number'])->find();

        if($thisData['manage_staff_name']!=session('staff_name')){
            return array('code'=>0,'msg'=>'您不是此客诉的处理人，不可操作');
        }

        if($thisData['is_status']==4){
            return array('code'=>0,'msg'=>'已解决客诉信息不可修改');
        }
        //print_r($data);die;
        $insertData['w_name']    = trim($data['w_name']);
        $insertData['w_phone']   = trim($data['w_phone']);
        $insertData['m_name']    = trim($data['m_name']);
        $insertData['m_phone']   = trim($data['m_phone']);
        $insertData['customer_number'] = trim($data['customer_number']);
        $insertData['order_number']    = trim($data['order_number']);
        $insertData['source_id']       = trim($data['source_id']);
        $insertData['source_name']     = trim($data['source_name']);
        $insertData['level']            = trim($data['level']);
        $insertData['describe']         = trim($data['describe']);

        if($data['is_edit_com']==1){
            $insertData['complain_id']     = implode(',',$data['complain_id']);//投诉类型
            if(!$insertData['complain_id']||!is_array($data['complain_id'])||count($data['complain_id'])==0){
                return array('code'=>0,'msg'=>'请选择投诉类型');
            }
            $complain=db('s_complain_type')->where('id','in',$insertData['complain_id'])->select();
            $insertData['complain_name'] = implode(',',array_column($complain,'complain_name'));
        }

        if($data['is_edit']==1){
            $insertData['duty_position_code']   = implode(',',$data['position_code']);//负责人岗位
            $insertData['duty_staff_number']    = implode(',',$data['staff_number']);//负责人编号
            $insertData['brand_id']  = trim($data['brand_id']);
            $insertData['brandclass']  = trim($data['brandclass']);
            $insertData['shop_code']  = trim($data['shop_code']);
            $insertData['shop_name']  = trim($data['shop_name']);
            //$insertData['department_id']  = trim($data['department_id']);
            //$insertData['department_name']  = trim($data['department_name']);

            if(!$insertData['duty_position_code']||!is_array($data['position_code'])||count($data['position_code'])==0){
                return array('code'=>0,'msg'=>'请选择投诉责任岗位');
            }
            if(!$insertData['duty_staff_number']||!is_array($data['staff_number'])||count($data['staff_number'])==0){
                return array('code'=>0,'msg'=>'请选择投诉责任人');
            }

            $position=controller('Setting','lib')->get_position(array('position_code'=>$insertData['duty_position_code']));
            $insertData['duty_position_name'] = implode(',',array_column($position,'position_name'));

            $staffData=[];
            foreach($data['staff_number'] as $k => $v){
                $staff=controller('Setting','lib')->get_staff(array('staffnumber'=>$v));
                array_push($staffData,$staff[0]);
                unset($staff);
            }

            $insertData['duty_staff_id'] = implode(',',array_column($staffData,'id'));
            $insertData['duty_staff_name'] = implode(',',array_column($staffData,'staffname'));
            $insertData['department_id'] = implode(',',array_unique(array_column($staffData,'department_id')));
            $insertData['department_name'] = implode(',',array_unique(array_column($staffData,'department_name')));
        }
        $res=db('k_work_order')->where('work_number',$data['work_number'])->update($insertData);
        //print_r(db()->getLastSql());die;
        if($res===false){
            return array('code'=>0,'msg'=>'修改失败');
        }else{
            return array('code'=>1,'msg'=>'修改成功');
        }
    }


    /*
     * 跟进记录
     */
    public function trackLog(){
        $work_number=input('param.work_number');
        $orderId = input('param.orderId');
        $manageLog=db('k_manage_log')->where('work_number',$work_number)->order('id desc')->select();
        $erp = config('ext.app_config');  //读取erp配置文件
        $addr = $erp['sx_erp']['addr'];  //调用url
        $dataUrl=$addr.'/SX_CustomerService/SX_InquireCustomerInfoKF?Token=^******^&StartDate=&EndDate=&orderid='.$orderId.'&pageIndex=0&pageSize=0&Code=&cxtype=0';
        $response = requestERP($dataUrl, '');  //调用erp接口
        if ($response['Code'] == 200) {
            $customer_number = $response['Data'][0]['customerid'];
            $res = sx_call('5b1a1f8ebd740', array('customer_number'=>$customer_number),'sx_crm');
            if ($res['code'] == 200) {
                $customer_log = $res['data'];
                $this->assign('customer_log',$customer_log);
            }
        }

        $this->assign('manageLog',$manageLog);
        return view('tracklog');

    }

    /*
     * 二次满意度调查页
     */
    public function secondManage(){
        $work_number=input('param.work_number');
        $workInfo=db('k_work_order')->where('work_number',$work_number)->find();
        $this->assign('workInfo',$workInfo);

        return $this->fetch();
    }

    /*
     * 二次满意度调查结果
     */
    public function doSecondManage(){
        $data = input('post.');
        $res=controller('Workorder','lib')->doSecondManage($data);
        if($res===false){
            return array('code'=>0,'msg'=>'操作失败，请稍后重试');
        }else{
            return array('code'=>1,'msg'=>'提交成功');
        }
    }


    /*
     * 客诉公示平台
     */
    public function publicity(){
        $data=input('post.');
        $page = input('post.page');
        $pageSize = input('post.pageSize');
        $keyword = input('post.keyword');

        if (isset($page) && null !== $page) {
            $nowPage = $page;
        }else {
            $nowPage = 1;
        }

        $pageSize = $pageSize ? $pageSize : 10;
        $options=[
            'page'=>$nowPage,
            'path'=>url('publicity')
        ];

        if($keyword&&!empty($keyword)){
            $sql = ' m_name like "%'.$keyword.'%" or w_name like "%'.$keyword.'%" or m_phone like "%'.$keyword.'%" or w_phone like "%'.$keyword.'%" or order_number like "%'.$keyword.'%" or work_number like "%'.$keyword.'%" or manage_staff_name like "%'.$keyword.'%" or duty_staff_name like "%'.$keyword.'%" or shop_name like "%'.$keyword.'%" or brandclass like "%'.$keyword.'%" ';
        }
        $count = db('k_work_order')->where('is_ks = 1 or is_ks = 3 or is_ks=7')->where('is_refute',2)->where($sql)->count('id');
        $data  = db('k_work_order')->where('is_ks = 1 or is_ks = 3 or is_ks=7')->where('is_refute',2)->where($sql)->order('level desc')->paginate($pageSize,false,$options);
        $str='';
        foreach($data as $k => $v){
            $remark = preg_replace('/<\s*img\s+[^>]*?src\s*=\s*(\'|\")(.*?)\\1[^>]*?\/?\s*>/i', '', $v['describe']);

            if($v['is_status']==1){
                $v['is_status'] = '待领取';
            }elseif($v['is_status']==2){
                $v['is_status'] = '已领取';
            }elseif($v['is_status']==3){
                $v['is_status'] = '处理中';
            }elseif($v['is_status']==4){
                $v['is_status'] = '已解决';
            }elseif($v['is_status']==5){
                $v['is_status'] = '后续跟进';
            }

            if($v['ks_expend']==1){
                $v['ks_expend'] = '无成本支出';
            }elseif($v['ks_expend']==2){
                $v['ks_expend'] = '异业赠品解决';
            }elseif($v['ks_expend']==3){
                $v['ks_expend'] = '自有产品解决';
            }elseif($v['ks_expend']==0){
                $v['ks_expend'] = '';
            }
            $v['level'] = $v['level'] ==1 ? '一般客诉' : '<font color="red">重大客诉</font>';
            $v['brand_expend']=!empty($v['brand_expend'])?'事业部投诉支出':'';

            $str .='<div class="p-list">
                <div class="table-top gray-bg">
                    <span class="ks-date">客诉日期  '.$v['create_time'].'</span>
                    <span class="ks-order">客诉单号  '.$v['work_number'].'</span>
                </div>
                <ul class="p-table">
                    <li>
                        <div class="list-wrap">
                            <div class="list-row">
                                <span class="list-name">订&nbsp;&nbsp;单&nbsp;&nbsp;号</span>
                                <span class="list-content">'.$v['order_number'].'</span>
                            </div>
                            <div class="list-row Whalf">
                                <span class="list-name">男士姓名</span>
                                <span class="list-content">'.$v['m_name'].'</span>
                            </div>
                            <div class="list-row Whalf">
                                <span class="list-name">男士电话</span>
                                <span class="list-content">'.$v['m_phone'].'</span>
                            </div>
                            <div class="list-row Whalf">
                                <span class="list-name">女士姓名</span>
                                <span class="list-content">'.$v['w_name'].'</span>
                            </div>
                            <div class="list-row Whalf">
                                <span class="list-name">女士电话</span>
                                <span class="list-content">'.$v['w_phone'].'</span>
                            </div>

                        </div>
                    </li>
                    <li>
                        <div class="list-wrap">'.$v['level'].'</div>
                    </li>
                    <li>
                        <div class="list-wrap">
                            <div class="list-row">'.$v['duty_staff_name'].'</div>

                        </div>
                    </li>
                    <li>
                        <div class="list-wrap">'.$v['source_name'].'</div>
                    </li>
                    <li>
                        <div class="list-wrap">
                            <div class="list-row">'.$v['complain_name'].'</div>
                        </div>
                    </li>
                     <li>
                        <div class="list-wrap">'.$remark.'</div>
                    </li>
                    <li>
                        <div class="list-wrap">'.$v['manage_staff_name'].'</div>
                    </li>
                    <li>
                        <div class="list-wrap">
                            <div class="list-row">'.$v['is_status'].'</div>
                            <div class="list-row">'.$v['ks_expend'].'</div>
                            <div class="list-row">'.$v['brand_expend'].'</div>
                        </div>
                    </li>
                </ul>
            </div>';
        }
        if(Request::instance()->isAjax()){
            return array('code'=>1,'data'=>$str,'count'=>$count);
        }
        $this->assign('str',$str);
        $this->assign(['data'=>$data,'count'=>$count]);
        return $this->fetch();
    }



    //签名短信提醒
    public function signatureSms(){
        $rule=db('s_sysconfig')->where('skey','kf')->value('svalue');
        $value=json_decode($rule,true);
        $smsTime=$value['ks_signature'];
        $ruleDate=date("Y-m-d H:i:s",time()-$smsTime*60*60);
        //已解决，流程已完成，未签字
        $workList=db('k_work_order')->where('is_status',4)->where('is_over',1)->where('is_signature',2)->select();
        $signList=db('k_staff_sign')->where('work_number','in',array_column($workList,'work_number'))->select();
        //print_r($signList);die;
        foreach($signList as $k => $v){
            $res=sx_call('5ab9a901ee228',['code'=>$v['code'],'type'=>1]);
            if($res['code']==200||!empty($res['data']['url'])){
                db('k_staff_sign')->where('code',$v['code'])->update(['is_signature'=>1,'signature_time'=>date('Y-m-d H:i:s',time())]);
            }
        }
        foreach($workList as $key => $val){
            $nowData=db('k_staff_sign')->where('work_number',$val['work_number'])->where('is_signature',2)->select();
            if(empty($nowData)||!$nowData){
                db('k_work_order')->where('work_number',$val['work_number'])->update(['is_signature'=>1,'signature_time'=>date('Y-m-d H:i:s',time())]);
            }
        }
        //已解决，流程已完成，未发短信，到达时间，未签字
        $newWorkList=db('k_work_order')->where('is_status',4)->where('is_over',1)->where('is_sms',2)->where('over_time',['<=',$ruleDate])->where('is_signature',2)->select();

        if($newWorkList){
            $numbers=implode(',',array_unique(array_filter(explode(',',implode(',',array_column($newWorkList,'signature_staff_number'))))));
            $this->sendSms(['staff_number'=>$numbers,'content'=>'您好，您有一条未签字工单，详情请查看微信公众号消息提醒','send_config'=>'kf']);
            db('k_work_order')->where('id','in',array_column($newWorkList,'id'))->update(['is_sms'=>1]);
        }

    }


    /*
     * 审核客诉h5
     */
    public function checkKsView(){
        $work_number = input('get.work_number');
        $detail = db('k_work_order')->where('work_number',$work_number)->find();
        if($detail['department_id']&&$detail['department_id']!=0){
            $staff = controller('Setting','lib')->get_staff(['department_id'=>$detail['department_id']]);
        }else{
            if($detail['shop_code']&&$detail['shop_code']!=0){
                $staff = controller('Setting','lib')->get_staff(['shop_code'=>$detail['shop_code']]);
            }else{
                $staff = controller('Setting','lib')->get_staff(['brandclass_id'=>$detail['brand_id']]);
            }
        }
        $this->assign(['detail'=>$detail,'staff'=>$staff]);
        return view('checkks');
    }

    /*
     * 审核结果
     */
    public function checkKs(){
        $data = input();
        $res = controller('Workorder','lib')->checkKs($data);
        return $res;

    }

    /*
     * 相关人员处理客诉
     */
    public function manageKsView(){
        $work_number = input('get.work_number');
        $detail = db('k_work_order')->where('work_number',$work_number)->find();
        $this->assign('detail',$detail);
        return view('manageks');
    }

    /*
     * 处理客诉
     */
    public function manageKs(){
        $data = input();
        $res = controller('Workorder','lib')->manageKs($data);
        return $res;
    }




    //订单查询
    public function searchOrder(){
        if(Request::instance()->isAjax()){
            $data = input();
            $detail=controller("Workorder","lib")->searchOrder($data);
            //$detail=controller("Visit","lib")->orderListData($data);
            echo  json_encode($detail);
        }else{

            return view('searchorder');
        }

    }



    /*
     *  获取订单详细信息
     */
    public function getAllServiceInfo(){
        $orderId = input('get.orderId');

        // 是否安装erp
       // $is_erp = is_install('sx_erp');
        //if ($is_erp) {
            $shop_type = session('shop_type');
            if ($shop_type == 2) {
                $shop_type = 1;
            }else{
                $shop_type = 0;
            }
            $erp = config('ext.app_config')['sx_erp'];
            $addr= $erp['addr'];

            $tel = 1;
            $url = $addr.'SX_CrmApi/All_CustomerOrderInfo?Token=^******^&CustomerType='.$shop_type.'&Tel='.$tel.'&orderId='.$orderId;
            $dataErp = '[]';

            $response = requestERP($url, $dataErp);

            if ($response['Code'] == 200) {
                // 基础信息  订单表
                $baseInfo = $response['Data']['C_order'];
                // var_dump($baseInfo);
                $this->assign('baseInfo', $baseInfo);
                // 产品信息  消费项目
                $cpInfo = $response['Data']['C_page'];
                $this->assign('cpInfo', $cpInfo);
                // 摄影信息
                $syInfo = $response['Data']['C_photo'];
                $this->assign('syInfo', $syInfo);
                // 选片信息
                $xpInfo = $response['Data']['C_sp'];
                $this->assign('xpInfo', $xpInfo);
                // 收款信息
                $skInfo = $response['Data']['C_payment'];
                $this->assign('skInfo', $skInfo);
                // 化妆信息
                $hzInfo = $response['Data']['C_makeup'];
                $this->assign('hzInfo', $hzInfo);
                // 礼服信息
                $lfInfo = $response['Data']['C_dress'];
                $this->assign('lfInfo', $lfInfo);

            }
       // }

        $log = db('k_work_order')->where('o.order_number',$orderId)
            ->alias('o')
            ->join('k_manage_log l','o.work_number=l.work_number','left')
            ->field('l.id,l.work_number,l.order_number,l.manage_type,l.is_manage,l.manage_staff_name,l.manage_time,l.manage_num,l.note')
            ->order('l.id desc')
            ->select();

        $this->assign(['order_sn'=>$orderId,'log'=>$log]);
        return $this->fetch();
    }



}