<?php
/**
 * KF 实现模块
 * KF的基本功能实现，如客资录入，客资查询等。
 * 所有业务的真正实现全在lib目录下建controller并且访问modle等，供controller层调用
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: wangyining<wangyining@suxuantech.cn> 2018-04-11 $
 */
namespace app\kf\lib;
use think\Cache;
use think\Controller;
use PHPExcel_IOFactory;
use Excel5;
use PHPExcel;
use app\common\lib\redisQueue;
use think\Exception;
use think\Db;
class Bottle extends Controller{

    /**
     * 调用erp接口获取订单信息
     */
    public function bottleListData($params){

        $page = $params['page'] ? $params['page'] : 1;
        $limit = $params['limit'] ? $params['limit'] : 10;
        //print_r($params);die;

        $sql=$this->getSql($params['key']);

        switch ($params['key']['tabs']){

            case 'new'://新漂流瓶
                $sql .= " and status = 1 ";
                break;
            case 'today'://当日领取回访单
                $today=date('Y-m-d',time());
                $before_time=date("Y-m-d",strtotime("$today -1 day"));
                $after_time=date("Y-m-d",strtotime("$today +1 day"));
                $sql .= " and receive_staff_number = '".session('staff_number')."' and (receive_time between '".$before_time."'and '".$after_time."') ";
                break;
            case 'my_get'://已领取
                $sql .= " and receive_staff_number = '".session('staff_number')."' and status = 2 ";
                break;
            case 'my_bottle'://已处理
                $sql .= " and receive_staff_number = '".session('staff_number')."' and status = 3 ";
                break;
            default:
                $sql .= " and status = 1 ";

        }

        $res= db('k_drift_bottle')->where($sql)->page($page,$limit)->select();
        $count = db('k_drift_bottle')->where($sql)->count();



        $result['code'] = 0;
        $result['msg'] = '';

        if($res){
            $result['data'] = $res;
            $result['count'] = $count;
        }else{
            $result['data'] = array();
            $result['count'] = 0;
        }

        return $result;
    }

    public function bottleNum($params){
        $sql=$this->getSql($params);

        $today=date('Y-m-d',time());
        $before_time=date("Y-m-d",strtotime("$today -1 day"));
        $after_time=date("Y-m-d",strtotime("$today +1 day"));

        $num['new_num'] = db('k_drift_bottle')->where('status',1)->where($sql)->count();
        $num['today_num'] = db('k_drift_bottle')->where('receive_staff_number',session('staff_number'))->where('receive_time', 'between time', [$before_time, $after_time])->where($sql)->count();
        $num['my_get_num'] = db('k_drift_bottle')->where('status',2)->where('receive_staff_number',session('staff_number'))->where($sql)->count();
        $num['my_bottle_num'] = db('k_drift_bottle')->where('status',3)->where('receive_staff_number',session('staff_number'))->where($sql)->count();
        return $num;
    }

    /*
     * 获取查询条件sql
    */

    public  function getSql($data){

         $sql = " 1=1 ";
         $end_time=$data['end_time'];
         if (!empty($data)) {
              if ($data['keyword'])      $sql .= " and content like '%" . $data['keyword'] . "%' ";
              if($data['brand_id'])     $sql .= " and brand_id = '" . $data['brand_id'] . "' ";
              if($data['shop_code'])     $sql .= " and shop_code = '" . $data['shop_code'] . "' ";
              if($data['time_type']&&!empty($data['time_type'])){
                   if($data['start_time'])      $sql .= " and ".$data['time_type']." >= '".$data['start_time']."' ";
                   if($data['end_time'])        $sql .= " and ".$data['time_type']." < '".date("Y-m-d",strtotime("$end_time +1 day"))."' ";
              }
         }
         return $sql;
    }

    //领取漂流瓶
    public function bottleReceive($id){
        $data['status'] = 2;
        $data['receive_staff_id'] = session('staff_id');
        $data['receive_staff_name'] = session('staff_name');
        $data['receive_staff_number'] = session('staff_number');
        $data['receive_time'] = date('Y-m-d H:i:s',time());
        $res=db('k_drift_bottle')->where('id',$id)->update($data);
        if($res===false){
            return false;
        }else{
            return true;
        }
    }




}