<?php
/**
 * CRM 实现模块
 * CRM的基本功能实现，如客资录入，客资查询等。
 * 所有业务的真正实现全在lib目录下建controller并且访问modle等，供controller层调用
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: songdemei<songdemei@suxuantech.cn> 2017-10-17 $
 */
namespace app\kf\lib;
use think\Cache;
use think\Controller;
use PHPExcel_IOFactory;
use Excel5;
use PHPExcel;
use app\common\lib\redisQueue;
use think\Exception;

class Customer extends Controller{
    protected $errid = 0;
    protected $errmsg = '';
    function login($params){
        if(!empty($params['five'])){
            $params['five'] = input('post.five');
            $time =date('Y-m-d H:i:s',time()+432000);
        }else{
            $time = date('Y-m-d H:i:s',time()+86400);
        }
        $params['app_id'] = config('app_id');

        $url = '59f2e9fb5f863';
        $res = sx_call($url,$params);

        if($res['code'] == 200){
            $loginRes = $this->setLoginEnv($res['data'],'pc','user_name',$params['five']);
            if($loginRes){
                //所有可查看店的岗位
                $info = $this->getPositions();
                if($info){
                    session('positions_'.session('staff_id'),$info);
                }
                $returnUrl = '/';
                if(session('return_url')){
                    $returnUrl = session('return_url');
                    session('return_url',null);
                }
                return ['code'=>200, 'return_url'=>$returnUrl,];
            }else{
                $res = array('code'=>201,'error'=>201,'msg'=>'登录失败，请重试。');
            }
        }elseif($res['code'] == 101){
            //密码复杂度判断
            $res = array('code' => 101, 'error' => 101, 'msg' => $res['msg'],);

        }elseif($res['code'] == 102){
            //密码过期判断
            $res = array('code' => 102, 'error' => 102, 'msg' => $res['msg'],);

        }elseif($res['code'] == 500){

            $res = array('code'=>500,'error'=>101,'msg'=>'此员工已离职');

        }else{
            $res = array('code'=>202,'error'=>202,'msg'=>'用户名或密码错误') ;
        }
        return $res;
    }

    /**
     * 设置登录环境，根据MC返回的登录结果数据
     *
     * @param type $loginRes
     */
    function setLoginEnv($loginRes,$loginType='pc',$loginMethod='user_name',$five = 0){
        if(empty($loginRes['staff_id'])
            || empty($loginRes['staffname'])
            || empty($loginRes['staffnumber'])
            || empty($loginRes['session_id'])
            //|| empty($loginRes['setkey'])
        ){
            return false;
        }
        session('staff_id',$loginRes['staff_id']);
        session('staff_name',$loginRes['staffname']);
        session('staff_number',$loginRes['staffnumber']);
        session('session_id',$loginRes['session_id']);
        session('brandclass_id',$loginRes['brandclass_id']);
        session('brandclass',$loginRes['brandclass']);
        session('shop_name',$loginRes['shop_name']);
        session('shop_code',$loginRes['shop_code']);
        session('belong_shop_name',$loginRes['belong_shop_name']);
        session('belong_shop_code',$loginRes['belong_shop_code']);
        session('is_sk',$loginRes['is_sk']);
        session('shop_type',$loginRes['shop_type']);
        session('setkey',$loginRes['setkey']);
        session('main_work_type',$loginRes['main_work_type']);
        session('work_type',$loginRes['work_type']);
        session('department_name',$loginRes['department_name']);
        session('department_id',$loginRes['department_id']);
        session('position_code',$loginRes['position_code']);
        session('main_position_name',$loginRes['main_position_name']);
        session('main_position_code',$loginRes['main_position_code']);
        session('grade_type',$loginRes['grade_type']);
        session('is_marketing',$loginRes['is_marketing']);//是否是营销店
        session('is_belong',$loginRes['is_belong']);//判断是属于集团，品牌，店面下
        session('open_id', $loginRes['open_id']);
        if($five){
            $loginRes['keep_login'] = 1;
            $info = json_encode($loginRes);
            cookie('session_id',$loginRes['session_id'],432000);
            cookie('staff_id',$loginRes['staff_id'],432000);
            cache('KF_staffInfo_'.$loginRes['staff_id'],$info,432000);
            cookie('status',$loginRes['status'],432000);
        }else{
            $info = json_encode($loginRes);
            cookie('session_id',$loginRes['session_id']);
            cookie('staff_id',$loginRes['staff_id']);
            cache('KF_staffInfo_'.$loginRes['staff_id'],$info);
            cookie('status',$loginRes['status']);
        }
        //操作session表
        $db = db('SSession');
        $staffInfo = $db->where(array('staff_id' => $loginRes['staff_id']))->find();

        $db->startTrans();
        if(!empty($staffInfo['staff_id'])){
            $param['session_id'] = $loginRes['session_id'];
            $param['ip'] = get_client_ip();
            $param['login_type'] = $loginType;
            $param['login_method'] = $loginMethod;
            $param['expiry'] = date('Y-m-d H:i:s',time()+86400);
            $param['status'] = 1;
            $resdb = $db->where(array('staff_id' => $staffInfo['staff_id']))->update($param);
            $param['staff_id'] = $loginRes['staff_id'];
        }else{
            $param['staff_id'] = $loginRes['staff_id'];
            $param['session_id'] = $loginRes['session_id'];
            $param['ip'] = get_client_ip();
            $param['login_type'] = $loginType;
            $param['login_method'] = $loginMethod;
            $param['expiry'] = date('Y-m-d H:i:s',time()+86400);
            $param['status'] = 1;
            $resdb = $db->insert($param);
        }
        if($resdb){
            $db->commit();
            return true;
        }else{
            $db->rollBack();
            return false;
        }
    }

    function update_status($status){
        // 取出员工信息
        $info = cache('KF_staffInfo_'.cookie('staff_id'));
        // 赋值状态
        $info['status'] = $status;
        if($info['keep_login'] == 1){
            cache('KF_staffInfo_'.cookie('staff_id'), json_encode($info),432000);
        }else{
            cache('KF_staffInfo_'.cookie('staff_id'), json_encode($info));
        }
        cookie('status',$status);
        return true;
        // $param['status'] = $status;
        // $db = db('SSession');
        // $db->startTrans();
        // $res = $db->where(array('staff_id' => session('staff_id')))->update($param);
        // if($res){
        //     cookie('status',$status);
        //     $db->commit();
        //     return true;
        // }else{
        //     $db->rollBack();
        //     return false;
        // }
    }
    /*
     * 短消息
     * */
    public function message_list($type){
        $res = db('CMessage')->where('send_type',$type)->where('is_delete',0)->where('receive_id',session('staff_id'))->select();
        return $res;
    }
    /*
     * 通知
     * */
    public function notice_list(){
        return db('CMessage')->where('send_type',2)->where('is_delete',0)->where('receive_id',session('staff_id'))->select();
    }
    /*
     * 查看信息，通知
     */
    function update_message($id){
        $info = db('CMessage')->where('is_delete',0)->where('id',$id)->find();
        if($info && $info['read_status'] == 0){
            //修改状态，更新时间
            $data['read_status'] = 1;
            $data['read_time'] = date('Y-m-d H:i:s',time());
            db()->startTrans();
            $res = db('CMessage')->where('id',$id)->update($data);
            if($res === false){
                db()->rollBack();
                return false;
            }else{
                db()->commit();
                $info['read_status'] == 1;
                $info['read_time'] = $data['read_time'];
                return $info;
            }
        }else{
            return $info;
        }
    }
    function logOut($staffId){
        $staffId = cookie('staff_id');
        cache('KF_staffInfo_'.$staffId,null);
        cookie('session_id',null);
        cookie('auto_session_id',null);
        cookie('auto_staff_id',null);
        cookie('staff_id',null);
        cookie('status',null);
        cookie(null);
        session('openid',null);
        session('staff_id',null);
        session('auto_staff_id',null);
        session('status',null);
        session(null);
        if(is_weixin()){
            $url = '59f424811d52f';
            sx_call($url,array('staff_id'=>$staffId));
            $this->redirect('crm/Index/wxLogin');
        }
    }

    function getStaffinfoByOpenId(){
        $url = '59fe8bd048e1d';
        return sx_call($url,cookie('openId'));
    }
    function getStaffOnlineStatus($staff_id){
        $info = cache('KF_staffInfo_'.$staff_id);
        if( (time() - $info['active'] > 160) || ($info['status'] != 1) ){
            return false;
        }else{
            return true;
        }
    }
    function wx_login($param){
        $url = '5a029ee140dba';
        //$param['open_id'] = cookie('openId');
        $res = sx_call($url,$param);//openid和员工对应，调登录接口
        if($res['code'] == 200){
            //绑定openid成功与否无所谓，大不了再输一次密码
            // sx_call('5a2239cf24883', ['staffname'=>$param['staffname'],'password'=>$param['password'],'open_id'=>$param['open_id']]);
            $this->setLoginEnv($res['data'], 'WX', 'user_name', 0);

            $arr = array(
                'code' => 200,
                'msg' =>'',
                'data' =>  $param
            );
        }else {
            $arr = array(
                'code' => 100,
                'msg' =>'登录失败，请重试',
                'data' =>  $param
            );
        }
        return $arr;
    }
    function update_pwd($params){
        $url = '59f44a14c3cae';
        return sx_call($url,$params);
    }

    function get_staff_info($staffId){
        $url = '59f933a395abe';
        return sx_call($url,$staffId);
    }

    // 更新客资(customerinfo)及消息表(message)，开启事务 Eric
    public function updateCM($dataC, $whereC, $dataM, $whereM){

        // 开启事务
        db()->startTrans();
        try {
            db('c_customerinfo')->where($whereC)->update($dataC);
            db('c_message')->where($whereM)->update($dataM);
            db()->commit();
            // $this->errmsg = db()->getLastSql();
            return true;
        } catch (Exception $e) {
            $error = db()->getLastSql();
            $this->errid = 1;
            $this->errmsg= $error;
            db()->rollback();
            return false;
        }
    }
    public function getMessageById($id){
        $msgInfo = db('c_message')->find((int)$id);

        return $msgInfo;

    }
    public function getMessageByCustomerId($customerId){
        $msgInfo = db('c_message')->where('customer_id',(int)$customerId)->find();
        return $msgInfo;
    }
    // 获取最新的消息
    public function getMessageList($mid){
        $time = time();
        // 存在获取mid之后的消息
        $where = array(
            'receive_id'=> session('staff_id'),
            'is_delete' => 0
        );
        if ($mid && $mid != 0) {
            // 最新的消息 大于mid的消息
            $messageList = db('c_message')
                ->where($where)
                ->where('id','gt',$mid)
                ->order('read_status asc')
                ->order('id desc')
                ->limit(10)
                ->select();
            //echo db()->getLastSql();
        }
        // 不存在，获取倒数10条
        else{
            // 最新的消息id
            $messageList = db('c_message')->where($where)->order('read_status asc')->order('id desc')->limit(10)->select();
            // echo db('c_message')->getLastSql();
        }
        foreach ($messageList as $key => $value) {
            $timeOut = $value['time_out'] - $time;

            // 可操作，未接收，未超时
            if ($value['operation_type']==1 && $value['receive_status']==0 && $timeOut<DEFAULT_SECOND) {
                $messageList[$key]['operation'] = '';
                $messageList[$key]['operation_type'] = 2;
            }else{
                $messageList[$key]['operation'] = json_decode($value['operation'],true);
            }
        }
        //$messageList = my_sort($messageList, 'id');
        return $messageList;
    }

    // 获取最新的 弹框 消息
    public function getPopList($mid){
        $time = time();
        $gtime = $time-DEFAULT_SECOND;
        // 存在获取mid之后的消息
        if ($mid && $mid != 0) {
            $where = array(
                'receive_id'=> session('staff_id'),
                'send_type' => 1,
                'is_delete' => 0
            );
            $popList = db('c_message')
                ->where($where)
                ->where('id','gt',$mid)
                ->where('time_out', 'gt', $gtime)
                ->order('id desc')
                ->limit(5)
                ->select();
        }
        // 不存在，获取倒数5条
        else{
            $where = array(
                'receive_id'=> session('staff_id'),
                'send_type' => 1,
                'is_delete' => 0
            );
            $popList = db('c_message')
                ->where($where)
                ->where('time_out', 'gt', $time)
                ->order('id desc')
                ->limit(5)
                ->select();
            // echo db()->getLastSql();
        }
        $arr = [];
        $arrIds = [];

        foreach ($popList as $key => $value) {
            $timeOut = $value['time_out'] - $time;

            if ($value['send_type'] == 1 && $value['read_status'] == 0 && $timeOut > 0) {
                array_push($arr,$value['customer_id']);
                array_push($arrIds,$value['id']);
                $popList[$key]['pop_status'] = 1;
                $popList[$key]['time_out'] = $timeOut;
                $popList[$key]['operation'] = json_decode($value['operation'],true);
            }
        }
        $num = count($arr);
        if($num>3){
            $popList = [];
            $ids = implode(',',$arr);
            $mids = implode('_',$arrIds);
            $msg['id'] = $mids;
            $msg['send_type'] = 1;
            $msg['send_id'] = -1;
            $msg['send_name'] = 'system';
            $msg['send_time'] = date('Y-m-d H:i:s');
            $msg['send_title'] = '系统消息';
            $msg['send_msg'] = '您收到'.$num.'笔客资，请注意查收！';
            $msg['operation_type'] = 1;
            $msg['operation'][0] = ['button'=>'接收','url'=>'/crm/Customer/customerReceive.html?cid='.$ids.'&'];
            $msg['operation'][1] = ['button'=>'放弃','url'=>'/crm/Customer/customerDrop.html?cid='.$ids.'&'];
            $msg['time_out'] = $timeOut;
            $msg['customer_id'] = $ids;
            $msg['receive_id'] = session('staff_id');
            $msg['receive_name'] = session('staff_name');
            $msg['receive_status'] = 0;
            $msg['is_delete'] = 0;
            $msg['pop_status'] = 1;
            array_push($popList,$msg);
        }

//        $popList = my_sort($popList, 'id');
//        dump($popList);die;
        return $popList;
    }

    // 获取最近一条消息的id
    public function getNewMessageId(){
        $where = array(
            'receive_id'=> session('staff_id'),
            'is_delete' => 0
        );
        // 最新的消息id
        $mid = db('c_message')->where($where)->max('id');
        return $mid;
    }

    // 获取未读消息的数目
    // params maxId int 最大消息ID，如果传了，则只取小于此ID的未读消息数量---songdemei
    //
    public function getNewMessageNum($maxId = 0){
        $where = [
            'receive_id' => session('staff_id'),
            'read_status'=> 0,
            'is_delete'  => 0,
        ];
        $time = time()-DEFAULT_SECOND;
        $msg = db('c_message')
            ->where($where);
        if((int)$maxId > 0){
            $msg->where('id','<=',$maxId);
        }
        $num = $msg
            // ->where('time_out', 'lt', $time)
            ->count();
        return $num;
    }

    // 客户端请求监听
    public function webSubscribe($channel, $callback){

        $message = '';
        $staffid = session('staff_id');
        while (!$message || $message['receive_id'] != $staffid) {
            $res = redisQueue::init()->subscribe($channel, $callback);
            // 监听频道超时
            if ($res === false) {
                return false;
            }
            $message = json_decode($res ,true);
        }
        $time = time();
        $message['time_out'] = $message['time_out']-$time;
        $message['operation']= json_decode($message['operation'], ture);
        return $message;
    }





    //员工所有岗位
    public function getPositions(){
        $url = '5a0b96b65c111';
        $position = $this->get_staff_info(['staff_id'=>session('staff_id')]);
        $position_code = $position['data']['main_position_code'].','.$position['data']['position_code'];
        $info = sx_call($url,['position_code'=>$position_code]);
        if($info['code'] == 200) {
            return $info['data'];
        }else{
            return false;
        }
    }

    //人员
    function get_staff_list($data){
        $url="5a01766b4a3dd";
        $res=sx_call($url,$data);
        if($res['code']==200){
            $info=$res['data'];
        }
        return $info;
    }
    //人员
    function get_staff_lists($data){
        $url="5a574b13103b7";
        $res=sx_call($url,$data);
        if($res['code']==200){
            $info=$res['data'];
        }
        return $info;
    }

    //店面
    function get_shop($data){
        $url="5a005e0038270";
        $res=sx_call($url,$data);
        if($res['code']==200){
            $info=$res['data'];
        }
        return $info;
    }


    //店面查询
    function shop($data){
        $url="5a005e0038270";
        $res=sx_call($url,$data);
        if($res['code']==200){
            $detail=$res['data'];
        }
        return $detail;
    }

    //获取任职某一店面下岗位的员工，包括兼职岗位
    function getShopAllStaff($data){
        $url="5a7424f13aa54";
        $res=sx_call($url,$data);
        if($res['code']==200){
            $detail=$res['data'];
        }
        return $detail;
    }

    /**
     * 发送模板消息
     * @param Integer  $content json格式模板消息内容
     *  @param String  $brandclass_id 品牌id
     * @param String   $shop_code 店面唯一识别码
     * @author {wangyining}<{wangyining@suxuantech.cn}> 2017-10-17 $
     */
    function sendMsg($data){
        $url="5a4b81bc26160";
        $res=sx_call($url,$data);
        if($res['code']==200){
            $detail=$res['data'];
        }
        return $detail;
    }

    //获取必填项对应id
    public function get_set_id($data,$add_shop_code,$shop_code){
        $channel=cache('crm_channel_'.$add_shop_code);//客户渠道
        $consultation_type=cache('crm_consultation_type');//消费类型
        $access_model=cache('crm_access_model');//获取方式
        $source=cache('crm_source');//客户来源
        $intention=cache('crm_intention');//客户意向
        $area=cache('crm_area');//分区
        $region=cache('crm_region');//地域
        $orderAddress=cache('crm_orderAddress');//接单点
        $address=cache('crm_address');
        $consulation_shop=cache('crm_consulation_shop');

        if(isset($data['sales_staff']) && !empty($data['sales_staff'])){
            $staff=$this->get_staff_list(array('staffname'=>$data['sales_staff'],'shop_code'=>$shop_code));
            $ids['sales_staff_id']=$staff[0]['id'];
            $ids['sales_staff_number']=$staff[0]['staffnumber'];
        }else{
            $ids['sales_staff_id']=null;
            $ids['sales_staff_number']='';

        }

        if($data['customer_channel']){
            if(!$channel){
                $channel=db('s_channel')->where('shop_code',$add_shop_code)->select();
                cache('crm_channel_'.$add_shop_code,$channel);
            }
            foreach($channel as $key => $val){
                if($data['customer_channel']==$val['channel_name']){
                    $ids['customer_channel_id']=$val['id'];
                }
            }
        }

        if($data['consultation_type']){
            if(!$consultation_type){
                $consultation_type=$this->consumptionType();
                cache('crm_consultation_type',$consultation_type);
            }
            foreach($consultation_type as $k => $v){
                if($data['consultation_type']==$v['consumption_name']){
                    $ids['consultation_type_id']=$v['id'];
                }
            }
        }

        if($data['access_model']){
            if(!$access_model){
                $access_model=$this->accessModel();
                cache('crm_access_model',$access_model);
            }
            foreach ($access_model as $k => $v ) {
                if($data['access_model']==$v['accessmodel']){
                    $ids['access_model_id']=$v['id'];
                }
            }
        }
        if($data['customer_cource']){//来源
            if(!$source){
                $source=$this->source();
                cache('crm_source',$source);
            }
            foreach($source as $k => $v){
                if($data['customer_cource']==$v['cus_name']){
                    $ids['customer_cource_id']=$v['id'];
                }
            }
        }
        if($data['customer_intention']){//客户意向
            if(!$intention){
                $intention=$this->intention();
                cache('crm_intention',$intention);
            }
            foreach($intention as $k => $v){
                if($data['customer_intention']==$v['intention_name']){
                    $ids['customer_intention_id']=$v['id'];
                }
            }
        }
        if($data['customer_area']){
            if(!$area){
                $area=$this->areaSet();
                cache('crm_area',$area);
            }
            foreach($area as $k => $v){
                if($data['customer_area']==$v['area_name']){
                    $ids['customer_area_id']=$v['id'];
                }
            }
        }
//        if($data['customer_region']){
//            if(!$region){
//                $region=$this->region();
//                cache('crm_region',$region);
//            }
//            foreach($region as $k => $v){
//                if($data['customer_region']==$v['region_name']){
//                    $ids['customer_region_id']=$v['id'];
//                }
//            }
//        }
        if($data['customer_orderaddress']){
            if(!$orderAddress){
                $orderAddress=$this->orderAddress();
                cache('crm_orderAddress',$orderAddress);
            }
            foreach($orderAddress as $k => $v){
                if($data['customer_orderaddress']==$v['acceptoraddress_name']){
                    $ids['customer_orderaddress_id']=$v['id'];
                }
            }
        }

        //意向店面，所有非营销店
        if($data['consulation_shop']){
            if(!$consulation_shop){
                $consulation_shop=$this->shop(array('is_marketing'=>2));
                cache('crm_consulation_shop',$consulation_shop);
            }
            foreach($consulation_shop as $k => $v){
                if($data['consulation_shop']==$v['shop_name']){
                    $ids['consulation_shop_code']=$v['shop_code'];
                }
            }
        }

        if(!$address){
            $address=$this->getCity();
            cache('crm_address',$address);
        }
        if($data['province']){
            foreach($address as $k => $v){
                if($data['province']==$v['name']){
                    $ids['province_id']=$v['id'];
                    $pid=$v['pid'];
                }
            }

            if(!$region){
                $region=$this->region();
                cache('crm_region',$region);
            }
            foreach($region as $k => $v){
                if($v['id']==$pid){
                    $ids['customer_region_id']=$pid;
                    $ids['customer_region']=$v['region_name'];
                }
            }


        }
        if($data['city']){
            foreach($address as $k => $v){
                if($data['city']==$v['name']){
                    $ids['city_id']=$v['id'];
                }
            }
        }
        if($data['county']){
            foreach($address as $k => $v){
                if($data['county']==$v['name']){
                    $ids['county_id']=$v['id'];
                }
            }
        }

        return $ids;
    }


    //获取指定个数的excel列名称
    public function stringFromColumnIndex($pColumnIndex = 0)
    {
        static $_indexCache = array();

        if (!isset($_indexCache[$pColumnIndex])) {
            if ($pColumnIndex < 26) {
                $_indexCache[$pColumnIndex] = chr(65 + $pColumnIndex);
            } elseif ($pColumnIndex < 702) {
                $_indexCache[$pColumnIndex] = chr(64 + ($pColumnIndex / 26)) . chr(65 + $pColumnIndex % 26);
            } else {
                $_indexCache[$pColumnIndex] = chr(64 + (($pColumnIndex - 26) / 676)) . chr(65 + ((($pColumnIndex - 26) % 676) / 26)) . chr(65 + $pColumnIndex % 26);
            }
        }
        return $_indexCache[$pColumnIndex];
    }

    //上传excel文件
    function uploadExcel($file,$file_name){
        //ini_set('memory_limit','1024M');
        $info = $file->validate(['ext' => 'xlsx'])->move(ROOT_PATH . 'application' . DS . 'data' . DS . 'excel');//上传验证后缀名,以及上传之后移动的地址
        if ($info) {
            //echo $info->getFilename();
            $exclePath = $info->getSaveName();  //获取文件名
            $file_url = ROOT_PATH . 'application' . DS . 'data'  . DS . 'excel' . DS . $exclePath;   //上传文件的地址
//            $objReader =\PHPExcel_IOFactory::createReader('Excel2007');
//            $obj_PHPExcel =$objReader->load($file_url, $encode = 'utf-8');  //加载文件内容,编码utf-8
//            $excel_array=$obj_PHPExcel->getsheet(0)->toArray();   //转换为数组格式
//            $first=reset($excel_array);
//            //$title=array('customer_name'=>'客户姓名','customer_sex'=>'性别','customer_tel'=>'手机号','customer_wechat'=>'微信','customer_weibo'=>'微博','customer_qq'=>'QQ','province'=>'省','city'=>'市','county'=>'区','customer_address'=>'详细地址','customer_type'=>'客户类型','consultation_type'=>'消费类型','consulation_shop'=>'意向店面','customer_channel'=>'客户渠道','customer_cource'=>'客户来源','customer_intention'=>'客户意向','customer_orderaddress'=>'接单点','access_model'=>'获取方式','customer_area'=>'客户分区','customer_region'=>'客户地域');
//            $title=import_header();//excel标准表头
//            array_shift($excel_array);

            //检验模板格式
//            if(count($first)!=count($title)){
//                $this->error('您导入的文件模板格式错误','/');
//            }
//            if(count($excel_array)<1){
//                $this->error('您导入的文件没有数据','/');
//            }
//


            $excel_file['file_name']=$file_name;
            $excel_file['file_url']=$file_url;
            $excel_file['staff_id']=session('staff_id');
            $excel_file['staff_name']=session('staff_name');
            $excel_file['addtime']=date('Y-m-d H:i:s',time());
            //$excel_file['all_number']=count($excel_array);
            unset($excel_array);
            //是否筛客
            $b_is_sk = controller("Customer", "lib")->is_sk(session('belong_shop_code'));
            if($b_is_sk ==1 || session('is_sk') == 1){
                $skList = controller("Customer", "lib")->sklist('',24);
                if(!empty($skList)){
                    $excel_file['is_sk']=1;//是否筛客
                }
            }

            db()->startTrans();//开启事务
            try {
                $res=db('c_excel_import')->insert($excel_file);
                $id=db('c_excel_import')->getLastInsID();
                db()->commit();
            } catch (Exception $e) {
                db()->rollback();
            }


//            if($param['is_sk'] == 1){
//                $message['body']['sk']=array('is_sk'=>$param['is_sk'],'sk_staff_id'=>$param['sk_staff_id'],'sk_staff'=>$param['sk_staff']);
//            }
            $message['body']['file_url']=$file_url;
            $message['body']['eid']=$id;
            $message['body']['staff']=array('staff_id'=>session('staff_id'),'staff_name'=>session('staff_name'),'staff_number'=>session('staff_number'),'shop_name'=>session('belong_shop_name'),'shop_code'=>session('belong_shop_code'),'brandclass_id'=>session('brandclass_id'),'brandclass'=>session('brandclass'),'add_shop_code'=>session('shop_code'),'add_shop_name'=>session('shop_name'));
            //$message['body']['data']=$excel_array;
            //$message['body']['num']=$num;

            $dir='../application/data/excel/error';
            if (!is_dir($dir)){
                mkdir($dir);
            }

            if($res){
                $resutl=push_list("excelImportRedisList", $message);
                //redisQueue::init()->rPush('excelImportRedisList', $message);
                $this->success('客资文件上传成功',"/",$file_name);
            }
        } else {
            echo $file->getError();
        }
    }


    //生成错误文件
    function cusFailFile($fail_file){
        $PHPExcel = new PHPExcel();
        $PHPSheet = $PHPExcel->getActiveSheet();
        $PHPSheet->setTitle('customer'); //给当前活动sheet设置名称
        $title=array('客户姓名','性别','手机号','微信','微博','QQ','省','市','区','详细地址','客户类型','客户渠道','获取方式','消费类型','客户来源','客户分区','客户意向','意向店面','接单点','追踪人','错误原因');
        $index = 1;
        for($i=0;$i<count($title);$i++){
            $range[$i] = controller("crm/Customer","lib")->stringFromColumnIndex($i);
            $PHPSheet->setCellValue($range[$i].$index, $title[$i]);
        }
        if(count($fail_file['fail_array'])>0){
            foreach($fail_file['fail_array'] as $k=>$v){
                $index++;
                foreach(array_values($v) as $kk=>$vv){
                    $PHPSheet->setCellValue("{$range[$kk]}{$index}",$vv);
                }
            }
        }

        $PHPWriter = PHPExcel_IOFactory::createWriter($PHPExcel,'Excel2007');
        $file_url = ROOT_PATH . 'application' . DS . 'data'  . DS . 'excel';
        $file_name=$file_url."/error/".'error'.$fail_file['eid'].'.xlsx';
        // echo $file_name;
        $PHPWriter->save($file_name);
        return $file_name;
    }

    //导出
    function export($title,$data,$file){
        set_time_limit(0);
        $PHPExcel = new PHPExcel();
        $cacheMethod = \PHPExcel_CachedObjectStorageFactory::cache_in_memory_gzip;
        if (!\PHPExcel_Settings::setCacheStorageMethod($cacheMethod)) {
            die($cacheMethod . " 缓存方法不可用" . EOL);
        }

        $PHPSheet = $PHPExcel->getActiveSheet();
        $PHPSheet->setTitle('customer'); //给当前活动sheet设置名称
        $index = 1;
        for($i=0;$i<count($title);$i++){
            $range[$i] = controller("crm/Customer","lib")->stringFromColumnIndex($i);
            $PHPSheet->setCellValue($range[$i].$index, $title[$i]);
        }
        // var_dump($data);
        // exit;
        if(count($data)>0){
            foreach($data as $k=>$v){
                if ($v['customer_type']) {
                    $v['customer_type'] = $v['customer_type']==1?'新客资':'转介绍';
                }
                if ($v['is_valid']) {
                    $v['is_valid'] = getIsValidAttr($v['is_valid']);
                }
                if ($v['is_intostore']) {
                    $v['is_intostore']=getIsIntostore($v['is_intostore']);
                }
                if ($v['is_fp']) {
                    $v['is_fp']=getIsFP($v['is_fp']);
                }
                if ($v['is_success']) {
                    $v['is_success']=getIsSuccess($v['is_success']);
                }
                if ($v['is_loss']) {
                    $v['is_loss']=getIsLoss($v['is_loss']);
                }
                if ($v['order_type'] == 1) {
                    $v['order_type']='线上';
                }elseif($v['order_type'] == 2){
                    $v['order_type']='线下';
                }
                if ($v['c_from'] == 1) {
                    $v['c_from']='CRM';
                }elseif($v['c_from'] == 2){
                    $v['c_from']='ERP';
                }
                if ($v['introducer_type']) {
                    $v['introducer_type']=getIntroducerType($v['introducer_type']);
                }
                if($v['track_record']){
                    $v['track_record'] = strip_tags($v['track_record']);
                }
                $index++;
                foreach(array_values($v) as $kk=>$vv){
                    $PHPSheet->setCellValue("{$range[$kk]}{$index}",$vv);
                }
            }
        }

        $PHPWriter = PHPExcel_IOFactory::createWriter($PHPExcel,'Excel2007');
        //header("Content-type:text/html;charset=utf-8");
        header('Content-type: application/vnd.ms-excel');//告诉浏览器输出07Excel文件
        header('Content-Disposition: attachment;filename='.$file);//告诉浏览器输出浏览器名称
        header("Content-Description: File Transfer");
        header('Cache-Control: max-age=0');//禁止缓存
        header("Content-Transfer-Encoding: binary"); //告诉浏览器，这是二进制文件
        $PHPWriter->save("php://output");
        exit;

    }

    //下载源文件
    function before_file($id){
        $data=db('c_excel_import')->where(array('id'=>$id))->find();
        $this->down_file($data['file_url'],$data['file_name']);
    }

    //下载失败文件
    function fail_file($id){
        $data=db('c_excel_import')->where(array('id'=>$id))->find();
        $this->down_file($data['fail_file_url'],'错误数据-'.$data['file_name']);
    }

    //下载文件
    function down_file($url,$name){

        $name = $name?$name:basename($url);
        $file=fopen($url,"r");
        header("Content-Type: application/octet-stream");
        header("Accept-Ranges: bytes");
        header("Accept-Length: ".filesize($url));
        header("Content-Disposition: attachment; filename=".$name);
        echo fread($file,filesize($url));
        fclose($file);

    }


    /*
     * 插入手机归属地信息
     * tel : 男手机号
     * */
    public function insTelInfo($tel){
        //查询是否已有此手机号信息
        $info = $this->getTelInfo($tel);
        if(!empty($info)){
            return $info;
        }
//        $res = preg_match('/^1[3|4|5|6|7|8][0-9]{9}$/', $tel) ? true : false;
        //修改手机号时，查询归属地，区号等
        $telInfo = getData($tel);
        $arr = explode(' ',$telInfo);
        if($arr[1] == $arr[2]){
            $customerInfo['tel_belong'] = $arr[1];
        }else{
            $customerInfo['tel_belong'] = $arr[1].' '.$arr[2];
        }
        $customerInfo['tel_operator'] = $arr[3];
        $customerInfo['tel_area_code'] = $arr[5];
        //插入客资电话信息表
        db()->startTrans();
        if($customerInfo['tel_belong']){
            $id = db('c_customer_tel')->insertGetId(['customer_tel'=>$tel,'tel_belong'=>$customerInfo['tel_belong'],'tel_operator'=>$customerInfo['tel_operator'],'tel_area_code'=>$customerInfo['tel_area_code']]);
            if($id){
                db()->commit();
                return $customerInfo;
            }else{
                db()->rollback();
                return false;
            }
        }else{
            db()->rollback();
            return false;
        }
    }
    /*.
     * 查询手机归属地信息
     * */
    public function getTelInfo($tel){
        $res = db('c_customer_tel')->where('customer_tel',$tel)->find();
        return $res;
    }


}
