<?php
/**
 * 品控中心->知识库
 * CRM的基本功能实现，如客资录入，客资查询等。
 * 所有业务的真正实现全在lib目录下建controller并且访问modle等，供controller层调用
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: chaidongdong<chaidongdong@suxuantech.cn> 2018-4-23 $
 */
namespace app\kf\lib;

use think\Db;
use app\kf\model\TKnowledgeClass;
use app\kf\model\TKnowledge;
class Knowledge{
    
    /**
     * 获取权限目录和文件
     *
     * @param string $data 筛选条件
     * @return array
     * @author chaidongdong@suxuantech.cn
     */
    public function getKnowledgePower($data = []){
        $data['id'] = $data['id'] ? $data['id'] : 0;
        $model_TKnowledgeClass = new TKnowledgeClass();
        $model_TKnowledge = new TKnowledge();
        $class_filter = [
            'p_id'=>$data['id'],
            'is_delete'=>'0'
        ];
        $knowledge_filter = [
            'class_id'=>$data['id'],
            'is_delete'=>'0'
        ];
        if(trim($data['key']['name'])){
            $class_filter['name'] = ['s'=>'like','v'=>'%'.$data['key']['name'].'%'];
            $knowledge_filter['name'] = ['s'=>'like','v'=>'%'.$data['key']['name'].'%'];
        }
        $class_list = $model_TKnowledgeClass->getList($class_filter);
        $knowledge = $model_TKnowledge->getList($knowledge_filter);
        return array_merge($class_list,$knowledge);
    }

    /**
     * 获取目录的上级目录ID
     *
     * @param array $data 目录ID
     * @return array
     * @author chaidongdong@suxuantech.cn
     */
    public function getPKnowledgeClass($data){
        $model_TKnowledgeClass = new TKnowledgeClass();
        $res = $model_TKnowledgeClass->getOne(['id'=>$data['id']]);
        if($res['p_id'] != '0'){
            $res = $model_TKnowledgeClass->getOne(['id'=>$res['p_id']]);
            if($res){
                return $res['id'];
            }
        }
        return 0;
    }

    /**
     * 获取目录信息
     *
     * @param array $data
     * @return array
     * @author chaidongdong@suxuantech.cn
     */
    public function getOneKnowedgeClass($data){
        $model_TKnowledgeClass = new TKnowledgeClass();
        return $model_TKnowledgeClass->getOne($data);
    }

    /**
     * 获取权限目录
     *
     * @param int $pid 父目录ID
     * @param string $power 查看用户组
     * @return array
     * @author chaidongdong@suxuantech.cn
     */
    public function getKnowledgeClassPower($u_power,$pid=0){
        $model_TKnowledgeClass = new TKnowledgeClass();
        $class = $model_TKnowledgeClass->getList(['p_id'=>$pid]);
        $return = [];
        if($class){
            foreach ($class as $key => $value) {
                $res = $this->get_filter_permissions($value['power'],$u_power);
                if($res){
                    $return[] = $value;
                }
            }
        }
        return $return;
    }

    /**
     * 设置知识库目录权限判断
     *
     * @param array @power 权限
     * @return bool
     * @author chaidongdong@suxuantech.cn
     */
    // public function set_filter_permissions($power = []){
    //     if($power){

    //     }
    // }

    /**
     * 获取知识库目录权限判断
     *
     * @param text $power 权限（json/Null）
     * @param array $u_power 用户信息
     * @return bool
     * @author chaidongdong@suxuantech.cn
     */
    public function get_filter_permissions($power,$u_power){
        if($power && ($power != NULL) && !empty($power)){
            $power = json_decode($power,true);
            if($power['organization'] && $u_power['grade_type']){     //组织架构 PS:存储集团名称
                if($u_power['grade_type'] == '1' && in_array($u_power['group_company_name'], $power['organization']['group_company_name'])){  //集团
                    return true;
                }elseif($u_power['grade_type'] == '2' && in_array($u_power['brandclass_id'], $power['organization']['brandclass_id'])){  //事业部/品牌
                    return true;
                }elseif($u_power['grade_type'] == '3' && in_array($u_power['shop_code'], $power['organization']['shop_code'])){  //门店
                    return true;
                }elseif($u_power['grade_type'] == '4' && in_array($u_power['department_id'], $power['organization']['department_id'])){  //门店部门
                    return true;
                }
            }
            if($power['post'] && $u_power['main_position_code']){             //岗位
                if(in_array($u_power['main_position_code'], $power['post'])){
                    return true;
                }
            }
            if($power['work_type'] && $u_power['work_type']){        //工作类型
                if(in_array($u_power, $power['work_type'])){
                    return true;
                }
            }
            return false;
        }else{
            return true;
        }
    }

    /**
     * 修改目录
     *
     * @param array $data 数据
     * @param string &$msg 提示
     * @return bool
     * @author chaidongdong@suxuantech.cn
     */
    public function editKnowledgeClass($data,&$msg = ''){
        $data['id'] = trim($data['id']);
        $data['name'] = trim($data['name']);
        if($data['id'] && $data['name']){
            $model_TKnowledgeClass = new TKnowledgeClass();
            $class = $model_TKnowledgeClass->getOne(['id'=>$data['id']]);
            if($class){
                $res = $model_TKnowledgeClass->getOne(['id'=>['s'=>'neq','id'=>$data['id']],'name'=>$data['name']]);
                if(!$res){
                    if($data['name'] == $class['name']){
                        return true;
                    }
                    $res = $model_TKnowledgeClass->tUpdate(['name'=>$data['name']],['id'=>$data['id']]);
                    if($res){
                        return true;
                    }else{
                        $msg = '操作失败';
                        return false;
                    }
                }else{
                    $msg = '存在重复名称，请更换名称';
                    return false;
                }
            }else{
                $msg = '目录不存在';
                return false;
            }
        }else{
            $msg = '请选择目录';
            return false;
        }
    }

    /**
     * 添加目录
     *
     * @param array $data  数据 
     * @return bool
     * @author chaidongdong@suxuantech.cn
     */
    public function addKnowledgeClass($data,&$msg = ''){
        $data['p_id'] = $data['p_id'] ? $data['p_id'] : 0;
        $model_TKnowledgeClass = new TKnowledgeClass();
        if($data['pid'] != 0){
            $p_class = $model_TKnowledgeClass->getOne(['p_id'=>$data['pid'],'is_delete'=>'0']);
            if(!$p_class){
                $msg = '父目录不存在';
                return false;
            }
        }
        $p_name = $model_TKnowledgeClass->getOne(['name'=>$data['name']]);
        if($p_name){
            $msg = '存在重复名称，请更换名称';
            return false;
        }
        $data = [
            'name'  =>  $data['name'],
            'p_id'  =>  $data['p_id'] ? $data['p_id'] : 0,
            'create_staff_id'   =>  $data['create_staff_id'],
            'create_time'   =>  date('Y-m-d H:i:s')
        ];
        Db::startTrans();
        $res = $model_TKnowledgeClass->tInsert($data);
        if($res){
            if($data['p_id'] != '0'){
                $class = $model_TKnowledgeClass->getOne(['id'=>$data['p_id']]);
                if($class){
                    if($model_TKnowledgeClass->tUpdate(['child_number'=>$class['child_number']+1],['id'=>$data['p_id']])){
                        Db::commit();
                        return true;
                    }else{
                        Db::rollback();
                        $msg = '添加失败';
                        return false;
                    }
                }else{
                    Db::rollback();
                    $msg = '目录不存在';
                    return false;
                }
            }else{
                Db::commit();
                return true;
            }
        }else{
            Db::rollback();
            $msg = '操作失败';
            return false;
        }
    }

    /**
     * 添加文章
     *
     * @param array $data
     * @param string &$msg
     * @return bool
     * @author chaidongdong@suxuantech.cn
     */
    public function addKnowledge($data,&$msg = ''){
        $model_TKnowledge = new TKnowledge();
        $model_TKnowledgeClass = new TKnowledgeClass();
        $data['class_id'] = intval($data['class_id']) ? intval($data['class_id']) : 0;
        if($data['class_id'] != 0){
            $class = $model_TKnowledgeClass->getOne(['id'=>$data['class_id'],'is_delete'=>'0']);
            if(!$class){
                $msg = '目录不存在';
                return false;
            }
        }
        $knowledge = $model_TKnowledge->getOne(['name'=>trim($data['name']),'class_id'=>$data['class_id']]);
        if(!$knowledge){
            $add = [
                'class_id'=>$data['class_id'],
                'name'=>trim($data['name']),
                'content'=>$data['content'],
                'create_staff_id'=>$data['create_staff_id'],
                'create_time'=>date('Y-m-d H:i:s')
            ];
            Db::startTrans();
            $res = $model_TKnowledge->tInsert($add);
            if($res){
                if($class){
                    if($model_TKnowledgeClass->tUpdate(['child_number'=>$class['child_number']+1],['id'=>$class['id']])){
                        Db::commit();
                        return true;
                    }else{
                        Db::rollback();
                        $msg = '操作失败';
                        return false;
                    }
                }
                Db::commit();
                return true;
            }else{
                Db::rollback();
                $msg = '操作失败';
                return false;
            }
        }else{
            $msg = '存在重复名称，请更换名称';
            return false;
        }
    }

    /**
     * 添加文章
     *
     * @param array $data
     * @param string &$msg
     * @return bool
     * @author chaidongdong@suxuantech.cn
     */
    public function editKnowledge($data,&$msg){
        $model_TKnowledge = new TKnowledge();
        $model_TKnowledgeClass = new TKnowledgeClass();
        $data['class_id'] = intval($data['class_id']) ? intval($data['class_id']) : 0;
        $data['id'] = intval($data['id']) ? intval($data['id']) : 0;
        if($data['class_id'] != 0){
            $class = $model_TKnowledgeClass->getOne(['id'=>$data['class_id'],'is_delete'=>'0']);
            if(!$class){
                $msg = '目录不存在';
                return false;
            }
        }
        $knowledge = $model_TKnowledge->getOne(['id'=>$data['id'],'class_id'=>$data['class_id'],'is_delete'=>'0']);
        if($knowledge){
            $res = $model_TKnowledge->getOne(['id'=>['s'=>'neq','id'=>$data['id']],'is_delete'=>'0','name'=>trim($data['name'])]);
            if(!$res){
                $update = [
                    'name'=>$data['name'],
                    'content'=>$data['content'],
                ];
                $res = $model_TKnowledge->update($update,['id'=>$data['id']]);
                if(!$res){
                    $msg = '操作失败';
                    return false;
                }else{
                    return true;
                }
            }else{
                $msg = '存在重复名称，请更换名称';
                return false;
            }
        }else{
            $msg = '文章不存在';
            return false;
        }
    }

    /**
     * 获取文章信息
     *
     * @param array $data
     * @return array
     * @author chaidongdong@suxuantech.cn
     */
    public function getOneKnowledge($data = []){
        $model_TKnowledge = new TKnowledge();
        return $model_TKnowledge->getOne($data);
    }

    /**
     * 获取目录路径
     *
     * @param string $id 目录ID
     * @return array
     * @author chaidongdong@suxauntech.cn
     */
    public function getKnowledgeClassPath($id,$path = []){
        $id = $id ? $id : '0';
        if($id == '0'){
            array_unshift($path, ['id'=>0,'name'=>'全部文件']);
            return $path;
        }
        $model_TKnowledgeClass = new TKnowledgeClass();
        $class = $model_TKnowledgeClass->getOne(['id'=>$id]);
        array_unshift($path,$class);
        return $this->getKnowledgeClassPath($class['p_id'],$path);
    }

    /**
     * 删除文章
     *
     * @param array $params
     * @param string &$msg
     * @return bool
     * @author chaidongdong@suxuantech.cn
     */
    public function delKnowledge($params,&$msg){
        $model_TKnowledge = new TKnowledge();
        $model_TKnowledgeClass = new TKnowledgeClass();
        $knowledge = $model_TKnowledge->getOne(['id'=>$params['id']]);
        if($knowledge){
            Db::startTrans();
            if($model_TKnowledge->tUpdate(['is_delete'=>'1'],['id'=>$knowledge['id']])){
                if($knowledge['class_id'] != '0'){
                    $class = $model_TKnowledgeClass->getOne(['id'=>$knowledge['class_id']]);
                    if($class){
                        if($model_TKnowledgeClass->tUpdate(['child_number'=>($class['child_number']-1)],['id'=>$class['id']])){
                            Db::commit();
                            return true;
                        }else{
                            Db::rollback();
                            $msg = '操作失败';
                            return false;
                        }
                    }else{
                        Db::rollback();
                        $msg = '操作失败';
                        return false;
                    }
                }
                Db::commit();
                return true;
            }else{
                Db::rollback();
                $msg = '删除失败';
                return false;
            }
        }else{
            $msg = '文章不存在';
            return true;
        }

    }

    /**
     * 知识库添加访问日志
     *
     * @param integer $staff_id
     * @param integer $knowledge_id
     * @param integer $source
     */
    public function addKnowledgeLog($staff_id,$knowledge_id,$source = 'wx'){
        $data = [
            'staff_id'=>$staff_id,
            'knowledge_id'=>$knowledge_id,
            'source'=>$source,
            'create_time'=>date('Y-m-d H:i:s')
        ];
        $model_TKnowledgePvLogs = new \app\kf\model\TKnowledgePvLogs();
        $model_TKnowledgePvLogs->tInsert($data);
    }

    /**
     * 删除目录
     *
     * @param array $params
     * @param string &$msg
     * @return bool
     * @author chaidongdong@suxuantech.cn
     */
    public function delKnowledgeClass($params,&$msg){
        $model_TKnowledgeClass = new TKnowledgeClass();
        $class = $model_TKnowledgeClass->getOne(['id'=>$params['id']]);
        if($class){
            Db::startTrans();
            if($class['child_number']<=0){
                if($model_TKnowledgeClass->tUpdate(['is_delete'=>'1'],['id'=>$class['id']])){
                    if($class['p_id'] != 0){
                        if($model_TKnowledgeClass->tUpdate(['child_number'=>($class['child_number']-1)],['id'=>$class['p_id']])){
                            Db::commit();
                            return true;
                        }else{
                            Db::rollback();
                            $msg = '操作失败';
                            return false;
                        }
                    }
                    Db::commit();
                    return true;
                }else{
                    Db::rollback();
                    $msg = '删除失败';
                    return false;
                }
            }else{
                Db::rollback();
                $msg = '目录下存在文件或者目录,不能删除';
                return false;
            }
        }else{
            $msg = '目录不存在';
            return true;
        }
    }

}