<?php
/**
 * MC 接口模型，
 * 所有请求MC接口的，写到此类里，未来可以方便管理。
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: songdemei<songdemei@suxuantech.cn> 2018-01-30 $
 */
namespace app\kf\lib;
use think\Controller;
use think\Exception;

class mcInterface extends Controller{
    var $_code = 0;
    var $_msg = '';
    var $_shopCode = '';
    function _initialize($shopCode = ''){
        $this->_shopCode = $shopCode;
    }
    public function retResult($res){
        if(!$res){
            $this->_code = -2;
            $this->_msg = '接口请求失败，请重试';
            return false;
        }
        if($res['error']){
            $this->_code = -1;
            $this->_msg = $res['error'];
            return false;
        }
        if($res['code'] != 200){
            $this->_code = $res['code'];
            $this->_msg = $res['msg'];
            return false;
        }
        return $res['data'];

    }
    public function getAddcustomerShopList($shopCode){
        $shopCode = $shopCode?$shopCode:$this->_shopCode;
        $res = sx_call('5a7076a6ccfaa',['shop_code'=>$shopCode]);
        return $this->retResult($res);

    }
    public function getCustomerResource($shopCode = ''){
        $res = sx_call('59fd5ec462c88',[]);
        return $this->retResult($res);
    }
    public function getCustomerArea(){
        $res = sx_call('5a004e9c3e030');
        return $this->retResult($res);
    }
    public function getCustomerRegin(){
        $res = sx_call('59fd5fa926b98');
        return $this->retResult($res);
    }
    public function getBrandShopList($brandId){
        $res = sx_call('5a005e0038270');
        return $this->retResult($res);
    }
    public function getStaffById($staffId){
        $res = sx_call('5a01766b4a3dd',['id'=>$staffId]);
        if($res['code'] == 200 && $res['data'][0]){
            return $this->retResult(['code'=>200,'data'=>$res['data'][0]]);
        }else{
            return $this->retResult($res);
        }
        
    }
    /**
     * 根据部门ID，获取部门下所有员工
     * 
     */
    public function getStaffListByDepartmentId($departmentId){
        $res = sx_call('5a01766b4a3dd',['department_id'=>$departmentId]);
        return $this->retResult($res);
    }
    /**
     * 根据门店编码，获取店下直属员工
     * 
     */
    public function getStaffListByShopcode($shopCode){
        $res = sx_call('5a01766b4a3dd',['shop_code'=>$shopCode,'grade_type'=>3]);
        return $this->retResult($res);
    }
    /**
     * 根据店号获取店下的所有部门
     * @param  [type] $shopCode [description]
     * @return [type]           [description]
     */
    public function getDepartmentByShopcode($shopCode){
        $res = sx_call('5a0aef152b750',['shop_code'=>$shopCode]);
        return $this->retResult($res);

    }
    /**
     * 获取部门信息
     * 
     * @param  [type] $departmentId [description]
     * @return [type]               [description]
     */
    public function getDepartmentById($departmentId){
        $res = sx_call('5a0aef152b750',['id'=>$departmentId]);
        if($res['data'][0]){
            return $this->retResult(['code'=>200,'data'=>$res['data'][0]]);
        }else{
            return $this->retResult($res);
        }

    }
    
    // 根据branclass 查事业部下所有的店
    public function getBrandShops($param){
        $data['brandclass'] = $param;
        $res = sx_call('5a005e0038270', $data);
        return $this->retResult($res);
    }

    public function getStaffsByShopCode($shopCode){
        $res = sx_call('5a01766b4a3dd',['shop_code'=>$shopCode,'grade_type'=>4]);
        return $this->retResult($res);
    }

}