<?php
/**
 * CRM 实现模块
 * CRM的基本功能实现，如客资录入，客资查询等。
 * 所有业务的真正实现全在lib目录下建controller并且访问modle等，供controller层调用
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: chaidongdong<chaidongdong@suxuantech.cn> 2018-4-23 $
 */
namespace app\kf\lib;

use app\kf\model\SQualityItems;
use app\kf\model\SQualityObject;
use think\Db;
use app\kf\model\SQualityList;
use app\kf\model\SQualitys;
class Quality{

    /**
     * 页面获取培质检单单项列表(分页)
     *
     * @param array $params 参数
     * @return array
     * @author chaidongdong@suxuantech.cn
     */
    public function SingleList($params = []){
        $page = $params['page'] ? $params['page'] : 1;
        $limit = intval($params['limit']) ? intval($params['limit']) : 10;
        $model_SQualityList = new SQualityList();
        if($params['key']){
             $filter = $params['key'];
             $filter = array_filter($filter,'trim');
             if($filter['name']){
                 $filter['name'] = ['s'=>'like','v'=>'%'.$filter['name'].'%'];
             }
        }
        $list = $model_SQualityList->getList($filter,'*',$page,$limit,'create_time desc');
        $count = $model_SQualityList->getCount($filter);
        if($count<1){
            return ['data'=>[], 'count'=>0];
        }else{
            return ['data'=>$list, 'count'=>$count];
        }
    }

    /**
     * 页面获取培质检单单项列表(分页)
     *
     * @param array $params 参数
     * @return array
     * @author chaidongdong@suxuantech.cn
     */
    public function QualityList($params = []){
        $page = $params['page'] ? $params['page'] : 1;
        $limit = intval($params['limit']) ? intval($params['limit']) : 10;
        $model_SQualitys = new SQualitys();
        // unset($params['page'],$params['limit']);
        if($params['key']){
            // $filter = $params['key'];
            // if($filter['title']){
            //     $filter['title'] = ['s'=>'like','v'=>'%'.$filter['title'].'%'];
            // }
        }
        $list = $model_SQualitys->getList($filter,'*',$page,$limit,'create_time desc');
        $count = $model_SQualitys->getCount($filter);
        if($count<1){
            return ['data'=>[], 'count'=>0];
        }else{
            return ['data'=>$list, 'count'=>$count];
        }
    }

    /**
     * 获取单个质检单单项
     *
     * @param array $params 条件
     * @return array
     * @author chaidongdong@suxuantech.cn
     */
    public function getSingleOne($params){
        $model_SQualityList = new SQualityList();
        $res = $model_SQualityList->getOne($params);
        if($res){
            $res['options'] = json_decode($res['options'],true);
            return $res;
        }else{
            return false;
        }
    }

    /**
     * 获取多个质检单单项
     *
     * @param array $params 条件
     * @return array
     * @author chaidongdong@suxuantech.cn
     */
    public function getSingleList($params){
        $model_SQualityList = new SQualityList();
        $res = $model_SQualityList->getList($params);
        if($res){
            foreach ($res as $key => &$value) {
                $value['options'] = json_decode($value['options'],true);
            }
            return $res;
        }else{
            return false;
        }
    }

    /**
     * 修改或者添加质检单单项
     *
     * @param array $params 数据
     * @param string &msg 提示
     * @return bool
     * @author chaidongdong@suxuantech.cn
     */
    public function saveSingle($params = [],&$msg){
        $params = array_filter($params);
        $params['options'] = array_filter($params['options'],'trim');

        $params['score'] = array_filter($params['score'],function($v){
            return $v || is_numeric($v);
        });
        if(!empty($params['options']) && !empty($params['score'])){
            if(count($params['options']) == count($params['score'])){
                $i = 1;
                $top_score = 0;
                foreach ($params['options'] as $key => $value) {
                    if($key < 0){
                        $msg = '操作失败';
                        return false;
                    }
                    $params['score'][$key] = intval($params['score'][$key]);
//                    dd($params);
                    if(!$params['score'][$key] && $params['score'][$key] != 0){
                        $msg = '请填写对应的对应分值';
                        return false;
                    }
                    $score[$i] = $params['score'][$key];
                    $options[$i] = $params['options'][$key];
                    if($top_score < $score[$i]){
                        $top_score = $score[$i];
                    }
                    $i++;
                }
                $model_SQualityList = new SQualityList();
                $data =[
                    'name'=>trim($params['name']),
                    'options'=>json_encode(['options'=>$options,'score'=>$score]),
                    'top_score'=>$top_score
                ];
                if($params['id']){
                    if($model_SQualityList->getOne(['id'=>$params['id']])){
                        $res = $model_SQualityList->tUpdate($data,['id'=>$params['id']]);
                        if($res !== false){
                            return true;
                        }else{
                            $msg = '操作失败';
                            return false;
                        }
                    }else{
                        $msg = '质检单单项不存在';
                        return false;
                    }
                }else{
                    $data['create_staff_id'] = $params['create_staff_id'];
                    $data['create_time'] = date('Y-m-d H:i:s');
                    if($model_SQualityList->tInsert($data)){
                        return true;
                    }else{
                        $msg = '操作失败';
                        return false;
                    }
                }
                if($res){
                    return false;
                }else{
                    $msg = '操作失败';
                    return false;
                }
            }else{
                $msg = '请填写选项和分值一一对应';
                return false;
            }
        }else{
            $msg = '请填写选项和对应分值';
            return false;
        }
    }

    /**
     * 添加、修改质检单
     *
     * @param array $data
     * @param string &$msg
     * @return bool
     * @author chaidongdong@suxuantech.cn
     */
    public function saveQuality($params,&$msg){
        if(!$params['quality_list']){
            $msg = '请选择质检项';
            return false;
        }
        if(!is_numeric($params['score']) || $params['score'] <= 0 || $params['score'] > 1000){
            $msg = '请填写总权重，填写1-999的数字';
            return false;
        }
        $score = 0;
        foreach ($params['quality_list'] as $value){
            $score += $value['top_score'];
        }
        if($score != $params['score']) {
            $s = $score - $params['score'];
            if($s < 0){
                $msg = '总权重超出质检项'.abs($s).'个权重';
            }else{
                $msg = '质检项超出总权重'.abs($s).'个权重';
            }
            return false;
        }
        $data = [
            'name'=>trim($params['name']),
            'type'=>$params['type'],
            'start_time'=>$params['start_time'],
            'score'=>$score,
            'end_time'=>$params['end_time'],
            'quality_list'=>json_encode($params['quality_list']),
        ];
        if($data['name'] && $data['type'] && $data['quality_list'] && $data['start_time'] && $data['end_time'] && ($data['start_time'] < $data['end_time'])){
            $model_SQualitys = new SQualitys();
            if($params['id']){
                $res = $model_SQualitys->tUpdate($data,['id'=>$params['id']]);
                if($res !== false){
                    return true;
                }else{
                    $msg = '修改失败';
                    return false;
                }
            }else{
                if($params['create_staff_id']){
                    $data['create_staff_id'] = $params['create_staff_id'];
                    $data['create_time'] = date('Y-m-d H:i:s');
                    if($model_SQualitys->tInsert($data)){
                        return true;
                    }else{
                        $msg = '修改失败';
                        return false;
                    }
                }else{
                    $msg = '缺少参数';
                    return false;
                }
            }
        }else{
            $msg = '请正确填写';
            return false;
        }
    }
    /**
     * 删除质检单单项
     *
     * @param array $params
     * @param string &$msg
     * @return bool
     * @author chaidongdong@suxauntech.cn
     */
    public function delQualitySingle($params,&$msg){
        $model_SQualityList = new SQualityList();
        return $model_SQualityList->tDelete($params);
    }

    /**
     * 获取单个质检单
     *
     * @param array $params
     * @return array
     * @author chaidongdong@suxuantech.cn
     */
    public function getQualityOne($params){
        $model_SQualitys = new SQualitys();
        $res = $model_SQualitys->getOne($params);
        if($res['quality_list']){
            $model_SQualityList = new SQualityList();
            $res['quality_list'] = @json_decode($res['quality_list'],true);
            foreach ($res['quality_list'] as $key => $value){
                $list = $model_SQualityList->getOne(['id'=>$value['id']],'name');
                $res['quality_name'][$value['id']]['name']=$list['name'];
                $res['quality_name'][$value['id']]['top_score']=$value['top_score'];
            }
        }
        return $res;
    }

    /**
     * 删除质检单
     *
     * @param array $params
     * @return bool
     * @author chaidongdong@suxuantech.cn
     */
    public function delQuality($params){
        $model_SQualitys = new SQualitys();
        return $model_SQualitys->tDelete($params);
    }

    /**
     * 生成前台用户的需要的质检单
     *
     * @param array @params
     * @return mixed
     * @author chaidongdong@suxuantech.cn
     */
    public function getQualityInfo($params){
        $model_SQualitys = new SQualitys();
        $date = date('Y-m-d H:i:s');
        $params['start_time']=['s'=>'lt','v'=>$date];
        $params['end_time']=['s'=>'gt','v'=>$date];
        $quality = $model_SQualitys->getOne($params);
        if($quality && $quality['quality_list']){
            $quality['quality_list'] = @json_decode($quality['quality_list'],true);
            $model_SQualityList = new SQualityList();
            foreach ($quality['quality_list'] as $key=>$value){
                $single = $model_SQualityList->getOne(['id'=>$value['id']]);
                $single['options'] = json_decode($single['options'],true);
                $quality['list'][] = $single;
            }
            return $quality;
        }else{
            return false;
        }
    }

    /**
     * 特殊
     */
    public function getQualityInfosss($params){
        $model_SQualitys = new SQualitys();
        $quality = $model_SQualitys->getOne($params);
        if($quality && $quality['quality_list']){
            $quality['quality_list'] = @json_decode($quality['quality_list'],true);
            $model_SQualityList = new SQualityList();
            foreach ($quality['quality_list'] as $key=>$value){
                $single = $model_SQualityList->getOne(['id'=>$value['id']]);
                $single['options'] = json_decode($single['options'],true);
                $quality['list'][] = $single;
            }
            return $quality;
        }else{
            return false;
        }
    }

    /**
     * 生成前台用需要查看的质检单结果
     *
     * @param array @params
     * @return mixed
     * @author chaidongdong@suxuantach.cn
     */
    public function getQualityInfoR($params){
        $model_SQualitys = new SQualitys();
        $date = date('Y-m-d H:i:s');
        $params['end_time']=['s'=>'lt','v'=>$date];
        $quality = $model_SQualitys->getOne($params);
        if($quality && $quality['quality_list']){
            $quality['quality_list'] = @json_decode($quality['quality_list'],true);
            $model_SQualityList = new SQualityList();
            foreach ($quality['quality_list'] as $key=>$value){
                $single = $model_SQualityList->getOne(['id'=>$value['id']]);
                $single['options'] = json_decode($single['options'],true);
                $quality['list'][] = $single;
            }
            return $quality;
        }else{
            return false;
        }
    }

    /**
     * 获取门店是否跟该质检有关
     *
     * @param integer $quality_id
     * @param integer $shop_code
     * @return true
     * @author chaidongdong@suxuantech.cn
     */
    public function getQualityShop($quality_id,$shop_code){
        $model_SQualityObject = new SQualityObject();
        return $model_SQualityObject->getOne([
            'quality_id'=>$quality_id,
            'shop_code'=>$shop_code,
            'is_end'=>0
            ]
        );
    }


    /**
     * 获取门店是否跟该质检有关
     *
     * @param integer $quality_id
     * @param integer $department_id
     * @return true
     */
    public function getQualityDept($quality_id,$department_id){
        $model_SQualityObject = new SQualityObject();
        return $model_SQualityObject->getOne([
                'quality_id'=>$quality_id,
                'department_id'=>$department_id,
                'is_end'=>0
            ]
        );
    }

    /**
     * 检查订单号在质检单使用过
     *
     * @param string $orderid
     * @return bool
     * @author chaidongdong@suxuantech.cn
     */
    public function checkQualityOrder($orderid){
        $model_SqualityObject = new SQualityObject();
        if($model_SqualityObject->getOne(['orderid'=>$orderid])){
            return false;
        }
        return true;
    }

    /**
     * 从ERP获取订单信息并验证
     *
     * @param string $orderid 订单号
     * @param string $mobile 订单手机号
     * @param string $brandId 事业部ID
     * @param string &$msg 提示信息
     * @return bool
     * @author chaidongdong@suxuantech.cn
     */
    public function checkErpOrder($orderId,$mobile,$brandId,&$msg){
        if(!trim($orderId)){
            $msg = '请输入订单号';
            return false;
        }
        if($this->checkQualityOrder($orderId)){
            $erp = config('ext.app_config')['sx_erp'];
            $addr= $erp['addr'];
//            $url = $addr.'SX_CrmApi/Sel_CustomerOrderList?Token=^******^&orderInfo=''&CustomerType=1&brandid='.$brandId.'&startdate=&enddate=';
//            $dataErp = '[]';
//            $response = requestERP($url, $dataErp);
//            dd($response);
            $dataErp = '[]';
            for ($i=0;$i<3;$i++){
                $url = $addr.'SX_CrmApi/Sel_CustomerOrderList?Token=^******^&orderInfo='.$orderId.'&CustomerType='.$i.'&brandid='.$brandId.'&startdate=&enddate=';
                $response = requestERP($url, $dataErp);
                if($response['Code'] == 200 && !empty($response['Data'])){
//                    dd($response);
                    if($response['Data']['0']['wphone'] != $mobile){
                        $msg = '订单信息不准确，请核对信息';
                        return false;
                    }else{
                        $msg = '验证正确';
                        return true;
                    }
                }
            }
            $msg = '订单不存在';
            return false;
        }
        $msg = '订单已使用，请更换订单';
        return false;
    }

    /**
     * 提交前台用户的提交的质检单单项答卷
     *
     * @param integer $quality_id
     * @param string $code  当质检对象是店面是 shop_code,是部门时 department_id
     * @param integer $staff_id
     * @param array $params
     * @param string &$msg
     * @return bool
     * @author chaidongdong@suxuantech.cn
     */
    public function handQuality($quality_id,$code,$staff_id,$params,&$msg){
        $model_SQualityItems = new SQualityItems();
        $model_SQuality = new SQualitys();
        $model_SQualityList = new SQualityList();
        $model_SQualityObject = new SQualityObject();
        $object_type = getZJObjectType();
        if($object_type==1){
            $object = $model_SQualityObject->getOne(['quality_id'=>$quality_id,'shop_code'=>$code,'object_type'=>$object_type]);
        }elseif($object_type==2){
            $object = $model_SQualityObject->getOne(['quality_id'=>$quality_id,'department_id'=>$code,'object_type'=>$object_type]);
        }

        if(!$object){
            $msg = '质检单不存在';
            return false;
        }
        $score = 0;
        $quality = $model_SQuality->getOne(['id'=>$quality_id]);
        $quality['quality_list'] = json_decode($quality['quality_list'],true);
        $tmp_l = array_keys($quality['quality_list']);
        sort($tmp_l);
        $tmp_list = array_keys($params['quality']);
        sort($tmp_list);
        if($tmp_list != $tmp_l){
            $msg = '请将质检单选项填写完整';
            return false;
        }
        Db::startTrans();
        foreach ($params['quality'] as $key=>$value){
//            dd($params);
            $single = $model_SQualityList->getOne(['id'=>$key]);
            if($single){
                $single['options'] = json_decode($single['options'],true);
                $insert = [
                    'quality_id'=>$quality_id,
                    'quality_list_id'=>$key,
                    'object_id'=>$object['id'],
                    'score'=>$single['options']['score'][$value],
                    'remarks'=>json_encode(['a'=>$params['result'][$key],'old_remarks'=>$params['result'][$key],'old_score'=>$single['options']['score'][$value]])
                ];
                $score += $single['options']['score'][$value];
                if(!$model_SQualityItems->tInsert($insert)){
                    Db::rollback();
                    $msg = '操作失败';
                    return false;
                }
            }else{
                $msg = '操作失败';
                Db::rollback();
                return false;
            }
        }
        $update = [
            'score'=>$score,
            'result'=>$params['result'],
            'staff_id'=>$staff_id,
            'username'=>$params['username'],
            'orderid'=>$params['orderid'],
            'mobile'=>$params['mobile'],
            'is_end'=>1
        ];
        if($object_type==1){
            $res = $model_SQualityObject->update($update,['quality_id'=>$quality_id,'shop_code'=>$code]);
        }elseif($object_type==2){
            $res = $model_SQualityObject->update($update,['quality_id'=>$quality_id,'department_id'=>$code]);
        }

        if($res !== false){
            Db::commit();
            return true;
        }else{
            $msg = '操作失败';
            Db::rollback();
            return false;
        }
    }

    /**
     * 获取可使用的质检单
     *
     * @param integer $quality_id
     * @return array
     * @author chaidongdong@suxuantech.cn
     */
    public function getValidQuality($quality_id){
        $date = date('Y-m-d H:i:s');
        $model_SQuality = new SQualitys();
        $res = $model_SQuality->getOne([
            'id'=>$quality_id,
            'start_time'=>['s'=>'lt','v'=>$date],
            'end_time'=>['s'=>'gt','v'=>$date],
            'quality_list'=>['s'=>'neq','v'=>'NULL'],
        ]);
        return $res;
    }

    /**
     * 获取质检对象
     *
     * @param array $params
     * @return array
     * @author chaidongdong@suxuantech.cn
     */
    public function getQualityObject($params){
        $model_SQualityObject = new SQualityObject();
        return $model_SQualityObject->getList($params);
    }

    /**
     * 获取后台页面可区分的质检对象
     *
     * @param integer $quality_id
     * @param integer $object_type  质检对象类型 1店面，2部门
     * @return array
     * @author chaidongdong@suxuantech.cn
     */
    public function getFormatQualityObject($quality_id,$object_type){
        $res = $this->getQualityObject(['quality_id'=>$quality_id,'object_type'=>$object_type]);

        $data = [];
        if($res&&$object_type==1){
            foreach ($res as $value){
                if(!$data[$value['brand_id']]){
                    $data[$value['brand_id']] = [
                        'brandclass' =>$value['brandclass'],
                        'brand_id'=>$value['id']
                    ];
                }
                $data[$value['brand_id']]['shop_list'][$value['shop_code']] = [
                    'shop_code'=>$value['shop_code'],
                    'shop_name'=>$value['shop_name'],
                    'score'=>($value['is_end'] == '1') ? $value['score'] : '未质检'
                ];
            }
        }
        if($res&&$object_type==2){
            foreach ($res as $value){
                if(!$data[$value['shop_code']]){
                    $data[$value['shop_code']] = [
                        'shop_name' =>$value['shop_name'],
                        'shop_code'=>$value['shop_code']
                    ];
                }
                $data[$value['shop_code']]['dept_list'][$value['department_id']] = [
                    'department_id'=>$value['department_id'],
                    'department_name'=>$value['department_name'],
                    'score'=>($value['is_end'] == '1') ? $value['score'] : '未质检'
                ];
            }
        }


        return $data;
    }

    /**
     * 添加质检对象（门店）
     *
     * @param integer $quality_id
     * @param array $params 品牌-》门店 允许为空
     * @param array $object_type 质检对象类型，1店面，2部门
     * @return bool
     * @author chaidongdong@suxuantech.cn
     */
    public function saveQualityObject($quality_id,$params = [],$object_type=1){

        $model_SQualityObject = new SQualityObject();
        Db::startTrans();
        $res = $model_SQualityObject->getOne(['quality_id'=>$quality_id]);
        if($res){
            $res = $model_SQualityObject->tDelete(['quality_id'=>$quality_id,'object_type'=>$object_type]);
            if($res === false){
                Db::rollback();
                return false;
            }
        }
        if($params&&$object_type==1){
            $list = array();
            foreach ($params as $key => $value) {
                $list = array_merge($list,$value);
            }
            $insert = [];
            foreach ($list as $v){
                $shop = controller('Setting','lib')->get_shop(['shop_code'=>$v])[0];
                $insert[] = [
                    'quality_id'=>$quality_id,
                    'brand_id'=>$shop['brandclass_id'],
                    'brandclass'=>$shop['brandclass'],
                    'shop_code'=>$shop['shop_code'],
                    'shop_name'=>$shop['shop_name'],
                    'object_type'=>$object_type,
                ];
            }

            if(!db('s_quality_object')->insertAll($insert)){
                Db::rollback();
                return false;
            }

/*
            foreach ($params as $brand_id =>$value){
                $brand = controller('Setting','lib')->selectBrandclass(['id'=>$brand_id]);
                foreach ($value as $v){
                    $shop = controller('Setting','lib')->get_shop(['shop_code'=>$v]);
                    $insert = [
                        'quality_id'=>$quality_id,
                        'brand_id'=>$brand_id,
                        'shop_code'=>$v,
                        'brandclass'=>$brand['0']['brandclass'],
                        'shop_name'=>$shop['0']['shop_name']
                    ];
                    if(!$model_SQualityObject->tInsert($insert)){
                        Db::rollback();
                        return false;
                    }
                }
            }
*/
        }elseif($params&&$object_type==2){

            $list = array();
            foreach ($params as $key => $value) {
                $list = array_merge($list,$value);
            }

            $insert = [];
            foreach ($list as $v){
                $dept = controller('Setting','lib')->department_list(['id'=>$v])[0];
                $insert[] = [
                    'quality_id'=>$quality_id,
                    'brand_id'=>$dept['brandclass_id'],
                    'brandclass'=>$dept['brandclass'],
                    'shop_code'=>$dept['shop_code'],
                    'shop_name'=>$dept['shop_name'],
                    'object_type'=>$object_type,
                    'department_id'=>$dept['id'],
                    'department_name'=>$dept['department_name'],
                ];
            }

            if(!db('s_quality_object')->insertAll($insert)){
                Db::rollback();
                return false;
            }
        }
        Db::commit();
        return true;
    }

    /**
     * 获取质检单需要质检的品牌
     *
     * @param integer $quality_id
     * @return array
     * @author chaidongdong@suxuantech.cn
     */
    public function getQualityBrandList($quality_id){
        $model_SQualityObject = new SQualityObject();
        $brand_ids = $model_SQualityObject->getList(['quality_id'=>$quality_id,'object_type'=>1],'brand_id','1','0','','brand_id');
        if($brand_ids){
            foreach ($brand_ids as $value){
                $brand = controller('Setting','lib')->selectBrandclass(['id'=>$value['brand_id']]);
                $brands[] = current($brand);
            }
            return array_filter($brands);
        }

        return [];
    }



    /**
     * 获取质检单和品牌关联的门店
     *
     * @param integer $quality_id
     * @param integer $brand_id
     * @return array
     * @author chaidongdong@suxuantech.cn
     */
    public function getQualityBrandShop($quality_id,$brand_id,$object_type){
        $model_SQualityObject = new SQualityObject();
        $shop_codes = $model_SQualityObject->getList(['quality_id'=>$quality_id,'brand_id'=>$brand_id,'object_type'=>$object_type],'shop_code,shop_name');
        if($shop_codes){
//            foreach ($shop_codes as $value){
//                $shop = controller('Setting','lib')->get_shop(['shop_code'=>$value['shop_code']]);
//                $shops[] = current($shop);
//            }
            return $shop_codes;
        }
        return [];
    }

    /**
     * 获取质检单需要质检的店
     *
     * @param integer $quality_id
     * @return array
     * @author wangyining@suxuantech.cn
     */
    public function getQualityShopList($quality_id){
        //质检对象为部门
        $shop = db('s_quality_object')->where(['quality_id'=>$quality_id,'object_type'=>2])->group('shop_code')->select();
        if(!$shop)  $shop = [];
        return $shop;
    }

    /**
     * 获取质检单和店面关联的部门
     *
     * @param integer $quality_id
     * @param integer $shop_code
     * @param integer $object_type   1对象为店，2对象为部门
     * @return array
     * @author chaidongdong@suxuantech.cn
     */
    public function getQualityShopDept($quality_id,$shop_code,$object_type){
        $deptList = db('s_quality_object')->where(['quality_id'=>$quality_id,'shop_code'=>$shop_code,'object_type'=>$object_type])->field('department_id,department_name')->select();
        if(!$deptList)  $deptList=[];
        return $deptList;
    }

    /**
     * 生成二维码
     *
     * @param string $url
     * @param string $name
     * @return bool
     * @throws \Endroid\QrCode\Exception\InvalidWriterException
     */
    public function qrcodeQuality($url,$name){
        $path = ROOT_PATH.'public' . DS . 'upload'.DS.'quality'.DS;
        if(!file_exists($path)){
            if (!mkdir($path, 0755, true)) {
                return false;
            }
        }
        $qrCode = new \Endroid\QrCode\QrCode();
        $qrCode->setText($url);
        if(file_exists($path.$name.'.png')){
            unlink($path.$name.'.png');
        }
        $res = $qrCode->writeFile($path.$name.'.png');
        if($res){
            return true;
        }else{
            return false;
        }
    }

    /**
     * 判断岗位是否有查看质检单的权限
     *
     * @param string $position_code
     * @return bool
     * @author chaidongdong@suxuantech.cn
     */
    public function checkPosition_code($position_code){
        $positionData=controller('Setting','lib')->get_position_list(array('position_code'=>$position_code));
        if($positionData[0]['work_type']==SYSTEM_AUTH_ADMIN){
            return true;
        }else{
            $menu = db('s_menu')->where('menu_url','like','%Quality/qualityList%')->find();
            $data = db('s_position_menu')->where('position_code',$position_code)->where('menu_code','like',$menu['menu_code'])->find();
            if($data){
                return true;
            }else{
                return false;
            }
        }
    }

    /**
     * 获取质检单的所有的质检品牌
     *
     * @param string $quality_id
     * @return array
     * @author chaidongdong@suxuantech.cn
     */
    public function getQualityObjectBrand($quality_id){
        $model_SQualityObject = new SQualityObject();
        //质检对象为店面时
        $brands = $model_SQualityObject->getList(['quality_id'=>$quality_id,'object_type'=>1]);
        $data = [];
        foreach ($brands as $value){
            if(!$data[$value['brand_id']]){
                $data[$value['brand_id']] = [
                    'brandclass'=>$value['brandclass'],
                    'brand_id'=>$value['brand_id']
                ];
            }
        }
        return $data;
    }

    /**
     * 获取质检单的事业部所属门店
     *
     * @param string $quality_id
     * @param string $brand_id
     * @return array
     * @author chaidongdong@suxuantech.cn
     */
    public function getQualityObjectBrandShop($quality_id,$brand_id){
        $model_SQualityObject = new SQualityObject();
        $object_type = getZJObjectType();
        $shops = $model_SQualityObject->getList(['quality_id'=>$quality_id,'brand_id'=>$brand_id,'object_type'=>$object_type]);
        $data = [];
        foreach ($shops as $value){
            $data[] = [
                'shop_code'=>$value['shop_code'],
                'shop_name'=>$value['shop_name']
            ];
        }
        return $data;
    }

    /**
     * 获取质检的质检结果
     * @param string $object_type  质检对象类型 1店面 2部门
     * @param string $code         $object_type=1时，$code为店面shop_code,$object_type=2时，$code为部门department_id
     * @param string $quality_id
     * @return array
     * @author chaidongdong@suxuantech.cn
     */
    public function getQualityObjectShop($code,$quality_id,$object_type){
        $mode_SQualityObject = new SQualityObject();
        if($object_type==1){
            $object = $mode_SQualityObject->getOne(['shop_code'=>$code,'quality_id'=>$quality_id]);
        }elseif($object_type==2){
            $object = $mode_SQualityObject->getOne(['department_id'=>$code,'quality_id'=>$quality_id]);
        }

        if(!$object || $object['score'] != '-1'){
            $model_SQualiyuItems = new SQualityItems();
            $object_items = $model_SQualiyuItems->getList(['object_id'=>$object['id']],'quality_list_id,score,remarks');
            foreach ($object_items as $key=>$value){
                $value['remarks'] = @json_decode($value['remarks'],1);
                $object['items'][$value['quality_list_id']] = $value;
            }
            return $object;
        }else{
            return false;
        }
    }

    /**
     * 检查是否有修改质检单和质检结果的权限
     *
     * @param string $staff_id
     * @param string $quality_id
     * @return bool
     * @author chaidongdong@suxuantech.cn
     */
    public function checkEditQuality($staff_id,$quality_id){
        $model_SQuality = new SQualitys();
        if($model_SQuality->getOne(['id'=>$quality_id,'create_staff_id'=>$staff_id])){
            return true;
        }
        return false;
    }

    /**
     * 修改质检结果
     *
     * @param string $code   质检对象为1时 shop_code,2时department_id
     * @param string $quality_id
     * @param array $data
     * @return bool
     * @author chaidongdong@suxuantech.cn
     */
    public function editQualityObject($code,$quality_id,$data){
        $model_SQualityObject = new SQualityObject();

        $object_type = getZJObjectType();
        $object = $this->getQualityObjectShop($code,$quality_id,$object_type);


        if($object && $object['score'] > -1){
            if($data){
                Db::startTrans();
                $model_SQualityItems = new SQualityItems();
                $object_items = $model_SQualityItems->getList(['quality_id'=>$quality_id,'object_id'=>$object['id']]);
                $object_items_f = [];
                foreach ($object_items as $value){
                    $value['remarks'] = json_decode($value['remarks'],1);
                    $object_items_f[$value['quality_list_id']] = $value;
                }
                $score = 0;
                foreach ($data['quality'] as $key => $value){
                    $score += $value;
                    if($value || $value == '0'){
                            $update_item = [
                                'score'=>$value,
                                'remarks'=>json_encode([
                                    'a'=>$data['u'][$key],
                                    'old_score'=>$object_items_f[$key]['remarks']['old_score'],
                                    'old_remarks'=>$object_items_f[$key]['remarks']['old_remarks']
                                ])
                            ];
                            $res = $model_SQualityItems->tUpdate($update_item,['quality_id'=>$quality_id,'object_id'=>$object['id'],'quality_list_id'=>$key]);
                            if($res === false){
                                Db::rollback();
                                return false;
                            }
                    }else{
                        Db::rollback();
                        return false;
                    }
                }
                $update_object = [
                    'score'=>$score,
                    'question'=>$data['question'],
                    'tip'=>$data['tip'],
                    'reply'=>$data['reply']
                ];
                $res = $model_SQualityObject->tUpdate($update_object,['id'=>$object['id']]);
                if($res === false){
                    Db::rollback();
                    return false;
                }
                Db::commit();
                return true;
            }else{
                return false;
            }
        }else{
            return false;
        }
    }

    /**
     * 质检结果抄送
     *
     * @param string/array $staff_id
     * @param integer $quality_id
     * @param string $code    $object_type=1 为shop_code ,$object_type=1 为department_id
     * @param string $url
     * @param integer $object_type
     * @return bool
     * @author chaidongdong@suxuantech.cn
     */
    public function wxQualityResultSend($staff_id,$quality_id,$code,$url,$object_type){
        $res = $this->getSimpleResult($quality_id,$code,$object_type);
        if($res && !empty($res)){
            $data = [
                'template_id'=>OPENTM_QA,
                'url'=>$url,
                'data'=>$res
            ];
            if(is_string($staff_id)){
                $data['touser'] = $staff_id;
                $send_data['content'] = json_encode($data);
                return sendMsg($send_data);
            }
            if(is_array($staff_id)){
                foreach ($staff_id as $value){
                    $data['touser'] = $value;
                    $send_data['content'] = json_encode($data);
                    $res = sendMsg($send_data);
                    if(!$res){
                        return $res;
                    }
                }
            }
            return true;
        }
        return false;
    }

    /**
     * 获取质检简要结果用于抄送
     *
     * @param integer $quality_id
     * @param string $code          $object_type=1 为shop_code ,$object_type=1 为department_id
     * @param string $object_type   质检对象 1店面2部门
     * @return array
     * @author chaidongdong@suxuantech.cn
     */
    public function getSimpleResult($quality_id,$code,$object_type){
        $model_SQualityObject = new SQualityObject();
        $model_SQualitys = new SQualitys();
        $data = [];
        $quality = $model_SQualitys->getOne(['id'=>$quality_id]);
        if($object_type==1){
            $object = $model_SQualityObject->getOne(['shop_code'=>$code,'quality_id'=>$quality_id,'object_type'=>$object_type]);
            $object_name = $object['shop_name'];
        }else{
            $object = $model_SQualityObject->getOne(['department_id'=>$code,'quality_id'=>$quality_id,'object_type'=>$object_type]);
            $object_name = $object['department_name'];
        }

        if($object && $quality){
            $data = [
                'first'=>[
                    'value'=>$quality['name'].'-质检结果',
                    'color'=>'#173177'
                ],
                'keyword1'=>[
                    'value'=>$object_name,
                    'color'=>'#173177'
                ],
                'keyword2'=>[
                    'value'=>$object['score'].'权重',
                    'color'=>'#173177'
                ],
                'keyword3'=>[
                    'value'=>'质检单-总权重：'.$quality['score'],
                    'color'=>'#173177'
                ],
                'remark'=>[
                    'value'=>'质检结果已经新鲜出炉，请查看！',
                    'color'=>'#173177'
                ]
            ];
        }
        return $data;
    }

    /**
     * 获取所有已经结束的质检单
     *
     * @param array $param
     * @return array
     * @author chaidongdong@suxuantech.cn
     */
    public function getQualityResult($param = []){
        $model_SQuality = new SQualitys();
        $filter = array_merge(['end_time'=>['s'=>'lt','v'=>date('Y-m-d H:i:s')]],$param);
        return $model_SQuality->getList($filter);
    }

    /**
     * 获取线性图数据
     *
     * @param integer $brand_id 事业部
     * @param string $code  $object_type=1时 shop_code $object_type=2时 department_id
     * @param string $type 查询类型（mouth、quarter、year）
     * @param array $time [start=>2017-10,end=>2018-11]
     * @param string $score （总权重、平均权重、百分比）amount,score,per
     * @param integer $object_type 质检对象 1店面，2部门
     * @return array
     * @author chaidongdong@suxuantech
     */
    public function getQualityLine($brand_id,$code,$type,$time,$score = 'score',$object_type){
        $start_time = $time['start'].'-1 00:00:00';
        $end_time = date('Y-m-d',strtotime($time['end'].'-1 +1 month -1 day')).' 23:59:59';
        $model_SQualityObject = new SQualityObject();
        $model_SQuality = new SQualitys();
        $qualitys = $model_SQuality->getList([
            'end_time'=>['s'=>'between','v'=>[$start_time,$end_time]],
        ],'id,start_time,end_time,score');
        $tmp_qualitys = [];
        foreach ($qualitys as $value){
            $tmp_qualitys[$value['id']] = $value;
        }
        $qualitys = $tmp_qualitys;
        if($object_type==1){
            $object_list = $model_SQualityObject->getList([
                'shop_code'=>$code,
                'object_type'=>$object_type,
                'score'=>['s'=>'gt','v'=>-1],
                'quality_id'=>[
                    's'=>'in',
                    'v'=>array_keys($qualitys)
                ]
            ]);
        }else{
            $object_list = $model_SQualityObject->getList([
                'department_id'=>$code,
                'object_type'=>$object_type,
                'score'=>['s'=>'gt','v'=>-1],
                'quality_id'=>[
                    's'=>'in',
                    'v'=>array_keys($qualitys)
                ]
            ]);
        }

        $tmp_object_list = [];
        foreach ($object_list as $value){
            $tmp_object_list[$value['quality_id']] = $value;
        }
        $object_list = $tmp_object_list;

        $time = $this->getTime($start_time,$end_time,$type);
        $data = [];
        foreach ($time as $key=>$value){
            $s = strtotime($value[0]);
            $e = strtotime($value[1]);
            if($qualitys){
                foreach ($qualitys as $k=>$v){
                    if(strtotime($v['end_time']) >= $s && strtotime($v['end_time']) < $e && $object_list[$k]){
                        $data[$key][] = $object_list[$k];
                    }else{
                        if(!isset($data[$key])){
                            $data[$key] = [];
                        }
                    }
                }
            }else{
                $data[$key] = [];
            }
        }
        $amount = [];
        $return = [];
        foreach ($data as $key => $value){
            $quality_amount_score = 0;
            foreach ($value as $v){
                $quality_amount_score += $qualitys[$v['quality_id']]['score'];
                $amount[$key]['amount'] += $v['score'];
                $amount[$key]['times'] += 1;
            }
            if($score == 'amount'){
                $return[$key]= $amount[$key]['amount'] ? $amount[$key]['amount'] : 0;
            }
            if($score == 'score'){
                $return[$key]= ceil($amount[$key]['amount']/$amount[$key]['times']);
            }
            if($score == 'per'){
                $return[$key] = round($amount[$key]['amount']/$quality_amount_score,3);
            }
        }
        return $return;
    }

    /**
     * 获取月份或者季度或者年份的时间段
     *
     * @param string $start_time 2017-10
     * @param string $end_time  2018-11
     * @param string $type (mouth,quarter,year)
     * @return array
     * @author chaidongdong@suxuantech.cn
     */
    public function getTime($start_time,$end_time,$type = 'mouth'){
        $start_time = strtotime($start_time.'-1');
        $end_time = strtotime($end_time.'-1');
        $d = array();
        switch ($type){
            case 'year':
                $j = 12;
                break;
            case 'quarter':
                $j = 3;
                 break;
            default:
                $j=1;
                break;
        }
        while ($start_time<=$end_time){
            $y = date('Y',$start_time);
            $m = date('m',$start_time);
            if($type == 'mouth'){
                $s = $y.'-'.$m.'-1 00:00:00';
                $d = date('Y-m-d', strtotime("$s +1 month -1 day")).' 23:59:59';
            }else if($type == 'quarter'){
                $s = $y.'-'.(ceil($m/3)*3-2).'-1 00:00:00';
            }else if($type == 'year'){
                $s = $y.'-1-1 00:00:00';
            }
            $d = date('Y-m-d', strtotime("$s +$j month -1 day")).' 23:59:59';
            $data[$y.$m] = [$s,$d];
            $start_time = strtotime('+'.$j.' month',$start_time);
        }
        return $data;
    }

    /**
     * 获取已经质检的所有的品牌
     *
     * @return array
     * @author chaidongdong@suxuantech.cn
     */
    public function getQualityAllBrandList(){
        $model_SQualityObject = new SQualityObject();
        return $model_SQualityObject->getList(['object_type'=>1],'brand_id,brandclass','','','','brand_id');
    }

    /**
     * 获取某个品牌下所有已经质检过的门店
     *
     * @param string $brand_id
     * @return array
     * @author chaidongdong@suxuantech.cn
     */
    public function getQualityAllShop($brand_id){
        $model_SQualityObject = new SQualityObject();
        return $model_SQualityObject->getList(['brand_id'=>$brand_id,'object_type'=>1],'shop_code,shop_name','','','','shop_code');
    }


    /**
     * 获取已经质检的所有的店面
     */
    public function getQualityAllShopList(){
        $shop = db('s_quality_object')->where('object_type',2)->field('shop_code,shop_name')->group('shop_code')->select();
        if(!$shop) $shop = [];
        return $shop;

    }

    /**
     * 获取某个品牌下所有已经质检过的门店
     *
     */
    public function getQualityAllDept($shop_code){
        $dept = db('s_quality_object')->where(['object_type'=>2,'shop_code'=>$shop_code])->field('department_id,department_name')->group('department_id')->select();
        if(!$dept) $dept = [];
        return $dept;
    }

}