<?php
/**
 * CRM 实现模块
 * CRM的基本功能实现，如客资录入，客资查询等。
 * 所有业务的真正实现全在lib目录下建controller并且访问modle等，供controller层调用
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: chaidongdong<chaidongdong@suxuantech.cn> 2018-4-23 $
 */
namespace app\kf\lib;

use app\kf\model\TQuestion;
use think\Db;
class Question{

    //题目类型
    public $question_type = ['1','2','3','4'];

    /**
     * 获取考题数据
     *
     * @param array $params 参数
     * @return array
     * @author chaidongdong@suxuantech.cn
     */
    public function getQuestions($params = []){
        $model_TQuestion = new TQuestion();
        return $model_TQuestion->getList($params);
    }

    /**
     * 获取单个考题数据
     * 
     * @param array $params 参数
     * @return array
     * @author chaidongdong@suxuantech.cn
     */
    public function getQuestionInfo($params){
        $model_TQuestion = new TQuestion();
        $data = $model_TQuestion->getOne($params);
        if($data['answer']){
            $data['answer'] = json_decode($data['answer'],true);
        }
        return $data;
    }

    /**
     * 页面获取考题列表(分页)
     *
     * @param array $params 参数
     * @return array
     * @author chaidongdong@suxuantech.cn
     */
    public function QuestionList($params = []){
        $page = $params['page'] ? $params['page'] : 1;
        $limit = intval($params['limit']) ? intval($params['limit']) : 10;
        $model_TQuestion = new TQuestion();
        if($params['key']){
            $filter = $params['key'];
            $filter = array_filter($filter);
            if($filter['question']){
                $filter['question'] = ['s'=>'like','v'=>'%'.$filter['question'].'%'];
            }
        }
        $list = $model_TQuestion->getList($filter,'*',$page,$limit);
        $count = $model_TQuestion->getCount($filter);
        if($count<1){
            return ['data'=>[], 'count'=>0];
        }else{
            return ['data'=>$list, 'count'=>$count];
        }
    }

    /**
     * 添加、修改考题
     *
     * @param array $data 数据
     * @param string &$msg 提示
     * @return bool
     * @author chaidongdong@suxuantech.cn
     */
    public function saveQuestion($data,&$msg = ''){
        if($data['question_type'] && in_array($data['question_type'], $this->question_type)){
            // if($data['question_type'] == '1'){
            //     $this->saveQuestionRadio();
            // }
            switch ($data['question_type']) {
                case '1':
                    $result = $this->formatQuestionRadio($data,$msg);
                    break;
                case '2':
                    $result = $this->formatQuestionCheckbox($data,$msg);
                    break;
                case '3':
                    $result = $this->formatQuestionBlank($data,$msg);
                    break;
                case '4':
                    $result = $this->formatQuestionAnswer($data,$msg);
                    break;
                default:
                    $msg = '问题类型不存在';
                    return false;
            }
        }else{
            $msg = '问题类型不存在';
            return false;
        }
        if($result){
            $model_TQuestion = new TQuestion();
            $result['answer'] = json_encode($result['answer']);
            if($data['id']){
                $res = $model_TQuestion->tUpdate($result,['id'=>$data['id']]);
                if($res !== false){
                    return true;
                }else{
                    $msg = '操作失败';
                    return false;
                }
            }else{
                if($model_TQuestion->tInsert($result)){
                    return true;
                }else{
                    $msg = '操作失败';
                    return false;
                }
            }
        }else{
            return false;
        }
    }

    /**
     * 格式化单选题
     *
     * @param array $data 数据
     * @param string &$msg 提示
     * @return array
     * @author chaidongdong@suxuantech.cn
     */
    public function formatQuestionRadio($data,&$msg = ''){
        $return = array(
            'question_type'=>$data['question_type'],
            'question'=>$data['question'],
            'answer'=>[
                'content'=>$data['content'],
                'answer'=>$data['answer']
            ],
            'score'=> $data['score'] ? intval($data['score']) : 0
        );
        foreach ($return['answer']['content'] as $key => $value) {
            if(!trim($value)){
                unset($return['answer']['content'][$key]);
            }
        }
        if(!$return['question_type'] || !$return['question'] || !$return['answer']['content'] || !$return['answer']['answer'] || $return['score'] == 0){
            $msg = '请填写完整';
            return false;
        }
        if(!in_array($return['answer']['answer'], array_keys($return['answer']['content']))){
            $msg = '请选择正确答案';
            return false;
        }
        return $return;
    }

    /**
     * 格式化多选题
     *
     * @param array $data 数据
     * @param string &$msg 提示
     * @return array
     * @author chaidongdong@suxuantech.cn
     */
    public function formatQuestionCheckbox($data,&$msg = ''){
        $return = [
            'question_type'=>$data['question_type'],
            'question'=>trim($data['question']),
            'answer'=>[
                'content'=>$data['content'],
                'answer'=>$data['answer']
            ],
            'score'=> $data['score'] ? intval($data['score']) : 0
        ];
        foreach ($return['answer']['content'] as $key => $value) {
            if(!trim($value)){
                unset($return['answer']['content'][$key]);
            }
        }
        if(!$return['question_type'] || !$return['question'] || !$return['answer']['content'] || !$return['answer']['answer'] || $return['score'] == 0){
            $msg = '请填写完整';
            return false;
        }
        foreach ($return['answer']['answer'] as $key => $value) {
            if(!in_array($value, array_keys($return['answer']['content']))){
                $msg = '请选择正确答案';
                return false;
            }
        }
        return $return;
    }

    /**
     * 格式化填空题
     *
     * @param array $data 数据
     * @param string &$msg 提示
     * @return array
     * @author chaidongdong@suxuantech.cn
     */
    public function formatQuestionBlank($data,&$msg = ''){
        $str = '(______)';   //填空标识符
        $return = [
            'question_type'=>$data['question_type'],
            'question'=>trim($data['question']),
            'answer'=>explode("\r\n",trim($data['answer'])), //textarea 换行分割
            'score'=> $data['score'] ? intval($data['score']) : 0
        ];
        if(!$return['question'] || !$return['answer'] || ($return['score'] == 0) || !$return['score']){
            $msg = '请填写完整';
            return false;
        }
        foreach ($return['answer'] as $key => $value) {
            if(!trim($value))
                unset($return['answer'][$key]);
        }
        $count = substr_count($return['question'], $str);
        if($count == 0){
            $msg = '请添加填空';
            return false;
        }
        if($count != count($return['answer'])){
            $msg = '答案和填空的数量不一致';
            return false;
        }
        return $return;
    }

    /**
     * 格式化简答题
     *
     * @param array $data 数据
     * @param string &$msg 提示
     * @return array
     * @author chaidongdong@suxuantech.cn
     */
    public function formatQuestionAnswer($data,&$msg = ''){
        if(!trim($data['question']) || !trim($data['answer'])){
            $msg = '请填写完整';
            return false;
        }
        $return = [
            'question_type'=>$data['question_type'],
            'question'=>trim($data['question']),
            'answer'=>@explode("\r\n",trim($data['answer'])),
            'score'=> $data['score'] ? intval($data['score']) : 0
        ];
        $return = array_filter($return);
        if(count($return) != 4){
            $msg = '请填写完整';
            return false;
        }
        return $return;
    }

    /**
     * 删除考题
     *
     * @param array $params 条件
     * @return bool
     * @author chaidongdong@suxuantech.cn
     */
    public function delQuestion($params = array()){
        $model_TQuestion = new TQuestion();
        return $model_TQuestion->tDelete($params);
    }


}