<?php

/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

namespace app\crm\lib;
use think\Controller;
use app\common\lib\redisQueue;
class RunCustomerFp extends Controller {
    // 客资id，录入id，客资所属店shop_code
    function run($id,$staff_id,$shop_code) {
        $this->log('----要分配的客资ID----:'.$id);
        // 获取录入人信息  如果是本人录入，分配给本人  符合某个工作类型
        $staffinfo = getStaffInfoById($staff_id);
        $workTypes = RECEIVE_WORK_TYPE;
        $this->log('----staffinfoName----:'.json_encode($staffinfo['staffname']));
        // 工作类型
        $staffinfo = getStaffInfoById($staff_id);
        if ($staffinfo['work_type']) {
            $type = explode(',', $staffinfo['work_type']);
            array_push($type, $staffinfo['main_work_type']);
        }else{
            $type = $staffinfo['main_work_type'];
        }
        $this->log('----type----:'.json_encode($type));
        if (is_array($type)) {
            $is_in = in_array($workTypes, $type);
        }else{
            if ($workTypes == $type) {
                $is_in = true;
            }else{
                $is_in = false;
            }
        }
        $this->log('----is_in----:'.json_encode($is_in));
        // 数据统计用数据   // 根据客资id 获取客资详情
        $cInfo = controller("crm/Customer","lib")->getCustomerInfo($id);
        $this->log('----当前要分配的客资信息----'.json_encode($cInfo));
        // 直接分配给提报人
        if ($is_in) {
            $this->log('----直接分配给提报人----');
            // 获取要分配的员工信息，执行分配动作 , 并发送消息
            // 分配  用数据
            $date = date('Y-m-d H:i:s');
            $data['sales_staff_id']	   = $staff_id;
            $data['sales_staff']	   = $staffinfo['staffname'];
            $data['sales_staff_number']= $staffinfo['staffnumber'];
            $data['fp_day']			   = $date;
            $data['is_fp']			   = 1;
            $data['jr_day']            = $date;

            // 进入数据统计队列
            $listName = 'historyDataList';
            $old = [
                'sales_staff_id'    => $cInfo['sales_staff_id'],
                'sales_staff'       => $cInfo['sales_staff'],
                'sales_staff_number'=> $cInfo['sales_staff_number'],
                'fp_day'            => $cInfo['fp_day'],
                'is_fp'             => $cInfo['is_fp'],
            ];
            $cinfo = [
                'id'     => $cInfo['id'],
                'dj_id'  => $cInfo['dj_staff_id'],
                'dj_day' => $cInfo['dj_day'],
                'sel_id' => $cInfo['sk_staff_id'],
                'sel_day'=> $cInfo['sk_time'],
                'jr_id'  => $staff_id,
                'jr_day' => $date,
            ];
            $messageH = array(
                'type'      => 1,
                'staff_id'  => $staff_id,
                'identity'  => 'sale',
                'cinfo'     => $cinfo,
                'old_data'  => $old,
                'new_data'  => $data,
                'controller'=> 'Customer',
                'action'    => 'addCustomer',
            );

            // 开启事务
            db()->startTrans();
            try {
                db('c_customerinfo')->where('id', $id)->update($data);
                // $resM = sendSystemMessage($messageD);
                $resH = push_list($listName, $messageH);

                db()->commit();
                $this->log('分配提报人成功：'.$id);
                return true;
            } catch (Exception $e) {
                $this->log('分配提报人保存数据库失败：'.$id);
                db()->rollback();
                return false;
            }
        }else{ // 按规则分配
            // 根据客资id 获取客资详情
            $this->log('----开始按规则分配客资----');
            // $this->log('rulesFP:'.$id);
            $shopCode = $shop_code;
            $cid = $id;
            // $this->log('当前客资shopcode:'.$shopCode.';CID：'.$cid);
            $this->log('shopcode:'.$shopCode.'-----;----CID---:'.$cid);
            // 获取规则及规则下的员工集合
            $staffs = controller("crm/Customer","lib")->getFpRuleStaffs($shopCode);
            $this->log('规则及符合规则的员工集合===>'.  json_encode($staffs));
            // $this->log('staffs:'.json_encode($staffs));
            foreach ($staffs as $key => $value) {
                $rid = $value['id'];
                $members= $value['member'];
                // 离线是否分配  1：分配
                $not_online_is_fp = db_config('not_online_is_fp_'.$shop_code);
                if ($not_online_is_fp == 1) {
                    $member = $members;
                }else{
                    $member = controller("crm/Customer","lib")->getMemberOnline($members);
                    $this->log('规则id：'.$rid.'----在线员工==>'.json_encode($member));
                }
                unset($members);
                $num = count($member);
                if ($num<=0) {
                    continue;
                }
                $useThisRule = false;
                // 渠道深挖客资专用（^_^）
                if($value['customer_condition'] == 'add_organize'){
                    $valArr = explode('-', $value['customer_value']);
                    $type = strtolower($valArr[0]);// shop department staff
                    $val  = str_replace($type.'-', '', $value['customer_value']);
                    switch ($type) {
                        case 'shop':
                            $this->log('shop('.$cInfo['add_shop_code'].'==>'.$val.')');
                            if($cInfo['add_shop_code'] == $val ){
                                $useThisRule = true;
                            }
                            break;
                        case 'department':
                            $this->log('department('.$cInfo['customer_channel_id'].'==>'.$val.')');
                            if ($cInfo['customer_channel_id'] == $val ){
                                $useThisRule = true;
                            }
                            break;
                        case 'staff':
                            $this->log('staff('.$cInfo['dj_staff_id'].'==>'.$val.')');
                            if ($cInfo['dj_staff_id'] == $val ){
                                $useThisRule = true;
                            }
                            break;
                        default:
                            $this->log('不支持该分配方式：'.$value['customer_value']);
                            break;
                    }
                    
                }
                // 分配依据，地区，来源，渠道等
                $cusCondition = ['customer_area','customer_channel','customer_cource','customer_region'];
                if (in_array($value['customer_condition'], $cusCondition) && $cInfo[$value['customer_condition']] == $value['customer_value']) {
                    $useThisRule = true;
                    $this->log('rule('.$value['customer_condition'].'==>'.$value['customer_value'].')');
                }

                // 默认规则
                if ($value['customer_condition'] == "default") {
                    $useThisRule = true;
                    $this->log('default--rule.');
                }

                if ($useThisRule) {
                    $this->log('useThisRule is true!!!'.$value['id']);
                    // 条件分配
                    if ($value['allocationtype'] == 1) {
                        $res = controller("crm/Customer","lib")->fpCustomerT($cid, $rid, $member);
                        $this->log('条件分配结果：'.json_encode($res));
                        $this->log('规则id：'.$rid.'===>接收人:'.json_encode($res));
                        // var_dump($res);
                    }else{ // 平均分配
                        $res = controller("crm/Customer","lib")->fpCustomerP($cid, $rid, $member);
                         $this->log('平均分配结果：'.json_encode($res));
                         $this->log('规则id：'.$rid.'===>接收人:'.json_encode($res));
                        // var_dump($res);
                    }
                    if ($res['sales_staff_id']) {
                        break;
                    }else{
                        continue;
                    }
                }
            }
            
            // 如果存在可分配的员工
            $time = time();
            if ($res['sales_staff_id']) {
                $this->log('------开始分配动作------');
                // 获取要分配的员工信息，执行分配动作 , 并发送消息
                // 分配  用数据  mark
                $date = date('Y-m-d H:i:s');
                $data['sales_staff_id']	    = $res['sales_staff_id'];
                $data['sales_staff']		= $res['sales_staff'];
                $data['sales_staff_number'] = $res['sales_staff_number'];
                $data['fp_day']			    = $date;
                $data['is_fp']			    = 3;

                // 消息  用数据  //send_type:'消息类型:1:短消息(弹窗)；2：通知',
                $operation = array(
                    [
                        'button'=>'接收',
                        'url'=>'/crm/customer/customerReceive.html?cid='.$cid.'&',
                    ],
                    [
                        'button'=>'放弃',
                        'url'=>'/crm/Customer/customerDrop.html?cid='.$cid.'&',
                    ],
                );
                $operation = json_encode($operation);
                $message['send_type']      = 1;
                $message['send_title']     = '系统消息';
                $message['send_msg']       = '您收到一笔新客资，姓名：'.$cInfo['customer_name'].'，请查收。';
                $message['customer_id']    = $cid;
                $message['receive_id']     = $res['sales_staff_id'];
                $message['receive_name']   = $res['sales_staff'];
                $message['receive_status'] = 0;
                $message['operation_type'] = 1;
                $message['operation']      = $operation;
                $this->log('message:'.json_encode($message));
                // include 'application/crm/common.php';
                $timeOut = db_config('fp_timeout_'.$shop_code);
                $timeOut = $timeOut ? $timeOut : 60;
                $message['time_out']       = $timeOut;
                $this->log('timeOut:'.$timeOut);

                // 发送微信模板消息
                // 向上一级发信息  微信
                $overTime = date('Y-m-d H:i:s', ($time+$timeOut));
                $wxConfirmUrl = config('url_domain_root').'/crm/weixin/receiveCustomer/cid/'.$cid;
                $sex = $cInfo['customer_sex']?'('.$cInfo['customer_sex'].')':'';
                $content = [
                    'touser'       => $res['sales_staff_id'],
                    'template_id'  => OPENTM_FP,
                    'url'          => $wxConfirmUrl,
                    'data'         => [
                        'first'=>[
                            'value'=> '您好，您有一笔新客资啦，快去追踪吧！',
                            'color'=> '#173177'
                        ],
                        'keyword1'=>[
                            'value'=> $cInfo['customer_name'].' '.$sex,
                            'color'=> '#173177'
                        ],
                        'keyword2'=>[
                            'value'=> $cInfo['customer_tel'],
                            'color'=> '#173177'
                        ],
                        'keyword3'=>[
                            'value'=> '系统分配',
                            'color'=> '#173177'
                        ],
                        'keyword4'=>[
                            'value'=> $overTime,
                            'color'=> '#173177'
                        ],
                        'remark'=>[
                            'value'=> '请尽快接收，谢谢',
                            'color'=> '#173177'
                        ]
                    ]
                ];
                $send_data['content'] = json_encode($content);
                $res = sendMsg($send_data);
                $this->log('----发送微信模板消息:'.json_encode($res));
                // 开启事务
                db()->startTrans();
                try {
                    $data['fp_time_out'] = $time+$timeOut;
                    db('c_customerinfo')->where('id', $cid)->update($data);
                    // db('c_message')->insert($message);
                    $res = sendSystemMessage($message);
                    $this->log('发送消息:'.$res);
                    db()->commit();
                    // 发消息
                    // $message['id'] = db()->getLastInsID;
                    // redisQueue::init()->publish($channel, $message);
                    // $this->log('发送消息:'.json_encode($message));
                    // $this->log('message:'.json_encode($message));
                    
                    // 根据customer_id,查c_fp_pool 如果存在，删除
                    $fpCustomer = db('c_fp_pool')->where('cid', $cid)->find();
                    if ($fpCustomer) {
                        $res = db('c_fp_pool')->where('cid',$cid)->delete();
                        $this->log('lins:'.$res);
                    }

                    // 记日志
                    $old = [
                        'sales_staff_id'    => $cInfo['sales_staff_id'],
                        'sales_staff'       => $cInfo['sales_staff'],
                        'sales_staff_number'=> $cInfo['sales_staff_number'],
                        'fp_day'            => $cInfo['fp_day'],
                        'is_fp'             => $cInfo['is_fp'],
                    ];
                    history_log($data, $old, $cid, '-1', 'system','crm','Customer','fpCustomer');
                    return true;
                } catch (\Exception $e) {
                    $this->log('database-operation-error:'.json_encode($e->getTraceAsString()));
                    // $this->log('数据库操作失败:'.  json_encode($e->getTraceAsString()));
                    db()->rollback();
                    return false;
                }
                // return true;
            }else{
                $this->log('------没有可以分配的人------');
                // 根据customer_id,查c_fp_pool
                    // 如果存在，count+1，fp_time_out=(count*5*60)+time()
                    // 如果没有，insert into c_fp_pool
                    // 如果count>=10，修改状态，分配失败
                $fpCustomer = db('c_fp_pool')->where('cid', $cid)->find();
                // $this->log('fp_pool_sql:--->'.db()->getLastSql());
                if ($fpCustomer) {
                    $this->log('------分配池中存在该客资，cid：'.$cid);
                    if ($fpCustomer['count'] >= 10) {
                        // 分配失败
                        $upData = [
                            'is_fp'              => FP_STATUS_FALSE,
                            'sales_staff'        => null,
                            'sales_staff_id'     => null,
                            'sales_staff_number' => null,
                        ];
                        $res = db('c_customerinfo')->where('id', $cid)->update($upData);
                        // $this->log('update_customerInfo:--->'.db()->getLastSql());
                        $this->log('分配重试次数超过10次，标记分配失败，更新结果:'.($res?'sucess':'false'));
                    }else{
                        $upInPool['count'] = $fpCustomer['count']+1;
                        $upInPool['fp_time_out'] = ($fpCustomer['count']*300)+$time;
                        db('c_fp_pool')->where('cid', $cid)->update($upInPool);
                        // $this->log('update_fp_pool:--->'.db()->getLastSql());
                        $fpCount = $fpCustomer['count'];
                        $this->log('分配失败，信息在待处理内已有此客资:'.$cid.'累计重试次数：'.$upInPool['count']);
                    }
                }else{
                    $this->log('------分配池中--不--存在该客资，cid：'.$cid);
                    // $this->log('<----insert_fp_pool---->');
                    $pool_msg =[
                        'receive'  => '-1',
                        'body'     => $cid,
                        'staff_id' => $staff_id,
                        'shop_code'=> $shop_code
                    ];
                    $inPool = [
                        'cid'         => $cid,
                        'msg'         => json_encode($pool_msg),
                        'fp_time_out' => $time+300,
                        'create_time' => date('Y-m-d H:i:s'),
                        'count'       => 1,
                    ];
                    $poolRes = db('c_fp_pool')->insert($inPool);
                    if($poolRes){
                        $this->log('分配失败，信息存入客资待处理:'.$cid.'下次处理时间：'.date('Y-m-d H:i:s',$time+300));
                    }else{
                        $this->log('分配失败，信息存入待处表失败，失败SQL:'.db()->getLastSql());
                    }
                }
                // $this->log('分配失败，保存失败状态:'.($res?'成功':'失败' ));
                // $this->log('fp-error:'.($res?'sucess':'false'));
                return true;
            }
        }        
    }
    function log($str){
        if(config('app_debug')){
            echo date('Y-m-d H:i:s').$str."\r\n";
        }
    }

}  