<?php

/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

namespace app\crm\lib;
use think\Controller;
use app\common\lib\redisQueue;
use PHPExcel_IOFactory;
use Excel5;
use PHPExcel;
class RunExcelImport extends Controller {

    public function cus_import($data){
    	$customer = [];
        $fail_array =[];
        $this->log('begin--eid-'.$data['eid']);

        $file_url=$data['file_url'];
        if(!$file_url){
            $fileData=db('c_excel_import')->where('id',$data['eid'])->find();
            $file_url=$fileData['file_url'];
        }

        if(empty($file_url)){
            $this->log('没有获取到文件地址');
            return false;
        }
        $this->log('准备读取文件');
        $objReader =\PHPExcel_IOFactory::createReader('Excel2007');
        $obj_PHPExcel =$objReader->load($file_url, $encode = 'utf-8');  //加载文件内容,编码utf-8
        $excel_array=$obj_PHPExcel->getsheet(0)->toArray();   //转换为数组格式
        $first=reset($excel_array);
        array_shift($excel_array);
        $all_number=count($excel_array);
        $this->log('总数据量'.$all_number);
        //$this->log('读取到文件');
        if(!$excel_array){
            $this->log('没有读取到文件数据');
            return false;
        }

        $title=import_header();//标准表头格式
        $header=array();
        foreach($title as $key => $val){
            foreach($first as $k => $v){
                if($first[$k]==$title[$key]){
                    $header[$key]=$k;
                }
            }
        }

        $now_xh_num=1;//当前foreach循环次数
        $num=1;//本次foreach处理成功数据条数
        $contact=array();//用于文件数据中排重的联系方式
        foreach($excel_array as $k=>$v) {

            $import=cache('import_excel_'.$data['eid']);//处理到第几行（从0开始）
            if($import&&$k<=$import){
                continue;
            }else{
               
                $customer[$k]['customer_name']     = addslashes($v[$header['customer_name']]);
                $customer[$k]['customer_sex']      = addslashes($v[$header['customer_sex']]);
                $customer[$k]['customer_tel']      = addslashes($v[$header['customer_tel']]);
                $customer[$k]['customer_wechat']   = addslashes($v[$header['customer_wechat']]);
                $customer[$k]['customer_qq']        = addslashes($v[$header['customer_qq']]);
                $customer[$k]['customer_weibo']    = addslashes($v[$header['customer_weibo']]);
                $customer[$k]['province']           = addslashes($v[$header['province']]);
                $customer[$k]['city']                = addslashes($v[$header['city']]);
                $customer[$k]['county']              = addslashes($v[$header['county']]);
                $customer[$k]['customer_address']  = addslashes($v[$header['customer_address']]);
                $customer[$k]['customer_type']      = addslashes($v[$header['customer_type']]);
                $customer[$k]['customer_channel']  = addslashes($v[$header['customer_channel']]);
                $customer[$k]['access_model']       = addslashes($v[$header['access_model']]);
                $customer[$k]['consultation_type'] = addslashes($v[$header['consultation_type']]);
                $customer[$k]['customer_cource']    = addslashes($v[$header['customer_cource']]);
                $customer[$k]['customer_area']      = addslashes($v[$header['customer_area']]);
                $customer[$k]['customer_intention'] = addslashes($v[$header['customer_intention']]);
                $customer[$k]['consulation_shop']   = addslashes($v[$header['consulation_shop']]);
                $customer[$k]['customer_orderaddress'] = addslashes($v[$header['customer_orderaddress']]);
                $customer[$k]['sales_staff']        = addslashes($v[$header['sales_staff']]);
                //$customer[$k]['customer_region'] = addslashes($v[$header['customer_region']]);

                if(empty($fileData)){
                    $fileData=db('c_excel_import')->where('id',$data['eid'])->find();
                }
                if(!$customer[$k]){
                    unset($customer[$k]);
                    if($k==count($excel_array)-1){
                        $this->last_import($all_number,$customer,$fail_array,$fileData,$data,$contact);
                        return false;
                    }else{
                        continue;
                    }
                }
                if(empty($customer[$k]['customer_channel'])){
                    //$this->log('第'.$now_xh_num.'次循环，第'.$num.'条，没有‘来源渠道’。----文件第'.$k.'行');
                    $customer[$k]['error']='没有填写来源渠道';
                    array_push($fail_array,$customer[$k]);
                    unset($customer[$k]);
                    if($k==count($excel_array)-1){
                        $this->last_import($all_number,$customer,$fail_array,$fileData,$data,$contact);
                        return false;
                    }else{
                        continue;
                    }
                }

                if(empty($customer[$k]['consultation_type'])){
                    //$this->log('第'.$now_xh_num.'次循环，第'.$num.'条，没有‘消费类型’。----文件第'.$k.'行');
                    $customer[$k]['error']='没有填写消费类型';
                    array_push($fail_array,$customer[$k]);
                    unset($customer[$k]);
                    if($k==count($excel_array)-1){
                        $this->last_import($all_number,$customer,$fail_array,$fileData,$data,$contact);
                        return false;
                    }else{
                        continue;
                    }
                }

                if(empty($customer[$k]['access_model'])){
                    //$this->log('第'.$now_xh_num.'次循环，第'.$num.'条，没有‘获取方式’。----文件第'.$k.'行');
                    $customer[$k]['error']='没有填写获取方式';
                    array_push($fail_array,$customer[$k]);
                    unset($customer[$k]);
                    if($k==count($excel_array)-1){
                        $this->last_import($all_number,$customer,$fail_array,$fileData,$data,$contact);
                        return false;
                    }else{
                        continue;
                    }
                }

                if($customer[$k]['customer_wechat']||$customer[$k]['customer_qq']||$customer[$k]['customer_tel']){
                    //手机号存在
                    if(!empty($customer[$k]['customer_tel'])){
                        if(!preg_match("/^1[3|4|5|7|8][0-9]{9}$/", $customer[$k]['customer_tel'])){//手机号格式
                            //$this->log('第'.$now_xh_num.'次循环，第'.$num.'条，手机号格式错误。----文件第'.$k.'行');
                            $customer[$k]['error']='手机号格式错误';
                            array_push($fail_array,$customer[$k]);
                            unset($customer[$k]);
                            if($k==count($excel_array)-1){
                                $this->last_import($all_number,$customer,$fail_array,$fileData,$data,$contact);
                                return false;
                            }else{
                                continue;
                            }
                        }else{
                            if(in_array($customer[$k]['customer_tel'],$contact)){
                                //$this->log('第'.$now_xh_num.'次循环，第'.$num.'条，文件中手机号重复。----文件第'.$k.'行');
                                $customer[$k]['error']='此条客资已重复';
                                array_push($fail_array,$customer[$k]);
                                unset($customer[$k]);
                                if($k==count($excel_array)-1){
                                    $this->last_import($all_number,$customer,$fail_array,$fileData,$data,$contact);
                                    return false;
                                }else{
                                    continue;
                                }
                            }
                        }
                    }

                    if(!empty($customer[$k]['customer_wechat'])){
                        if(preg_match('/[\x{4e00}-\x{9fa5}]/u',$customer[$k]['customer_wechat'])>0){
                            //$this->log('第'.$now_xh_num.'次循环，第'.$num.'条，微信格式错误。----文件第'.$k.'行');
                            $customer[$k]['error']='微信号输入错误';
                            array_push($fail_array,$customer[$k]);
                            unset($customer[$k]);
                            if($k==count($excel_array)-1){
                                $this->last_import($all_number,$customer,$fail_array,$fileData,$data,$contact);
                                return false;
                            }else{
                                continue;
                            }
                        }else{
                            if(in_array($customer[$k]['customer_wechat'],$contact)){
                                //$this->log('第'.$now_xh_num.'次循环，第'.$num.'条，文件中微信重复。----文件第'.$k.'行');
                                $customer[$k]['error']='此条客资已重复';
                                array_push($fail_array,$customer[$k]);
                                unset($customer[$k]);
                                if($k==count($excel_array)-1){
                                    $this->last_import($all_number,$customer,$fail_array,$fileData,$data,$contact);
                                    return false;
                                }else{
                                    continue;
                                }
                            }
                        }
                    }

                    if(!empty($customer[$k]['customer_qq'])){
                        if(preg_match('/[\x{4e00}-\x{9fa5}]/u', $customer[$k]['customer_qq'])>0){
                            //$this->log('第'.$now_xh_num.'次循环，第'.$num.'条，qq格式错误。----文件第'.$k.'行');
                            $customer[$k]['error']='QQ号输入错误';
                            array_push($fail_array,$customer[$k]);
                            unset($customer[$k]);
                            if($k==count($excel_array)-1){
                                $this->last_import($all_number,$customer,$fail_array,$fileData,$data,$contact);
                                return false;
                            }else{
                                continue;
                            }
                        }else{
                            if(in_array($customer[$k]['customer_qq'],$contact)){
                                //$this->log('第'.$now_xh_num.'次循环，第'.$num.'条，文件中qq重复。----文件第'.$k.'行');
                                $customer[$k]['error']='此条客资已重复';
                                array_push($fail_array,$customer[$k]);
                                unset($customer[$k]);
                                if($k==count($excel_array)-1){
                                    $this->last_import($all_number,$customer,$fail_array,$fileData,$data,$contact);
                                    return false;
                                }else{
                                    continue;
                                }
                            }
                        }
                    }

                    $arr=controller('crm/Customer','lib')->isRepeat($data['staff']['brandclass'],$customer[$k]['customer_tel'],$customer[$k]['customer_wechat'],$customer[$k]['customer_qq']);
                    $this->log(json_encode($arr));
                    if($arr){
                        //$this->log('第'.$now_xh_num.'次循环，第'.$num.'条，数据库中已经存在此联系方式。----文件第'.$k.'行');
                        $customer[$k]['error']='系统内已存在此客资';
                        array_push($fail_array,$customer[$k]);
                        unset($customer[$k]);
                        if($k==count($excel_array)-1){
                            $this->last_import($all_number,$customer,$fail_array,$fileData,$data,$contact);
                            return false;
                        }else{
                            continue;
                        }
                    }else{

                        $conditions=array();
                        if($customer[$k]['customer_channel'])    $conditions['customer_channel']=$customer[$k]['customer_channel'];
                        if($customer[$k]['consultation_type'])   $conditions['consultation_type']=$customer[$k]['consultation_type'];
                        if($customer[$k]['access_model'])         $conditions['access_model']=$customer[$k]['access_model'];
                        if($customer[$k]['customer_cource'])     $conditions['customer_cource']=$customer[$k]['customer_cource'];
                        if($customer[$k]['customer_intention'])  $conditions['customer_intention']=$customer[$k]['customer_intention'];
                        if($customer[$k]['customer_area'])        $conditions['customer_area']=$customer[$k]['customer_area'];
                        //if($customer[$k]['customer_region'])      $conditions['customer_region']=$customer[$k]['customer_region'];
                        if($customer[$k]['customer_orderaddress'])  $conditions['customer_orderaddress']=$customer[$k]['customer_orderaddress'];
                        if($customer[$k]['consulation_shop'])     $conditions['consulation_shop']=$customer[$k]['consulation_shop'];
                        if($customer[$k]['province'])              $conditions['province']=$customer[$k]['province'];
                        if($customer[$k]['city'])                   $conditions['city']=$customer[$k]['city'];
                        if($customer[$k]['county'])                 $conditions['county']=$customer[$k]['county'];
                        if($customer[$k]['sales_staff'])           $conditions['sales_staff']=$customer[$k]['sales_staff'];

                        $all_id=controller('crm/Customer','lib')->get_set_id($conditions,$data['staff']['add_shop_code'],$data['staff']['shop_code']);
                        $this->log(json_encode($all_id));
                        if(!empty($all_id)){

                            if($customer[$k]['customer_channel']&&empty($all_id['customer_channel_id'])){
                                $customer[$k]['error']='客户渠道填写有误';
                                array_push($fail_array,$customer[$k]);
                                unset($customer[$k]);
                                if($k==count($excel_array)-1){
                                    $this->last_import($all_number,$customer,$fail_array,$fileData,$data,$contact);
                                    return false;
                                }else{
                                    continue;
                                }
                            }
                            if($customer[$k]['consultation_type']&&empty($all_id['consultation_type_id'])){
                                $customer[$k]['error']='消费类型填写有误';
                                array_push($fail_array,$customer[$k]);
                                unset($customer[$k]);
                                if($k==count($excel_array)-1){
                                    $this->last_import($all_number,$customer,$fail_array,$fileData,$data,$contact);
                                    return false;
                                }else{
                                    continue;
                                }
                            }
                            if($customer[$k]['access_model']&&empty($all_id['access_model_id'])){
                                $customer[$k]['error']='获取方式填写有误';
                                array_push($fail_array,$customer[$k]);
                                unset($customer[$k]);
                                if($k==count($excel_array)-1){
                                    $this->last_import($all_number,$customer,$fail_array,$fileData,$data,$contact);
                                    return false;
                                }else{
                                    continue;
                                }
                            }
                            if($customer[$k]['customer_cource']&&empty($all_id['customer_cource_id'])){
                                $customer[$k]['error']='客户来源填写有误';
                                array_push($fail_array,$customer[$k]);
                                unset($customer[$k]);
                                if($k==count($excel_array)-1){
                                    $this->last_import($all_number,$customer,$fail_array,$fileData,$data,$contact);
                                    return false;
                                }else{
                                    continue;
                                }
                            }
                            if($customer[$k]['customer_intention']&&empty($all_id['customer_intention_id'])){
                                $customer[$k]['error']='客户意向填写有误';
                                array_push($fail_array,$customer[$k]);
                                unset($customer[$k]);
                                if($k==count($excel_array)-1){
                                    $this->last_import($all_number,$customer,$fail_array,$fileData,$data,$contact);
                                    return false;
                                }else{
                                    continue;
                                }
                            }
                            if($customer[$k]['customer_area']&&empty($all_id['customer_area_id'])){
                                $customer[$k]['error']='客户分区填写有误';
                                array_push($fail_array,$customer[$k]);
                                unset($customer[$k]);
                                if($k==count($excel_array)-1){
                                    $this->last_import($all_number,$customer,$fail_array,$fileData,$data,$contact);
                                    return false;
                                }else{
                                    continue;
                                }
                            }
//                            if($customer[$k]['customer_region']&&empty($all_id['customer_region_id'])){
//                                $customer[$k]['error']='客户地域填写有误';
//                                array_push($fail_array,$customer[$k]);
//                                unset($customer[$k]);
//                                if($k==count($excel_array)-1){
//                                    $this->last_import($all_number,$customer,$fail_array,$fileData,$data,$contact);
//                                    return false;
//                                }else{
//                                    continue;
//                                }
//                            }
                            if($customer[$k]['customer_orderaddress']&&empty($all_id['customer_orderaddress_id'])){
                                $customer[$k]['error']='接单点填写有误';
                                array_push($fail_array,$customer[$k]);
                                unset($customer[$k]);
                                if($k==count($excel_array)-1){
                                    $this->last_import($all_number,$customer,$fail_array,$fileData,$data,$contact);
                                    return false;
                                }else{
                                    continue;
                                }
                            }
                            if($customer[$k]['consulation_shop']&&empty($all_id['consulation_shop_code'])){
                                $customer[$k]['error']='意向店面填写有误';
                                array_push($fail_array,$customer[$k]);
                                unset($customer[$k]);
                                if($k==count($excel_array)-1){
                                    $this->last_import($all_number,$customer,$fail_array,$fileData,$data,$contact);
                                    return false;
                                }else{
                                    continue;
                                }
                            }
                            if($customer[$k]['province']&&empty($all_id['province_id'])){
                                $customer[$k]['error']='省填写有误';
                                array_push($fail_array,$customer[$k]);
                                unset($customer[$k]);
                                if($k==count($excel_array)-1){
                                    $this->last_import($all_number,$customer,$fail_array,$fileData,$data,$contact);
                                    return false;
                                }else{
                                    continue;
                                }
                            }
                            if($customer[$k]['city']&&empty($all_id['city_id'])){
                                $customer[$k]['error']='市填写有误';
                                array_push($fail_array,$customer[$k]);
                                unset($customer[$k]);
                                if($k==count($excel_array)-1){
                                    $this->last_import($all_number,$customer,$fail_array,$fileData,$data,$contact);
                                    return false;
                                }else{
                                    continue;
                                }
                            }
                            if($customer[$k]['county']&&empty($all_id['county_id'])){
                                $customer[$k]['error']='区填写有误';
                                array_push($fail_array,$customer[$k]);
                                unset($customer[$k]);
                                if($k==count($excel_array)-1){
                                    $this->last_import($all_number,$customer,$fail_array,$fileData,$data,$contact);
                                    return false;
                                }else{
                                    continue;
                                }
                            }
                            if($customer[$k]['sales_staff']&&empty($all_id['sales_staff_id'])){
                                $customer[$k]['error']='追踪人填写有误';
                                array_push($fail_array,$customer[$k]);
                                unset($customer[$k]);
                                if($k==count($excel_array)-1){
                                    $this->last_import($all_number,$customer,$fail_array,$fileData,$data,$contact);
                                    return false;
                                }else{
                                    continue;
                                }
                            }

                            $customer[$k]['customer_channel_id']=$all_id['customer_channel_id'];
                            $customer[$k]['consultation_type_id']=$all_id['consultation_type_id'];
                            $customer[$k]['access_model_id']=$all_id['access_model_id'];
                            $customer[$k]['customer_cource_id']=$all_id['customer_cource_id'];
                            $customer[$k]['customer_intention_id']=$all_id['customer_intention_id'];
                            $customer[$k]['customer_area_id']=$all_id['customer_area_id'];
                            $customer[$k]['customer_orderaddress_id']=$all_id['customer_orderaddress_id'];
                            $customer[$k]['consulation_shop_code']=$all_id['consulation_shop_code'];
                            $customer[$k]['customer_region_id']=$all_id['customer_region_id'];
                            $customer[$k]['province_id']=$all_id['province_id'];
                            $customer[$k]['customer_region_id']=$all_id['customer_region_id'];
                            $customer[$k]['customer_region']=$all_id['customer_region'];
                            $customer[$k]['city_id']=$all_id['city_id'];
                            $customer[$k]['county_id']=$all_id['county_id'];
                            $customer[$k]['sales_staff_id']=$all_id['sales_staff_id'];
                            $customer[$k]['sales_staff_number']=$all_id['sales_staff_number'];

                            if ($customer[$k]['sales_staff_id']) {
                                $customer[$k]['is_fp']  = 1;

                                $customer[$k]['fp_staff']=$data['staff']['staff_name'];
                                $customer[$k]['fp_staff_id']=$data['staff']['staff_id'];
                                $customer[$k]['fp_staff_number']=$data['staff']['staff_number'];

                                $customer[$k]['fp_day'] = date('Y-m-d H:i:s');
                                $customer[$k]['jr_day'] = date('Y-m-d H:i:s');
                            }else{
                                $customer[$k]['is_fp']  = 2;
                                $customer[$k]['fp_staff']='';
                                $customer[$k]['fp_staff_id']=null;
                                $customer[$k]['fp_staff_number']='';
                                $customer[$k]['fp_day'] = null;
                                $customer[$k]['jr_day'] = null;
                            }

                        }else{
                            $customer[$k]['error']='请检查您的信息是否填写有误';
                            array_push($fail_array,$customer[$k]);
                            unset($customer[$k]);
                            if($k==count($excel_array)-1){
                                $this->last_import($all_number,$customer,$fail_array,$fileData,$data,$contact);
                                return false;
                            }else{
                                continue;
                            }
                        }

                        if(!empty($customer[$k]['customer_tel'])){
                            $customer[$k]['tel_staff_id']=$data['staff']['staff_id'];
                            $customer[$k]['tel_staff']=$data['staff']['staff_name'];
                            $customer[$k]['tel_time']=date('Y-m-d H:i:s',time());
                            $data['is_first_tel']=1;
                            array_push($contact,$customer[$k]['customer_tel']);
                        }else{
                            $customer[$k]['tel_staff_id'] = null;
                            $customer[$k]['tel_staff'] = '';
                            $customer[$k]['tel_time'] = null;

                        }
                        if(!empty($customer[$k]['customer_wechat'])){
                            $customer[$k]['wechat_staff_id']=$data['staff']['staff_id'];
                            $customer[$k]['wechat_staff']=$data['staff']['staff_name'];
                            $customer[$k]['wechat_time']=date('Y-m-d H:i:s',time());
                            $data['is_first_wechat']=1;
                            array_push($contact,$customer[$k]['customer_wechat']);
                        }else{
                            $customer[$k]['wechat_staff_id'] = null;
                            $customer[$k]['wechat_staff'] = '';
                            $customer[$k]['wechat_time'] = null;
                        }
                        if(!empty($customer[$k]['customer_qq'])){
                            $customer[$k]['qq_staff_id']=$data['staff']['staff_id'];
                            $customer[$k]['qq_staff']=$data['staff']['staff_name'];
                            $customer[$k]['qq_time']=date('Y-m-d H:i:s',time());
                            $data['is_first_qq']=1;
                            array_push($contact,$customer[$k]['customer_qq']);
                        }else{
                            $customer[$k]['qq_staff_id'] = null;
                            $customer[$k]['qq_staff'] = '';
                            $customer[$k]['qq_time'] = null;
                        }

                        //$this->log('第'.$now_xh_num.'次循环，第'.$num.'条，----文件第'.$k.'行，排重联系方式数组现在为'.json_encode($contact));

                        $customer[$k]['eid'] = replaceSpecialChar($data['eid']);
                        $customer[$k]['customer_number'] = str_shuffle(time().generate_code());
                        $customer[$k]['customer_type']='新客资'?1:2;
                        $customer[$k]['dj_day'] = date('Y-m-d H:i:s',time());
                        $customer[$k]['creator_day'] = date('Y-m-d H:i:s',time());
                        $customer[$k]['dj_staff']=$data['staff']['staff_name'];
                        $customer[$k]['dj_staff_id']=$data['staff']['staff_id'];
                        $customer[$k]['dj_staff_number']=$data['staff']['staff_number'];
                        $customer[$k]['shop_name']=$data['staff']['shop_name'];
                        $customer[$k]['shop_code']=$data['staff']['shop_code'];
                        $customer[$k]['brandclass']=$data['staff']['brandclass'];
                        $customer[$k]['brandclass_id']=$data['staff']['brandclass_id'];
                        $customer[$k]['add_shop_code']=$data['staff']['add_shop_code'];
                        $customer[$k]['add_shop_name']=$data['staff']['add_shop_name'];

                        if($fileData['is_sk']==1){
                            $sklist = controller("crm/Customer", "lib")->sklist($data['staff']['add_shop_code'].','.$data['staff']['shop_code'],24);
                            $rand = rand(0,count($sklist)-1);
                            $arr = $sklist[$rand];
                            if(!empty($arr)){
                                $customer[$k]['is_sk']=1;
                                $customer[$k]['sk_staff_id'] = $arr['id'];
                                $customer[$k]['sk_staff'] = $arr['staffname'];
                            }else{
                                $customer[$k]['is_sk']=2;
                                $customer[$k]['sk_staff_id'] = null;
                                $customer[$k]['sk_staff'] = null;
                            }
                        }
                        //$this->log('---获取客资信息over---');
                    }

                }else{
                    $this->log('第'.$now_xh_num.'次循环，第'.$num.'条，没有联系方式----文件第'.$k.'行');
                    $customer[$k]['error']='没有联系方式';
                    array_push($fail_array,$customer[$k]);
                    unset($customer[$k]);
                    if($k==count($excel_array)-1){
                        $this->last_import($all_number,$customer,$fail_array,$fileData,$data,$contact);
                        return false;
                    }else{
                        continue;
                    }

                }
                if($num>=200||$k==count($excel_array)-1){

                    //将costomer数组类数据进行入库
                    //将错误数组写入excel
                    //将excel_import表更新已处理和错误数量
                    $res=$this->doImport($all_number,$customer,$fail_array,$fileData,$data,$contact);
                    //doImport($customer,$fail_array,$fileData,$data,$contact);
                    if($res===false){
                        $this->log('导入数据执行失败');
                        return false;
                    }else{
                        unset ($customer,$contact);
                        //unset($conditions);
                        //unset($all_id);
                        //unset ($customer,$fail_array,$contact);
                        cache('import_excel_'.$data['eid'],$k);
                        $num=1;
                        $this->log('本次导入的eid----》》》'.$data['eid']);
                        if($k==count($excel_array)-1){
                            unset($all_number);
                            if(count($fail_array)>0){
                                $fail_file['fail_array']=$fail_array;
                                $fail_file['eid']=$data['eid'];
                                $fail_url=controller("crm/Customer","lib")->cusFailFile($fail_file);
                                $this->log('最后一次导入成功后生成错误文件'.$fail_url);
                            }
                            db('c_excel_import')->where(array('id'=>$data['eid']))->update(array('status'=>1,'fail_file_url'=>$fail_url));
                            $this->log('进统计队列之前的data====>>>'.json_encode($data));
                            $this->historyList($data);//数据统计队列
                            if($fileData['is_sk']!=1){
                                $this->fpList($data);//分配队列
                            }

                        }
                    }

                    $now_xh_num++;
                    continue;
                }else{
                    $num++;
                    //unset($conditions);
                    //unset($all_id);
                }
            }

        }

    }

    /*将costomer数组类数据进行入库
     *将错误数组写入excel
     * 将excel_import表更新已处理和错误数量
     * $all_number     文件总数量
     * $customer       已处理成功数据
     * $failCustomer   过滤失败数据
     * $fileData       文件信息
     * $data           队列输入的数据
     * $contact        已处理成功数据的联系方式（一维数组）
     */

    function doImport($all_number,$customer,$failCustomer,$fileData,$data,$contact){
        $contactAll=array();
        $contact=array_unique($contact);
        foreach($contact as $k =>$v){
            $contactAll[$k]['contact']=$v;
            $contactAll[$k]['brandclass']=$data['staff']['brandclass'];
        }

        db()->startTrans();//开启事务
        try{
            if(count($customer)>0){
                db('c_customerinfo')->insertAll($customer);
                db('c_customer_contact')->insertAll($contactAll);
                $this->log('====执行添加====');
                //$fileData=db('c_excel_import')->where('id',$data['eid'])->find();
                //$import_number=$fileData['import_number']+count($customer);
                $this->log('上次导入成功数'.$fileData['import_number'].'--本次导入成功-'.count($customer));
                db('c_excel_import')->where('id',$data['eid'])->setInc('import_number',count($customer));//新增成功数据量
                db('c_excel_import')->where(array('id'=>$data['eid']))->update(array('status'=>2,'all_number'=>$all_number,'fail_number'=>count($failCustomer)));
            }else{
                if(count($failCustomer)>0){
                    db('c_excel_import')->where(array('id'=>$data['eid']))->update(array('status'=>2,'all_number'=>$all_number,'fail_number'=>count($failCustomer)));
                }
            }
            //db('c_excel_import')->where('id',$eid)->inc(array('import_number'=>count($customer),'fail_number'=>count($failCustomer)))->update(array('status'=>2));

            db()->commit();
            return true;
        }catch (\Exception $e){
            db()->rollback();
            db('c_excel_import')->where(array('id'=>$data['eid']))->update(array('status'=>3));
            return false;
        }
    }

    /*最后一次循环入库后，生成错误文件 改变文件状态
      * $all_number     文件总数量
     * $customer       已处理成功数据
     * $fail_array   过滤失败数据
     * $fileData       文件信息
     * $data           队列输入的数据
     * $contact        已处理成功数据的联系方式（一维数组）
     */
    function last_import($all_number,$customer,$fail_array,$fileData,$data,$contact){
        $this->log("***最后一次入库方法，最后一条是错误信息时，走这里的逻辑");
        $res=$this->doImport($all_number,$customer,$fail_array,$fileData,$data,$contact);

        //unset($conditions);
        //unset($all_id);
        if($res===false){
            $this->log('导入数据执行失败');
            return false;
        }else{
            unset ($customer,$contact,$all_number);
            //cache('import_excel_'.$data['eid'],null);
            if(count($fail_array)>0){
                $fail_file['fail_array']=$fail_array;
                $fail_file['eid']=$fileData['id'];
                $fail_url=controller("crm/Customer","lib")->cusFailFile($fail_file);
            }
            $this->log('生成错误文件'.$fail_url);
            db('c_excel_import')->where(array('id'=>$fileData['id']))->update(array('status'=>1,'fail_file_url'=>$fail_url));

            $this->historyList($data);//数据统计队列
            if($fileData['is_sk']!=1){
                $this->fpList($data);//分配队列
            }

            return false;
        }
        return false;
    }

    //分配队列
    function fpList($data){
        $sysconfig = db_config('fp_switch_'.$data['staff']['shop_code']);
                if($sysconfig==1){
                    // 系统分配队列
                    $this->log('start fpCustomerList');
                    $listName_fp = 'fpCustomerList';
                    $message_fp['type']=2;
                    $message_fp['eid']=$data['eid'];
                    $message_fp['receive'] = '-1';
                    $message_fp['body']    = '';
                    $message_fp['staff_id']= $data['staff']['staff_id'];
                    $message_fp['shop_code']= $data['staff']['shop_code'];
                    $this->log('导入的客资进入分配队列---->'.json_encode($message_fp));
                    push_list($listName_fp, $message_fp);
                    $this->log('push fpcustomerlist over....');
                }
    }

    //数据统计
    function historyList($data){
        // 数据统计队列
        $listName= 'historyDataList';
        $cinfo   = [];
        $message = array(
            // 数据统计类型（1：单条；2：批量导入）
            'type'       => 2,
            // 批量导入的客资的eid
            'eid'        => $data['eid'],
            'staff_id'   => $data['staff']['staff_id'],
            'identity'   => 'record',
            'cinfo'      => $cinfo,
            'old_data'   => array(),
            'new_data'   => $data,
            'controller' => 'Customer',
            'action'     => 'addCustomer',
        );
        push_list($listName,$message);
    }


    function log($str){
        if(config('app_debug')){
            echo date('Y-m-d H:i:s').$str."\r\n";
        }
    }








    //        $this->log('out-of-foreach');
//        if(count($customer)>0){
//            db()->startTrans();//开启事务
//            try {
//                db('c_customerinfo')->insertAll($customer);
//                if(count($fail_array)>0){
//                    $this->log('Record fail array data.');
//                    $fail_file['fail_array']=$fail_array;
//                    $fail_file['eid']=$data['id'];
//                    $fail_url=controller("crm/Customer","lib")->cusFailFile($fail_file);
//                    $status=db('c_excel_import')->where(array('id'=>$data['id']))->update(array('status'=>1,'import_number'=>count($customer),'fail_number'=>count($fail_array),'fail_file_url'=>$fail_url));
//                }else{
//                    db('c_excel_import')->where(array('id'=>$data['id']))->update(array('status'=>1,'import_number'=>count($customer),'fail_number'=>count($fail_array)));
//
//                }
//                $this->log('start HistoryList');
//                // 数据统计队列
//                $listName= 'historyDataList';
//                $cinfo   = [];
//                $message = array(
//                    // 数据统计类型（1：单条；2：批量导入）
//                    'type'       => 2,
//                    // 批量导入的客资的eid
//                    'eid'        => $data['id'],
//                    'staff_id'   => $data['staff']['staff_id'],
//                    'identity'   => 'record',
//                    'cinfo'      => $cinfo,
//                    'old_data'   => array(),
//                    'new_data'   => $data,
//                    'controller' => 'Customer',
//                    'action'     => 'addCustomer',
//                );
//                push_list($listName,$message);
//                $this->log('push list HistoryList over..');
//
//
//                $sysconfig = db_config('fp_switch_'.$data['staff']['shop_code']);
//                if($sysconfig==1){
//                    // 系统分配队列
//                    $this->log('start fpCustomerList');
//                    $listName_fp = 'fpCustomerList';
//                    $message_fp['type']=2;
//                    $message_fp['eid']=$data['id'];
//                    $message_fp['receive'] = '-1';
//                    $message_fp['body']    = '';
//                    $message_fp['staff_id']= $data['staff']['staff_id'];
//                    $message_fp['shop_code']= $data['staff']['shop_code'];
//                    push_list($listName_fp, $message_fp);
//                    $this->log('push fpcustomerlist over....');
//                }


//                db()->commit();
//            } catch (\Exception $e) {
//                db()->rollback();
//                db('c_excel_import')->where(array('id'=>$data['id']))->update(array('status'=>2,'import_number'=>'0','fail_number'=>count($data['data'])));
//            }
//
//        }else{
//            $excel=db('c_excel_import')->where(array('id'=>$data['id']))->update(array('status'=>1,'import_number'=>'0','fail_number'=>count($fail_array)));
//        }

}  