<?php
/**
 * 设定用函数
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: wzy<wangzhenya@suxuantech.cn> 2017-10-27 $
 */
namespace app\kf\lib;
use think\Controller;
use think\Exception;

class Setting extends Controller{
    //获取品牌列表
    function getBrandList(){
        return db('CBrandclass')->order('id desc')->select();
    }
    //获取店面列表
    function getShopList($id = 0,$shop_name = ''){
        if($id){
            $result = db('CShopset')->where('id','<>',$id)->order('id desc')->select();
        }else{
            if($shop_name){
                $result = db('CShopset')->where('shop_name',''%'.','%'.$shop_name.'%')->order('id desc')->select();
            }else{
                $result = db('CShopset')->order('id desc')->select();
            }
        }
        return $result;
    }
    function  getShopListByFP(){
        $result = db('CShopset')->order('id desc')->select();
        return $result;
    }
    //获取店面列表
    function getShopListCount($id = 0,$shop_name = ''){
        if($id){
            $result = db('CShopset')->where('id','<>',$id)->order('id desc')->count();
        }else{
            if($shop_name){
                $result = db('CShopset')->where('shop_name','like','%'.$shop_name.'%')->order('id desc')->count();
            }else{
                $result = db('CShopset')->order('id desc')->count();
            }
        }
        return $result;
    }
    //获取店面列表接口
    function getStoreJson($shop_name = ''){
        $result['code'] = 0;
        $result['msg'] = '';
        if($shop_name){
            $result['count'] = db('CShopset')->where('shop_code',session('shop_code'))->where('shop_name','like','%'.$shop_name.'%')->field('id,brandclass,shop_name,shop_code,sn,numberorder,shopaddress,receiv_shop_code')->order('id desc')->count();
            $result['data'] = db('CShopset')->where('shop_code',session('shop_code'))->where('shop_name','like','%'.$shop_name.'%')->order('id desc')->select();
        }else{
            $result['count'] = db('CShopset')->order('id desc')->count();
            $result['data'] = db('CShopset')->field('id,brandclass,shop_name,shop_code,sn,numberorder,shopaddress,receiv_shop_code')->order('id desc')->select();
        }
        return(($result)) ;
    }
    function setStore($params){
        $db = db('CShopset');
        $db->insert($params);
        $id = $db->getLastInsID();
        $db->startTrans();
        if($id){
            action_log($params,'',session(['staff_id']),0,session(['staff_name']));
            $db->commit();
            return $id;
        }else{
            $db->rollback();
            $res = array('error'=>1,'code'=>400,'msg'=>'店面设置有误！');
            return $res;
        }
    }

    function editGoal($id){
        $res = db('SKpiStaffgoal')->where('id',$id)->find();
        return $res;
    }
    //岗位列表
    function get_position_list($data)
    {
            $url = '5a0b96b65c111';
            $res = sx_call($url, $data);
            if ($res['code'] == 200) {
                return $res['data'];
            } else {
                return false;
            }
    }

    //品牌列表
    function brandclass_list($data)
    {
            $url = "5a44c4782c1b6";
            $res = sx_call($url, $data);
            if ($res['code'] == 200) {
                $info = $res['data'];
                return $info;
            }
    }

    //查询品牌信息
    function selectBrandclass($data = []){
        $url = '5a38840b15ba9';
        $res = sx_call($url, $data);
        if ($res['code'] == 200) {
            $info = $res['data'];
            return $info;
        }
    }

    //店面
    function get_shop($data){
        $url="5a005e0038270";
        $res=sx_call($url,$data);
        if($res['code']==200){
            $info=$res['data'];
        }
        return $info;
    }

    //工作类型
    function get_workType_list($data){
        $url = '5ae01abbbc263';
        $res = sx_call($url, $data);
        if ($res['code'] == 200) {
            return $res['data'];
        } else {
            return false;
        }
    }

    //部门列表
    function department_list($data){
        $url = '5a0aef152b750';
        $res = sx_call($url,$data);
        if($res['code'] == 200){
            return $res['data'];
        }else{
            return false;
        }
    }

    //岗位
    public function get_position($data){
        $url = '5a0b96b65c111';
        $res = sx_call($url,$data);
        if($res['code'] == 200){
            return $res['data'];
        }else{
            return false;
        }
    }

    //人员
    function get_staff($data){
        $url="5a01766b4a3dd";
        $res=sx_call($url,$data);
        if($res['code']==200){
            $info=$res['data'];
        }
        return $info;
    }

    //部门列表
    function get_department_list(){
        // $res = db('SDepartmentinfo')->where('gradeType',4)->where('shop_code',session('shop_code'))->field('id,department_name')->select();
        $url = '5a0aef152b750';
        $res = sx_call($url,array('shop_code'=>session('shop_code')));
        if($res['code'] == 200){
            return $res['data'];
        }else{
            return false;
        }
    }
    function getStaffList(){
        $url = '59ff2d5de2cb6';
        return sx_call($url,'');
    }
    function getGroupList(){
        $res = db('CStaffGroup')->where('shop_code',session('shop_code'))->select();
        return $res;
    }
    function getdepartment(){
        $url = '5a0aef152b750';
        return sx_call($url,array('shop_code'=>session('shop_code')));
    }
    function getposition(){
        $url = '5a0b96b65c111';
        return sx_call($url,array('shop_code'=>session('shop_code')));
    }



    //菜单数据列表
    function getMenuList(){
        $data = db('SMenu')->order('sort asc')->select();
        $res=formatTree(listToTree($data));
        if($res){
            return $res;
        }else{
            return false;
        }
    }

    //查询菜单数据
    function getMenuJSON($param){
        $page = $param['page'] ? $param['page'] : 1;
        $limit = $param['limit'] ? $param['limit'] : 10;
        $result['code'] = 0;
        $result['msg'] = '';
        $res = db('SMenu')->where('menu_name','like','%'.$param['menu_name'].'%')
            ->order('sort asc')
            // ->page($page,$limit)
            ->select();
        $count = db('SMenu')->where('menu_name','like','%'.$param['menu_name'].'%')->count();
        if($res){
            $result['data'] = formatTree(listToTree($res));
            $result['count'] = $count;
        }else{
            $result['data'] = array();
        }
        return ($result);
    }

    //功能菜单增加
    function addMenu($param){
        if($param['id']){
            $res = db('SMenu')->where('id',$param['id'])->update($param);
            if($res===false){
                $this->error('失败', '/');
            }else{
                action_log($param,'',session(['staff_id']),0,session(['staff_name']));
                cache('KF_menu_*',null);
                cache('KF_menuAll',null);
                cache('KF_menuAllS',null);
                $this->success('成功', '/');
            }
        }else{
            $param['menu_code']='menu'.time();
            $res=db('SMenu')->insert($param);
            $id = db('SMenu')->getLastInsID();
            if(!$id){
                $this->error('失败', '/');
            }else{
                action_log($param,'',session(['staff_id']),0,session(['staff_name']));
                cache('KF_menu_*',null);
                cache('KF_menuAll',null);
                cache('KF_menuAllS',null);
                $this->success('成功', '/');
            }
        }

    }


    //功能菜单删除
    function delMenu($id){
        $data=db('SMenu')->where('fid',$id)->find();
        if($data){
            $this->error('此菜单存在子菜单，请清空子菜单再操作', '/');
        }else{
            $res = db('SMenu')->where('id',$id)->delete();
            if($res===false){
                $this->error('功能删除失败', '/');
            }else{
                action_log($id,'',session(['staff_id']),0,session(['staff_name']));
                cache('KF_menu_*',null);
                cache('KF_menuAll',null);
                cache('KF_menuAllS',null);
                $this->success('功能删除成功', '/');
            }
        }

    }


    //权限设定页面
    function getPermissionJSON(){
        $permission=db('SMenu')->select();
        foreach($permission as $k => $v){
            $permission[$k]['text']=$v['menu_name'];
        }
        $fid=0;
        $res=treeData($permission,$fid);
        echo json_encode($res);
    }



    //授权
    public function authorise($params){

        //检验所授予权限是否在自己所拥有权限内
        if(!check_right('menu1512029925')){
            $this->error('您没有权限，不可给岗位授权','/');
        }
        $positionData=controller('Setting','lib')->get_position_list(array('position_code'=>$params['position_code']));
        if($positionData[0]['work_type']==SYSTEM_AUTH_ADMIN){
            $this->error('此岗位为系统管理员，请不要修改此权限','/');
        }

        $auth=getAuth($type='auth');
        $menuList=cache('KF_menuAll');
        foreach ($menuList as $k=>$menuInfo){
            if(!in_array($menuInfo['id'], explode(',',$params['id']))){
                unset($menuList[$k]);
            }
        }
        foreach($menuList as $k=>$v){
            //print_r($menuData[$v['id']]['menu_name']);print_r(array_column($auth,'id'));die;
            if(!in_array($v['id'],array_column($auth,'id'))) {
                $this->error('您没有“'.$v['menu_name'].'”的权限，不能授予岗位此权限','/');
            }
        }

        $data=db('SMenu')->where('id','in',$params['id'])->select();
        if($params['position_code']){
            $detail['position_code']=$params['position_code'];
            $detail['menu_code']=implode(',',array_column($data,'menu_code'));
            if(db('s_position_menu')->where('position_code',$params['position_code'])->find()){
                $res=db('s_position_menu')->where('position_code',$params['position_code'])->update($detail);
            }else{
                $res=db('s_position_menu')->insert($detail);
            }
            if($res===false){
                $this->error('授权失败', '/');
            }else{
                action_log($params,'',session(['staff_id']),0,session(['staff_name']));
                cache('KF_menu_'.$params['position_code'],null);
                $this->success('授权成功','/');
            }
        }else{
            $this->error('不可修改自己的权限','/');
        }
    }

    //根据岗位查询其功能权限
    public function getPositionMenu($position_code){
        $positionData=controller('Setting','lib')->get_position_list(array('position_code'=>$position_code));
        if($positionData[0]['work_type']==SYSTEM_AUTH_ADMIN){
            $menu=db('s_menu')->select();
            $result['auth_admin']=1;
        }else{
            $data=db('s_position_menu')->where('position_code',$position_code)->find();
            $menu=db('s_menu')->where('menu_code','in',$data['menu_code'])->select();
        }
        $result['menu_id']=array_column($menu,'id');
        $this->success('查询成功','/',$result);
    }


    /**
     * 回访无效原因数据
     */
    function getInvalidJSON($param)
    {
        $result['code'] = 0;
        $result['msg'] = '';
        $page = $param['page'] ? $param['page'] : 1;
        $limit = $param['limit'] ? $param['limit'] : 20;
        $res = db('s_invalid_reason')->where('invalid_reason','like','%'.$param['invalid_reason'].'%')->page($page,$limit)->select();
        $count = db('s_invalid_reason')->where('invalid_reason','like','%'.$param['invalid_reason'].'%')->count();
        if($res){
            $result['data'] = $res;
            $result['count'] = $count;
        }else{
            $result['data'] = array();
        }
        return ($result);
    }

    /**
     * 回访不满原因数据
     */
    function getDiscontentJSON($param)
    {
        $result['code'] = 0;
        $result['msg'] = '';
        $page = $param['page'] ? $param['page'] : 1;
        $limit = $param['limit'] ? $param['limit'] : 20;
        $res = db('s_discontent')->where('name','like','%'.$param['name'].'%')->page($page,$limit)->select();
        $count = db('s_discontent')->where('name','like','%'.$param['name'].'%')->count();
        if($res){
            $result['data'] = $res;
            $result['count'] = $count;
        }else{
            $result['data'] = array();
        }
        return ($result);
    }

    /**
     * 客诉解决方案数据
     */
    function getSolutionJSON($param)
    {
        $result['code'] = 0;
        $result['msg'] = '';
        $page = $param['page'] ? $param['page'] : 1;
        $limit = $param['limit'] ? $param['limit'] : 20;
        $res = db('s_solution')->where('name','like','%'.$param['name'].'%')->page($page,$limit)->select();
        $count = db('s_solution')->where('name','like','%'.$param['name'].'%')->count();
        if($res){
            $result['data'] = $res;
            $result['count'] = $count;
        }else{
            $result['data'] = array();
        }
        return ($result);
    }


    /**
     * 客诉来源设定
     */
    function getSourceJSON($param)
    {
        $result['code'] = 0;
        $result['msg'] = '';
        $page = $param['page'] ? $param['page'] : 1;
        $limit = $param['limit'] ? $param['limit'] : 20;
        $res = db('s_source')->where('source_name','like','%'.$param['source_name'].'%')->page($page,$limit)->select();
        $count = db('s_source')->where('source_name','like','%'.$param['source_name'].'%')->count();
        if($res){
            $result['data'] = $res;
            $result['count'] = $count;
        }else{
            $result['data'] = array();
        }
        return ($result);
    }


    /**
     * 投诉类型设定
     */
    function getComplainJSON($param)
    {
        $result['code'] = 0;
        $result['msg'] = '';
        $page = $param['page'] ? $param['page'] : 1;
        $limit = $param['limit'] ? $param['limit'] : 20;
        $res = db('s_complain_type')
            ->where('complain_name','like','%'.$param['complain_name'].'%')
            //->page($page,$limit)
            ->select();
        $res=formatTree(listToTree($res),'','complain_name');
        $count = db('s_complain_type')->where('complain_name','like','%'.$param['complain_name'].'%')->count();
        if($res){
            $result['data'] = $res;
            $result['count'] = $count;
        }else{
            $result['data'] = array();
        }
        return ($result);
    }

    /**
     * 受理流程设定
     */
    function getManageJSON($param)
    {
        $result['code'] = 0;
        $result['msg'] = '';
        $page = $param['page'] ? $param['page'] : 1;
        $limit = $param['limit'] ? $param['limit'] : 20;
        $res = db('s_manage_process')->page($page,$limit)->order('sort asc')->select();
        $count = db('s_manage_process')->count();
        if($res){
            $result['data'] = $res;
            $result['count'] = $count;
        }else{
            $result['data'] = array();
        }
        return ($result);
    }


}