<?php
/**
 * 统计用lib
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: wangyining<wangyining@suxuantech.cn> 2017-10-27 $
 */
namespace app\kf\lib;
use think\Controller;
use PHPExcel_IOFactory;
use Excel5;
use PHPExcel;
class Statistics extends Controller{

    //导出
    function export($title,$data,$file){
        set_time_limit(0);
        $PHPExcel = new PHPExcel();
        $cacheMethod = \PHPExcel_CachedObjectStorageFactory::cache_in_memory_gzip;
        if (!\PHPExcel_Settings::setCacheStorageMethod($cacheMethod)) {
            die($cacheMethod . " 缓存方法不可用" . EOL);
        }

        $PHPSheet = $PHPExcel->getActiveSheet();
        $PHPSheet->setTitle('data1'); //给当前活动sheet设置名称
        $index = 1;
        for($i=0;$i<count($title);$i++){
            $range[$i] = $this->stringFromColumnIndex($i);

            //设置列宽
            $PHPExcel->setActiveSheetIndex(0);
            $PHPExcel->getActiveSheet()->getColumnDimension($range[$i])->setWidth(20);

            $PHPSheet->setCellValue($range[$i].$index, $title[$i]);
        }

        if(count($data)>0){
            foreach($data as $k=>$v){
                $index++;
                foreach(array_values($v) as $kk=>$vv){
                    $PHPSheet->setCellValue("{$range[$kk]}{$index}",$vv);
                }
            }
        }

        $PHPWriter = PHPExcel_IOFactory::createWriter($PHPExcel,'Excel2007');
        header('Content-type: application/vnd.ms-excel');//告诉浏览器输出07Excel文件
        header('Content-Disposition: attachment;filename='.$file);//告诉浏览器输出浏览器名称
        header("Content-Description: File Transfer");
        header('Cache-Control: max-age=0');//禁止缓存
        header("Content-Transfer-Encoding: binary"); //告诉浏览器，这是二进制文件
        $PHPWriter->save("php://output");
        exit;
    }

    //获取指定个数的excel列名称
    public function stringFromColumnIndex($pColumnIndex = 0)
    {
        static $_indexCache = array();

        if (!isset($_indexCache[$pColumnIndex])) {
            if ($pColumnIndex < 26) {
                $_indexCache[$pColumnIndex] = chr(65 + $pColumnIndex);
            } elseif ($pColumnIndex < 702) {
                $_indexCache[$pColumnIndex] = chr(64 + ($pColumnIndex / 26)) . chr(65 + $pColumnIndex % 26);
            } else {
                $_indexCache[$pColumnIndex] = chr(64 + (($pColumnIndex - 26) / 676)) . chr(65 + ((($pColumnIndex - 26) % 676) / 26)) . chr(65 + $pColumnIndex % 26);
            }
        }
        return $_indexCache[$pColumnIndex];
    }


    //电访无效原因
    public function getInvalid($params){

        $sql=$this->getInvalidSql($params);
        $page = $params['page'] ? $params['page'] : 1;
        $limit = $params['limit'] ? $params['limit'] : 10;
        $result['code'] = 0;
        $result['msg'] = '';
        $res = db('k_order')->where($sql)->page($page,$limit)->select();
        $count = db('k_order')->where($sql)->count();

        if($res){
            $result['data'] = $res;
            $result['count'] = $count;
        }else{
            $result['data'] = array();
        }
        return ($result);
    }

    public function getInvalidSql($params){

        $sql = " 1=1 ";
        $end_time=$params['end_time'];
        if (!empty($params)) {
            if($params['brand_id'])     $sql .= " and brand_id = '" . $params['brand_id'] . "' ";
            if($params['shop_code'])    $sql .= " and shop_code = '" . $params['shop_code'] . "' ";
            if($params['start_time'])   $sql .= " and order_time >= '".$params['start_time']."' ";
            if($params['end_time'])     $sql .= " and order_time < '".date("Y-m-d",strtotime("$end_time +1 day"))."' ";
        }

        $sql .= " and is_valid = 3 ";
        return $sql;
    }

    /*
    *事业部每月客诉汇总数据（12月）
    */
    public function ksEveryMonth($params){
        $source = db('s_source')->select();
        $complain = db('s_complain_type')->where('fid',0)->select();

        $sql = 'SELECT MONTH(create_time) as dateTime,';
        foreach($source as $k => $v){
            $sql .= 'sum(if(source_id = '.$v['id'].', 1, 0)) AS source_'.$v['id'].',';
        }
//        foreach($complain as $kk => $vv){
//            $sql .= 'sum(if(complain_id = '.$vv['id'].', 1, 0)) AS complain_'.$vv['id'].',';
//        }

        $complainAll = db('s_complain_type')->order('create_time')->select();
        $complainTree =listToTree($complainAll);

        foreach($complainTree as $key => $val){
            if($val['_child']){
                $sql .= 'sum(if(';
                $childSql = '';
                foreach($val['_child'] as $kk => $vv){
                    if($childSql){
                        $childSql .= ' or complain_id = '.$vv['id'];
                    }else{
                        $childSql .= 'complain_id = '.$vv['id'];
                    }
                }
                $sql .= $childSql.',1,0)) AS complain_'.$val['id'].',';
            }
        }

        $sql .= 'sum(if(ks_expend = 1, 1, 0)) AS ks_expend_1,
             sum(if(ks_expend = 2, 1, 0)) AS ks_expend_2,
             sum(if(ks_expend = 3, 1, 0)) AS ks_expend_3,
             sum(if(second_visit_staff_id is not null and is_over = 1, 1, 0)) AS content_1,
             sum(if(second_visit_staff_id is not null and is_over = 2, 1, 0)) AS content_2,
             COUNT(1) AS countNumber
             FROM k_work_order ';
        if($params['brand_id']){
            $sql .= ' where brand_id ='.$params['brand_id'];
        }

        $count = db()->query($sql);
        $count[0]['dateTime'] = '汇总';
        $sql .= ' GROUP BY MONTH(create_time)';
        $data = db()->query($sql);
        $data[] = $count[0];
        if($data){
            $result['data'] = $data;
            $result['count'] = count($data);
        }else{
            $result['data'] = array();
        }
        $result['msg']   = '';
        $result['code']  = 0;
        return $result;

    }

    /*
     *导出事业部每月客诉汇总数据（12月）
     * data  数据
     * brandclass  事业部名称
     */
    public function exportKsEveryMonth($data,$brandclass){
        set_time_limit(0);
        $PHPExcel = new PHPExcel();
        $PHPExcel->getProperties()->setCreator("Maarten Balliauw")
            ->setLastModifiedBy("Maarten Balliauw")
            ->setTitle("Office 2007 XLSX Document")
            ->setSubject("Office 2007 XLSX Document")
            ->setDescription("Test document for Office 2007 XLSX, generated using PHP classes.")
            ->setKeywords("office 2007 openxml php")
            ->setCategory("Test result file");
        $cacheMethod = \PHPExcel_CachedObjectStorageFactory::cache_in_memory_gzip;
        if (!\PHPExcel_Settings::setCacheStorageMethod($cacheMethod)) {
            die($cacheMethod . " 缓存方法不可用" . EOL);
        }

        //合并单元格  标题
        $source = db('s_source')->select();
        $countSource = count($source);
        $complain = db('s_complain_type')->where('fid',0)->select();
        $countComplain = count($complain);
        $rowCount = $countSource + $countComplain +7;
        $rowNum = $this->stringFromColumnIndex($rowCount);
        $PHPExcel->getActiveSheet()->mergeCells('A1:'.$rowNum.'1');      //合并
        $PHPExcel->getActiveSheet()->setCellValue('A1',$brandclass. '事业部客诉汇总数据');
        $PHPExcel->setActiveSheetIndex(0)->getstyle('A1')->getAlignment()->setHorizontal(\PHPExcel_style_Alignment::HORIZONTAL_CENTER);

        $PHPSheet = $PHPExcel->getActiveSheet();
        $PHPSheet->setTitle('ksEveryMonth'); //给当前活动sheet设置名称

        //$PHPExcel->getActiveSheet()->setCellValue('A2','月份');
        $PHPExcel->getActiveSheet()->mergeCells('A2:A3');

//        $firstTitle = ['月份','投诉来源','投诉分类','投诉支出','二次满意度'];
//        $title1 = 2;
//        for($i=0;$i<count($firstTitle);$i++){
//            $range[$i] = $this->stringFromColumnIndex($i);
//            $PHPSheet->setCellValue($range[$i].$title1, $firstTitle[$i]);
//        }
        $PHPExcel->getActiveSheet()->setCellValue('A2','月份');
        $PHPExcel->setActiveSheetIndex(0)->getstyle('A2')->getAlignment()->setHorizontal(\PHPExcel_style_Alignment::HORIZONTAL_CENTER);

        //合并来源
        $sourceHB = $this->stringFromColumnIndex($countSource);
        $PHPExcel->getActiveSheet()->mergeCells('B2:'.$sourceHB.'2');
        $PHPExcel->getActiveSheet()->setCellValue('B2','投诉来源');
        $PHPExcel->setActiveSheetIndex(0)->getstyle('B2')->getAlignment()->setHorizontal(\PHPExcel_style_Alignment::HORIZONTAL_CENTER);
        //合并投诉类型
        $complainStart = $this->stringFromColumnIndex(1 + $countSource);
        $complainHB = $this->stringFromColumnIndex($countSource + $countComplain);
        $PHPExcel->getActiveSheet()->mergeCells($complainStart.'2:'.$complainHB.'2');
        $PHPExcel->getActiveSheet()->setCellValue($complainStart.'2','投诉分类');
        $PHPExcel->setActiveSheetIndex(0)->getstyle($complainStart.'2')->getAlignment()->setHorizontal(\PHPExcel_style_Alignment::HORIZONTAL_CENTER);

        //合并投诉支出
        $expendStart = $this->stringFromColumnIndex(1 + $countSource + $countComplain);
        $expendHB = $this->stringFromColumnIndex($countSource + $countComplain + 3);
        $PHPExcel->getActiveSheet()->mergeCells($expendStart.'2:'.$expendHB.'2');
        $PHPExcel->getActiveSheet()->setCellValue($expendStart.'2','投诉支出');
        $PHPExcel->setActiveSheetIndex(0)->getstyle($expendStart.'2')->getAlignment()->setHorizontal(\PHPExcel_style_Alignment::HORIZONTAL_CENTER);

        //合并满意度
        $contentStart = $this->stringFromColumnIndex(1 + $countSource + $countComplain + 3);
        $contentHB = $this->stringFromColumnIndex($countSource + $countComplain + 3 + 2);
        $PHPExcel->getActiveSheet()->mergeCells($contentStart.'2:'.$contentHB.'2');
        $PHPExcel->getActiveSheet()->setCellValue($contentStart.'2','二次满意度');
        $PHPExcel->setActiveSheetIndex(0)->getstyle($contentStart.'2')->getAlignment()->setHorizontal(\PHPExcel_style_Alignment::HORIZONTAL_CENTER);

        //合并 合计（上下合并）
        $hjHB = $this->stringFromColumnIndex($countSource + $countComplain + 3 + 2 + 1);
        $PHPExcel->getActiveSheet()->setCellValue($hjHB.'2','合计（月）');
        $PHPExcel->getActiveSheet()->mergeCells($hjHB.'2:'.$hjHB.'3');
        $PHPExcel->setActiveSheetIndex(0)->getstyle($hjHB.'2')->getAlignment()->setHorizontal(\PHPExcel_style_Alignment::HORIZONTAL_CENTER);

        $secondTitle = array_merge(array_column($source,'source_name'),array_column($complain,'complain_name'));
        array_push($secondTitle,'无成本解决');
        array_push($secondTitle,'异业赠品解决');
        array_push($secondTitle,'自有产品解决');
        array_push($secondTitle,'满意');
        array_push($secondTitle,'不满意');

        $title2 = 3;
        for($i=0;$i<count($secondTitle);$i++){
            $range[$i+1] = $this->stringFromColumnIndex($i+1);
            $PHPSheet->setCellValue($range[$i+1].$title2, $secondTitle[$i]);
        }
        //print_r($data);die;
        if(count($data)>0){
            foreach($data as $k=>$v){
                $v['dateTime'] = $v['dateTime'].'月份';
                $title2++;
                foreach(array_values($v) as $kk=>$vv){
                    $ranges[$kk] = $this->stringFromColumnIndex($kk);
                    $PHPSheet->setCellValue($ranges[$kk].$title2, $vv);
                    //$PHPSheet->setCellValue("{$range[$kk]}{$title2}",$vv);
                }
            }
        }
        $PHPWriter = PHPExcel_IOFactory::createWriter($PHPExcel,'Excel2007');
        //header("Content-type:text/html;charset=utf-8");
        header('Content-type: application/vnd.ms-excel');//告诉浏览器输出07Excel文件
        header('Content-Disposition: attachment;filename='.$brandclass. '事业部客诉汇总数据.xlsx');//告诉浏览器输出浏览器名称
        header("Content-Description: File Transfer");
        header('Cache-Control: max-age=0');//禁止缓存
        header("Content-Transfer-Encoding: binary"); //告诉浏览器，这是二进制文件
        $PHPWriter->save("php://output");
        exit;
    }


    /*
     * 客诉责任分类（12个月)
     */
    public function ksDutyClassify(){
        $source = db('s_source')->select();
        $complainAll = db('s_complain_type')->order('create_time')->select();
        $complainTree =listToTree($complainAll);
        $secondComplain = [];
        foreach($complainTree as $k => $v){
            $secondComplain = array_merge($secondComplain,$v['_child']);
        }

        $departmentAll = db('k_work_order')->where('department_name is not null and department_name <> ""')->group('department_name')->select();
        $department = array_values(array_unique(explode(',',trim(implode(',',array_column($departmentAll,'department_name')),','))));
        $sql = 'SELECT MONTH(create_time) as dateTime,';
        foreach($department as $k => $v){
            $sql .= 'sum(if(FIND_IN_SET("'.$v.'",department_name), 1, 0)) AS department_'.$k.',';
        }
        foreach($source as $k => $v){
            $sql .= 'sum(if(source_id = '.$v['id'].', 1, 0)) AS source_'.$v['id'].',';
        }
        foreach($secondComplain as $kk => $vv){
            $sql .= 'sum(if(FIND_IN_SET("'.$vv['id'].'",complain_id), 1, 0)) AS complain_'.$vv['id'].',';
        }

        $sql .= '
         COUNT(1) AS countNumber
         FROM k_work_order ';

        $count = db()->query($sql);
        $count[0]['dateTime'] = '汇总';
        $sql .= ' GROUP BY MONTH(create_time)';
        $data = db()->query($sql);
        $data[] = $count[0];
        if($data){
            $result['data'] = $data;
            $result['count'] = count($data);
        }else{
            $result['data'] = array();
        }
        $result['msg']   = '';
        $result['code']  = 0;
        return $result;

    }

    /*
    *导出客诉分类（12月）
    * data  数据
    *
    */
    public function exportKsDuty($data){
        set_time_limit(0);
        $PHPExcel = new PHPExcel();
        $PHPExcel->getProperties()->setCreator("Maarten Balliauw")
            ->setLastModifiedBy("Maarten Balliauw")
            ->setTitle("Office 2007 XLSX Document")
            ->setSubject("Office 2007 XLSX Document")
            ->setDescription("Test document for Office 2007 XLSX, generated using PHP classes.")
            ->setKeywords("office 2007 openxml php")
            ->setCategory("Test result file");
        $cacheMethod = \PHPExcel_CachedObjectStorageFactory::cache_in_memory_gzip;
        if (!\PHPExcel_Settings::setCacheStorageMethod($cacheMethod)) {
            die($cacheMethod . " 缓存方法不可用" . EOL);
        }
        //合并单元格
        $departmentAll = db('k_work_order')->where('department_name is not null and department_name <> ""')->group('department_name')->select();
        $department = array_values(array_unique(explode(',',trim(implode(',',array_column($departmentAll,'department_name')),','))));
        $countDepartment = count($department);
        $source = db('s_source')->select();
        $countSource = count($source);
        //投诉类型
        $complainAll = db('s_complain_type')->order('create_time')->select();
        $complainTree = listToTree($complainAll);
        $secondComplain = [];//二级
        foreach($complainTree as $k => $v){
            $secondComplain = array_merge($secondComplain,$v['_child']);
        }
        $countComplain = count($secondComplain);//二级个数 表格列数

        $rowCount = $countDepartment+$countSource + $countComplain +2;
        $rowNum = $this->stringFromColumnIndex($rowCount);
        $PHPExcel->getActiveSheet()->mergeCells('A1:'.$rowNum.'1');      //合并
        $PHPExcel->getActiveSheet()->setCellValue('A1', '客诉问题记录汇总分类表 ');
        $PHPExcel->setActiveSheetIndex(0)->getstyle('A1')->getAlignment()->setHorizontal(\PHPExcel_style_Alignment::HORIZONTAL_CENTER);

        $PHPSheet = $PHPExcel->getActiveSheet();
        $PHPSheet->setTitle('ksEveryMonth'); //给当前活动sheet设置名称

        $PHPExcel->getActiveSheet()->mergeCells('A2:A4');
        $PHPExcel->getActiveSheet()->setCellValue('A2','月份');
        $PHPExcel->setActiveSheetIndex(0)->getstyle('A2')->getAlignment()->setHorizontal(\PHPExcel_style_Alignment::HORIZONTAL_CENTER);

        //合并部门
        $departmentHB = $this->stringFromColumnIndex($countDepartment);
        $PHPExcel->getActiveSheet()->mergeCells('B2:'.$departmentHB.'2');
        $PHPExcel->getActiveSheet()->setCellValue('B2','部门');
        $PHPExcel->setActiveSheetIndex(0)->getstyle('B2')->getAlignment()->setHorizontal(\PHPExcel_style_Alignment::HORIZONTAL_CENTER);
        //合并来源
        $sourceStar = $this->stringFromColumnIndex(1 + $countDepartment);
        $sourceHB = $this->stringFromColumnIndex($countDepartment + $countSource);
        $PHPExcel->getActiveSheet()->mergeCells($sourceStar.'2:'.$sourceHB.'2');
        $PHPExcel->getActiveSheet()->setCellValue($sourceStar.'2','投诉来源');
        $PHPExcel->setActiveSheetIndex(0)->getstyle($sourceStar.'2')->getAlignment()->setHorizontal(\PHPExcel_style_Alignment::HORIZONTAL_CENTER);
        //合并投诉类型
        $complainStart = $this->stringFromColumnIndex(1 + $countDepartment + $countSource);
        $complainHB = $this->stringFromColumnIndex($countDepartment + $countSource + $countComplain);
        $PHPExcel->getActiveSheet()->mergeCells($complainStart.'2:'.$complainHB.'2');
        $PHPExcel->getActiveSheet()->setCellValue($complainStart.'2','投诉分类');
        $PHPExcel->setActiveSheetIndex(0)->getstyle($complainStart.'2')->getAlignment()->setHorizontal(\PHPExcel_style_Alignment::HORIZONTAL_CENTER);

        //合并 合计（上下合并）
        $hjHB = $this->stringFromColumnIndex($countDepartment + $countSource + $countComplain + 1);
        $PHPExcel->getActiveSheet()->setCellValue($hjHB.'2','合计（月）');
        $PHPExcel->getActiveSheet()->mergeCells($hjHB.'2:'.$hjHB.'4');
        $PHPExcel->setActiveSheetIndex(0)->getstyle($hjHB.'2')->getAlignment()->setHorizontal(\PHPExcel_style_Alignment::HORIZONTAL_CENTER);

        $secondTitle = array_merge($department,array_column($source,'source_name'));
        //$secondTitle = array_merge($secondTitle,array_column($complainTree,'complain_name'));

        for($i=0;$i<count($secondTitle);$i++){
            $range[$i+1] = $this->stringFromColumnIndex($i+1);
            $PHPExcel->getActiveSheet()->mergeCells($range[$i+1].'3:'.$range[$i+1].'4');
            $PHPSheet->setCellValue($range[$i+1].'3', $secondTitle[$i]);
        }

        $line = count($secondTitle);
        for($i=0;$i<count($complainTree);$i++){
            $start = $this->stringFromColumnIndex($line+1);
            $end = $this->stringFromColumnIndex($line + count($complainTree[$i]['_child']));
            if(count($complainTree[$i]['_child'])>1){
                $PHPExcel->getActiveSheet()->mergeCells($start.'3:'.$end.'3');
            }
            $PHPSheet->setCellValue($start.'3', $complainTree[$i]['complain_name']);
            $line = $line + count($complainTree[$i]['_child']);
        }

        $row = 4;
        $line2 = count($secondTitle);
        for($i=0;$i<count($secondComplain);$i++){
            $line2++;
            $range[$i] = $this->stringFromColumnIndex($line2);
            $PHPSheet->setCellValue($range[$i].$row, $secondComplain[$i]['complain_name']);
        }

        if(count($data)>0){
            foreach($data as $k=>$v){
                $v['dateTime'] = $v['dateTime'].'月份';
                $row++;
                foreach(array_values($v) as $kk=>$vv){
                    $ranges[$kk] = $this->stringFromColumnIndex($kk);
                    $PHPSheet->setCellValue($ranges[$kk].$row, $vv);
                    //$PHPSheet->setCellValue("{$range[$kk]}{$title2}",$vv);
                }
            }
        }
        $PHPWriter = PHPExcel_IOFactory::createWriter($PHPExcel,'Excel2007');
        header('Content-type: application/vnd.ms-excel');//告诉浏览器输出07Excel文件
        header('Content-Disposition: attachment;filename=客诉责任分类.xlsx');//告诉浏览器输出浏览器名称
        header("Content-Description: File Transfer");
        header('Cache-Control: max-age=0');//禁止缓存
        header("Content-Transfer-Encoding: binary"); //告诉浏览器，这是二进制文件
        $PHPWriter->save("php://output");
        exit;
    }


    /*
     * 回放对比
     * @params brand_id    事业部id
     *  @params visit_type  服务/专业
     *  @params score      超期/达到/低期
     *  @params start_time
     *  @params end_time
     */
    public function visitContrast($params){

        $brand_id  = $params['brand_id'];
        $visit_type = $params['visit_type'];
        $score      = $params['score'];
//        $brand_id =1;
//        $visit_type = 'service_score';
//        $score = 3;
        if($brand_id&&$brand_id!=0){
            $shop = controller('Setting','lib')->get_shop(['brandclass_id'=>$brand_id]);
        }

        if($visit_type&&$shop){
            $sql = 'SELECT ';
            foreach($shop as $k => $v) {
                $sql .= 'CONCAT(round(sum(shop_code = "'.$v['shop_code'].'" and '.$visit_type.' ='.$score.')/sum(shop_code = "'.$v['shop_code'].'") * 100,2),"%") AS shop_'.$v['shop_code'].',';
            }
            $sql = trim($sql,',');
            $sql .= ' FROM k_score_list ';
            $data = db()->query($sql);
            $list = [];
            $key = 0;
            foreach ($data as $k => $v) {
                foreach ($v as $kkk => $vvv) {
                    foreach($shop as $s => $sh) {
                        if ($kkk == 'shop_' . $sh['shop_code'] && substr($kkk, 5) == $sh['shop_code']) {
                            $list[$key]['shop_' . $sh['shop_code']] = empty($v['shop_' . $sh['shop_code']])?'0.00%':$v['shop_' . $sh['shop_code']];
                            $list[$key]['tq_' . $sh['shop_code']] = empty($v['tq_' . $sh['shop_code']])?'0.00%':$v['tq_' . $sh['shop_code']];
                        }
                    }
                }
                $key ++;
            }
        }


        if($list){
            return $list;
        }else{
            return array();
        }

    }

    /*
    * 导出回访对比
    */
    public function exportVisitContrast($data,$params){
        set_time_limit(0);
        $PHPExcel = new PHPExcel();
        $cacheMethod = \PHPExcel_CachedObjectStorageFactory::cache_in_memory_gzip;
        if (!\PHPExcel_Settings::setCacheStorageMethod($cacheMethod)) {
            die($cacheMethod . " 缓存方法不可用" . EOL);
        }

        $PHPSheet = $PHPExcel->getActiveSheet();
        $PHPSheet->setTitle('customer'); //给当前活动sheet设置名称

        $brand_id = $params['brand_id'];
        if($brand_id&&$brand_id!=0){
            $shop = controller('Setting','lib')->get_shop(['brandclass_id'=>$brand_id]);
            $titles = [];
            foreach($shop as $k => $v){
                $array['shop_'.$v['shop_code']] = $v['shop_name'];
                array_push($titles,$array['shop_'.$v['shop_code']]);
                $array['tq_'.$v['shop_code']] = '同期';
                array_push($titles,$array['tq_'.$v['shop_code']]);

            }

        }

        $index = 1;
        for($i=0;$i<count($titles);$i++){
            $range[$i] = $this->stringFromColumnIndex($i);
            $PHPSheet->setCellValue($range[$i].$index, $titles[$i]);
        }

        if(count($data)>0){
            foreach($data as $k=>$v){
                $index++;
                foreach(array_values($v) as $kk=>$vv){
                    $PHPSheet->setCellValue("{$range[$kk]}{$index}",$vv);
                }
            }
        }

        $PHPWriter = PHPExcel_IOFactory::createWriter($PHPExcel,'Excel2007');
        header('Content-type: application/vnd.ms-excel');//告诉浏览器输出07Excel文件
        header('Content-Disposition: attachment;filename='.$params['brandclass'].'回访（超期达到低于）对比.xlsx');//告诉浏览器输出浏览器名称
        header("Content-Description: File Transfer");
        header('Cache-Control: max-age=0');//禁止缓存
        header("Content-Transfer-Encoding: binary"); //告诉浏览器，这是二进制文件
        $PHPWriter->save("php://output");
        exit;

    }



    /* 2
     * 回访对比（超期，达到，底期同时显示）
     */
    public function visitContrast2($params){

        $brand_id = $params['brand_id'];
        $values   = $params['values'];
        $start_time = $params['visit_start_time'];
        $end_time = $params['visit_end_time'];
        $end_time = date('Y-m-d',strtotime($end_time.' +1 day'));

        if($brand_id&&$brand_id!=0){
            $shop = controller('Setting','lib')->get_shop(['brandclass_id'=>$brand_id]);
        }

        $timeSql = '';
        if($start_time){
            $timeSql .= ' and visit_time >= "'.$start_time.'"';
        }

        if($start_time){
            $timeSql .= ' and visit_time < "'.$end_time.'"';
        }

        //print_r($timeSql);die;

        if($values&&$shop){
            $sql = 'SELECT ';
            foreach($shop as $k => $v) {
                $sql .= 'sum(shop_code = "'.$v['shop_code'].'"'.$timeSql.') AS shop_'.$v['shop_code'].',
 sum(shop_code = "'.$v['shop_code'].'" and '.$values.' =3'.$timeSql.') AS 3_'.$v['shop_code'].',
 sum(shop_code = "'.$v['shop_code'].'" and '.$values.' =2'.$timeSql.') AS 2_'.$v['shop_code'].',
 sum(shop_code = "'.$v['shop_code'].'" and '.$values.' =1'.$timeSql.') AS 1_'.$v['shop_code'].',
 CONCAT(round(sum(shop_code = "'.$v['shop_code'].'" and '.$values.' =3'.$timeSql.')/sum(shop_code = "'.$v['shop_code'].'"'.$timeSql.') * 100,2),"%") AS percent_3_'.$v['shop_code'].',
 CONCAT(round(sum(shop_code = "'.$v['shop_code'].'" and '.$values.' =2'.$timeSql.')/sum(shop_code = "'.$v['shop_code'].'"'.$timeSql.') * 100,2),"%") AS percent_2_'.$v['shop_code'].',
 CONCAT(round(sum(shop_code = "'.$v['shop_code'].'" and '.$values.' =1'.$timeSql.')/sum(shop_code = "'.$v['shop_code'].'"'.$timeSql.') * 100,2),"%") AS percent_1_'.$v['shop_code'].',';
            }
            $sql = trim($sql,',');
            $sql .= ' FROM k_score_list where '.$values.' is not null and '.$values.' <> "" ';

            $data = db()->query($sql);
            $list = [];
            $key = 0;
            foreach ($data as $k => $v) {
                foreach ($v as $kkk => $vvv) {
                    foreach($shop as $s => $sh) {
                        if ($kkk == 'shop_' . $sh['shop_code'] && substr($kkk, 5) == $sh['shop_code']) {
                            $list[$key]['shop_' . $sh['shop_code']] = $v['shop_' . $sh['shop_code']];
                            $list[$key]['3_' . $sh['shop_code']] = $v['3_' . $sh['shop_code']];
                            $list[$key]['2_' . $sh['shop_code']] = $v['2_' . $sh['shop_code']];
                            $list[$key]['1_' . $sh['shop_code']] = $v['1_' . $sh['shop_code']];
                            $list[$key + 1]['shop_' . $sh['shop_code']] = '';
                            $list[$key + 1]['3_' . $sh['shop_code']] = empty($v['percent_3_' . $sh['shop_code']])?'0.00%':$v['percent_3_' . $sh['shop_code']];
                            $list[$key + 1]['2_' . $sh['shop_code']] = empty($v['percent_2_' . $sh['shop_code']])?'0.00%':$v['percent_2_' . $sh['shop_code']];
                            $list[$key + 1]['1_' . $sh['shop_code']] = empty($v['percent_1_' . $sh['shop_code']])?'0.00%':$v['percent_1_' . $sh['shop_code']];
                        }
                    }
                }
                $key = $key +2;
            }
        }

        if($list){
            return $list;
        }else{
            return array();
        }

    }

    /*
     * 导出回访对比 （超期，达到，底期同时显示）
     */
    public function exportVisitContrast2($data,$params){
        set_time_limit(0);
        $PHPExcel = new PHPExcel();
        $cacheMethod = \PHPExcel_CachedObjectStorageFactory::cache_in_memory_gzip;
        if (!\PHPExcel_Settings::setCacheStorageMethod($cacheMethod)) {
            die($cacheMethod . " 缓存方法不可用" . EOL);
        }

        $PHPSheet = $PHPExcel->getActiveSheet();
        $PHPSheet->setTitle('customer'); //给当前活动sheet设置名称

        $brand_id = $params['brand_id'];
        if($brand_id&&$brand_id!=0){
            $shop = controller('Setting','lib')->get_shop(['brandclass_id'=>$brand_id]);
            $titles = [];
            foreach($shop as $k => $v){
                $array['shop_'.$v['shop_code']] = $v['shop_name'];
                array_push($titles,$array['shop_'.$v['shop_code']]);
                $array['3_'.$v['shop_code']] = '超期';
                array_push($titles,$array['3_'.$v['shop_code']]);
                $array['2_'.$v['shop_code']] = '达到';
                array_push($titles,$array['2_'.$v['shop_code']]);
                $array['1_'.$v['shop_code']] = '低于';
                array_push($titles,$array['1_'.$v['shop_code']]);
            }

        }

        $index = 1;
        for($i=0;$i<count($titles);$i++){
            $range[$i] = $this->stringFromColumnIndex($i);
            $PHPSheet->setCellValue($range[$i].$index, $titles[$i]);
        }

        if(count($data)>0){
            foreach($data as $k=>$v){
                $index++;
                foreach(array_values($v) as $kk=>$vv){
                    $PHPSheet->setCellValue("{$range[$kk]}{$index}",$vv);
                }
            }
        }

        $PHPWriter = PHPExcel_IOFactory::createWriter($PHPExcel,'Excel2007');
        header('Content-type: application/vnd.ms-excel');//告诉浏览器输出07Excel文件
        header('Content-Disposition: attachment;filename='.$params['brandclass'].'回访（超期达到低于）对比.xlsx');//告诉浏览器输出浏览器名称
        header("Content-Description: File Transfer");
        header('Cache-Control: max-age=0');//禁止缓存
        header("Content-Transfer-Encoding: binary"); //告诉浏览器，这是二进制文件
        $PHPWriter->save("php://output");
        exit;

    }

    /* 4
     * 事业部 各部门对比
     * params visit_type   服务/专业
     * params values       3超期/2达到/1低期
     */
    public function departmentBrand($params){

        $visit_type = $params['visit_type'];
        $score = $params['score'];

        if($visit_type&&$score){
            $brand=controller('Setting','lib')->brandclass_list();
            $year = date('Y');
            $start = $year.'-01-01 00:00:00';
            $end   = $year.'-12-31 23:59:59';
            $lastYear  = date("Y", strtotime("-1 year"));
            $lastStart = $lastYear.'-01-01 00:00:00';
            $lastEnd   = $lastYear.'-12-31 23:59:59';
            ;
            $sql  = 'SELECT department_name,';
            $sql .= 'sum(visit_time > "'.$start.'" and visit_time <= "'.$end.'") AS company,
                  sum(visit_time > "'.$lastStart.'" and visit_time <= "'.$lastEnd.'") AS last_company,';
            foreach($brand as $k => $v){
                $sql .= 'sum(brand_id = '.$v['id'].' and visit_time > "'.$start.'" and visit_time <= "'.$end.'") AS brand_'.$v['id'].',
                  sum(brand_id = '.$v['id'].' and visit_time > "'.$lastStart.'" and visit_time <= "'.$lastEnd.'") AS last_brand_'.$v['id'].',';
            }
            $sql = trim($sql,',');

            $sql .= ' FROM k_score_list
               WHERE '.$visit_type.' = '.$score;

            $allData = db()->query($sql);
            $brandData = db()->query($sql.' and department_name is not null GROUP BY department_name');

            foreach($allData[0] as $k => $v){
                foreach($brandData as $brandKey => $brandValue){
                    foreach($brandValue as $key => $val){
                        if($key == $k){
                            if(is_numeric($val)){
                                $brandData[$brandKey][$key] = round($val/$v*100,2).'%';
                            }else{
                                $brandData[$brandKey][$key] = $val;
                            }
                        }
                    }
                }
            }
        }

        if($brandData){
            $result['data'] = $brandData;
            $result['count'] = count($brandData);
        }else{
            $result['data'] = array();
        }
        $result['msg']   = '';
        $result['code']  = 0;
        return $result;

    }

    /*
     * 导出 事业部各部门对比
     */
    public function exportDepartmentBrand($data,$params){
        set_time_limit(0);
        $PHPExcel = new PHPExcel();
        $PHPExcel->getProperties()->setCreator("Maarten Balliauw")
            ->setLastModifiedBy("Maarten Balliauw")
            ->setTitle("Office 2007 XLSX Document")
            ->setSubject("Office 2007 XLSX Document")
            ->setDescription("Test document for Office 2007 XLSX, generated using PHP classes.")
            ->setKeywords("office 2007 openxml php")
            ->setCategory("Test result file");
        $cacheMethod = \PHPExcel_CachedObjectStorageFactory::cache_in_memory_gzip;
        if (!\PHPExcel_Settings::setCacheStorageMethod($cacheMethod)) {
            die($cacheMethod . " 缓存方法不可用" . EOL);
        }

        if($params['visit_type']=='service_score'){
            $visit_type = '服务';
        }elseif($params['visit_type']=='professional_score'){
            $visit_type = '专业';
        }
        if($params['score']=='3'){
            $score = '超期';
        }elseif($params['score']=='2'){
            $score = '达到';
        }elseif($params['score']=='1'){
            $score = '低于';
        }
        $PHPSheet = $PHPExcel->getActiveSheet();
        $PHPSheet->setTitle('ksEveryMonth'); //给当前活动sheet设置名称

        //合并单元格  标题
        $brand=controller('Setting','lib')->brandclass_list();
        $countBrand = count($brand);
        $rowCount = $countBrand * 2 + 2;
        $rowNum = $this->stringFromColumnIndex($rowCount);
        $PHPExcel->getActiveSheet()->mergeCells('A1:'.$rowNum.'1');      //合并
        $PHPExcel->getActiveSheet()->setCellValue('A1', '1-12月事业部部门'.$visit_type.$score.'横向对比分析表');
        $PHPExcel->setActiveSheetIndex(0)->getstyle('A1')->getAlignment()->setHorizontal(\PHPExcel_style_Alignment::HORIZONTAL_CENTER);

        $PHPExcel->getActiveSheet()->mergeCells('D2:'.$rowNum.'2');      //合并
        $PHPExcel->getActiveSheet()->setCellValue('D2', '事业部'.$visit_type.$score.'对比');
        $PHPExcel->setActiveSheetIndex(0)->getstyle('D2')->getAlignment()->setHorizontal(\PHPExcel_style_Alignment::HORIZONTAL_CENTER);

        $PHPExcel->getActiveSheet()->mergeCells('A2:A4');
        $PHPExcel->getActiveSheet()->setCellValue('A2','部门');
        $PHPExcel->setActiveSheetIndex(0)->getstyle('A2')->getAlignment()->setHorizontal(\PHPExcel_style_Alignment::HORIZONTAL_CENTER);

        $PHPExcel->getActiveSheet()->mergeCells('B2:C2');
        $PHPExcel->getActiveSheet()->setCellValue('B2','集团'.$visit_type.$score);
        $PHPExcel->setActiveSheetIndex(0)->getstyle('B2')->getAlignment()->setHorizontal(\PHPExcel_style_Alignment::HORIZONTAL_CENTER);

        $PHPExcel->getActiveSheet()->mergeCells('B3:B4');
        $PHPExcel->getActiveSheet()->setCellValue('B3',$visit_type.$score);
        $PHPExcel->setActiveSheetIndex(0)->getstyle('B3')->getAlignment()->setHorizontal(\PHPExcel_style_Alignment::HORIZONTAL_CENTER);

        $PHPExcel->getActiveSheet()->mergeCells('C3:C4');
        $PHPExcel->getActiveSheet()->setCellValue('C3','去年同期');
        $PHPExcel->setActiveSheetIndex(0)->getstyle('C3')->getAlignment()->setHorizontal(\PHPExcel_style_Alignment::HORIZONTAL_CENTER);

        $num = 3;
        foreach($brand as $key => $val){
            $start = $this->stringFromColumnIndex($num);
            $end = $this->stringFromColumnIndex($num+1);
            $PHPExcel->getActiveSheet()->mergeCells($start.'3:'.$end.'3');
            $PHPExcel->getActiveSheet()->setCellValue($start.'3',$val['brandclass']);
            $num = $num + 2;
        }
        $title = [];
        foreach($brand as $k => $v){
            $title[] = '本年';
            $title[] = '同期';
        }

        for($i=0;$i<count($title);$i++){
            $range[$i] = $this->stringFromColumnIndex($i+3);
            $PHPSheet->setCellValue($range[$i].'4', $title[$i]);
        }

        $line = 4;
        if(count($data)>0){
            foreach($data as $k=>$v){
//                $v['dateTime'] = $v['dateTime'].'月份';
                $line++;
                foreach(array_values($v) as $kk=>$vv){
                    $ranges[$kk] = $this->stringFromColumnIndex($kk);
                    $PHPSheet->setCellValue($ranges[$kk].$line, $vv);
                    //$PHPSheet->setCellValue("{$range[$kk]}{$title2}",$vv);
                }
            }
        }
        $PHPWriter = PHPExcel_IOFactory::createWriter($PHPExcel,'Excel2007');
        //header("Content-type:text/html;charset=utf-8");
        header('Content-type: application/vnd.ms-excel');//告诉浏览器输出07Excel文件
        header('Content-Disposition: attachment;filename=事业部客诉汇总数据.xlsx');//告诉浏览器输出浏览器名称
        header("Content-Description: File Transfer");
        header('Cache-Control: max-age=0');//禁止缓存
        header("Content-Transfer-Encoding: binary"); //告诉浏览器，这是二进制文件
        $PHPWriter->save("php://output");
        exit;
    }

    /*
     * 回访对象数据百分比对比
     */
    public function staffVisit($params){
        $brand_id = $params['brand_id'];
        $shop_code = $params['shop_code'];
        $visit_type = $params['visit_type'];
        $order_link = $params['order_link'];

        $sql = 'select visit_object,staff_name,shop_name,
	COUNT(1) AS staff_all,
	SUM('.$visit_type.' = 3) AS score_3,
	CONCAT(round(SUM('.$visit_type.' = 3)/COUNT(1) * 100,2),"%") AS score_3_zb,
	SUM('.$visit_type.' = 2) AS score_2,
	CONCAT(round(SUM('.$visit_type.' = 2)/COUNT(1) * 100,2),"%") AS score_2_zb,
	SUM('.$visit_type.' = 1) AS score_1,
	CONCAT(round(SUM('.$visit_type.' = 1)/COUNT(1) * 100,2),"%") AS score_1_zb';

        $sql .= ' FROM k_score_list where 1 = 1 ';
        if($brand_id)      $sql .= " and brand_id = '" . $brand_id . "' ";
        if($shop_code)     $sql .= " and shop_code = '" . $shop_code . "' ";
        if($order_link)    $sql .= " and order_link = '" . $order_link . "' ";
        if($params['start_time'])      $sql .= " and visit_time >= '".$params['start_time']."' ";
        if($params['end_time']){
            $end_time = $params['end_time'];
            $sql .= " and visit_time < '".date("Y-m-d",strtotime("$end_time +1 day"))."' ";
        }
        $sql .= ' and staff_name <> "" and '.$visit_type.' is not null and '.$visit_type.' <> "" GROUP BY staff_name ORDER BY visit_object ';

        $res = db()->query($sql);
        foreach($res as $k => $v){
            $res[$k]['visit_object'] = $this->getObjectName($v['visit_object']);
        }

        if($res){
            $result['data'] = $res;
            $result['count'] = count($res);
        }else{
            $result['data'] = array();
        }
        $result['msg']   = '';
        $result['code']  = 0;

        return $result;

    }

    //根据标识获取回访对象名称
    public function getObjectName($visit_object){
        if($visit_object == 'storeconsuitant1')  $name = '销售门市';
        if($visit_object == 'storeconsuitant2')  $name = '网销门市';
        if($visit_object == 'secretaireman')     $name = '礼服秘书';
        if($visit_object == 'zhuozhuangshi')     $name = '着装师';
        if($visit_object == 'foor')                $name = '楼层调度';
        if($visit_object == 'dresser')            $name = '化妆师';
        if($visit_object == 'huazhuangzhuli')    $name = '化妆助理';
        if($visit_object == 'cameraman')     $name = '摄影师';
        if($visit_object == 'photoassistant')     $name = '摄影助理';
        if($visit_object == 'xpstaff_name') $name = '样前数码修调';
        if($visit_object == 'selectman')     $name = '选片师';
        if($visit_object == 'jxstaff')       $name = '样后数码修调师(样后精修)';
        if($visit_object == 'pbstaff')       $name = '排版';
        if($visit_object == 'tiaosestaff')  $name = '调色师';
        if($visit_object == 'kanbanshi')  $name = '校稿看版';
        if($visit_object == 'qj_renname')   $name = '取件调度';
        if($visit_object == 'storeconsuitant4')   $name = '服务人员';

        return $name;
    }

    /*
     * 回访对象数据百分比对比 导出
     */
    public function exportStaffVisit($data,$params){
        set_time_limit(0);
        $PHPExcel = new PHPExcel();
        $PHPExcel->getProperties()->setCreator("Maarten Balliauw")
            ->setLastModifiedBy("Maarten Balliauw")
            ->setTitle("Office 2007 XLSX Document")
            ->setSubject("Office 2007 XLSX Document")
            ->setDescription("Test document for Office 2007 XLSX, generated using PHP classes.")
            ->setKeywords("office 2007 openxml php")
            ->setCategory("Test result file");
        $cacheMethod = \PHPExcel_CachedObjectStorageFactory::cache_in_memory_gzip;
        if (!\PHPExcel_Settings::setCacheStorageMethod($cacheMethod)) {
            die($cacheMethod . " 缓存方法不可用" . EOL);
        }

        $title=['工作职位', '员工名称', '店面','总数','超期','超期占比','达到','达到占比','低于','低于占比'];
        //合并单元格  标题
        $rowNum = $this->stringFromColumnIndex(count($title));
        $PHPExcel->getActiveSheet()->mergeCells('A1:'.$rowNum.'1');      //合并
        $PHPExcel->getActiveSheet()->setCellValue('A1',$params['brandclass'].$params['order_link_name'].$params['visit_type_name'].'满意度回访 个人数据对比('.$params['start_time'].'——'.$params['end_time'].')');
        //当个单元格居中
        //$PHPExcel->setActiveSheetIndex(0)->getstyle('A1')->getAlignment()->setHorizontal(\PHPExcel_style_Alignment::HORIZONTAL_CENTER);
        //所有单元格居中
        $PHPExcel->getDefaultStyle()->getAlignment()->setHorizontal(\PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $PHPExcel->getDefaultStyle()->getAlignment()->setVertical(\PHPExcel_Style_Alignment::VERTICAL_CENTER);


        $PHPSheet = $PHPExcel->getActiveSheet();
        $PHPSheet->setTitle('ksEveryMonth'); //给当前活动sheet设置名称

        $index = 2;
        for($i=0;$i<count($title);$i++){
            $range[$i] = $this->stringFromColumnIndex($i);
            //设置列宽
            $PHPExcel->setActiveSheetIndex(0);
            $PHPExcel->getActiveSheet()->getColumnDimension($range[$i])->setWidth(20);

            $PHPSheet->setCellValue($range[$i].$index, $title[$i]);
        }

        if(count($data)>0){
            foreach($data as $k=>$v){
                $index++;
                foreach(array_values($v) as $kk=>$vv){
                    $PHPSheet->setCellValue("{$range[$kk]}{$index}",$vv);
                }
            }
        }

        $PHPWriter = PHPExcel_IOFactory::createWriter($PHPExcel,'Excel2007');
        header('Content-type: application/vnd.ms-excel');//告诉浏览器输出07Excel文件
        header('Content-Disposition: attachment;filename=个人数据对比.xlsx');//告诉浏览器输出浏览器名称
        header("Content-Description: File Transfer");
        header('Cache-Control: max-age=0');//禁止缓存
        header("Content-Transfer-Encoding: binary"); //告诉浏览器，这是二进制文件
        $PHPWriter->save("php://output");
        exit;
    }

    /*
    * 员工回访量对比
    * params  brand_id   事业部id
    * params order_link   订单类型
    * params start_time   开始时间
    * params end_time     结束时间
    */
    public function visitAmount($params){
        $brand_id = $params['brand_id'];
        $visit_type = $params['visit_type'];
        $order_link = $params['order_link'];

        $sql = 'select visit_staff_number,visit_staff_name,
    COUNT(1)AS all_num,
	SUM(is_valid = 1)AS valid_num,
	CONCAT(round(SUM(is_valid = 1)/COUNT(1) * 100,2),"%") AS valid_num_zb,
	SUM(is_valid = 2)AS ing_num,
	CONCAT(round(SUM(is_valid = 2)/COUNT(1) * 100,2),"%") AS ing_num_zb,
	SUM(is_valid = 3)AS invalid_num,
	CONCAT(round(SUM(is_valid = 3)/COUNT(1) * 100,2),"%") AS invalid_num_zb';

        $sql .= ' FROM k_order where 1 = 1 ';
        if($brand_id)      $sql .= " and brand_id = '" . $brand_id . "' ";
        if($order_link)    $sql .= " and order_link = '" . $order_link . "' ";
        if($params['start_time'])      $sql .= " and visit_time >= '".$params['start_time']."' ";
        if($params['end_time']){
            $end_time = $params['end_time'];
            $sql .= " and visit_time < '".date("Y-m-d",strtotime("$end_time +1 day"))."' ";
        }
        $sql .= ' GROUP BY visit_staff_id';

        $res = db()->query($sql);

        if($res){
            $result['data'] = $res;
            $result['count'] = count($res);
        }else{
            $result['data'] = array();
        }
        $result['msg']   = '';
        $result['code']  = 0;

        return $result;

    }

    /*
    * 员工回访量对比  --------------导出
    */
    public function exportVisitAmount($data,$params){
        set_time_limit(0);
        $PHPExcel = new PHPExcel();
        $PHPExcel->getProperties()->setCreator("Maarten Balliauw")
            ->setLastModifiedBy("Maarten Balliauw")
            ->setTitle("Office 2007 XLSX Document")
            ->setSubject("Office 2007 XLSX Document")
            ->setDescription("Test document for Office 2007 XLSX, generated using PHP classes.")
            ->setKeywords("office 2007 openxml php")
            ->setCategory("Test result file");
        $cacheMethod = \PHPExcel_CachedObjectStorageFactory::cache_in_memory_gzip;
        if (!\PHPExcel_Settings::setCacheStorageMethod($cacheMethod)) {
            die($cacheMethod . " 缓存方法不可用" . EOL);
        }

        $title=['员工编号', '员工名称', '总数','已完成','已完成占比','回访中','回访中占比','无效','无效占比'];
        //合并单元格  标题
        $rowNum = $this->stringFromColumnIndex(count($title)-1);
        $PHPExcel->getActiveSheet()->mergeCells('A1:'.$rowNum.'1');      //合并
        $PHPExcel->getActiveSheet()->setCellValue('A1',$params['brandclass'].$params['order_link_name'].' 员工回访数据量对比('.$params['start_time'].'——'.$params['end_time'].')');
        //所有单元格居中
        $PHPExcel->getDefaultStyle()->getAlignment()->setHorizontal(\PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $PHPExcel->getDefaultStyle()->getAlignment()->setVertical(\PHPExcel_Style_Alignment::VERTICAL_CENTER);

        $PHPSheet = $PHPExcel->getActiveSheet();
        $PHPSheet->setTitle('exportVisitAmount'); //给当前活动sheet设置名称

        $index = 2;
        for($i=0;$i<count($title);$i++){
            $range[$i] = $this->stringFromColumnIndex($i);
            //设置列宽
            $PHPExcel->setActiveSheetIndex(0);
            $PHPExcel->getActiveSheet()->getColumnDimension($range[$i])->setWidth(20);

            $PHPSheet->setCellValue($range[$i].$index, $title[$i]);
        }

        if(count($data)>0){
            foreach($data as $k=>$v){
                $index++;
                foreach(array_values($v) as $kk=>$vv){
                    $PHPSheet->setCellValue("{$range[$kk]}{$index}",$vv);
                }
            }
        }

        $PHPWriter = PHPExcel_IOFactory::createWriter($PHPExcel,'Excel2007');
        header('Content-type: application/vnd.ms-excel');//告诉浏览器输出07Excel文件
        header('Content-Disposition: attachment;filename=员工回访数据量对比.xlsx');//告诉浏览器输出浏览器名称
        header("Content-Description: File Transfer");
        header('Cache-Control: max-age=0');//禁止缓存
        header("Content-Transfer-Encoding: binary"); //告诉浏览器，这是二进制文件
        $PHPWriter->save("php://output");
        exit;
    }


    /*
     * 回访订单详情信息
     * params  brand_id   事业部id
     * params order_link   订单类型
     * params start_time   开始时间
     * params end_time     结束时间
     * params visit_type   服务、专业
     */
    public function visitOrderInfo($params){
        $brand_id = $params['brand_id'];
        $visit_type = $params['visit_type'];
        $order_link = $params['order_link'];
        //print_r($visit_type);die;
        $sql = '1=1';
        if($brand_id)      $sql .= " and brand_id = '" . $brand_id . "' ";
        if($order_link)    $sql .= " and order_link = '" . $order_link . "' ";
        if($params['start_time'])   $sql .= " and order_time >= '".$params['start_time']."' ";
        if($params['end_time']){
            $end_time = $params['end_time'];
            $sql .= " and order_time < '".date("Y-m-d",strtotime("$end_time +1 day"))."' ";
        }

        $page = $params['page'] ? $params['page'] : 1;
        $limit = $params['limit'] ? $params['limit'] : 10;

        //不同环节 字段不同
        if($order_link == 'sp'){
            $fields = 'id,orderId,order_link,order_time,mname,mphone,wname,wphone,brand_id,first_visit_time,bargain_money,supplementary_money';
        }elseif($order_link == 'qj'){
            $fields = 'id,orderId,order_link,order_time,mname,mphone,wname,wphone,brand_id';
        } else{
            $fields = 'id,orderId,order_link,order_time,mname,mphone,wname,wphone,brand_id,first_visit_time';
        }

        if($params['is_all'] == 1){
        //不分页
            $order = db('k_order')
                ->where($sql)
                ->field($fields)
                ->select();
            $count = count($order);
        }else{
            //订单信息
            $order = db('k_order')
                ->where($sql)
                ->field($fields)
                ->page($page,$limit)
                ->select();

            $count = db('k_order')
                ->where($sql)
                ->field($fields)
                ->count();
        }


        foreach($order as $k => $v){

            //选片环节展示 拍摄日期
            if($order_link == 'sp'){
                $photoData = db('k_order')->where(['orderId'=>$v['orderId'],'order_link'=>'photo'])->order('order_time desc')->find();
                $order[$k]['photo_time'] = $photoData['order_time'];
            }

            //已评分数
            //$score = db('k_score_list')->where('visit_order_id',$v['id'])->select();
            $score = db('k_score_list')->where('orderId',$v['orderId'])->select();
            $scoreData = [];
            foreach($score as $key => $val){
                $scoreData[$val['visit_object']]['staff_name'] = $val['staff_name'];
                $scoreData[$val['visit_object']]['score'] = $val[$visit_type];
            }
            //根据环节回访对象设定  对应回访对象和分数
            $linkObj = $this->getVisitObject($order_link,$visit_type);
            foreach($linkObj as $keys => $vals){
                $order[$k]['obj_'.$vals['object_code']] = $scoreData[$vals['object_code']]['staff_name'];
                $order[$k]['score_'.$vals['object_code']] = $scoreData[$vals['object_code']]['score'];
            }

            //调研问题答案
            $answer = db('k_visit_question_answer')->where('order_id',$v['id'])->where('delete_time is null')->select();
            foreach($answer as $key2 => $val2){
                $answerData[$val2['q_id']] = $val2['answer_text'];
            }
            //本环节调研问题
            $linkQuestion = $this->getLinkQuestion($order_link);
            foreach($linkQuestion as $key3 => $val3){
                $order[$k]['answer_'.$val3['id']] = $answerData[$val3['id']];
            }

            //回访备注
            $note = db('k_visit_list')->where('visit_order_id',$v['id'])->where('note <> ""')->column('note');
            foreach($note as $key => $val){
                $note[$key] = preg_replace('/<\s*img\s+[^>]*?src\s*=\s*(\'|\")(.*?)\\1[^>]*?\/?\s*>/i', '', $val);
            }

            //时间
            if($v['order_time']) $order[$k]['order_time'] = date('Y-m-d',strtotime($v['order_time']));

            $order[$k]['note'] = $note?implode('|',$note):'';
        }

        return array('code'=>0,'data'=>$order,'count'=>$count,'msg'=>'');
    }

    /*
     * 某个环节回访对象
     * order_link  回访环节
     * visit_type  专业、服务
     */
    public function getVisitObject($order_link,$visit_type){
        //本环节回访对象
        $visit_type = $visit_type=='professional_score'?'professional':'service';//专业或服务
        $visitObj = db('k_visit_link_object')
            ->where(['link'=>$order_link,'option_code'=>['like','%'.$visit_type.'%']])
            ->alias('a')
            ->join('k_visit_object b','a.object_code = b.code','left')
            ->where('b.is_show',1)
            ->order('a.id asc')
            ->select();

        $objectArray = array_column($visitObj,'object_code');

        switch($order_link){
            case'photo':
                if(!in_array('cameraman',$objectArray))        $visitObj[] = ['object_code'=>'cameraman','new_name'=>'摄影师'];
                if(!in_array('dresser',$objectArray))          $visitObj[] = ['object_code'=>'dresser','new_name'=>'化妆师'];
                if(!in_array('secretaireman',$objectArray))    $visitObj[] = ['object_code'=>'secretaireman','new_name'=>'礼服师'];
                if(!in_array('storeconsuitant1',$objectArray)) $visitObj[] = ['object_code'=>'storeconsuitant1','new_name'=>'门市销售'];
                break;
            case'qj':
                if(!in_array('storeconsuitant1',$objectArray)) $visitObj[] = ['object_code'=>'storeconsuitant1','new_name'=>'门市销售'];
                break;
        }

        return $visitObj;
    }

    /*
     * 某环节调研问题
     * order_link
     */
    public function getLinkQuestion($order_link){

        $question = db('k_visit_question')->where("FIND_IN_SET('".$order_link."',link)")->order('id asc')->select();
        return $question;

    }


    /*
     * 回访订单详情信息------------------导出
     *   data    数据
     * params  brand_id   事业部id
     * params order_link   订单类型
     * params start_time   开始时间
     * params end_time     结束时间
     * params visit_type   服务、专业
     */
    public function exportVisitOrderInfo($data,$params){
        //本环节回访对象
        $visitObj = controller('Statistics','lib')->getVisitObject($params['order_link'],$params['visit_type']);

        //本环节调研问题
        $question = controller('Statistics','lib')->getLinkQuestion($params['order_link']);

        $title['orderId'] = '单号';
        $title['mname'] = '先生';
        $title['wname'] = '女士';
        $title['mphone'] = '先生手机';
        $title['wphone'] = '女士手机';

        if($params['order_link'] != 'qj'){//取件环节不展示此字段
            $title['first_visit_time'] = '第一次回访时间';
        }

        switch($params['order_link']){
            case'order':$link = '订单日期';break;
            case'photo':$link = '拍照日期';break;
            case'sp':$link = '选片日期';break;
            case'jg':$link = '校稿日期';break;
            case'qj':$link = '取件日期';break;
        }
        $title['order_time'] = $link;

        if($params['order_link'] == 'sp'){
            $title['bargain_money'] = '一销金额';
            $title['supplementary_money'] = '二销金额';
            $title['photo_time'] = '拍摄日期';
        }

        foreach($visitObj as $k => $v){
            $title['obj_'.$v['object_code']] = $v['new_name'];
            if($params['is_score']==1)  $title['score_'.$v['object_code']] = '分数';
        }

        foreach($question as $key => $val){
            $title['answer_'.$val['id']] = $val['question'];
        }
        $title['note'] = '备注';


        //将数据按照标题的顺序记性排序
        $newData = [];
        foreach($data as $dataK => $dataV){
            $addData = [];
            foreach($title as $titleK => $titleV){
                $addData[$titleK] = $dataV[$titleK];
            }
            $newData[] = $addData;
        }

        $title = array_values($title);
        $first = $params['brandclass'].$params['order_link_name'].'的'.$params['visit_type_name'].'满意度 回访详情('.$params['start_time'].'——'.$params['end_time'].')';
        $this->exportNormFile($newData,$title,$first,'订单回访详情.xlsx');

    }


    /*
     * 导出第一行合并居中有标题的excel文件
     * data  数据数组
     * title 表头数组
     * firs  第一行合并居中的文件标题名
     * file_name  文件名
     */
    public function exportNormFile($data,$title,$first,$file_name){
        set_time_limit(0);
        $PHPExcel = new PHPExcel();
        $PHPExcel->getProperties()->setCreator("Maarten Balliauw")
            ->setLastModifiedBy("Maarten Balliauw")
            ->setTitle("Office 2007 XLSX Document")
            ->setSubject("Office 2007 XLSX Document")
            ->setDescription("Test document for Office 2007 XLSX, generated using PHP classes.")
            ->setKeywords("office 2007 openxml php")
            ->setCategory("Test result file");
        $cacheMethod = \PHPExcel_CachedObjectStorageFactory::cache_in_memory_gzip;
        if (!\PHPExcel_Settings::setCacheStorageMethod($cacheMethod)) {
            die($cacheMethod . " 缓存方法不可用" . EOL);
        }

        //合并单元格  标题
        $rowNum = $this->stringFromColumnIndex(count($title)-1);
        $PHPExcel->getActiveSheet()->mergeCells('A1:'.$rowNum.'1');      //合并
        $PHPExcel->getActiveSheet()->setCellValue('A1',$first);
        //所有单元格居中
        $PHPExcel->getDefaultStyle()->getAlignment()->setHorizontal(\PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $PHPExcel->getDefaultStyle()->getAlignment()->setVertical(\PHPExcel_Style_Alignment::VERTICAL_CENTER);

        $PHPSheet = $PHPExcel->getActiveSheet();
        $PHPSheet->setTitle('exportVisitAmount'); //给当前活动sheet设置名称

        $index = 2;
        for($i=0;$i<count($title);$i++){
            $range[$i] = $this->stringFromColumnIndex($i);
            //设置列宽
            $PHPExcel->setActiveSheetIndex(0);
            $PHPExcel->getActiveSheet()->getColumnDimension($range[$i])->setWidth(20);

            $PHPSheet->setCellValue($range[$i].$index, $title[$i]);
        }

        if(count($data)>0){
            foreach($data as $k=>$v){
                $index++;
                foreach(array_values($v) as $kk=>$vv){
                    $PHPSheet->setCellValue("{$range[$kk]}{$index}",$vv);
                }
            }
        }

        $PHPWriter = PHPExcel_IOFactory::createWriter($PHPExcel,'Excel2007');
        header('Content-type: application/vnd.ms-excel');//告诉浏览器输出07Excel文件
        header('Content-Disposition: attachment;filename='.$file_name);//告诉浏览器输出浏览器名称
        header("Content-Description: File Transfer");
        header('Cache-Control: max-age=0');//禁止缓存
        header("Content-Transfer-Encoding: binary"); //告诉浏览器，这是二进制文件
        $PHPWriter->save("php://output");
        exit;
    }




}