<?php
/**
 * 指标计算类。负责计算各种指标
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: songdemei<songdemei@suxuantech.cn> 2017-11-23s $
 */
namespace app\kf\lib;
class Target {
    protected  $funcs =[
        'newCustomerNum'=>
        [
            'id' =>'newCustomerNum',
            'name'=>'毛客资量',
            'method'=>'newCustomerNum'
        ],
        'validCustomerNumber'=>
        [
            'id'=>'validCustomerNumber',
            'name'=>'有效客资量',
            'method'=>'validCustomerNumber'
        ],
        'inviteIntoCustomerNumber'=>
        [
            'id'=>'inviteIntoCustomerNumber',
            'name'=>'邀约进店客资量',
            'method'=>'inviteIntoCustomerNumber'
        ],
        'actualIntoCustomerNumber'=>
        [
            'id'=>'actualIntoCustomerNumber',
            'name'=>'实际进店客资量',
            'method'=>'actualIntoCustomerNumber'
        ],
        'orderNumber'=>
        [
            'id'=>'orderNumber',
            'name'=>'成交量',
            'method'=>'orderNumber'
        ],
        'telVisitNumber'=>
        [
            'id'=>'telVisitNumber',
            'name'=>'电访量',
            'method'=>'telVisitNumber'
        ],
        'orderValueRate'=>
        [
            'id'=>'orderValueRate',
            'name'=>'订单转化率',
            'method'=>'orderValueRate',
            'type'=>'1'
        ],
        'intoValueRate'=>
        [
            'id'=>'intoValueRate',
            'name'=>'进店转化率',
            'method'=>'intoValueRate',
            'type'=>'1'
        ],
        'valueCustomerRate'=>
        [
            'id'=>'valueCustomerRate',
            'name'=>'客资有效率',
            'method'=>'valueCustomerRate',
            'type'=>'1'
        ],
        'valueCustomerIntoRate'=>
        [
            'id'=>'valueCustomerIntoRate',
            'name'=>'客资进店率',
            'method'=>'valueCustomerIntoRate',
            'type'=>'1'
        ],
        'valueCustomerconvertRate'=>
        [
            'id'=>'valueCustomerconvertRate',
            'name'=>'客资转换率',
            'method'=>'valueCustomerconvertRate',
            'type'=>'1'
        ],
        'dealAmount'=>
        [
            'id'=>'dealAmount',
            'name'=>'成交金额',
            'method'=>'dealAmount'
        ],
        'unvalidOrder'=>
        [
            'id'=>'unvalidOrder',
            'name'=>'无效新单',
            'method'=>'unvalidOrder'
        ],
        'ACustomerRate'=>
        [
            'id'=>'ACustomerRate',
            'name'=>'A客转化率',
            'method'=>'ACustomerRate'
        ],
        'ObtainCost'=>
        [
            'id'=>'ObtainCost',
            'name'=>'毛客资获取成本',
            'method'=>'ObtainCost'
        ],
        'NewOrderCost'=>
        [
            'id'=>'NewOrderCost',
            'name'=>'新单成本',
            'method'=>'NewOrderCost'
        ],
        
    ];
    public function get_target_name_by_id($id){
        $value = $this->getValueByKey($this->funcs,$id);
        return $value['name'];
    }
    public function get_target_method_by_id($id){
        $value = $this->getValueByKey($this->funcs,$id);
        return $value['method'];
    }
    function getValueByKey($arr, $key) {
        foreach($arr as $k => $v) {
            if ($k == $key) {
                return $v;
            }
        }
        return '';
    }

    /**
     * 计算  毛客资量 
     * @param  array  start_day(Y-m-d)，end_day(Y-m-d)，shop_code，staff_id
     * @return str    
     * @author Eric
     */
    public function newCustomerNum_old($params) {
        $res = db('c_day_number')
            ->where('addtime','between',[$params['start_day'], $params['end_day']])
            // ->where('shop_code', $params['shop_code'])
            ->where('staff_id', $params['staff_id'])
            ->sum('dj_customer');
        return $res;
    }
    public function newCustomerNum($params) {
        $start = date('Y-m-d', strtotime($params['start_day']));
        $end   = date('Y-m-d', strtotime($params['end_day']));
        $staff_id = (int)$params['staff_id'];
        if ($start == $end) {
            $end = date("Y-m-d",strtotime('+1 day',strtotime($end)));
        }
        $sql = "dj_staff_id = :dj_staff_id or sales_staff_id = :sales_staff_id or sk_staff_id = :sk_staff_id";
        $arr['dj_staff_id']    = $staff_id;
        $arr['sales_staff_id'] = $staff_id;
        $arr['sk_staff_id']    = $staff_id;

        $res = db('c_customerinfo')
            ->where('dj_day', 'between time', [$start, $end])
            ->where('is_status', 1)
            ->where('c_from', 1)
            ->where('add_shop_code', session('shop_code'))
            ->where($sql, $arr)
            ->count('id');
        
        return $res;
    }
    
    /**
     * 计算  有效客资量 
     * @param  array  start_day(Y-m-d)，end_day(Y-m-d)，shop_code，staff_id
     * @return str    
     * @author Eric
     */
    public function validCustomerNumber_old($params) {
        $res = db('c_day_number')
            ->where('addtime','between',[$params['start_day'], $params['end_day']])
            // ->where('shop_code', $params['shop_code'])
            ->where('staff_id', $params['staff_id'])
            ->sum('valid_customer');
        return $res;
    }
    public function validCustomerNumber($params) {
        
        $start = date('Y-m-d', strtotime($params['start_day']));
        $end   = date('Y-m-d', strtotime($params['end_day']));
        $staff_id = (int)$params['staff_id'];
        if ($start == $end) {
            $end = date("Y-m-d",strtotime('+1 day',strtotime($end)));
        }
        $sql = "dj_staff_id = :dj_staff_id or sales_staff_id = :sales_staff_id or sk_staff_id = :sk_staff_id";
        $arr['dj_staff_id']    = $staff_id;
        $arr['sales_staff_id'] = $staff_id;
        $arr['sk_staff_id']    = $staff_id;

        $res = db('c_customerinfo')
            ->where('yx_day', 'between time', [$start, $end])
            ->where('is_valid',1)
            ->where('is_status', 1)
            ->where('c_from', 1)
            ->where($sql, $arr)
            ->where('shop_code|add_shop_code', session('shop_code'))
            ->count('id');
        return $res;
    }
    
    /**
     * 计算  邀约进店客资量 
     * @param  array  start_day(Y-m-d)，end_day(Y-m-d)，shop_code，staff_id
     * @return str    
     * @author Eric
     */
    public function inviteIntoCustomerNumber_old($params) {
        $res = db('c_day_number')
            ->where('addtime','between',[$params['start_day'], $params['end_day']])
            // ->where('shop_code', $params['shop_code'])
            ->where('staff_id', $params['staff_id'])
            ->sum('yjd');
        return $res;
    }
    public function inviteIntoCustomerNumber($params) {
        $start = date('Y-m-d', strtotime($params['start_day']));
        $end   = date('Y-m-d', strtotime($params['end_day']));
        $staff_id = (int)$params['staff_id'];
        if ($start == $end) {
            $end = date("Y-m-d",strtotime('+1 day',strtotime($end)));
        }
        $sql = "dj_staff_id = :dj_staff_id or sales_staff_id = :sales_staff_id or sk_staff_id = :sk_staff_id";
        $arr['dj_staff_id']    = $staff_id;
        $arr['sales_staff_id'] = $staff_id;
        $arr['sk_staff_id']    = $staff_id;

        $res = db('c_customerinfo')
            ->where('yjd_day', 'between time', [$start, $end])
            ->where('is_status', 1)
            ->where('c_from', 1)
            ->where($sql, $arr)
            ->where('shop_code|add_shop_code', session('shop_code'))
            ->count('id');        

        return $res;
    }
    
    /**
     * 计算  实际进店客资量
     * @param  array  start_day(Y-m-d)，end_day(Y-m-d)，shop_code，staff_id
     * @return str
     * @author Eric
     */
    public function actualIntoCustomerNumber_olde($params) {
        $res = db('c_day_number')
            ->where('addtime','between',[$params['start_day'], $params['end_day']])
            // ->where('shop_code', $params['shop_code'])
            ->where('staff_id', $params['staff_id'])
            ->sum('syjd_jk');
        return $res;
    }
    public function actualIntoCustomerNumber($params) {
        $start = date('Y-m-d', strtotime($params['start_day']));
        $end   = date('Y-m-d', strtotime($params['end_day']));
        $staff_id = (int)$params['staff_id'];
        if ($start == $end) {
            $end = date("Y-m-d",strtotime('+1 day',strtotime($end)));
        }
        $sql = "dj_staff_id = :dj_staff_id or sales_staff_id = :sales_staff_id or sk_staff_id = :sk_staff_id";
        $arr['dj_staff_id']    = $staff_id;
        $arr['sales_staff_id'] = $staff_id;
        $arr['sk_staff_id']    = $staff_id;

        $res = db('c_customerinfo')
            ->where('syjd_day', 'between time', [$start, $end])
            ->where('is_intostore','between',['2', '3'])
            ->where('is_status', 1)
            ->where('c_from', 1)
            ->where($sql, $arr)
            ->where('shop_code|add_shop_code', session('shop_code'))
            ->count('id');
        return $res;
    }

    
    /**
     * 计算  电访量
     * @param  array  start_day(Y-m-d)，end_day(Y-m-d)，shop_code，staff_id
     * @return str    
     * @author Eric
     */
    public function telVisitNumber_old($params) {
        $res = db('c_day_number')
            ->where('addtime','between',[$params['start_day'], $params['end_day']])
            // ->where('shop_code', $params['shop_code'])
            ->where('staff_id', $params['staff_id'])
            ->sum('tel_visit');
        return $res;
    }
    public function telVisitNumber($params) {
        $start = date('Y-m-d', strtotime($params['start_day']));
        $end   = date('Y-m-d', strtotime($params['end_day']));
        $staff_id = (int)$params['staff_id'];
        if ($start == $end) {
            $end = date("Y-m-d",strtotime('+1 day',strtotime($end)));
        }
        $sql = "dj_staff_id = :dj_staff_id or sales_staff_id = :sales_staff_id or sk_staff_id = :sk_staff_id";
        $arr['dj_staff_id']    = $staff_id;
        $arr['sales_staff_id'] = $staff_id;
        $arr['sk_staff_id']    = $staff_id;

        $res = db('c_salestrackinginfo')
            ->where('tel_starttime', 'between time', [$start, $end])
            ->where('gtType', 1)
            ->where('sales_staff_id', $staff_id)
            ->where('shop_code|add_shop_code', session('shop_code'))
            ->count('id');
        return $res;
    }

    /**
     * 计算  客资进店率  进店 进客/标记有效
     * @param  array  start_day(Y-m-d)，end_day(Y-m-d)，shop_code，staff_id
     * @return float    
     * @author Eric
     */
    public function valueCustomerIntoRate_old($params) {
        // 进店进客数
        $res_jk = db('c_day_number')
            ->where('addtime','between',[$params['start_day'], $params['end_day']])
            // ->where('shop_code', $params['shop_code'])
            ->where('staff_id', $params['staff_id'])
            ->sum('syjd_jk');
        // 标记有效
        $res_yx = db('c_day_number')
            ->where('addtime','between',[$params['start_day'], $params['end_day']])
            // ->where('shop_code', $params['shop_code'])
            ->where('staff_id', $params['staff_id'])
            ->sum('valid_customer');
        $res = $res_jk/$res_yx;
        return floatval($res);
    }
    public function valueCustomerIntoRate($params) {
        $start = date('Y-m-d', strtotime($params['start_day']));
        $end   = date('Y-m-d', strtotime($params['end_day']));
        $staff_id = (int)$params['staff_id'];
        if ($start == $end) {
            $end = date("Y-m-d",strtotime('+1 day',strtotime($end)));
        }
        $sql = "dj_staff_id = :dj_staff_id or sales_staff_id = :sales_staff_id or sk_staff_id = :sk_staff_id";
        $arr['dj_staff_id']    = $staff_id;
        $arr['sales_staff_id'] = $staff_id;
        $arr['sk_staff_id']    = $staff_id;

        $res_jd = db('c_customerinfo')
            ->where('syjd_day', 'between time', [$start, $end])
            ->where('is_intostore',2)
            ->where('is_status', 1)
            ->where('c_from', 1)
            ->where($sql, $arr)
            ->where('shop_code|add_shop_code', session('shop_code'))
            ->count('id');
        $res_yx = db('c_customerinfo')
            ->where('yx_day', 'between time', [$start, $end])
            ->where('is_valid',1)
            ->where('is_status', 1)
            ->where('c_from', 1)
            ->where($sql, $arr)
            ->where('shop_code|add_shop_code', session('shop_code'))
            ->count('id');

        $res = floatval($res_jd/$res_yx);
        return $res;
    }
    
    /**
     * 计算  客资转换率
     * @param  array  start_day(Y-m-d)，end_day(Y-m-d)，shop_code，staff_id  有效客资量/毛客资量
     * @return float    
     * @author Eric
     */
    public function valueCustomerconvertRate_old($params) {
        $mk = db('c_day_number')
            ->where('addtime','between',[$params['start_day'], $params['end_day']])
            ->where('staff_id', $params['staff_id'])
            ->sum('dj_customer');

        $yx = db('c_day_number')
            ->where('addtime','between',[$params['start_day'], $params['end_day']])
            ->where('staff_id', $params['staff_id'])
            ->sum('valid_customer');

        $res = $yx/$mk;
        return $res;
    }
    public function valueCustomerconvertRate($params) {
        $start = date('Y-m-d', strtotime($params['start_day']));
        $end   = date('Y-m-d', strtotime($params['end_day']));
        $staff_id = (int)$params['staff_id'];
        if ($start == $end) {
            $end = date("Y-m-d",strtotime('+1 day',strtotime($end)));
        }
        $sql = "dj_staff_id = :dj_staff_id or sales_staff_id = :sales_staff_id or sk_staff_id = :sk_staff_id";
        $arr['dj_staff_id']    = $staff_id;
        $arr['sales_staff_id'] = $staff_id;
        $arr['sk_staff_id']    = $staff_id;

        $res_yx = db('c_customerinfo')
            ->where('yx_day', 'between time', [$start, $end])
            ->where('is_valid',1)
            ->where('is_status', 1)
            ->where('c_from', 1)
            ->where($sql, $arr)
            ->where('shop_code|add_shop_code', session('shop_code'))
            ->count('id');

        $res_mk = db('c_customerinfo')
            ->where('dj_day', 'between time', [$start, $end])
            ->where('is_status', 1)
            ->where('c_from', 1)
            ->where($sql, $arr)
            ->where('shop_code|add_shop_code', session('shop_code'))
            ->count('id');

        $res = floatval($res_yx/$res_mk);
        return $res;
    }

    /**
     * 计算  成交金额   实收款  
     * @param  array  start_day(Y-m-d)，end_day(Y-m-d)，shop_code，staff_id，staff_type(录入dj_staff_id，筛客sk_staff_id，接收sales_staff_id)
     * @return str    
     * @author Eric
     */
    public function dealAmount_old($params) {
        $cids = db('c_customerinfo')
            ->where('order_day','between',[$params['start_day'], $params['end_day']])
            ->where($params['staff_type'], $params['staff_id'])
            ->column('id');

        $res = db('c_customer_order')
            ->where('create_time','between',[$params['start_day'], $params['end_day']])
            // ->where('shop_code', $params['shop_code'])
            ->where('customer_id', 'in', $cids)
            ->sum('order_fact');
        return $res;
    }
    public function dealAmount($params) {
        $start = date('Y-m-d', strtotime($params['start_day']));
        $end   = date('Y-m-d', strtotime($params['end_day']));
        $staff_id = (int)$params['staff_id'];
        if ($start == $end) {
            $end = date("Y-m-d",strtotime('+1 day',strtotime($end)));
        }
        $sql = "dj_staff_id = :dj_staff_id or sales_staff_id = :sales_staff_id or sk_staff_id = :sk_staff_id";
        $arr['dj_staff_id']    = $staff_id;
        $arr['sales_staff_id'] = $staff_id;
        $arr['sk_staff_id']    = $staff_id;

        $res = db('c_customerinfo')
            ->where('order_start_time', 'between time', [$start, $end])
            ->where('is_status', 1)
            ->where('c_from', 1)
            ->where($sql, $arr)
            ->where('shop_code|add_shop_code', session('shop_code'))
            ->sum('fact_money');

        return $res;
    }
    
    /**
     * 计算  成交量  有效新单 is_success=1
     * @param  array  start_day(Y-m-d)，end_day(Y-m-d)，shop_code，staff_id
     * @return str    
     * @author Eric
     */
    public function orderNumber_old($params) {
        $res = db('c_day_number')
            ->where('addtime','between',[$params['start_day'], $params['end_day']])
            // ->where('shop_code', $params['shop_code'])
            ->where('staff_id', $params['staff_id'])
            ->sum('orders');

        return $res;
    }
    public function orderNumber($params) {
        $start = date('Y-m-d', strtotime($params['start_day']));
        $end   = date('Y-m-d', strtotime($params['end_day']));
        $staff_id = (int)$params['staff_id'];
        if ($start == $end) {
            $end = date("Y-m-d",strtotime('+1 day',strtotime($end)));
        }
        $sql = "dj_staff_id = :dj_staff_id or sales_staff_id = :sales_staff_id or sk_staff_id = :sk_staff_id";
        $arr['dj_staff_id']    = $staff_id;
        $arr['sales_staff_id'] = $staff_id;
        $arr['sk_staff_id']    = $staff_id;

        $res = db('c_customerinfo')
            ->where('order_start_time', 'between time', [$start, $end])
            ->where('is_status', 1)
            ->where('is_success', 1)
            ->where('c_from', 1)
            ->where($sql, $arr)
            ->where('shop_code|add_shop_code', session('shop_code'))
            ->count('id');

        return $res;
    }

    /**
     * 计算  订单转化率:order_rate DT/YT  YT：标记有效；DT：有效成单数
     * @param  array  start_day(Y-m-d)，end_day(Y-m-d)，shop_code，staff_id
     * @return float
     * @author Eric
     */
    public function orderValueRate_old($params) {
        $dt = db('c_day_number')
            ->where('addtime','between',[$params['start_day'], $params['end_day']])
            // ->where('shop_code', $params['shop_code'])
            ->where('staff_id', $params['staff_id'])
            ->sum('valid_order');

        $yt = db('c_day_number')
            ->where('addtime','between',[$params['start_day'], $params['end_day']])
            // ->where('shop_code', $params['shop_code'])
            ->where('staff_id', $params['staff_id'])
            ->sum('valid_customer');

        $res = $dt/$yt;
        return $res;
    }

    public function orderValueRate($params) {
        $start = date('Y-m-d', strtotime($params['start_day']));
        $end   = date('Y-m-d', strtotime($params['end_day']));
        $staff_id = (int)$params['staff_id'];
        if ($start == $end) {
            $end = date("Y-m-d",strtotime('+1 day',strtotime($end)));
        }
        $sql = "dj_staff_id = :dj_staff_id or sales_staff_id = :sales_staff_id or sk_staff_id = :sk_staff_id";
        $arr['dj_staff_id']    = $staff_id;
        $arr['sales_staff_id'] = $staff_id;
        $arr['sk_staff_id']    = $staff_id;

        $dt = db('c_customerinfo')
            ->where('is_status', 1)
            ->where('c_from', 1)
            ->where('order_day', 'between time', [$start, $end])
            ->where('is_success',1)
            ->where($sql, $arr)
            ->where('shop_code|add_shop_code', session('shop_code'))
            ->count('id');

        $yd = db('c_customerinfo')
            ->where('yx_day', 'between time', [$start, $end])
            ->where('is_valid', 1)
            ->where('is_status', 1)
            ->where('c_from', 1)
            ->where($sql, $arr)
            ->where('shop_code|add_shop_code', session('shop_code'))
            ->count('id');

        $res = floatval($dt/$yd);
        return $res;
    }

    /**
     * 计算  进店转化率:in_rate  实际进店数，进客(st)/YT  YT：标记有效；
     * @param  array  start_day(Y-m-d)，end_day(Y-m-d)，shop_code，staff_id
     * @return str    
     * @author Eric
     */
    public function intoValueRate_old($params) {
        $st = db('c_day_number')
            ->where('addtime','between',[$params['start_day'], $params['end_day']])
            // ->where('shop_code', $params['shop_code'])
            ->where('staff_id', $params['staff_id'])
            ->sum('syjd_jk');

        $yt = db('c_day_number')
            ->where('addtime','between',[$params['start_day'], $params['end_day']])
            // ->where('shop_code', $params['shop_code'])
            ->where('staff_id', $params['staff_id'])
            ->sum('valid_customer');
        
        $res = $st/$yt;
        return $res;
    }
    public function intoValueRate($params) {
        $start = date('Y-m-d', strtotime($params['start_day']));
        $end   = date('Y-m-d', strtotime($params['end_day']));
        $staff_id = (int)$params['staff_id'];
        if ($start == $end) {
            $end = date("Y-m-d",strtotime('+1 day',strtotime($end)));
        }
        $sql = "dj_staff_id = :dj_staff_id or sales_staff_id = :sales_staff_id or sk_staff_id = :sk_staff_id";
        $arr['dj_staff_id']    = $staff_id;
        $arr['sales_staff_id'] = $staff_id;
        $arr['sk_staff_id']    = $staff_id;

        $st = db('c_customerinfo')
            ->where('is_status', 1)
            ->where('c_from', 1)
            ->where('syjd_day', 'between time', [$start, $end])
            ->where('is_intostore',2)
            ->where($sql, $arr)
            ->where('shop_code|add_shop_code', session('shop_code'))
            ->count('id');

        $yt = db('c_customerinfo')
            ->where('is_status', 1)
            ->where('c_from', 1)
            ->where('yx_day', 'between time', [$start, $end])
            ->where('is_valid',1)
            ->where($sql, $arr)
            ->where('shop_code|add_shop_code', session('shop_code'))
            ->count('id');

        $res = floatval($st/$yt);
        return $res;
    }
    
    /**
     * 计算  客资有效率  customer_rate YT/LT  LT：录入；YT：标记有效；
     * @param  array  start_day(Y-m-d)，end_day(Y-m-d)，shop_code，staff_id
     * @return str    
     * @author Eric
     */
    public function valueCustomerRate_old($params) {

        $yt = db('c_day_number')
            ->where('addtime','between',[$params['start_day'], $params['end_day']])
            // ->where('shop_code', $params['shop_code'])
            ->where('staff_id', $params['staff_id'])
            ->sum('valid_customer');
        $lt = db('c_day_number')
            ->where('addtime','between',[$params['start_day'], $params['end_day']])
            // ->where('shop_code', $params['shop_code'])
            ->where('staff_id', $params['staff_id'])
            ->sum('dj_customer');
        $res = $yt/$lt;
        return $res;
    }
    public function valueCustomerRate($params) {
        $start = date('Y-m-d', strtotime($params['start_day']));
        $end   = date('Y-m-d', strtotime($params['end_day']));
        $staff_id = (int)$params['staff_id'];
        if ($start == $end) {
            $end = date("Y-m-d",strtotime('+1 day',strtotime($end)));
        }
        $sql = "dj_staff_id = :dj_staff_id or sales_staff_id = :sales_staff_id or sk_staff_id = :sk_staff_id";
        $arr['dj_staff_id']    = $staff_id;
        $arr['sales_staff_id'] = $staff_id;
        $arr['sk_staff_id']    = $staff_id;

        $yt = db('c_customerinfo')
            ->where('is_status', 1)
            ->where('c_from', 1)
            ->where('yx_day', 'between time', [$start, $end])
            ->where('is_valid',1)
            ->where($sql, $arr)
            ->where('shop_code|add_shop_code', session('shop_code'))
            ->count('id');

        $lt = db('c_customerinfo')
            ->where('dj_day', 'between time', [$start, $end])
            ->where('is_status', 1)
            ->where('c_from', 1)
            ->where($sql, $arr)
            ->where('shop_code|add_shop_code', session('shop_code'))
            ->count('id');

        $res = floatval($yt/$lt);
        return $res;
    }
    /**
     * 无效新单 is_success=2=3
     * @param  array
     * @return str
     * @author Eric
     */
    public function unvalidOrder($params) {
        $start = date('Y-m-d', strtotime($params['start_day']));
        $end   = date('Y-m-d', strtotime($params['end_day']));
        $staff_id = (int)$params['staff_id'];
        if ($start == $end) {
            $end = date("Y-m-d",strtotime('+1 day',strtotime($end)));
        }
        $sql = "dj_staff_id = :dj_staff_id or sales_staff_id = :sales_staff_id or sk_staff_id = :sk_staff_id";
        $arr['dj_staff_id']    = $staff_id;
        $arr['sales_staff_id'] = $staff_id;
        $arr['sk_staff_id']    = $staff_id;

        $res = db('c_customerinfo')
            ->where('is_status', 1)
            ->where('c_from', 1)
            ->where('order_start_time', 'between time', [$start, $end])
            ->where('is_success', '<>', 1)
            ->where($sql, $arr)
            ->where('shop_code|add_shop_code', session('shop_code'))
            ->count('id');

        return $res;
    }

    /*
     * A客转化率  A客/有效
     */
    public function ACustomerRate($params){

        $start = date('Y-m-d', strtotime($params['start_day']));
        $end   = date('Y-m-d', strtotime($params['end_day']));
        $staff_id = (int)$params['staff_id'];
        if ($start == $end) {
            $end = date("Y-m-d",strtotime('+1 day',strtotime($end)));
        }
        $sql = "dj_staff_id = :dj_staff_id or sales_staff_id = :sales_staff_id or sk_staff_id = :sk_staff_id";
        $arr['dj_staff_id']    = $staff_id;
        $arr['sales_staff_id'] = $staff_id;
        $arr['sk_staff_id']    = $staff_id;

        $aCus = db('c_customerinfo')
            ->where('is_status', 1)
            ->where('c_from', 1)
            ->where('sign_time', 'between time', [$start, $end])
            ->where('sign_name', 'like', 'A%')
            ->where($sql, $arr)
            ->where('shop_code|add_shop_code', session('shop_code'))
            ->count('id');

        $value = db('c_customerinfo')
            ->where('yx_day', 'between time', [$start, $end])
            ->where('is_valid',1)
            ->where('is_status', 1)
            ->where('c_from', 1)
            ->where($sql, $arr)
            ->where('shop_code|add_shop_code', session('shop_code'))
            ->count('id');
        
        $res = floatval($aCus/$value);
        return $res;
    }
    /*
     * 花费
     * */
    function cost($param){
        $start = date('Y-m-d', strtotime($param['start_day']));
        $end   = date('Y-m-d', strtotime($param['end_day']));
        $channel_id = $param['channel_id'] ? $param['channel_id'] : 0;
        $province_id = $param['province_id'] ? $param['province_id'] : 0;
        $city_id = $param['city_id'] ? $param['city_id'] : 0;
        $arr = array();
        if($channel_id){
            $arr['channel_id'] = $channel_id;
        }
        if($province_id){
            $arr['province_id'] = $province_id;
        }
        if($city_id){
            $arr['city_id'] = $city_id;
        }
        $res = db('c_customer_cost')->where('shop_code',$param['shop_code'])->where('cost_time', 'between time', [$start, $end])->where($arr)->sum('cost_avg');
        return $res;
    }
    /*
     * 毛客资获取成本
     * */
    function ObtainCost($params){
        $newCustomerNum = $this->newCustomerNum($params);
        $cost = $this->cost($params);
        return $cost/$newCustomerNum;
    }
    /*
     * 新单成本
     * */
    function NewOrderCost($params){
        $validOrder = $this->orderNumber($params);
        $cost = $this->cost($params);
        return $cost/$validOrder;
    }
    public function getAllTarget() {
        return $this->funcs;
    }
}