<?php
/**
 * CRM 实现模块
 * CRM的基本功能实现，如客资录入，客资查询等。
 * 所有业务的真正实现全在lib目录下建controller并且访问modle等，供controller层调用
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: chaidongdong<chaidongdong@suxuantech.cn> 2018-4-23 $
 */
namespace app\kf\lib;

use app\kf\model\TQuestion;
use app\kf\model\TTest;
use app\kf\model\TTestAnswer;
use app\kf\model\TTestQuestion;
use app\kf\model\TTraining;
use think\Db;
use PHPExcel_IOFactory;
use Excel5;
use PHPExcel;
class Test{

    //1:固定题目 2:随机题目
    public $type = ['1','2'];
    /**
     * 获取考试数据
     *
     * @param array $params 参数
     * @return array
     * @author chaidongdong@suxuantech.cn
     */
    // public function getTrainings($params = []){
        // $model_TTraining = Model('TTraining');
        // return $model_TTraining->where($params)->select();

        // $model_TTraining = new TTraining();
        // return $model_TTraining->getList($params);

        // return Db::table('t_training')->where($params)->select();
    // }

    /**
     * 页面获取考试列表(分页)
     *
     * @param array $params 参数
     * @return array
     * @author chaidongdong@suxuantech.cn
     */
    public function TestList($params = []){
        $page = $params['page'] ? $params['page'] : 1;
        $limit = intval($params['limit']) ? intval($params['limit']) : 10;
        $model_TTest = new TTest();
        // unset($params['page'],$params['limit']);
        if($params['key']){
            $filter = $params['key'];
            if($filter['title']){
                $filter['title'] = ['s'=>'like','v'=>'%'.$filter['title'].'%'];
            }
        }
        $list = $model_TTest->getList($filter,'*',$page,$limit);
        if($list){
            $model_TTraining = Model('TTraining');
            foreach ($list as $key => $value) {
                if($value['training_id'] && ($value['training_id']!='0')){
                    $training = $model_TTraining->getOne(['id'=>$value['training_id']],'title');
                    $list[$key]['traing_title'] = $training['title'];
                }
            }
        }
        $count = $model_TTest->getCount($filter);
        if($count<1){
            return ['data'=>[], 'count'=>0];
        }else{
            return ['data'=>$list, 'count'=>$count];
        }
    }

    /**
     * 查找单个考试
     *
     * @param array $params 参数
     * @return array
     * @author chaidongdong@suxauntech.cn
     */
    public function getTestInfo($params){
        $model_TTest = new TTest();
        $data = $model_TTest->getOne($params);
        if($data){
            $data['export_rule'] = json_decode($data['export_rule'],1);
        }
        return $data;
    }

    /**
     * 获取后台查看考试列表
     *
     * @param array $params 参数
     * @return array
     * @author chaidongdong@suxuantech.cn
     */
    public function getTestAnswerA($params){
        $page = $params['page'] ? $params['page'] : 1;
        $limit = intval($params['limit']) ? intval($params['limit']) : 10;
        $model_TTestAnswer = new TTestAnswer();
        $list = $model_TTestAnswer->getList($params['key'],'*',$page,$limit);
        $count = $model_TTestAnswer->getCount($params['key']);
        if($count<1){
            return ['data'=>[], 'count'=>0];
        }else{
            return ['data'=>$list, 'count'=>$count];
        }
    }

    /**
     * 修改加分
     *
     * @param integer $test_id
     * @param array $points
     * @return bool
     * @author chaidongdong@suxuantech.cn
     */
    public function saveTestPoints($test_id,$points){
        $model_TTestAnswer = new TTestAnswer();
        Db::startTrans();
        foreach ($points as $key => $value){
            $answer = $model_TTestAnswer->getOne(['id'=>$key,'test_id'=>$test_id]);
            $amount_score = $answer['score'] + $value;
            $res = $model_TTestAnswer->tUpdate(['amount_score'=>$amount_score,'points'=>$value],['id'=>$key]);
            if($res === false){
                Db::rollback();
                return false;
            }
        }
        Db::commit();
        return true;
    }

    /**
     * 页面获取考题列表(分页)
     *
     * @param array $params 参数
     * @return array
     * @author chaidongdong@suxuantech.cn
     */
//    public function QuestionList($params = []){
//        $page = $params['page'] ? $params['page'] : 1;
//        $limit = intval($params['limit']) ? intval($params['limit']) : 10;
//        $model_TQuestion = new TQuestion();
//        if($params['key']){
//            $filter = $params['key'];
//            $filter = array_filter($filter);
//            if($filter['question']){
//                $filter['question'] = ['s'=>'like','v'=>'%'.$filter['question'].'%'];
//            }
//        }
//        $list = $model_TQuestion->getList($filter,'*',$page,$limit);
//        $count = $model_TQuestion->getCount($filter);
//        if($count<1){
//            return ['data'=>[], 'count'=>0];
//        }else{
//            return ['data'=>$list, 'count'=>$count];
//        }
//    }

    /**
     * 添加、修改考试基本信息
     *
     * @param array $params
     * @param string &$msg
     * @return bool
     * @author chaidongdong@suxuantech.cn
     */
    public function saveTest($params,&$msg){
        $data = [
            'name'=>trim($params['name']),
            'training_id'=>$params['training_id'] ? intval($params['training_id']) : 0,
            'start_time'=> $params['start_time'],
            'end_time'=> $params['end_time'],
            'type'=>$params['type'],
            'address'=>$params['address'],
            'apply_type'=>$params['apply_type'],
            'amount_score'=>intval($params['amount_score']) ? intval($params['amount_score']) : 100,
            'pass_score'=>intval($params['pass_score']) ? intval($params['pass_score']) : 60,
            'supplement_num'=>intval($params['supplement_num'])?intval($params['supplement_num']):'0',
            'create_staff_id'=>$params['create_staff_id']
        ];
        foreach ($params['stage'] as $value){
            if(($value['max'] && ($value['max'] > $data['amount_score'] || $value['max'] < 0)) || ($value['min'] && ($value['min'] > $data['amount_score'] || $value['min'] < 0 ))){
                $msg = '请正确填写分值阶段';
                return false;
            }
        }
        $data['export_rule'] = json_encode($params['stage']);
//        $data = [];
//        $data = array_filter($data,'trim');
        if(!$data['name'] || !$data['start_time'] || !$data['end_time'] || !$data['type']){
            $msg = '请填写完整';
            return false;
        }
        if(!$params['id']){
            $data['create_time'] = date('Y-m-d H:i:s');
        }
        if(!in_array($data['type'], $this->type)){
            $msg = '参数错误';
            return false;
        }
        $data['start_time'] = date('Y-m-d H:i:s',strtotime($data['start_time']));
        $data['end_time'] = date('Y-m-d H:i:s',strtotime($data['end_time']));
        if($data['end_time'] <= $data['start_time']){
            $msg = '结束时间必须大于开始时间';
            return false;
        }
        $model_TTest = new TTest();
        if($params['id']){
            $res = $model_TTest->tUpdate($data,['id'=>$params['id']]);
        }else{
            $res = $model_TTest->tInsert($data);
        }
        if($res !== false){
            return true;
        }else{
            $msg = '操作失败';
            return false;
        }
    }

    /**
     * 添加或者修改考题
     * 
     * @param array $params 出题规则或者是数据
     * @param string &$msg 提示
     * @return bool
     * @author chaidongdong@suxuantech.cn
     */
    public function saveTestQuestion($params = [], &$msg){
//        dd($params);
        if($params['test_id']){
            $model_tTest = new TTest();
            $test = $model_tTest->getOne(['id'=>$params['test_id']]);
            if($test){
                if($test['type'] == '2'){   //随机题目
                    $model_TQuestion = new TQuestion();
                    $rule = [];
                    $amount_score = 0;
                    if((intval($params['ques_1_num']) > 0) && (intval($params['ques_1_score'])>0)){
                        $rule['1'] = ['num'=>intval($params['ques_1_num']),'score'=>intval($params['ques_1_score'])];
                        $res = $model_TQuestion->getOne(['question_type'=>'1'],'count(1) as count');
                        if($res['count'] < $rule['1']['num']){
                            $msg = '题库的单选题只有'.$res['count'].'道';
                            return false;
                        }
                        $amount_score += ($rule['1']['num']*$rule['1']['score']);
                    }
                    if((intval($params['ques_2_num']) > 0) && (intval($params['ques_2_score'])>0)){
                        $rule['2'] = ['num'=>intval($params['ques_2_num']),'score'=>intval($params['ques_2_score'])];
                        $res = $model_TQuestion->getOne(['question_type'=>'2'],'count(1) as count');
                        if($res['count'] < $rule['2']['num']){
                            $msg = '题库的多选题只有'.$res['count'].'道';
                            return false;
                        }
                        $amount_score += ($rule['2']['num']*$rule['2']['score']);
                    }
                    if((intval($params['ques_3_num']) > 0) && (intval($params['ques_3_score'])>0)){
                        $rule['3'] = ['num'=>intval($params['ques_3_num']),'score'=>intval($params['ques_3_score'])];
                        $res = $model_TQuestion->getOne(['question_type'=>'3'],'count(1) as count');
//                        if($res['count'] < $rule['3']['num']){
//                            $msg = '题库的填空题只有'.$res['count'].'道';
//                            return false;
//                        }
                        $amount_score += ($rule['3']['num']*$rule['3']['score']);
                    }
                    if((intval($params['ques_4_num']) > 0) && (intval($params['ques_4_score'])>0)){
                        $rule['4'] = ['num'=>intval($params['ques_4_num']),'score'=>intval($params['ques_4_score'])];
                        $res = $model_TQuestion->getOne(['question_type'=>'4'],'count(1) as count');
                        if($res['count'] < $rule['4']['num']){
                            $msg = '题库的简单题只有'.$res['count'].'道';
                            return false;
                        }
                        $amount_score += ($rule['4']['num']*$rule['4']['score']);
                    }
                    $a_score = ($amount_score-$test['amount_score']);
                    if($a_score == 0){
                        $json_rule = json_encode($rule);
                        $res = $model_tTest->tUpdate(['rule'=>$json_rule],['id'=>$test['id']]);
                        if($res !== false){
                            return true;
                        }else{
                            $msg = '操作失败';
                            return false;
                        }
                    }else{
                        if($a_score>0){
                            $msg = '请正确设置分数，超过总分'.abs($a_score);
                        }else{
                            $msg = '请正确设置分数，距离总分'.abs($a_score);
                        }
                        return false;
                    }
                }elseif($test['type'] == '1'){     //固定题目
                    $question_list = [];
                    $amount_score = 0;
                    $model_TQuestion = new TQuestion();
                    foreach ($params['question_list'] as $value) {
                        $question = $model_TQuestion->getOne(['id'=>$value]);
                        if($question['question_type'] == '3'){
                            $answer = @json_decode($question['answer'],true);
                            $amount_score += count($answer)*$params['question_score'][$value];
                        }else{
                            $amount_score += $params['question_score'][$value];
                        }
                        if($question){
                            $question_list[$question['question_type']][] = [
                                'question_id'=>$value,
                                'score'=>$params['question_score'][$value]
                            ];
                        }else{
                            $msg = '考题不存在';
                            return false;
                        }
                    }
                    $a_score = ($amount_score-$test['amount_score']);
                    if($a_score != 0){
                        if($a_score>0){
                            $msg = '请正确设置分数，超过总分'.abs($a_score);
                        }else{
                            $msg = '请正确设置分数，距离总分'.abs($a_score);
                        }
                        return false;
                    }
                    ksort($question_list);
                    $res = $model_tTest->tUpdate(['rule'=>json_encode($question_list)],['id'=>$test['id']]);
                    if($res !== false){
                        return true;
                    }else{
                        $msg = '操作失败';
                        return false;
                    }
                }
            }else{
                $msg = '请选择考题';
                return false;
            }
        }else{
            $msg = '请选择考题';
            return false;
        }
//        if($params['test_id']){
//            $model_TTest = new TTest();
//            $test = $model_TTest->getOne(['id'=>$params['test_id']]);
//            if($test){
//                $percentage = (intval($params['pass_score']) > 0) ? intval($params['pass_score']) : 60;
//                $amount_score = 0;  //总分
//                $pass_score = 0;    //及格分
//                if($test['type'] == '1'){   //固定题目
//
//                }else if($test['type'] == '2'){ //随机题目
//                    $rule = [];
//                    if((intval($params['ques_1_num']) > 0) && (intval($params['ques_1_score'])>0)){
//                        $rule['1'] = ['num'=>intval($params['ques_1_num']),'score'=>intval($params['ques_1_score'])];
//                        $amount_score += ($rule['1']['num']*$rule['1']['score']);
//                    }
//                    if((intval($params['ques_2_num']) > 0) && (intval($params['ques_2_score'])>0)){
//                        $rule['2'] = ['num'=>intval($params['ques_2_num']),'score'=>intval($params['ques_2_score'])];
//                        $amount_score += ($rule['2']['num']*$rule['2']['score']);
//                    }
//                    if((intval($params['ques_3_num']) > 0) && (intval($params['ques_3_score'])>0)){
//                        $rule['3'] = ['num'=>intval($params['ques_3_num']),'score'=>intval($params['ques_3_score'])];
//                        $amount_score += ($rule['3']['num']*$rule['3']['score']);
//                    }
//                    if((intval($params['ques_4_num']) > 0) && (intval($params['ques_4_score'])>0)){
//                        $rule['4'] = ['num'=>intval($params['ques_4_num']),'score'=>intval($params['ques_4_score'])];
//                        $amount_score += ($rule['4']['num']*$rule['4']['score']);
//                    }
//                }else{
//                    $msg = '数据有误';
//                    return false;
//                }
//                if($amount_score > 0){
//                    if((intval($params['pass_score']) <= 100) || (intval($params['pass_score']) >0)){
//                        $pass_score = ceil($percentage*$amount_score/100);
//                        $data = [
//                            'amount_score' => $amount_score,
//                            'pass_score'=>$pass_score,
//                            'rule'=>json_encode($rule)
//                        ];
//                        $model_TTraining = new TTest();
//                        if($model_TTraining->tUpdate($data,['id'=>$test['id']])){
//                            return true;
//                        }else{
//                            $msg = '操作失败';
//                            return false;
//                        }
//                    }else{
//                        $msg = '及格百分比的范围是【1-100】';
//                        return false;
//                    }
//                }else{
//                    $msg = '请设置题目';
//                    return false;
//                }
//            }else{
//                $msg = '考试不存在';
//                return false;
//            }
//        }else{
//            $msg = '请选择考试';
//            return false;
//        }
    }

    /**
     * 删除考试
     *
     * @param array $params
     * @return bool
     * @author chaidongdong@suxuantech.cn
     */
    public function delTest($params){
        $model_TTest = new TTest();
        return $model_TTest->tDelete($params);
    }

    /**
     * 计算获取单个考试考题
     * @param int $test_id
     * @param string &$msg
     * @return array
     * @author chaidongdong@suxuantech.cn
     */
    public function getTestQuestionInfo($test_id,&$msg){
        $test = $this->getTestValid($test_id);    //检查考试是否有效
        if($test){
            switch ($test['type']){
                case '1':
                    return $this->getFixedQuestion(json_decode($test['rule'],true),$test['apply_type'],$test['id'],$msg);
                case '2':
                    //获取随机试题
                    return $this->getRandQuesion(json_decode($test['rule'],true),$test['id'],$msg);
            }
            $msg = '获取失败';
            return false;
        }else{
            $msg = '考试不存在或者无效';
            return false;
        }
    }

    /**
     * 获取固定考题
     *
     * @param array $rule
     * @param integer $test_id
     * @param integer $apply_type
     * @param string $msg
     * @return array|bool
     * @author chaidongdong@suxuantech.cn
     */
    public function getFixedQuestion($rule,$apply_type,$test_id,&$msg){
        if($rule && !empty($rule)){
            $model_TTestQuestion = new TTestQuestion();
            $model_TQuestion = new TQuestion();
            $questions = [];
//            $apply_type = 1;
            foreach ($rule as $key=>$value){
//                if($key == '3' || $key == '4'){
//                    $apply_type = 2;
//                }
                foreach ($value as $k=>$v){
                    $question = $model_TQuestion->getOne(['id'=>$v['question_id']]);
                    $questions[$key][$k] = $question;
                    $questions[$key][$k]['score'] = $v['score'];
                    $questions[$key][$k]['answer'] = json_decode($question['answer'],true);
                    $insert_question[$key][$k] = ['question_id'=>$v['id'],'score'=>$value['score']];
                }
            }
            $question_list = json_encode($rule);
            $is_insert = 1;
            $testquestions = $model_TTestQuestion->getList(['test_id'=>$test_id]);
            foreach ($testquestions as $value){
                if($value['question_list'] == $question_list){
                    $is_insert = 2;
                    $id = $value['id'];
                    break;
                }
            }
            if($is_insert == 2){
                return ['id'=>$id,'question'=>$questions];
            }else{
                $insert = [
                    'test_id'=>$test_id,
                    'question_list'=>$question_list,
                    'apply_type'=>$apply_type
                ];
                $res = $model_TTestQuestion->tInsert($insert);
                if($res){
                    return ['id'=>$model_TTestQuestion->getLastInsID(),'question'=>$questions];
                }else{
                    $msg = '操作失败';
                    return false;
                }
            }
        }else{
            $msg = '请联系管理员';
            return false;
        }
    }

    /**
     * 获取随机试题
     * @param array $rule 规则
     * @param integer $test_id 考试ID
     * @param string &$msg 提示
     * @param integer $times 用于递归
     * @return mixed
     * @author chaidongdong@suxuantech.cn
     */
    public function getRandQuesion($rule,$test_id,&$msg,$times = 1){
        if($rule && $test_id){
            $model_TQuestion = new TQuestion();
            $model_TTest = new TTest();
            $question = [];
            $insert_question = [];
            $test = $model_TTest->getOne(['id'=>$test_id]);
            foreach($rule as $key => $value){
                //获取随机数据
                $question[$key] = $model_TQuestion->getList(['question_type'=>$key],'*',1,$value['num'],'RAND()');
                if(count($question[$key]) != $value['num']){
                    $msg = '题库数量不够，请联系管理员';
                    return false;
                }
                //整理数据
                foreach($question[$key] as $k => $v ){
                    $question[$key][$k]['score'] = $value['score'];
                    $question[$key][$k]['answer'] = json_decode($v['answer'],true);
                    $insert_question[$key][$k] = ['question_id'=>$v['id'],'score'=>$value['score']];
                }
            }
            $insert = ['test_id'=>$test_id,'apply_type'=>$test['apply_type'],'question_list'=>json_encode($insert_question)];
            $model_TTestQuestion = new TTestQuestion();
            $test_question_list = $model_TTestQuestion->getList(['test_id'=>$test_id]);
            if($test_question_list) {
                foreach ($test_question_list as $key => $value) {
                    if ($value['question_list'] == $insert['question_list']) {
                        if ($times < 3) {
                            $times++;
                            return $this->getRandQuesion($rule, $test_id, $msg, $times);
                        } else {
                            $id = $value['id'];
                            break;
                        }
                    }
                }
            }
            if($times<3){
                $res = $model_TTestQuestion->tInsert($insert);
                if($res){
                    return ['id'=>$model_TTestQuestion->getLastInsID(),'question'=>$question];
                }else{
                    $msg = '操作失败';
                    return false;
                }
            }else{
                return ['id'=>$id,'question'=>$question];
            }
//            $res = $model_TTestQuestion->getOne($insert);
//            if($res && $times < 3){
//                $times++;
//                return $this->getRandQuesion($rule,$test_id,$times);
//            }else{
//                if($times >= 3 && $res){
//                    return ['id'=>$res['id'],'question'=>$question];
//                }else{
//                    $res = $model_TTestQuestion->tInsert($insert);
//                    if($res){
//                        return ['id'=>$model_TTestQuestion->getLastInsID(),'question'=>$question];
//                    }else{
//                        $msg = '操作失败';
//                        return false;
//                    }
//                }
//            }
        }else{
            $msg = '请重新设置考题';
            return false;
        }
    }

    /**
     * 查看考试是否有效并返回考试信息
     * @param int $id
     * @return mixed
     * @author chaidongdong@suxuantech.cn
     */
    public function getTestValid($id){
        $date = date('Y-m-d H:i:s');
        $model_TTest = new TTest();
        $res = $model_TTest->getOne(['id'=>$id,'start_time'=>['s'=>'lt','v'=>$date],'end_time'=>['s'=>'gt','v'=>$date]]);
        if($res){
            return $res;
        }else{
            return false;
        }
    }

    /**
     * 前台获取所有有效的考试列表
     *
     * @param array $params
     * @return array
     * @author chaidongdong@suxuantech.cn
     */
    public function getStaffTestList($params = []){
        $model_TTest = new TTest();
        $date = date('Y-m-d H:i:s');
        $self_params = [
            'start_time'=>['s'=>'lt','v'=>$date],
            'end_time'=>['s'=>'gt','v'=>$date],
            'rule'=>['s'=>'neq','v'=>'NULL']
        ];
        if($params){
            $params = array_merge($params,$self_params);
        }else{
            $params = $self_params;
        }
        $tests = $model_TTest->getList($params,'*','','','create_time desc');
        return $tests;
    }

    /**
     * 前台用户获取最后一次考试情况
     *
     * @param integer $test_id
     * @param integer $staff_id
     * @return array 1:未考试 2：考试通过 3：考试未通过,4:正在审题
     * @author chaidongdong@suxuantech.cn
     */
    public function getLastStaffTest($test_id,$staff_id){
        $model_TTestAnswer = new TTestAnswer();
        $answer = $model_TTestAnswer->getOne(['test_id'=>$test_id,'answer_staff_id'=>$staff_id],'score,test_id,create_time','create_time desc');
        if($answer){
            if($answer['score'] >= 0){
                $model_TTest = new TTest();
                $test = $model_TTest->getOne(['id'=>$test_id]);
                if($test['pass_score'] <= $answer['score']){
                    return ['type'=>2,'test_id'=>$test_id,'score'=>$answer['score'],'amount_score'=>$test['amount_score']];
                }else{
                    return ['type'=>3,'test_id'=>$test_id,'score'=>$answer['score'],'amount_score'=>$test['amount_score']];
                }
            }else{
                return ['type'=>4];
            }
        }else{
            return ['type'=>1];
        }
    }

    /**
     * 前台用户获取考试情况
     *
     * @param integer $test_id
     * @param integer $staff_id
     * @return array
     * @author chaidongdong@suxuantech.cn
     */
//    public function getStaffTest($test_id,$staff_id){
//        $model_TTestAnswer = new TTestAnswer();
//        $answer = $model_TTestAnswer->getOne(['test_id'=>$test_id,'answer_staff_id'=>$staff_id],'*','create_time desc');
//        if($answer){
////            $answer['score'] = ($answer['score']=='-1') ? 0 : $answer['score'];
//            $model_TTest = new TTest();
//            $test = $model_TTest->getOne(['id'=>$test_id]);
//            if($answer['score'] >= $test['pass_score']){
//                return ['pass'=>1,'score'=>$answer['score'],'type'=>1];   //已经通过考试
//            }
//
//        }else{
//            return ['pass'=>0,'score'=>0,'type'=>0];
//        }
//        if($answer){
//            $answer['score'] = ($answer['score']=='-1') ? 0 : $answer['score'];
//            $answer['score'] = $answer['score'] ? $answer['score'] : 0;
//            $model_TTest = new TTest();
//            $test = $model_TTest->getOne(['id'=>$test_id]);
//            if($test['pass_score'] <= $answer['score']){
//                return ['pass'=>1,'score'=>$answer['score']];   //已经通过考试
//            }else{
//                $c = $this->checkStaffTestSupplement($test_id,$staff_id);
//                if(is_bool($c) && !$c){
//                    return ['pass'=>0,'score'=>$answer['score']];   //没有通过考试，并且不同意补考
//                }elseif (is_array($c)){
//                    return ['pass'=>0,'score'=>$answer['score'],'type'=>$c['type']];    //没有通过考试,允许考试
//                }
//            }
//        }else{
//            return ['pass'=>0,'score'=>$answer['score'],'type'=>0];
//        }
//    }

    /**
     * 判断是否可以参加考试或者补考
     *
     * @param integer $test_id
     * @param integer $staff_id
     * @return array 1:考试不存在 2：已经通过考试 3：不能参加补考 4:可以参加补考 5：首次参加考试 6：正在审核
     * @author chaidongdong@suxuantech.cn
     */
    public function checkStaffTestSupplement($test_id,$staff_id){
        $date = date('Y-m-d H:i:s');
        $model_TTest = new TTest();
        $test = $model_TTest->getOne([
            'id'=>$test_id,
            'start_time'=>['s'=>'lt','v'=>$date],
            'end_time'=>['s'=>'gt','v'=>$date],
            'rule'=>['s'=>'neq','v'=>'NULL']]
        );
        if($test){
            $model_TTestAnswer = new TTestAnswer();
            $answer = $model_TTestAnswer->getOne(['test_id'=>$test_id,'answer_staff_id'=>$staff_id],'*','create_time desc');
            if($answer){
                if($answer['score'] < 0 && isset($answer['score'])){
                    return ['type'=>6,'msg'=>'考试正在审核','score'=>0];
                }
                if($answer['amount_score'] >= $test['pass_score'] && isset($answer['score'])){
                    return ['type'=>2,'msg'=>'已经通过考试','score'=>$answer['score']];
                }
                $num = $test['supplement_num']+1;
                $count = $model_TTestAnswer->getCount(['test_id'=>$test_id,'answer_staff_id'=>$staff_id]);
                if($count < $num){
                    return ['type'=>4,'msg'=>'可以参加考试','score'=>$answer['amount_score']];
                }else{
                    return ['type'=>3,'msg'=>'不能参加考试','score'=>$answer['amount_score']];
                }
            }else{
                return ['type'=>5,'msg'=>'首次参加考试','score'=>0];
            }
        }else{
            return ['type'=>1,'msg'=>'考试不存在'];
        }
    }

    /**
     * 前台用户获取已参加的考试列表
     *
     * @param string $staff_id
     * @return array
     * @author chaidongdong@suxuantech.cn
     */
    public function getJoinTest($staff_id){
        $model_TTestAnswer = new TTestAnswer();
        $test_answer = $model_TTestAnswer->getList(['answer_staff_id'=>$staff_id],'*',false,false,'is_supplement desc');
        if($test_answer){
            $model_TTest = new TTest();
            $test_ids = [];
            foreach ($test_answer as $key => $value){
                if(!$test_ids[$value['test_id']]){
                    $test_ids[$value['test_id']] = $value['test_id'];
                }else{
                    unset($test_answer[$key]);
                }
            }
            $tests = $model_TTest->getList(['id'=>['s'=>'in','v'=>$test_ids]],'id,name,pass_score');
            foreach ($tests as $value){
                $test_name[$value['id']] = $value;
            }
            foreach ($test_answer as $key => $value){
                $test_answer[$key] = array_merge($test_answer[$key],$test_name[$value['test_id']]);
            }
            return $test_answer;
        }else{
            return [];
        }
    }

    /**
     * 获取考试考题
     *
     * @param integer $id
     * @return array
     * @author chaidongdong@suxuantech.cn
     */
    public function getTestQuestion($id){
        $model_TTestQuestion = new TTestQuestion();
        return $model_TTestQuestion->getOne(['id'=>$id]);
    }

    /**
     * 提交答卷
     *
     * @param integer $staff_id
     * @param integer $question_id
     * @param array $params
     * @return mixed
     * @author chaidongdong@suxuantech.cn
     */
    public function autoHandOverTest($staff_id,$question_id,$params,$staff_name){
        $model_TTestQuestion = new TTestQuestion();
        $question = $model_TTestQuestion->getOne(['id'=>$question_id]);
        if($question){
            $model_TTestAnswer = new TTestAnswer();
            $count = $model_TTestAnswer->getCount(['test_id'=>$question['test_id'],'answer_staff_id'=>$staff_id]);
            $insert = [
                'test_id'=>$question['test_id'],
                'test_question_id'=>$question['id'],
                'brandclass'=>session('brandclass'),
                'department_name'=>session('department_name'),
                'position_name'=>session('main_position_name'),
                'shop_code'=>session('shop_code'),
                'answer'=>json_encode($params),
                'answer_staff_id'=>$staff_id,
                'answer_staff_name'=>$staff_name,
                'create_time'=>date('Y-m-d H:i:s'),
                'is_supplement'=>$count ? $count : 0
            ];
            Db::startTrans();
            $res = $model_TTestAnswer->tInsert($insert);
            if($res){
                if($question['apply_type'] == '1'){
                    $res = $this->autoOverTest($model_TTestAnswer->getLastInsID());
                    if($res){
                        Db::commit();
                        return $res;
                    }else{
                        Db::rollback();
                        return false;
                    }
                }else{
                    Db::commit();
                    return true;
                }
            }else{
                Db::rollback();
                return false;
            }
        }else{
            return false;
        }
    }

    /**
     * 自动审题(单调用请使用数据库事务)
     *
     * @param integer $answer_id
     * @return array
     * @author chaidongdong@suxuantech.cn
     */
    public function autoOverTest($answer_id){
        $model_TTestAnswer = new TTestAnswer();
        $model_TQuestion = new TQuestion();
        $model_TTestQuestion = new TTestQuestion();
        $answer = $model_TTestAnswer->getOne(['id'=>$answer_id]);
        $testQuestion = $model_TTestQuestion->getOne(['id'=>$answer['test_question_id']]);
        $testQuestion['question_list'] = json_decode($testQuestion['question_list'],true);
        $ex_score = [];
        foreach ($testQuestion['question_list'] as $value){
            foreach ($value as $v){
                $ex_score[$v['question_id']] = $v['score'];
            }
        }
        $answer['answer'] = json_decode($answer['answer'],true);
        $score = 0;
        $single_answer = [];
        foreach ($answer['answer'] as $key=> $value){
            $question = $model_TQuestion->getOne(['id'=>$key]);
            $question['answer'] = json_decode($question['answer'],1);
            if(in_array($question['question_type'],[1,2])){ //单选和多选
                $question['answer']['answer'] =  (array)$question['answer']['answer'];
                ksort($question['answer']['answer']);
                $value = (array)$value;
                ksort($value);
                if($value == $question['answer']['answer']){
                    $score += $ex_score[$key];
                    $single_answer[$key] = $ex_score[$key];
                }else{
                    $single_answer[$key] = 0;
                }
            }else if($question['question_type'] == 3){
                $single_answer[$key] = 0;
                foreach ($value as $k=> $v){
                    if(trim($v) == trim($question['answer'][$k])){
                        $single_answer[$key] += $ex_score[$key];
                    }
                }
                $score += $single_answer[$key];
            }else{
                foreach ($question['answer'] as $v){
                    if(stripos($v,$value) === false){
                        $single_answer[$key] = 0;
                        break;
                    }
                }
                if($single_answer[$key] !== 0){
                    $single_answer[$key] = $ex_score[$key];
                }
                $score += $single_answer[$key];
            }
        }
        $res = $model_TTestAnswer->tUpdate(['sing_score'=>json_encode($single_answer)],['id'=>$answer_id]);
        if($res === false){
            return false;
        }
        $update = [
            'apply_time'=>date('Y-m-d H:i:s'),
            'score'=>$score,
            'amount_score'=>$score,
            'apply_staff_id'=>'0'
        ];
        $res = $model_TTestAnswer->tUpdate($update,['id'=>$answer_id]);
        if($res === false){
            return false;
        }
        return true;
    }

    /**
     * 获取单人考试最后一份答卷
     *
     * @param integer $test_id
     * @param integer $answer_staff_id
     * @return mixed
     * @author chaidongdong@suxauntech.cn
     */
    public function getStaffTestAnwer($test_id,$answer_staff_id){
        $model_TTestAnswer = new TTestAnswer();
        $answer = $model_TTestAnswer->getOne([
            'test_id'=>$test_id,
            'answer_staff_id'=>$answer_staff_id
        ],'*','create_time desc');
        if($answer){
            $question =  $this->formatStaffTestAnswer($answer);
            return ['question'=>$question,'answer'=>$answer];
        }
        return false;
    }

    /**
     * 生成审题二维码
     *
     * @param string $url
     * @param string $name
     * @return string
     * @author chaidongdong@suxuantech.cn
     */
    public function getApplyTestQrcode($url,$name){
        $path = ROOT_PATH.'public' . DS . 'upload'.DS.'test'.DS;
        if(!file_exists($path)){
            if (!mkdir($path, 0755, true)) {
                return false;
            }
        }
        $qrCode = new \Endroid\QrCode\QrCode();
        $qrCode->setText($url);
        if(file_exists($path.$name.'.png')){
            unlink($path.$name.'.png');
        }
        $res = $qrCode->writeFile($path.$name.'.png');
        if($res){
            return true;
        }else{
            return false;
        }

//        $url = $_SERVER['HTTP_HOST'].
    }

    /**
     * 判断用户是否拥有审题权限
     * (目前是只有创建用户才有审题权限)
     *
     * @param integer $test_id
     * @param integer $staff_id
     * @return bool
     * @author chaidongdong@suxuantech.cn
     */
    public function checkApplyTest($test_id,$staff_id){
        $model_TTest = new TTest();
        $test = $model_TTest->getOne(['id'=>$test_id]);
        if($test){
            if($test['create_staff_id'] == $staff_id){
                return true;
            }else{
                return false;
            }
        }else{
            return false;
        }
    }

    /**
     * 获取首次考试排名
     *
     * @param integer $test_id
     * @return array
     * @author chaidongdong@suxuantech.cn
     */
    public function getTestAnswerRanking($test_id){
        $model_TTestAnswer = new TTestAnswer();
        return $model_TTestAnswer->getList(['test_id'=>$test_id,'score'=>['s'=>'egt','v'=>'0'],'is_supplement'=>'0'],'*','','0','amount_score desc');
    }

    /**
     * 获取考试最后一次排名
     *
     * @param integer $test_id
     * @return array
     * @author chaidongdong@suxuantech.cn
     */
    public function getTestALlAnswerRanking($test_id){
        $model_TTestAnswer = new TTestAnswer();
        $data = $model_TTestAnswer->getList(['test_id'=>$test_id,'score'=>['s'=>'egt','v'=>'0']],'*','','0','amount_score desc');
        $return  = [];
        foreach ($data as $value){
            if(!$return[$value['answer_staff_id']] || ($return[$value['answer_staff_id']]['is_supplement'] < $value['is_supplement'] )){
                $return[$value['answer_staff_id']] = $value;
            }
        }
        return $return;
    }

    /**
     * 获取某次考试的所有考卷
     *
     * @param integer $test_id
     * @return $array
     * @author chaidongdong@suxuantech.cn
     */
    public function getTestAnswerList($test_id){
        $model_TTest = new TTest();
        $test = $model_TTest->getOne(['id'=>$test_id]);
        if($test){
            $model_TTestAnswet = new TTestAnswer();
            $answer = $model_TTestAnswet->getList(['test_id'=>$test_id],'*','1','0','create_time desc','answer_staff_id');
            if($answer){
                foreach ($answer as $key=>$value){
                    if($value['score'] >= 0 && $value['score'] >= $test['pass_score']){
                        $answer[$key]['pass'] = 1;
                    }
                }
            }
            return $answer;
        }else{
            return [];
        }
    }

    /**
     * 获取考试答卷
     *
     * @param integer $answer_id
     * @return array
     * @author chaidongdong@suxuantech.cn
     */
    public function getTestAnswer($answer_id){
       $model_TTestAnswer = new TTestAnswer();
       return $model_TTestAnswer->getOne(['id'=>$answer_id]);
    }

    /**
     * 获取用户考试答卷
     *
     * @param integer $staff_id
     * @param integer $test_id
     * @return array
     * @author chaidongdong@suxuantech.cn
     */
    public function getStaffTestAnswer($staff_id,$test_id){
        $model_TTestAnswer = new TTestAnswer();
        return $model_TTestAnswer->getList(['answer_staff_id'=>$staff_id,'test_id'=>$test_id]);
    }

    /**
     * 生成考试二维码
     *
     * @param string $url
     * @param string $name
     * @return bool
     * @author chaidongdong@suxuantech.cn
     */
    public function qrcodeTest($url,$name){
        $path = ROOT_PATH.'public' . DS . 'upload'.DS.'test'.DS;
        if(!file_exists($path)){
            if (!mkdir($path, 0755, true)) {
                return false;
            }
        }
        $qrCode = new \Endroid\QrCode\QrCode();
        $qrCode->setText($url);
        if(file_exists($path.$name.'.png')){
            unlink($path.$name.'.png');
        }
        $res = $qrCode->writeFile($path.$name.'.png');
        if($res){
            return true;
        }else{
            return false;
        }

    }

    /**
     * 格式化答案和对应考题
     *
     * @param array $answer
     * @return mixed
     * @author chaidongdong@suxuantech.cn
     */
    public function formatStaffTestAnswer($answer){
        $model_TTestQuestion = new TTestQuestion();
        $model_TQuestion = new TQuestion();
        $TestQuestion = $model_TTestQuestion->getOne(['id'=>$answer['test_question_id']]);
        $answer['answer'] = json_decode($answer['answer'],1);
        $answer['sing_score'] = json_decode($answer['sing_score'],1);
        $TestQuestion['question_list'] = json_decode($TestQuestion['question_list'],true);
        foreach ($TestQuestion['question_list'] as $key=>$value){
            foreach ($value as $k=>$v){
                $question = $model_TQuestion->getOne(['id'=>$v['question_id']]);
                if($question){
                    $question['answer'] = json_decode($question['answer'],true);

//                    $question['answer']['answer'] = is_array($question['answer']['answer']) ? $question['answer']['answer'] : [0=>$question['answer']['answer']];
                    if($question['question_type'] != 3 && $question['question_type'] !=4){
                        $question['answer']['answer'] = (array)$question['answer']['answer'];
                    }else{
                        $a = $question['answer'];
                        unset($question['answer']);
                        $question['answer']['answer'] = (array)$a;
                    }
                    $TestQuestion['question_list'][$key][$k]['question'] = $question;
                    $TestQuestion['question_list'][$key][$k]['staff_answer'] = (array)$answer['answer'][$v['question_id']];
                    $TestQuestion['question_list'][$key][$k]['staff_score'] = $answer['sing_score'][$v['question_id']] ? $answer['sing_score'][$v['question_id']] : 0;
                }else{
                    return false;
                }
            }
        }
        return $TestQuestion;
    }

    /**
     * 手动审题
     *
     * @param integer $test_id
     * @param integer $answer_id
     * @param integer $staff_id 审题人
     * @param array $params
     * @return array
     * @author chaidongdong@suxuantech.cn
     */
    public function handOverTest($test_id,$answer_id,$staff_id,$params){
        foreach ($params as $key=>&$value){
            $value = trim($value);
            if(!is_numeric($value) || $value < 0){
                return false;
            }
        }
        unset($value);
        $model_TTestAnswer = new TTestAnswer();
        $answer = $model_TTestAnswer->getOne(['id'=>$answer_id,'test_id'=>$test_id,'score'=>'-1']);
        if($answer){
            $answer_question_id = array_keys(json_decode($answer['answer'],true));
            ksort($answer_question_id);
            $apply_question_id = array_keys($params);
            ksort($apply_question_id);
            if(!array_diff($apply_question_id,$apply_question_id)){
                $model_testQuestion = new TTestQuestion();
                $testQuestion = $model_testQuestion->getOne(['id'=>$answer['test_question_id']]);
                $testQuestion['question_list'] = json_decode($testQuestion['question_list'],true);
                $score = 0;
                foreach ($testQuestion['question_list'] as $value){
                    foreach ($value as $k => $v){
                        if($v['score'] < $params[$v['question_id']]){
                            return false;
                        }
                        $score += $params[$v['question_id']];
                    }
                }
                $update = [
                    'score'=>$score,
                    'sing_score'=>json_encode($params),
                    'apply_staff_id'=>$staff_id,
                    'apply_time'=>date('Y-m-d H:i:s')
                ];
                $res = $model_TTestAnswer->tUpdate($update,['id'=>$answer_id]);
                if($res !== false){
                    return true;
                }else{
                    return false;
                }
            }else{
                return false;
            }
        }else{
            return false;
        }
    }

    /***
     * 查看考试总成绩列表
     *
     * @param integer $test_id
     * @return array
     * @author chaidongdong@suxuantech.cn
     */
    public function getTestAnswerResult($test_id){
        $model_TestAnswer = new TTestAnswer();
        $res = $model_TestAnswer->getList(['test_id'=>$test_id],'*','','','amount_score desc,is_supplement desc');
        $data = [];
        foreach ($res as $value){
            if(!$data[$value['answer_staff_id']]){
                $data[$value['answer_staff_id']] = $value;
            }
        }
        return $data;
    }

    /**
     * 导出首次考试和补考的考试成绩表
     *
     * @param integer $test_id
     * @return excel
     * @author chaidongdong@suxuantech.cn
     */
    public function export_excel($test_id){
        $model_TTest = new TTest();
        $test = $model_TTest->getOne(['id'=>$test_id]);
        $model_TTestAnswer = new TTestAnswer();
        $answer = $model_TTestAnswer->getList(['test_id'=>$test_id],'answer_staff_name,department_name,position_name,score,points,amount_score,is_supplement',false,false,'amount_score desc,create_time desc');
        $answer_list = [];
        $i = [];
        foreach ($answer as $value){
            $i[$value['is_supplement']]++;
            array_unshift($value,$i[$value['is_supplement']]);
            $s = $value;
            array_pop($s);
            $answer_list[$value['is_supplement']]['data'][] = $s;
            $answer_list[$value['is_supplement']]['title'] = ['排名','姓名','部门','职位','得分','加分','总分'];
            if($value['is_supplement'] == 0){
                $answer_list[$value['is_supplement']]['sheet_name'] = '首次考试成绩';
            }else{
                $answer_list[$value['is_supplement']]['sheet_name'] = '第'.$value['is_supplement'].'次补考成绩';
            }
        }
        return $this->export($answer_list,$test['name'].'考试成绩');
    }

    /**
     * 多个sheet xls格式导出
     *
     * @param array $data 包含头部、数据、sheet名称
     * @param string $filename
     * @return file
     * @author chaidongdong@suxuantech.cn
     */
    public function export($data,$filename){
        set_time_limit(0);
        $PHPExcel = new PHPExcel();
        $cacheMethod = \PHPExcel_CachedObjectStorageFactory::cache_in_memory_gzip;
        if (!\PHPExcel_Settings::setCacheStorageMethod($cacheMethod)) {
            die($cacheMethod . " 缓存方法不可用" . EOL);
        }
        $data = array_values($data);
        foreach ($data as $key => $value){
            if($key == 0){
                $PHPSheet = $PHPExcel->getActiveSheet()->setTitle($value['sheet_name']);
            }else{
                $PHPSheet = $PHPExcel->createSheet()->setTitle($value['sheet_name']);
            }
            $index = 1;
            for($i=0;$i<count($value['title']);$i++){
                $range[$i] = $this->stringFromColumnIndex($i);
                $PHPSheet->setCellValue($range[$i].$index, $value['title'][$i]);
            }
            foreach ($value['data'] as $v){
                $index++;
                $v = array_values($v);
                foreach ($v as $i=>$n){
                    $PHPSheet->setCellValue($range[$i].$index,$n);
                }
            }
        }
//        $PHPSheet = $PHPExcel->createSheet()->setTitle();
//        $PHPSheet->setTitle($filename); //给当前sheet设置名称
//        $index = 1;
//        for($i=0;$i<count($title);$i++){
//            $range[$i] = $this->stringFromColumnIndex($i);
//            $PHPSheet->setCellValue($range[$i].$index, $title[$i]);
//        }
//        foreach ($data as $value){
//            $index++;
//            $value = array_values($value);
//            foreach ($value as $k=>$v){
//                $PHPSheet->setCellValue($range[$k].$index,$v);
//            }
//        }

        $PHPWriter = PHPExcel_IOFactory::createWriter($PHPExcel,'Excel2007');
        header('Content-type: application/vnd.ms-excel');//告诉浏览器输出07Excel文件
        header('Content-Disposition: attachment;filename='.$filename.'.xlsx');//告诉浏览器输出浏览器名称
        header("Content-Description: File Transfer");
        header('Cache-Control: max-age=0');//禁止缓存
        header("Content-Transfer-Encoding: binary"); //告诉浏览器，这是二进制文件
        $PHPWriter->save("php://output");
        exit;
    }
    //获取指定个数的excel列名称
    public function stringFromColumnIndex($pColumnIndex = 0)
    {
        static $_indexCache = array();
        if (!isset($_indexCache[$pColumnIndex])) {
            if ($pColumnIndex < 26) {
                $_indexCache[$pColumnIndex] = chr(65 + $pColumnIndex);
            } elseif ($pColumnIndex < 702) {
                $_indexCache[$pColumnIndex] = chr(64 + ($pColumnIndex / 26)) . chr(65 + $pColumnIndex % 26);
            } else {
                $_indexCache[$pColumnIndex] = chr(64 + (($pColumnIndex - 26) / 676)) . chr(65 + ((($pColumnIndex - 26) % 676) / 26)) . chr(65 + $pColumnIndex % 26);
            }
        }
        return $_indexCache[$pColumnIndex];
    }


}