<?php
/**
 * CRM 实现模块
 * CRM的基本功能实现，如客资录入，客资查询等。
 * 所有业务的真正实现全在lib目录下建controller并且访问modle等，供controller层调用
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: chaidongdong<chaidongdong@suxuantech.cn> 2018-4-23 $
 */
namespace app\kf\lib;

use app\kf\model\TTraining;
use app\kf\model\TTrainingJoin;
use think\Db;
use PHPExcel_IOFactory;
use Excel5;
use PHPExcel;

class Training{

    //培训状态
    public $status = ['1'=>'正常','2'=>'暂停','3'=>'作废'];

    //用作xls定位
    public $word = [
            '1'=>'A','2'=>'B','3'=>'C','4'=>'D','5'=>'E',
            '6'=>'F','7'=>'G','8'=>'H','9'=>'I','10'=>'J',
            '11'=>'K','12'=>'L','13'=>'M','14'=>'N','15'=>'O',
            '16'=>'P','17'=>'Q','18'=>'R','19'=>'S','20'=>'T',
            '21'=>'U','22'=>'V','23'=>'W','24'=>'X','25'=>'Y',
            '26'=>'Z',
        ];

    /**
     * 获取培训数据
     *
     * @param array $params 参数
     * @return array
     * @author chaidongdong@suxuantech.cn
     */
    public function getTrainings($params = []){
        $model_TTraining = new TTraining();
        return $model_TTraining->getList($params);
    }

    /**
     * 页面获取培训列表(分页)
     *
     * @param array $params 参数
     * @return array
     * @author chaidongdong@suxuantech.cn
     */
    public function TrainingList($params = []){
        $page = $params['page'] ? $params['page'] : 1;
        $limit = intval($params['limit']) ? intval($params['limit']) : 10;
        $model_TTraining = new TTraining();
        if($params['key']){
            $filter = $params['key'];
        }
        $list = $model_TTraining->getList($filter,'*',$page,$limit,'create_time desc');
        $count = $model_TTraining->getCount($filter);
        if($count<1){
            return ['data'=>[], 'count'=>0];
        }else{
            return ['data'=>$list, 'count'=>$count];
        }
    }

    /**
     * 添加培训
     *
     * @param array $data 数据
     * @param string &$mess 提示
     * @return bool
     * @author chaidongdong@suxuantech.cn
     */
    public function addTraining($data,&$mess = ''){
        $f_data = [];
        if($data['id']){    //如果有ID就是修改
            $filter['id'] = $data['id'];
        }
        $f_data['title'] = trim($data['title']);
        if(!$f_data['title']){
            $mess = '请填写完整培训主题';
            return false;
        }
        $new_file = [];
        if($data['file']){
            foreach ($data['file'] as $value){
                $new_file[] = json_decode($value,true);
            }
        }
        $f_data['file'] = json_encode($new_file);
        $f_data['start_time'] = date('Y-m-d H:i:s',strtotime($data['start_time']));
        $f_data['end_time'] = date('Y-m-d H:i:s',strtotime($data['end_time']));
        $f_data['address'] = trim($data['address']);
        $f_data['content'] = trim($data['content']);
        $f_data['speaker'] = trim($data['speaker']);
        $f_data['img'] = trim($data['img']);
        if(!$filter['id']){
            $f_data['create_staff_id'] = $data['create_staff_id'];
            $f_data['create_time'] = date('Y-m-d H:i:s');
        }
        if(!in_array($data['status'], array_keys($this->status))){
            $mess = '培训状态错误';
            return false;
        }
        $f_data['status'] = $data['status'];
        $model_TTraining = new TTraining();
        if($filter){
            $res = $model_TTraining->tUpdate($f_data,$filter);
        }else{
            $res = $model_TTraining->tInsert($f_data);
        }
        if($res === false){
            $mess = '操作失败';
            return false;
        }
        return true;
    }

    /**
     * 获取单一培训
     *
     * @param array @params 条件
     * @return array
     * @author chaidongdong@suxauntech.cn
     */
    public function getOneTraining($params){
        $model_TTraining = new TTraining();
        $data = $model_TTraining->getOne($params);
        if($data){
            if($data['file']){
                $data['file'] = json_decode($data['file'],true);
                foreach ($data['file'] as $key => $value){
                    $data['file'][$key]['json'] = json_encode($value);
                }
            }
            if($data['tidbit']){
                $data['tidbit'] = json_decode($data['tidbit'],true);
                foreach ($data['tidbit'] as $key => $value){
                    $data['tidbit'][$key]['json'] = json_encode($value);
                }
            }
        }
        return $data;
    }

    /**
     * 获取文件大小
     *
     * @param string $path
     * @param int $prec
     * @return string
     */
    function tosize($path,$prec=2){
        $size = filesize($path);
        if($size){
            $rank=0;
            $unit="B";
            while($size>1024){
                $size=$size/1024;
                $rank++;
            }
            $size=round($size,$prec);
            switch ($rank){
                case "1":
                    $unit="KB";
                    break;
                case "2":
                    $unit="MB";
                    break;
                case "3":
                    $unit="GB";
                    break;
                case "4":
                    $unit="TB";
                    break;
                default :

            }
            return $size.$unit;
        }else{
            return 0;
        }
    }

    /**
     * 删除培训
     *
     * @param array $params 条件
     * @return bool
     * @author chaidongdong@suxuantech.cn
     */
    public function delTraining($params){
        $model_TTraining = new TTraining();
        return $model_TTraining->tDelete($params);
    }

    /**
     * 获取培训报名列表
     *
     * @param array $params 条件
     * @return array
     * @author chaidongdong@suxuantech.cn
     */
    public function getJoinSignTrainingList($params){
        $model_TTrainingJoin = new TTrainingJoin();
        return $model_TTrainingJoin->getList($params);
    }


    /**
     * 获取有效的培训列表
     * @param array $params 条件
     * @return array
     * @authro chaidongdong@suxuantech.cn
     */
    public function getTrainingValid($params = []){
        $date = date('Y-m-d H:i:s');
        $filter = [
            'start_time'=>[
                's'=>'lt',
                'v'=>$date,
            ],
            'end_time'=>[
                's'=>'gt',
                'v'=>$date
            ],
            'status'=>'1',
        ];
        $filter = array_merge($filter,$params);
        $model_TTraining = new TTraining();
        return $model_TTraining->getList($filter,'*','','','create_time desc');
    }

    /**
     * 图片上传（公用）
     *
     * @param string $name
     * @return string
     * @author chaidongdong@suxuantech.cn
     */
    public function upload_image($name = 'file'){
        $type = checkFileType($_FILES[$name]['tmp_name']);
        switch($type){
            case 'png':
            case 'jpg':
                $file = request()->file($name);
                // 移动到框架应用根目录/public/uploads/ 目录下
                $info = $file->move(ROOT_PATH.'public' . DS . 'upload/'.'pic',date(ymdHis).get_rand_string().'.jpg');
                if($info){
                    return   DS . 'upload/'.'pic/'.$info->getSaveName();
                }else{
                    return false;
                }
                break;
            default:
                return false;
        }
    }

    /**
     * 获取筛选的培训
     *
     * @param array $param
     * @param
     * @return array
     */
    function getTrainingList($filter = [], $field = '*', $page = '', $limit = '', $order = 'create_time desc', $group = ''){
        $model_TTraining = new TTraining();
        return $model_TTraining->getList($filter,$field,$page,$limit,$order,$group);
    }

    /**
     * 查看用户针对培训的报名和签到
     *
     * @param integer $training_id
     * @param integer $staff_id
     * @return mixed
     * @author chaidongdong@suxuantech.cn
     */
    public function checkTrainingJoin($training_id,$staff_id){
        $model_TTraining = new TTraining();
        $training = $model_TTraining->getOne([
            'id'=>$training_id,
            'end_time'=>['s'=>'gt','v'=>date('Y-m-d H:i:s')]
        ]);
        if($training){
            $model_TTrainingJoin = new TTrainingJoin();
            return $model_TTrainingJoin->getOne(['training_id'=>$training_id,'staff_id'=>$staff_id]);
        }else{
            return false;
        }
    }

    /**
     * 培训报名
     *
     * @param integer $training_id
     * @param integer $staff_id
     * @param string $staff_name
     * @return bool
     * @author chaidongdong@suxuantech.cn
     */
    public function joinTraining($training_id,$staff_id,$staff_name){
        $res = $this->checkTrainingJoin($training_id,$staff_id);
        if(!$res['join_time']){
            $model_TTrainingJoin = new TTrainingJoin();
            if(!$res){
                $data = [
                    'training_id'=>$training_id,
                    'staff_id'=>$staff_id,
                    'staff_name'=>$staff_name,
                    'join_time'=>date('Y-m-d H:i:s'),
                ];
                $res = $model_TTrainingJoin->tInsert($data);
                if($res){
                    return true;
                }else{
                    return false;
                }
            }else{
                $data = ['join_time'=>date('Y-m-d H:i:s')];
                $res = $model_TTrainingJoin->tUpdate($data,['id'=>$res['id']]);
                if($res !== false){
                    return true;
                }else{
                    return false;
                }
            }
        }else{
            return true;
        }
    }

    /**
     * 培训签到
     *
     * @param integer $training_id
     * @param integer $staff_id
     * @param string $staff_name
     * @return bool
     * @author chaidongdong@suxuantech.cn
     */
    public function signTraining($training_id,$staff_id,$staff_name){
        $res = $this->checkTrainingJoin($training_id,$staff_id);
        if(!$res['sign_time']){
            $model_TTrainingJoin = new TTrainingJoin();
            if(!$res){
                $data = [
                    'training_id'=>$training_id,
                    'staff_id'=>$staff_id,
                    'staff_name'=>$staff_name,
                    'sign_time'=>date('Y-m-d H:i:s'),
                ];
                $res = $model_TTrainingJoin->tInsert($data);
                if($res){
                    return true;
                }else{
                    return false;
                }
            }else{
                $data = ['sign_time'=>date('Y-m-d H:i:s')];
                $res = $model_TTrainingJoin->tUpdate($data,['id'=>$res['id']]);
                if($res !== false){
                    return true;
                }else{
                    return false;
                }
            }
        }else{
            return true;
        }
    }

//    /**
//     * 活动报名/签到二维码生成
//     *
//     * @param array $arr_url
//     * @return array
//     * @author chaidongdong@suxuangtech.cn
//     */
//    public function qrcodeTraining($arr_url){
//        if(!empty($arr_url)){
//            $path = ROOT_PATH.'public' . DS . 'upload'.DS.'training'.DS;
//            $qrCode = new \Endroid\QrCode\QrCode();
//            header('Content-Type: '.$qrCode->getContentType());
//            foreach ($arr_url as $key=>$value){
//                $png_path = $path.$key.'.png';
//                if(file_exists($png_path)){
//                    unlink($png_path);
//                }
//                $qrCode->getText($value);
//                $res = $qrCode->writeFile($png_path);
//                if(!$res){
//                    return false;
//                }
//            }
//            $url = '/upload/';
//        }
//        return [];
////        $path = ROOT_PATH.'public' . DS . 'upload'.DS.'training'.DS;
////        if(!file_exists($path)){
////            if (!mkdir($path, 0755, true)) {
////                return false;
////            }
////        }
////        $qrCode = new \Endroid\QrCode\QrCode('1');
////        header('Content-Type: '.$qrCode->getContentType());
////        $res = $qrCode->writeFile($path.'/qrcode.png');
////        dd($res);
//    }

    /**
     * 生成二维码
     *
     * @param string $url
     * @param string $name
     * @return bool
     * @throws \Endroid\QrCode\Exception\InvalidWriterException
     */
    public function qrcodeTraining($url,$name){
        $path = ROOT_PATH.'public' . DS . 'upload'.DS.'training'.DS;
        if(!file_exists($path)){
            if (!mkdir($path, 0755, true)) {
                return false;
            }
        }
        $qrCode = new \Endroid\QrCode\QrCode();
        $qrCode->setText($url);
        if(file_exists($path.$name.'.png')){
            unlink($path.$name.'.png');
        }
        $res = $qrCode->writeFile($path.$name.'.png');
        if($res){
            return true;
        }else{
            return false;
        }
    }

    /**
     * 获取培训内容
     *
     * @param array $params
     * @return array
     */
    public function getTrainingInfo($params = []){
        $model_TTraining = new TTraining();
        return $model_TTraining->getOne($params);
    }

    /**
     * 获取视频第一秒第一帧
     *
     */
    public function getVideoCover($file,$time,$name) {
        if(empty($time))$time = '1';//默认截取第一秒第一帧
        $strlen = strlen($file);
        // $videoCover = substr($file,0,$strlen-4);
        // $videoCoverName = $videoCover.'.jpg';//缩略图命名
        //exec("ffmpeg -i ".$file." -y -f mjpeg -ss ".$time." -t 0.001 -s 320x240 ".$name."",$out,$status);
        $str = "ffmpeg -i ".$file." -y -f mjpeg -ss 3 -t ".$time." -s 320x240 ".$name;
        //echo $str."</br>";
        $result = system($str);
    }

    /**
     * 培训上传附件
     *
     * @param file $data
     * @param integer $trining_id
     * @param string &msg
     * @return array
     * @author chaidongdong@suxuantech.cn
     */
    public function uploadFile($data,$trining_id,&$msg){
        if($data['error'] == 0){
//            $postfix = [
//                'xls',
//                'docx',
//                'doc',
//                'zip',
//                'mp4',
//                'txt'
//            ];
            $name_postfix =  strrev(explode('.', strrev($data['name']))[0]);
            $file_name = $this->getNewTriningFileName($trining_id);
            $path = ROOT_PATH.'public' . DS . 'upload'.DS.'training'.DS.'file'.DS;
            if(!file_exists($path)){
                if (!mkdir($path, 0755, true)) {
                    return false;
                }
            }
            $path_file = $path.$file_name.'.'.$name_postfix;
            if(file_exists($path_file)){
                unlink($path_file);
            }
            $link_path = '/upload'.DS.'training'.DS.'file'.DS.$file_name.'.'.$name_postfix;
            if(move_uploaded_file($data['tmp_name'],$path_file)){
                $size = $this->tosize($path_file);
                if($trining_id){
                    return $this->setTriningFile(['link_path'=>$link_path,'name'=>$data['name']]);
                }
                return ['name'=>$data['name'],'link_path'=>$link_path,'size'=>$size];
            }else{
                $msg = '文件上传失败';
                return false;
            }
        }else{
            $msg = '文件错误';
            return false;
        }
    }

    /**
     * 修改培训附件
     *
     * @param integer $trining_id
     * @param mixed $params
     * @param string $type:默认add
     * @return bool
     * @author chaidongdong@suxuantech.cn
     */
    public function saveTriningFile($trining_id,$params ,$type = 'add'){
        $model_TTraining = new TTraining();
        $training = $model_TTraining->getOne(['id'=>$trining_id]);
        if($training){
            $file_list = @json_decode($training['file'],true);
            if($type == 'add'){
                $file_list[] = [
                    'name'=>$params['name'],
                    'link_path'=>$params['link_path']
                ];
            }else{
                unset($file_list[$params]);
            }
            $file_list = @json_encode($file_list);
            $res = $model_TTraining->tUpdate(['file'=>$file_list],['id'=>$trining_id]);
            if($res !== false){
                return true;
            }else{
                return false;
            }
        }else{
            return false;
        }
    }

    /**
     * 生成培训上传文件名称
     *
     * $param integer $trining_id
     * @return string
     * @author chaidongdong@suxuantech.cn
     */
    public function getNewTriningFileName($trining_id){
        return substr(md5($trining_id.date('Y-m-d H:i:s').rand(1,100)),10,10);
    }

    /**
     * 修改培训花絮
     *
     * @param array $tiddit
     * @param array $params
     * @return bool
     */
    public function saveTrainingTidbit($tiddit,$params){
        $tiddit = json_encode($tiddit);
        $model_TTraining = new TTraining();
        $res = $model_TTraining->tUpdate(['tidbit'=>$tiddit],$params);
        if($res === false){
            return false;
        }else{
            return true;
        }
    }

    /**
     * 简单xls格式导出
     *
     * @param array $title
     * @param array $data
     * @param string $filename
     * @return file
     * @author chaidongdong@suxuantech.cn
     */
    public function export($title,$data,$filename){
        set_time_limit(0);
        $PHPExcel = new PHPExcel();
        $cacheMethod = \PHPExcel_CachedObjectStorageFactory::cache_in_memory_gzip;
        if (!\PHPExcel_Settings::setCacheStorageMethod($cacheMethod)) {
            die($cacheMethod . " 缓存方法不可用" . EOL);
        }
        $PHPSheet = $PHPExcel->getActiveSheet();
        $PHPSheet->setTitle($filename); //给当前活动sheet设置名称
        $index = 1;
        for($i=0;$i<count($title);$i++){
            $range[$i] = $this->stringFromColumnIndex($i);
            $PHPSheet->setCellValue($range[$i].$index, $title[$i]);
        }
        foreach ($data as $value){
            $index++;
            $value = array_values($value);
            foreach ($value as $k=>$v){
                $PHPSheet->setCellValue($range[$k].$index,$v);
            }
        }
        $PHPWriter = PHPExcel_IOFactory::createWriter($PHPExcel,'Excel2007');
        header('Content-type: application/vnd.ms-excel');//告诉浏览器输出07Excel文件
        header('Content-Disposition: attachment;filename='.$filename.'.xlsx');//告诉浏览器输出浏览器名称
        header("Content-Description: File Transfer");
        header('Cache-Control: max-age=0');//禁止缓存
        header("Content-Transfer-Encoding: binary"); //告诉浏览器，这是二进制文件
        $PHPWriter->save("php://output");
        exit;
    }

    //获取指定个数的excel列名称
    public function stringFromColumnIndex($pColumnIndex = 0)
    {
        static $_indexCache = array();
        if (!isset($_indexCache[$pColumnIndex])) {
            if ($pColumnIndex < 26) {
                $_indexCache[$pColumnIndex] = chr(65 + $pColumnIndex);
            } elseif ($pColumnIndex < 702) {
                $_indexCache[$pColumnIndex] = chr(64 + ($pColumnIndex / 26)) . chr(65 + $pColumnIndex % 26);
            } else {
                $_indexCache[$pColumnIndex] = chr(64 + (($pColumnIndex - 26) / 676)) . chr(65 + ((($pColumnIndex - 26) % 676) / 26)) . chr(65 + $pColumnIndex % 26);
            }
        }
        return $_indexCache[$pColumnIndex];
    }


}