<?php
/**
 * KF 实现模块
 * KF的基本功能实现，如客资录入，客资查询等。
 * 所有业务的真正实现全在lib目录下建controller并且访问modle等，供controller层调用
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: wangyining<wangyining@suxuantech.cn> 2018-04-11 $
 */
namespace app\kf\lib;
use think\Cache;
use think\Controller;
use PHPExcel_IOFactory;
use Excel5;
use PHPExcel;
use app\common\lib\redisQueue;
use think\Exception;
use think\Db;
class Visit extends Controller{

    /**
     * 调用erp接口获取订单信息
     */
    public function orderListData($params){
        ini_set('memory_limit','-1');

        $page = $params['page'] ? $params['page'] : 1;
        $limit = $params['limit'] ? $params['limit'] : 10;

        if($params['tabs']&&$params['tabs']!='new_order'){

            $params['time_type'] = $params['order_link'] ? 'order_time' : 'visit_time';//选择订单环节则查订单信息，没有则查回访日期
            $sql=$this->getSql($params);

            switch ($params['tabs']){

                case 'today_visit'://当日领取回访单
                    $today=date('Y-m-d',time());
                    $before_time=date("Y-m-d",strtotime("$today -1 day"));
                    $after_time=date("Y-m-d",strtotime("$today +1 day"));
                    $sql .= " and visit_staff_number = '".session('staff_number')."' and (visit_time between '".$before_time."'and '".$after_time."') ";
                    break;
                case 'visiting'://回访中
                    $sql .= " and visit_staff_number = '".session('staff_number')."' and is_valid = 2 ";
                    break;
                case 'over_visit'://回访成功
                    $sql .= " and visit_staff_number = '".session('staff_number')."' and is_valid = 1 ";
                    break;
                case 'fail_visit'://回访失败
                    $sql .= " and visit_staff_number = '".session('staff_number')."' and is_valid = 3 ";
                    break;
                case 'my_visit'://我的回访
                    $sql .= " and visit_staff_number = '".session('staff_number')."' ";
                    break;
                default:
                    $sql = $sql;

            }

            if($params['data_type'] == 'all'){
                $res= db('k_order')->where($sql)->select();
            }else{
                $res= db('k_order')->where($sql)->page($page,$limit)->select();
            }

            //print_r(db()->getlastsql());die;
            $count = db('k_order')->where($sql)->count();

        }else{

            $orderId = $params['orderId'];
            $order_link = $params['order_link'];

            if($params['start_time']){
                $start_time=date('Ymd',strtotime($params['start_time']));
            }
            if($params['end_time']){
                $end_time=date('Ymd',strtotime($params['end_time']));
            }

            $shop_code=$params['shop_code'];
            unset($params['shop_code']);

            $erp = config('ext.app_config');  //读取erp配置文件
            $addr = $erp['sx_erp']['addr'];  //调用url

            //if(session('grade_type') != 1){
                $sessionBrandId = $params['brand_id'];
            //}

            $page=$page-1;

            if($params['data_type'] == 'all'){
                $page = 0;
                $limit = 0;
            }


            if($order_link&&$order_link=='order'){//已订单
                $dataUrl=$addr.'/SX_CustomerService/SX_InquireCustomerInfoKF?Token=^******^&StartDate='.$start_time.'&EndDate='.$end_time.'&orderid='.$orderId.'&pageIndex='.$page.'&pageSize='.$limit.'&Code='.$shop_code.'&cxtype=0&brandid='.$sessionBrandId;
                $CountUrl=$addr.'/SX_CustomerService/SX_InquireCustomerInfoKF?Token=^******^&StartDate='.$start_time.'&EndDate='.$end_time.'&orderid='.$orderId.'&pageIndex=0&pageSize=0&Code='.$shop_code.'&cxtype=0&brandid='.$sessionBrandId;
            }else if($order_link&&$order_link=='photo'){//已拍照
                $dataUrl=$addr.'/SX_CustomerService/SX_CustomerPhotoInfoKF?Token=^******^&StartDate='.$start_time.'&EndDate='.$end_time.'&orderid='.$orderId.'&pageIndex='.$page.'&pageSize='.$limit.'&Code='.$shop_code.'&PZID=&State=2&brandid='.$sessionBrandId;
                $CountUrl=$addr.'/SX_CustomerService/SX_CustomerPhotoInfoKF?Token=^******^&StartDate='.$start_time.'&EndDate='.$end_time.'&orderid='.$orderId.'&pageIndex=0&pageSize=0&Code='.$shop_code.'&PZID=&State=2&brandid='.$sessionBrandId;
            }else if($order_link&&$order_link=='sp'){//已选片
                $dataUrl=$addr.'/SX_CustomerService/SX_CustomerXuanPianKF?Token=^******^&StartDate='.$start_time.'&EndDate='.$end_time.'&orderid='.$orderId.'&pageIndex='.$page.'&pageSize='.$limit.'&Code='.$shop_code.'&XPID=&State=1&brandid='.$sessionBrandId;
                $CountUrl=$addr.'/SX_CustomerService/SX_CustomerXuanPianKF?Token=^******^&StartDate='.$start_time.'&EndDate='.$end_time.'&orderid='.$orderId.'&pageIndex=0&pageSize=0&Code='.$shop_code.'&XPID=&State=1&brandid='.$sessionBrandId;
            }else if($order_link&&$order_link=='jg'){//已校稿
                $dataUrl=$addr.'/SX_CustomerService/SX_CustomerKanBanKF?Token=^******^&StartDate='.$start_time.'&EndDate='.$end_time.'&orderid='.$orderId.'&pageIndex='.$page.'&pageSize='.$limit.'&Code='.$shop_code.'&XPID=&State=1&brandid='.$sessionBrandId;
                $CountUrl=$addr.'/SX_CustomerService/SX_CustomerKanBanKF?Token=^******^&StartDate='.$start_time.'&EndDate='.$end_time.'&orderid='.$orderId.'&pageIndex=0&pageSize=0&Code='.$shop_code.'&XPID=&State=1&brandid='.$sessionBrandId;
            }else if($order_link&&$order_link=='qj'){//已取件
                $dataUrl=$addr.'/SX_CustomerService/SX_InquireCustomerInfoKF?Token=^******^&StartDate='.$start_time.'&EndDate='.$end_time.'&orderid='.$orderId.'&pageIndex='.$page.'&pageSize='.$limit.'&Code='.$shop_code.'&cxtype=1&brandid='.$sessionBrandId;
                $CountUrl=$addr.'/SX_CustomerService/SX_InquireCustomerInfoKF?Token=^******^&StartDate='.$start_time.'&EndDate='.$end_time.'&orderid='.$orderId.'&pageIndex=0&pageSize=0&Code='.$shop_code.'&cxtype=1&brandid='.$sessionBrandId;
            }

            //print_r($params);die;
            if($params['visit_object'] && $params['visit_staff_name']){
                $sqlwhere = " and ".$params['visit_object']." = '".$params['visit_staff_name']."'";
                $jsonParam = json_encode(['sqlwhere'=>$sqlwhere]);
            }else{
                $jsonParam = json_encode(['sqlwhere'=>'']);
            }
            //print_r($jsonParam);
            //print_r($dataUrl);

            $response = requestERP($dataUrl,$jsonParam);  //调用erp接口
            //print_r($response);die;
            if ($response['Code'] == 200) {
                $res=$response['Data'];
            }
            //print_r($res);die;

            //$params['time_type'] = 'order_time';
            $where = $this->getSql($params);
            $myData= db('k_order')->where($where)->select();
            //print_r(db()->getlastsql());die;
            $orderIdArray = [];  //单号
            $onlyArray = [];     //表id + 单号
            $is_valid_array = [];//回访状态。完成、下次继续回访、无效
            $connect_phone_array = [];//回访接通电话
            $visit_staff = []; //回访人
            $have_ks = [];     //是否有客诉
            foreach($myData as $k => $v){
                $orderIdArray[] = $v['orderId'];
                $onlyArray[] = $v['this_id'].$v['orderId'];
                $is_valid_array[$v['this_id'].$v['orderId']] = $v['is_valid'];//是否有效
                $connect_phone_array[$v['this_id'].$v['orderId']] = $v['connect_phone'];//接通电话
                $visit_staff[$v['this_id'].$v['orderId']] = $v['visit_staff_name'];//回访人
                $have_ks[$v['this_id'].$v['orderId']] = $v['have_ks'];
            }

            //print_r($onlyArray);die;
            foreach($res as $kk => $vv){
                if(in_array($vv['id'].$vv['orderId'],$onlyArray)){
                    $res[$kk]['order_link'] = '已领取';
                    $res[$kk]['is_valid'] = $is_valid_array[$vv['id'].$vv['orderId']];
                    $res[$kk]['connect_phone']    = $connect_phone_array[$vv['id'].$vv['orderId']];
                    $res[$kk]['visit_staff_name'] = $visit_staff[$vv['id'].$vv['orderId']];
                    $res[$kk]['have_ks']  = $have_ks[$vv['id'].$vv['orderId']];
                }else{
                    $res[$kk]['order_link'] = '未领取';
                }

                if(in_array($vv['orderId'],$orderIdArray)){
                    $res[$kk]['already_visit'] = '回访过';
                }else{
                    $res[$kk]['already_visit'] = '未回访';
                }
            }

            $countResponse = requestERP($CountUrl,$jsonParam);  //调用erp接口
            if ($countResponse['Code'] == 200) {
                $count=count($countResponse['Data']);
            }
        }


        /*列表展示回访分数-----start----*/
        $orderIds = array_column($res,'orderId');
        $score = db('k_score_list')->where('orderId','in',$orderIds)->select();

        $visitObj = db('k_visit_link_object')
            ->where(['link'=>$params['order_link']])
            ->alias('a')
            ->join('k_visit_object b','a.object_code = b.code','left')
            ->where('b.is_show',1)
            ->order('a.id asc')
            ->select();

        $option_score = [];
        foreach($visitObj as $k => $v){

            foreach($score as $key => $val){

                if($v['code'] == $val['visit_object']){
                    if(explode('-',$v['option_code'])[1] == 'service'){
                        $option_score[$val['this_id'].$val['orderId']][$v['code']] .=  $val['service_score'] ? '|服务'.$val['service_score'] : '';
                    }else{
                        $option_score[$val['this_id'].$val['orderId']][$v['code']] .= $val['professional_score'] ? '|专业'.$val['professional_score'] : '';
                    }
                }
            }

        }

        foreach($res as $key => $value){
            $onlySign = $value['this_id'].$value['orderId'];

            $storeconsuitant1 = $option_score[$onlySign]['storeconsuitant1'] ? '('.trim($option_score[$onlySign]['storeconsuitant1'],'|').')' : '';
            $res[$key]['storeconsuitant1'] = $value['storeconsuitant1'] . $storeconsuitant1;

            $storeconsuitant2 = $option_score[$onlySign]['storeconsuitant2'] ? '('.trim($option_score[$onlySign]['storeconsuitant2'],'|').')' : '';
            $res[$key]['storeconsuitant2'] = $value['storeconsuitant2'] . $storeconsuitant2;

            $dresser = $option_score[$onlySign]['dresser'] ? '('.trim($option_score[$onlySign]['dresser'],'|').')' : '';
            $res[$key]['dresser'] = $value['dresser'] . $dresser;

            $huazhuangzhuli = $option_score[$onlySign]['huazhuangzhuli'] ? '('.trim($option_score[$onlySign]['huazhuangzhuli'],'|').')' : '';
            $res[$key]['huazhuangzhuli'] = $value['huazhuangzhuli'] . $huazhuangzhuli;

            $cameraman = $option_score[$onlySign]['cameraman'] ? '('.trim($option_score[$onlySign]['cameraman'],'|').')' : '';
            $res[$key]['cameraman'] = $value['cameraman'] . $cameraman;

            $photoassistant = $option_score[$onlySign]['photoassistant'] ? '('.trim($option_score[$onlySign]['photoassistant'],'|').')' : '';
            $res[$key]['photoassistant'] = $value['photoassistant'] . $photoassistant;

            $secretaireman = $option_score[$onlySign]['secretaireman'] ? '('.trim($option_score[$onlySign]['secretaireman'],'|').')' : '';
            $res[$key]['secretaireman'] = $value['secretaireman'] . $secretaireman;

            $zhuozhuangshi = $option_score[$onlySign]['zhuozhuangshi'] ? '('.trim($option_score[$onlySign]['zhuozhuangshi'],'|').')' : '';
            $res[$key]['zhuozhuangshi'] = $value['zhuozhuangshi'] . $zhuozhuangshi;

            $selectman = $option_score[$onlySign]['selectman'] ? '('.trim($option_score[$onlySign]['selectman'],'|').')' : '';
            $res[$key]['selectman'] = $value['selectman'] . $selectman;

            $kanbanshi = $option_score[$onlySign]['kanbanshi'] ? '('.trim($option_score[$onlySign]['kanbanshi'],'|').')' : '';
            $res[$key]['kanbanshi'] = $value['kanbanshi'] . $kanbanshi;

            $qj_renname = $option_score[$onlySign]['qj_renname'] ? '('.trim($option_score[$onlySign]['qj_renname'],'|').')' : '';
            $res[$key]['qj_renname'] = $value['qj_renname'] . $qj_renname;

            $storeconsuitant4 = $option_score[$onlySign]['storeconsuitant4'] ? '('.trim($option_score[$onlySign]['storeconsuitant4'],'|').')' : '';
            $res[$key]['storeconsuitant4'] = $value['storeconsuitant4'] . $storeconsuitant4;
        }
        /*列表展示回访分数-----end----*/


        $result['code'] = 0;
        $result['msg'] = '';

        if($res){
            $result['data'] = $res;
            $result['count'] = $count;
        }else{
            $result['data'] = array();
            $result['count'] = 0;
        }

        return $result;
    }

    public function orderNum($params){
        $params['time_type'] = $params['order_link'] ? 'order_time' : 'visit_time';//选择订单环节则查订单信息，没有则查回访日期

        $sql = $this->getSql($params);
        $ksSql = $this->getKsSql($params);

        $today=date('Y-m-d',time());
        $before_time=date("Y-m-d",strtotime("$today -1 day"));
        $after_time=date("Y-m-d",strtotime("$today +1 day"));

        $num['today_visit_num'] = db('k_order')->where('visit_staff_number',session('staff_number'))->where('visit_time', 'between time', [$before_time, $after_time])->where($sql)->count();
        $num['visiting_num'] = db('k_order')->where('is_valid',2)->where('visit_staff_number',session('staff_number'))->where($sql)->count();
        $num['over_visit_num'] = db('k_order')->where('is_valid',1)->where('visit_staff_number',session('staff_number'))->where($sql)->count();
        //print_r(db()->getlastsql());die;
        $num['fail_visit_num'] = db('k_order')->where('is_valid',3)->where('visit_staff_number',session('staff_number'))->where($sql)->count();
        $num['my_visit_num']   = db('k_order')->where('visit_staff_number',session('staff_number'))->where($sql)->count();
        $num['my_ks_num']   = db('k_work_order')->where('create_staff_number',session('staff_number'))->where('source_id',1)->where($ksSql)->count();

        $num['not_check_num']   = db('k_work_order')->where('check_staff_number',session('staff_number'))->where('source_id',1)->where('is_ks',2)->where($ksSql)->count();

        return $num;
    }

    /*
     * 获取查询条件sql
    */

    public function getSql($data){

         $sql = " 1=1 ";
         $end_time=$data['end_time'];
         if (!empty($data)) {
             if($data['orderId'])      $sql .= " and (wname like '%".$data['orderId']."%' or mname like '%".$data['orderId']."%'  or wphone like '%".$data['orderId']."%'  or mphone like '%".$data['orderId']."%'  or orderId like '%".$data['orderId']."%') ";
             if($data['shop_code'])    $sql .= " and shop_code = '" . $data['shop_code'] . "' ";
             if($data['order_link'])   $sql .= " and order_link = '" . $data['order_link'] . "' ";

             if($data['order_link']&&!empty($data['order_link'])){

                 if($data['time_type']){
                     if($data['start_time'])      $sql .= " and ".$data['time_type']." >= '".$data['start_time']."' ";
                     if($data['end_time'])        $sql .= " and ".$data['time_type']." < '".date("Y-m-d",strtotime("$end_time +1 day"))."' ";
                 }

             }

             //服务人员
             if($data['visit_object'] && $data['visit_staff_name']){
                 $visit_object = explode('.',$data['visit_object'])[1];
                 $sql .= " and ".$visit_object." = '".$data['visit_staff_name']."' ";
             }
         }

        if(session('grade_type') != 1){
            $sql .= " and brand_id = '".session('brandclass_id')."'";
        }else{
            if($data['brand_id'])    $sql .= " and brand_id = '" . $data['brand_id'] . "' ";
        }

        return $sql;
    }


    /*
     * 回访中心发起的客诉列表
     */
    public function workListData($params){
        $page = $params['page'] ? $params['page'] : 1;
        $limit = $params['limit'] ? $params['limit'] : 10;
        $sql = $this->getKsSql($params);

        switch ($params['tabs']){

            case 'my_ks'://我的客诉
                $sql .= " and create_staff_number = '".session('staff_number')."' and source_id = 1 ";
                break;
            case 'not_check'://待审核客诉
                $sql .= " and check_staff_number = '".session('staff_number')."' and is_ks = 2 and source_id = 1 ";
                break;
            default:
                $sql = $sql;

        }

        if($params['data_type'] == 'all'){
            $result['data']  = db('k_work_order')->where($sql)->select();
        }else{
            $result['data']  = db('k_work_order')->where($sql)->page($page,$limit)->select();
        }

        $result['count'] = db('k_work_order')->where($sql)->count();
        $result['code'] = 0;
        $result['msg'] = '';
        return $result;
    }

    /*
     * 获取客诉sql
     */
    public function getKsSql($data){
        $sql = " 1=1 ";
        $end_time=$data['end_time'];
        if (!empty($data)) {
            if($data['orderId'])       $sql .= " and (w_name like '%".$data['orderId']."%' or m_name like '%".$data['orderId']."%'  or w_phone like '%".$data['orderId']."%'  or m_phone like '%".$data['orderId']."%'  or order_number like '%".$data['orderId']."%') ";
            if($data['shop_code'])    $sql .= " and shop_code = '" . $data['shop_code'] . "' ";
            if($data['start_time'])      $sql .= " and create_time >= '".$data['start_time']."' ";
            if($data['end_time'])        $sql .= " and create_time < '".date("Y-m-d",strtotime("$end_time +1 day"))."' ";

        }
        return $sql;
    }


    /**
     * 修改订单信息，以及回访记录
     */
    public function addVisit($params){
        $scoreArr = json_decode($params['scoreArr'],true);
        //print_r($scoreArr);die;

        $visitID=$params['visitID'];
        if($params['is_valid'])            $orderData['is_valid']=$params['is_valid'];
        if($params['invalid_reason'])      $orderData['invalid_reason']=$params['invalid_reason'];
        if($params['advice'])              $orderData['advice']=$params['advice'];
        if($params['lowstand'])            $orderData['lowstand']=$params['lowstand'];
        if($params['research'])            $orderData['research']=$params['research'];
        $orderData['visit_time'] = date('Y-m-d H:i:s');
        $orderData['connect_phone'] = $params['connect_phone'];//接通的是男士还是女士电话
        db('k_order')->where('id',$visitID)->update($orderData);
        $lastVisit=db('k_order')->where('id',$visitID)->find();

//        if($lastVisit&&$lastVisit['visit_staff_number']!=session('staff_number')){
//            return array('code'=>0,'msg'=>'此订单已被他人回访');
//        }
//        $visitID=$lastVisit['id'];

        //调研结果
        $research = $params['research'];
        if($research){
            $addResearch = [];
            $nowTime = date('Y-m-d H:i:s');
            foreach($research as $k => $v){
                $arr['order_id'] = $visitID;
                $arr['q_id'] = $k;
                $arr['q_text'] = $v['question'];
                $arr['answer_text'] = $v['answer'];
                $arr['create_time'] = $nowTime;
                $addResearch[] = $arr;
            }
        }

        db()->startTrans();//开启事务
        try{
            if($params['keywords']){//关键词
                $orderData['keywords']=$lastVisit['keywords']?$lastVisit['keywords'].','.$params['keywords']:$params['keywords'];
                $is_key=db('s_keywords')->where('keyword',$params['keywords'])->find();
                if($is_key){
                    db('s_keywords')->where('keyword',$params['keywords'])->update(['num'=>['exp',"num + 1"]]);
                }else{
                    db('s_keywords')->insert(['keyword'=>$params['keywords'],'num'=>1]);
                }
            }
//            if(!$lastVisit){
//                $orderData['first_visit_time']=$orderData['visit_time'];
//                $visitID=db('k_order')->insertGetId($orderData);
//            }else{

//            }

            $visitData['visit_order_id'] = $visitID;
            $visitData['orderId']    = $params['orderId'];
            $visitData['this_id']    = $params['this_id'];
            $visitData['customerid'] = $params['customerid'];
            $visitData['order_link'] = $params['order_link'];
            $visitData['visit_way']  = $params['visit_way'];
            $visitData['is_visit']   = $params['is_visit'];
            $visitData['duration']   = $params['duration'];//通话时长
            $visitData['is_valid']   = $params['is_valid'];//是否有效通话
            $visitData['tel_recording'] = $params['tel_recording'];//通话记录文件
            $visitData['connect_phone'] = $params['connect_phone'];//接通的是男士还是女士电话
            $visit_tel=$this->getRule('visit_tel');
            if($params['duration']<=$visit_tel){
                $visitData['is_get_valid']=2;
            }else{
                $visitData['is_get_valid']=1;
            }
            $visitData['note']        = $params['note'];
            $visitData['visit_staff_id']     = session('staff_id');
            $visitData['visit_staff_name']   = session('staff_name');
            $visitData['visit_staff_number'] = session('staff_number');
            $visitData['visit_time']         = date('Y-m-d H:i:s',time());
            $visitData['shop_code']  = $params['shop_code'];
            $visitData['shop_name']  = $params['shop_name'];
            $visitData['brand_id']  = $params['brand_id'];
            $visitData['brandclass']  = $params['brandclass'];
            db('k_visit_list')->insert($visitData);//回访记录

            $data['orderId']     = $params['orderId'];
            $data['order_link']  = $params['order_link'];
            $data['this_id']     = $params['this_id'];
            $data['visit_order_id'] = $visitID;
            $data['visit_staff_id'] = session('staff_id');
            $data['visit_staff_name']   = session('staff_name');
            $data['visit_staff_number'] = session('staff_number');
            $data['visit_time'] = date('Y-m-d H:i:s',time());
            $data['shop_code']  = $params['shop_code'];
            $data['shop_name']  = $params['shop_name'];
            $data['brand_id']   = $params['brand_id'];
            $data['brandclass'] = $params['brandclass'];


            //评分
            foreach($scoreArr as $key => $val){
            //print_r($val);die;
                //如果之前评过分，此次改为0 ,不起作用
                if($val['score']>0){
                    $arr = explode('-',$val['option_code']);
                    $visit_object = $arr[0];
                    $visit_option = $arr[1];
                    $score['visit_object'] = $visit_object;
                    $score[$visit_option.'_score'] = $val['score'];
                    $score['staff_name'] = trim($val['staff_name']);

                    if($val['bm_id']){
                        $score[$visit_option.'_bm_id'] = $val['bm_id'];
                        $score[$visit_option.'_bm'] = db('s_discontent')->where('id',$val['bm_id'])->value('name');
                    }else{
                        $score[$visit_option.'_bm_id'] = null;
                        $score[$visit_option.'_bm'] = null;
                    }

                    $scoreData = array_merge($data,$score);
                    unset($score);

                    $is_exist = db('k_score_list')->where('visit_order_id',$visitID)->where(['visit_object'=>$visit_object])->find();
                    if($is_exist){
                        db('k_score_list')->where('id',$is_exist['id'])->update($scoreData);
                    }else{
                        if($val['staff_name']){
                            $staffInfo = controller('Setting','lib')->get_staff(['staffname'=>$val['staff_name']]);
                            $scoreData['staff_id'] = $staffInfo[0]['id'];
                            $scoreData['staff_number'] = $staffInfo[0]['staffnumber'];
                            $scoreData['department_id'] = $staffInfo[0]['department_id'];
                            $scoreData['department_name'] = $staffInfo[0]['department_name'];
                        }
                        db('k_score_list')->insert($scoreData);
                    }
                }

            }

            //调研问题
            if($addResearch){
                db('k_visit_question_answer')->where('order_id',$visitID)->update(['delete_time'=>$nowTime]);
                db('k_visit_question_answer')->insertAll($addResearch);
            }

            action_log($params,'',$visitID,session(['staff_id']),session(['staff_name']));
            db()->commit();
            return array('code'=>1,'msg'=>'回访记录提交成功','data'=>'');
        }catch(Exception $e){
            print_r($e->getMessage());
            db()->rollBack();//回滚();
            return array('code'=>0,'msg'=>'回访记录提交失败','data'=>'');
        }


    }


    /*
     * 添加客诉工单
     *
     */
    public function addWorkOrder($params){

        $insertData['w_name']    = trim($params['w_name']);
        $insertData['w_phone']   = trim($params['w_phone']);
        $insertData['m_name']    = trim($params['m_name']);
        $insertData['m_phone']   = trim($params['m_phone']);
        //$insertData['customer_number'] = trim($data['customer_number']);
        $insertData['order_number']    = trim($params['order_number']);
        $insertData['source_id']       = 2;//回访
        $insertData['source_name']     = trim($params['source_name']);
        $insertData['level']            = trim($params['level']);
        $insertData['describe']         = trim($params['describe']);
        $insertData['duty_position_code']   = $params['position_code']?implode(',',$params['position_code']):'';//负责人岗位
        $insertData['duty_staff_number']    = $params['staff_number']?implode(',',$params['staff_number']):'';//负责人编号
        $insertData['complain_id']     = implode(',',$params['complain_id']);//投诉类型
        $insertData['brand_id']    = trim($params['brand_id']);
        $insertData['brandclass']  = trim($params['brandclass']);
        $insertData['shop_code']   = trim($params['shop_code']);
        $insertData['shop_name']   = trim($params['shop_name']);
        //审核人
        $insertData['check_staff_number']  = $params['check_staff_number'];
        $insertData['check_staff_name']    = $params['check_staff_name'];
        $insertData['check_staff_id']      = $params['check_staff_id'];

        $sourceData = db('s_source')->where('id',$insertData['source_id'])->find();
        if($sourceData['is_great']==1) {//重大客诉
            $insertData['level'] = 2;
        }
        $insertData['is_ks'] = 1;//若需要审核 应是2
        if(!$insertData['complain_id']||!is_array($params['complain_id'])||count($params['complain_id'])==0){
            return array('code'=>0,'msg'=>'请选择投诉类型');
        }

        //若选择流程类，不需要选择责任人
        $com_id = reset($params['complain_id']);
        $comData = db('s_complain_type')->where('id',$com_id)->find();
        if(!(count($params['complain_id'])==1&&$comData['fid']==1)){
            if(!$insertData['duty_position_code']||!is_array($params['position_code'])||count($params['position_code'])==0){
                return array('code'=>0,'msg'=>'请选择投诉责任岗位');
            }
            if(!$insertData['duty_staff_number']||!is_array($params['staff_number'])||count($params['staff_number'])==0){
                return array('code'=>0,'msg'=>'请选择投诉责任人');
            }
        }else{
            if(! $insertData['shop_code']){
                return array('code'=>0,'msg'=>'请选择投诉责任店');
            }
        }

        $complain=db('s_complain_type')->where('id','in',$insertData['complain_id'])->select();
        $insertData['complain_name'] = implode(',',array_column($complain,'complain_name'));

        if( $insertData['duty_position_code']){
            $position=controller('Setting','lib')->get_position(array('position_code'=>$insertData['duty_position_code']));
            $insertData['duty_position_name'] = implode(',',array_column($position,'position_name'));
        }
        if($params['staff_number']){
            $staffData=[];
            foreach($params['staff_number'] as $k => $v){
                $staff = controller('Setting','lib')->get_staff(array('staffnumber'=>$v));
                array_push($staffData,$staff[0]);
                unset($staff);
            }
            $insertData['duty_staff_id'] = implode(',',array_column($staffData,'id'));
            $insertData['duty_staff_name'] = implode(',',array_column($staffData,'staffname'));
            $insertData['department_id'] = implode(',',array_unique(array_column($staffData,'department_id')));
            $insertData['department_name'] = implode(',',array_unique(array_column($staffData,'department_name')));
        }

        do{
            $insertData['work_number'] = getWorkNumber($insertData['brand_id']);
            $repeat=db('k_work_order')->where('work_number',$insertData['work_number'])->find();
        }while(!empty($repeat));
        //$insertData['work_number']='kf'.str_shuffle(time().generate_code());
        //创建人信息
        $insertData['create_time']     =date('Y-m-d H:i:s',time());
        $insertData['create_staff_id']    =session('staff_id');
        $insertData['create_staff_name']=session('staff_name');
        $insertData['create_staff_number']=session('staff_number');
        $insertData['create_brand_id'] = session('brandclass_id');
        $insertData['create_brandclass'] = session('brandclass');
        //处理事业部
        $insertData['manage_brand_id']   = session('brandclass_id');
        $insertData['manage_brandclass'] = session('brandclass');

        $res=db('k_work_order')->insert($insertData);
        if($res===false){
            return false;
        }else{
            return true;
        }

    }

    //品牌列表
    public function get_brandclass($data)
    {
        $url = "5a44c4782c1b6";
        $res = sx_call($url, $data);
        if ($res['code'] == 200) {
            $info = $res['data'];
            return $info;
        }
    }

    //店面
    public function get_shop($data){
        $url="5a005e0038270";
        $res=sx_call($url,$data);
        if($res['code']==200){
            $info=$res['data'];
        }
        return $info;
    }

    //人员
    public function get_staff_info($staff_name){

        $allUserInfo=cache('Kf_all_staff_info');
        if(!$allUserInfo){
            $res=sx_call('5a01766b4a3dd',[]);
            if($res['code']==200){
                $allUserInfo=$res['data'];
                print_r($allUserInfo);
                cache('Kf_all_staff_info',$allUserInfo);
            }else{
                return [];
            }
        }

        foreach($allUserInfo as $k => $v){
            if($v['staffname']==$staff_name){
               return $v;
            }
        }
    }

    /*
     * 获取系统设置规则
     */
    public function getRule($rule_key){
        $rule=db('s_sysconfig')->where('skey','kf')->value('svalue');
        $data=json_decode($rule,true);
        if(!empty($data)){
            return $data[$rule_key];
        }
    }



}