<?php
/**
 * CRM 实现模块
 * CRM的基本功能实现，如客资录入，客资查询等。
 * 所有业务的真正实现全在lib目录下建controller并且访问modle等，供controller层调用
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: wangyining<wangyining@suxuantech.cn> 2018-04-11 $
 */
namespace app\kf\lib;
use think\Cache;
use think\Controller;
use PHPExcel_IOFactory;
use Excel5;
use PHPExcel;
use app\common\lib\redisQueue;
use think\Exception;
use think\Db;
class Workorder extends Controller{

    /**
     * 调用erp接口获取订单信息
     */
    public function WorkOrderList($params){


        $page = $params['page'] ? $params['page'] : 1;
        $limit = $params['limit'] ? $params['limit'] : 10;

        $end_time=$params['end_time'];
        $params['end_time']=date("Y-m-d",strtotime("$end_time +1 day"));
        $sql=$this->getSql($params);

        //只有选项卡create下客诉 取创建事业部（create_brand_id），其他取处理事业部（manage_brand_id）
        //$brandIdName = $params['tabs']=='create'?'create_brand_id':'manage_brand_id';
        if($params['tabs']=='create'){
            $brandIdName = 'create_brand_id';
        }elseif($params['tabs']=='not_second'||$params['tabs']=='second'){
            $brandIdName = 'second_visit_brand_id';
        }else{
            $brandIdName = 'manage_brand_id';
        }
        $sql .= " and ".$brandIdName." = '".session('brandclass_id')."' ";

        //若没有查看所有客诉的权限 则只能查看本人的
        if(!check_right('menu1542865371')){
            $createSql = " and create_staff_name = '".session('staff_name')."'";
            $receiceSql = " and receice_staff_name = '".session('staff_name')."'";
            $manageSql = " and manage_staff_name = '".session('staff_name')."'";
            $secondSql = " and second_visit_staff_name = '".session('staff_name')."'";
            $failSql = " and manage_staff_name = '".session('staff_name')."'";
        }

        switch ($params['tabs']){
            case 'new_ks':
                $sql .= " and is_status = 1  and is_refute = 2 ";
                break;
            case 'create'://我创建的客诉单（只有此选项卡下客诉 处理事业部（manage_brand_id）不一定是我的事业部）
                $sql .= " and is_refute = 2 ";
                $sql .= $createSql;
                break;
            case 'today_receive'://当日领取客资
                $today=date('Y-m-d',time());
                $before_time=date("Y-m-d",time());
                $after_time=date("Y-m-d",strtotime("$today +1 day"));
                $sql .= "  and is_refute = 2 and (receice_time between '".$before_time."'and '".$after_time."') ";
                $sql .= $receiceSql;
                break;
            case 'not_manage'://当前人待处理客诉
                $sql .= "  and is_refute = 2 and (is_status = 2 or is_status = 3) and manage_time is null";//未处理 以及更换处理人之后未处理
                $sql .= $manageSql;
                break;
            case 'manage'://当前人处理中客诉
                $sql .= "  and is_refute = 2 and is_status = 3 and manage_time is not null ";
                $sql .= $manageSql;
                break;
            case 'over'://已解决
                $sql .= "  and is_refute = 2 and is_status = 4 ";
                $sql .= $manageSql;
                break;
            case 'not_second':
                $sql .= "  and is_refute = 2 and is_status = 5 and second_visit_time is null ";
                $sql .= $secondSql;
                break;
            case 'second':
                $sql .= "  and is_refute = 2 and is_status = 4 and second_visit_time is not null  ";
                $sql .= $secondSql;
                break;
            case 'second_fail'://二次满意度回访失败
                $sql .= "  and is_refute = 2 and is_status = 6";
                $sql .= $failSql;
                break;
            case 'refute'://驳回
                $sql .=" and is_refute = 1 ";
                break;
            default:
                $sql .= " and is_status = 1  and is_refute = 2 ";
        }
        //print_r($sql);die;

        $result['code'] = 0;
        $result['msg'] = '';

        if($params['data_type'] == 'all'){
            //查询所有数据
            $res = db('k_work_order')
                ->where($sql)
                //->field('id,work_number,order_number,w_name,w_phone,m_name,m_phone,brandclass,shop_name,duty_staff_name,complain_name,source_name,level,is_status,is_ks,create_time,manage_staff_name,second_visit_staff_name,')
                ->order('level desc')
                ->select();
        }else{
            $res = db('k_work_order')->where($sql)->order('level desc')->page($page,$limit)->select();
        }

        foreach($res as $key => $val){
            $res[$key]['describe'] = preg_replace('/<\s*img\s+[^>]*?src\s*=\s*(\'|\")(.*?)\\1[^>]*?\/?\s*>/i', '', $val['describe']);
        }

        //print_r(db()->getLastSql());die;
        $count = db('k_work_order')->where($sql)->count();
        if($res){
            $result['data'] = $res;
            $result['count'] = $count;
        }else{
            $result['data'] = array();
        }

        return $result;

    }

    //每个选项卡数量
    public function WorkOrderNum($params){
        $end_time=$params['end_time'];
        $params['end_time']=date("Y-m-d",strtotime("$end_time +1 day"));
        $sql=$this->getSql($params);

        //只有选项卡create下客诉 取创建事业部（create_brand_id），其他取处理事业部（manage_brand_id）
        $createBrand = "create_brand_id = '".session('brandclass_id')."' ";
        $manageBrand = "manage_brand_id = '".session('brandclass_id')."' ";
        $secondBrand = "second_visit_brand_id = '".session('brandclass_id')."'";

        //若没有查看所有客诉的权限 则只能查看本人的
        if(!check_right('menu1542865371')){
            $createSql = " create_staff_name = '".session('staff_name')."'";
            $receiceSql = " receice_staff_name = '".session('staff_name')."'";
            $manageSql = " manage_staff_name = '".session('staff_name')."'";
            $secondSql = " second_visit_staff_name = '".session('staff_name')."'";
            $failSql = " manage_staff_name = '".session('staff_name')."'";
        }

        $today=date('Y-m-d',time());
        $before_time=date("Y-m-d",time());
        $after_time=date("Y-m-d",strtotime("$today +1 day"));

        $num['new_ks_num']        = db('k_work_order')->where('is_refute',2)->where('is_status',1)->where($sql)->where($manageBrand)->count();
        $num['create_num']        = db('k_work_order')->where('is_refute',2)->where($sql)->where($createBrand)->where($createSql)->count();
        $num['today_receive_num'] = db('k_work_order')->where('is_refute',2)->where('receice_time', 'between time', [$before_time, $after_time])->where($sql)->where($manageBrand)->where($receiceSql)->count();
        $num['not_manage_num']    = db('k_work_order')->where('is_refute',2)->where('is_status = 2 or is_status = 3')->where('manage_time is null')->where($sql)->where($manageBrand)->where($manageSql)->count();
        $num['manage_num']        = db('k_work_order')->where('is_refute',2)->where('is_status',3)->where('manage_time is not null')->where($sql)->where($manageBrand)->where($manageSql)->count();
        $num['over_num']          = db('k_work_order')->where('is_refute',2)->where('is_status',4)->where($sql)->where($manageBrand)->where($manageSql)->count();
        $num['not_second_num']    = db('k_work_order')->where('is_refute',2)->where('is_status',5)->where('second_visit_time',null)->where($sql)->where($secondBrand)->where($secondSql)->count();
        $num['second_num']        = db('k_work_order')->where('is_refute',2)->where('is_status',4)->where('second_visit_time is not null')->where($sql)->where($secondBrand)->where($secondSql)->count();
        $num['second_fail_num']   = db('k_work_order')->where('is_refute',2)->where('is_status',6)->where($sql)->where($manageBrand)->where($failSql)->count();
        $num['refute_num']        = db('k_work_order')->where('is_refute',1)->where($sql)->where($manageBrand)->count();

        return $num;
    }


    public function getSql($data)
    {
        $sql = " 1=1 ";
        if (!empty($data)) {
            if($data['username'])     $sql .= " and w_name like '%" . $data['username'] . "%' or  m_name like '%" . $data['username'] . "%' ";
            if($data['mobile'])       $sql .= " and w_phone like '%" . $data['mobile'] . "%' or  m_phone like '%" . $data['mobile'] . "%' ";
            if($data['source_id'])    $sql .= " and source_id = '".$data['source_id']."' ";
            if($data['level'])        $sql .= " and level = '".$data['level']."' ";
            if($data['order_number']) $sql .= " and order_number like '%".$data['order_number']."%' ";
            if($data['work_number'])  $sql .= " and work_number like '%".$data['work_number']."%' ";
            if($data['complain_id'])  $sql .= " and FIND_IN_SET('".$data['complain_id']."',complain_id) ";
            if($data['work_order_number'])   $sql .= " and work_number like '%".$data['work_order_number']."%' ";
            if($data['duty_position_name'])  $sql .= " and FIND_IN_SET('".$data['duty_position_name']."',duty_position_name) ";
            if($data['duty_staff_name'])     $sql .= " and FIND_IN_SET('".$data['duty_staff_name']."',duty_staff_name) ";
            //if($data['brand_id'])     $sql .= " and brand_id = '".$data['brand_id']."'";

            if($data['all_time']&&!empty($data['all_time'])){
                if($data['start_time'])      $sql .= " and ".$data['all_time']." >='".$data['start_time']."' ";
                if($data['end_time'])        $sql .= " and ".$data['all_time']." <'".$data['end_time']."' ";
            }

        }
        $sql .= ' and (is_ks = 1 or is_ks = 3 or is_ks = 5 or is_ks = 6 or is_ks = 7) ';
        return $sql;
    }


    /*
    * 客诉工单号
    */
    public function getWorkNumber($brand_id){
        $numberData = cache('KF_work_number');
        if($numberData){
            //$numberData = json_decode($work_number_json,true);
            if($numberData['date']==date('Ymd')){
                $my_number = $numberData['number'];
                if(strlen((int)$my_number+1)<strlen($my_number)){
                    $now_number = str_pad((int)$my_number + 1, strlen($my_number), '0', STR_PAD_LEFT);
                }elseif(strlen((int)$my_number+1)>=strlen($my_number)){
                    $now_number=(int)$my_number+1;
                }
            }else{
                $now_number = '001';
            }
        }else{
            $now_number = '001';
        }

        cache('KF_work_number',json_encode(array('date'=>date('Ymd'),'number'=>$now_number)));
        $work_number = 'kf'.$brand_id.date('Ymd').$now_number;
        return $work_number;
    }

    /*
     * 添加客诉工单
     *
     */
    public function addWorkOrder($params){
        $insertData['w_name']    = trim($params['w_name']);
        $insertData['w_phone']   = trim($params['w_phone']);
        $insertData['m_name']    = trim($params['m_name']);
        $insertData['m_phone']   = trim($params['m_phone']);
        //$insertData['customer_number'] = trim($data['customer_number']);
        $insertData['order_number']    = trim($params['order_number']);
        $insertData['ks_phase']        = trim($params['ks_phase']);  //客诉阶段
        $insertData['source_name']     = trim($params['source_name']);
        $insertData['source_id']       = trim($params['source_id']);
        if(!$insertData['source_id']){
            $insertData['source_id'] = db('s_source')->where('source_name',$insertData['source_name'])->value('id');
        }

        $insertData['level']           = trim($params['level']);
        $insertData['describe']        = trim($params['describe']);
        $insertData['tel_recording']   = trim($params['tel_recording']);
        $insertData['duty_position_code']   = $params['position_code']?implode(',',$params['position_code']):'';//负责人岗位
        $insertData['duty_staff_number']    = $params['staff_number']?implode(',',$params['staff_number']):'';//负责人编号
        $insertData['complain_id']     = implode(',',$params['complain_id']);//投诉类型
        $insertData['brand_id']    = trim($params['brand_id']);
        $insertData['brandclass']  = trim($params['brandclass']);
        $insertData['shop_code']   = trim($params['shop_code']);
        $insertData['shop_name']   = trim($params['shop_name']);
        //$insertData['staff_id']   = trim($params['shop_name']);
        //$insertData['shop_name']  = trim($params['shop_name']);
        if($params['department_id']){
            $insertData['department_id'] = $params['department_id'];
            $insertData['department_name'] = $params['department_name'];
        }

        $sourceData = db('s_source')->where('id',$insertData['source_id'])->find();
        if($sourceData['is_great']==1) {//重大客诉
            $insertData['level'] = 2;
        }

        $insertData['create_time']     = date('Y-m-d H:i:s',time());
        $insertData['create_staff_id'] = session('staff_id');
        $insertData['create_staff_name'] = session('staff_name');
        $insertData['create_staff_number'] = session('staff_number');
        $insertData['create_brand_id'] = session('brandclass_id');
        $insertData['create_brandclass'] = session('brandclass');
        $insertData['manage_brand_id']   = session('brandclass_id');
        $insertData['manage_brandclass'] = session('brandclass');


        //print_r($insertData);die;

        //若选择上升给集团处理
        if($params['is_group'] == 1){
            //处理事业部
            $insertData['manage_brand_id'] = '0';
            $insertData['manage_brandclass'] = '0';
        }

        //通知相关负责人处理
        if($params['notice']==1){
            $insertData['is_ks'] = 5;
            $insertData['manage_staff_number'] = trim($params['manage_staff_number']);
            if(!$insertData['manage_staff_number']){
                return array('code'=>0,'msg'=>'请选择通知人');
            }
            $notice_man = controller('Setting','lib')->get_staff(array('staffnumber'=> $insertData['manage_staff_number']));

            $insertData['is_status'] = 2;
            $insertData['receice_staff_id']   = $notice_man[0]['id'];
            $insertData['receice_staff_name'] = $notice_man[0]['staffname'];
            $insertData['receice_staff_number'] = trim($params['manage_staff_number']);
            $insertData['receice_time']       = date('Y-m-d H:i:s',time());

            $insertData['manage_staff_name'] = $notice_man[0]['staffname'];
            $insertData['manage_staff_id'] = $notice_man[0]['id'];
            $insertData['manage_brand_id'] = $notice_man[0]['brandclass_id'];
            $insertData['manage_brandclass'] = $notice_man[0]['brandclass'];

        }else{
            $insertData['is_ks'] = 1;
        }

        if(!$insertData['complain_id']||!is_array($params['complain_id'])||count($params['complain_id'])==0){
            return array('code'=>0,'msg'=>'请选择投诉类型');
        }

        //若选择流程类，不需要选择责任人
        $com_id = reset($params['complain_id']);
        $comData = db('s_complain_type')->where('id',$com_id)->find();
        if(!(count($params['complain_id'])==1&&$comData['fid']==1)){
            if(!$insertData['duty_position_code']||!is_array($params['position_code'])||count($params['position_code'])==0){
                if(!$params['qt']){//未确定责任人时选择 '其他'选项
                    return array('code'=>0,'msg'=>'请选择投诉责任岗位');
                }
            }
            if(!$insertData['duty_staff_number']||!is_array($params['staff_number'])||count($params['staff_number'])==0){
                if(!$params['qt']){//未确定责任人时选择 '其他'选项
                    return array('code'=>0,'msg'=>'请选择投诉责任人');
                }

            }
        }else{
            if(! $insertData['shop_code']){
                return array('code'=>0,'msg'=>'请选择投诉责任店');
            }
        }

        $complain=db('s_complain_type')->where('id','in',$insertData['complain_id'])->select();
        $insertData['complain_name'] = implode(',',array_column($complain,'complain_name'));

        if( $insertData['duty_position_code']){
            $position=controller('Setting','lib')->get_position(array('position_code'=>$insertData['duty_position_code']));
            $insertData['duty_position_name'] = implode(',',array_column($position,'position_name'));
        }
        if($params['staff_number']){
            $staffData=[];
            foreach($params['staff_number'] as $k => $v){
                $staff = controller('Setting','lib')->get_staff(array('staffnumber'=>$v));
                array_push($staffData,$staff[0]);
                unset($staff);
            }
            $insertData['duty_staff_id'] = implode(',',array_column($staffData,'id'));
            $insertData['duty_staff_name'] = implode(',',array_column($staffData,'staffname'));
            $insertData['department_id'] = implode(',',array_unique(array_column($staffData,'department_id')));
            $insertData['department_name'] = implode(',',array_unique(array_column($staffData,'department_name')));
        }

        do{
            $insertData['work_number'] = $this->getWorkNumber($insertData['brand_id']);
            $repeat=db('k_work_order')->where('work_number',$insertData['work_number'])->find();
        }while(!empty($repeat));
        //$insertData['work_number']='kf'.str_shuffle(time().generate_code());

        $res=db('k_work_order')->insert($insertData);
        if($res===false){
            return false;
        }else{

            //通知责任人
            $staffids = array_column($staffData,'id');
            foreach($staffids as $staffid){
                $contentArr = [
                    'touser'       => $staffid,
                    'template_id'  => PROCESS,
                    'data'         => [
                        'first'=>[
                            'value'=> '有一条投诉您的新客诉！工单号：'.$insertData['work_number'],
                            'color'=> '#173177'
                        ],
                        'keyword1'=>[
                            'value'=> '订单号：'.$insertData['order_number'],
                            'color'=> '#173177'
                        ],
                        'keyword2'=>[
                            'value'=> date('Y-m-d H:i:s',time()),
                            'color'=> '#173177'
                        ],
                        'remark'=>[
                            'value'=> '责任人：'.$insertData['duty_staff_name'],
                            'color'=> '#173177'
                        ],
                    ],
                ];

                sendMsg(['content'=>json_encode($contentArr)]);
            }

            //通知上级人处理
            if($params['notice']==1){
                $url = getDomain().'/index/Index/manageKsView?work_number='.$insertData['work_number'];
                $content = [
                    'touser'       => $insertData['manage_staff_id'],
                    'template_id'  => SIGNATURE,
                    'url'=>$url,
                    'data'         => [
                        'first'=>[
                            'value'=> '您有一条客诉需要处理！工单号：'.$insertData['work_number'],
                            'color'=> '#173177'
                        ],
                        'keyword1'=>[
                            'value'=> '订单号：'.$insertData['order_number'],
                            'color'=> '#173177'
                        ],
                        'keyword2'=>[
                            'value'=> date('Y-m-d H:i:s',time()),
                            'color'=> '#173177'
                        ],
                        'remark'=>[
                            'value'=> '请尽快处理，谢谢！',
                            'color'=> '#173177'
                        ],
                    ],
                ];
                $send_data['content'] = json_encode($content);
                sendMsg($send_data);
            }

            //通知erp此订单有客诉
            if($insertData['order_number']){
                $erp = config('ext.app_config');  //读取erp配置文件
                $addr = $erp['sx_erp']['addr'];  //调用url
                $dataUrl=$addr.'/SX_CustomerService/SX_AlterProblemKF?Token=^******^&orderid='.$insertData['order_number'].'&ISproblem=1';
                $response = requestERP($dataUrl, '');
                //print_r($response);die;
            }

            //若有是回访中产生的客诉，则标记回访数据
            if($params['order_link'] && $params['this_id']){
                $visitRes = db('k_order')->where(['order_link'=>$params['order_link'],'this_id'=>$params['this_id']])->update(['have_ks'=>1]);
                if($visitRes === false){
                    return array('code'=>0,'msg'=>'标记回访订单产生客诉失败！');
                }
            }

            return true;
        }
    }

    /*
     * 处理客诉
     */
    public function doManage($params){

        if($params['is_manage']==1){//是否已解决
            if(!db('k_work_order')->where('work_number',$params['work_number'])->value('order_number')&&!$params['order_number']){
                return array('code'=>0,'msg'=>'请绑定单号');
            }
            $workData['is_status']=4;
            $workData['manage_time']=date('Y-m-d H:i:s',time());
            $workData['manage_num']=$params['manage_num']+1;
            $workData['ks_expend']=$params['ks_expend'];
            $workData['ks_expend_money']=$params['ks_expend_money'];
            $workData['brand_expend_money']=$params['brand_expend_money'];

            //签字确认人
            if($params['staff_number']&&!empty($params['staff_number'])){
                $workData['signature_staff_number'] = implode(',',$params['staff_number']);
                $staffData=[];
                foreach($params['staff_number'] as $k => $v){
                    $staff=controller('Setting','lib')->get_staff(array('staffnumber'=>$v));
                    array_push($staffData,$staff[0]);
                    unset($staff);
                }

                $workData['signature_staff_id'] = implode(',',array_column($staffData,'id'));
                $workData['signature_staff_name'] = implode(',',array_column($staffData,'staffname'));

                $signData=[];
                foreach($staffData as $kk => $vv){
                    $signData[$kk]['code'] = 'kf'.str_shuffle(time().generate_code());
                    $signData[$kk]['work_number'] = $params['work_number'];
                    $signData[$kk]['sign_id']      = $vv['id'];
                    $signData[$kk]['sign_number']  = $vv['staffnumber'];
                    $signData[$kk]['sign_name']    = $vv['staffname'];
                    $signData[$kk]['is_signature'] = 2;
                }
            }

            $manageData=$this->getManageLink($params['manage_num']+1);//已解决，判断是否需要二次回访
            //满意，并且需要二次满意度回访
            if($params['is_content']==1&&$manageData['is_second']==1&&!empty($manageData['second_visit_staff_number'])){
                $workData['second_visit_staff_id']=$manageData['second_visit_staff_id'];
                $workData['second_visit_staff_name']=$manageData['second_visit_staff_name'];
                $workData['second_visit_staff_number']=$manageData['second_visit_staff_number'];
                $workData['second_visit_brand_id']=$manageData['second_visit_brand_id'];
                $workData['second_visit_brandclass']=$manageData['second_visit_brandclass'];
                $workData['second_visit_time']=null;
                $workData['is_status']=5;

                $change['work_number'] = $params['work_number'];
                $change['manage_staff_name'] = $manageData['second_visit_staff_name'];
                $change['manage_staff_id']   = $manageData['second_visit_staff_id'];
                $change['manage_staff_number'] = $manageData['second_visit_staff_number'];
                $change['manage_time'] = date('Y-m-d H:i:s',time());
                $change['manage_type'] = 3;
                $change['note']  = '二次满意度，处理人'.$manageData['second_visit_staff_name'];

            }else{
                $workData['is_over'] = 1;
                $workData['over_time'] = date('Y-m-d H:i:s',time());

                //不需要二次满意度调查，直接签字
                //$ids=array_column($staffData,'id');
                foreach($signData as $k => $v){
                    $signUrl=$this->getSignature($v['code'],$params['work_number']);
                    $content = [
                        'touser'       => $v['sign_id'],
                        'template_id'  => SIGNATURE,
                        'url'=>$signUrl,
                        'data'         => [
                            'first'=>[
                                'value'=> '您有一条工单信息需要签字，请审核！',
                                'color'=> '#173177'
                            ],
                            'keyword1'=>[
                                'value'=> '工单号'.$params['work_number'],
                                'color'=> '#173177'
                            ],
                            'keyword2'=>[
                                'value'=> $workData['over_time'],
                                'color'=> '#173177'
                            ],
                            'remark'=>[
                                'value'=> '请尽快签字确认，谢谢！',
                                'color'=> '#173177'
                            ],
                        ],
                    ];
                    $send_data['content'] = json_encode($content);
                    $res = sendMsg($send_data);

                }

            }

            $record['manage_type'] = 1;
        }else{
            //未解决的情况下，1.进入下一步，2暂时保存输入信息，不进入下一步

            $workData['is_status']=3;
            $workData['manage_time']=date('Y-m-d H:i:s',time());

            if($params['is_next']==1){

                //检测下次将处理到第几环节，是否更换处理人，
                $workData['manage_num']=$params['manage_num']+1;


                //未解决，判断是否需要更换处理人
                $manageData=$this->getManageLink($params['manage_num']+2);
                if(!empty($manageData['manage_staff_number'])&&$manageData['manage_staff_number']!=session('staff_number')){
                    $workData['manage_staff_id']=$manageData['manage_staff_id'];
                    $workData['manage_staff_name']=$manageData['manage_staff_name'];
                    $workData['manage_staff_number']=$manageData['manage_staff_number'];
                    $workData['manage_brand_id']=$manageData['manage_brand_id'];
                    $workData['manage_brandclass']=$manageData['manage_brandclass'];
                    $workData['manage_time']=null;

                    $change['work_number']  = $params['work_number'];
                    $change['manage_staff_name'] = session('staff_name');
                    $change['manage_staff_id']   = session('staff_id');
                    $change['manage_staff_number'] = session('staff_number');
                    $change['manage_time'] = date('Y-m-d H:i:s',time());
                    $change['manage_type'] = 3;
                    $change['note']  = '客诉升级，更换处理人为'.$manageData['manage_staff_name'];

                    //检测本环节未成功解决 是否升为重大客诉
                    $thisData=$this->getManageLink($params['manage_num']+1);
                    if($thisData['is_great']==1){
                        $workData['level']=2;
                    }

                }

                $record['manage_type'] = 1;
            }else{
                $record['manage_type'] = 0;
            }

        }

        $workData['settle_staff_id'] = $params['settle_staff_id'];    //解决人
        $workData['settle_staff_name'] = $params['settle_staff_name'];
        $workData['solution_id'] = $params['solution_id'];            //解决方案
        $workData['solution'] = $params['solution'];


        $record['work_number']  = $params['work_number'];
        $record['order_number'] = $params['order_number'];
        $record['w_name']  = $params['w_name'];
        $record['w_phone'] = $params['w_phone'];
        $record['m_name']  = $params['m_name'];
        $record['m_phone'] = $params['m_phone'];
        $record['is_manage'] = $params['is_manage'];
        $record['manage_staff_name'] = session('staff_name');
        $record['manage_staff_id']   = session('staff_id');
        $record['manage_staff_number'] = session('staff_number');
        $record['manage_time'] = date('Y-m-d H:i:s',time());
        $record['manage_num']  = $params['manage_num']+1;
        $record['note']  =  $params['note'];
        db()->startTrans();
        try{
            if(!empty($workData)){
                db('k_work_order')->where('work_number',$params['work_number'])->update($workData);
            }
            //如果之前有暂存跟进备注，修改暂存跟进备注，没有则新增一条记录
            $last_record = db('k_manage_log')->where(['work_number'=>$record['work_number'],'manage_type'=>0])->order('manage_time desc')->find();
            if($last_record){
                db('k_manage_log')->where('id',$last_record['id'])->update($record);
            }else{
                db('k_manage_log')->insert($record);
            }


            if(!empty($change)){
                db('k_manage_log')->insert($change);
            }
            if(!empty($signData)){
                db('k_staff_sign')->where('work_number',$params['work_number'])->delete();
                db('k_staff_sign')->insertAll($signData);
            }

            action_log($params,'',$params['work_number'],session(['staff_id']),session(['staff_name']));
            db()->commit();
            return array('code'=>1,'msg'=>'处理结果提交成功');
            //return true;
        }catch(Exception $e){
            db()->rollback();
            return array('code'=>0,'msg'=>'处理结果提交失败，请稍后重试'.$e->getMessage());
            //return false;
        }

    }

    //发起签字
    public function getSignature($code,$work_number){
        $params = db('k_work_order')->where('work_number',$work_number)->find();
        $jsonData['work_number'] = $params['work_number'];
        $jsonData['order_number'] = $params['order_number'];
        $jsonData['w_name'] = $params['w_name'];
        $jsonData['m_name'] = $params['m_name'];
        $jsonData['w_phone'] = $params['w_phone'];
        $jsonData['m_phone'] = $params['m_phone'];
        $jsonData['duty_staff_name']   = $params['duty_staff_name'];
        $jsonData['manage_staff_name'] = $params['manage_staff_name'];

        $data['code'] = $code;
        $data['data'] = json_encode($jsonData);
        $data['viewtype'] = 'signature2';
        $data['type'] = 1;
        $res = sx_call('5ab99d8594c78',$data);
        if($res['code']==200){
            return $res['data']['url'];
        }else{
            return '';
        }
    }


    /*
     * 处理流程判断
     */
    public function getManageLink($manage_num){

        $array=db('s_manage_process')->where('is_open',1)->order('sort asc')->select();
        $rule=[];
        $num=0;
        $res=[];
        foreach($array as $k => $v){
            $num=$num+$v['manage_num'];
            $rule[$k]['sort'] = $v['sort'];
            $rule[$k]['num']  = $num;
            $rule[$k]['manage_staff_id']   = $v['manage_staff_id'];
            $rule[$k]['manage_staff_name'] = $v['manage_staff_name'];
            $rule[$k]['manage_staff_number'] = $v['manage_staff_number'];
            $rule[$k]['manage_brand_id'] = $v['manage_brand_id'];
            $rule[$k]['manage_brandclass'] = $v['manage_brandclass'];

            $rule[$k]['manage_num'] = $v['manage_num'];
            $rule[$k]['is_great']   = $v['is_great'];
            $rule[$k]['is_second']  = $v['is_second'];
            $rule[$k]['second_visit_staff_id']   = $v['second_visit_staff_id'];
            $rule[$k]['second_visit_staff_name'] = $v['second_visit_staff_name'];
            $rule[$k]['second_visit_staff_number'] = $v['second_visit_staff_number'];
            $rule[$k]['second_visit_brand_id'] = $v['second_visit_brand_id'];
            $rule[$k]['second_visit_brandclass'] = $v['second_visit_brandclass'];
        }

        foreach($rule as $key => $val){
            if($val['num'] >= $manage_num){
                $res=$val;
                break;
            }
        }
        return $res?$res:end($rule);
    }


    //二次满意度回访
    public function doSecondManage($params){
        $workData['is_over'] = $params['is_over'];
        if($params['is_over']==2){//不满意
            $workData['is_status']= 6;
            $workData['discontent_reason'] = $params['discontent_reason'];
        }else if($params['is_over']==1){
            $workData['is_status'] = 4;
            $workData['over_time'] = date('Y-m-d H:i:s',time());

            //二次满意度调查完成，签字
            $getStaff=db('k_staff_sign')->where('work_number',$params['work_number'])->select();
            foreach($getStaff as $k => $v){
                $signUrl=$this->getSignature($v['code'],$params['work_number']);
                $content = [
                    'touser'       => $v['sign_id'],
                    'template_id'  => SIGNATURE,
                    'url'=>$signUrl,
                    'data'         => [
                        'first'=>[
                            'value'=> '您有一条工单信息需要签字，请审核！',
                            'color'=> '#173177'
                        ],
                        'keyword1'=>[
                            'value'=> '工单号'.$params['work_number'],
                            'color'=> '#173177'
                        ],
                        'keyword2'=>[
                            'value'=> $workData['over_time'],
                            'color'=> '#173177'
                        ],
                        'remark'=>[
                            'value'=> '请尽快签字确认，谢谢！',
                            'color'=> '#173177'
                        ],
                    ],
                ];
                $send_data['content'] = json_encode($content);
                $res = sendMsg($send_data);

            }
        }
        $workData['second_visit_time']=date('Y-m-d H:i:s',time());

        $record['work_number']  = $params['work_number'];
        $record['order_number'] = $params['order_number'];
        $record['customer_number'] = $params['customer_number'];
        $record['w_name']  = $params['w_name'];
        $record['w_phone'] = $params['w_phone'];
        $record['m_name']  = $params['m_name'];
        $record['m_phone'] = $params['m_phone'];
        $record['is_manage'] = $params['is_over'];
        $record['manage_staff_name'] = session('staff_name');
        $record['manage_staff_id']   = session('staff_id');
        $record['manage_staff_number'] = session('staff_number');
        $record['manage_time'] = date('Y-m-d H:i:s',time());
        $record['manage_type'] = 2;
        $record['note']  =  $params['discontent_reason'];
        db()->startTrans();
        try{
            db('k_work_order')->where('work_number',$params['work_number'])->update($workData);
            db('k_manage_log')->insert($record);
            action_log($params,'',$params['work_number'],session(['staff_id']),session(['staff_name']));
            db()->commit();
            return true;
        }catch(Exception $e){
            db()->rollback();
            return false;
        }
    }

    /************************************************************************************************
     * api 添加客诉接口
     * source_id 固定来源：1回访，2事业部，3会员
     */
    public function apiAddKs($params){
        $insertData['w_name']    = trim($params['w_name']);
        $insertData['w_phone']   = trim($params['w_phone']);
        $insertData['m_name']    = trim($params['m_name']);
        $insertData['m_phone']   = trim($params['m_phone']);
        $insertData['order_number']    = trim($params['order_number']);
        $insertData['ks_phase']        = trim($params['ks_phase']);  //客诉阶段
        $insertData['source_id']       = trim($params['source_id']);
        $insertData['level']            = trim($params['level']);
        $insertData['describe']         = trim($params['describe']);
        $insertData['complain_id']     = implode(',',$params['complain_id']);//投诉类型
        $insertData['brand_id']    = trim($params['brand_id']);
        $insertData['brandclass']  = trim($params['brandclass']);
        $insertData['shop_code']   = trim($params['shop_code']);
        $insertData['shop_name']   = trim($params['shop_name']);
        $insertData['duty_position_code']   = implode(',',$params['position_code']);//负责人岗位
        $insertData['duty_staff_number']    = implode(',',$params['staff_number']);//负责人编号
        //负责人部门
        if($params['department_id']){
            $insertData['department_id'] = $params['department_id'];
            $insertData['department_name'] = $params['department_name'];
        }

        $insertData['create_time'] = date('Y-m-d H:i:s',time());
        $insertData['create_staff_id']     = $params['staff_id'];
        $insertData['create_staff_name']   = $params['staff_name'];
        $insertData['create_staff_number'] = $params['staff_number'];
        $insertData['create_brand_id']   = $params['create_brand_id'];
        $insertData['create_brandclass'] = $params['brandclass'];

        $insertData['check_staff_number']  = $params['check_staff_number'];
        $insertData['check_staff_name']    = $params['check_staff_name'];
        $insertData['check_staff_id']      = $params['check_staff_id'];

        $insertData['manage_brand_id']   = $params['create_brand_id'];
        $insertData['manage_brandclass'] = $params['create_brandclass'];

        //若选择上升给集团处理
        if($params['is_group'] == 1){
            //处理事业部
            $insertData['manage_brand_id'] = '0';
            $insertData['manage_brandclass'] = '0';
        }

        //通过接口过来的客诉全部是审核状态
        $insertData['is_ks'] = 2;

        if(!$insertData['duty_position_code']||!is_array($params['position_code'])||count($params['position_code'])==0){
            return array('code'=>0,'msg'=>'请选择投诉责任岗位');
        }
        if(!$insertData['duty_staff_number']||!is_array($params['staff_number'])||count($params['staff_number'])==0){
            return array('code'=>0,'msg'=>'请选择投诉责任人');
        }
        if(!$insertData['complain_id']||!is_array($params['complain_id'])||count($params['complain_id'])==0){
            return array('code'=>0,'msg'=>'请选择投诉类型');
        }

        $complain=db('s_complain_type')->where('id','in',$insertData['complain_id'])->select();//投诉类型
        $insertData['complain_name'] = implode(',',array_column($complain,'complain_name'));

        $sourceData = db('s_source')->where('id',$insertData['source_id'])->find();//客诉来源
        $insertData['source_name']     = $sourceData['source_name'];
        if($sourceData['is_great']==1) {//重大客诉
            $insertData['level'] = 2;
        }

        $position=controller('Setting','lib')->get_position(array('position_code'=>$insertData['duty_position_code']));
        $insertData['duty_position_name'] = implode(',',array_column($position,'position_name'));

        $staffData=[];
        foreach($params['staff_number'] as $k => $v){
            $staff=controller('Setting','lib')->get_staff(array('staffnumber'=>$v));
            array_push($staffData,$staff[0]);
            unset($staff);
        }

        $insertData['duty_staff_id'] = implode(',',array_column($staffData,'id'));
        $insertData['duty_staff_name'] = implode(',',array_column($staffData,'staffname'));
        $insertData['department_id'] = implode(',',array_unique(array_column($staffData,'department_id')));
        $insertData['department_name'] = implode(',',array_unique(array_column($staffData,'department_name')));
        //$insertData['duty_position_code'] = implode(',',array_unique(array_column($staffData,'main_position_code')));
        //$insertData['duty_position_name'] = implode(',',array_unique(array_column($staffData,'main_position_name')));

        do{
            $insertData['work_number'] = $this->getWorkNumber($insertData['brand_id']);
            $repeat=db('k_work_order')->where('work_number',$insertData['work_number'])->find();
        }while(!empty($repeat));

        $res = db('k_work_order')->insert($insertData);
        if($res===false){
            return array('code'=>201,'msg'=>'添加客诉工单失败');
        }else{
            if($insertData['check_staff_id']){
                $url = getDomain().'/kf/Workorder/checkKsView?work_number='.$params['work_number'];
                $content = [
                    'touser'       => $insertData['check_staff_id'],
                    'template_id'  => SIGNATURE,
                    'url'=>$url,
                    'data'         => [
                        'first'=>[
                            'value'=> '您有一条客诉工单需要审核！',
                            'color'=> '#173177'
                        ],
                        'keyword1'=>[
                            'value'=> '工单号'.$params['work_number'],
                            'color'=> '#173177'
                        ],
                        'keyword2'=>[
                            'value'=> date('Y-m-d H:i:s',time()),
                            'color'=> '#173177'
                        ],
                        'remark'=>[
                            'value'=> '请尽快审核，谢谢！',
                            'color'=> '#173177'
                        ],
                    ],
                ];
                $send_data['content'] = json_encode($content);
                sendMsg($send_data);
            }
            return array('code'=>200,'msg'=>'添加客诉工单成功');
        }
    }

    /*
    *   审核客诉,如果需相关人员处理 发模板消息
    *   3审核通过，4审核不通过，5通知相关负责人处理中
    */
    public function checkKs($params){
        $up['is_ks'] = $params['is_ks'];
        if($params['is_ks']==5){
            $up['manage_staff_number'] = trim($params['manage_staff_number']);
            $notice_man = controller('Setting','lib')->get_staff(array('staffnumber'=> trim($params['manage_staff_number'])));
            $up['manage_staff_name'] = $notice_man[0]['staffname'];
            $up['manage_staff_id'] = $notice_man[0]['id'];
        }
        $res = db('k_work_order')->where('work_number',$params['work_number'])->update($up);
        if($res!==false){
            if($params['is_ks']==5){
                //$detail = db('k_work_order')->where('work_number',$params['work_number'])->find();
                //$ids = array_unique(explode(',',$detail['duty_staff_id']));
                $url = getDomain().'/kf/Workorder/manageKsView?work_number='.$params['work_number'];
                //foreach($ids as $k => $v){

                    $content = [
                        'touser'       => $up['manage_staff_id'],
                        'template_id'  => SIGNATURE,
                        'url'=>$url,
                        'data'         => [
                            'first'=>[
                                'value'=> '您有一条客诉需要处理！',
                                'color'=> '#173177'
                            ],
                            'keyword1'=>[
                                'value'=> '工单号'.$params['work_number'],
                                'color'=> '#173177'
                            ],
                            'keyword2'=>[
                                'value'=> date('Y-m-d H:i:s',time()),
                                'color'=> '#173177'
                            ],
                            'remark'=>[
                                'value'=> '请尽快处理，谢谢！',
                                'color'=> '#173177'
                            ],
                        ],
                    ];
                    $send_data['content'] = json_encode($content);
                    $res = sendMsg($send_data);
                //}
            }
            return array('code'=>200,'msg'=>'审核操作成功');
        }else{
            return array('code'=>100,'msg'=>'操作失败，请稍后重试');
        }
    }

    /*
    * 标记相关人员已处理客诉
    */
    public function manageKs($params){  //6已处理
        db()->startTrans();
        try{
            //is_ks 6相关人员已处理   is_status 4 已解决
            db('k_work_order')->where('work_number',$params['work_number'])->update(['is_ks'=>$params['is_ks'],'is_status'=>4]);
            $change['work_number']  = $params['work_number'];
            $change['manage_staff_name'] = $params['manage_staff_name'];
            $change['manage_staff_id']   = $params['manage_staff_id'];
            $change['manage_staff_number'] = $params['manage_staff_number'];
            $change['manage_time'] = date('Y-m-d H:i:s',time());
            $change['manage_type'] = 5;
            $change['note']  = '相关人员处理-'.$params['note'];
            db('k_manage_log')->insert($change);
            db()->commit();
            return array('code'=>200,'msg'=>'操作成功');
        }catch (Exception $e){
            db()->rollback();
            return array('code'=>100,'msg'=>'操作失败，请稍后重试');

        }

    }


    /*
     * 订单查询
     */
    public function searchOrder($params){
        $page = $params['page'] ? $params['page'] : 1;
        $limit = $params['limit'] ? $params['limit'] : 10;
        $end_time=$params['end_time'];
        $params['end_time']=date("Y-m-d",strtotime("$end_time +1 day"));

        $erp = config('ext.app_config')['sx_erp'];
        $addr= $erp['addr'];
        $url = $addr.'SX_CrmApi/Sel_CustomerOrderList?Token=^******^&CustomerType=0';
        $url = $url.'&orderinfo='.$params['keyword'].'&brandid=&startdate='.$params['end_time'].'&enddate='.$params['start_time'];
        $dataErp = '[]';
        $response = requestERP($url, $dataErp);
        if($response['Code'] == 200) {
            $result['code'] = 0;
            $result['msg'] = '';
            $result['data'] = $response['Data'];
            $result['count'] = count($response['Data']);
            return $result;

        }
    }

}