<?php
/**
 * 品控中心->知识库目录结构
 * CRM的基本功能实现，如客资录入，客资查询等。
 * 所有业务的真正实现全在lib目录下建controller并且访问modle等，供controller层调用
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: chaidongdong<chaidongdong@suxuantech.cn> 2018-03-08 $
 */
namespace app\kf\model;
use think\Model;

class TKnowledge extends model{

	/**
	 * 多条查询
	 *
	 * @param array 	$filter 	条件
	 * @param string 	$filed 		字段
	 * @param int 		$offect 	开始字段
	 * @param int 		$limit 		条数
	 * @param string 	$order 		排序
	 * @param string 	$group 		分组
	 * @param bool    	$toArray 	是否转数组
	 * @return array
	 * @author chaidongdong@suxuantech.cn
	 */
	public function getList($filter = [], $field = '*', $page = 1, $limit = '', $order = '', $group = '', $toArray = true){
        $model = db('t_knowledge');
		foreach ($filter as $key => $value) {
			if(is_array($value)){
				$model->where($key,$value['s'],$value['v']);
			}else{
				$model->where($key,$value);
			}
		}
		$result = $model->field($field)->page($page,$limit)->order($order)->group($group)->select();
		if($toArray && $result){
			return \think\model\Collection::make($result)->toArray();
		}
		return $result;
	}

	/**
	 * 单条查询
	 *
	 * @param array 	$filter 	条件
	 * @param string 	$filed 		字段
	 * @param string 	$order 		排序
	 * @param string 	$group 		分组
	 * @param bool    	$toArray 	是否转数组
	 * @return array
	 * @author chaidongdong@suxuantech.cn
	 */
	public function getOne($filter = [], $field = '*', $order = '', $group = '', $toArray = true){
        $model = db('t_knowledge');
		foreach ($filter as $key => $value) {
			// dd($filter);
			if(is_array($value)){
				$model->where($key,$value['s'],$value['v']);
			}else{
				$model->where($key,$value);
			}
		}
		$result =  $model->field($field)->order($order)->group($group)->find();
		if($toArray && $result && is_object($result)){
			return $result->toArray();
		}
		return $result;
	}

	/**
	 * 条数统计
	 * 
	 * @param array 	$filter 	条件
	 * @return array
	 * @author chaidongdong@suxuantech.cn
	 */
	public function getCount($filter = []){
        $model = db('t_knowledge');
		foreach ($filter as $key => $value) {
			// dd($filter);
			if(is_array($value)){
				$model->where($key,$value['s'],$value['v']);
			}else{
				$model->where($key,$value);
			}
		}
		return $model->count();
	}

	/**
	 * 添加培训
	 * 
	 * @param array $data
	 * @return int
	 * @author chaidongdong@suxuantech.cn
	 */
	public function tInsert($data){
        $model = db('t_knowledge');
		return $model->insert($data);
	}

	/**
	 * 修改数据
	 *
	 * @param array $update   数据
	 * @param array $filter   条件
	 * @return bool
	 * @author chaidongdong@suxuantech.cn
	 */
	public function tUpdate($update, $filter = []){
		$model = db('t_knowledge');
		foreach ($filter as $key => $value) {
			// dd($filter);
			if(is_array($value)){
				$model->where($key,$value['s'],$value['v']);
			}else{
				$model->where($key,$value);
			}
		}
		return $model->update($update);
	}

	/**
	 * 删除数据
	 *
	 * @param array $filter 条件
	 * @return bool
	 * @author chaidongdong@suxuantech.cn
	 */
	public function tDelete($filter = []){
		$model = db('t_knowledge_class');
		foreach ($filter as $key => $value) {
			// dd($filter);
			if(is_array($value)){
				$model->where($key,$value['s'],$value['v']);
			}else{
				$model->where($key,$value);
			}
		}
		return $model->delete();
	}

}