/**
 * Created by sff on 2018/1/3.
 */

$(function(){
    // 右上角时间显示
    $("#Timer").text(new Date().toLocaleString());
    setInterval(function(){
        $("#Timer").text(new Date().toLocaleString());
    },1000);
    //设置尺寸
    function setRem () { // 绑定到窗口的这个事件中
        var whdef = 100/1920;// 表示1920的设计图,使用100PX的默认值
        var wH = window.innerHeight;// 当前窗口的高度
        var wW = window.innerWidth<=1920?1920:window.innerWidth;// 当前窗口的宽度
        var rem = wW * whdef;// 以默认比例值乘以当前窗口宽度,得到该宽度下的相应FONT-SIZE值
        $('html').css('font-size', rem + "px");
    }
    setRem ();
    $(window).resize(function(){
        setRem ();
        window.location.reload();
    });
    bigScreenPic();

    setInterval(function(){
        initPage();
        // leftOne();
        // leftTwo();
        // rightOne();
        // rightTwo();
        bigScreenPic();
    // }, 6000);
    }, 60000);
});
function initPage(){
    $.ajax({
        type: "POST",
        url: '{:url(crm/Statistics/bigscreen)}',
        data: '',
        success:function(msg){
            if (msg) {
                // 事业部日毛客资排名
                $("#leftOne").html(getBrandDayCusHtml(msg.brandDayCus));
                // 事业部月毛客资排名
                $("#leftTwo").html(getBrandMonthCusHtml(msg.brandMonthCus));
                // 事业部 网销 日邀约排名
                $("#rightOne").html(getBrandDayCusHtml(msg.brandDayWxInv));
                // 事业部 控潜(深挖) 邀约排名
                $("#rightTwo").html(getBrandMonthCusHtml(msg.brandDaySwInv));
                // 客资总量
                $("#allCustomer").html(msg.allCustomer);
                // 新单量(所有)
                $("#newOrder").html(msg.newOrder);
                // 有效获取量
                $("#validCustomer").html(msg.validCustomer);
                // 新单成本
                $("#newCustomerCost").html(msg.newCustomerCost);
                // 获取率
                $("#validRate").html(msg.validRate);
                // 无效单
                $("#noValidOrder").html(msg.noValidOrder);
                // 营收金额 (有效单)
                $("#ysMoney").html(msg.ysMoney);
                // 成交金额 (有效+无效 单)
                $("#orderMoney").html(msg.orderMoney);
                // 实收金额 (实际收入)
                $("#realMoney").html(msg.realMoney);
                // 转化率 
                $("#changeRate").html(msg.changeRate);
                // 获取成本
                $("#getRate").html(msg.getRate);
            };
            
        },
        error:function(){
            initPage();
        }
    })
}
// 事业部日毛客资排名
function getBrandDayCusHtml(data){
    var ret = '<tr><th colspan="4">事业部日毛客资排名</th></tr>';
    for(var i in data){
        ret += '<tr><td>'+(++i)+'</td><td>'+data[i].brandclassSort+'</td><td>'+data[i].dayNum+'</td><td></td></tr>';
    }
    return ret;
}
// 事业部月毛客资排名
function getBrandMonthCusHtml(data){
    var ret = '<tr><th colspan="4">事业部月毛客资排名</th></tr>';
    for(var i in data){
        ret += '<tr><td>'+(++i)+'</td><td>'+data[i].brandclassSort+'</td><td>'+data[i].monthNum+'</td><td></td></tr>';
    }
    return ret;
}

// 事业部网销日邀约排名
function getBrandDayCusHtml(data){
    var ret = '<tr><th colspan="4">事业部网销日邀约排名</th></tr>';
    for(var i in data){
        ret += '<tr><td>'+(++i)+'</td><td>'+data[i].brandclassSort+'</td><td>'+data[i].dayNum+'</td><td></td></tr>';
    }
    return ret;
}
// 事业部控潜邀约排名
function getBrandMonthCusHtml(data){
    var ret = '<tr><th colspan="4">事业部控潜邀约排名</th></tr>';
    for(var i in data){
        ret += '<tr><td>'+(++i)+'</td><td>'+data[i].brandclassSort+'</td><td>'+data[i].dayNum+'</td><td></td></tr>';
    }
    return ret;
}

function bigScreenPic () {
    // 基于准备好的dom，初始化echarts实例
    var myChart = echarts.init(document.getElementById('myChart'));
    myChart.clear();

    myChart.setOption({
        tooltip: {
            trigger: 'axis',
            axisPointer: {
                type: 'cross',
                crossStyle: {
                    color: '#999'
                }
            }
        },
        legend: {
            data:['毛客资量','新单量','转化率']
        },
        xAxis: [
            {
                type: 'category',
                boundaryGap: false,
                splitLine:{
                    show:true
                },
                axisPointer: {
                    type: 'shadow'
                },
                data: []
            }
        ],      
        yAxis: [
            {
                type: 'value',
                name: '毛客资量/新单量（人）',
                // min: 0,
                // max: 20,
                // interval: 5,
                axisLabel: {
                    formatter: '{value} 个'
                }
            },
            {
                type: 'value',
                name: '转化率',
                min: 0,
                max: 100,
                interval: 20,
                axisLabel: {
                    formatter: '{value} %'
                }
            }
        ],
        series: []
    });
    var arr=[];
    $.ajax({
        type: 'POST',
        url : '/crm/Statistics/bigScreenPic',
        success: function(res){
            // console.log(res);
            for(var i=0;i<res.data.length;i++){
                if (i == 2) {
                    arr.push({
                        name:res.data[i].names,
                        type:"line",
                        // itemStyle: {
                        //     normal: {
                        //         color: "#6959CD",
                        //         lineStyle: {
                        //             color: "#6959CD",
                        //             width: 2
                        //         }
                        //     }
                        // },
                        yAxisIndex: 1,
                        label:{normal:{show:true}},
                        data:res.data[i].data,
                    });
                }else{
                    arr.push({
                        name:res.data[i].names,
                        data:res.data[i].data,
                        type:"line",
                    });
                }
            }
            myChart.setOption({
                xAxis: {
                    data: res.timezone
                },
                series: arr
            });
        }
    })
    // 使用刚指定的配置项和数据显示图表。
    // myChart.setOption(option);
};
/*-------------------------------||-------------------------------*/
// 左一，事业部日毛客资排名
function leftOne () {
    $.ajax({
        type: "POST",
        url: 'crm/Statistics/leftOne',
        data: '',
        success: function(msg){
            if( msg.code == 200 ){
                layer.alert(msg.msg);
                reloadGrid();
                return false;
            }else{
                layer.alert(msg.msg);
            }
        },
        error:function(){
            layer.alert('操作有误');
        }
    });
}
// 左二，事业部月毛客资排名
function leftTwo () {
    $.ajax({
        type: "POST",
        url: 'crm/Statistics/leftTwo',
        data: '',
        success: function(msg){
            if( msg.code == 200 ){
                layer.alert(msg.msg);
                reloadGrid();
                return false;
            }else{
                layer.alert(msg.msg);
            }
        },
        error:function(){
            layer.alert('操作有误');
        }
    });
}
// 右一，事业部网销日邀约排名
function rightOne () {
    $.ajax({
        type: "POST",
        url: 'crm/Statistics/rightOne',
        data: '',
        success: function(msg){
            if( msg.code == 200 ){
                layer.alert(msg.msg);
                reloadGrid();
                return false;
            }else{
                layer.alert(msg.msg);
            }
        },
        error:function(){
            layer.alert('操作有误');
        }
    });
}
// 右二，事业部控潜邀约排名
function rightTwo () {
    $.ajax({
        type: "POST",
        url: 'crm/Statistics/rightTwo',
        data: '',
        success: function(msg){
            if( msg.code == 200 ){
                layer.alert(msg.msg);
                reloadGrid();
                return false;
            }else{
                layer.alert(msg.msg);
            }
        },
        error:function(){
            layer.alert('操作有误');
        }
    });
}
