/**
 * Created by sff on 2018/1/3.
 */

$(function(){
    //设置尺寸
    function setRem ()// 绑定到窗口的这个事件中
    {
        var whdef = 100/1920;// 表示1920的设计图,使用100PX的默认值
        var wH = window.innerHeight;// 当前窗口的高度
        var wW = window.innerWidth<=1920?1920:window.innerWidth;// 当前窗口的宽度
        var rem = wW * whdef;// 以默认比例值乘以当前窗口宽度,得到该宽度下的相应FONT-SIZE值
        $('html').css('font-size', rem + "px");
    }
    setRem ();
    $(window).resize(function(){
        setRem ();
        window.location.reload();
    });
   // 右上角时间显示
    $("#Timer").text(new Date().toLocaleString());
    setInterval(function(){
        $("#Timer").text(new Date().toLocaleString());
    },1000);
    /* ---------------------------------------------  页面开始的时候加载的数据 start  --------------------------------------------- */
    // 页面基础数据
    baseData();
    // 四个排行榜
    rankData();
    // 转化漏斗 （日） 图
    dayChangeRate();
    // 转化漏斗 （月） 图
    monthChangeRate();
    // 本月毛客资量走势 图
    monthCustomerNumber();
    // 本月网销邀约 （进店） 量走势 图
    monthIntoNumber();
    // 本月网络新单量走势 图
    monthNewOrderNumber();
    // 本月转化率 （ 新单 / 有效获取 ） 走势 图
    monthOrderRateNumber();

    half = setInterval(function(){
        baseData();
    },30000);
    one = setInterval(function(){
        dayChangeRate();
        monthChangeRate();
        // 四个排行榜
        rankData();
    },60000);
    two = setInterval(function(){
        monthCustomerNumber();
        monthIntoNumber();
        monthNewOrderNumber();
        monthOrderRateNumber();
    },120000);
    /* ---------------------------------------------  页面开始的时候加载的数据 end  --------------------------------------------- */
    // 数据展示底部轮播
    var index=0;
    var half;
    var one;
    var two;
    var tabLunbo=function(){
        clearInterval(half);
        clearInterval(one);
        clearInterval(two);
        index++;
        if(index==$(".top-tab li").length){
            index=0;
        }
        $(".top-tab li").eq(index).addClass("active").siblings().removeClass("active");
        var bid = $(".top-tab li").eq(index).attr('bid');
        // 页面基础数据
        baseData(bid);
        // 四个排行榜
        rankData();
        dayChangeRate(bid);
        monthChangeRate(bid);
        monthCustomerNumber(bid);
        monthIntoNumber(bid);
        monthNewOrderNumber(bid);
        monthOrderRateNumber(bid);
        half = setInterval(function(){
            baseData(bid);
        },30000);
        one = setInterval(function(){
            dayChangeRate(bid);
            monthChangeRate(bid);
            // 四个排行榜
            rankData();
        },60000);
        two = setInterval(function(){
            monthCustomerNumber(bid);
            monthIntoNumber(bid);
            monthNewOrderNumber(bid);
            monthOrderRateNumber(bid);
        },120000);
    };
    var timer=setInterval(tabLunbo,300000);
    $(".top-tab li").click(function(){
        clearInterval(timer);
        index=$(this).index()-1;
        tabLunbo();
        timer=setInterval(tabLunbo,300000);
    });
});
// 页面基础数据
function baseData (brandclass_id) {
    $.ajax({
        type: 'POST',
        data: {brandclass_id:brandclass_id},
        url : '/crm/Bigscreen/baseData',
        success: function(res){
            if (res) {
                $("#dealMoney").html(res.dealMoney);
                $("#incomeMoney").html(res.incomeMoney);
                $("#orderNumber").html(res.orderNumber);
                $("#avgCost").html(res.avgCost);
                $("#invCost").html(res.invCost);
                $("#orderCost").html(res.orderCost);
                $("#dayChangeRateData").html('日转化率：'+res.dayChangeRate);
                $("#monthChangeRateData").html('月转化率：'+res.monthChangeRate);
            };
        },
        // error:function(){
        //     baseData(brandclass_id);
        // }
    })
}
// 四个排行榜
function rankData () {
    // var brandclass_id = brandclass_id;
    var brandclass_id = '';
    $.ajax({
        type: 'POST',
        data: {brandclass_id:brandclass_id},
        url : '/crm/Bigscreen/rankData',
        success: function(res){
            if (res) {
                // 毛客资
                var brandDayNew  = res.brandDayNew;
                var ret1 = '<table cellpadding="0" cellspacing="0">';
                var j1=0;
                for(var i = 0; i < brandDayNew.length; i++){
                    j1=i+1;
                    ret1 += '<tr><td>'+(j1)+'</td><td>'+brandDayNew[i]['nickname']+'</td><td>'+brandDayNew[i]['dayNum']+'/<small>'+brandDayNew[i]['monthNum']+'</small></td><td></td></tr>'
                }
                ret1 +='</table>';
                $('#brandDayNew').html(ret1);

                // // 有效客资
                // var brandDayInv  = res.brandDayInv;
                // var ret2 = '<table cellpadding="0" cellspacing="0">';
                // var j2=0;
                // for(var i = 0; i < brandDayInv.length; i++){
                //     j2=i+1;
                //     ret2 += '<tr><td>'+(j2)+'</td><td>'+brandDayInv[i]['nickname']+'</td><td>'+brandDayInv[i]['dayNum']+'/<small>'+brandDayInv[i]['monthNum']+'</small></td><td></td></tr>'
                // }
                // ret2 +='</table>';
                // $('#brandDayInv').html(ret2);

                // 转化率
                var brandChangeRate  = res.brandChangeRate;
                var ret2 = '<table cellpadding="0" cellspacing="0">';
                var j2=0;
                for(var i = 0; i < brandChangeRate.length; i++){
                    j2=i+1;
                    ret2 += '<tr><td>'+(j2)+'</td><td>'+brandChangeRate[i]['nickname']+'</td><td>'+brandChangeRate[i]['dayNum']+'%/<small>'+brandChangeRate[i]['monthNum']+'%</small></td><td></td></tr>'
                }
                ret2 +='</table>';
                $('#brandChangeRate').html(ret2);

                // 邀约
                var brandDayInto = res.brandDayInto;
                var ret3 = '<table cellpadding="0" cellspacing="0">';
                var j3=0;
                for(var i = 0; i < brandDayInto.length; i++){
                    j3=i+1;
                    ret3 += '<tr><td>'+(j3)+'</td><td>'+brandDayInto[i]['nickname']+'</td><td>'+brandDayInto[i]['dayNum']+'/<small>'+brandDayInto[i]['monthNum']+'</small></td><td></td></tr>'
                }
                ret3 +='</table>';
                $('#brandDayInto').html(ret3);

                // 新单
                var brandDayOrder= res.brandDayOrder;
                var ret4 = '<table cellpadding="0" cellspacing="0">';
                var j4=0;
                for(var i = 0; i < brandDayOrder.length; i++){
                    j4=i+1;
                    ret4 += '<tr><td>'+(j4)+'</td><td>'+brandDayOrder[i]['nickname']+'</td><td>'+brandDayOrder[i]['dayNum']+'/<small>'+brandDayOrder[i]['monthNum']+'</small></td><td></td></tr>'
                }
                ret4 +='</table>';
                $('#brandDayOrder').html(ret4);
            };
        }
    })
}
// 转化漏斗 （日） 图
function dayChangeRate (brandclass_id) {
    // 基于准备好的dom，初始化echarts实例
    var dayChangeRate = echarts.init(document.getElementById('dayChangeRate'));
    dayChangeRate.clear();

    dayChangeRate.setOption({
        title: {
            // text: '转化漏斗（日）',
        },
        tooltip: {
            trigger: 'axis',
            axisPointer: {
                type: 'shadow'
            }
        },
        color:['#ffaf74','#65fbe3','#85e6ff','#fcdd7f'],  //手动设置每个图例的颜色
        legend: {
            data: ['毛客资量','有效客资','进店','订单'],
            itemWidth: 15,
            itemHeight: 10,
            itemGap: 5,
            textStyle: {
                fontSize: 12,
                color: '#fff'
            }
        },
        grid: {
            x:'10%',
            y:'20%',
            x2:'5%',
            y2:"15%",
            borderWidth:1
        },
        xAxis: {
            type: 'value',
            axisLabel: {
                formatter: '{value}'
            },
            axisLine:{
                lineStyle:{
                    color:'#fff',
                    width:1
                }
            }
        },
        yAxis: {
            show:false,
            type: 'category'
        },
        series: [],
    });
    var arr=[];
    var labelOption = {
        normal: {
            show: true,
            position: 'right',
            // distance: '15',
            // align: 'left',
            // verticalAlign: 'middle',
            // rotate: 90,
            // formatter: '{c} {a}',
            formatter: '{c}',
            fontSize: 12,
            textStyle: {
                color: '#FFF',
            }
            // formatter: '{c}  {name|{a}}',
            // rich: {
            //     name: {
            //         textBorderColor: '#fff'
            //     }
            // }
        }
    };
    $.ajax({
        type: 'POST',
        data: {brandclass_id:brandclass_id},
        url : '/crm/Bigscreen/dayChangeRate',
        success: function(res){
            for(var i=0;i<res.length;i++){
                arr.push({
                    name: res[i].name,
                    data: [res[i].data],
                    type: 'bar',
                    label: labelOption,
                })
            }
            dayChangeRate.setOption({
                series: arr
            });
        }
    })
}
// 转化漏斗 （月） 图
function monthChangeRate (brandclass_id) {
    // 基于准备好的dom，初始化echarts实例
    var monthChangeRate = echarts.init(document.getElementById('monthChangeRate'));
    monthChangeRate.clear();

    monthChangeRate.setOption({
        tooltip: {
            trigger: 'axis',
            axisPointer: {
                type: 'shadow'
            }
        },
        color:['#ffaf74','#65fbe3','#85e6ff','#fcdd7f'],  //手动设置每个图例的颜色
        legend: {
            data: ['毛客资量','有效客资','进店','订单'],
            itemWidth: 15,
            itemHeight: 10,
            itemGap: 5,
            textStyle: {
                fontSize: 12,
                color: '#fff'
            }
        },
        grid: {
            x:'5%',
            y:'20%',
            x2:'10%',
            y2:"15%",
            borderWidth:1
        },
        xAxis: {
            type: 'value',
            axisLabel: {
                formatter: '{value}'
            },
            axisLine:{
                lineStyle:{
                    color:'#fff',
                    width:1
                }
            }
        },
        yAxis: {
            show:false,
            type: 'category'
        },
        series: [],
    });
    var arr=[];
    var labelOption = {
        normal: {
            show: true,
            position: 'right',
            // distance: '15',
            // align: 'left',
            // verticalAlign: 'middle',
            // rotate: 90,
            formatter: '{c}',
            fontSize: 12,
            textStyle: {
                color: '#FFF',
            }
            // formatter: '{c}  {name|{a}}',
            // rich: {
            //     name: {
            //         textBorderColor: '#fff'
            //     }
            // }
        }
    };
    $.ajax({
        type: 'POST',
        data: {brandclass_id:brandclass_id},
        url : '/crm/Bigscreen/monthChangeRate',
        success: function(res){
            for(var i=0;i<res.length;i++){
                arr.push({
                    name: res[i].name,
                    data: [res[i].data],
                    type: 'bar',
                    label: labelOption,
                })
            }
            monthChangeRate.setOption({
                series: arr
            });
        }
    })
}
// 本月毛客资量走势 图
function monthCustomerNumber (brandclass_id) {
    // 基于准备好的dom，初始化echarts实例
    var monthCustomerNumber = echarts.init(document.getElementById('monthCustomerNumber'));
    monthCustomerNumber.clear();

    monthCustomerNumber.setOption({
        tooltip: {
            trigger: 'axis'
        },
        color: ['#66e0ff'],
        grid: {
            x:'10%',
            y:'10%',
            x2:'5%',
            y2:"15%",
            borderWidth:1
        },
        xAxis:  {
            type: 'category',
            boundaryGap: false,
            axisLine:{
                lineStyle:{
                    color:'#fff',
                    width:1
                }
            },
            data: [],
        },
        yAxis: {
                type: 'value',
                // max:800,
                // min:0,
                axisLine:{
                    lineStyle:{
                        color:'#fff',
                        width:1
                    }
                }
        },
        series: [],
    });
    var arr=[];
    var labelOption = {
        normal: {
            show: true,
            position: 'top',
        }
    };
    $.ajax({
        type: 'POST',
        data: {brandclass_id:brandclass_id},
        url : '/crm/Bigscreen/monthCustomerNumber',
        success: function(res){
            arr.push({
                name:res.data[0].name,
                data:res.data[0].data,
                type: 'bar',
                // label: labelOption,
            })
            monthCustomerNumber.setOption({
                xAxis: {
                    data: res.timezone
                },
                series: arr
            });
        }
    })
}
// 本月网销邀约 （进店） 量走势 图
function monthIntoNumber (brandclass_id) {
    // 基于准备好的dom，初始化echarts实例
    var monthIntoNumber = echarts.init(document.getElementById('monthIntoNumber'));
    monthIntoNumber.clear();

    monthIntoNumber.setOption({
        color: ['#fcdd7f'],
        tooltip: {
            trigger: 'axis'
        },
        grid: {
            x:'5%',
            y:'10%',
            x2:'6%',
            y2:"15%",
            borderWidth:1
        },
        xAxis:  {
            type: 'category',
            boundaryGap: false,
            data: [],
            axisLine:{
                lineStyle:{
                    color:'#fff',
                    width:1
                }
            }
        },
        yAxis: {
            type: 'value',
            // max:800,
            // min:0,
            axisLine:{
                lineStyle:{
                    color:'#fff',
                    width:1
                }
            }
        },
        series: [],
    });
    var arr=[];
    var labelOption = {
        normal: {
            show: true,
            position: 'top',
        }
    };
    $.ajax({
        type: 'POST',
        data: {brandclass_id:brandclass_id},
        url : '/crm/Bigscreen/monthIntoNumber',
        success: function(res){
            arr.push({
                name:res.data[0].name,
                data:res.data[0].data,
                type: 'bar',
                // label: labelOption,
            })
            monthIntoNumber.setOption({
                xAxis: {
                    data: res.timezone
                },
                series: arr
            });
        }
    })
}
// 本月网络新单量走势 图
function monthNewOrderNumber (brandclass_id) {
    // 基于准备好的dom，初始化echarts实例
    var monthNewOrderNumber = echarts.init(document.getElementById('monthNewOrderNumber'));
    monthNewOrderNumber.clear();

    monthNewOrderNumber.setOption({
        color: ['#00ffd6'],
        tooltip: {
            trigger: 'axis'
        },
        grid: {
            x:'10%',
            y:'10%',
            x2:'5%',
            y2:"15%",
            borderWidth:1
        },
        xAxis:  {
            type: 'category',
            boundaryGap: false,
            data: [],
            axisLine:{
                lineStyle:{
                    color:'#fff',
                    width:1
                }
            }
        },
        yAxis: {
            type: 'value',
            axisLine:{
                lineStyle:{
                    color:'#fff',
                    width:1
                }
            }
        },
        series: [],
    });
    var arr=[];
    var labelOption = {
        normal: {
            show: true,
            position: 'top',
        }
    };
    $.ajax({
        type: 'POST',
        data: {brandclass_id:brandclass_id},
        url : '/crm/Bigscreen/monthNewOrderNumber',
        success: function(res){
            arr.push({
                name:res.data[0].name,
                data:res.data[0].data,
                type: 'bar',
                // label: labelOption,
            })
            monthNewOrderNumber.setOption({
                xAxis: {
                    data: res.timezone
                },
                series: arr
            });
        }
    })
}
// 本月转化率 （ 新单 / 有效获取 ） 走势 图
function monthOrderRateNumber (brandclass_id){
    // 基于准备好的dom，初始化echarts实例
    var monthOrderRateNumber = echarts.init(document.getElementById('monthOrderRateNumber'));
    monthOrderRateNumber.clear();

    monthOrderRateNumber.setOption({
        color: ['#ffae95','#ffaf74'],
        tooltip: {
            trigger: 'axis'
        },
        grid: {
            x:'7%',
            y:'10%',
            x2:'6%',
            y2:"15%",
            borderWidth:1
        },
        xAxis:  {
            type: 'category',
            boundaryGap: false,
            data: [],
            axisLine:{
                lineStyle:{
                    color:'#fff',
                    width:1
                }
            }
        },
        yAxis: {
            // type: 'value',
            interval: 25,
            axisLabel: {
                formatter: '{value} %'
            },
            axisLine:{
                lineStyle:{
                    color:'#fff',
                    width:1
                }
            }
        },
        series: [],
    });
    var arr=[];
    var labelOption = {
        normal: {
            show: true,
            position: 'top',
        }
    };
    $.ajax({
        type: 'POST',
        data: {brandclass_id:brandclass_id},
        url : '/crm/Bigscreen/monthOrderRateNumber',
        success: function(res){
            for(var i=0;i<res.data.length;i++){
                arr.push({
                    name:res.data[i].name,
                    data:res.data[i].data,
                    type: 'line',
                    // label: labelOption,
                })
            }
            monthOrderRateNumber.setOption({
                xAxis: {
                    data: res.timezone
                },
                series: arr
            });
        }
    })
}