$(function () {
    //表单
    layui.use('form', function () {
        var form = layui.form;
    });
    //日历
    layui.use('laydate', function () {
        var laydate = layui.laydate;
        //单控件
        lay('.test-item').each(function () {
            laydate.render({
                elem: this
                , format: 'yyyy-MM-dd'
                , value: ''
                , trigger: 'click'
            });
        });
        // 预拍日期
        laydate.render({
            elem: '#yp_day'
            , format: 'yyyy-MM-dd H:m:s'
            , value: $("#yp_day").val()
            , trigger: 'click'
        });
        // 标记日期
        laydate.render({
            elem: '#op_signday'
            , format: 'yyyy-MM-dd H:m:s'
            , value: $("#op_signday").val()
            , trigger: 'click'
        });
        // 登记日期
        laydate.render({
            elem: '#dj_day'
            , format: 'yyyy-MM-dd H:m:s'
            , value: $("#dj_day").val()
            , trigger: 'click'
        });
        // 邀约日期
        laydate.render({
            elem: '#yjd_day'
            , format: 'yyyy-MM-dd H:m:s'
            , value: $("#yjd_day").val()
            , trigger: 'click'
        });
        // 订单日期
        laydate.render({
            elem: '#order_day'
            , format: 'yyyy-MM-dd H:m:s'
            , value: $("#order_day").val()
            , trigger: 'click'
        });
        // 进店日期
        laydate.render({
            elem: '#syjd_day'
            , format: 'yyyy-MM-dd H:m:s'
            , value: $("#syjd_day").val()
            , trigger: 'click'
        });
        // 结婚日期
        laydate.render({
            elem: '#marry_day'
            , format: 'yyyy-MM-dd'
            , value: $("#marry_day").val()
            , trigger: 'click'
        });
        // 预产日期
        laydate.render({
            elem: '#ready_baby_day'
            , format: 'yyyy-MM-dd'
            , value: $("#ready_baby_day").val()
            , trigger: 'click'
        });
        // 宝宝生日
        laydate.render({
            elem: '#baby_birthday'
            , format: 'yyyy-MM-dd'
            , value: $("#baby_birthday").val()
            , trigger: 'click'
        });

        lay('.hour-item').each(function () {
            laydate.render({
                elem: this
                , type: 'time'
                , done: function (value, date, endDate) {
                    console.log(value, date, endDate);
                }
                , change: function (value, date, endDate) {
                    //this.elem.val(value)
                }
            });
        });

    });
    function trim(str){
        return str.replace(/(^\s*)|(\s*$)/g, "");
    }
    //弹窗
    layui.use(['layer','layedit'], function () {
        var $ = layui.jquery, layer = layui.layer,layedit = layui.layedit;//独立版的layer无需执行这一句
        //触发事件
        var active = {
            add: function (cus) {
                layer.open({
                    title: '客诉登记',
                    type: 2,
                    skin: 'layui-layer-rim',
                    area: ['740px', '620px'],
                    //content: $('#add-box'),
                    content: "/crm/Order/workOrderAdd",
                    btn: ['提交', '取消'],
                    yes: function (iframeDom,index) {
                        var shade = layer.load(1, {shade: 0.3});
                        var cus = $(".layui-layer-content iframe").contents().children();

                        // 获取 iframe
                        var iframeWin = window[$(index).find('iframe')[0]['name']];
                        // 通过 getupContent 方法对 img_record 重新赋值
                        cus.find("#form1").find("#img_record").text(iframeWin.getupContent());
                        var customer  = cus.find("#form1").serialize();
                        var w_name    = trim(cus.find("#w_name").val());
                        var w_phone   = trim(cus.find("#w_phone").val());
                        var m_name    = trim(cus.find("#m_name").val());
                        var m_phone   = trim(cus.find("#m_phone").val());
                        var customer_number = trim(cus.find('#customer_number').val());
                        var order_number    = trim(cus.find('#order_number').val());

                        var source_id,source_name,complain_id,complain_name;
                        if (cus.find('#source_name').val()) {
                            source_name = cus.find('#source_name option:selected').html();//工单来源
                        } else {
                            source_name = "";
                        }
                        if (cus.find('#complain_name').val()) {
                            complain_name = cus.find('#complain_name option:selected').html();//来源
                        } else {
                            complain_name = "";
                        }

                        var name_reg=/^[a-zA-Z0-9_\u4e00-\u9fa5]{0,}$/;
                        if(w_name&&!name_reg.exec(w_name)){
                            layer.alert("姓名只能输入汉字、英文、数字和下划线");
                            layer.close(shade);
                            return false;
                        }
                        if(m_name&&!name_reg.exec(m_name)){
                            layer.alert("姓名只能输入汉字、英文、数字和下划线");
                            layer.close(shade);
                            return false;
                        }

                        var patrn = /^1[3|4|5|6|7|8|9][0-9]{9}$/;
                        if (w_phone && !patrn.exec(w_phone)) {
                            layer.alert("女士手机号输入错误");
                            layer.close(shade);
                            return false;
                        }
                        if (m_phone && !patrn.exec(m_phone)) {
                            layer.alert("男士手机号输入错误");
                            layer.close(shade);
                            return false;
                        }

                        var rege=/.*[\u4e00-\u9fa5]+.*$/;
                        if(customer_number&&rege.test(customer_number)){
                            layer.alert('客资编号输入错误');
                            layer.close(shade);
                            return false;
                        }
                        if(order_number&&rege.test(order_number)){
                            layer.alert('订单号输入错误');
                            layer.close(shade);
                            return false;
                        }

                        if (!w_phone && !m_phone) {
                            layer.alert("请填写女士手机号或男士手机号任一");
                            layer.close(shade);
                            return false;
                        }
                        complain_id = cus.find("#complain_name").val();
                        if (!complain_id) {
                            layer.alert("请选择投诉类型");
                            layer.close(shade);
                            return false;
                        }
                        source_id = cus.find("#source_name").val();
                        if (!source_id) {
                            layer.alert("请选择工单来源");
                            layer.close(shade);
                            return false;
                        }

                        $.ajax({
                            type: "POST",
                            url: "/crm/Order/addWorkOrder",
                            data: customer + '&source_name=' + source_name + '&complain_name=' + complain_name,
                            success: function (msg) {
                                console.log(msg);

                                //alert(msg.data.all_crm);console.log(msg.data.all_crm);
                                if (msg.code == 1) {
                                    layer.alert('录入成功');
                                    layer.close(shade);
                                    setTimeout(function(){
                                        layer.closeAll('iframe');
                                    },1500);
                                } else {
                                    layer.alert(msg.msg);
                                    layer.close(shade);
                                    return false;
                                }
                            }
                        });
                    }
                });
            }



        };

        $('.cus-btn').on('click', function () {
            var type = $(this).data('type');
            active[type] ? active[type].call(this) : '';
            $(this).addClass("active").siblings(".cus-model-btn").removeClass("active");
            if (type == "allot") {
                $("#allot-box").parent().css("overflow", "inherit");
            }
        });
    });

    //省市县
    layui.use('form', function(){
        var form = layui.form;
        form.on('select(province)', function(data){
            var province = data.value;
            if(province){
                $.ajax({
                    type: "POST",
                    url: 'searchCity',
                    data: "pid="+province,
                    success: function (msg) {
                        var replace = '<select name="city_id" id="city_id" lay-filter="city" class="cus-input"><option value="">请选择</option>';
                        for(var i=0;i<msg.length;i++){
                            replace += '<option value="'+msg[i]['id']+'">'+msg[i]['name']+'</option>';
                        }
                        replace +='</select>';
                        $(".city").html(replace);
                        var county='<select name="county_id" id="county_id" lay-filter="county" class="cus-input"><option value="">请选择</option></select>';
                        $(".county").html(county);
                        form.render();
                    }
                });
            }else{
                var replace = '<select name="city_id" id="city_id" lay-filter="city" class="cus-input"><option value="">请选择</option></select>';
                $(".city").html(replace);
                var county = '<select name="county_id" id="county_id" lay-filter="county" class="cus-input"><option value="">请选择</option></select>';
                $(".county").html(county);
                form.render();
            }

        });

        form.on('select(city)', function(data){
            var city = data.value;
            if(city){
                $.ajax({
                    type: "POST",
                    url: 'searchCity',
                    data: "pid="+city,
                    success: function (msg) {

                        var replace = '<select name="county_id" id="county_id" lay-filter="county" class="cus-input"><option value="">请选择</option>';
                        for(var i=0;i<msg.length;i++){
                            replace += '<option value="'+msg[i]['id']+'">'+msg[i]['name']+'</option>';
                        }
                        replace +='</select>';
                        $(".county").html(replace);
                        form.render();

                    }
                });
            }else{
                var replace = '<select name="county_id" id="county_id" lay-filter="county" class="cus-input"><option value="">请选择</option></select>';
                $(".county").html(replace);
                form.render();
            }

        });

        // 客资分配，部门--->员工选择，联动
        form.on('select(department)', function(data){
            var department_name = data.value;
            $.ajax({
                type: "POST",
                url: 'getDepartmentStaffs',
                data: "department_name="+department_name,
                success: function (msg) {
                    var replace = '<select name="staff_id" id="staff_id' +
                        '" lay-filter="staff" class="cus-input" ><option value="">请选择员工</option>';
                    for(var i=0;i<msg.length;i++){
                        replace += '<option value="'+msg[i]['id']+'">'+msg[i]['staffname']+'</option>';
                    }
                    replace +='</select>';
                    $(".staff").html(replace);
                    form.render();
                }
            });
        });
        // 客资详情、编辑 地区三级联动
        form.on('select(provinceI)', function(data){
            var province = data.value;
            $.ajax({
                type: "POST",
                url: '/crm/Customer/searchCity',
                data: "pid="+province,
                success: function (msg) {

                    var replace = '<select name="city_id" id="city_id" lay-filter="cityI" class="cus-input"><option value="">请选择</option>';
                    for(var i=0;i<msg.length;i++){
                        replace += '<option value="'+msg[i]['id']+'">'+msg[i]['name']+'</option>';
                    }
                    replace +='</select>';
                    // alert(replace);
                    $(".cityI").html(replace);
                    var county='<select name="county_id" id="county_id" lay-filter="countyI" class="cus-input"><option value="">请选择</option></select>';
                    $(".countyI").html(county);
                    form.render();

                }
            });
        });

        form.on('select(cityI)', function(data){
            var city = data.value;
            $.ajax({
                type: "POST",
                url: '/crm/Customer/searchCity',
                data: "pid="+city,
                success: function (msg) {

                    var replace = '<select name="county_id" id="county_id" lay-filter="countyI" class="cus-input"><option value="">请选择</option>';
                    for(var i=0;i<msg.length;i++){
                        replace += '<option value="'+msg[i]['id']+'">'+msg[i]['name']+'</option>';
                    }
                    replace +='</select>';
                    $(".countyI").html(replace);
                    form.render();

                }
            });
        });


    });

    //选项卡
    layui.use('element', function () {
        var element = layui.element;
    });


    //    滚动条问题
    $(".layui-layer-content").scroll(function(){
        $("body").preventDefault();
    })
});
