-- --------------------------------------------------------
-- 主机:                           127.0.0.1
-- 服务器版本:                        5.7.9 - MySQL Community Server (GPL)
-- 服务器操作系统:                      Win64
-- HeidiSQL 版本:                  9.4.0.5125
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8 */;
/*!50503 SET NAMES utf8mb4 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;


-- 导出 sx_vip 的数据库结构
CREATE DATABASE IF NOT EXISTS `sx_vip` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci */;
USE `sx_vip`;

-- 导出  表 sx_vip.action_log 结构
DROP TABLE IF EXISTS `action_log`;
CREATE TABLE IF NOT EXISTS `action_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `old_score` int(11) DEFAULT NULL,
  `new_score` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `brand_id` int(11) DEFAULT NULL,
  `staff_name` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  `old_level_name` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  `new_level_name` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  `up_time` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.action_log 的数据：~0 rows (大约)
DELETE FROM `action_log`;
/*!40000 ALTER TABLE `action_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `action_log` ENABLE KEYS */;

-- 导出  表 sx_vip.advertising 结构
DROP TABLE IF EXISTS `advertising`;
CREATE TABLE IF NOT EXISTS `advertising` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '//广告位id',
  `adv_name` varchar(100) CHARACTER SET utf8 DEFAULT '' COMMENT '//广告位名称',
  `adv_img` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '//广告位头像',
  `adv_count` varchar(255) CHARACTER SET utf8 DEFAULT '' COMMENT '//广告位描述',
  `adv_status` int(5) DEFAULT '0' COMMENT '//当前广告使用状态',
  `adv_staff` int(11) DEFAULT '0' COMMENT '//添加当前广告员工',
  `adv_cause` int(11) DEFAULT '0' COMMENT '//所属事业部',
  `create_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '//广告添加时间',
  `adv_seat` int(11) DEFAULT '0' COMMENT '//广告位投放位置说明 1DIY 2是任务大厅 3是我的任务 4推荐新人 5是推荐新人列表',
  `brandid` int(11) DEFAULT '0' COMMENT '品牌或门店id',
  `adv_detail` text COLLATE utf8_unicode_ci COMMENT '广告js',
  `adv_typeid` tinyint(2) DEFAULT NULL COMMENT '广告类型1是普通广告，2是轮播广告',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.advertising 的数据：~0 rows (大约)
DELETE FROM `advertising`;
/*!40000 ALTER TABLE `advertising` DISABLE KEYS */;
/*!40000 ALTER TABLE `advertising` ENABLE KEYS */;

-- 导出  表 sx_vip.api_app 结构
DROP TABLE IF EXISTS `api_app`;
CREATE TABLE IF NOT EXISTS `api_app` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `app_id` varchar(50) NOT NULL DEFAULT '' COMMENT '应用id',
  `app_secret` varchar(50) NOT NULL DEFAULT '' COMMENT '应用密码',
  `app_name` varchar(50) NOT NULL DEFAULT '' COMMENT '应用名称',
  `app_status` tinyint(2) NOT NULL DEFAULT '1' COMMENT '应用状态：0表示禁用，1表示启用',
  `app_type` tinyint(2) NOT NULL DEFAULT '1' COMMENT '应用类型',
  `app_info` tinytext NOT NULL COMMENT '应用说明',
  PRIMARY KEY (`id`),
  UNIQUE KEY `app_id` (`app_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COMMENT='appId和appSecret表';

-- 正在导出表  sx_vip.api_app 的数据：~3 rows (大约)
DELETE FROM `api_app`;
/*!40000 ALTER TABLE `api_app` DISABLE KEYS */;
INSERT INTO `api_app` (`id`, `app_id`, `app_secret`, `app_name`, `app_status`, `app_type`, `app_info`) VALUES
	(3, '94201193', 'DCGJduSGIceYUFNtWloBzzXhShXERsqH', '管理中心APP', 1, 1, ''),
	(4, '44793168', 'oUWKYeqCEojOvbmsynvWTctJSAVeoMZv', '客资系统', 1, 1, '客资CRM系统'),
	(5, '64255735', 'GjnkCcPgSjDXwRaruVAzcyCEJfloMtee', 'ERP系统', 1, 1, '');
/*!40000 ALTER TABLE `api_app` ENABLE KEYS */;

-- 导出  表 sx_vip.api_auth_group 结构
DROP TABLE IF EXISTS `api_auth_group`;
CREATE TABLE IF NOT EXISTS `api_auth_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `description` varchar(5) COLLATE utf8_unicode_ci DEFAULT '',
  `status` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.api_auth_group 的数据：~0 rows (大约)
DELETE FROM `api_auth_group`;
/*!40000 ALTER TABLE `api_auth_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `api_auth_group` ENABLE KEYS */;

-- 导出  表 sx_vip.api_auth_group_access 结构
DROP TABLE IF EXISTS `api_auth_group_access`;
CREATE TABLE IF NOT EXISTS `api_auth_group_access` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` mediumint(8) DEFAULT '0',
  `groupId` varchar(255) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.api_auth_group_access 的数据：~0 rows (大约)
DELETE FROM `api_auth_group_access`;
/*!40000 ALTER TABLE `api_auth_group_access` DISABLE KEYS */;
/*!40000 ALTER TABLE `api_auth_group_access` ENABLE KEYS */;

-- 导出  表 sx_vip.api_auth_rule 结构
DROP TABLE IF EXISTS `api_auth_rule`;
CREATE TABLE IF NOT EXISTS `api_auth_rule` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `url` varchar(80) COLLATE utf8_unicode_ci DEFAULT '',
  `groupId` int(11) DEFAULT '0',
  `auth` int(11) DEFAULT '0',
  `status` tinyint(4) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.api_auth_rule 的数据：~0 rows (大约)
DELETE FROM `api_auth_rule`;
/*!40000 ALTER TABLE `api_auth_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `api_auth_rule` ENABLE KEYS */;

-- 导出  表 sx_vip.api_fields 结构
DROP TABLE IF EXISTS `api_fields`;
CREATE TABLE IF NOT EXISTS `api_fields` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `fieldName` varchar(50) NOT NULL DEFAULT '' COMMENT '字段名称',
  `hash` varchar(50) NOT NULL DEFAULT '' COMMENT '对应接口的唯一标识',
  `dataType` tinyint(2) NOT NULL DEFAULT '0' COMMENT '数据类型，来源于DataType类库',
  `default` varchar(500) NOT NULL DEFAULT '' COMMENT '默认值',
  `isMust` tinyint(2) NOT NULL DEFAULT '0' COMMENT '是否必须 0为不必须，1为必须',
  `range` varchar(500) NOT NULL DEFAULT '' COMMENT '范围，Json字符串，根据数据类型有不一样的含义',
  `info` varchar(500) NOT NULL DEFAULT '' COMMENT '字段说明',
  `type` tinyint(2) NOT NULL DEFAULT '0' COMMENT '字段用处：0为request，1为response',
  `showName` varchar(50) NOT NULL DEFAULT '' COMMENT 'wiki显示用字段',
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=104 DEFAULT CHARSET=utf8 COMMENT='用于保存各个API的字段规则';

-- 正在导出表  sx_vip.api_fields 的数据：~72 rows (大约)
DELETE FROM `api_fields`;
/*!40000 ALTER TABLE `api_fields` DISABLE KEYS */;
INSERT INTO `api_fields` (`id`, `fieldName`, `hash`, `dataType`, `default`, `isMust`, `range`, `info`, `type`, `showName`) VALUES
	(1, 'aaa', '', 8, '123123', 1, 'fsdf', 'sf', 0, 'aaa'),
	(2, 'sdf', '', 1, 'asdf', 1, '', '', 0, 'sdf'),
	(3, '123', '', 1, '`12', 1, '`12', '', 0, '123'),
	(10, 'ergerger', '59ea0cd052201', 1, '324234', 0, '2342342', '34234', 1, 'ergerger'),
	(11, 'username', '59eb02fb401b1', 2, '', 1, 'test', '我是说明\n', 0, 'username'),
	(12, 'password', '59eb02fb401b1', 2, '', 1, '', '密码', 0, 'password'),
	(13, 'username', '59eb2c9d9b723', 2, '', 1, '', '用于登录的用户名，可以是手机号，或staff表内的登录名。', 0, 'username'),
	(14, 'password', '59eb2c9d9b723', 2, '', 1, '', '登录密码', 0, 'password'),
	(16, 'code', '59eb2c9d9b723', 1, '200', 1, '', '返回200表示成功。其他为失败', 1, 'code'),
	(17, 'staffid', '59eb382d6af16', 1, '', 1, '', '', 0, 'staffid'),
	(18, 'username', '59ec9360b6861', 2, '', 1, '', '用户名', 0, 'username'),
	(19, 'password', '59ec9360b6861', 2, '', 1, '', 'password', 0, 'password'),
	(20, 'username', '59f15d141e7e2', 2, '', 1, '', '', 0, 'username'),
	(21, 'oldpwd', '59f15d141e7e2', 2, '', 1, '', '', 0, 'oldpwd'),
	(22, 'newpwd', '59f15d141e7e2', 2, '', 1, '', '新密码', 0, 'newpwd'),
	(31, 'abc', '59f83a849c87d', 7, '', 1, '123', '456', 0, 'abc'),
	(48, 'test2', '5a4df22370da2', 2, '', 1, '', 'adfasdf', 0, 'test2'),
	(49, 'tel', '5a4dfeae25990', 1, '', 1, '', '用户手机号', 0, 'tel'),
	(50, 'brandid', '5a4dfc37a4318', 1, '0', 1, '', '品牌id或者叫事业部id，必填', 0, 'brandid'),
	(51, 'brand_id', '5a4dfeae25990', 1, '', 1, '', '事业部id', 0, 'brand_id'),
	(52, 'tel', '5a4e02a78f110', 1, '', 1, '', '用户手机号', 0, 'tel'),
	(53, 'brand_id', '5a4e02a78f110', 1, '', 1, '', '事业部id', 0, 'brand_id'),
	(54, 'order_code', '5a4e02a78f110', 1, '', 1, '', '订单号', 0, 'order_code'),
	(55, 'one_money', '5a4e02a78f110', 1, '', 1, '', '一销金额', 0, 'one_money'),
	(56, 'two_money', '5a4e02a78f110', 1, '', 1, '', '二销金额', 0, 'two_money'),
	(57, 'one_detail', '5a4e02a78f110', 3, '', 1, '', '一销明细', 0, 'one_detail'),
	(58, 'two_detail', '5a4e02a78f110', 3, '', 1, '', '二销明细', 0, 'two_detail'),
	(59, 'order_time', '5a4e02a78f110', 2, '', 1, '', '订单时间', 0, 'order_time'),
	(60, 'phone', '5a4dfc37a4318', 2, '', 1, '', '手机号码必须填写', 0, 'phone'),
	(61, 'couponcode', '5a4dfc37a4318', 2, '', 1, '', '输入优惠券码', 0, 'couponcode'),
	(62, 'checkuser', '5a4dfc37a4318', 1, '', 1, '', '操作人姓名', 0, 'checkuser'),
	(63, 'user_number', '5a51964e56636', 2, '', 1, '', '会员编号', 0, 'user_number'),
	(64, 'money', '5a51964e56636', 1, '', 1, '', '储值金额', 0, 'money'),
	(65, 'pay_money', '5a51ebad2bf4f', 1, '', 1, '', '支付金额', 0, 'pay_money'),
	(66, 'code', '5a51ebad2bf4f', 2, '', 1, '', '二维码编号为经过64加密', 0, 'code'),
	(67, 'user_id', '5a51ebad2bf4f', 1, '', 1, '', '会员id', 0, 'user_id'),
	(68, 'tel', '5a53159ac7032', 2, '', 1, '', '用户电话', 0, 'tel'),
	(69, 'brand_id', '5a53159ac7032', 1, '', 1, '', '事业部id', 0, 'brand_id'),
	(70, 'tel', '5a5315f09266b', 2, '', 1, '', '用户电话', 0, 'tel'),
	(71, 'user_code', '5a5315f09266b', 2, '', 1, '', '会员卡号码', 0, 'user_code'),
	(72, 'brand_id', '5a5315f09266b', 1, '', 1, '', '事业部id', 0, 'brand_id'),
	(73, 'tel', '5a5316581b829', 2, '', 1, '', '用户电话', 0, 'tel'),
	(74, 'user_code', '5a5316581b829', 2, '', 1, '', '会员卡号码', 0, 'user_code'),
	(75, 'brand_id', '5a5316581b829', 1, '', 1, '', '事业部id', 0, 'brand_id'),
	(76, 'day', '5a5316581b829', 1, '', 1, '', '需要延长多少天', 0, 'day'),
	(77, 'tel', '5a5316c5dc9b2', 2, '', 1, '', '用户电话', 0, 'tel'),
	(78, 'user_code', '5a5316c5dc9b2', 2, '', 1, '', '会员卡号码', 0, 'user_code'),
	(79, 'brand_id', '5a5316c5dc9b2', 1, '', 1, '', '事业部id', 0, 'brand_id'),
	(80, 'money', '5a5316c5dc9b2', 1, '', 1, '', '扣除金额', 0, 'money'),
	(81, 'staff_name', '5a5316c5dc9b2', 2, '', 1, '', '操作员工名称', 0, 'staff_name'),
	(82, 'staff_number', '5a5316c5dc9b2', 2, '', 1, '', '操作员工编号', 0, 'staff_number'),
	(83, 'order_code', '5a5316c5dc9b2', 2, '', 1, '', '该条消费记录单号', 0, 'order_code'),
	(84, 'order_title', '5a5316c5dc9b2', 2, '', 1, '', '该条消费单号的标题', 0, 'order_title'),
	(85, 'shop_name', '5a51964e56636', 2, '', 1, '', '充值店面', 0, 'shop_name'),
	(86, 'brand_id', '5a51964e56636', 1, '', 1, '', '事业部id', 0, 'brand_id'),
	(87, 'staff_name', '5a51964e56636', 2, '', 1, '', '充值员工', 0, 'staff_name'),
	(88, 'shop_name', '5a51ebad2bf4f', 2, '', 1, '', '扣款店面', 0, 'shop_name'),
	(89, 'brand_id', '5a51ebad2bf4f', 1, '', 1, '', '事业部id', 0, 'brand_id'),
	(90, 'staff_name', '5a51ebad2bf4f', 2, '', 1, '', '员工名称', 0, 'staff_name'),
	(91, 'order_code', '5a51ebad2bf4f', 2, '', 1, '', '消费单号', 0, 'order_code'),
	(92, 'staff_name', '5a570d045de23', 2, '', 1, '', '当前需要查询的员工姓名', 0, 'staff_name'),
	(93, 'brand_id', '5a570d045de23', 1, '', 1, '', '事业部id', 0, 'brand_id'),
	(94, 'shop_name', '5a570d045de23', 2, '', 1, '', '门店名称', 0, 'shop_name'),
	(95, 'phone', '5a57178b5e9a9', 2, '', 1, '', '用户手机号', 0, 'phone'),
	(96, 'shop_name', '5a57178b5e9a9', 2, '', 1, '', '门店信息', 0, 'shop_name'),
	(97, 'brand_id', '5a57178b5e9a9', 1, '', 1, '', '事业部id', 0, 'brand_id'),
	(98, 'card_code', '5a57178b5e9a9', 2, '', 1, '', '会员卡卡号', 0, 'card_code'),
	(99, 'shop_name', '5a5316c5dc9b2', 2, '', 1, '', '消费门店', 0, 'shop_name'),
	(100, 'shop_name', '5a570dd66c09f', 2, '', 1, '', '门店名称', 0, 'shop_name'),
	(101, 'phone', '5a570dd66c09f', 2, '', 1, '', '用户电话', 0, 'phone'),
	(102, 'brand_id', '5a570dd66c09f', 1, '', 1, '', '事业部id', 0, 'brand_id'),
	(103, 'code_password', '5a5316c5dc9b2', 2, '', 1, '', '会员卡密码', 0, 'code_password');
/*!40000 ALTER TABLE `api_fields` ENABLE KEYS */;

-- 导出  表 sx_vip.api_list 结构
DROP TABLE IF EXISTS `api_list`;
CREATE TABLE IF NOT EXISTS `api_list` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `apiName` varchar(50) NOT NULL DEFAULT '' COMMENT 'api索引，保存了类和方法',
  `apiUrl` varchar(50) DEFAULT NULL,
  `app_id` int(11) NOT NULL DEFAULT '0' COMMENT '应用ID',
  `hash` varchar(50) NOT NULL DEFAULT '' COMMENT 'api唯一标识',
  `accessToken` tinyint(2) NOT NULL DEFAULT '1' COMMENT '是否需要认证AccessToken 1：需要，0：不需要',
  `needLogin` tinyint(2) NOT NULL DEFAULT '1' COMMENT '是否需要认证用户token  1：需要 0：不需要',
  `status` tinyint(2) NOT NULL DEFAULT '1' COMMENT 'API状态：0表示禁用，1表示启用',
  `method` tinyint(2) NOT NULL DEFAULT '2' COMMENT '请求方式0：不限1：Post，2：Get',
  `info` varchar(500) NOT NULL DEFAULT '' COMMENT 'api中文说明',
  `isTest` tinyint(2) NOT NULL DEFAULT '0' COMMENT '是否是测试模式：0:生产模式，1：测试模式',
  `returnStr` text COMMENT '返回数据示例',
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8 COMMENT='用于维护接口信息';

-- 正在导出表  sx_vip.api_list 的数据：~13 rows (大约)
DELETE FROM `api_list`;
/*!40000 ALTER TABLE `api_list` DISABLE KEYS */;
INSERT INTO `api_list` (`id`, `apiName`, `apiUrl`, `app_id`, `hash`, `accessToken`, `needLogin`, `status`, `method`, `info`, `isTest`, `returnStr`) VALUES
	(15, '测试接口', 'Test/testApi', 4, '5a4df22370da2', 1, 0, 1, 1, '', 0, NULL),
	(16, '优惠券核销', 'User/useCoupon', 5, '5a4dfc37a4318', 1, 0, 1, 1, '优惠券核销操作', 1, NULL),
	(17, '验证ERP会员等级', 'Port/popUserGrade', 5, '5a4dfeae25990', 1, 0, 1, 1, '验证是否是会员并反回等级与折扣信息', 0, NULL),
	(18, 'ERP下单后自动成为会员接口', 'Port/defaultVip', 5, '5a4e02a78f110', 1, 0, 1, 1, 'ERP会员自动转为会员', 0, NULL),
	(19, '会员线下储值', 'Port/popMoney', 5, '5a51964e56636', 1, 0, 1, 1, '会员储值接口', 0, NULL),
	(20, '会员出示会员码支付', 'Port/codePay', 5, '5a51ebad2bf4f', 0, 0, 1, 1, '会员码支付', 0, NULL),
	(21, '获取当前用户名下所有卡信息', 'Port/userCardList', 5, '5a53159ac7032', 1, 0, 1, 1, '获取当前会员下的所有卡信息', 0, NULL),
	(22, '获取当前单张卡片的余额', 'Port/cardOneBalance', 5, '5a5315f09266b', 1, 0, 1, 1, '获取当前单张卡片的余额', 0, NULL),
	(23, '延长有效期', 'Port/extendTime', 5, '5a5316581b829', 1, 0, 1, 1, '延长有效期', 0, NULL),
	(24, '会员使用帐号密码扣款', 'Port/cardDebit', 5, '5a5316c5dc9b2', 1, 0, 1, 1, '会员使用帐号密码扣款', 0, NULL),
	(25, '充值记录查询接口', 'Port/popMoneyRecord', 5, '5a570d045de23', 1, 0, 1, 1, '调用会员储值记录接口', 0, NULL),
	(26, '会员在门店消费记录查询', 'Port/codePayRecord', 5, '5a570dd66c09f', 1, 0, 1, 1, '通过支付码支付的记录', 0, NULL),
	(27, '储值卡消费记录', 'Port/cardDebitRecord', 5, '5a57178b5e9a9', 1, 0, 1, 1, '储值卡消费记录', 0, NULL);
/*!40000 ALTER TABLE `api_list` ENABLE KEYS */;

-- 导出  表 sx_vip.app_version 结构
DROP TABLE IF EXISTS `app_version`;
CREATE TABLE IF NOT EXISTS `app_version` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `version` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `up_time` datetime DEFAULT NULL,
  `up_sql` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=97 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='应用版本管理';

-- 正在导出表  sx_vip.app_version 的数据：~75 rows (大约)
DELETE FROM `app_version`;
/*!40000 ALTER TABLE `app_version` DISABLE KEYS */;
INSERT INTO `app_version` (`id`, `version`, `up_time`, `up_sql`) VALUES
	(1, '0.0.4', '2018-01-09 19:19:17', 'CREATE TABLE `m_money_log`(`id` int  NOT NULL  AUTO_INCREMENT ,`u_number` char(100)  NOT NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,`u_money` decimal(10,2)  NOT NULL  DEFAULT 0 ,`u_time` datetime  NOT NULL  DEFAULT 0 ,PRIMARY KEY (`id`)) COLLATE=\'utf8_unicode_ci\'  ENGINE=InnoDB \r\nCREATE TABLE `m_mp_log`(`m_id` int  NOT NULL  AUTO_INCREMENT ,`m_money` decimal(10,2)  NOT NULL  DEFAULT 0 ,`m_code` char(100)  NOT NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,`m_time` datetime  NOT NULL  DEFAULT 0 ,PRIMARY KEY (`m_id`)) COLLATE=\'utf8_unicode_ci\'  ENGINE=InnoDB \r\nCREATE TABLE `c_card_list`(`id` int  NOT NULL  AUTO_INCREMENT ,`user_phone_id` int  NULL  DEFAULT 0 ,`card_type_id` int  NULL  DEFAULT 0 ,`card_no` varchar(100)  NOT NULL  COLLATE \'utf8_unicode_ci\' ,`card_value` decimal(12,2)  NULL  DEFAULT 0.00 ,`balance` decimal(12,2)  NULL  DEFAULT 0.00 ,`status` tinyint(1)  NULL  DEFAULT 1 ,`create_time` datetime  NULL ,`expire_time` datetime  NULL ,`create_staff_id` int  NULL  DEFAULT 0 ,`create_staff_name` varchar(200)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,PRIMARY KEY (`id`)) COLLATE=\'utf8_unicode_ci\'  ENGINE=InnoDB \r\nCREATE TABLE `c_card_log`(`id` int  NOT NULL  AUTO_INCREMENT ,`consume_money` decimal(12,2)  NULL  DEFAULT 0.00 ,`consume_time` datetime  NULL ,`card_list_id` int  NOT NULL ,`consume_order_code` varchar(200)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,`consume_title` varchar(200)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,`create_staff_number` varchar(120)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,`create_staff_name` varchar(120)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,PRIMARY KEY (`id`)) COLLATE=\'utf8_unicode_ci\'  ENGINE=InnoDB \r\n ALTER TABLE `m_users_phone`  ADD COLUMN `update_time` datetime  NULL \r\nCREATE TABLE `c_vip_save`(`id` int  NOT NULL  AUTO_INCREMENT ,`url` varchar(250)  NOT NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,`data` text  NULL  COLLATE \'utf8_unicode_ci\' ,`create_time` datetime  NULL ,`error_count` int  NOT NULL  DEFAULT 4 ,`call_time` varchar(11)  NOT NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,PRIMARY KEY (`id`)) COLLATE=\'utf8_unicode_ci\'  ENGINE=InnoDB '),
	(2, '0.0.7', '2018-01-11 10:44:06', ' ALTER TABLE `m_money_log`  ADD COLUMN `shop_name` varchar(100)  NOT NULL  COLLATE \'utf8_unicode_ci\' , ADD COLUMN `staff_name` varchar(100)  NOT NULL  COLLATE \'utf8_unicode_ci\' \r\n ALTER TABLE `m_mp_log`  ADD COLUMN `shop_name` varchar(100)  NOT NULL  COLLATE \'utf8_unicode_ci\' , ADD COLUMN `staff_name` varchar(100)  NOT NULL  COLLATE \'utf8_unicode_ci\' , ADD COLUMN `order_code` varchar(100)  NOT NULL  COLLATE \'utf8_unicode_ci\' '),
	(3, '0.0.15', '2018-01-17 18:22:33', 'CREATE TABLE `c_excel_import`(`id` int  NOT NULL  AUTO_INCREMENT ,`file_name` varchar(100)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,`file_url` varchar(300)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,`fail_file_url` varchar(300)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,`addtime` datetime  NULL ,`status` tinyint(1)  NULL  DEFAULT 0 ,`all_number` int  NULL  DEFAULT 0 ,`import_number` int  NULL  DEFAULT 0 ,`fail_number` int  NULL  DEFAULT 0 ,`brandid` int  NULL  DEFAULT 0 ,`staff_id` varchar(100)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,`staff_name` varchar(100)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,PRIMARY KEY (`id`)) COLLATE=\'utf8_unicode_ci\'  ENGINE=InnoDB \r\nCREATE TABLE `api_auth_group`(`id` int  NOT NULL  AUTO_INCREMENT ,`name` varchar(50)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,`description` varchar(5)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,`status` tinyint(1)  NULL  DEFAULT 1 ,PRIMARY KEY (`id`)) COLLATE=\'utf8_unicode_ci\'  ENGINE=InnoDB \r\nCREATE TABLE `api_auth_group_access`(`id` int  NOT NULL  AUTO_INCREMENT ,`uid` mediumint(8)  NULL  DEFAULT 0 ,`groupId` varchar(255)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,PRIMARY KEY (`id`)) COLLATE=\'utf8_unicode_ci\'  ENGINE=InnoDB \r\nCREATE TABLE `api_auth_rule`(`id` int  NOT NULL  AUTO_INCREMENT ,`url` varchar(80)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,`groupId` int  NULL  DEFAULT 0 ,`auth` int  NULL  DEFAULT 0 ,`status` tinyint  NULL  DEFAULT 1 ,PRIMARY KEY (`id`)) COLLATE=\'utf8_unicode_ci\'  ENGINE=InnoDB \r\nCREATE TABLE `s_menu`(`id` int  NOT NULL  AUTO_INCREMENT ,`menu_name` varchar(100)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,`fid` int  NULL  DEFAULT 0 ,`menu_code` varchar(100)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,`menu_url` varchar(100)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,`menu_icon` varchar(50)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,`status` tinyint(1)  NULL  DEFAULT 1 ,`sort` int  NULL  DEFAULT 0 ,PRIMARY KEY (`id`)) COLLATE=\'utf8_unicode_ci\'  ENGINE=InnoDB \r\nCREATE TABLE `s_position_menu`(`id` int  NOT NULL  AUTO_INCREMENT ,`position_code` varchar(100)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,`menu_code` varchar(2000)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,`menu_url` varchar(100)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,`status` tinyint(1)  NULL  DEFAULT 1 ,PRIMARY KEY (`id`)) COLLATE=\'utf8_unicode_ci\'  ENGINE=InnoDB '),
	(4, '0.0.19', '2018-01-19 21:50:48', ' ALTER TABLE `recommend`  ADD COLUMN `price_type` tinyint(1)  NULL  DEFAULT 1 , ADD COLUMN `sell_counselor` varchar(150)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' , ADD COLUMN `remark` text  NULL  COLLATE \'utf8_unicode_ci\' \r\nCREATE TABLE `wx_event_log`(`id` int  NOT NULL  AUTO_INCREMENT ,`form_openid` varchar(100)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,`openid` varchar(100)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,`event_type` tinyint(1)  NULL  DEFAULT 0 ,`brandid` int  NULL  DEFAULT 0 ,`create_time` datetime  NOT NULL ,PRIMARY KEY (`id`)) COLLATE=\'utf8_unicode_ci\'  ENGINE=InnoDB \r\nCREATE TABLE `wx_menu`(`id` int  NOT NULL  AUTO_INCREMENT ,`parentid` int  NULL  DEFAULT 0 ,`name` varchar(60)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,`url` varchar(100)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,`brandid` int  NULL  DEFAULT 0 ,`create_time` datetime  NOT NULL ,`staff_id` varchar(100)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,`staff_name` varchar(100)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,PRIMARY KEY (`id`)) COLLATE=\'utf8_unicode_ci\'  ENGINE=InnoDB \r\nCREATE TABLE `wx_auto_relay`(`id` int  NOT NULL  AUTO_INCREMENT ,`name` varchar(100)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,`content` varchar(1000)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,`brandid` int  NULL  DEFAULT 0 ,`create_time` datetime  NOT NULL ,`staff_id` varchar(100)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,`staff_name` varchar(100)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,PRIMARY KEY (`id`)) COLLATE=\'utf8_unicode_ci\'  ENGINE=InnoDB '),
	(5, '0.0.20', '2018-01-20 17:01:47', 'CREATE TABLE `wx_default_info`(`id` int  NOT NULL  AUTO_INCREMENT ,`follow_msg` varchar(500)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,`relay_msg` varchar(200)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,`brandid` int  NULL  DEFAULT 0 ,`create_time` datetime  NOT NULL ,`staff_id` varchar(100)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,`staff_name` varchar(100)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,PRIMARY KEY (`id`)) COLLATE=\'utf8_unicode_ci\'  ENGINE=InnoDB '),
	(6, '0.0.21', '2018-01-23 17:53:51', ' ALTER TABLE `wx_default_info`  ADD COLUMN `appid` varchar(100)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' , ADD COLUMN `appsecret` varchar(100)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' '),
	(7, '0.0.22', '2018-01-24 10:27:03', 'CREATE TABLE `m_withdraw`(`id` int  NOT NULL  AUTO_INCREMENT ,`user_phone_id` int  NULL ,`user_true_name` varchar(100)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,`user_number` char(25)  NULL  DEFAULT 0  COLLATE \'utf8_unicode_ci\' ,`user_bank` varchar(100)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,`bank_code` char(200)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,`bank_status` tinyint(1)  NULL  DEFAULT 1 ,`brandid` int  NULL  DEFAULT 0 ,`bank_time` datetime  NOT NULL ,PRIMARY KEY (`id`)) COLLATE=\'utf8_unicode_ci\'  ENGINE=InnoDB \r\nCREATE TABLE `m_withdraw_log`(`id` int  NOT NULL  AUTO_INCREMENT ,`get_money` decimal(10,2)  NULL  DEFAULT 0.00 ,`get_time` datetime  NOT NULL ,`user_phone_id` int  NULL ,`money_status` tinyint(1)  NULL  DEFAULT 2 ,`staff_name` varchar(200)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,`exe_time` datetime  NOT NULL ,PRIMARY KEY (`id`)) COLLATE=\'utf8_unicode_ci\'  ENGINE=InnoDB '),
	(8, '0.0.24', '2018-01-25 17:11:14', ' ALTER TABLE `m_withdraw_log`  ADD COLUMN `error_state` varchar(225)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' \r\n ALTER TABLE `a_activity_list`  ADD COLUMN `ishot` tinyint(1)  NULL  DEFAULT 0 '),
	(9, '0.0.24', '2018-01-25 17:11:14', NULL),
	(10, '0.0.24', '2018-01-25 17:11:14', NULL),
	(11, '0.0.25', '2018-01-26 08:12:49', ' ALTER TABLE `a_activity_list`  ADD COLUMN `hot_img` varchar(100)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' '),
	(12, '0.0.26', '2018-01-27 14:08:35', ' ALTER TABLE `c_coupon_list`  ADD COLUMN `activityid` int  NULL  DEFAULT 0 '),
	(13, '0.0.28', '2018-01-30 16:12:00', ' ALTER TABLE `m_withdraw_log`  ADD COLUMN `brandid` int  NULL  DEFAULT 0 '),
	(14, '0.0.29', '2018-01-31 15:27:39', ' ALTER TABLE `wedding_lovecard`  ADD COLUMN `invitation_site_lat` varchar(100)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' , ADD COLUMN `invitation_site_lng` varchar(100)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' '),
	(15, '0.0.29', '2018-01-31 15:27:39', NULL),
	(16, '0.0.29', '2018-01-31 15:27:39', NULL),
	(17, '0.0.29', '2018-01-31 15:27:39', NULL),
	(18, '0.0.30', '2018-01-31 21:33:57', 'CREATE TABLE `action_log`(`id` int  NOT NULL  AUTO_INCREMENT ,`old_score` int  NULL ,`new_score` int  NULL ,`user_id` int  NULL ,`brand_id` int  NULL ,`staff_name` varchar(200)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,`old_level_name` varchar(200)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,`new_level_name` varchar(200)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,`up_time` datetime  NOT NULL ,PRIMARY KEY (`id`)) COLLATE=\'utf8_unicode_ci\'  ENGINE=InnoDB '),
	(19, '0.0.32', '2018-02-01 18:50:59', 'CREATE TABLE `secretary`(`id` int  NOT NULL  AUTO_INCREMENT ,`name` varchar(100)  NULL  COLLATE \'utf8_unicode_ci\' ,`phone` varchar(11)  NULL  COLLATE \'utf8_unicode_ci\' ,`brandid` int  NULL  DEFAULT 0 ,`create_time` datetime  NOT NULL ,`staff_id` varchar(100)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,`staff_name` varchar(100)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,PRIMARY KEY (`id`)) COLLATE=\'utf8_unicode_ci\'  ENGINE=InnoDB \r\n ALTER TABLE `recommend`  ADD COLUMN `secretary_id` int  NULL '),
	(20, '0.0.34', '2018-02-03 21:38:29', ' ALTER TABLE `m_mp_log`  ADD COLUMN `m_title` varchar(100)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' \r\n ALTER TABLE `m_money_log`  ADD COLUMN `u_title` varchar(100)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' '),
	(21, '0.0.35', '2018-02-04 11:08:35', 'CREATE TABLE `wx_extend`(`id` int  NOT NULL  AUTO_INCREMENT ,`title` varchar(100)  NULL  COLLATE \'utf8_unicode_ci\' ,`ticket` varchar(500)  NULL  COLLATE \'utf8_unicode_ci\' ,`scene` varchar(255)  NULL  COLLATE \'utf8_unicode_ci\' ,`scaned_num` int  NULL  DEFAULT 0 ,`follow_num` int  NULL  DEFAULT 0 ,`brandid` int  NULL  DEFAULT 0 ,`create_time` datetime  NOT NULL ,`delete_time` datetime  NOT NULL ,`staff_id` int  NULL  DEFAULT 0 ,`staff_name` varchar(100)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,PRIMARY KEY (`id`)) COLLATE=\'utf8_unicode_ci\'  ENGINE=InnoDB \r\nCREATE TABLE `wx_extend_detail`(`id` int  NOT NULL  AUTO_INCREMENT ,`extend_id` int  NULL  DEFAULT 0 ,`openid` varchar(100)  NULL  COLLATE \'utf8_unicode_ci\' ,`state` tinyint  NULL  DEFAULT 0 ,`scan_time` datetime  NOT NULL ,`follow_time` datetime  NOT NULL ,`event` varchar(100)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,`event_key` varchar(200)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,PRIMARY KEY (`id`)) COLLATE=\'utf8_unicode_ci\'  ENGINE=InnoDB \r\n INSERT INTO `s_menu`  (menu_name,fid,menu_code,menu_url,menu_icon,status,sort)  SELECT \'微信渠道管理\',\'0\',\'menu1517658795\',\'/crm/Setting/province\',\'fa-share-alt\',\'1\',\'90\' '),
	(22, '0.0.37', '2018-02-05 11:17:18', ' ALTER TABLE `m_users_phone`  ADD COLUMN `c_excel_import_id` int  NULL  DEFAULT 0 \r\n ALTER TABLE `m_users_phone`  ADD COLUMN `truename` varchar(100)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' '),
	(23, '0.0.43', '2018-02-08 13:07:16', 'CREATE TABLE `a_activity_msg`(`id` int  NOT NULL  AUTO_INCREMENT ,`activity_id` int  NULL  DEFAULT 0 ,`userid` int(0)  NULL ,`content` varchar(255)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,`create_time` datetime  NULL ,`update_time` datetime  NULL ,`status` tinyint(1)  NULL  DEFAULT 0 ,`check_time` datetime  NULL ,`staff_name` varchar(100)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,`staff_id` varchar(50)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,PRIMARY KEY (`id`)) COLLATE=\'utf8_unicode_ci\'  ENGINE=InnoDB \r\n ALTER TABLE `c_coupon_num`  ADD COLUMN `discount_type` tinyint(1)  NOT NULL  DEFAULT 0 , ADD COLUMN `expire_time` int  NULL  DEFAULT 0 \r\n ALTER TABLE `c_coupon_list`  ADD COLUMN `discount_type` tinyint(1)  NOT NULL  DEFAULT 0 , ADD COLUMN `expire_time` datetime  NULL \r\n ALTER TABLE `c_coupon_list`  ADD COLUMN `discount_value` int  NOT NULL  DEFAULT 0 , ADD COLUMN `condition_value` int  NOT NULL  DEFAULT 0 \r\n ALTER TABLE `a_activity_sign_up`  ADD COLUMN `b_content` varchar(256)  NOT NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' '),
	(24, '0.0.44', '2018-02-08 13:40:00', ' ALTER TABLE `a_activity_msg`  ADD COLUMN `user_del` tinyint  NOT NULL  DEFAULT 0 '),
	(25, '0.0.45', '2018-02-08 14:31:35', ' ALTER TABLE `c_coupon_list`  ADD COLUMN `name` varchar(100)  NOT NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' '),
	(28, '0.0.46', '2018-03-04 15:33:12', 'CREATE TABLE `wx_help`(`id` int  NOT NULL  AUTO_INCREMENT ,`help_scene` varchar(100)  NULL  COLLATE \'utf8_unicode_ci\' ,`help_name` varchar(255)  NULL  COLLATE \'utf8_unicode_ci\' ,`help_info` text  NULL  COLLATE \'utf8_unicode_ci\' ,`template_code` varchar(50)  NULL  COLLATE \'utf8_unicode_ci\' ,`help_img` varchar(255)  NULL  COLLATE \'utf8_unicode_ci\' ,`brand_id` int(11)  NULL  DEFAULT 0 ,`start_time` datetime  NULL ,`end_time` datetime  NULL ,`params` text  NULL  COLLATE \'utf8_unicode_ci\' ,`status` tinyint  NULL  DEFAULT 1 ,`talk_code` text  NULL  COLLATE \'utf8_unicode_ci\' ,`subscribe_rule` text  NULL  COLLATE \'utf8_unicode_ci\' ,`sale_rule` text  NULL  COLLATE \'utf8_unicode_ci\' ,`share_title` varchar(50)  NULL  COLLATE \'utf8_unicode_ci\' ,`share_content` varchar(255)  NULL  COLLATE \'utf8_unicode_ci\' ,`root_ticket` varchar(200)  NULL  COLLATE \'utf8_unicode_ci\' ,`test_ticket` varchar(200)  NULL  COLLATE \'utf8_unicode_ci\' ,`award_top_image` varchar(255)  NULL  COLLATE \'utf8_unicode_ci\' ,`award_foot_image` varchar(255)  NULL  COLLATE \'utf8_unicode_ci\' ,`staff_id` int(11)  NULL ,`staff_name` varchar(11)  NULL  COLLATE \'utf8_unicode_ci\' ,`create_time` datetime  NULL ,`delete_time` datetime  NULL ,PRIMARY KEY (`id`)) COLLATE=\'utf8_unicode_ci\'  ENGINE=InnoDB \r\nCREATE TABLE `wx_help_user`(`id` int  NOT NULL  AUTO_INCREMENT ,`parent_id` int(11)  NULL  DEFAULT 0 ,`help_id` int(11)  NULL ,`nick_name` varchar(200)  NULL  COLLATE \'utf8_unicode_ci\' ,`head_img` varchar(500)  NULL  COLLATE \'utf8_unicode_ci\' ,`help_num` int(11)  NULL  DEFAULT 0 ,`fission_num` int(11)  NULL  DEFAULT 0 ,`award_num` int(11)  NULL  DEFAULT 0 ,`openid` varchar(100)  NULL  COLLATE \'utf8_unicode_ci\' ,`phone` varchar(50)  NULL  COLLATE \'utf8_unicode_ci\' ,`parent_nick_name` varchar(200)  NULL  COLLATE \'utf8_unicode_ci\' ,`parent_head_img` varchar(500)  NULL  COLLATE \'utf8_unicode_ci\' ,`parent_ids` text  NULL  COLLATE \'utf8_unicode_ci\' ,`ticket` varchar(255)  NULL  COLLATE \'utf8_unicode_ci\' ,`img` varchar(255)  NULL  COLLATE \'utf8_unicode_ci\' ,`add_time` datetime  NULL ,PRIMARY KEY (`id`)) COLLATE=\'utf8_unicode_ci\'  ENGINE=InnoDB \r\nCREATE TABLE `wx_help_templates`(`id` int  NOT NULL  AUTO_INCREMENT ,`code` varchar(50)  NOT NULL  COLLATE \'utf8_unicode_ci\' ,`title` varchar(100)  NOT NULL  COLLATE \'utf8_unicode_ci\' ,`bg_image` varchar(500)  NULL  COLLATE \'utf8_unicode_ci\' ,`psd_url` varchar(500)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,`params` text  NULL  COLLATE \'utf8_unicode_ci\' ,`status` tinyint  NULL  DEFAULT 1 ,`add_time` datetime  NULL ,PRIMARY KEY (`id`)) COLLATE=\'utf8_unicode_ci\'  ENGINE=InnoDB \r\nCREATE TABLE `wx_help_award`(`id` int  NOT NULL  AUTO_INCREMENT ,`help_id` int(11)  NOT NULL ,`award_type` tinyint(2)  NOT NULL ,`award_value` varchar(50)  NULL  COLLATE \'utf8_unicode_ci\' ,`coupon_id` int(11)  NULL ,`rule_type` int(11)  NULL ,`rule_value` varchar(50)  NULL  COLLATE \'utf8_unicode_ci\' ,`pay_amount` decimal(10)  NULL ,`stock` int(11)  NULL  DEFAULT 9999999 ,`image` varchar(255)  NULL  COLLATE \'utf8_unicode_ci\' ,`desc` text  NULL  COLLATE \'utf8_unicode_ci\' ,`create_time` datetime  NULL ,PRIMARY KEY (`id`)) COLLATE=\'utf8_unicode_ci\'  ENGINE=InnoDB \r\nCREATE TABLE `wx_help_user_award`(`id` int  NOT NULL  AUTO_INCREMENT ,`openid` varchar(200)  NOT NULL  COLLATE \'utf8_unicode_ci\' ,`help_id` int(11)  NOT NULL ,`award_id` int(11)  NOT NULL ,`award_title` varchar(50)  NULL  COLLATE \'utf8_unicode_ci\' ,`award_image` varchar(255)  NULL  COLLATE \'utf8_unicode_ci\' ,`status` tinyint(4)  NULL ,`get_time` datetime  NULL ,`send_time` datetime  NULL ,PRIMARY KEY (`id`)) COLLATE=\'utf8_unicode_ci\'  ENGINE=InnoDB '),
	(29, '0.0.46', '2018-03-04 15:33:12', NULL),
	(30, '0.0.46', '2018-03-04 15:33:12', NULL),
	(31, '0.0.47', '2018-03-08 16:07:43', ' ALTER TABLE `wx_help`  ADD COLUMN `share_score` int(11)  NULL  DEFAULT 0 '),
	(32, '0.0.48', '2018-03-10 16:20:46', ' ALTER TABLE `minute_log`  ADD COLUMN `users_phone_id` int(11)  NULL '),
	(33, '0.0.49', '2018-03-10 18:08:40', ' ALTER TABLE `user_level`  ADD COLUMN `sort` int(11)  NULL  DEFAULT 0 '),
	(34, '0.0.50', '2018-03-11 15:59:44', ' ALTER TABLE `m_users_phone`  ADD COLUMN `agent_status` tinyint(2)  NULL , ADD COLUMN `agent_type` tinyint(2)  NULL , ADD COLUMN `real_name` tinyint(2)  NULL , ADD COLUMN `agent_time` datetime  NULL '),
	(35, '0.0.51', '2018-03-12 10:10:10', ' ALTER TABLE `m_users_phone`  ADD COLUMN `apply_time` datetime  NULL , ADD COLUMN `check_apply_user` datetime  NULL , ADD COLUMN `check_apply_time` datetime  NULL '),
	(36, '0.0.52', '2018-03-14 20:05:21', ' ALTER TABLE `m_users`  ADD COLUMN `qq` varchar(50)  NULL  COLLATE \'utf8_unicode_ci\' , ADD COLUMN `email` varchar(100)  NULL  COLLATE \'utf8_unicode_ci\' , ADD COLUMN `weixin` varchar(100)  NULL  COLLATE \'utf8_unicode_ci\' , ADD COLUMN `address` varchar(300)  NULL  COLLATE \'utf8_unicode_ci\' , ADD COLUMN `remark` varchar(400)  NULL  COLLATE \'utf8_unicode_ci\' '),
	(55, '0.0.53', '2018-03-14 20:41:23', ' INSERT INTO `s_menu`  (id,menu_name,fid,menu_code,menu_url,menu_icon,status)  SELECT \'147\',\'经纪人管理\',\'15\',\'menu1520770309\',\'/vip/recommend/agent\',\'\',\'1\' union  SELECT \'148\',\'审核经纪人\',\'147\',\'menu1520773491\',\'/vip/recommend/checkAgent\',\'\',\'1\' union  SELECT \'150\',\'修改会员资料\',\'5\',\'menu1520842088\',\'/vip/users/editusers\',\'\',\'1\' '),
	(56, '0.0.54', '2018-03-15 22:26:58', ' INSERT INTO `s_menu`  (id,menu_name,fid,menu_code,menu_url,menu_icon,status,sort)  SELECT \'151\',\'微信接力活动\',\'0\',\'menu1521123031\',\'vip/wxhelp/index\',\'fa-user-plus\',\'1\',\'89\' '),
	(58, '0.0.55', '2018-03-15 23:40:37', ' INSERT INTO `wx_help_templates`  (code,title,bg_image,top_image,foot_image,psd_url,params,status,add_time)  SELECT \'yungger\',\'萌宝表情包（儿童）\',\'/public/resource/images/6acdd1e7af65f002e251142a0c6e555a.jpg\',\'\',\'\',\'\',\'{"bg": {"scale": "1", "x": "0", "y": "0"},"avatar": {"scale": "1", "x": "50", "y": "34", "color": "#ab9898"},"qrcode": {"scale": "1", "x": "75", "y": "1164"},"is_show_avatar": "1"}\',\'1\',\'2018-03-08 19:52:31\' union  SELECT \'autumn\',\'你的爱情，我来记录（婚纱）\',\'/public/resource/images/373b67c6323e9d9ef72f10a44bfdb63c.jpg\',\'\',\'\',\'\',\'{"bg": {"scale": "1", "x": "0", "y": "0"},"avatar": {"scale": "1", "x": "50", "y": "34", "color": "#ab9898"},"qrcode": {"scale": "1", "x": "75", "y": "1164"},"is_show_avatar": "1"}\',\'1\',\'2018-03-08 19:52:31\' union  SELECT \'love\',\'有缘，相惠\',\'/public/resource/images/4737fdbc76c8a48640378922060afb0e.jpg\',\'\',\'\',\'\',\'{"bg": {"scale": "1", "x": "0", "y": "0"},"avatar": {"scale": "1", "x": "50", "y": "34", "color": "#ab9898"},"qrcode": {"scale": "1", "x": "75", "y": "1164"},"is_show_avatar": "1"}\',\'1\',\'2018-03-08 19:52:31\' '),
	(59, '0.0.56', '2018-03-30 09:38:49', ' ALTER TABLE `c_coupon_num`  ADD COLUMN `is_show` tinyint(2)  NULL  DEFAULT 0 '),
	(60, '0.0.57', '2018-04-11 17:14:56', 'CREATE TABLE `c_kf`(`id` int  NOT NULL  AUTO_INCREMENT ,`url` varchar(250)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,`brandid` int(11)  NULL ,`create_time` datetime  NULL ,PRIMARY KEY (`id`)) COLLATE=\'utf8_unicode_ci\'  ENGINE=InnoDB '),
	(61, '0.0.58', '2018-04-17 21:25:05', 'CREATE TABLE `group_cause`(`id` int  NOT NULL  AUTO_INCREMENT ,`cause` varchar(255)  NULL  COLLATE \'utf8_unicode_ci\' ,`name` varchar(255)  NULL  COLLATE \'utf8_unicode_ci\' ,`phone` varchar(255)  NULL  COLLATE \'utf8_unicode_ci\' ,`groupuser_id` int(10)  NULL ,PRIMARY KEY (`id`)) COLLATE=\'utf8_unicode_ci\'  ENGINE=InnoDB '),
	(62, '0.0.58', '2018-04-17 21:25:05', NULL),
	(63, '0.0.58', '2018-04-17 21:25:05', NULL),
	(64, '0.0.58', '2018-04-17 21:25:05', NULL),
	(65, '0.0.58', '2018-04-17 21:25:05', NULL),
	(66, '0.0.58', '2018-04-17 21:25:05', NULL),
	(67, '0.0.58', '2018-04-17 21:25:05', NULL),
	(68, '0.0.58', '2018-04-17 21:25:05', NULL),
	(69, '0.0.58', '2018-04-17 21:25:05', NULL),
	(70, '0.0.58', '2018-04-17 21:25:05', NULL),
	(71, '0.0.58', '2018-04-17 21:25:05', NULL),
	(72, '0.0.58', '2018-04-17 21:25:05', NULL),
	(73, '0.0.58', '2018-04-17 21:25:05', NULL),
	(74, '0.0.58', '2018-04-17 21:25:05', NULL),
	(75, '0.0.58', '2018-04-17 21:25:05', NULL),
	(76, '0.0.58', '2018-04-17 21:25:05', NULL),
	(77, '0.0.58', '2018-04-17 21:25:05', NULL),
	(78, '0.0.58', '2018-04-17 21:25:05', NULL),
	(79, '0.0.59', '2018-04-20 20:47:34', ' ALTER TABLE `group_cause`  ADD COLUMN `create_time` datetime  NULL '),
	(80, '0.0.59', '2018-04-20 20:47:34', NULL),
	(81, '0.0.59', '2018-04-20 20:47:34', NULL),
	(82, '0.0.59', '2018-04-20 20:47:34', NULL),
	(83, '0.0.59', '2018-04-20 20:47:34', NULL),
	(84, '0.0.59', '2018-04-20 20:47:34', NULL),
	(85, '0.0.59', '2018-04-20 20:47:34', NULL),
	(86, '0.0.59', '2018-04-20 20:47:34', NULL),
	(87, '0.0.59', '2018-04-20 20:47:34', NULL),
	(88, '0.0.59', '2018-04-20 20:47:34', NULL),
	(89, '0.0.59', '2018-04-20 20:47:34', NULL),
	(90, '0.0.59', '2018-04-20 20:47:34', NULL),
	(91, '0.0.59', '2018-04-20 20:47:34', NULL),
	(92, '0.0.59', '2018-04-20 20:47:34', NULL),
	(93, '0.0.59', '2018-04-20 20:47:34', NULL),
	(94, '0.0.59', '2018-04-20 20:47:34', NULL),
	(95, '0.0.59', '2018-04-20 20:47:34', NULL),
	(96, '0.0.59', '2018-04-20 20:47:34', NULL);
/*!40000 ALTER TABLE `app_version` ENABLE KEYS */;

-- 导出  表 sx_vip.a_activity_link 结构
DROP TABLE IF EXISTS `a_activity_link`;
CREATE TABLE IF NOT EXISTS `a_activity_link` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `activityid` int(11) DEFAULT '0' COMMENT '活动id ',
  `link` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '连接地址',
  `qrcode` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '二维码图片',
  `create_user` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '添加的人',
  `create_time` datetime DEFAULT NULL,
  `delete_time` datetime DEFAULT NULL,
  `brandid` int(11) DEFAULT '0' COMMENT '品牌id',
  `visit_total` int(11) DEFAULT '0' COMMENT '观看总数',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '是否删除1表示删除，0表示正常',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.a_activity_link 的数据：~0 rows (大约)
DELETE FROM `a_activity_link`;
/*!40000 ALTER TABLE `a_activity_link` DISABLE KEYS */;
/*!40000 ALTER TABLE `a_activity_link` ENABLE KEYS */;

-- 导出  表 sx_vip.a_activity_list 结构
DROP TABLE IF EXISTS `a_activity_list`;
CREATE TABLE IF NOT EXISTS `a_activity_list` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(150) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '活动标题',
  `scontent` varchar(200) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '简要说明',
  `content` text COLLATE utf8_unicode_ci COMMENT '详细说明',
  `couponid` int(11) DEFAULT '0' COMMENT '优惠券id',
  `share_score` int(11) DEFAULT '0' COMMENT '分享赠送的积分数量',
  `index_img` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '活动首页图片',
  `status` tinyint(1) DEFAULT '0' COMMENT '是否启用',
  `start_time` datetime DEFAULT NULL COMMENT '//当前活动所属事业部',
  `end_time` datetime DEFAULT NULL COMMENT '活动结束时间',
  `order_num` int(11) DEFAULT '0' COMMENT '排序数字',
  `share_total` int(11) DEFAULT '0' COMMENT '分享次数',
  `view_total` int(11) DEFAULT '0' COMMENT '浏览记录',
  `delete_time` datetime DEFAULT NULL COMMENT '是否删除',
  `create_time` datetime DEFAULT NULL COMMENT '活动添加时间',
  `update_time` datetime DEFAULT NULL,
  `create_user` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '//活动添加人',
  `share_title` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '分享时的标题',
  `share_img` varchar(200) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '分享时显示的图片',
  `share_content` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '分享时的详细介绍',
  `brandid` int(11) DEFAULT '0' COMMENT '品牌或者事业部id',
  `permit_level` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '只允许查看的用户级别',
  `signup_total` int(11) DEFAULT '0' COMMENT '// 报名数量',
  `style_detail` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '样式详情',
  `iswid` int(11) DEFAULT '0',
  `ishot` tinyint(1) DEFAULT '0',
  `hot_img` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='活动列表';

-- 正在导出表  sx_vip.a_activity_list 的数据：~0 rows (大约)
DELETE FROM `a_activity_list`;
/*!40000 ALTER TABLE `a_activity_list` DISABLE KEYS */;
/*!40000 ALTER TABLE `a_activity_list` ENABLE KEYS */;

-- 导出  表 sx_vip.a_activity_msg 结构
DROP TABLE IF EXISTS `a_activity_msg`;
CREATE TABLE IF NOT EXISTS `a_activity_msg` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `activity_id` int(11) DEFAULT '0',
  `userid` int(11) DEFAULT NULL,
  `content` varchar(255) COLLATE utf8_unicode_ci DEFAULT '',
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  `status` tinyint(1) DEFAULT '0',
  `check_time` datetime DEFAULT NULL,
  `staff_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `staff_id` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `user_del` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.a_activity_msg 的数据：~0 rows (大约)
DELETE FROM `a_activity_msg`;
/*!40000 ALTER TABLE `a_activity_msg` DISABLE KEYS */;
/*!40000 ALTER TABLE `a_activity_msg` ENABLE KEYS */;

-- 导出  表 sx_vip.a_activity_sign_up 结构
DROP TABLE IF EXISTS `a_activity_sign_up`;
CREATE TABLE IF NOT EXISTS `a_activity_sign_up` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `activityid` int(11) DEFAULT '0' COMMENT '活动id',
  `userid` int(11) DEFAULT '0' COMMENT '用户id',
  `b_username` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '预约用户名',
  `b_phone` varchar(50) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '预约电话',
  `wename` varchar(50) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '微信用户名',
  `photo_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '预约的拍照类别',
  `shopid` varchar(100) COLLATE utf8_unicode_ci DEFAULT '0' COMMENT '预约店铺',
  `status` tinyint(1) DEFAULT '0' COMMENT '预约状态',
  `check_userid` int(11) DEFAULT '0' COMMENT '审核人',
  `check_time` datetime DEFAULT NULL COMMENT '审核时间',
  `delete_time` datetime DEFAULT NULL COMMENT '是否删除',
  `create_time` datetime DEFAULT NULL COMMENT '添加时间',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `brandid` int(11) DEFAULT '0' COMMENT '品牌id',
  `sign_total` int(11) DEFAULT '0' COMMENT '活动报名总数',
  `check_name` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '//处理人名称',
  `b_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '//报名时间',
  `b_type` tinyint(5) DEFAULT '0' COMMENT '//展示类别 1是报名 2是报价',
  `shop_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '//店铺名称',
  `b_say` varchar(150) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '拍摄类型的备注',
  `iswid` int(11) DEFAULT '0',
  `b_content` varchar(256) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='活动预约和获取报价表';

-- 正在导出表  sx_vip.a_activity_sign_up 的数据：~0 rows (大约)
DELETE FROM `a_activity_sign_up`;
/*!40000 ALTER TABLE `a_activity_sign_up` DISABLE KEYS */;
/*!40000 ALTER TABLE `a_activity_sign_up` ENABLE KEYS */;

-- 导出  表 sx_vip.a_activity_visit 结构
DROP TABLE IF EXISTS `a_activity_visit`;
CREATE TABLE IF NOT EXISTS `a_activity_visit` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `activityid` int(11) DEFAULT '0' COMMENT '活动id',
  `userid` int(11) DEFAULT '0' COMMENT '访问用户id',
  `linkid` int(11) DEFAULT '0' COMMENT '来自连接的id',
  `link_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `from_brandid` int(11) DEFAULT '0' COMMENT '来自品牌id',
  `create_time` datetime DEFAULT NULL,
  `delete_time` datetime DEFAULT NULL,
  `add_time` datetime DEFAULT NULL COMMENT '添加时间',
  `iswid` tinyint(1) DEFAULT '0' COMMENT '0表示userid就是m_users里的id,1表示userid是m_we_users里的wid',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.a_activity_visit 的数据：~0 rows (大约)
DELETE FROM `a_activity_visit`;
/*!40000 ALTER TABLE `a_activity_visit` DISABLE KEYS */;
/*!40000 ALTER TABLE `a_activity_visit` ENABLE KEYS */;

-- 导出  表 sx_vip.bespeaks_photo 结构
DROP TABLE IF EXISTS `bespeaks_photo`;
CREATE TABLE IF NOT EXISTS `bespeaks_photo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` int(11) DEFAULT '0' COMMENT '预约用户id',
  `shopid` int(11) DEFAULT '0' COMMENT '预约店铺id',
  `b_type` tinyint(1) DEFAULT '0' COMMENT '预约类别1拍照，2选片',
  `status` tinyint(1) DEFAULT '0' COMMENT '状态',
  `check_userid` int(11) DEFAULT '0' COMMENT '审核人',
  `check_time` datetime DEFAULT NULL COMMENT '审核时间',
  `delete_time` datetime DEFAULT NULL COMMENT '是否删除',
  `create_time` datetime DEFAULT NULL COMMENT '预约拍照日期',
  `update_time` datetime DEFAULT NULL,
  `brandid` int(11) DEFAULT '0' COMMENT '品牌id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='预约拍照和选片表';

-- 正在导出表  sx_vip.bespeaks_photo 的数据：~0 rows (大约)
DELETE FROM `bespeaks_photo`;
/*!40000 ALTER TABLE `bespeaks_photo` DISABLE KEYS */;
/*!40000 ALTER TABLE `bespeaks_photo` ENABLE KEYS */;

-- 导出  表 sx_vip.bg_imgs 结构
DROP TABLE IF EXISTS `bg_imgs`;
CREATE TABLE IF NOT EXISTS `bg_imgs` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `brandid` int(11) DEFAULT NULL,
  `img` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `add_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.bg_imgs 的数据：~0 rows (大约)
DELETE FROM `bg_imgs`;
/*!40000 ALTER TABLE `bg_imgs` DISABLE KEYS */;
/*!40000 ALTER TABLE `bg_imgs` ENABLE KEYS */;

-- 导出  表 sx_vip.cameraman 结构
DROP TABLE IF EXISTS `cameraman`;
CREATE TABLE IF NOT EXISTS `cameraman` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '//摄影师表id',
  `c_name` varchar(50) CHARACTER SET utf8 DEFAULT '' COMMENT '//摄影师名称',
  `c_age` int(255) DEFAULT '0' COMMENT '//摄影师年龄',
  `c_tel` char(11) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '//摄影师电话',
  `c_shop` varchar(100) CHARACTER SET utf8 DEFAULT '' COMMENT '//摄影师门店',
  `c_img` varchar(255) CHARACTER SET utf8 DEFAULT '' COMMENT '//摄影师头像',
  `c_brief` text CHARACTER SET utf8 COMMENT '//摄影师简介',
  `c_address` varchar(50) CHARACTER SET utf8 DEFAULT '' COMMENT '//摄影师地点',
  `c_type` int(11) DEFAULT '0' COMMENT '//摄影师类型',
  `c_work` int(11) DEFAULT '1' COMMENT '//摄影师工作年限',
  `c_production` varchar(255) CHARACTER SET utf8 DEFAULT '' COMMENT '//摄影师作品封面',
  `c_rank` int(11) DEFAULT '0' COMMENT '//摄影师等级',
  `c_money` decimal(10,0) DEFAULT '0' COMMENT '//摄影师价格',
  `brandid` int(11) DEFAULT '0' COMMENT '//所属门店',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.cameraman 的数据：~0 rows (大约)
DELETE FROM `cameraman`;
/*!40000 ALTER TABLE `cameraman` DISABLE KEYS */;
/*!40000 ALTER TABLE `cameraman` ENABLE KEYS */;

-- 导出  表 sx_vip.cam_attention 结构
DROP TABLE IF EXISTS `cam_attention`;
CREATE TABLE IF NOT EXISTS `cam_attention` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '关注表id',
  `cam_id` int(11) DEFAULT NULL COMMENT '//摄影师id',
  `userid` int(11) DEFAULT NULL COMMENT '//用户id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.cam_attention 的数据：~0 rows (大约)
DELETE FROM `cam_attention`;
/*!40000 ALTER TABLE `cam_attention` DISABLE KEYS */;
/*!40000 ALTER TABLE `cam_attention` ENABLE KEYS */;

-- 导出  表 sx_vip.cam_evaluate 结构
DROP TABLE IF EXISTS `cam_evaluate`;
CREATE TABLE IF NOT EXISTS `cam_evaluate` (
  `e_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '//摄影师评价id',
  `userid` int(11) DEFAULT '0' COMMENT '//用户id',
  `camid` int(11) DEFAULT '0' COMMENT '摄影师id',
  `counts` varchar(255) CHARACTER SET utf8 DEFAULT '' COMMENT '//评价内容',
  `evaluate_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '//评价时间',
  `several_star` int(11) DEFAULT '0' COMMENT '//几星',
  `evaluate_title` varchar(100) CHARACTER SET utf8 DEFAULT '' COMMENT '//几字精简评价',
  `evaluate_img` varchar(255) CHARACTER SET utf8 DEFAULT '' COMMENT '//评价图片',
  `brandid` int(11) DEFAULT '0' COMMENT '品牌或门店id',
  `evaluate_count` int(11) DEFAULT '0' COMMENT '//有多少人回复了此评论',
  PRIMARY KEY (`e_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.cam_evaluate 的数据：~1 rows (大约)
DELETE FROM `cam_evaluate`;
/*!40000 ALTER TABLE `cam_evaluate` DISABLE KEYS */;
INSERT INTO `cam_evaluate` (`e_id`, `userid`, `camid`, `counts`, `evaluate_time`, `several_star`, `evaluate_title`, `evaluate_img`, `brandid`, `evaluate_count`) VALUES
	(2, 75, 31, 'asdfasdf', '2017-12-19 00:00:00', 0, '1', '', 6, 0);
/*!40000 ALTER TABLE `cam_evaluate` ENABLE KEYS */;

-- 导出  表 sx_vip.cam_order 结构
DROP TABLE IF EXISTS `cam_order`;
CREATE TABLE IF NOT EXISTS `cam_order` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '//预约订单表',
  `o_odd` varchar(255) CHARACTER SET utf8 DEFAULT '' COMMENT '//订单号',
  `o_name` varchar(200) CHARACTER SET utf8 DEFAULT '' COMMENT '//订单名称',
  `create_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '//下单时间',
  `pay_type` tinyint(4) DEFAULT '0' COMMENT '//付款方式',
  `pay_money` decimal(10,0) DEFAULT '0' COMMENT '//付款金额',
  `o_status` tinyint(4) DEFAULT '0' COMMENT '//支付状态',
  `userid` int(11) DEFAULT '0' COMMENT '//支付人',
  `o_about_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '//订单预约时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.cam_order 的数据：~0 rows (大约)
DELETE FROM `cam_order`;
/*!40000 ALTER TABLE `cam_order` DISABLE KEYS */;
/*!40000 ALTER TABLE `cam_order` ENABLE KEYS */;

-- 导出  表 sx_vip.cam_production 结构
DROP TABLE IF EXISTS `cam_production`;
CREATE TABLE IF NOT EXISTS `cam_production` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '//摄影师id',
  `cam_id` int(11) DEFAULT NULL COMMENT '//摄影师id',
  `cam_img` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '//摄影师内容',
  `production_count` int(11) DEFAULT '0' COMMENT '//作品点赞数量统计',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.cam_production 的数据：~0 rows (大约)
DELETE FROM `cam_production`;
/*!40000 ALTER TABLE `cam_production` DISABLE KEYS */;
/*!40000 ALTER TABLE `cam_production` ENABLE KEYS */;

-- 导出  表 sx_vip.cam_reply 结构
DROP TABLE IF EXISTS `cam_reply`;
CREATE TABLE IF NOT EXISTS `cam_reply` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '//评论回复表',
  `e_id` int(11) DEFAULT NULL COMMENT '//评论人自增id',
  `userid` int(11) DEFAULT NULL COMMENT '//评论人id',
  `r_count` int(11) DEFAULT NULL COMMENT '//回复内容',
  `r_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '//回复时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.cam_reply 的数据：~0 rows (大约)
DELETE FROM `cam_reply`;
/*!40000 ALTER TABLE `cam_reply` DISABLE KEYS */;
/*!40000 ALTER TABLE `cam_reply` ENABLE KEYS */;

-- 导出  表 sx_vip.cam_reservation 结构
DROP TABLE IF EXISTS `cam_reservation`;
CREATE TABLE IF NOT EXISTS `cam_reservation` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '//摄影师预约表',
  `userid` int(11) DEFAULT '0' COMMENT '//预约用户id',
  `camid` int(11) DEFAULT '0' COMMENT '//摄影师id',
  `about_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '//预约时间',
  `brandid` int(11) DEFAULT '0' COMMENT '品牌或门店id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.cam_reservation 的数据：~0 rows (大约)
DELETE FROM `cam_reservation`;
/*!40000 ALTER TABLE `cam_reservation` DISABLE KEYS */;
/*!40000 ALTER TABLE `cam_reservation` ENABLE KEYS */;

-- 导出  表 sx_vip.cam_spot 结构
DROP TABLE IF EXISTS `cam_spot`;
CREATE TABLE IF NOT EXISTS `cam_spot` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '//点赞表id',
  `e_id` int(11) DEFAULT '0' COMMENT '//哪条评论',
  `userid` int(11) DEFAULT '0' COMMENT '//点赞人id',
  `spot_time` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '//点赞时间',
  `spot_type` tinyint(4) DEFAULT '0' COMMENT '//点赞类型 1是评论 2是作品',
  `cam_id` int(11) DEFAULT '0' COMMENT '//摄影师id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.cam_spot 的数据：~0 rows (大约)
DELETE FROM `cam_spot`;
/*!40000 ALTER TABLE `cam_spot` DISABLE KEYS */;
/*!40000 ALTER TABLE `cam_spot` ENABLE KEYS */;

-- 导出  表 sx_vip.cam_type 结构
DROP TABLE IF EXISTS `cam_type`;
CREATE TABLE IF NOT EXISTS `cam_type` (
  `typeid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '//摄影师类别id',
  `type_name` varchar(100) CHARACTER SET utf8 DEFAULT NULL COMMENT '//级别名称',
  PRIMARY KEY (`typeid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.cam_type 的数据：~0 rows (大约)
DELETE FROM `cam_type`;
/*!40000 ALTER TABLE `cam_type` DISABLE KEYS */;
/*!40000 ALTER TABLE `cam_type` ENABLE KEYS */;

-- 导出  表 sx_vip.card_rule 结构
DROP TABLE IF EXISTS `card_rule`;
CREATE TABLE IF NOT EXISTS `card_rule` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '//卡号生成规则id',
  `card_lenght` tinyint(1) DEFAULT '16' COMMENT '//默认卡号长度',
  `card_prefix` char(50) CHARACTER SET utf8 DEFAULT NULL COMMENT '//卡片前缀',
  `card_divide` tinyint(1) DEFAULT '1' COMMENT '//默认剔除4   1是去除2是不去除',
  `brandid` int(11) DEFAULT NULL COMMENT '//事业部id',
  `staffid` int(11) DEFAULT NULL COMMENT '//添加员工',
  `card_next` char(50) CHARACTER SET utf8 DEFAULT NULL COMMENT '//卡片后缀',
  `this_phone` tinyint(1) DEFAULT NULL COMMENT '//是否默认手机号',
  `card_number` char(50) CHARACTER SET utf8 DEFAULT NULL COMMENT '//卡长度',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.card_rule 的数据：~0 rows (大约)
DELETE FROM `card_rule`;
/*!40000 ALTER TABLE `card_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `card_rule` ENABLE KEYS */;

-- 导出  表 sx_vip.c_card_list 结构
DROP TABLE IF EXISTS `c_card_list`;
CREATE TABLE IF NOT EXISTS `c_card_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_phone_id` int(11) DEFAULT '0',
  `card_type_id` int(11) DEFAULT '0',
  `card_no` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `card_value` decimal(12,2) DEFAULT '0.00',
  `balance` decimal(12,2) DEFAULT '0.00',
  `status` tinyint(1) DEFAULT '1',
  `create_time` datetime DEFAULT NULL,
  `expire_time` datetime DEFAULT NULL,
  `create_staff_id` int(11) DEFAULT '0',
  `create_staff_name` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  `card_password` varchar(200) CHARACTER SET utf8 DEFAULT '666666' COMMENT '//密码',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.c_card_list 的数据：~0 rows (大约)
DELETE FROM `c_card_list`;
/*!40000 ALTER TABLE `c_card_list` DISABLE KEYS */;
/*!40000 ALTER TABLE `c_card_list` ENABLE KEYS */;

-- 导出  表 sx_vip.c_card_log 结构
DROP TABLE IF EXISTS `c_card_log`;
CREATE TABLE IF NOT EXISTS `c_card_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `consume_money` decimal(12,2) DEFAULT '0.00',
  `consume_time` datetime DEFAULT NULL,
  `card_list_id` int(11) NOT NULL,
  `consume_order_code` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  `consume_title` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  `create_staff_number` varchar(120) COLLATE utf8_unicode_ci DEFAULT '',
  `create_staff_name` varchar(120) COLLATE utf8_unicode_ci DEFAULT '',
  `shop_name` varchar(100) CHARACTER SET utf8 DEFAULT NULL COMMENT '//消费门店',
  `brand_id` int(11) DEFAULT NULL,
  `user_phone_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.c_card_log 的数据：~0 rows (大约)
DELETE FROM `c_card_log`;
/*!40000 ALTER TABLE `c_card_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `c_card_log` ENABLE KEYS */;

-- 导出  表 sx_vip.c_card_type 结构
DROP TABLE IF EXISTS `c_card_type`;
CREATE TABLE IF NOT EXISTS `c_card_type` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `card_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '卡类型名称',
  `card_img` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '卡图片',
  `status` tinyint(1) DEFAULT '1' COMMENT '卡状态',
  `price` decimal(12,2) DEFAULT '0.00' COMMENT '卡片售价',
  `discount` decimal(5,2) DEFAULT '100.00' COMMENT '享受的折扣',
  `card_desc` text COLLATE utf8_unicode_ci COMMENT '卡片说明',
  `order_num` int(11) DEFAULT '0' COMMENT '排序数',
  `card_prefix` varchar(11) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '卡片前缀',
  `card_balance` decimal(10,0) DEFAULT '0' COMMENT '//卡内余额',
  `expire_days` int(11) DEFAULT '0' COMMENT '//卡片有效时间天数',
  `create_time` datetime DEFAULT NULL COMMENT '添加日期',
  `update_time` datetime DEFAULT NULL COMMENT '最后修改时间',
  `delete_time` datetime DEFAULT NULL COMMENT '是否删除',
  `business_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '//所属事业部',
  `create_user` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '添加用户',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '是否删除',
  `brandid` int(11) DEFAULT '0' COMMENT '品牌或门店id',
  `add_time` datetime DEFAULT NULL COMMENT '卡片添加时间',
  `card_type` tinyint(1) DEFAULT NULL,
  `card_num` int(11) DEFAULT NULL,
  `card_pass` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='会员卡类型表';

-- 正在导出表  sx_vip.c_card_type 的数据：~0 rows (大约)
DELETE FROM `c_card_type`;
/*!40000 ALTER TABLE `c_card_type` DISABLE KEYS */;
/*!40000 ALTER TABLE `c_card_type` ENABLE KEYS */;

-- 导出  表 sx_vip.c_coupon_list 结构
DROP TABLE IF EXISTS `c_coupon_list`;
CREATE TABLE IF NOT EXISTS `c_coupon_list` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `userid` int(11) DEFAULT '0' COMMENT '用户id',
  `shopid` int(11) DEFAULT '0' COMMENT '优惠券使用店铺的id',
  `coupon_num_id` int(11) DEFAULT '0' COMMENT '优惠券批次id',
  `coupon_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '优惠券号',
  `status` tinyint(1) DEFAULT '0' COMMENT '0未消费，1消费，2已失效',
  `use_time` datetime DEFAULT NULL COMMENT '使用时间',
  `create_time` datetime DEFAULT NULL COMMENT '获取优惠券时间',
  `update_time` datetime DEFAULT NULL,
  `delete_time` datetime DEFAULT NULL COMMENT '是否删除',
  `check_user` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '更改状态的人',
  `brandid` int(11) DEFAULT '0' COMMENT '品牌或门店id',
  `iswid` int(11) DEFAULT '0',
  `activityid` int(11) DEFAULT '0',
  `discount_type` tinyint(1) NOT NULL DEFAULT '0',
  `expire_time` datetime DEFAULT NULL,
  `discount_value` int(11) NOT NULL DEFAULT '0',
  `condition_value` int(11) NOT NULL DEFAULT '0',
  `name` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='优惠券表 ';

-- 正在导出表  sx_vip.c_coupon_list 的数据：~0 rows (大约)
DELETE FROM `c_coupon_list`;
/*!40000 ALTER TABLE `c_coupon_list` DISABLE KEYS */;
/*!40000 ALTER TABLE `c_coupon_list` ENABLE KEYS */;

-- 导出  表 sx_vip.c_coupon_num 结构
DROP TABLE IF EXISTS `c_coupon_num`;
CREATE TABLE IF NOT EXISTS `c_coupon_num` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(150) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT '' COMMENT '优惠券标题',
  `coupon_num` varchar(50) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '优惠券编号',
  `img` varchar(150) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '优惠券图片',
  `coupon_typeid` int(11) DEFAULT '0' COMMENT '优惠券类别',
  `money` int(11) DEFAULT '0' COMMENT '优惠金额',
  `content` varchar(200) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '优惠详细介绍',
  `total_num` int(11) DEFAULT '0' COMMENT '优惠券总数量',
  `start_time` datetime DEFAULT NULL COMMENT '优惠券开始使用时间',
  `end_time` datetime DEFAULT NULL COMMENT '优惠券截至使用时间',
  `min_consume` int(11) DEFAULT '0' COMMENT '最低消费',
  `status` tinyint(1) DEFAULT '0' COMMENT '是否启用',
  `receive_total` int(11) DEFAULT '0' COMMENT '领取数量',
  `order_num` int(11) DEFAULT '0' COMMENT '排序数字',
  `create_time` datetime DEFAULT NULL COMMENT '添加优惠券时间',
  `delete_time` datetime DEFAULT NULL COMMENT '软删除',
  `update_time` datetime DEFAULT NULL,
  `each_max_total` int(11) unsigned DEFAULT '1' COMMENT '0代表不限制，1代表1张',
  `brandid` int(11) DEFAULT '0' COMMENT '品牌或门店id',
  `create_user` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '添加的用户名称',
  `discount_type` tinyint(1) NOT NULL DEFAULT '0',
  `expire_time` int(11) DEFAULT '0',
  `is_show` tinyint(2) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='优惠券批次表';

-- 正在导出表  sx_vip.c_coupon_num 的数据：~0 rows (大约)
DELETE FROM `c_coupon_num`;
/*!40000 ALTER TABLE `c_coupon_num` DISABLE KEYS */;
/*!40000 ALTER TABLE `c_coupon_num` ENABLE KEYS */;

-- 导出  表 sx_vip.c_coupon_type 结构
DROP TABLE IF EXISTS `c_coupon_type`;
CREATE TABLE IF NOT EXISTS `c_coupon_type` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '用户id',
  `create_time` datetime DEFAULT NULL COMMENT '获取优惠券时间',
  `delete_time` datetime DEFAULT NULL COMMENT '是否删除',
  `update_time` datetime DEFAULT NULL,
  `brandid` int(11) DEFAULT '0' COMMENT '品牌或门店id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='优惠券表 ';

-- 正在导出表  sx_vip.c_coupon_type 的数据：~0 rows (大约)
DELETE FROM `c_coupon_type`;
/*!40000 ALTER TABLE `c_coupon_type` DISABLE KEYS */;
/*!40000 ALTER TABLE `c_coupon_type` ENABLE KEYS */;

-- 导出  表 sx_vip.c_excel_import 结构
DROP TABLE IF EXISTS `c_excel_import`;
CREATE TABLE IF NOT EXISTS `c_excel_import` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `file_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `file_url` varchar(300) COLLATE utf8_unicode_ci DEFAULT '',
  `fail_file_url` varchar(300) COLLATE utf8_unicode_ci DEFAULT '',
  `addtime` datetime DEFAULT NULL,
  `status` tinyint(1) DEFAULT '0',
  `all_number` int(11) DEFAULT '0',
  `import_number` int(11) DEFAULT '0',
  `fail_number` int(11) DEFAULT '0',
  `brandid` int(11) DEFAULT '0',
  `staff_id` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `staff_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.c_excel_import 的数据：~0 rows (大约)
DELETE FROM `c_excel_import`;
/*!40000 ALTER TABLE `c_excel_import` DISABLE KEYS */;
/*!40000 ALTER TABLE `c_excel_import` ENABLE KEYS */;

-- 导出  表 sx_vip.c_kf 结构
DROP TABLE IF EXISTS `c_kf`;
CREATE TABLE IF NOT EXISTS `c_kf` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `url` varchar(250) COLLATE utf8_unicode_ci DEFAULT '',
  `brandid` int(11) DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.c_kf 的数据：~1 rows (大约)
DELETE FROM `c_kf`;
/*!40000 ALTER TABLE `c_kf` DISABLE KEYS */;
INSERT INTO `c_kf` (`id`, `url`, `brandid`, `create_time`) VALUES
	(1, 'http://uclient.yunque360.com/frame.html?company_id=c9mdid5113go&yq_src=weixin', 2, '2018-04-11 17:15:43');
/*!40000 ALTER TABLE `c_kf` ENABLE KEYS */;

-- 导出  表 sx_vip.c_vip_save 结构
DROP TABLE IF EXISTS `c_vip_save`;
CREATE TABLE IF NOT EXISTS `c_vip_save` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `url` varchar(250) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `data` text COLLATE utf8_unicode_ci,
  `create_time` datetime DEFAULT NULL,
  `error_count` int(11) NOT NULL DEFAULT '4',
  `call_time` varchar(11) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.c_vip_save 的数据：~0 rows (大约)
DELETE FROM `c_vip_save`;
/*!40000 ALTER TABLE `c_vip_save` DISABLE KEYS */;
/*!40000 ALTER TABLE `c_vip_save` ENABLE KEYS */;

-- 导出  表 sx_vip.grade 结构
DROP TABLE IF EXISTS `grade`;
CREATE TABLE IF NOT EXISTS `grade` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `grade_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '//会员等级名称',
  `create_value` int(10) DEFAULT NULL COMMENT '//当前卡的初始分值',
  `end_value` int(10) DEFAULT NULL COMMENT '//当前卡的终止分值',
  `division` int(11) DEFAULT NULL COMMENT '//当前等级所属事业部',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.grade 的数据：~0 rows (大约)
DELETE FROM `grade`;
/*!40000 ALTER TABLE `grade` DISABLE KEYS */;
/*!40000 ALTER TABLE `grade` ENABLE KEYS */;

-- 导出  表 sx_vip.group_activity 结构
DROP TABLE IF EXISTS `group_activity`;
CREATE TABLE IF NOT EXISTS `group_activity` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `activity_title` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '活动标题',
  `front_money` decimal(11,0) DEFAULT '0' COMMENT '报名定金要求',
  `starttime` datetime DEFAULT NULL COMMENT '开始时间',
  `endtime` datetime DEFAULT NULL COMMENT '结束时间',
  `wedding_price` decimal(11,0) DEFAULT NULL COMMENT '套系价格',
  `discount` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '团购折扣率',
  `list_img` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '列表页图片',
  `share_img` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '分享显示图片',
  `share_title` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '分享标题',
  `share_desc` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '分享描述',
  `permit_level` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '参与用户等级',
  `user_require` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '参与用户要求(>=多少人才能成团)',
  `brandid` int(10) DEFAULT NULL,
  `info_img` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '详情图',
  `apply_img` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '报名图',
  `couponid` int(10) DEFAULT NULL COMMENT '优惠券id',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `delete_time` datetime DEFAULT NULL COMMENT '删除时间',
  `status` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '活动状态（1发布 0不发布）',
  `ordernum` int(10) DEFAULT NULL COMMENT '排序（数字越大显示越靠前）',
  `update_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '修改时间',
  `price` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '套系原价',
  `coupon_num` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '优惠券批次（编号）',
  `share_score` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.group_activity 的数据：~0 rows (大约)
DELETE FROM `group_activity`;
/*!40000 ALTER TABLE `group_activity` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_activity` ENABLE KEYS */;

-- 导出  表 sx_vip.group_buy 结构
DROP TABLE IF EXISTS `group_buy`;
CREATE TABLE IF NOT EXISTS `group_buy` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `activity_id` int(10) DEFAULT NULL COMMENT '活动id',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `broker_id` int(10) DEFAULT NULL COMMENT '经纪人id',
  `brandid` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '事业部',
  `activity_title` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '活动标题',
  `info_img` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '详情图',
  `apply_img` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '报名图',
  `broker_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '经纪人姓名',
  `status` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '团的状态（1进行中 2结束了）',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.group_buy 的数据：~0 rows (大约)
DELETE FROM `group_buy`;
/*!40000 ALTER TABLE `group_buy` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_buy` ENABLE KEYS */;

-- 导出  表 sx_vip.group_cause 结构
DROP TABLE IF EXISTS `group_cause`;
CREATE TABLE IF NOT EXISTS `group_cause` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `cause` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '取消原因',
  `name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '姓名',
  `phone` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '手机号码',
  `groupuser_id` int(10) DEFAULT NULL COMMENT '团购成员id',
  `create_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.group_cause 的数据：~0 rows (大约)
DELETE FROM `group_cause`;
/*!40000 ALTER TABLE `group_cause` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_cause` ENABLE KEYS */;

-- 导出  表 sx_vip.group_user 结构
DROP TABLE IF EXISTS `group_user`;
CREATE TABLE IF NOT EXISTS `group_user` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `user_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户昵称',
  `join_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '参加时间',
  `front_money` int(30) DEFAULT '0' COMMENT '定金',
  `pay_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '支付时间',
  `phone` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '参与人手机号',
  `wedding_day` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '结婚日期',
  `broker_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '经纪人姓名',
  `brandid` int(10) DEFAULT NULL COMMENT '事业部id',
  `groupbuy_id` int(10) DEFAULT NULL COMMENT '团购id',
  `img` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '头像',
  `name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户姓名',
  `user_id` int(10) DEFAULT NULL COMMENT '客户id(m_users 主键id）',
  `order_no` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '订单号',
  `pay_status` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '支付状态(1 已支付 0 代付款 )',
  `status` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '拼团状态（0待成团 1已成团 2超时失败 3已取消）',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.group_user 的数据：~0 rows (大约)
DELETE FROM `group_user`;
/*!40000 ALTER TABLE `group_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_user` ENABLE KEYS */;

-- 导出  表 sx_vip.growth_log 结构
DROP TABLE IF EXISTS `growth_log`;
CREATE TABLE IF NOT EXISTS `growth_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '//成长值日志表',
  `userid` int(11) DEFAULT '0' COMMENT '//用户id',
  `graowth_num` int(11) DEFAULT '0' COMMENT '//成长值分数',
  `graowth_type` int(11) DEFAULT '0' COMMENT '//成长值类型 1每天登录2每天签到3领取任务4做任务5推荐新人6报名活动7浏览活动8是分享11分享活动12分享任务13会员等级升级',
  `graowth_tid` int(11) DEFAULT '0' COMMENT '//任务或者活动id',
  `graowth_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `iswid` int(11) DEFAULT '0',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ROW_FORMAT=COMPACT;

-- 正在导出表  sx_vip.growth_log 的数据：~0 rows (大约)
DELETE FROM `growth_log`;
/*!40000 ALTER TABLE `growth_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `growth_log` ENABLE KEYS */;

-- 导出  表 sx_vip.growth_rule 结构
DROP TABLE IF EXISTS `growth_rule`;
CREATE TABLE IF NOT EXISTS `growth_rule` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '规则id',
  `levelid` int(11) DEFAULT '0' COMMENT '级别id对应level表id',
  `detail` text COLLATE utf8_unicode_ci COMMENT 'json格式的数据，包含签到规则详细信息',
  `delete_time` datetime DEFAULT NULL COMMENT '删除',
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  `brandid` int(11) DEFAULT '0' COMMENT '品牌或门店id',
  `create_user` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '添加数据的人',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ROW_FORMAT=COMPACT COMMENT='积分规则表';

-- 正在导出表  sx_vip.growth_rule 的数据：~0 rows (大约)
DELETE FROM `growth_rule`;
/*!40000 ALTER TABLE `growth_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `growth_rule` ENABLE KEYS */;

-- 导出  表 sx_vip.img_code 结构
DROP TABLE IF EXISTS `img_code`;
CREATE TABLE IF NOT EXISTS `img_code` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '//二维码表id',
  `c_img` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '//图片地址',
  `staff_id` int(11) DEFAULT NULL COMMENT '//员工id',
  `c_tyid` int(11) DEFAULT NULL COMMENT '//二维码类型',
  `c_code` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '//二维码串码',
  `brandid` int(11) DEFAULT NULL COMMENT '//品牌id',
  `staff_name` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '//员工姓名',
  `create_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '//二维码生成时间',
  `qrcode` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '//二维码名称',
  `delete_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '//删除时间',
  `link_site` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '//链接地址',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.img_code 的数据：~0 rows (大约)
DELETE FROM `img_code`;
/*!40000 ALTER TABLE `img_code` DISABLE KEYS */;
/*!40000 ALTER TABLE `img_code` ENABLE KEYS */;

-- 导出  表 sx_vip.membereq 结构
DROP TABLE IF EXISTS `membereq`;
CREATE TABLE IF NOT EXISTS `membereq` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '//会员权益说明id',
  `eq_type` varchar(255) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '//权益名称(类型)',
  `eq_count` text CHARACTER SET utf8 COMMENT '//权益类型说明',
  `eq_card_type` varchar(255) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '//哪种会员享受',
  `eq_img` varchar(255) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '//权益图片',
  `create_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '//添加时间',
  `brandid` int(11) DEFAULT '0' COMMENT '//品牌id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.membereq 的数据：~0 rows (大约)
DELETE FROM `membereq`;
/*!40000 ALTER TABLE `membereq` DISABLE KEYS */;
/*!40000 ALTER TABLE `membereq` ENABLE KEYS */;

-- 导出  表 sx_vip.message 结构
DROP TABLE IF EXISTS `message`;
CREATE TABLE IF NOT EXISTS `message` (
  `m_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '//消息表id',
  `mes_title` varchar(150) CHARACTER SET utf8 DEFAULT NULL COMMENT '//消息标题',
  `mes_count` text CHARACTER SET utf8 COMMENT '//消息内容',
  `mes_status` tinyint(4) DEFAULT NULL COMMENT '//是否查看 1查看 0 未查看',
  `mes_type` int(11) DEFAULT NULL COMMENT '//提醒类型 1投诉',
  `mes_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '//阅读时间',
  `staff_id` int(11) DEFAULT NULL COMMENT '//员工id',
  `com_id` int(11) DEFAULT NULL COMMENT '//关联投诉建议表id',
  `brand_id` int(11) DEFAULT NULL COMMENT '//品牌id',
  `time_out` int(11) DEFAULT NULL COMMENT '//过期时间',
  PRIMARY KEY (`m_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.message 的数据：~0 rows (大约)
DELETE FROM `message`;
/*!40000 ALTER TABLE `message` DISABLE KEYS */;
/*!40000 ALTER TABLE `message` ENABLE KEYS */;

-- 导出  表 sx_vip.minute_log 结构
DROP TABLE IF EXISTS `minute_log`;
CREATE TABLE IF NOT EXISTS `minute_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '//积分日志id',
  `m_title` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '//积分消费标题',
  `m_num` int(11) DEFAULT '0' COMMENT '//积分加减值',
  `m_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '//操作时间',
  `m_executor` int(11) DEFAULT NULL COMMENT '//执行人',
  `m_type` int(11) DEFAULT NULL COMMENT '//积分类型',
  `iswid` int(11) DEFAULT '0',
  `users_phone_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.minute_log 的数据：~0 rows (大约)
DELETE FROM `minute_log`;
/*!40000 ALTER TABLE `minute_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `minute_log` ENABLE KEYS */;

-- 导出  表 sx_vip.m_admin_logs 结构
DROP TABLE IF EXISTS `m_admin_logs`;
CREATE TABLE IF NOT EXISTS `m_admin_logs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `userid` int(11) DEFAULT NULL COMMENT '用户id',
  `action_type` tinyint(1) DEFAULT NULL COMMENT '操作类型，增加1，修改2，删除3，登陆4',
  `operation_type` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '操作类别，1表示活动，2任务，3优惠券，4推荐管理',
  `operation_id` int(11) DEFAULT NULL COMMENT '操作的对象的id',
  `old_content` text COLLATE utf8_unicode_ci COMMENT '修改前的内容',
  `new_content` text COLLATE utf8_unicode_ci COMMENT '修改后的数据',
  `ip` varchar(25) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '登录ip地址',
  `create_time` datetime DEFAULT NULL COMMENT '操作时间',
  `update_time` datetime DEFAULT NULL,
  `delete_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='后台日志表';

-- 正在导出表  sx_vip.m_admin_logs 的数据：~0 rows (大约)
DELETE FROM `m_admin_logs`;
/*!40000 ALTER TABLE `m_admin_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `m_admin_logs` ENABLE KEYS */;

-- 导出  表 sx_vip.m_money_log 结构
DROP TABLE IF EXISTS `m_money_log`;
CREATE TABLE IF NOT EXISTS `m_money_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `u_number` char(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `u_money` decimal(10,2) NOT NULL DEFAULT '0.00',
  `u_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `staff_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `u_titlef` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `phone_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.m_money_log 的数据：~0 rows (大约)
DELETE FROM `m_money_log`;
/*!40000 ALTER TABLE `m_money_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `m_money_log` ENABLE KEYS */;

-- 导出  表 sx_vip.m_mp_log 结构
DROP TABLE IF EXISTS `m_mp_log`;
CREATE TABLE IF NOT EXISTS `m_mp_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `m_id` int(11) NOT NULL,
  `m_money` decimal(10,2) NOT NULL DEFAULT '0.00',
  `m_code` char(100) COLLATE utf8_unicode_ci DEFAULT '',
  `m_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `staff_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `order_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `m_title` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.m_mp_log 的数据：~0 rows (大约)
DELETE FROM `m_mp_log`;
/*!40000 ALTER TABLE `m_mp_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `m_mp_log` ENABLE KEYS */;

-- 导出  表 sx_vip.m_order 结构
DROP TABLE IF EXISTS `m_order`;
CREATE TABLE IF NOT EXISTS `m_order` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '//用户订单表',
  `order_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '//订单时间',
  `order_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '//订单编号',
  `one_money` decimal(10,0) DEFAULT '0' COMMENT '//一销金额',
  `two_money` decimal(10,0) DEFAULT '0' COMMENT '//二销金额',
  `one_detail` decimal(10,0) DEFAULT '0' COMMENT '//一销实收',
  `two_detail` decimal(10,0) DEFAULT '0' COMMENT '//二销实收金额',
  `order_userid` int(11) DEFAULT NULL COMMENT '//该订单消费人',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.m_order 的数据：~0 rows (大约)
DELETE FROM `m_order`;
/*!40000 ALTER TABLE `m_order` DISABLE KEYS */;
/*!40000 ALTER TABLE `m_order` ENABLE KEYS */;

-- 导出  表 sx_vip.m_users 结构
DROP TABLE IF EXISTS `m_users`;
CREATE TABLE IF NOT EXISTS `m_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '用户id',
  `phone` varchar(50) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '手机号',
  `username` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '用户名称',
  `password` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '密码',
  `sex` tinyint(1) DEFAULT '0' COMMENT '性别0女1男',
  `brithday` varchar(10) COLLATE utf8_unicode_ci DEFAULT '0' COMMENT '生日',
  `simg` varchar(255) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '头像',
  `merryday` int(8) DEFAULT '0' COMMENT '结婚日期',
  `openid` varchar(50) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '用户微信id',
  `ip` varchar(15) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '登录ip地址',
  `total_score` int(11) DEFAULT '0' COMMENT '总积分',
  `total_sign` int(11) DEFAULT '0' COMMENT '签到总数',
  `level` int(11) DEFAULT '1' COMMENT '用户级别',
  `growth_value` int(11) DEFAULT '0' COMMENT '成长值',
  `money` decimal(10,2) DEFAULT '0.00' COMMENT '账户余额',
  `brandid` int(10) DEFAULT '0' COMMENT '//用户所属事业部',
  `user_number` varchar(50) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '//会员卡号码',
  `status` tinyint(1) DEFAULT '1' COMMENT '是否停用0停用，1启用',
  `reg_time` datetime DEFAULT NULL COMMENT '注册时间',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '//修改时间',
  `delete_time` datetime DEFAULT NULL,
  `last_land_time` datetime DEFAULT NULL COMMENT '最后登陆的时间',
  `qq` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `email` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `weixin` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `address` varchar(300) COLLATE utf8_unicode_ci DEFAULT NULL,
  `remark` varchar(400) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='注册表';

-- 正在导出表  sx_vip.m_users 的数据：~0 rows (大约)
DELETE FROM `m_users`;
/*!40000 ALTER TABLE `m_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `m_users` ENABLE KEYS */;

-- 导出  表 sx_vip.m_users_phone 结构
DROP TABLE IF EXISTS `m_users_phone`;
CREATE TABLE IF NOT EXISTS `m_users_phone` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '用户id',
  `phone` varchar(50) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '手机号',
  `total_score` int(11) DEFAULT NULL COMMENT '积分',
  `money` decimal(10,2) DEFAULT '0.00' COMMENT '账户余额',
  `username` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '用户名称',
  `reg_time` varchar(50) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '登陆的时间',
  `total_sign` int(11) DEFAULT '0' COMMENT '签到总数',
  `userid` int(11) DEFAULT '0' COMMENT 'm_users表的id',
  `growth_value` int(11) DEFAULT '0' COMMENT '成长值',
  `brithday` varchar(50) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '生日',
  `merryday` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '结婚日期',
  `sex` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '性别0女1男',
  `bind_time` int(11) DEFAULT '0' COMMENT '绑定的时间',
  `brandid` int(11) DEFAULT '0',
  `password` varchar(80) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '密码',
  `user_number` varchar(100) CHARACTER SET utf8 DEFAULT '' COMMENT '//会员编号',
  `update_time` datetime DEFAULT NULL,
  `last_land_time` datetime DEFAULT NULL,
  `pay_password` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  `status` tinyint(1) DEFAULT '1' COMMENT '用户状态1表示正常，0表示冻结',
  `c_excel_import_id` int(11) DEFAULT '0',
  `truename` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `agent_status` tinyint(2) DEFAULT NULL,
  `agent_type` tinyint(2) DEFAULT NULL,
  `real_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `agent_time` datetime DEFAULT NULL,
  `apply_time` datetime DEFAULT NULL,
  `check_apply_user` datetime DEFAULT NULL,
  `check_apply_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `userid` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='注册表';

-- 正在导出表  sx_vip.m_users_phone 的数据：~0 rows (大约)
DELETE FROM `m_users_phone`;
/*!40000 ALTER TABLE `m_users_phone` DISABLE KEYS */;
/*!40000 ALTER TABLE `m_users_phone` ENABLE KEYS */;

-- 导出  表 sx_vip.m_withdraw 结构
DROP TABLE IF EXISTS `m_withdraw`;
CREATE TABLE IF NOT EXISTS `m_withdraw` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_phone_id` int(11) DEFAULT NULL,
  `user_true_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `user_number` char(25) COLLATE utf8_unicode_ci DEFAULT '0',
  `user_bank` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `bank_code` char(200) COLLATE utf8_unicode_ci DEFAULT '',
  `bank_status` tinyint(1) DEFAULT '1',
  `brandid` int(11) DEFAULT '0',
  `bank_time` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.m_withdraw 的数据：~0 rows (大约)
DELETE FROM `m_withdraw`;
/*!40000 ALTER TABLE `m_withdraw` DISABLE KEYS */;
/*!40000 ALTER TABLE `m_withdraw` ENABLE KEYS */;

-- 导出  表 sx_vip.m_withdraw_log 结构
DROP TABLE IF EXISTS `m_withdraw_log`;
CREATE TABLE IF NOT EXISTS `m_withdraw_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `get_money` decimal(10,2) DEFAULT '0.00',
  `get_time` datetime NOT NULL,
  `user_phone_id` int(11) DEFAULT NULL,
  `money_status` tinyint(1) DEFAULT '2',
  `staff_name` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  `exe_time` datetime NOT NULL,
  `error_state` varchar(225) COLLATE utf8_unicode_ci DEFAULT '',
  `brandid` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.m_withdraw_log 的数据：~0 rows (大约)
DELETE FROM `m_withdraw_log`;
/*!40000 ALTER TABLE `m_withdraw_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `m_withdraw_log` ENABLE KEYS */;

-- 导出  表 sx_vip.open_verify 结构
DROP TABLE IF EXISTS `open_verify`;
CREATE TABLE IF NOT EXISTS `open_verify` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '//是否开启手机验证码',
  `status` int(11) DEFAULT '1' COMMENT '// 0是关闭 1是开启',
  `type` int(11) DEFAULT NULL COMMENT '//验证码类型  1是手机2是其它',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.open_verify 的数据：~1 rows (大约)
DELETE FROM `open_verify`;
/*!40000 ALTER TABLE `open_verify` DISABLE KEYS */;
INSERT INTO `open_verify` (`id`, `status`, `type`) VALUES
	(1, 1, 0);
/*!40000 ALTER TABLE `open_verify` ENABLE KEYS */;

-- 导出  表 sx_vip.public_num 结构
DROP TABLE IF EXISTS `public_num`;
CREATE TABLE IF NOT EXISTS `public_num` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `appid` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `app_secret` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `linkcode` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '连接识别码',
  `create_user` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  `delete_time` datetime DEFAULT NULL,
  `brandid` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.public_num 的数据：~0 rows (大约)
DELETE FROM `public_num`;
/*!40000 ALTER TABLE `public_num` DISABLE KEYS */;
/*!40000 ALTER TABLE `public_num` ENABLE KEYS */;

-- 导出  表 sx_vip.recommend 结构
DROP TABLE IF EXISTS `recommend`;
CREATE TABLE IF NOT EXISTS `recommend` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `r_username` varchar(50) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '被推荐姓名',
  `r_phone` char(11) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '被推荐手机',
  `r_sex` tinyint(3) DEFAULT '1' COMMENT '//推荐人性别 1男2女',
  `userid` int(11) DEFAULT '0' COMMENT '推荐人的userid',
  `create_time` datetime DEFAULT NULL COMMENT '推荐时间',
  `status` tinyint(1) DEFAULT '3' COMMENT '状态  //3是待处理 2 是审核通过 1是未通过',
  `check_user` varchar(30) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '审核人',
  `check_msg` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '审核说明',
  `update_time` datetime DEFAULT NULL COMMENT '审核时间',
  `recom_num` int(11) DEFAULT '0' COMMENT '//推荐积分',
  `delete_time` datetime DEFAULT NULL,
  `brandid` int(11) DEFAULT '0' COMMENT '品牌或门店id',
  `iswid` int(11) DEFAULT '0',
  `price_type` tinyint(1) DEFAULT '1',
  `sell_counselor` varchar(150) COLLATE utf8_unicode_ci DEFAULT '',
  `remark` text COLLATE utf8_unicode_ci,
  `servant_money` decimal(10,2) DEFAULT '0.00' COMMENT '//金额',
  `secretary_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='推荐表';

-- 正在导出表  sx_vip.recommend 的数据：~0 rows (大约)
DELETE FROM `recommend`;
/*!40000 ALTER TABLE `recommend` DISABLE KEYS */;
/*!40000 ALTER TABLE `recommend` ENABLE KEYS */;

-- 导出  表 sx_vip.record 结构
DROP TABLE IF EXISTS `record`;
CREATE TABLE IF NOT EXISTS `record` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '//兑换类型表',
  `user_id` int(11) DEFAULT '0' COMMENT '//用户id',
  `card_id` int(11) DEFAULT '0' COMMENT '//卡级别',
  `create_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '//兑换日期',
  `way` int(255) DEFAULT '0' COMMENT '//兑换方式(1购买，2兑换)',
  `consume` decimal(10,0) DEFAULT NULL,
  `ditch` int(11) DEFAULT '0' COMMENT '//支付渠道(1微信，2成长值,3支付宝)',
  `orderid` varchar(80) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '//订单号',
  `status` int(255) DEFAULT '0' COMMENT '//状态(1成功2失败)',
  `status_explain` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '\\\\状态说明',
  `brandid` int(11) DEFAULT '0' COMMENT '品牌或门店id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.record 的数据：~0 rows (大约)
DELETE FROM `record`;
/*!40000 ALTER TABLE `record` DISABLE KEYS */;
/*!40000 ALTER TABLE `record` ENABLE KEYS */;

-- 导出  表 sx_vip.rule_money 结构
DROP TABLE IF EXISTS `rule_money`;
CREATE TABLE IF NOT EXISTS `rule_money` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '//提现说明',
  `money_explain` text COLLATE utf8_unicode_ci,
  `monry_time` text COLLATE utf8_unicode_ci,
  `staff_id` int(11) DEFAULT '0' COMMENT '//员工id',
  `brand_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.rule_money 的数据：~0 rows (大约)
DELETE FROM `rule_money`;
/*!40000 ALTER TABLE `rule_money` DISABLE KEYS */;
/*!40000 ALTER TABLE `rule_money` ENABLE KEYS */;

-- 导出  表 sx_vip.secretary 结构
DROP TABLE IF EXISTS `secretary`;
CREATE TABLE IF NOT EXISTS `secretary` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `phone` varchar(11) COLLATE utf8_unicode_ci DEFAULT NULL,
  `brandid` int(11) DEFAULT '0',
  `create_time` datetime NOT NULL,
  `staff_id` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `staff_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.secretary 的数据：~0 rows (大约)
DELETE FROM `secretary`;
/*!40000 ALTER TABLE `secretary` DISABLE KEYS */;
/*!40000 ALTER TABLE `secretary` ENABLE KEYS */;

-- 导出  表 sx_vip.share_detail 结构
DROP TABLE IF EXISTS `share_detail`;
CREATE TABLE IF NOT EXISTS `share_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` int(11) DEFAULT '0' COMMENT '用户id',
  `sourceid` tinyint(1) DEFAULT '0' COMMENT '1表示活动，2表示任务，3表示助力活动',
  `score` int(11) DEFAULT '0' COMMENT '积分数量',
  `shareid` int(11) NOT NULL DEFAULT '0' COMMENT '被分享id',
  `status` tinyint(1) DEFAULT '0' COMMENT '1成功0失败',
  `share_url` varchar(200) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '分享的url地址',
  `ip` varchar(20) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '用户ip',
  `create_time` datetime DEFAULT NULL COMMENT '分享时间',
  `delete_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  `brandid` int(11) DEFAULT '0' COMMENT '品牌或门店id',
  `iswid` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='分享积分记录表';

-- 正在导出表  sx_vip.share_detail 的数据：~0 rows (大约)
DELETE FROM `share_detail`;
/*!40000 ALTER TABLE `share_detail` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_detail` ENABLE KEYS */;

-- 导出  表 sx_vip.share_setup 结构
DROP TABLE IF EXISTS `share_setup`;
CREATE TABLE IF NOT EXISTS `share_setup` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `adduserid` int(11) DEFAULT '0' COMMENT '用户id',
  `addusername` varchar(100) COLLATE utf8_unicode_ci DEFAULT '0' COMMENT '1表示活动，2表示任务',
  `title` int(11) DEFAULT '0' COMMENT '积分数量',
  `content` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0' COMMENT '被分享id',
  `keywords` varchar(150) COLLATE utf8_unicode_ci DEFAULT '0' COMMENT '1成功0失败',
  `share_img` varchar(200) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '分享的时的图片',
  `brandid` int(11) DEFAULT '0' COMMENT '品牌id',
  `create_time` datetime DEFAULT NULL COMMENT '分享时间',
  `delete_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='分享积分记录表';

-- 正在导出表  sx_vip.share_setup 的数据：~0 rows (大约)
DELETE FROM `share_setup`;
/*!40000 ALTER TABLE `share_setup` DISABLE KEYS */;
/*!40000 ALTER TABLE `share_setup` ENABLE KEYS */;

-- 导出  表 sx_vip.sign 结构
DROP TABLE IF EXISTS `sign`;
CREATE TABLE IF NOT EXISTS `sign` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '//签到展示id',
  `userid` int(11) DEFAULT NULL COMMENT '//用户id',
  `num` int(11) DEFAULT NULL COMMENT '//所得积分',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.sign 的数据：~0 rows (大约)
DELETE FROM `sign`;
/*!40000 ALTER TABLE `sign` DISABLE KEYS */;
/*!40000 ALTER TABLE `sign` ENABLE KEYS */;

-- 导出  表 sx_vip.sign_awa 结构
DROP TABLE IF EXISTS `sign_awa`;
CREATE TABLE IF NOT EXISTS `sign_awa` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '//签到额外奖励表',
  `userid` int(11) DEFAULT '0' COMMENT '//用户id',
  `sign_day` int(11) DEFAULT '0' COMMENT '//连续天数',
  `sign_num` int(11) DEFAULT '0' COMMENT '//所得积分',
  `create_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '//领取时间',
  `sign_type` int(11) DEFAULT '2' COMMENT '//1积分2是优惠券',
  `type` tinyint(1) DEFAULT NULL COMMENT '//1是累计2是连续',
  `iswid` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.sign_awa 的数据：~0 rows (大约)
DELETE FROM `sign_awa`;
/*!40000 ALTER TABLE `sign_awa` DISABLE KEYS */;
/*!40000 ALTER TABLE `sign_awa` ENABLE KEYS */;

-- 导出  表 sx_vip.sign_continuous 结构
DROP TABLE IF EXISTS `sign_continuous`;
CREATE TABLE IF NOT EXISTS `sign_continuous` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '//连续奖励列表id',
  `sign_type` int(11) DEFAULT '0' COMMENT '//奖励类型  积分还是优惠券',
  `sign_days` int(11) DEFAULT '0' COMMENT '//连续几天',
  `sign_miun` int(11) DEFAULT '0' COMMENT '//连续奖励的分值/面额',
  `sign_grand` int(11) DEFAULT '0' COMMENT '//是签到还是累计',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.sign_continuous 的数据：~0 rows (大约)
DELETE FROM `sign_continuous`;
/*!40000 ALTER TABLE `sign_continuous` DISABLE KEYS */;
/*!40000 ALTER TABLE `sign_continuous` ENABLE KEYS */;

-- 导出  表 sx_vip.sign_detail 结构
DROP TABLE IF EXISTS `sign_detail`;
CREATE TABLE IF NOT EXISTS `sign_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '签到id',
  `userid` int(11) DEFAULT NULL COMMENT '用户id',
  `sign_time` datetime DEFAULT NULL COMMENT '签到日期',
  `sign_sum` int(11) DEFAULT NULL COMMENT '//会员连续签到次数',
  `sign_create` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '//初始时间',
  `brandid` int(11) DEFAULT '0' COMMENT '品牌或门店id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.sign_detail 的数据：~0 rows (大约)
DELETE FROM `sign_detail`;
/*!40000 ALTER TABLE `sign_detail` DISABLE KEYS */;
/*!40000 ALTER TABLE `sign_detail` ENABLE KEYS */;

-- 导出  表 sx_vip.sign_get 结构
DROP TABLE IF EXISTS `sign_get`;
CREATE TABLE IF NOT EXISTS `sign_get` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '//领取表',
  `awa_id` int(11) DEFAULT '0' COMMENT '//领取id',
  `userid` int(11) DEFAULT NULL COMMENT '//用户id',
  `type` tinyint(1) DEFAULT NULL COMMENT '//1累计2是签到',
  `iswid` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.sign_get 的数据：~0 rows (大约)
DELETE FROM `sign_get`;
/*!40000 ALTER TABLE `sign_get` DISABLE KEYS */;
/*!40000 ALTER TABLE `sign_get` ENABLE KEYS */;

-- 导出  表 sx_vip.s_menu 结构
DROP TABLE IF EXISTS `s_menu`;
CREATE TABLE IF NOT EXISTS `s_menu` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menu_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `fid` int(11) DEFAULT '0',
  `menu_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `menu_url` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `menu_icon` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `status` tinyint(1) DEFAULT '1',
  `sort` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=159 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.s_menu 的数据：~118 rows (大约)
DELETE FROM `s_menu`;
/*!40000 ALTER TABLE `s_menu` DISABLE KEYS */;
INSERT INTO `s_menu` (`id`, `menu_name`, `fid`, `menu_code`, `menu_url`, `menu_icon`, `status`, `sort`) VALUES
	(1, '首页', 0, 'menu1516108857', '/vip/index/index', 'fa-home', 1, 0),
	(2, '会员统计', 0, 'menu1516678182', '/vip/ucount/index', 'fa-database', 1, 0),
	(5, '会员管理', 0, 'menu1515911208', '/vip/users/index', 'fa-user', 1, 0),
	(6, '会员规则设置', 0, 'menu1515916924', '/vip/level/index', 'fa-suitcase', 1, 0),
	(7, '会员卡管理', 0, 'menu1515911265', '/vip/card/index', 'fa-credit-card', 1, 0),
	(8, '摄影师管理', 0, 'menu1515911356', '/vip/cameraman/index', 'fa-camera', 1, 0),
	(9, '活动管理', 0, 'menu1515911327', '/vip/activity/index', 'fa-gift', 1, 0),
	(10, '活动报名管理', 0, 'menu1515914895', '/vip/signup/index', 'fa-tags', 1, 0),
	(11, '获取报价管理', 0, 'menu1515915497', '/vip/getmoney/index', 'fa-money', 0, 0),
	(12, '优惠券管理', 0, 'menu1515911409', '/vip/coupon/index', 'fa-money', 1, 0),
	(13, '任务管理', 0, 'menu1515911526', '/vip/task/index', 'fa-tags', 1, 0),
	(14, '信息分享管理', 0, 'menu1515911536', '/vip/share/index', 'fa-share-alt', 1, 0),
	(15, '客户推荐管理', 0, 'menu1515911575', '/vip/recommend/index', 'fa-user-plus', 1, 0),
	(16, '投诉建议管理', 0, 'menu1515911593', '/vip/commend/index', 'fa-envelope-o', 1, 0),
	(27, '财务管理', 0, 'menu1517289275', '/vip/disposemoney/index', 'fa-money', 1, 0),
	(30, '会员秘书管理', 0, 'menu1517470861', '/vip/secretary/index', 'fa-user-plus', 1, 0),
	(36, '广告位管理', 0, 'menu1516009945', '/vip/advertising/index', 'fa-tags', 1, 0),
	(37, '微信相关设置', 0, 'menu1516271692', '/vip/weixinconfig/menu', 'fa-database', 1, 0),
	(38, '系统设置', 0, 'menu1515911652', '/vip/setting/menuset', 'fa-cog', 1, 0),
	(45, '添加用户级别', 3, 'menu1515979054', '/vip/level/add', '', 1, 0),
	(46, '修改用户级别', 3, 'menu1516069919', '/vip/level/edit', '', 1, 0),
	(47, '删除用户级别', 3, 'menu1516069926', '/vip/level/del', '', 1, 0),
	(49, '修改积分规则', 3, 'menu1515979203', '/vip/scorerule/edit', '', 1, 0),
	(50, '会员卡号生产规则管理', 3, 'menu1515979336', '/vip/scorerule/setcardnumrule', '', 1, 0),
	(51, '查看会员权益', 3, 'menu1515979543', '/vip/memberq/index', '', 1, 0),
	(52, '添加会员权益', 3, 'menu1515979594', '/vip/memberq/add', '', 1, 0),
	(53, '删除会员权益', 3, 'menu1515979696', '/vip/memberq/del', '', 1, 0),
	(54, '成长值规则设置', 3, 'menu1515979841', '/vip/level/setgrowthrule', '', 1, 0),
	(55, '查看会员导入记录', 5, 'menu1517477683', '/vip/users/importlist', '', 1, 0),
	(56, '下载导入源文件和导出出错的文件', 5, 'menu1517477694', '/vip/users/downexcel', '', 1, 0),
	(57, '导入会员', 5, 'menu1517477669', '/vip/users/upexcel', '', 1, 0),
	(58, '设置会员状态', 5, 'menu1517477606', '/vip/users/setstatus', '', 1, 0),
	(59, '删除会员', 5, 'menu1517477622', '/vip/users/del', '', 1, 0),
	(60, '添加会员卡', 4, 'menu1516078657', '/vip/card/add', '', 1, 0),
	(61, '修改会员卡信息', 4, 'menu1516006440', '/vip/card/edit', '', 1, 0),
	(62, '删除会员卡', 4, 'menu1516006491', '/vip/card/del', '', 1, 0),
	(63, '查看卡片出售列表', 4, 'menu1516078682', '/vip/card/detail', '', 1, 0),
	(64, '添加摄影师', 8, 'menu1517477763', '/vip/cameraman/add', '', 1, 0),
	(65, '修改摄影师信息', 8, 'menu1517477784', '/vip/cameraman/edit', '', 1, 0),
	(66, '删除摄影师信息', 8, 'menu1517477799', '/vip/cameraman/del', '', 1, 0),
	(67, '查看摄影师预约表', 8, 'menu1517477814', '/vip/cameraman/make', '', 1, 0),
	(68, '查看摄影师订单表', 8, 'menu1517477828', '/vip/cameraman/order', '', 1, 0),
	(69, '添加新活动', 9, 'menu1517477921', '/vip/activity/add', '', 1, 0),
	(70, '修改活动信息', 9, 'menu1517477938', '/vip/activity/edit', '', 1, 0),
	(71, '设置活动状态', 9, 'menu1517477953', '/vip/activity/setstatus', '', 1, 0),
	(72, '删除活动信息', 9, 'menu1517477973', '/vip/activity/del', '', 1, 0),
	(73, '查看活动推广链接', 9, 'menu1517478039', '/vip/activity/linkcenter', '', 1, 0),
	(74, '生成活动推广链接', 9, 'menu1517478061', '/vip/activity/makecode', '', 1, 0),
	(75, '更改活动报名信息状态', 10, 'menu1517478021', '/vip/signup/setstatus', '', 1, 0),
	(76, '删除活动报名信息', 10, 'menu1517478181', '/vip/signup/del', '', 1, 0),
	(77, '修改获取报价状态', 11, 'menu1517478213', '/vip/getmoney/setstatus', '', 0, 0),
	(78, '删除获取报价信息', 11, 'menu1517478235', '/vip/getmoney/del', '', 0, 0),
	(79, '新增优惠券', 12, 'menu1517478285', '/vip/coupon/addcoupon', '', 1, 0),
	(80, '修改优惠券信息', 12, 'menu1517478315', '/vip/coupon/editcoupon', '', 1, 0),
	(81, '删除优惠券', 12, 'menu1517478336', '/vip/coupon/delcoupon', '', 1, 0),
	(82, '查看优惠类型列表', 12, 'menu1517478377', '/vip/coupontype/index', '', 1, 0),
	(83, '添加优惠券类型', 12, 'menu1517484755', '/vip/coupontype/add', '', 1, 0),
	(84, '删除优惠券类型', 12, 'menu1517484819', '/vip/coupontype/del', '', 1, 0),
	(85, '查看优惠券领取详情', 12, 'menu1517484835', '/vip/coupon/receivedetail', '', 1, 0),
	(86, '更改优惠券使用状态', 12, 'menu1517484873', '/vip/coupon/setcouponstatus', '', 1, 0),
	(87, '添加新任务', 13, 'menu1517484906', '/vip/task/add', '', 1, 0),
	(88, '修改任务信息', 13, 'menu1517484936', '/vip/task/edit', '', 1, 0),
	(89, '删除任务信息', 13, 'menu1517484956', '/vip/task/del', '', 1, 0),
	(90, '查看任务领取详情', 10, 'menu1516008665', '/vip/task/taskdetail', '', 1, 0),
	(91, '查看用户做任务详情', 10, 'menu1516008751', '/vip/task/dodetail', '', 1, 0),
	(92, '设置活动状态', 10, 'menu1516008849', '/vip/task/setstatus', '', 1, 0),
	(93, '审核用户推荐信息的状态', 15, 'menu1517485001', '/vip/recommend/setstatus', '', 1, 0),
	(94, '删除转推荐信息', 15, 'menu1517485027', '/vip/recommend/del', '', 1, 0),
	(95, '查看投诉建议详情', 16, 'menu1517485057', '/vip/commend/view', '', 1, 0),
	(96, '删除投诉建议', 16, 'menu1517485088', '/vip/commend/del', '', 1, 0),
	(97, '更改投诉建议状态', 16, 'menu1517485109', '/vip/commend/setstatus', '', 1, 0),
	(98, '查看积分规则列表', 3, 'menu1516073874', '/vip/scorerule/index', '', 1, 0),
	(99, '修改会员权益', 6, 'menu1517477871', '/vip/memberq/edit', '', 1, 0),
	(100, '设置卡状态', 4, 'menu1516079786', '/vip/card/setstatus', '', 1, 0),
	(101, '查看活动推广链接浏览详情', 9, 'menu1517477992', '/vip/activity/visitdetail', '', 1, 0),
	(102, '删除活动推广链接', 9, 'menu1517478151', '/vip/activity/linkdel', '', 1, 0),
	(103, '修改优惠信息', 12, 'menu1517484785', '/vip/coupontype/edit', '', 1, 0),
	(104, '添加广告位', 36, 'menu1517485296', '/vip/advertising/add', '', 1, 0),
	(105, '修改广告位信息', 36, 'menu1516094971', '/vip/advertising/edit', '', 1, 0),
	(106, '删除广告位信息', 36, 'menu1516095023', '/vip/advertising/del', '', 1, 0),
	(108, '添加菜单功能', 38, 'menu1516096262', '/vip/setting/addmenu', '', 1, 0),
	(109, '权限设定管理', 38, 'menu1516096200', '/vip/setting/permission', '', 1, 0),
	(110, '删除菜单', 38, 'menu1516096247', '/vip/setting/delmenu', '', 1, 0),
	(114, '添加微信菜单', 37, 'menu1517485146', '/vip/weixinconfig/addmenu', '', 1, 0),
	(115, '修改微信菜单', 37, 'menu1517485174', '/vip/weixinconfig/editmenu', '', 1, 0),
	(116, '删除微信菜单', 37, 'menu1516256523', '/vip/weixinconfig/delmenu', '', 1, 0),
	(117, '查看会员系统固定菜单连接', 37, 'menu1516256919', '/vip/weixinconfig/wxlink', '', 1, 0),
	(118, '查看微信自动回复消息', 37, 'menu1516273140', '/vip/weixinconfig/relay', '', 1, 0),
	(119, '修改回复消息', 37, 'menu1516270705', '/vip/weixinconfig/editrelay', '', 1, 0),
	(120, '添加回复信息', 37, 'menu1516273109', '/vip/weixinconfig/addrelay', '', 1, 0),
	(121, '删除回复信息', 37, 'menu1516273072', '/vip/weixinconfig/delrelay', '', 1, 0),
	(122, '更新微信公众号菜单', 37, 'menu1516431872', '/vip/weixinconfig/setwxmenu', '', 1, 0),
	(123, '设置公众号号默认信息', 37, 'menu1516431923', '/vip/weixinconfig/setdefault', '', 1, 0),
	(131, '修改会员积分和等级', 6, 'menu1517477886', '/vip/users/usermessage', '', 1, 0),
	(133, '添加会员秘书', 30, 'menu1517470908', '/vip/secretary/add', '', 1, 0),
	(134, '修改会员秘书', 30, 'menu1517470944', '/vip/secretary/edit', '', 1, 0),
	(135, '删除会员秘书', 30, 'menu1517470986', '/vip/secretary/del', '', 1, 0),
	(136, '修改积分', 5, 'menu1517658966', '/vip/users/setscore', '', 1, 0),
	(137, '修改用户等级', 5, 'menu1517658996', '/vip/users/setgrowth', '', 1, 0),
	(138, '微信渠道管理', 0, 'menu1517714954', '/vip/wxextend/index', 'fa-share-alt', 1, 90),
	(139, '给会员群发短信', 5, 'menu1517801111', '/vip/users/sendmsg', '', 1, 0),
	(140, '给会员群发短信', 5, 'menu1517753835', '/vip/users/sendmsg', '', 1, 0),
	(141, '查看活动留言', 9, 'menu1517991469', '/vip/activity/activitymsg', '', 1, 0),
	(142, '修改活动留言内容', 9, 'menu1517993309', '/vip/activity/editactivitymsg', '', 1, 0),
	(143, '审核活动留言', 9, 'menu1517991576', '/vip/activity/setmsgstatus', '', 1, 0),
	(144, '删除活动留言', 9, 'menu1517991607', '/vip/activity/delactivitymsg', '', 1, 0),
	(145, '积分商城', 0, 'menu1520473452', '', '', 1, 0),
	(147, '经纪人管理', 15, 'menu1520770309', '/vip/recommend/agent', '', 1, 0),
	(148, '审核经纪人', 147, 'menu1520773491', '/vip/recommend/checkAgent', '', 1, 0),
	(150, '修改会员资料', 5, 'menu1520842088', '/vip/users/editusers', '', 1, 0),
	(151, '微信接力活动', 0, 'menu1521124397', '/vip/wxhelp/index', 'fa-user-plus', 1, 89),
	(152, '团购活动', 0, 'menu1523621095', '/vip/groupbuy/index', 'fa-gift', 1, 0),
	(153, '活动管理', 152, 'menu1523621177', '/vip/groupbuy/index', '', 0, 0),
	(154, '团购管理', 152, 'menu1523621182', '/vip/groupbuy/group_buy', '', 0, 0),
	(155, '参团人员管理', 152, 'menu1523621114', '/vip/groupbuy/group_user', '', 1, 0),
	(156, '添加活动', 152, 'menu1523621123', '/vip/groupbuy/activityadd', '', 1, 0),
	(157, '活动修改', 152, 'menu1523621135', '/vip/groupbuy/activityedit', '', 1, 0),
	(158, '活动删除', 152, 'menu1523621144', '/vip/groupbuy/activitydel', '', 1, 0);
/*!40000 ALTER TABLE `s_menu` ENABLE KEYS */;

-- 导出  表 sx_vip.s_position_menu 结构
DROP TABLE IF EXISTS `s_position_menu`;
CREATE TABLE IF NOT EXISTS `s_position_menu` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `position_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `menu_code` varchar(2000) COLLATE utf8_unicode_ci DEFAULT '',
  `menu_url` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `status` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.s_position_menu 的数据：~0 rows (大约)
DELETE FROM `s_position_menu`;
/*!40000 ALTER TABLE `s_position_menu` DISABLE KEYS */;
/*!40000 ALTER TABLE `s_position_menu` ENABLE KEYS */;

-- 导出  表 sx_vip.s_score_detail 结构
DROP TABLE IF EXISTS `s_score_detail`;
CREATE TABLE IF NOT EXISTS `s_score_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `rule_name` int(11) DEFAULT '0' COMMENT '积分规则名称取（s_score_rule里的detail字段，里的对应k值如sign_fist）',
  `userid` int(11) DEFAULT '0' COMMENT '用户id',
  `score_num` int(11) DEFAULT '0' COMMENT '积分数量',
  `create_time` datetime DEFAULT NULL COMMENT '获得时间',
  `ip` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '登录ip地址',
  `brandid` int(11) DEFAULT '0' COMMENT '品牌或门店id',
  `iswid` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='积分详情表';

-- 正在导出表  sx_vip.s_score_detail 的数据：~0 rows (大约)
DELETE FROM `s_score_detail`;
/*!40000 ALTER TABLE `s_score_detail` DISABLE KEYS */;
/*!40000 ALTER TABLE `s_score_detail` ENABLE KEYS */;

-- 导出  表 sx_vip.s_score_rule 结构
DROP TABLE IF EXISTS `s_score_rule`;
CREATE TABLE IF NOT EXISTS `s_score_rule` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '规则id',
  `levelid` int(11) DEFAULT '0' COMMENT '级别id对应level表id',
  `detail` text COLLATE utf8_unicode_ci COMMENT 'json格式的数据，包含签到规则详细信息',
  `delete_time` datetime DEFAULT NULL COMMENT '删除',
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  `brandid` int(11) DEFAULT '0' COMMENT '品牌或门店id',
  `create_user` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '添加数据的人',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='积分规则表';

-- 正在导出表  sx_vip.s_score_rule 的数据：~0 rows (大约)
DELETE FROM `s_score_rule`;
/*!40000 ALTER TABLE `s_score_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `s_score_rule` ENABLE KEYS */;

-- 导出  表 sx_vip.s_score_type 结构
DROP TABLE IF EXISTS `s_score_type`;
CREATE TABLE IF NOT EXISTS `s_score_type` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '类别id',
  `name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '类型名称',
  `unit` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '单位',
  `create_time` datetime DEFAULT NULL COMMENT '添加时间',
  `update_time` datetime DEFAULT NULL,
  `delete_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='积分类型表';

-- 正在导出表  sx_vip.s_score_type 的数据：~0 rows (大约)
DELETE FROM `s_score_type`;
/*!40000 ALTER TABLE `s_score_type` DISABLE KEYS */;
/*!40000 ALTER TABLE `s_score_type` ENABLE KEYS */;

-- 导出  表 sx_vip.s_session 结构
DROP TABLE IF EXISTS `s_session`;
CREATE TABLE IF NOT EXISTS `s_session` (
  `staff_id` int(11) NOT NULL,
  `session_id` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `ip` varchar(16) COLLATE utf8_unicode_ci NOT NULL,
  `login_type` varchar(20) COLLATE utf8_unicode_ci NOT NULL COMMENT '登录类型',
  `login_method` varchar(30) COLLATE utf8_unicode_ci NOT NULL COMMENT '登录方式',
  `logout_time` datetime DEFAULT NULL COMMENT '退出登录时间',
  `expiry` datetime NOT NULL COMMENT 'session过期时间',
  `status` tinyint(4) DEFAULT '1' COMMENT '登录状态:1:正常，2：忙碌;3:离线'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='crm session表';

-- 正在导出表  sx_vip.s_session 的数据：~0 rows (大约)
DELETE FROM `s_session`;
/*!40000 ALTER TABLE `s_session` DISABLE KEYS */;
/*!40000 ALTER TABLE `s_session` ENABLE KEYS */;

-- 导出  表 sx_vip.t_task_detail 结构
DROP TABLE IF EXISTS `t_task_detail`;
CREATE TABLE IF NOT EXISTS `t_task_detail` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` int(11) DEFAULT '0' COMMENT '用户id',
  `taskid` int(11) DEFAULT '0' COMMENT '任务列表id',
  `status` tinyint(1) DEFAULT '0' COMMENT '执行状态1成功0失败',
  `create_time` datetime DEFAULT NULL COMMENT '执行时间',
  `update_time` datetime DEFAULT NULL,
  `delete_time` datetime DEFAULT NULL,
  `brandid` int(11) DEFAULT '0' COMMENT '品牌或门店id',
  `iswid` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='任务详情记录';

-- 正在导出表  sx_vip.t_task_detail 的数据：~0 rows (大约)
DELETE FROM `t_task_detail`;
/*!40000 ALTER TABLE `t_task_detail` DISABLE KEYS */;
/*!40000 ALTER TABLE `t_task_detail` ENABLE KEYS */;

-- 导出  表 sx_vip.t_task_list 结构
DROP TABLE IF EXISTS `t_task_list`;
CREATE TABLE IF NOT EXISTS `t_task_list` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business` int(11) DEFAULT NULL COMMENT '//当前任务所属事业部',
  `title` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '任务名称',
  `typeid` tinyint(1) DEFAULT '0' COMMENT '任务类别',
  `index_img` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '首页图片',
  `scontent` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '简要说明',
  `content` longtext COLLATE utf8_unicode_ci COMMENT '详细介绍',
  `reward_score` int(11) DEFAULT '0' COMMENT '奖励积分',
  `share_score` int(11) DEFAULT '0' COMMENT '分享积分',
  `days` int(11) DEFAULT '0' COMMENT '活动周期',
  `start_time` datetime DEFAULT NULL COMMENT '开始时间',
  `end_time` datetime DEFAULT NULL COMMENT '结束日期',
  `status` tinyint(1) DEFAULT '0' COMMENT '1开启0关闭',
  `receive_total` int(11) DEFAULT '0' COMMENT '被领取总数',
  `done_total` int(11) DEFAULT '0' COMMENT '已完成总数',
  `share_total` int(11) DEFAULT '0' COMMENT '分享总数',
  `view_num` int(11) DEFAULT '0' COMMENT '查看次数',
  `order_num` int(11) DEFAULT '0' COMMENT '排序数',
  `create_time` datetime DEFAULT NULL COMMENT '任务添加的时间',
  `delete_time` datetime DEFAULT NULL COMMENT '是否删除',
  `update_time` datetime DEFAULT NULL,
  `create_user` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '//任务添加人',
  `share_img` varchar(200) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '分享时显示的图片',
  `share_title` varchar(150) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '分享的标题',
  `share_content` varchar(255) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '分享的介绍',
  `brandid` int(11) DEFAULT '0' COMMENT '品牌或门店id',
  `style_detail` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '样式记录表',
  `task_url` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '任务的外部连接',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='总任务列表';

-- 正在导出表  sx_vip.t_task_list 的数据：~0 rows (大约)
DELETE FROM `t_task_list`;
/*!40000 ALTER TABLE `t_task_list` DISABLE KEYS */;
/*!40000 ALTER TABLE `t_task_list` ENABLE KEYS */;

-- 导出  表 sx_vip.t_task_user_list 结构
DROP TABLE IF EXISTS `t_task_user_list`;
CREATE TABLE IF NOT EXISTS `t_task_user_list` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` int(11) DEFAULT '0' COMMENT '用户id',
  `taskid` int(11) DEFAULT '0' COMMENT '任务id',
  `status` tinyint(1) DEFAULT '0' COMMENT '是否完成',
  `delete_time` datetime DEFAULT NULL COMMENT '是否删除',
  `create_time` datetime DEFAULT NULL COMMENT '领取时间',
  `done_total` int(11) DEFAULT '0' COMMENT '已经完成次数',
  `update_time` datetime DEFAULT NULL,
  `t_task_integral` int(11) DEFAULT '0' COMMENT '//所得积分',
  `brandid` int(11) DEFAULT '0' COMMENT '品牌或门店id',
  `iswid` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='用户参与任务记录表';

-- 正在导出表  sx_vip.t_task_user_list 的数据：~0 rows (大约)
DELETE FROM `t_task_user_list`;
/*!40000 ALTER TABLE `t_task_user_list` DISABLE KEYS */;
/*!40000 ALTER TABLE `t_task_user_list` ENABLE KEYS */;

-- 导出  表 sx_vip.user_card 结构
DROP TABLE IF EXISTS `user_card`;
CREATE TABLE IF NOT EXISTS `user_card` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` int(11) DEFAULT '0' COMMENT '//用户id',
  `cardid` int(11) DEFAULT '0' COMMENT '//会员卡类型id',
  `card_number` varchar(80) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '//会员卡号码',
  `create_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '//会员卡创建时间',
  `update_time` datetime DEFAULT NULL,
  `delete_time` datetime DEFAULT NULL,
  `brandid` int(11) DEFAULT '0' COMMENT '品牌或门店id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.user_card 的数据：~0 rows (大约)
DELETE FROM `user_card`;
/*!40000 ALTER TABLE `user_card` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_card` ENABLE KEYS */;

-- 导出  表 sx_vip.user_commend 结构
DROP TABLE IF EXISTS `user_commend`;
CREATE TABLE IF NOT EXISTS `user_commend` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(150) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '投诉建议标题',
  `userid` int(11) DEFAULT '0' COMMENT '用户id',
  `content` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '详细说明',
  `imgs` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '建议图片',
  `status` tinyint(1) DEFAULT '0' COMMENT '0未查看，1已查看',
  `check_user` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '后台审查人员',
  `create_time` datetime DEFAULT NULL COMMENT '添加时间 ',
  `update_time` datetime DEFAULT NULL,
  `delete_time` datetime DEFAULT NULL COMMENT '是否删除',
  `typeid` tinyint(4) DEFAULT '0' COMMENT '1表示投诉，2表示建议',
  `brandid` int(11) DEFAULT '0' COMMENT '品牌或门店id',
  `iswid` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='用户建议表';

-- 正在导出表  sx_vip.user_commend 的数据：~0 rows (大约)
DELETE FROM `user_commend`;
/*!40000 ALTER TABLE `user_commend` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_commend` ENABLE KEYS */;

-- 导出  表 sx_vip.user_level 结构
DROP TABLE IF EXISTS `user_level`;
CREATE TABLE IF NOT EXISTS `user_level` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '级别名称',
  `min_value` int(11) DEFAULT '0' COMMENT '最少成长值',
  `max_value` int(11) DEFAULT '0' COMMENT '最高成长值',
  `create_time` datetime DEFAULT NULL,
  `delete_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  `brandid` int(11) DEFAULT '0' COMMENT '品牌或门店id',
  `create_user` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '添加数据的人',
  `img` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '级别图片',
  `discount` decimal(65,1) DEFAULT '10.0' COMMENT '//默认等级折扣',
  `sort` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.user_level 的数据：~3 rows (大约)
DELETE FROM `user_level`;
/*!40000 ALTER TABLE `user_level` DISABLE KEYS */;
INSERT INTO `user_level` (`id`, `name`, `min_value`, `max_value`, `create_time`, `delete_time`, `update_time`, `brandid`, `create_user`, `img`, `discount`, `sort`) VALUES
	(16, '贵宾卡', 0, 0, '2017-12-18 16:46:10', NULL, '2017-12-18 16:46:10', 2, '3', '20180419/edka1524115088.png', 0.0, 0),
	(19, '白金卡', 101, 9999, '2017-12-19 10:24:47', NULL, '2017-12-19 10:24:47', 2, '3', '20180419/bcgf1524115100.png', 0.0, 0),
	(20, '钻石卡', 501, 19999, '2017-12-19 10:24:47', NULL, '2017-12-19 10:24:47', 2, '3', '20180419/gakn1524115107.png', 0.0, 0);
/*!40000 ALTER TABLE `user_level` ENABLE KEYS */;

-- 导出  表 sx_vip.user_logs 结构
DROP TABLE IF EXISTS `user_logs`;
CREATE TABLE IF NOT EXISTS `user_logs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` int(11) DEFAULT '0' COMMENT '登陆的用户id',
  `create_time` datetime DEFAULT NULL,
  `ip` varchar(60) COLLATE utf8_unicode_ci DEFAULT '' COMMENT 'ip地址',
  `typeid` int(11) DEFAULT '0' COMMENT '类型0 代表登陆',
  `brandid` int(11) DEFAULT '0' COMMENT '品牌或门店id',
  `iswid` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.user_logs 的数据：~0 rows (大约)
DELETE FROM `user_logs`;
/*!40000 ALTER TABLE `user_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_logs` ENABLE KEYS */;

-- 导出  表 sx_vip.verify_code 结构
DROP TABLE IF EXISTS `verify_code`;
CREATE TABLE IF NOT EXISTS `verify_code` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `phone` varchar(11) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '手机号',
  `code` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '验证码',
  `craete_time` datetime DEFAULT NULL COMMENT '发送时间',
  `end_time` datetime DEFAULT NULL COMMENT '结束时间',
  `status` tinyint(1) DEFAULT NULL COMMENT '状态是否使用',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='手机验证码表';

-- 正在导出表  sx_vip.verify_code 的数据：~0 rows (大约)
DELETE FROM `verify_code`;
/*!40000 ALTER TABLE `verify_code` DISABLE KEYS */;
/*!40000 ALTER TABLE `verify_code` ENABLE KEYS */;

-- 导出  表 sx_vip.video 结构
DROP TABLE IF EXISTS `video`;
CREATE TABLE IF NOT EXISTS `video` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `brandid` int(11) DEFAULT NULL COMMENT '品牌的id',
  `name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '视频地址',
  `add_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '添加的时间',
  `create_user` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '添加的人员',
  `type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '媒体类型',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.video 的数据：~0 rows (大约)
DELETE FROM `video`;
/*!40000 ALTER TABLE `video` DISABLE KEYS */;
/*!40000 ALTER TABLE `video` ENABLE KEYS */;

-- 导出  表 sx_vip.wedding_desk 结构
DROP TABLE IF EXISTS `wedding_desk`;
CREATE TABLE IF NOT EXISTS `wedding_desk` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '婚礼座位表id',
  `desk_name` varchar(100) CHARACTER SET utf8 DEFAULT NULL COMMENT '//桌号名称',
  `desk_content` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '//当前桌子简介',
  `desk_mans` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '//坐席宾客',
  `desk_user` int(11) DEFAULT NULL COMMENT '//添加人',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.wedding_desk 的数据：~0 rows (大约)
DELETE FROM `wedding_desk`;
/*!40000 ALTER TABLE `wedding_desk` DISABLE KEYS */;
/*!40000 ALTER TABLE `wedding_desk` ENABLE KEYS */;

-- 导出  表 sx_vip.wedding_flow 结构
DROP TABLE IF EXISTS `wedding_flow`;
CREATE TABLE IF NOT EXISTS `wedding_flow` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '//婚礼流程表id',
  `this_time` time DEFAULT NULL,
  `this_work` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '//流程事项',
  `this_man` varchar(150) CHARACTER SET utf8 DEFAULT NULL COMMENT '//参与流程事项的人员',
  `this_user` int(11) DEFAULT NULL COMMENT '//当前添加人',
  `this_type` int(11) DEFAULT '0' COMMENT '//属于哪个分类下',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1337 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.wedding_flow 的数据：~25 rows (大约)
DELETE FROM `wedding_flow`;
/*!40000 ALTER TABLE `wedding_flow` DISABLE KEYS */;
INSERT INTO `wedding_flow` (`id`, `this_time`, `this_work`, `this_man`, `this_user`, `this_type`) VALUES
	(0, '06:00:00', '新郎新娘起床准备化妆,跟妆到位', '化妆师', 0, 1),
	(1, '06:10:00', '新郎发型做好,跟拍摄像到位', '摄像师', 0, 1),
	(2, '06:20:00', '婚车到位,婚车装饰到位', '司机', 0, 2),
	(3, '07:00:00', '新娘藏好新鞋,等待新郎伴郎', '新娘,伴娘', 0, 2),
	(4, '07:50:00', '所有婚车到达新娘家', '', 0, 2),
	(5, '07:05:00', '敲门,堵门,盘问,塞红包游戏', '伴娘', 0, 2),
	(6, '07:15:00', '新郎找鞋,新郎求婚并且向女方家人承诺', '新郎', 0, 2),
	(7, '07:30:00', '新娘新娘向新娘父母告别', '新郎&新娘', 0, 2),
	(8, '07:35:00', '车队出发', NULL, 0, 2),
	(9, '08:00:00', '车队到达男方家(新人新房)', NULL, 0, 2),
	(10, '08:10:00', '新郎抱新娘进门', '新郎', 0, 2),
	(11, '08:15:00', '新娘给男方父母敬茶', '新娘', 0, 2),
	(12, '08:30:00', '新郎新娘出发至酒店', NULL, 0, 2),
	(13, '08:45:00', '婚庆到位,现场布置完毕', '', 0, 2),
	(14, '08:50:00', '检查酒席安排,司仪,灯光', NULL, 0, 2),
	(15, '08:55:00', '结婚证书,婚戒准备', NULL, 0, 2),
	(16, '09:00:00', '新人入场,奏乐', '乐队', 0, 3),
	(17, '09:15:00', '婚礼仪式交换戒指', '新郎&新娘', 0, 3),
	(18, '09:30:00', '感恩父母', NULL, 0, 3),
	(19, '09:40:00', '现场婚礼游戏', NULL, 0, 3),
	(20, '11:30:00', '宾客入席', NULL, 0, 4),
	(21, '12:00:00', '酒店准备婚宴开始', '酒店', 0, 4),
	(22, '14:30:00', '新人敬酒', '新郎&新娘', 0, 4),
	(23, '16:00:00', '送宾客', NULL, 0, 4),
	(24, '16:20:00', '清点物品婚礼结束', NULL, 0, 4);
/*!40000 ALTER TABLE `wedding_flow` ENABLE KEYS */;

-- 导出  表 sx_vip.wedding_flowtype 结构
DROP TABLE IF EXISTS `wedding_flowtype`;
CREATE TABLE IF NOT EXISTS `wedding_flowtype` (
  `flow_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '//婚礼流程id',
  `flow_type` varchar(100) CHARACTER SET utf8 DEFAULT NULL COMMENT '//流程类型名称',
  `flow_user` int(11) DEFAULT NULL COMMENT '//创建人',
  `flow_status` tinyint(1) DEFAULT '1' COMMENT '//该流程状态 1是显示 2是不显示',
  PRIMARY KEY (`flow_id`)
) ENGINE=InnoDB AUTO_INCREMENT=403 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.wedding_flowtype 的数据：~4 rows (大约)
DELETE FROM `wedding_flowtype`;
/*!40000 ALTER TABLE `wedding_flowtype` DISABLE KEYS */;
INSERT INTO `wedding_flowtype` (`flow_id`, `flow_type`, `flow_user`, `flow_status`) VALUES
	(1, '新人', 0, 1),
	(2, '接亲流程', 0, 1),
	(3, '婚礼流程', 0, 1),
	(4, '婚宴流程', 0, 1);
/*!40000 ALTER TABLE `wedding_flowtype` ENABLE KEYS */;

-- 导出  表 sx_vip.wedding_lovecard 结构
DROP TABLE IF EXISTS `wedding_lovecard`;
CREATE TABLE IF NOT EXISTS `wedding_lovecard` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '//微喜帖id',
  `invitation_title` varchar(200) CHARACTER SET utf8 DEFAULT NULL COMMENT '//标题',
  `invitation_describe` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '//相册描述',
  `invitation_img` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '//封面图片',
  `invitation_music` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '//背景音乐',
  `invitation_site` varchar(200) CHARACTER SET utf8 DEFAULT NULL COMMENT '//地图地点',
  `brand_id` int(11) DEFAULT '0' COMMENT '//事业部id',
  `template_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '0' COMMENT '//模版关联id',
  `user_phone_id` int(11) DEFAULT '0' COMMENT '//添加用户id',
  `invitation_site_lat` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `invitation_site_lng` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=156 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.wedding_lovecard 的数据：~7 rows (大约)
DELETE FROM `wedding_lovecard`;
/*!40000 ALTER TABLE `wedding_lovecard` DISABLE KEYS */;
INSERT INTO `wedding_lovecard` (`id`, `invitation_title`, `invitation_describe`, `invitation_img`, `invitation_music`, `invitation_site`, `brand_id`, `template_name`, `user_phone_id`, `invitation_site_lat`, `invitation_site_lng`) VALUES
	(1, '热带雨林', '带上爱一路旅行,阳光和你.', 'public/cardtemplate/template1/imgs/view-img12.png', '/public/front/muise/徐海俏 - 南下.mp3', '上海马戏团', 0, 'template1', 0, '', ''),
	(2, '告白气球', '幸福的气球带上我的爱去寻找你', 'public/front/imgnew/inv2/love.png', '/public/front/muise/徐海俏 - 南下.mp3', '北京世纪坛', 0, 'template2', 0, '', ''),
	(3, '情书', '不要愁老之将至，你老了一定很可爱。', 'public/front/imgnew/inv3/inv3-page4-img4.jpg', '/public/front/muise/金玟岐 - 最初的梦想.mp3', NULL, 0, 'template3', 0, '', ''),
	(4, '凤凰于飞', '凤凰于飞，翙翙其羽', 'public/front/imgnew/inv5/inv5-page2-img2.jpg', '/public/front/muise/李袁杰,筱筱雨沐 - 枕边人.mp3', NULL, 0, 'template5', 0, '', ''),
	(5, '动物世界', '亲爱的宝贝，生日快乐', 'public/front/imgnew/child1/child1-page5-img4.jpg', '/public/front/muise/张悬 - 宝贝 (in a day).mp3', NULL, 0, 'childtemplate1', 0, '', ''),
	(6, 'Summer Vocation', 'Summer Vocation', 'public/front/imgnew/child2/child2-page5-img5.jpg', '/public/front/muise/张悬 - 宝贝 (in a day).mp3', NULL, 0, 'childtemplate2', 0, '', ''),
	(7, '我们结婚啦', '我们结婚啦', 'public/front/imgnew/inv4/5a5476ec972d6.jpg', '/public/front/muise/苏琛 - 最后一首情歌.mp3', NULL, 0, 'template4', 0, '', '');
/*!40000 ALTER TABLE `wedding_lovecard` ENABLE KEYS */;

-- 导出  表 sx_vip.wedding_lovedata 结构
DROP TABLE IF EXISTS `wedding_lovedata`;
CREATE TABLE IF NOT EXISTS `wedding_lovedata` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '//模版数据表',
  `wedding_lovecard_id` int(11) DEFAULT NULL COMMENT '//关联主表id',
  `wedding_data` text CHARACTER SET utf8 COMMENT '//当前页面数据',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=153 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.wedding_lovedata 的数据：~7 rows (大约)
DELETE FROM `wedding_lovedata`;
/*!40000 ALTER TABLE `wedding_lovedata` DISABLE KEYS */;
INSERT INTO `wedding_lovedata` (`id`, `wedding_lovecard_id`, `wedding_data`) VALUES
	(1, 1, '{"one_page_one_line":"\\u6731\\u5229\\u5b89&\\u738b\\u601d\\u96e8","one_page_two_line":"\\u606d\\u5019\\u60a8\\u7684\\u5149\\u4e34","two_page_one_line":"\\u5728\\u6700\\u7f8e\\u597d\\u7684\\u5e74\\u534e\\u9047\\u89c1\\u6700\\u7231\\u7684\\u4eba,\\u6c89\\u6d78\\u5728\\u5e78\\u798f\\u4e2d\\u7684\\u6211\\u4eec\\u5c06\\u4e8eXXXX\\u5e74XX\\u6708XX\\u65e5\\u4e3e\\u529e\\u5a5a\\u793c","three_page_one_line":"\\u606d\\u5019\\u60a8\\u7684\\u5149\\u4e34"}'),
	(2, 2, '{"one_page_one_line":"\\u541b\\u964c\\u7cfb","one_page_two_line":"\\u767d\\u6df1\\u6df1","one_page_three_line":"2017.09.17","two_page_one_line":"\\u5728\\u6700\\u7f8e\\u597d\\u7684\\u5e74\\u534e\\u9047\\u89c1\\u6700\\u7231\\u7684\\u4eba,\\u6c89\\u6d78\\u5728\\u5e78\\u798f\\u4e2d\\u7684\\u6211\\u4eec\\u5c06\\u4e8eXXXX\\u5e74XX\\u6708XX\\u65e5\\u4e3e\\u529e\\u5a5a\\u793c","three_page_one_line":"\\u606d\\u5019\\u60a8\\u7684\\u5149\\u4e34"}'),
	(3, 3, '{"one_page_one_line":"\\u6731\\u5229\\u5b89&\\u738b\\u601d\\u96e8","one_page_two_line":"\\u606d\\u5019\\u60a8\\u7684\\u5149\\u4e34","two_page_one_line":"\\u5728\\u6700\\u7f8e\\u597d\\u7684\\u5e74\\u534e\\u9047\\u89c1\\u6700\\u7231\\u7684\\u4eba,\\u6c89\\u6d78\\u5728\\u5e78\\u798f\\u4e2d\\u7684\\u6211\\u4eec\\u5c06\\u4e8eXXXX\\u5e74XX\\u6708XX\\u65e5\\u4e3e\\u529e\\u5a5a\\u793c","three_page_one_line":"\\u606d\\u5019\\u60a8\\u7684\\u5149\\u4e34"}'),
	(4, 4, '{"one_page_one_line":"\\u541b\\u964c\\u7cfb","one_page_two_line":"\\u767d\\u6df1\\u6df1","one_page_three_line":"2017.09.17","two_page_one_line":"\\u5728\\u6700\\u7f8e\\u597d\\u7684\\u5e74\\u534e\\u9047\\u89c1\\u6700\\u7231\\u7684\\u4eba,\\u6c89\\u6d78\\u5728\\u5e78\\u798f\\u4e2d\\u7684\\u6211\\u4eec\\u5c06\\u4e8eXXXX\\u5e74XX\\u6708XX\\u65e5\\u4e3e\\u529e\\u5a5a\\u793c","three_page_one_line":"\\u606d\\u5019\\u60a8\\u7684\\u5149\\u4e34"}'),
	(5, 5, '{"one_page_one_line":"\\u5b9d\\u8d1d","one_page_two_line":"\\u6b22\\u8fce\\u53c2\\u52a0\\u54e6~","two_page_one_line":"\\u5b9d\\u8d1d\\uff0c\\u613f\\u4f60\\u4e00\\u76f4\\u88ab\\u8fd9\\u4e2a\\u4e16\\u754c\\u6e29\\u67d4\\u4ee5\\u5f85\\uff0c\\u6c38\\u8fdc\\u5929\\u771f\\uff0c\\u6c38\\u8fdc\\u5584\\u826f\\u3002","three_page_one_line":null}'),
	(6, 6, '{"one_page_one_line":"\\u5b9d\\u8d1d","one_page_two_line":"\\u6b22\\u8fce\\u53c2\\u52a0\\u54e6~","two_page_one_line":"\\u5b9d\\u8d1d\\uff0c\\u613f\\u4f60\\u4e00\\u76f4\\u88ab\\u8fd9\\u4e2a\\u4e16\\u754c\\u6e29\\u67d4\\u4ee5\\u5f85\\uff0c\\u6c38\\u8fdc\\u5929\\u771f\\uff0c\\u6c38\\u8fdc\\u5584\\u826f\\u3002","three_page_one_line":null}'),
	(7, 7, '{"one_page_one_line":"\\u6731\\u5229\\u5b89&\\u738b\\u601d\\u96e8","one_page_two_line":"\\u606d\\u5019\\u60a8\\u7684\\u5149\\u4e34","two_page_one_line":"\\u5728\\u6700\\u7f8e\\u597d\\u7684\\u5e74\\u534e\\u9047\\u89c1\\u6700\\u7231\\u7684\\u4eba,\\u6c89\\u6d78\\u5728\\u5e78\\u798f\\u4e2d\\u7684\\u6211\\u4eec\\u5c06\\u4e8eXXXX\\u5e74XX\\u6708XX\\u65e5\\u4e3e\\u529e\\u5a5a\\u793c","three_page_one_line":"\\u606d\\u5019\\u60a8\\u7684\\u5149\\u4e34"}');
/*!40000 ALTER TABLE `wedding_lovedata` ENABLE KEYS */;

-- 导出  表 sx_vip.wedding_lovejoin 结构
DROP TABLE IF EXISTS `wedding_lovejoin`;
CREATE TABLE IF NOT EXISTS `wedding_lovejoin` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '//参加婚礼帖子id',
  `wedding_lovecard_id` int(11) NOT NULL DEFAULT '0' COMMENT '//关联主表id',
  `join_name` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '//参加姓名',
  `join_phone` varchar(100) CHARACTER SET utf8 DEFAULT NULL COMMENT '//参加者电话',
  `join_num` int(11) DEFAULT '0' COMMENT '//参与人数',
  `join_message` text CHARACTER SET utf8 COMMENT '//参与者留言',
  `join_message_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '//留言时间',
  `join_user_phone_id` int(11) DEFAULT NULL COMMENT '//关联当前用户id',
  `join_wish_status` tinyint(1) DEFAULT '2' COMMENT '//是否祝福过  1是祝福 2是未祝福',
  `join_wish_time` datetime DEFAULT NULL COMMENT '//祝福时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.wedding_lovejoin 的数据：~0 rows (大约)
DELETE FROM `wedding_lovejoin`;
/*!40000 ALTER TABLE `wedding_lovejoin` DISABLE KEYS */;
/*!40000 ALTER TABLE `wedding_lovejoin` ENABLE KEYS */;

-- 导出  表 sx_vip.wedding_lovephotos 结构
DROP TABLE IF EXISTS `wedding_lovephotos`;
CREATE TABLE IF NOT EXISTS `wedding_lovephotos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '//微喜帖照片集id',
  `wedding_lovecard_id` int(11) DEFAULT NULL COMMENT '//关联主帖子id',
  `card_img` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '//帖子单张照片',
  `this_several` tinyint(2) DEFAULT NULL COMMENT '//当前属于第几页',
  `this_seat` tinyint(1) DEFAULT NULL COMMENT '//显示位置',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1038 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.wedding_lovephotos 的数据：~49 rows (大约)
DELETE FROM `wedding_lovephotos`;
/*!40000 ALTER TABLE `wedding_lovephotos` DISABLE KEYS */;
INSERT INTO `wedding_lovephotos` (`id`, `wedding_lovecard_id`, `card_img`, `this_several`, `this_seat`) VALUES
	(1, 1, 'public/cardtemplate/template1/imgs/inv-load-img.jpg', 1, 1),
	(2, 1, 'public/cardtemplate/template1/imgs/page3-img02.jpg', 2, 1),
	(3, 1, 'public/cardtemplate/template1/imgs/page5-img.jpg', 2, 2),
	(4, 1, 'public/cardtemplate/template1/imgs/page4-img.jpg', 3, 1),
	(5, 1, 'public/cardtemplate/template1/imgs/page5-img.jpg', 4, 1),
	(6, 1, 'public/cardtemplate/template1/imgs/page9-img.jpg', 5, 1),
	(7, 2, 'public/cardtemplate/template2/imgs/inv2-page1-img.jpg', 1, 1),
	(8, 2, 'public/cardtemplate/template2/imgs/inv2-page3-img04.jpg', 2, 1),
	(9, 2, 'public/cardtemplate/template2/imgs/inv2-page3-img01.jpg', 2, 2),
	(10, 2, 'public/cardtemplate/template2/imgs/inv2-page3-img02.jpg', 2, 3),
	(11, 2, 'public/cardtemplate/template2/imgs/inv2-page3-img03.jpg', 2, 4),
	(12, 2, 'public/cardtemplate/template2/imgs/inv2-page4-img02.jpg', 3, 1),
	(13, 2, 'public/cardtemplate/template2/imgs/inv2-page4-img01.jpg', 3, 2),
	(14, 2, 'public/cardtemplate/template2/imgs/inv2-page5-img02.jpg', 4, 1),
	(15, 2, 'public/cardtemplate/template2/imgs/inv2-page5-img01.jpg', 4, 2),
	(16, 3, 'public/front/imgnew/inv3/inv3-page1-img4.jpg', 1, 1),
	(17, 3, 'public/front/imgnew/inv3/inv3-page2-img2.jpg', 2, 1),
	(18, 3, 'public/front/imgnew/inv3/inv3-page2-img5.jpg', 2, 2),
	(19, 3, 'public/front/imgnew/inv3/inv3-page3-img2.jpg', 3, 1),
	(20, 3, 'public/front/imgnew/inv3/inv3-page3-img6.jpg', 3, 2),
	(21, 3, 'public/front/imgnew/inv3/inv3-page4-img4.jpg', 4, 1),
	(22, 3, 'public/front/imgnew/inv3/inv3-page5-img4.jpg', 5, 1),
	(23, 4, 'public/front/imgnew/inv5/inv5-page2-img2.jpg', 1, 1),
	(24, 4, 'public/front/imgnew/inv5/inv5-page3-img1.jpg', 2, 1),
	(25, 4, 'public/front/imgnew/inv5/inv5-page4-img3.jpg', 3, 1),
	(26, 4, 'public/front/imgnew/inv5/inv5-page4-img4.jpg', 3, 2),
	(27, 4, 'public/front/imgnew/inv5/inv5-page5-img1.jpg', 4, 1),
	(28, 5, 'public/front/imgnew/child1/child1-page1-img3.jpg', 1, 1),
	(29, 5, 'public/front/imgnew/child1/child1-page2-img2.jpg', 2, 1),
	(30, 5, 'public/front/imgnew/child1/child1-page2-img4.jpg', 2, 2),
	(31, 5, 'public/front/imgnew/child1/child1-page3-img2.jpg', 3, 1),
	(32, 5, 'public/front/imgnew/child1/child1-page3-img4.jpg', 3, 2),
	(33, 5, 'public/front/imgnew/child1/child1-page4-img2.jpg', 4, 1),
	(34, 5, 'public/front/imgnew/child1/child1-page5-img2.jpg', 5, 1),
	(35, 5, 'public/front/imgnew/child1/child1-page5-img4.jpg', 5, 2),
	(36, 6, 'public/front/imgnew/child2/child2-page1-img7.jpg', 1, 1),
	(37, 6, 'public/front/imgnew/child2/child2-page2-img8.jpg', 2, 1),
	(38, 6, 'public/front/imgnew/child2/child2-page2-img9.jpg', 2, 2),
	(39, 6, 'public/front/imgnew/child2/child2-page3-img5.jpg', 3, 1),
	(40, 6, 'public/front/imgnew/child2/child2-page4-img7.jpg', 4, 1),
	(41, 6, 'public/front/imgnew/child2/child2-page4-img8.jpg', 4, 2),
	(42, 6, 'public/front/imgnew/child2/child2-page5-img5.jpg', 5, 1),
	(43, 7, 'public/front/imgnew/inv4/5a547451cc042.jpg', 1, 1),
	(44, 7, 'public/front/imgnew/inv4/5a5475314e997.jpg', 2, 1),
	(45, 7, 'public/front/imgnew/inv4/5a547531976dc.jpg', 2, 2),
	(46, 7, 'public/front/imgnew/inv4/5a54764cecd30.jpg', 3, 1),
	(47, 7, 'public/front/imgnew/inv4/5a5476eb50136.jpg', 4, 1),
	(48, 7, 'public/front/imgnew/inv4/5a5476ec972d6.jpg', 4, 2),
	(49, 7, 'public/front/imgnew/inv4/5a5476ec5e6da.jpg', 4, 3);
/*!40000 ALTER TABLE `wedding_lovephotos` ENABLE KEYS */;

-- 导出  表 sx_vip.wedding_money 结构
DROP TABLE IF EXISTS `wedding_money`;
CREATE TABLE IF NOT EXISTS `wedding_money` (
  `wed_project` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '//婚礼消费类型',
  `wed_name` varchar(50) CHARACTER SET utf8 DEFAULT NULL COMMENT '//消费项目',
  `wed_money` int(11) DEFAULT '0' COMMENT '//消费金额',
  `wed_status` tinyint(1) DEFAULT NULL COMMENT '//当前价格状态',
  `wed_remark` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '//备注',
  `wed_user` int(11) NOT NULL COMMENT '//当前执行人',
  `wed_per` char(10) CHARACTER SET utf8 DEFAULT NULL COMMENT '//百分比',
  `wed_show` tinyint(1) DEFAULT NULL COMMENT '//是否显示',
  `sort` tinyint(4) DEFAULT NULL COMMENT 'sort排序',
  `w_id` int(11) NOT NULL AUTO_INCREMENT,
  `wed_consume` tinyint(1) DEFAULT '1' COMMENT '//是否消费',
  PRIMARY KEY (`w_id`),
  KEY `wed_user` (`wed_user`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=3110 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.wedding_money 的数据：~13 rows (大约)
DELETE FROM `wedding_money`;
/*!40000 ALTER TABLE `wedding_money` DISABLE KEYS */;
INSERT INTO `wedding_money` (`wed_project`, `wed_name`, `wed_money`, `wed_status`, `wed_remark`, `wed_user`, `wed_per`, `wed_show`, `sort`, `w_id`, `wed_consume`) VALUES
	('婚前消费', '珠宝首饰', 0, 1, '5745', 0, '0.1', 1, 1, 1, 1),
	('婚前消费', '婚纱摄影', 0, 1, NULL, 0, '0.052', 1, 2, 2, 1),
	('婚礼消费', '请帖喜糖', 0, 1, NULL, 0, '0.03', 1, 3, 3, 1),
	('婚礼消费', '婚礼礼服', 0, 1, NULL, 0, '0.044', 1, 4, 4, 1),
	('婚礼消费', '婚礼跟妆', 0, 1, NULL, 0, '0.012', 1, 5, 5, 1),
	('婚礼消费', '婚礼摄像', 0, 1, NULL, 0, '0.018', 1, 6, 6, 1),
	('婚礼消费', '婚礼摄影', 0, 1, NULL, 0, '0.027', 1, 7, 7, 1),
	('婚礼消费', '婚礼司仪', 0, 1, NULL, 0, '0.025', 1, 8, 8, 1),
	('婚礼消费', '婚车租供', 0, 1, NULL, 0, '0.132', 1, 9, 9, 1),
	('婚礼消费', '婚礼策划', 0, 1, NULL, 0, '0.378', 1, 10, 10, 1),
	('婚礼消费', '婚礼酒店', 0, 1, NULL, 0, '0.056', 1, 11, 11, 1),
	('婚后消费', '蜜月旅行', 0, 1, NULL, 0, '0.126', 1, 12, 12, 1),
	('其他消费', '其他消费', 0, 1, NULL, 0, '0', 1, 13, 13, 1);
/*!40000 ALTER TABLE `wedding_money` ENABLE KEYS */;

-- 导出  表 sx_vip.wedding_moneytype 结构
DROP TABLE IF EXISTS `wedding_moneytype`;
CREATE TABLE IF NOT EXISTS `wedding_moneytype` (
  `wed_id` tinyint(2) unsigned NOT NULL AUTO_INCREMENT COMMENT '//结婚预算表类型id',
  `wed_type` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '//消费类型',
  `wed_st` tinyint(1) DEFAULT '1' COMMENT '//当前项目状态',
  PRIMARY KEY (`wed_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.wedding_moneytype 的数据：~4 rows (大约)
DELETE FROM `wedding_moneytype`;
/*!40000 ALTER TABLE `wedding_moneytype` DISABLE KEYS */;
INSERT INTO `wedding_moneytype` (`wed_id`, `wed_type`, `wed_st`) VALUES
	(1, '婚前消费', 1),
	(2, '婚礼消费', 1),
	(3, '婚后消费', 1),
	(4, '其他消费', 1);
/*!40000 ALTER TABLE `wedding_moneytype` ENABLE KEYS */;

-- 导出  表 sx_vip.wedding_music 结构
DROP TABLE IF EXISTS `wedding_music`;
CREATE TABLE IF NOT EXISTS `wedding_music` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `url` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.wedding_music 的数据：~30 rows (大约)
DELETE FROM `wedding_music`;
/*!40000 ALTER TABLE `wedding_music` DISABLE KEYS */;
INSERT INTO `wedding_music` (`id`, `name`, `url`) VALUES
	(1, 'Love Love Love', '/public/front/muise/lll.mp3'),
	(2, '小情歌-苏打绿', '/public/front/muise/xqg.mp3'),
	(3, 'Love Paradise-陈慧琳', '/public/front/muise/loveparadise.mp3'),
	(4, '最重要的决定-范玮琪', '/public/front/muise/zzydjd.mp3'),
	(5, 'You Are My Sunshine-张靓颖', '/public/front/muise/youaremysunshine.mp3'),
	(6, '有点甜-汪苏泷,By2', '/public/front/muise/ydt.mp3'),
	(7, '123我爱你', '/public/front/muise/123loveyou.mp3'),
	(8, '醉赤壁-林俊杰', '/public/front/muise/zcb.mp3'),
	(9, '枕边人-李袁杰,筱筱雨沐', '/public/front/muise/zbr.mp3'),
	(10, '宝贝-张悬', '/public/front/muise/baby.mp3'),
	(11, '虫儿飞（儿童）', '/public/front/muise/cef.mp3'),
	(12, '咱们结婚吧-齐晨', '/public/front/muise/zmjhb.mp3'),
	(13, '给你们-张宇', '/public/front/muise/geinimen.mp3'),
	(14, '爱的就是你-王力宏', '/public/front/muise/adjsn.mp3'),
	(15, 'Marry You-Bruno Mars', '/public/front/muise/brunomarsmarryyou.mp3'),
	(16, '梦中的婚礼（纯音乐）', '/public/front/muise/mzdhl.mp3'),
	(17, '我的眼里只有你-景岗山', '/public/front/muise/wdylzyn.mp3'),
	(18, '发现哎-林俊杰,金沙', '/public/front/muise/fxai.mp3'),
	(19, '唯一-王力宏', '/public/front/muise/weiyi.mp3'),
	(20, '让我爱你-周渝民,徐熙媛', '/public/front/muise/rwoaini.mp3'),
	(21, '小夫妻-蔡淳佳,欧得洋', '/public/front/muise/xiaofuqi.mp3'),
	(22, 'I Believe-范逸臣', '/public/front/muise/ibelieve.mp3'),
	(23, 'Only You', '/public/front/muise/onlyyou.mp3'),
	(24, 'Rumors', '/public/front/muise/rumors.mp3'),
	(25, '水晶-任贤齐,徐怀钰', '/public/front/muise/shuijing.mp3'),
	(26, 'Can\'t Stop Love', '/public/front/muise/cantstoplove.mp3'),
	(27, '嫁给我 - 民谣版', '/public/front/muise/jiageiwo.mp3'),
	(28, '最浪漫的事-邝美云', '/public/front/muise/zuilangmandeshi.mp3'),
	(29, '我愿意-王菲', '/public/front/muise/woyuanyi.mp3'),
	(30, '大城小爱-王力宏', '/public/front/muise/dachengxiaoai.mp3');
/*!40000 ALTER TABLE `wedding_music` ENABLE KEYS */;

-- 导出  表 sx_vip.wed_money 结构
DROP TABLE IF EXISTS `wed_money`;
CREATE TABLE IF NOT EXISTS `wed_money` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '//当前预算总和',
  `money_sum` int(11) DEFAULT '0' COMMENT '//预算总数',
  `money_user` int(11) DEFAULT '0' COMMENT '//设置总额的人',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.wed_money 的数据：~0 rows (大约)
DELETE FROM `wed_money`;
/*!40000 ALTER TABLE `wed_money` DISABLE KEYS */;
/*!40000 ALTER TABLE `wed_money` ENABLE KEYS */;

-- 导出  表 sx_vip.wed_phos 结构
DROP TABLE IF EXISTS `wed_phos`;
CREATE TABLE IF NOT EXISTS `wed_phos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '//相册id',
  `p_id` int(11) DEFAULT NULL COMMENT '//关联相册标题表的id',
  `p_name` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '//作品路径',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.wed_phos 的数据：~0 rows (大约)
DELETE FROM `wed_phos`;
/*!40000 ALTER TABLE `wed_phos` DISABLE KEYS */;
/*!40000 ALTER TABLE `wed_phos` ENABLE KEYS */;

-- 导出  表 sx_vip.wed_photoman 结构
DROP TABLE IF EXISTS `wed_photoman`;
CREATE TABLE IF NOT EXISTS `wed_photoman` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '//相册点赞表id',
  `p_id` int(11) DEFAULT NULL COMMENT '//关联的相册表id',
  `p_user` int(11) DEFAULT NULL COMMENT '//哪个用户赞的id',
  `p_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '//点赞时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.wed_photoman 的数据：~0 rows (大约)
DELETE FROM `wed_photoman`;
/*!40000 ALTER TABLE `wed_photoman` DISABLE KEYS */;
/*!40000 ALTER TABLE `wed_photoman` ENABLE KEYS */;

-- 导出  表 sx_vip.wed_photos 结构
DROP TABLE IF EXISTS `wed_photos`;
CREATE TABLE IF NOT EXISTS `wed_photos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '//婚礼相册id',
  `book_title` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '//相册标题',
  `book_coutent` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '//相册描述',
  `book_img` varchar(100) CHARACTER SET utf8 DEFAULT NULL COMMENT '//相册封面',
  `book_muise` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '//相册播放音乐',
  `book_time` datetime DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP COMMENT '//上传时间',
  `book_user` int(11) DEFAULT '0' COMMENT '//该相册添加人',
  `book_id` int(11) DEFAULT NULL COMMENT '//选择模版id',
  `book_sta` tinyint(1) DEFAULT '1' COMMENT '//当前模版状态',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.wed_photos 的数据：~0 rows (大约)
DELETE FROM `wed_photos`;
/*!40000 ALTER TABLE `wed_photos` DISABLE KEYS */;
/*!40000 ALTER TABLE `wed_photos` ENABLE KEYS */;

-- 导出  表 sx_vip.wed_ptem 结构
DROP TABLE IF EXISTS `wed_ptem`;
CREATE TABLE IF NOT EXISTS `wed_ptem` (
  `tem_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '//模版id',
  `tem_name` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '//模版名称',
  PRIMARY KEY (`tem_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.wed_ptem 的数据：~1 rows (大约)
DELETE FROM `wed_ptem`;
/*!40000 ALTER TABLE `wed_ptem` DISABLE KEYS */;
INSERT INTO `wed_ptem` (`tem_id`, `tem_name`) VALUES
	(1, '遇见单纯的小美好');
/*!40000 ALTER TABLE `wed_ptem` ENABLE KEYS */;

-- 导出  表 sx_vip.wx_auto_relay 结构
DROP TABLE IF EXISTS `wx_auto_relay`;
CREATE TABLE IF NOT EXISTS `wx_auto_relay` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `content` varchar(1000) COLLATE utf8_unicode_ci DEFAULT '',
  `brandid` int(11) DEFAULT '0',
  `create_time` datetime NOT NULL,
  `staff_id` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `staff_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.wx_auto_relay 的数据：~0 rows (大约)
DELETE FROM `wx_auto_relay`;
/*!40000 ALTER TABLE `wx_auto_relay` DISABLE KEYS */;
/*!40000 ALTER TABLE `wx_auto_relay` ENABLE KEYS */;

-- 导出  表 sx_vip.wx_default_info 结构
DROP TABLE IF EXISTS `wx_default_info`;
CREATE TABLE IF NOT EXISTS `wx_default_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `follow_msg` varchar(500) COLLATE utf8_unicode_ci DEFAULT '',
  `relay_msg` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  `brandid` int(11) DEFAULT '0',
  `create_time` datetime NOT NULL,
  `staff_id` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `staff_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `appid` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `appsecret` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.wx_default_info 的数据：~0 rows (大约)
DELETE FROM `wx_default_info`;
/*!40000 ALTER TABLE `wx_default_info` DISABLE KEYS */;
/*!40000 ALTER TABLE `wx_default_info` ENABLE KEYS */;

-- 导出  表 sx_vip.wx_event_log 结构
DROP TABLE IF EXISTS `wx_event_log`;
CREATE TABLE IF NOT EXISTS `wx_event_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `from_openid` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `openid` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `event_type` tinyint(1) DEFAULT '0',
  `brandid` int(11) DEFAULT '0',
  `create_time` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.wx_event_log 的数据：~0 rows (大约)
DELETE FROM `wx_event_log`;
/*!40000 ALTER TABLE `wx_event_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `wx_event_log` ENABLE KEYS */;

-- 导出  表 sx_vip.wx_extend 结构
DROP TABLE IF EXISTS `wx_extend`;
CREATE TABLE IF NOT EXISTS `wx_extend` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ticket` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  `scene` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `scaned_num` int(11) DEFAULT '0',
  `follow_num` int(11) DEFAULT '0',
  `brandid` int(11) DEFAULT '0',
  `create_time` datetime DEFAULT NULL,
  `delete_time` datetime DEFAULT NULL,
  `staff_id` int(11) DEFAULT '0',
  `staff_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.wx_extend 的数据：~0 rows (大约)
DELETE FROM `wx_extend`;
/*!40000 ALTER TABLE `wx_extend` DISABLE KEYS */;
/*!40000 ALTER TABLE `wx_extend` ENABLE KEYS */;

-- 导出  表 sx_vip.wx_extend_detail 结构
DROP TABLE IF EXISTS `wx_extend_detail`;
CREATE TABLE IF NOT EXISTS `wx_extend_detail` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `extend_id` int(11) DEFAULT '0',
  `openid` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `state` tinyint(4) DEFAULT '0',
  `scan_time` datetime DEFAULT NULL,
  `follow_time` datetime DEFAULT NULL,
  `event` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `event_key` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.wx_extend_detail 的数据：~0 rows (大约)
DELETE FROM `wx_extend_detail`;
/*!40000 ALTER TABLE `wx_extend_detail` DISABLE KEYS */;
/*!40000 ALTER TABLE `wx_extend_detail` ENABLE KEYS */;

-- 导出  表 sx_vip.wx_help 结构
DROP TABLE IF EXISTS `wx_help`;
CREATE TABLE IF NOT EXISTS `wx_help` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `help_scene` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `help_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `help_info` text COLLATE utf8_unicode_ci,
  `template_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `help_img` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `brand_id` int(11) DEFAULT '0',
  `start_time` datetime DEFAULT NULL,
  `end_time` datetime DEFAULT NULL,
  `params` text COLLATE utf8_unicode_ci,
  `status` tinyint(4) DEFAULT '1',
  `talk_code` text COLLATE utf8_unicode_ci,
  `subscribe_rule` text COLLATE utf8_unicode_ci,
  `sale_rule` text COLLATE utf8_unicode_ci,
  `share_title` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `share_content` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `root_ticket` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `test_ticket` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `award_top_image` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `award_foot_image` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `staff_name` varchar(11) COLLATE utf8_unicode_ci DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  `delete_time` datetime DEFAULT NULL,
  `share_score` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.wx_help 的数据：~0 rows (大约)
DELETE FROM `wx_help`;
/*!40000 ALTER TABLE `wx_help` DISABLE KEYS */;
/*!40000 ALTER TABLE `wx_help` ENABLE KEYS */;

-- 导出  表 sx_vip.wx_help_award 结构
DROP TABLE IF EXISTS `wx_help_award`;
CREATE TABLE IF NOT EXISTS `wx_help_award` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `help_id` int(11) NOT NULL,
  `award_type` tinyint(2) NOT NULL,
  `award_value` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `coupon_id` int(11) DEFAULT NULL,
  `rule_type` int(11) DEFAULT NULL,
  `rule_value` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `pay_amount` decimal(10,0) DEFAULT NULL,
  `stock` int(11) DEFAULT '9999999',
  `image` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `desc` text COLLATE utf8_unicode_ci,
  `create_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.wx_help_award 的数据：~0 rows (大约)
DELETE FROM `wx_help_award`;
/*!40000 ALTER TABLE `wx_help_award` DISABLE KEYS */;
/*!40000 ALTER TABLE `wx_help_award` ENABLE KEYS */;

-- 导出  表 sx_vip.wx_help_templates 结构
DROP TABLE IF EXISTS `wx_help_templates`;
CREATE TABLE IF NOT EXISTS `wx_help_templates` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `title` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `bg_image` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  `top_image` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '领奖头部图片',
  `foot_image` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '领奖成功图片',
  `psd_url` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  `params` text COLLATE utf8_unicode_ci,
  `status` tinyint(4) DEFAULT '1',
  `add_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='助力模板表';

-- 正在导出表  sx_vip.wx_help_templates 的数据：~3 rows (大约)
DELETE FROM `wx_help_templates`;
/*!40000 ALTER TABLE `wx_help_templates` DISABLE KEYS */;
INSERT INTO `wx_help_templates` (`id`, `code`, `title`, `bg_image`, `top_image`, `foot_image`, `psd_url`, `params`, `status`, `add_time`) VALUES
	(8, 'yungger', '萌宝表情包（儿童）', '/public/resource/images/6acdd1e7af65f002e251142a0c6e555a.jpg', '', '', '', '{"bg": {"scale": "1", "x": "0", "y": "0"},"avatar": {"scale": "1", "x": "50", "y": "34", "color": "#ab9898"},"qrcode": {"scale": "1", "x": "75", "y": "1164"},"is_show_avatar": "1"}', 1, '2018-03-08 19:52:31'),
	(9, 'autumn', '你的爱情，我来记录（婚纱）', '/public/resource/images/373b67c6323e9d9ef72f10a44bfdb63c.jpg', '', '', '', '{"bg": {"scale": "1", "x": "0", "y": "0"},"avatar": {"scale": "1", "x": "50", "y": "34", "color": "#ab9898"},"qrcode": {"scale": "1", "x": "75", "y": "1164"},"is_show_avatar": "1"}', 1, '2018-03-08 19:52:31'),
	(10, 'love', '有缘，相惠', '/public/resource/images/4737fdbc76c8a48640378922060afb0e.jpg', '', '', '', '{"bg": {"scale": "1", "x": "0", "y": "0"},"avatar": {"scale": "1", "x": "50", "y": "34", "color": "#ab9898"},"qrcode": {"scale": "1", "x": "75", "y": "1164"},"is_show_avatar": "1"}', 1, '2018-03-08 19:52:31');
/*!40000 ALTER TABLE `wx_help_templates` ENABLE KEYS */;

-- 导出  表 sx_vip.wx_help_user 结构
DROP TABLE IF EXISTS `wx_help_user`;
CREATE TABLE IF NOT EXISTS `wx_help_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) DEFAULT '0',
  `help_id` int(11) DEFAULT NULL,
  `nick_name` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `head_img` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  `help_num` int(11) DEFAULT '0',
  `fission_num` int(11) DEFAULT '0',
  `award_num` int(11) DEFAULT '0',
  `openid` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `phone` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `parent_nick_name` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `parent_head_img` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  `parent_ids` text COLLATE utf8_unicode_ci,
  `ticket` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `img` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `add_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.wx_help_user 的数据：~0 rows (大约)
DELETE FROM `wx_help_user`;
/*!40000 ALTER TABLE `wx_help_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `wx_help_user` ENABLE KEYS */;

-- 导出  表 sx_vip.wx_help_user_award 结构
DROP TABLE IF EXISTS `wx_help_user_award`;
CREATE TABLE IF NOT EXISTS `wx_help_user_award` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `openid` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `help_id` int(11) NOT NULL,
  `award_id` int(11) NOT NULL,
  `award_title` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `award_image` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` tinyint(4) DEFAULT NULL,
  `get_time` datetime DEFAULT NULL,
  `send_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.wx_help_user_award 的数据：~0 rows (大约)
DELETE FROM `wx_help_user_award`;
/*!40000 ALTER TABLE `wx_help_user_award` DISABLE KEYS */;
/*!40000 ALTER TABLE `wx_help_user_award` ENABLE KEYS */;

-- 导出  表 sx_vip.wx_menu 结构
DROP TABLE IF EXISTS `wx_menu`;
CREATE TABLE IF NOT EXISTS `wx_menu` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parentid` int(11) DEFAULT '0',
  `name` varchar(60) COLLATE utf8_unicode_ci DEFAULT '',
  `url` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `brandid` int(11) DEFAULT '0',
  `create_time` datetime NOT NULL,
  `staff_id` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `staff_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_vip.wx_menu 的数据：~0 rows (大约)
DELETE FROM `wx_menu`;
/*!40000 ALTER TABLE `wx_menu` DISABLE KEYS */;
/*!40000 ALTER TABLE `wx_menu` ENABLE KEYS */;

/*!40101 SET SQL_MODE=IFNULL(@OLD_SQL_MODE, '') */;
/*!40014 SET FOREIGN_KEY_CHECKS=IF(@OLD_FOREIGN_KEY_CHECKS IS NULL, 1, @OLD_FOREIGN_KEY_CHECKS) */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
