-- --------------------------------------------------------
-- 主机:                           127.0.0.1
-- 服务器版本:                        5.7.9 - MySQL Community Server (GPL)
-- 服务器OS:                        Win64
-- HeidiSQL 版本:                  10.2.0.5599
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8 */;
/*!50503 SET NAMES utf8mb4 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;


-- Dumping database structure for erds_sx_sp

-- Dumping structure for table erds_sx_sp.crm_c_customerinfo
DROP TABLE IF EXISTS `crm_c_customerinfo`;
CREATE TABLE IF NOT EXISTS `crm_c_customerinfo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `eid` int(11) DEFAULT NULL COMMENT '导入时的id',
  `c_unique` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customer_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户编号',
  `customer_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户姓名',
  `customer_sex` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户性别',
  `customer_tel` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户手机',
  `customer_wechat` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户微信',
  `customer_weibo` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户微博',
  `customer_qq` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `province_id` int(11) DEFAULT NULL COMMENT '省id',
  `province` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '所在省',
  `city_id` int(11) DEFAULT NULL,
  `city` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '所在市',
  `county_id` int(11) DEFAULT NULL,
  `county` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '县（区）',
  `customer_address` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户地址',
  `mate_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '配偶姓名',
  `mate_sex` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '配偶性别',
  `mate_tel` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '配偶电话',
  `mate_wechat` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '配偶微信',
  `mate_weibo` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '配偶微博',
  `mate_qq` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mate_address` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '配偶地址',
  `consultation_type_id` int(11) DEFAULT NULL,
  `consultation_type` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '消费类型',
  `customer_type` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户类型，1新单、2转介绍',
  `consulation_shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '意向店面编码',
  `consulation_shop` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '意向店面',
  `customer_channel_id` int(11) DEFAULT NULL,
  `customer_channel` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户渠道',
  `customer_cource_id` int(11) DEFAULT NULL,
  `customer_cource` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户来源',
  `customer_intention_id` int(11) DEFAULT NULL,
  `customer_intention` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户意向',
  `customer_orderaddress_id` int(11) DEFAULT NULL,
  `customer_orderaddress` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '接单点',
  `access_model_id` int(11) DEFAULT NULL,
  `access_model` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '获取方式',
  `customer_area_id` int(11) DEFAULT NULL,
  `customer_area` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户分区',
  `customer_region_id` int(11) DEFAULT NULL,
  `customer_region` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户地域',
  `is_intostore` tinyint(4) DEFAULT '1' COMMENT '是否进店，1未进店； 2进店进客；3进店非进客；4：邀约流失；5：进店流失',
  `is_success` tinyint(4) DEFAULT '2' COMMENT '是否成交，1 已成交，2 未成交，3已定金',
  `is_valid` tinyint(4) DEFAULT '2' COMMENT '是否有效，1 有效，2待定，3无效，录入时默认为2',
  `yx_day` datetime DEFAULT NULL COMMENT '标记有效日期',
  `is_loss` tinyint(4) DEFAULT '2' COMMENT '不再追踪，1是，2否',
  `is_next` tinyint(1) DEFAULT '2' COMMENT '是否再约：1：是；2：否',
  `next_time` datetime DEFAULT NULL COMMENT '再约时间',
  `is_send_next_msg` tinyint(1) DEFAULT '2' COMMENT '再约提醒信息是否已发送:1:是；2：否',
  `is_send_birthday_msg` tinyint(1) DEFAULT '2' COMMENT '生日提醒信息是否已发送:1:是；2：否',
  `is_send_wedd_msg` tinyint(1) DEFAULT '2' COMMENT '结婚纪念日提醒信息是否已发送:1:是；2：否',
  `op_signinfo` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客资标记',
  `op_signday` datetime DEFAULT NULL COMMENT '标记日期',
  `photo_address` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '拍照地',
  `customer_birthday` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户生日',
  `customer_idtype` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户证件类型',
  `customer_idnumber` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户证件号',
  `mate_birthday` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '配偶生日',
  `mate_idtype` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '配偶证件类型',
  `mate_idnumber` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '配偶证件号码',
  `introducer_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '介绍人姓名',
  `introducer_ordernum` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '介绍人单号',
  `introducer_tel` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '介绍人手机',
  `wedding_date` datetime DEFAULT NULL COMMENT '结婚日期',
  `dj_staff` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '登记员工',
  `dj_staff_id` int(11) DEFAULT NULL COMMENT '登记员工id',
  `dj_staff_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '登记员工编号',
  `dj_day` datetime DEFAULT NULL COMMENT '登记日期',
  `fp_staff_id` int(11) DEFAULT NULL COMMENT '分配人员id',
  `fp_staff` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '分配人员',
  `fp_staff_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '分配人员编号',
  `fp_day` datetime DEFAULT NULL COMMENT '分配日期',
  `is_fp` tinyint(4) DEFAULT '2' COMMENT '是否分配，1已分配，2未分配，3待接收,4分配失败',
  `sales_staff` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '销售人员',
  `sales_staff_id` int(11) DEFAULT NULL COMMENT '销售人员id',
  `sales_staff_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '销售人员编号',
  `jr_day` datetime DEFAULT NULL COMMENT '接入日期',
  `yjd_day` datetime DEFAULT NULL COMMENT '预约进店日期',
  `syjd_day` datetime DEFAULT NULL COMMENT '实际进店日期',
  `yp_day` datetime DEFAULT NULL COMMENT '预拍日期',
  `order_day` datetime DEFAULT NULL COMMENT '成交订单日期',
  `totalpay_money` decimal(16,4) DEFAULT NULL,
  `order_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '订单单号',
  `seles_step` int(11) DEFAULT NULL COMMENT '追踪阶段id',
  `step_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '追踪阶段名称',
  `c_star_day` datetime DEFAULT NULL COMMENT '客资追踪开始日期',
  `c_end_day` datetime DEFAULT NULL COMMENT '客资追踪结束日期',
  `last_trackday` datetime DEFAULT NULL COMMENT '最后一次追踪日期',
  `seles_error_id` int(11) DEFAULT NULL COMMENT '追踪失败原因id',
  `seles_error_reason` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '追踪失败原因',
  `customer_remark` text COLLATE utf8_unicode_ci COMMENT '客户备注',
  `photo_day` datetime DEFAULT NULL COMMENT '实际拍照日期',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `brandclass` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '所属品牌（事业部）',
  `is_status` int(11) DEFAULT '1',
  `sign_id` int(11) DEFAULT NULL,
  `sign_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '客资标记',
  `tel_visit_num` int(11) DEFAULT '0',
  `loss_cause` text COLLATE utf8_unicode_ci COMMENT '不再追踪原因',
  `create_time` datetime DEFAULT NULL,
  `add_shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `add_shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tel_staff_id` int(11) DEFAULT NULL,
  `tel_staff` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tel_time` datetime DEFAULT NULL,
  `is_first_tel` tinyint(2) DEFAULT NULL,
  `channel_plan_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customer_key` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `intostore_note` text COLLATE utf8_unicode_ci,
  `ready_baby_day` datetime DEFAULT NULL,
  `baby_birthday` datetime DEFAULT NULL,
  `baby_address` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `marry_day` datetime DEFAULT NULL,
  `fp_time_out` int(10) DEFAULT NULL,
  `img_record` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  `track_record` text COLLATE utf8_unicode_ci,
  `budget` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fact_money` decimal(16,4) DEFAULT NULL,
  `tel_belong` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tel_operator` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tel_area_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `brandclass_id` int(11) DEFAULT NULL,
  `reception_id` int(11) DEFAULT NULL,
  `reception_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `is_first_wechat` tinyint(2) DEFAULT NULL,
  `wechat_staff_id` int(11) DEFAULT NULL,
  `wechat_staff` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `wechat_time` datetime DEFAULT NULL,
  `c_from` tinyint(2) NOT NULL DEFAULT '1',
  `order_start_time` datetime DEFAULT NULL,
  `order_type` tinyint(4) DEFAULT '0' COMMENT '1：线上；2：线下',
  `is_send_yjd_msg` tinyint(1) DEFAULT '2' COMMENT '是否已发预进店信息：1：是；2：否',
  `is_send_syjd_msg` tinyint(1) DEFAULT '2' COMMENT '是否已发进店信息：1：是；2：否',
  `sign_time` datetime DEFAULT NULL COMMENT '客资标记时间',
  `loss_day` datetime DEFAULT NULL COMMENT '不再追踪时间',
  `op_signinfo_id` int(11) DEFAULT '0',
  `is_act` int(2) DEFAULT '1',
  `yjd_action_day` datetime DEFAULT NULL,
  `reject_reason` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `reject_remark` text COLLATE utf8_unicode_ci,
  `loss_remark` text COLLATE utf8_unicode_ci COMMENT '不再追踪备注',
  `update_time` datetime DEFAULT NULL,
  `del_time` datetime DEFAULT NULL,
  `unvalid_id` int(11) DEFAULT '0',
  `unvalid_reason` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `erp_loss` tinyint(2) NOT NULL DEFAULT '1',
  `erp_loss_reason` text COLLATE utf8_unicode_ci,
  `erp_loss_time` datetime DEFAULT NULL,
  `dj_department_id` int(11) DEFAULT NULL,
  `dj_department_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sales_department_id` int(11) DEFAULT NULL,
  `sales_department_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `is_examine` tinyint(4) DEFAULT '1' COMMENT '是否审核',
  `examine_reason` text COLLATE utf8_unicode_ci,
  `baby_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `baby_sex` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  `home_phone` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `email` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `introduce_staff_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `contact` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `zjs_from` tinyint(2) NOT NULL DEFAULT '0',
  `ad_page` text COLLATE utf8_unicode_ci,
  `add_friend_time` datetime DEFAULT NULL,
  `erp_wphone` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `erp_mphone` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `dj_group_id` int(11) DEFAULT NULL,
  `dj_group_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sales_group_id` int(11) DEFAULT NULL,
  `sales_group_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `c_channel_cost` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '渠道客资成本',
  `bonus` tinyint(2) DEFAULT '2' COMMENT 'A客奖金',
  `bonus_deal` tinyint(2) DEFAULT '2' COMMENT '成交奖金',
  `customer_contact` varchar(2000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `valid_new` tinyint(4) DEFAULT NULL COMMENT '是否为有效新客（0：无效；1：有效）',
  `customer_capacity` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '消费能力',
  `is_urgent` int(11) DEFAULT NULL COMMENT '是否加急，1加急，2否',
  `company_shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customer_label` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客资标签',
  `record_day` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `all_staff` (`dj_staff_id`,`fp_staff_id`,`sales_staff_id`) USING BTREE,
  KEY `customer_contact` (`customer_tel`,`customer_wechat`,`customer_qq`,`mate_tel`) USING BTREE,
  KEY `shop_code` (`shop_code`,`add_shop_code`,`brandclass_id`) USING BTREE,
  KEY `status` (`is_intostore`,`is_success`,`is_valid`,`is_loss`,`is_fp`,`is_status`,`c_from`,`order_type`) USING BTREE,
  KEY `all_time` (`dj_day`,`fp_day`,`jr_day`,`yjd_day`,`syjd_day`,`yp_day`,`order_day`,`c_star_day`,`c_end_day`,`create_time`,`order_start_time`,`sign_time`) USING BTREE,
  KEY `reception_id` (`reception_id`) USING BTREE,
  KEY `sales_staff_id` (`sales_staff_id`) USING BTREE,
  KEY `customer_type` (`customer_type`) USING BTREE,
  KEY `customer_wechat` (`customer_wechat`) USING BTREE,
  KEY `order_number` (`order_number`) USING BTREE,
  KEY `syjd_day` (`syjd_day`) USING BTREE,
  KEY `c_unique` (`c_unique`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='客资信息表';

-- Dumping data for table erds_sx_sp.crm_c_customerinfo: ~0 rows (大约)
DELETE FROM `crm_c_customerinfo`;
/*!40000 ALTER TABLE `crm_c_customerinfo` DISABLE KEYS */;
/*!40000 ALTER TABLE `crm_c_customerinfo` ENABLE KEYS */;

-- Dumping structure for table erds_sx_sp.qwqw
DROP TABLE IF EXISTS `qwqw`;
CREATE TABLE IF NOT EXISTS `qwqw` (
  `abcd` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table erds_sx_sp.qwqw: ~0 rows (大约)
DELETE FROM `qwqw`;
/*!40000 ALTER TABLE `qwqw` DISABLE KEYS */;
/*!40000 ALTER TABLE `qwqw` ENABLE KEYS */;

-- Dumping structure for table erds_sx_sp.sp_result
DROP TABLE IF EXISTS `sp_result`;
CREATE TABLE IF NOT EXISTS `sp_result` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `orderId` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `isSelect` int(11) DEFAULT NULL,
  `photoinfo` text COLLATE utf8_unicode_ci,
  `recordtime` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table erds_sx_sp.sp_result: ~0 rows (大约)
DELETE FROM `sp_result`;
/*!40000 ALTER TABLE `sp_result` DISABLE KEYS */;
/*!40000 ALTER TABLE `sp_result` ENABLE KEYS */;

-- Dumping structure for table erds_sx_sp.sp_resultv5
DROP TABLE IF EXISTS `sp_resultv5`;
CREATE TABLE IF NOT EXISTS `sp_resultv5` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `orderId` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `proname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `typename` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `photoinfo` text COLLATE utf8_unicode_ci,
  `recordtime` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table erds_sx_sp.sp_resultv5: ~0 rows (大约)
DELETE FROM `sp_resultv5`;
/*!40000 ALTER TABLE `sp_resultv5` DISABLE KEYS */;
/*!40000 ALTER TABLE `sp_resultv5` ENABLE KEYS */;

-- Dumping structure for table erds_sx_sp.s_yjposition
DROP TABLE IF EXISTS `s_yjposition`;
CREATE TABLE IF NOT EXISTS `s_yjposition` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `yj_position` varchar(10) COLLATE utf8_unicode_ci DEFAULT '',
  `pay_suoshu` varchar(10) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table erds_sx_sp.s_yjposition: ~0 rows (大约)
DELETE FROM `s_yjposition`;
/*!40000 ALTER TABLE `s_yjposition` DISABLE KEYS */;
/*!40000 ALTER TABLE `s_yjposition` ENABLE KEYS */;

-- Dumping structure for table erds_sx_sp.vvv
DROP TABLE IF EXISTS `vvv`;
CREATE TABLE IF NOT EXISTS `vvv` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table erds_sx_sp.vvv: ~0 rows (大约)
DELETE FROM `vvv`;
/*!40000 ALTER TABLE `vvv` DISABLE KEYS */;
/*!40000 ALTER TABLE `vvv` ENABLE KEYS */;

-- Dumping structure for table erds_sx_sp.x_allremark
DROP TABLE IF EXISTS `x_allremark`;
CREATE TABLE IF NOT EXISTS `x_allremark` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `remarks` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  `name1` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table erds_sx_sp.x_allremark: 3 rows
DELETE FROM `x_allremark`;
/*!40000 ALTER TABLE `x_allremark` DISABLE KEYS */;
INSERT INTO `x_allremark` (`id`, `remarks`, `name1`) VALUES
	(1, '美白', NULL),
	(2, '瘦脸', NULL),
	(3, '瘦身', NULL);
/*!40000 ALTER TABLE `x_allremark` ENABLE KEYS */;

-- Dumping structure for table erds_sx_sp.x_allwarn
DROP TABLE IF EXISTS `x_allwarn`;
CREATE TABLE IF NOT EXISTS `x_allwarn` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `remarks` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  `name1` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table erds_sx_sp.x_allwarn: 0 rows
DELETE FROM `x_allwarn`;
/*!40000 ALTER TABLE `x_allwarn` DISABLE KEYS */;
/*!40000 ALTER TABLE `x_allwarn` ENABLE KEYS */;

-- Dumping structure for table erds_sx_sp.x_consume
DROP TABLE IF EXISTS `x_consume`;
CREATE TABLE IF NOT EXISTS `x_consume` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `customernum` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `orderid` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `photonum` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `consumeitem` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `Size` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `amount` int(11) DEFAULT NULL,
  `itemnum` int(11) DEFAULT NULL,
  `type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `imagegroup` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `optime` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=723 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='选片产品';

-- Dumping data for table erds_sx_sp.x_consume: ~507 rows (大约)
DELETE FROM `x_consume`;
/*!40000 ALTER TABLE `x_consume` DISABLE KEYS */;
INSERT INTO `x_consume` (`id`, `customernum`, `orderid`, `photonum`, `consumeitem`, `Size`, `amount`, `itemnum`, `type`, `imagegroup`, `optime`) VALUES
	(2, '63190', 'HK-JW230516001', 'y1_2055630', '10寸实木摆台', '', 1, 1, '1', '', NULL),
	(9, '63190', 'HK-JW230516001', 'y1_2056256', '方8寸单面水晶相册', '', 1, 3, '1', '', NULL),
	(10, '63190', 'HK-JW230516001', 'y1_2056255', '方8寸单面水晶相册', '', 1, 3, '1', '', NULL),
	(11, '63190', 'HK-JW230516001', 'y1_2055816', '方8寸单面水晶相册', '', 1, 3, '1', '', NULL),
	(12, '63190', 'HK-JW230516001', 'y1_2057461', '方8寸单面水晶相册', '', 1, 3, '1', '', NULL),
	(13, '63190', 'HK-JW230516001', 'y1_2056463', '方8寸单面水晶相册', '', 1, 3, '1', '', NULL),
	(16, '63191', 'HK-SY230516001', 'y1_82e25daa47b82744a82617d7ef51588', '安语方10寸相册', '', 1, 2, '1', '', NULL),
	(17, '63191', 'HK-SY230516001', 'y1_a31373157136283ee5d1dabf6b7febd', '安语方10寸相册', '', 1, 2, '1', '', NULL),
	(18, '63191', 'HK-SY230516001', 'y1_d3c772c636c85fad3d9b80ee2c3f560', '安语方10寸相册', '', 1, 2, '1', '', NULL),
	(19, '63191', 'HK-SY230516001', 'y1_31f5b39155ec7dcdeaddfb9d7e99bf8', '安语方10寸相册', '', 1, 2, '1', '', NULL),
	(20, '63191', 'HK-SY230516001', 'y1_178d7144eed0cc079ac0894045d1fb8', '安语方10寸相册', '', 1, 2, '1', '', NULL),
	(21, '63191', 'HK-SY230516001', 'y1_7e1e8cd0e67960abe2b7c362421d94b', '安语方10寸相册', '', 1, 2, '1', '', NULL),
	(22, '63191', 'HK-SY230516001', 'y1_42aad5a26396db80e3234fbe20365c7', '安语方10寸相册', '', 1, 2, '1', '', NULL),
	(23, '63191', 'HK-SY230516001', 'y1_04795e0fa7a4808dce9458c32ce190e', '10寸圆角高亮水晶摆台', '', 1, 3, '1', '', NULL),
	(24, '63191', 'HK-SY230516001', 'y1_87e8ed5620f237f167e88f732b2f4e2', '24寸贝恩简约框（50X60））', '', 1, 4, '1', '', NULL),
	(25, '63191', 'HK-SY230516001', 'y1_f83644474782e967906c0bb9916811b', '40X40米色九宫格', '', 1, 5, '1', '', NULL),
	(26, '63191', 'HK-SY230516001', 'y1_87e8ed5620f237f167e88f732b2f4e2', '40X40米色九宫格', '', 1, 5, '1', '', NULL),
	(27, '63191', 'HK-SY230516001', 'y1_9fbaaf1ebce9ec984c67bff53e5209d', '40X40米色九宫格', '', 1, 5, '1', '', NULL),
	(28, '63191', 'HK-SY230516001', 'y1_a1cae855645b37feb8508c7d27fed4e', '旗舰店8X8环保三层软皮相册（红、咖）', '', 1, 6, '1', '', NULL),
	(29, '63191', 'HK-SY230516001', 'y1_92a9e5cec31f67de6d8132c4a2306ca', '旗舰店8X8环保三层软皮相册（红、咖）', '', 1, 6, '1', '', NULL),
	(30, '63191', 'HK-SY230516001', 'y1_bd34f332bcc4a63081316a0570bf436', '旗舰店8X8环保三层软皮相册（红、咖）', '', 1, 6, '1', '', NULL),
	(31, '63191', 'HK-SY230516001', 'y1_bbdd95dc0a9de99fa6c276a786e6df1', '旗舰店8X8环保三层软皮相册（红、咖）', '', 1, 6, '1', '', NULL),
	(32, '63191', 'HK-SY230516001', 'y1_95357d0d2489f550f8498ea47a8a7ec', '旗舰店8X8环保三层软皮相册（红、咖）', '', 1, 6, '1', '', NULL),
	(33, '63191', 'HK-SY230516001', 'y1_a57321508ccf8fbbf5b0aec47622552', '旗舰店8X8环保三层软皮相册（红、咖）', '', 1, 6, '1', '', NULL),
	(34, '63191', 'HK-SY230516001', 'y1_4dd8e1d653b70a7a7ea37abc6d7448b', '旗舰店8X8环保三层软皮相册（红、咖）', '', 1, 6, '1', '', NULL),
	(60, '63201', 'HK-JW230518001', 'y1_2056873', '40寸V14框', '', 1, 1, '1', '', NULL),
	(61, '63201', 'HK-JW230518001', 'y1_2056256', '40寸V14框', '', 1, 1, '1', '', NULL),
	(62, '63201', 'HK-JW230518001', 'y1_2055816', '40寸V14框', '', 1, 1, '1', '', NULL),
	(63, '63201', 'HK-JW230518001', 'y1_2056601', '40寸V14框', '', 1, 1, '1', '', NULL),
	(64, '63201', 'HK-JW230518001', 'y1_2056360', '40寸V14框', '', 1, 1, '1', '', NULL),
	(65, '63201', 'HK-JW230518001', 'y1_2057461', '40寸V14框', '', 1, 1, '1', '', NULL),
	(66, '63201', 'HK-JW230518001', 'y1_2056255', '40寸V14框', '', 1, 1, '1', '', NULL),
	(67, '63201', 'HK-JW230518001', 'y1_2055628', '40寸V14框', '', 1, 1, '1', '', NULL),
	(68, '63201', 'HK-JW230518001', 'y1_2056463', '40寸V14框', '', 1, 1, '1', '', NULL),
	(69, '63201', 'HK-JW230518001', 'y1_2056730', '40寸V14框', '', 1, 1, '1', '', NULL),
	(70, '63201', 'HK-JW230518001', 'y1_2056797', '40寸V14框', '', 1, 1, '1', '', NULL),
	(71, '63201', 'HK-JW230518001', 'y1_2057259', '40寸V14框', '', 1, 1, '1', '', NULL),
	(72, '63201', 'HK-JW230518001', 'y1_2056787', '40寸V14框', '', 1, 1, '1', '', NULL),
	(73, '63201', 'HK-JW230518001', 'y1_2056133', '40寸V14框', '', 1, 1, '1', '', NULL),
	(74, '63201', 'HK-JW230518001', 'y1_2055977', '40寸V14框', '', 1, 1, '1', '', NULL),
	(75, '63201', 'HK-JW230518001', 'y1_2055865', '40寸V14框', '', 1, 1, '1', '', NULL),
	(76, '63201', 'HK-JW230518001', 'y1_2055835', '40寸V14框', '', 1, 1, '1', '', NULL),
	(77, '63201', 'HK-JW230518001', 'y1_2055826', '40寸V14框', '', 1, 1, '1', '', NULL),
	(78, '63201', 'HK-JW230518001', 'y1_2055959', '40寸V14框', '', 1, 1, '1', '', NULL),
	(79, '63201', 'HK-JW230518001', 'y1_2055625', '40寸V14框', '', 1, 1, '1', '', NULL),
	(80, '63201', 'HK-JW230518001', 'y1_2057001', '40寸V14框', '', 1, 1, '1', '', NULL),
	(81, '63201', 'HK-JW230518001', 'y1_2055630', '40寸V14框', '', 1, 1, '1', '', NULL),
	(82, '63201', 'HK-JW230518001', 'y1_2057193', '40寸V14框', '', 1, 1, '1', '', NULL),
	(91, '63201', 'HK-JW230518001', 'y1_2055625', '小企鹅', '', 1, 3, '1', '', NULL),
	(92, '63201', 'HK-JW230518001', 'y1_2055628', '小企鹅', '', 1, 3, '1', '', NULL),
	(93, '63201', 'HK-JW230518001', 'y1_2055628', '宝宝成长卡', '', 1, 4, '1', '', NULL),
	(94, '63201', 'HK-JW230518001', 'y1_2055630', '宝宝成长卡', '', 1, 4, '1', '', NULL),
	(95, '63201', 'HK-JW230518001', 'y1_2055816', '宝宝成长卡', '', 1, 4, '1', '', NULL),
	(96, '64061', 'HK-JW230521002', 's1_P004', '10X10倾听册', '', 1, 1, '1', '', NULL),
	(97, '64061', 'HK-JW230521002', 's1_P005', '10X10倾听册', '', 1, 1, '1', '', NULL),
	(98, '64061', 'HK-JW230521002', 's1_P006', '10X10倾听册', '', 1, 1, '1', '', NULL),
	(99, '64061', 'HK-JW230521002', 's1_P007', '10X10倾听册', '', 1, 1, '1', '', NULL),
	(100, '64061', 'HK-JW230521002', 's1_P008', '10X10倾听册', '', 1, 1, '1', '', NULL),
	(101, '64061', 'HK-JW230521002', 's1_P009', '10X10倾听册', '', 1, 1, '1', '', NULL),
	(102, '64061', 'HK-JW230521002', 's1_P010', '10X10倾听册', '', 1, 1, '1', '', NULL),
	(103, '64061', 'HK-JW230521002', 's1_P011', '10X10倾听册', '', 1, 1, '1', '', NULL),
	(104, '64061', 'HK-JW230521002', 's1_P012', '10X10倾听册', '', 1, 1, '1', '', NULL),
	(105, '64061', 'HK-JW230521002', 's1_P013', '10X10倾听册', '', 1, 1, '1', '', NULL),
	(106, '64061', 'HK-JW230521002', 's1_P014', '10X10倾听册', '', 1, 1, '1', '', NULL),
	(107, '64061', 'HK-JW230521002', 's1_P015', '10X10倾听册', '', 1, 1, '1', '', NULL),
	(108, '64061', 'HK-JW230521002', 's1_P016', '10X10倾听册', '', 1, 1, '1', '', NULL),
	(109, '64061', 'HK-JW230521002', 'y1_2E0A8259', '24寸倾听框', '', 1, 2, '1', '', NULL),
	(110, '64061', 'HK-JW230521002', 'y1_2E0A8264', '8寸倾听摆台', '', 1, 3, '1', '', NULL),
	(111, '64061', 'HK-JW230521002', 'y1_2E0A8173', '同底拷底', '', 1, 4, '1', '', NULL),
	(112, '64061', 'HK-JW230521002', 'y1_2E0A8175', '同底拷底', '', 1, 4, '1', '', NULL),
	(113, '64061', 'HK-JW230521002', 'y1_2E0A8179', '同底拷底', '', 1, 4, '1', '', NULL),
	(114, '64061', 'HK-JW230521002', 'y1_2E0A8191', '同底拷底', '', 1, 4, '1', '', NULL),
	(115, '64061', 'HK-JW230521002', 'y1_2E0A8192', '同底拷底', '', 1, 4, '1', '', NULL),
	(116, '64061', 'HK-JW230521002', 'y1_2E0A8196', '同底拷底', '', 1, 4, '1', '', NULL),
	(117, '64061', 'HK-JW230521002', 'y1_2E0A8200', '同底拷底', '', 1, 4, '1', '', NULL),
	(118, '64061', 'HK-JW230521002', 'y1_2E0A8206', '同底拷底', '', 1, 4, '1', '', NULL),
	(119, '64061', 'HK-JW230521002', 'y1_2E0A8211', '同底拷底', '', 1, 4, '1', '', NULL),
	(120, '64061', 'HK-JW230521002', 'y1_2E0A8217', '同底拷底', '', 1, 4, '1', '', NULL),
	(121, '64061', 'HK-JW230521002', 'y1_2E0A8220', '同底拷底', '', 1, 4, '1', '', NULL),
	(122, '64061', 'HK-JW230521002', 'y1_2E0A8223', '同底拷底', '', 1, 4, '1', '', NULL),
	(123, '64061', 'HK-JW230521002', 'y1_2E0A8227', '同底拷底', '', 1, 4, '1', '', NULL),
	(124, '64061', 'HK-JW230521002', 'y1_2E0A8232', '同底拷底', '', 1, 4, '1', '', NULL),
	(125, '64061', 'HK-JW230521002', 'y1_2E0A8235', '同底拷底', '', 1, 4, '1', '', NULL),
	(126, '64061', 'HK-JW230521002', 'y1_2E0A8245', '同底拷底', '', 1, 4, '1', '', NULL),
	(127, '64061', 'HK-JW230521002', 'y1_2E0A8250', '同底拷底', '', 1, 4, '1', '', NULL),
	(128, '64061', 'HK-JW230521002', 'y1_2E0A8254', '同底拷底', '', 1, 4, '1', '', NULL),
	(129, '64061', 'HK-JW230521002', 'y1_2E0A8259', '同底拷底', '', 1, 4, '1', '', NULL),
	(130, '64061', 'HK-JW230521002', 'y1_2E0A8261', '同底拷底', '', 1, 4, '1', '', NULL),
	(131, '64061', 'HK-JW230521002', 'y1_2E0A8264', '同底拷底', '', 1, 4, '1', '', NULL),
	(132, '64061', 'HK-JW230521002', 'y1_2E0A8268', '同底拷底', '', 1, 4, '1', '', NULL),
	(133, '64061', 'HK-JW230521002', 'y1_2E0A8272', '同底拷底', '', 1, 4, '1', '', NULL),
	(134, '64061', 'HK-JW230521002', 'y1_2E0A8276', '同底拷底', '', 1, 4, '1', '', NULL),
	(135, '64061', 'HK-JW230521002', 'y1_2E0A8280', '同底拷底', '', 1, 4, '1', '', NULL),
	(136, '64061', 'HK-JW230521002', 'y1_2E0A8285', '同底拷底', '', 1, 4, '1', '', NULL),
	(137, '64061', 'HK-JW230521002', 'y1_2E0A8288', '同底拷底', '', 1, 4, '1', '', NULL),
	(138, '64061', 'HK-JW230521002', 'y1_2E0A8294', '同底拷底', '', 1, 4, '1', '', NULL),
	(139, '64061', 'HK-JW230521002', 'y1_2E0A8298', '同底拷底', '', 1, 4, '1', '', NULL),
	(140, '64061', 'HK-JW230521002', 'y1_2E0A8304', '同底拷底', '', 1, 4, '1', '', NULL),
	(141, '64061', 'HK-JW230521002', 'y1_2E0A8306', '同底拷底', '', 1, 4, '1', '', NULL),
	(142, '64061', 'HK-JW230521002', 'y1_2E0A8310', '同底拷底', '', 1, 4, '1', '', NULL),
	(143, '64061', 'HK-JW230521002', 'y1_2E0A8312', '同底拷底', '', 1, 4, '1', '', NULL),
	(144, '64061', 'HK-JW230521002', 'y1_2E0A8315', '同底拷底', '', 1, 4, '1', '', NULL),
	(145, '64061', 'HK-JW230521002', 'y1_2E0A8321', '同底拷底', '', 1, 4, '1', '', NULL),
	(146, '64061', 'HK-JW230521002', 'y1_2E0A8322', '同底拷底', '', 1, 4, '1', '', NULL),
	(147, '64061', 'HK-JW230521002', 'y1_2E0A8328', '同底拷底', '', 1, 4, '1', '', NULL),
	(148, '64061', 'HK-JW230521002', 'y1_2E0A8334', '同底拷底', '', 1, 4, '1', '', NULL),
	(149, '64061', 'HK-JW230521002', 'y1_2E0A8337', '同底拷底', '', 1, 4, '1', '', NULL),
	(150, '64061', 'HK-JW230521002', 'y1_2E0A8344', '同底拷底', '', 1, 4, '1', '', NULL),
	(151, '64061', 'HK-JW230521002', 'y1_2E0A8400', '30寸贝恩简约框（60X70）', '', 1, 5, '1', '', NULL),
	(152, '64061', 'HK-JW230521002', 'y1_2E0A8421', '8X8初语（黄-蓝）', '', 1, 7, '1', '', NULL),
	(153, '64061', 'HK-JW230521002', 'y1_2E0A8441', '花语木框', '', 1, 8, '1', '', NULL),
	(154, '64061', 'HK-JW230521002', 'y1_2E0A8379', '20寸单片', '', 1, 6, '1', '', NULL),
	(155, '64061', 'HK-JW230521002', 'y1_2E0A8382', '20寸单片', '', 1, 6, '1', '', NULL),
	(156, '64061', 'HK-JW230521002', 'y1_2E0A8386', '20寸单片', '', 1, 6, '1', '', NULL),
	(157, '64061', 'HK-JW230521002', 'y1_2E0A8388', '20寸单片', '', 1, 6, '1', '', NULL),
	(158, '64061', 'HK-JW230521002', 'y1_2E0A8391', '20寸单片', '', 1, 6, '1', '', NULL),
	(159, '64061', 'HK-JW230521002', 'y1_2E0A8393', '20寸单片', '', 1, 6, '1', '', NULL),
	(160, '64061', 'HK-JW230521002', 'y1_2E0A8396', '20寸单片', '', 1, 6, '1', '', NULL),
	(161, '64061', 'HK-JW230521002', 'y1_2E0A8397', '20寸单片', '', 1, 6, '1', '', NULL),
	(162, '64061', 'HK-JW230521002', 'y1_2E0A8400', '20寸单片', '', 1, 6, '1', '', NULL),
	(163, '64061', 'HK-JW230521002', 'y1_2E0A8403', '20寸单片', '', 1, 6, '1', '', NULL),
	(164, '64061', 'HK-JW230521002', 'y1_2E0A8405', '20寸单片', '', 1, 6, '1', '', NULL),
	(165, '64061', 'HK-JW230521002', 'y1_2E0A8406', '20寸单片', '', 1, 6, '1', '', NULL),
	(166, '64061', 'HK-JW230521002', 'y1_2E0A8409', '20寸单片', '', 1, 6, '1', '', NULL),
	(167, '64061', 'HK-JW230521002', 'y1_2E0A8412', '20寸单片', '', 1, 6, '1', '', NULL),
	(168, '64061', 'HK-JW230521002', 'y1_2E0A8415', '20寸单片', '', 1, 6, '1', '', NULL),
	(169, '64061', 'HK-JW230521002', 'y1_2E0A8468', '20寸贝恩简约框（40X50)）', '', 1, 9, '1', '', NULL),
	(170, '58432', '65070_WL2020091301', 'y1_4dd8e1d653b70a7a7ea37abc6d7448b', '同底拷底', '', 1, 1, '1', '', NULL),
	(171, '58432', '65070_WL2020091301', 'y1_04795e0fa7a4808dce9458c32ce190e', '方10寸杂志相册', '', 1, 2, '1', '', NULL),
	(172, '58432', '65070_WL2020091301', 'y1_12c7a7a2c08285423cf13be025f6f7b', '方10寸杂志相册', '', 1, 2, '1', '', NULL),
	(173, '58432', '65070_WL2020091301', 'y1_178d7144eed0cc079ac0894045d1fb8', '方10寸杂志相册', '', 1, 2, '1', '', NULL),
	(174, '58432', '65070_WL2020091301', 'y1_31f5b39155ec7dcdeaddfb9d7e99bf8', '方10寸杂志相册', '', 1, 2, '1', '', NULL),
	(175, '58432', '65070_WL2020091301', 'y1_397b79c902b8ce000c91c31f5399122', '方10寸杂志相册', '', 1, 2, '1', '', NULL),
	(176, '58432', '65070_WL2020091301', 'y1_42aad5a26396db80e3234fbe20365c7', '方10寸杂志相册', '', 1, 2, '1', '', NULL),
	(177, '58432', '65070_WL2020091301', 'y1_7b1749f1acfeae4ca3d9829c38c006b', '方10寸杂志相册', '', 1, 2, '1', '', NULL),
	(178, '58432', '65070_WL2020091301', 'y1_7c34e74a3b14b11c2ff00e7e4635265', '方10寸杂志相册', '', 1, 2, '1', '', NULL),
	(179, '58432', '65070_WL2020091301', 'y1_7e1e8cd0e67960abe2b7c362421d94b', '方10寸杂志相册', '', 1, 2, '1', '', NULL),
	(180, '58432', '65070_WL2020091301', 'y1_82e25daa47b82744a82617d7ef51588', '方10寸杂志相册', '', 1, 2, '1', '', NULL),
	(181, '58432', '65070_WL2020091301', 'y1_87e8ed5620f237f167e88f732b2f4e2', '方10寸杂志相册', '', 1, 2, '1', '', NULL),
	(182, '58432', '65070_WL2020091301', 'y1_92a9e5cec31f67de6d8132c4a2306ca', '方10寸杂志相册', '', 1, 2, '1', '', NULL),
	(183, '58432', '65070_WL2020091301', 'y1_95357d0d2489f550f8498ea47a8a7ec', '方10寸杂志相册', '', 1, 2, '1', '', NULL),
	(184, '58432', '65070_WL2020091301', 'y1_9fbaaf1ebce9ec984c67bff53e5209d', '方10寸杂志相册', '', 1, 2, '1', '', NULL),
	(185, '58432', '65070_WL2020091301', 'y1_a1cae855645b37feb8508c7d27fed4e', '方10寸杂志相册', '', 1, 2, '1', '', NULL),
	(186, '64010', 'HK-JW230518004', 'y1_2055625', '10寸实木摆台', '', 1, 2, '1', '', NULL),
	(187, '64010', 'HK-JW230518004', 'y1_2055628', '10寸实木摆台', '', 1, 2, '1', '', NULL),
	(188, '64010', 'HK-JW230518004', 'y1_2055630', '10寸实木摆台', '', 1, 2, '1', '', NULL),
	(189, '64010', 'HK-JW230518004', 'y1_2055816', '10寸实木摆台', '', 1, 2, '1', '', NULL),
	(190, '64010', 'HK-JW230518004', 'y1_2055826', '10寸实木摆台', '', 1, 2, '1', '', NULL),
	(191, '64010', 'HK-JW230518004', 'y1_2055835', '10寸实木摆台', '', 1, 2, '1', '', NULL),
	(192, '64010', 'HK-JW230518004', 'y1_2055865', '10寸实木摆台', '', 1, 2, '1', '', NULL),
	(193, '64010', 'HK-JW230518004', 'y1_2055959', '10寸实木摆台', '', 1, 2, '1', '', NULL),
	(194, '64010', 'HK-JW230518004', 'y1_2055977', '10寸实木摆台', '', 1, 2, '1', '', NULL),
	(195, '64010', 'HK-JW230518004', 'y1_2056133', '10寸实木摆台', '', 1, 2, '1', '', NULL),
	(196, '64010', 'HK-JW230518004', 'y1_2056255', '10寸实木摆台', '', 1, 2, '1', '', NULL),
	(197, '64010', 'HK-JW230518004', 'y1_2056256', '10寸实木摆台', '', 1, 2, '1', '', NULL),
	(198, '64010', 'HK-JW230518004', 'y1_2056360', '10寸实木摆台', '', 1, 2, '1', '', NULL),
	(199, '64010', 'HK-JW230518004', 'y1_2056463', '10寸实木摆台', '', 1, 2, '1', '', NULL),
	(200, '64010', 'HK-JW230518004', 'y1_2056585', '10寸实木摆台', '', 1, 2, '1', '', NULL),
	(201, '64010', 'HK-JW230518004', 'y1_2056601', '10寸实木摆台', '', 1, 2, '1', '', NULL),
	(202, '64010', 'HK-JW230518004', 'y1_2056730', '10寸实木摆台', '', 1, 2, '1', '', NULL),
	(203, '64010', 'HK-JW230518004', 'y1_2056787', '10寸实木摆台', '', 1, 2, '1', '', NULL),
	(204, '64010', 'HK-JW230518004', 'y1_2056797', '10寸实木摆台', '', 1, 2, '1', '', NULL),
	(205, '64010', 'HK-JW230518004', 'y1_2056873', '10寸实木摆台', '', 1, 2, '1', '', NULL),
	(206, '64010', 'HK-JW230518004', 'y1_2057001', '10寸实木摆台', '', 1, 2, '1', '', NULL),
	(207, '64010', 'HK-JW230518004', 'y1_2057193', '10寸实木摆台', '', 1, 2, '1', '', NULL),
	(208, '64010', 'HK-JW230518004', 'y1_2057259', '10寸实木摆台', '', 1, 2, '1', '', NULL),
	(209, '64010', 'HK-JW230518004', 'y1_2057461', '10寸实木摆台', '', 1, 2, '1', '', NULL),
	(210, '64010', 'HK-JW230518004', 'y1_2055625 - 副本', '10寸实木摆台', '', 1, 2, '1', '', NULL),
	(211, '64010', 'HK-JW230518004', 'y1_2055628 - 副本', '10寸实木摆台', '', 1, 2, '1', '', NULL),
	(212, '64010', 'HK-JW230518004', 'y1_2055630 - 副本', '10寸实木摆台', '', 1, 2, '1', '', NULL),
	(213, '64010', 'HK-JW230518004', 'y1_2055816 - 副本', '10寸实木摆台', '', 1, 2, '1', '', NULL),
	(214, '64010', 'HK-JW230518004', 'y1_2055826 - 副本', '10寸实木摆台', '', 1, 2, '1', '', NULL),
	(215, '63183', 'HK-SY230514001', 's1_178d7144eed0cc079ac0894045d1fb8', '7寸萌芽摆台（绿）', '', 1, 1, '1', '', NULL),
	(216, '63183', 'HK-SY230514001', 's1_12c7a7a2c08285423cf13be025f6f7b', '方8寸萌芽册（绿）', '', 1, 2, '1', '', NULL),
	(217, '63183', 'HK-SY230514001', 's1_178d7144eed0cc079ac0894045d1fb8', '方8寸萌芽册（绿）', '', 1, 2, '1', '', NULL),
	(218, '63183', 'HK-SY230514001', 's1_92a9e5cec31f67de6d8132c4a2306ca', '方8寸萌芽册（绿）', '', 1, 2, '1', '', NULL),
	(219, '63183', 'HK-SY230514001', 's1_87e8ed5620f237f167e88f732b2f4e2', '方8寸萌芽册（绿）', '', 1, 2, '1', '', NULL),
	(220, '63183', 'HK-SY230514001', 's1_82e25daa47b82744a82617d7ef51588', '方8寸萌芽册（绿）', '', 1, 2, '1', '', NULL),
	(221, '63183', 'HK-SY230514001', 's1_7e1e8cd0e67960abe2b7c362421d94b', '方8寸萌芽册（绿）', '', 1, 2, '1', '', NULL),
	(222, '63183', 'HK-SY230514001', 's1_7c34e74a3b14b11c2ff00e7e4635265', '方8寸萌芽册（绿）', '', 1, 2, '1', '', NULL),
	(223, '63183', 'HK-SY230514001', 's1_4dd8e1d653b70a7a7ea37abc6d7448b', '方8寸萌芽册（绿）', '', 1, 2, '1', '', NULL),
	(224, '63183', 'HK-SY230514001', 's1_397b79c902b8ce000c91c31f5399122', '方8寸萌芽册（绿）', '', 1, 2, '1', '', NULL),
	(225, '63183', 'HK-SY230514001', 's1_31f5b39155ec7dcdeaddfb9d7e99bf8', '方8寸萌芽册（绿）', '', 1, 2, '1', '', NULL),
	(226, '63183', 'HK-SY230514001', 's1_42aad5a26396db80e3234fbe20365c7', '方8寸萌芽册（绿）', '', 1, 2, '1', '', NULL),
	(227, '63183', 'HK-SY230514001', 's1_95357d0d2489f550f8498ea47a8a7ec', '16寸萌芽框（绿）', '', 1, 3, '1', '', NULL),
	(228, '63183', 'HK-SY230514001', 's1_9fbaaf1ebce9ec984c67bff53e5209d', '10寸欧典水晶摆台', '', 1, 5, '1', '', NULL),
	(229, '63183', 'HK-SY230514001', 's1_9fbaaf1ebce9ec984c67bff53e5209d', '方10寸经典全家册', '', 1, 6, '1', '', NULL),
	(230, '63183', 'HK-SY230514001', 's1_a1cae855645b37feb8508c7d27fed4e', '方10寸经典全家册', '', 1, 6, '1', '', NULL),
	(231, '63183', 'HK-SY230514001', 's1_a22483955ed1a6b25511eff873a33ae', '方10寸经典全家册', '', 1, 6, '1', '', NULL),
	(232, '63183', 'HK-SY230514001', 's1_a31373157136283ee5d1dabf6b7febd', '方10寸经典全家册', '', 1, 6, '1', '', NULL),
	(233, '63183', 'HK-SY230514001', 's1_a57321508ccf8fbbf5b0aec47622552', '方10寸经典全家册', '', 1, 6, '1', '', NULL),
	(234, '63183', 'HK-SY230514001', 's1_b8bef9ff1c1ac68bfbbfc5a021fdfb5', '方10寸经典全家册', '', 1, 6, '1', '', NULL),
	(235, '63183', 'HK-SY230514001', 's1_bbdd95dc0a9de99fa6c276a786e6df1', '方10寸经典全家册', '', 1, 6, '1', '', NULL),
	(236, '63183', 'HK-SY230514001', 's1_bd34f332bcc4a63081316a0570bf436', '方10寸经典全家册', '', 1, 6, '1', '', NULL),
	(237, '63183', 'HK-SY230514001', 's1_d3c772c636c85fad3d9b80ee2c3f560', '方10寸经典全家册', '', 1, 6, '1', '', NULL),
	(238, '63183', 'HK-SY230514001', 's1_f83644474782e967906c0bb9916811b', '方10寸经典全家册', '', 1, 6, '1', '', NULL),
	(239, '63183', 'HK-SY230514001', 's1_a31373157136283ee5d1dabf6b7febd', '方8寸萌芽册（绿）', '', 1, 2, '1', '', NULL),
	(240, '63183', 'HK-SY230514001', 's1_a57321508ccf8fbbf5b0aec47622552', '方8寸萌芽册（绿）', '', 1, 2, '1', '', NULL),
	(241, '63183', 'HK-SY230514001', 's1_b8bef9ff1c1ac68bfbbfc5a021fdfb5', '方8寸萌芽册（绿）', '', 1, 2, '1', '', NULL),
	(242, '63183', 'HK-SY230514001', 's1_bbdd95dc0a9de99fa6c276a786e6df1', '方8寸萌芽册（绿）', '', 1, 2, '1', '', NULL),
	(243, '63183', 'HK-SY230514001', 's1_bd34f332bcc4a63081316a0570bf436', '方8寸萌芽册（绿）', '', 1, 2, '1', '', NULL),
	(244, '63183', 'HK-SY230514001', 's1_12c7a7a2c08285423cf13be025f6f7b', '方10寸经典全家册', '', 1, 6, '1', '', NULL),
	(245, '63183', 'HK-SY230514001', 's1_178d7144eed0cc079ac0894045d1fb8', '方10寸经典全家册', '', 1, 6, '1', '', NULL),
	(246, '63183', 'HK-SY230514001', 's1_4dd8e1d653b70a7a7ea37abc6d7448b', '方10寸经典全家册', '', 1, 6, '1', '', NULL),
	(247, '63183', 'HK-SY230514001', 's1_7c34e74a3b14b11c2ff00e7e4635265', '方10寸经典全家册', '', 1, 6, '1', '', NULL),
	(248, '63183', 'HK-SY230514001', 's1_7e1e8cd0e67960abe2b7c362421d94b', '方10寸经典全家册', '', 1, 6, '1', '', NULL),
	(249, '63183', 'HK-SY230514001', 's1_82e25daa47b82744a82617d7ef51588', '方10寸经典全家册', '', 1, 6, '1', '', NULL),
	(349, '64036', 'HK-JW230520001', 'y1_2055826', '24寸单片', '', 1, 1, '1', '', NULL),
	(350, '64036', 'HK-JW230520001', 'y1_2055835', '24寸单片', '', 1, 1, '1', '', NULL),
	(351, '64036', 'HK-JW230520001', 'y1_2055959', '24寸单片', '', 1, 1, '1', '', NULL),
	(352, '64036', 'HK-JW230520001', 'y1_2055977', '24寸单片', '', 1, 1, '1', '', NULL),
	(353, '64036', 'HK-JW230520001', 'y1_2056133', '24寸单片', '', 1, 1, '1', '', NULL),
	(354, '64036', 'HK-JW230520001', 'y1_2056255', '24寸单片', '', 1, 1, '1', '', NULL),
	(355, '64036', 'HK-JW230520001', 'y1_2056256', '24寸单片', '', 1, 1, '1', '', NULL),
	(356, '64036', 'HK-JW230520001', 'y1_2056360', '24寸单片', '', 1, 1, '1', '', NULL),
	(357, '64036', 'HK-JW230520001', 'y1_2056463', '24寸单片', '', 1, 1, '1', '', NULL),
	(358, '64036', 'HK-JW230520001', 'y1_2056585', '24寸单片', '', 1, 1, '1', '', NULL),
	(359, '64036', 'HK-JW230520001', 'y1_2056601', '24寸单片', '', 1, 1, '1', '', NULL),
	(360, '64036', 'HK-JW230520001', 'y1_2056730', '24寸单片', '', 1, 1, '1', '', NULL),
	(361, '64036', 'HK-JW230520001', 'y1_2056787', '24寸单片', '', 1, 1, '1', '', NULL),
	(362, '64036', 'HK-JW230520001', 'y1_2056797', '24寸单片', '', 1, 1, '1', '', NULL),
	(363, '64036', 'HK-JW230520001', 'y1_2056873', '24寸单片', '', 1, 1, '1', '', NULL),
	(364, '64036', 'HK-JW230520001', 'y1_2057001', '24寸单片', '', 1, 1, '1', '', NULL),
	(365, '64036', 'HK-JW230520001', 'y1_2057193', '24寸单片', '', 1, 1, '1', '', NULL),
	(366, '64036', 'HK-JW230520001', 'y1_2057259', '24寸单片', '', 1, 1, '1', '', NULL),
	(367, '64036', 'HK-JW230520001', 'y1_2057461', '24寸单片', '', 1, 1, '1', '', NULL),
	(368, '64036', 'HK-JW230520001', 'y1_2055625 - 副本', '24寸单片', '', 1, 1, '1', '', NULL),
	(369, '64036', 'HK-JW230520001', 'y1_2055630 - 副本', '24寸单片', '', 1, 1, '1', '', NULL),
	(370, '64036', 'HK-JW230520001', 'y1_2055816 - 副本', '24寸单片', '', 1, 1, '1', '', NULL),
	(371, '64036', 'HK-JW230520001', 'y1_2055835 - 副本', '24寸单片', '', 1, 1, '1', '', NULL),
	(372, '64036', 'HK-JW230520001', 'y1_2055865 - 副本', '24寸单片', '', 1, 1, '1', '', NULL),
	(373, '64036', 'HK-JW230520001', 'y1_2055865', '24寸单片', '', 1, 1, '1', '', NULL),
	(374, '64036', 'HK-JW230520001', 'y1_2055630', '24寸单片', '', 1, 1, '1', '', NULL),
	(375, '64036', 'HK-JW230520001', 'y1_2055816', '24寸单片', '', 1, 1, '1', '', NULL),
	(376, '64036', 'HK-JW230520001', 'y1_2055625', '24寸单片', '', 1, 1, '1', '', NULL),
	(377, '64036', 'HK-JW230520001', 'y1_2055628', '24寸单片', '', 1, 1, '1', '', NULL),
	(378, '64036', 'HK-JW230520001', 'y1_2055628 - 副本', '24寸单片', '', 1, 1, '1', '', NULL),
	(379, '64036', 'HK-JW230520001', 'y1_2055826 - 副本', '24寸单片', '', 1, 1, '1', '', NULL),
	(380, '64098', 'HK-JW230525003', 'y1_N22A9171', '同底拷底', '', 1, 1, '1', '', NULL),
	(381, '64098', 'HK-JW230525003', 'y1_N22A9172', '同底拷底', '', 1, 1, '1', '', NULL),
	(382, '64098', 'HK-JW230525003', 'y1_N22A9173', '同底拷底', '', 1, 1, '1', '', NULL),
	(383, '64098', 'HK-JW230525003', 'y1_N22A9174', '同底拷底', '', 1, 1, '1', '', NULL),
	(384, '64098', 'HK-JW230525003', 'y1_N22A9176', '同底拷底', '', 1, 1, '1', '', NULL),
	(385, '64098', 'HK-JW230525003', 'y1_N22A9186', '10寸单片', '', 1, 3, '1', '', NULL),
	(386, '64098', 'HK-JW230525003', 'y1_N22A9177', '10寸实木摆台', '', 1, 2, '1', '', NULL),
	(387, '64098', 'HK-JW230525003', 'y1_N22A9185', '10寸实木摆台', '', 1, 2, '1', '', NULL),
	(408, '64099', 'HK-JW230525004', 'y1_2055826 - 副本', '20寸单片', '', 3, 2, '1', '', NULL),
	(409, '64099', 'HK-JW230525004', 'y1_2056730', '同底拷底', '', 1, 1, '1', '', NULL),
	(410, '64099', 'HK-JW230525004', 'y1_2055865 - 副本', '同底拷底', '', 1, 1, '1', '', NULL),
	(411, '64099', 'HK-JW230525004', 'y1_2056601', '同底拷底', '', 1, 1, '1', '', NULL),
	(412, '64099', 'HK-JW230525004', 'y1_2055826 - 副本', '同底拷底', '', 1, 1, '1', '', NULL),
	(413, '64099', 'HK-JW230525004', 'y1_2056787', '同底拷底', '', 1, 1, '1', '', NULL),
	(414, '64099', 'HK-JW230525004', 'y1_2055816 - 副本', '同底拷底', '', 1, 1, '1', '', NULL),
	(415, '64099', 'HK-JW230525004', 'y1_2055865', '同底拷底', '', 1, 1, '1', '', NULL),
	(416, '64099', 'HK-JW230525004', 'y1_2056133', '同底拷底', '', 1, 1, '1', '', NULL),
	(417, '64099', 'HK-JW230525004', 'y1_2055835', '同底拷底', '', 1, 1, '1', '', NULL),
	(418, '64099', 'HK-JW230525004', 'y1_2055826', '同底拷底', '', 1, 1, '1', '', NULL),
	(419, '64099', 'HK-JW230525004', 'y1_2057001', '同底拷底', '', 1, 1, '1', '', NULL),
	(420, '64099', 'HK-JW230525004', 'y1_2055816', '同底拷底', '', 1, 1, '1', '', NULL),
	(421, '64099', 'HK-JW230525004', 'y1_2057193', '同底拷底', '', 1, 1, '1', '', NULL),
	(422, '64099', 'HK-JW230525004', 'y1_2055835 - 副本', '同底拷底', '', 1, 1, '1', '', NULL),
	(423, '64099', 'HK-JW230525004', 'y1_2056797', '同底拷底', '', 1, 1, '1', '', NULL),
	(424, '64099', 'HK-JW230525004', 'y1_2055977', '同底拷底', '', 1, 1, '1', '', NULL),
	(425, '64099', 'HK-JW230525004', 'y1_2055959', '同底拷底', '', 1, 1, '1', '', NULL),
	(426, '64099', 'HK-JW230525004', 'y1_2056463', '同底拷底', '', 1, 1, '1', '', NULL),
	(427, '64099', 'HK-JW230525004', 'y1_2056360', '同底拷底', '', 1, 1, '1', '', NULL),
	(428, '64099', 'HK-JW230525004', 'y1_2055628 - 副本', '同底拷底', '', 1, 1, '1', '', NULL),
	(429, '64099', 'HK-JW230525004', 'y1_2057259', '同底拷底', '', 1, 1, '1', '', NULL),
	(430, '64099', 'HK-JW230525004', 'y1_2055625 - 副本', '同底拷底', '', 1, 1, '1', '', NULL),
	(431, '64099', 'HK-JW230525004', 'y1_2056255', '同底拷底', '', 1, 1, '1', '', NULL),
	(432, '64099', 'HK-JW230525004', 'y1_2056256', '同底拷底', '', 1, 1, '1', '', NULL),
	(433, '64099', 'HK-JW230525004', 'y1_2056873', '同底拷底', '', 1, 1, '1', '', NULL),
	(434, '64099', 'HK-JW230525004', 'y1_2055630 - 副本', '同底拷底', '', 1, 1, '1', '', NULL),
	(435, '64099', 'HK-JW230525004', 'y1_2057461', '同底拷底', '', 1, 1, '1', '', NULL),
	(436, '64099', 'HK-JW230525004', 'y1_2055625 - 副本', '40X40米色九宫格', '', 1, 3, '1', '', NULL),
	(437, '64099', 'HK-JW230525004', 'y1_2057259', '40X40米色九宫格', '', 1, 3, '1', '', NULL),
	(438, '64099', 'HK-JW230525004', 'y1_2056730', '40X40米色九宫格', '', 1, 3, '1', '', NULL),
	(439, '64099', 'HK-JW230525004', 'y1_2055865 - 副本', '40X40米色九宫格', '', 1, 3, '1', '', NULL),
	(440, '64099', 'HK-JW230525004', 'y1_2056601', '40X40米色九宫格', '', 1, 3, '1', '', NULL),
	(442, '64099', 'HK-JW230525004', 'y1_2056787', '40X40米色九宫格', '', 1, 3, '1', '', NULL),
	(443, '64099', 'HK-JW230525004', 'y1_2055816 - 副本', '40X40米色九宫格', '', 1, 3, '1', '', NULL),
	(445, '64099', 'HK-JW230525004', 'y1_2056133', '40X40米色九宫格', '', 1, 3, '1', '', NULL),
	(447, '64099', 'HK-JW230525004', 'y1_2055826', '40X40米色九宫格', '', 1, 3, '1', '', NULL),
	(448, '64099', 'HK-JW230525004', 'y1_2057001', '40X40米色九宫格', '', 1, 3, '1', '', NULL),
	(449, '64099', 'HK-JW230525004', 'y1_2055816', '40X40米色九宫格', '', 1, 3, '1', '', NULL),
	(450, '64099', 'HK-JW230525004', 'y1_2057193', '40X40米色九宫格', '', 1, 3, '1', '', NULL),
	(451, '64099', 'HK-JW230525004', 'y1_2056797', '40X40米色九宫格', '', 1, 3, '1', '', NULL),
	(452, '64099', 'HK-JW230525004', 'y1_2056463', '40X40米色九宫格', '', 1, 3, '1', '', NULL),
	(453, '64099', 'HK-JW230525004', 'y1_2056360', '40X40米色九宫格', '', 1, 3, '1', '', NULL),
	(454, '64099', 'HK-JW230525004', 'y1_2056256', '40X40米色九宫格', '', 1, 3, '1', '', NULL),
	(467, '64099', 'HK-JW230525004', 'y1_2055959', '8X8初语（黄-蓝）', '', 1, 4, '1', '', NULL),
	(468, '64099', 'HK-JW230525004', 'y1_2055959', '花语木框', '', 1, 5, '1', '', NULL),
	(469, '64099', 'HK-JW230525004', 'y1_2057001', '花语木框', '', 1, 5, '1', '', NULL),
	(470, '64099', 'HK-JW230525004', 'y1_2055835 - 副本', '花语木框', '', 1, 5, '1', '', NULL),
	(471, '64099', 'HK-JW230525004', 'y1_2057193', '花语木框', '', 1, 5, '1', '', NULL),
	(472, '64099', 'HK-JW230525004', 'y1_2055835', '20寸贝恩简约框（40X50)）', '', 1, 6, '1', '', NULL),
	(473, '64099', 'HK-JW230525004', 'y1_2055826', '20寸贝恩简约框（40X50)）', '', 1, 6, '1', '', NULL),
	(474, '64099', 'HK-JW230525004', 'y1_2057001', '20寸贝恩简约框（40X50)）', '', 1, 6, '1', '', NULL),
	(475, '64099', 'HK-JW230525004', 'y1_2055816', '20寸贝恩简约框（40X50)）', '', 1, 6, '1', '', NULL),
	(476, '64099', 'HK-JW230525004', 'y1_2057193', '20寸贝恩简约框（40X50)）', '', 1, 6, '1', '', NULL),
	(477, '64099', 'HK-JW230525004', 'y1_2055835 - 副本', '20寸贝恩简约框（40X50)）', '', 1, 6, '1', '', NULL),
	(478, '64099', 'HK-JW230525004', 'y1_2056797', '20寸贝恩简约框（40X50)）', '', 1, 6, '1', '', NULL),
	(479, '64099', 'HK-JW230525004', 'y1_2055977', '20寸贝恩简约框（40X50)）', '', 1, 6, '1', '', NULL),
	(480, '64099', 'HK-JW230525004', 'y1_2055959', '20寸贝恩简约框（40X50)）', '', 1, 6, '1', '', NULL),
	(481, '64099', 'HK-JW230525004', 'y1_2056463', '20寸贝恩简约框（40X50)）', '', 1, 6, '1', '', NULL),
	(482, '64099', 'HK-JW230525004', 'y1_2056360', '20寸贝恩简约框（40X50)）', '', 1, 6, '1', '', NULL),
	(483, '64099', 'HK-JW230525004', 'y1_2055628 - 副本', '20寸贝恩简约框（40X50)）', '', 1, 6, '1', '', NULL),
	(484, '64099', 'HK-JW230525004', 'y1_2057259', '20寸贝恩简约框（40X50)）', '', 1, 6, '1', '', NULL),
	(485, '64099', 'HK-JW230525004', 'y1_2056256', '精致原木框', '', 1, 9, '1', '', NULL),
	(486, '63204', 'HK-SY230529001', 'y1_5Z9A4078', '同底拷底', '', 1, 1, '1', '', NULL),
	(487, '63204', 'HK-SY230529001', 'y1_5Z9A4079', '同底拷底', '', 1, 1, '1', '', NULL),
	(488, '63204', 'HK-SY230529001', 'y1_1', '同底拷底', '', 1, 1, '1', '', NULL),
	(489, '63204', 'HK-SY230529001', 'y1_5Z9A4060', '同底拷底', '', 1, 1, '1', '', NULL),
	(490, '63204', 'HK-SY230529001', 'y1_5Z9A4064', '同底拷底', '', 1, 1, '1', '', NULL),
	(491, '63204', 'HK-SY230529001', 'y1_5Z9A4115', '同底拷底', '', 1, 1, '1', '', NULL),
	(492, '63204', 'HK-SY230529001', 'y1_5Z9A4118', '同底拷底', '', 1, 1, '1', '', NULL),
	(493, '63204', 'HK-SY230529001', 'y1_5Z9A4133', '同底拷底', '', 1, 1, '1', '', NULL),
	(494, '63204', 'HK-SY230529001', 'y1_5Z9A4138', '同底拷底', '', 1, 1, '1', '', NULL),
	(495, '63204', 'HK-SY230529001', 'y1_5Z9A4151', '同底拷底', '', 1, 1, '1', '', NULL),
	(496, '63204', 'HK-SY230529001', 'y1_5Z9A4197', '同底拷底', '', 1, 1, '1', '', NULL),
	(497, '63204', 'HK-SY230529001', 'y1_5Z9A4205', '同底拷底', '', 1, 1, '1', '', NULL),
	(498, '63204', 'HK-SY230529001', 'y1_5Z9A4215', '同底拷底', '', 1, 1, '1', '', NULL),
	(499, '63204', 'HK-SY230529001', 'y1_5Z9A4218', '同底拷底', '', 1, 1, '1', '', NULL),
	(500, '63204', 'HK-SY230529001', 'y1_5Z9A4224', '同底拷底', '', 1, 1, '1', '', NULL),
	(501, '63204', 'HK-SY230529001', 'y1_5Z9A4235', '同底拷底', '', 1, 1, '1', '', NULL),
	(502, '63204', 'HK-SY230529001', 'y1_5Z9A4239', '同底拷底', '', 1, 1, '1', '', NULL),
	(503, '63204', 'HK-SY230529001', 'y1_5Z9A4251', '同底拷底', '', 1, 1, '1', '', NULL),
	(504, '63204', 'HK-SY230529001', 'y1_5Z9A4256', '同底拷底', '', 1, 1, '1', '', NULL),
	(505, '63204', 'HK-SY230529001', 'y1_5Z9A4265', '同底拷底', '', 1, 1, '1', '', NULL),
	(506, '63204', 'HK-SY230529001', 'y1_5Z9A4279', '同底拷底', '', 1, 1, '1', '', NULL),
	(507, '63204', 'HK-SY230529001', 'y1_IMG_3942', '同底拷底', '', 1, 1, '1', '', NULL),
	(508, '63204', 'HK-SY230529001', 'y1_IMG_3957', '同底拷底', '', 1, 1, '1', '', NULL),
	(509, '63204', 'HK-SY230529001', 'y1_IMG_5789', '同底拷底', '', 1, 1, '1', '', NULL),
	(510, '63204', 'HK-SY230529001', 'y1_IMG_5793', '同底拷底', '', 1, 1, '1', '', NULL),
	(511, '63204', 'HK-SY230529001', 'y1_IMG_5795', '同底拷底', '', 1, 1, '1', '', NULL),
	(512, '63204', 'HK-SY230529001', 'y1_IMG_5796', '同底拷底', '', 1, 1, '1', '', NULL),
	(513, '63204', 'HK-SY230529001', 'y1_IMG_5800', '同底拷底', '', 1, 1, '1', '', NULL),
	(514, '63204', 'HK-SY230529001', 'y1_IMG_5816', '同底拷底', '', 1, 1, '1', '', NULL),
	(515, '63204', 'HK-SY230529001', 'y1_合影 (19)', '同底拷底', '', 1, 1, '1', '', NULL),
	(516, '63204', 'HK-SY230529001', 'y1_合影 (21)', '同底拷底', '', 1, 1, '1', '', NULL),
	(517, '63204', 'HK-SY230529001', 'y1_5Z9A4064', '方10寸经典全家册', '', 1, 2, '1', '', NULL),
	(518, '63204', 'HK-SY230529001', 'y1_5Z9A4078', '方10寸经典全家册', '', 1, 2, '1', '', NULL),
	(519, '63204', 'HK-SY230529001', 'y1_5Z9A4079', '方10寸经典全家册', '', 1, 2, '1', '', NULL),
	(520, '63204', 'HK-SY230529001', 'y1_5Z9A4115', '方10寸经典全家册', '', 1, 2, '1', '', NULL),
	(521, '63204', 'HK-SY230529001', 'y1_5Z9A4118', '方10寸经典全家册', '', 1, 2, '1', '', NULL),
	(522, '63204', 'HK-SY230529001', 'y1_5Z9A4133', '方10寸经典全家册', '', 1, 2, '1', '', NULL),
	(527, '63204', 'HK-SY230529001', 'y1_5Z9A4138', '8X8家传承', '', 1, 4, '1', '', NULL),
	(528, '63204', 'HK-SY230529001', 'y1_5Z9A4115', '8X8家传承', '', 1, 4, '1', '', NULL),
	(529, '63204', 'HK-SY230529001', 'y1_5Z9A4118', '8X8家传承', '', 1, 4, '1', '', NULL),
	(530, '63204', 'HK-SY230529001', 'y1_5Z9A4133', '8X8家传承', '', 1, 4, '1', '', NULL),
	(556, '63204', 'HK-JW230529001', 'y1_AC7A8775', '20寸贝恩简约框（40X50)）', '', 1, 1, '1', '', NULL),
	(557, '63204', 'HK-JW230529001', 'y1_AC7A8797', '20寸贝恩简约框（40X50)）', '', 1, 1, '1', '', NULL),
	(558, '63204', 'HK-JW230529001', 'y1_AC7A8730', '20寸贝恩简约框（40X50)）', '', 1, 1, '1', '', NULL),
	(559, '63204', 'HK-JW230529001', 'y1_AC7A8741', '20寸贝恩简约框（40X50)）', '', 1, 1, '1', '', NULL),
	(560, '63204', 'HK-JW230529001', 'y1_AC7A8754', '20寸贝恩简约框（40X50)）', '', 1, 1, '1', '', NULL),
	(561, '63204', 'HK-JW230529001', 'y1_00', '20寸贝恩简约框（40X50)）', '', 1, 1, '1', '', NULL),
	(562, '63204', 'HK-JW230529001', 'y1_AC7A8697', '20寸贝恩简约框（40X50)）', '', 1, 1, '1', '', NULL),
	(563, '63204', 'HK-JW230529001', 'y1_AC7A8702', '20寸贝恩简约框（40X50)）', '', 1, 1, '1', '', NULL),
	(564, '63204', 'HK-JW230529001', 'y1_AC7A8707', '20寸贝恩简约框（40X50)）', '', 1, 1, '1', '', NULL),
	(565, '63204', 'HK-JW230529001', 'y1_AC7A8818', '20寸贝恩简约框（40X50)）', '', 1, 1, '1', '', NULL),
	(566, '63204', 'HK-JW230529001', 'y1_微信图片_20201015170814', '20寸贝恩简约框（40X50)）', '', 1, 1, '1', '', NULL),
	(567, '63204', 'HK-JW230529001', 'y1_微信图片_20201015170825', '20寸贝恩简约框（40X50)）', '', 1, 1, '1', '', NULL),
	(568, '63204', 'HK-JW230529001', 'y1_微信图片_20201015170828', '20寸贝恩简约框（40X50)）', '', 1, 1, '1', '', NULL),
	(569, '63204', 'HK-JW230529001', 'y1_微信图片_20201015170831', '20寸贝恩简约框（40X50)）', '', 1, 1, '1', '', NULL),
	(570, '63204', 'HK-JW230529001', 'y1_微信图片_20201015170833', '20寸贝恩简约框（40X50)）', '', 1, 1, '1', '', NULL),
	(571, '63204', 'HK-JW230529001', 'y1_微信图片_20201015170836', '20寸贝恩简约框（40X50)）', '', 1, 1, '1', '', NULL),
	(572, '63204', 'HK-JW230529001', 'y1_微信图片_20201015170838', '20寸贝恩简约框（40X50)）', '', 1, 1, '1', '', NULL),
	(573, '63204', 'HK-JW230529001', 'y1_微信图片_20201015170903', '20寸贝恩简约框（40X50)）', '', 1, 1, '1', '', NULL),
	(574, '63204', 'HK-JW230529001', 'y1_微信图片_20201015170907', '20寸贝恩简约框（40X50)）', '', 1, 1, '1', '', NULL),
	(575, '63204', 'HK-JW230529001', 'y1_微信图片_20201015170910', '20寸贝恩简约框（40X50)）', '', 1, 1, '1', '', NULL),
	(576, '63204', 'HK-JW230529001', 'y1_AC7A8709', '20寸贝恩简约框（40X50)）', '', 1, 1, '1', '', NULL),
	(587, '641', 'HK-JW230602001', 'y1_KA4B8347', '布朗熊 摆台20X25CM', '', 1, 3, '1', '', NULL),
	(588, '641', 'HK-JW230602001', 'y1_KA4B8354', '布朗熊放大70X50CM', '', 1, 5, '1', '', NULL),
	(589, '641', 'HK-JW230602001', 'y1_KA4B8354', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(590, '641', 'HK-JW230602001', 'y1_KA4B8141', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(591, '641', 'HK-JW230602001', 'y1_KA4B8143', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(592, '641', 'HK-JW230602001', 'y1_KA4B8147', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(593, '641', 'HK-JW230602001', 'y1_KA4B8148', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(594, '641', 'HK-JW230602001', 'y1_KA4B8149', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(595, '641', 'HK-JW230602001', 'y1_KA4B8151', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(596, '641', 'HK-JW230602001', 'y1_KA4B8162', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(597, '641', 'HK-JW230602001', 'y1_KA4B8163', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(598, '641', 'HK-JW230602001', 'y1_KA4B8164', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(599, '641', 'HK-JW230602001', 'y1_KA4B8167', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(600, '641', 'HK-JW230602001', 'y1_KA4B8168', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(601, '641', 'HK-JW230602001', 'y1_KA4B8169', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(602, '641', 'HK-JW230602001', 'y1_KA4B8171', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(603, '641', 'HK-JW230602001', 'y1_KA4B8172', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(604, '641', 'HK-JW230602001', 'y1_KA4B8175', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(605, '641', 'HK-JW230602001', 'y1_KA4B8179', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(606, '641', 'HK-JW230602001', 'y1_KA4B8180', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(607, '641', 'HK-JW230602001', 'y1_KA4B8181', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(608, '641', 'HK-JW230602001', 'y1_KA4B8183', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(609, '641', 'HK-JW230602001', 'y1_KA4B8185', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(610, '641', 'HK-JW230602001', 'y1_KA4B8186', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(611, '641', 'HK-JW230602001', 'y1_KA4B8190', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(612, '641', 'HK-JW230602001', 'y1_KA4B8191', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(613, '641', 'HK-JW230602001', 'y1_KA4B8192', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(614, '641', 'HK-JW230602001', 'y1_KA4B8193', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(615, '641', 'HK-JW230602001', 'y1_KA4B8194', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(616, '641', 'HK-JW230602001', 'y1_KA4B8195', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(617, '641', 'HK-JW230602001', 'y1_KA4B8196', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(618, '641', 'HK-JW230602001', 'y1_KA4B8197', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(619, '641', 'HK-JW230602001', 'y1_KA4B8198', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(620, '641', 'HK-JW230602001', 'y1_KA4B8199', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(621, '641', 'HK-JW230602001', 'y1_KA4B8200', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(622, '641', 'HK-JW230602001', 'y1_KA4B8201', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(623, '641', 'HK-JW230602001', 'y1_KA4B8202', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(624, '641', 'HK-JW230602001', 'y1_KA4B8203', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(625, '641', 'HK-JW230602001', 'y1_KA4B8204', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(626, '641', 'HK-JW230602001', 'y1_KA4B8205', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(627, '641', 'HK-JW230602001', 'y1_KA4B8206', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(628, '641', 'HK-JW230602001', 'y1_KA4B8207', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(629, '641', 'HK-JW230602001', 'y1_KA4B8208', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(630, '641', 'HK-JW230602001', 'y1_KA4B8209', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(631, '641', 'HK-JW230602001', 'y1_KA4B8211', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(632, '641', 'HK-JW230602001', 'y1_KA4B8213', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(633, '641', 'HK-JW230602001', 'y1_KA4B8214', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(634, '641', 'HK-JW230602001', 'y1_KA4B8215', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(635, '641', 'HK-JW230602001', 'y1_KA4B8216', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(636, '641', 'HK-JW230602001', 'y1_KA4B8218', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(637, '641', 'HK-JW230602001', 'y1_KA4B8219', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(638, '641', 'HK-JW230602001', 'y1_KA4B8221', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(639, '641', 'HK-JW230602001', 'y1_KA4B8222', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(640, '641', 'HK-JW230602001', 'y1_KA4B8223', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(641, '641', 'HK-JW230602001', 'y1_KA4B8224', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(642, '641', 'HK-JW230602001', 'y1_KA4B8227', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(643, '641', 'HK-JW230602001', 'y1_KA4B8228', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(644, '641', 'HK-JW230602001', 'y1_KA4B8229', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(645, '641', 'HK-JW230602001', 'y1_KA4B8230', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(646, '641', 'HK-JW230602001', 'y1_KA4B8231', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(647, '641', 'HK-JW230602001', 'y1_KA4B8232', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(648, '641', 'HK-JW230602001', 'y1_KA4B8233', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(649, '641', 'HK-JW230602001', 'y1_KA4B8234', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(650, '641', 'HK-JW230602001', 'y1_KA4B8235', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(651, '641', 'HK-JW230602001', 'y1_KA4B8236', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(652, '641', 'HK-JW230602001', 'y1_KA4B8237', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(653, '641', 'HK-JW230602001', 'y1_KA4B8238', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(654, '641', 'HK-JW230602001', 'y1_KA4B8239', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(655, '641', 'HK-JW230602001', 'y1_KA4B8240', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(656, '641', 'HK-JW230602001', 'y1_KA4B8241', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(657, '641', 'HK-JW230602001', 'y1_KA4B8242', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(658, '641', 'HK-JW230602001', 'y1_KA4B8243', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(659, '641', 'HK-JW230602001', 'y1_KA4B8244', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(660, '641', 'HK-JW230602001', 'y1_KA4B8245', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(661, '641', 'HK-JW230602001', 'y1_KA4B8246', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(662, '641', 'HK-JW230602001', 'y1_KA4B8247', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(663, '641', 'HK-JW230602001', 'y1_KA4B8248', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(664, '641', 'HK-JW230602001', 'y1_KA4B8250', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(665, '641', 'HK-JW230602001', 'y1_KA4B8251', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(666, '641', 'HK-JW230602001', 'y1_KA4B8252', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(667, '641', 'HK-JW230602001', 'y1_KA4B8253', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(668, '641', 'HK-JW230602001', 'y1_KA4B8255', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(669, '641', 'HK-JW230602001', 'y1_KA4B8256', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(670, '641', 'HK-JW230602001', 'y1_KA4B8257', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(671, '641', 'HK-JW230602001', 'y1_KA4B8258', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(672, '641', 'HK-JW230602001', 'y1_KA4B8259', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(673, '641', 'HK-JW230602001', 'y1_KA4B8260', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(674, '641', 'HK-JW230602001', 'y1_KA4B8261', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(675, '641', 'HK-JW230602001', 'y1_KA4B8262', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(676, '641', 'HK-JW230602001', 'y1_KA4B8263', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(677, '641', 'HK-JW230602001', 'y1_KA4B8264', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(678, '641', 'HK-JW230602001', 'y1_KA4B8265', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(679, '641', 'HK-JW230602001', 'y1_KA4B8266', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(680, '641', 'HK-JW230602001', 'y1_KA4B8267', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(681, '641', 'HK-JW230602001', 'y1_KA4B8268', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(682, '641', 'HK-JW230602001', 'y1_KA4B8269', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(683, '641', 'HK-JW230602001', 'y1_KA4B8270', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(684, '641', 'HK-JW230602001', 'y1_KA4B8271', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(685, '641', 'HK-JW230602001', 'y1_KA4B8273', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(686, '641', 'HK-JW230602001', 'y1_KA4B8275', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(687, '641', 'HK-JW230602001', 'y1_KA4B8276', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(688, '641', 'HK-JW230602001', 'y1_KA4B8278', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(689, '641', 'HK-JW230602001', 'y1_KA4B8279', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(690, '641', 'HK-JW230602001', 'y1_KA4B8294', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(691, '641', 'HK-JW230602001', 'y1_KA4B8295', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(692, '641', 'HK-JW230602001', 'y1_KA4B8296', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(693, '641', 'HK-JW230602001', 'y1_KA4B8297', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(694, '641', 'HK-JW230602001', 'y1_KA4B8320', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(695, '641', 'HK-JW230602001', 'y1_KA4B8321', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(696, '641', 'HK-JW230602001', 'y1_KA4B8323', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(697, '641', 'HK-JW230602001', 'y1_KA4B8324', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(698, '641', 'HK-JW230602001', 'y1_KA4B8325', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(699, '641', 'HK-JW230602001', 'y1_KA4B8326', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(700, '641', 'HK-JW230602001', 'y1_KA4B8327', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(701, '641', 'HK-JW230602001', 'y1_KA4B8328', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(702, '641', 'HK-JW230602001', 'y1_KA4B8329', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(703, '641', 'HK-JW230602001', 'y1_KA4B8331', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(704, '641', 'HK-JW230602001', 'y1_KA4B8333', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(705, '641', 'HK-JW230602001', 'y1_KA4B8334', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(706, '641', 'HK-JW230602001', 'y1_KA4B8335', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(707, '641', 'HK-JW230602001', 'y1_KA4B8336', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(708, '641', 'HK-JW230602001', 'y1_KA4B8337', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(709, '641', 'HK-JW230602001', 'y1_KA4B8339', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(710, '641', 'HK-JW230602001', 'y1_KA4B8340', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(711, '641', 'HK-JW230602001', 'y1_KA4B8341', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(712, '641', 'HK-JW230602001', 'y1_KA4B8342', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(713, '641', 'HK-JW230602001', 'y1_KA4B8343', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(714, '641', 'HK-JW230602001', 'y1_KA4B8345', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(715, '641', 'HK-JW230602001', 'y1_KA4B8347', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(716, '641', 'HK-JW230602001', 'y1_KA4B8350', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(717, '641', 'HK-JW230602001', 'y1_KA4B8351', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(718, '641', 'HK-JW230602001', 'y1_KA4B8352', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(719, '641', 'HK-JW230602001', 'y1_KA4B8353', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(720, '641', 'HK-JW230602001', 'y1_KA4B8150', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(721, '641', 'HK-JW230602001', 'y1_KA4B8140', '方10寸布朗熊相册', '', 1, 2, '1', '', NULL),
	(722, '641', 'HK-JW230602001', 'y1_KA4B8328', '布朗熊 摆台15X20CM', '', 1, 4, '1', '', NULL);
/*!40000 ALTER TABLE `x_consume` ENABLE KEYS */;

-- Dumping structure for table erds_sx_sp.x_consumebk
DROP TABLE IF EXISTS `x_consumebk`;
CREATE TABLE IF NOT EXISTS `x_consumebk` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `customernum` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `orderid` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `photonum` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `consumeitem` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `Size` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `amount` int(11) NOT NULL DEFAULT '0',
  `itemnum` int(11) NOT NULL DEFAULT '0',
  `type` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `imagegroup` varchar(70) COLLATE utf8_unicode_ci DEFAULT '',
  `optime` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=171 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table erds_sx_sp.x_consumebk: ~0 rows (大约)
DELETE FROM `x_consumebk`;
/*!40000 ALTER TABLE `x_consumebk` DISABLE KEYS */;
/*!40000 ALTER TABLE `x_consumebk` ENABLE KEYS */;

-- Dumping structure for table erds_sx_sp.x_consumedel
DROP TABLE IF EXISTS `x_consumedel`;
CREATE TABLE IF NOT EXISTS `x_consumedel` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `customernum` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `orderid` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `photonum` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `consumeitem` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `Size` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `amount` int(11) DEFAULT NULL,
  `itemnum` int(11) DEFAULT NULL,
  `type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `imagegroup` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `optime` datetime DEFAULT NULL,
  `opdeltype` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  `opdelman` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `orderid` (`orderid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='选片产品';

-- Dumping data for table erds_sx_sp.x_consumedel: ~0 rows (大约)
DELETE FROM `x_consumedel`;
/*!40000 ALTER TABLE `x_consumedel` DISABLE KEYS */;
/*!40000 ALTER TABLE `x_consumedel` ENABLE KEYS */;

-- Dumping structure for table erds_sx_sp.x_fenlei
DROP TABLE IF EXISTS `x_fenlei`;
CREATE TABLE IF NOT EXISTS `x_fenlei` (
  `leibie` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table erds_sx_sp.x_fenlei: ~0 rows (大约)
DELETE FROM `x_fenlei`;
/*!40000 ALTER TABLE `x_fenlei` DISABLE KEYS */;
/*!40000 ALTER TABLE `x_fenlei` ENABLE KEYS */;

-- Dumping structure for table erds_sx_sp.x_ftpsendrecord
DROP TABLE IF EXISTS `x_ftpsendrecord`;
CREATE TABLE IF NOT EXISTS `x_ftpsendrecord` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `guid` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `consumeitem` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `itemnum` int(11) DEFAULT NULL,
  `issuccess` int(11) DEFAULT NULL,
  `orderId` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `remark` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `guid` (`guid`),
  KEY `orderId` (`orderId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='发包记录';

-- Dumping data for table erds_sx_sp.x_ftpsendrecord: ~0 rows (大约)
DELETE FROM `x_ftpsendrecord`;
/*!40000 ALTER TABLE `x_ftpsendrecord` DISABLE KEYS */;
/*!40000 ALTER TABLE `x_ftpsendrecord` ENABLE KEYS */;

-- Dumping structure for table erds_sx_sp.x_ftpsendrecordf
DROP TABLE IF EXISTS `x_ftpsendrecordf`;
CREATE TABLE IF NOT EXISTS `x_ftpsendrecordf` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `orderId` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `guid` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `filecreate` int(11) DEFAULT '0',
  `sendtime` datetime DEFAULT CURRENT_TIMESTAMP,
  `currentfc` int(11) DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sendman` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `istruing` int(11) DEFAULT '0',
  `targetdate` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mmbbbb` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `guid` (`guid`),
  KEY `orderId` (`orderId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table erds_sx_sp.x_ftpsendrecordf: ~0 rows (大约)
DELETE FROM `x_ftpsendrecordf`;
/*!40000 ALTER TABLE `x_ftpsendrecordf` DISABLE KEYS */;
/*!40000 ALTER TABLE `x_ftpsendrecordf` ENABLE KEYS */;

-- Dumping structure for table erds_sx_sp.x_ftptask
DROP TABLE IF EXISTS `x_ftptask`;
CREATE TABLE IF NOT EXISTS `x_ftptask` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `orderId` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '单号',
  `targetdate` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '订单日期',
  `shopname` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '上传店面',
  `localpath` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '文件路径',
  `fatherpath` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '目标路径',
  `filename` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '文件名',
  `state` int(11) DEFAULT '0' COMMENT '上传状态',
  `failmessage` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `shopname` (`shopname`),
  KEY `state` (`state`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table erds_sx_sp.x_ftptask: ~0 rows (大约)
DELETE FROM `x_ftptask`;
/*!40000 ALTER TABLE `x_ftptask` DISABLE KEYS */;
/*!40000 ALTER TABLE `x_ftptask` ENABLE KEYS */;

-- Dumping structure for table erds_sx_sp.x_ftptask_down
DROP TABLE IF EXISTS `x_ftptask_down`;
CREATE TABLE IF NOT EXISTS `x_ftptask_down` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `orderId` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '单号',
  `targetdate` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '订单日期',
  `shopname` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '上传店面',
  `localpath` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '文件路径',
  `fatherpath` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '目标路径',
  `filename` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '文件名',
  `state` int(11) DEFAULT '0' COMMENT '上传状态',
  `failmessage` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `shopname` (`shopname`),
  KEY `state` (`state`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ROW_FORMAT=COMPACT;

-- Dumping data for table erds_sx_sp.x_ftptask_down: ~0 rows (大约)
DELETE FROM `x_ftptask_down`;
/*!40000 ALTER TABLE `x_ftptask_down` DISABLE KEYS */;
/*!40000 ALTER TABLE `x_ftptask_down` ENABLE KEYS */;

-- Dumping structure for table erds_sx_sp.x_heban
DROP TABLE IF EXISTS `x_heban`;
CREATE TABLE IF NOT EXISTS `x_heban` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `orderid` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `fc` int(11) DEFAULT '0',
  `photonum` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `consumeitem` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `itemnum` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `banmian` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table erds_sx_sp.x_heban: ~0 rows (大约)
DELETE FROM `x_heban`;
/*!40000 ALTER TABLE `x_heban` DISABLE KEYS */;
/*!40000 ALTER TABLE `x_heban` ENABLE KEYS */;

-- Dumping structure for table erds_sx_sp.x_note
DROP TABLE IF EXISTS `x_note`;
CREATE TABLE IF NOT EXISTS `x_note` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `customerid` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `orderId` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `PhotoNum` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `Note` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ShapeType` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ShapeX` int(11) DEFAULT NULL,
  `ShapeY` int(11) DEFAULT NULL,
  `ShapeW` int(11) DEFAULT NULL,
  `ShapeH` int(11) DEFAULT NULL,
  `PicW` int(11) DEFAULT NULL,
  `ShapeColor` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='标记';

-- Dumping data for table erds_sx_sp.x_note: ~0 rows (大约)
DELETE FROM `x_note`;
/*!40000 ALTER TABLE `x_note` DISABLE KEYS */;
/*!40000 ALTER TABLE `x_note` ENABLE KEYS */;

-- Dumping structure for table erds_sx_sp.x_othershop
DROP TABLE IF EXISTS `x_othershop`;
CREATE TABLE IF NOT EXISTS `x_othershop` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `shop_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_ip` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_port` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `OriginalPath` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  `MidOriginalPath` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  `SendPagePath` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  `SendZipPagePath` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  `LocalSpecialPath` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  `LocaldownloadPath` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ReportPath` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  `CloudPath` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ProductmoldePath` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  `setkey` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table erds_sx_sp.x_othershop: ~0 rows (大约)
DELETE FROM `x_othershop`;
/*!40000 ALTER TABLE `x_othershop` DISABLE KEYS */;
/*!40000 ALTER TABLE `x_othershop` ENABLE KEYS */;

-- Dumping structure for table erds_sx_sp.x_phopo
DROP TABLE IF EXISTS `x_phopo`;
CREATE TABLE IF NOT EXISTS `x_phopo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `customerid` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户编号',
  `orderId` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '订单编号',
  `daoru` int(11) DEFAULT NULL COMMENT '是不是导入',
  `xuanru` int(11) DEFAULT NULL COMMENT '是不是选入',
  `PhotoNum` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '图片名',
  `MakeFlag` int(11) DEFAULT NULL COMMENT '有无标记',
  `remark` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  `AllMark` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  `isSelect` int(11) DEFAULT '0' COMMENT '选没选',
  `type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '订单名',
  `CutFlag` int(11) DEFAULT NULL,
  `deleteTime` datetime DEFAULT NULL,
  `specialflag` int(11) DEFAULT NULL,
  `AllWarn` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  `imagegroup` varchar(70) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `orderId_PhotoNum` (`orderId`,`PhotoNum`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='导片选片记录';

-- Dumping data for table erds_sx_sp.x_phopo: ~0 rows (大约)
DELETE FROM `x_phopo`;
/*!40000 ALTER TABLE `x_phopo` DISABLE KEYS */;
/*!40000 ALTER TABLE `x_phopo` ENABLE KEYS */;

-- Dumping structure for table erds_sx_sp.x_phopodp
DROP TABLE IF EXISTS `x_phopodp`;
CREATE TABLE IF NOT EXISTS `x_phopodp` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `orderId` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '订单编号',
  `PhotoNum` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '图片名',
  `filepath` varchar(150) COLLATE utf8_unicode_ci DEFAULT NULL,
  `photoid` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `orderId_PhotoNum_photoid` (`orderId`,`PhotoNum`,`photoid`),
  KEY `orderId` (`orderId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='导片选片记录';

-- Dumping data for table erds_sx_sp.x_phopodp: ~0 rows (大约)
DELETE FROM `x_phopodp`;
/*!40000 ALTER TABLE `x_phopodp` DISABLE KEYS */;
/*!40000 ALTER TABLE `x_phopodp` ENABLE KEYS */;

-- Dumping structure for table erds_sx_sp.x_product
DROP TABLE IF EXISTS `x_product`;
CREATE TABLE IF NOT EXISTS `x_product` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `orderid` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `productnum` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `imagename` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fc` int(11) DEFAULT NULL,
  `optype` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table erds_sx_sp.x_product: 0 rows
DELETE FROM `x_product`;
/*!40000 ALTER TABLE `x_product` DISABLE KEYS */;
/*!40000 ALTER TABLE `x_product` ENABLE KEYS */;

-- Dumping structure for table erds_sx_sp.x_sendrecord
DROP TABLE IF EXISTS `x_sendrecord`;
CREATE TABLE IF NOT EXISTS `x_sendrecord` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `customerid` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `orderId` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sendcontent` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mname` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `wname` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `targetdate` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `isdelete` int(11) DEFAULT NULL,
  `sendtime` datetime DEFAULT NULL,
  `issuccess` int(11) DEFAULT NULL,
  `sendstyle` int(11) DEFAULT NULL,
  `sendman` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `currentfc` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='发包记录';

-- Dumping data for table erds_sx_sp.x_sendrecord: ~0 rows (大约)
DELETE FROM `x_sendrecord`;
/*!40000 ALTER TABLE `x_sendrecord` DISABLE KEYS */;
/*!40000 ALTER TABLE `x_sendrecord` ENABLE KEYS */;

-- Dumping structure for table erds_sx_sp.x_shortkeys
DROP TABLE IF EXISTS `x_shortkeys`;
CREATE TABLE IF NOT EXISTS `x_shortkeys` (
  `keyname` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `keyvalue` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table erds_sx_sp.x_shortkeys: ~92 rows (大约)
DELETE FROM `x_shortkeys`;
/*!40000 ALTER TABLE `x_shortkeys` DISABLE KEYS */;
INSERT INTO `x_shortkeys` (`keyname`, `keyvalue`) VALUES
	('BrowserFullCKey', 'Control'),
	('BrowserFullKey', 'S'),
	('BrowserAllCKey', 'Control'),
	('BrowserAllKey', 'V'),
	('PreCKey', ''),
	('PreKey', 'Left'),
	('FirstCKey', NULL),
	('FirstKey', 'Up'),
	('NextCKey', NULL),
	('NextKey', 'Right'),
	('LastCKey', NULL),
	('LastKey', 'Down'),
	('ConsumeCKey', 'Alt'),
	('ConsumeKey', 'C'),
	('PrintSelPicCKey', 'Control'),
	('PrintSelPicKey', 'F3'),
	('PrintProductPicCKey', 'Control'),
	('PrintProductPicKey', 'M'),
	('PrintSelNoPicCKey', 'Alt'),
	('PrintSelNoPicKey', 'X'),
	('PrintProductNoPicCKey', 'Control'),
	('PrintProductNoPicKey', 'F6'),
	('FlagPicCKey', 'Control'),
	('FlagPicKey', 'F9'),
	('RemarkArea5CKey', ''),
	('RemarkArea5Key', 'F4'),
	('ProportionAreaCKey', ''),
	('ProportionAreaKey', 'F9'),
	('RemarkArea6CKey', ''),
	('RemarkArea6Key', 'F5'),
	('ChanPinRCKey', 'Shift'),
	('ChanPinRKey', 'C'),
	('ThreeAreaCKey', ''),
	('ThreeAreaKey', 'F7'),
	('SendPackageTimeCKey', ''),
	('SendPackageTimeKey', 'F10'),
	('SelectMenuCKey', NULL),
	('SelectMenuKey', 'F2'),
	('PicSelectingCKey', NULL),
	('PicSelectingKey', 'Space'),
	('LikeCKey', 'Control'),
	('LikeKey', 'Q'),
	('Like2CKey', 'Control'),
	('Like2Key', 'F10'),
	('UnLikeCKey', 'Control'),
	('UnLikeKey', 'D'),
	('UnLike2CKey', 'Shift'),
	('UnLike2Key', 'V'),
	('PrintSSelPicCKey', ''),
	('PrintSSelPicKey', 'F11'),
	('PrintSSelNoPicCKey', 'Control'),
	('PrintSSelNoPicKey', 'G'),
	('BrowserStyleCKey', ''),
	('BrowserStyleKey', 'F8'),
	('OrderCKey', 'Control'),
	('OrderKey', 'F11'),
	('SelectInfoCKey', NULL),
	('SelectInfoKey', 'F12'),
	('UnorderCKey', 'Control'),
	('UnorderKey', 'X'),
	('ZoomoutCKey', NULL),
	('ZoomoutKey', 'OemMinus'),
	('ZoominCKey', NULL),
	('ZoominKey', 'Oemplus'),
	('SelectVisbleCKey', 'Alt'),
	('SelectVisbleKey', 'Z'),
	('OrderByTimeCKey', 'Control'),
	('OrderByTimeKey', 'F12'),
	('ProVisbleCKey', 'Control'),
	('ProVisbleKey', 'P'),
	('ChangeWorkSCKey', 'Shift'),
	('ChangeWorkSKey', 'Y'),
	('ChangeWorkAllCKey', 'Control'),
	('ChangeWorkAllKey', 'W'),
	('SpecialCKey', ''),
	('SpecialKey', 'S'),
	('LikeOrNoCKey', 'Control'),
	('LikeOrNoKey', 'O'),
	('HandleUpCKey', 'Control'),
	('HandleUpKey', 'W'),
	('ProVisbleNCKey', 'Control'),
	('ProVisbleNKey', 'Y'),
	('ChangeWorkSBCKey', 'Shift'),
	('ChangeWorkSBKey', 'W'),
	('ChangeWorkSJCKey', 'Alt'),
	('ChangeWorkSJKey', 'J'),
	('LikeOrNoNCKey', 'Control'),
	('LikeOrNoNKey', 'I'),
	('PlayMP4CKey', 'Alt'),
	('PlayMP4Key', 'M'),
	('PlayQDHCKey', 'Alt'),
	('PlayQDHKey', 'Q');
/*!40000 ALTER TABLE `x_shortkeys` ENABLE KEYS */;

-- Dumping structure for table erds_sx_sp.x_systeminit
DROP TABLE IF EXISTS `x_systeminit`;
CREATE TABLE IF NOT EXISTS `x_systeminit` (
  `isrenameori` int(11) DEFAULT NULL,
  `列 3` int(11) DEFAULT NULL,
  `xp_shopname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `newsize` int(11) DEFAULT '1200',
  `highquality` int(11) DEFAULT '0',
  `sy0` varchar(50) COLLATE utf8_unicode_ci DEFAULT '0',
  `sy1` int(11) DEFAULT '0',
  `sy2` varchar(50) COLLATE utf8_unicode_ci DEFAULT '0',
  `sj0` varchar(50) COLLATE utf8_unicode_ci DEFAULT '1',
  `sj1` int(11) DEFAULT '0',
  `sj2` varchar(50) COLLATE utf8_unicode_ci DEFAULT '0',
  `ss0` varchar(50) COLLATE utf8_unicode_ci DEFAULT '2',
  `ss1` int(11) DEFAULT '0',
  `ss2` varchar(50) COLLATE utf8_unicode_ci DEFAULT '0',
  `showmoney` int(11) DEFAULT '0',
  `listshow` int(11) DEFAULT '0',
  `defaulebackcolor` int(11) DEFAULT '0',
  `isshowbrowse` int(11) DEFAULT '0',
  `service_tel` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `zipsize` int(11) DEFAULT '2400',
  `showallinfo` int(11) DEFAULT '0',
  `createdate` int(11) DEFAULT '0',
  `sendsongjian` int(11) DEFAULT '1',
  `yzcaiqie` int(11) DEFAULT '1',
  `yzpcount` int(11) DEFAULT '1',
  `yzpiccount` int(11) DEFAULT '1',
  `backpiccount` int(11) DEFAULT '0',
  `hideindex` int(11) DEFAULT '0',
  `flagover` int(11) DEFAULT '2',
  `renamerule` varchar(50) COLLATE utf8_unicode_ci DEFAULT '000',
  `jinzhirename` int(11) DEFAULT '0',
  `yzdipian` int(11) DEFAULT '0',
  `bmnamechaiban` int(11) DEFAULT '0',
  `backuppic` int(11) DEFAULT '0',
  `cloudtype` int(11) DEFAULT '0',
  `yzrccount` int(11) DEFAULT '0',
  `cachexp` int(11) DEFAULT '0',
  `fabaoyznopay` int(11) DEFAULT '1',
  `n8sp` int(11) DEFAULT '0',
  `ischkshowbrowse` int(11) DEFAULT '1',
  `isconshowbrowse` int(11) DEFAULT '1',
  `fbzhizuodan` int(11) DEFAULT '1',
  `fbzhizuodannopic` int(11) DEFAULT '0',
  `conjingyonglast` int(11) DEFAULT '1',
  `fabaofolderwphone` int(11) DEFAULT '0',
  `show2row` int(11) DEFAULT '0',
  `deleteeffect` int(11) DEFAULT '0',
  `xpzs` int(11) DEFAULT '0',
  `rczs` int(11) DEFAULT '0',
  `onlyten` int(11) DEFAULT '0',
  `sctype` int(11) DEFAULT '0',
  `scdp` int(11) DEFAULT '0',
  `wjjxp` int(11) DEFAULT '0' COMMENT '文件夹选片',
  `bfdp` int(11) DEFAULT '0' COMMENT '不自动发底片'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table erds_sx_sp.x_systeminit: ~0 rows (大约)
DELETE FROM `x_systeminit`;
/*!40000 ALTER TABLE `x_systeminit` DISABLE KEYS */;
INSERT INTO `x_systeminit` (`isrenameori`, `列 3`, `xp_shopname`, `newsize`, `highquality`, `sy0`, `sy1`, `sy2`, `sj0`, `sj1`, `sj2`, `ss0`, `ss1`, `ss2`, `showmoney`, `listshow`, `defaulebackcolor`, `isshowbrowse`, `service_tel`, `zipsize`, `showallinfo`, `createdate`, `sendsongjian`, `yzcaiqie`, `yzpcount`, `yzpiccount`, `backpiccount`, `hideindex`, `flagover`, `renamerule`, `jinzhirename`, `yzdipian`, `bmnamechaiban`, `backuppic`, `cloudtype`, `yzrccount`, `cachexp`, `fabaoyznopay`, `n8sp`, `ischkshowbrowse`, `isconshowbrowse`, `fbzhizuodan`, `fbzhizuodannopic`, `conjingyonglast`, `fabaofolderwphone`, `show2row`, `deleteeffect`, `xpzs`, `rczs`, `onlyten`, `sctype`, `scdp`, `wjjxp`, `bfdp`) VALUES
	(0, NULL, '花开有声儿童摄影', 2400, 1, '0', 0, '0', '1', 0, '0', '2', 0, '0', 0, 0, 0, 0, '', 2400, 0, 1, 0, 0, 0, 0, 1, 1, 2, '000', 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
/*!40000 ALTER TABLE `x_systeminit` ENABLE KEYS */;

-- Dumping structure for table erds_sx_sp.x_ztprice
DROP TABLE IF EXISTS `x_ztprice`;
CREATE TABLE IF NOT EXISTS `x_ztprice` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ztname` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `apprice` decimal(10,2) DEFAULT '0.00',
  `rcprice` decimal(10,2) DEFAULT '0.00',
  `dpprice` decimal(10,2) DEFAULT '0.00',
  `dk` int(11) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `ztname` (`ztname`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- Dumping data for table erds_sx_sp.x_ztprice: ~0 rows (大约)
DELETE FROM `x_ztprice`;
/*!40000 ALTER TABLE `x_ztprice` DISABLE KEYS */;
/*!40000 ALTER TABLE `x_ztprice` ENABLE KEYS */;

/*!40101 SET SQL_MODE=IFNULL(@OLD_SQL_MODE, '') */;
/*!40014 SET FOREIGN_KEY_CHECKS=IF(@OLD_FOREIGN_KEY_CHECKS IS NULL, 1, @OLD_FOREIGN_KEY_CHECKS) */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
