# ************************************************************
# Sequel Pro SQL dump
# Version 5446
#
# https://www.sequelpro.com/
# https://github.com/sequelpro/sequelpro
#
# Host: 192.168.0.11 (MySQL 5.6.37)
# Database: test
# Generation Time: 2024-09-18 08:06:54 +0000
# ************************************************************


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
SET NAMES utf8mb4;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;


# Dump of table api_app
# ------------------------------------------------------------

DROP TABLE IF EXISTS `api_app`;

CREATE TABLE `api_app` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `app_id` varchar(50) NOT NULL DEFAULT '' COMMENT '应用id',
  `app_secret` varchar(50) NOT NULL DEFAULT '' COMMENT '应用密码',
  `app_name` varchar(50) NOT NULL DEFAULT '' COMMENT '应用名称',
  `app_status` tinyint(2) NOT NULL DEFAULT '1' COMMENT '应用状态：0表示禁用，1表示启用',
  `app_type` tinyint(2) NOT NULL DEFAULT '1' COMMENT '应用类型1素玄系统应用，2第三方应用',
  `app_info` tinytext COMMENT '应用说明',
  `app_prefix` varchar(200) DEFAULT NULL COMMENT '应用前缀',
  `app_code` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `app_id` (`app_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='appId和appSecret表';

LOCK TABLES `api_app` WRITE;
/*!40000 ALTER TABLE `api_app` DISABLE KEYS */;

INSERT INTO `api_app` (`id`, `app_id`, `app_secret`, `app_name`, `app_status`, `app_type`, `app_info`, `app_prefix`, `app_code`)
VALUES
	(3,'94201193','2616fbee5a3f21efb245bff8a09aa597','管理中心APP',1,1,'','',NULL),
	(4,'44793168','2616fbee5a3f21efb245bff8a09aa597','客资系统',1,1,'客资CRM系统','',NULL),
	(5,'48383736','2616fbee5a3f21efb245bff8a09aa597','素玄ERP服务端',1,1,'',NULL,NULL),
	(6,'sx_vip','2616fbee5a3f21efb245bff8a09aa597','素玄会员系统',1,1,NULL,NULL,NULL);

/*!40000 ALTER TABLE `api_app` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table api_auth_group
# ------------------------------------------------------------

DROP TABLE IF EXISTS `api_auth_group`;

CREATE TABLE `api_auth_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL COMMENT '组名称',
  `description` varchar(50) NOT NULL COMMENT '组描述',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '组状态：为1正常，为0禁用',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='权限组';

LOCK TABLES `api_auth_group` WRITE;
/*!40000 ALTER TABLE `api_auth_group` DISABLE KEYS */;

INSERT INTO `api_auth_group` (`id`, `name`, `description`, `status`)
VALUES
	(1,'全部权限','xczv',1);

/*!40000 ALTER TABLE `api_auth_group` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table api_auth_group_access
# ------------------------------------------------------------

DROP TABLE IF EXISTS `api_auth_group_access`;

CREATE TABLE `api_auth_group_access` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `uid` mediumint(8) unsigned NOT NULL,
  `groupId` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='用户和组的对应关系';

LOCK TABLES `api_auth_group_access` WRITE;
/*!40000 ALTER TABLE `api_auth_group_access` DISABLE KEYS */;

INSERT INTO `api_auth_group_access` (`id`, `uid`, `groupId`)
VALUES
	(1,1,'1');

/*!40000 ALTER TABLE `api_auth_group_access` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table api_auth_rule
# ------------------------------------------------------------

DROP TABLE IF EXISTS `api_auth_rule`;

CREATE TABLE `api_auth_rule` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `url` char(80) NOT NULL DEFAULT '' COMMENT '规则唯一标识',
  `groupId` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '权限所属组的ID',
  `auth` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '权限数值',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态：为1正常，为0禁用',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='权限细节';

LOCK TABLES `api_auth_rule` WRITE;
/*!40000 ALTER TABLE `api_auth_rule` DISABLE KEYS */;

INSERT INTO `api_auth_rule` (`id`, `url`, `groupId`, `auth`, `status`)
VALUES
	(1,'Permission/index',3,0,1),
	(2,'Permission/add',3,0,1),
	(3,'Permission/close',3,0,1),
	(4,'Permission/open',3,0,1),
	(5,'Permission/edit',3,0,1),
	(6,'Permission/del',3,0,1),
	(7,'Permission/group',3,0,1),
	(8,'Permission/member',3,0,1),
	(9,'Permission/delMember',3,0,1),
	(10,'Permission/rule',3,0,1),
	(11,'Log/index',3,0,1),
	(12,'Log/ajaxGetIndex',3,0,1),
	(13,'Log/del',3,0,1),
	(25,'User/index',3,0,1),
	(26,'User/add',3,0,1),
	(27,'User/close',3,0,1),
	(28,'User/open',3,0,1),
	(29,'User/del',3,0,1),
	(31,'App/index',3,0,1),
	(32,'App/edit',3,0,1),
	(33,'App/add',3,0,1),
	(34,'App/open',3,0,1),
	(35,'App/close',3,0,1),
	(36,'App/del',3,0,1),
	(37,'ApiManage/index',3,0,1),
	(38,'ApiManage/add',3,0,1),
	(39,'ApiManage/open',3,0,1),
	(40,'ApiManage/close',3,0,1),
	(41,'ApiManage/edit',3,0,1),
	(42,'ApiManage/del',3,0,1),
	(43,'FieldsManage/response',3,0,1),
	(44,'FieldsManage/request',3,0,1),
	(45,'FieldsManage/add',3,0,1),
	(46,'FieldsManage/edit',3,0,1),
	(47,'FieldsManage/upload',3,0,1),
	(48,'FieldsInfoManage/index',3,0,1),
	(70,'System/regionSet',3,0,1),
	(71,'System/addRegion',3,0,1),
	(72,'System/editRegion',3,0,1),
	(73,'System/delRegion',3,0,1),
	(78,'System/capacity',3,0,1),
	(79,'System/addCapacity',3,0,1),
	(80,'System/editCapacity',3,0,1),
	(81,'System/delCapacity',3,0,1),
	(82,'System/acceptorAddress',3,0,1),
	(83,'System/addAcceptorAddress',3,0,1),
	(84,'System/editAcceptorAddress',3,0,1),
	(85,'System/delAcceptorAddress',3,0,1),
	(86,'System/template',3,0,1),
	(87,'System/addTemplate',3,0,1),
	(88,'System/editTemplate',3,0,1),
	(89,'System/delTemplate',3,0,1),
	(91,'System/searchContent',3,0,1),
	(93,'Personnel/GroupCompany',3,0,1),
	(94,'Personnel/GroupCompany',3,0,1),
	(95,'Personnel/brandClass',3,0,1),
	(96,'Personnel/addBrand',3,0,1),
	(97,'Personnel/editBrand',3,0,1),
	(98,'Personnel/delBrand',3,0,1),
	(99,'Personnel/shopSet',3,0,1),
	(100,'Personnel/editShop',3,0,1),
	(101,'Personnel/delShop',3,0,1),
	(102,'Personnel/addShop',3,0,1),
	(103,'Personnel/department',3,0,1),
	(104,'Personnel/addDepartment',3,0,1),
	(105,'Personnel/editDepartment',3,0,1),
	(106,'Personnel/staffGroup',3,0,1),
	(107,'Personnel/addGroup',3,0,1),
	(108,'Personnel/editGroup',3,0,1),
	(109,'Personnel/delGroup',3,0,1),
	(110,'Personnel/position',3,0,1),
	(111,'Personnel/addPosition',3,0,1),
	(112,'Personnel/editPosition',3,0,1),
	(113,'Personnel/delPosition',3,0,1),
	(114,'Personnel/zhijiSet',3,0,1),
	(115,'Personnel/addZhiji',3,0,1),
	(116,'Personnel/editZhiji',3,0,1),
	(117,'Personnel/delZhiji',3,0,1),
	(118,'Personnel/staff',3,0,1),
	(119,'Personnel/addStaff',3,0,1),
	(120,'Personnel/editStaff',3,0,1),
	(121,'Personnel/delStaff',3,0,1),
	(122,'Personnel/searchShop',3,0,1),
	(123,'Personnel/searchDepartment',3,0,1),
	(134,'Index/index',3,0,1),
	(135,'2',3,0,1),
	(136,'7',3,0,1),
	(137,'91',3,0,1),
	(138,'System/globalSet',3,0,1),
	(140,'50',3,0,1),
	(141,'Personnel/delDepartment',3,0,1),
	(142,'Personnel/brandShop',3,0,1),
	(144,'Index/welcome',4,0,1),
	(145,'Index/index',4,0,1),
	(146,'50',4,0,1),
	(147,'Personnel/position',4,0,1),
	(148,'Personnel/addPosition',4,0,1),
	(149,'Personnel/editPosition',4,0,1),
	(150,'Personnel/delPosition',4,0,1),
	(151,'Personnel/zhijiSet',4,0,1),
	(152,'Personnel/addZhiji',4,0,1),
	(153,'Personnel/editZhiji',4,0,1),
	(154,'Personnel/delZhiji',4,0,1),
	(155,'Personnel/staff',4,0,1),
	(156,'Personnel/addStaff',4,0,1),
	(157,'Personnel/editStaff',4,0,1),
	(158,'Personnel/delStaff',4,0,1),
	(159,'Personnel/searchShop',4,0,1),
	(160,'Personnel/searchDepartment',4,0,1),
	(161,'Personnel/shopSet',4,0,1),
	(162,'Personnel/editShop',4,0,1),
	(163,'Personnel/delShop',4,0,1),
	(164,'Personnel/addShop',4,0,1),
	(165,'Personnel/department',4,0,1),
	(166,'Personnel/addDepartment',4,0,1),
	(167,'Personnel/editDepartment',4,0,1),
	(168,'Personnel/delDepartment',4,0,1),
	(169,'Personnel/brandShop',4,0,1),
	(170,'78',5,0,1),
	(171,'Channel/channelClass',5,0,1),
	(172,'Channel/addChannel',5,0,1),
	(173,'Channel/editChannel',5,0,1),
	(174,'Channel/delChannel',5,0,1),
	(175,'Channel/channelInfo',5,0,1),
	(176,'Channel/addChannelInfo',5,0,1),
	(177,'Channel/editChannelInfo',5,0,1),
	(178,'Channel/delChannelInfo',5,0,1),
	(179,'System/accessModel',5,0,1),
	(180,'System/addAccess',5,0,1),
	(181,'System/editAccess',5,0,1),
	(182,'System/delAccess',5,0,1),
	(186,'91',6,0,1),
	(187,'System/cusSource',6,0,1),
	(188,'System/addCusSource',6,0,1),
	(189,'System/editCusSource',6,0,1),
	(190,'System/delCusSource',6,0,1),
	(191,'System/accessModel',6,0,1),
	(192,'System/addAccess',6,0,1),
	(193,'System/editAccess',6,0,1),
	(194,'System/delAccess',6,0,1),
	(195,'System/regionSet',6,0,1),
	(196,'System/addRegion',6,0,1),
	(197,'System/editRegion',6,0,1),
	(198,'System/delRegion',6,0,1),
	(199,'78',6,0,1),
	(200,'Channel/channelClass',6,0,1),
	(201,'Channel/addChannel',6,0,1),
	(202,'Channel/editChannel',6,0,1),
	(203,'Channel/delChannel',6,0,1),
	(204,'Channel/channelInfo',6,0,1),
	(205,'Channel/addChannelInfo',6,0,1),
	(206,'Channel/editChannelInfo',6,0,1),
	(207,'Channel/delChannelInfo',6,0,1),
	(217,'Personnel/staff',7,0,1),
	(218,'Personnel/addStaff',7,0,1),
	(219,'Personnel/editStaff',7,0,1),
	(220,'Personnel/delStaff',7,0,1),
	(221,'Personnel/searchShop',7,0,1),
	(222,'Personnel/searchDepartment',7,0,1),
	(224,'7',8,0,1),
	(225,'App/index',8,0,1),
	(226,'App/edit',8,0,1),
	(227,'App/add',8,0,1),
	(228,'App/open',8,0,1),
	(229,'App/close',8,0,1),
	(230,'App/del',8,0,1),
	(231,'ApiManage/index',8,0,1),
	(232,'ApiManage/add',8,0,1),
	(233,'ApiManage/open',8,0,1),
	(234,'ApiManage/close',8,0,1),
	(235,'ApiManage/edit',8,0,1),
	(236,'ApiManage/del',8,0,1),
	(237,'FieldsManage/response',8,0,1),
	(238,'FieldsManage/request',8,0,1),
	(239,'FieldsManage/add',8,0,1),
	(240,'FieldsManage/edit',8,0,1),
	(241,'FieldsManage/upload',8,0,1),
	(242,'FieldsInfoManage/index',8,0,1),
	(243,'91',8,0,1),
	(244,'System/template',8,0,1),
	(245,'System/addTemplate',8,0,1),
	(246,'System/editTemplate',8,0,1),
	(247,'System/delTemplate',8,0,1),
	(248,'System/globalSet',8,0,1),
	(249,'System/searchContent',8,0,1),
	(250,'50',8,0,1),
	(251,'Personnel/brandClass',8,0,1),
	(252,'Personnel/addBrand',8,0,1),
	(253,'Personnel/editBrand',8,0,1),
	(254,'Personnel/delBrand',8,0,1),
	(255,'50',7,0,1),
	(256,'Personnel/shopSet',7,0,1),
	(257,'Personnel/editShop',7,0,1),
	(258,'Personnel/delShop',7,0,1),
	(259,'Personnel/addShop',7,0,1),
	(260,'Personnel/department',7,0,1),
	(261,'Personnel/addDepartment',7,0,1),
	(262,'Personnel/editDepartment',7,0,1),
	(263,'Personnel/delDepartment',7,0,1),
	(264,'Personnel/brandShop',7,0,1),
	(265,'personnel/batchSet',7,0,1),
	(266,'personnel/doBatch',7,0,1),
	(267,'personnel/search_positon',7,0,1),
	(268,'Personnel/position',7,0,1),
	(269,'Personnel/addPosition',7,0,1),
	(270,'Personnel/editPosition',7,0,1),
	(271,'Personnel/delPosition',7,0,1),
	(272,'personnel/copyPosition',7,0,1),
	(273,'personnel/doCopy',7,0,1),
	(278,'Personnel/workTypeLevel',3,0,1),
	(279,'Personnel/addWorkLevel',3,0,1),
	(280,'Personnel/addWorkLevel',3,0,1),
	(281,'Personnel/editWorkLevel',3,0,1),
	(282,'Personnel/editWorkLevel',3,0,1),
	(283,'Personnel/workTypeLevel',3,0,1),
	(284,'Register/leaveOffice',3,0,1),
	(285,'Register/addLeave',3,0,1),
	(286,'Register/editLeave',3,0,1),
	(287,'Register/positionChange',3,0,1),
	(288,'Register/addChange',3,0,1),
	(289,'Register/recruitmentApply',3,0,1),
	(290,'Register/addRecruitment',3,0,1),
	(291,'Register/editRecruitment',3,0,1),
	(292,'Register/delRecruitment',3,0,1),
	(293,'personnel/leaveStaff',3,0,1),
	(294,'personnel/batchSet',3,0,1),
	(295,'personnel/doBatch',3,0,1),
	(296,'personnel/search_positon',3,0,1),
	(297,'personnel/copyPosition',3,0,1),
	(298,'personnel/doCopy',3,0,1),
	(301,'System/acl',3,0,1),
	(302,'System/acladd',3,0,1),
	(303,'System/acldel',3,0,1),
	(304,'System/acltoken',3,0,1),
	(305,'System/acltokenadd',3,0,1),
	(306,'System/acltokendel',3,0,1),
	(307,'System/aclstatus',3,0,1),
	(317,'Index/index',7,0,1),
	(318,'System/getOpenid',7,0,1),
	(319,'System/serverValid',7,0,1),
	(320,'System/serverValid',7,0,1),
	(321,'System/serverValid',7,0,1),
	(322,'Personnel/getShopCode',7,0,1),
	(323,'2',7,0,1),
	(330,'System/passwordSet',7,0,1),
	(331,'Sms/Account',7,0,1),
	(332,'User/index',7,0,1),
	(333,'User/add',7,0,1),
	(334,'User/close',7,0,1),
	(335,'User/open',7,0,1),
	(336,'User/del',7,0,1),
	(337,'System/acl',7,0,1),
	(338,'System/acladd',7,0,1),
	(339,'System/acldel',7,0,1),
	(340,'System/acltoken',7,0,1),
	(341,'System/acltokenadd',7,0,1),
	(342,'System/acltokendel',7,0,1),
	(343,'System/aclstatus',7,0,1),
	(347,'Permission/index',7,0,1),
	(348,'Permission/add',7,0,1),
	(349,'Permission/close',7,0,1),
	(350,'Permission/open',7,0,1),
	(351,'Permission/edit',7,0,1),
	(352,'Permission/del',7,0,1),
	(353,'Permission/group',7,0,1),
	(354,'Permission/member',7,0,1),
	(355,'Permission/delMember',7,0,1),
	(356,'Permission/rule',7,0,1),
	(357,'Log/index',7,0,1),
	(358,'Log/ajaxGetIndex',7,0,1),
	(359,'Log/del',7,0,1),
	(361,'sms/getBalance',7,0,1),
	(362,'system/updateServerValid',7,0,1),
	(379,'Log/ajaxGetIndex',8,0,1),
	(380,'Log/del',8,0,1);

/*!40000 ALTER TABLE `api_auth_rule` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table api_fields
# ------------------------------------------------------------

DROP TABLE IF EXISTS `api_fields`;

CREATE TABLE `api_fields` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `fieldName` varchar(50) NOT NULL DEFAULT '' COMMENT '字段名称',
  `hash` varchar(50) NOT NULL DEFAULT '' COMMENT '对应接口的唯一标识',
  `dataType` tinyint(2) NOT NULL DEFAULT '0' COMMENT '数据类型，来源于DataType类库',
  `default` varchar(500) NOT NULL DEFAULT '' COMMENT '默认值',
  `isMust` tinyint(2) NOT NULL DEFAULT '0' COMMENT '是否必须 0为不必须，1为必须',
  `range` varchar(500) NOT NULL DEFAULT '' COMMENT '范围，Json字符串，根据数据类型有不一样的含义',
  `info` varchar(500) NOT NULL DEFAULT '' COMMENT '字段说明',
  `type` tinyint(2) NOT NULL DEFAULT '0' COMMENT '字段用处：0为request，1为response',
  `showName` varchar(50) NOT NULL DEFAULT '' COMMENT 'wiki显示用字段',
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='用于保存各个API的字段规则';

LOCK TABLES `api_fields` WRITE;
/*!40000 ALTER TABLE `api_fields` DISABLE KEYS */;

INSERT INTO `api_fields` (`id`, `fieldName`, `hash`, `dataType`, `default`, `isMust`, `range`, `info`, `type`, `showName`)
VALUES
	(1,'aaa','',8,'123123',1,'fsdf','sf',0,'aaa'),
	(2,'sdf','',1,'asdf',1,'','',0,'sdf'),
	(3,'123','',1,'`12',1,'`12','',0,'123'),
	(10,'ergerger','59ea0cd052201',1,'324234',0,'2342342','34234',1,'ergerger'),
	(11,'username','59eb02fb401b1',2,'',1,'test','我是说明\n',0,'username'),
	(12,'password','59eb02fb401b1',2,'',1,'','密码',0,'password'),
	(13,'username','59eb2c9d9b723',2,'',1,'','用于登录的用户名，可以是手机号，或staff表内的登录名。',0,'username'),
	(14,'password','59eb2c9d9b723',2,'',1,'','登录密码',0,'password'),
	(16,'code','59eb2c9d9b723',1,'200',1,'','返回200表示成功。其他为失败',1,'code'),
	(17,'staffid','59eb382d6af16',1,'',1,'','',0,'staffid'),
	(18,'username','59ec9360b6861',2,'',1,'','用户名',0,'username'),
	(19,'password','59ec9360b6861',2,'',1,'','password',0,'password'),
	(20,'username','59f15d141e7e2',2,'',1,'','',0,'username'),
	(21,'oldpwd','59f15d141e7e2',2,'',1,'','',0,'oldpwd'),
	(22,'newpwd','59f15d141e7e2',2,'',1,'','新密码',0,'newpwd'),
	(23,'staffname','59f2e9fb5f863',2,'',1,'','员工名',0,'staffname'),
	(24,'password','59f2e9fb5f863',2,'',1,'','密码',0,'password'),
	(26,'staff_id','59f424811d52f',1,'',1,'','员工id',0,'staff_id'),
	(28,'staff_id','59f44a14c3cae',1,'',1,'','员工id',0,'staff_id'),
	(29,'oldPassword','59f44a14c3cae',2,'',1,'','旧密码',0,'oldPassword'),
	(30,'newPassword','59f44a14c3cae',2,'',1,'','新密码',0,'newPassword'),
	(32,'staff_id','59f933a395abe',1,'5',1,'','',0,'staff_id'),
	(33,'group_name','59f95e5ab44ef',2,'重案六组',1,'','组名',0,'group_name'),
	(34,'staff_id','59f95e5ab44ef',1,'5',1,'','自己的id，查询时排除此条',0,'staff_id'),
	(35,'name','59fad7a50fde8',1,'',1,'','需查询的品牌名或者店面名',0,'name'),
	(36,'type','59fad7a50fde8',1,'',1,'','1为品牌，2为店面',0,'type'),
	(37,'id','59fd885ed3628',1,'',0,'','',0,'id'),
	(38,'id','59fd5f0792e10',1,'',0,'','',0,'id'),
	(39,'accessmodel','59fd5f0792e10',2,'',0,'','',0,'accessmodel'),
	(40,'shop_name','59fd5f0792e10',2,'',0,'','',0,'shop_name'),
	(41,'id','59fd5e729e5a8',1,'',0,'','',0,'id'),
	(42,'id','59fd5f6c1d340',1,'',0,'','',0,'id'),
	(43,'id','59fd5fa926b98',1,'',0,'','',0,'id'),
	(44,'id','59fd5ec462c88',1,'',0,'','',0,'id'),
	(45,'id','59fd58574204a',1,'',0,'','',0,'id'),
	(46,'id','5a004e9c3e030',1,'',0,'','',0,'id'),
	(47,'id','5a00506445948',1,'',0,'','',0,'id'),
	(48,'shop_name','5a005e0038270',2,'',0,'','店面名称',0,'shop_name'),
	(49,'shop_code','5a005e0038270',2,'',0,'','店面识别码',0,'shop_code'),
	(50,'brandclass','5a005e0038270',2,'',0,'','所属品牌（事业部）',0,'brandclass'),
	(51,'staffname','5a01766b4a3dd',2,'',0,'','员工名字',0,'staffname'),
	(52,'staffnumber','5a01766b4a3dd',2,'',0,'','员工编号',0,'staffnumber'),
	(53,'sex','5a01766b4a3dd',2,'',0,'','性别',0,'sex'),
	(54,'shop_name','5a01766b4a3dd',2,'',0,'','所属店面，查询同一店面员工信息',0,'shop_name'),
	(55,'shop_code','5a01766b4a3dd',2,'',0,'','所属店面编号',0,'shop_code'),
	(56,'id','5a01766b4a3dd',1,'',0,'','员工id，若为批量查询，id之间以逗号隔开',0,'id'),
	(57,'shop_code','5a02666c9935d',2,'5555555555',1,'','商铺编号',0,'shop_code'),
	(58,'open_id','5a0294f3f243e',2,'5555',1,'','',0,'open_id'),
	(59,'staffname','5a029ee140dba',2,'王振亚',1,'','员工名',0,'staffname'),
	(60,'password','5a029ee140dba',2,'123456',1,'','密码',0,'password'),
	(61,'open_id','5a029ee140dba',2,'5555',1,'','',0,'open_id'),
	(62,'shop_code','5a00506445948',2,'',0,'','',0,'shop_code'),
	(63,'shop_name','5a00506445948',2,'',0,'','',0,'shop_name'),
	(64,'id','5a08fbe736447',1,'5',1,'','员工id',0,'id'),
	(65,'status','5a08fbe736447',1,'1',1,'','状态：1：在线；2：忙碌；3：离线',0,'status'),
	(66,'five','59f2e9fb5f863',1,'0',0,'','5天自动登录',0,'five'),
	(70,'shop_code','5a0a7bc01da07',2,'5555555555',1,'','shop_code',0,'shop_code'),
	(71,'app_name','5a0a9ddc8f9d9',2,'',1,'','当前安装的应用名称',0,'app_name'),
	(72,'app_id','5a0a9ddc8f9d9',2,'',1,'','应用的APP代码，即sx_crm sc_erp等。相同应用代码，只能安装一个。',0,'app_id'),
	(73,'app_code','5a0a9ddc8f9d9',2,'',1,'','产品码，在应用安装时，录入的，应用需用此码云端验证完成后，再调用本接口进行安装注册',0,'app_code'),
	(74,'app_prefix','5a0a9ddc8f9d9',2,'',1,'','应用访问前缀，用户调用时，只需要在此前缀后加接口hash值即可。',0,'app_prefix'),
	(75,'app_info','5a0a9ddc8f9d9',2,'',0,'','APP的备注信息，用于说明APP的使用范围及作用等。',0,'app_info'),
	(76,'shop_code','59fd58574204a',2,'',0,'','店面识别码',0,'shop_code'),
	(77,'shop_code','5a004e9c3e030',2,'',0,'','店面识别码',0,'shop_code'),
	(78,'shop_code','59fd5e729e5a8',2,'',0,'','店面识别码',0,'shop_code'),
	(79,'shop_code','59fd5ec462c88',2,'',0,'','店面识别码',0,'shop_code'),
	(80,'shop_code','59fd5f0792e10',2,'',0,'','店面识别码',0,'shop_code'),
	(81,'shop_code','59fd5f6c1d340',2,'',0,'','店面识别码',0,'shop_code'),
	(82,'shop_code','59fd5fa926b98',2,'',0,'','',0,'shop_code'),
	(83,'id','5a0aef152b750',1,'',0,'','',0,'id'),
	(84,'shop_code','5a0aef152b750',2,'',0,'','店面识别码',0,'shop_code'),
	(85,'id','5a0b96b65c111',1,'',0,'','',0,'id'),
	(87,'shop_code','5a0a624728618',1,'0',1,'','',0,'shop_code'),
	(88,'shop_code','5a0c42f43e986',2,'',0,'','shop_code',0,'shop_code'),
	(89,'shop_code','5a0c43da3e99a',2,'',0,'','店面识别码',0,'shop_code'),
	(90,'code','5a0e5f4ced930',2,'',1,'','跳转管理中心后，回跳时，传的code',0,'code'),
	(92,'qr_code','5a1027da4e9c1',2,'',0,'','如果传入qr_code这个字段，则返回当前这个CODE的基本信息，\n其中：\nstate:\n空或init表示初始状态\nscaned:已扫码（需要扫码者预操作）\nlogined:已登录',0,'qr_code'),
	(93,'code','5a125fdfc4f6b',2,'',1,'','',0,'code'),
	(94,'shop_code','5a14dd1d722a6',2,'',0,'','店面识别码',0,'shop_code'),
	(95,'id','5a14dd1d722a6',1,'',0,'','',0,'id'),
	(96,'shop_code','5a14de25a68f0',2,'',0,'','店面识别码',0,'shop_code'),
	(97,'id','5a14de25a68f0',1,'',0,'','',0,'id'),
	(98,'shop_code','5a14de993bb90',2,'',0,'','',0,'shop_code'),
	(99,'id','5a14de993bb90',1,'',0,'','',0,'id'),
	(100,'shop_code','5a14dec689d91',2,'',0,'','',0,'shop_code'),
	(101,'id','5a14dec689d91',1,'',0,'','',0,'id'),
	(102,'shop_code','5a14dfc86bf72',2,'',0,'','',0,'shop_code'),
	(103,'id','5a14dfc86bf72',1,'',0,'','',0,'id'),
	(104,'shop_code','5a14e013b447a',2,'',0,'','',0,'shop_code'),
	(105,'id','5a14e013b447a',1,'',0,'','',0,'id'),
	(106,'shop_code','5a1510583e3a5',2,'',1,'','店面识别码',0,'shop_code'),
	(107,'work_type','5a1510583e3a5',1,'',0,'','1：门市 ，2：礼服，3：拍照，4：摄影助理，5：灯光师，6：选片，7：化妆，8：取件，9：美编，10：调色，11：设计，12：修片，13：沟通，14：收款，15：录影，16：司机，17：记录，18：邀约，19：推广，20：网销，21：电放',0,'work_type'),
	(108,'department_name','5a18d69aefed1',2,'电联部',1,'','部门名称',0,'department_name'),
	(109,'staff_id','5a18e3fa516a1',2,'1,5,6',1,'','staff_id数组或字符串',0,'staff_id'),
	(110,'group_id','5a18f958756dc',1,'1',1,'','分组id',0,'group_id'),
	(111,'group_name','5a18f958756dc',2,'',1,'','小组名称',0,'group_name'),
	(112,'id','5a18f958756dc',1,'',1,'','要修改的员工id字符串或数组',0,'id'),
	(113,'staffid','5a1911b6693e3',2,'',1,'','',0,'staffid'),
	(114,'staffname','5a1911b6693e3',2,'',1,'','',0,'staffname'),
	(115,'password','5a1911b6693e3',2,'',1,'','',0,'password'),
	(116,'id','5a19201a33c20',1,'',0,'','员工编号',0,'id'),
	(117,'staffname','5a19201a33c20',2,'',0,'','员工名字',0,'staffname'),
	(118,'staffnumber','5a19201a33c20',2,'',0,'','员工编号',0,'staffnumber'),
	(119,'brandclass','5a19201a33c20',2,'',0,'','品牌名称',0,'brandclass'),
	(120,'shop_name','5a19201a33c20',2,'',0,'','店面名称',0,'shop_name'),
	(121,'shop_code','5a19201a33c20',2,'',0,'','店面识别码',0,'shop_code'),
	(122,'department_name','5a19201a33c20',1,'',0,'','部门名称',0,'department_name'),
	(123,'position_name','5a19201a33c20',2,'',0,'','岗位名称',0,'position_name'),
	(124,'telephone','5a01766b4a3dd',2,'',0,'','手机号',0,'telephone'),
	(125,'brandclass','5a01766b4a3dd',2,'',0,'','品牌',0,'brandclass'),
	(126,'department_name','5a01766b4a3dd',2,'',0,'','部门名称',0,'department_name'),
	(127,'position_name','5a01766b4a3dd',2,'',0,'','岗位名称',0,'position_name'),
	(128,'department_id','5a0a624728618',2,'',0,'','店下的部门名称',0,'department_id'),
	(129,'position_id','5a0a624728618',2,'',0,'','店下的职位名称',0,'position_id'),
	(130,'mobile','5a17b86088f1a',2,'',1,'','手机号，支持逗号分隔的多个手机号',0,'mobile'),
	(131,'content','5a17b86088f1a',2,'',1,'','内容，必须符合模板要求，可以签名也可以不带签名。',0,'content'),
	(132,'send_time','5a17b86088f1a',1,'',0,'','发送时间，发果是立即发送不需要，格式：2017-01-01 15:22:56',0,'send_time'),
	(133,'shop_code','5a17b86088f1a',2,'',0,'','调用短信的门店CODE，如果不传，取配置内默认第一个配置进行发送。传的话，取门店，品牌，集团，任意一个有配置的',0,'shop_code'),
	(134,'telephone','5a1cb7e65cb5f',1,'13515303738',1,'','手机号',0,'telephone'),
	(135,'password','5a1cb7e65cb5f',2,'',1,'','密码',0,'password'),
	(136,'department_id','5a0e6f272bb38',1,'',1,'','部门id',0,'department_id'),
	(137,'department_id','5a1fa8feacda0',1,'',1,'','部门id',0,'department_id'),
	(138,'staffname','5a221a6621364',2,'',0,'','员工登录名，与员工手机号选填一项即可。',0,'staffname'),
	(139,'telphone','5a221a6621364',2,'',0,'','员工手机号,与员工登录名选填一项即可。',0,'telphone'),
	(140,'password','5a221a6621364',1,'',1,'','员工登录密码',0,'password'),
	(141,'staffname','5a221c9548d47',2,'',0,'','',0,'staffname'),
	(142,'telephone','5a221c9548d47',2,'',0,'','',0,'telephone'),
	(143,'password','5a221c9548d47',2,'',1,'','',0,'password'),
	(144,'staffname','5a22380ec9a63',2,'',0,'','',0,'staffname'),
	(145,'telephone','5a22380ec9a63',2,'',0,'','',0,'telephone'),
	(146,'password','5a22380ec9a63',2,'',1,'','',0,'password'),
	(147,'open_id','5a22380ec9a63',2,'',1,'','',0,'open_id'),
	(148,'staffname','5a2239cf24883',2,'',0,'','',0,'staffname'),
	(149,'telephone','5a2239cf24883',2,'',0,'','',0,'telephone'),
	(150,'password','5a2239cf24883',2,'',1,'','',0,'password'),
	(151,'open_id','5a2239cf24883',2,'',1,'','',0,'open_id'),
	(153,'qr_code','5a260b53c2907',2,'',0,'','如果传入qr_code这个字段，则返回当前这个CODE的基本信息， 其中： state: 空或init表示初始状态 scaned:已扫码（需要扫码者预操作） logined:已登录',0,'qr_code'),
	(155,'channelclass','59fd5e729e5a8',2,'微信',0,'','渠道类型',0,'channelclass'),
	(156,'id','5a2757c0a9810',1,'',0,'','',0,'id'),
	(157,'channelclass','5a2757c0a9810',1,'',0,'','渠道类型名',0,'channelclass'),
	(158,'staffname','5a254b1208166',2,'',1,'','',0,'staffname'),
	(159,'password','5a254b1208166',2,'',1,'','',0,'password'),
	(160,'five','5a254b1208166',2,'0',0,'','',0,'five'),
	(161,'open_id','5a2a39421a636',2,'',1,'','',0,'open_id'),
	(162,'shop_code','5a2a5f948c9a5',2,'',0,'','店面唯一识别码',0,'shop_code'),
	(163,'is_dig','5a005e0038270',1,'',0,'','是否是接入店',0,'is_dig'),
	(164,'openid','5a2a39b803dc2',2,'',1,'','获取到的员工的openid',0,'openid'),
	(165,'shop_code','5a574b13103b7',2,'',1,'','',0,'shop_code'),
	(166,'main_position_code','5a19201a33c20',2,'',0,'','主岗位编号,每个编号用英文单引号，如果多个编号需用英文逗号隔开',0,'main_position_code'),
	(209,'shop_code','5a5c6626eef07',2,'',0,'','交易的门店ID，如果是门店扫码，必传，线上或会员中心可以不传',0,'shop_code'),
	(210,'brand_id','5a5c6626eef07',1,'',0,'','事业部ID，会员系统或积分商城支付时需要。门店扫码支付不用传',0,'brand_id'),
	(211,'staff_id','5a5c6626eef07',1,'',0,'','如果是扫码支付，此为当前登录者的员工编号，线上或会员中心可以不传',0,'staff_id'),
	(212,'body','5a5c6626eef07',2,'',1,'','交易信息主体，传门店名称，门店支付，传：门店名称-$支付简短描述$；线上支付，传：事业部名称-在线订单支付',0,'body'),
	(213,'detail','5a5c6626eef07',2,'',0,'','交易商品描述',0,'detail'),
	(214,'total_fee','5a5c6626eef07',1,'',1,'','交易总金额，传整型，一块钱，传：100',0,'total_fee'),
	(215,'client_ip','5a5c6626eef07',1,'',0,'','客户端IP地址。',0,'client_ip'),
	(216,'trade_type','5a5c6626eef07',2,'',1,'','扫码支付，传native,APP调用，传APP，网页调用，传JSAPI',0,'trade_type'),
	(217,'order_no','5a5c6626eef07',2,'',1,'','交易单号，可通过此单号来查询交易情况，必值项，未传返回106，如果返回108，则去调用查询接口查询订单支付状态。',0,'order_no'),
	(218,'open_id','5a5c6626eef07',1,'',0,'','JSAPI支付时，必须传open_id',0,'open_id'),
	(219,'limit_pay','5a5c6626eef07',2,'',0,'','限制支付种类，中果不允许信用卡，请传：no_credit',0,'limit_pay'),
	(220,'order_no','5a5ca00c81db4',2,'',1,'','请求生成订单时的order_no',0,'order_no'),
	(221,'limit_pay','5a5da9f70d56e',2,'',0,'','限制支付种类，中果不允许信用卡，请传：no_credit',0,'limit_pay'),
	(222,'order_no','5a5da9f70d56e',2,'',1,'','交易单号，可通过此单号来查询交易情况，必值项，未传返回106，如果返回108，则去调用查询接口查询订单支付状态。',0,'order_no'),
	(223,'auth_code','5a5da9f70d56e',1,'',0,'','扫到的授权码。',0,'auth_code'),
	(224,'client_ip','5a5da9f70d56e',1,'',0,'','客户端IP地址。',0,'client_ip'),
	(225,'total_fee','5a5da9f70d56e',1,'',1,'','交易总金额，传整型，一块钱，传：100',0,'total_fee'),
	(226,'detail','5a5da9f70d56e',2,'',0,'','交易商品描述',0,'detail'),
	(227,'body','5a5da9f70d56e',2,'',1,'','交易信息主体，传门店名称，门店支付，传：门店名称-$支付简短描述$；线上支付，传：事业部名称-在线订单支付',0,'body'),
	(228,'staff_id','5a5da9f70d56e',1,'',0,'','如果是扫码支付，此为当前登录者的员工编号，线上或会员中心可以不传',0,'staff_id'),
	(229,'shop_id','5a5da9f70d56e',1,'',0,'','门店ID，门店扫码支付必传与shop_code选传一个即可',0,'shop_id'),
	(230,'shop_code','5a5da9f70d56e',2,'',0,'','交易的门店ID，如果是门店扫码，必传，线上或会员中心可以不传',0,'shop_code'),
	(231,'shop_code','5a5dbddc8fa64',2,'',0,'','交易的门店ID，如果是门店扫码，必传，线上或会员中心可以不传',0,'shop_code'),
	(232,'brand_id','5a5dbddc8fa64',1,'',0,'','事业部ID，会员系统或积分商城支付时需要。门店扫码支付不用传',0,'brand_id'),
	(233,'prepay_id','5a5dbddc8fa64',2,'',1,'','预支付ID，由创建订单接口生成',0,'prepay_id'),
	(234,'product_id','5a5c6626eef07',2,'',0,'','商品ID，如果是NATIVE扫码支付，则为必传',0,'product_id'),
	(235,'mobile','5a5df0ae0fcd5',2,'',1,'','手机号，支持逗号分隔的多个手机号',0,'mobile'),
	(236,'content','5a5df0ae0fcd5',2,'',1,'','内容，必须符合模板要求，可以签名也可以不带签名。',0,'content'),
	(237,'send_time','5a5df0ae0fcd5',1,'',0,'','发送时间，发果是立即发送不需要，格式：2017-01-01 15:22:56',0,'send_time'),
	(238,'shop_code','5a5df0ae0fcd5',2,'',0,'','',0,'shop_code'),
	(239,'product_id','5a5f015c659ee',2,'',0,'','商品ID，如果是NATIVE扫码支付，则为必传',0,'product_id'),
	(240,'limit_pay','5a5f015c659ee',2,'',0,'','限制支付种类，中果不允许信用卡，请传：no_credit',0,'limit_pay'),
	(241,'open_id','5a5f015c659ee',1,'',0,'','JSAPI支付时，必须传open_id',0,'open_id'),
	(242,'order_no','5a5f015c659ee',2,'',1,'','交易单号，可通过此单号来查询交易情况，必值项，未传返回106，如果返回108，则去调用查询接口查询订单支付状态。',0,'order_no'),
	(243,'trade_type','5a5f015c659ee',2,'',1,'','扫码支付，传native,APP调用，传APP，网页调用，传JSAPI',0,'trade_type'),
	(244,'client_ip','5a5f015c659ee',1,'',0,'','客户端IP地址。',0,'client_ip'),
	(245,'total_fee','5a5f015c659ee',1,'',1,'','交易总金额，传整型，一块钱，传：100',0,'total_fee'),
	(246,'detail','5a5f015c659ee',2,'',0,'','交易商品描述',0,'detail'),
	(247,'body','5a5f015c659ee',2,'',1,'','交易信息主体，传门店名称，门店支付，传：门店名称-$支付简短描述$；线上支付，传：事业部名称-在线订单支付',0,'body'),
	(248,'staff_id','5a5f015c659ee',1,'',0,'','如果是扫码支付，此为当前登录者的员工编号，线上或会员中心可以不传',0,'staff_id'),
	(249,'brand_id','5a5f015c659ee',1,'',0,'','事业部ID，会员系统或积分商城支付时需要。门店扫码支付不用传',0,'brand_id'),
	(250,'shop_code','5a5f015c659ee',2,'',0,'','交易的门店ID，如果是门店扫码，必传，线上或会员中心可以不传',0,'shop_code'),
	(251,'shop_code','5a5f0252c9ae7',2,'',0,'','交易的门店ID，如果是门店扫码，必传，线上或会员中心可以不传',0,'shop_code'),
	(252,'shop_id','5a5f0252c9ae7',1,'',0,'','门店ID，门店扫码支付必传与shop_code选传一个即可',0,'shop_id'),
	(253,'staff_id','5a5f0252c9ae7',1,'',0,'','如果是扫码支付，此为当前登录者的员工编号，线上或会员中心可以不传',0,'staff_id'),
	(254,'body','5a5f0252c9ae7',2,'',1,'','交易信息主体，传门店名称，门店支付，传：门店名称-$支付简短描述$；线上支付，传：事业部名称-在线订单支付',0,'body'),
	(255,'detail','5a5f0252c9ae7',2,'',0,'','交易商品描述',0,'detail'),
	(256,'total_fee','5a5f0252c9ae7',1,'',1,'','交易总金额，传整型，一块钱，传：100',0,'total_fee'),
	(257,'client_ip','5a5f0252c9ae7',1,'',0,'','客户端IP地址。',0,'client_ip'),
	(258,'auth_code','5a5f0252c9ae7',1,'',0,'','扫到的授权码。',0,'auth_code'),
	(259,'order_no','5a5f0252c9ae7',2,'',1,'','交易单号，可通过此单号来查询交易情况，必值项，未传返回106，如果返回108，则去调用查询接口查询订单支付状态。',0,'order_no'),
	(260,'limit_pay','5a5f0252c9ae7',2,'',0,'','限制支付种类，中果不允许信用卡，请传：no_credit',0,'limit_pay'),
	(261,'order_no','5a5f01acab982',2,'',1,'','请求生成订单时的order_no（ERP 的唯一流水号+店面简码）',0,'order_no'),
	(262,'brandclass_id','5a60436d631a4',1,'',0,'','品牌id',0,'brandclass_id'),
	(263,'shop_code','5a62dcd5c7e40',2,'',1,'','店面唯一识别码',0,'shop_code'),
	(264,'content','5a4b81bc26160',1,'',0,'','',0,'content'),
	(265,'group_company_name','5a6978bb82027',2,'',0,'','集团名称',0,'group_company_name'),
	(266,'id','5a6978bb82027',1,'',0,'','集团id',0,'id'),
	(268,'shop_code','5a706286930ce',2,'',1,'','店面识别码',0,'shop_code'),
	(269,'shop_code','5a7076a6ccfaa',2,'',1,'','店面识别码',0,'shop_code'),
	(270,'department_id','5a01766b4a3dd',1,'',0,'','部门id',0,'department_id'),
	(271,'id','5a704aa96e503',1,'',0,'','省id',0,'id'),
	(272,'name','5a704aa96e503',2,'',0,'','省份',0,'name'),
	(274,'grade_type','5a01766b4a3dd',1,'',0,'','等级，1集团，2品牌，3店面，4部门',0,'grade_type'),
	(275,'main_position_code','5a01766b4a3dd',2,'',0,'','主岗位标识',0,'main_position_code'),
	(276,'is_photo','5a39fd8c6c9f7',1,'',0,'','是否为拍照店，1是2不是',0,'is_photo'),
	(277,'shop_code','5a7424f13aa54',2,'',0,'','店面标识',0,'shop_code'),
	(278,'shop_code','5a73d4f13a9eb',2,'',0,'','店面标识',0,'shop_code'),
	(279,'brandclass_id','5a73d4f13a9eb',1,'',0,'','品牌编号',0,'brandclass_id'),
	(280,'scene','5a73d4f13a9eb',2,'',0,'','场景编号，即参数，不重复',0,'scene'),
	(281,'type','5a73d4f13a9eb',1,'',0,'','类型1永久，2临时，临时有效期为1个月',0,'type'),
	(285,'mobile','5a780e2613bb9',2,'',1,'','手机号',0,'mobile'),
	(286,'verify_code','5a780e2613bb9',2,'',1,'','验证码',0,'verify_code'),
	(287,'shop_code','5a780e2613bb9',2,'',0,'','店面识别码',0,'shop_code'),
	(288,'brand_id','5a5df0ae0fcd5',1,'',0,'','',0,'brand_id'),
	(289,'brandclass_id','5a439c7e5b8e7',2,'',0,'','',0,'brandclass_id'),
	(290,'content','5a439c7e5b8e7',2,'',1,'','',0,'content'),
	(291,'mobile','5a7bdbdaa5870',2,'',1,'','手机号',0,'mobile'),
	(292,'content','5a7bdbdaa5870',2,'',1,'','内容，必须符合模板要求，可以签名也可以不带签名。',0,'content'),
	(293,'send_time','5a7bdbdaa5870',2,'',0,'','发送时间，发果是立即发送不需要，格式：2017-01-01 15:22:56 ',0,'send_time'),
	(294,'shop_code','5a7bdbdaa5870',2,'',0,'','店面识别码',0,'shop_code'),
	(298,'staff_id','5a8fd8296f3d3',1,'',1,'','员工id',0,'staff_id'),
	(299,'vip_url','5a38840b15ba9',2,'',0,'','会员网址',0,'vip_url'),
	(300,'brand_id','5a17b86088f1a',2,'',0,'','事业部ID，用作会员发短信。',0,'brand_id'),
	(301,'belong_shop_code','5a005e0038270',2,'',0,'','归属店shop_code',0,'belong_shop_code'),
	(302,'staff_id','5aae44296a6bf',2,'',0,'','门店识别码，与品牌编码和配置号传一个即可',0,'staff_id'),
	(303,'brand_id','5aae44296a6bf',1,'',0,'','品牌编码，与门店识别码和配置号传一个即可',0,'brand_id'),
	(304,'send_config','5aae44296a6bf',2,'',0,'','配置号，与品牌编码和门店识别码传一个即可',0,'send_config'),
	(305,'staff_id','5aae46527269f',2,'',0,'','门店识别码，与品牌编码和配置号传一个即可',0,'staff_id'),
	(306,'brand_id','5aae46527269f',1,'',0,'','品牌编码，与门店识别码和配置号传一个即可',0,'brand_id'),
	(307,'send_config','5aae46527269f',2,'',0,'','配置号，与品牌编码和门店识别码传一个即可',0,'send_config'),
	(308,'staff_id','5aae460d2996e',2,'',0,'','门店识别码，与品牌编码和配置号传一个即可',0,'staff_id'),
	(309,'brand_id','5aae460d2996e',1,'',0,'','品牌编码，与门店识别码和配置号传一个即可',0,'brand_id'),
	(310,'send_config','5aae460d2996e',2,'',0,'','配置号，与品牌编码和门店识别码传一个即可',0,'send_config'),
	(311,'staff_id','5aae466ce7ddd',2,'',0,'','门店识别码，与品牌编码和配置号传一个即可',0,'staff_id'),
	(312,'brand_id','5aae466ce7ddd',1,'',0,'','品牌编码，与门店识别码和配置号传一个即可',0,'brand_id'),
	(313,'send_config','5aae466ce7ddd',2,'',0,'','配置号，与品牌编码和门店识别码传一个即可',0,'send_config'),
	(314,'send_config','5a5df0ae0fcd5',2,'',0,'','配置号，使用指定配置发短信',0,'send_config'),
	(315,'send_config','5a17b86088f1a',2,'',0,'','配置号，使用指定配置发短信',0,'send_config'),
	(317,'shop_code','5aafa4ac48058',2,'',0,'','店面唯一识别码',0,'shop_code'),
	(318,'is_marketing','5a39fd8c6c9f7',1,'',0,'','1 营销店 2 实体店',0,'is_marketing'),
	(319,'brandclass_id','5aafa4ac48058',1,'',0,'','事业部id',0,'brandclass_id'),
	(322,'brandclass_id','5a005e0038270',1,'',0,'','事业部id',0,'brandclass_id'),
	(323,'is_marketing','5a005e0038270',1,'',0,'','是否是营销店',0,'is_marketing'),
	(324,'mobile','5ab88f1fd2f00',2,'',1,'','手机号',0,'mobile'),
	(325,'mobile','5ab8b32fcc970',2,'',1,'','手机号',0,'mobile'),
	(326,'code','5ab99d8594c78',2,'',1,'','订单与签名的 唯一值',0,'code'),
	(327,'data','5ab99d8594c78',2,'',1,'','订单主要数据内容有:订单编号、客户编号、会员卡号、选片张数、销售门市、网销门市、订单总额、化妆金额、已付金额、未付金额、礼服总金额、礼服加挑金额、礼服销售金额、礼服已付金额、礼服未付金额',0,'data'),
	(328,'viewtype','5ab99d8594c78',1,'',1,'','模板名称',0,'viewtype'),
	(330,'code','5ab9a901ee228',1,'',1,'','订单对应的签名 唯一标识',0,'code'),
	(331,'type','5ab9a901ee228',1,'',1,'','返回的签名类型(1:url,0:二进制)',0,'type'),
	(333,'id','5ae01abbbc263',1,'',0,'','id',0,'id'),
	(334,'work_type','5ae01abbbc263',2,'',0,'','工作类型名称',0,'work_type'),
	(336,'brandclass_id','5a004e9c3e030',1,'',0,'','事业部id',0,'brandclass_id'),
	(337,'code','5ac3579d76bb8',1,'',1,'','订单对应的签名 唯一标识',0,'code'),
	(338,'staff_number','5af2f899164f4',2,'',0,'','员工number,多个用英文逗号隔开',0,'staff_number'),
	(339,'content','5af2f899164f4',2,'',0,'','短信内容',0,'content'),
	(340,'send_config','5af2f899164f4',2,'',0,'','短信配置',0,'send_config'),
	(341,'staffname','5af3c003b4cae',2,'',0,'','人员名字，与数据名字，编号模糊查询',0,'staffname'),
	(342,'staffnumber','5af3c003b4cae',2,'',0,'','人员编号 与数据名字，编号模糊查询',0,'staffnumber'),
	(343,'telephone','5af3c003b4cae',2,'',0,'','手机号',0,'telephone'),
	(344,'brandclass','5af3c003b4cae',2,'',0,'','事业部名称',0,'brandclass'),
	(345,'brandclass_id','5af3c003b4cae',1,'',0,'','事业部id',0,'brandclass_id'),
	(346,'shop_name','5af3c003b4cae',2,'',0,'','店',0,'shop_name'),
	(347,'shop_code','5af3c003b4cae',2,'',0,'','店',0,'shop_code'),
	(348,'department_name','5af3c003b4cae',2,'',0,'','部门名称',0,'department_name'),
	(349,'department_id','5af3c003b4cae',1,'',0,'','部门id',0,'department_id'),
	(356,'id','5af3fe7a0a668',1,'',0,'','',0,'id'),
	(357,'brandclass_id','5af3fe7a0a668',1,'',0,'','事业部ID',0,'brandclass_id'),
	(358,'id','5af40001983f0',1,'',0,'','',0,'id'),
	(359,'brandclass_id','5af40001983f0',1,'',0,'','事业部ID',0,'brandclass_id'),
	(363,'grade_type','5aff92c0762a0',1,'',1,'','部门所属：1集团，2品牌，3店面',0,'grade_type'),
	(364,'brandclass_id','5aff92c0762a0',1,'',0,'','事业部id',0,'brandclass_id'),
	(365,'shop_code','5aff92c0762a0',2,'',0,'','shop_code',0,'shop_code'),
	(366,'shop_code','5aec138a7bae9',2,'',0,'','shop_code',0,'shop_code'),
	(367,'key_words','5aec138a7bae9',2,'',0,'','手机号,员工名',0,'key_words'),
	(369,'fid','5a14de25a68f0',1,'',0,'','父级id称为fid',0,'fid'),
	(372,'type','5b20eb32badd8',1,'',1,'','类型：1岗位code，2人员编号',0,'type'),
	(373,'number','5b20eb32badd8',2,'',1,'','岗位code或人员编号',0,'number'),
	(391,'staff_id','5b33489a1ec30',1,'',1,'','员工id',0,'员工id'),
	(392,'expire','5a73d4f13a9eb',1,'',0,'','过期时间，默认60秒。以秒为单位。',0,'expire'),
	(393,'shop_code','5a39fd8c6c9f7',2,'',0,'','',0,'shop_code'),
	(394,'brandid','5ab99d8594c78',1,'',1,'','事业部id',0,'brandid'),
	(395,'id','5b3c3dc4ebca8',1,'',1,'','事业部id',0,'id'),
	(396,'brandclass','5b3c3dc4ebca8',2,'',0,'','事业部名称',0,'brandclass'),
	(397,'group_company_name','5b3c3dc4ebca8',2,'',0,'','集团',0,'group_company_name'),
	(398,'nickname','5b3c3dc4ebca8',2,'',0,'','事业部简称',0,'nickname'),
	(399,'wx_public','5b3c3dc4ebca8',2,'',0,'','公众号名称',0,'wx_public'),
	(400,'wx_appid','5b3c3dc4ebca8',2,'',0,'','公众号appid',0,'wx_appid'),
	(401,'wx_secret','5b3c3dc4ebca8',2,'',0,'','公众号秘钥secret',0,'wx_secret'),
	(402,'wx_mch_id','5b3c3dc4ebca8',2,'',0,'','商户号',0,'wx_mch_id'),
	(403,'wx_pay_key','5b3c3dc4ebca8',2,'',0,'','支付秘钥',0,'wx_pay_key'),
	(404,'vip_url','5b3c3dc4ebca8',2,'',0,'','会员网址',0,'vip_url'),
	(405,'mall_url','5b3c3dc4ebca8',2,'',0,'','商城网址',0,'mall_url'),
	(406,'sms_config','5b3c3dc4ebca8',2,'',0,'','短信配置id',0,'sms_config'),
	(407,'valid_date','5b3c3dc4ebca8',1,'',0,'','客资有效期（天数，例30）',0,'valid_date'),
	(408,'order_rule','5b3c3dc4ebca8',2,'',0,'','有效订单标准,1实收款，2占比',0,'order_rule'),
	(409,'proportion','5b3c3dc4ebca8',2,'',0,'','有效订单标准值，填写数字，如order_rule为1则为数值，order_rule为2则为数值/100（只填写数值不用处理百分比）',0,'proportion'),
	(410,'brandclass_id','5b3c5bec9ee30',1,'',1,'','brandclass_id',0,'brandclass_id'),
	(411,'id','5b3c5ccadc2a8',1,'',1,'','店id',0,'id'),
	(412,'shop_name','5b3c5ccadc2a8',2,'',0,'','店面名称',0,'shop_name'),
	(413,'shop_code','5b3c5ccadc2a8',2,'',1,'','店面code,唯一标识',0,'shop_code'),
	(414,'sn','5b3c5ccadc2a8',2,'',0,'','店面简码',0,'sn'),
	(415,'group_company_name','5b3c5ccadc2a8',2,'',0,'','集团',0,'group_company_name'),
	(416,'brandclass','5b3c5ccadc2a8',2,'',1,'','事业部名称',0,'brandclass'),
	(417,'brandclass_id','5b3c5ccadc2a8',1,'',1,'','事业部id',0,'brandclass_id'),
	(418,'prefix_number','5b3c5ccadc2a8',2,'',0,'','订单规则前缀',0,'prefix_number'),
	(419,'numberorder','5b3c5ccadc2a8',2,'',0,'','订单规则中间主要部分',0,'numberorder'),
	(420,'serial_number','5b3c5ccadc2a8',2,'',0,'','订单规则后缀',0,'serial_number'),
	(421,'shopaddress','5b3c5ccadc2a8',2,'',0,'','店面地址',0,'shopaddress'),
	(422,'wx_public','5b3c5ccadc2a8',2,'',0,'','微信公众号名称',0,'wx_public'),
	(423,'wx_appid','5b3c5ccadc2a8',2,'',0,'','微信公众号appid',0,'wx_appid'),
	(424,'wx_secret','5b3c5ccadc2a8',2,'',0,'','微信公众号秘钥secret',0,'wx_secret'),
	(425,'sms_config','5b3c5ccadc2a8',1,'',0,'','短信配置',0,'sms_config'),
	(426,'belong_shop_code','5b3c5ccadc2a8',2,'',0,'','提报客资归属店',0,'belong_shop_code'),
	(427,'belong_shop_name','5b3c5ccadc2a8',2,'',0,'','提报客资归属店',0,'belong_shop_name'),
	(428,'shop_type','5b3c5ccadc2a8',1,'',0,'','店面类型，1婚纱，2儿童，3旅拍，4艺术，5其他',0,'shop_type'),
	(429,'is_marketing','5b3c5ccadc2a8',1,'',0,'','店面分类，1电商店，2实体店，3网销店，4渠道店',0,'is_marketing'),
	(430,'is_dig','5b3c5ccadc2a8',1,'',0,'','是否深挖，1是，2否',0,'is_dig'),
	(431,'is_sk','5b3c5ccadc2a8',1,'',0,'','是否深挖',0,'is_sk'),
	(432,'is_group','5b3c5ccadc2a8',1,'',0,'','是否集团店，1是2不是',0,'is_group'),
	(433,'is_photo','5b3c5ccadc2a8',1,'',0,'','是否拍照店，1是2不是',0,'is_photo'),
	(434,'shop_code','5b3dbce7c7da8',2,'',1,'','shop_code',0,'shop_code'),
	(435,'id','5b3dbdd2964b0',1,'',1,'','部门id',0,'id'),
	(436,'department_name','5b3dbdd2964b0',2,'',0,'','部门名称',0,'department_name'),
	(437,'shop_name','5b3dbdd2964b0',2,'',0,'','店面名称',0,'shop_name'),
	(438,'shop_code','5b3dbdd2964b0',2,'',0,'','店面code',0,'shop_code'),
	(439,'group_company_name','5b3dbdd2964b0',2,'',0,'','集团',0,'group_company_name'),
	(440,'brandclass','5b3dbdd2964b0',2,'',0,'','事业部',0,'brandclass'),
	(441,'brandclass_id','5b3dbdd2964b0',1,'',0,'','事业部id',0,'brandclass_id'),
	(442,'grade_type','5b3dbdd2964b0',1,'',0,'','1直属集团 2直属事业部 3直属店面',0,'grade_type'),
	(443,'department_id','5b3dc428987d8',1,'',1,'','department_id',0,'department_id'),
	(453,'code','5b3dc4a1dc1e0',1,'',0,'','grade_type为1时 集团id，为2时事业部id，3时shop_code,4时 department_id',0,'code'),
	(454,'grade_type','5b3dc4a1dc1e0',1,'',0,'','1直属集团 2直属事业部 3直属店面 4部门',0,'grade_type'),
	(455,'content','5b3dc4a1dc1e0',2,'',0,'','json格式,多个岗位详情，包括position_name、oa_p_id、superior_position_code（直属上级岗位code）',0,'content'),
	(457,'grade_type','5b3dc56a73de8',2,'',1,'','1直属集团 2直属事业部 3直属店面 4部门',0,'grade_type'),
	(458,'id','5b3dc732048a8',1,'',1,'','人员id',0,'id'),
	(459,'staffnumber','5b3dc732048a8',2,'',0,'','staffnumber',0,'staffnumber'),
	(460,'staffname','5b3dc732048a8',2,'',0,'','staffname',0,'staffname'),
	(461,'password','5b3dc732048a8',2,'',0,'','密码（加密后）',0,'password'),
	(462,'telephone','5b3dc732048a8',2,'',0,'','手机',0,'telephone'),
	(463,'main_position_name','5b3dc732048a8',2,'',0,'','主岗位名称',0,'main_position_name'),
	(464,'main_position_code','5b3dc732048a8',2,'',0,'','主岗位code',0,'main_position_code'),
	(465,'main_position_id','5b3dc732048a8',2,'',0,'','主岗位id',0,'main_position_id'),
	(466,'position_code','5b3dc732048a8',2,'',0,'','兼职岗位，多个用英文逗号隔开',0,'position_code'),
	(467,'position_id','5b3dc732048a8',2,'',0,'','兼职岗位id，多个用英文逗号隔开',0,'position_id'),
	(468,'department_id','5b3dc732048a8',1,'',0,'','部门id',0,'department_id'),
	(469,'department_name','5b3dc732048a8',2,'',0,'','部门名称',0,'department_name'),
	(470,'shop_name','5b3dc732048a8',2,'',0,'','店面名称',0,'shop_name'),
	(471,'shop_code','5b3dc732048a8',2,'',0,'','店面code',0,'shop_code'),
	(472,'group_company_name','5b3dc732048a8',2,'',0,'','集团',0,'group_company_name'),
	(473,'brandclass','5b3dc732048a8',2,'',0,'','事业部',0,'brandclass'),
	(474,'brandclass_id','5b3dc732048a8',1,'',0,'','事业部id',0,'brandclass_id'),
	(475,'grade_type','5b3dc732048a8',1,'',0,'','1直属集团 2直属事业部 3直属店面 4店下部门',0,'grade_type'),
	(476,'work_shop','5b3dc732048a8',2,'',0,'','工作店面',0,'work_shop'),
	(477,'work_types','5b3dc732048a8',2,'',0,'','工作类型',0,'work_types'),
	(478,'staff_id','5b3dc87367e80',1,'',1,'','人员id',0,'staff_id'),
	(522,'brandclass_id','59fd58574204a',1,'',0,'','事业部id',0,'brandclass_id'),
	(523,'brandclass_id','5a14dd1d722a6',1,'',0,'','事业部id',0,'brandclass_id'),
	(524,'code','5b3dc56a73de8',2,'',1,'','grade_type为1时 集团id，为2时事业部id，3时shop_code,4时 department_id',0,'code'),
	(525,'oa_p_id','5b3dc56a73de8',2,'',1,'','oa岗位表中id，一维数组json_encode后',0,'oa_p_id'),
	(526,'work_type_level','5b3dc732048a8',2,'',0,'','工作类型id +‘_’+ 工作类型等级名称，例:1_高级门市,若没有等级则为1_（多个用英文逗号隔开）',0,'work_type_level'),
	(527,'work_type_level_id','5b3dc732048a8',2,'',0,'','工作类型id +‘_’+ 工作类型等级id，例:1_22,若没有等级则为1_（多个用英文逗号隔开）',0,'work_type_level_id'),
	(528,'entry_date','5b3dc732048a8',2,'',0,'','入职时间',0,'entry_date'),
	(529,'leave_date','5b3dc732048a8',2,'',0,'','离职时间',0,'leave_date'),
	(530,'contract_endday','5b3dc732048a8',2,'',0,'','合同到期时间',0,'contract_endday'),
	(531,'grade_type','5b4717ca97046',1,'',1,'','1直属集团 2直属事业部 3直属店面 4部门',0,'grade_type'),
	(532,'code','5b4717ca97046',2,'',0,'','grade_type为1时 集团id，为2时事业部id，3时shop_code,4时 department_id',0,'code'),
	(533,'content','5b4717ca97046',2,'',0,'','json格式,多个岗位详情，包括position_name、oa_p_id',0,'content'),
	(534,'shop_type','5a005e0038270',1,'',0,'','店面类型，1,2,3  支持,分隔',0,'shop_type'),
	(535,'brandclass_id','5a00506445948',2,'',0,'','事业部id',0,'brandclass_id'),
	(536,'brandclass_id','5a14e013b447a',2,'',0,'','事业部id',0,'brandclass_id'),
	(537,'staff_id','5b6575a339c38',1,'',1,'','员工id',0,'staff_id'),
	(538,'shop_code','5b75341456d18',2,'',1,'','店面唯一识别码',0,'shop_code'),
	(539,'work_type','5b75341456d18',1,'',1,'','工作类型编码',0,'work_type'),
	(541,'id','5b8630d8d21b8',1,'',1,'','员工id',0,'id'),
	(542,'staffnumber','5b8630d8d21b8',2,'',0,'','员工编号',0,'staffnumber'),
	(543,'staffname','5b8630d8d21b8',2,'',0,'','员工名称',0,'staffname'),
	(544,'password','5b8630d8d21b8',2,'',0,'','密码',0,'password'),
	(545,'grade_type','5b8630d8d21b8',1,'',0,'','1集团，2事业部，3店面，4店下部门',0,'grade_type'),
	(546,'group_company_name','5b8630d8d21b8',2,'',0,'','集团名',0,'group_company_name'),
	(547,'brandclass','5b8630d8d21b8',2,'',0,'','事业部',0,'brandclass'),
	(548,'brandclass_id','5b8630d8d21b8',1,'',0,'','事业部id',0,'brandclass_id'),
	(549,'shop_name','5b8630d8d21b8',2,'',0,'','店名',0,'shop_name'),
	(550,'shop_code','5b8630d8d21b8',2,'',0,'','店唯一标识码',0,'shop_code'),
	(551,'sn','5b8630d8d21b8',2,'',0,'','店简码',0,'sn'),
	(552,'department_id','5b8630d8d21b8',1,'',0,'','部门id',0,'department_id'),
	(553,'department_name','5b8630d8d21b8',2,'',0,'','部门名称',0,'department_name'),
	(554,'main_position_name','5b8630d8d21b8',2,'',0,'','主岗位名称',0,'main_position_name'),
	(555,'main_position_code','5b8630d8d21b8',2,'',0,'','主岗位标识码',0,'main_position_code'),
	(556,'position_code','5b8630d8d21b8',2,'',0,'','副岗位标识码，多个用英文逗号隔开',0,'position_code'),
	(557,'leave_date','5b8630d8d21b8',2,'',0,'','离职日期',0,'leave_date'),
	(558,'id','5b876a32ca648',1,'',1,'','员工id',0,'id'),
	(559,'group_company_name','5b876a32ca648',2,'',0,'','集团名称',0,'group_company_name'),
	(560,'wx_public','5b876a32ca648',2,'',0,'','微信公众号名称',0,'wx_public'),
	(561,'wx_appid','5b876a32ca648',2,'',0,'','微信公众号appid',0,'wx_appid'),
	(562,'wx_secret','5b876a32ca648',2,'',0,'','微信公众号secret',0,'wx_secret'),
	(563,'sms_config','5b876a32ca648',1,'',0,'','短息配置',0,'sms_config'),
	(564,'wx_mch_id','5b876a32ca648',2,'',0,'','商户号',0,'wx_mch_id'),
	(565,'wx_pay_key','5b876a32ca648',2,'',0,'','微信支付秘钥',0,'wx_pay_key'),
	(573,'get_leave','5aec138a7bae9',1,'',0,'','',0,'get_leave'),
	(574,'id','5b8a64f1c39b0',1,'',1,'','工作类型等级表主键id',0,'id'),
	(575,'level_name','5b8a64f1c39b0',2,'',0,'','等级名称',0,'level_name'),
	(576,'work_type_id','5b8a64f1c39b0',1,'',0,'','工作类型id',0,'work_type_id'),
	(577,'work_type','5b8a64f1c39b0',2,'',0,'','工作类型名称',0,'work_type'),
	(578,'sort','5b8a64f1c39b0',2,'',0,'','排序',0,'sort'),
	(579,'add_time','5b8a64f1c39b0',1,'',0,'','添加时间',0,'add_time'),
	(580,'id','5b8a655b5d4f8',1,'',1,'','工作类型等级表主键id',0,'id'),
	(581,'brandclass_id','5a37a1503264d',1,'',1,'','',0,'brandclass_id'),
	(582,'brandclass','5a0aef152b750',1,'',1,'','',0,'brandclass'),
	(583,'brandclass_id','5a0aef152b750',1,'',0,'','',0,'brandclass_id'),
	(584,'grade_type','5a0aef152b750',1,'',1,'','',0,'grade_type'),
	(588,'staff_id','5b9cac8aa21c0',1,'',1,'','员工id',0,'staff_id'),
	(589,'brandclass_id','5b9cac8aa21c0',1,'',0,'','事业部id',0,'brandclass_id'),
	(590,'shop_type','5b9cac8aa21c0',1,'',0,'','店面类型（儿童2，婚纱）',0,'shop_type'),
	(591,'staff_id','5b3ae7a95f370',1,'',1,'','',0,'staff_id'),
	(592,'token','5b3ae7a95f370',2,'',1,'','',0,'token'),
	(593,'shop_code','5bc58874c5828',2,'',1,'','店面唯一识别码，多个用英文逗号隔开',0,'shop_code'),
	(594,'work_type','5bc58874c5828',1,'',1,'','工作类型编码',0,'work_type'),
	(596,'type','5bc8702e3e056',2,'',1,'','类型',0,'type'),
	(597,'msg','5bc8702e3e056',2,'',1,'','消息',0,'msg'),
	(598,'type','5bc870ff09178',2,'',1,'','类型',0,'type'),
	(599,'msg','5bc870ff09178',2,'',1,'','消息',0,'msg'),
	(600,'staff_id','5bc870ff09178',2,'',0,'','员工id，json格式',0,'staff_id'),
	(601,'rid','5bc870ff09178',2,'',0,'','极光id，json格式',0,'rid'),
	(602,'staff_id','5bc871078bcee',1,'',1,'','员工id',0,'staff_id'),
	(603,'imgs','5bc94272b051a',2,'',1,'','图片文件信息',0,'imgs'),
	(604,'is_cover','5bc94272b051a',1,'1',1,'','同文件是否覆盖，1：覆盖；2：不覆盖',0,'is_cover'),
	(605,'img_path','5bc94294ae9c2',2,'',1,'','删除图片，支持多图片删除，逗号分隔',0,'img_path'),
	(606,'brandclass_id','5bcd7a65e1d8c',1,'',1,'','事业部id',0,'brandclass_id'),
	(607,'grade_type','5bcd7b190d812',1,'',1,'','部门所属类型',0,'grade_type'),
	(608,'brandclass_id','5bcd7b190d812',1,'',0,'','事业部id',0,'brandclass_id'),
	(609,'shop_code','5bcd7b190d812',2,'',0,'','店面识别码',0,'shop_code'),
	(610,'grade_type','5bcd7bf31b0c2',1,'',1,'','人员类型id',0,'grade_type'),
	(611,'brandclass_id','5bcd7bf31b0c2',1,'',0,'','事业部id',0,'brandclass_id'),
	(612,'shop_code','5bcd7bf31b0c2',2,'',0,'','店面识别码',0,'shop_code'),
	(613,'department_id','5bcd7bf31b0c2',1,'',0,'','部门id',0,'department_id'),
	(614,'key_words','5bcd7c794bcbd',2,'',0,'','要查询的字段',0,'key_words'),
	(621,'department','5bd27d0a93120',2,'',1,'','部门信息，json格式',0,'department'),
	(622,'position','5bd27d0a93120',2,'',1,'','岗位信息，json格式',0,'position'),
	(624,'data','5bdaed7e5e551',2,'',1,'','事业部id',0,'data'),
	(625,'data','5bdaee20b646d',2,'',1,'','部门所属类型',0,'data'),
	(626,'data','5bdaee2a462e6',2,'',1,'','事业部id',0,'data'),
	(627,'data','5bdaee35ac5ad',2,'',1,'','店面识别码',0,'data'),
	(628,'get_main','5a0e6f272bb38',1,'',0,'','1:不查看兼职； 2:查看兼职；',0,'get_main'),
	(629,'is_op4','5a39fd8c6c9f7',1,'',0,'是否为取件店，0：不是；1：是','是否为取件店，0：不是；1：是',0,'is_op4'),
	(630,'brandclass_id','5a39fd8c6c9f7',1,'',0,'','',0,'brandclass_id'),
	(631,'shop_code','5aec138a7bae9',2,'',1,'','shop_code',0,'shop_code'),
	(632,'key_words','5aec138a7bae9',2,'',1,'','手机号,员工名',0,'key_words'),
	(633,'shop_code','5aec138a7bae9',2,'',1,'','shop_code',0,'shop_code'),
	(634,'key_words','5aec138a7bae9',2,'',1,'','手机号,员工名',0,'key_words'),
	(635,'shop_code','5aec138a7bae9',2,'',1,'','shop_code',0,'shop_code'),
	(636,'key_words','5aec138a7bae9',2,'',1,'','手机号,员工名',0,'key_words'),
	(637,'shop_code','5aec138a7bae9',2,'',1,'','shop_code',0,'shop_code'),
	(638,'key_words','5aec138a7bae9',2,'',1,'','手机号,员工名',0,'key_words'),
	(639,'shop_code','5aec138a7bae9',2,'',1,'','shop_code',0,'shop_code'),
	(640,'key_words','5aec138a7bae9',2,'',1,'','手机号,员工名',0,'key_words'),
	(641,'shop_code','5aec138a7bae9',2,'',1,'','shop_code',0,'shop_code'),
	(642,'key_words','5aec138a7bae9',2,'',1,'','手机号,员工名',0,'key_words'),
	(643,'shop_code','5aec138a7bae9',2,'',1,'','shop_code',0,'shop_code'),
	(644,'key_words','5aec138a7bae9',2,'',1,'','手机号,员工名',0,'key_words'),
	(645,'shop_code','5aec138a7bae9',2,'',1,'','shop_code',0,'shop_code'),
	(646,'key_words','5aec138a7bae9',2,'',1,'','手机号,员工名',0,'key_words'),
	(647,'order_id','5c9ae4289e598',2,'',1,'','订单编号',0,'order_id'),
	(648,'brand_id','5c9ae4289e598',1,'',1,'','事业部id',0,'brand_id'),
	(649,'code','5c9ae4289e598',2,'',1,'','唯一标识',0,'code'),
	(650,'openid','5caf4eceb94bd',2,'',1,'','订单编号',0,'openid'),
	(651,'province','5a005e0038270',2,'',0,'','城市',0,'province'),
	(652,'staff_number','5cbe739c8d8d8',2,'',1,'','员工编号',0,'staff_number'),
	(653,'is_op','5cbe739c8d8d8',1,'',0,'','店面标识 1：拍照店； 2：接单店； 3：选片店； 4：取件店',0,'is_op'),
	(654,'group_id','5cc6ed5f19c60',1,'',0,'','组id',0,'group_id'),
	(655,'group_name','5cc6ed5f19c60',2,'',0,'','组名',0,'group_name'),
	(656,'department_id','5cc6ed5f19c60',2,'',0,'','部门id',0,'department_id'),
	(657,'department_name','5cc6ed5f19c60',2,'',0,'','部门名',0,'department_name'),
	(658,'shop_code','5cc6ed5f19c60',1,'',0,'','shop_code',0,'shop_code'),
	(659,'shop_name','5cc6ed5f19c60',1,'',0,'','shop_name',0,'shop_name'),
	(660,'brandclass_id','5cc6ed5f19c60',1,'',0,'','事业部ID',0,'brandclass_id'),
	(661,'brandclass','5cc6ed5f19c60',1,'',0,'','事业部名',0,'brandclass'),
	(669,'order_no','5ccfccc905078',2,'',1,'','商户订单号',0,'order_no'),
	(670,'refund_fee','5ccfccc905078',1,'',0,'','退款金额（单位为分,可以做部分退款）',0,'refund_fee'),
	(672,'code','5ce4f98fa25c3',1,'',0,'','code',0,'code'),
	(673,'order_id','5ce791a0e5268',2,'',1,'','订单号',0,'order_id'),
	(674,'fc_id','5ce791a0e5268',1,'',0,'','订单服次',0,'fc_id'),
	(675,'file_name','5ce791a0e5268',1,'',0,'','文件名',0,'file_name'),
	(676,'img','5ce791a0e5268',1,'',0,'','文件',0,'img'),
	(677,'group_id','5cf8d76edd1ca',1,'',1,'','组ID',0,'group_id'),
	(678,'shop_type','5d75f7dcedd78',1,'0',1,'','店面类型（0：全部；1：婚纱：2：儿童）',0,'shop_type'),
	(679,'get_leave','5d75f7dcedd78',1,'2',1,'','是否获取离职人员（1：是，即包含离职人员；2：否，不包含离职人员，只取在职人员）',0,'get_leave'),
	(680,'id','5f045c5f0f056',1,'',1,'','小组id',0,'id'),
	(681,'group_name','5f045c5f0f056',2,'',0,'','小组名称',0,'group_name'),
	(682,'department_id','5f045c5f0f056',2,'',0,'','部门id',0,'department_id'),
	(683,'department_name','5f045c5f0f056',2,'',0,'','部门名称',0,'department_name'),
	(684,'shop_name','5f045c5f0f056',2,'',0,'','店面名称',0,'shop_name'),
	(685,'shop_code','5f045c5f0f056',2,'',0,'','店面code',0,'shop_code'),
	(686,'group_company_name','5f045c5f0f056',2,'',0,'','集团',0,'group_company_name'),
	(687,'brandclass','5f045c5f0f056',2,'',0,'','事业部',0,'brandclass'),
	(688,'brandclass_id','5f045c5f0f056',1,'',0,'','事业部id',0,'brandclass_id'),
	(689,'id','5f045c7367527',1,'',1,'','小组id',0,'id'),
	(690,'test','59f2e9fb5f863',2,'',0,'','',0,'test'),
	(691,'staff_id','erds200ccc905078',1,'',1,'','',0,'staff_id'),
	(692,'session_id','erds200ccc905078',2,'',1,'','',0,'session_id'),
	(693,'position_name','5a0b96b65c111',2,'',0,'','',0,'position_name'),
	(694,'position_code','5a0b96b65c111',2,'',0,'','',0,'position_code');

/*!40000 ALTER TABLE `api_fields` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table api_fields_info
# ------------------------------------------------------------

DROP TABLE IF EXISTS `api_fields_info`;

CREATE TABLE `api_fields_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '唯一主键',
  `field` varchar(50) NOT NULL DEFAULT '' COMMENT '字段名',
  `info` varchar(300) NOT NULL DEFAULT '' COMMENT '字段说明',
  PRIMARY KEY (`id`),
  UNIQUE KEY `field` (`field`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='字段说明对应关系';



# Dump of table api_list
# ------------------------------------------------------------

DROP TABLE IF EXISTS `api_list`;

CREATE TABLE `api_list` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `apiName` varchar(50) NOT NULL DEFAULT '' COMMENT 'api索引，保存了类和方法',
  `apiUrl` varchar(50) DEFAULT NULL,
  `app_id` int(11) NOT NULL DEFAULT '0' COMMENT '应用ID',
  `hash` varchar(50) NOT NULL DEFAULT '' COMMENT 'api唯一标识',
  `accessToken` tinyint(2) NOT NULL DEFAULT '1' COMMENT '是否需要认证AccessToken 1：需要，0：不需要',
  `needLogin` tinyint(2) NOT NULL DEFAULT '1' COMMENT '是否需要认证用户token  1：需要 0：不需要',
  `status` tinyint(2) NOT NULL DEFAULT '1' COMMENT 'API状态：0表示禁用，1表示启用',
  `method` tinyint(2) NOT NULL DEFAULT '2' COMMENT '请求方式0：不限1：Post，2：Get',
  `info` varchar(500) NOT NULL DEFAULT '' COMMENT 'api中文说明',
  `isTest` tinyint(2) NOT NULL DEFAULT '0' COMMENT '是否是测试模式：0:生产模式，1：测试模式',
  `returnStr` text COMMENT '返回数据示例',
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash` (`hash`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='用于维护接口信息';

LOCK TABLES `api_list` WRITE;
/*!40000 ALTER TABLE `api_list` DISABLE KEYS */;

INSERT INTO `api_list` (`id`, `apiName`, `apiUrl`, `app_id`, `hash`, `accessToken`, `needLogin`, `status`, `method`, `info`, `isTest`, `returnStr`)
VALUES
	(7,'登录接口erp','Staff/login',3,'59f2e9fb5f863',1,0,1,1,'登录接口',1,NULL),
	(9,'退出登录','Staff/logOut',3,'59f424811d52f',0,0,1,1,'退出登录',1,NULL),
	(10,'修改密码','Staff/updatePassword',3,'59f44a14c3cae',0,0,1,1,'修改密码',1,NULL),
	(11,'获取员工信息','Staff/get_staff_info',3,'59f933a395abe',0,0,1,1,'获取员工信息',0,NULL),
	(12,'查询同分组下的小伙伴','Staff/group_info',3,'59f95e5ab44ef',0,0,1,1,'查询同分组下的小伙伴',0,NULL),
	(13,'公众号查询','Staff/wxPublic',4,'59fad7a50fde8',0,0,1,1,'查询品牌或店面的公众号信息',0,NULL),
	(14,'消费类型','System/consumptionType',4,'59fd58574204a',0,0,1,1,'消费类型查询',0,NULL),
	(15,'来源渠道','Channel/channelInfo',4,'59fd5e729e5a8',0,0,1,1,'来源渠道查询',0,NULL),
	(16,'客户来源','System/cusSource',4,'59fd5ec462c88',0,0,1,1,'客户来源查询',0,NULL),
	(17,'获取方式','System/accessModel',4,'59fd5f0792e10',0,0,1,1,'或许方式查询',0,NULL),
	(18,'客户意向','System/intentionSet',4,'59fd5f6c1d340',0,0,1,1,'客户意向查询',0,NULL),
	(19,'客资地域','System/regionSet',4,'59fd5fa926b98',0,0,1,1,'客资地域查询',0,NULL),
	(20,'客户地址字典','System/clientAddress',4,'59fd885ed3628',0,0,1,1,'',0,NULL),
	(21,'客户分区','System/areaSet',4,'5a004e9c3e030',0,0,1,1,'',0,NULL),
	(22,'接单点','System/acceptorAddress',4,'5a00506445948',0,0,1,1,'',0,NULL),
	(23,'店面详情查询','Staff/shopSet',4,'5a005e0038270',0,0,1,1,'店面详情查询',0,NULL),
	(24,'员工信息筛选','Staff/staffInfo',4,'5a01766b4a3dd',1,0,1,1,'支持各条件员工信息筛选',1,NULL),
	(25,'获取人员','Staff/getRenyuan',3,'5a02666c9935d',0,0,1,1,'shop_code相同的员工',1,NULL),
	(28,'微信端登录接口','Staff/wx_login',3,'5a029ee140dba',0,0,1,1,'微信端登录接口',0,NULL),
	(29,'修改登录状态','Staff/update_status',3,'5a08fbe736447',1,0,1,1,'修改登录状态',0,NULL),
	(30,'获取员工id，name，number','Staff/getFpStaff',3,'5a0a624728618',1,0,1,1,'根据  部门名，职位名，取员工id，name，number',0,NULL),
	(32,'获取员工小组信息','Staff/getGroup',3,'5a0a7bc01da07',1,0,1,1,'获取员工小组信息',0,NULL),
	(33,'应用安装注册','app/installApp',3,'5a0a9ddc8f9d9',0,0,1,1,'应用安装后，要调此接口进行安装注册，获取接口间通迅密钥。',0,NULL),
	(34,'获取应用列表接口','app/getInstallApp',3,'5a0aacca01925',0,0,1,1,'',0,NULL),
	(35,'部门查询','Staff/department',3,'5a0aef152b750',0,0,1,1,'部门查询',0,NULL),
	(36,'岗位查询','Staff/position',3,'5a0b96b65c111',0,0,1,1,'岗位信息查询，或同店面下岗位',0,NULL),
	(37,'客资标记','System/markSet',4,'5a0c42f43e986',1,0,1,1,'客资标记',0,NULL),
	(38,'消费能力','System/capacity',3,'5a0c43da3e99a',1,0,1,1,'消费能力',0,NULL),
	(39,'根据code获取openid','staff/getWxUserInfo',4,'5a0e5f4ced930',1,0,1,1,'',0,NULL),
	(40,'部门下员工查询','Staff/getDepartmentStaffs',3,'5a0e6f272bb38',0,0,1,1,'根据部门id，获取该部门下所有的员工',0,NULL),
	(41,'获取已安装的所有APP','app/getInstallApp',7,'5a10168c0809b',1,0,1,1,'',0,NULL),
	(42,'获取已安装所有应用','app/getInstallApp',8,'5a1016fe35c9c',1,0,1,1,'',0,NULL),
	(43,'获取扫码登录二维码','staff/getLoginQrCode',4,'5a1027da4e9c1',1,0,1,1,'',0,NULL),
	(44,'根据openid获取微信会员信息','Staff/getWxUserInfo',6,'5a125fdfc4f6b',1,0,1,1,'',0,NULL),
	(45,'消费类型','System/erpConsumptionType',5,'5a14dd1d722a6',0,0,1,1,'erp查询店面下设定的消费类型',0,NULL),
	(46,'客户分区','System/erpArea',5,'5a14de25a68f0',0,0,1,1,'erp查询店面下设定的客户分区',0,NULL),
	(47,'客户来源','System/erpSource',5,'5a14de993bb90',0,0,1,1,'erp查询店面下设定的客户来源',0,NULL),
	(48,'客户意向','System/erpIntention',5,'5a14dec689d91',0,0,1,1,'erp查询店面下设定的客户意向',0,NULL),
	(49,'客户标记','System/erpMark',5,'5a14dfc86bf72',0,0,1,1,'erp查询店面下设定的客户标记',0,NULL),
	(50,'接单点','System/erpAcceptorAddress',5,'5a14e013b447a',0,0,1,1,'erp查询店面下设定的接单点',0,NULL),
	(51,'同一工作类型下人员','Staff/getWorkType',5,'5a1510583e3a5',0,0,1,1,'查询一工作类型下所有人员信息',0,NULL),
	(52,'发送短信','system/sendSms',3,'5a17b86088f1a',0,0,1,1,'',0,NULL),
	(53,'获取同部门下的无小组人员','Staff/getNogroupStaffInfo',4,'5a18d69aefed1',1,0,1,1,'获取同部门下的无小组人员',0,NULL),
	(54,'通过ids获取员工信息数组','Staff/getStaffInfos',4,'5a18e3fa516a1',0,0,1,1,'通过ids获取员工信息数组',0,NULL),
	(55,'修改员工分组','Staff/updateGroup',4,'5a18f958756dc',1,0,1,1,'修改员工分组',0,NULL),
	(56,'ssss','Staff/updatePassword',5,'5a1911b6693e3',1,0,1,1,'',0,NULL),
	(57,'人员查询','Staff/erpStaff',5,'5a19201a33c20',0,0,1,1,'支持各条件查询员工信息',0,NULL),
	(58,'重置密码','Staff/resetPassword',4,'5a1cb7e65cb5f',1,0,1,1,'重置密码',0,NULL),
	(60,'检测用户密码是否正确','Staff/checkPassword',3,'5a221a6621364',1,0,1,1,'此接口只检测用户名和密码是否正确，正确反回用户的基本信息，不做其他用途',0,NULL),
	(61,'检测用户密码是否正确	','Staff/checkPassword',4,'5a221c9548d47',1,0,1,1,'此接口只检测用户名和密码是否正确，正确反回用户的基本信息，不做其他用途	禁用',0,NULL),
	(62,'更新用户openid用于绑定微信或微信登录','Staff/updateOpenid',3,'5a22380ec9a63',1,0,1,1,'',0,NULL),
	(63,'更新用户openid用于绑定微信或微信登录','Staff/updateOpenid',4,'5a2239cf24883',1,0,1,1,'',0,NULL),
	(64,'账号登录接口','Staff/login',6,'5a254b1208166',1,0,1,1,'',0,NULL),
	(65,'微信扫码登录','staff/getLoginQrCode',6,'5a260b53c2907',1,0,1,1,'',0,NULL),
	(66,'获取渠道类型','channel/channelClass',4,'5a2757c0a9810',1,0,1,1,'获取渠道类型',1,NULL),
	(67,'根据OPENID获取员工信息','Staff/getStaffInfoByOpenId',3,'5a2a39421a636',1,0,1,1,'',0,NULL),
	(68,'通过OPENID获取员工信息','Staff/getStaffInfoByOpenId',4,'5a2a39b803dc2',1,0,1,1,'',0,NULL),
	(69,'岗位查询','Staff/position',5,'5a2a5f948c9a5',0,0,1,1,'',0,NULL),
	(70,'获取事业部下某工作类型的人','Staff/positionStaff',4,'5a3717909d178',1,0,1,1,'获取事业部下某工作类型的人',0,NULL),
	(71,'根据品牌id获取品牌下店面','Staff/getBrandShop',3,'5a37a11b05b75',0,0,1,1,'',0,NULL),
	(72,'根据品牌id获取品牌下店面','Staff/getBrandShop',6,'5a37a1503264d',0,0,1,1,'',0,NULL),
	(73,'查询品牌信息','Staff/brandClass',6,'5a38840b15ba9',0,0,1,1,'根据品牌id，查询品牌信息，或者查询所有品牌信息',0,NULL),
	(74,'店面信息查询','Staff/shopSet',5,'5a39fd8c6c9f7',0,0,1,1,'',0,NULL),
	(75,'查询品牌信息','Staff/brandClass',4,'5a3bbb5d0988d',1,0,1,1,'',0,NULL),
	(76,'获取全部品牌店','Staff/getBrands',5,'5a4216fe6b2b5',1,0,1,1,'',0,NULL),
	(77,'发送模板消息','System/sendMsg',3,'5a439c7e5b8e7',0,0,1,1,'发送模板消息',0,NULL),
	(78,'品牌查询','Staff/brandClass',3,'5a44c4782c1b6',0,0,1,1,'',0,NULL),
	(79,'crm给员工发送模板消息','System/crmSendMsg',3,'5a4b81bc26160',0,0,1,1,'',0,NULL),
	(80,'验证ERP会员等级','Port/popUserGrade',3,'5a4cc93c0ea20',1,1,1,1,'',0,NULL),
	(81,'验证ERP会员等级','front/Port/popUserGrade',6,'5a4cca9127088',1,0,1,1,'',0,NULL),
	(82,'订单用户默认成为会员','front/Port/defaultVip',6,'5a4dceb477528',1,0,1,1,'',0,NULL),
	(83,'登录扫码','staff/getLoginQrCode',5,'5a54275fb256c',0,0,1,1,'',0,NULL),
	(84,'店面下所有人员工作类型集合','Staff/getShopStaffWorkType',5,'5a574b13103b7',0,0,1,1,'',0,NULL),
	(85,'微信扫码支付，生成支付订单','order/newOrder',3,'5a5c6626eef07',1,0,1,1,'统一下单支付接口',0,NULL),
	(86,'微信扫码支付，查看支付状态','order/queryOrderPayStatus',3,'5a5ca00c81db4',1,0,1,1,'微信扫码支付，查看支付状态，用户主动扫我们的码。',0,NULL),
	(87,'微信被动扫码支付-生成支付','order/micropay',3,'5a5da9f70d56e',1,0,1,1,'',0,NULL),
	(88,'微信支付JSAPI签名	','order/jsapiSign',3,'5a5dbddc8fa64',1,0,1,1,'',0,NULL),
	(89,'发送短信','system/sendSms',5,'5a5df0ae0fcd5',1,0,1,1,'',0,NULL),
	(94,'微信扫码支付，生成支付订单','order/newOrder',5,'5a5f015c659ee',1,0,1,1,'统一下单支付接口',0,NULL),
	(95,'微信扫码支付，查看支付状态','order/queryOrderPayStatus',5,'5a5f01acab982',1,0,1,1,'微信扫码支付，查看支付状态，用户主动扫我们的码。',0,NULL),
	(96,'微信被动扫码支付-生成支付','order/micropay',5,'5a5f0252c9ae7',1,0,1,1,'生成二维码扫码支付',0,NULL),
	(97,'微信支付JSAPI签名','order/jsapiSign',5,'5a5f02718e1d1',1,0,1,1,'',0,NULL),
	(98,'获取微信access_token','System/getAccessToken',3,'5a603e4ea5c0c',0,0,1,1,'根据品牌id,店面code 获取其微信公众号的接口调用凭证access_token',0,NULL),
	(100,'获取微信access_token','System/getAccessToken',6,'5a60436d631a4',0,0,1,1,'根据品牌id,店面code 获取其微信公众号的接口调用凭证access_token',0,NULL),
	(101,'部门查询 ','Staff/department',5,'5a62dcd5c7e40',0,0,1,1,'部门查询',0,NULL),
	(112,'批量发送短信','System/batchSendSms',6,'5a7bdbdaa5870',0,0,1,1,'批量发送短信，每200条请求一次接口发送',0,NULL),
	(113,'获取某员工可查看店面','Staff/getPositionShop',5,'5a8fd8296f3d3',0,0,1,1,'根据员工的岗位和兼职岗位，获取所有所属店。',0,NULL),
	(121,'查询集团信息 ','Staff/groupCompany',3,'5a6978bb82027',0,0,1,1,'获取集团信息',0,NULL),
	(122,'获取某个店的所有客资提报店 ','Staff/getAddCustomerShop',3,'5a706286930ce',1,0,1,1,'获取某个店的所有客资提报店',0,NULL),
	(123,'获取某个店的所有客资提报店 ','Staff/getAddCustomerShop',4,'5a7076a6ccfaa',1,0,1,1,'获取某个店的所有客资提报店',0,NULL),
	(124,'通过省id获取地域 ','Staff/getRegionByProvinceId',4,'5a704aa96e503',1,0,1,1,'通过省id获取地域',0,NULL),
	(125,'某一店面下所有员工，包括兼职本店岗位的员工 ','Staff/getShopAllStaff',4,'5a7424f13aa54',0,0,1,1,'通过省id获取地域',0,NULL),
	(126,'获取公众号二维码','System/getExtendQrInfo',4,'5a73d4f13a9eb',0,0,1,1,'通过参数获取品牌下公众号的二维码信息，返回ticket可以接显示二维码',0,NULL),
	(127,'发送验证码','System/sendVerifySMS',6,'5a780e2613bb9',0,0,1,1,'只用于发送验证码，参数只需传入手机号，验证码。',0,NULL),
	(128,'会员支付统一下单接口','order/newOrder',6,'5aa3fcd1050e0',1,0,1,1,'',0,NULL),
	(129,'获取JSAPI支付数据','order/jsapiSign',6,'5aa401fd2f740',1,0,1,1,'',0,NULL),
	(130,'短信余额查询接口','System/smsBalance',3,'5aae44296a6bf',0,0,1,1,'查询短信余额',0,NULL),
	(131,'短信余额查询接口','System/smsBalance',4,'5aae46527269f',0,0,1,1,'查询短信余额',0,NULL),
	(132,'短信余额查询接口','System/smsBalance',5,'5aae460d2996e',0,0,1,1,'查询短信余额',0,NULL),
	(133,'短信余额查询接口','System/smsBalance',6,'5aae466ce7ddd',0,0,1,1,'查询短信余额',0,NULL),
	(137,'某店面下人员信息（包括工作类型的集合）','Staff/getShopStaffData',5,'5aafa4ac48058',0,0,1,1,'某店面下人员信息（包括工作类型的集合）',0,NULL),
	(138,'短信验证码登录','Staff/getLoginCode',3,'5ab88f1fd2f00',0,0,1,1,'通过手机号获取验证码登录',0,NULL),
	(139,'手机验证码登录','Staff/phoneLogin',3,'5ab8b32fcc970',0,0,1,1,'通过手机号获取验证码登录',0,NULL),
	(140,'签名','System/signature',3,'5ab99d8594c78',0,0,1,1,'订单签名确认',0,NULL),
	(141,'获取订单签名信息','System/getsignature',3,'5ab9a901ee228',0,0,1,1,'获取订单签名的信息',0,NULL),
	(161,'工作类型查询','Staff/workType',3,'5ae01abbbc263',0,0,1,1,'工作类型查询',0,NULL),
	(179,'添加、编辑事业部 ','Staff/editBrand',3,'5b3c3dc4ebca8',0,0,1,1,'添加、编辑事业部信息',0,NULL),
	(180,'删除事业部 ','Staff/delBrand',3,'5b3c5bec9ee30',0,0,1,1,'删除事业部信息',0,NULL),
	(181,'添加、编辑店面 ','Staff/editShop',3,'5b3c5ccadc2a8',0,0,1,1,'添加、编辑事业店面',0,NULL),
	(182,'删除店面 ','Staff/delShop',3,'5b3dbce7c7da8',0,0,1,1,'删除店面',0,NULL),
	(183,'添加、编辑部门 ','Staff/editDepartment',3,'5b3dbdd2964b0',0,0,1,1,'添加、编辑部门',0,NULL),
	(184,'删除部门 ','Staff/delDepartment',3,'5b3dc428987d8',0,0,1,1,'删除部门',0,NULL),
	(185,'编辑岗位 ','Staff/editPosition',3,'5b3dc4a1dc1e0',0,0,1,1,'添加、编辑岗位',0,NULL),
	(186,'删除岗位 ','Staff/delPosition',3,'5b3dc56a73de8',0,0,1,1,'删除岗位',0,NULL),
	(187,'添加、编辑人员 ','Staff/editStaff',3,'5b3dc732048a8',0,0,1,1,'添加、编辑人员',0,NULL),
	(188,'删除人员 ','Staff/delStaff',3,'5b3dc87367e80',0,0,1,1,'删除人员',0,NULL),
	(189,'获取所有未使用的门店的shop_code ','Staff/getShopCode',3,'5b3dc8f4d1218',0,0,1,1,'获取所有未使用的门店的shop_code',0,NULL),
	(194,'添加岗位 ','Staff/addPosition',3,'5b4717ca97046',0,0,1,1,'添加岗位',0,NULL),
	(195,'获取短信配置 ','Staff/getSmsConfig',3,'5b484a585d5c0',0,0,1,1,'获取短信配置',0,NULL),
	(432,'删除签名','System/delsignature',3,'5ac3579d76bb8',0,0,1,1,'删除签名',0,NULL),
	(439,'搜索员工 ','Staff/searchStaff',3,'5aec138a7bae9',0,0,1,1,'根据 姓名或者手机号，模糊搜索',0,NULL),
	(440,'根据员工编号发送短信','System/smsByStaffNumber',3,'5af2f899164f4',0,0,1,1,'根据员工编号发送短信',0,NULL),
	(441,'erp获取实体店人员','Staff/erpStStaff',5,'5af3c003b4cae',0,0,1,1,'erp获取实体店人员',0,NULL),
	(442,'查询客资无效原因','System/getUnValidReason',4,'5af3fe7a0a668',0,0,1,1,'',0,NULL),
	(443,'查询未成单原因','System/getNotOrderReason',4,'5af40001983f0',1,0,1,1,'',0,NULL),
	(445,'获取集团或事业部的直属部门','Staff/getDepartment',3,'5aff92c0762a0',0,0,1,1,'获取集团或事业部下的直属部门',0,NULL),
	(451,'获取某岗位或员工的直属上级岗位对应的人','Staff/getTopStaff',3,'5b20eb32badd8',0,0,1,1,'获取某岗位或员工的直属上级岗位对应的人',0,NULL),
	(452,'修改极光账号密码 ','Staff/changeJgPwd',3,'5b6575a339c38',0,0,1,1,'修改极光账号密码',0,NULL),
	(453,'验证token接口','Staff/checkToken',3,'5b3ae7a95f370',0,0,1,1,'',0,NULL),
	(454,'查询店下所有的人 ','Staff/getStaffsByWorkType',4,'5b75341456d18',0,0,1,1,'同一店面 ( 包含可操作店 ) 下某工作类型下所有员工 ( 包含但不限于岗位工作类型 ) ',0,NULL),
	(455,'编辑员工表某几个字段 ','Staff/staffSpecialEdit',4,'5b8630d8d21b8',0,0,1,1,'编辑员工表某几个字段，传参则改',0,NULL),
	(456,'添加、编辑集团信息 ','Staff/editCompany',4,'5b876a32ca648',0,0,1,1,'添加、编辑集团信息',0,NULL),
	(457,'添加、编辑工作类型等级 ','Staff/addWorkLevel',4,'5b8a64f1c39b0',0,0,1,1,'添加、编辑工作类型等级',0,NULL),
	(458,'删除工作类型等级 ','Staff/delWorkLevel',4,'5b8a655b5d4f8',0,0,1,1,'删除工作类型等级',0,NULL),
	(459,'获取员工在某事业部下的客操作店 ','Staff/getWorkShop',4,'5b9cac8aa21c0',0,0,1,1,'获取员工在某事业部下的客操作店',0,NULL),
	(460,'可操作店包括某店的某个工作类型人员','Staff/getStaffsByWorkShopType',5,'5bc58874c5828',0,0,1,1,'可操作店包括某店面的，某个工作类型（人员设定中勾选）的所有在职员工 ',0,NULL),
	(461,'极光推送消息(全部人)','System/pushToAll',3,'5bc8702e3e056',0,0,1,1,'极光推送消息(全部人)',0,NULL),
	(462,'极光推送消息(指定人)','System/pushToStaff',3,'5bc870ff09178',0,0,1,1,'极光推送消息(全部人)',0,NULL),
	(463,'清空指定人极光id','System/pushToAll',3,'5bc871078bcee',0,0,1,1,'极光推送消息(全部人)',0,NULL),
	(464,'图片上传','System/uploadImg',3,'5bc94272b051a',0,0,1,1,'图片上传',1,NULL),
	(465,'图片删除','System/delImg',3,'5bc94294ae9c2',0,0,1,1,'图片删除',0,NULL),
	(467,'oa获取集团下的事业部列表','Oa/getBrandList',3,'5bcd6e7692511',0,0,1,1,'oa获取集团下的事业部列表',0,NULL),
	(468,'oa获取事业部下的店面列表','Oa/getShopList',3,'5bcd7a65e1d8c',0,0,1,1,'oa获取事业部下的店面列表',0,NULL),
	(469,'oa获取部门','Oa/getDepartmentList',3,'5bcd7b190d812',0,0,1,1,'oa获取部门',0,NULL),
	(470,'oa获取集团下的获取人员','Oa/getStaffList',3,'5bcd7bf31b0c2',0,0,1,1,'oa获取集团下的获取人员',0,NULL),
	(471,'oa模糊搜索 人名 和 手机号','Oa/seacherStaff',3,'5bcd7c794bcbd',0,0,1,1,'oa模糊搜索 人名 和 手机号',0,NULL),
	(474,'oa复制店面下的部门岗位','Staff/copyPosition',3,'5bd27d0a93120',0,0,1,1,'oa复制店面下的部门岗位',0,NULL),
	(475,'导入事业部信息','Staff/importBrand',3,'5bdaed7e5e551',0,0,1,1,'导入事业部信息',0,NULL),
	(476,'导入店面信息','Staff/importShop',3,'5bdaee20b646d',0,0,1,1,'导入店面信息',0,NULL),
	(477,'导入部门信息','Staff/importDept',3,'5bdaee2a462e6',0,0,1,1,'导入部门信息',0,NULL),
	(478,'导入人员信息','Staff/importStaff',3,'5bdaee35ac5ad',0,0,1,1,'导入人员信息',0,NULL),
	(487,'erp线下订单支付','System/erpPaymentQrCode',3,'5c9ae4289e598',0,0,1,1,'erp线下订单支付',0,NULL),
	(488,'获取openid下的订单 ','Order/getOrdersByOpenid',3,'5caf4eceb94bd',1,0,1,1,'获取openid下的所有订单',0,NULL),
	(489,'根据标识获取员工制定店面列表','Staff/getOpShoplist',3,'5cbe739c8d8d8',0,0,1,1,'获取openid下的所有订单',0,NULL),
	(490,'查询小组','Staff/getGroupInfo',3,'5cc6ed5f19c60',0,0,1,1,'获取小组信息，不含成员',0,NULL),
	(491,'微信退款','Order/wxRefund',3,'5ccfccc905078',0,0,1,1,'微信退款',0,NULL),
	(492,'获取电子合同单图片路径','System/getContractImg',3,'5ce4f98fa25c3',0,0,1,1,'获取电子合同单图片路径',0,NULL),
	(493,'先睹为快照片上传','System/uploadImgSneakPeek',3,'5ce791a0e5268',0,0,1,1,'先睹为快照片上传',0,NULL),
	(494,'根据组id查询小组人员','Staff/getGroupStaff',3,'5cf8d76edd1ca',1,0,1,1,'多个id逗号隔开',0,NULL),
	(495,'根据手机号发送微信模板消息 ','System/sendMsgByMobile',3,'5d00c53f80f8d',1,0,1,1,'根据手机号发送微信模板消息',0,NULL),
	(496,'会员绑定微信 ','Vip/bindWeixin',3,'5d02eb39af707',1,0,1,1,'会员系统绑定手机号时，将微信的openid与手机号进行绑定，以便后期发送模板消息.',0,NULL),
	(498,'NAS检测文件同步 ','Nas/getMvUploadFiles',3,'5d0b3a67d0f22',1,0,1,1,'NAS检测文件同步',0,NULL),
	(499,'获取可删除的文件列表 ','Nas/getDelFiles',3,'5d0b3a978cf2e',1,0,1,1,'获取可删除的文件列表',0,NULL),
	(500,'出错时的报警消息发送 ','Nas/errSendMessage',3,'5d0b3abf6627c',1,0,1,1,'出错时的报警消息发送',0,NULL),
	(501,'NAS心跳通知 ','Nas/active',3,'5d0b3b32efba5',1,0,1,1,'NAS心跳通知',0,NULL),
	(505,'绑定微信接口','Staff/getBindWeixinCode',3,'5d10431862ecb',1,0,1,1,'需要绑定微信时，获取绑定CODE和二维码URL，同时提交CODE后，可以获取绑定结果。',0,NULL),
	(506,'获取服次完成的超期服次    ','Nas/getFcoverOrders',3,'5d393b2045d29',1,0,1,1,'需要配置文件内增加clean_photo_day 设定超时天数   ',0,NULL),
	(507,'获取员工主岗位及兼职岗位信息','Staff/getStaffByShopType',5,'5d75f7dcedd78',1,0,1,1,'根据店面类型获取员工主岗位及兼职岗位信息',1,NULL),
	(508,'获取短信模板列表','Sms/getTemplate',5,'5d78e5b101c5c',1,0,1,1,'获取短信模板列表',0,NULL),
	(509,'发送模板短信','Sms/sendTemplateSms',5,'5d78e60eeb6a2',1,0,1,1,'发送模板短信',0,NULL),
	(510,'更新集团信息','Personnel/updateGroupCompany',5,'5d6fee8a0d4ba',1,0,1,1,'更新集团信息',0,NULL),
	(511,'获取职业列表','System/professor',5,'5e9534699e6ee',1,0,1,1,'获取职业列表',0,NULL),
	(512,'院校列表','System/school',5,'5e9537f91e931',1,0,1,1,'院校列表',0,NULL),
	(513,'获取MC产品ID','App/getMcProductId',5,'5ef1a04c80175',0,0,1,1,'获取MC产品ID，供其他系统调用',0,NULL),
	(514,'添加、编辑小组 ','Staff/editGroup',3,'5f045c5f0f056',0,0,1,1,'添加、编辑小组信息',0,NULL),
	(515,'删除小组 ','Staff/delGroup',3,'5f045c7367527',0,0,1,1,'删除小组信息',0,NULL),
	(517,'获取手机号是否绑定和关注公众号 ','Vip/isBindWeixin',3,'5f212252cc174',1,0,1,1,'可能比调用会员更准一些^-^',0,NULL),
	(518,'VR视频模板列表','Product/getTemplates',3,'5fa3a7e37ae45',1,0,1,1,'VR视频模板列表^-^',0,NULL),
	(519,'亦盟接口：帐户余额','Qgc/getAccount',3,'5facd568cd3d4',1,0,1,1,'亦盟接口：帐户余额',0,NULL),
	(520,'亦盟接口：获取中文拼音组合','Qgc/queryPinyin',3,'5facd84f4096d',1,0,1,1,'亦盟接口：获取中文拼音组合',0,NULL),
	(521,'亦盟接口：生成体验单','Qgc/newPreOrder',3,'5facdd623c5d9',1,0,1,1,'亦盟接口：生成体验单',0,NULL),
	(522,'亦盟接口：生成正式单','Qgc/newOrder',3,'5facf6f6916ff',1,0,1,1,'亦盟接口：生成正式单',0,NULL),
	(523,'亦盟接口：订单查询','Qgc/queryOrder',3,'5facfb0b8a233',1,0,1,1,'亦盟接口：订单查询',0,NULL),
	(526,'亦盟接口：查询绘本接口','Qgc/queryBookPic',3,'5fb4c75e7d560',1,0,1,1,'亦盟接口：查询绘本接口',0,NULL),
	(527,'亦盟接口：查询订单列表','Qgc/getOrderList',3,'5fb753ea3b7d1',1,0,1,1,'亦盟接口：查询订单列表',0,NULL),
	(528,'获取微信验证码信息','Wx/getWxVerifyCode',3,'5fc7ae614a744',1,0,1,1,'获取微信验证码信息,要先调用：4dc7afc14a78e,参数key:长度40以内',0,NULL),
	(529,'生成微信验证码所需的公众号二维码','Wx/verifyCodeQrcode',3,'4dc7afc14a78e',1,0,1,1,'生成微信验证码所需的公众号二维码',0,NULL),
	(530,'微信接口：获取用于JS签名的jsticket','Wx/getWxJsapiTicket',3,'30bde89324376',1,0,1,1,'获取用于JS签名的jsticket',0,NULL),
	(531,'获取客服人员','Wx/getWxKfStaff',3,'5f32641f028f0',1,0,1,1,'',0,NULL),
	(532,'发送消息(直接调取微信接口)','getWxSendMessage',3,'5f32711801d34',1,0,1,1,'',0,NULL),
	(533,'上传临时素材','Wx/getWxSendTemporaryMaterial',3,'5f32714d7088a',1,0,1,1,'',0,NULL),
	(534,'获取微信会话列表1','Wx/wxTalkListJSON1',3,'5f33978d6e6af',1,0,1,1,'',0,NULL),
	(535,'获取微信会话列表2','Wx/wxTalkListJSON2',3,'5f3397a8a512a',1,0,1,1,'',0,NULL),
	(536,'获取微信会话页面','Wx/getKfTalk',3,'5f339d2535459',1,0,1,1,'',0,NULL),
	(537,'发送消息','Wx/getWxKfTalk',3,'5f33ac035d292',1,0,1,1,'',0,NULL),
	(538,'获取最新消息','Wx/getWxNewMsg',3,'5f34afb5582c2',1,0,1,1,'',0,NULL),
	(539,'获取微信表情','Wx/getWxTupian',3,'5f34b6e6247f5',1,0,1,1,'',0,NULL),
	(540,'聊天记录','Wx/getTalkByOpenid',3,'5f34caa21cf48',1,0,1,1,'',0,NULL),
	(541,'分配客服','Wx/getWxAllotKf',3,'5f34fff504b5b',1,0,1,1,'',0,NULL),
	(542,'更新已读消息','Wx/getUpdateMsg',3,'5f3629f1f295b',1,0,1,1,'',0,NULL),
	(543,'获取素材列表','Wx/getWxSource',3,'5f3a3b4a2811d',1,0,1,1,'',0,NULL),
	(544,'获取客服人员管理','Wx/getWxKfStaffToJSON',3,'5f3b6a32962df',1,0,1,1,'',0,NULL),
	(545,'添加客服人员','Wx/getWxAddkf',3,'5f3b7022ee5df',1,0,1,1,'',0,NULL),
	(546,'修改客服人员','Wx/getWxEditkf',3,'5f3b88b12e7d0',1,0,1,1,'',0,NULL),
	(547,'删除客服人员','Wx/getWxDelkf',3,'5f3b8add08911',1,0,1,1,'',0,NULL),
	(548,'生成二维码','Wx/getWxQRorder',3,'5f3ba72e9d8a8',1,0,1,1,'',0,NULL),
	(549,'微信自定义菜单','Wx/getWxMenu',3,'5f3c8fa2561a0',1,0,1,1,'',0,NULL),
	(550,'微信新增菜单','Wx/getWxAddMenuSet',3,'5f3c9c4b07bc4',1,0,1,1,'',0,NULL),
	(551,'微信新增菜单写入','Wx/getWxAddMenu',3,'5f3cb81ecc895',1,0,1,1,'',0,NULL),
	(552,'微信删除菜单','Wx/getWxDelMenu',3,'5f3cc835b031c',1,0,1,1,'',0,NULL),
	(553,'初始化微信菜单','Wx/getWxSetWxmenu',3,'5f3cca0071020',1,0,1,1,'',0,NULL),
	(554,'获取自动回复列表列表','Wx/getWxAutoAnswerList',3,'5f3cd67174c71',1,0,1,1,'',0,NULL),
	(555,'回复详情','Wx/getAnswerDetail',3,'5f3cd9fa71bf7',1,0,1,1,'',0,NULL),
	(556,'获取微信公众号自动回复','Wx/geWxtAutoAnswer',3,'5f3ce8b53f53b',1,0,1,1,'',0,NULL),
	(557,'获取微信 最新消息','Wx/getWxsendSystemMessage',3,'5f434d2fcdd52',1,0,1,1,'',0,NULL),
	(562,'检查手机号是否绑定微信','Wx/checkMobileBinded',3,'5fad47ff1atf5',1,0,1,1,'检查手机号是否绑定微信或是否关注公众号',0,NULL),
	(563,'新增微信模板消息缓存','Wx/saveWxTemplate',3,'9p9f3efer91fd',1,0,1,1,'新增微信模板消息缓存主要用于解决微信模板消息显示字数不够多的情况，可点击查看详情',0,NULL),
	(564,'联合登录验证','Staff/checkStaffSession',3,'erds200ccc905078',1,0,1,1,'微信退款',0,NULL);

/*!40000 ALTER TABLE `api_list` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table api_login_log
# ------------------------------------------------------------

DROP TABLE IF EXISTS `api_login_log`;

CREATE TABLE `api_login_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `login_method` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `ip` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `result` tinyint(1) DEFAULT '1',
  `error_reason` varchar(255) COLLATE utf8_unicode_ci DEFAULT '',
  `create_time` datetime DEFAULT NULL,
  `login_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table api_menu
# ------------------------------------------------------------

DROP TABLE IF EXISTS `api_menu`;

CREATE TABLE `api_menu` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '???',
  `fid` int(11) NOT NULL COMMENT '父级菜单ID',
  `url` varchar(50) CHARACTER SET utf8mb4 NOT NULL DEFAULT '' COMMENT '链接',
  `auth` tinyint(2) NOT NULL DEFAULT '0' COMMENT '访客权限',
  `sort` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `hide` tinyint(2) NOT NULL DEFAULT '0' COMMENT '是否显示',
  `icon` varchar(50) CHARACTER SET utf8mb4 NOT NULL DEFAULT '' COMMENT '菜单图标',
  `level` tinyint(2) NOT NULL DEFAULT '0' COMMENT '菜单认证等级',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='目录信息';

LOCK TABLES `api_menu` WRITE;
/*!40000 ALTER TABLE `api_menu` DISABLE KEYS */;

INSERT INTO `api_menu` (`id`, `name`, `fid`, `url`, `auth`, `sort`, `hide`, `icon`, `level`)
VALUES
	(1,'欢迎页',0,'Index/welcome',0,0,0,'',0),
	(2,'系统配置',0,'',0,1,0,'',0),
	(3,'菜单维护',2,'Menu/index',0,0,0,'',0),
	(4,'用户管理',2,'User/index',0,1,0,'',0),
	(5,'权限管理',2,'Permission/index',0,2,0,'',0),
	(6,'操作日志',2,'Log/index',0,3,0,'',0),
	(7,'应用管理',0,'',0,2,0,'',0),
	(8,'应用列表',7,'App/index',0,0,0,'',0),
	(9,'接口列表',7,'ApiManage/index',0,1,0,'',0),
	(10,'字段注解',7,'FieldsInfoManage/index',0,2,1,'',0),
	(11,'首页',0,'Index/index',0,0,1,'',0),
	(12,'新增菜单',3,'Menu/add',0,0,1,'',0),
	(13,'编辑菜单',3,'Menu/edit',0,0,1,'',0),
	(14,'隐藏菜单',3,'Menu/close',0,0,1,'',0),
	(15,'显示菜单',3,'Menu/open',0,0,1,'',0),
	(16,'删除菜单',3,'Menu/del',0,0,1,'',0),
	(17,'新增用户',4,'User/add',0,0,1,'',0),
	(18,'账号封停',4,'User/close',0,0,1,'',0),
	(19,'账号解封',4,'User/open',0,0,1,'',0),
	(20,'账号删除',4,'User/del',0,0,1,'',0),
	(21,'编辑应用',8,'App/edit',0,0,1,'',0),
	(22,'新增应用',8,'App/add',0,0,1,'',0),
	(23,'启用应用',8,'App/open',0,0,1,'',0),
	(24,'禁用应用',8,'App/close',0,0,1,'',0),
	(25,'删除应用',8,'App/del',0,0,1,'',0),
	(26,'新增接口',9,'ApiManage/add',0,0,1,'',0),
	(27,'启用接口',9,'ApiManage/open',0,0,1,'',0),
	(28,'禁用接口',9,'ApiManage/close',0,0,1,'',0),
	(29,'编辑接口',9,'ApiManage/edit',0,0,1,'',0),
	(30,'删除接口',9,'ApiManage/del',0,0,1,'',0),
	(31,'返回字段编辑',9,'FieldsManage/response',0,0,1,'',0),
	(32,'请求字段编辑',9,'FieldsManage/request',0,0,1,'',0),
	(33,'新增字段',9,'FieldsManage/add',0,0,1,'',0),
	(34,'字段编辑',9,'FieldsManage/edit',0,0,1,'',0),
	(35,'批量上传返回字段',9,'FieldsManage/upload',0,0,1,'',0),
	(36,'Ajax查询Log列表',6,'Log/ajaxGetIndex',0,0,1,'',0),
	(37,'日志删除',6,'Log/del',0,0,1,'',0),
	(38,'日志详情查看',6,'Log/showDetail',0,0,1,'',0),
	(39,'添加权限组',5,'Permission/add',0,0,1,'',0),
	(40,'禁用权限组',5,'Permission/close',0,0,1,'',0),
	(41,'启用权限组',5,'Permission/open',0,0,1,'',0),
	(42,'编辑权限组',5,'Permission/edit',0,0,1,'',0),
	(43,'删除权限组',5,'Permission/del',0,0,1,'',0),
	(44,'用户入组',5,'Permission/group',0,0,1,'',0),
	(45,'组用户列表',5,'Permission/member',0,0,1,'',0),
	(46,'踢出成员',5,'Permission/delMember',0,0,1,'',0),
	(47,'权限组权限配置',5,'Permission/rule',0,0,1,'',0),
	(49,'字段删除',34,'FieldsManage/del',0,0,0,'',0),
	(50,'人事资料设定',0,'',0,4,0,'',0),
	(51,'集团设定',50,'Personnel/GroupCompany',0,1,0,'',0),
	(52,'新增集团名称设定',51,'Personnel/GroupCompany',0,0,1,'',0),
	(53,'品牌设定',50,'Personnel/brandClass',0,2,0,'',0),
	(54,'新增品牌名称',53,'Personnel/addBrand',0,0,1,'',0),
	(55,'编辑品牌名称',53,'Personnel/editBrand',0,0,1,'',0),
	(56,'删除品牌',53,'Personnel/delBrand',0,0,1,'',0),
	(57,'店面设定',50,'Personnel/shopSet',0,3,0,'',0),
	(58,'编辑店面',57,'Personnel/editShop',0,0,1,'',0),
	(59,'删除店面',57,'Personnel/delShop',0,0,1,'',0),
	(60,'新增店面',57,'Personnel/addShop',0,0,1,'',0),
	(61,'部门设定',50,'Personnel/department',0,4,0,'',0),
	(62,'新增部门',61,'Personnel/addDepartment',0,0,1,'',0),
	(64,'编辑部门',61,'Personnel/editDepartment',0,0,1,'',0),
	(65,'分组设定',50,'Personnel/staffGroup',0,5,1,'',0),
	(66,'新增分组',65,'Personnel/addGroup',0,0,1,'',0),
	(67,'编辑分组',65,'Personnel/editGroup',0,0,1,'',0),
	(69,'删除分组',65,'Personnel/delGroup',0,0,1,'',0),
	(70,'岗位设定',50,'Personnel/position',0,6,0,'',0),
	(71,'新增岗位',70,'Personnel/addPosition',0,0,1,'',0),
	(72,'编辑岗位',70,'Personnel/editPosition',0,0,1,'',0),
	(73,'删除岗位',70,'Personnel/delPosition',0,0,1,'',0),
	(74,'人员设定',50,'Personnel/staff',0,8,0,'',0),
	(75,'新增人员',74,'Personnel/addStaff',0,0,1,'',0),
	(76,'编辑人员',74,'Personnel/editStaff',0,0,1,'',0),
	(77,'删除人员',74,'Personnel/delStaff',0,0,1,'',0),
	(78,'CRM系统设定',0,'',0,5,0,'',0),
	(79,'渠道类型设置',78,'Channel/channelClass',0,1,0,'',0),
	(80,'新增渠道类型',79,'Channel/addChannel',0,0,1,'',0),
	(81,'编辑渠道类型',79,'Channel/editChannel',0,0,1,'',0),
	(82,'删除渠道类型',79,'Channel/delChannel',0,0,1,'',0),
	(83,'来源渠道设定',78,'Channel/channelInfo',0,2,0,'',0),
	(84,'新增来源渠道',83,'Channel/addChannelInfo',0,0,1,'',0),
	(85,'编辑来源渠道',83,'Channel/editChannelInfo',0,0,1,'',0),
	(86,'删除来源渠道',83,'Channel/delChannelInfo',0,0,1,'',0),
	(87,'职级设定',50,'Personnel/zhijiSet',0,7,0,'',0),
	(88,'新增职级',87,'Personnel/addZhiji',0,0,1,'',0),
	(89,'编辑职级',87,'Personnel/editZhiji',0,0,1,'',0),
	(90,'删除职级',87,'Personnel/delZhiji',0,0,1,'',0),
	(91,'系统资料设定',0,'',0,3,0,'',0),
	(92,'消费类型设定',91,'System/consumptionType',0,1,0,'',0),
	(93,'新增消费类型',92,'System/addConsumptionType',0,0,1,'',0),
	(94,'编辑消费类型',92,'System/editConsumptionType',0,0,1,'',0),
	(95,'删除消费类型',92,'System/delConsumptionType',0,0,1,'',0),
	(96,'客户分区设定',91,'System/areaSet',0,2,0,'',0),
	(97,'新增客户分区',96,'System/addArea',0,0,1,'',0),
	(98,'编辑客户分区',96,'System/editArea',0,0,1,'',0),
	(99,'删除客户分区',96,'System/delArea',0,0,1,'',0),
	(100,'客户来源设定',91,'System/cusSource',0,3,0,'',0),
	(101,'新增客户来源',100,'System/addCusSource',0,0,1,'',0),
	(102,'客户意向设定',91,'System/intentionSet',0,4,0,'',0),
	(103,'新增客户意向',102,'System/addIntention',0,0,1,'',0),
	(104,'编辑客户意向',102,'System/editIntention',0,0,1,'',0),
	(105,'删除客户意向',102,'System/delIntention',0,0,1,'',0),
	(106,'编辑客户来源',100,'System/editCusSource',0,0,1,'',0),
	(107,'删除客户来源',100,'System/delCusSource',0,0,1,'',0),
	(108,'获取方式设定',91,'System/accessModel',0,5,0,'',0),
	(109,'新增获取方式',108,'System/addAccess',0,0,1,'',0),
	(110,'编辑获取方式',108,'System/editAccess',0,0,1,'',0),
	(111,'删除获取方式',108,'System/delAccess',0,0,1,'',0),
	(112,'客户地域设定',91,'System/regionSet',0,6,0,'',0),
	(113,'新增客户地域',112,'System/addRegion',0,0,1,'',0),
	(114,'编辑客户地域',112,'System/editRegion',0,0,1,'',0),
	(115,'删除客户地域',112,'System/delRegion',0,0,1,'',0),
	(120,'消费能力设定',91,'System/capacity',0,8,0,'',0),
	(121,'新增消费能力',120,'System/addCapacity',0,0,1,'',0),
	(122,'编辑消费能力',120,'System/editCapacity',0,0,1,'',0),
	(123,'删除消费能力',120,'System/delCapacity',0,0,1,'',0),
	(124,'接单点设定',91,'System/acceptorAddress',0,9,0,'',0),
	(125,'新增接单点',124,'System/addAcceptorAddress',0,0,1,'',0),
	(126,'编辑接单点',124,'System/editAcceptorAddress',0,0,1,'',0),
	(127,'删除接单点',124,'System/delAcceptorAddress',0,0,1,'',0),
	(128,'系统全局设定',0,'System/globalSet',0,3,0,'',0),
	(129,'所属查询',62,'Personnel/searchGrade',0,0,1,'',0),
	(130,'查询短信配置信息',128,'System/searchContent',0,0,1,'',0),
	(131,'模板设定',91,'System/template',0,9,0,'',0),
	(132,'新增微信模板',131,'System/addTemplate',0,0,1,'',0),
	(133,'编辑微信模板',131,'System/editTemplate',0,0,1,'',0),
	(134,'删除微信模板',131,'System/delTemplate',0,0,1,'',0),
	(135,'查询某一品牌下的店面',74,'Personnel/searchShop',0,0,1,'',0),
	(136,'查询店面下的部门',74,'Personnel/searchDepartment',0,0,1,'',0),
	(137,'删除部门',61,'Personnel/delDepartment',0,0,1,'',0),
	(138,'查询部门下岗位',75,'Personnel/searchPosition',0,0,1,'',0),
	(139,'test',12,'sdfsdf',0,0,0,'',0),
	(140,'联动查询品牌下的店面',61,'Personnel/brandShop',0,0,1,'',0),
	(141,'获取品牌下营销店',60,'Personnel/getBrandMarketing',0,0,0,'',0),
	(142,'getOpenid',0,'System/getOpenid',0,0,1,'',0),
	(143,'员工信息联动',75,'Personnel/link_search',0,0,1,'',0),
	(144,'根据多个岗位id获取岗位名称',76,'Personnel/getPositionName',0,0,1,'',0),
	(145,'复制岗位页面',70,'personnel/copyPosition',0,0,1,'',0),
	(146,'复制岗位',70,'personnel/doCopy',0,0,1,'',0),
	(147,'批量设置兼职岗位',61,'personnel/batchSet',0,0,1,'',0),
	(148,'执行批量设置兼职岗位',61,'personnel/doBatch',0,0,1,'',0),
	(152,'店下所有岗位',61,'personnel/search_positon',0,0,1,'',0),
	(153,'查看系统状态',0,'System/serverValid',1,0,1,'',0),
	(154,'查看系统状态',0,'System/serverValid',1,0,1,'',0),
	(156,'查看系统状态',0,'System/serverValid',1,0,1,'',0),
	(157,'添加子级分区',96,'System/addChildArea',0,4,1,'',0),
	(159,'人员离职登记',50,'Register/leaveOffice',0,10,0,'',0),
	(160,'新增离职登记',159,'Register/addLeave',0,1,1,'',0),
	(161,'编辑离职资料',159,'Register/editLeave',0,2,1,'',0),
	(162,'工作类型等级',50,'Personnel/workTypeLevel',0,8,0,'',0),
	(163,'新增工作类型等级',162,'Personnel/addWorkLevel',0,1,1,'',0),
	(164,'编辑工作类型等级',162,'Personnel/editWorkLevel',0,2,1,'',0),
	(165,'获取工作类型等级',75,'Personnel/get_work_type_level',0,4,1,'',0),
	(166,'岗位异动',50,'Register/positionChange',0,11,0,'',0),
	(167,'岗位异动登记',166,'Register/addChange',0,1,1,'',0),
	(168,'获取员工详情',167,'Register/get_staff',0,0,1,'',0),
	(169,'招聘申请',50,'Register/recruitmentApply',0,12,0,'',0),
	(170,'新增招聘申请',169,'Register/addRecruitment',0,1,1,'',0),
	(171,'编辑招聘申请',169,'Register/editRecruitment',0,2,1,'',0),
	(172,'删除招聘申请',169,'Register/delRecruitment',0,3,1,'',0),
	(173,'根据岗位id获取对应工作类型和等级',167,'Register/get_position_info',0,2,1,'',0),
	(174,'获取可用shop_code',0,'Personnel/getShopCode',0,0,1,'',0),
	(175,'专业团队设定',91,'System/teamSet',0,2,0,'',0),
	(176,'新增专业团队',175,'System/addTeam',0,1,1,'',0),
	(177,'编辑专业团队',175,'System/editTeam',0,2,1,'',0),
	(178,'删除专业团队',175,'System/delTeam',0,3,1,'',0),
	(179,'工作类型等级',50,'Personnel/workTypeLevel',0,8,0,'',0),
	(180,'新增工作类型等级',162,'Personnel/addWorkLevel',0,1,1,'',0),
	(181,'编辑工作类型等级',162,'Personnel/editWorkLevel',0,2,1,'',0),
	(182,'获取工作类型等级',75,'Personnel/get_work_type_level',0,4,1,'',0),
	(183,'离职人员',50,'personnel/leaveStaff',0,8,0,'',0),
	(184,'查看详情',183,'personnel/leaveInfo',0,1,1,'',0),
	(185,'工作类型等级',50,'Personnel/workTypeLevel',0,8,0,'',0),
	(186,'新增工作类型等级',162,'Personnel/addWorkLevel',0,1,1,'',0),
	(187,'编辑工作类型等级',162,'Personnel/editWorkLevel',0,2,1,'',0),
	(188,'获取工作类型等级',75,'Personnel/get_work_type_level',0,4,1,'',0),
	(192,'离职人员',50,'personnel/leaveStaff',0,8,0,'',0),
	(193,'查看详情',183,'personnel/leaveInfo',0,1,1,'',0),
	(1000,'访问控制',2,'System/acl',0,1,0,'',0),
	(1001,'添加白名单',1000,'System/acladd',0,1,1,'',0),
	(1002,'删除白名单',1000,'System/acldel',0,1,1,'',0),
	(1003,'密钥管理',1000,'System/acltoken',0,1,1,'',0),
	(1004,'密钥添加',1000,'System/acltokenadd',0,1,1,'',0),
	(1005,'密钥删除',1000,'System/acltokendel',0,1,1,'',0),
	(1006,'白名单开关',1000,'System/aclstatus',0,1,1,'',0),
	(1007,'短信日志',2,'SmsLog/index',0,1,0,'',0),
	(1008,'列表',1007,'SmsLog/ajaxGetIndex',0,1,1,'',0),
	(1009,'删除',1007,'SmsLog/del',0,1,1,'',0),
	(1010,'人员导出',74,'personnel/exportStaff',0,12,1,'',0),
	(1019,'员工密码设定',2,'System/passwordSet',0,0,0,'',0),
	(1020,'新增密码设定',181,'System/addPasswordSet',0,1,1,'',0),
	(1021,'编辑密码设定',181,'System/editPasswordSet',0,3,1,'',0),
	(1022,'删除密码设定',181,'System/delPasswordSet',0,3,1,'',0),
	(1026,'ajax请求部门下小组',65,'personnel/searchGroup',0,4,1,'',0),
	(1027,'ajax请求下级省市区',65,'personnel/getNextAddress',0,4,1,'',0),
	(1028,'ajax请求下级省市区',65,'personnel/getNextAddress',0,4,1,'',0),
	(1030,'地址设定',91,'personnel/address',0,1,0,'',0),
	(1031,'添加子级地址',1030,'personnel/addChildAddress',0,1,1,'',0),
	(1032,'删除地址',1030,'personnel/delAddress',0,2,1,'',0),
	(1033,'编辑地址',1030,'personnel/editAddress',0,3,1,'',0),
	(1034,'新增地址',1030,'personnel/addAddress',0,4,1,'',0),
	(1035,'ajax请求地址',1030,'personnel/address_search',0,6,1,'',0),
	(1036,'获取绑定的地址',1030,'Personnel/getAddressName',0,7,1,'',0),
	(1037,'员工导入',50,'Import/importStaff',0,0,0,'',0),
	(1038,'文件上传',50,'Import/uploadExcel',0,0,1,'',0),
	(1039,'删除导入记录',50,'Import/deleteImport',0,0,1,'',0),
	(1040,'执行导入',50,'Import/doImport',0,0,1,'',0),
	(1041,'导入进度',50,'Import/getImportPercent',0,0,1,'',0),
	(1042,'导入详情',50,'Import/detailImport',0,0,1,'',0),
	(1043,'修改明细',50,'Import/updateImportDetail',0,0,1,'',0),
	(1044,'离职人员删除',74,'Personnel/delLeaveStaff',0,99,1,'',0),
	(1045,'短信签名管理',91,'Sms/Sign',0,0,0,'',0),
	(1046,'短信模板管理',91,'Sms/Template',0,0,0,'',0),
	(1047,'短信签名新增',1045,'Sms/Signadd',0,0,1,'',0),
	(1048,'短信签名编辑',1045,'Sms/Signedit',0,0,1,'',0),
	(1049,'短信签名删除',1045,'Sms/Signdel',0,0,1,'',0),
	(1050,'短信模板删除',1046,'Sms/Templatedel',0,0,1,'',0),
	(1051,'短信模板编辑',1046,'Sms/Templateedit',0,0,1,'',0),
	(1052,'短信模板新增',1046,'Sms/Templateadd',0,0,1,'',0),
	(1054,'短信发送限额配置',128,'System/smslimit',0,0,1,'',0),
	(1055,'短信帐号设定',2,'Sms/Account',0,0,0,'',0),
	(1056,'职业设定',91,'System/professor',0,10,0,'',0),
	(1057,'职业添加',1056,'System/professoradd',0,0,1,'',0),
	(1058,'职业修改',1056,'System/professoredit',0,0,1,'',0),
	(1059,'职业删除',1056,'System/professordel',0,0,1,'',0),
	(1060,'院校设定',91,'System/school',0,11,0,'',0),
	(1061,'院校添加',1060,'System/schooladd',0,0,1,'',0),
	(1062,'院校编辑',1060,'System/schooledit',0,0,1,'',0),
	(1063,'院校删除',1060,'System/schooldel',0,0,1,'',0),
	(1065,'上传渠道图片',83,'Channel/upload',0,4,1,'',0),
	(1066,'短信余额',2,'sms/getBalance',0,4,1,'',0),
	(1067,'手机端登录时效',128,'system/appExpire',0,4,1,'',0),
	(1069,'更新注册码',0,'system/updateServerValid',1,1,1,'',0),
	(1070,'新云底片回调',128,'system/ydpMessage',0,4,1,'',0),
	(1071,'员工排重设定',128,'system/staffRepSet',0,5,1,'',0);

/*!40000 ALTER TABLE `api_menu` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table api_user
# ------------------------------------------------------------

DROP TABLE IF EXISTS `api_user`;

CREATE TABLE `api_user` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `username` varchar(64) NOT NULL DEFAULT '' COMMENT '用户名',
  `nickname` varchar(64) NOT NULL DEFAULT '' COMMENT '用户昵称',
  `password` char(32) NOT NULL DEFAULT '' COMMENT '用户密码',
  `regTime` int(10) NOT NULL DEFAULT '0' COMMENT '注册时间',
  `regIp` varchar(11) NOT NULL DEFAULT '' COMMENT '注册IP',
  `updateTime` int(10) NOT NULL DEFAULT '0' COMMENT '更新时间',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '账号状态 0封号 1正常',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='管理员认证信息';

LOCK TABLES `api_user` WRITE;
/*!40000 ALTER TABLE `api_user` DISABLE KEYS */;

INSERT INTO `api_user` (`id`, `username`, `nickname`, `password`, `regTime`, `regIp`, `updateTime`, `status`)
VALUES
	(1,'root','root','912601e4ad1b308c9ae41877cf6ca754',1492004246,'3682992231',1492236545,1);

/*!40000 ALTER TABLE `api_user` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table api_user_action
# ------------------------------------------------------------

DROP TABLE IF EXISTS `api_user_action`;

CREATE TABLE `api_user_action` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `actionName` varchar(50) NOT NULL DEFAULT '' COMMENT '行为名称',
  `uid` varchar(100) NOT NULL DEFAULT '0' COMMENT '操作用户ID',
  `nickname` varchar(50) NOT NULL DEFAULT '' COMMENT '用户昵称',
  `addTime` int(11) NOT NULL DEFAULT '0' COMMENT '操作时间',
  `data` text COMMENT '用户提交的数据',
  `url` varchar(200) NOT NULL DEFAULT '' COMMENT '操作URL',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='用户操作日志';



# Dump of table api_user_data
# ------------------------------------------------------------

DROP TABLE IF EXISTS `api_user_data`;

CREATE TABLE `api_user_data` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `loginTimes` int(11) DEFAULT NULL COMMENT '账号登录次数',
  `lastLoginIp` varchar(11) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT '' COMMENT '最后登录IP',
  `lastLoginTime` int(11) DEFAULT NULL COMMENT '最后登录时间',
  `uid` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT '' COMMENT '用户ID',
  `type` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='管理员数据表';

LOCK TABLES `api_user_data` WRITE;
/*!40000 ALTER TABLE `api_user_data` DISABLE KEYS */;

INSERT INTO `api_user_data` (`id`, `loginTimes`, `lastLoginIp`, `lastLoginTime`, `uid`, `type`)
VALUES
	(1,2,'2130706433',1553247924,'4',0),
	(2,811,'2886991873',1688613729,'1',0),
	(3,237,'3232235623',1525498687,'11',0),
	(4,1,'1007871377',1516983405,'13',0),
	(5,96,'1007871377',1522574824,'12',0),
	(6,1,'1946345567',1517715038,'GLB011',0),
	(7,2,'1946346887',1519721939,'KF001',0),
	(8,8,'3747942483',1521432130,'14',0),
	(9,12,'3747942562',1523943650,'JT0014',0),
	(10,20,'3747942475',1524886551,'JT0016',0),
	(11,51,'3728661422',1525229212,'JT0021',0),
	(12,36,'3747909143',1525319007,'JT0018',0),
	(13,31,'1864015186',1525253423,'JT0020',0),
	(14,24,'3735760466',1525316182,'JT0017',0),
	(15,44,'1007871377',1525314717,'GLB019',0),
	(16,29,'1946348226',1525323365,'JT0015',0),
	(17,21,'3054638165',1525325898,'JT0019',0),
	(18,65,'1946346346',1522739037,'17',0),
	(19,2,'1007871377',1521947003,'16',0),
	(20,1,'1946345742',1521962893,'QQLPWX001',0),
	(21,6,'611219035',1523518680,'S001',0),
	(22,1,'3726729700',1522300481,'A001',0),
	(23,1,'1946348353',1522375024,'DJFRDS002',0),
	(24,7,'30123311',1523342233,'GLB025',0),
	(25,5,'1946347204',1525240965,'18',0),
	(26,3,'1946346346',1522736732,'19',0),
	(27,22,'1007871373',1524466244,'20',0),
	(28,4,'3726805214',1523848929,'GLB029',0),
	(29,1,'1946347376',1522821967,'CDJFR001',0),
	(30,2,'3054638165',1524562317,'BJFRDS016',0),
	(31,1,'30124611',1523960455,'SQD010',0),
	(32,1,'3747942400',1524187758,'S055',0),
	(33,1,'3747942451',1524211259,'GLB030',0),
	(34,2,'3747909143',1524445617,'DJFRSY013',0),
	(35,1,'3054638165',1524562251,'HEBJFRD043',0),
	(36,1,'3054638165',1524562281,'BJJFRD011',0),
	(37,2,'1946349004',1524878677,'JT0003',0),
	(38,1,'2130706433',1527565566,'3',0),
	(39,117,'2130706433',1565145763,'2',0),
	(40,2,'2130706433',1536804070,'LJ007',0),
	(41,22,'3232235530',0,'432',1),
	(42,2,'2886991873',0,NULL,1),
	(43,7,'2886991873',0,'8',0),
	(44,25,'3232235530',1685527472,'2029',1),
	(45,16,'3232235530',1682399022,'2035',1),
	(46,5,'3232235530',1682045840,'2039',1),
	(47,2,'3232235530',1684460045,'2027',1);

/*!40000 ALTER TABLE `api_user_data` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table app_version
# ------------------------------------------------------------

DROP TABLE IF EXISTS `app_version`;

CREATE TABLE `app_version` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `version` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `up_time` datetime DEFAULT NULL,
  `up_sql` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='应用版本管理';

LOCK TABLES `app_version` WRITE;
/*!40000 ALTER TABLE `app_version` DISABLE KEYS */;

INSERT INTO `app_version` (`id`, `version`, `up_time`, `up_sql`)
VALUES
	(106,'2.0.0','2023-03-07 11:51:00',''),
	(107,'2.0.1','2023-03-11 14:25:39',' INSERT INTO `api_list`  (`apiName`,`apiUrl`,`app_id`,`hash`,`accessToken`,`needLogin`,`status`,`method`,`info`,`isTest`)  SELECT \'联合登录验证\',\'Staff/checkStaffSession\',\'3\',\'erds200ccc905078\',\'1\',\'0\',\'1\',\'1\',\'微信退款\',\'0\' '),
	(108,'2.0.2','2023-06-28 20:49:24','');

/*!40000 ALTER TABLE `app_version` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table c_sysconfig
# ------------------------------------------------------------

DROP TABLE IF EXISTS `c_sysconfig`;

CREATE TABLE `c_sysconfig` (
  `ckey` varchar(50) COLLATE utf8_unicode_ci NOT NULL COMMENT '配置KEY，系统写死',
  `cvalue` text COLLATE utf8_unicode_ci COMMENT '配置内容，存JSON数据',
  PRIMARY KEY (`ckey`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='相关的配置参数。';

LOCK TABLES `c_sysconfig` WRITE;
/*!40000 ALTER TABLE `c_sysconfig` DISABLE KEYS */;

INSERT INTO `c_sysconfig` (`ckey`, `cvalue`)
VALUES
	('acl','0'),
	('app_expire','0'),
	('kuaidi100','{\"key\":null,\"customer\":null}'),
	('sign_sms','{\"is_sign\":null}'),
	('sms','{\"1\":{\"title\":\"\\u65f6\\u5c1a\\u7ecf\\u5178\\u4f1a\\u5458\\u4e2d\\u5fc3\",\"user\":\"ssjd\",\"psw\":\"ssjd123654\",\"drive\":\"Huaxin\",\"sign\":\"\\u65f6\\u5c1a\\u7ecf\\u5178\",\"domain\":\"https:\\/\\/dx.ipyy.net\"},\"2\":{\"title\":\"ERP\\u77ed\\u4fe1\\u5e10\\u53f7\",\"user\":\"ssjderp\",\"psw\":\"erp0428\",\"drive\":\"Huaxin\",\"sign\":\"\\u65f6\\u5c1a\\u7ecf\\u5178\",\"domain\":\"https:\\/\\/dx.ipyy.net\"},\"3\":{\"title\":\" 0518\\u6d4b\\u8bd5\",\"user\":\"suxuantech002\",\"psw\":\"Suxuantech0518\",\"drive\":\"ZhuTong\",\"sign\":\"\\u7d20\\u7384\\u79d1\\u6280\",\"domain\":\"http:\\/\\/www.ztsms.cn\\/\"}}'),
	('sms_limit','{\"sms_mobile_day_limit\":20,\"sms_mobile_hour_limit\":5,\"sms_mobile_same_secend_limit\":600}'),
	('staff_weixin_Offica','0'),
	('wx_global','{\"wx_token\":\"\"}'),
	('ydp_wxmessage_key','f34ff434k0o2e3et'),
	('ydp_wxmessage_remark','基材艺术硕士'),
	('ydp_wxmessage_template','dvav'),
	('yx_sms','{\"yx_user\":\"\",\"yx_psw\":\"\",\"yx_domain\":\"\",\"yx_sign\":\"\",\"yx_drive\":\"\"}');

/*!40000 ALTER TABLE `c_sysconfig` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table m_users
# ------------------------------------------------------------

DROP TABLE IF EXISTS `m_users`;

CREATE TABLE `m_users` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `openid` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `username` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sex` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  `last_login_time` datetime DEFAULT NULL,
  `last_login_ip` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `headimgurl` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `openid` (`openid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

LOCK TABLES `m_users` WRITE;
/*!40000 ALTER TABLE `m_users` DISABLE KEYS */;

INSERT INTO `m_users` (`id`, `openid`, `username`, `sex`, `create_time`, `last_login_time`, `last_login_ip`, `headimgurl`)
VALUES
	(422,'o3mGr0iz8l7_gptL0cFB-rvSq6Yo','',NULL,'2020-04-19 18:13:25','2020-04-22 17:38:02','127.0.0.1',NULL);

/*!40000 ALTER TABLE `m_users` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table o_pay_order
# ------------------------------------------------------------

DROP TABLE IF EXISTS `o_pay_order`;

CREATE TABLE `o_pay_order` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `appid` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '公众帐号ID，非微信支付留空',
  `mch_id` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '微信商户号',
  `device_info` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '设备号（门店CODE）',
  `nonce_str` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '随机字符串',
  `sign` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '签名',
  `body` varchar(256) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '商品描述',
  `detail` text COLLATE utf8_unicode_ci COMMENT '详情',
  `attach` varchar(256) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '符加参数',
  `out_trade_no` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '商户订单号',
  `auth_code` varchar(256) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '扫码支付时，扫到的授权码',
  `fee_type` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '币种',
  `total_fee` int(11) DEFAULT NULL COMMENT '总金额',
  `discount_fee` int(11) DEFAULT NULL COMMENT '总共优惠金额',
  `spbill_create_ip` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '请求端IP',
  `time_start` datetime DEFAULT NULL COMMENT '交易起始时间',
  `time_expire` datetime DEFAULT NULL COMMENT '交易过期时间',
  `goods_tag` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '标记（微信可用于优惠标记）',
  `notify_url` varchar(256) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '回调地址',
  `trade_type` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '交易类型',
  `product_id` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '商品编号',
  `limit_pay` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '指定支付类型',
  `openid` varchar(256) COLLATE utf8_unicode_ci DEFAULT NULL,
  `other` text COLLATE utf8_unicode_ci COMMENT '其他信息',
  `prepay_id` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '支付网关返回支付会话标识',
  `code_url` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '如果是扫码支付，则返回扫码字符串',
  `gateway_status` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '网关返回状态',
  `pay_status` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '支付状态，INIT 初始，PAYED已支付。ERROR 错误',
  `transaction_id` varchar(256) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '第三方支付的交易单号',
  `pay_fee` int(11) DEFAULT NULL COMMENT '支付金额',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '店代码',
  `shop_id` int(11) DEFAULT NULL COMMENT '店ID',
  `brand_id` int(11) DEFAULT NULL COMMENT '品牌ID',
  `callback_url` varchar(300) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `out_trade_no` (`out_trade_no`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table o_pay_order_notify
# ------------------------------------------------------------

DROP TABLE IF EXISTS `o_pay_order_notify`;

CREATE TABLE `o_pay_order_notify` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `content` text COLLATE utf8_unicode_ci COMMENT '消息主体',
  `create_time` datetime DEFAULT NULL COMMENT '接收到的时间',
  `request_ip` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '请求者的IP地址',
  `check_result` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '检测结果验证结果，记录备查',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table o_pay_refund
# ------------------------------------------------------------

DROP TABLE IF EXISTS `o_pay_refund`;

CREATE TABLE `o_pay_refund` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `appid` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `mch_id` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `nonce_str` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '随机字符串',
  `out_refund_no` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '商户退款单号',
  `refund_id` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '微信退款单号',
  `transaction_id` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '微信订单号',
  `out_trade_no` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '商户订单号',
  `total_fee` int(11) DEFAULT NULL COMMENT '总支付金额',
  `refund_fee` int(11) DEFAULT NULL COMMENT '退款金额',
  `sign` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '签名',
  `status` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '退款状态,成功SUCCESS',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_id` int(11) DEFAULT NULL,
  `brand_id` int(11) DEFAULT NULL,
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='微信支付退款';



# Dump of table oa_app_version
# ------------------------------------------------------------

DROP TABLE IF EXISTS `oa_app_version`;

CREATE TABLE `oa_app_version` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `version` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `up_time` datetime DEFAULT NULL,
  `up_sql` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='应用版本管理';



# Dump of table s_acceptoraddress
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_acceptoraddress`;

CREATE TABLE `s_acceptoraddress` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `acceptoraddress_name` varchar(100) CHARACTER SET utf8 DEFAULT NULL,
  `shop_name` varchar(100) CHARACTER SET utf8 DEFAULT NULL,
  `shop_code` varchar(100) CHARACTER SET utf8 DEFAULT NULL,
  `setkey` varchar(100) CHARACTER SET utf8 DEFAULT NULL,
  `brandclass_ids` text CHARACTER SET utf8 COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COMMENT='接单点';



# Dump of table s_acl_list
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_acl_list`;

CREATE TABLE `s_acl_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ip` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `memo` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  `add_type` tinyint(1) DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  `create_user_id` int(11) DEFAULT NULL,
  `create_user_name` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  `create_ip` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

LOCK TABLES `s_acl_list` WRITE;
/*!40000 ALTER TABLE `s_acl_list` DISABLE KEYS */;

INSERT INTO `s_acl_list` (`id`, `ip`, `memo`, `add_type`, `create_time`, `create_user_id`, `create_user_name`, `update_time`, `create_ip`)
VALUES
	(1,'192.168.7.10','可以',2,'2023-02-22 10:16:53',1,'root','2023-02-22 10:16:53','127.0.0.1');

/*!40000 ALTER TABLE `s_acl_list` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table s_acl_token
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_acl_token`;

CREATE TABLE `s_acl_token` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `token` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `memo` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  `create_ip` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `create_user_id` int(11) DEFAULT NULL,
  `create_user_name` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

LOCK TABLES `s_acl_token` WRITE;
/*!40000 ALTER TABLE `s_acl_token` DISABLE KEYS */;

INSERT INTO `s_acl_token` (`id`, `token`, `memo`, `create_time`, `create_ip`, `create_user_id`, `create_user_name`)
VALUES
	(1,'1','1','2023-02-22 10:16:30','127.0.0.1',1,'root');

/*!40000 ALTER TABLE `s_acl_token` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table s_acl_token_logs
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_acl_token_logs`;

CREATE TABLE `s_acl_token_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `token` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ip` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  `result` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table s_address
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_address`;

CREATE TABLE `s_address` (
  `id` smallint(5) NOT NULL AUTO_INCREMENT,
  `pid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `name` varchar(120) NOT NULL DEFAULT '',
  `type` tinyint(1) NOT NULL DEFAULT '2',
  `order_sort` varchar(200) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT '',
  `path` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

LOCK TABLES `s_address` WRITE;
/*!40000 ALTER TABLE `s_address` DISABLE KEYS */;

INSERT INTO `s_address` (`id`, `pid`, `name`, `type`, `order_sort`, `path`)
VALUES
	(1,0,'中国',0,'',NULL),
	(2,1,'北京',1,'',NULL),
	(3,1,'天津',1,'',NULL),
	(4,1,'河北省',1,'',NULL),
	(5,1,'山西省',1,'',NULL),
	(6,1,'内蒙古自治区',1,'',NULL),
	(7,1,'辽宁省',1,'',NULL),
	(8,1,'吉林省',1,'',NULL),
	(9,1,'黑龙江省',1,'',NULL),
	(10,1,'上海',1,'',NULL),
	(11,1,'江苏省',1,'',NULL),
	(12,1,'浙江省',1,'',NULL),
	(13,1,'安徽省',1,'',NULL),
	(14,1,'福建省',1,'',NULL),
	(15,1,'江西省',1,'',NULL),
	(16,1,'山东省',1,'',NULL),
	(17,1,'河南省',1,'',NULL),
	(18,1,'湖北省',1,'',NULL),
	(19,1,'湖南省',1,'',NULL),
	(20,1,'广东省',1,'',NULL),
	(21,1,'广西壮族自治区',1,'',NULL),
	(22,1,'海南省',1,'',NULL),
	(23,1,'重庆',1,'',NULL),
	(24,1,'四川省',1,'',NULL),
	(25,1,'贵州省',1,'',NULL),
	(26,1,'云南省',1,'',NULL),
	(27,1,'西藏自治区',1,'',NULL),
	(28,1,'陕西省',1,'',NULL),
	(29,1,'甘肃省',1,'',NULL),
	(30,1,'青海省',1,'',NULL),
	(31,1,'宁夏回族自治区',1,'',NULL),
	(32,1,'新疆维吾尔自治区',1,'',NULL),
	(33,1,'台湾',1,'',NULL),
	(34,1,'香港特别行政区',1,'',NULL),
	(35,1,'澳门特别行政区',1,'',NULL),
	(36,1,'海外',1,'',NULL),
	(37,2,'北京市',2,'',NULL),
	(38,3,'天津市',2,'',NULL),
	(39,4,'石家庄市',2,'',NULL),
	(40,4,'唐山市',2,'',NULL),
	(41,4,'秦皇岛市',2,'',NULL),
	(42,4,'邯郸市',2,'',NULL),
	(43,4,'邢台市',2,'',NULL),
	(44,4,'保定市',2,'',NULL),
	(45,4,'张家口市',2,'',NULL),
	(46,4,'承德市',2,'',NULL),
	(47,4,'沧州市',2,'',NULL),
	(48,4,'廊坊市',2,'',NULL),
	(49,4,'衡水市',2,'',NULL),
	(50,5,'太原市',2,'',NULL),
	(51,5,'大同市',2,'',NULL),
	(52,5,'阳泉市',2,'',NULL),
	(53,5,'长治市',2,'',NULL),
	(54,5,'晋城市',2,'',NULL),
	(55,5,'朔州市',2,'',NULL),
	(56,5,'晋中市',2,'',NULL),
	(57,5,'运城市',2,'',NULL),
	(58,5,'忻州市',2,'',NULL),
	(59,5,'临汾市',2,'',NULL),
	(60,5,'吕梁市',2,'',NULL),
	(61,6,'呼和浩特市',2,'',NULL),
	(62,6,'包头市',2,'',NULL),
	(63,6,'乌海市',2,'',NULL),
	(64,6,'赤峰市',2,'',NULL),
	(65,6,'通辽市',2,'',NULL),
	(66,6,'鄂尔多斯市',2,'',NULL),
	(67,6,'呼伦贝尔市',2,'',NULL),
	(68,6,'巴彦淖尔市',2,'',NULL),
	(69,6,'乌兰察布市',2,'',NULL),
	(70,6,'兴安盟',2,'',NULL),
	(71,6,'锡林郭勒盟',2,'',NULL),
	(72,6,'阿拉善盟',2,'',NULL),
	(73,7,'沈阳市',2,'',NULL),
	(74,7,'大连市',2,'',NULL),
	(75,7,'鞍山市',2,'',NULL),
	(76,7,'抚顺市',2,'',NULL),
	(77,7,'本溪市',2,'',NULL),
	(78,7,'丹东市',2,'',NULL),
	(79,7,'锦州市',2,'',NULL),
	(80,7,'营口市',2,'',NULL),
	(81,7,'阜新市',2,'',NULL),
	(82,7,'辽阳市',2,'',NULL),
	(83,7,'盘锦市',2,'',NULL),
	(84,7,'铁岭市',2,'',NULL),
	(85,7,'朝阳市',2,'',NULL),
	(86,7,'葫芦岛市',2,'',NULL),
	(87,8,'长春市',2,'',NULL),
	(88,8,'吉林市',2,'',NULL),
	(89,8,'四平市',2,'',NULL),
	(90,8,'辽源市',2,'',NULL),
	(91,8,'通化市',2,'',NULL),
	(92,8,'白山市',2,'',NULL),
	(93,8,'松原市',2,'',NULL),
	(94,8,'白城市',2,'',NULL),
	(95,8,'延边朝鲜族自治州',2,'',NULL),
	(96,9,'哈尔滨市',2,'',NULL),
	(97,9,'齐齐哈尔市',2,'',NULL),
	(98,9,'鸡西市',2,'',NULL),
	(99,9,'鹤岗市',2,'',NULL),
	(100,9,'双鸭山市',2,'',NULL),
	(101,9,'大庆市',2,'',NULL),
	(102,9,'伊春市',2,'',NULL),
	(103,9,'佳木斯市',2,'',NULL),
	(104,9,'七台河市',2,'',NULL),
	(105,9,'牡丹江市',2,'',NULL),
	(106,9,'黑河市',2,'',NULL),
	(107,9,'绥化市',2,'',NULL),
	(108,9,'大兴安岭地区',2,'',NULL),
	(109,10,'上海市',2,'',NULL),
	(110,11,'南京市',2,'',NULL),
	(111,11,'无锡市',2,'',NULL),
	(112,11,'徐州市',2,'',NULL),
	(113,11,'常州市',2,'',NULL),
	(114,11,'苏州市',2,'',NULL),
	(115,11,'南通市',2,'',NULL),
	(116,11,'连云港市',2,'',NULL),
	(117,11,'淮安市',2,'',NULL),
	(118,11,'盐城市',2,'',NULL),
	(119,11,'扬州市',2,'',NULL),
	(120,11,'镇江市',2,'',NULL),
	(121,11,'泰州市',2,'',NULL),
	(122,11,'宿迁市',2,'',NULL),
	(123,12,'杭州市',2,'',NULL),
	(124,12,'宁波市',2,'',NULL),
	(125,12,'温州市',2,'',NULL),
	(126,12,'嘉兴市',2,'',NULL),
	(127,12,'湖州市',2,'',NULL),
	(128,12,'绍兴市',2,'',NULL),
	(129,12,'金华市',2,'',NULL),
	(130,12,'衢州市',2,'',NULL),
	(131,12,'舟山市',2,'',NULL),
	(132,12,'台州市',2,'',NULL),
	(133,12,'丽水市',2,'',NULL),
	(134,13,'合肥市',2,'',NULL),
	(135,13,'芜湖市',2,'',NULL),
	(136,13,'蚌埠市',2,'',NULL),
	(137,13,'淮南市',2,'',NULL),
	(138,13,'马鞍山市',2,'',NULL),
	(139,13,'淮北市',2,'',NULL),
	(140,13,'铜陵市',2,'',NULL),
	(141,13,'安庆市',2,'',NULL),
	(142,13,'黄山市',2,'',NULL),
	(143,13,'滁州市',2,'',NULL),
	(144,13,'阜阳市',2,'',NULL),
	(145,13,'宿州市',2,'',NULL),
	(146,13,'六安市',2,'',NULL),
	(147,13,'亳州市',2,'',NULL),
	(148,13,'池州市',2,'',NULL),
	(149,13,'宣城市',2,'',NULL),
	(150,14,'福州市',2,'',NULL),
	(151,14,'厦门市',2,'',NULL),
	(152,14,'莆田市',2,'',NULL),
	(153,14,'三明市',2,'',NULL),
	(154,14,'泉州市',2,'',NULL),
	(155,14,'漳州市',2,'',NULL),
	(156,14,'南平市',2,'',NULL),
	(157,14,'龙岩市',2,'',NULL),
	(158,14,'宁德市',2,'',NULL),
	(159,15,'南昌市',2,'',NULL),
	(160,15,'景德镇市',2,'',NULL),
	(161,15,'萍乡市',2,'',NULL),
	(162,15,'九江市',2,'',NULL),
	(163,15,'新余市',2,'',NULL),
	(164,15,'鹰潭市',2,'',NULL),
	(165,15,'赣州市',2,'',NULL),
	(166,15,'吉安市',2,'',NULL),
	(167,15,'宜春市',2,'',NULL),
	(168,15,'抚州市',2,'',NULL),
	(169,15,'上饶市',2,'',NULL),
	(170,16,'济南市',2,'',NULL),
	(171,16,'青岛市',2,'',NULL),
	(172,16,'淄博市',2,'',NULL),
	(173,16,'枣庄市',2,'',NULL),
	(174,16,'东营市',2,'',NULL),
	(175,16,'烟台市',2,'',NULL),
	(176,16,'潍坊市',2,'',NULL),
	(177,16,'济宁市',2,'',NULL),
	(178,16,'泰安市',2,'',NULL),
	(179,16,'威海市',2,'',NULL),
	(180,16,'日照市',2,'',NULL),
	(181,16,'莱芜市',2,'',NULL),
	(182,16,'临沂市',2,'',NULL),
	(183,16,'德州市',2,'',NULL),
	(184,16,'聊城市',2,'',NULL),
	(185,16,'滨州市',2,'',NULL),
	(186,16,'菏泽市',2,'',NULL),
	(187,17,'郑州市',2,'',NULL),
	(188,17,'开封市',2,'',NULL),
	(189,17,'洛阳市',2,'',NULL),
	(190,17,'平顶山市',2,'',NULL),
	(191,17,'安阳市',2,'',NULL),
	(192,17,'鹤壁市',2,'',NULL),
	(193,17,'新乡市',2,'',NULL),
	(194,17,'焦作市',2,'',NULL),
	(195,17,'濮阳市',2,'',NULL),
	(196,17,'许昌市',2,'',NULL),
	(197,17,'漯河市',2,'',NULL),
	(198,17,'三门峡市',2,'',NULL),
	(199,17,'南阳市',2,'',NULL),
	(200,17,'商丘市',2,'',NULL),
	(201,17,'信阳市',2,'',NULL),
	(202,17,'周口市',2,'',NULL),
	(203,17,'驻马店市',2,'',NULL),
	(204,18,'武汉市',2,'',NULL),
	(205,18,'黄石市',2,'',NULL),
	(206,18,'十堰市',2,'',NULL),
	(207,18,'宜昌市',2,'',NULL),
	(208,18,'襄阳市',2,'',NULL),
	(209,18,'鄂州市',2,'',NULL),
	(210,18,'荆门市',2,'',NULL),
	(211,18,'孝感市',2,'',NULL),
	(212,18,'荆州市',2,'',NULL),
	(213,18,'黄冈市',2,'',NULL),
	(214,18,'咸宁市',2,'',NULL),
	(215,18,'随州市',2,'',NULL),
	(216,18,'恩施土家族苗族自治州',2,'',NULL),
	(217,19,'长沙市',2,'',NULL),
	(218,19,'株洲市',2,'',NULL),
	(219,19,'湘潭市',2,'',NULL),
	(220,19,'衡阳市',2,'',NULL),
	(221,19,'邵阳市',2,'',NULL),
	(222,19,'岳阳市',2,'',NULL),
	(223,19,'常德市',2,'',NULL),
	(224,19,'张家界市',2,'',NULL),
	(225,19,'益阳市',2,'',NULL),
	(226,19,'郴州市',2,'',NULL),
	(227,19,'永州市',2,'',NULL),
	(228,19,'怀化市',2,'',NULL),
	(229,19,'娄底市',2,'',NULL),
	(230,19,'湘西土家族苗族自治州',2,'',NULL),
	(231,20,'广州市',2,'',NULL),
	(232,20,'韶关市',2,'',NULL),
	(233,20,'深圳市',2,'',NULL),
	(234,20,'珠海市',2,'',NULL),
	(235,20,'汕头市',2,'',NULL),
	(236,20,'佛山市',2,'',NULL),
	(237,20,'江门市',2,'',NULL),
	(238,20,'湛江市',2,'',NULL),
	(239,20,'茂名市',2,'',NULL),
	(240,20,'肇庆市',2,'',NULL),
	(241,20,'惠州市',2,'',NULL),
	(242,20,'梅州市',2,'',NULL),
	(243,20,'汕尾市',2,'',NULL),
	(244,20,'河源市',2,'',NULL),
	(245,20,'阳江市',2,'',NULL),
	(246,20,'清远市',2,'',NULL),
	(247,20,'东莞市',2,'',NULL),
	(248,20,'中山市',2,'',NULL),
	(249,20,'东沙群岛',2,'',NULL),
	(250,20,'潮州市',2,'',NULL),
	(251,20,'揭阳市',2,'',NULL),
	(252,20,'云浮市',2,'',NULL),
	(253,21,'南宁市',2,'',NULL),
	(254,21,'柳州市',2,'',NULL),
	(255,21,'桂林市',2,'',NULL),
	(256,21,'梧州市',2,'',NULL),
	(257,21,'北海市',2,'',NULL),
	(258,21,'防城港市',2,'',NULL),
	(259,21,'钦州市',2,'',NULL),
	(260,21,'贵港市',2,'',NULL),
	(261,21,'玉林市',2,'',NULL),
	(262,21,'百色市',2,'',NULL),
	(263,21,'贺州市',2,'',NULL),
	(264,21,'河池市',2,'',NULL),
	(265,21,'来宾市',2,'',NULL),
	(266,21,'崇左市',2,'',NULL),
	(267,22,'海口市',2,'',NULL),
	(268,22,'三亚市',2,'',NULL),
	(269,22,'三沙市',2,'',NULL),
	(270,23,'重庆市',2,'',NULL),
	(271,24,'成都市',2,'',NULL),
	(272,24,'自贡市',2,'',NULL),
	(273,24,'攀枝花市',2,'',NULL),
	(274,24,'泸州市',2,'',NULL),
	(275,24,'德阳市',2,'',NULL),
	(276,24,'绵阳市',2,'',NULL),
	(277,24,'广元市',2,'',NULL),
	(278,24,'遂宁市',2,'',NULL),
	(279,24,'内江市',2,'',NULL),
	(280,24,'乐山市',2,'',NULL),
	(281,24,'南充市',2,'',NULL),
	(282,24,'眉山市',2,'',NULL),
	(283,24,'宜宾市',2,'',NULL),
	(284,24,'广安市',2,'',NULL),
	(285,24,'达州市',2,'',NULL),
	(286,24,'雅安市',2,'',NULL),
	(287,24,'巴中市',2,'',NULL),
	(288,24,'资阳市',2,'',NULL),
	(289,24,'阿坝藏族羌族自治州',2,'',NULL),
	(290,24,'甘孜藏族自治州',2,'',NULL),
	(291,24,'凉山彝族自治州',2,'',NULL),
	(292,25,'贵阳市',2,'',NULL),
	(293,25,'六盘水市',2,'',NULL),
	(294,25,'遵义市',2,'',NULL),
	(295,25,'安顺市',2,'',NULL),
	(296,25,'铜仁市',2,'',NULL),
	(297,25,'黔西南布依族苗族自治州',2,'',NULL),
	(298,25,'毕节市',2,'',NULL),
	(299,25,'黔东南苗族侗族自治州',2,'',NULL),
	(300,25,'黔南布依族苗族自治州',2,'',NULL),
	(301,26,'昆明市',2,'',NULL),
	(302,26,'曲靖市',2,'',NULL),
	(303,26,'玉溪市',2,'',NULL),
	(304,26,'保山市',2,'',NULL),
	(305,26,'昭通市',2,'',NULL),
	(306,26,'丽江市',2,'',NULL),
	(307,26,'普洱市',2,'',NULL),
	(308,26,'临沧市',2,'',NULL),
	(309,26,'楚雄彝族自治州',2,'',NULL),
	(310,26,'红河哈尼族彝族自治州',2,'',NULL),
	(311,26,'文山壮族苗族自治州',2,'',NULL),
	(312,26,'西双版纳傣族自治州',2,'',NULL),
	(313,26,'大理白族自治州',2,'',NULL),
	(314,26,'德宏傣族景颇族自治州',2,'',NULL),
	(315,26,'怒江傈僳族自治州',2,'',NULL),
	(316,26,'迪庆藏族自治州',2,'',NULL),
	(317,27,'拉萨市',2,'',NULL),
	(318,27,'昌都市',2,'',NULL),
	(319,27,'山南地区',2,'',NULL),
	(320,27,'日喀则市',2,'',NULL),
	(321,27,'那曲地区',2,'',NULL),
	(322,27,'阿里地区',2,'',NULL),
	(323,27,'林芝市',2,'',NULL),
	(324,28,'西安市',2,'',NULL),
	(325,28,'铜川市',2,'',NULL),
	(326,28,'宝鸡市',2,'',NULL),
	(327,28,'咸阳市',2,'',NULL),
	(328,28,'渭南市',2,'',NULL),
	(329,28,'延安市',2,'',NULL),
	(330,28,'汉中市',2,'',NULL),
	(331,28,'榆林市',2,'',NULL),
	(332,28,'安康市',2,'',NULL),
	(333,28,'商洛市',2,'',NULL),
	(334,29,'兰州市',2,'',NULL),
	(335,29,'嘉峪关市',2,'',NULL),
	(336,29,'金昌市',2,'',NULL),
	(337,29,'白银市',2,'',NULL),
	(338,29,'天水市',2,'',NULL),
	(339,29,'武威市',2,'',NULL),
	(340,29,'张掖市',2,'',NULL),
	(341,29,'平凉市',2,'',NULL),
	(342,29,'酒泉市',2,'',NULL),
	(343,29,'庆阳市',2,'',NULL),
	(344,29,'定西市',2,'',NULL),
	(345,29,'陇南市',2,'',NULL),
	(346,29,'临夏回族自治州',2,'',NULL),
	(347,29,'甘南藏族自治州',2,'',NULL),
	(348,30,'西宁市',2,'',NULL),
	(349,30,'海东市',2,'',NULL),
	(350,30,'海北藏族自治州',2,'',NULL),
	(351,30,'黄南藏族自治州',2,'',NULL),
	(352,30,'海南藏族自治州',2,'',NULL),
	(353,30,'果洛藏族自治州',2,'',NULL),
	(354,30,'玉树藏族自治州',2,'',NULL),
	(355,30,'海西蒙古族藏族自治州',2,'',NULL),
	(356,31,'银川市',2,'',NULL),
	(357,31,'石嘴山市',2,'',NULL),
	(358,31,'吴忠市',2,'',NULL),
	(359,31,'固原市',2,'',NULL),
	(360,31,'中卫市',2,'',NULL),
	(361,32,'乌鲁木齐市',2,'',NULL),
	(362,32,'克拉玛依市',2,'',NULL),
	(363,32,'吐鲁番市',2,'',NULL),
	(364,32,'哈密地区',2,'',NULL),
	(365,32,'昌吉回族自治州',2,'',NULL),
	(366,32,'博尔塔拉蒙古自治州',2,'',NULL),
	(367,32,'巴音郭楞蒙古自治州',2,'',NULL),
	(368,32,'阿克苏地区',2,'',NULL),
	(369,32,'克孜勒苏柯尔克孜自治州',2,'',NULL),
	(370,32,'喀什地区',2,'',NULL),
	(371,32,'和田地区',2,'',NULL),
	(372,32,'伊犁哈萨克自治州',2,'',NULL),
	(373,32,'塔城地区',2,'',NULL),
	(374,32,'阿勒泰地区',2,'',NULL),
	(375,33,'台北市',2,'',NULL),
	(376,33,'高雄市',2,'',NULL),
	(377,33,'台南市',2,'',NULL),
	(378,33,'台中市',2,'',NULL),
	(379,33,'金门县',2,'',NULL),
	(380,33,'南投县',2,'',NULL),
	(381,33,'基隆市',2,'',NULL),
	(382,33,'新竹市',2,'',NULL),
	(383,33,'嘉义市',2,'',NULL),
	(384,33,'新北市',2,'',NULL),
	(385,33,'宜兰县',2,'',NULL),
	(386,33,'新竹县',2,'',NULL),
	(387,33,'桃园县',2,'',NULL),
	(388,33,'苗栗县',2,'',NULL),
	(389,33,'彰化县',2,'',NULL),
	(390,33,'嘉义县',2,'',NULL),
	(391,33,'云林县',2,'',NULL),
	(392,33,'屏东县',2,'',NULL),
	(393,33,'台东县',2,'',NULL),
	(394,33,'花莲县',2,'',NULL),
	(395,33,'澎湖县',2,'',NULL),
	(396,33,'连江县',2,'',NULL),
	(397,34,'香港岛',2,'',NULL),
	(398,34,'九龙',2,'',NULL),
	(399,34,'新界',2,'',NULL),
	(400,35,'澳门半岛',2,'',NULL),
	(401,35,'离岛',2,'',NULL),
	(402,36,'海外',2,'',NULL),
	(403,37,'东城区',3,'',NULL),
	(404,37,'西城区',3,'',NULL),
	(405,37,'崇文区',3,'',NULL),
	(406,37,'宣武区',3,'',NULL),
	(407,37,'朝阳区',3,'',NULL),
	(408,37,'丰台区',3,'',NULL),
	(409,37,'石景山区',3,'',NULL),
	(410,37,'海淀区',3,'',NULL),
	(411,37,'门头沟区',3,'',NULL),
	(412,37,'房山区',3,'',NULL),
	(413,37,'通州区',3,'',NULL),
	(414,37,'顺义区',3,'',NULL),
	(415,37,'昌平区',3,'',NULL),
	(416,37,'大兴区',3,'',NULL),
	(417,37,'怀柔区',3,'',NULL),
	(418,37,'平谷区',3,'',NULL),
	(419,37,'密云县',3,'',NULL),
	(420,37,'延庆县',3,'',NULL),
	(421,37,'其它区',3,'',NULL),
	(422,38,'和平区',3,'',NULL),
	(423,38,'河东区',3,'',NULL),
	(424,38,'河西区',3,'',NULL),
	(425,38,'南开区',3,'',NULL),
	(426,38,'河北区',3,'',NULL),
	(427,38,'红桥区',3,'',NULL),
	(428,38,'塘沽区',3,'',NULL),
	(429,38,'汉沽区',3,'',NULL),
	(430,38,'大港区',3,'',NULL),
	(431,38,'东丽区',3,'',NULL),
	(432,38,'西青区',3,'',NULL),
	(433,38,'津南区',3,'',NULL),
	(434,38,'北辰区',3,'',NULL),
	(435,38,'武清区',3,'',NULL),
	(436,38,'宝坻区',3,'',NULL),
	(437,38,'滨海新区',3,'',NULL),
	(438,38,'宁河县',3,'',NULL),
	(439,38,'静海县',3,'',NULL),
	(440,38,'蓟县',3,'',NULL),
	(441,38,'其它区',3,'',NULL),
	(442,39,'长安区',3,'',NULL),
	(443,39,'桥东区',3,'',NULL),
	(444,39,'桥西区',3,'',NULL),
	(445,39,'新华区',3,'',NULL),
	(446,39,'井陉矿区',3,'',NULL),
	(447,39,'裕华区',3,'',NULL),
	(448,39,'井陉县',3,'',NULL),
	(449,39,'正定县',3,'',NULL),
	(450,39,'栾城区',3,'',NULL),
	(451,39,'行唐县',3,'',NULL),
	(452,39,'灵寿县',3,'',NULL),
	(453,39,'高邑县',3,'',NULL),
	(454,39,'深泽县',3,'',NULL),
	(455,39,'赞皇县',3,'',NULL),
	(456,39,'无极县',3,'',NULL),
	(457,39,'平山县',3,'',NULL),
	(458,39,'元氏县',3,'',NULL),
	(459,39,'赵县',3,'',NULL),
	(460,39,'辛集市',3,'',NULL),
	(461,39,'藁城区',3,'',NULL),
	(462,39,'晋州市',3,'',NULL),
	(463,39,'新乐市',3,'',NULL),
	(464,39,'鹿泉区',3,'',NULL),
	(465,39,'其它区',3,'',NULL),
	(466,40,'路南区',3,'',NULL),
	(467,40,'路北区',3,'',NULL),
	(468,40,'古冶区',3,'',NULL),
	(469,40,'开平区',3,'',NULL),
	(470,40,'丰南区',3,'',NULL),
	(471,40,'丰润区',3,'',NULL),
	(472,40,'滦县',3,'',NULL),
	(473,40,'滦南县',3,'',NULL),
	(474,40,'乐亭县',3,'',NULL),
	(475,40,'迁西县',3,'',NULL),
	(476,40,'玉田县',3,'',NULL),
	(477,40,'曹妃甸区',3,'',NULL),
	(478,40,'遵化市',3,'',NULL),
	(479,40,'迁安市',3,'',NULL),
	(480,40,'其它区',3,'',NULL),
	(481,41,'海港区',3,'',NULL),
	(482,41,'山海关区',3,'',NULL),
	(483,41,'北戴河区',3,'',NULL),
	(484,41,'青龙满族自治县',3,'',NULL),
	(485,41,'昌黎县',3,'',NULL),
	(486,41,'抚宁县',3,'',NULL),
	(487,41,'卢龙县',3,'',NULL),
	(488,41,'其它区',3,'',NULL),
	(489,41,'经济技术开发区',3,'',NULL),
	(490,42,'邯山区',3,'',NULL),
	(491,42,'丛台区',3,'',NULL),
	(492,42,'复兴区',3,'',NULL),
	(493,42,'峰峰矿区',3,'',NULL),
	(494,42,'邯郸县',3,'',NULL),
	(495,42,'临漳县',3,'',NULL),
	(496,42,'成安县',3,'',NULL),
	(497,42,'大名县',3,'',NULL),
	(498,42,'涉县',3,'',NULL),
	(499,42,'磁县',3,'',NULL),
	(500,42,'肥乡县',3,'',NULL),
	(501,42,'永年县',3,'',NULL),
	(502,42,'邱县',3,'',NULL),
	(503,42,'鸡泽县',3,'',NULL),
	(504,42,'广平县',3,'',NULL),
	(505,42,'馆陶县',3,'',NULL),
	(506,42,'魏县',3,'',NULL),
	(507,42,'曲周县',3,'',NULL),
	(508,42,'武安市',3,'',NULL),
	(509,42,'其它区',3,'',NULL),
	(510,43,'桥东区',3,'',NULL),
	(511,43,'桥西区',3,'',NULL),
	(512,43,'邢台县',3,'',NULL),
	(513,43,'临城县',3,'',NULL),
	(514,43,'内丘县',3,'',NULL),
	(515,43,'柏乡县',3,'',NULL),
	(516,43,'隆尧县',3,'',NULL),
	(517,43,'任县',3,'',NULL),
	(518,43,'南和县',3,'',NULL),
	(519,43,'宁晋县',3,'',NULL),
	(520,43,'巨鹿县',3,'',NULL),
	(521,43,'新河县',3,'',NULL),
	(522,43,'广宗县',3,'',NULL),
	(523,43,'平乡县',3,'',NULL),
	(524,43,'威县',3,'',NULL),
	(525,43,'清河县',3,'',NULL),
	(526,43,'临西县',3,'',NULL),
	(527,43,'南宫市',3,'',NULL),
	(528,43,'沙河市',3,'',NULL),
	(529,43,'其它区',3,'',NULL),
	(530,44,'新市区',3,'',NULL),
	(531,44,'北市区',3,'',NULL),
	(532,44,'南市区',3,'',NULL),
	(533,44,'满城县',3,'',NULL),
	(534,44,'清苑县',3,'',NULL),
	(535,44,'涞水县',3,'',NULL),
	(536,44,'阜平县',3,'',NULL),
	(537,44,'徐水县',3,'',NULL),
	(538,44,'定兴县',3,'',NULL),
	(539,44,'唐县',3,'',NULL),
	(540,44,'高阳县',3,'',NULL),
	(541,44,'容城县',3,'',NULL),
	(542,44,'涞源县',3,'',NULL),
	(543,44,'望都县',3,'',NULL),
	(544,44,'安新县',3,'',NULL),
	(545,44,'易县',3,'',NULL),
	(546,44,'曲阳县',3,'',NULL),
	(547,44,'蠡县',3,'',NULL),
	(548,44,'顺平县',3,'',NULL),
	(549,44,'博野县',3,'',NULL),
	(550,44,'雄县',3,'',NULL),
	(551,44,'涿州市',3,'',NULL),
	(552,44,'定州市',3,'',NULL),
	(553,44,'安国市',3,'',NULL),
	(554,44,'高碑店市',3,'',NULL),
	(555,44,'高开区',3,'',NULL),
	(556,44,'其它区',3,'',NULL),
	(557,45,'桥东区',3,'',NULL),
	(558,45,'桥西区',3,'',NULL),
	(559,45,'宣化区',3,'',NULL),
	(560,45,'下花园区',3,'',NULL),
	(561,45,'宣化县',3,'',NULL),
	(562,45,'张北县',3,'',NULL),
	(563,45,'康保县',3,'',NULL),
	(564,45,'沽源县',3,'',NULL),
	(565,45,'尚义县',3,'',NULL),
	(566,45,'蔚县',3,'',NULL),
	(567,45,'阳原县',3,'',NULL),
	(568,45,'怀安县',3,'',NULL),
	(569,45,'万全县',3,'',NULL),
	(570,45,'怀来县',3,'',NULL),
	(571,45,'涿鹿县',3,'',NULL),
	(572,45,'赤城县',3,'',NULL),
	(573,45,'崇礼县',3,'',NULL),
	(574,45,'其它区',3,'',NULL),
	(575,46,'双桥区',3,'',NULL),
	(576,46,'双滦区',3,'',NULL),
	(577,46,'鹰手营子矿区',3,'',NULL),
	(578,46,'承德县',3,'',NULL),
	(579,46,'兴隆县',3,'',NULL),
	(580,46,'平泉县',3,'',NULL),
	(581,46,'滦平县',3,'',NULL),
	(582,46,'隆化县',3,'',NULL),
	(583,46,'丰宁满族自治县',3,'',NULL),
	(584,46,'宽城满族自治县',3,'',NULL),
	(585,46,'围场满族蒙古族自治县',3,'',NULL),
	(586,46,'其它区',3,'',NULL),
	(587,47,'新华区',3,'',NULL),
	(588,47,'运河区',3,'',NULL),
	(589,47,'沧县',3,'',NULL),
	(590,47,'青县',3,'',NULL),
	(591,47,'东光县',3,'',NULL),
	(592,47,'海兴县',3,'',NULL),
	(593,47,'盐山县',3,'',NULL),
	(594,47,'肃宁县',3,'',NULL),
	(595,47,'南皮县',3,'',NULL),
	(596,47,'吴桥县',3,'',NULL),
	(597,47,'献县',3,'',NULL),
	(598,47,'孟村回族自治县',3,'',NULL),
	(599,47,'泊头市',3,'',NULL),
	(600,47,'任丘市',3,'',NULL),
	(601,47,'黄骅市',3,'',NULL),
	(602,47,'河间市',3,'',NULL),
	(603,47,'其它区',3,'',NULL),
	(604,48,'安次区',3,'',NULL),
	(605,48,'广阳区',3,'',NULL),
	(606,48,'固安县',3,'',NULL),
	(607,48,'永清县',3,'',NULL),
	(608,48,'香河县',3,'',NULL),
	(609,48,'大城县',3,'',NULL),
	(610,48,'文安县',3,'',NULL),
	(611,48,'大厂回族自治县',3,'',NULL),
	(612,48,'开发区',3,'',NULL),
	(613,48,'燕郊经济技术开发区',3,'',NULL),
	(614,48,'霸州市',3,'',NULL),
	(615,48,'三河市',3,'',NULL),
	(616,48,'其它区',3,'',NULL),
	(617,49,'桃城区',3,'',NULL),
	(618,49,'枣强县',3,'',NULL),
	(619,49,'武邑县',3,'',NULL),
	(620,49,'武强县',3,'',NULL),
	(621,49,'饶阳县',3,'',NULL),
	(622,49,'安平县',3,'',NULL),
	(623,49,'故城县',3,'',NULL),
	(624,49,'景县',3,'',NULL),
	(625,49,'阜城县',3,'',NULL),
	(626,49,'冀州市',3,'',NULL),
	(627,49,'深州市',3,'',NULL),
	(628,49,'其它区',3,'',NULL),
	(629,50,'小店区',3,'',NULL),
	(630,50,'迎泽区',3,'',NULL),
	(631,50,'杏花岭区',3,'',NULL),
	(632,50,'尖草坪区',3,'',NULL),
	(633,50,'万柏林区',3,'',NULL),
	(634,50,'晋源区',3,'',NULL),
	(635,50,'清徐县',3,'',NULL),
	(636,50,'阳曲县',3,'',NULL),
	(637,50,'娄烦县',3,'',NULL),
	(638,50,'古交市',3,'',NULL),
	(639,50,'其它区',3,'',NULL),
	(640,51,'城区',3,'',NULL),
	(641,51,'矿区',3,'',NULL),
	(642,51,'南郊区',3,'',NULL),
	(643,51,'新荣区',3,'',NULL),
	(644,51,'阳高县',3,'',NULL),
	(645,51,'天镇县',3,'',NULL),
	(646,51,'广灵县',3,'',NULL),
	(647,51,'灵丘县',3,'',NULL),
	(648,51,'浑源县',3,'',NULL),
	(649,51,'左云县',3,'',NULL),
	(650,51,'大同县',3,'',NULL),
	(651,51,'其它区',3,'',NULL),
	(652,52,'城区',3,'',NULL),
	(653,52,'矿区',3,'',NULL),
	(654,52,'郊区',3,'',NULL),
	(655,52,'平定县',3,'',NULL),
	(656,52,'盂县',3,'',NULL),
	(657,52,'其它区',3,'',NULL),
	(658,53,'长治县',3,'',NULL),
	(659,53,'襄垣县',3,'',NULL),
	(660,53,'屯留县',3,'',NULL),
	(661,53,'平顺县',3,'',NULL),
	(662,53,'黎城县',3,'',NULL),
	(663,53,'壶关县',3,'',NULL),
	(664,53,'长子县',3,'',NULL),
	(665,53,'武乡县',3,'',NULL),
	(666,53,'沁县',3,'',NULL),
	(667,53,'沁源县',3,'',NULL),
	(668,53,'潞城市',3,'',NULL),
	(669,53,'城区',3,'',NULL),
	(670,53,'郊区',3,'',NULL),
	(671,53,'高新区',3,'',NULL),
	(672,53,'其它区',3,'',NULL),
	(673,54,'城区',3,'',NULL),
	(674,54,'沁水县',3,'',NULL),
	(675,54,'阳城县',3,'',NULL),
	(676,54,'陵川县',3,'',NULL),
	(677,54,'泽州县',3,'',NULL),
	(678,54,'高平市',3,'',NULL),
	(679,54,'其它区',3,'',NULL),
	(680,55,'朔城区',3,'',NULL),
	(681,55,'平鲁区',3,'',NULL),
	(682,55,'山阴县',3,'',NULL),
	(683,55,'应县',3,'',NULL),
	(684,55,'右玉县',3,'',NULL),
	(685,55,'怀仁县',3,'',NULL),
	(686,55,'其它区',3,'',NULL),
	(687,56,'榆次区',3,'',NULL),
	(688,56,'榆社县',3,'',NULL),
	(689,56,'左权县',3,'',NULL),
	(690,56,'和顺县',3,'',NULL),
	(691,56,'昔阳县',3,'',NULL),
	(692,56,'寿阳县',3,'',NULL),
	(693,56,'太谷县',3,'',NULL),
	(694,56,'祁县',3,'',NULL),
	(695,56,'平遥县',3,'',NULL),
	(696,56,'灵石县',3,'',NULL),
	(697,56,'介休市',3,'',NULL),
	(698,56,'其它区',3,'',NULL),
	(699,57,'盐湖区',3,'',NULL),
	(700,57,'临猗县',3,'',NULL),
	(701,57,'万荣县',3,'',NULL),
	(702,57,'闻喜县',3,'',NULL),
	(703,57,'稷山县',3,'',NULL),
	(704,57,'新绛县',3,'',NULL),
	(705,57,'绛县',3,'',NULL),
	(706,57,'垣曲县',3,'',NULL),
	(707,57,'夏县',3,'',NULL),
	(708,57,'平陆县',3,'',NULL),
	(709,57,'芮城县',3,'',NULL),
	(710,57,'永济市',3,'',NULL),
	(711,57,'河津市',3,'',NULL),
	(712,57,'其它区',3,'',NULL),
	(713,58,'忻府区',3,'',NULL),
	(714,58,'定襄县',3,'',NULL),
	(715,58,'五台县',3,'',NULL),
	(716,58,'代县',3,'',NULL),
	(717,58,'繁峙县',3,'',NULL),
	(718,58,'宁武县',3,'',NULL),
	(719,58,'静乐县',3,'',NULL),
	(720,58,'神池县',3,'',NULL),
	(721,58,'五寨县',3,'',NULL),
	(722,58,'岢岚县',3,'',NULL),
	(723,58,'河曲县',3,'',NULL),
	(724,58,'保德县',3,'',NULL),
	(725,58,'偏关县',3,'',NULL),
	(726,58,'原平市',3,'',NULL),
	(727,58,'其它区',3,'',NULL),
	(728,59,'尧都区',3,'',NULL),
	(729,59,'曲沃县',3,'',NULL),
	(730,59,'翼城县',3,'',NULL),
	(731,59,'襄汾县',3,'',NULL),
	(732,59,'洪洞县',3,'',NULL),
	(733,59,'古县',3,'',NULL),
	(734,59,'安泽县',3,'',NULL),
	(735,59,'浮山县',3,'',NULL),
	(736,59,'吉县',3,'',NULL),
	(737,59,'乡宁县',3,'',NULL),
	(738,59,'大宁县',3,'',NULL),
	(739,59,'隰县',3,'',NULL),
	(740,59,'永和县',3,'',NULL),
	(741,59,'蒲县',3,'',NULL),
	(742,59,'汾西县',3,'',NULL),
	(743,59,'侯马市',3,'',NULL),
	(744,59,'霍州市',3,'',NULL),
	(745,59,'其它区',3,'',NULL),
	(746,60,'离石区',3,'',NULL),
	(747,60,'文水县',3,'',NULL),
	(748,60,'交城县',3,'',NULL),
	(749,60,'兴县',3,'',NULL),
	(750,60,'临县',3,'',NULL),
	(751,60,'柳林县',3,'',NULL),
	(752,60,'石楼县',3,'',NULL),
	(753,60,'岚县',3,'',NULL),
	(754,60,'方山县',3,'',NULL),
	(755,60,'中阳县',3,'',NULL),
	(756,60,'交口县',3,'',NULL),
	(757,60,'孝义市',3,'',NULL),
	(758,60,'汾阳市',3,'',NULL),
	(759,60,'其它区',3,'',NULL),
	(760,61,'新城区',3,'',NULL),
	(761,61,'回民区',3,'',NULL),
	(762,61,'玉泉区',3,'',NULL),
	(763,61,'赛罕区',3,'',NULL),
	(764,61,'土默特左旗',3,'',NULL),
	(765,61,'托克托县',3,'',NULL),
	(766,61,'和林格尔县',3,'',NULL),
	(767,61,'清水河县',3,'',NULL),
	(768,61,'武川县',3,'',NULL),
	(769,61,'其它区',3,'',NULL),
	(770,62,'东河区',3,'',NULL),
	(771,62,'昆都仑区',3,'',NULL),
	(772,62,'青山区',3,'',NULL),
	(773,62,'石拐区',3,'',NULL),
	(774,62,'白云鄂博矿区',3,'',NULL),
	(775,62,'九原区',3,'',NULL),
	(776,62,'土默特右旗',3,'',NULL),
	(777,62,'固阳县',3,'',NULL),
	(778,62,'达尔罕茂明安联合旗',3,'',NULL),
	(779,62,'其它区',3,'',NULL),
	(780,63,'海勃湾区',3,'',NULL),
	(781,63,'海南区',3,'',NULL),
	(782,63,'乌达区',3,'',NULL),
	(783,63,'其它区',3,'',NULL),
	(784,64,'红山区',3,'',NULL),
	(785,64,'元宝山区',3,'',NULL),
	(786,64,'松山区',3,'',NULL),
	(787,64,'阿鲁科尔沁旗',3,'',NULL),
	(788,64,'巴林左旗',3,'',NULL),
	(789,64,'巴林右旗',3,'',NULL),
	(790,64,'林西县',3,'',NULL),
	(791,64,'克什克腾旗',3,'',NULL),
	(792,64,'翁牛特旗',3,'',NULL),
	(793,64,'喀喇沁旗',3,'',NULL),
	(794,64,'宁城县',3,'',NULL),
	(795,64,'敖汉旗',3,'',NULL),
	(796,64,'其它区',3,'',NULL),
	(797,65,'科尔沁区',3,'',NULL),
	(798,65,'科尔沁左翼中旗',3,'',NULL),
	(799,65,'科尔沁左翼后旗',3,'',NULL),
	(800,65,'开鲁县',3,'',NULL),
	(801,65,'库伦旗',3,'',NULL),
	(802,65,'奈曼旗',3,'',NULL),
	(803,65,'扎鲁特旗',3,'',NULL),
	(804,65,'霍林郭勒市',3,'',NULL),
	(805,65,'其它区',3,'',NULL),
	(806,66,'东胜区',3,'',NULL),
	(807,66,'达拉特旗',3,'',NULL),
	(808,66,'准格尔旗',3,'',NULL),
	(809,66,'鄂托克前旗',3,'',NULL),
	(810,66,'鄂托克旗',3,'',NULL),
	(811,66,'杭锦旗',3,'',NULL),
	(812,66,'乌审旗',3,'',NULL),
	(813,66,'伊金霍洛旗',3,'',NULL),
	(814,66,'其它区',3,'',NULL),
	(815,67,'海拉尔区',3,'',NULL),
	(816,67,'扎赉诺尔区',3,'',NULL),
	(817,67,'阿荣旗',3,'',NULL),
	(818,67,'莫力达瓦达斡尔族自治旗',3,'',NULL),
	(819,67,'鄂伦春自治旗',3,'',NULL),
	(820,67,'鄂温克族自治旗',3,'',NULL),
	(821,67,'陈巴尔虎旗',3,'',NULL),
	(822,67,'新巴尔虎左旗',3,'',NULL),
	(823,67,'新巴尔虎右旗',3,'',NULL),
	(824,67,'满洲里市',3,'',NULL),
	(825,67,'牙克石市',3,'',NULL),
	(826,67,'扎兰屯市',3,'',NULL),
	(827,67,'额尔古纳市',3,'',NULL),
	(828,67,'根河市',3,'',NULL),
	(829,67,'其它区',3,'',NULL),
	(830,68,'临河区',3,'',NULL),
	(831,68,'五原县',3,'',NULL),
	(832,68,'磴口县',3,'',NULL),
	(833,68,'乌拉特前旗',3,'',NULL),
	(834,68,'乌拉特中旗',3,'',NULL),
	(835,68,'乌拉特后旗',3,'',NULL),
	(836,68,'杭锦后旗',3,'',NULL),
	(837,68,'其它区',3,'',NULL),
	(838,69,'集宁区',3,'',NULL),
	(839,69,'卓资县',3,'',NULL),
	(840,69,'化德县',3,'',NULL),
	(841,69,'商都县',3,'',NULL),
	(842,69,'兴和县',3,'',NULL),
	(843,69,'凉城县',3,'',NULL),
	(844,69,'察哈尔右翼前旗',3,'',NULL),
	(845,69,'察哈尔右翼中旗',3,'',NULL),
	(846,69,'察哈尔右翼后旗',3,'',NULL),
	(847,69,'四子王旗',3,'',NULL),
	(848,69,'丰镇市',3,'',NULL),
	(849,69,'其它区',3,'',NULL),
	(850,70,'乌兰浩特市',3,'',NULL),
	(851,70,'阿尔山市',3,'',NULL),
	(852,70,'科尔沁右翼前旗',3,'',NULL),
	(853,70,'科尔沁右翼中旗',3,'',NULL),
	(854,70,'扎赉特旗',3,'',NULL),
	(855,70,'突泉县',3,'',NULL),
	(856,70,'其它区',3,'',NULL),
	(857,71,'二连浩特市',3,'',NULL),
	(858,71,'锡林浩特市',3,'',NULL),
	(859,71,'阿巴嘎旗',3,'',NULL),
	(860,71,'苏尼特左旗',3,'',NULL),
	(861,71,'苏尼特右旗',3,'',NULL),
	(862,71,'东乌珠穆沁旗',3,'',NULL),
	(863,71,'西乌珠穆沁旗',3,'',NULL),
	(864,71,'太仆寺旗',3,'',NULL),
	(865,71,'镶黄旗',3,'',NULL),
	(866,71,'正镶白旗',3,'',NULL),
	(867,71,'正蓝旗',3,'',NULL),
	(868,71,'多伦县',3,'',NULL),
	(869,71,'其它区',3,'',NULL),
	(870,72,'阿拉善左旗',3,'',NULL),
	(871,72,'阿拉善右旗',3,'',NULL),
	(872,72,'额济纳旗',3,'',NULL),
	(873,72,'其它区',3,'',NULL),
	(874,73,'和平区',3,'',NULL),
	(875,73,'沈河区',3,'',NULL),
	(876,73,'大东区',3,'',NULL),
	(877,73,'皇姑区',3,'',NULL),
	(878,73,'铁西区',3,'',NULL),
	(879,73,'苏家屯区',3,'',NULL),
	(880,73,'浑南区',3,'',NULL),
	(881,73,'新城子区',3,'',NULL),
	(882,73,'于洪区',3,'',NULL),
	(883,73,'辽中县',3,'',NULL),
	(884,73,'康平县',3,'',NULL),
	(885,73,'法库县',3,'',NULL),
	(886,73,'新民市',3,'',NULL),
	(887,73,'浑南新区',3,'',NULL),
	(888,73,'张士开发区',3,'',NULL),
	(889,73,'沈北新区',3,'',NULL),
	(890,73,'其它区',3,'',NULL),
	(891,74,'中山区',3,'',NULL),
	(892,74,'西岗区',3,'',NULL),
	(893,74,'沙河口区',3,'',NULL),
	(894,74,'甘井子区',3,'',NULL),
	(895,74,'旅顺口区',3,'',NULL),
	(896,74,'金州区',3,'',NULL),
	(897,74,'长海县',3,'',NULL),
	(898,74,'开发区',3,'',NULL),
	(899,74,'瓦房店市',3,'',NULL),
	(900,74,'普兰店市',3,'',NULL),
	(901,74,'庄河市',3,'',NULL),
	(902,74,'岭前区',3,'',NULL),
	(903,74,'其它区',3,'',NULL),
	(904,75,'铁东区',3,'',NULL),
	(905,75,'铁西区',3,'',NULL),
	(906,75,'立山区',3,'',NULL),
	(907,75,'千山区',3,'',NULL),
	(908,75,'台安县',3,'',NULL),
	(909,75,'岫岩满族自治县',3,'',NULL),
	(910,75,'高新区',3,'',NULL),
	(911,75,'海城市',3,'',NULL),
	(912,75,'其它区',3,'',NULL),
	(913,76,'新抚区',3,'',NULL),
	(914,76,'东洲区',3,'',NULL),
	(915,76,'望花区',3,'',NULL),
	(916,76,'顺城区',3,'',NULL),
	(917,76,'抚顺县',3,'',NULL),
	(918,76,'新宾满族自治县',3,'',NULL),
	(919,76,'清原满族自治县',3,'',NULL),
	(920,76,'其它区',3,'',NULL),
	(921,77,'平山区',3,'',NULL),
	(922,77,'溪湖区',3,'',NULL),
	(923,77,'明山区',3,'',NULL),
	(924,77,'南芬区',3,'',NULL),
	(925,77,'本溪满族自治县',3,'',NULL),
	(926,77,'桓仁满族自治县',3,'',NULL),
	(927,77,'其它区',3,'',NULL),
	(928,78,'元宝区',3,'',NULL),
	(929,78,'振兴区',3,'',NULL),
	(930,78,'振安区',3,'',NULL),
	(931,78,'宽甸满族自治县',3,'',NULL),
	(932,78,'东港市',3,'',NULL),
	(933,78,'凤城市',3,'',NULL),
	(934,78,'其它区',3,'',NULL),
	(935,79,'古塔区',3,'',NULL),
	(936,79,'凌河区',3,'',NULL),
	(937,79,'太和区',3,'',NULL),
	(938,79,'黑山县',3,'',NULL),
	(939,79,'义县',3,'',NULL),
	(940,79,'凌海市',3,'',NULL),
	(941,79,'北镇市',3,'',NULL),
	(942,79,'其它区',3,'',NULL),
	(943,80,'站前区',3,'',NULL),
	(944,80,'西市区',3,'',NULL),
	(945,80,'鲅鱼圈区',3,'',NULL),
	(946,80,'老边区',3,'',NULL),
	(947,80,'盖州市',3,'',NULL),
	(948,80,'大石桥市',3,'',NULL),
	(949,80,'其它区',3,'',NULL),
	(950,81,'海州区',3,'',NULL),
	(951,81,'新邱区',3,'',NULL),
	(952,81,'太平区',3,'',NULL),
	(953,81,'清河门区',3,'',NULL),
	(954,81,'细河区',3,'',NULL),
	(955,81,'阜新蒙古族自治县',3,'',NULL),
	(956,81,'彰武县',3,'',NULL),
	(957,81,'其它区',3,'',NULL),
	(958,82,'白塔区',3,'',NULL),
	(959,82,'文圣区',3,'',NULL),
	(960,82,'宏伟区',3,'',NULL),
	(961,82,'弓长岭区',3,'',NULL),
	(962,82,'太子河区',3,'',NULL),
	(963,82,'辽阳县',3,'',NULL),
	(964,82,'灯塔市',3,'',NULL),
	(965,82,'其它区',3,'',NULL),
	(966,83,'双台子区',3,'',NULL),
	(967,83,'兴隆台区',3,'',NULL),
	(968,83,'大洼县',3,'',NULL),
	(969,83,'盘山县',3,'',NULL),
	(970,83,'其它区',3,'',NULL),
	(971,84,'银州区',3,'',NULL),
	(972,84,'清河区',3,'',NULL),
	(973,84,'铁岭县',3,'',NULL),
	(974,84,'西丰县',3,'',NULL),
	(975,84,'昌图县',3,'',NULL),
	(976,84,'调兵山市',3,'',NULL),
	(977,84,'开原市',3,'',NULL),
	(978,84,'其它区',3,'',NULL),
	(979,85,'双塔区',3,'',NULL),
	(980,85,'龙城区',3,'',NULL),
	(981,85,'朝阳县',3,'',NULL),
	(982,85,'建平县',3,'',NULL),
	(983,85,'喀喇沁左翼蒙古族自治县',3,'',NULL),
	(984,85,'北票市',3,'',NULL),
	(985,85,'凌源市',3,'',NULL),
	(986,85,'其它区',3,'',NULL),
	(987,86,'连山区',3,'',NULL),
	(988,86,'龙港区',3,'',NULL),
	(989,86,'南票区',3,'',NULL),
	(990,86,'绥中县',3,'',NULL),
	(991,86,'建昌县',3,'',NULL),
	(992,86,'兴城市',3,'',NULL),
	(993,86,'其它区',3,'',NULL),
	(994,87,'南关区',3,'',NULL),
	(995,87,'宽城区',3,'',NULL),
	(996,87,'朝阳区',3,'',NULL),
	(997,87,'二道区',3,'',NULL),
	(998,87,'绿园区',3,'',NULL),
	(999,87,'双阳区',3,'',NULL),
	(1000,87,'农安县',3,'',NULL),
	(1001,87,'九台区',3,'',NULL),
	(1002,87,'榆树市',3,'',NULL),
	(1003,87,'德惠市',3,'',NULL),
	(1004,87,'高新技术产业开发区',3,'',NULL),
	(1005,87,'汽车产业开发区',3,'',NULL),
	(1006,87,'经济技术开发区',3,'',NULL),
	(1007,87,'净月旅游开发区',3,'',NULL),
	(1008,87,'其它区',3,'',NULL),
	(1009,88,'昌邑区',3,'',NULL),
	(1010,88,'龙潭区',3,'',NULL),
	(1011,88,'船营区',3,'',NULL),
	(1012,88,'丰满区',3,'',NULL),
	(1013,88,'永吉县',3,'',NULL),
	(1014,88,'蛟河市',3,'',NULL),
	(1015,88,'桦甸市',3,'',NULL),
	(1016,88,'舒兰市',3,'',NULL),
	(1017,88,'磐石市',3,'',NULL),
	(1018,88,'其它区',3,'',NULL),
	(1019,89,'铁西区',3,'',NULL),
	(1020,89,'铁东区',3,'',NULL),
	(1021,89,'梨树县',3,'',NULL),
	(1022,89,'伊通满族自治县',3,'',NULL),
	(1023,89,'公主岭市',3,'',NULL),
	(1024,89,'双辽市',3,'',NULL),
	(1025,89,'其它区',3,'',NULL),
	(1026,90,'龙山区',3,'',NULL),
	(1027,90,'西安区',3,'',NULL),
	(1028,90,'东丰县',3,'',NULL),
	(1029,90,'东辽县',3,'',NULL),
	(1030,90,'其它区',3,'',NULL),
	(1031,91,'东昌区',3,'',NULL),
	(1032,91,'二道江区',3,'',NULL),
	(1033,91,'通化县',3,'',NULL),
	(1034,91,'辉南县',3,'',NULL),
	(1035,91,'柳河县',3,'',NULL),
	(1036,91,'梅河口市',3,'',NULL),
	(1037,91,'集安市',3,'',NULL),
	(1038,91,'其它区',3,'',NULL),
	(1039,92,'浑江区',3,'',NULL),
	(1040,92,'抚松县',3,'',NULL),
	(1041,92,'靖宇县',3,'',NULL),
	(1042,92,'长白朝鲜族自治县',3,'',NULL),
	(1043,92,'江源区',3,'',NULL),
	(1044,92,'临江市',3,'',NULL),
	(1045,92,'其它区',3,'',NULL),
	(1046,93,'宁江区',3,'',NULL),
	(1047,93,'前郭尔罗斯蒙古族自治县',3,'',NULL),
	(1048,93,'长岭县',3,'',NULL),
	(1049,93,'乾安县',3,'',NULL),
	(1050,93,'扶余市',3,'',NULL),
	(1051,93,'其它区',3,'',NULL),
	(1052,94,'洮北区',3,'',NULL),
	(1053,94,'镇赉县',3,'',NULL),
	(1054,94,'通榆县',3,'',NULL),
	(1055,94,'洮南市',3,'',NULL),
	(1056,94,'大安市',3,'',NULL),
	(1057,94,'其它区',3,'',NULL),
	(1058,95,'延吉市',3,'',NULL),
	(1059,95,'图们市',3,'',NULL),
	(1060,95,'敦化市',3,'',NULL),
	(1061,95,'珲春市',3,'',NULL),
	(1062,95,'龙井市',3,'',NULL),
	(1063,95,'和龙市',3,'',NULL),
	(1064,95,'汪清县',3,'',NULL),
	(1065,95,'安图县',3,'',NULL),
	(1066,95,'其它区',3,'',NULL),
	(1067,96,'道里区',3,'',NULL),
	(1068,96,'南岗区',3,'',NULL),
	(1069,96,'道外区',3,'',NULL),
	(1070,96,'香坊区',3,'',NULL),
	(1071,96,'动力区',3,'',NULL),
	(1072,96,'平房区',3,'',NULL),
	(1073,96,'松北区',3,'',NULL),
	(1074,96,'呼兰区',3,'',NULL),
	(1075,96,'依兰县',3,'',NULL),
	(1076,96,'方正县',3,'',NULL),
	(1077,96,'宾县',3,'',NULL),
	(1078,96,'巴彦县',3,'',NULL),
	(1079,96,'木兰县',3,'',NULL),
	(1080,96,'通河县',3,'',NULL),
	(1081,96,'延寿县',3,'',NULL),
	(1082,96,'阿城区',3,'',NULL),
	(1083,96,'双城区',3,'',NULL),
	(1084,96,'尚志市',3,'',NULL),
	(1085,96,'五常市',3,'',NULL),
	(1086,96,'阿城市',3,'',NULL),
	(1087,96,'其它区',3,'',NULL),
	(1088,97,'龙沙区',3,'',NULL),
	(1089,97,'建华区',3,'',NULL),
	(1090,97,'铁锋区',3,'',NULL),
	(1091,97,'昂昂溪区',3,'',NULL),
	(1092,97,'富拉尔基区',3,'',NULL),
	(1093,97,'碾子山区',3,'',NULL),
	(1094,97,'梅里斯达斡尔族区',3,'',NULL),
	(1095,97,'龙江县',3,'',NULL),
	(1096,97,'依安县',3,'',NULL),
	(1097,97,'泰来县',3,'',NULL),
	(1098,97,'甘南县',3,'',NULL),
	(1099,97,'富裕县',3,'',NULL),
	(1100,97,'克山县',3,'',NULL),
	(1101,97,'克东县',3,'',NULL),
	(1102,97,'拜泉县',3,'',NULL),
	(1103,97,'讷河市',3,'',NULL),
	(1104,97,'其它区',3,'',NULL),
	(1105,98,'鸡冠区',3,'',NULL),
	(1106,98,'恒山区',3,'',NULL),
	(1107,98,'滴道区',3,'',NULL),
	(1108,98,'梨树区',3,'',NULL),
	(1109,98,'城子河区',3,'',NULL),
	(1110,98,'麻山区',3,'',NULL),
	(1111,98,'鸡东县',3,'',NULL),
	(1112,98,'虎林市',3,'',NULL),
	(1113,98,'密山市',3,'',NULL),
	(1114,98,'其它区',3,'',NULL),
	(1115,99,'向阳区',3,'',NULL),
	(1116,99,'工农区',3,'',NULL),
	(1117,99,'南山区',3,'',NULL),
	(1118,99,'兴安区',3,'',NULL),
	(1119,99,'东山区',3,'',NULL),
	(1120,99,'兴山区',3,'',NULL),
	(1121,99,'萝北县',3,'',NULL),
	(1122,99,'绥滨县',3,'',NULL),
	(1123,99,'其它区',3,'',NULL),
	(1124,100,'尖山区',3,'',NULL),
	(1125,100,'岭东区',3,'',NULL),
	(1126,100,'四方台区',3,'',NULL),
	(1127,100,'宝山区',3,'',NULL),
	(1128,100,'集贤县',3,'',NULL),
	(1129,100,'友谊县',3,'',NULL),
	(1130,100,'宝清县',3,'',NULL),
	(1131,100,'饶河县',3,'',NULL),
	(1132,100,'其它区',3,'',NULL),
	(1133,101,'萨尔图区',3,'',NULL),
	(1134,101,'龙凤区',3,'',NULL),
	(1135,101,'让胡路区',3,'',NULL),
	(1136,101,'红岗区',3,'',NULL),
	(1137,101,'大同区',3,'',NULL),
	(1138,101,'肇州县',3,'',NULL),
	(1139,101,'肇源县',3,'',NULL),
	(1140,101,'林甸县',3,'',NULL),
	(1141,101,'杜尔伯特蒙古族自治县',3,'',NULL),
	(1142,101,'其它区',3,'',NULL),
	(1143,102,'伊春区',3,'',NULL),
	(1144,102,'南岔区',3,'',NULL),
	(1145,102,'友好区',3,'',NULL),
	(1146,102,'西林区',3,'',NULL),
	(1147,102,'翠峦区',3,'',NULL),
	(1148,102,'新青区',3,'',NULL),
	(1149,102,'美溪区',3,'',NULL),
	(1150,102,'金山屯区',3,'',NULL),
	(1151,102,'五营区',3,'',NULL),
	(1152,102,'乌马河区',3,'',NULL),
	(1153,102,'汤旺河区',3,'',NULL),
	(1154,102,'带岭区',3,'',NULL),
	(1155,102,'乌伊岭区',3,'',NULL),
	(1156,102,'红星区',3,'',NULL),
	(1157,102,'上甘岭区',3,'',NULL),
	(1158,102,'嘉荫县',3,'',NULL),
	(1159,102,'铁力市',3,'',NULL),
	(1160,102,'其它区',3,'',NULL),
	(1161,103,'永红区',3,'',NULL),
	(1162,103,'向阳区',3,'',NULL),
	(1163,103,'前进区',3,'',NULL),
	(1164,103,'东风区',3,'',NULL),
	(1165,103,'郊区',3,'',NULL),
	(1166,103,'桦南县',3,'',NULL),
	(1167,103,'桦川县',3,'',NULL),
	(1168,103,'汤原县',3,'',NULL),
	(1169,103,'抚远县',3,'',NULL),
	(1170,103,'同江市',3,'',NULL),
	(1171,103,'富锦市',3,'',NULL),
	(1172,103,'其它区',3,'',NULL),
	(1173,104,'新兴区',3,'',NULL),
	(1174,104,'桃山区',3,'',NULL),
	(1175,104,'茄子河区',3,'',NULL),
	(1176,104,'勃利县',3,'',NULL),
	(1177,104,'其它区',3,'',NULL),
	(1178,105,'东安区',3,'',NULL),
	(1179,105,'阳明区',3,'',NULL),
	(1180,105,'爱民区',3,'',NULL),
	(1181,105,'西安区',3,'',NULL),
	(1182,105,'东宁县',3,'',NULL),
	(1183,105,'林口县',3,'',NULL),
	(1184,105,'绥芬河市',3,'',NULL),
	(1185,105,'海林市',3,'',NULL),
	(1186,105,'宁安市',3,'',NULL),
	(1187,105,'穆棱市',3,'',NULL),
	(1188,105,'其它区',3,'',NULL),
	(1189,106,'爱辉区',3,'',NULL),
	(1190,106,'嫩江县',3,'',NULL),
	(1191,106,'逊克县',3,'',NULL),
	(1192,106,'孙吴县',3,'',NULL),
	(1193,106,'北安市',3,'',NULL),
	(1194,106,'五大连池市',3,'',NULL),
	(1195,106,'其它区',3,'',NULL),
	(1196,107,'北林区',3,'',NULL),
	(1197,107,'望奎县',3,'',NULL),
	(1198,107,'兰西县',3,'',NULL),
	(1199,107,'青冈县',3,'',NULL),
	(1200,107,'庆安县',3,'',NULL),
	(1201,107,'明水县',3,'',NULL),
	(1202,107,'绥棱县',3,'',NULL),
	(1203,107,'安达市',3,'',NULL),
	(1204,107,'肇东市',3,'',NULL),
	(1205,107,'海伦市',3,'',NULL),
	(1206,107,'其它区',3,'',NULL),
	(1207,108,'松岭区',3,'',NULL),
	(1208,108,'新林区',3,'',NULL),
	(1209,108,'呼中区',3,'',NULL),
	(1210,108,'呼玛县',3,'',NULL),
	(1211,108,'塔河县',3,'',NULL),
	(1212,108,'漠河县',3,'',NULL),
	(1213,108,'加格达奇区',3,'',NULL),
	(1214,108,'其它区',3,'',NULL),
	(1215,109,'黄浦区',3,'',NULL),
	(1216,109,'卢湾区',3,'',NULL),
	(1217,109,'徐汇区',3,'',NULL),
	(1218,109,'长宁区',3,'',NULL),
	(1219,109,'静安区',3,'',NULL),
	(1220,109,'普陀区',3,'',NULL),
	(1221,109,'闸北区',3,'',NULL),
	(1222,109,'虹口区',3,'',NULL),
	(1223,109,'杨浦区',3,'',NULL),
	(1224,109,'闵行区',3,'',NULL),
	(1225,109,'宝山区',3,'',NULL),
	(1226,109,'嘉定区',3,'',NULL),
	(1227,109,'浦东新区',3,'',NULL),
	(1228,109,'金山区',3,'',NULL),
	(1229,109,'松江区',3,'',NULL),
	(1230,109,'青浦区',3,'',NULL),
	(1231,109,'南汇区',3,'',NULL),
	(1232,109,'奉贤区',3,'',NULL),
	(1233,109,'川沙区',3,'',NULL),
	(1234,109,'崇明县',3,'',NULL),
	(1235,109,'其它区',3,'',NULL),
	(1236,110,'玄武区',3,'',NULL),
	(1237,110,'白下区',3,'',NULL),
	(1238,110,'秦淮区',3,'',NULL),
	(1239,110,'建邺区',3,'',NULL),
	(1240,110,'鼓楼区',3,'',NULL),
	(1241,110,'下关区',3,'',NULL),
	(1242,110,'浦口区',3,'',NULL),
	(1243,110,'栖霞区',3,'',NULL),
	(1244,110,'雨花台区',3,'',NULL),
	(1245,110,'江宁区',3,'',NULL),
	(1246,110,'六合区',3,'',NULL),
	(1247,110,'溧水区',3,'',NULL),
	(1248,110,'高淳区',3,'',NULL),
	(1249,110,'其它区',3,'',NULL),
	(1250,111,'崇安区',3,'',NULL),
	(1251,111,'南长区',3,'',NULL),
	(1252,111,'北塘区',3,'',NULL),
	(1253,111,'锡山区',3,'',NULL),
	(1254,111,'惠山区',3,'',NULL),
	(1255,111,'滨湖区',3,'',NULL),
	(1256,111,'江阴市',3,'',NULL),
	(1257,111,'宜兴市',3,'',NULL),
	(1258,111,'新区',3,'',NULL),
	(1259,111,'其它区',3,'',NULL),
	(1260,112,'鼓楼区',3,'',NULL),
	(1261,112,'云龙区',3,'',NULL),
	(1262,112,'九里区',3,'',NULL),
	(1263,112,'贾汪区',3,'',NULL),
	(1264,112,'泉山区',3,'',NULL),
	(1265,112,'丰县',3,'',NULL),
	(1266,112,'沛县',3,'',NULL),
	(1267,112,'铜山区',3,'',NULL),
	(1268,112,'睢宁县',3,'',NULL),
	(1269,112,'新沂市',3,'',NULL),
	(1270,112,'邳州市',3,'',NULL),
	(1271,112,'其它区',3,'',NULL),
	(1272,113,'天宁区',3,'',NULL),
	(1273,113,'钟楼区',3,'',NULL),
	(1274,113,'戚墅堰区',3,'',NULL),
	(1275,113,'新北区',3,'',NULL),
	(1276,113,'武进区',3,'',NULL),
	(1277,113,'溧阳市',3,'',NULL),
	(1278,113,'金坛市',3,'',NULL),
	(1279,113,'其它区',3,'',NULL),
	(1280,114,'沧浪区',3,'',NULL),
	(1281,114,'平江区',3,'',NULL),
	(1282,114,'金阊区',3,'',NULL),
	(1283,114,'虎丘区',3,'',NULL),
	(1284,114,'吴中区',3,'',NULL),
	(1285,114,'相城区',3,'',NULL),
	(1286,114,'姑苏区',3,'',NULL),
	(1287,114,'常熟市',3,'',NULL),
	(1288,114,'张家港市',3,'',NULL),
	(1289,114,'昆山市',3,'',NULL),
	(1290,114,'吴江区',3,'',NULL),
	(1291,114,'太仓市',3,'',NULL),
	(1292,114,'新区',3,'',NULL),
	(1293,114,'园区',3,'',NULL),
	(1294,114,'其它区',3,'',NULL),
	(1295,115,'崇川区',3,'',NULL),
	(1296,115,'港闸区',3,'',NULL),
	(1297,115,'通州区',3,'',NULL),
	(1298,115,'海安县',3,'',NULL),
	(1299,115,'如东县',3,'',NULL),
	(1300,115,'启东市',3,'',NULL),
	(1301,115,'如皋市',3,'',NULL),
	(1302,115,'通州市',3,'',NULL),
	(1303,115,'海门市',3,'',NULL),
	(1304,115,'开发区',3,'',NULL),
	(1305,115,'其它区',3,'',NULL),
	(1306,116,'连云区',3,'',NULL),
	(1307,116,'新浦区',3,'',NULL),
	(1308,116,'海州区',3,'',NULL),
	(1309,116,'赣榆区',3,'',NULL),
	(1310,116,'东海县',3,'',NULL),
	(1311,116,'灌云县',3,'',NULL),
	(1312,116,'灌南县',3,'',NULL),
	(1313,116,'其它区',3,'',NULL),
	(1314,117,'清河区',3,'',NULL),
	(1315,117,'淮安区',3,'',NULL),
	(1316,117,'淮阴区',3,'',NULL),
	(1317,117,'清浦区',3,'',NULL),
	(1318,117,'涟水县',3,'',NULL),
	(1319,117,'洪泽县',3,'',NULL),
	(1320,117,'盱眙县',3,'',NULL),
	(1321,117,'金湖县',3,'',NULL),
	(1322,117,'其它区',3,'',NULL),
	(1323,118,'亭湖区',3,'',NULL),
	(1324,118,'盐都区',3,'',NULL),
	(1325,118,'响水县',3,'',NULL),
	(1326,118,'滨海县',3,'',NULL),
	(1327,118,'阜宁县',3,'',NULL),
	(1328,118,'射阳县',3,'',NULL),
	(1329,118,'建湖县',3,'',NULL),
	(1330,118,'东台市',3,'',NULL),
	(1331,118,'大丰市',3,'',NULL),
	(1332,118,'其它区',3,'',NULL),
	(1333,119,'广陵区',3,'',NULL),
	(1334,119,'邗江区',3,'',NULL),
	(1335,119,'维扬区',3,'',NULL),
	(1336,119,'宝应县',3,'',NULL),
	(1337,119,'仪征市',3,'',NULL),
	(1338,119,'高邮市',3,'',NULL),
	(1339,119,'江都区',3,'',NULL),
	(1340,119,'经济开发区',3,'',NULL),
	(1341,119,'其它区',3,'',NULL),
	(1342,120,'京口区',3,'',NULL),
	(1343,120,'润州区',3,'',NULL),
	(1344,120,'丹徒区',3,'',NULL),
	(1345,120,'丹阳市',3,'',NULL),
	(1346,120,'扬中市',3,'',NULL),
	(1347,120,'句容市',3,'',NULL),
	(1348,120,'其它区',3,'',NULL),
	(1349,121,'海陵区',3,'',NULL),
	(1350,121,'高港区',3,'',NULL),
	(1351,121,'兴化市',3,'',NULL),
	(1352,121,'靖江市',3,'',NULL),
	(1353,121,'泰兴市',3,'',NULL),
	(1354,121,'姜堰区',3,'',NULL),
	(1355,121,'其它区',3,'',NULL),
	(1356,122,'宿城区',3,'',NULL),
	(1357,122,'宿豫区',3,'',NULL),
	(1358,122,'沭阳县',3,'',NULL),
	(1359,122,'泗阳县',3,'',NULL),
	(1360,122,'泗洪县',3,'',NULL),
	(1361,122,'其它区',3,'',NULL),
	(1362,123,'上城区',3,'',NULL),
	(1363,123,'下城区',3,'',NULL),
	(1364,123,'江干区',3,'',NULL),
	(1365,123,'拱墅区',3,'',NULL),
	(1366,123,'西湖区',3,'',NULL),
	(1367,123,'滨江区',3,'',NULL),
	(1368,123,'萧山区',3,'',NULL),
	(1369,123,'余杭区',3,'',NULL),
	(1370,123,'桐庐县',3,'',NULL),
	(1371,123,'淳安县',3,'',NULL),
	(1372,123,'建德市',3,'',NULL),
	(1373,123,'富阳区',3,'',NULL),
	(1374,123,'临安市',3,'',NULL),
	(1375,123,'其它区',3,'',NULL),
	(1376,124,'海曙区',3,'',NULL),
	(1377,124,'江东区',3,'',NULL),
	(1378,124,'江北区',3,'',NULL),
	(1379,124,'北仑区',3,'',NULL),
	(1380,124,'镇海区',3,'',NULL),
	(1381,124,'鄞州区',3,'',NULL),
	(1382,124,'象山县',3,'',NULL),
	(1383,124,'宁海县',3,'',NULL),
	(1384,124,'余姚市',3,'',NULL),
	(1385,124,'慈溪市',3,'',NULL),
	(1386,124,'奉化市',3,'',NULL),
	(1387,124,'其它区',3,'',NULL),
	(1388,125,'鹿城区',3,'',NULL),
	(1389,125,'龙湾区',3,'',NULL),
	(1390,125,'瓯海区',3,'',NULL),
	(1391,125,'洞头县',3,'',NULL),
	(1392,125,'永嘉县',3,'',NULL),
	(1393,125,'平阳县',3,'',NULL),
	(1394,125,'苍南县',3,'',NULL),
	(1395,125,'文成县',3,'',NULL),
	(1396,125,'泰顺县',3,'',NULL),
	(1397,125,'瑞安市',3,'',NULL),
	(1398,125,'乐清市',3,'',NULL),
	(1399,125,'其它区',3,'',NULL),
	(1400,126,'南湖区',3,'',NULL),
	(1401,126,'秀洲区',3,'',NULL),
	(1402,126,'嘉善县',3,'',NULL),
	(1403,126,'海盐县',3,'',NULL),
	(1404,126,'海宁市',3,'',NULL),
	(1405,126,'平湖市',3,'',NULL),
	(1406,126,'桐乡市',3,'',NULL),
	(1407,126,'其它区',3,'',NULL),
	(1408,127,'吴兴区',3,'',NULL),
	(1409,127,'南浔区',3,'',NULL),
	(1410,127,'德清县',3,'',NULL),
	(1411,127,'长兴县',3,'',NULL),
	(1412,127,'安吉县',3,'',NULL),
	(1413,127,'其它区',3,'',NULL),
	(1414,128,'越城区',3,'',NULL),
	(1415,128,'柯桥区',3,'',NULL),
	(1416,128,'新昌县',3,'',NULL),
	(1417,128,'诸暨市',3,'',NULL),
	(1418,128,'上虞区',3,'',NULL),
	(1419,128,'嵊州市',3,'',NULL),
	(1420,128,'其它区',3,'',NULL),
	(1421,129,'婺城区',3,'',NULL),
	(1422,129,'金东区',3,'',NULL),
	(1423,129,'武义县',3,'',NULL),
	(1424,129,'浦江县',3,'',NULL),
	(1425,129,'磐安县',3,'',NULL),
	(1426,129,'兰溪市',3,'',NULL),
	(1427,129,'义乌市',3,'',NULL),
	(1428,129,'东阳市',3,'',NULL),
	(1429,129,'永康市',3,'',NULL),
	(1430,129,'其它区',3,'',NULL),
	(1431,130,'柯城区',3,'',NULL),
	(1432,130,'衢江区',3,'',NULL),
	(1433,130,'常山县',3,'',NULL),
	(1434,130,'开化县',3,'',NULL),
	(1435,130,'龙游县',3,'',NULL),
	(1436,130,'江山市',3,'',NULL),
	(1437,130,'其它区',3,'',NULL),
	(1438,131,'定海区',3,'',NULL),
	(1439,131,'普陀区',3,'',NULL),
	(1440,131,'岱山县',3,'',NULL),
	(1441,131,'嵊泗县',3,'',NULL),
	(1442,131,'其它区',3,'',NULL),
	(1443,132,'椒江区',3,'',NULL),
	(1444,132,'黄岩区',3,'',NULL),
	(1445,132,'路桥区',3,'',NULL),
	(1446,132,'玉环县',3,'',NULL),
	(1447,132,'三门县',3,'',NULL),
	(1448,132,'天台县',3,'',NULL),
	(1449,132,'仙居县',3,'',NULL),
	(1450,132,'温岭市',3,'',NULL),
	(1451,132,'临海市',3,'',NULL),
	(1452,132,'其它区',3,'',NULL),
	(1453,133,'莲都区',3,'',NULL),
	(1454,133,'青田县',3,'',NULL),
	(1455,133,'缙云县',3,'',NULL),
	(1456,133,'遂昌县',3,'',NULL),
	(1457,133,'松阳县',3,'',NULL),
	(1458,133,'云和县',3,'',NULL),
	(1459,133,'庆元县',3,'',NULL),
	(1460,133,'景宁畲族自治县',3,'',NULL),
	(1461,133,'龙泉市',3,'',NULL),
	(1462,133,'其它区',3,'',NULL),
	(1463,134,'瑶海区',3,'',NULL),
	(1464,134,'庐阳区',3,'',NULL),
	(1465,134,'蜀山区',3,'',NULL),
	(1466,134,'包河区',3,'',NULL),
	(1467,134,'长丰县',3,'',NULL),
	(1468,134,'肥东县',3,'',NULL),
	(1469,134,'肥西县',3,'',NULL),
	(1470,134,'高新区',3,'',NULL),
	(1471,134,'中区',3,'',NULL),
	(1472,134,'其它区',3,'',NULL),
	(1473,135,'镜湖区',3,'',NULL),
	(1474,135,'弋江区',3,'',NULL),
	(1475,135,'鸠江区',3,'',NULL),
	(1476,135,'三山区',3,'',NULL),
	(1477,135,'芜湖县',3,'',NULL),
	(1478,135,'繁昌县',3,'',NULL),
	(1479,135,'南陵县',3,'',NULL),
	(1480,135,'其它区',3,'',NULL),
	(1481,136,'龙子湖区',3,'',NULL),
	(1482,136,'蚌山区',3,'',NULL),
	(1483,136,'禹会区',3,'',NULL),
	(1484,136,'淮上区',3,'',NULL),
	(1485,136,'怀远县',3,'',NULL),
	(1486,136,'五河县',3,'',NULL),
	(1487,136,'固镇县',3,'',NULL),
	(1488,136,'其它区',3,'',NULL),
	(1489,137,'大通区',3,'',NULL),
	(1490,137,'田家庵区',3,'',NULL),
	(1491,137,'谢家集区',3,'',NULL),
	(1492,137,'八公山区',3,'',NULL),
	(1493,137,'潘集区',3,'',NULL),
	(1494,137,'凤台县',3,'',NULL),
	(1495,137,'其它区',3,'',NULL),
	(1496,138,'金家庄区',3,'',NULL),
	(1497,138,'花山区',3,'',NULL),
	(1498,138,'雨山区',3,'',NULL),
	(1499,138,'博望区',3,'',NULL),
	(1500,138,'当涂县',3,'',NULL),
	(1501,138,'其它区',3,'',NULL),
	(1502,139,'杜集区',3,'',NULL),
	(1503,139,'相山区',3,'',NULL),
	(1504,139,'烈山区',3,'',NULL),
	(1505,139,'濉溪县',3,'',NULL),
	(1506,139,'其它区',3,'',NULL),
	(1507,140,'铜官山区',3,'',NULL),
	(1508,140,'狮子山区',3,'',NULL),
	(1509,140,'郊区',3,'',NULL),
	(1510,140,'铜陵县',3,'',NULL),
	(1511,140,'其它区',3,'',NULL),
	(1512,141,'迎江区',3,'',NULL),
	(1513,141,'大观区',3,'',NULL),
	(1514,141,'宜秀区',3,'',NULL),
	(1515,141,'怀宁县',3,'',NULL),
	(1516,141,'枞阳县',3,'',NULL),
	(1517,141,'潜山县',3,'',NULL),
	(1518,141,'太湖县',3,'',NULL),
	(1519,141,'宿松县',3,'',NULL),
	(1520,141,'望江县',3,'',NULL),
	(1521,141,'岳西县',3,'',NULL),
	(1522,141,'桐城市',3,'',NULL),
	(1523,141,'其它区',3,'',NULL),
	(1524,142,'屯溪区',3,'',NULL),
	(1525,142,'黄山区',3,'',NULL),
	(1526,142,'徽州区',3,'',NULL),
	(1527,142,'歙县',3,'',NULL),
	(1528,142,'休宁县',3,'',NULL),
	(1529,142,'黟县',3,'',NULL),
	(1530,142,'祁门县',3,'',NULL),
	(1531,142,'其它区',3,'',NULL),
	(1532,143,'琅琊区',3,'',NULL),
	(1533,143,'南谯区',3,'',NULL),
	(1534,143,'来安县',3,'',NULL),
	(1535,143,'全椒县',3,'',NULL),
	(1536,143,'定远县',3,'',NULL),
	(1537,143,'凤阳县',3,'',NULL),
	(1538,143,'天长市',3,'',NULL),
	(1539,143,'明光市',3,'',NULL),
	(1540,143,'其它区',3,'',NULL),
	(1541,144,'颍州区',3,'',NULL),
	(1542,144,'颍东区',3,'',NULL),
	(1543,144,'颍泉区',3,'',NULL),
	(1544,144,'临泉县',3,'',NULL),
	(1545,144,'太和县',3,'',NULL),
	(1546,144,'阜南县',3,'',NULL),
	(1547,144,'颍上县',3,'',NULL),
	(1548,144,'界首市',3,'',NULL),
	(1549,144,'其它区',3,'',NULL),
	(1550,145,'埇桥区',3,'',NULL),
	(1551,145,'砀山县',3,'',NULL),
	(1552,145,'萧县',3,'',NULL),
	(1553,145,'灵璧县',3,'',NULL),
	(1554,145,'泗县',3,'',NULL),
	(1555,145,'其它区',3,'',NULL),
	(1556,134,'巢湖市',3,'',NULL),
	(1557,134,'居巢区',3,'',NULL),
	(1558,134,'庐江县',3,'',NULL),
	(1559,135,'无为县',3,'',NULL),
	(1560,138,'含山县',3,'',NULL),
	(1561,138,'和县',3,'',NULL),
	(1562,146,'金安区',3,'',NULL),
	(1563,146,'裕安区',3,'',NULL),
	(1564,146,'寿县',3,'',NULL),
	(1565,146,'霍邱县',3,'',NULL),
	(1566,146,'舒城县',3,'',NULL),
	(1567,146,'金寨县',3,'',NULL),
	(1568,146,'霍山县',3,'',NULL),
	(1569,146,'其它区',3,'',NULL),
	(1570,147,'谯城区',3,'',NULL),
	(1571,147,'涡阳县',3,'',NULL),
	(1572,147,'蒙城县',3,'',NULL),
	(1573,147,'利辛县',3,'',NULL),
	(1574,147,'其它区',3,'',NULL),
	(1575,148,'贵池区',3,'',NULL),
	(1576,148,'东至县',3,'',NULL),
	(1577,148,'石台县',3,'',NULL),
	(1578,148,'青阳县',3,'',NULL),
	(1579,148,'其它区',3,'',NULL),
	(1580,149,'宣州区',3,'',NULL),
	(1581,149,'郎溪县',3,'',NULL),
	(1582,149,'广德县',3,'',NULL),
	(1583,149,'泾县',3,'',NULL),
	(1584,149,'绩溪县',3,'',NULL),
	(1585,149,'旌德县',3,'',NULL),
	(1586,149,'宁国市',3,'',NULL),
	(1587,149,'其它区',3,'',NULL),
	(1588,150,'鼓楼区',3,'',NULL),
	(1589,150,'台江区',3,'',NULL),
	(1590,150,'仓山区',3,'',NULL),
	(1591,150,'马尾区',3,'',NULL),
	(1592,150,'晋安区',3,'',NULL),
	(1593,150,'闽侯县',3,'',NULL),
	(1594,150,'连江县',3,'',NULL),
	(1595,150,'罗源县',3,'',NULL),
	(1596,150,'闽清县',3,'',NULL),
	(1597,150,'永泰县',3,'',NULL),
	(1598,150,'平潭县',3,'',NULL),
	(1599,150,'福清市',3,'',NULL),
	(1600,150,'长乐市',3,'',NULL),
	(1601,150,'其它区',3,'',NULL),
	(1602,151,'思明区',3,'',NULL),
	(1603,151,'海沧区',3,'',NULL),
	(1604,151,'湖里区',3,'',NULL),
	(1605,151,'集美区',3,'',NULL),
	(1606,151,'同安区',3,'',NULL),
	(1607,151,'翔安区',3,'',NULL),
	(1608,151,'其它区',3,'',NULL),
	(1609,152,'城厢区',3,'',NULL),
	(1610,152,'涵江区',3,'',NULL),
	(1611,152,'荔城区',3,'',NULL),
	(1612,152,'秀屿区',3,'',NULL),
	(1613,152,'仙游县',3,'',NULL),
	(1614,152,'其它区',3,'',NULL),
	(1615,153,'梅列区',3,'',NULL),
	(1616,153,'三元区',3,'',NULL),
	(1617,153,'明溪县',3,'',NULL),
	(1618,153,'清流县',3,'',NULL),
	(1619,153,'宁化县',3,'',NULL),
	(1620,153,'大田县',3,'',NULL),
	(1621,153,'尤溪县',3,'',NULL),
	(1622,153,'沙县',3,'',NULL),
	(1623,153,'将乐县',3,'',NULL),
	(1624,153,'泰宁县',3,'',NULL),
	(1625,153,'建宁县',3,'',NULL),
	(1626,153,'永安市',3,'',NULL),
	(1627,153,'其它区',3,'',NULL),
	(1628,154,'鲤城区',3,'',NULL),
	(1629,154,'丰泽区',3,'',NULL),
	(1630,154,'洛江区',3,'',NULL),
	(1631,154,'泉港区',3,'',NULL),
	(1632,154,'惠安县',3,'',NULL),
	(1633,154,'安溪县',3,'',NULL),
	(1634,154,'永春县',3,'',NULL),
	(1635,154,'德化县',3,'',NULL),
	(1636,154,'金门县',3,'',NULL),
	(1637,154,'石狮市',3,'',NULL),
	(1638,154,'晋江市',3,'',NULL),
	(1639,154,'南安市',3,'',NULL),
	(1640,154,'其它区',3,'',NULL),
	(1641,155,'芗城区',3,'',NULL),
	(1642,155,'龙文区',3,'',NULL),
	(1643,155,'云霄县',3,'',NULL),
	(1644,155,'漳浦县',3,'',NULL),
	(1645,155,'诏安县',3,'',NULL),
	(1646,155,'长泰县',3,'',NULL),
	(1647,155,'东山县',3,'',NULL),
	(1648,155,'南靖县',3,'',NULL),
	(1649,155,'平和县',3,'',NULL),
	(1650,155,'华安县',3,'',NULL),
	(1651,155,'龙海市',3,'',NULL),
	(1652,155,'其它区',3,'',NULL),
	(1653,156,'延平区',3,'',NULL),
	(1654,156,'顺昌县',3,'',NULL),
	(1655,156,'浦城县',3,'',NULL),
	(1656,156,'光泽县',3,'',NULL),
	(1657,156,'松溪县',3,'',NULL),
	(1658,156,'政和县',3,'',NULL),
	(1659,156,'邵武市',3,'',NULL),
	(1660,156,'武夷山市',3,'',NULL),
	(1661,156,'建瓯市',3,'',NULL),
	(1662,156,'建阳区',3,'',NULL),
	(1663,156,'其它区',3,'',NULL),
	(1664,157,'新罗区',3,'',NULL),
	(1665,157,'长汀县',3,'',NULL),
	(1666,157,'永定区',3,'',NULL),
	(1667,157,'上杭县',3,'',NULL),
	(1668,157,'武平县',3,'',NULL),
	(1669,157,'连城县',3,'',NULL),
	(1670,157,'漳平市',3,'',NULL),
	(1671,157,'其它区',3,'',NULL),
	(1672,158,'蕉城区',3,'',NULL),
	(1673,158,'霞浦县',3,'',NULL),
	(1674,158,'古田县',3,'',NULL),
	(1675,158,'屏南县',3,'',NULL),
	(1676,158,'寿宁县',3,'',NULL),
	(1677,158,'周宁县',3,'',NULL),
	(1678,158,'柘荣县',3,'',NULL),
	(1679,158,'福安市',3,'',NULL),
	(1680,158,'福鼎市',3,'',NULL),
	(1681,158,'其它区',3,'',NULL),
	(1682,159,'东湖区',3,'',NULL),
	(1683,159,'西湖区',3,'',NULL),
	(1684,159,'青云谱区',3,'',NULL),
	(1685,159,'湾里区',3,'',NULL),
	(1686,159,'青山湖区',3,'',NULL),
	(1687,159,'南昌县',3,'',NULL),
	(1688,159,'新建县',3,'',NULL),
	(1689,159,'安义县',3,'',NULL),
	(1690,159,'进贤县',3,'',NULL),
	(1691,159,'红谷滩新区',3,'',NULL),
	(1692,159,'经济技术开发区',3,'',NULL),
	(1693,159,'昌北区',3,'',NULL),
	(1694,159,'其它区',3,'',NULL),
	(1695,160,'昌江区',3,'',NULL),
	(1696,160,'珠山区',3,'',NULL),
	(1697,160,'浮梁县',3,'',NULL),
	(1698,160,'乐平市',3,'',NULL),
	(1699,160,'其它区',3,'',NULL),
	(1700,161,'安源区',3,'',NULL),
	(1701,161,'湘东区',3,'',NULL),
	(1702,161,'莲花县',3,'',NULL),
	(1703,161,'上栗县',3,'',NULL),
	(1704,161,'芦溪县',3,'',NULL),
	(1705,161,'其它区',3,'',NULL),
	(1706,162,'庐山区',3,'',NULL),
	(1707,162,'浔阳区',3,'',NULL),
	(1708,162,'九江县',3,'',NULL),
	(1709,162,'武宁县',3,'',NULL),
	(1710,162,'修水县',3,'',NULL),
	(1711,162,'永修县',3,'',NULL),
	(1712,162,'德安县',3,'',NULL),
	(1713,162,'星子县',3,'',NULL),
	(1714,162,'都昌县',3,'',NULL),
	(1715,162,'湖口县',3,'',NULL),
	(1716,162,'彭泽县',3,'',NULL),
	(1717,162,'瑞昌市',3,'',NULL),
	(1718,162,'其它区',3,'',NULL),
	(1719,162,'共青城市',3,'',NULL),
	(1720,163,'渝水区',3,'',NULL),
	(1721,163,'分宜县',3,'',NULL),
	(1722,163,'其它区',3,'',NULL),
	(1723,164,'月湖区',3,'',NULL),
	(1724,164,'余江县',3,'',NULL),
	(1725,164,'贵溪市',3,'',NULL),
	(1726,164,'其它区',3,'',NULL),
	(1727,165,'章贡区',3,'',NULL),
	(1728,165,'赣县',3,'',NULL),
	(1729,165,'信丰县',3,'',NULL),
	(1730,165,'大余县',3,'',NULL),
	(1731,165,'上犹县',3,'',NULL),
	(1732,165,'崇义县',3,'',NULL),
	(1733,165,'安远县',3,'',NULL),
	(1734,165,'龙南县',3,'',NULL),
	(1735,165,'定南县',3,'',NULL),
	(1736,165,'全南县',3,'',NULL),
	(1737,165,'宁都县',3,'',NULL),
	(1738,165,'于都县',3,'',NULL),
	(1739,165,'兴国县',3,'',NULL),
	(1740,165,'会昌县',3,'',NULL),
	(1741,165,'寻乌县',3,'',NULL),
	(1742,165,'石城县',3,'',NULL),
	(1743,165,'黄金区',3,'',NULL),
	(1744,165,'瑞金市',3,'',NULL),
	(1745,165,'南康区',3,'',NULL),
	(1746,165,'其它区',3,'',NULL),
	(1747,166,'吉州区',3,'',NULL),
	(1748,166,'青原区',3,'',NULL),
	(1749,166,'吉安县',3,'',NULL),
	(1750,166,'吉水县',3,'',NULL),
	(1751,166,'峡江县',3,'',NULL),
	(1752,166,'新干县',3,'',NULL),
	(1753,166,'永丰县',3,'',NULL),
	(1754,166,'泰和县',3,'',NULL),
	(1755,166,'遂川县',3,'',NULL),
	(1756,166,'万安县',3,'',NULL),
	(1757,166,'安福县',3,'',NULL),
	(1758,166,'永新县',3,'',NULL),
	(1759,166,'井冈山市',3,'',NULL),
	(1760,166,'其它区',3,'',NULL),
	(1761,167,'袁州区',3,'',NULL),
	(1762,167,'奉新县',3,'',NULL),
	(1763,167,'万载县',3,'',NULL),
	(1764,167,'上高县',3,'',NULL),
	(1765,167,'宜丰县',3,'',NULL),
	(1766,167,'靖安县',3,'',NULL),
	(1767,167,'铜鼓县',3,'',NULL),
	(1768,167,'丰城市',3,'',NULL),
	(1769,167,'樟树市',3,'',NULL),
	(1770,167,'高安市',3,'',NULL),
	(1771,167,'其它区',3,'',NULL),
	(1772,168,'临川区',3,'',NULL),
	(1773,168,'南城县',3,'',NULL),
	(1774,168,'黎川县',3,'',NULL),
	(1775,168,'南丰县',3,'',NULL),
	(1776,168,'崇仁县',3,'',NULL),
	(1777,168,'乐安县',3,'',NULL),
	(1778,168,'宜黄县',3,'',NULL),
	(1779,168,'金溪县',3,'',NULL),
	(1780,168,'资溪县',3,'',NULL),
	(1781,168,'东乡县',3,'',NULL),
	(1782,168,'广昌县',3,'',NULL),
	(1783,168,'其它区',3,'',NULL),
	(1784,169,'信州区',3,'',NULL),
	(1785,169,'上饶县',3,'',NULL),
	(1786,169,'广丰区',3,'',NULL),
	(1787,169,'玉山县',3,'',NULL),
	(1788,169,'铅山县',3,'',NULL),
	(1789,169,'横峰县',3,'',NULL),
	(1790,169,'弋阳县',3,'',NULL),
	(1791,169,'余干县',3,'',NULL),
	(1792,169,'鄱阳县',3,'',NULL),
	(1793,169,'万年县',3,'',NULL),
	(1794,169,'婺源县',3,'',NULL),
	(1795,169,'德兴市',3,'',NULL),
	(1796,169,'其它区',3,'',NULL),
	(1797,170,'历下区',3,'',NULL),
	(1798,170,'市中区',3,'',NULL),
	(1799,170,'槐荫区',3,'',NULL),
	(1800,170,'天桥区',3,'',NULL),
	(1801,170,'历城区',3,'',NULL),
	(1802,170,'长清区',3,'',NULL),
	(1803,170,'平阴县',3,'',NULL),
	(1804,170,'济阳县',3,'',NULL),
	(1805,170,'商河县',3,'',NULL),
	(1806,170,'章丘市',3,'',NULL),
	(1807,170,'其它区',3,'',NULL),
	(1808,171,'市南区',3,'',NULL),
	(1809,171,'市北区',3,'',NULL),
	(1810,171,'四方区',3,'',NULL),
	(1811,171,'黄岛区',3,'',NULL),
	(1812,171,'崂山区',3,'',NULL),
	(1813,171,'李沧区',3,'',NULL),
	(1814,171,'城阳区',3,'',NULL),
	(1815,171,'开发区',3,'',NULL),
	(1816,171,'胶州市',3,'',NULL),
	(1817,171,'即墨市',3,'',NULL),
	(1818,171,'平度市',3,'',NULL),
	(1819,171,'胶南市',3,'',NULL),
	(1820,171,'莱西市',3,'',NULL),
	(1821,171,'其它区',3,'',NULL),
	(1822,172,'淄川区',3,'',NULL),
	(1823,172,'张店区',3,'',NULL),
	(1824,172,'博山区',3,'',NULL),
	(1825,172,'临淄区',3,'',NULL),
	(1826,172,'周村区',3,'',NULL),
	(1827,172,'桓台县',3,'',NULL),
	(1828,172,'高青县',3,'',NULL),
	(1829,172,'沂源县',3,'',NULL),
	(1830,172,'其它区',3,'',NULL),
	(1831,173,'市中区',3,'',NULL),
	(1832,173,'薛城区',3,'',NULL),
	(1833,173,'峄城区',3,'',NULL),
	(1834,173,'台儿庄区',3,'',NULL),
	(1835,173,'山亭区',3,'',NULL),
	(1836,173,'滕州市',3,'',NULL),
	(1837,173,'其它区',3,'',NULL),
	(1838,174,'东营区',3,'',NULL),
	(1839,174,'河口区',3,'',NULL),
	(1840,174,'垦利县',3,'',NULL),
	(1841,174,'利津县',3,'',NULL),
	(1842,174,'广饶县',3,'',NULL),
	(1843,174,'西城区',3,'',NULL),
	(1844,174,'东城区',3,'',NULL),
	(1845,174,'其它区',3,'',NULL),
	(1846,175,'芝罘区',3,'',NULL),
	(1847,175,'福山区',3,'',NULL),
	(1848,175,'牟平区',3,'',NULL),
	(1849,175,'莱山区',3,'',NULL),
	(1850,175,'长岛县',3,'',NULL),
	(1851,175,'龙口市',3,'',NULL),
	(1852,175,'莱阳市',3,'',NULL),
	(1853,175,'莱州市',3,'',NULL),
	(1854,175,'蓬莱市',3,'',NULL),
	(1855,175,'招远市',3,'',NULL),
	(1856,175,'栖霞市',3,'',NULL),
	(1857,175,'海阳市',3,'',NULL),
	(1858,175,'其它区',3,'',NULL),
	(1859,176,'潍城区',3,'',NULL),
	(1860,176,'寒亭区',3,'',NULL),
	(1861,176,'坊子区',3,'',NULL),
	(1862,176,'奎文区',3,'',NULL),
	(1863,176,'临朐县',3,'',NULL),
	(1864,176,'昌乐县',3,'',NULL),
	(1865,176,'开发区',3,'',NULL),
	(1866,176,'青州市',3,'',NULL),
	(1867,176,'诸城市',3,'',NULL),
	(1868,176,'寿光市',3,'',NULL),
	(1869,176,'安丘市',3,'',NULL),
	(1870,176,'高密市',3,'',NULL),
	(1871,176,'昌邑市',3,'',NULL),
	(1872,176,'其它区',3,'',NULL),
	(1873,177,'市中区',3,'',NULL),
	(1874,177,'任城区',3,'',NULL),
	(1875,177,'微山县',3,'',NULL),
	(1876,177,'鱼台县',3,'',NULL),
	(1877,177,'金乡县',3,'',NULL),
	(1878,177,'嘉祥县',3,'',NULL),
	(1879,177,'汶上县',3,'',NULL),
	(1880,177,'泗水县',3,'',NULL),
	(1881,177,'梁山县',3,'',NULL),
	(1882,177,'曲阜市',3,'',NULL),
	(1883,177,'兖州区',3,'',NULL),
	(1884,177,'邹城市',3,'',NULL),
	(1885,177,'其它区',3,'',NULL),
	(1886,178,'泰山区',3,'',NULL),
	(1887,178,'岱岳区',3,'',NULL),
	(1888,178,'宁阳县',3,'',NULL),
	(1889,178,'东平县',3,'',NULL),
	(1890,178,'新泰市',3,'',NULL),
	(1891,178,'肥城市',3,'',NULL),
	(1892,178,'其它区',3,'',NULL),
	(1893,179,'环翠区',3,'',NULL),
	(1894,179,'文登区',3,'',NULL),
	(1895,179,'荣成市',3,'',NULL),
	(1896,179,'乳山市',3,'',NULL),
	(1897,179,'其它区',3,'',NULL),
	(1898,180,'东港区',3,'',NULL),
	(1899,180,'岚山区',3,'',NULL),
	(1900,180,'五莲县',3,'',NULL),
	(1901,180,'莒县',3,'',NULL),
	(1902,180,'其它区',3,'',NULL),
	(1903,181,'莱城区',3,'',NULL),
	(1904,181,'钢城区',3,'',NULL),
	(1905,181,'其它区',3,'',NULL),
	(1906,182,'兰山区',3,'',NULL),
	(1907,182,'罗庄区',3,'',NULL),
	(1908,182,'河东区',3,'',NULL),
	(1909,182,'沂南县',3,'',NULL),
	(1910,182,'郯城县',3,'',NULL),
	(1911,182,'沂水县',3,'',NULL),
	(1912,182,'兰陵县',3,'',NULL),
	(1913,182,'费县',3,'',NULL),
	(1914,182,'平邑县',3,'',NULL),
	(1915,182,'莒南县',3,'',NULL),
	(1916,182,'蒙阴县',3,'',NULL),
	(1917,182,'临沭县',3,'',NULL),
	(1918,182,'其它区',3,'',NULL),
	(1919,183,'德城区',3,'',NULL),
	(1920,183,'陵城区',3,'',NULL),
	(1921,183,'宁津县',3,'',NULL),
	(1922,183,'庆云县',3,'',NULL),
	(1923,183,'临邑县',3,'',NULL),
	(1924,183,'齐河县',3,'',NULL),
	(1925,183,'平原县',3,'',NULL),
	(1926,183,'夏津县',3,'',NULL),
	(1927,183,'武城县',3,'',NULL),
	(1928,183,'开发区',3,'',NULL),
	(1929,183,'乐陵市',3,'',NULL),
	(1930,183,'禹城市',3,'',NULL),
	(1931,183,'其它区',3,'',NULL),
	(1932,184,'东昌府区',3,'',NULL),
	(1933,184,'阳谷县',3,'',NULL),
	(1934,184,'莘县',3,'',NULL),
	(1935,184,'茌平县',3,'',NULL),
	(1936,184,'东阿县',3,'',NULL),
	(1937,184,'冠县',3,'',NULL),
	(1938,184,'高唐县',3,'',NULL),
	(1939,184,'临清市',3,'',NULL),
	(1940,184,'其它区',3,'',NULL),
	(1941,185,'滨城区',3,'',NULL),
	(1942,185,'惠民县',3,'',NULL),
	(1943,185,'阳信县',3,'',NULL),
	(1944,185,'无棣县',3,'',NULL),
	(1945,185,'沾化区',3,'',NULL),
	(1946,185,'博兴县',3,'',NULL),
	(1947,185,'邹平县',3,'',NULL),
	(1948,185,'其它区',3,'',NULL),
	(1949,186,'牡丹区',3,'',NULL),
	(1950,186,'曹县',3,'',NULL),
	(1951,186,'单县',3,'',NULL),
	(1952,186,'成武县',3,'',NULL),
	(1953,186,'巨野县',3,'',NULL),
	(1954,186,'郓城县',3,'',NULL),
	(1955,186,'鄄城县',3,'',NULL),
	(1956,186,'定陶县',3,'',NULL),
	(1957,186,'东明县',3,'',NULL),
	(1958,186,'其它区',3,'',NULL),
	(1959,187,'中原区',3,'',NULL),
	(1960,187,'二七区',3,'',NULL),
	(1961,187,'管城回族区',3,'',NULL),
	(1962,187,'金水区',3,'',NULL),
	(1963,187,'上街区',3,'',NULL),
	(1964,187,'惠济区',3,'',NULL),
	(1965,187,'中牟县',3,'',NULL),
	(1966,187,'巩义市',3,'',NULL),
	(1967,187,'荥阳市',3,'',NULL),
	(1968,187,'新密市',3,'',NULL),
	(1969,187,'新郑市',3,'',NULL),
	(1970,187,'登封市',3,'',NULL),
	(1971,187,'郑东新区',3,'',NULL),
	(1972,187,'高新区',3,'',NULL),
	(1973,187,'其它区',3,'',NULL),
	(1974,188,'龙亭区',3,'',NULL),
	(1975,188,'顺河回族区',3,'',NULL),
	(1976,188,'鼓楼区',3,'',NULL),
	(1977,188,'禹王台区',3,'',NULL),
	(1978,188,'金明区',3,'',NULL),
	(1979,188,'杞县',3,'',NULL),
	(1980,188,'通许县',3,'',NULL),
	(1981,188,'尉氏县',3,'',NULL),
	(1982,188,'祥符区',3,'',NULL),
	(1983,188,'兰考县',3,'',NULL),
	(1984,188,'其它区',3,'',NULL),
	(1985,189,'老城区',3,'',NULL),
	(1986,189,'西工区',3,'',NULL),
	(1987,189,'瀍河回族区',3,'',NULL),
	(1988,189,'涧西区',3,'',NULL),
	(1989,189,'吉利区',3,'',NULL),
	(1990,189,'洛龙区',3,'',NULL),
	(1991,189,'孟津县',3,'',NULL),
	(1992,189,'新安县',3,'',NULL),
	(1993,189,'栾川县',3,'',NULL),
	(1994,189,'嵩县',3,'',NULL),
	(1995,189,'汝阳县',3,'',NULL),
	(1996,189,'宜阳县',3,'',NULL),
	(1997,189,'洛宁县',3,'',NULL),
	(1998,189,'伊川县',3,'',NULL),
	(1999,189,'偃师市',3,'',NULL),
	(2000,190,'新华区',3,'',NULL),
	(2001,190,'卫东区',3,'',NULL),
	(2002,190,'石龙区',3,'',NULL),
	(2003,190,'湛河区',3,'',NULL),
	(2004,190,'宝丰县',3,'',NULL),
	(2005,190,'叶县',3,'',NULL),
	(2006,190,'鲁山县',3,'',NULL),
	(2007,190,'郏县',3,'',NULL),
	(2008,190,'舞钢市',3,'',NULL),
	(2009,190,'汝州市',3,'',NULL),
	(2010,190,'其它区',3,'',NULL),
	(2011,191,'文峰区',3,'',NULL),
	(2012,191,'北关区',3,'',NULL),
	(2013,191,'殷都区',3,'',NULL),
	(2014,191,'龙安区',3,'',NULL),
	(2015,191,'安阳县',3,'',NULL),
	(2016,191,'汤阴县',3,'',NULL),
	(2017,191,'滑县',3,'',NULL),
	(2018,191,'内黄县',3,'',NULL),
	(2019,191,'林州市',3,'',NULL),
	(2020,191,'其它区',3,'',NULL),
	(2021,192,'鹤山区',3,'',NULL),
	(2022,192,'山城区',3,'',NULL),
	(2023,192,'淇滨区',3,'',NULL),
	(2024,192,'浚县',3,'',NULL),
	(2025,192,'淇县',3,'',NULL),
	(2026,192,'其它区',3,'',NULL),
	(2027,193,'红旗区',3,'',NULL),
	(2028,193,'卫滨区',3,'',NULL),
	(2029,193,'凤泉区',3,'',NULL),
	(2030,193,'牧野区',3,'',NULL),
	(2031,193,'新乡县',3,'',NULL),
	(2032,193,'获嘉县',3,'',NULL),
	(2033,193,'原阳县',3,'',NULL),
	(2034,193,'延津县',3,'',NULL),
	(2035,193,'封丘县',3,'',NULL),
	(2036,193,'长垣县',3,'',NULL),
	(2037,193,'卫辉市',3,'',NULL),
	(2038,193,'辉县市',3,'',NULL),
	(2039,193,'其它区',3,'',NULL),
	(2040,194,'解放区',3,'',NULL),
	(2041,194,'中站区',3,'',NULL),
	(2042,194,'马村区',3,'',NULL),
	(2043,194,'山阳区',3,'',NULL),
	(2044,194,'修武县',3,'',NULL),
	(2045,194,'博爱县',3,'',NULL),
	(2046,194,'武陟县',3,'',NULL),
	(2047,194,'温县',3,'',NULL),
	(2048,194,'沁阳市',3,'',NULL),
	(2049,194,'孟州市',3,'',NULL),
	(2050,194,'其它区',3,'',NULL),
	(2051,195,'华龙区',3,'',NULL),
	(2052,195,'清丰县',3,'',NULL),
	(2053,195,'南乐县',3,'',NULL),
	(2054,195,'范县',3,'',NULL),
	(2055,195,'台前县',3,'',NULL),
	(2056,195,'濮阳县',3,'',NULL),
	(2057,195,'其它区',3,'',NULL),
	(2058,196,'魏都区',3,'',NULL),
	(2059,196,'许昌县',3,'',NULL),
	(2060,196,'鄢陵县',3,'',NULL),
	(2061,196,'襄城县',3,'',NULL),
	(2062,196,'禹州市',3,'',NULL),
	(2063,196,'长葛市',3,'',NULL),
	(2064,196,'其它区',3,'',NULL),
	(2065,197,'源汇区',3,'',NULL),
	(2066,197,'郾城区',3,'',NULL),
	(2067,197,'召陵区',3,'',NULL),
	(2068,197,'舞阳县',3,'',NULL),
	(2069,197,'临颍县',3,'',NULL),
	(2070,197,'其它区',3,'',NULL),
	(2071,198,'湖滨区',3,'',NULL),
	(2072,198,'渑池县',3,'',NULL),
	(2073,198,'陕州区',3,'',NULL),
	(2074,198,'卢氏县',3,'',NULL),
	(2075,198,'义马市',3,'',NULL),
	(2076,198,'灵宝市',3,'',NULL),
	(2077,198,'其它区',3,'',NULL),
	(2078,199,'宛城区',3,'',NULL),
	(2079,199,'卧龙区',3,'',NULL),
	(2080,199,'南召县',3,'',NULL),
	(2081,199,'方城县',3,'',NULL),
	(2082,199,'西峡县',3,'',NULL),
	(2083,199,'镇平县',3,'',NULL),
	(2084,199,'内乡县',3,'',NULL),
	(2085,199,'淅川县',3,'',NULL),
	(2086,199,'社旗县',3,'',NULL),
	(2087,199,'唐河县',3,'',NULL),
	(2088,199,'新野县',3,'',NULL),
	(2089,199,'桐柏县',3,'',NULL),
	(2090,199,'邓州市',3,'',NULL),
	(2091,199,'其它区',3,'',NULL),
	(2092,200,'梁园区',3,'',NULL),
	(2093,200,'睢阳区',3,'',NULL),
	(2094,200,'民权县',3,'',NULL),
	(2095,200,'睢县',3,'',NULL),
	(2096,200,'宁陵县',3,'',NULL),
	(2097,200,'柘城县',3,'',NULL),
	(2098,200,'虞城县',3,'',NULL),
	(2099,200,'夏邑县',3,'',NULL),
	(2100,200,'永城市',3,'',NULL),
	(2101,200,'其它区',3,'',NULL),
	(2102,201,'浉河区',3,'',NULL),
	(2103,201,'平桥区',3,'',NULL),
	(2104,201,'罗山县',3,'',NULL),
	(2105,201,'光山县',3,'',NULL),
	(2106,201,'新县',3,'',NULL),
	(2107,201,'商城县',3,'',NULL),
	(2108,201,'固始县',3,'',NULL),
	(2109,201,'潢川县',3,'',NULL),
	(2110,201,'淮滨县',3,'',NULL),
	(2111,201,'息县',3,'',NULL),
	(2112,201,'其它区',3,'',NULL),
	(2113,202,'川汇区',3,'',NULL),
	(2114,202,'扶沟县',3,'',NULL),
	(2115,202,'西华县',3,'',NULL),
	(2116,202,'商水县',3,'',NULL),
	(2117,202,'沈丘县',3,'',NULL),
	(2118,202,'郸城县',3,'',NULL),
	(2119,202,'淮阳县',3,'',NULL),
	(2120,202,'太康县',3,'',NULL),
	(2121,202,'鹿邑县',3,'',NULL),
	(2122,202,'项城市',3,'',NULL),
	(2123,202,'其它区',3,'',NULL),
	(2124,203,'驿城区',3,'',NULL),
	(2125,203,'西平县',3,'',NULL),
	(2126,203,'上蔡县',3,'',NULL),
	(2127,203,'平舆县',3,'',NULL),
	(2128,203,'正阳县',3,'',NULL),
	(2129,203,'确山县',3,'',NULL),
	(2130,203,'泌阳县',3,'',NULL),
	(2131,203,'汝南县',3,'',NULL),
	(2132,203,'遂平县',3,'',NULL),
	(2133,203,'新蔡县',3,'',NULL),
	(2134,203,'其它区',3,'',NULL),
	(2135,204,'江岸区',3,'',NULL),
	(2136,204,'江汉区',3,'',NULL),
	(2137,204,'硚口区',3,'',NULL),
	(2138,204,'汉阳区',3,'',NULL),
	(2139,204,'武昌区',3,'',NULL),
	(2140,204,'青山区',3,'',NULL),
	(2141,204,'洪山区',3,'',NULL),
	(2142,204,'东西湖区',3,'',NULL),
	(2143,204,'汉南区',3,'',NULL),
	(2144,204,'蔡甸区',3,'',NULL),
	(2145,204,'江夏区',3,'',NULL),
	(2146,204,'黄陂区',3,'',NULL),
	(2147,204,'新洲区',3,'',NULL),
	(2148,204,'其它区',3,'',NULL),
	(2149,205,'黄石港区',3,'',NULL),
	(2150,205,'西塞山区',3,'',NULL),
	(2151,205,'下陆区',3,'',NULL),
	(2152,205,'铁山区',3,'',NULL),
	(2153,205,'阳新县',3,'',NULL),
	(2154,205,'大冶市',3,'',NULL),
	(2155,205,'其它区',3,'',NULL),
	(2156,206,'茅箭区',3,'',NULL),
	(2157,206,'张湾区',3,'',NULL),
	(2158,206,'郧阳区',3,'',NULL),
	(2159,206,'郧西县',3,'',NULL),
	(2160,206,'竹山县',3,'',NULL),
	(2161,206,'竹溪县',3,'',NULL),
	(2162,206,'房县',3,'',NULL),
	(2163,206,'丹江口市',3,'',NULL),
	(2164,206,'城区',3,'',NULL),
	(2165,206,'其它区',3,'',NULL),
	(2166,207,'西陵区',3,'',NULL),
	(2167,207,'伍家岗区',3,'',NULL),
	(2168,207,'点军区',3,'',NULL),
	(2169,207,'猇亭区',3,'',NULL),
	(2170,207,'夷陵区',3,'',NULL),
	(2171,207,'远安县',3,'',NULL),
	(2172,207,'兴山县',3,'',NULL),
	(2173,207,'秭归县',3,'',NULL),
	(2174,207,'长阳土家族自治县',3,'',NULL),
	(2175,207,'五峰土家族自治县',3,'',NULL),
	(2176,207,'葛洲坝区',3,'',NULL),
	(2177,207,'开发区',3,'',NULL),
	(2178,207,'宜都市',3,'',NULL),
	(2179,207,'当阳市',3,'',NULL),
	(2180,207,'枝江市',3,'',NULL),
	(2181,207,'其它区',3,'',NULL),
	(2182,208,'襄城区',3,'',NULL),
	(2183,208,'樊城区',3,'',NULL),
	(2184,208,'襄州区',3,'',NULL),
	(2185,208,'南漳县',3,'',NULL),
	(2186,208,'谷城县',3,'',NULL),
	(2187,208,'保康县',3,'',NULL),
	(2188,208,'老河口市',3,'',NULL),
	(2189,208,'枣阳市',3,'',NULL),
	(2190,208,'宜城市',3,'',NULL),
	(2191,208,'其它区',3,'',NULL),
	(2192,209,'梁子湖区',3,'',NULL),
	(2193,209,'华容区',3,'',NULL),
	(2194,209,'鄂城区',3,'',NULL),
	(2195,209,'其它区',3,'',NULL),
	(2196,210,'东宝区',3,'',NULL),
	(2197,210,'掇刀区',3,'',NULL),
	(2198,210,'京山县',3,'',NULL),
	(2199,210,'沙洋县',3,'',NULL),
	(2200,210,'钟祥市',3,'',NULL),
	(2201,210,'其它区',3,'',NULL),
	(2202,211,'孝南区',3,'',NULL),
	(2203,211,'孝昌县',3,'',NULL),
	(2204,211,'大悟县',3,'',NULL),
	(2205,211,'云梦县',3,'',NULL),
	(2206,211,'应城市',3,'',NULL),
	(2207,211,'安陆市',3,'',NULL),
	(2208,211,'汉川市',3,'',NULL),
	(2209,211,'其它区',3,'',NULL),
	(2210,212,'沙市区',3,'',NULL),
	(2211,212,'荆州区',3,'',NULL),
	(2212,212,'公安县',3,'',NULL),
	(2213,212,'监利县',3,'',NULL),
	(2214,212,'江陵县',3,'',NULL),
	(2215,212,'石首市',3,'',NULL),
	(2216,212,'洪湖市',3,'',NULL),
	(2217,212,'松滋市',3,'',NULL),
	(2218,212,'其它区',3,'',NULL),
	(2219,213,'黄州区',3,'',NULL),
	(2220,213,'团风县',3,'',NULL),
	(2221,213,'红安县',3,'',NULL),
	(2222,213,'罗田县',3,'',NULL),
	(2223,213,'英山县',3,'',NULL),
	(2224,213,'浠水县',3,'',NULL),
	(2225,213,'蕲春县',3,'',NULL),
	(2226,213,'黄梅县',3,'',NULL),
	(2227,213,'麻城市',3,'',NULL),
	(2228,213,'武穴市',3,'',NULL),
	(2229,213,'其它区',3,'',NULL),
	(2230,214,'咸安区',3,'',NULL),
	(2231,214,'嘉鱼县',3,'',NULL),
	(2232,214,'通城县',3,'',NULL),
	(2233,214,'崇阳县',3,'',NULL),
	(2234,214,'通山县',3,'',NULL),
	(2235,214,'赤壁市',3,'',NULL),
	(2236,214,'温泉城区',3,'',NULL),
	(2237,214,'其它区',3,'',NULL),
	(2238,215,'曾都区',3,'',NULL),
	(2239,215,'随县',3,'',NULL),
	(2240,215,'广水市',3,'',NULL),
	(2241,215,'其它区',3,'',NULL),
	(2242,216,'恩施市',3,'',NULL),
	(2243,216,'利川市',3,'',NULL),
	(2244,216,'建始县',3,'',NULL),
	(2245,216,'巴东县',3,'',NULL),
	(2246,216,'宣恩县',3,'',NULL),
	(2247,216,'咸丰县',3,'',NULL),
	(2248,216,'来凤县',3,'',NULL),
	(2249,216,'鹤峰县',3,'',NULL),
	(2250,216,'其它区',3,'',NULL),
	(2251,217,'芙蓉区',3,'',NULL),
	(2252,217,'天心区',3,'',NULL),
	(2253,217,'岳麓区',3,'',NULL),
	(2254,217,'开福区',3,'',NULL),
	(2255,217,'雨花区',3,'',NULL),
	(2256,217,'长沙县',3,'',NULL),
	(2257,217,'望城区',3,'',NULL),
	(2258,217,'宁乡县',3,'',NULL),
	(2259,217,'浏阳市',3,'',NULL),
	(2260,217,'其它区',3,'',NULL),
	(2261,218,'荷塘区',3,'',NULL),
	(2262,218,'芦淞区',3,'',NULL),
	(2263,218,'石峰区',3,'',NULL),
	(2264,218,'天元区',3,'',NULL),
	(2265,218,'株洲县',3,'',NULL),
	(2266,218,'攸县',3,'',NULL),
	(2267,218,'茶陵县',3,'',NULL),
	(2268,218,'炎陵县',3,'',NULL),
	(2269,218,'醴陵市',3,'',NULL),
	(2270,218,'其它区',3,'',NULL),
	(2271,219,'雨湖区',3,'',NULL),
	(2272,219,'岳塘区',3,'',NULL),
	(2273,219,'湘潭县',3,'',NULL),
	(2274,219,'湘乡市',3,'',NULL),
	(2275,219,'韶山市',3,'',NULL),
	(2276,219,'其它区',3,'',NULL),
	(2277,220,'珠晖区',3,'',NULL),
	(2278,220,'雁峰区',3,'',NULL),
	(2279,220,'石鼓区',3,'',NULL),
	(2280,220,'蒸湘区',3,'',NULL),
	(2281,220,'南岳区',3,'',NULL),
	(2282,220,'衡阳县',3,'',NULL),
	(2283,220,'衡南县',3,'',NULL),
	(2284,220,'衡山县',3,'',NULL),
	(2285,220,'衡东县',3,'',NULL),
	(2286,220,'祁东县',3,'',NULL),
	(2287,220,'耒阳市',3,'',NULL),
	(2288,220,'常宁市',3,'',NULL),
	(2289,220,'其它区',3,'',NULL),
	(2290,221,'双清区',3,'',NULL),
	(2291,221,'大祥区',3,'',NULL),
	(2292,221,'北塔区',3,'',NULL),
	(2293,221,'邵东县',3,'',NULL),
	(2294,221,'新邵县',3,'',NULL),
	(2295,221,'邵阳县',3,'',NULL),
	(2296,221,'隆回县',3,'',NULL),
	(2297,221,'洞口县',3,'',NULL),
	(2298,221,'绥宁县',3,'',NULL),
	(2299,221,'新宁县',3,'',NULL),
	(2300,221,'城步苗族自治县',3,'',NULL),
	(2301,221,'武冈市',3,'',NULL),
	(2302,221,'其它区',3,'',NULL),
	(2303,222,'岳阳楼区',3,'',NULL),
	(2304,222,'云溪区',3,'',NULL),
	(2305,222,'君山区',3,'',NULL),
	(2306,222,'岳阳县',3,'',NULL),
	(2307,222,'华容县',3,'',NULL),
	(2308,222,'湘阴县',3,'',NULL),
	(2309,222,'平江县',3,'',NULL),
	(2310,222,'汨罗市',3,'',NULL),
	(2311,222,'临湘市',3,'',NULL),
	(2312,222,'其它区',3,'',NULL),
	(2313,223,'武陵区',3,'',NULL),
	(2314,223,'鼎城区',3,'',NULL),
	(2315,223,'安乡县',3,'',NULL),
	(2316,223,'汉寿县',3,'',NULL),
	(2317,223,'澧县',3,'',NULL),
	(2318,223,'临澧县',3,'',NULL),
	(2319,223,'桃源县',3,'',NULL),
	(2320,223,'石门县',3,'',NULL),
	(2321,223,'津市市',3,'',NULL),
	(2322,223,'其它区',3,'',NULL),
	(2323,224,'永定区',3,'',NULL),
	(2324,224,'武陵源区',3,'',NULL),
	(2325,224,'慈利县',3,'',NULL),
	(2326,224,'桑植县',3,'',NULL),
	(2327,224,'其它区',3,'',NULL),
	(2328,225,'资阳区',3,'',NULL),
	(2329,225,'赫山区',3,'',NULL),
	(2330,225,'南县',3,'',NULL),
	(2331,225,'桃江县',3,'',NULL),
	(2332,225,'安化县',3,'',NULL),
	(2333,225,'沅江市',3,'',NULL),
	(2334,225,'其它区',3,'',NULL),
	(2335,226,'北湖区',3,'',NULL),
	(2336,226,'苏仙区',3,'',NULL),
	(2337,226,'桂阳县',3,'',NULL),
	(2338,226,'宜章县',3,'',NULL),
	(2339,226,'永兴县',3,'',NULL),
	(2340,226,'嘉禾县',3,'',NULL),
	(2341,226,'临武县',3,'',NULL),
	(2342,226,'汝城县',3,'',NULL),
	(2343,226,'桂东县',3,'',NULL),
	(2344,226,'安仁县',3,'',NULL),
	(2345,226,'资兴市',3,'',NULL),
	(2346,226,'其它区',3,'',NULL),
	(2347,227,'零陵区',3,'',NULL),
	(2348,227,'冷水滩区',3,'',NULL),
	(2349,227,'祁阳县',3,'',NULL),
	(2350,227,'东安县',3,'',NULL),
	(2351,227,'双牌县',3,'',NULL),
	(2352,227,'道县',3,'',NULL),
	(2353,227,'江永县',3,'',NULL),
	(2354,227,'宁远县',3,'',NULL),
	(2355,227,'蓝山县',3,'',NULL),
	(2356,227,'新田县',3,'',NULL),
	(2357,227,'江华瑶族自治县',3,'',NULL),
	(2358,227,'其它区',3,'',NULL),
	(2359,228,'鹤城区',3,'',NULL),
	(2360,228,'中方县',3,'',NULL),
	(2361,228,'沅陵县',3,'',NULL),
	(2362,228,'辰溪县',3,'',NULL),
	(2363,228,'溆浦县',3,'',NULL),
	(2364,228,'会同县',3,'',NULL),
	(2365,228,'麻阳苗族自治县',3,'',NULL),
	(2366,228,'新晃侗族自治县',3,'',NULL),
	(2367,228,'芷江侗族自治县',3,'',NULL),
	(2368,228,'靖州苗族侗族自治县',3,'',NULL),
	(2369,228,'通道侗族自治县',3,'',NULL),
	(2370,228,'洪江市',3,'',NULL),
	(2371,228,'其它区',3,'',NULL),
	(2372,229,'娄星区',3,'',NULL),
	(2373,229,'双峰县',3,'',NULL),
	(2374,229,'新化县',3,'',NULL),
	(2375,229,'冷水江市',3,'',NULL),
	(2376,229,'涟源市',3,'',NULL),
	(2377,229,'其它区',3,'',NULL),
	(2378,230,'吉首市',3,'',NULL),
	(2379,230,'泸溪县',3,'',NULL),
	(2380,230,'凤凰县',3,'',NULL),
	(2381,230,'花垣县',3,'',NULL),
	(2382,230,'保靖县',3,'',NULL),
	(2383,230,'古丈县',3,'',NULL),
	(2384,230,'永顺县',3,'',NULL),
	(2385,230,'龙山县',3,'',NULL),
	(2386,230,'其它区',3,'',NULL),
	(2387,231,'荔湾区',3,'',NULL),
	(2388,231,'越秀区',3,'',NULL),
	(2389,231,'海珠区',3,'',NULL),
	(2390,231,'天河区',3,'',NULL),
	(2391,231,'白云区',3,'',NULL),
	(2392,231,'黄埔区',3,'',NULL),
	(2393,231,'番禺区',3,'',NULL),
	(2394,231,'花都区',3,'',NULL),
	(2395,231,'南沙区',3,'',NULL),
	(2396,231,'萝岗区',3,'',NULL),
	(2397,231,'增城区',3,'',NULL),
	(2398,231,'从化区',3,'',NULL),
	(2399,231,'东山区',3,'',NULL),
	(2400,231,'其它区',3,'',NULL),
	(2401,232,'武江区',3,'',NULL),
	(2402,232,'浈江区',3,'',NULL),
	(2403,232,'曲江区',3,'',NULL),
	(2404,232,'始兴县',3,'',NULL),
	(2405,232,'仁化县',3,'',NULL),
	(2406,232,'翁源县',3,'',NULL),
	(2407,232,'乳源瑶族自治县',3,'',NULL),
	(2408,232,'新丰县',3,'',NULL),
	(2409,232,'乐昌市',3,'',NULL),
	(2410,232,'南雄市',3,'',NULL),
	(2411,232,'其它区',3,'',NULL),
	(2412,233,'罗湖区',3,'',NULL),
	(2413,233,'福田区',3,'',NULL),
	(2414,233,'南山区',3,'',NULL),
	(2415,233,'宝安区',3,'',NULL),
	(2416,233,'龙岗区',3,'',NULL),
	(2417,233,'盐田区',3,'',NULL),
	(2418,233,'其它区',3,'',NULL),
	(2419,233,'光明新区',3,'',NULL),
	(2420,233,'坪山新区',3,'',NULL),
	(2421,233,'大鹏新区',3,'',NULL),
	(2422,233,'龙华新区',3,'',NULL),
	(2423,234,'香洲区',3,'',NULL),
	(2424,234,'斗门区',3,'',NULL),
	(2425,234,'金湾区',3,'',NULL),
	(2426,234,'金唐区',3,'',NULL),
	(2427,234,'南湾区',3,'',NULL),
	(2428,234,'其它区',3,'',NULL),
	(2429,235,'龙湖区',3,'',NULL),
	(2430,235,'金平区',3,'',NULL),
	(2431,235,'濠江区',3,'',NULL),
	(2432,235,'潮阳区',3,'',NULL),
	(2433,235,'潮南区',3,'',NULL),
	(2434,235,'澄海区',3,'',NULL),
	(2435,235,'南澳县',3,'',NULL),
	(2436,235,'其它区',3,'',NULL),
	(2437,236,'禅城区',3,'',NULL),
	(2438,236,'南海区',3,'',NULL),
	(2439,236,'顺德区',3,'',NULL),
	(2440,236,'三水区',3,'',NULL),
	(2441,236,'高明区',3,'',NULL),
	(2442,236,'其它区',3,'',NULL),
	(2443,237,'蓬江区',3,'',NULL),
	(2444,237,'江海区',3,'',NULL),
	(2445,237,'新会区',3,'',NULL),
	(2446,237,'台山市',3,'',NULL),
	(2447,237,'开平市',3,'',NULL),
	(2448,237,'鹤山市',3,'',NULL),
	(2449,237,'恩平市',3,'',NULL),
	(2450,237,'其它区',3,'',NULL),
	(2451,238,'赤坎区',3,'',NULL),
	(2452,238,'霞山区',3,'',NULL),
	(2453,238,'坡头区',3,'',NULL),
	(2454,238,'麻章区',3,'',NULL),
	(2455,238,'遂溪县',3,'',NULL),
	(2456,238,'徐闻县',3,'',NULL),
	(2457,238,'廉江市',3,'',NULL),
	(2458,238,'雷州市',3,'',NULL),
	(2459,238,'吴川市',3,'',NULL),
	(2460,238,'其它区',3,'',NULL),
	(2461,239,'茂南区',3,'',NULL),
	(2462,239,'电白区',3,'',NULL),
	(2463,239,'电白县',3,'',NULL),
	(2464,239,'高州市',3,'',NULL),
	(2465,239,'化州市',3,'',NULL),
	(2466,239,'信宜市',3,'',NULL),
	(2467,239,'其它区',3,'',NULL),
	(2468,240,'端州区',3,'',NULL),
	(2469,240,'鼎湖区',3,'',NULL),
	(2470,240,'广宁县',3,'',NULL),
	(2471,240,'怀集县',3,'',NULL),
	(2472,240,'封开县',3,'',NULL),
	(2473,240,'德庆县',3,'',NULL),
	(2474,240,'高要市',3,'',NULL),
	(2475,240,'四会市',3,'',NULL),
	(2476,240,'其它区',3,'',NULL),
	(2477,241,'惠城区',3,'',NULL),
	(2478,241,'惠阳区',3,'',NULL),
	(2479,241,'博罗县',3,'',NULL),
	(2480,241,'惠东县',3,'',NULL),
	(2481,241,'龙门县',3,'',NULL),
	(2482,241,'其它区',3,'',NULL),
	(2483,242,'梅江区',3,'',NULL),
	(2484,242,'梅县区',3,'',NULL),
	(2485,242,'大埔县',3,'',NULL),
	(2486,242,'丰顺县',3,'',NULL),
	(2487,242,'五华县',3,'',NULL),
	(2488,242,'平远县',3,'',NULL),
	(2489,242,'蕉岭县',3,'',NULL),
	(2490,242,'兴宁市',3,'',NULL),
	(2491,242,'其它区',3,'',NULL),
	(2492,243,'城区',3,'',NULL),
	(2493,243,'海丰县',3,'',NULL),
	(2494,243,'陆河县',3,'',NULL),
	(2495,243,'陆丰市',3,'',NULL),
	(2496,243,'其它区',3,'',NULL),
	(2497,244,'源城区',3,'',NULL),
	(2498,244,'紫金县',3,'',NULL),
	(2499,244,'龙川县',3,'',NULL),
	(2500,244,'连平县',3,'',NULL),
	(2501,244,'和平县',3,'',NULL),
	(2502,244,'东源县',3,'',NULL),
	(2503,244,'其它区',3,'',NULL),
	(2504,245,'江城区',3,'',NULL),
	(2505,245,'阳西县',3,'',NULL),
	(2506,245,'阳东区',3,'',NULL),
	(2507,245,'阳春市',3,'',NULL),
	(2508,245,'其它区',3,'',NULL),
	(2509,246,'清城区',3,'',NULL),
	(2510,246,'佛冈县',3,'',NULL),
	(2511,246,'阳山县',3,'',NULL),
	(2512,246,'连山壮族瑶族自治县',3,'',NULL),
	(2513,246,'连南瑶族自治县',3,'',NULL),
	(2514,246,'清新区',3,'',NULL),
	(2515,246,'英德市',3,'',NULL),
	(2516,246,'连州市',3,'',NULL),
	(2517,246,'其它区',3,'',NULL),
	(2518,250,'湘桥区',3,'',NULL),
	(2519,250,'潮安区',3,'',NULL),
	(2520,250,'饶平县',3,'',NULL),
	(2521,250,'枫溪区',3,'',NULL),
	(2522,250,'其它区',3,'',NULL),
	(2523,251,'榕城区',3,'',NULL),
	(2524,251,'揭东区',3,'',NULL),
	(2525,251,'揭西县',3,'',NULL),
	(2526,251,'惠来县',3,'',NULL),
	(2527,251,'普宁市',3,'',NULL),
	(2528,251,'东山区',3,'',NULL),
	(2529,251,'其它区',3,'',NULL),
	(2530,252,'云城区',3,'',NULL),
	(2531,252,'新兴县',3,'',NULL),
	(2532,252,'郁南县',3,'',NULL),
	(2533,252,'云安区',3,'',NULL),
	(2534,252,'罗定市',3,'',NULL),
	(2535,252,'其它区',3,'',NULL),
	(2536,253,'兴宁区',3,'',NULL),
	(2537,253,'青秀区',3,'',NULL),
	(2538,253,'江南区',3,'',NULL),
	(2539,253,'西乡塘区',3,'',NULL),
	(2540,253,'良庆区',3,'',NULL),
	(2541,253,'邕宁区',3,'',NULL),
	(2542,253,'武鸣区',3,'',NULL),
	(2543,253,'隆安县',3,'',NULL),
	(2544,253,'马山县',3,'',NULL),
	(2545,253,'上林县',3,'',NULL),
	(2546,253,'宾阳县',3,'',NULL),
	(2547,253,'横县',3,'',NULL),
	(2548,253,'其它区',3,'',NULL),
	(2549,254,'城中区',3,'',NULL),
	(2550,254,'鱼峰区',3,'',NULL),
	(2551,254,'柳南区',3,'',NULL),
	(2552,254,'柳北区',3,'',NULL),
	(2553,254,'柳江县',3,'',NULL),
	(2554,254,'柳城县',3,'',NULL),
	(2555,254,'鹿寨县',3,'',NULL),
	(2556,254,'融安县',3,'',NULL),
	(2557,254,'融水苗族自治县',3,'',NULL),
	(2558,254,'三江侗族自治县',3,'',NULL),
	(2559,254,'其它区',3,'',NULL),
	(2560,255,'秀峰区',3,'',NULL),
	(2561,255,'叠彩区',3,'',NULL),
	(2562,255,'象山区',3,'',NULL),
	(2563,255,'七星区',3,'',NULL),
	(2564,255,'雁山区',3,'',NULL),
	(2565,255,'阳朔县',3,'',NULL),
	(2566,255,'临桂区',3,'',NULL),
	(2567,255,'灵川县',3,'',NULL),
	(2568,255,'全州县',3,'',NULL),
	(2569,255,'兴安县',3,'',NULL),
	(2570,255,'永福县',3,'',NULL),
	(2571,255,'灌阳县',3,'',NULL),
	(2572,255,'龙胜各族自治县',3,'',NULL),
	(2573,255,'资源县',3,'',NULL),
	(2574,255,'平乐县',3,'',NULL),
	(2575,255,'荔浦县',3,'',NULL),
	(2576,255,'恭城瑶族自治县',3,'',NULL),
	(2577,255,'其它区',3,'',NULL),
	(2578,256,'万秀区',3,'',NULL),
	(2579,256,'蝶山区',3,'',NULL),
	(2580,256,'长洲区',3,'',NULL),
	(2581,256,'龙圩区',3,'',NULL),
	(2582,256,'苍梧县',3,'',NULL),
	(2583,256,'藤县',3,'',NULL),
	(2584,256,'蒙山县',3,'',NULL),
	(2585,256,'岑溪市',3,'',NULL),
	(2586,256,'其它区',3,'',NULL),
	(2587,257,'海城区',3,'',NULL),
	(2588,257,'银海区',3,'',NULL),
	(2589,257,'铁山港区',3,'',NULL),
	(2590,257,'合浦县',3,'',NULL),
	(2591,257,'其它区',3,'',NULL),
	(2592,258,'港口区',3,'',NULL),
	(2593,258,'防城区',3,'',NULL),
	(2594,258,'上思县',3,'',NULL),
	(2595,258,'东兴市',3,'',NULL),
	(2596,258,'其它区',3,'',NULL),
	(2597,259,'钦南区',3,'',NULL),
	(2598,259,'钦北区',3,'',NULL),
	(2599,259,'灵山县',3,'',NULL),
	(2600,259,'浦北县',3,'',NULL),
	(2601,259,'其它区',3,'',NULL),
	(2602,260,'港北区',3,'',NULL),
	(2603,260,'港南区',3,'',NULL),
	(2604,260,'覃塘区',3,'',NULL),
	(2605,260,'平南县',3,'',NULL),
	(2606,260,'桂平市',3,'',NULL),
	(2607,260,'其它区',3,'',NULL),
	(2608,261,'玉州区',3,'',NULL),
	(2609,261,'福绵区',3,'',NULL),
	(2610,261,'容县',3,'',NULL),
	(2611,261,'陆川县',3,'',NULL),
	(2612,261,'博白县',3,'',NULL),
	(2613,261,'兴业县',3,'',NULL),
	(2614,261,'北流市',3,'',NULL),
	(2615,261,'其它区',3,'',NULL),
	(2616,262,'右江区',3,'',NULL),
	(2617,262,'田阳县',3,'',NULL),
	(2618,262,'田东县',3,'',NULL),
	(2619,262,'平果县',3,'',NULL),
	(2620,262,'德保县',3,'',NULL),
	(2621,262,'靖西县',3,'',NULL),
	(2622,262,'那坡县',3,'',NULL),
	(2623,262,'凌云县',3,'',NULL),
	(2624,262,'乐业县',3,'',NULL),
	(2625,262,'田林县',3,'',NULL),
	(2626,262,'西林县',3,'',NULL),
	(2627,262,'隆林各族自治县',3,'',NULL),
	(2628,262,'其它区',3,'',NULL),
	(2629,263,'八步区',3,'',NULL),
	(2630,263,'平桂管理区',3,'',NULL),
	(2631,263,'昭平县',3,'',NULL),
	(2632,263,'钟山县',3,'',NULL),
	(2633,263,'富川瑶族自治县',3,'',NULL),
	(2634,263,'其它区',3,'',NULL),
	(2635,264,'金城江区',3,'',NULL),
	(2636,264,'南丹县',3,'',NULL),
	(2637,264,'天峨县',3,'',NULL),
	(2638,264,'凤山县',3,'',NULL),
	(2639,264,'东兰县',3,'',NULL),
	(2640,264,'罗城仫佬族自治县',3,'',NULL),
	(2641,264,'环江毛南族自治县',3,'',NULL),
	(2642,264,'巴马瑶族自治县',3,'',NULL),
	(2643,264,'都安瑶族自治县',3,'',NULL),
	(2644,264,'大化瑶族自治县',3,'',NULL),
	(2645,264,'宜州市',3,'',NULL),
	(2646,264,'其它区',3,'',NULL),
	(2647,265,'兴宾区',3,'',NULL),
	(2648,265,'忻城县',3,'',NULL),
	(2649,265,'象州县',3,'',NULL),
	(2650,265,'武宣县',3,'',NULL),
	(2651,265,'金秀瑶族自治县',3,'',NULL),
	(2652,265,'合山市',3,'',NULL),
	(2653,265,'其它区',3,'',NULL),
	(2654,266,'江州区',3,'',NULL),
	(2655,266,'扶绥县',3,'',NULL),
	(2656,266,'宁明县',3,'',NULL),
	(2657,266,'龙州县',3,'',NULL),
	(2658,266,'大新县',3,'',NULL),
	(2659,266,'天等县',3,'',NULL),
	(2660,266,'凭祥市',3,'',NULL),
	(2661,266,'其它区',3,'',NULL),
	(2662,267,'秀英区',3,'',NULL),
	(2663,267,'龙华区',3,'',NULL),
	(2664,267,'琼山区',3,'',NULL),
	(2665,267,'美兰区',3,'',NULL),
	(2666,267,'其它区',3,'',NULL),
	(2667,269,'西沙群岛',3,'',NULL),
	(2668,269,'南沙群岛',3,'',NULL),
	(2669,269,'中沙群岛的岛礁及其海域',3,'',NULL),
	(2670,189,'高新区',3,'',NULL),
	(2671,189,'其它区',3,'',NULL),
	(2672,270,'万州区',3,'',NULL),
	(2673,270,'涪陵区',3,'',NULL),
	(2674,270,'渝中区',3,'',NULL),
	(2675,270,'大渡口区',3,'',NULL),
	(2676,270,'江北区',3,'',NULL),
	(2677,270,'沙坪坝区',3,'',NULL),
	(2678,270,'九龙坡区',3,'',NULL),
	(2679,270,'南岸区',3,'',NULL),
	(2680,270,'北碚区',3,'',NULL),
	(2681,270,'万盛区',3,'',NULL),
	(2682,270,'双桥区',3,'',NULL),
	(2683,270,'渝北区',3,'',NULL),
	(2684,270,'巴南区',3,'',NULL),
	(2685,270,'黔江区',3,'',NULL),
	(2686,270,'长寿区',3,'',NULL),
	(2687,270,'綦江区',3,'',NULL),
	(2688,270,'潼南县',3,'',NULL),
	(2689,270,'铜梁区',3,'',NULL),
	(2690,270,'大足区',3,'',NULL),
	(2691,270,'荣昌县',3,'',NULL),
	(2692,270,'璧山区',3,'',NULL),
	(2693,270,'梁平县',3,'',NULL),
	(2694,270,'城口县',3,'',NULL),
	(2695,270,'丰都县',3,'',NULL),
	(2696,270,'垫江县',3,'',NULL),
	(2697,270,'武隆县',3,'',NULL),
	(2698,270,'忠县',3,'',NULL),
	(2699,270,'开县',3,'',NULL),
	(2700,270,'云阳县',3,'',NULL),
	(2701,270,'奉节县',3,'',NULL),
	(2702,270,'巫山县',3,'',NULL),
	(2703,270,'巫溪县',3,'',NULL),
	(2704,270,'石柱土家族自治县',3,'',NULL),
	(2705,270,'秀山土家族苗族自治县',3,'',NULL),
	(2706,270,'酉阳土家族苗族自治县',3,'',NULL),
	(2707,270,'彭水苗族土家族自治县',3,'',NULL),
	(2708,270,'江津区',3,'',NULL),
	(2709,270,'合川区',3,'',NULL),
	(2710,270,'永川区',3,'',NULL),
	(2711,270,'南川区',3,'',NULL),
	(2712,270,'其它区',3,'',NULL),
	(2713,271,'锦江区',3,'',NULL),
	(2714,271,'青羊区',3,'',NULL),
	(2715,271,'金牛区',3,'',NULL),
	(2716,271,'武侯区',3,'',NULL),
	(2717,271,'成华区',3,'',NULL),
	(2718,271,'龙泉驿区',3,'',NULL),
	(2719,271,'青白江区',3,'',NULL),
	(2720,271,'新都区',3,'',NULL),
	(2721,271,'温江区',3,'',NULL),
	(2722,271,'金堂县',3,'',NULL),
	(2723,271,'双流县',3,'',NULL),
	(2724,271,'郫县',3,'',NULL),
	(2725,271,'大邑县',3,'',NULL),
	(2726,271,'蒲江县',3,'',NULL),
	(2727,271,'新津县',3,'',NULL),
	(2728,271,'都江堰市',3,'',NULL),
	(2729,271,'彭州市',3,'',NULL),
	(2730,271,'邛崃市',3,'',NULL),
	(2731,271,'崇州市',3,'',NULL),
	(2732,271,'其它区',3,'',NULL),
	(2733,272,'自流井区',3,'',NULL),
	(2734,272,'贡井区',3,'',NULL),
	(2735,272,'大安区',3,'',NULL),
	(2736,272,'沿滩区',3,'',NULL),
	(2737,272,'荣县',3,'',NULL),
	(2738,272,'富顺县',3,'',NULL),
	(2739,272,'其它区',3,'',NULL),
	(2740,273,'东区',3,'',NULL),
	(2741,273,'西区',3,'',NULL),
	(2742,273,'仁和区',3,'',NULL),
	(2743,273,'米易县',3,'',NULL),
	(2744,273,'盐边县',3,'',NULL),
	(2745,273,'其它区',3,'',NULL),
	(2746,274,'江阳区',3,'',NULL),
	(2747,274,'纳溪区',3,'',NULL),
	(2748,274,'龙马潭区',3,'',NULL),
	(2749,274,'泸县',3,'',NULL),
	(2750,274,'合江县',3,'',NULL),
	(2751,274,'叙永县',3,'',NULL),
	(2752,274,'古蔺县',3,'',NULL),
	(2753,274,'其它区',3,'',NULL),
	(2754,275,'旌阳区',3,'',NULL),
	(2755,275,'中江县',3,'',NULL),
	(2756,275,'罗江县',3,'',NULL),
	(2757,275,'广汉市',3,'',NULL),
	(2758,275,'什邡市',3,'',NULL),
	(2759,275,'绵竹市',3,'',NULL),
	(2760,275,'其它区',3,'',NULL),
	(2761,276,'涪城区',3,'',NULL),
	(2762,276,'游仙区',3,'',NULL),
	(2763,276,'三台县',3,'',NULL),
	(2764,276,'盐亭县',3,'',NULL),
	(2765,276,'安县',3,'',NULL),
	(2766,276,'梓潼县',3,'',NULL),
	(2767,276,'北川羌族自治县',3,'',NULL),
	(2768,276,'平武县',3,'',NULL),
	(2769,276,'高新区',3,'',NULL),
	(2770,276,'江油市',3,'',NULL),
	(2771,276,'其它区',3,'',NULL),
	(2772,277,'利州区',3,'',NULL),
	(2773,277,'昭化区',3,'',NULL),
	(2774,277,'朝天区',3,'',NULL),
	(2775,277,'旺苍县',3,'',NULL),
	(2776,277,'青川县',3,'',NULL),
	(2777,277,'剑阁县',3,'',NULL),
	(2778,277,'苍溪县',3,'',NULL),
	(2779,277,'其它区',3,'',NULL),
	(2780,278,'船山区',3,'',NULL),
	(2781,278,'安居区',3,'',NULL),
	(2782,278,'蓬溪县',3,'',NULL),
	(2783,278,'射洪县',3,'',NULL),
	(2784,278,'大英县',3,'',NULL),
	(2785,278,'其它区',3,'',NULL),
	(2786,279,'市中区',3,'',NULL),
	(2787,279,'东兴区',3,'',NULL),
	(2788,279,'威远县',3,'',NULL),
	(2789,279,'资中县',3,'',NULL),
	(2790,279,'隆昌县',3,'',NULL),
	(2791,279,'其它区',3,'',NULL),
	(2792,280,'市中区',3,'',NULL),
	(2793,280,'沙湾区',3,'',NULL),
	(2794,280,'五通桥区',3,'',NULL),
	(2795,280,'金口河区',3,'',NULL),
	(2796,280,'犍为县',3,'',NULL),
	(2797,280,'井研县',3,'',NULL),
	(2798,280,'夹江县',3,'',NULL),
	(2799,280,'沐川县',3,'',NULL),
	(2800,280,'峨边彝族自治县',3,'',NULL),
	(2801,280,'马边彝族自治县',3,'',NULL),
	(2802,280,'峨眉山市',3,'',NULL),
	(2803,280,'其它区',3,'',NULL),
	(2804,281,'顺庆区',3,'',NULL),
	(2805,281,'高坪区',3,'',NULL),
	(2806,281,'嘉陵区',3,'',NULL),
	(2807,281,'南部县',3,'',NULL),
	(2808,281,'营山县',3,'',NULL),
	(2809,281,'蓬安县',3,'',NULL),
	(2810,281,'仪陇县',3,'',NULL),
	(2811,281,'西充县',3,'',NULL),
	(2812,281,'阆中市',3,'',NULL),
	(2813,281,'其它区',3,'',NULL),
	(2814,282,'东坡区',3,'',NULL),
	(2815,282,'仁寿县',3,'',NULL),
	(2816,282,'彭山区',3,'',NULL),
	(2817,282,'洪雅县',3,'',NULL),
	(2818,282,'丹棱县',3,'',NULL),
	(2819,282,'青神县',3,'',NULL),
	(2820,282,'其它区',3,'',NULL),
	(2821,283,'翠屏区',3,'',NULL),
	(2822,283,'宜宾县',3,'',NULL),
	(2823,283,'南溪区',3,'',NULL),
	(2824,283,'江安县',3,'',NULL),
	(2825,283,'长宁县',3,'',NULL),
	(2826,283,'高县',3,'',NULL),
	(2827,283,'珙县',3,'',NULL),
	(2828,283,'筠连县',3,'',NULL),
	(2829,283,'兴文县',3,'',NULL),
	(2830,283,'屏山县',3,'',NULL),
	(2831,283,'其它区',3,'',NULL),
	(2832,284,'广安区',3,'',NULL),
	(2833,284,'前锋区',3,'',NULL),
	(2834,284,'岳池县',3,'',NULL),
	(2835,284,'武胜县',3,'',NULL),
	(2836,284,'邻水县',3,'',NULL),
	(2837,284,'华蓥市',3,'',NULL),
	(2838,284,'市辖区',3,'',NULL),
	(2839,284,'其它区',3,'',NULL),
	(2840,285,'通川区',3,'',NULL),
	(2841,285,'达川区',3,'',NULL),
	(2842,285,'宣汉县',3,'',NULL),
	(2843,285,'开江县',3,'',NULL),
	(2844,285,'大竹县',3,'',NULL),
	(2845,285,'渠县',3,'',NULL),
	(2846,285,'万源市',3,'',NULL),
	(2847,285,'其它区',3,'',NULL),
	(2848,286,'雨城区',3,'',NULL),
	(2849,286,'名山区',3,'',NULL),
	(2850,286,'荥经县',3,'',NULL),
	(2851,286,'汉源县',3,'',NULL),
	(2852,286,'石棉县',3,'',NULL),
	(2853,286,'天全县',3,'',NULL),
	(2854,286,'芦山县',3,'',NULL),
	(2855,286,'宝兴县',3,'',NULL),
	(2856,286,'其它区',3,'',NULL),
	(2857,287,'巴州区',3,'',NULL),
	(2858,287,'恩阳区',3,'',NULL),
	(2859,287,'通江县',3,'',NULL),
	(2860,287,'南江县',3,'',NULL),
	(2861,287,'平昌县',3,'',NULL),
	(2862,287,'其它区',3,'',NULL),
	(2863,288,'雁江区',3,'',NULL),
	(2864,288,'安岳县',3,'',NULL),
	(2865,288,'乐至县',3,'',NULL),
	(2866,288,'简阳市',3,'',NULL),
	(2867,288,'其它区',3,'',NULL),
	(2868,289,'汶川县',3,'',NULL),
	(2869,289,'理县',3,'',NULL),
	(2870,289,'茂县',3,'',NULL),
	(2871,289,'松潘县',3,'',NULL),
	(2872,289,'九寨沟县',3,'',NULL),
	(2873,289,'金川县',3,'',NULL),
	(2874,289,'小金县',3,'',NULL),
	(2875,289,'黑水县',3,'',NULL),
	(2876,289,'马尔康县',3,'',NULL),
	(2877,289,'壤塘县',3,'',NULL),
	(2878,289,'阿坝县',3,'',NULL),
	(2879,289,'若尔盖县',3,'',NULL),
	(2880,289,'红原县',3,'',NULL),
	(2881,289,'其它区',3,'',NULL),
	(2882,290,'康定市',3,'',NULL),
	(2883,290,'泸定县',3,'',NULL),
	(2884,290,'丹巴县',3,'',NULL),
	(2885,290,'九龙县',3,'',NULL),
	(2886,290,'雅江县',3,'',NULL),
	(2887,290,'道孚县',3,'',NULL),
	(2888,290,'炉霍县',3,'',NULL),
	(2889,290,'甘孜县',3,'',NULL),
	(2890,290,'新龙县',3,'',NULL),
	(2891,290,'德格县',3,'',NULL),
	(2892,290,'白玉县',3,'',NULL),
	(2893,290,'石渠县',3,'',NULL),
	(2894,290,'色达县',3,'',NULL),
	(2895,290,'理塘县',3,'',NULL),
	(2896,290,'巴塘县',3,'',NULL),
	(2897,290,'乡城县',3,'',NULL),
	(2898,290,'稻城县',3,'',NULL),
	(2899,290,'得荣县',3,'',NULL),
	(2900,290,'其它区',3,'',NULL),
	(2901,291,'西昌市',3,'',NULL),
	(2902,291,'木里藏族自治县',3,'',NULL),
	(2903,291,'盐源县',3,'',NULL),
	(2904,291,'德昌县',3,'',NULL),
	(2905,291,'会理县',3,'',NULL),
	(2906,291,'会东县',3,'',NULL),
	(2907,291,'宁南县',3,'',NULL),
	(2908,291,'普格县',3,'',NULL),
	(2909,291,'布拖县',3,'',NULL),
	(2910,291,'金阳县',3,'',NULL),
	(2911,291,'昭觉县',3,'',NULL),
	(2912,291,'喜德县',3,'',NULL),
	(2913,291,'冕宁县',3,'',NULL),
	(2914,291,'越西县',3,'',NULL),
	(2915,291,'甘洛县',3,'',NULL),
	(2916,291,'美姑县',3,'',NULL),
	(2917,291,'雷波县',3,'',NULL),
	(2918,291,'其它区',3,'',NULL),
	(2919,292,'南明区',3,'',NULL),
	(2920,292,'云岩区',3,'',NULL),
	(2921,292,'花溪区',3,'',NULL),
	(2922,292,'乌当区',3,'',NULL),
	(2923,292,'白云区',3,'',NULL),
	(2924,292,'小河区',3,'',NULL),
	(2925,292,'开阳县',3,'',NULL),
	(2926,292,'息烽县',3,'',NULL),
	(2927,292,'修文县',3,'',NULL),
	(2928,292,'观山湖区',3,'',NULL),
	(2929,292,'清镇市',3,'',NULL),
	(2930,292,'其它区',3,'',NULL),
	(2931,293,'钟山区',3,'',NULL),
	(2932,293,'六枝特区',3,'',NULL),
	(2933,293,'水城县',3,'',NULL),
	(2934,293,'盘县',3,'',NULL),
	(2935,293,'其它区',3,'',NULL),
	(2936,294,'红花岗区',3,'',NULL),
	(2937,294,'汇川区',3,'',NULL),
	(2938,294,'遵义县',3,'',NULL),
	(2939,294,'桐梓县',3,'',NULL),
	(2940,294,'绥阳县',3,'',NULL),
	(2941,294,'正安县',3,'',NULL),
	(2942,294,'道真仡佬族苗族自治县',3,'',NULL),
	(2943,294,'务川仡佬族苗族自治县',3,'',NULL),
	(2944,294,'凤冈县',3,'',NULL),
	(2945,294,'湄潭县',3,'',NULL),
	(2946,294,'余庆县',3,'',NULL),
	(2947,294,'习水县',3,'',NULL),
	(2948,294,'赤水市',3,'',NULL),
	(2949,294,'仁怀市',3,'',NULL),
	(2950,294,'其它区',3,'',NULL),
	(2951,295,'西秀区',3,'',NULL),
	(2952,295,'平坝区',3,'',NULL),
	(2953,295,'普定县',3,'',NULL),
	(2954,295,'镇宁布依族苗族自治县',3,'',NULL),
	(2955,295,'关岭布依族苗族自治县',3,'',NULL),
	(2956,295,'紫云苗族布依族自治县',3,'',NULL),
	(2957,295,'其它区',3,'',NULL),
	(2958,296,'碧江区',3,'',NULL),
	(2959,296,'江口县',3,'',NULL),
	(2960,296,'玉屏侗族自治县',3,'',NULL),
	(2961,296,'石阡县',3,'',NULL),
	(2962,296,'思南县',3,'',NULL),
	(2963,296,'印江土家族苗族自治县',3,'',NULL),
	(2964,296,'德江县',3,'',NULL),
	(2965,296,'沿河土家族自治县',3,'',NULL),
	(2966,296,'松桃苗族自治县',3,'',NULL),
	(2967,296,'万山区',3,'',NULL),
	(2968,296,'其它区',3,'',NULL),
	(2969,297,'兴义市',3,'',NULL),
	(2970,297,'兴仁县',3,'',NULL),
	(2971,297,'普安县',3,'',NULL),
	(2972,297,'晴隆县',3,'',NULL),
	(2973,297,'贞丰县',3,'',NULL),
	(2974,297,'望谟县',3,'',NULL),
	(2975,297,'册亨县',3,'',NULL),
	(2976,297,'安龙县',3,'',NULL),
	(2977,297,'其它区',3,'',NULL),
	(2978,298,'七星关区',3,'',NULL),
	(2979,298,'大方县',3,'',NULL),
	(2980,298,'黔西县',3,'',NULL),
	(2981,298,'金沙县',3,'',NULL),
	(2982,298,'织金县',3,'',NULL),
	(2983,298,'纳雍县',3,'',NULL),
	(2984,298,'威宁彝族回族苗族自治县',3,'',NULL),
	(2985,298,'赫章县',3,'',NULL),
	(2986,298,'其它区',3,'',NULL),
	(2987,299,'凯里市',3,'',NULL),
	(2988,299,'黄平县',3,'',NULL),
	(2989,299,'施秉县',3,'',NULL),
	(2990,299,'三穗县',3,'',NULL),
	(2991,299,'镇远县',3,'',NULL),
	(2992,299,'岑巩县',3,'',NULL),
	(2993,299,'天柱县',3,'',NULL),
	(2994,299,'锦屏县',3,'',NULL),
	(2995,299,'剑河县',3,'',NULL),
	(2996,299,'台江县',3,'',NULL),
	(2997,299,'黎平县',3,'',NULL),
	(2998,299,'榕江县',3,'',NULL),
	(2999,299,'从江县',3,'',NULL),
	(3000,299,'雷山县',3,'',NULL),
	(3001,299,'麻江县',3,'',NULL),
	(3002,299,'丹寨县',3,'',NULL),
	(3003,299,'其它区',3,'',NULL),
	(3004,300,'都匀市',3,'',NULL),
	(3005,300,'福泉市',3,'',NULL),
	(3006,300,'荔波县',3,'',NULL),
	(3007,300,'贵定县',3,'',NULL),
	(3008,300,'瓮安县',3,'',NULL),
	(3009,300,'独山县',3,'',NULL),
	(3010,300,'平塘县',3,'',NULL),
	(3011,300,'罗甸县',3,'',NULL),
	(3012,300,'长顺县',3,'',NULL),
	(3013,300,'龙里县',3,'',NULL),
	(3014,300,'惠水县',3,'',NULL),
	(3015,300,'三都水族自治县',3,'',NULL),
	(3016,300,'其它区',3,'',NULL),
	(3017,301,'五华区',3,'',NULL),
	(3018,301,'盘龙区',3,'',NULL),
	(3019,301,'官渡区',3,'',NULL),
	(3020,301,'西山区',3,'',NULL),
	(3021,301,'东川区',3,'',NULL),
	(3022,301,'呈贡区',3,'',NULL),
	(3023,301,'晋宁县',3,'',NULL),
	(3024,301,'富民县',3,'',NULL),
	(3025,301,'宜良县',3,'',NULL),
	(3026,301,'石林彝族自治县',3,'',NULL),
	(3027,301,'嵩明县',3,'',NULL),
	(3028,301,'禄劝彝族苗族自治县',3,'',NULL),
	(3029,301,'寻甸回族彝族自治县',3,'',NULL),
	(3030,301,'安宁市',3,'',NULL),
	(3031,301,'其它区',3,'',NULL),
	(3032,302,'麒麟区',3,'',NULL),
	(3033,302,'马龙县',3,'',NULL),
	(3034,302,'陆良县',3,'',NULL),
	(3035,302,'师宗县',3,'',NULL),
	(3036,302,'罗平县',3,'',NULL),
	(3037,302,'富源县',3,'',NULL),
	(3038,302,'会泽县',3,'',NULL),
	(3039,302,'沾益县',3,'',NULL),
	(3040,302,'宣威市',3,'',NULL),
	(3041,302,'其它区',3,'',NULL),
	(3042,303,'红塔区',3,'',NULL),
	(3043,303,'江川县',3,'',NULL),
	(3044,303,'澄江县',3,'',NULL),
	(3045,303,'通海县',3,'',NULL),
	(3046,303,'华宁县',3,'',NULL),
	(3047,303,'易门县',3,'',NULL),
	(3048,303,'峨山彝族自治县',3,'',NULL),
	(3049,303,'新平彝族傣族自治县',3,'',NULL),
	(3050,303,'元江哈尼族彝族傣族自治县',3,'',NULL),
	(3051,303,'其它区',3,'',NULL),
	(3052,304,'隆阳区',3,'',NULL),
	(3053,304,'施甸县',3,'',NULL),
	(3054,304,'腾冲县',3,'',NULL),
	(3055,304,'龙陵县',3,'',NULL),
	(3056,304,'昌宁县',3,'',NULL),
	(3057,304,'其它区',3,'',NULL),
	(3058,305,'昭阳区',3,'',NULL),
	(3059,305,'鲁甸县',3,'',NULL),
	(3060,305,'巧家县',3,'',NULL),
	(3061,305,'盐津县',3,'',NULL),
	(3062,305,'大关县',3,'',NULL),
	(3063,305,'永善县',3,'',NULL),
	(3064,305,'绥江县',3,'',NULL),
	(3065,305,'镇雄县',3,'',NULL),
	(3066,305,'彝良县',3,'',NULL),
	(3067,305,'威信县',3,'',NULL),
	(3068,305,'水富县',3,'',NULL),
	(3069,305,'其它区',3,'',NULL),
	(3070,306,'古城区',3,'',NULL),
	(3071,306,'玉龙纳西族自治县',3,'',NULL),
	(3072,306,'永胜县',3,'',NULL),
	(3073,306,'华坪县',3,'',NULL),
	(3074,306,'宁蒗彝族自治县',3,'',NULL),
	(3075,306,'其它区',3,'',NULL),
	(3076,307,'思茅区',3,'',NULL),
	(3077,307,'宁洱哈尼族彝族自治县',3,'',NULL),
	(3078,307,'墨江哈尼族自治县',3,'',NULL),
	(3079,307,'景东彝族自治县',3,'',NULL),
	(3080,307,'景谷傣族彝族自治县',3,'',NULL),
	(3081,307,'镇沅彝族哈尼族拉祜族自治县',3,'',NULL),
	(3082,307,'江城哈尼族彝族自治县',3,'',NULL),
	(3083,307,'孟连傣族拉祜族佤族自治县',3,'',NULL),
	(3084,307,'澜沧拉祜族自治县',3,'',NULL),
	(3085,307,'西盟佤族自治县',3,'',NULL),
	(3086,307,'其它区',3,'',NULL),
	(3087,308,'临翔区',3,'',NULL),
	(3088,308,'凤庆县',3,'',NULL),
	(3089,308,'云县',3,'',NULL),
	(3090,308,'永德县',3,'',NULL),
	(3091,308,'镇康县',3,'',NULL),
	(3092,308,'双江拉祜族佤族布朗族傣族自治县',3,'',NULL),
	(3093,308,'耿马傣族佤族自治县',3,'',NULL),
	(3094,308,'沧源佤族自治县',3,'',NULL),
	(3095,308,'其它区',3,'',NULL),
	(3096,309,'楚雄市',3,'',NULL),
	(3097,309,'双柏县',3,'',NULL),
	(3098,309,'牟定县',3,'',NULL),
	(3099,309,'南华县',3,'',NULL),
	(3100,309,'姚安县',3,'',NULL),
	(3101,309,'大姚县',3,'',NULL),
	(3102,309,'永仁县',3,'',NULL),
	(3103,309,'元谋县',3,'',NULL),
	(3104,309,'武定县',3,'',NULL),
	(3105,309,'禄丰县',3,'',NULL),
	(3106,309,'其它区',3,'',NULL),
	(3107,310,'个旧市',3,'',NULL),
	(3108,310,'开远市',3,'',NULL),
	(3109,310,'蒙自市',3,'',NULL),
	(3110,310,'屏边苗族自治县',3,'',NULL),
	(3111,310,'建水县',3,'',NULL),
	(3112,310,'石屏县',3,'',NULL),
	(3113,310,'弥勒市',3,'',NULL),
	(3114,310,'泸西县',3,'',NULL),
	(3115,310,'元阳县',3,'',NULL),
	(3116,310,'红河县',3,'',NULL),
	(3117,310,'金平苗族瑶族傣族自治县',3,'',NULL),
	(3118,310,'绿春县',3,'',NULL),
	(3119,310,'河口瑶族自治县',3,'',NULL),
	(3120,310,'其它区',3,'',NULL),
	(3121,311,'文山市',3,'',NULL),
	(3122,311,'砚山县',3,'',NULL),
	(3123,311,'西畴县',3,'',NULL),
	(3124,311,'麻栗坡县',3,'',NULL),
	(3125,311,'马关县',3,'',NULL),
	(3126,311,'丘北县',3,'',NULL),
	(3127,311,'广南县',3,'',NULL),
	(3128,311,'富宁县',3,'',NULL),
	(3129,311,'其它区',3,'',NULL),
	(3130,312,'景洪市',3,'',NULL),
	(3131,312,'勐海县',3,'',NULL),
	(3132,312,'勐腊县',3,'',NULL),
	(3133,312,'其它区',3,'',NULL),
	(3134,313,'大理市',3,'',NULL),
	(3135,313,'漾濞彝族自治县',3,'',NULL),
	(3136,313,'祥云县',3,'',NULL),
	(3137,313,'宾川县',3,'',NULL),
	(3138,313,'弥渡县',3,'',NULL),
	(3139,313,'南涧彝族自治县',3,'',NULL),
	(3140,313,'巍山彝族回族自治县',3,'',NULL),
	(3141,313,'永平县',3,'',NULL),
	(3142,313,'云龙县',3,'',NULL),
	(3143,313,'洱源县',3,'',NULL),
	(3144,313,'剑川县',3,'',NULL),
	(3145,313,'鹤庆县',3,'',NULL),
	(3146,313,'其它区',3,'',NULL),
	(3147,314,'瑞丽市',3,'',NULL),
	(3148,314,'芒市',3,'',NULL),
	(3149,314,'梁河县',3,'',NULL),
	(3150,314,'盈江县',3,'',NULL),
	(3151,314,'陇川县',3,'',NULL),
	(3152,314,'其它区',3,'',NULL),
	(3153,315,'泸水县',3,'',NULL),
	(3154,315,'福贡县',3,'',NULL),
	(3155,315,'贡山独龙族怒族自治县',3,'',NULL),
	(3156,315,'兰坪白族普米族自治县',3,'',NULL),
	(3157,315,'其它区',3,'',NULL),
	(3158,316,'香格里拉市',3,'',NULL),
	(3159,316,'德钦县',3,'',NULL),
	(3160,316,'维西傈僳族自治县',3,'',NULL),
	(3161,316,'其它区',3,'',NULL),
	(3162,317,'城关区',3,'',NULL),
	(3163,317,'林周县',3,'',NULL),
	(3164,317,'当雄县',3,'',NULL),
	(3165,317,'尼木县',3,'',NULL),
	(3166,317,'曲水县',3,'',NULL),
	(3167,317,'堆龙德庆县',3,'',NULL),
	(3168,317,'达孜县',3,'',NULL),
	(3169,317,'墨竹工卡县',3,'',NULL),
	(3170,317,'其它区',3,'',NULL),
	(3171,318,'卡若区',3,'',NULL),
	(3172,318,'江达县',3,'',NULL),
	(3173,318,'贡觉县',3,'',NULL),
	(3174,318,'类乌齐县',3,'',NULL),
	(3175,318,'丁青县',3,'',NULL),
	(3176,318,'察雅县',3,'',NULL),
	(3177,318,'八宿县',3,'',NULL),
	(3178,318,'左贡县',3,'',NULL),
	(3179,318,'芒康县',3,'',NULL),
	(3180,318,'洛隆县',3,'',NULL),
	(3181,318,'边坝县',3,'',NULL),
	(3182,318,'其它区',3,'',NULL),
	(3183,319,'乃东县',3,'',NULL),
	(3184,319,'扎囊县',3,'',NULL),
	(3185,319,'贡嘎县',3,'',NULL),
	(3186,319,'桑日县',3,'',NULL),
	(3187,319,'琼结县',3,'',NULL),
	(3188,319,'曲松县',3,'',NULL),
	(3189,319,'措美县',3,'',NULL),
	(3190,319,'洛扎县',3,'',NULL),
	(3191,319,'加查县',3,'',NULL),
	(3192,319,'隆子县',3,'',NULL),
	(3193,319,'错那县',3,'',NULL),
	(3194,319,'浪卡子县',3,'',NULL),
	(3195,319,'其它区',3,'',NULL),
	(3196,320,'桑珠孜区',3,'',NULL),
	(3197,320,'南木林县',3,'',NULL),
	(3198,320,'江孜县',3,'',NULL),
	(3199,320,'定日县',3,'',NULL),
	(3200,320,'萨迦县',3,'',NULL),
	(3201,320,'拉孜县',3,'',NULL),
	(3202,320,'昂仁县',3,'',NULL),
	(3203,320,'谢通门县',3,'',NULL),
	(3204,320,'白朗县',3,'',NULL),
	(3205,320,'仁布县',3,'',NULL),
	(3206,320,'康马县',3,'',NULL),
	(3207,320,'定结县',3,'',NULL),
	(3208,320,'仲巴县',3,'',NULL),
	(3209,320,'亚东县',3,'',NULL),
	(3210,320,'吉隆县',3,'',NULL),
	(3211,320,'聂拉木县',3,'',NULL),
	(3212,320,'萨嘎县',3,'',NULL),
	(3213,320,'岗巴县',3,'',NULL),
	(3214,320,'其它区',3,'',NULL),
	(3215,321,'那曲县',3,'',NULL),
	(3216,321,'嘉黎县',3,'',NULL),
	(3217,321,'比如县',3,'',NULL),
	(3218,321,'聂荣县',3,'',NULL),
	(3219,321,'安多县',3,'',NULL),
	(3220,321,'申扎县',3,'',NULL),
	(3221,321,'索县',3,'',NULL),
	(3222,321,'班戈县',3,'',NULL),
	(3223,321,'巴青县',3,'',NULL),
	(3224,321,'尼玛县',3,'',NULL),
	(3225,321,'其它区',3,'',NULL),
	(3226,321,'双湖县',3,'',NULL),
	(3227,322,'普兰县',3,'',NULL),
	(3228,322,'札达县',3,'',NULL),
	(3229,322,'噶尔县',3,'',NULL),
	(3230,322,'日土县',3,'',NULL),
	(3231,322,'革吉县',3,'',NULL),
	(3232,322,'改则县',3,'',NULL),
	(3233,322,'措勤县',3,'',NULL),
	(3234,322,'其它区',3,'',NULL),
	(3235,323,'巴宜区',3,'',NULL),
	(3236,323,'工布江达县',3,'',NULL),
	(3237,323,'米林县',3,'',NULL),
	(3238,323,'墨脱县',3,'',NULL),
	(3239,323,'波密县',3,'',NULL),
	(3240,323,'察隅县',3,'',NULL),
	(3241,323,'朗县',3,'',NULL),
	(3242,323,'其它区',3,'',NULL),
	(3243,324,'新城区',3,'',NULL),
	(3244,324,'碑林区',3,'',NULL),
	(3245,324,'莲湖区',3,'',NULL),
	(3246,324,'灞桥区',3,'',NULL),
	(3247,324,'未央区',3,'',NULL),
	(3248,324,'雁塔区',3,'',NULL),
	(3249,324,'阎良区',3,'',NULL),
	(3250,324,'临潼区',3,'',NULL),
	(3251,324,'长安区',3,'',NULL),
	(3252,324,'蓝田县',3,'',NULL),
	(3253,324,'周至县',3,'',NULL),
	(3254,324,'户县',3,'',NULL),
	(3255,324,'高陵区',3,'',NULL),
	(3256,324,'其它区',3,'',NULL),
	(3257,325,'王益区',3,'',NULL),
	(3258,325,'印台区',3,'',NULL),
	(3259,325,'耀州区',3,'',NULL),
	(3260,325,'宜君县',3,'',NULL),
	(3261,325,'其它区',3,'',NULL),
	(3262,326,'渭滨区',3,'',NULL),
	(3263,326,'金台区',3,'',NULL),
	(3264,326,'陈仓区',3,'',NULL),
	(3265,326,'凤翔县',3,'',NULL),
	(3266,326,'岐山县',3,'',NULL),
	(3267,326,'扶风县',3,'',NULL),
	(3268,326,'眉县',3,'',NULL),
	(3269,326,'陇县',3,'',NULL),
	(3270,326,'千阳县',3,'',NULL),
	(3271,326,'麟游县',3,'',NULL),
	(3272,326,'凤县',3,'',NULL),
	(3273,326,'太白县',3,'',NULL),
	(3274,326,'其它区',3,'',NULL),
	(3275,327,'秦都区',3,'',NULL),
	(3276,327,'杨陵区',3,'',NULL),
	(3277,327,'渭城区',3,'',NULL),
	(3278,327,'三原县',3,'',NULL),
	(3279,327,'泾阳县',3,'',NULL),
	(3280,327,'乾县',3,'',NULL),
	(3281,327,'礼泉县',3,'',NULL),
	(3282,327,'永寿县',3,'',NULL),
	(3283,327,'彬县',3,'',NULL),
	(3284,327,'长武县',3,'',NULL),
	(3285,327,'旬邑县',3,'',NULL),
	(3286,327,'淳化县',3,'',NULL),
	(3287,327,'武功县',3,'',NULL),
	(3288,327,'兴平市',3,'',NULL),
	(3289,327,'其它区',3,'',NULL),
	(3290,328,'临渭区',3,'',NULL),
	(3291,328,'华县',3,'',NULL),
	(3292,328,'潼关县',3,'',NULL),
	(3293,328,'大荔县',3,'',NULL),
	(3294,328,'合阳县',3,'',NULL),
	(3295,328,'澄城县',3,'',NULL),
	(3296,328,'蒲城县',3,'',NULL),
	(3297,328,'白水县',3,'',NULL),
	(3298,328,'富平县',3,'',NULL),
	(3299,328,'韩城市',3,'',NULL),
	(3300,328,'华阴市',3,'',NULL),
	(3301,328,'其它区',3,'',NULL),
	(3302,329,'宝塔区',3,'',NULL),
	(3303,329,'延长县',3,'',NULL),
	(3304,329,'延川县',3,'',NULL),
	(3305,329,'子长县',3,'',NULL),
	(3306,329,'安塞县',3,'',NULL),
	(3307,329,'志丹县',3,'',NULL),
	(3308,329,'吴起县',3,'',NULL),
	(3309,329,'甘泉县',3,'',NULL),
	(3310,329,'富县',3,'',NULL),
	(3311,329,'洛川县',3,'',NULL),
	(3312,329,'宜川县',3,'',NULL),
	(3313,329,'黄龙县',3,'',NULL),
	(3314,329,'黄陵县',3,'',NULL),
	(3315,329,'其它区',3,'',NULL),
	(3316,330,'汉台区',3,'',NULL),
	(3317,330,'南郑县',3,'',NULL),
	(3318,330,'城固县',3,'',NULL),
	(3319,330,'洋县',3,'',NULL),
	(3320,330,'西乡县',3,'',NULL),
	(3321,330,'勉县',3,'',NULL),
	(3322,330,'宁强县',3,'',NULL),
	(3323,330,'略阳县',3,'',NULL),
	(3324,330,'镇巴县',3,'',NULL),
	(3325,330,'留坝县',3,'',NULL),
	(3326,330,'佛坪县',3,'',NULL),
	(3327,330,'其它区',3,'',NULL),
	(3328,331,'榆阳区',3,'',NULL),
	(3329,331,'神木县',3,'',NULL),
	(3330,331,'府谷县',3,'',NULL),
	(3331,331,'横山县',3,'',NULL),
	(3332,331,'靖边县',3,'',NULL),
	(3333,331,'定边县',3,'',NULL),
	(3334,331,'绥德县',3,'',NULL),
	(3335,331,'米脂县',3,'',NULL),
	(3336,331,'佳县',3,'',NULL),
	(3337,331,'吴堡县',3,'',NULL),
	(3338,331,'清涧县',3,'',NULL),
	(3339,331,'子洲县',3,'',NULL),
	(3340,331,'其它区',3,'',NULL),
	(3341,332,'汉滨区',3,'',NULL),
	(3342,332,'汉阴县',3,'',NULL),
	(3343,332,'石泉县',3,'',NULL),
	(3344,332,'宁陕县',3,'',NULL),
	(3345,332,'紫阳县',3,'',NULL),
	(3346,332,'岚皋县',3,'',NULL),
	(3347,332,'平利县',3,'',NULL),
	(3348,332,'镇坪县',3,'',NULL),
	(3349,332,'旬阳县',3,'',NULL),
	(3350,332,'白河县',3,'',NULL),
	(3351,332,'其它区',3,'',NULL),
	(3352,333,'商州区',3,'',NULL),
	(3353,333,'洛南县',3,'',NULL),
	(3354,333,'丹凤县',3,'',NULL),
	(3355,333,'商南县',3,'',NULL),
	(3356,333,'山阳县',3,'',NULL),
	(3357,333,'镇安县',3,'',NULL),
	(3358,333,'柞水县',3,'',NULL),
	(3359,333,'其它区',3,'',NULL),
	(3360,334,'城关区',3,'',NULL),
	(3361,334,'七里河区',3,'',NULL),
	(3362,334,'西固区',3,'',NULL),
	(3363,334,'安宁区',3,'',NULL),
	(3364,334,'红古区',3,'',NULL),
	(3365,334,'永登县',3,'',NULL),
	(3366,334,'皋兰县',3,'',NULL),
	(3367,334,'榆中县',3,'',NULL),
	(3368,334,'其它区',3,'',NULL),
	(3369,336,'金川区',3,'',NULL),
	(3370,336,'永昌县',3,'',NULL),
	(3371,336,'其它区',3,'',NULL),
	(3372,337,'白银区',3,'',NULL),
	(3373,337,'平川区',3,'',NULL),
	(3374,337,'靖远县',3,'',NULL),
	(3375,337,'会宁县',3,'',NULL),
	(3376,337,'景泰县',3,'',NULL),
	(3377,337,'其它区',3,'',NULL),
	(3378,338,'秦州区',3,'',NULL),
	(3379,338,'麦积区',3,'',NULL),
	(3380,338,'清水县',3,'',NULL),
	(3381,338,'秦安县',3,'',NULL),
	(3382,338,'甘谷县',3,'',NULL),
	(3383,338,'武山县',3,'',NULL),
	(3384,338,'张家川回族自治县',3,'',NULL),
	(3385,338,'其它区',3,'',NULL),
	(3386,339,'凉州区',3,'',NULL),
	(3387,339,'民勤县',3,'',NULL),
	(3388,339,'古浪县',3,'',NULL),
	(3389,339,'天祝藏族自治县',3,'',NULL),
	(3390,339,'其它区',3,'',NULL),
	(3391,340,'甘州区',3,'',NULL),
	(3392,340,'肃南裕固族自治县',3,'',NULL),
	(3393,340,'民乐县',3,'',NULL),
	(3394,340,'临泽县',3,'',NULL),
	(3395,340,'高台县',3,'',NULL),
	(3396,340,'山丹县',3,'',NULL),
	(3397,340,'其它区',3,'',NULL),
	(3398,341,'崆峒区',3,'',NULL),
	(3399,341,'泾川县',3,'',NULL),
	(3400,341,'灵台县',3,'',NULL),
	(3401,341,'崇信县',3,'',NULL),
	(3402,341,'华亭县',3,'',NULL),
	(3403,341,'庄浪县',3,'',NULL),
	(3404,341,'静宁县',3,'',NULL),
	(3405,341,'其它区',3,'',NULL),
	(3406,342,'肃州区',3,'',NULL),
	(3407,342,'金塔县',3,'',NULL),
	(3408,342,'瓜州县',3,'',NULL),
	(3409,342,'肃北蒙古族自治县',3,'',NULL),
	(3410,342,'阿克塞哈萨克族自治县',3,'',NULL),
	(3411,342,'玉门市',3,'',NULL),
	(3412,342,'敦煌市',3,'',NULL),
	(3413,342,'其它区',3,'',NULL),
	(3414,343,'西峰区',3,'',NULL),
	(3415,343,'庆城县',3,'',NULL),
	(3416,343,'环县',3,'',NULL),
	(3417,343,'华池县',3,'',NULL),
	(3418,343,'合水县',3,'',NULL),
	(3419,343,'正宁县',3,'',NULL),
	(3420,343,'宁县',3,'',NULL),
	(3421,343,'镇原县',3,'',NULL),
	(3422,343,'其它区',3,'',NULL),
	(3423,344,'安定区',3,'',NULL),
	(3424,344,'通渭县',3,'',NULL),
	(3425,344,'陇西县',3,'',NULL),
	(3426,344,'渭源县',3,'',NULL),
	(3427,344,'临洮县',3,'',NULL),
	(3428,344,'漳县',3,'',NULL),
	(3429,344,'岷县',3,'',NULL),
	(3430,344,'其它区',3,'',NULL),
	(3431,345,'武都区',3,'',NULL),
	(3432,345,'成县',3,'',NULL),
	(3433,345,'文县',3,'',NULL),
	(3434,345,'宕昌县',3,'',NULL),
	(3435,345,'康县',3,'',NULL),
	(3436,345,'西和县',3,'',NULL),
	(3437,345,'礼县',3,'',NULL),
	(3438,345,'徽县',3,'',NULL),
	(3439,345,'两当县',3,'',NULL),
	(3440,345,'其它区',3,'',NULL),
	(3441,346,'临夏市',3,'',NULL),
	(3442,346,'临夏县',3,'',NULL),
	(3443,346,'康乐县',3,'',NULL),
	(3444,346,'永靖县',3,'',NULL),
	(3445,346,'广河县',3,'',NULL),
	(3446,346,'和政县',3,'',NULL),
	(3447,346,'东乡族自治县',3,'',NULL),
	(3448,346,'积石山保安族东乡族撒拉族自治县',3,'',NULL),
	(3449,346,'其它区',3,'',NULL),
	(3450,347,'合作市',3,'',NULL),
	(3451,347,'临潭县',3,'',NULL),
	(3452,347,'卓尼县',3,'',NULL),
	(3453,347,'舟曲县',3,'',NULL),
	(3454,347,'迭部县',3,'',NULL),
	(3455,347,'玛曲县',3,'',NULL),
	(3456,347,'碌曲县',3,'',NULL),
	(3457,347,'夏河县',3,'',NULL),
	(3458,347,'其它区',3,'',NULL),
	(3459,348,'城东区',3,'',NULL),
	(3460,348,'城中区',3,'',NULL),
	(3461,348,'城西区',3,'',NULL),
	(3462,348,'城北区',3,'',NULL),
	(3463,348,'大通回族土族自治县',3,'',NULL),
	(3464,348,'湟中县',3,'',NULL),
	(3465,348,'湟源县',3,'',NULL),
	(3466,348,'其它区',3,'',NULL),
	(3467,349,'平安区',3,'',NULL),
	(3468,349,'民和回族土族自治县',3,'',NULL),
	(3469,349,'乐都区',3,'',NULL),
	(3470,349,'互助土族自治县',3,'',NULL),
	(3471,349,'化隆回族自治县',3,'',NULL),
	(3472,349,'循化撒拉族自治县',3,'',NULL),
	(3473,349,'其它区',3,'',NULL),
	(3474,350,'门源回族自治县',3,'',NULL),
	(3475,350,'祁连县',3,'',NULL),
	(3476,350,'海晏县',3,'',NULL),
	(3477,350,'刚察县',3,'',NULL),
	(3478,350,'其它区',3,'',NULL),
	(3479,351,'同仁县',3,'',NULL),
	(3480,351,'尖扎县',3,'',NULL),
	(3481,351,'泽库县',3,'',NULL),
	(3482,351,'河南蒙古族自治县',3,'',NULL),
	(3483,351,'其它区',3,'',NULL),
	(3484,352,'共和县',3,'',NULL),
	(3485,352,'同德县',3,'',NULL),
	(3486,352,'贵德县',3,'',NULL),
	(3487,352,'兴海县',3,'',NULL),
	(3488,352,'贵南县',3,'',NULL),
	(3489,352,'其它区',3,'',NULL),
	(3490,353,'玛沁县',3,'',NULL),
	(3491,353,'班玛县',3,'',NULL),
	(3492,353,'甘德县',3,'',NULL),
	(3493,353,'达日县',3,'',NULL),
	(3494,353,'久治县',3,'',NULL),
	(3495,353,'玛多县',3,'',NULL),
	(3496,353,'其它区',3,'',NULL),
	(3497,354,'玉树市',3,'',NULL),
	(3498,354,'杂多县',3,'',NULL),
	(3499,354,'称多县',3,'',NULL),
	(3500,354,'治多县',3,'',NULL),
	(3501,354,'囊谦县',3,'',NULL),
	(3502,354,'曲麻莱县',3,'',NULL),
	(3503,354,'其它区',3,'',NULL),
	(3504,355,'格尔木市',3,'',NULL),
	(3505,355,'德令哈市',3,'',NULL),
	(3506,355,'乌兰县',3,'',NULL),
	(3507,355,'都兰县',3,'',NULL),
	(3508,355,'天峻县',3,'',NULL),
	(3509,355,'其它区',3,'',NULL),
	(3510,356,'兴庆区',3,'',NULL),
	(3511,356,'西夏区',3,'',NULL),
	(3512,356,'金凤区',3,'',NULL),
	(3513,356,'永宁县',3,'',NULL),
	(3514,356,'贺兰县',3,'',NULL),
	(3515,356,'灵武市',3,'',NULL),
	(3516,356,'其它区',3,'',NULL),
	(3517,357,'大武口区',3,'',NULL),
	(3518,357,'惠农区',3,'',NULL),
	(3519,357,'平罗县',3,'',NULL),
	(3520,357,'其它区',3,'',NULL),
	(3521,358,'利通区',3,'',NULL),
	(3522,358,'红寺堡区',3,'',NULL),
	(3523,358,'盐池县',3,'',NULL),
	(3524,358,'同心县',3,'',NULL),
	(3525,358,'青铜峡市',3,'',NULL),
	(3526,358,'其它区',3,'',NULL),
	(3527,359,'原州区',3,'',NULL),
	(3528,359,'西吉县',3,'',NULL),
	(3529,359,'隆德县',3,'',NULL),
	(3530,359,'泾源县',3,'',NULL),
	(3531,359,'彭阳县',3,'',NULL),
	(3532,359,'其它区',3,'',NULL),
	(3533,360,'沙坡头区',3,'',NULL),
	(3534,360,'中宁县',3,'',NULL),
	(3535,360,'海原县',3,'',NULL),
	(3536,360,'其它区',3,'',NULL),
	(3537,361,'天山区',3,'',NULL),
	(3538,361,'沙依巴克区',3,'',NULL),
	(3539,361,'新市区',3,'',NULL),
	(3540,361,'水磨沟区',3,'',NULL),
	(3541,361,'头屯河区',3,'',NULL),
	(3542,361,'达坂城区',3,'',NULL),
	(3543,361,'东山区',3,'',NULL),
	(3544,361,'米东区',3,'',NULL),
	(3545,361,'乌鲁木齐县',3,'',NULL),
	(3546,361,'其它区',3,'',NULL),
	(3547,362,'独山子区',3,'',NULL),
	(3548,362,'克拉玛依区',3,'',NULL),
	(3549,362,'白碱滩区',3,'',NULL),
	(3550,362,'乌尔禾区',3,'',NULL),
	(3551,362,'其它区',3,'',NULL),
	(3552,363,'高昌区',3,'',NULL),
	(3553,363,'鄯善县',3,'',NULL),
	(3554,363,'托克逊县',3,'',NULL),
	(3555,363,'其它区',3,'',NULL),
	(3556,364,'哈密市',3,'',NULL),
	(3557,364,'巴里坤哈萨克自治县',3,'',NULL),
	(3558,364,'伊吾县',3,'',NULL),
	(3559,364,'其它区',3,'',NULL),
	(3560,365,'昌吉市',3,'',NULL),
	(3561,365,'阜康市',3,'',NULL),
	(3562,365,'米泉市',3,'',NULL),
	(3563,365,'呼图壁县',3,'',NULL),
	(3564,365,'玛纳斯县',3,'',NULL),
	(3565,365,'奇台县',3,'',NULL),
	(3566,365,'吉木萨尔县',3,'',NULL),
	(3567,365,'木垒哈萨克自治县',3,'',NULL),
	(3568,365,'其它区',3,'',NULL),
	(3569,366,'博乐市',3,'',NULL),
	(3570,366,'阿拉山口市',3,'',NULL),
	(3571,366,'精河县',3,'',NULL),
	(3572,366,'温泉县',3,'',NULL),
	(3573,366,'其它区',3,'',NULL),
	(3574,367,'库尔勒市',3,'',NULL),
	(3575,367,'轮台县',3,'',NULL),
	(3576,367,'尉犁县',3,'',NULL),
	(3577,367,'若羌县',3,'',NULL),
	(3578,367,'且末县',3,'',NULL),
	(3579,367,'焉耆回族自治县',3,'',NULL),
	(3580,367,'和静县',3,'',NULL),
	(3581,367,'和硕县',3,'',NULL),
	(3582,367,'博湖县',3,'',NULL),
	(3583,367,'其它区',3,'',NULL),
	(3584,368,'阿克苏市',3,'',NULL),
	(3585,368,'温宿县',3,'',NULL),
	(3586,368,'库车县',3,'',NULL),
	(3587,368,'沙雅县',3,'',NULL),
	(3588,368,'新和县',3,'',NULL),
	(3589,368,'拜城县',3,'',NULL),
	(3590,368,'乌什县',3,'',NULL),
	(3591,368,'阿瓦提县',3,'',NULL),
	(3592,368,'柯坪县',3,'',NULL),
	(3593,368,'其它区',3,'',NULL),
	(3594,369,'阿图什市',3,'',NULL),
	(3595,369,'阿克陶县',3,'',NULL),
	(3596,369,'阿合奇县',3,'',NULL),
	(3597,369,'乌恰县',3,'',NULL),
	(3598,369,'其它区',3,'',NULL),
	(3599,370,'喀什市',3,'',NULL),
	(3600,370,'疏附县',3,'',NULL),
	(3601,370,'疏勒县',3,'',NULL),
	(3602,370,'英吉沙县',3,'',NULL),
	(3603,370,'泽普县',3,'',NULL),
	(3604,370,'莎车县',3,'',NULL),
	(3605,370,'叶城县',3,'',NULL),
	(3606,370,'麦盖提县',3,'',NULL),
	(3607,370,'岳普湖县',3,'',NULL),
	(3608,370,'伽师县',3,'',NULL),
	(3609,370,'巴楚县',3,'',NULL),
	(3610,370,'塔什库尔干塔吉克自治县',3,'',NULL),
	(3611,370,'其它区',3,'',NULL),
	(3612,371,'和田市',3,'',NULL),
	(3613,371,'和田县',3,'',NULL),
	(3614,371,'墨玉县',3,'',NULL),
	(3615,371,'皮山县',3,'',NULL),
	(3616,371,'洛浦县',3,'',NULL),
	(3617,371,'策勒县',3,'',NULL),
	(3618,371,'于田县',3,'',NULL),
	(3619,371,'民丰县',3,'',NULL),
	(3620,371,'其它区',3,'',NULL),
	(3621,372,'伊宁市',3,'',NULL),
	(3622,372,'奎屯市',3,'',NULL),
	(3623,372,'伊宁县',3,'',NULL),
	(3624,372,'察布查尔锡伯自治县',3,'',NULL),
	(3625,372,'霍城县',3,'',NULL),
	(3626,372,'巩留县',3,'',NULL),
	(3627,372,'新源县',3,'',NULL),
	(3628,372,'昭苏县',3,'',NULL),
	(3629,372,'特克斯县',3,'',NULL),
	(3630,372,'尼勒克县',3,'',NULL),
	(3631,372,'其它区',3,'',NULL),
	(3632,373,'塔城市',3,'',NULL),
	(3633,373,'乌苏市',3,'',NULL),
	(3634,373,'额敏县',3,'',NULL),
	(3635,373,'沙湾县',3,'',NULL),
	(3636,373,'托里县',3,'',NULL),
	(3637,373,'裕民县',3,'',NULL),
	(3638,373,'和布克赛尔蒙古自治县',3,'',NULL),
	(3639,373,'其它区',3,'',NULL),
	(3640,374,'阿勒泰市',3,'',NULL),
	(3641,374,'布尔津县',3,'',NULL),
	(3642,374,'富蕴县',3,'',NULL),
	(3643,374,'福海县',3,'',NULL),
	(3644,374,'哈巴河县',3,'',NULL),
	(3645,374,'青河县',3,'',NULL),
	(3646,374,'吉木乃县',3,'',NULL),
	(3647,374,'其它区',3,'',NULL),
	(3648,375,'中正区',3,'',NULL),
	(3649,375,'大同区',3,'',NULL),
	(3650,375,'中山区',3,'',NULL),
	(3651,375,'松山区',3,'',NULL),
	(3652,375,'大安区',3,'',NULL),
	(3653,375,'万华区',3,'',NULL),
	(3654,375,'信义区',3,'',NULL),
	(3655,375,'士林区',3,'',NULL),
	(3656,375,'北投区',3,'',NULL),
	(3657,375,'内湖区',3,'',NULL),
	(3658,375,'南港区',3,'',NULL),
	(3659,375,'文山区',3,'',NULL),
	(3660,375,'其它区',3,'',NULL),
	(3661,376,'新兴区',3,'',NULL),
	(3662,376,'前金区',3,'',NULL),
	(3663,376,'芩雅区',3,'',NULL),
	(3664,376,'盐埕区',3,'',NULL),
	(3665,376,'鼓山区',3,'',NULL),
	(3666,376,'旗津区',3,'',NULL),
	(3667,376,'前镇区',3,'',NULL),
	(3668,376,'三民区',3,'',NULL),
	(3669,376,'左营区',3,'',NULL),
	(3670,376,'楠梓区',3,'',NULL),
	(3671,376,'小港区',3,'',NULL),
	(3672,376,'其它区',3,'',NULL),
	(3673,376,'苓雅区',3,'',NULL),
	(3674,376,'仁武区',3,'',NULL),
	(3675,376,'大社区',3,'',NULL),
	(3676,376,'冈山区',3,'',NULL),
	(3677,376,'路竹区',3,'',NULL),
	(3678,376,'阿莲区',3,'',NULL),
	(3679,376,'田寮区',3,'',NULL),
	(3680,376,'燕巢区',3,'',NULL),
	(3681,376,'桥头区',3,'',NULL),
	(3682,376,'梓官区',3,'',NULL),
	(3683,376,'弥陀区',3,'',NULL),
	(3684,376,'永安区',3,'',NULL),
	(3685,376,'湖内区',3,'',NULL),
	(3686,376,'凤山区',3,'',NULL),
	(3687,376,'大寮区',3,'',NULL),
	(3688,376,'林园区',3,'',NULL),
	(3689,376,'鸟松区',3,'',NULL),
	(3690,376,'大树区',3,'',NULL),
	(3691,376,'旗山区',3,'',NULL),
	(3692,376,'美浓区',3,'',NULL),
	(3693,376,'六龟区',3,'',NULL),
	(3694,376,'内门区',3,'',NULL),
	(3695,376,'杉林区',3,'',NULL),
	(3696,376,'甲仙区',3,'',NULL),
	(3697,376,'桃源区',3,'',NULL),
	(3698,376,'那玛夏区',3,'',NULL),
	(3699,376,'茂林区',3,'',NULL),
	(3700,376,'茄萣区',3,'',NULL),
	(3701,377,'中西区',3,'',NULL),
	(3702,377,'东区',3,'',NULL),
	(3703,377,'南区',3,'',NULL),
	(3704,377,'北区',3,'',NULL),
	(3705,377,'安平区',3,'',NULL),
	(3706,377,'安南区',3,'',NULL),
	(3707,377,'其它区',3,'',NULL),
	(3708,377,'永康区',3,'',NULL),
	(3709,377,'归仁区',3,'',NULL),
	(3710,377,'新化区',3,'',NULL),
	(3711,377,'左镇区',3,'',NULL),
	(3712,377,'玉井区',3,'',NULL),
	(3713,377,'楠西区',3,'',NULL),
	(3714,377,'南化区',3,'',NULL),
	(3715,377,'仁德区',3,'',NULL),
	(3716,377,'关庙区',3,'',NULL),
	(3717,377,'龙崎区',3,'',NULL),
	(3718,377,'官田区',3,'',NULL),
	(3719,377,'麻豆区',3,'',NULL),
	(3720,377,'佳里区',3,'',NULL),
	(3721,377,'西港区',3,'',NULL),
	(3722,377,'七股区',3,'',NULL),
	(3723,377,'将军区',3,'',NULL),
	(3724,377,'学甲区',3,'',NULL),
	(3725,377,'北门区',3,'',NULL),
	(3726,377,'新营区',3,'',NULL),
	(3727,377,'后壁区',3,'',NULL),
	(3728,377,'白河区',3,'',NULL),
	(3729,377,'东山区',3,'',NULL),
	(3730,377,'六甲区',3,'',NULL),
	(3731,377,'下营区',3,'',NULL),
	(3732,377,'柳营区',3,'',NULL),
	(3733,377,'盐水区',3,'',NULL),
	(3734,377,'善化区',3,'',NULL),
	(3735,377,'大内区',3,'',NULL),
	(3736,377,'山上区',3,'',NULL),
	(3737,377,'新市区',3,'',NULL),
	(3738,377,'安定区',3,'',NULL),
	(3739,378,'中区',3,'',NULL),
	(3740,378,'东区',3,'',NULL),
	(3741,378,'南区',3,'',NULL),
	(3742,378,'西区',3,'',NULL),
	(3743,378,'北区',3,'',NULL),
	(3744,378,'北屯区',3,'',NULL),
	(3745,378,'西屯区',3,'',NULL),
	(3746,378,'南屯区',3,'',NULL),
	(3747,378,'其它区',3,'',NULL),
	(3748,378,'太平区',3,'',NULL),
	(3749,378,'大里区',3,'',NULL),
	(3750,378,'雾峰区',3,'',NULL),
	(3751,378,'乌日区',3,'',NULL),
	(3752,378,'丰原区',3,'',NULL),
	(3753,378,'后里区',3,'',NULL),
	(3754,378,'石冈区',3,'',NULL),
	(3755,378,'东势区',3,'',NULL),
	(3756,378,'和平区',3,'',NULL),
	(3757,378,'新社区',3,'',NULL),
	(3758,378,'潭子区',3,'',NULL),
	(3759,378,'大雅区',3,'',NULL),
	(3760,378,'神冈区',3,'',NULL),
	(3761,378,'大肚区',3,'',NULL),
	(3762,378,'沙鹿区',3,'',NULL),
	(3763,378,'龙井区',3,'',NULL),
	(3764,378,'梧栖区',3,'',NULL),
	(3765,378,'清水区',3,'',NULL),
	(3766,378,'大甲区',3,'',NULL),
	(3767,378,'外埔区',3,'',NULL),
	(3768,378,'大安区',3,'',NULL),
	(3769,379,'金沙镇',3,'',NULL),
	(3770,379,'金湖镇',3,'',NULL),
	(3771,379,'金宁乡',3,'',NULL),
	(3772,379,'金城镇',3,'',NULL),
	(3773,379,'烈屿乡',3,'',NULL),
	(3774,379,'乌坵乡',3,'',NULL),
	(3775,380,'南投市',3,'',NULL),
	(3776,380,'中寮乡',3,'',NULL),
	(3777,380,'草屯镇',3,'',NULL),
	(3778,380,'国姓乡',3,'',NULL),
	(3779,380,'埔里镇',3,'',NULL),
	(3780,380,'仁爱乡',3,'',NULL),
	(3781,380,'名间乡',3,'',NULL),
	(3782,380,'集集镇',3,'',NULL),
	(3783,380,'水里乡',3,'',NULL),
	(3784,380,'鱼池乡',3,'',NULL),
	(3785,380,'信义乡',3,'',NULL),
	(3786,380,'竹山镇',3,'',NULL),
	(3787,380,'鹿谷乡',3,'',NULL),
	(3788,381,'仁爱区',3,'',NULL),
	(3789,381,'信义区',3,'',NULL),
	(3790,381,'中正区',3,'',NULL),
	(3791,381,'中山区',3,'',NULL),
	(3792,381,'安乐区',3,'',NULL),
	(3793,381,'暖暖区',3,'',NULL),
	(3794,381,'七堵区',3,'',NULL),
	(3795,381,'其它区',3,'',NULL),
	(3796,382,'东区',3,'',NULL),
	(3797,382,'北区',3,'',NULL),
	(3798,382,'香山区',3,'',NULL),
	(3799,382,'其它区',3,'',NULL),
	(3800,383,'东区',3,'',NULL),
	(3801,383,'西区',3,'',NULL),
	(3802,383,'其它区',3,'',NULL),
	(3803,384,'万里区',3,'',NULL),
	(3804,384,'金山区',3,'',NULL),
	(3805,384,'板桥区',3,'',NULL),
	(3806,384,'汐止区',3,'',NULL),
	(3807,384,'深坑区',3,'',NULL),
	(3808,384,'石碇区',3,'',NULL),
	(3809,384,'瑞芳区',3,'',NULL),
	(3810,384,'平溪区',3,'',NULL),
	(3811,384,'双溪区',3,'',NULL),
	(3812,384,'贡寮区',3,'',NULL),
	(3813,384,'新店区',3,'',NULL),
	(3814,384,'坪林区',3,'',NULL),
	(3815,384,'乌来区',3,'',NULL),
	(3816,384,'永和区',3,'',NULL),
	(3817,384,'中和区',3,'',NULL),
	(3818,384,'土城区',3,'',NULL),
	(3819,384,'三峡区',3,'',NULL),
	(3820,384,'树林区',3,'',NULL),
	(3821,384,'莺歌区',3,'',NULL),
	(3822,384,'三重区',3,'',NULL),
	(3823,384,'新庄区',3,'',NULL),
	(3824,384,'泰山区',3,'',NULL),
	(3825,384,'林口区',3,'',NULL),
	(3826,384,'芦洲区',3,'',NULL),
	(3827,384,'五股区',3,'',NULL),
	(3828,384,'八里区',3,'',NULL),
	(3829,384,'淡水区',3,'',NULL),
	(3830,384,'三芝区',3,'',NULL),
	(3831,384,'石门区',3,'',NULL),
	(3832,385,'宜兰市',3,'',NULL),
	(3833,385,'头城镇',3,'',NULL),
	(3834,385,'礁溪乡',3,'',NULL),
	(3835,385,'壮围乡',3,'',NULL),
	(3836,385,'员山乡',3,'',NULL),
	(3837,385,'罗东镇',3,'',NULL),
	(3838,385,'三星乡',3,'',NULL),
	(3839,385,'大同乡',3,'',NULL),
	(3840,385,'五结乡',3,'',NULL),
	(3841,385,'冬山乡',3,'',NULL),
	(3842,385,'苏澳镇',3,'',NULL),
	(3843,385,'南澳乡',3,'',NULL),
	(3844,385,'钓鱼台',3,'',NULL),
	(3845,386,'竹北市',3,'',NULL),
	(3846,386,'湖口乡',3,'',NULL),
	(3847,386,'新丰乡',3,'',NULL),
	(3848,386,'新埔镇',3,'',NULL),
	(3849,386,'关西镇',3,'',NULL),
	(3850,386,'芎林乡',3,'',NULL),
	(3851,386,'宝山乡',3,'',NULL),
	(3852,386,'竹东镇',3,'',NULL),
	(3853,386,'五峰乡',3,'',NULL),
	(3854,386,'横山乡',3,'',NULL),
	(3855,386,'尖石乡',3,'',NULL),
	(3856,386,'北埔乡',3,'',NULL),
	(3857,386,'峨眉乡',3,'',NULL),
	(3858,387,'中坜市',3,'',NULL),
	(3859,387,'平镇市',3,'',NULL),
	(3860,387,'龙潭乡',3,'',NULL),
	(3861,387,'杨梅市',3,'',NULL),
	(3862,387,'新屋乡',3,'',NULL),
	(3863,387,'观音乡',3,'',NULL),
	(3864,387,'桃园市',3,'',NULL),
	(3865,387,'龟山乡',3,'',NULL),
	(3866,387,'八德市',3,'',NULL),
	(3867,387,'大溪镇',3,'',NULL),
	(3868,387,'复兴乡',3,'',NULL),
	(3869,387,'大园乡',3,'',NULL),
	(3870,387,'芦竹乡',3,'',NULL),
	(3871,388,'竹南镇',3,'',NULL),
	(3872,388,'头份镇',3,'',NULL),
	(3873,388,'三湾乡',3,'',NULL),
	(3874,388,'南庄乡',3,'',NULL),
	(3875,388,'狮潭乡',3,'',NULL),
	(3876,388,'后龙镇',3,'',NULL),
	(3877,388,'通霄镇',3,'',NULL),
	(3878,388,'苑里镇',3,'',NULL),
	(3879,388,'苗栗市',3,'',NULL),
	(3880,388,'造桥乡',3,'',NULL),
	(3881,388,'头屋乡',3,'',NULL),
	(3882,388,'公馆乡',3,'',NULL),
	(3883,388,'大湖乡',3,'',NULL),
	(3884,388,'泰安乡',3,'',NULL),
	(3885,388,'铜锣乡',3,'',NULL),
	(3886,388,'三义乡',3,'',NULL),
	(3887,388,'西湖乡',3,'',NULL),
	(3888,388,'卓兰镇',3,'',NULL),
	(3889,389,'彰化市',3,'',NULL),
	(3890,389,'芬园乡',3,'',NULL),
	(3891,389,'花坛乡',3,'',NULL),
	(3892,389,'秀水乡',3,'',NULL),
	(3893,389,'鹿港镇',3,'',NULL),
	(3894,389,'福兴乡',3,'',NULL),
	(3895,389,'线西乡',3,'',NULL),
	(3896,389,'和美镇',3,'',NULL),
	(3897,389,'伸港乡',3,'',NULL),
	(3898,389,'员林镇',3,'',NULL),
	(3899,389,'社头乡',3,'',NULL),
	(3900,389,'永靖乡',3,'',NULL),
	(3901,389,'埔心乡',3,'',NULL),
	(3902,389,'溪湖镇',3,'',NULL),
	(3903,389,'大村乡',3,'',NULL),
	(3904,389,'埔盐乡',3,'',NULL),
	(3905,389,'田中镇',3,'',NULL),
	(3906,389,'北斗镇',3,'',NULL),
	(3907,389,'田尾乡',3,'',NULL),
	(3908,389,'埤头乡',3,'',NULL),
	(3909,389,'溪州乡',3,'',NULL),
	(3910,389,'竹塘乡',3,'',NULL),
	(3911,389,'二林镇',3,'',NULL),
	(3912,389,'大城乡',3,'',NULL),
	(3913,389,'芳苑乡',3,'',NULL),
	(3914,389,'二水乡',3,'',NULL),
	(3915,390,'番路乡',3,'',NULL),
	(3916,390,'梅山乡',3,'',NULL),
	(3917,390,'竹崎乡',3,'',NULL),
	(3918,390,'阿里山乡',3,'',NULL),
	(3919,390,'中埔乡',3,'',NULL),
	(3920,390,'大埔乡',3,'',NULL),
	(3921,390,'水上乡',3,'',NULL),
	(3922,390,'鹿草乡',3,'',NULL),
	(3923,390,'太保市',3,'',NULL),
	(3924,390,'朴子市',3,'',NULL),
	(3925,390,'东石乡',3,'',NULL),
	(3926,390,'六脚乡',3,'',NULL),
	(3927,390,'新港乡',3,'',NULL),
	(3928,390,'民雄乡',3,'',NULL),
	(3929,390,'大林镇',3,'',NULL),
	(3930,390,'溪口乡',3,'',NULL),
	(3931,390,'义竹乡',3,'',NULL),
	(3932,390,'布袋镇',3,'',NULL),
	(3933,391,'斗南镇',3,'',NULL),
	(3934,391,'大埤乡',3,'',NULL),
	(3935,391,'虎尾镇',3,'',NULL),
	(3936,391,'土库镇',3,'',NULL),
	(3937,391,'褒忠乡',3,'',NULL),
	(3938,391,'东势乡',3,'',NULL),
	(3939,391,'台西乡',3,'',NULL),
	(3940,391,'仑背乡',3,'',NULL),
	(3941,391,'麦寮乡',3,'',NULL),
	(3942,391,'斗六市',3,'',NULL),
	(3943,391,'林内乡',3,'',NULL),
	(3944,391,'古坑乡',3,'',NULL),
	(3945,391,'莿桐乡',3,'',NULL),
	(3946,391,'西螺镇',3,'',NULL),
	(3947,391,'二仑乡',3,'',NULL),
	(3948,391,'北港镇',3,'',NULL),
	(3949,391,'水林乡',3,'',NULL),
	(3950,391,'口湖乡',3,'',NULL),
	(3951,391,'四湖乡',3,'',NULL),
	(3952,391,'元长乡',3,'',NULL),
	(3953,392,'屏东市',3,'',NULL),
	(3954,392,'三地门乡',3,'',NULL),
	(3955,392,'雾台乡',3,'',NULL),
	(3956,392,'玛家乡',3,'',NULL),
	(3957,392,'九如乡',3,'',NULL),
	(3958,392,'里港乡',3,'',NULL),
	(3959,392,'高树乡',3,'',NULL),
	(3960,392,'盐埔乡',3,'',NULL),
	(3961,392,'长治乡',3,'',NULL),
	(3962,392,'麟洛乡',3,'',NULL),
	(3963,392,'竹田乡',3,'',NULL),
	(3964,392,'内埔乡',3,'',NULL),
	(3965,392,'万丹乡',3,'',NULL),
	(3966,392,'潮州镇',3,'',NULL),
	(3967,392,'泰武乡',3,'',NULL),
	(3968,392,'来义乡',3,'',NULL),
	(3969,392,'万峦乡',3,'',NULL),
	(3970,392,'崁顶乡',3,'',NULL),
	(3971,392,'新埤乡',3,'',NULL),
	(3972,392,'南州乡',3,'',NULL),
	(3973,392,'林边乡',3,'',NULL),
	(3974,392,'东港镇',3,'',NULL),
	(3975,392,'琉球乡',3,'',NULL),
	(3976,392,'佳冬乡',3,'',NULL),
	(3977,392,'新园乡',3,'',NULL),
	(3978,392,'枋寮乡',3,'',NULL),
	(3979,392,'枋山乡',3,'',NULL),
	(3980,392,'春日乡',3,'',NULL),
	(3981,392,'狮子乡',3,'',NULL),
	(3982,392,'车城乡',3,'',NULL),
	(3983,392,'牡丹乡',3,'',NULL),
	(3984,392,'恒春镇',3,'',NULL),
	(3985,392,'满州乡',3,'',NULL),
	(3986,393,'台东市',3,'',NULL),
	(3987,393,'绿岛乡',3,'',NULL),
	(3988,393,'兰屿乡',3,'',NULL),
	(3989,393,'延平乡',3,'',NULL),
	(3990,393,'卑南乡',3,'',NULL),
	(3991,393,'鹿野乡',3,'',NULL),
	(3992,393,'关山镇',3,'',NULL),
	(3993,393,'海端乡',3,'',NULL),
	(3994,393,'池上乡',3,'',NULL),
	(3995,393,'东河乡',3,'',NULL),
	(3996,393,'成功镇',3,'',NULL),
	(3997,393,'长滨乡',3,'',NULL),
	(3998,393,'金峰乡',3,'',NULL),
	(3999,393,'大武乡',3,'',NULL),
	(4000,393,'达仁乡',3,'',NULL),
	(4001,393,'太麻里乡',3,'',NULL),
	(4002,394,'花莲市',3,'',NULL),
	(4003,394,'新城乡',3,'',NULL),
	(4004,394,'太鲁阁',3,'',NULL),
	(4005,394,'秀林乡',3,'',NULL),
	(4006,394,'吉安乡',3,'',NULL),
	(4007,394,'寿丰乡',3,'',NULL),
	(4008,394,'凤林镇',3,'',NULL),
	(4009,394,'光复乡',3,'',NULL),
	(4010,394,'丰滨乡',3,'',NULL),
	(4011,394,'瑞穗乡',3,'',NULL),
	(4012,394,'万荣乡',3,'',NULL),
	(4013,394,'玉里镇',3,'',NULL),
	(4014,394,'卓溪乡',3,'',NULL),
	(4015,394,'富里乡',3,'',NULL),
	(4016,395,'马公市',3,'',NULL),
	(4017,395,'西屿乡',3,'',NULL),
	(4018,395,'望安乡',3,'',NULL),
	(4019,395,'七美乡',3,'',NULL),
	(4020,395,'白沙乡',3,'',NULL),
	(4021,395,'湖西乡',3,'',NULL),
	(4022,396,'南竿乡',3,'',NULL),
	(4023,396,'北竿乡',3,'',NULL),
	(4024,396,'莒光乡',3,'',NULL),
	(4025,396,'东引乡',3,'',NULL),
	(4026,397,'中西区',3,'',NULL),
	(4027,397,'湾仔',3,'',NULL),
	(4028,397,'东区',3,'',NULL),
	(4029,397,'南区',3,'',NULL),
	(4030,398,'九龙城区',3,'',NULL),
	(4031,398,'油尖旺区',3,'',NULL),
	(4032,398,'深水埗区',3,'',NULL),
	(4033,398,'黄大仙区',3,'',NULL),
	(4034,398,'观塘区',3,'',NULL),
	(4035,399,'北区',3,'',NULL),
	(4036,399,'大埔区',3,'',NULL),
	(4037,399,'沙田区',3,'',NULL),
	(4038,399,'西贡区',3,'',NULL),
	(4039,399,'元朗区',3,'',NULL),
	(4040,399,'屯门区',3,'',NULL),
	(4041,399,'荃湾区',3,'',NULL),
	(4042,399,'葵青区',3,'',NULL),
	(4043,399,'离岛区',3,'',NULL),
	(4044,0,'东北',2,'',NULL);

/*!40000 ALTER TABLE `s_address` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table s_appid_template
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_appid_template`;

CREATE TABLE `s_appid_template` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `appid` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `secret` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `template_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `template_id` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `content` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` tinyint(2) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

LOCK TABLES `s_appid_template` WRITE;
/*!40000 ALTER TABLE `s_appid_template` DISABLE KEYS */;

INSERT INTO `s_appid_template` (`id`, `appid`, `secret`, `template_number`, `template_id`, `content`, `status`)
VALUES
	(1,'wxe1d66f5605ddc128','','OPENTM206831895','GDsXZI5CrFYOSAP9mQprmQpWx8BeofWIFY9U_NkDojY',NULL,NULL);

/*!40000 ALTER TABLE `s_appid_template` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table s_brandclass
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_brandclass`;

CREATE TABLE `s_brandclass` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `brandclass` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '??????',
  `group_company_name` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '????',
  `wx_public` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '?????',
  `wx_appid` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `wx_secret` varchar(200) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '?????????????appsecret',
  `sms_config` int(11) DEFAULT NULL COMMENT '短信配置，存sms内的JSONkey值',
  `nickname` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `order_rule` tinyint(2) DEFAULT NULL COMMENT '有效订单标准，1实收款2占比',
  `proportion` int(11) DEFAULT NULL COMMENT '有效订单的值，1则为数字，2则为数值/100',
  `mall_url` varchar(500) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT '',
  `wx_mch_id` varchar(200) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT '',
  `wx_pay_key` varchar(200) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT '',
  `vip_url` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT '',
  `valid_date` varchar(5) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `wx_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COMMENT='集团品牌设定';



# Dump of table s_consumption_capacity
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_consumption_capacity`;

CREATE TABLE `s_consumption_capacity` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `capacity` varchar(100) CHARACTER SET utf8 DEFAULT NULL,
  `shop_name` varchar(100) CHARACTER SET utf8 DEFAULT NULL,
  `shop_code` varchar(100) CHARACTER SET utf8 DEFAULT NULL,
  `setkey` varchar(100) CHARACTER SET utf8 DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COMMENT='消费能力';

LOCK TABLES `s_consumption_capacity` WRITE;
/*!40000 ALTER TABLE `s_consumption_capacity` DISABLE KEYS */;

INSERT INTO `s_consumption_capacity` (`id`, `capacity`, `shop_name`, `shop_code`, `setkey`)
VALUES
	(1,'100块钱',NULL,NULL,NULL);

/*!40000 ALTER TABLE `s_consumption_capacity` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table s_cussource
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_cussource`;

CREATE TABLE `s_cussource` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cus_name` varchar(100) CHARACTER SET utf8 DEFAULT NULL,
  `shop_name` varchar(100) CHARACTER SET utf8 DEFAULT NULL,
  `shop_code` varchar(100) CHARACTER SET utf8 DEFAULT NULL,
  `setkey` varchar(100) CHARACTER SET utf8 DEFAULT NULL,
  `type_id` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COMMENT='客户来源表';



# Dump of table s_departmentinfo
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_departmentinfo`;

CREATE TABLE `s_departmentinfo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `department_name` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '部门名称',
  `grade_type` tinyint(4) DEFAULT NULL COMMENT '1集团，2品牌，3店面，4部门',
  `channel_list` varchar(3000) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '管理渠道',
  `group_company_name` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '集团名称',
  `brandclass` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '品牌',
  `shop_name` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '所属店面名称',
  `shop_code` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '所属店面识别码',
  `setkey` varchar(100) CHARACTER SET utf8 DEFAULT NULL COMMENT '设定店面识别码',
  `brandclass_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COMMENT='部门设定';



# Dump of table s_function_staff
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_function_staff`;

CREATE TABLE `s_function_staff` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `system_name` varchar(100) DEFAULT NULL,
  `function_name` varchar(100) DEFAULT NULL,
  `function_code` varchar(100) DEFAULT NULL,
  `function_fid` int(11) DEFAULT NULL,
  `staffnumber` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



# Dump of table s_functioninfo
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_functioninfo`;

CREATE TABLE `s_functioninfo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `system_name` varchar(100) DEFAULT NULL,
  `function_name` varchar(100) DEFAULT NULL,
  `function_code` varchar(100) DEFAULT NULL,
  `function_fid` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



# Dump of table s_functionset
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_functionset`;

CREATE TABLE `s_functionset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `A` varchar(20) DEFAULT NULL,
  `Aid` varchar(20) DEFAULT NULL,
  `B` varchar(20) DEFAULT NULL,
  `Bid` varchar(20) DEFAULT NULL,
  `C` varchar(20) DEFAULT NULL,
  `Cid` varchar(20) DEFAULT NULL,
  `D` varchar(20) DEFAULT NULL,
  `Did` varchar(20) DEFAULT NULL,
  `E` varchar(20) DEFAULT NULL,
  `Eid` varchar(20) DEFAULT NULL,
  `coderkey` varchar(20) DEFAULT NULL,
  `setkey` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



# Dump of table s_groupcompany
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_groupcompany`;

CREATE TABLE `s_groupcompany` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `group_company_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '集团名称',
  `wx_public` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '微信配置名',
  `wx_appid` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `wx_secret` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sms_config` int(11) DEFAULT NULL COMMENT '短信配置',
  `wx_mch_id` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  `wx_pay_key` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  `wx_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `third_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='集团名称设定';



# Dump of table s_intentionset
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_intentionset`;

CREATE TABLE `s_intentionset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `intention_name` varchar(100) CHARACTER SET utf8 DEFAULT NULL,
  `shop_name` varchar(100) CHARACTER SET utf8 DEFAULT NULL,
  `shop_code` varchar(100) CHARACTER SET utf8 DEFAULT NULL,
  `setkey` varchar(100) CHARACTER SET utf8 DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COMMENT='客户意向';



# Dump of table s_leave
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_leave`;

CREATE TABLE `s_leave` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staffname` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sex` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  `phone` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `department_name` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `position_name` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `address` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  `entry_date` datetime DEFAULT NULL COMMENT '入职时间',
  `contract_end_day` datetime DEFAULT NULL COMMENT '合同到期时间',
  `apply_leave` datetime DEFAULT NULL COMMENT '申请时间',
  `check_leave` datetime DEFAULT NULL COMMENT '核准离职时间',
  `leave_type` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '离职类型',
  `leave_reason` text COLLATE utf8_unicode_ci COMMENT '离职原因',
  `advice` text COLLATE utf8_unicode_ci COMMENT '对公司意见',
  `department_advice` text COLLATE utf8_unicode_ci COMMENT '部门意见',
  `personnel_advice` text COLLATE utf8_unicode_ci COMMENT '人事部意见',
  `manager_advice` text COLLATE utf8_unicode_ci COMMENT '总经理意见',
  `add_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table s_losssignitem
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_losssignitem`;

CREATE TABLE `s_losssignitem` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `lossname` varchar(500) DEFAULT NULL,
  `shop_name` varchar(100) DEFAULT NULL,
  `shop_code` varchar(100) DEFAULT NULL,
  `setkey` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



# Dump of table s_markset
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_markset`;

CREATE TABLE `s_markset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `mark_name` varchar(50) CHARACTER SET utf8 DEFAULT NULL COMMENT '标记名',
  `mark_color` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `shop_name` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `shop_code` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  `setkey` varchar(50) CHARACTER SET utf8 DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table s_menu
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_menu`;

CREATE TABLE `s_menu` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `menu_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '菜单名称',
  `fid` int(11) DEFAULT NULL,
  `menu_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '功能菜单唯一标识',
  `menu_url` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '菜单url',
  `menu_icon` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '菜单图标',
  `status` tinyint(4) DEFAULT NULL COMMENT '状态',
  `sort` int(10) unsigned DEFAULT NULL COMMENT '排序',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='功能菜单表';

LOCK TABLES `s_menu` WRITE;
/*!40000 ALTER TABLE `s_menu` DISABLE KEYS */;

INSERT INTO `s_menu` (`id`, `menu_name`, `fid`, `menu_code`, `menu_url`, `menu_icon`, `status`, `sort`)
VALUES
	(1,'我的工作',0,'menu1512736714','/crm/Customer/index','fa-home',1,1),
	(2,'客户管理',0,'menu1512735953','/crm/Customer/customerList','fa-user',1,2),
	(5,'统计分析',0,'menu1512736477','/crm/setting/statistics_list','fa-bar-chart',1,4),
	(6,'系统设置',0,'menu1512650831','#','fa-cog',1,4),
	(7,'渠道花费',8,'menu1512650793','/crm/Setting/qdType',NULL,1,1),
	(8,'花费录入',0,'menu1529995000','#','fa-money',1,6),
	(9,'系统日志',0,'menu1537322224','#','fa-file-text',1,5),
	(10,'客资分配设定',6,'menu1512009199','/crm/Setting/fpSet',NULL,1,2),
	(11,'小组设定',6,'menu1512028478','/crm/Setting/groupSet',NULL,1,3),
	(12,'客资提醒设定',6,'menu1512028590','/crm/Setting/remindSet',NULL,1,4),
	(13,'沟通流程设定',6,'menu1512028684','/crm/Setting/workFlow',NULL,1,5),
	(14,'业务目标设定',6,'menu1512028704','/crm/Setting/goalSet',NULL,1,6),
	(15,'五维图设定',6,'menu1512028736','/crm/Setting/biao',NULL,1,7),
	(16,'不再追踪原因设定',6,'menu1512029560','/crm/Setting/fileReason','',1,8),
	(17,'短信模板设定',6,'menu1512029583','/crm/Setting/modalSet',NULL,1,9),
	(18,'微信模板设定',6,'menu1512029604','/crm/Setting/pushModal','',0,10),
	(19,'电访备注设定',6,'menu1512029635','/crm/Setting/telphoneRemark','',0,11),
	(21,'功能菜单设定',6,'menu1512029909','/crm/Setting/menuSet','',0,13),
	(22,'权限设定',6,'menu1512029925','/crm/Setting/permission',NULL,1,14),
	(26,'深挖--毛客资量统计',5,'menu1512897388','/crm/Statistics/dj_customer','',0,1),
	(32,'查看所有客资',34,'menu1512637269','allCustomer','',1,1),
	(33,'新增客资',61,'menu1512970660','/crm/Customer/addCustomer','',1,1),
	(34,'客资查询',2,'menu1512970347','','',0,1),
	(35,'查看追踪人的客资',34,'menu1512650502','','',1,3),
	(36,'删除客资',61,'menu1512970570','/crm/Customer/delCustomer','',1,2),
	(37,'导入客资',61,'menu1512970672','/crm/Customer/import','',1,4),
	(38,'导出客资',61,'menu1512970678','/crm/Customer/export','',1,5),
	(39,'刷新列表',61,'menu1512970682','','',1,6),
	(40,'客资分配',61,'menu1512970623','/crm/Customer/customerAllotOne','',1,8),
	(41,'选项卡-所有客资',34,'menu1512698495','','',1,4),
	(42,'选项卡-待追踪',34,'menu1512698552','','',1,5),
	(43,'选项卡-待分配',34,'menu1512698635','','',1,6),
	(44,'选项卡-追踪中',34,'menu1512698693','','',1,7),
	(45,'选项卡-已订单',34,'menu1512698717','','',1,8),
	(46,'选项卡-进店未成交',34,'menu1512698836','','',1,9),
	(59,'电商--统计日报',5,'menu1512971049','/crm/Statistics/dsDaily','',0,3),
	(60,'追踪标记设定',6,'menu1512898027','/crm/Setting/markSet','',1,50),
	(61,'客资维护',2,'menu1512970388','','',0,2),
	(62,'修改客资',61,'menu1512970667','/crm/Customer/customerInfo','',1,3),
	(63,'客资追踪',2,'menu1512971674','','',0,3),
	(64,'客资电话追踪',63,'menu1512971662','/crm/Customer/addSalesTracking','',1,1),
	(65,'客资标记',63,'menu1512971681','','',1,2),
	(66,'查看追踪记录',63,'menu1512971583','/crm/Customer/trackLog','',1,3),
	(67,'发送短信',63,'menu1512971646','/crm/Customer/send_message','',1,4),
	(68,'查看个人工作',70,'menu1512987407','','',1,1),
	(69,'查看小组成员工作',70,'menu1512987394','','',1,2),
	(70,'界面菜单',1,'menu1512993265','','fa-home',0,0),
	(71,'查看手机号',34,'menu1512998373','3','',1,2),
	(72,'客资标记设定',6,'menu1513213883','/crm/Setting/trackingKmarker','',1,20),
	(73,'花费返点',8,'menu1513343947','/crm/Setting/qdReturn','',1,52),
	(74,'岗位授权',22,'menu1513394914','/crm/Setting/authorise','',1,1),
	(75,'选项卡-不再追踪',34,'menu1513395549','','',1,10),
	(76,'修改qq/微信/微博',61,'menu1513409629','','',1,9),
	(77,'修改客资渠道',61,'menu1513409657','','',1,10),
	(78,'修改获取方式',61,'menu1513409684','','',1,11),
	(79,'修改消费类型',61,'menu1513409704','','',1,12),
	(80,'修改客户来源',61,'menu1513409882','','',1,13),
	(81,'修改客户意向',61,'menu1513410030','','',1,14),
	(82,'修改客资分区',61,'menu1513410084','','',1,15),
	(83,'修改客资地域',61,'menu1513410164','','',1,16),
	(84,'选项卡-待筛客',34,'menu1513592505','','',1,11),
	(85,'获取成本',8,'menu1513855331','/crm/Setting/obtainCost','',0,60),
	(86,'选项卡-已筛客',34,'menu1513863618','','',1,12),
	(87,'呼叫前缀设定',6,'menu1514183289','/crm/Setting/callPrefix','',1,30),
	(88,'电商--统计月报',5,'menu1514351403','/crm/Statistics/dsReport','',0,3),
	(89,'深挖客资日报',5,'menu1514424405','/crm/Statistics/swCustomerDaily','',0,4),
	(90,'电销日报',5,'menu1514425074','/crm/Statistics/swDaily','',0,5),
	(91,'电销月报',5,'menu1514425150','/crm/Statistics/swReport','',0,6),
	(92,'深挖数据统计',5,'menu1514425221','/crm/Statistics/swStatistics','',0,7),
	(93,'首页客资简析',6,'menu1514430518','/crm/Setting/homeShowSet','',1,46),
	(97,'转客资',61,'menu1515837753','','',1,0),
	(98,'查看个人权限',22,'menu1515927010','','',1,0),
	(99,'电商渠道客资统计',5,'menu1515985582','/crm/Statistics/dsCustomerStatistics','',0,2),
	(101,'渠道名称设定',6,'menu1516949559','/crm/Setting/channel',NULL,1,50),
	(102,'失败再分配',61,'menu1517042801','/crm/Customer/customerReAllot',NULL,1,0),
	(103,'客资标记',2,'menu1517129233','','',0,30),
	(104,'标记有效',103,'menu1517129299','/crm/signValid',NULL,1,30),
	(105,'标记无效',103,'menu1517129331','/crm/signUnvalid',NULL,1,30),
	(106,'当日接收',34,'menu1517217988','',NULL,1,1),
	(107,'三日内追踪',34,'menu1517218007','',NULL,1,1),
	(108,'当日预进店',34,'menu1517218044','',NULL,1,1),
	(109,'客资驳回',2,'menu1517278817','/crm/customerValidUpdate','',0,20),
	(110,'客资反驳回',2,'menu1517278844','/crm/customerUnValidUpdate','',0,20),
	(112,'省市区设定',6,'menu1517560908','/crm/Setting/province','',1,90),
	(113,'渠道-各店转化率表',5,'menu1517727451','/crm/Statistics/swCustomerChange','',0,9),
	(114,'选项卡-有效客资',34,'menu1519611713','',NULL,1,13),
	(115,'选项卡-无效客资',34,'menu1519611738','',NULL,1,14),
	(116,'选项卡-待定客资',34,'menu1519611762','',NULL,1,15),
	(117,'选项卡-驳回客资',34,'menu1519611781','',NULL,1,16),
	(118,'右键-客资标记',2,'menu1519631971','/crm/Customer/customerSign','',0,20),
	(119,'右键-追踪标记',2,'menu1519632099','/crm/Customer/customerSign',NULL,0,21),
	(120,'右键-不再追踪',2,'menu1519633436','/crm/Customer/notTraking',NULL,0,30),
	(121,'右键-预约进店',2,'menu1519633870','/crm/Customer/customerYJD',NULL,0,25),
	(122,'右键-转订单',2,'menu1519633923','/crm/Customer/zhuanOrder',NULL,0,26),
	(123,'右键-编辑订单',2,'menu1519633959','/crm/Customer/editOrder',NULL,0,27),
	(124,'右键-筛客',2,'menu1519635403','/crm/Customer/skCustomer',NULL,0,20),
	(129,'渠道漏斗统计',5,'menu1519826594','/crm/Statistics/ds_channelLd','',0,2),
	(130,'地域漏斗统计',5,'menu1519826642','/crm/Statistics/ds_regionLd',NULL,0,2),
	(132,'右键-撤销',2,'menu1520675106','/crm/Customer/customerRevoke',NULL,0,28),
	(133,'返点规则',8,'menu1521280345','/crm/Setting/shop_return_setting',NULL,0,100),
	(134,'查询服务',0,'menu1521267312','/crm/Customer/moreSearch','fa-search',1,3),
	(135,'电商统计日报--常态报表1',5,'menu1521352296','/crm/Statistics/ds_sta_day','',0,10),
	(136,'电商统周报--常态报表2',5,'menu1521352325','/crm/Statistics/ds_sta_month',NULL,0,11),
	(137,'电商统计日报--常态报表3',5,'menu1521352381','/crm/Statistics/ds_to_wx_report',NULL,0,12),
	(138,'电商日报明细',5,'menu1521352428','/crm/Statistics/daily_detail',NULL,0,13),
	(139,'网销漏斗',5,'menu1521352461','/crm/Statistics/wx_ld',NULL,0,14),
	(140,'渠道透视',5,'menu1521352487','/crm/Statistics/qd_ts',NULL,0,15),
	(141,'地域渠道有效客资透视',5,'menu1521352560','/crm/Statistics/dy_ts',NULL,0,16),
	(142,'网销无效分析',5,'menu1521352579','/crm/Statistics/wx_unvalid',NULL,0,17),
	(143,'渠道漏斗月走势统计',5,'menu1521352601','/crm/Statistics/channel_ld_month',NULL,0,18),
	(144,'关键词分析',5,'menu1521352632','/crm/Statistics/keywords',NULL,0,19),
	(146,'网销小组邀约(进店)统计',5,'menu1521352682','/crm/Statistics/wx_group_jd',NULL,0,21),
	(147,'网销小组新单统计',5,'menu1521352703','/crm/Statistics/wx_group_new_order',NULL,0,22),
	(148,'网销地域统计',5,'menu1521352729','/crm/Statistics/wx_region',NULL,0,23),
	(149,'电商目标达成统计',5,'menu1521352748','/crm/Statistics/ds_goal',NULL,0,24),
	(150,'电商渠道达成进店跟踪',5,'menu1521352772','/crm/Statistics/ds_shop_goal',NULL,0,25),
	(166,'批量客资查询',134,'menu1521439092','/crm/Customer/moreSearch','',1,0),
	(167,'门市订单查询',134,'menu1521352773','/crm/Customer/searchorders',NULL,1,2),
	(171,'驳回原因设定',6,'menu1521784361','/crm/Setting/RejectReason',NULL,1,21),
	(172,'系统配置',6,'menu1522207375','/crm/Setting/erpSet','',1,101),
	(173,'订单来源设定',6,'menu1522225258','/crm/Setting/orderSource',NULL,1,102),
	(174,'各店24小时PK表',5,'menu1522237395','/crm/Statistics/ds_pk',NULL,0,26),
	(175,'右键-介绍人修改',2,'menu1522653972','/crm/Customer/editIntroducer',NULL,0,29),
	(176,'电商--本店各渠道数据明细',5,'menu1522752932','/crm/Statistics/dayStatistics',NULL,0,28),
	(177,'各事业部数据统计',5,'menu1522752970','/crm/Statistics/week_and_month_statistics',NULL,0,29),
	(185,'服务监控',70,'menu1523865883','/server/index',NULL,1,1),
	(187,'第三方录入接口配置',6,'menu1523588039','/crm/Setting/customerInterface',NULL,1,103),
	(190,'本店报表设置',5,'menu1523775076','','',0,1),
	(192,'其它花费',8,'menu1524225422','/crm/Setting/anotherCost',NULL,1,105),
	(193,'今日需追踪',34,'menu1524450329','',NULL,1,1),
	(194,'客资池',61,'menu1524551642','',NULL,1,0),
	(195,'网销综合数据分析2',5,'menu1521352658','/crm/Statistics/wx_group1',NULL,0,20),
	(196,'事业部大屏',5,'menu1526378178','/crm/Bigscreen/brand',NULL,0,0),
	(265,'客资爆破',6,'menu1521091523','/crm/Setting/customerSwap',NULL,1,101),
	(266,'爆破设定',171,'menu1521093152','/crm/Setting/customerSwapSet',NULL,1,102),
	(267,'添加客资',171,'menu1521093203','/crm/Setting/addCustomerSwap',NULL,1,103),
	(422,'花费数据统计',5,'code1527312667','/crm/Report/index/id/Costdata.html',NULL,0,32),
	(423,'花费明细统计',5,'code1527410247','/crm/Report/index/id/Ds_channelcost.html',NULL,0,33),
	(424,'深挖员工数据统计',5,'code1527744704','/crm/Report/index/id/Sw_cd_customer.html',NULL,0,32),
	(425,'渠道向集团汇报报表',5,'code1528164320','/crm/Report/index/id/Brandclass_report_to_company.html',NULL,0,35),
	(426,'电商部集团报表',5,'code1528202261','/crm/Report/index/id/Ds_data.html',NULL,0,36),
	(427,'网销漏斗统计',5,'code1528767818','/crm/Report/index/id/Wx_ld.html',NULL,0,37),
	(428,'网销小组进店新单统计',5,'code1528788812','/crm/Report/index/id/Wx_group_data.html',NULL,0,38),
	(429,'网销地域统计',5,'code1528805903','/crm/Report/index/id/Wx_region.html',NULL,0,39),
	(430,'各店24小时pk表',5,'code1528853294','/crm/Report/index/id/Shop_pk.html',NULL,0,40),
	(431,'渠道毛客资透视',5,'code1528867761','/crm/Report/index/id/Ds_qd_mkz.html',NULL,0,41),
	(432,'关键词分析',5,'code1528883250','/crm/Report/index/id/Keywords.html',NULL,0,42),
	(433,'电商部渠道漏斗月走势',5,'code1528891617','/crm/Report/index/id/Ds_qd_month.html',NULL,0,43),
	(434,'电商有效客资透视',5,'code1528941567','/crm/Report/index/id/Ds_region_ts.html',NULL,0,44),
	(440,'电商渠道漏斗',5,'code1529029231','/crm/report/index/id/Ds_channel_ld.html',NULL,0,45),
	(441,'电商地域漏斗',5,'code1529030534','/crm/report/index/id/Ds_region_ld.html',NULL,0,46),
	(449,'批量有效',61,'menu1529401205','/crm/Customer//crm/Customer/customerMoreValid',NULL,0,7),
	(450,'批量无效',61,'menu1529401206','/crm/Customer//crm/Customer/customerMoreUnValid',NULL,0,8),
	(452,'查看小组客资',61,'menu1529653231','',NULL,0,10),
	(453,'回收站',61,'menu1529995330','/crm/Customer/customerBack',NULL,0,9),
	(454,'查看小组客资',61,'menu1529653231','',NULL,0,10),
	(455,'回收站',61,'menu1529995330','/crm/Customer/customerBack',NULL,0,9),
	(456,'客资审核',61,'menu1531379209','/crm/Customer/customerExamine',NULL,0,10),
	(457,'查看部门客资',61,'menu1531471639','',NULL,0,11),
	(458,'客资转移',61,'menu1532333135','',NULL,0,11),
	(459,'客资转移',61,'menu1532333135','',NULL,0,11),
	(462,'客资转移',61,'menu1532333135','',NULL,0,11),
	(463,'客资姓名修改',61,'menu1533803338','',NULL,0,11),
	(465,'查看小组客资',61,'menu1529653231','',NULL,0,10),
	(466,'回收站',61,'menu1529995330','/crm/Customer/customerBack',NULL,0,9),
	(467,'客资审核',61,'menu1531379209','/crm/Customer/customerExamine',NULL,0,10),
	(468,'查看部门客资',61,'menu1531471639','',NULL,0,11),
	(469,'客资转移',61,'menu1532333135','',NULL,0,11),
	(471,'删除小组',74,'menu1535542292','',NULL,0,15),
	(472,'批量有效',61,'menu1529401205','/crm/Customer//crm/Customer/customerMoreValid',NULL,0,7),
	(473,'批量无效',61,'menu1529401206','/crm/Customer//crm/Customer/customerMoreUnValid',NULL,0,8),
	(474,'坐席监控',70,'menu1537587731','',NULL,0,3),
	(475,'客资分配日志',9,'menu1537322380','/crm/Logs/fplogs',NULL,1,1),
	(476,'网销签到信息',9,'menu1538119117','',NULL,0,1),
	(477,'手机修改日志',9,'menu1538103712','/crm/Logs/telLogs',NULL,1,1),
	(478,'客资操作日志',9,'menu1538103743','/crm/Logs/customerLogs',NULL,1,1),
	(479,'设定日志',9,'menu1538103771','/crm/Logs/settingLogs',NULL,1,1),
	(482,'客资提醒查询',9,'menu1538103331','/crm/Logs/remindLogs',NULL,1,1),
	(483,'关键字修改',61,'menu1539573890','',NULL,0,20),
	(484,'提报表单设定',6,'menu1540363547','/crm/Setting/third',NULL,1,30),
	(485,'选项卡-过期客资',34,'menu1540550148','',NULL,1,17),
	(486,'客资再分配',61,'menu1541663886','',NULL,1,8),
	(487,'排程设定',6,'menu1542112060','/crm/Setting/pcSet',NULL,1,35),
	(2000,'门店电务',0,'menu1542196943','','fa-home',1,7),
	(2001,'排程',2000,'menu1542196979','/erp/Erp/childArrange','',1,1),
	(2002,'体验拍',2000,'menu1542197015','/erp/Erp/mark',NULL,1,2),
	(2003,'客资再分配',61,'menu1541663886','','',1,8),
	(2004,'客资再分配',61,'menu1541663886','','',1,8),
	(2005,'客资再分配',61,'menu1541663886','','',1,8),
	(2006,'客资再分配',61,'menu1541663886','','',1,8),
	(2007,'客资再分配',61,'menu1541663886','','',1,8),
	(2008,'订单转移',61,'menu1512977628','','',0,11),
	(2009,'离职交接',61,'menu1532333136','','',0,12),
	(2010,'广告信息录入',8,'menu1544608169','/crm/Setting/anotherSetting',NULL,1,110),
	(2011,'右键-标记有效',2,'menu1546854995','/crm/signValid','',0,30),
	(2012,'查看一年内客资',34,'menu1546854888','','',0,3),
	(2013,'奖金标记',61,'menu1546854777','','',0,22),
	(2018,'预约客资查询',134,'menu1551495428','/crm/Customer/yjdSearch','',1,0);

/*!40000 ALTER TABLE `s_menu` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table s_message_templateinfo
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_message_templateinfo`;

CREATE TABLE `s_message_templateinfo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `mtempalte_name` varchar(50) DEFAULT NULL,
  `mtempalte_content` varchar(3000) DEFAULT NULL,
  `outsex` int(11) DEFAULT NULL,
  `shop_name` varchar(100) DEFAULT NULL,
  `shop_code` varchar(100) DEFAULT NULL,
  `setkey` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



# Dump of table s_passwordset
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_passwordset`;

CREATE TABLE `s_passwordset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `default_pwd` varchar(100) COLLATE utf8_unicode_ci DEFAULT '8888',
  `letter` tinyint(1) DEFAULT '1',
  `num` tinyint(1) DEFAULT '1',
  `special_char` tinyint(1) DEFAULT '1',
  `length` int(11) DEFAULT NULL,
  `error_num` int(5) DEFAULT NULL,
  `invalid_time` int(5) DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

LOCK TABLES `s_passwordset` WRITE;
/*!40000 ALTER TABLE `s_passwordset` DISABLE KEYS */;

INSERT INTO `s_passwordset` (`id`, `default_pwd`, `letter`, `num`, `special_char`, `length`, `error_num`, `invalid_time`, `create_time`, `update_time`)
VALUES
	(1,'1',2,2,2,1,0,0,'2023-03-26 09:19:26',NULL),
	(2,NULL,2,2,2,NULL,NULL,NULL,'2023-03-09 11:06:21',NULL),
	(3,NULL,2,2,2,NULL,NULL,NULL,'2023-03-09 11:06:40',NULL);

/*!40000 ALTER TABLE `s_passwordset` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table s_photo_address
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_photo_address`;

CREATE TABLE `s_photo_address` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `photoAddress` varchar(100) DEFAULT NULL,
  `shop_name` varchar(100) DEFAULT NULL,
  `setkey` varchar(100) DEFAULT NULL,
  `shop_code` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



# Dump of table s_position_change
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_position_change`;

CREATE TABLE `s_position_change` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staffname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `entry_date` datetime DEFAULT NULL COMMENT '入职时间',
  `before_brandclass_id` int(11) DEFAULT NULL,
  `before_brandclass` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `before_shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `before_shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `before_department_id` int(11) DEFAULT NULL COMMENT '之前部门id',
  `before_department_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `before_position_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `before_position_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `before_zhiji_id` int(11) DEFAULT NULL,
  `before_zhiji_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `before_basic_pay` decimal(10,2) DEFAULT NULL COMMENT '之前基本工资',
  `before_merit_pay` decimal(10,2) DEFAULT NULL COMMENT '之前绩效工资',
  `brandclass_id` int(11) DEFAULT NULL,
  `brandclass` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `department_id` int(11) DEFAULT NULL,
  `department_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `main_position_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `main_position_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `zhiji_id` int(11) DEFAULT NULL,
  `zhiji_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `basic_pay` decimal(10,2) DEFAULT NULL,
  `merit_pay` decimal(10,2) DEFAULT NULL,
  `reason` text COLLATE utf8_unicode_ci COMMENT '调动原因',
  `update_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

LOCK TABLES `s_position_change` WRITE;
/*!40000 ALTER TABLE `s_position_change` DISABLE KEYS */;

INSERT INTO `s_position_change` (`id`, `staffname`, `entry_date`, `before_brandclass_id`, `before_brandclass`, `before_shop_code`, `before_shop_name`, `before_department_id`, `before_department_name`, `before_position_code`, `before_position_name`, `before_zhiji_id`, `before_zhiji_name`, `before_basic_pay`, `before_merit_pay`, `brandclass_id`, `brandclass`, `shop_code`, `shop_name`, `department_id`, `department_name`, `main_position_code`, `main_position_name`, `zhiji_id`, `zhiji_name`, `basic_pay`, `merit_pay`, `reason`, `update_time`)
VALUES
	(1,'刘艳喜',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'时尚经典事业部','VVC009','时尚经典渠道部',3,'渠道部','p15169102452235','渠道主管',NULL,NULL,NULL,NULL,'能力有限',NULL),
	(8,'刘艳喜',NULL,1,'时尚经典事业部','VVC009','时尚经典渠道部',3,'渠道部','p15169808544390','',NULL,NULL,NULL,NULL,1,'时尚经典事业部','VVC009','时尚经典渠道部',3,'渠道部','p15169102452235','渠道主管',NULL,NULL,NULL,NULL,'能力有限','2018-06-27 17:42:09'),
	(9,'刘艳喜',NULL,1,'时尚经典事业部','VVC009','时尚经典渠道部',3,'渠道部','p15169102452235','渠道主管',NULL,NULL,NULL,NULL,1,'时尚经典事业部','VVC001','时尚经典旗舰店',4,'门市部','p15169793315051','门市经理',NULL,NULL,NULL,NULL,'试试','2018-06-28 19:36:28'),
	(10,'刘艳喜',NULL,1,'时尚经典事业部','VVC001','时尚经典旗舰店',4,'门市部','p15169793315051','门市经理',NULL,NULL,NULL,NULL,3,'沈阳巴黎婚纱','BLHSDS001','沈阳巴黎婚纱电商部',76,'电商部','p15216267952598','电商经理',NULL,NULL,NULL,NULL,'','2018-06-28 20:19:26'),
	(11,'刘艳喜',NULL,3,'沈阳巴黎婚纱','BLHSDS001','沈阳巴黎婚纱电商部',76,'电商部','p15216267952598','电商经理',NULL,NULL,NULL,NULL,1,'时尚经典事业部','VVC001','时尚经典旗舰店',5,'礼服部','p15169793949498','礼服经理',NULL,NULL,NULL,NULL,'','2018-06-28 20:23:01'),
	(12,'刘艳喜',NULL,1,'时尚经典事业部','VVC001','时尚经典旗舰店',5,'礼服部','p15169793949498','礼服经理',NULL,NULL,NULL,NULL,1,'时尚经典事业部','VVC001','时尚经典旗舰店',8,'数码部','p15169852895308','数码样后修调师',NULL,NULL,NULL,NULL,'','2018-06-28 20:28:23'),
	(13,'刘艳喜',NULL,1,'时尚经典事业部','VVC001','时尚经典旗舰店',8,'数码部','p15169852895308','数码样后修调师',NULL,NULL,NULL,NULL,1,'时尚经典事业部','VVC001','时尚经典旗舰店',18,'财务部','p15169814002223','收银',NULL,NULL,NULL,NULL,'','2018-06-28 20:30:11'),
	(14,'刘艳喜',NULL,1,'时尚经典事业部','VVC001','时尚经典旗舰店',18,'财务部','p15169814002223','收银',NULL,NULL,NULL,NULL,1,'时尚经典事业部','VVC001','时尚经典旗舰店',18,'财务部','p15169814002223','收银',NULL,NULL,NULL,NULL,'','2018-06-28 20:42:23'),
	(15,'刘艳喜',NULL,1,'时尚经典事业部','VVC001','时尚经典旗舰店',18,'财务部','p15169814002223','收银',NULL,NULL,NULL,NULL,1,'时尚经典事业部','VVC001','时尚经典旗舰店',6,'看样部','p15169795275440','看样经理',NULL,NULL,NULL,NULL,'','2018-06-28 20:54:44'),
	(16,'刘艳喜',NULL,1,'时尚经典事业部','VVC001','时尚经典旗舰店',6,'看样部','p15169795275440','看样经理',NULL,NULL,NULL,NULL,1,'时尚经典事业部','VVC001','时尚经典旗舰店',4,'门市部','p15169793587099','门市主管',NULL,NULL,NULL,NULL,'','2018-06-28 22:01:08'),
	(17,'刘艳喜',NULL,1,'时尚经典事业部','VVC001','时尚经典旗舰店',4,'门市部','p15169793587099','门市主管',NULL,NULL,NULL,NULL,1,'时尚经典事业部','VVC001','时尚经典旗舰店',7,'取件部','p15169796049042','取件主管',NULL,NULL,NULL,NULL,'','2018-06-28 22:05:48'),
	(18,'刘艳喜',NULL,1,'时尚经典事业部','VVC001','时尚经典旗舰店',7,'取件部','p15169796049042','取件主管',NULL,NULL,NULL,NULL,1,'时尚经典事业部','VVC001','时尚经典旗舰店',5,'礼服部','p15169793949498','礼服经理',NULL,NULL,NULL,NULL,'','2018-07-18 16:00:23'),
	(19,'刘艳喜',NULL,0,'','','',0,'','','',NULL,NULL,NULL,NULL,NULL,'0','0','0',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'','2023-02-24 15:10:50');

/*!40000 ALTER TABLE `s_position_change` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table s_position_menu
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_position_menu`;

CREATE TABLE `s_position_menu` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `position_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '岗位唯一标识',
  `menu_code` text COLLATE utf8_unicode_ci,
  `menu_url` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '功能菜单url',
  `status` tinyint(2) DEFAULT NULL COMMENT '状态，1是显示，2不显示',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table s_positionset
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_positionset`;

CREATE TABLE `s_positionset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `position_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '岗位名称',
  `position_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '岗位唯一标识',
  `grade_type` tinyint(4) DEFAULT NULL COMMENT '1集团，2品牌，3店面，4部门',
  `group_company_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '集团名称',
  `brandclass` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '品牌名称',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '所属店面名称',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '所属店面识别码',
  `department_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '部门名称',
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '设定店面识别码',
  `work_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '工作类型，用逗号隔开',
  `department_id` int(11) DEFAULT NULL,
  `groupId` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'mc权限组',
  `brandclass_id` int(11) DEFAULT NULL,
  `zhiji_id` int(11) DEFAULT NULL COMMENT '职级id',
  `zhiji_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '职级名称',
  `superior_position_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `superior_position_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='岗位设定';



# Dump of table s_professor
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_professor`;

CREATE TABLE `s_professor` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `professor_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

LOCK TABLES `s_professor` WRITE;
/*!40000 ALTER TABLE `s_professor` DISABLE KEYS */;

INSERT INTO `s_professor` (`id`, `professor_name`)
VALUES
	(1,'老师');

/*!40000 ALTER TABLE `s_professor` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table s_qr_login
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_qr_login`;

CREATE TABLE `s_qr_login` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `qr_code` varchar(200) COLLATE utf8_bin DEFAULT NULL COMMENT '生成的二维码唯一编码',
  `qr_expire` datetime DEFAULT NULL COMMENT '生成的二维码过期时间，二维码过期后，需要重新获取',
  `staff_id` int(11) DEFAULT NULL COMMENT '对应是哪个员工',
  `login_time` datetime DEFAULT NULL COMMENT '确认登录时间',
  `login_system` varchar(50) COLLATE utf8_bin DEFAULT NULL COMMENT '从哪个系统请求的登录',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='二唯码登录表';



# Dump of table s_recruitment_apply
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_recruitment_apply`;

CREATE TABLE `s_recruitment_apply` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `position_name` varchar(100) CHARACTER SET utf8 DEFAULT NULL COMMENT '岗位名称',
  `position_code` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '岗位唯一标识',
  `grade_type` tinyint(4) DEFAULT NULL COMMENT '1集团，2品牌，3店面，4部门',
  `group_company_name` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '集团名称',
  `brandclass_id` int(11) DEFAULT NULL,
  `brandclass` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '品牌名称',
  `shop_name` varchar(100) CHARACTER SET utf8 DEFAULT NULL COMMENT '所属店面名称',
  `shop_code` varchar(100) CHARACTER SET utf8 DEFAULT NULL COMMENT '所属店面识别码',
  `department_name` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '部门名称',
  `department_id` int(11) DEFAULT NULL,
  `work_type` varchar(50) CHARACTER SET utf8 DEFAULT NULL COMMENT '工作类型',
  `zhiji_id` int(11) DEFAULT NULL COMMENT '职级id',
  `zhiji_name` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '职级名称',
  `is_check` tinyint(4) DEFAULT NULL COMMENT '1集团，2品牌，3店面，4部门',
  `add_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COMMENT='岗位设定';

LOCK TABLES `s_recruitment_apply` WRITE;
/*!40000 ALTER TABLE `s_recruitment_apply` DISABLE KEYS */;

INSERT INTO `s_recruitment_apply` (`id`, `position_name`, `position_code`, `grade_type`, `group_company_name`, `brandclass_id`, `brandclass`, `shop_name`, `shop_code`, `department_name`, `department_id`, `work_type`, `zhiji_id`, `zhiji_name`, `is_check`, `add_time`)
VALUES
	(1,'摄像',NULL,4,'中国沈阳时尚经典婚纱摄影集团',1,'时尚经典事业部','时尚经典旗舰店','VVC001','门市部',4,'1',5,'副经理',NULL,'2023-02-24 14:28:08');

/*!40000 ALTER TABLE `s_recruitment_apply` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table s_regionset
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_regionset`;

CREATE TABLE `s_regionset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `region_name` varchar(100) CHARACTER SET utf8 DEFAULT NULL,
  `shop_name` varchar(100) CHARACTER SET utf8 DEFAULT NULL,
  `shop_code` varchar(100) CHARACTER SET utf8 DEFAULT NULL,
  `setkey` varchar(100) CHARACTER SET utf8 DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COMMENT='客户地域';



# Dump of table s_roleset
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_roleset`;

CREATE TABLE `s_roleset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rolename` varchar(50) DEFAULT NULL,
  `pid` int(11) DEFAULT NULL,
  `functionId` varchar(1000) DEFAULT NULL,
  `coderkey` varchar(20) DEFAULT NULL,
  `setkey` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



# Dump of table s_sales_routines
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_sales_routines`;

CREATE TABLE `s_sales_routines` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `step_name` varchar(100) DEFAULT NULL,
  `step_content` varchar(3000) DEFAULT NULL,
  `step_stage` varchar(100) DEFAULT NULL,
  `shop_name` varchar(100) DEFAULT NULL,
  `shop_code` varchar(100) DEFAULT NULL,
  `setkey` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



# Dump of table s_school
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_school`;

CREATE TABLE `s_school` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `school_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

LOCK TABLES `s_school` WRITE;
/*!40000 ALTER TABLE `s_school` DISABLE KEYS */;

INSERT INTO `s_school` (`id`, `school_name`)
VALUES
	(1,'大学中心');

/*!40000 ALTER TABLE `s_school` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table s_shop_pay_config
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_shop_pay_config`;

CREATE TABLE `s_shop_pay_config` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `config_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `appid` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `secret` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `enable` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table s_shopset
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_shopset`;

CREATE TABLE `s_shopset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `brandclass` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '集团品牌',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '所属店面名称',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '所属店面识别码',
  `sn` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '店面简码',
  `numberorder` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '订单号规则',
  `shopaddress` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '店面地址',
  `receiv_shop_code` varchar(3000) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '可收款店面码',
  `is_dig` tinyint(4) DEFAULT '2' COMMENT '是否深挖,1是，2否，默认为2',
  `is_marketing` tinyint(4) DEFAULT '2' COMMENT '是否为营销店，1电商店，2实体店，3网销店，4渠道店',
  `is_manage` tinyint(4) DEFAULT '2' COMMENT '是否管理产品，1是 2否，默认为2',
  `is_synch` tinyint(4) DEFAULT '2' COMMENT '是否同步产品，1是 2否，默认为2',
  `is_switch` tinyint(4) DEFAULT '2' COMMENT '是否开启自动分配，1开启，2关闭，默认为2',
  `wx_public` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '微信公众号',
  `wx_appid` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `wx_secret` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '第三方用户唯一凭证密钥，即appsecret',
  `sms_config` int(11) DEFAULT NULL COMMENT '短信配置key(JSON内的一维KEY)',
  `is_op1` int(11) DEFAULT NULL COMMENT '显示排序',
  `is_op2` int(11) DEFAULT NULL COMMENT '是否接单店，1是，0不是',
  `is_op3` int(11) DEFAULT NULL COMMENT '是否选片店，1是，0不是',
  `is_op4` int(11) DEFAULT NULL COMMENT '是否取件店，1是，0不是',
  `number_rule` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `belong_shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `belong_shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_type` tinyint(2) DEFAULT NULL COMMENT '店面类型，1婚纱，2儿童，3旅拍，4艺术，5其他',
  `is_sk` tinyint(2) DEFAULT NULL,
  `is_group` tinyint(2) DEFAULT NULL COMMENT '是否集团店，1是，2不是',
  `weight` decimal(5,0) NOT NULL DEFAULT '1' COMMENT '店面加权系数',
  `end_date` datetime DEFAULT NULL,
  `wx_mch_id` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  `wx_pay_key` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  `is_photo` tinyint(4) DEFAULT '2',
  `brandclass_id` int(11) DEFAULT NULL,
  `group_company_name` varchar(200) COLLATE utf8_unicode_ci DEFAULT '',
  `prefix_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `serial_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `province_id` int(11) DEFAULT NULL,
  `province` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `city_id` int(11) DEFAULT NULL,
  `city` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `county_id` int(11) DEFAULT NULL,
  `county` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_phone` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `is_door` tinyint(1) DEFAULT NULL,
  `wx_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `third_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `nav_url` varchar(500) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '导航URL地址',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='公司店面设定';



# Dump of table s_signature
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_signature`;

CREATE TABLE `s_signature` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `data` text COLLATE utf8_unicode_ci,
  `viewtype` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `img` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `createtime` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `updatetime` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `deletetime` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `apipathname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `contract_img` text COLLATE utf8_unicode_ci,
  `contract_pdf` text COLLATE utf8_unicode_ci,
  `user_data` text COLLATE utf8_unicode_ci,
  `openid` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mobile` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `orderid` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `brand_id` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

LOCK TABLES `s_signature` WRITE;
/*!40000 ALTER TABLE `s_signature` DISABLE KEYS */;

INSERT INTO `s_signature` (`id`, `code`, `data`, `viewtype`, `img`, `createtime`, `updatetime`, `deletetime`, `apipathname`, `contract_img`, `contract_pdf`, `user_data`, `openid`, `mobile`, `orderid`, `shop_code`, `brand_id`)
VALUES
	(1,'11','{\"storeconsuitant2\":\"\",\"storeconsuitant3\":\"\",\"total_money\":\"0.00\",\"payment_money\":\"0.00\",\"nopayment_money\":\"0.00\",\"dresstotal\":\"0.00\",\"dresspay\":\"0.00\",\"dressnonpay\":\"0.00\",\"makeuptotal\":null,\"makeuppay\":null,\"makeupnonpay\":null}','signature1','','1524744101',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0),
	(2,'123','{\"orderId\":\"S18042600001\",\"customerid\":\"27304455-361c-4f59-9306-78fc230b939d\",\"vipnum\":\"\",\"viptype\":null,\"storeconsuitant1\":\"SSS\",\"storeconsuitant2\":\"\",\"storeconsuitant3\":\"\",\"total_money\":\"0.00\",\"payment_money\":\"0.00\",\"nopayment_money\":\"0.00\",\"dresstotal\":\"0.00\"}','signature1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0),
	(3,'S6181494DG','{\"orderId\":\"S6181494DG\",\"customerid\":\"26041227-99e8-4dc5-b66a-ecd4908a9c57\",\"vipnum\":\"\",\"viptype\":null,\"storeconsuitant1\":\"乔宇奇 \",\"storeconsuitant2\":\"\",\"storeconsuitant3\":\"\",\"total_money\":\"4299.00\",\"payment_money\":\"1500.00\",\"nopayment_money\":\"2799.00\",\"dresstotal\":\"0.00\",\"dresspay\":\"0.00\",\"dressnonpay\":\"0.00\",\"makeuptotal\":\"0.00\",\"makeuppay\":\"0.00\",\"makeupnonpay\":\"0.00\"}','signature1','/pic/e3/e364b8cd4bdc45f13981b1cca0bd289a.png','1524744967',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0),
	(6,'V6180395DG','{\"orderId\":\"V6180395DG\",\"customerid\":\"04dad31f-595a-4d8c-97c7-ea39d8fd5216\",\"vipnum\":\"\",\"viptype\":null,\"storeconsuitant1\":\"李佳宁 \",\"storeconsuitant2\":\"陈诚\",\"storeconsuitant3\":\"刘扬 \",\"total_money\":\"6999.00\",\"payment_money\":\"7099.00\",\"nopayment_money\":\"-100.00\",\"dresstotal\":\"0.00\",\"dresspay\":\"0.00\",\"dressnonpay\":\"0.00\",\"makeuptotal\":\"0.00\",\"makeuppay\":\"0.00\",\"makeupnonpay\":\"0.00\"}','signature1','/pic/ae/ae5592564ea340e11901088a3d6cc2b2.png','1524745464',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0),
	(7,'Q6180076DG','{\"orderId\":\"Q6180076DG\",\"customerid\":\"fd76863e-a468-4a85-8ac3-9c524316a0bd\",\"vipnum\":\"\",\"viptype\":null,\"storeconsuitant1\":\"李孟楠\",\"storeconsuitant2\":\"刘馨遥\",\"storeconsuitant3\":\"于淼（本溪）\",\"total_money\":\"4999.00\",\"payment_money\":\"0.00\",\"nopayment_money\":\"4999.00\",\"dresstotal\":\"0.00\",\"dresspay\":\"0.00\",\"dressnonpay\":\"0.00\",\"makeuptotal\":\"0.00\",\"makeuppay\":\"0.00\",\"makeupnonpay\":\"0.00\"}','signature1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0),
	(8,'S6182212DG','{\"orderId\":\"S6182212DG\",\"customerid\":\"3b0045eb-2dbd-4a2f-b2ca-27ebc50d5e25\",\"vipnum\":\"\",\"viptype\":null,\"storeconsuitant1\":\"蔡蒙\",\"storeconsuitant2\":\"周娇\",\"storeconsuitant3\":\"刘扬 \",\"total_money\":\"4699.00\",\"payment_money\":\"4699.00\",\"nopayment_money\":\"0.00\",\"dresstotal\":\"0.00\",\"dresspay\":\"0.00\",\"dressnonpay\":\"0.00\",\"makeuptotal\":\"0.00\",\"makeuppay\":\"0.00\",\"makeupnonpay\":\"0.00\"}','signature1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0),
	(9,'SF6180252DG','{\"orderId\":\"SF6180252DG\",\"customerid\":\"acdbb186-5fe4-4844-ac13-c58da718ef47\",\"vipnum\":\"\",\"viptype\":null,\"storeconsuitant1\":\"孙玉晶\",\"storeconsuitant2\":\"\",\"storeconsuitant3\":\"\",\"total_money\":\"4999.00\",\"payment_money\":\"0.00\",\"nopayment_money\":\"4999.00\",\"dresstotal\":\"0.00\",\"dresspay\":\"0.00\",\"dressnonpay\":\"0.00\",\"makeuptotal\":\"0.00\",\"makeuppay\":\"0.00\",\"makeupnonpay\":\"0.00\"}','signature1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0),
	(10,'cc234','11','signature1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0),
	(11,'nnn20190524001','4535','vipcard',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0),
	(12,'20190525002','2','vipcard',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0),
	(13,'20190525004','2','vipcard',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0),
	(14,'SS190708008',NULL,'signature1','/pic/94/943a4d69df4841bde6ac1556cb408c48.png',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0),
	(15,'test2019072201','q','signsp',NULL,'1563772737',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0),
	(16,'test2019072202','q','signphotobefor','/pic/2c/2c1e6f8dcf29255304fbd6cf6a76c6c0.png','1564399023',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0),
	(17,'test2019072203',NULL,'signphotoafter',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0),
	(18,'1aa953ec-273b-4101-90f7-35aaab632d8f','{\"Storeconsuitant1\":\"小飞\",\"Mphone\":\"14321312312\",\"Mname\":\"veve\",\"Wphone\":\"\",\"Wname\":\"\",\"OrderId\":\"SY190802000001\",\"Targetdate\":\"20190802\",\"Scenespro\":[{\"Top3\":\"http://mc.erp.suxuantech.cn/public/uploads/1f/06/1f061228bf1a9c5d43f3cb33e0271a03.jpg\",\"Top2\":\"星光花园\",\"Top1\":\"内景\"},{\"Top3\":\"http://mc.erp.suxuantech.cn/public/uploads/e6/c7/e6c7c3e0ee45c9245a6f09cb975182ef.jpg\",\"Top2\":\"环球大教堂\",\"Top1\":\"内景\"},{\"Top3\":\"http://mc.erp.suxuantech.cn/public/uploads/1f/3c/1f3c82ca7541e392ce9e701e6f747019.jpg\",\"Top2\":\"古堡花园\",\"Top1\":\"外景\"},{\"Top3\":\"http://mc.erp.suxuantech.cn/public/uploads/84/51/8451a7c4c5fbc52968d6d021c7342928.jpg\",\"Top2\":\"爱之音符\",\"Top1\":\"外景\"}],\"Zqevaluatepro\":[{\"Top3\":\",有化妆过敏史,\",\"Top2\":\"有化妆过敏史,无化妆过敏史\",\"Top1\":\"特殊肤质\"},{\"Top3\":\",过敏,痤疮,\",\"Top2\":\"较光滑,有粉刺,痤疮,有红点,过敏\",\"Top1\":\"脸部现状\"},{\"Top3\":\",简洁素雅,主题拍摄,黑白主义,剧情演绎,没意见,\",\"Top2\":\"简洁素雅,主题拍摄,新派创意,画意唯美,黑白主义,剧情演绎,其它,没意见\",\"Top1\":\"风格\"}],\"Syevaluatepro\":[{\"Top3\":\",微笑,含蓄不笑,\",\"Top2\":\"开心,微笑,含蓄不笑\",\"Top1\":\"希望表情\"},{\"Top3\":\",稍偏左,稍偏右,俯拍,仰拍,阿萨德,\",\"Top2\":\"稍偏左,稍偏右,仰拍,俯拍,正面,侧面,都可以,阿萨德\",\"Top1\":\"拍摄角度(测试脸型)\"}],\"Fgevaluatepro\":[{\"Top3\":\",特写,半身,全身,七分身,\",\"Top2\":\"特写,半身,七分身,全身,随意发挥\",\"Top1\":\"构图\"}]}','signphotobefore',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0),
	(19,'test20190806001','{\"Storeconsuitant1\":\"小飞\",\"Mphone\":\"14321312312\",\"Mname\":\"veve\",\"Wphone\":\"\",\"Wname\":\"\",\"OrderId\":\"SY190802000001\",\"Targetdate\":\"20190802\",\"Scenespro\":[{\"Top3\":\"http://mc.erp.suxuantech.cn/public/uploads/1f/06/1f061228bf1a9c5d43f3cb33e0271a03.jpg\",\"Top2\":\"星光花园\",\"Top1\":\"内景\"},{\"Top3\":\"http://mc.erp.suxuantech.cn/public/uploads/e6/c7/e6c7c3e0ee45c9245a6f09cb975182ef.jpg\",\"Top2\":\"环球大教堂\",\"Top1\":\"内景\"},{\"Top3\":\"http://mc.erp.suxuantech.cn/public/uploads/1f/3c/1f3c82ca7541e392ce9e701e6f747019.jpg\",\"Top2\":\"古堡花园\",\"Top1\":\"外景\"},{\"Top3\":\"http://mc.erp.suxuantech.cn/public/uploads/84/51/8451a7c4c5fbc52968d6d021c7342928.jpg\",\"Top2\":\"爱之音符\",\"Top1\":\"外景\"}],\"Zqevaluatepro\":[{\"Top3\":\",有化妆过敏史,\",\"Top2\":\"有化妆过敏史,无化妆过敏史\",\"Top1\":\"特殊肤质\"},{\"Top3\":\",过敏,痤疮,\",\"Top2\":\"较光滑,有粉刺,痤疮,有红点,过敏\",\"Top1\":\"脸部现状\"},{\"Top3\":\",简洁素雅,主题拍摄,黑白主义,剧情演绎,没意见,\",\"Top2\":\"简洁素雅,主题拍摄,新派创意,画意唯美,黑白主义,剧情演绎,其它,没意见\",\"Top1\":\"风格\"}],\"Syevaluatepro\":[{\"Top3\":\",微笑,含蓄不笑,\",\"Top2\":\"开心,微笑,含蓄不笑\",\"Top1\":\"希望表情\"},{\"Top3\":\",稍偏左,稍偏右,俯拍,仰拍,阿萨德,\",\"Top2\":\"稍偏左,稍偏右,仰拍,俯拍,正面,侧面,都可以,阿萨德\",\"Top1\":\"拍摄角度(测试脸型)\"}],\"Fgevaluatepro\":[{\"Top3\":\",特写,半身,全身,七分身,\",\"Top2\":\"特写,半身,七分身,全身,随意发挥\",\"Top1\":\"构图\"}]}','signphotoafter',NULL,'1565094666',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0),
	(20,'test20190813','1','signature1',NULL,'1565673169',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0),
	(21,'ES230419003___11','{\"img\":\"http://mc.erp.suxuantech.cn/public/uploads/fd/cb/fdcbfa0fdcf3fb6a771283db66bcf8df.jpg\",\"phone\":\"13041139590\"}','signatureimg',NULL,'1681884491','1681891128',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0),
	(22,'ES230421001___1','{\"img\":\"/uploads/55/15/55150c9719075b604831dff91a25f32b.jpg\",\"phone\":\"13041139590\"}','signatureimg',NULL,'1682040982','1682042917',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0),
	(23,'ES230421001___11','{\"img\":\"/uploads/ea/a0/eaa0798a9897ab95c1e160ad43648698.jpg\",\"phone\":\"13041139590\"}','signatureimg',NULL,'1682041637','1682070024',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0),
	(24,'ES230421001___15','{\"img\":\"/uploads/24/19/2419e95ed081089c2931b81b1f484d51.jpg\",\"phone\":\"13041139590\"}','signatureimg',NULL,'1682047338',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0),
	(25,'ES230421002___11','{\"img\":\"/uploads/21/9d/219d88c023d67842dff321e8d3545531.jpg\",\"phone\":\"13041139590\"}','signatureimg',NULL,'1682053409','1682053414',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0),
	(26,'ES230421003___11','{\"img\":\"/uploads/39/94/39946dce95c8a90fd24e7e0696f46f88.jpg\",\"phone\":\"13041139590\"}','signatureimg',NULL,'1682059466',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0),
	(27,'ES230421004___11','{\"img\":\"/uploads/89/9c/899ca43632fe9ce8540d085307563940.jpg\",\"phone\":\"13651009711\"}','signatureimg',NULL,'1682060719',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0),
	(28,'ES230421004___1','{\"img\":\"/uploads/b1/ac/b1ac8fb829bb327128677276a9f6e44a.jpg\",\"phone\":\"13651009711\"}','signatureimg',NULL,'1682062237',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0),
	(29,'ES230425001___11','{\"img\":\"/uploads/2d/55/2d555d3eb82fc5840faf85c30245da94.jpg\",\"phone\":\"13041139590\"}','signatureimg',NULL,'1682387611','1682388139',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0),
	(30,'ES230425001___0','{\"img\":\"/uploads/79/60/7960e8a169a4e120d1fdcb431e2d5714.jpg\",\"phone\":\"13041139590\"}','signatureimg',NULL,'1682410648',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0),
	(31,'ES230427001___11','{\"img\":\"/uploads/69/a5/69a52cc9de7c48743e81a8fbb19813a5.jpg\",\"phone\":\"13041139590\"}','signatureimg',NULL,'1682566412','1682566437',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0),
	(32,'ES230427001___3','{\"img\":\"/uploads/d5/72/d5723c7e4f5578da753d3c31ffed7351.jpg\",\"phone\":\"13041139590\"}','signatureimg',NULL,'1682566498',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0),
	(33,'ES230427001___0','{\"img\":\"/uploads/58/5e/585e55fb8f13394d64cfb0d1c15f106e.jpg\",\"phone\":\"13041139590\"}','signatureimg',NULL,'1682573123','1682573360',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0),
	(34,'ES230418002___11','{\"img\":\"/uploads/91/e6/91e645355f02595935fb7f6f893e5303.jpg\",\"phone\":\"18501043684\"}','signatureimg',NULL,'1682645666','1682646118',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0),
	(35,'ES230428001___11','{\"img\":\"/uploads/82/f8/82f8fd669b8307f38dcbf4b31f545cfa.jpg\",\"phone\":\"13077777777\"}','signatureimg',NULL,'1682663526',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0),
	(36,'ES230428001___1','{\"img\":\"/uploads/18/b6/18b6458f1c74e5435827c3853e147119.jpg\",\"phone\":\"13077777777\"}','signatureimg',NULL,'1682663575',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0),
	(37,'ES230419005___11','{\"img\":\"/uploads/60/ca/60cae25f0e602b1bec85128b17fd2c25.jpg\",\"phone\":\"13088888888\"}','signatureimg',NULL,'1683191555',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0),
	(38,'ES230419005___1','{\"img\":\"/uploads/c7/46/c746b6141037202ca3205dc6370624ef.jpg\",\"phone\":\"13088888888\"}','signatureimg',NULL,'1683191715',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0),
	(39,'ES230505001___11','{\"img\":\"/uploads/c1/9a/c19acd8fa187e95e4f5a390fc2cda579.jpg\",\"phone\":\"15224992744\"}','signatureimg',NULL,'1683336701','1683336804',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0),
	(40,'ES230511001___11','{\"img\":\"/uploads/a1/be/a1beaafa21ba96c9c9e7bcb1c72f2860.jpg\",\"phone\":\"18501043684\"}','signatureimg',NULL,'1683778506',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0),
	(41,'ES230418001___0','{\"img\":\"/uploads/e9/c4/e9c4aa3dfb22adebbac4206f0a58c2d3.jpg\",\"phone\":\"18501043684\"}','signatureimg',NULL,'1683789021',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0),
	(42,'ES230419001___11','{\"img\":\"/uploads/ce/ee/ceeeee51d0620fda85b25e3b5493bb4a.jpg\",\"phone\":\"18810003398\"}','signatureimg',NULL,'1685535019','1685599857',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'yshs',0),
	(43,'ES230418001___11','{\"img\":\"/uploads/3b/8f/3b8f0960ec9784cf68633ea2dc08f8c1.jpg\",\"phone\":\"18501043684\"}','signatureimg',NULL,'1685960749',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'yshs',0),
	(44,'ES230419001___12','{\"img\":\"/uploads/ac/21/ac21d875fd1a139d4e8fd2e0b31aef43.jpg\",\"phone\":\"18810003398\"}','signatureimg',NULL,'1686391219','1686558815',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'yshs',0);

/*!40000 ALTER TABLE `s_signature` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table s_staff_import
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_staff_import`;

CREATE TABLE `s_staff_import` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `file_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '上传文件名',
  `file_url` varchar(300) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fail_file_url` varchar(300) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '错误文件地址',
  `staff_id` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '员工编号',
  `staff_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '员工姓名',
  `addtime` datetime DEFAULT NULL COMMENT '导入时间',
  `status` tinyint(2) DEFAULT '0' COMMENT '导入状态，0未导入，1已导入，2正在导入，默认为0',
  `all_number` int(11) DEFAULT '0' COMMENT '数据总条数',
  `import_fail` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='导入记录表';

LOCK TABLES `s_staff_import` WRITE;
/*!40000 ALTER TABLE `s_staff_import` DISABLE KEYS */;

INSERT INTO `s_staff_import` (`id`, `file_name`, `file_url`, `fail_file_url`, `staff_id`, `staff_name`, `addtime`, `status`, `all_number`, `import_fail`)
VALUES
	(1,'staff_default (1).xlsx','/data/www/dev/mc-erds/public/data/excel/20230419/90a717473a787315a649beb4e26fb965.xlsx',NULL,'1','root','2023-04-19 16:53:43',0,1,NULL);

/*!40000 ALTER TABLE `s_staff_import` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table s_staff_import_data
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_staff_import_data`;

CREATE TABLE `s_staff_import_data` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `import_id` int(11) unsigned NOT NULL,
  `staff_sn` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `staffname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `password` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `turestaffname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `department_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `position_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `group_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `work_type` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `entry_date` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `leave_date` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sex` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  `IDcard` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `birthday` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `telephone` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `addressinfo` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `place_origin` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `education` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `marital_status` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `brandclass` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `email` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `weixin` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ext_1` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ext_2` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ext_3` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ext_4` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ext_5` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ext_6` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ext_7` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ext_8` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ext_9` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ext_10` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` int(11) DEFAULT '0',
  `msg` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

LOCK TABLES `s_staff_import_data` WRITE;
/*!40000 ALTER TABLE `s_staff_import_data` DISABLE KEYS */;

INSERT INTO `s_staff_import_data` (`id`, `import_id`, `staff_sn`, `staffname`, `password`, `turestaffname`, `shop_name`, `department_name`, `position_name`, `group_name`, `work_type`, `entry_date`, `leave_date`, `sex`, `IDcard`, `birthday`, `telephone`, `addressinfo`, `place_origin`, `education`, `marital_status`, `brandclass`, `email`, `weixin`, `ext_1`, `ext_2`, `ext_3`, `ext_4`, `ext_5`, `ext_6`, `ext_7`, `ext_8`, `ext_9`, `ext_10`, `status`, `msg`)
VALUES
	(1,1,'','test','','张三','sx002','导入部门','导入专员','','门市','','','','','','','','','','','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'');

/*!40000 ALTER TABLE `s_staff_import_data` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table s_staff_login
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_staff_login`;

CREATE TABLE `s_staff_login` (
  `staff_id` int(11) DEFAULT NULL,
  `session_id` varchar(100) NOT NULL,
  `status` tinyint(4) DEFAULT NULL,
  `expire_time` datetime DEFAULT NULL,
  PRIMARY KEY (`session_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



# Dump of table s_staff_session
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_staff_session`;

CREATE TABLE `s_staff_session` (
  `staff_id` int(11) NOT NULL,
  `session_id` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `ip` varchar(16) COLLATE utf8_unicode_ci NOT NULL,
  `login_type` varchar(20) COLLATE utf8_unicode_ci NOT NULL COMMENT '登录类型',
  `login_method` varchar(30) COLLATE utf8_unicode_ci NOT NULL COMMENT '登录方式',
  `logout_time` datetime DEFAULT NULL COMMENT '退出登录时间',
  `expiry` datetime NOT NULL COMMENT 'session过期时间',
  `status` tinyint(4) DEFAULT '1' COMMENT '登录状态:1:正常，2：忙碌',
  `token` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mobile_code` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `jpush_rid` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='mc session表';



# Dump of table s_staffgroup
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_staffgroup`;

CREATE TABLE `s_staffgroup` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `group_name` varchar(100) CHARACTER SET utf8 DEFAULT NULL COMMENT '组别名称',
  `shop_name` varchar(100) CHARACTER SET utf8 DEFAULT NULL COMMENT '所属店面名称',
  `shop_code` varchar(100) CHARACTER SET utf8 DEFAULT NULL COMMENT '所属店面识别码',
  `setkey` varchar(100) CHARACTER SET utf8 DEFAULT NULL COMMENT '设定店面识别码',
  `brandclass_id` int(11) DEFAULT NULL,
  `brandclass` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `department_id` int(11) DEFAULT NULL,
  `department_name` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COMMENT='分组名称设定';



# Dump of table s_staffinfo
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_staffinfo`;

CREATE TABLE `s_staffinfo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staffnumber` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '员工编号',
  `staffname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '员工名',
  `password` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `department_id` int(11) DEFAULT NULL COMMENT '部门id',
  `department_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '部门',
  `main_position_id` int(11) DEFAULT NULL COMMENT '主岗位',
  `main_position_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '主岗位名称',
  `main_position_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '主岗位唯一标识',
  `position_id` text COLLATE utf8_unicode_ci,
  `position_code` text COLLATE utf8_unicode_ci COMMENT '岗位唯一标识',
  `zhiji_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '职级',
  `turestaffname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '真实姓名',
  `group_company_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '集团名称',
  `brandclass` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '品牌名称',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '店面名称',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '店面编码',
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `group_id` int(11) DEFAULT '0' COMMENT '小组id',
  `group_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '组名',
  `group_admin` text COLLATE utf8_unicode_ci,
  `sex` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '性别',
  `entry_date` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '入职时间',
  `leave_date` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '离职时间',
  `birthday` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '生日',
  `IDcard` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '身份证',
  `nation` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '国家',
  `place_origin` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '出生地',
  `political` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '政治身份',
  `education` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '教育程度',
  `graduation_school` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '毕业学校',
  `marital_status` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '婚姻状况',
  `contract_endday` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '合同结束时间',
  `telephone` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '电话号',
  `QQ` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `email` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `weixin` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `a_discount` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '一期折扣',
  `b_discount` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '二期折扣',
  `a_cost` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '一期成本',
  `b_cost` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '二期成本',
  `liaison_person` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '联系人',
  `liaison_tel` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '联系电话',
  `salary_money` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '薪水',
  `social_security` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '社会保险',
  `bank_cardnumber` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '银行卡号',
  `addressinfo` varchar(300) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '住址',
  `remarkinfo` text COLLATE utf8_unicode_ci COMMENT '备注信息',
  `vice_work_type` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '副工作类型，兼职工作类型',
  `work_shop` varchar(3000) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '工作店面',
  `open_id` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '绑定微信',
  `open_id_name` varchar(200) CHARACTER SET latin1 DEFAULT NULL COMMENT '绑定的微信号名字，用于显示当前绑定者',
  `status` tinyint(1) unsigned DEFAULT '1' COMMENT '在线状态：1：在线；2：忙碌；3：离线',
  `Popedom1` varchar(1000) CHARACTER SET latin1 DEFAULT NULL,
  `Popedom2` varchar(1000) CHARACTER SET latin1 DEFAULT NULL,
  `Popedom3` varchar(1000) CHARACTER SET latin1 DEFAULT NULL,
  `Popedom4` varchar(1000) CHARACTER SET latin1 DEFAULT NULL,
  `Popedom6` varchar(1000) CHARACTER SET latin1 DEFAULT NULL,
  `Popedom5` varchar(1000) CHARACTER SET latin1 DEFAULT NULL,
  `Popedom7` varchar(1000) CHARACTER SET latin1 DEFAULT NULL,
  `Popedom8` varchar(1000) CHARACTER SET latin1 DEFAULT NULL,
  `Popedom9` varchar(1000) CHARACTER SET utf8 DEFAULT NULL,
  `Popedom10` varchar(1000) CHARACTER SET latin1 DEFAULT NULL,
  `Popedom11` varchar(1000) CHARACTER SET latin1 DEFAULT NULL,
  `Popedom12` varchar(1000) CHARACTER SET latin1 DEFAULT NULL,
  `Popedom13` varchar(1000) CHARACTER SET latin1 DEFAULT NULL,
  `Popedom14` varchar(1000) CHARACTER SET latin1 DEFAULT NULL,
  `Popedom15` varchar(1000) CHARACTER SET latin1 DEFAULT NULL,
  `Popedom16` varchar(1000) CHARACTER SET latin1 DEFAULT NULL,
  `Popedom17` varchar(1000) CHARACTER SET latin1 DEFAULT NULL,
  `Popedom18` varchar(1000) CHARACTER SET latin1 DEFAULT NULL,
  `zhiji_id` int(11) DEFAULT NULL,
  `add_time` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sn` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `grade_type` tinyint(2) DEFAULT NULL,
  `last_login_ip` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `last_login_time` datetime DEFAULT NULL,
  `brandclass_id` int(11) DEFAULT NULL,
  `work_types` varchar(1000) COLLATE utf8_unicode_ci DEFAULT '',
  `is_jiguang` tinyint(2) DEFAULT '2' COMMENT '是否安装极光推送（1：已安装；2：未安装）',
  `start_holiday` datetime DEFAULT NULL COMMENT '开始休假时间',
  `end_holiday` datetime DEFAULT NULL COMMENT '结束休假时间',
  `work_type_level` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '工作类型等级',
  `work_type_level_id` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `working_status` tinyint(2) DEFAULT '1' COMMENT '1在职，2停薪留职，3离职，4淡季假，5申请离职',
  `visa_number` int(11) DEFAULT NULL COMMENT '电子签证号',
  `fingerprint1` text COLLATE utf8_unicode_ci COMMENT '指纹1',
  `fingerprint2` text COLLATE utf8_unicode_ci,
  `fingerprint3` text COLLATE utf8_unicode_ci,
  `fingerprint4` text COLLATE utf8_unicode_ci,
  `fingerprint5` text COLLATE utf8_unicode_ci,
  `minzu` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `is_lock` tinyint(1) DEFAULT '2',
  `update_pwd_time` datetime DEFAULT NULL,
  `fingerprint6` text COLLATE utf8_unicode_ci,
  `fingerprint7` text COLLATE utf8_unicode_ci,
  `fingerprint8` text COLLATE utf8_unicode_ci,
  `fingerprint9` text COLLATE utf8_unicode_ci,
  `fingerprint10` text COLLATE utf8_unicode_ci,
  `is_group_admin` text COLLATE utf8_unicode_ci,
  `address_id` text COLLATE utf8_unicode_ci,
  `leaders` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  `is_quanrizhi` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `staff_sn` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table s_staffinfo_del
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_staffinfo_del`;

CREATE TABLE `s_staffinfo_del` (
  `id` int(11) NOT NULL,
  `staffnumber` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '员工编号',
  `staffname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '员工名',
  `password` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `department_id` int(11) DEFAULT NULL COMMENT '部门id',
  `department_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '部门',
  `main_position_id` int(11) DEFAULT NULL COMMENT '主岗位',
  `main_position_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '主岗位名称',
  `main_position_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '主岗位唯一标识',
  `position_id` text COLLATE utf8_unicode_ci,
  `position_code` text COLLATE utf8_unicode_ci COMMENT '岗位唯一标识',
  `zhiji_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '职级',
  `turestaffname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '真实姓名',
  `group_company_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '集团名称',
  `brandclass` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '品牌名称',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '店面名称',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '店面编码',
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `group_id` int(11) DEFAULT '0' COMMENT '小组id',
  `group_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '组名',
  `is_group_admin` text COLLATE utf8_unicode_ci,
  `sex` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '性别',
  `entry_date` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '入职时间',
  `leave_date` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '离职时间',
  `birthday` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '生日',
  `IDcard` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '身份证',
  `nation` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '国家',
  `place_origin` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '出生地',
  `political` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '政治身份',
  `education` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '教育程度',
  `graduation_school` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '毕业学校',
  `marital_status` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '婚姻状况',
  `contract_endday` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '合同结束时间',
  `telephone` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '电话号',
  `QQ` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `email` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `weixin` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `a_discount` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '一期折扣',
  `b_discount` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '二期折扣',
  `a_cost` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '一期成本',
  `b_cost` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '二期成本',
  `liaison_person` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '联系人',
  `liaison_tel` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '联系电话',
  `salary_money` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '薪水',
  `social_security` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '社会保险',
  `bank_cardnumber` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '银行卡号',
  `addressinfo` varchar(300) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '住址',
  `remarkinfo` text COLLATE utf8_unicode_ci COMMENT '备注信息',
  `vice_work_type` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '副工作类型，兼职工作类型',
  `work_shop` varchar(3000) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '工作店面',
  `open_id` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '绑定微信',
  `open_id_name` varchar(200) CHARACTER SET latin1 DEFAULT NULL COMMENT '绑定的微信号名字，用于显示当前绑定者',
  `status` tinyint(1) unsigned DEFAULT '1' COMMENT '在线状态：1：在线；2：忙碌；3：离线',
  `zhiji_id` int(11) DEFAULT NULL,
  `add_time` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sn` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `grade_type` tinyint(2) DEFAULT NULL,
  `last_login_ip` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `last_login_time` datetime DEFAULT NULL,
  `brandclass_id` int(11) DEFAULT NULL,
  `work_types` varchar(1000) COLLATE utf8_unicode_ci DEFAULT '',
  `is_jiguang` tinyint(2) DEFAULT '2',
  `start_holiday` datetime DEFAULT NULL,
  `end_holiday` datetime DEFAULT NULL,
  `work_type_level_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `work_type_level` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `working_status` tinyint(2) DEFAULT '1',
  `visa_number` int(11) DEFAULT NULL,
  `minzu` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `is_lock` tinyint(1) DEFAULT '2',
  `update_pwd_time` datetime DEFAULT NULL,
  `staff_sn` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `address_id` text COLLATE utf8_unicode_ci,
  `leaders` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table s_teamset
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_teamset`;

CREATE TABLE `s_teamset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `team_name` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `brandclass_ids` text COLLATE utf8_unicode_ci,
  `addtime` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

LOCK TABLES `s_teamset` WRITE;
/*!40000 ALTER TABLE `s_teamset` DISABLE KEYS */;

INSERT INTO `s_teamset` (`id`, `team_name`, `brandclass_ids`, `addtime`)
VALUES
	(1,'敢死队','1,2,3,4,5,6,7,8,10,11','2018-07-16 20:51:11'),
	(2,'对对队','7,8,10,11','2018-07-16 20:51:04'),
	(3,'123333',NULL,'2018-07-16 20:51:21');

/*!40000 ALTER TABLE `s_teamset` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table s_telremark
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_telremark`;

CREATE TABLE `s_telremark` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `telremark` varchar(500) DEFAULT NULL,
  `shop_name` varchar(100) DEFAULT NULL,
  `shop_code` varchar(100) DEFAULT NULL,
  `setkey` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



# Dump of table s_templateset
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_templateset`;

CREATE TABLE `s_templateset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `app_id` int(11) DEFAULT NULL COMMENT '应用id',
  `template_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '模板名称',
  `template_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '模板编号',
  `template_id` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '微信返回的模板id',
  `is_use` tinyint(2) DEFAULT '2',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

LOCK TABLES `s_templateset` WRITE;
/*!40000 ALTER TABLE `s_templateset` DISABLE KEYS */;

INSERT INTO `s_templateset` (`id`, `app_id`, `template_name`, `template_number`, `template_id`, `is_use`)
VALUES
	(7,NULL,'用户登录提醒 ','TM00181',NULL,1),
	(9,NULL,'会员充值通知','OPENTM201378330',NULL,1),
	(10,NULL,'待办任务提醒','OPENTM213512088',NULL,1),
	(11,NULL,'积分兑换成功通知','OPENTM201014137',NULL,1),
	(12,NULL,'帐户推广概况通知','TM00200',NULL,1),
	(13,NULL,'会员消费通知','OPENTM201378279',NULL,1),
	(15,NULL,'服务器恢复通知','TM00180',NULL,1),
	(21,NULL,'付款通知','OPENTM208029645',NULL,1),
	(22,NULL,'选片通知','OPENTM208029189',NULL,1),
	(23,NULL,'取件通知','OPENTM208029181',NULL,1),
	(24,NULL,'会员拍照通知','OPENTM400074760',NULL,1),
	(25,NULL,'订单通知','OPENTM208029195',NULL,1),
	(26,NULL,'看版通知','OPENTM208023746',NULL,1),
	(29,NULL,'预约提醒','OPENTM405733202',NULL,1),
	(44,NULL,'客户驳回通知','OPENTM414173928',NULL,1),
	(45,NULL,'信息冲突通知','OPENTM414173940',NULL,1),
	(46,NULL,'客户分配通知','OPENTM414174098',NULL,1),
	(47,NULL,'预约进店提醒','OPENTM405765901',NULL,1),
	(48,NULL,'再约提醒','OPENTM416748201',NULL,1),
	(49,NULL,'会员注册提醒','OPENTM200560196',NULL,1),
	(50,NULL,'批量分配客资提醒','OPENTM412936679',NULL,1),
	(51,NULL,'签字通知','OPENTM410972039',NULL,1),
	(57,NULL,'事项审核提醒','OPENTM412499555','',1),
	(58,NULL,'消费成功通知 ','OPENTM406121400',NULL,1),
	(59,NULL,'待办任务通知','OPENTM206831895',NULL,1),
	(60,NULL,'待办任务通知 ','OPENTM206831895',NULL,1),
	(61,NULL,'客户跟踪提醒 ','OPENTM416747652',NULL,1),
	(62,NULL,'流程操作通知','OPENTM207793577',NULL,1),
	(63,NULL,'验证码通知','OPENTM203026900',NULL,1),
	(65,NULL,'故障通报通知','TM00204',NULL,1);

/*!40000 ALTER TABLE `s_templateset` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table s_tracksign
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_tracksign`;

CREATE TABLE `s_tracksign` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `Tracksign` varchar(500) DEFAULT NULL,
  `shop_name` varchar(100) DEFAULT NULL,
  `shop_code` varchar(100) DEFAULT NULL,
  `setkey` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



# Dump of table s_work_type_level
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_work_type_level`;

CREATE TABLE `s_work_type_level` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `level_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `work_type_id` int(11) DEFAULT NULL,
  `work_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sort` int(11) DEFAULT NULL,
  `add_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

LOCK TABLES `s_work_type_level` WRITE;
/*!40000 ALTER TABLE `s_work_type_level` DISABLE KEYS */;

INSERT INTO `s_work_type_level` (`id`, `level_name`, `work_type_id`, `work_type`, `sort`, `add_time`)
VALUES
	(1,'顶级',2,'礼服',1,'2018-06-25 18:44:35'),
	(2,'中级',2,'礼服',2,'2018-06-25 19:26:43'),
	(3,'高级',1,'门市',1,'2018-08-30 14:32:01');

/*!40000 ALTER TABLE `s_work_type_level` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table s_worktype
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_worktype`;

CREATE TABLE `s_worktype` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `work_type` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '工作类型',
  `group` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '分组，设定的时候展示',
  `sort` tinyint(2) DEFAULT NULL COMMENT '排序，升级',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

LOCK TABLES `s_worktype` WRITE;
/*!40000 ALTER TABLE `s_worktype` DISABLE KEYS */;

INSERT INTO `s_worktype` (`id`, `work_type`, `group`, `sort`)
VALUES
	(1,'门市','门店工作类型',1),
	(3,'拍照','门店工作类型',3),
	(6,'选片','门店工作类型',9),
	(7,'化妆','门店工作类型',5),
	(8,'取件','门店工作类型',11),
	(9,'精修','数码工作类型',2),
	(11,'设计','数码工作类型',3),
	(14,'收款','门店工作类型',12),
	(21,'话务','网销工作类型',1),
	(22,'系统管理员','其它',1),
	(23,'客资提报','网销工作类型',2),
	(25,'导师','门店工作类型',4),
	(32,'品控','数码工作类型',5),
	(33,'采访','门店工作类型',7),
	(34,'排相','门店工作类型',2),
	(35,'剪辑师','门店工作类型',8),
	(38,'MV摄影','门店工作类型',6),
	(39,'初修','数码工作类型',1),
	(41,'看效果','门店工作类型',10),
	(42,'发件','数码工作类型',4);

/*!40000 ALTER TABLE `s_worktype` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table s_wx_answer_contact
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_wx_answer_contact`;

CREATE TABLE `s_wx_answer_contact` (
  `answer_id` int(11) DEFAULT NULL,
  `auto_key_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '关键词匹配方式：1：半匹配；2：全匹配',
  `auto_key_word` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '关键词',
  `auto_answer_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '回复内容类型（1：文字；2：图片；3：图文消息；4：音频；5：视频）',
  `auto_answer_contact` text COLLATE utf8_unicode_ci COMMENT '回复内容',
  `create_time` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table s_wx_auto_answer
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_wx_auto_answer`;

CREATE TABLE `s_wx_auto_answer` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `auto_type` int(11) DEFAULT NULL COMMENT '自动回复类型（1：关键词回复；2：收到消息回复；3：被关注回复）',
  `auto_name` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '关键词回复，规则名称',
  `answer_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '回复方式（reply_all：回复全部；random_one：随机回复一条）',
  `keywords` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci COMMENT 'equal:全匹配；contain:半匹配',
  `contents` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `staff_id` int(11) DEFAULT NULL COMMENT '创建人',
  `staff_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `wxsys_id` int(11) DEFAULT NULL COMMENT '微信公众号设定（wx_system）id',
  `wxsys_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '微信公众号名',
  `wxsys_appid` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '公众号appid',
  `is_del` tinyint(4) DEFAULT '2' COMMENT '是否删除（1：已删除；2：未删除）',
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  `wx_public` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '获取的微信公众号wx_public',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table s_wx_kf_staff
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_wx_kf_staff`;

CREATE TABLE `s_wx_kf_staff` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) DEFAULT NULL,
  `staff_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '人员名称',
  `staff_number` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '人员编号',
  `kf_account` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客服账号',
  `kf_nick` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '昵称',
  `kf_wx` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `photo` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '头像地址',
  `belong_wx_id` int(11) DEFAULT NULL,
  `belong_wx_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staff_id` (`staff_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table s_wx_menu
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_wx_menu`;

CREATE TABLE `s_wx_menu` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '菜单名称',
  `fid` int(11) DEFAULT NULL,
  `menu_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '功能菜单唯一标识',
  `menu_icon` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '菜单图标',
  `status` tinyint(4) DEFAULT NULL COMMENT '状态:99:删除',
  `sort` int(10) unsigned DEFAULT NULL COMMENT '排序',
  `level` tinyint(1) unsigned DEFAULT NULL COMMENT '菜单等级',
  `type` varchar(50) COLLATE utf8_unicode_ci DEFAULT 'view' COMMENT '菜单类型 -- click:消息；view：网页；miniprogram：小程序；',
  `keyword` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '当type为click时的子类型--media_id：图片消息，view_limited：图文消息，click：文本消息',
  `url` text COLLATE utf8_unicode_ci COMMENT '跳转页面或者回复文本消息时的内容',
  `media_id` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '资源库media_id',
  `img_url` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '资源图片',
  `pagepath` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '小程序用，页面路径',
  `appid` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '当菜单类型是小程序时要用到',
  `wx_public` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '获取的微信公众号wx_public',
  `wx_appid` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table s_wx_relation
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_wx_relation`;

CREATE TABLE `s_wx_relation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `subscribe` tinyint(4) DEFAULT NULL COMMENT '用户是否订阅该公众号标识，值为0时，代表此用户没有关注该公众号，拉取不到其余信息。',
  `openid` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `nickname` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '用户的昵称',
  `sex` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '1时是男性，2时是女性，0时是未知',
  `language` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '用户的语言，简体中文为zh_CN',
  `headimgurl` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '用户头像，最后一个数值代表正方形头像大小（有0、46、64、96、132数值可选，0代表640*640正方形头像）',
  `subscribe_time` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '用户关注时间，为时间戳。如果用户曾多次关注，则取最后关注时间',
  `unionid` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '只有在用户将公众号绑定到微信开放平台帐号后，才会出现该字段。',
  `remark` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '公众号运营者对粉丝的备注',
  `kf_id` int(11) DEFAULT NULL COMMENT '对应的客服id',
  `cid` int(11) DEFAULT NULL COMMENT '对应的客资id',
  `wx_sys_id` int(11) DEFAULT NULL COMMENT '对应的微信公众id',
  `qdid` int(11) DEFAULT NULL COMMENT '渠道id',
  `wx_public` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '获取的微信公众号wx_public',
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `openid` (`openid`) USING BTREE,
  KEY `kf_id` (`kf_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table s_wx_server_msg
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_wx_server_msg`;

CREATE TABLE `s_wx_server_msg` (
  `id` bigint(11) NOT NULL AUTO_INCREMENT,
  `create_time` datetime DEFAULT NULL,
  `timestamp` decimal(16,5) DEFAULT NULL,
  `appid` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `openid` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `msg_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `msg` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `app_id` (`appid`) USING BTREE,
  KEY `open_id` (`openid`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='微信事件记录，即微信接口调用服务端的记录';



# Dump of table s_wx_talk
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_wx_talk`;

CREATE TABLE `s_wx_talk` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `openid` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `opercode` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '操作码，2002（客服发送信息），2003（客服接收消息）',
  `type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '文本（text）、图片（img）、语音（voice）、视频（video）、图文消息（news）',
  `text` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `time` datetime DEFAULT NULL,
  `kf_id` int(11) DEFAULT NULL COMMENT '发送消息的客服人员，如果为-1 则为系统自动回复',
  `subscribe` tinyint(1) DEFAULT '0' COMMENT '0:未读,1:已读',
  PRIMARY KEY (`id`),
  KEY `openid` (`openid`) USING BTREE,
  KEY `kf_id` (`kf_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table s_wx_template
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_wx_template`;

CREATE TABLE `s_wx_template` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `wtempalte_name` varchar(50) DEFAULT NULL,
  `wtempalte_content` varchar(3000) DEFAULT NULL,
  `shop_name` varchar(100) DEFAULT NULL,
  `shop_code` varchar(100) DEFAULT NULL,
  `setkey` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



# Dump of table s_wx_template_message
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_wx_template_message`;

CREATE TABLE `s_wx_template_message` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` tinyint(4) DEFAULT '1',
  `content` text COLLATE utf8_unicode_ci,
  `create_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table s_zhijiset
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_zhijiset`;

CREATE TABLE `s_zhijiset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `zhiji_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fatid` int(11) DEFAULT NULL,
  `grade_type` tinyint(4) DEFAULT NULL COMMENT '1集团，2品牌，3店面，4部门',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `grade` int(11) DEFAULT '1' COMMENT '职等，默认为1',
  `fatname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '直属上级的职级名称',
  `addtime` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table sms_sign
# ------------------------------------------------------------

DROP TABLE IF EXISTS `sms_sign`;

CREATE TABLE `sms_sign` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sign` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `add_time` datetime DEFAULT NULL,
  `verify_time` datetime DEFAULT NULL,
  `state` tinyint(4) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

LOCK TABLES `sms_sign` WRITE;
/*!40000 ALTER TABLE `sms_sign` DISABLE KEYS */;

INSERT INTO `sms_sign` (`id`, `sign`, `add_time`, `verify_time`, `state`)
VALUES
	(1,'签名测试','2023-02-23 10:14:33','2023-02-23 10:14:33',1);

/*!40000 ALTER TABLE `sms_sign` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table sms_template
# ------------------------------------------------------------

DROP TABLE IF EXISTS `sms_template`;

CREATE TABLE `sms_template` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `content` varchar(1000) COLLATE utf8_unicode_ci DEFAULT '',
  `params` varchar(500) COLLATE utf8_unicode_ci DEFAULT '',
  `add_time` datetime DEFAULT NULL,
  `verify_time` datetime DEFAULT NULL,
  `state` tinyint(4) DEFAULT '0',
  `name` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

LOCK TABLES `sms_template` WRITE;
/*!40000 ALTER TABLE `sms_template` DISABLE KEYS */;

INSERT INTO `sms_template` (`id`, `content`, `params`, `add_time`, `verify_time`, `state`, `name`)
VALUES
	(1,'【签名测试】','','2023-02-23 11:30:49','2023-02-23 11:30:49',1,'签名');

/*!40000 ALTER TABLE `sms_template` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table staff_profile
# ------------------------------------------------------------

DROP TABLE IF EXISTS `staff_profile`;

CREATE TABLE `staff_profile` (
  `id` int(11) NOT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `birthday` datetime DEFAULT NULL COMMENT '员工生日',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='保存员工非必要信息';



# Dump of table staffc_test
# ------------------------------------------------------------

DROP TABLE IF EXISTS `staffc_test`;

CREATE TABLE `staffc_test` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  `login_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='员工表';



# Dump of table vip_users
# ------------------------------------------------------------

DROP TABLE IF EXISTS `vip_users`;

CREATE TABLE `vip_users` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `openid` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `nickname` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `unionid` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sex` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `headimgurl` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  `brandclass_id` int(11) DEFAULT NULL,
  `mobile` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `brand_id` int(10) DEFAULT '0',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `appid` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table vip_users_order
# ------------------------------------------------------------

DROP TABLE IF EXISTS `vip_users_order`;

CREATE TABLE `vip_users_order` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `openid` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `order_sn` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

LOCK TABLES `vip_users_order` WRITE;
/*!40000 ALTER TABLE `vip_users_order` DISABLE KEYS */;

INSERT INTO `vip_users_order` (`id`, `openid`, `order_sn`, `create_time`)
VALUES
	(3,'o3mGr0paq4VWktKzPiBn-082a4Go','234234',NULL);

/*!40000 ALTER TABLE `vip_users_order` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table z_guest_signup
# ------------------------------------------------------------

DROP TABLE IF EXISTS `z_guest_signup`;

CREATE TABLE `z_guest_signup` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mobile` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `credential_type` tinyint(2) DEFAULT NULL COMMENT '证件类型',
  `credential_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '证件号码',
  `sex` tinyint(1) DEFAULT NULL COMMENT '性别',
  `birthday` date DEFAULT NULL COMMENT '出生日期',
  `is_out` tinyint(4) DEFAULT NULL COMMENT '是否境外人员',
  `temperature` decimal(10,2) DEFAULT NULL COMMENT '体温',
  `symptom` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '证状，逗号分隔',
  `desc` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '详细描述',
  `yjd_day` date DEFAULT NULL COMMENT '预约日期',
  `company_name` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '影楼名称',
  `attr1` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '符件1：健康码截图',
  `attr2` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '符件2：个人轨迹截图',
  `add_time` datetime DEFAULT NULL COMMENT '添加时间',
  `add_ip` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '添加者IP',
  `state` tinyint(1) DEFAULT '0' COMMENT '0初始，1审核通过，2已进店',
  `staff_id` int(10) DEFAULT NULL COMMENT '审核人',
  `openid` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `staff_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '审核人姓名',
  `in_time` datetime DEFAULT NULL COMMENT '实际进店时间',
  `code` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '核销码',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

LOCK TABLES `z_guest_signup` WRITE;
/*!40000 ALTER TABLE `z_guest_signup` DISABLE KEYS */;

INSERT INTO `z_guest_signup` (`id`, `name`, `mobile`, `credential_type`, `credential_number`, `sex`, `birthday`, `is_out`, `temperature`, `symptom`, `desc`, `yjd_day`, `company_name`, `attr1`, `attr2`, `add_time`, `add_ip`, `state`, `staff_id`, `openid`, `staff_name`, `in_time`, `code`, `shop_code`)
VALUES
	(1,'123123','13212312312',2,'123123',1,'2019-12-12',2,1.00,NULL,'123','2020-04-15',NULL,'/uploads/20200415/bf9ac5e5384420c64ec613259b82042f.jpeg',NULL,'2020-04-15 15:25:15','127.0.0.1',2,NULL,NULL,NULL,NULL,'zsrBUO',''),
	(2,'2222','13333333333',1,'4444444',1,'2019-12-12',2,1.00,'on,on','2123123','2020-04-16',NULL,'/uploads/20200415/1eba36f02779587a40f512aae3f9f782.jpeg','/uploads/20200415/78b334d6dc804bf0eba10bbc3c93b465.jpeg','2020-04-15 18:03:40','127.0.0.1',0,NULL,NULL,NULL,NULL,'8013360',''),
	(3,'2222','13333333333',1,'4444444',1,'2019-12-12',2,1.00,NULL,'2123123','2020-04-16',NULL,'/uploads/20200415/51806cf244bed455f985c7e4caa166b1.jpeg','/uploads/20200415/00b51bd36695b30b658d0f8f5679f2f2.jpeg','2020-04-15 18:06:20','127.0.0.1',0,NULL,NULL,NULL,NULL,'2677395',''),
	(4,'22222','13233333333',1,'123123123',1,'2019-12-12',2,1.00,'on','','2020-04-16','11111','/uploads/20200415/e8f5b02dd0ee185415e0cb1cd627fc58.jpeg','/uploads/20200415/c8383bd4de65cd311ba714bd5ba8ba5a.jpeg','2020-04-15 18:32:51','127.0.0.1',0,NULL,NULL,NULL,NULL,'1556047',''),
	(5,'123123','13231231231',2,'1231231',1,'2019-12-12',2,1.00,NULL,'','2020-04-16','123123','/uploads/20200415/fc9747108bf443d2941dca573af866f9.jpeg','/uploads/20200415/6ee2d0f3742793063a142f2e7b38ba94.jpeg','2020-04-15 18:36:18','127.0.0.1',0,NULL,NULL,NULL,NULL,'9431506',''),
	(6,'12312','13213123123',1,'1231231',1,'2019-12-12',2,1.00,NULL,'','2020-04-16','123123123','/uploads/20200415/c6f6c44ed6587dd6189915143ea11651.jpeg','/uploads/20200415/b9127608d1967b7040cb69703e240145.jpeg','2020-04-15 18:37:11','127.0.0.1',0,NULL,NULL,NULL,NULL,'7414590',''),
	(7,'2222','13231231231',2,'123123123',2,'2019-12-12',2,1.00,NULL,'','2020-04-16','11111','/uploads/20200415/7b1cf76c8ebfe56393b7b16d67b8ff1a.jpeg','/uploads/20200415/4b39553f791b0839b3868b5cf2f89b3c.jpeg','2020-04-15 18:38:27','127.0.0.1',2,NULL,NULL,NULL,NULL,'60071347',''),
	(8,'22222','13223333333',1,'123123123',1,'2019-12-12',2,1.00,'发热,干咳,流涕','','2020-04-16','11111','/uploads/20200415/f51c5e7c57795adae0eb56357d4aa0f8.jpeg','/uploads/20200415/df7b5f59116c11b5621b37eb255a275d.jpeg','2020-04-15 18:51:24','127.0.0.1',2,NULL,NULL,NULL,NULL,'76833421',''),
	(9,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,''),
	(10,'22222','13223333333',1,'123123123',1,'2019-12-12',2,1.00,'乏力,干咳,鼻塞,流涕,腹泻,呼吸困难','','2020-04-16','11111','/uploads/20200415/00fa2a950feabc7d575b3f9c67076840.jpeg','/uploads/20200415/42d859c8ac491e74f844284bcc7d6312.jpeg','2020-04-15 18:52:47','127.0.0.1',2,NULL,NULL,NULL,NULL,'10016022',''),
	(11,'123','13212312312',2,'123123123',1,'2019-12-12',2,1.00,NULL,'','2020-04-20','123','/uploads/20200419/4c50aa7b1e45fad0c5effc469d1feb2d.jpeg','/uploads/20200419/efae82ab0166877b610c3f9d81737e81.jpeg','2020-04-19 18:00:00','127.0.0.1',2,NULL,'o3mGr0iz8l7_gptL0cFB-rvSq6Yo',NULL,'2020-04-19 18:50:38','94074731',''),
	(12,'123123','13212312312',3,'123123123',2,'2019-12-12',2,1.00,'乏力','','2020-04-20','sadfasdf','/uploads/20200419/3d6af54be54d04e246e1ff9250c2fbba.jpeg','/uploads/20200419/f25bc98350ab1861f1d99851e627eee6.jpeg','2020-04-19 18:58:34','127.0.0.1',3,NULL,'o3mGr0iz8l7_gptL0cFB-rvSq6Yo',NULL,NULL,'61458102',''),
	(13,'123123','13123123123',2,'123123123',1,'1981-08-20',2,1.00,NULL,'','2020-04-20','123123','/uploads/20200419/c86769ab162d1e8e67fde7922e52d0b0.jpeg','/uploads/20200419/a5b3fdd643a70cde1b45458f21df7e89.jpeg','2020-04-19 22:50:23','127.0.0.1',3,NULL,'o3mGr0iz8l7_gptL0cFB-rvSq6Yo',NULL,NULL,'60094123',''),
	(14,'123123','13121231231',1,'34242519810820401X',1,'1981-08-20',2,1.00,'发热','','2020-04-21','123123','/uploads/20200421/940a3cc121a1e622b94cacb2a8167d45.jpeg','/uploads/20200421/9cc079f376406434923eb72beb8d53ed.jpeg','2020-04-21 15:48:48','127.0.0.1',2,NULL,'o3mGr0iz8l7_gptL0cFB-rvSq6Yo',NULL,'2020-04-21 15:50:39','48255371',''),
	(15,'sdfsdf','13212312312',1,'34242519810820401X',1,'1981-08-20',2,1.00,NULL,'','2020-04-21','123123','/uploads/20200421/a42286bc6a4331712cfb4ae915cb56d3.jpeg','/uploads/20200421/cd04985539fe8815e21d43be3145806a.jpeg','2020-04-21 15:59:46','127.0.0.1',3,NULL,'o3mGr0iz8l7_gptL0cFB-rvSq6Yo',NULL,NULL,'57878152',''),
	(16,'123123','13641009570',4,'123123',1,'2019-12-12',2,1.00,NULL,'','2020-04-21','123123','/uploads/20200421/045dec0fc6d9933fbb7f812879baf2fe.jpeg','/uploads/20200421/ca262bf90155dadbfe9469ed106c790f.jpeg','2020-04-21 17:02:08','127.0.0.1',0,NULL,'o3mGr0iz8l7_gptL0cFB-rvSq6Yo',NULL,NULL,'84981633','');

/*!40000 ALTER TABLE `z_guest_signup` ENABLE KEYS */;
UNLOCK TABLES;



/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;
/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
