/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud;

import com.wgcloud.ApplicationContextHelper;
import com.wgcloud.CommonConfig;
import com.wgcloud.FormatUtil;
import com.wgcloud.entity.AppState;
import com.wgcloud.entity.CpuState;
import com.wgcloud.entity.DeskState;
import com.wgcloud.entity.MemState;
import com.wgcloud.entity.NetIoState;
import com.wgcloud.entity.SysLoadState;
import com.wgcloud.entity.SystemInfo;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.CentralProcessor;
import oshi.hardware.GlobalMemory;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.NetworkIF;
import oshi.software.os.FileSystem;
import oshi.software.os.OSFileStore;
import oshi.software.os.OSProcess;
import oshi.software.os.OperatingSystem;
import oshi.util.Util;

public class OshiUtil {
    private static Logger logger = LoggerFactory.getLogger(OshiUtil.class);
    private static CommonConfig commonConfig = (CommonConfig)ApplicationContextHelper.getBean(CommonConfig.class);
    private static Runtime r = Runtime.getRuntime();

    public static MemState memory(GlobalMemory memory) throws Exception {
        MemState memState = new MemState();
        long total = memory.getTotal() / 1024L / 1024L;
        long free = memory.getAvailable() / 1024L / 1024L;
        double usePer = (double)(total - free) / (double)total;
        memState.setUsePer(Double.valueOf(FormatUtil.formatDouble((double)(usePer * 100.0), (int)1)));
        memState.setHostname(commonConfig.getBindIp());
        return memState;
    }

    public static CpuState cpu(CentralProcessor processor) throws Exception {
        long[] prevTicks = processor.getSystemCpuLoadTicks();
        Util.sleep((long)1000L);
        CpuState cpuState = new CpuState();
        cpuState.setSys(Double.valueOf(FormatUtil.formatDouble((double)(processor.getSystemCpuLoadBetweenTicks(prevTicks) * 100.0), (int)1)));
        cpuState.setHostname(commonConfig.getBindIp());
        return cpuState;
    }

    public static SystemInfo os(CentralProcessor processor, OperatingSystem os) throws Exception {
        SystemInfo systemInfo = new SystemInfo();
        systemInfo.setHostname(commonConfig.getBindIp());
        systemInfo.setCpuCoreNum(processor.getLogicalProcessorCount() + "");
        String cpuInfo = processor.toString();
        if (cpuInfo.indexOf("\n") > 0) {
            cpuInfo = cpuInfo.substring(0, cpuInfo.indexOf("\n"));
        }
        systemInfo.setCpuXh(cpuInfo);
        systemInfo.setVersion(os.toString());
        systemInfo.setVersionDetail(os.toString());
        systemInfo.setState("1");
        return systemInfo;
    }

    public static List<DeskState> file(Timestamp t, FileSystem fileSystem) throws Exception {
        ArrayList<DeskState> list = new ArrayList<DeskState>();
        List fsArray = fileSystem.getFileStores();
        for (OSFileStore fs : fsArray) {
            long usable = fs.getUsableSpace();
            long total = fs.getTotalSpace();
            DeskState deskState = new DeskState();
            deskState.setFileSystem(fs.getName());
            deskState.setHostname(commonConfig.getBindIp());
            deskState.setUsed((total - usable) / 1024L / 1024L / 1024L + "G");
            deskState.setAvail(usable / 1024L / 1024L / 1024L + "G");
            deskState.setSize(total / 1024L / 1024L / 1024L + "G");
            double usedSize = total - usable;
            double usePercent = 0.0;
            if (total > 0L) {
                usePercent = FormatUtil.formatDouble((double)(usedSize / (double)total * 100.0), (int)2);
            }
            deskState.setUsePer(usePercent + "%");
            deskState.setCreateTime((Date)t);
            list.add(deskState);
        }
        return list;
    }

    public static SysLoadState getLoadState(SystemInfo systemInfo, CentralProcessor processor) throws Exception {
        SysLoadState sysLoadState = new SysLoadState();
        if (systemInfo == null) {
            return null;
        }
        if (systemInfo.getVersionDetail().indexOf("Microsoft") > -1) {
            return null;
        }
        double[] loadAverage = processor.getSystemLoadAverage(3);
        sysLoadState.setOneLoad(Double.valueOf(loadAverage[0]));
        sysLoadState.setHostname(commonConfig.getBindIp());
        sysLoadState.setFiveLoad(Double.valueOf(loadAverage[1]));
        sysLoadState.setFifteenLoad(Double.valueOf(loadAverage[2]));
        return sysLoadState;
    }

    public static AppState getLoadPid(String pid, OperatingSystem os, GlobalMemory memory) throws Exception {
        try {
            ArrayList<Integer> pidList = new ArrayList<Integer>();
            pidList.add(Integer.valueOf(pid));
            List procs = os.getProcesses(pidList);
            int i = 0;
            if (i < procs.size() && i < 5) {
                OSProcess p = (OSProcess)procs.get(i);
                AppState appState = new AppState();
                appState.setCpuPer(Double.valueOf(FormatUtil.formatDouble((double)(100.0 * (double)(p.getKernelTime() + p.getUserTime()) / (double)p.getUpTime()), (int)2)));
                appState.setMemPer(Double.valueOf(FormatUtil.formatDouble((double)(100.0 * (double)p.getResidentSetSize() / (double)memory.getTotal()), (int)2)));
                return appState;
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u8fdb\u7a0b\u4fe1\u606f\u9519\u8bef", (Throwable)e);
        }
        return null;
    }

    public static NetIoState net(HardwareAbstractionLayer hal) throws Exception {
        long rxBytesBegin = 0L;
        long txBytesBegin = 0L;
        long rxPacketsBegin = 0L;
        long txPacketsBegin = 0L;
        long rxBytesEnd = 0L;
        long txBytesEnd = 0L;
        long rxPacketsEnd = 0L;
        long txPacketsEnd = 0L;
        List listBegin = hal.getNetworkIFs();
        for (Object net : listBegin) {
            rxBytesBegin += net.getBytesRecv();
            txBytesBegin += net.getBytesSent();
            rxPacketsBegin += net.getPacketsRecv();
            txPacketsBegin += net.getPacketsSent();
        }
        Thread.sleep(5000L);
        List listEnd = hal.getNetworkIFs();
        for (NetworkIF net : listEnd) {
            rxBytesEnd += net.getBytesRecv();
            txBytesEnd += net.getBytesSent();
            rxPacketsEnd += net.getPacketsRecv();
            txPacketsEnd += net.getPacketsSent();
        }
        long rxBytesAvg = (rxBytesEnd - rxBytesBegin) / 3L / 1024L;
        long txBytesAvg = (txBytesEnd - txBytesBegin) / 3L / 1024L;
        long rxPacketsAvg = (rxPacketsEnd - rxPacketsBegin) / 3L / 1024L;
        long txPacketsAvg = (txPacketsEnd - txPacketsBegin) / 3L / 1024L;
        NetIoState netIoState = new NetIoState();
        netIoState.setRxbyt(rxBytesAvg + "");
        netIoState.setTxbyt(txBytesAvg + "");
        netIoState.setRxpck(rxPacketsAvg + "");
        netIoState.setTxpck(txPacketsAvg + "");
        netIoState.setHostname(commonConfig.getBindIp());
        return netIoState;
    }
}

