/*
 * Decompiled with CFR 0.152.
 */
package com.wgcloud;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.wgcloud.CommonConfig;
import com.wgcloud.FormatUtil;
import com.wgcloud.OshiUtil;
import com.wgcloud.RestUtil;
import com.wgcloud.entity.AppInfo;
import com.wgcloud.entity.AppState;
import com.wgcloud.entity.CpuState;
import com.wgcloud.entity.LogInfo;
import com.wgcloud.entity.MemState;
import com.wgcloud.entity.NetIoState;
import com.wgcloud.entity.SysLoadState;
import com.wgcloud.entity.SystemInfo;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import oshi.hardware.CentralProcessor;
import oshi.hardware.GlobalMemory;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.software.os.FileSystem;
import oshi.software.os.OperatingSystem;

@Component
public class ScheduledTask {
    private Logger logger = LoggerFactory.getLogger(ScheduledTask.class);
    public static List<AppInfo> appInfoList = Collections.synchronizedList(new ArrayList());
    @Autowired
    private RestUtil restUtil;
    @Autowired
    private CommonConfig commonConfig;
    private SystemInfo systemInfo = null;
    static ThreadPoolExecutor executor = new ThreadPoolExecutor(5, 10, 2L, TimeUnit.MINUTES, new LinkedBlockingDeque<Runnable>());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(initialDelay=59000L, fixedRate=120000L)
    public void minTask() {
        ArrayList APP_INFO_LIST_CP = new ArrayList();
        APP_INFO_LIST_CP.addAll(appInfoList);
        JSONObject jsonObject = new JSONObject();
        LogInfo logInfo = new LogInfo();
        Timestamp t = FormatUtil.getNowTime();
        logInfo.setHostname(this.commonConfig.getBindIp() + "\uff1aAgent\u9519\u8bef");
        logInfo.setCreateTime((Date)t);
        try {
            oshi.SystemInfo si = new oshi.SystemInfo();
            HardwareAbstractionLayer hal = si.getHardware();
            OperatingSystem os = si.getOperatingSystem();
            this.systemInfo = OshiUtil.os((CentralProcessor)hal.getProcessor(), (OperatingSystem)os);
            this.systemInfo.setCreateTime((Date)t);
            List deskStateList = OshiUtil.file((Timestamp)t, (FileSystem)os.getFileSystem());
            CpuState cpuState = OshiUtil.cpu((CentralProcessor)hal.getProcessor());
            cpuState.setCreateTime((Date)t);
            MemState memState = OshiUtil.memory((GlobalMemory)hal.getMemory());
            memState.setCreateTime((Date)t);
            NetIoState netIoState = OshiUtil.net((HardwareAbstractionLayer)hal);
            netIoState.setCreateTime((Date)t);
            SysLoadState sysLoadState = OshiUtil.getLoadState((SystemInfo)this.systemInfo, (CentralProcessor)hal.getProcessor());
            if (sysLoadState != null) {
                sysLoadState.setCreateTime((Date)t);
            }
            if (cpuState != null) {
                jsonObject.put("cpuState", (Object)cpuState);
            }
            if (memState != null) {
                jsonObject.put("memState", (Object)memState);
            }
            if (netIoState != null) {
                jsonObject.put("netIoState", (Object)netIoState);
            }
            if (sysLoadState != null) {
                jsonObject.put("sysLoadState", (Object)sysLoadState);
            }
            if (this.systemInfo != null) {
                if (memState != null) {
                    this.systemInfo.setVersionDetail(this.systemInfo.getVersion() + "\uff0c\u603b\u5185\u5b58\uff1a" + oshi.util.FormatUtil.formatBytes((long)hal.getMemory().getTotal()));
                    this.systemInfo.setMemPer(memState.getUsePer());
                } else {
                    this.systemInfo.setMemPer(Double.valueOf(0.0));
                }
                if (cpuState != null) {
                    this.systemInfo.setCpuPer(cpuState.getSys());
                } else {
                    this.systemInfo.setCpuPer(Double.valueOf(0.0));
                }
                jsonObject.put("systemInfo", (Object)this.systemInfo);
            }
            if (deskStateList != null) {
                jsonObject.put("deskStateList", (Object)deskStateList);
            }
            if (APP_INFO_LIST_CP.size() > 0) {
                ArrayList<AppInfo> appInfoResList = new ArrayList<AppInfo>();
                ArrayList<AppState> appStateResList = new ArrayList<AppState>();
                for (AppInfo appInfo : APP_INFO_LIST_CP) {
                    AppState appState;
                    appInfo.setHostname(this.commonConfig.getBindIp());
                    appInfo.setCreateTime((Date)t);
                    appInfo.setState("1");
                    String pid = FormatUtil.getPidByFile((AppInfo)appInfo);
                    if (StringUtils.isEmpty((CharSequence)pid) || (appState = OshiUtil.getLoadPid((String)pid, (OperatingSystem)os, (GlobalMemory)hal.getMemory())) == null) continue;
                    appState.setCreateTime((Date)t);
                    appState.setAppInfoId(appInfo.getId());
                    appInfo.setMemPer(appState.getMemPer());
                    appInfo.setCpuPer(appState.getCpuPer());
                    appInfoResList.add(appInfo);
                    appStateResList.add(appState);
                }
                jsonObject.put("appInfoList", appInfoResList);
                jsonObject.put("appStateList", appStateResList);
            }
            this.logger.debug("---------------" + jsonObject.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            logInfo.setInfoContent(e.toString());
        }
        finally {
            if (!StringUtils.isEmpty((CharSequence)logInfo.getInfoContent())) {
                jsonObject.put("logInfo", (Object)logInfo);
            }
            this.restUtil.post(this.commonConfig.getServerUrl() + "/wgcloud/agent/minTask", jsonObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(initialDelay=28000L, fixedRate=300000L)
    public void appInfoListTask() {
        JSONObject jsonObject = new JSONObject();
        LogInfo logInfo = new LogInfo();
        Timestamp t = FormatUtil.getNowTime();
        logInfo.setHostname(this.commonConfig.getBindIp() + "\uff1aAgent\u83b7\u53d6\u8fdb\u7a0b\u5217\u8868\u9519\u8bef");
        logInfo.setCreateTime((Date)t);
        try {
            JSONObject paramsJson = new JSONObject();
            paramsJson.put("hostname", (Object)this.commonConfig.getBindIp());
            String resultJson = this.restUtil.post(this.commonConfig.getServerUrl() + "/wgcloud/appInfo/agentList", paramsJson);
            if (resultJson != null) {
                JSONArray resultArray = JSONUtil.parseArray((String)resultJson);
                appInfoList.clear();
                if (resultArray.size() > 0) {
                    appInfoList = JSONUtil.toList((JSONArray)resultArray, AppInfo.class);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logInfo.setInfoContent(e.toString());
        }
        finally {
            if (!StringUtils.isEmpty((CharSequence)logInfo.getInfoContent())) {
                jsonObject.put("logInfo", (Object)logInfo);
            }
            this.restUtil.post(this.commonConfig.getServerUrl() + "/wgcloud/agent/minTask", jsonObject);
        }
    }
}

