<?php
namespace app\mobile\controller;
use app\common\logic\JssdkLogic;
use Think\Db;
use JSSDK;
class Index extends MobileBase {
	
	public function index2(){
		
		$this->fetch();
	}
    public function index(){
    	/*
			//获取微信配置
            $wechat_list = M('wx_user')->select();
            $wechat_config = $wechat_list[0];
            $this->weixin_config = $wechat_config;
            // 微信Jssdk 操作类 用分享朋友圈 JS
            $jssdk = new \Mobile\Logic\Jssdk($this->weixin_config['appid'], $this->weixin_config['appsecret']);
            $signPackage = $jssdk->GetSignPackage();
            print_r($signPackage);
        */
		//热门商品
		$brandid = session('brand_id');
		if(empty($brandid)){
		    $brand = getSiteBrand();
		    $brandid = $brand['id'];
		    session('brand_id',$brand['id']);
		}
        $hot_goods = M('goods')->where("is_hot=1 and is_on_sale=1 and ( brand_data_id = 0 or FIND_IN_SET(".(int)$brandid.",brand_data_id))")->order('sort DESC')->limit(24)->select();//首页热卖商品

        $thems = M('goods_category')->where('level=1')->order('sort_order')->limit(9)->cache(true,TPSHOP_CACHE_TIME)->select();
        $this->assign('thems',$thems);
        $this->assign('hot_goods',$hot_goods);

        $where = array('parent_id'=>0,'is_show'=>1,'is_hot'=>1);
        $cateArr = M("GoodsCategory")->where($where)->order("sort_order")->select();    //分类

        //会员等级
        $indexArr = db("user_level","dbvip")->limit(3)->select();
        $this->assign('catearr',$cateArr);
        $this->assign("levelarr",$indexArr);
        if(count($indexArr)==1){
            //只有一个会员等级时直接展示商品分类
            $where = array('parent_id'=>0,'is_show'=>1,'is_hot'=>1);
            $cateArr = M("GoodsCategory")->where($where)->order("sort_order")->select();	//分类
            $this->assign('catearr',$cateArr);
        }

		/**
		 * 广告位置查询
		 */
        //上方广告位
        $advon = db('advertising','dbvip')->where('adv_seat',10)->where('brandid',$brandid)->find();
        $advon = json_decode($advon['adv_detail'],true);

        $this->assign('advon',$advon);
        //下方广告位
        $advdown = db('advertising','dbvip')->where('adv_seat',11)->where('brandid',$brandid)->find();
        $advdown = json_decode($advdown['adv_detail'],true);
        $this->assign('advdown',$advdown);

        //客服电话
        $kefu = db('c_kf','dbvip')->where('brandid',session('brand_id'))->find();
        $this->assign('kefu',$kefu);

        $openid = session('openid');
        $user = db('m_users','dbvip')->where("openid",$openid)->find();

        //udesk客服
        $kfUrl = controller('Udesk')->udeskIM($user['id'],'商城首页-在线咨询');
        $this->assign('kfUrl',$kfUrl);

        //猜你喜欢
        $favourite_goods = M('goods')->where("is_recommend=1 and is_on_sale=1 and ( brand_data_id = 0 or FIND_IN_SET(".$brandid.",brand_data_id))")->field("goods_id,goods_name,shop_price,exchange_integral")->limit(24)->order('sort DESC')->select();//首页推荐商品

        //秒杀商品
        $now_time = time();  //当前时间
        if(is_int($now_time/7200)){      //双整点时间，如：10:00, 12:00
            $start_time = $now_time;
        }else{
            $start_time = floor($now_time/7200)*7200; //取得前一个双整点时间
        }
        $end_time = $start_time+7200;   //结束时间
        
        $index_view = config('index_view');
        
        $this->assign('openid',$openid);
        
        $this->assign('start_time',$start_time);
        $this->assign('end_time',$end_time);
        $this->assign('favourite_goods',$favourite_goods);

        if($index_view == '6j1'){
            return $this->fetch('index_fc');
        }else{
            return $this->fetch();
        }
        
    }
	
  

    /**
     * 分类列表显示
     */
    public function categoryList(){
        return $this->fetch();
    }
    
    /**
     * 模板列表
     */
    public function mobanlist(){
        $arr = glob("D:/wamp/www/svn_tpshop/mobile--html/*.html");
        foreach($arr as $key => $val)
        {
            $html = end(explode('/', $val));
            echo "<a href='http://www.php.com/svn_tpshop/mobile--html/{$html}' target='_blank'>{$html}</a> <br/>";            
        }        
    }
    
    /**
     * 商品列表页
     */
    public function goodsList(){
        $id = I('get.id/d',0); // 当前分类id
        $lists = getCatGrandson($id);
        $this->assign('lists',$lists);
        return $this->fetch();
    }
    
    public function ajaxGetMore(){
    	$p = I('p/d',1);
        $where = ['is_recommend'=>1,'is_on_sale'=>1,'virtual_indate'=>['exp',' = 0 OR virtual_indate > '.time()]];
    	$favourite_goods = Db::name('goods')->where($where)->order('goods_id DESC')->page($p,C('PAGESIZE'))->cache(true,TPSHOP_CACHE_TIME)->select();//首页推荐商品
    	$this->assign('favourite_goods',$favourite_goods);
    	return $this->fetch();
    }
    
    //微信Jssdk 操作类 用分享朋友圈 JS
    public function ajaxGetWxConfig(){
    	$askUrl = I('askUrl');//分享URL
    	require_once 'vendor'.DS.'weshare'.DS.'JSSDK.php';
        $brandid = session('brand_id');
        $appid = session('appid');
        $jssdk = new JSSDK($appid,$brandid,urldecode($askUrl));
        $signPackage = $jssdk->GetSignPackage();
     
     //    $weixin_config = M('wx_user')->find(); //获取微信配置
    	// $jssdk = new JssdkLogic($weixin_config['appid'], $weixin_config['appsecret']);
    	// $signPackage = $jssdk->GetSignPackage(urldecode($askUrl));
    	if($signPackage){
    		$this->ajaxReturn($signPackage,'JSON');
    	}else{
    		return false;
    	}
    }
       
}