<?php
namespace app\mobile\controller;
use think\Cache;
use think\Controller;
use think\Session;
class Udesk extends MobileBase {

    /**
     * 接入Udesk客服会话
     * @return mixed
     * @author Wangyining<wangyining@suxuantech.cn> 2019-02-15
     */
    public function udeskIM($user_id,$entry){

       /* $userData = db('m_users','dbvip')
            ->where('a.id',$user_id)
            ->alias('a')
            ->join('m_users_phone b','a.id = b.userid','left')
            ->field('a.id,a.username,b.user_number,a.real_address,a.simg,b.phone,b.real_name')
            ->find();*/

        $userData = db('m_users','dbvip')
            ->where('id',$user_id)
            ->find();

        //客服配置信息
        $kfData = db('c_kf','dbvip')->where('brandid',session('brand_id'))->find();
        //$kfData = controller('index', 'lib')->getKf();   //客服信息
        $key = $kfData['kf_key'];
        $url = $kfData['url'];

        //根据加密算法获取签名
        $data['timestamp'] = $this->msectime();
        $data['nonce'] = md5($this->createNonceStr());
        $data['web_token'] = $user_id;
        $signature = $this->signature($data,$key);

        $c_name= $userData['real_name'] ? $userData['real_name'] : $userData['username'];
        $c_phone = $userData['phone'];
        $c_cf_address = $userData['real_address'];
        $user_number = $userData['user_number'];

        $resUrl = strpos($url,'?') === false ? $url.'?' : $url.'&';
        $resUrl .= 'c_cf_address='.$c_cf_address.'&c_name='.$c_name.'&c_cf_会员中心ID='.$user_id.'&c_phone='.$c_phone.'&c_cf_会员卡号='.$user_number.'&c_cf_咨询入口='.$entry.'&nonce='.$data['nonce'].'&signature='.$signature.'&timestamp='.$data['timestamp'].'&web_token='.$data['web_token'];
        //$resUrl .= 'c_cf_address='.$c_cf_address.'&c_name='.$user_id.'&c_phone='.$c_phone.'&nonce='.$data['nonce'].'&signature='.$signature.'&timestamp='.$data['timestamp'].'&web_token='.$data['web_token'];

        return $resUrl;
    }

    //返回当前的毫秒时间戳
    public function msectime() {
        list($msec, $sec) = explode(' ', microtime());
        $msectime = (float)sprintf('%.0f', (floatval($msec) + floatval($sec)) * 1000);
        return $msectime;
    }


    /**
     * 签名验证
     * @return mixed
     * @author Wangyining<wangyining@suxuantech.cn> 2019-02-15
     */
    public function signature($data,$key){

        if(!empty($data)){
            ksort($data);
            $sign_str = '';
            foreach($data as $k=>$v){
                $sign_str .= $k.'='.$v.'&';
            }
        }

        $sign_str .= $key;

        $sign_sha1 = sha1($sign_str);
        $signature = strtoupper($sign_sha1);

        return $signature;
    }

    /**
     * 随机字符串
     * @return mixed
     * @author Wangyining<wangyining@suxuantech.cn> 2019-02-15
     */
    private function createNonceStr($length = 16) {
        $chars = "abcdefghijklmnopqrstuvwxyz0123456789";
        $str = "";
        for ($i = 0; $i < $length; $i++) {
            $str .= substr($chars, mt_rand(0, strlen($chars) - 1), 1);
        }
        return $str;
    }

}