<?php
class JSSDK {
  private $appId;
  private $brandid;
  private $errid;
  private $error;
  public function __construct($appId, $brandid, $url) {
    $this->appId = $appId;
    $this->brandid = $brandid;
    $this->url = $url;
  }

  public function getSignPackage() {
    $jsapiTicket = $this->getJsApiTicket();
    // 注意 URL 一定要动态获取，不能 hardcode.
    $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
    //$url = "$protocol$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
    if($this->url){
      $url = $this->url;
    }else{
      $url = "$protocol$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
    }
    $timestamp = time();
    $nonceStr = $this->createNonceStr();
    // 这里参数的顺序要按照 key 值 ASCII 码升序排序
    $string = "jsapi_ticket=$jsapiTicket&noncestr=$nonceStr&timestamp=$timestamp&url=$url";
    $signature = sha1($string);
    $signPackage = array(
      "appId"     => $this->appId,
      "nonceStr"  => $nonceStr,
      "timestamp" => $timestamp,
      "url"       => $url,
      "signature" => $signature,
      "rawString" => $string
    );
    if($jsapiTicket === false){
        $signPackage['signature']=$this->errid;
        $signPackage['rawString']=$this->error;
    }
    return $signPackage;
  }

  private function createNonceStr($length = 16) {
    $chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    $str = "";
    for ($i = 0; $i < $length; $i++) {
      $str .= substr($chars, mt_rand(0, strlen($chars) - 1), 1);
    }
    return $str;
  }

  private function getJsApiTicket() {
    // jsapi_ticket 应该全局存储与更新，以下代码以写入到文件中做示例
    //$data = json_decode($this->get_php_file($this->tokenfilepath."jsapi_ticket.php"));
    $cachekey = "ticket_brandid_".$this->brandid;
    $ticket   =  cache($cachekey);
    if (!$ticket) {
      $accessToken = $this->getAccessToken();
      if($accessToken === false){
          return false;
      }
      // 如果是企业号用以下 URL 获取 ticket
      // $url = "https://qyapi.weixin.qq.com/cgi-bin/get_jsapi_ticket?access_token=$accessToken";
      $url = "https://api.weixin.qq.com/cgi-bin/ticket/getticket?type=jsapi&access_token=$accessToken";
      $res = json_decode($this->httpGet($url));
      $ticket = $res->ticket;
      if($ticket) {
        $cachekey = "ticket_brandid_".$this->brandid;
        cache($cachekey,$ticket,7000);
      }else{
          $this->errid = $res->errcode;
          $this->error = $res->errmsg;
          return false;
      }
    }
    return $ticket;
  }

  private function getAccessToken() {
    // access_token 应该全局存储与更新，以下代码以写入到缓存中做
    $cachekey = "access_token_brandid_".$this->brandid;
    $access_token = cache($cachekey);
    if (!$access_token) {
      // 获取token
      $res=sx_call('5a60436d631a4',array('brandclass_id'=>$this->brandid));

      if($res['code']==200){
          $access_token = $res['data']['access_token'];
      }else{
          $this->error = $res['msg'];
          $this->errid = $res['code'];
          return false;
      }
      if($access_token) {
        $cachekey = "access_token_brandid_".$this->brandid;
        cache($cachekey,$access_token,7000);
      }
    }

    return $access_token;
  }

  private function httpGet($url) {
    $curl = curl_init();
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($curl, CURLOPT_TIMEOUT, 500);
    // 为保证第三方服务器与微信服务器之间数据传输的安全性，所有微信接口采用https方式调用，必须使用下面2行代码打开ssl安全校验。
    // 如果在部署过程中代码在此处验证失败，请到 http://curl.haxx.se/ca/cacert.pem 下载新的证书判别文件。
    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, true);
    curl_setopt($curl, CURLOPT_URL, $url);
    $res = curl_exec($curl);
    curl_close($curl);
    return $res;
  }

}

