
const common = {
    loadHtml : '<view class="loading" id="loading"><view class="loading-bg"><view class="loading-bd"><img src="/static/img/loading.gif" class="loading-icon"><view class="loading-title">{title}</view></view></view></view>',
    showLoading:(title)=>{
        title = title?title:"加载中...";
        if($("#loading").length == 0){
            let html = common.loadHtml.replace("{title}",title)
            $("body").append(html)
        }else{
            $(".loading-bd .loading-title").html(title);
        }
    },
    hideLoading:()=>{
        $("#loading").remove();
    },
    ajax:async (params)=>{
        params =  params?params:{};
        if(typeof params.data == "undefined"){
            params.data = {};
        }
        if(typeof params.type == "undefined"){
            params.type = "POST";
        }
        if(typeof params.type == "undefined"){
            throw new Error("无效的参数：url")
        }
        if(typeof params.dataType == "undefined"){
            params.dataType = "json";
        }

        return new Promise((resolve,reject)=>{
            $.ajax({
                type: params.type,
                url: params.url,
                data: params.data,
                dataType:params.dataType,
                success: function(ret){
                    if (ret.code == -1 ){
                       location.href="/login"
                       reject(new Error("登录已过期，请重新登录。"))
                    }else{
                        resolve(ret)
                    }
                },
                error:function(XMLHttpRequest, textStatus, errorThrown){
                    console.error("请求失败：",XMLHttpRequest,textStatus);
                    reject(new Error(errorThrown))
                }
            })
        })
    },
    buildHtmlFromTemplate:(id,data)=>{
        let tpl = '';
        let match;
        const cache = {}
        // 匹配模板id
        const idReg = /[\s\W]/g
        // 匹配JavaScript语句或变量
        const tplReg = /{%=?\s*([^%>]+?)\s*%}/g
        // 匹配各种关键字
        const keyReg = /(for|if|else|switch|case|break|{|})/g
        const add = (str, result, js) => {
            str = str.replace(/[\r\n\t]/g, '')
                .replace(/\\/g, '\\\\')
                .replace(/'/g, "\\'")
            result += js ? str.match(keyReg) ? `${str}` : `result.push(${str});` : `result.push('${str}');`
            return result
        }
        let cursor = 0
        let result = 'let result = [];'
        tpl = $("#"+id).html();
        // console.log(tpl)
        // 缓存处理
        if (cache[id]) {
            return cache[id].apply(data)
        }
        // 使用exec函数，动态改变index的值
        while (match = tplReg.exec(tpl)) {
            result = add(tpl.slice(cursor, match.index), result) // 匹配HTML结构
            result = add(match[1], result, true)		     // 匹配JavaScript语句、变量
            cursor = match.index + match[0].length		     // 改变HTML结果匹配的开始位置
        }

        result = add(tpl.slice(cursor), result)		             // 匹配剩余的HTML结构
        result += 'return result.join("")'
        // console.log(result)
        let fn = new Function(result)		                     // 转成可执行的JS代码
        
        
        if (!cache[id]) {                       // 缓存模板
            cache[id] = fn
        }
        return fn.apply(data)		                              // apply改变函数执行的作用域
    },
}