<?php
/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
namespace app\crm\lib;
use think\Controller;
use app\common\lib\redisQueue;
use PHPExcel_IOFactory;
use Excel5;
use PHPExcel;
class RunExcelImport extends Controller {

    protected $shop_type = '';
    protected $importHeader = [];
    public function cus_import($data){
        // 参与排重的联系方式 设定
        $exclusion_field = config('exclusion_field');

        $customer = [];
        $fail_array =[];
        // $this->log('begin--eid-'.$data['eid']);
        // 更新导入表状态 及查询归属店、事业部
        db('crm_c_excel_import')->where(array('id'=>$data['eid']))->update(array('status'=>2));
        $eInfo = db('crm_c_excel_import')
            ->where('id', $data['eid'])
            ->field('staff_id,belong_shop_code as shop_code,belong_shop_name as shop_name,brandclass_id,brandclass,add_shop_code,add_shop_name')
            ->find();
        $data['staff_id']  = $eInfo['staff_id'];
        $data['shop_code'] = $eInfo['shop_code'];
        $data['shop_name'] = $eInfo['shop_name'];
        $data['brandclass_id'] = $eInfo['brandclass_id'];
        $data['brandclass'] = $eInfo['brandclass'];
        
        $lrMust = db_config('lr_must_'.$eInfo['brandclass_id']);
        if ($lrMust || $eInfo['shop_code'] == 'TSYX13') {
            $lrMust = explode(',',trim($lrMust,','));
            //成都网销中心录入客资 ‘获取方式’为必填项
            if(!in_array('access_model',$lrMust)){
                $lrMust[] = 'access_model';
            }
            $this->log('录入必选项'.json_encode($lrMust));
        }else{
            $lrMust = false;
            $this->log('录入必选项'.$lrMust);
        }

        // 查询导入的数据
        $excel_array = db('crm_c_excel_import_data')
            ->where('eid',$data['eid'])
            ->where('import_status','<>', 1)
            ->select();
        if(!$excel_array){
            // 更新状态已完成
            db('crm_c_excel_import')->where(array('id'=>$data['eid']))->update(array('status'=>1));
            cache('upload_percent_'.$data['eid'],['eid'=>$data['eid'],'all_number'=>0,'upload_num'=>0,'status'=>2]);
            return false;
        }
        $header = import_header_child();//标准表头格式
        // 统计数量  开始导入
        $all_number = count($excel_array);
        cache('upload_percent_'.$data['eid'],['eid'=>$data['eid'],'all_number'=>$all_number,'upload_num'=>0,'status'=>1]);
        $this->log('总数据量'.$all_number);
        // 获取地区id
        $province = db('crm_s_address')
            ->where('type', '1')
            ->column('id,pid,name','name');
        // $this->log('省..'.json_encode($province));
        $city = db('crm_s_address')
            ->where('type', '2')
            ->column('id,pid,name','name');
        // $this->log('市..'.json_encode($city));
        $county = db('crm_s_address')
            ->where('type', '3')
            ->column('id,pid,name','name');
        // $this->log('区..'.json_encode($county));
        // 当前时间
        $time = date('Y-m-d H:i:s');
        $now_xh_num = 1;//当前foreach循环次数
        $num = 1;//本次foreach处理成功数据条数
        $contact=array();//用于文件数据中排重的联系方式        
        try {
            $this->log('start');
            foreach($excel_array as $k=>$v) { 
                // eric
                if ($k==$all_number-1) {
                    db('crm_c_excel_import')->where(array('id'=>$data['eid']))->update(array('status'=>1));
                    $this->log('--:lasttimesql==》'.db()->getLastSql());
                    cache('upload_percent_'.$data['eid'],['eid'=>$data['eid'],'all_number'=>$all_number,'upload_num'=>$k+1,'status'=>2]);
                }
                // sleep(2);
                $this->log('==='.$k);
                $tempInfo = $v;
                unset($tempInfo['id']);
                cache('upload_percent_'.$data['eid'],['eid'=>$data['eid'],'all_number'=>$all_number,'upload_num'=>$k+1,'status'=>1]);
                db()->startTrans();
                // 系统必选项
                if(!$v['customer_tel'] && !$v['customer_wechat']){
                    db('crm_c_excel_import')->where('id',$data['eid'])->setInc('fail_number');
                    $failData['msg']   = '列：妈妈电话、微信，不能为空';
                    $failData['import_status']= 2;
                    db('crm_c_excel_import_data')->where('id',$v['id'])->update($failData);
                    db()->commit();
                    continue;
                }
                if(!$v['baby_birthday'] && !$v['ready_baby_day'] && !$v['record_day']){
                    db('crm_c_excel_import')->where('id',$data['eid'])->setInc('fail_number');
                    $failData['msg']   = '列：宝宝生日、预产期、填写日期，不能为空';
                    $failData['import_status']= 2;
                    db('crm_c_excel_import_data')->where('id',$v['id'])->update($failData);
                    db()->commit();
                    continue;
                }
                if(!$v['customer_channel']){
                    db('crm_c_excel_import')->where('id',$data['eid'])->setInc('fail_number');
                    $failData['msg'] = '列：渠道名称，不能为空';
                    $failData['import_status'] = 2;
                    db('crm_c_excel_import_data')->where('id',$v['id'])->update($failData);
                    db()->commit();
                    continue;
                }
                // 设定的必填项
                if ($lrMust) {
                    $mustFail = false;
                    foreach ($lrMust as $key => $value) {
                        if (!trim($v[$value])) {
                            $mustFail = true;
                            $failData['msg'] = '列：'.$header[$value].'，不能为空';
                            $failData['import_status'] = 2;
                            continue;
                        }
                    }
                    if($mustFail){
                        db('crm_c_excel_import')->where('id',$data['eid'])->setInc('fail_number');
                        db('crm_c_excel_import_data')->where('id',$v['id'])->update($failData);
                        db()->commit();
                        continue;
                    }
                }

                $tempInfo['eid'] = $v['eid'];
                // 宝宝姓名
                if(!empty($v['baby_name'])) {
                    $tempInfo['baby_name'] = $v['baby_name'];
                }
                // 宝宝性别
                if(!empty($v['baby_sex'])) {
                    $tempInfo['baby_sex'] = $v['baby_sex'];
                }
                // 宝宝生日
                if(!empty($v['baby_birthday'])) {
                    if ($v['baby_birthday']=='1970-01-01' || $v['baby_birthday']=='1970-01-01 00:00:00') {
                        db('crm_c_excel_import')->where('id',$data['eid'])->setInc('fail_number');
                        $failData['msg']   = '列：宝宝生日，填写错误';
                        $failData['import_status']= 2;
                        db('crm_c_excel_import_data')->where('id',$v['id'])->update($failData);
                        db()->commit();
                        continue;
                    }else{
                        $tempInfo['baby_birthday'] = date('Y-m-d H:i:s',strtotime($v['baby_birthday']));
                    }
                }
                // 预产期
                if(!empty($v['ready_baby_day'])) {
                    if ($v['ready_baby_day']=='1970-01-01' || $v['ready_baby_day']=='1970-01-01 00:00:00') {
                        db('crm_c_excel_import')->where('id',$data['eid'])->setInc('fail_number');
                        $failData['msg']   = '列：预产日期，填写错误';
                        $failData['import_status']= 2;
                        db('crm_c_excel_import_data')->where('id',$v['id'])->update($failData);
                        db()->commit();
                        continue;
                    }else{
                        $tempInfo['ready_baby_day'] = date('Y-m-d H:i:s',strtotime($v['ready_baby_day']));
                    }
                }
                // 填写日期
                if(!empty($v['record_day'])) {
                    if ($v['record_day']=='1970-01-01' || $v['record_day']=='1970-01-01 00:00:00') {
                        db('crm_c_excel_import')->where('id',$data['eid'])->setInc('fail_number');
                        $failData['msg']   = '列：填写日期，填写错误';
                        $failData['import_status']= 2;
                        db('crm_c_excel_import_data')->where('id',$v['id'])->update($failData);
                        db()->commit();
                        continue;
                    }else{
                        $tempInfo['record_day'] = date('Y-m-d H:i:s',strtotime($v['record_day']));
                    }
                }
                // 宝宝出生地
                if(!empty($v['baby_address'])) {
                    $tempInfo['baby_address'] = trim($v['baby_address']);
                }
                // 妈妈姓名
                if (!empty($v['customer_name'])) {
                    $tempInfo['customer_name'] = trim($v['customer_name']);
                }
                // 妈妈手机
                if (!empty($v['customer_tel'])) {
                    if (in_array($v['customer_tel'],$contact)) {
                        db('crm_c_excel_import')->where('id',$data['eid'])->setInc('fail_number');
                        $failData['msg']   = '列：妈妈手机号，填写重复';
                        $failData['import_status']= 2;
                        db('crm_c_excel_import_data')->where('id',$v['id'])->update($failData);
                        db()->commit();
                        continue;
                    }
                    if (check_tel($v['customer_tel'])) {
                        $tempInfo['customer_tel']= trim($v['customer_tel']);
                        $tempInfo['tel_staff_id']= $v['dj_staff_id'];
                        $tempInfo['tel_staff']   = $v['dj_staff'];
                        $tempInfo['tel_time']    = $time;
                        $tempInfo['is_first_tel']= 1;
                        if (in_array('customer_tel',$exclusion_field)) {
                            array_push($contact,$v['customer_tel']);
                        }
                    }else{
                        db('crm_c_excel_import')->where('id',$data['eid'])->setInc('fail_number');
                        $failData['msg']   = '列：妈妈手机号，填写错误';
                        $failData['import_status']= 2;
                        db('crm_c_excel_import_data')->where('id',$v['id'])->update($failData);
                        db()->commit();
                        continue;
                    }
                }else{
                    $tempInfo['tel_staff_id']= null;
                    $tempInfo['tel_staff']   = '';
                    $tempInfo['tel_time']    = null;
                    $tempInfo['is_first_tel']= null;
                }
                // 妈妈微信
                if (!empty($v['customer_wechat'])) {
                    $tempInfo['customer_wechat']= trim($v['customer_wechat']);
                    $tempInfo['tel_staff_id']= $v['dj_staff_id'];
                    $tempInfo['tel_staff']   = $v['dj_staff'];
                    $tempInfo['tel_time']    = $time;
                    $tempInfo['is_first_tel']= 1;
                    if (in_array('customer_wechat',$exclusion_field)) {
                        array_push($contact,$v['customer_wechat']);
                    }
                }else{
                    $tempInfo['wechat_staff_id']= null;
                    $tempInfo['wechat_staff']   = '';
                    $tempInfo['wechat_time']    = null;
                    $tempInfo['is_first_wechat']= null;
                }
                // 妈妈QQ
                if(!empty($v['customer_qq'])) {
                    $tempInfo['customer_qq'] = trim($v['customer_qq']);
                }
                // 妈妈微博
                if(!empty($v['customer_weibo'])) {
                    $tempInfo['customer_weibo'] = trim($v['customer_weibo']);
                }
                // 爸爸姓名
                if (!empty($v['mate_name'])) {
                    $tempInfo['mate_name'] = trim($v['mate_name']);
                }
                // 爸爸手机
                if (!empty($v['mate_tel'])) {
                    if (check_tel($v['mate_tel'])) {
                        $tempInfo['mate_tel']= trim($v['mate_tel']);
                        if (in_array('mate_tel',$exclusion_field)) {
                            array_push($contact,$v['mate_tel']);
                        }
                    }else{
                        $failData['msg']   = '列：爸爸手机号，填写错误';
                        $failData['import_status']= 2;
                        db('crm_c_excel_import_data')->where('id',$v['id'])->update($failData);
                        db()->commit();
                        continue;
                    }
                }
                // 组织结构
                $orz = [
                    'add_shop_code'=> $eInfo['add_shop_code'],
                    'shop_code'    => $eInfo['shop_code'],
                    'brandclass'   => $eInfo['brandclass'],
                ];
                // 联系方式
                $con = [
                    'customer_tel'   => $v['customer_tel'],
                    'customer_wechat'=> $v['customer_wechat'],
                    'mate_tel'       => $v['mate_tel'],
                    'mate_wechat'    => $v['mate_wechat'],
                ];
                // 其他排重条件
                $other = [
                    'channel' => $v['customer_channel'],
                ];
                $arr = controller('crm/Customer','lib')->isRepeat($orz,$con,$other,0);
                $this->log('isRepeat---'.json_encode($arr));
                unset($orz,$con,$other);
                if($arr['code'] == 201){
                    db('crm_c_excel_import')->where('id',$data['eid'])->setInc('fail_number');
                    $failData['msg']   = '系统内已存在此客资！';
                    $failData['import_status']= 2;
                    db('crm_c_excel_import_data')->where('id',$v['id'])->update($failData);
                    db()->commit();
                    continue;
                }else{
                    // 客户标识
                    $tempInfo['c_unique'] = $arr['c_unique'] ? $arr['c_unique'] : '';
                    // 省
                    if (!empty($v['province'])) {
                        $tempInfo['province']   = trim($v['province']);
                        $tempInfo['province_id']= $province[$v['province']]['id'];
                    }
                    // 市
                    if (!empty($v['city'])) {
                        $tempInfo['city']   = trim($v['city']);
                        $tempInfo['city_id']= $city[$v['city']]['id'];
                    }
                    // 地区
                    if (!empty($v['county'])) {
                        $tempInfo['county'] = trim($v['county']);
                        $tempInfo['county_id'] = $county[$v['county']]['id'];
                    }
                    // 详细地址
                    if (!empty($v['customer_address'])) {
                        $tempInfo['customer_address'] = trim($v['customer_address']);
                    }
                    // 客户类型
                    if ($v['customer_type']=='转介绍') {
                        $tempInfo['customer_type'] = 2;
                    }else{
                        $tempInfo['customer_type'] = 1;
                    }
                    // 介绍人姓名
                    if (!empty($v['introducer_name'])) {
                        $tempInfo['introducer_name'] = trim($v['introducer_name']);
                    }
                    // 渠道名称
                    if (!empty($v['customer_channel'])) {
                        $conditions['customer_channel'] = $v['customer_channel'];
                    }
                    // 获取方式
                    if (!empty($v['access_model'])) {
                        $conditions['access_model'] = $v['access_model'];
                    }
                    // 消费类型
                    if (!empty($v['consultation_type'])) {
                        $conditions['consultation_type'] = $v['consultation_type'];
                    }
                    // 客户来源
                    if (!empty($v['customer_cource'])) {
                        $conditions['customer_cource'] = $v['customer_cource'];
                    }
                    // 客户分区
                    if (!empty($v['customer_area'])) {
                        $conditions['customer_area'] = $v['customer_area'];
                    }
                    // 客户意向
                    if (!empty($v['customer_intention'])) {
                        $conditions['customer_intention'] = $v['customer_intention'];
                    }
                    // 意向店面
                    if (!empty($v['consulation_shop'])) {
                       $conditions['consulation_shop'] = $v['consulation_shop'];
                    }
                    // 接单点
                    if (!empty($v['customer_orderaddress'])) {
                       $conditions['customer_orderaddress'] = $v['customer_orderaddress'];
                    }
                    // 追踪人
                    if (!empty($v['sales_staff'])) {
                        $conditions['sales_staff'] = $v['sales_staff'];
                    }
                    $conditions['brandclass_id'] = $eInfo['brandclass_id'];
                    $this->log('allParam--'.json_encode($conditions));
                    $this->log('allParama--'.$eInfo['add_shop_code']);
                    $this->log('allParams--'.$eInfo['shop_code']);
                    // 所有 相关的 ID
                    $all_id=controller('crm/Customer','lib')->get_set_id($conditions,$eInfo['add_shop_code'],$eInfo['shop_code']);
                    $this->log('all_id--'.json_encode($all_id));
                    if(empty($all_id)){
                        db('crm_c_excel_import')->where('id',$data['eid'])->setInc('fail_number');
                        $failData['msg']   = '填写信息错误！';
                        $failData['import_status']= 2;
                        db('crm_c_excel_import_data')->where('id',$v['id'])->update($failData);
                        db()->commit();
                        continue;
                    }
                    // 渠道名称 eric
                    if (!empty($v['customer_channel'])) {
                        $this->log('--time:'.microtime(true).'==>line:'.__LINE__);
                        if($v['customer_channel']&&empty($all_id['customer_channel_id'])){
                            db('crm_c_excel_import')->where('id',$data['eid'])->setInc('fail_number');
                            $failData['msg']   = '渠道名称填写有误';
                            $failData['import_status']= 2;
                            db('crm_c_excel_import_data')->where('id',$v['id'])->update($failData);
                            db()->commit();
                            continue;
                        }
                        $tempInfo['customer_channel']   = $v['customer_channel'];
                        $tempInfo['customer_channel_id']= $all_id['customer_channel_id'];
                    }
                    // 获取方式
                    if (!empty($v['access_model'])) {
                        $this->log('--time:'.microtime(true).'==>line:'.__LINE__);
                        if($v['access_model']&&empty($all_id['access_model_id'])){
                            db('crm_c_excel_import')->where('id',$data['eid'])->setInc('fail_number');
                            $failData['msg']   = '获取方式，填写有误';
                            $failData['import_status']= 2;
                            db('crm_c_excel_import_data')->where('id',$v['id'])->update($failData);
                            db()->commit();
                            continue;
                        }
                        $tempInfo['access_model'] = $v['access_model'];
                        $tempInfo['access_model'] = $all_id['access_model_id'];
                    }
                    // 消费类型
                    if (!empty($v['consultation_type'])) {
                        $this->log('--time:'.microtime(true).'==>line:'.__LINE__);
                        if($v['consultation_type']&&empty($all_id['consultation_type_id'])){
                            db('crm_c_excel_import')->where('id',$data['eid'])->setInc('fail_number');
                            $failData['msg']   = '消费类型，填写有误';
                            $failData['import_status']= 2;
                            db('crm_c_excel_import_data')->where('id',$v['id'])->update($failData);
                            db()->commit();
                            continue;
                        }
                        $tempInfo['consultation_type'] = $v['consultation_type'];
                        $tempInfo['consultation_type_id'] = $all_id['consultation_type_id'];
                    }
                    // 客户来源
                    if (!empty($v['customer_cource'])) {
                        $this->log('--time:'.microtime(true).'==>line:'.__LINE__);
                        if($v['customer_cource']&&empty($all_id['customer_cource_id'])){
                            db('crm_c_excel_import')->where('id',$data['eid'])->setInc('fail_number');
                            $failData['msg']   = '客户来源，填写有误';
                            $failData['import_status']= 2;
                            db('crm_c_excel_import_data')->where('id',$v['id'])->update($failData);
                            db()->commit();
                            continue;
                        }
                        $tempInfo['customer_cource'] = $v['customer_cource'];
                        $tempInfo['customer_cource_id'] = $all_id['customer_cource_id'];
                    }
                    // 客户分区
                    if (!empty($v['customer_area'])) {
                        $this->log('--time:'.microtime(true).'==>line:'.__LINE__);
                        if($v['customer_area']&&empty($all_id['customer_area_id'])){
                            db('crm_c_excel_import')->where('id',$data['eid'])->setInc('fail_number');
                            $failData['msg']   = '客户分区，填写有误';
                            $failData['import_status']= 2;
                            db('crm_c_excel_import_data')->where('id',$v['id'])->update($failData);
                            db()->commit();
                            continue;
                        }
                        $tempInfo['customer_area'] = $v['customer_area'];
                        $tempInfo['customer_area_id'] = $all_id['customer_area_id'];
                    }
                    // 客户意向
                    if (!empty($v['customer_intention'])) {
                        $this->log('--time:'.microtime(true).'==>line:'.__LINE__);
                        if($v['customer_intention']&&empty($all_id['customer_intention_id'])){
                            db('crm_c_excel_import')->where('id',$data['eid'])->setInc('fail_number');
                            $failData['msg']   = '客户意向，填写有误';
                            $failData['import_status']= 2;
                            db('crm_c_excel_import_data')->where('id',$v['id'])->update($failData);
                            db()->commit();
                            continue;
                        }
                        $tempInfo['customer_intention'] = $v['customer_intention'];
                        $tempInfo['customer_intention_id'] = $all_id['customer_intention_id'];
                    }
                    // 意向店面
                    if (!empty($v['consulation_shop'])) {
                        $this->log('--time:'.microtime(true).'==>line:'.__LINE__);
                        if($v['consulation_shop']&&empty($all_id['consulation_shop_code'])){
                            db('crm_c_excel_import')->where('id',$data['eid'])->setInc('fail_number');
                            $failData['msg']   = '意向店面，填写有误';
                            $failData['import_status']= 2;
                            db('crm_c_excel_import_data')->where('id',$v['id'])->update($failData);
                            db()->commit();
                            continue;
                        }
                        $tempInfo['consulation_shop'] = $v['consulation_shop'];
                        $tempInfo['consulation_shop_code'] = $all_id['consulation_shop_code'];
                    }
                    // 接单点
                    if (!empty($v['customer_orderaddress'])) {
                        $this->log('--time:'.microtime(true).'==>line:'.__LINE__);
                        if($v['customer_orderaddress']&&empty($all_id['customer_orderaddress_id'])){
                            db('crm_c_excel_import')->where('id',$data['eid'])->setInc('fail_number');
                            $failData['msg']   = '接单点，填写有误';
                            $failData['import_status']= 2;
                            db('crm_c_excel_import_data')->where('id',$v['id'])->update($failData);
                            db()->commit();
                            continue;
                        }
                        $tempInfo['customer_orderaddress'] = $v['customer_orderaddress'];
                        $tempInfo['customer_orderaddress'] = $all_id['customer_orderaddress_id'];
                    }
                    // 追踪人
                    if (!empty($v['sales_staff'])) {
                        $this->log('--time:'.microtime(true).'==>line:'.__LINE__);
                        if($v['sales_staff']&&empty($all_id['sales_staff_id'])){
                            db('crm_c_excel_import')->where('id',$data['eid'])->setInc('fail_number');
                            $failData['msg']   = '追踪人，填写有误';
                            $failData['import_status']= 2;
                            db('crm_c_excel_import_data')->where('id',$v['id'])->update($failData);
                            db()->commit();
                            continue;
                        }
                        $tempInfo['sales_staff']        = $v['sales_staff'];
                        $tempInfo['sales_staff_id']     = $all_id['sales_staff_id'];
                        $tempInfo['sales_staff_number'] = $all_id['sales_staff_number'];
                        $tempInfo['sales_group_id']     = $all_id['sales_group_id'];
                        $tempInfo['sales_group_name']   = $all_id['sales_group_name'];
                        $tempInfo['sales_department_id']= $all_id['sales_department_id'];
                        $tempInfo['sales_department_name']= $all_id['sales_department_name'];
                        $tempInfo['is_fp'] = 1;
                        $tempInfo['fp_staff'] = $v['dj_staff'];
                        $tempInfo['fp_staff_id'] = $v['dj_staff_id'];
                        $tempInfo['fp_staff_number'] = $v['dj_staff_number'];
                        $tempInfo['fp_day'] = $time;
                        $tempInfo['jr_day'] = $time;
                    }
                    /********************************************************/
                    // 推广编号
                    if (!empty($v['channel_plan_number'])) {
                        $this->log('--time:'.microtime(true).'==>line:'.__LINE__);
                        $tempInfo['channel_plan_number'] = trim($v['channel_plan_number']);
                    }
                    // 广告落地页
                    if (!empty($v['ad_page'])) {
                        $this->log('--time:'.microtime(true).'==>line:'.__LINE__);
                        $tempInfo['ad_page'] = trim($v['ad_page']);
                    }
                    // 客资备注
                    if (!empty($v['customer_remark'])) {
                        $this->log('--time:'.microtime(true).'==>line:'.__LINE__);
                        $tempInfo['customer_remark'] = trim($v['customer_remark']);
                    }
                    // 转介绍人
                    if (!empty($v['introduce_staff_name'])) {
                        $this->log('--time:'.microtime(true).'==>line:'.__LINE__);
                        $tempInfo['introduce_staff_name'] = trim($v['introduce_staff_name']);
                    }
                    // 关键字
                    if (!empty($v['customer_key'])) {
                        $this->log('--time:'.microtime(true).'==>line:'.__LINE__);
                        $tempInfo['customer_key'] = trim($v['customer_key']);
                    }
                    $this->log('--time:'.microtime(true).'==>line:'.__LINE__);
                    // 登记人
                    $tempInfo['dj_staff']        = $v['dj_staff'];
                    $tempInfo['dj_staff_id']     = $v['dj_staff_id'];
                    $tempInfo['dj_staff_number'] = $v['dj_staff_number'];
                    $tempInfo['dj_group_id']     = $v['dj_group_id'];
                    $tempInfo['dj_group_name']   = $v['dj_group_name'];
                    $tempInfo['dj_department_id']= $v['dj_department_id'];
                    $tempInfo['dj_department_name']= $v['dj_department_name'];
                    $tempInfo['add_shop_code'] = $v['add_shop_code'];
                    $tempInfo['add_shop_name'] = $v['add_shop_name'];
                    // 归属店面
                    $tempInfo['shop_code'] = $v['shop_code'];
                    $tempInfo['shop_name'] = $v['shop_name'];
                    // 事业部信息
                    $tempInfo['brandclass_id']= $v['brandclass_id'];
                    $tempInfo['brandclass']   = $v['brandclass'];
                    // 时间
                    $tempInfo['dj_day']     = $time;
                    $tempInfo['create_time']= $time;
                    $tempInfo['update_time']= $time;
                    $tempInfo['yx_day']     = $time;
                    $this->log('--time:'.microtime(true).'==>line:'.__LINE__);
                    // 有效新客
                    $is_valid_new = isValidNew($v);
                    $this->log('--validNew:'.$is_valid_new.':tel:'.$v['customer_tel']);
                    if (!$v['customer_tel'] || $is_valid_new) {
                        $this->log('--time:'.microtime(true).'==>line:'.__LINE__);
                        $tempInfo['valid_new'] = 1;
                        $tempInfo['is_valid'] = 2;
                       // $tempInfo['yx_day'] = date('Y-m-d H:i:s');
                        $upImportData['valid_new'] = 1;
                    }else{
                        $this->log('--time:'.microtime(true).'==>line:'.__LINE__);
                        $tempInfo['valid_new'] = 0;
                        $tempInfo['is_valid']  = 3;
                        $tempInfo['yx_day']  = date('Y-m-d H:i:s');
                        $upImportData['valid_new'] = 0;
                    }

                }
                $this->log('--time:'.microtime(true).'==>line:'.__LINE__);
                $same_tel = db('crm_c_customer_main')->where('brandclass_id',$eInfo['brandclass_id'])->where('wphone',$tempInfo['customer_tel'])->count();
                $upImportData['same_tel'] = $same_tel;
                $this->log('--time:'.microtime(true).'==>line:'.__LINE__);
                // $this->log('|sameSql=='.db()->getLastSql());
                $upImportData['import_status'] = 1;
                $upImportData['msg'] = NULl;
                db('crm_c_excel_import_data')->where('id',$v['id'])->update($upImportData);
                $this->log('--time:'.microtime(true).'==>line:'.__LINE__);
                // $this->log('|insSql=='.db()->getLastSql());
                db()->commit();
                // $this->log('|doCommit');
                $this->log('--time:'.microtime(true).'==>line:'.__LINE__);
                unset($upImportData);
                if (!empty($tempInfo)) {
                    $this->log('--time:'.microtime(true).'==>line:'.__LINE__);
                    $hq_num = db('crm_c_customerinfo')
                        ->where('customer_tel',$tempInfo['customer_tel'])
                        ->count();
                    if ($hq_num) {
                        $tempInfo['huoqu_num'] = $hq_num+1;
                    }else{
                        $tempInfo['huoqu_num'] = 1;
                    }

                    $tempInfo['i_id'] = $v['id'];
                    unset($tempInfo['same_tel'],$tempInfo['import_status'],$tempInfo['msg']);
                    // $this->log('This--'.json_encode($tempInfo));
                    if (!$customer) {
                        $customer = [];
                    }
                    array_push($customer, $tempInfo);
                    // $this->log('ThisC--'.json_encode($customer));
                }
                $this->log('num=='.$num.';all_number'.$all_number);
                if($num>=50||$k==$all_number-1){
                    $this->log('--time:'.microtime(true).'==>line:'.__LINE__);
                    // $this->log('本条数据--------->'.json_encode($customer));
                    $this->log('key=='.$k.';all_number'.$all_number);
                    if ($k==$all_number-1) {
                        $last = 1;
                        if (!empty($customer)) {
                            $res=$this->doImport($all_number,$customer,$fail_array,$fileData,$data,$contact,$last);
                        }else{
                            $this->fpList($data);//分adadmi配队列
                        }
                    }else{
                        if (!empty($customer)) {
                            $res=$this->doImport($all_number,$customer,$fail_array,$fileData,$data,$contact,0);
                        }else{
                            $res = true;
                        }
                    }
                    
                    $this->log('doImport--'.json_encode($res));
                    if($res===false){
                        $this->log('导入数据执行失败');
                        cache('upload_percent_'.$id,['eid'=>$id,'all_number'=>$all_number,'upload_num'=>0,'status'=>99]);
                        return false;
                    }else{
                        cache('upload_percent_'.$data['eid'],['eid'=>$data['eid'],'all_number'=>$all_number,'upload_num'=>$k+1,'status'=>1]);
                        $customer= [];
                        $contact = [];
                        cache('import_excel_'.$data['eid'],$k);
                        // $this->log('%%%%%%%%%%%%%%%%%%%%%%%%%%%');
                        $num=1;
                    }
                    $now_xh_num++;
                    continue;
                }else{
                    $num++;
                    //unset($conditions);
                    //unset($all_id);
                }
            }
            if ($customer) {
                $res=$this->doImport($all_number,$customer,$fail_array,$fileData,$data,$contact,1);
                if($res===false){
                    $this->log('导入数据执行失败');
                    cache('upload_percent_'.$id,['eid'=>$id,'all_number'=>$all_number,'upload_num'=>0,'status'=>99]);
                    return false;
                }else{
                    cache('upload_percent_'.$data['eid'],['eid'=>$data['eid'],'all_number'=>$all_number,'upload_num'=>$k+1,'status'=>1]);
                    $customer= [];
                    $contact = [];
                    cache('import_excel_'.$data['eid'],$k);
                    // $this->log('%%%%%%%%%%%%%%%%%%%%%%%%%%%');
                }
            }
        } catch (\Exception $e) {
            $this->log('|error==>'.$e->getMessage());
            db()->rollback();
            db('crm_c_excel_import')->where('id',$v['id'])->update($failData);

        }
    }

    /*将costomer数组类数据进行入库
     *将错误数组写入excel
     * 将excel_import表更新已处理和错误数量
     * $all_number     文件总数量
     * $customer       已处理成功数据
     * $failCustomer   过滤失败数据
     * $fileData       文件信息
     * $data           队列输入的数据
     * $contact        已处理成功数据的联系方式（一维数组）
     * $last           是否是最后一次，0：否，1：是
     */
    function doImport($all_number,$customer,$failCustomer,$fileData,$data,$contact,$last=0){
        $this->log('====inDoImport====');
        $this->log('====lasta:'.$last);
        db()->startTrans();//开启事务
        try{
            if(count($customer)>0){
                foreach ($customer as $key => $value) {
                    $mainRes = dealMain($value['c_unique'], $value);
                    if ($mainRes['code'] == 200) {
                        $customer[$key]['c_unique'] = $mainRes['c_unique'];
                        unset($customer[$key]['i_id']);
                    }else{
                        $failData['msg'] = '生成客户信息失败'.$mainRes['err'];
                        $failData['import_status']= 2;
                        db('crm_c_excel_import_data')->where('id',$value['i_id'])->update($failData);
                        db()->commit();
                        unset($customer[$key]);
                        continue;
                    }
                }
                // $this->log('inData---'.json_encode($customer));
                db('crm_c_customerinfo')->insertAll($customer);
                $this->log('====执行添加====');
                //通过eid查询导入的客资id,插入到排重表
                $eInfo = db('crm_c_customerinfo')->where('eid',$data['eid'])->master()->field('id,eid,c_unique,baby_name,baby_sex,baby_birthday,ready_baby_day,customer_name,customer_tel,customer_wechat,mate_name,mate_tel,customer_channel,consultation_type,customer_cource,consulation_shop,brandclass,dj_staff_id,add_shop_code,add_shop_name,shop_code,shop_name,dj_staff,sales_staff,brandclass_id,sales_staff_id')->order('id desc')->limit(count($customer))->select();
                // 日志用tels
                $tels = '';
                foreach($eInfo as $kk=>$vv){
                    // 记录一次获取日志
                    $logStr = '新增一次获取。宝宝姓名：'.$vv['baby_name'].'；宝宝性别：'.$vv['baby_sex'].'；宝宝生日：'.$vv['baby_birthday'].'；预产期：'.$vv['ready_baby_day'].'；妈妈姓名：'.$vv['customer_name'].'；妈妈电话：'.$vv['customer_tel'].'；妈妈微信：'.$vv['customer_wechat'].'；爸爸姓名：'.$vv['mate_name'].'；爸爸手机：'.$vv['mate_tel'].'；渠道名称：'.$vv['customer_channel'].'；消费类型：'.$vv['consultation_type'].'；客户来源：'.$vv['customer_cource'].'；意向店面：'.$vv['consulation_shop'].'；登记人：'.$vv['dj_staff'].'；追踪人：'.$vv['sales_staff'].'；录入店面：'.$vv['add_shop_name'].'；归属店面：'.$vv['shop_name'].'；';
                    history_log($logStr,$vv,$vv['id'],$vv['dj_staff_id'],$vv['dj_staff'],'crm','Customer','RunExcelImport');

                    $model = db_config('is_send_sms_'.$vv['add_shop_code']);
                    $msgUser = db_config('sms_'.$vv['add_shop_code']);
                    $this->log('====此客资是否可以发短信===='.$model);
                    if($vv['customer_tel'] && $msgUser && $model){
                        $send_msg = db('crm_s_message_templateinfo')->where('id',$model)->value('mtemplate_content');
                        preg_match("/(?:\{)(.*)(?:\})/i",$send_msg, $name);
                        preg_match("/(?:\[)(.*)(?:\])/i",$send_msg, $sex);
                        if($vv['customer_sex'] == '男'){
                            $m = '先生';
                        }elseif($vv['customer_sex'] == '女'){
                            $m = '女士';
                        }else{
                            $m = '';
                        }
                        //字符串替换
                        $send_msg1 = str_replace($name[0],$vv['customer_name'],$send_msg);
                        $msg = str_replace($sex[0],$m,$send_msg1);
                        $this->log('====发现短信内容===='.$msg);
                        $data1 = array(
                            'send_id' => $vv['dj_staff_id'],
                            'send_name'=>'素玄科技',
                            'send_content'=>$msg,
                            'model_id'=>$model,
                            'send_time'=>date('Y-m-d H:i:s',time()),
                            'receive_id'=>$vv['id'],
                            'receive_name'=>$vv['customer_name'],
                            'receive_phone'=>$vv['customer_tel']
                        );
                        //调用短信接口
                        $url = '5a17b86088f1a';
                        $da = array(
                            'mobile' => $vv['customer_tel'],
                            'content' =>$msg,
                            'send_config' =>$msgUser,
                        );
                        $res = sx_call($url,$da);
                        if($res['code'] == 200){
                            db('crm_c_send_message_log')->insert($data1);

                        }
                        $this->log('本次短信已发送--->'.$vv['id'].'--'.$vv['customer_tel']);
                    }
                    $tels .= $vv['customer_tel'];
                }

                $this->log('本次导入客资--->'.$tels);
                // $this->log('本次导入客资--->'.json_encode($eInfo));
                $date = date('Y-m-d H:i:s');
                $contactAll=array();
                $cid = [];
                $fpLog = [];
                foreach($eInfo as $k =>$v){
                    $cid[$k]['cid'] = $v['id'];
                    //查询有无追踪人，有的话记录追踪日志
                    if($v['sales_staff_id']){
                        $fpLog[$k]['cid']              = $v['id'];
                        $fpLog[$k]['eid']              = $v['eid'];
                        $fpLog[$k]['fp_model']         = 3;
                        $fpLog[$k]['fp_status']        = 1;
                        $fpLog[$k]['fp_time']          = $date;
                        $fpLog[$k]['jr_time']          = $date;
                        $fpLog[$k]['fp_staff_id']      = $v['dj_staff_id'];
                        $fpLog[$k]['fp_staff_name']    = $v['dj_staff'];
                        $fpLog[$k]['fp_shop_code']     = $v['add_shop_code'];
                        $fpLog[$k]['fp_shop_name']     = $v['add_shop_name'];
                        $fpLog[$k]['fp_brandclass_id'] = $v['brandclass_id'];
                        $fpLog[$k]['jr_staff_id']      = $v['sales_staff_id'];
                        $fpLog[$k]['jr_staff_name']    = $v['sales_staff'];
                        $fpLog[$k]['jr_shop_code']     = $v['shop_code'];
                        $fpLog[$k]['jr_shop_name']     = $v['shop_name'];
                    }
                    $temp = [];
                    if(!empty(trim($v['customer_tel']))){
                        $temp['c_id']            =$v['id'];
                        $temp['c_unique']        = trim($v['c_unique']);
                        $temp['customer_channel']= trim($v['customer_channel']);
                        $temp['contact']         = trim($v['customer_tel']);
                        $temp['brandclass']      = trim($v['brandclass']);
                        $contactAll[] = $temp;
                    }
                    if(!empty(trim($v['customer_wechat']))){
                        $temp['c_id']            =$v['id'];
                        $temp['c_unique']        = trim($v['c_unique']);
                        $temp['customer_channel']= trim($v['customer_channel']);
                        $temp['contact']         =trim($v['customer_wechat']);
                        $temp['brandclass']      =trim($v['brandclass']);
                        $contactAll[] = $temp;
                    }
                    if(!empty(trim($v['mate_tel']))){
                        $temp['c_id']            =$v['id'];
                        $temp['c_unique']        = trim($v['c_unique']);
                        $temp['customer_channel']= trim($v['customer_channel']);
                        $temp['contact']         =trim($v['mate_tel']);
                        $temp['brandclass']      =trim($v['brandclass']);
                        $contactAll[] = $temp;
                    }
                    if(!empty(trim($v['mate_wechat']))){
                        $temp['c_id']            = $v['id'];
                        $temp['c_unique']        = trim($v['c_unique']);
                        $temp['customer_channel']= trim($v['customer_channel']);
                        $temp['contact']         = trim($v['mate_wechat']);
                        $temp['brandclass']      = trim($v['brandclass']);
                        $contactAll[] = $temp;
                    }
                }
                $arr = array_unset_tt($contactAll,'contact');
                // $this->log('====排重后数组,准备插入排重表===='.json_encode($arr));
                $contactAll = array_values($arr);
                // $this->log('====插入排重表内容===='.json_encode($contactAll));
                $res = db('crm_c_customer_contact')->insertAll($contactAll);
                // $this->log('====插入排重表结果===='.$res);
                // $this->log('上次导入成功数'.$fileData['import_number'].'--本次导入成功-'.count($customer));
                // db('crm_c_excel_import')->where('id',$data['eid'])->setInc('import_number',count($customer));//新增成功数据量
                // $this->log('====修改成功数量sql===='.db()->getLastSql());
                // db('crm_c_excel_import')->where(array('id'=>$data['eid']))->update(array('all_number'=>$all_number,'fail_number'=>count($failCustomer)));
                // $this->log('====修改全部导入数量sql===='.db()->getLastSql());
                // $this->log('====分配日志===='.json_encode($contactAll));
                //插入分配日志
                db('crm_l_fp_logs')->insertAll($fpLog);
                //把cid存入from表
                // db('c_customer_from')->insertAll($cid);
                //把此次导入的信息存入pool表
                // $pool['msg'] = $data['eid'];
                // $pool['count'] = 0;
                // $pool['pool_type'] = 10;
                // $pool['fp_time_out'] = time();
                // $pool['create_time'] = date('Y-m-d H:i:s');
                // db('crm_c_fp_pool')->insert($pool);
                // db('crm_l_fp_logs')->insert($pool);
            }else{
                if(count($failCustomer)>0){
                    db('crm_c_excel_import')->where(array('id'=>$data['eid']))->update(array('all_number'=>$all_number,'fail_number'=>count($failCustomer)));
                }
            }
            //db('crm_c_excel_import')->where('id',$eid)->inc(array('import_number'=>count($customer),'fail_number'=>count($failCustomer)))->update(array('status'=>2));
            db()->commit();
            if ($last==1) {
                // $this->log('最后一次导入');
                $this->fpList($data);//分adadmi配队列
            }
            return true;
        }catch (\Exception $e){
            db()->rollback();
            // var_dump($e);
            $this->log('LastSql：'.db()->getLastSql());
            db('crm_c_excel_import')->where(array('id'=>$data['eid']))->update(array('status'=>3,'import_fail'=>0));
            $this->log('====数据库执行失败，错误信息：'.$e->getMessage());
            return false;
        }
    }

    /* 最后一次循环入库后，生成错误文件 改变文件状态
     * $all_number    文件总数量
     * $customer       已处理成功数据
     * $fail_array     过滤失败数据
     * $fileData       文件信息
     * $data           队列输入的数据
     * $contact        已处理成功数据的联系方式（一维数组）
     */
    function last_import($all_number,$customer,$fail_array,$fileData,$data,$contact){
        $this->log("***最后一次入库方法，最后一条是错误信息时，走这里的逻辑");
        // $this->log("***最后一次入库数据".$customer);
        $res=$this->doImport($all_number,$customer,$fail_array,$fileData,$data,$contact);
        // $this->log('000000000000000000000');
        //unset($conditions);
        //unset($all_id);
        if($res===false){
            //$this->log('导入数据执行失败');
            cache('upload_percent_'.$id,['eid'=>$id,'all_number'=>$all_number,'upload_num'=>0,'status'=>99]);
            return false;
        }else{
            unset ($customer,$contact,$all_number);
            //cache('import_excel_'.$data['eid'],null);
            // $this->log('-----failArry-------'.count($fail_array));
            if(count($fail_array)>0){
                $fail_file['fail_array']=$fail_array;
                $fail_file['eid']=$fileData['id'];
                $fail_file['shop_type'] = $this->shop_type;

                // $this->log('--------准备生成错误文件---表头----'.json_encode($this->importHeader));
                // $this->log('--------准备生成错误文件---第一条错误数据----'.json_encode($fail_array[0]));
                try{
                    $fail_url=controller("crm/Customer","lib")->cusFailFile($fail_file,$this->importHeader);
                    $this->log('------生成错误文件------'.$fail_url);
                }catch (\Exception $e){
                    $this->log('------生成错误文件失败------'.$e->getMessage());
                }
            }
            $this->log('---生成错误文件后---lastSql------'.db()->getLastSql());
            db('crm_c_excel_import')->where(array('id'=>$fileData['id']))->update(array('status'=>1,'fail_file_url'=>$fail_url,'fail_number'=>count($fail_array)));
            // $this->historyList($data);//数据统计队列
            if($fileData['is_sk']!=1){
                $this->fpList($data);//分adadmi配队列
            }
            cache('upload_percent_'.$id,['eid'=>$id,'all_number'=>$all_number,'upload_num'=>0,'status'=>99]);
            return false;
        }
        return false;
    }

    //分配队列
    function fpList($data){
        $this->log('==>进分配,data:'.json_encode($data));
        $sysconfig = db_config('fp_switch_'.$data['shop_code']);
        $this->log('== 配置:'.json_encode($sysconfig));
        if($sysconfig==1){
            // 系统分配队列
            $this->log('start fpCustomerList');
            $listName_fp = 'fpCustomerList';
            $message_fp['type']=2;
            $message_fp['eid']=$data['eid'];
            $message_fp['receive'] = '-1';
            $message_fp['body']    = '';
            $message_fp['staff_id']= $data['staff_id'];
            $message_fp['shop_code']= $data['shop_code'];
            $this->log('导入的客资进入分配队列---->'.json_encode($message_fp));
            push_list($listName_fp, $message_fp);
            $this->log('push fpcustomerlist over....');
        }
    }

    function log($str){
        if(config('app_debug')){
            if (strtoupper(substr(php_uname(),0,3)) == 'WIN') {
                $str = iconv("UTF-8","GB2312//IGNORE",$str);
            }
            echo date('Y-m-d H:i:s').$str."\r\n";
        }
    }


}

