<?php
/**
 * 报表实现类 郑州babypastel 月转化率表
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: lilong 2020-07-01 $
 */
namespace app\crm\lib\report;
use app\crm\lib\Report;
use think\Controller;
use think\image\Exception;

class Zzbb_xdl_month_data extends Report {
    private $level=1;
    private $type =1;
    private $code ='code1593597353';

    public function getLevel(){
        return $this->level;
    }
    public function getType(){
        return $this->type;
    }
    public function getCode(){
        return $this->code;
    }
    public function data(){
        set_time_limit(0);
        $data = input();

        $start = $data['start'] ? date('Y-m-01 00:00:00', strtotime($data['start'])) : date('Y-m-01 00:00:00');
        $end = date('Y-m-d 23:59:59', strtotime('+1 month -1 day'.$start));
        $det = db('crm_s_report_form')->alias('f')->join('crm_s_report_detail d','d.form_id=f.id')->where('d.id',$data['did'])->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();
        $shop_code = $det['shop_code'];
        if(empty($shop_code)){
            return array('code'=>100,'msg'=>'报表配置有误');
        }
        // ordernote 订单备注 order表
        // allfc 所有服次 currentfc 当前服次
        // c_paymentcontent  payclass =3 充值
        // c_paymentcontent  isshishou=实收 
        // c_paymentcontent  payment_money 小于 0 退款
        // c_paymentcontent  paytype 付款方式 
        // selectman 选片师 sp表
        // cameraman 摄影师 photo表
        // mentor_a  引导师A photo表
        // dresser   化妆师 photo表
        $returnData = [];
        $today_start = date('Ymd',strtotime($start));
        $today_end = date('Ymd',strtotime($end));
        $recTime = microtime(true).'<br />';

        //客资信息表      当日咨询量   客户渠道customer_channel
        $allOrderzxl = db('crm_c_customerinfo')->alias('c')
            ->join('c_customerorder o', 'c.customer_number=o.crm_customer_number','left')//客资信息表
            // ->where("c.dj_day between '$start' and '$end'")
            ->where("c.is_status",1)
            ->where("c.shop_code",$shop_code)
            ->where("c.customer_channel_id",'>',0)
            ->group('c.customer_channel')
            ->field("c.customer_channel_id,c.customer_channel,c.dj_day,sum(c.dj_day between '".$start."' and '".$end."') as mkz, sum(o.targetdate between '".$today_start."' and '".$today_end."') as `order`")
            ->select();
        $sql0 = db()->getLastSql();
        $recTime .= microtime(true).'<br />';
        foreach ($allOrderzxl as $key => $value) {
            // 订单 日期
            $returnData[$value['customer_channel']]['day'] = date('Y-m',strtotime($value['dj_day']));

            $returnData[$value['customer_channel']]['qd'] = $value['customer_channel'] == 0 ? '' : $value['customer_channel'];
            $returnData[$value['customer_channel']]['zxl'] = $value['mkz'] == 0 ? '' : $value['mkz'];
            $returnData[$value['customer_channel']]['cjl'] = $value['order'] == 0 ? '' : $value['order'];
        }
        //当日成交量   当日成交金额bargain_money
        $allOrdercjjine = db('crm_c_customerinfo')->alias('c')
            ->join('c_customerorder o', 'c.customer_number=o.crm_customer_number','left')//客资信息表
            // ->where("c.dj_day between '$start' and '$end'")
            ->where("c.is_status",1)
            ->where("c.shop_code",$shop_code)
            ->where("c.customer_channel_id",'>',0)
            ->group('c.customer_channel')
            ->field("c.customer_channel_id,c.customer_channel,o.bargain_money")
            ->select();
        $sql1 = db()->getLastSql();
        $recTime .= microtime(true).'<br />';
        // echo $sql1;die;
        foreach ($allOrdercjjine as $key => $value) {
            $returnData[$value['customer_channel']]['qd'] = $value['customer_channel'];

            $returnData[$value['customer_channel']]['cjjine'] += $value['bargain_money'];
        }
        $recTime .= microtime(true).'<br />';
        foreach ($returnData as $key => $value) {
            $returnData[$key]['cjlv'] = $value['cjl'] ? (sprintf("%.2f",$value['cjl']/$value['zxl'])*100).'%' : '';
            if (!$value['zxl']) {
                unset($returnData[$key]);
            }else{
                //总计
                $returnData['合计']['day'] = '合计';
                $returnData['合计']['zxl'] += $value['zxl'];
                $returnData['合计']['cjl'] += $value['cjl'];
                $returnData['合计']['cjjine'] += $value['bargain_money'];
            }
        }
        $return['sql0'] = $sql0;//查询所有订单单号
        $return['sql1'] = $sql1;//查询今日订单
        $return['recTime'] = $recTime;
        $return['code'] = 0;
        $return['msg'] = '';
        $return['count'] = count($returnData);
        $return['data'] = $returnData;

        return json($return);
    }
    //  
    public function show(){
        /*
        $did = strtolower(input('param.did'));
        $info = db('crm_s_report_form')->alias('f')->join('crm_s_report_detail d','d.form_id=f.id')->where('d.id',$did)->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();*/
        $menu_code = strtolower(input('param.menu_code'));
        $info = db('crm_s_report_form')->alias('f')->join('crm_s_report_detail d','d.form_id=f.id','left')->where('f.code',$menu_code)->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();
        $city = db('crm_s_shop_address')->where('shop_code',$info['shop_code'])->where('type',2)->select();
        //消费类型
        $consumptionType = controller("Customer", "lib")->consumptionType(['brandclass_id'=>$info['brandclass_id']]);
        $this->assign("consumptionType", $consumptionType);
        //来源渠道
        $channel = getChannelJson($info['shop_code']);
        $this->assign("channel", json_encode($channel));

        $code = $this->getCode();
        $display = APP_PATH.'crm'.DS.'view'.DS.'report'.DS.strtolower($info['report_class_name']).'.html';
        $title = db('crm_s_report_form')->where('code', $code)->value('report_name');
        $shopInfo = controller('crm/Customer','lib')->get_shop(['shop_code'=>$info['shop_code']]);
        $this->assign('title', $shopInfo[0]['shop_name'].'-'.$title);
        $this->assign('did', $info['id']);
        // c_paymenttype
        $allPayType = db('c_paymenttype')->where("find_in_set('".$info['shop_code']."',shop_code)")->field('id,typename')->select();
        $this->assign('allPayType', $allPayType);
        $this->assign('allPayCount', count($allPayType));
        // 当前操作人的可操作店
        // 今天
        $this->assign('today', date('Y-m'));

        return $this->fetch($display);
    }

}