<?php
/**
 * 报表实现类 郑州babypastel 电商部 业绩日报表
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: lilong 2020-07-01 $
 */
namespace app\crm\lib\report;
use app\crm\lib\Report;
use think\Controller;
use think\image\Exception;

class Zzbb_yeji_day_data_dianshang extends Report {
    private $level=1;
    private $type =1;
    private $code ='code1593597313';

    public function getLevel(){
        return $this->level;
    }
    public function getType(){
        return $this->type;
    }
    public function getCode(){
        return $this->code;
    }
    public function data(){
        set_time_limit(0);
        $data = input();

        $start = $data['start'] ? date('Y-m-d 00:00:00', strtotime($data['start'])) : date('Y-m-d 00:00:00');
        $end = date('Y-m-d 23:59:59', strtotime($data['end']));
        $det = db('crm_s_report_form')->alias('f')->join('crm_s_report_detail d','d.form_id=f.id')->where('d.id',$data['did'])->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();
        $shop_code = $det['shop_code'];
        if(empty($shop_code)){
            return array('code'=>100,'msg'=>'报表配置有误');
        }
        // ordernote 订单备注 order表
        // allfc 所有服次 currentfc 当前服次
        // c_paymentcontent  payclass =3 充值
        // c_paymentcontent  isshishou=实收 
        // c_paymentcontent  payment_money 小于 0 退款
        // c_paymentcontent  paytype 付款方式 
        // selectman 选片师 sp表
        // cameraman 摄影师 photo表
        // mentor_a  引导师A photo表
        // dresser   化妆师 photo表
        $returnData = [];
        $today = date('Ymd',strtotime($start));
        $recTime = microtime(true).'<br />';
        $allOrderIds = db('c_customerorder')->alias('o')//订单表
            // ->join('c_customerphoto ph', 'o.orderId=ph.orderId','left')//拍照表
            // ->join('c_customersp sp', 'o.orderId=sp.orderId','left')//选片表
            ->join('c_paymentcontent p','o.orderId=p.orderId','left')//收款表
            ->where('o.targetdate="'.$today.'" and o.shop_code="'.$shop_code.'"')
            // ->whereOr('ph.photodate="'.$today.'" and ph.shop_code="'.$shop_code.'"')
            // ->whereOr('sp.selectday="'.$today.'" and sp.shop_code="'.$shop_code.'"')
            ->whereOr('p.paymentdate="'.$today.'" and p.shop_code="'.$shop_code.'"')
            // ->page($page)->limit($limit)
            ->group('o.orderId')->column('o.orderId','o.orderId');
        $sql0 = db()->getLastSql();
        $recTime .= microtime(true).'<br />';
        // 当日订单客资
        $orderField = 'o.targetdate,o.orderId,c.wphone,c.wname,c.customer_channel,c.bbithdate,o.payment_money,o.nopayment_money,o.bargain_money,o.yixiaoshishou,o.supplementary_money,o.old_bargain_money,o.shengjimoney,o.ordernote,o.total_money,o.storeconsuitant2,o.wangfutype';
        $todayOrder = db('c_customerorder')->alias('o')
            ->join('c_customerinfo c', 'c.customerid=o.customerid','left')//客资信息表
            ->join('c_customerorder_servicefc fc', 'fc.orderId=o.orderId','left')
            ->join('crm_c_customerinfo crm_c', 'crm_c.customer_number=o.crm_customer_number','left')
            ->where('o.orderId','in',$allOrderIds)->where('o.targetdate',$today)
            ->order('o.targetdate')
            ->group('o.orderId')
            ->column($orderField.',fc.allfc,crm_c.dj_day','o.orderId');
        $sql1 = db()->getLastSql();
        $recTime .= microtime(true).'<br />';
        // echo $sql1;die;
        foreach ($todayOrder as $key => $value) {
            $noIds .= $value['orderId'].',';
            // 计算宝宝年龄
            $age = babyAge('',$value['bbithdate']);
            // 订单 日期
            $returnData[$key]['day'] = date('m-d',strtotime($value['targetdate'])).'-d';
            // 渠道
            $returnData[$key]['qd'] = $value['customer_channel'];
            // 妈妈姓名
            $returnData[$key]['name'] = $value['wname'];
            // 宝宝年龄
            $returnData[$key]['age'] = $age;
            // 妈妈电话
            $returnData[$key]['tel'] = $value['wphone'];

            // 成长套拍摄剩余次数
            if ($value['allfc']>1) {
                // $returnData[$key]['cztsycs'] = $value['allfc'];
                // 成长套拍摄量
                $returnData[$key]['czt'] = 1;
            }else{
                // $returnData[$key]['cztsycs'] = '';
                // 单套拍摄量
                $returnData[$key]['dt'] = 1;
            }

            // 新订单金额
            // $returnData[$key]['xddje'] = $value['bargain_money'];
            // 客户欠款
            $returnData[$key]['qk'] = $value['nopayment_money'];
            // 网络管家=开单人 网销门市
            $returnData[$key]['wlgj'] = $value['storeconsuitant2'];
            // 订单备注
            $returnData[$key]['bz'] = $value['ordernote'];

            //进店量 条件where wangfutype = 进店
            if ($value['wangfutype']=='进店') {
                $returnData[$key]['jdl'] += 1;
            }
        }
        $recTime .= microtime(true).'<br />';
        // 今日收款客资
        $todayPay = db('c_customerorder')->alias('o')
            ->join('c_customerinfo c', 'c.customerid=o.customerid','left')
            ->join('c_paymentcontent p', 'p.orderId=o.orderId','left')
            ->where('o.orderId','in',$allOrderIds)->where('p.paymentdate',$today)
            ->order('p.paymentdate')
            ->field($orderField.',p.paymentdate,p.payclass,p.paytype,p.isshishou,p.payment_money as pay,p.fundname,p.suoshu,p.remarks')
            ->select();
        $sql4 = db()->getLastSql();
        $recTime .= microtime(true).'<br />';
        foreach ($todayPay as $key => $value) {
            // 计算宝宝年龄
            $age = babyAge('',$value['bbithdate']);
            // 订单 日期
            $returnData[$value['orderId']]['day'] = date('m-d',strtotime($value['paymentdate'])).'-pay';
            // 渠道
            $returnData[$value['orderId']]['qd'] = $value['customer_channel'];
            // 妈妈姓名
            $returnData[$value['orderId']]['name'] = $value['wname'];
            // 宝宝年龄
            $returnData[$value['orderId']]['age'] = $age;
            // 妈妈电话
            $returnData[$value['orderId']]['tel'] = $value['wphone'];

            // 成长套拍摄剩余次数
            $allfc = db('c_customerorder_servicefc')->where('orderId',$value['orderId'])->value('allfc');
            if ($allfc>1) {
                // $returnData[$value['orderId']]['cztsycs'] = $allfc;
                // 成长套 新订单金额
                $returnData[$value['orderId']]['cztjine'] = $value['bargain_money'];
                // 成长套量
                $returnData[$value['orderId']]['czt'] = 1;
            }else{
                // $returnData[$value['orderId']]['cztsycs'] = '';
                // 单套 新订单金额
                $returnData[$value['orderId']]['dtjine'] = $value['bargain_money'];
                // 单套量
                $returnData[$value['orderId']]['dt'] = 1;
            }
            // 客户欠款
            $returnData[$value['orderId']]['qk'] = $value['nopayment_money'];
            // 客户还欠款
            if ($value['suoshu']=='前期补款' || $value['suoshu']=='后期补款') {
                $returnData[$value['orderId']]['hqk'] += $value['pay'];
            }
            // 客户退款(一)
            if ($value['pay']<0) {
                $returnData[$value['orderId']]['tk'] = $value['pay'];
            }
            // 实收 金额 包含充值
            if ($value['isshishou']=='实收') {
                $returnData[$value['orderId']]['ssje'] += $value['pay'];
            }
            // 付款方式
            $returnData[$value['orderId']][$value['paytype']] += $value['pay'];
            $returnData['合计'][$value['paytype']] += $value['pay'];

            // 应收金额  =订单金额
            $returnData[$value['orderId']]['ysje'] = $value['total_money'];
            // 回单
            if (substr($value['dj_day'],0,7) != date("Y-m", strtotime($data['start']))&&$value['pay'] > 0) {
                $returnData[$value['orderId']]['hd'] = '是';
            }
            // 订单 + 摄影 + 选片 + 收款备注
            $note = '';
            if ($value['ordernote']) {
                $note .= $value['ordernote'].'--';
            }
            if ($value['photonote']) {
                $note .= $value['photonote'].'--';
            }
            if ($value['spremarks']) {
                $note .= $value['spremarks'];
            }
            if ($value['remarks']) {
                $note .= $value['remarks'];
            }
            $returnData[$value['orderId']]['bz'] = $note;
        }
        foreach ($returnData as $key => $value) {
            //总计
            $returnData['合计']['day'] = '合计';
            $returnData['合计']['ysje'] += $value['ysje'];
            $returnData['合计']['ssje'] += $value['ssje'];
            $returnData['合计']['dt'] += $value['dt'];
            $returnData['合计']['dtjine'] += $value['dtjine'];
            $returnData['合计']['czt'] += $value['czt'];
            $returnData['合计']['cztjine'] += $value['cztjine'];
            $returnData['合计']['qk'] += $value['qk'];
            $returnData['合计']['hqk'] += $value['hqk'];
            $returnData['合计']['tk'] += $value['tk'];
            $returnData['合计']['jdl'] += $value['jdl'];
        }
        $recTime .= microtime(true).'<br />';
        $return['sql0'] = $sql0;//查询所有订单单号
        $return['sql1'] = $sql1;//查询今日订单
        $return['sql2'] = $sql2;//查询今日拍照
        $return['sql3'] = $sql3;//查询今日选片
        $return['sql4'] = $sql4;//查询今日收款
        $return['recTime'] = $recTime;
        $return['code'] = 0;
        $return['msg'] = '';
        $return['count'] = count($returnData);
        $return['data'] = $returnData;

        return json($return);
    }
    //  
    public function show(){
        /*
        $did = strtolower(input('param.did'));
        $info = db('crm_s_report_form')->alias('f')->join('crm_s_report_detail d','d.form_id=f.id')->where('d.id',$did)->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();*/
        $menu_code = strtolower(input('param.menu_code'));
        $info = db('crm_s_report_form')->alias('f')->join('crm_s_report_detail d','d.form_id=f.id','left')->where('f.code',$menu_code)->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();
        $city = db('crm_s_shop_address')->where('shop_code',$info['shop_code'])->where('type',2)->select();
        //消费类型
        $consumptionType = controller("Customer", "lib")->consumptionType(['brandclass_id'=>$info['brandclass_id']]);
        $this->assign("consumptionType", $consumptionType);
        //来源渠道
        $channel = getChannelJson($info['shop_code']);
        $this->assign("channel", json_encode($channel));

        $code = $this->getCode();
        $display = APP_PATH.'crm'.DS.'view'.DS.'report'.DS.strtolower($info['report_class_name']).'.html';
        $title = db('crm_s_report_form')->where('code', $code)->value('report_name');
        $shopInfo = controller('crm/Customer','lib')->get_shop(['shop_code'=>$info['shop_code']]);
        $this->assign('title', $shopInfo[0]['shop_name'].'-'.$title);
        $this->assign('did', $info['id']);
        // c_paymenttype
        $allPayType = db('c_paymenttype')->where("find_in_set('".$info['shop_code']."',shop_code)")->field('id,typename')->select();
        $this->assign('allPayType', $allPayType);
        $this->assign('allPayCount', count($allPayType));
        // 当前操作人的可操作店
        // 今天
        $this->assign('today', date('Y-m-d'));

        return $this->fetch($display);
    }

}