<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2019/8/28
 * Time: 17:00
 */

namespace app\Advert\controller;


use think\Controller;

class Index extends Controller
{
    public function customerSub(){
        $param = input();
        // var_dump($param);die;
        $code = trim($param['code']);
        if(!$code){
            return array('code'=>100,'msg'=>'未获取到落地页编码');
        }
        // 根据code查落地页
        $template = db('crm_s_advert_list')->where('advert_code',$code)->value('template');
        $template = json_decode($template, true);
        $component= $template['component'];
        $content = '';
        foreach ($component as $key => $value) {
            // var_dump($value);
            // 图片多选做了必选项
            if ($value['name']=='id_pictureCheckbox' && $value['required']) {
                if (empty($param['id_pictureCheckbox'])) {
                    return array('code'=>100,'msg'=>'“'.$value['title'].'”为必选项，请选择');
                }else{
                    foreach ($param['id_pictureCheckbox'] as $key => $value) {
                        $temp = explode('-',$value);
                        $content .= $temp[0].'<img src="'.$temp[1].'" width="40" />|';
                    }
                    $content = trim($content,'|');
                }
            }
            // 图片单选做了必选项
            else if ($value['name']=='id_pictureRadio' && $value['required']) {
                if (!$param['id_pictureRadio']) {
                    return array('code'=>101,'msg'=>'“'.$value['title'].'”为必选项，请选择');
                }else{
                    $temp = explode('-',$value);
                    $content .= $temp[0].'<img src="'.$temp[1].'" width="40" />';
                }
            }
            // 微信必选项
            else if ($value['name']=='basic_weixin' && $value['required']) {
                if (!$param['wechat']) {
                    return array('code'=>102,'msg'=>'“'.$value['title'].'”为必选项，请输入');
                }
            }
        }

        if(empty($param['name'])){
            return array('code'=>103,'msg'=>'姓名不能为空');
        }
        if(empty($param['tel'])){
            return array('code'=>104,'msg'=>'手机号不能为空');
        }
        $info = db('crm_s_advert_list')->where('advert_code',$param['code'])->find();
        $data['advert_code']    = trim($param['code']);
        $data['customer_name']  = trim($param['name']);
        $data['customer_tel']   = trim($param['tel']);
        $data['customer_wechat']= trim($param['wechat']);
        $data['add_shop_code']  = $info['add_shop_code'];
        $data['add_shop_name']  = $info['add_shop_name'];

        $data['ip'] = get_client_ip();
        $data['form_content'] = $content;
        $data['from_address'] = trim($param['from_address']);
        $data['create_time'] = date('Y-m-d H:i:s');

        $channel_id = (int)$param['channel_id'];
        if($channel_id){
            $channel = db('crm_s_advert_channel')->where('shop_code',$data['add_shop_code'])->where('channel_id', $channel_id)->find();
            if (!$channel) {
                return array('code'=>105,'msg'=>'查询渠道失败，请联系管理员','error'=>db()->getLastSql());
            }
            $data['brandclass']         = $channel['brandclass'];
            $data['brandclass_id']      = $channel['brandclass_id'];
            $data['customer_channel']   = $channel['channel_name'];
            $data['customer_channel_id']= $channel_id;
        }else{
            return array('code'=>106,'msg'=>'渠道名称不能为空');
        }
        $customer = [];
        $customer['consultation_type']= trim($param['consumption_name']);
        if($customer['consultation_type']){
            $customer['consultation_type_id'] = db('s_consumptiontype')->where('consumption_name',$customer['consultation_type'])->value('id');
            if (!$customer['consultation_type_id']) {
                $customer['consultation_type_id'] = NULL;
                $customer['consultation_type'] = NULL;
            }
        }
        $customer['city'] = $param['city'];
        $customer['customer_birthday'] = $param['birthday'] ? date('Y-m-d H:i:s', strtotime($param['birthday'])) : NULL;
        $customer['customer_remark'] = $param['remark'];
        $customer['customer_name'] = $data['customer_name'];
        $customer['customer_tel'] = $data['customer_tel'];
        $customer['customer_wechat'] = $data['customer_wechat'];
        $customer['add_shop_code'] = $data['add_shop_code'];
        $customer['add_shop_name'] = $data['add_shop_name'];
        $customer['shop_code'] = $data['add_shop_code'];
        $customer['shop_name'] = $data['add_shop_name'];
        $customer['customer_channel_id'] = $data['customer_channel_id'];
        $customer['customer_channel'] = $data['customer_channel'];
        $customer['dj_staff_id'] = $channel['staff_id'];
        $customer['dj_staff'] = $channel['staff_name'];
        $customer['brandclass_id'] = $channel['brandclass_id'];
        $customer['brandclass'] = $channel['brandclass'];
        db()->startTrans();
        try{
            $id = db('crm_s_advert_customer')->insertGetId($data);
            $cid = controller('crm/Customer','lib')->addCustomer_child($customer);
            db('crm_s_advert_list')->where('advert_code',$data['advert_code'])->setInc('request_num');
            $sql = db()->getLastSql();
            $upd = [];
            if($cid['code'] != 200){
                if($cid['code'] == 201){
                    $upd['is_in'] = 4;
                    $upd['c_id'] = NULL;
                    db('crm_s_advert_list')->where('advert_code',$data['advert_code'])->setInc('repeat_num');
                }
            }else{
                $upd['is_in'] = 1;
                $upd['c_id'] = intval($cid['cutomer_id']);
            }
            db('crm_s_advert_customer')->where('id',$id)->update($upd);
            db()->commit();
            return array('code'=>200,'msg'=>'提交成功','res'=>json_encode($cid),'sql'=>$sql);
        }catch (\Exception $e){
            db()->rollback();
            return array('code'=>100,'msg'=>'提交失败','data'=>$e->getMessage());
        }
    }
    //预览
    public function preview(){
        $code = input('advert_code');
        $channel_id = (int)input('channel_id');
        $this->assign('channel_id',$channel_id);
        $info = db('crm_s_advert_list')->where('advert_code',$code)->find();
        $info['template_json'] = $info['template'];
        $info['style_json'] = $info['style'];
        $info['template'] = json_decode($info['template'],true);
        $info['style'] = explode(',',$info['style']);
        // var_dump($info['template']);
        // die;
        //浏览数
        db('crm_s_advert_list')->where('advert_code',$code)->setInc('click_num');
        // print_r($info['style']);die;
        $this->assign('info',$info);
        $this->assign('style',$info['style']);
        $this->assign('host',getAppHost());
        return $this->fetch();
    }
}