<?php
/**
 * vip 接口模型，
 * 所有请求vip接口的，写到此类里，未来可以方便管理。
 * 
 * 接口返回false表示调用失败，非false的表示返回具体数据，注：有可能为空
 * 如果接口返回false 时，可以获取类的_code获性获得这个错误的代码，_msg获得错误描述
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: songdemei<songdemei@suxuantech.cn> 2018-01-30 $
 */
namespace app\common\lib;
use think\Controller;
use think\Exception;

class vipInterface extends Controller{
    var $_code = 0;
    var $_msg = '';
    var $_shopCode = '';
    function _initialize($shopCode = ''){
        $this->_shopCode = $shopCode;
    }
    public function retResult($res){
        if(!$res){
            $this->_code = -2;
            $this->_msg = '接口请求失败，请重试';
            return false;
        }
        if($res['error']){
            $this->_code = -1;
            $this->_msg = $res['error'];
            return false;
        }
        if($res['code'] != 200){
            $this->_code = $res['code'];
            $this->_msg = $res['msg'];
            return false;
        }
        return $res['data'];
    }

    /**
     * crm开完单写erp数据，之后还要调vip接口
     * 
     * @param   tel          妈妈手机
     * @param   brand_id     事业部id
     * @param   order_code   单号
     * @param   one_money    一销套系(crm开单只有意向套系，这里为0)
     * @param   two_money    二销套系(crm开单只有意向套系，这里为0)
     * @param   one_detail   一销实收
     * @param   two_detail   二销实收(crm开单只有意向套系，这里为0)
     * @param   order_time   开单时间
     * @param   total_money  订单总额(crm开单只有意向套系，这里为0)
     * @param   package_nam  套系名称(crm开单只有意向套系，这里为空)
     *
     * @return 
     */
    public function createOrder($param) {
        
        $res = sx_call('5a4e02a78f110', $param, 'sx_vip');
        $return = $this->retResult($res);

        return $return;
    }
    /**
     * 根据组id取组下的人 5cf8d76edd1ca
     * 
     * @param  group_id   
     * @return 
     */
    public function getStaffInfoByGid($param){
        $data['group_id'] = $param['group_id'];
        $cacheKey = 'mc_interface_5cf8d76edd1ca_'.md5(json_encode($param));
        //如果需要缓存，即是那些查询类的，需要定义好缓存KEY，
        //并且在本类的cleanCache里加上清除的方法，
        //这样在公共的清除缓方法里，会调用此方法清除缓存
        if(cache('?'.$cacheKey)){
            return cache($cacheKey);
        }else{
            $res = sx_call('5cf8d76edd1ca', $data);
            $return = $this->retResult($res);
            if($return !== false){
                cache($cacheKey,$return);
            }
        }
        return $return;
    }
}